#
# IMPORTANT: without this pytest won't consider this folder as a Python package to import
#
import os

from pytest import fixture
import shutil

# https://stackoverflow.com/a/29631801
@fixture
def copy_expected_result_files(tmpdir, request):
    """
    Fixture responsible for searching a folder with the same name of test module and if available,
    moving all contents to a temporary directory so tests can use them freely.
    """
    filename = request.module.__file__
    test_dir, _ = os.path.splitext(filename)

    if os.path.isdir(test_dir):
        shutil.copytree(test_dir, str(tmpdir))

    return tmpdir
