#
# HELPER CLASS TO SUPPORT XML COMMENTS
# See http://stackoverflow.com/questions/33573807/faithfully-preserve-comments-in-parsed-xml-python-2-7
#

XML_EXAMPLE_TEXT = """<?xml version='1.0' ?>
<!--
    Capture/StateMachine protocol configuration file

    This file describes which protocols must be analyzed by the StateMachine.
    Note that this file is used also by Capture component (and possibly others)
    to correctly configure its smart filter. This is the reason why it lives in hmcommon/etc.

    IMPORTANT: when adding/removing entire application suites <sections> please update also
                the DataCore/ApplicationSuiteId* files
-->
<config-file name="/home/hammer/hmcommon/etc/test-config" helm_chart="eva-statemachine" xmlns="http://www.empirix.com/master/xml/config" >
    <section name="scalar" tag="Scalar">
        <option name="enabled" default_value="true" type="boolean" short_desc="Enable option" long_desc="Enable option" />
        <option name="seconds" default_value="60" type="integer" min_value="0" max_value="120" short_desc="interval" long_desc="interval in sec" />
        <option name="negative" default_value="-60" type="integer" short_desc="negative integer" long_desc="a number with a minus in front" />
        <option name="floats" default_value="2.5" type="float" min_value="0" max_value="120" short_desc="interval" long_desc="interval in sec" />
        <option name="name" short_desc="this is a name" default_value="my test" type="string" />
        <option name="empty" short_desc="empty string" default_value="" type="string" />
        <option name="escaped" short_desc="escaped" default_value="my\\',\\ escaped" type="string" />
    </section>
    <section name="scalar1" tag="Scalar1">
        <option name="enabled" default_value="true" type="boolean" short_desc="Enable option" long_desc="Enable option" />
    </section>
    <section name="lists">
        <option name="example_enum" default_value="two" type="enum" available_values="one,two,three" short_desc="Enums" long_desc="List of enums" />
        <option name="example_string_num" default_value=" 123 " type="string" short_desc="Number string" long_desc="String consisted of digits only" />
        <option name="example_string_float" default_value="-1.23" type="string" short_desc="Float string" long_desc="String of a number" />
        <option name="example_empty_string" default_value="" type="string" short_desc="Empty string" long_desc="Empty string" />
        <option name="string_list1" default_value="abc,de/f,ghi,test@test" type="string_list" documentation="HIDDEN" tag="String_list1" short_desc="List of strings" long_desc="List of strings" />
        <option name="int_list1" default_value="4001, 5002, 6003" type="int_list" short_desc="Ports" long_desc="Used Ports" />
        <option name="string_list_of_nums" default_value="4001, 5002, 6003" type="string_list" short_desc="Ports" long_desc="Used Ports" />
        <option name="string_list_of_1" default_value="xyz:10000" type="string_list" documentation="HIDDEN" tag="String_list2" short_desc="List of one string" long_desc="List of one string" />
        <option name="string_list_long" type="string_list" documentation="HIDDEN" tag="String_list3" short_desc="Long list of strings" long_desc="Long list of strings">
            <default_values>
                <default_value>[+-]?(\\d*[.])?\\d+</default_value>
                <default_value>abcd[ardf]</default_value>
                <default_value>cdba#sdfs</default_value>
                <default_value>efgh</default_value>
                <default_value>hg,fe</default_value>
            </default_values>
        </option>
        <option name="string_list_of_1_bis" type="string_list" documentation="HIDDEN" tag="String_list4" short_desc="Long list of strings" long_desc="Long list of strings">
            <default_values>
                <default_value>abcdardf</default_value>
            </default_values>
        </option>
        <option name="int_list_of_1" default_value="909" type="int_list" short_desc="List of one number" long_desc="List of one number" />
        <option name="string_list_empty" default_value="" type="string_list" documentation="HIDDEN" short_desc="empty" long_desc="long description" />
        <option name="object_list_empty" default_value="" type="object_list" documentation="HIDDEN" short_desc="empty" long_desc="long description" />
        <option name="object_list_with_two_objects" default_value="" type="object_list" short_desc="has two elements" long_desc="long description">
            <option name="first_child" default_value="123" type="integer" short_desc="first child element" long_desc="long description"/>
            <option name="second_child" default_value="name,test" type="string_list" short_desc="second child element" long_desc="long description"/>
        </option>
        <option name="object_list_with_objects_without_default" default_value="" type="object_list" short_desc="has two elements" long_desc="long description">
            <option name="first_child" default_value="" type="integer" short_desc="first child element" long_desc="long description"/>
            <option name="second_child" default_value="" type="string_list" short_desc="second child element" long_desc="long description"/>
        </option>
    </section>
    <section name="lists1">
        <option name="object_list_with_one_item_two_children" default_value="" type="object_list" short_desc="has two elements" long_desc="long description">
            <option name="first_one" default_value="123" type="string" short_desc="first child element" long_desc="long description"/>
            <option name="second_one" default_value="name,test" type="string_list" short_desc="second child element" long_desc="long description"/>
        </option>
    </section>
    <section name="multiple_type_support">
        <option name="multi_scalar" default_value="12" default_type="float" type="integer float" short_desc="float or int" long_desc="long description"/>
        <option name="multi_scalar_with_min_max" min_value="-10" max_value="25" default_value="12" type="integer float" short_desc="float or int" long_desc="long description"/>
        <option name="multi_scalar_with_min_max_uint" min_value="-10" max_value="9999999999999999" default_value="12" type="integer float uint32" short_desc="float or int" long_desc="long description"/>
        <option name="multi_list" default_value="1,2,3" type="string_list int_list" short_desc="has two elements" long_desc="long description"/>
    </section>
</config-file>"""

YAML_EXAMPLE_RESULT = """
#     Capture/StateMachine protocol configuration file

#     This file describes which protocols must be analyzed by the StateMachine.
#     Note that this file is used also by Capture component (and possibly others)
#     to correctly configure its smart filter. This is the reason why it lives in hmcommon/etc.

#     IMPORTANT: when adding/removing entire application suites <sections> please update also
#                 the DataCore/ApplicationSuiteId* files
scalar:
  enabled: true                                                                 # ['boolean'] option, Enable option, min_value=None, max_value=None
  seconds: 60                                                                   # ['integer'] option, interval in sec, min_value=0, max_value=120
  negative: -60                                                                 # ['integer'] option, a number with a minus in front, min_value=None, max_value=None
  floats: 2.5                                                                   # ['float'] option, interval in sec, min_value=0.0, max_value=120.0
  name: my test                                                                 # ['string'] option, None, min_value=None, max_value=None
  empty: ''                                                                     # ['string'] option, None, min_value=None, max_value=None
  escaped: my\\',\\ escaped                                                       # ['string'] option, None, min_value=None, max_value=None
scalar1:
  enabled: true                                                                 # ['boolean'] option, Enable option, min_value=None, max_value=None
lists:
  example_enum: two                                                             # ['enum'] option, List of enums, min_value=None, max_value=None
  example_string_num: '123'                                                     # ['string'] option, String consisted of digits only, min_value=None, max_value=None
  example_string_float: '-1.23'                                                 # ['string'] option, String of a number, min_value=None, max_value=None
  example_empty_string: ''                                                      # ['string'] option, Empty string, min_value=None, max_value=None
  string_list1: [abc, de/f, ghi, test@test]                                     # ['string_list'] option, List of strings, min_value=None, max_value=None
  int_list1: [4001, 5002, 6003]                                                 # ['int_list'] option, Used Ports, min_value=None, max_value=None
  string_list_of_nums: ['4001', '5002', '6003']                                 # ['string_list'] option, Used Ports, min_value=None, max_value=None
  string_list_of_1: [xyz:10000]                                                 # ['string_list'] option, List of one string, min_value=None, max_value=None
  string_list_long: ['[+-]?(\\d*[.])?\\d+', 'abcd[ardf]', cdba#sdfs, efgh, 'hg,fe'] # ['string_list'] option, Long list of strings, min_value=None, max_value=None
  string_list_of_1_bis: [abcdardf]                                              # ['string_list'] option, Long list of strings, min_value=None, max_value=None
  int_list_of_1: [909]                                                          # ['int_list'] option, List of one number, min_value=None, max_value=None
  string_list_empty: []                                                         # ['string_list'] option, long description, min_value=None, max_value=None
  object_list_empty: []                                                         # ['object_list'] option, long description, min_value=None, max_value=None
  object_list_with_two_objects: []                                              # ['object_list'] option, long description, min_value=None, max_value=None
  object_list_with_objects_without_default: []                                  # ['object_list'] option, long description, min_value=None, max_value=None
lists1:
  object_list_with_one_item_two_children: []                                    # ['object_list'] option, long description, min_value=None, max_value=None
multiple_type_support:
  multi_scalar: 12.0                                                            # ['integer', 'float'] option, long description, min_value=None, max_value=None
  multi_scalar_with_min_max: 12                                                 # ['integer', 'float'] option, long description, min_value=-10.0, max_value=25.0
  multi_scalar_with_min_max_uint: 12                                            # ['integer', 'float', 'uint32'] option, long description, min_value=0, max_value=4294967295
  multi_list: ['1', '2', '3']                                                   # ['string_list', 'int_list'] option, long description, min_value=None, max_value=None
"""
