import pathlib
import hashlib
import os

import pytest
import config_file_generator_constants


class TestGenerateServiceConfigYamlSchemaJson:
    SCRIPT_LOCATION = pathlib.Path(__file__).parent.resolve()
    XML_LOCATION = os.path.join(SCRIPT_LOCATION, "input_files/")
    OUTPUT_FILES_LOCATION = os.path.join(SCRIPT_LOCATION, "output_files/")
    EXPECTED_FILES_LOCATION = os.path.join(SCRIPT_LOCATION, "expected_files/")

    SCRIPT_ABSOLUTE_PATH = os.path.abspath(config_file_generator_constants.SCRIPT_NAME)

    def get_check_sum(self, file_name):
        md5_hash = None
        hasher = hashlib.md5()
        with open(file_name, "rb") as f:
            buf = f.read()
            hasher.update(buf)
            md5_hash = hasher.hexdigest()
        return md5_hash

    def verify_check_sums(self, actual_file, expected_file, remove_actual_file=True):
        actual_check_sum = self.get_check_sum(actual_file)
        assert actual_check_sum, f"'{actual_file}' should have a valid check sum"

        expected_check_sum = self.get_check_sum(expected_file)
        assert expected_check_sum, f"'{expected_file}' should have a valid check sum"

        assert expected_check_sum == actual_check_sum, "Check sum should match"

        if remove_actual_file:
            os.remove(actual_file)

    def test_service_config_yaml_and_json_schema_output(self):
        xml_input_filename = os.path.join(self.XML_LOCATION, "service-config.xml")

        if not os.path.isdir(self.OUTPUT_FILES_LOCATION):
            os.makedirs(self.OUTPUT_FILES_LOCATION)

        yaml_output_filename = os.path.join(
            self.OUTPUT_FILES_LOCATION, "service-config.yaml"
        )
        schema_json_output_filename = os.path.join(
            self.OUTPUT_FILES_LOCATION, "service-config.yaml.schema.json"
        )

        conversion_command = f"{self.SCRIPT_ABSOLUTE_PATH} --input {xml_input_filename} --output {yaml_output_filename} --output_type YAML"
        print(f"Test command: {conversion_command}")
        stream = os.popen(conversion_command)
        command_output = stream.read()
        print(f"Command output: {command_output}")

        # Test generated yaml
        yaml_expected_filename = os.path.join(
            self.EXPECTED_FILES_LOCATION, "service-config.yaml"
        )
        self.verify_check_sums(
            f"{yaml_output_filename}",
            f"{yaml_expected_filename}",
        )

        # Test generated schema json
        schema_json_expected_filename = os.path.join(
            self.EXPECTED_FILES_LOCATION, "service-config.yaml.schema.json"
        )
        self.verify_check_sums(
            f"{schema_json_output_filename}",
            f"{schema_json_expected_filename}",
        )
