#!/bin/bash
CHART_NAME=$1
VERSION=$2
# HELM_URL=http://enstb-nexus-1.klerity:8081/repository/artifactory-helm/
HELM_URL=$3

Help()
{
    echo "----------"
    echo "$0"
    echo "----------"
    echo "Allows additional properties for root-level value.json"
    echo
    echo "Syntax: [-h] $0 <chart-name> <chart-version> <helm-repo-url>"
    echo "helm-repo-url example: 'http://enstb-nexus-1.klerity:8081/repository/artifactory-helm'"
    echo
}

while getopts ":h" option; do
    case $option in
        h) # display Help
            Help
        exit;;
        *) # invalid option, display Help
            echo "ERROR: Invalid option $1"
            echo
            Help
        exit;;
    esac
done
if [ $# -ne 3 ]; then
    echo "ERROR: Not enough arguments supplied"
    echo
    Help
    exit;
fi

helm version > /dev/null || echo "Helm is required. Please check your installation or run this script from the klerity deployer container"
helm repo add nexus "$HELM_URL"
helm pull nexus/"$CHART_NAME" --version "$VERSION" --untar

JSON_SCHEMA="$CHART_NAME"/values.schema.json
jq 'del(.additionalProperties)' "$JSON_SCHEMA" > "$JSON_SCHEMA.tmp"
mv "$JSON_SCHEMA.tmp"  "$JSON_SCHEMA"
helm package $CHART_NAME

curl -u admin:hammer -XPUT "$HELM_URL" -i -T "$CHART_NAME"-"$VERSION".tgz
