#
# This is the file which is included by 
#   - Application-targets.mk
#   - SharedLibrary-targets.mk
#   - StaticLibrary-targets.mk
# i.e., all makefiles that produce a library/executable.
# Note that this file is included before of the definition of ANY makefile target.
#
#
# This makefile will use/handle the following variables:
#
# About BUILDING/COMPILING:
#     EXTRA_INCS
#         Optionally defined to explicitly add directories to search
#         for header files.
#     EXTRA_DEFS
#         Optionally defined to explicitly add symbols to the preprocessor.
#     EXTRA_SRCS
#         This variable may be set to a list of extra sources files (beyond those contained in the Makefile directory)
#         to include in the build. Path should be relative to the directory of the Makefile.
#     EXTRA_HDRS
#         This variable may be set to a list of extra header files (beyond those contained in the Makefile directory)
#         to include in the build. Path should be relative to the directory of the Makefile.
#     EXCLUDE_SRCS
#         This variable may be set to a list of source files to exclude from the build.
#     EXCLUDE_SRCS_FORMATCHECKS
#         This variable may be set to a list of source files to exclude from the C++ format check
#     EXCLUDE_SRCS_CPPCHECKS
#         This variable may be set to a list of source files to exclude from the cppcheck
#
# About LINKING:
#     COMMON_LIBS
#         Optionally defined to list libraries coming from "Common" and required at build&link stage
#     EXTRA_LIBS
#         Optionally defined to explicitly add external libraries to link against. 
#         This is a space-separated like "path1/libName1 libName2 path3/libName3".
#         Note that, contrary to the USR_LIBS, a change into these libraries
#         will trigger a rebuild of the target.
#         This means that for each libX appearing in this list, a target in your Makefile
#         to produce that libX must be defined or otherwise GNU make will complain.
#         If this is not the desired effect, you should probably use USR_LIBS.
#     EXTRA_LIBS_WHOLE_ARCHIVE
#         Just like EXTRA_LIBS but the libraries listed in this variable will be linked against
#         the output executable (binary or shared lib) enclosed by -Wl,--whole-archive group;
#         --whole-archive disables the linker optimization where apparently-unused object files are
#         discarded from the output. This is specially useful for forcing linking of source code
#         containing Google Test code.
#         This is a space-separated list like "path1/libName1 libName2 path3/libName3"
#     USR_LIBS
#         Contains a list of libraries to use during linking, passed to GCC as -lNAME
#         This is a space-separated list like "path1/libName1 libName2 path3/libName3"
#     VERSIONED_USR_LIBS
#         Contains a list of libraries to use during linking, passed to GCC as -l:libNAME
#         This is a space-separated list like "path1/libName1 libName2 path3/libName3"
#     DEPENDENCIES_RPATHS
#         Contains paths to put in the ELF section as RPATH entries, i.e. path from which shared libraries should be loaded
#
# Others:
#     RM_OUTDIR
#         If 1, the output directory is removed
#     OUTDIR
#         If defined, overrides the default output directory, which is the
#         Lib subdirectory in the current directory.
#     BUILDDIR
#         Defined by standard makefiles and includes; can be overridden.
#     EXCLUDEDIRS
#         Only defined if directories are to be excluded from being compiled
#         into the library.
#     TARGS_SRC
#         If defined, the source files to build the target will not be automatically generated
#         and the contents of this variable define what to build.
#     BASH_FILES
#         If defined, the bash files will be validated for correct formatting
#     TARGS_OPTS
#         Only defined if options are added. Supported options include:
#             norecursive
#                 Only build objects in the current directory into a
#                 library.




##
## Default option values
##

ifndef EXCLUDEDIRS
# default value:
# we exclude from the build not only obvious directories (Bin/Lib/Build)
# but also directories that are handled in a special way by pipeline-framework (UnitTests)
EXCLUDEDIRS := Bin Lib Build unit-tests UnitTests
endif

ifndef SUPPORTS_CPPCHECK
# default value
SUPPORTS_CPPCHECK=1
endif

ifndef SUPPORTS_FORMAT_CHECK
# default value
SUPPORTS_FORMAT_CHECK=1
endif


##
## Create required directories
##

ifneq ($(MAKECMDGOALS),clean)
$(shell $(MKDIR) $(BUILDDIR))
$(shell $(MKDIR) $(OUTDIR))
endif



##
## Handle EXTRA_INCS, EXTRA_DEFS ----> COMMONFLAGS
##

COMMONFLAGS += $(foreach def, $(EXTRA_DEFS), -D$(def)) $(foreach inc, $(EXTRA_INCS), -I$(inc))


##
## Source files discovery mechanism
## Handle 
##    TARGS_OPT=norecursive
##    EXTRA_SRCS = list of C/C++ files to add into the build
##    EXCLUDE_SRCS = list of C/C++ files to exclude from the build
##    EXCLUDEDIRS = list of directories to exclude from the build
##  to create the 
##    TARGS_SRCS
##    TARGS_HDRS
## variables with the list of SOURCE and HEADER files to include in the build
##

ifndef TARGS_SRCS
	# TARGS_SRCS not specified: we need to create it using wildcards
	
	ifeq (,$(findstring norecursive,$(TARGS_OPTS)))
		
		##
		## Handle EXCLUDEDIRS
		##
		
		LOCAL_EXCLUDEDIRS := $(foreach directory, $(EXCLUDEDIRS), ./$(directory)%)
		TARGS_SUBDIRS := $(filter-out $(LOCAL_EXCLUDEDIRS), $(shell find $(DIR) -type d))

#$(info Recursively collecting source files from directories $(TARGS_SUBDIRS))			# recursive option included
	
		TARGS_SRCS := $(foreach directory, $(TARGS_SUBDIRS), $(subst ./,,$(wildcard $(directory)/*.c)))
		TARGS_SRCS := $(TARGS_SRCS) $(foreach directory, $(TARGS_SUBDIRS), $(subst ./,,$(wildcard $(directory)/*.cpp)))
		TARGS_SRCS := $(TARGS_SRCS) $(foreach directory, $(TARGS_SUBDIRS), $(subst ./,,$(wildcard $(directory)/*.cxx)))
		TARGS_SRCS := $(TARGS_SRCS) $(foreach directory, $(TARGS_SUBDIRS), $(subst ./,,$(wildcard $(directory)/*.cc)))
		TARGS_SRCS := $(TARGS_SRCS) $(EXTRA_SRCS)
		TARGS_SRCS := $(filter-out $(EXCLUDE_SRCS), $(TARGS_SRCS))
		TARGS_SRCS_PATH := $(sort $(foreach src, $(TARGS_SRCS), $(dir $(src))))
	
		TARGS_HDRS := $(foreach directory, $(TARGS_SUBDIRS), $(subst ./,,$(wildcard $(directory)/*.h)))
		TARGS_HDRS := $(TARGS_HDRS) $(foreach directory, $(TARGS_SUBDIRS), $(subst ./,,$(wildcard $(directory)/*.hpp)))
		TARGS_HDRS := $(TARGS_HDRS) $(EXTRA_HDRS)
		TARGS_HDRS_PATH := $(sort $(foreach hdr, $(TARGS_HDRS), $(dir $(hdr))))
		
		# adjust also include paths according to extra folders for header files collected:
		COMMONFLAGS += $(foreach inc, $(TARGS_HDRS_PATH), -I$(inc))
		
	else

#$(info Collecting source files from current directory)		# norecursive option included
		
		TARGS_SRCS := $(wildcard *.c)
		TARGS_SRCS := $(TARGS_SRCS) $(wildcard *.cpp)
		TARGS_SRCS := $(TARGS_SRCS) $(wildcard *.cxx)
		TARGS_SRCS := $(TARGS_SRCS) $(wildcard *.cc)
		TARGS_SRCS := $(TARGS_SRCS) $(EXTRA_SRCS)
		TARGS_SRCS := $(filter-out $(EXCLUDE_SRCS), $(TARGS_SRCS))
		TARGS_SRCS_PATH := $(sort $(foreach src, $(EXTRA_SRCS), $(dir $(src))))
		
		TARGS_HDRS := $(wildcard *.h)
		TARGS_HDRS := $(TARGS_HDRS) $(wildcard *.hpp)
		TARGS_HDRS := $(TARGS_HDRS) $(EXTRA_HDRS)
		TARGS_HDRS_PATH := $(sort $(foreach hdr, $(TARGS_HDRS), $(dir $(hdr))))
	
	endif

endif



##
## Create the TARGS_OBJS var
##

TARGS_OBJS := $(foreach src, $(notdir $(TARGS_SRCS)), $(addprefix $(BUILDDIR)/,$(src)))
TARGS_OBJS := $(patsubst %.cpp,%.o,$(TARGS_OBJS))
TARGS_OBJS := $(patsubst %.cc,%.o,$(TARGS_OBJS))
TARGS_OBJS := $(patsubst %.cxx,%.o,$(TARGS_OBJS))
TARGS_OBJS := $(patsubst %.c,%.o,$(TARGS_OBJS))

# in case the sources recursively collected contain extra folders, VPATH must be updated:
VPATH = $(sort $(TARGS_SRCS_PATH) $(TARGS_HDRS_PATH))



ifeq ($(SUPPORTS_FORMAT_CHECK), 1)

##
## Create the TARGS_FORMATCHECKS var
##

TARGS_FORMATCHECKS := $(filter-out $(EXCLUDE_SRCS_FORMATCHECKS), $(TARGS_SRCS) $(TARGS_HDRS))
TARGS_FORMATCHECKS := $(foreach src, $(notdir $(TARGS_FORMATCHECKS)), $(addprefix $(BUILDDIR)/,$(src)))
TARGS_FORMATCHECKS := $(patsubst %.cpp,%.sourcefmtcheck,$(TARGS_FORMATCHECKS))
TARGS_FORMATCHECKS := $(patsubst %.cc,%.sourcefmtcheck,$(TARGS_FORMATCHECKS))
TARGS_FORMATCHECKS := $(patsubst %.cxx,%.sourcefmtcheck,$(TARGS_FORMATCHECKS))
TARGS_FORMATCHECKS := $(patsubst %.c,%.sourcefmtcheck,$(TARGS_FORMATCHECKS))
TARGS_FORMATCHECKS := $(patsubst %.h,%.headerfmtcheck,$(TARGS_FORMATCHECKS))
#$(info $(TARGS_FORMATCHECKS))

endif


ifeq ($(SUPPORTS_CPPCHECK), 1)

##
## Create the TARGS_CPPCHECKS var
##

TARGS_CPPCHECKS := $(filter-out $(EXCLUDE_SRCS_CPPCHECKS), $(TARGS_SRCS) $(TARGS_HDRS))
TARGS_CPPCHECKS := $(foreach src, $(notdir $(TARGS_CPPCHECKS)), $(addprefix $(BUILDDIR)/,$(src)))
TARGS_CPPCHECKS := $(patsubst %.cpp,%.cppcheck,$(TARGS_CPPCHECKS))
TARGS_CPPCHECKS := $(patsubst %.cxx,%.cppcheck,$(TARGS_CPPCHECKS))
TARGS_CPPCHECKS := $(patsubst %.c,%.cppcheck,$(TARGS_CPPCHECKS))
TARGS_CPPCHECKS := $(patsubst %.h,%.cppcheck,$(TARGS_CPPCHECKS))
#$(info TARGS_CPPCHECKS contains: $(TARGS_CPPCHECKS))

endif


##
## Handle EXTRA_LIBS                ----> LINKER_FLAGS, EXTRA_LIBS_LINKER_LINE
## Handle EXTRA_LIBS_WHOLE_ARCHIVE  ----> LINKER_FLAGS, EXTRA_LIBS_LINKER_LINE
##

ifneq ($(strip $(EXTRA_LIBS_WHOLE_ARCHIVE)),)			# if we passed an empty list of variables between the start/end --whole-archive, g++ would error out
	EXTRA_LIBS_WHOLE_ARCHIVE_DIR := $(dir $(EXTRA_LIBS_WHOLE_ARCHIVE))
	EXTRA_LIBS_WHOLE_ARCHIVE_NAMES := $(notdir $(EXTRA_LIBS_WHOLE_ARCHIVE))
	EXTRA_LIBS_WHOLE_ARCHIVE_NAMES := $(subst lib,,$(EXTRA_LIBS_WHOLE_ARCHIVE_NAMES))
	EXTRA_LIBS_WHOLE_ARCHIVE_NAMES := $(subst .so,,$(EXTRA_LIBS_WHOLE_ARCHIVE_NAMES))
	EXTRA_LIBS_WHOLE_ARCHIVE_NAMES := $(subst .a,,$(EXTRA_LIBS_WHOLE_ARCHIVE_NAMES))
	# some old libraries under Third-Party have the .sa extension instead of .a, for some historical reason:
	EXTRA_LIBS_WHOLE_ARCHIVE_NAMES := $(subst .sa,,$(EXTRA_LIBS_WHOLE_ARCHIVE_NAMES))

	# create the EXTRA_LIBS_LINKER_LINE var:
	EXTRA_LIBS_LINKER_LINE += -Wl,--whole-archive $(foreach lib, $(EXTRA_LIBS_WHOLE_ARCHIVE_NAMES), -l$(lib)) -Wl,--no-whole-archive

	# create linker paths; we use sort() just to remove duplicate paths:
	LINKER_FLAGS += $(foreach lib, $(sort $(EXTRA_LIBS_WHOLE_ARCHIVE_DIR)), -L $(lib))
endif
ifneq ($(strip $(EXTRA_LIBS)),)			# if we passed an empty list of variables between the start/end --start-group, g++ would error out
	EXTRA_LIBS_DIR := $(dir $(EXTRA_LIBS))
	EXTRA_LIBS_NAMES := $(notdir $(EXTRA_LIBS))
	EXTRA_LIBS_NAMES := $(subst lib,,$(EXTRA_LIBS_NAMES))
	EXTRA_LIBS_NAMES := $(subst .so,,$(EXTRA_LIBS_NAMES))
	EXTRA_LIBS_NAMES := $(subst .a,,$(EXTRA_LIBS_NAMES))
	# some old libraries under Third-Party have the .sa extension instead of .a, for some historical reason:
	EXTRA_LIBS_NAMES := $(subst .sa,,$(EXTRA_LIBS_NAMES))

	# create the EXTRA_LIBS_LINKER_LINE var:
	EXTRA_LIBS_LINKER_LINE += -Wl,--start-group $(foreach lib, $(EXTRA_LIBS_NAMES), -l$(lib)) -Wl,--end-group

	# create linker paths; we use sort() just to remove duplicate paths:
	LINKER_FLAGS += $(foreach lib, $(sort $(EXTRA_LIBS_DIR)), -L $(lib))
endif



##
## Handle USR_LIBS ----> USR_LIBS_LINKER_LINE
##
	
USR_LIBS_DIR := $(filter-out ./,$(dir $(USR_LIBS)))
USR_LIBS_NAMES := $(notdir $(USR_LIBS))
#$(info USR_LIBS_NAMES is [$(USR_LIBS_NAMES)] and USR_LIBS_DIR is [$(USR_LIBS_DIR)])

USR_LIBS_LINKER_LINE += $(foreach lib, $(USR_LIBS_NAMES), -l$(lib))

# create linker paths; we use sort() just to remove duplicate paths:
LINKER_FLAGS += $(foreach lib, $(sort $(USR_LIBS_DIR)), -L $(lib))


##
## Handle VERSIONED_USR_LIBS ----> USR_LIBS_LINKER_LINE
##
	
VERSIONED_USR_LIBS_DIR := $(filter-out ./,$(dir $(VERSIONED_USR_LIBS)))
VERSIONED_USR_LIBS_NAMES := $(notdir $(VERSIONED_USR_LIBS))
#$(info VERSIONED_USR_LIBS_NAMES is [$(VERSIONED_USR_LIBS_NAMES)] and VERSIONED_USR_LIBS_DIR is [$(VERSIONED_USR_LIBS_DIR)])

USR_LIBS_LINKER_LINE += $(foreach lib, $(VERSIONED_USR_LIBS_NAMES), -l:$(lib))

# create linker paths; we use sort() just to remove duplicate paths:
LINKER_FLAGS += $(foreach lib, $(sort $(VERSIONED_USR_LIBS_DIR)), -L $(lib))


##
## Handle DEPENDENCIES_RPATHS ----> LINKER_FLAGS
##

DEPENDENCIES_RPATHS_LINKER_FLAGS = $(foreach path, $(DEPENDENCIES_RPATHS) $(RUNTIME_DIR), -Wl,-rpath -Wl,$(path))
LINKER_FLAGS += $(DEPENDENCIES_RPATHS_LINKER_FLAGS) $(EMPIRIX_LDFLAGS)
