#
# This is the file which is included by all Makefiles that just need to forward standard targets (all, packaging, etc)
# recursively to a list of sub-directories
#
# The calling Makefile must define:
#     DIRECTORIES
#         The list of subdirs to build.
#         Note that each name listed in this variable may be a variable itself with the list of targets to be done
#         processed as pre-requisite. E.g. if
#             DIRECTORIES= mydir1 mydir2 mydir3
#             mydir1=mydir3
#         means that: the "all" target will rebuild mydir1, mydir2 and mydir3. However, before building mydir1, the directory mydir3 will be rebuilt.
#         Also note that dependencies can be specified in a slightly-more clear way, as in the following example:
#             DIRECTORIES= mydir1 mydir2 mydir3
#             mydir1_DEP_DIRS=mydir3
#         i.e., defining a variable that ends with _DEP_DIRS postfix for each directory listed in DIRECTORIES
#
# Unit testing:
#     HAS_UNIT_TESTS
#         If 2 then the "test" target and the "test_valgrind" target are not defined at all;
#         the caller makefile must define them if needed.
#         If 1 when "test" target is called, it is propagated recursively to $(DIRECTORIES).
#         NOTE: value 0 is deprecated and not allowed anymore. If the calling makefile is not exposing any unit test, just
#         accept the default value "1" and make sure there is no "UnitTests" subfolder
#
# Static code analysis:
#     SUPPORTS_CPPCHECK
#         If 2 then the "cppcheck" target is not defined at all; the caller makefile must define it if needed.
#         If 1 when "cppcheck" target is called, it is propagated recursively to $(DIRECTORIES).
#         If 0 (default) then the "cppcheck" target will be implemented as no-op.
#
# Format checking:
#     SUPPORTS_FORMAT_CHECK
#         If 1 (default) when "format_check" target is called, it is propagated recursively to $(DIRECTORIES).
#         If 0 then the "format_check" target will be implemented as no-op.
#         Same applies to "format_inplace"
#
# Installation support:
#     HAS_INSTALL_SUPPORT
#         If 1 (default) then the "install" target will be implemented as recursive target.
#
# Config file regeneration:
#     HAS_CONFIG_FILES
#         If 0 (default) then the "config_files" target will be implemented as no-op
#         If 1 then the "config_files" target will be implemented as recursive target.
#         If 2 then the "config_files" target will be implemented as target that converts files listed in $(CONFIG_MASTER_XML_FILES)
#         to YAML and CSV files.
#
# SystemHealth file regeneration:
#     SYSTEM_HEALTH_XMLS
#         A list of XML files describing SystemHealth KPIs to provide to the 'systemhealth_kpi_generator' 
#         python utility for source code (.h) generation
#     SYSTEM_HEALTH_EXTRA_XMLS_FOR_DOCUMENTATION
#         A list of XML files to append to SYSTEM_HEALTH_XMLS to provide to the 'systemhealth_kpi_generator' 
#         python utility for documentation generation
# Targets defined:
#   all
#   clean
#   distclean
#   run
#   debug
#   install
#   test
#   test_valgrind
#   cppcheck
#   format_check
#   format_inplace
#   documentation
#


# ------------------------------------------------------------------------------------------
# check calling Makefile parameters:
# ------------------------------------------------------------------------------------------

ifeq ($(DIRECTORIES),)
	DIRECTORIES_MSG=no directories to process
else
	DIRECTORIES_MSG=$(DIRECTORIES)
endif

ifndef HAS_UNIT_TESTS
	# default value
	HAS_UNIT_TESTS=1
endif

ifndef HAS_CONFIG_FILES
	# default value
	HAS_CONFIG_FILES=0
endif

ifndef SUPPORTS_CPPCHECK
	# default value
	SUPPORTS_CPPCHECK=1
endif

ifndef SUPPORTS_FORMAT_CHECK
	# default value
	SUPPORTS_FORMAT_CHECK=1
endif

ifndef SUPPORTS_HELP
	# default value
	SUPPORTS_HELP=1
endif

ifndef HAS_INSTALL_SUPPORT
	# default value
	HAS_INSTALL_SUPPORT=1
endif

ifndef HAS_PACKAGING
	# default value
	HAS_PACKAGING=1
endif

ifeq ($(HAS_UNIT_TESTS),0)
$(error HAS_UNIT_TESTS=0 is not supported anymore. Please switch to HAS_UNIT_TESTS=1)
endif

ifndef REMOTE_DESTDIR
	# default value
	REMOTE_DESTDIR=/home/hammer
endif

ifndef SYSTEM_HEALTH_XMLS
	# default value
	SYSTEM_HEALTH_XMLS=
	SYSTEM_HEALTH_KPI_HEADER_OUTPUT_PATH=
endif

# ------------------------------------------------------------------------------------------
# inclusion checks
# ------------------------------------------------------------------------------------------

INCLUDED_RECURSIVE_TARGETS:=1

# blacklist other makefiles that for some reason are incompatible 
# (reason could be as simple as 'the combination has never been tested' or 'does not make much sense')
ifeq ($(INCLUDED_APPLICATION_TARGETS),1) 
$(error Packaging-targets.mk is incompatible with Recursive-targets.mk. Don't include both.)
endif
ifeq ($(INCLUDED_PACKAGING_TARGETS),1) 
$(error Packaging-targets.mk is incompatible with Recursive-targets.mk. Don't include both.)
endif

# ------------------------------------------------------------------------------------------
# more vars
# ------------------------------------------------------------------------------------------

CURRENT_DIR := $(shell readlink -f .)


# ------------------------------------------------------------------------------------------
# build & test targets
# ------------------------------------------------------------------------------------------

# to help debugging build_target macro you can add:
#   @echo "Dependencies for directory $(1) are: $(foreach dependency,$($(1)),$(dependency).BUILD)   $(foreach dependency,$($(1)_DEP_DIRS),$(dependency).BUILD)"
# inside it
define build_target
$(1).BUILD: source_code_generation $(foreach dependency,$($(1)),$(dependency).BUILD)         $(foreach dependency,$($(1)_DEP_DIRS),$(dependency).BUILD)
	@[ ! -z "$(TEAMCITY_VERSION)" ] && echo "##teamcity[blockOpened name='Building $(1) for $(BUILDID)']" || true
ifeq ($(V),0)
	@$$(MAKE) --no-print-directory --directory=$(1)
else
	$$(MAKE) --directory=$(1)
endif
	@[ ! -z "$(TEAMCITY_VERSION)" ] && echo "##teamcity[blockClosed name='Building $(1) for $(BUILDID)']" || true
endef

define clean_target
$(1).CLEAN:
ifeq ($(V),0)
	@$$(MAKE) --no-print-directory --directory=$(1) clean
else
	$$(MAKE) --directory=$(1) clean
endif
endef

define distclean_target
$(1).DISTCLEAN:
ifeq ($(V),0)
	@$$(MAKE) --no-print-directory --directory=$(1) distclean
else
	$$(MAKE) --directory=$(1) distclean
endif
endef

define cleanall_target
$(1).CLEANALL: $(foreach dependency,$($(1)),$(dependency).CLEAN)
ifeq ($(V),0)
	@$$(MAKE) --no-print-directory --directory=$(1) clean
else
	$$(MAKE) --directory=$(1) clean
endif
endef

define test_target
$(1).TEST:
ifeq ($(V),0)
	@$$(MAKE) --no-print-directory --directory=$(1) test
else
	$$(MAKE) --directory=$(1) test
endif
endef

define test_valgrind_target
$(1).TEST_VALGRIND:
ifeq ($(V),0)
	@$$(MAKE) --no-print-directory --directory=$(1) test_valgrind
else
	$$(MAKE) --directory=$(1) test_valgrind
endif
endef

define cppcheck_target
$(1).CPPCHECK:
ifeq ($(V),0)
	@$$(MAKE) --no-print-directory --directory=$(1) cppcheck
else
	$$(MAKE) --directory=$(1) cppcheck
endif
endef


# ------------------------------------------------------------------------------------------
# packaging targets
# ------------------------------------------------------------------------------------------

define install_target
$(1).INSTALL: $(foreach dependency,$($(1)),$(dependency).INSTALL)
ifeq ($(V),0)
	@$$(MAKE) --no-print-directory --directory=$(1) install
else
	$$(MAKE) --directory=$(1) install
endif
endef

define config_files_target
$(1).CONFIG_FILES:
ifeq ($(V),0)
	@$$(MAKE) --no-print-directory --directory=$(1) config_files
else
	$$(MAKE) --directory=$(1) config_files
endif
endef

define symlinks_target
$(1).SYMLINKS:
ifeq ($(V),0)
	@$$(MAKE) --no-print-directory --directory=$(1) symlinks
else
	$$(MAKE) --directory=$(1) symlinks
endif
endef

define packaging_target
$(1).PACKAGING:
ifeq ($(V),0)
	@$$(MAKE) --no-print-directory --directory=$(1) packaging
else
	$$(MAKE) --directory=$(1) packaging
endif
endef


# ------------------------------------------------------------------------------------------
# misc targets
# ------------------------------------------------------------------------------------------

define format_check_target
$(1).FORMAT_CHECK:
ifeq ($(V),0)
	@$$(MAKE) --no-print-directory --directory=$(1) format_check
else
	$$(MAKE) --directory=$(1) format_check
endif
endef

define format_inplace_target
$(1).FORMAT_INPLACE:
ifeq ($(V),0)
	@$$(MAKE) --no-print-directory --directory=$(1) format_inplace
else
	$$(MAKE) --directory=$(1) format_inplace
endif
endef

define run_target
$(1).RUN: $(foreach dependency,$($(1)),$(dependency).RUN)
ifeq ($(V),0)
	@$$(MAKE) --no-print-directory --directory=$(1) run
else
	$$(MAKE) --directory=$(1) run
endif
endef

define debug_target
$(1).DEBUG: $(foreach dependency,$($(1)),$(dependency).DEBUG)
ifeq ($(V),0)
	@$$(MAKE) --no-print-directory --directory=$(1) debug
else
	$$(MAKE) --directory=$(1) debug
endif
endef

define valgrind_target
$(1).VALGRIND: $(foreach dependency,$($(1)),$(dependency).VALGRIND)
ifeq ($(V),0)
	@$$(MAKE) --no-print-directory --directory=$(1) valgrind
else
	$$(MAKE) --directory=$(1) valgrind
endif
endef

define documentation_target
$(1).DOCUMENTATION:
ifeq ($(V),0)
	@$$(MAKE) --no-print-directory --directory=$(1) documentation
else
	$$(MAKE) --directory=$(1) documentation
endif
endef

# ------------------------------------------------------------------------------------------
# docker targets
# ------------------------------------------------------------------------------------------
#
# IMPORTANT: THE REASON FOR DISABLING THESE TARGETS IS THAT RATHER THAN DISPATCHING IN RECURSIVE WAY THE 'docker_*' TARGETS
#            IT MAKES MORE SENSE TO RUN THEM BUILDER DOCKER IMMEDIATELY (using BuilderDocker-targets.mk) AND THEN DO THE RECURSION
#            WITH THE GNU MAKE INSIDE THE BUILDER DOCKER
#
#define docker_run_target
#$(1).DOCKER_RUN: $(foreach dependency,$($(1)),$(dependency).DOCKER_RUN)
#	$$(MAKE) --directory=$(1) docker_run
#endef
#
#define docker_debug_target
#$(1).DOCKER_DEBUG: $(foreach dependency,$($(1)),$(dependency).DOCKER_DEBUG)
#	$$(MAKE) --directory=$(1) docker_debug
#endef
#
#define docker_valgrind_target
#$(1).DOCKER_VALGRIND: $(foreach dependency,$($(1)),$(dependency).DOCKER_VALGRIND)
#	$$(MAKE) --directory=$(1) docker_valgrind
#endef
#
#define docker_bash_target
#$(1).DOCKER_BASH: $(foreach dependency,$($(1)),$(dependency).DOCKER_BASH)
#	$$(MAKE) --directory=$(1) docker_bash
#endef
#

# ------------------------------------------------------------------------------------------
# setup lists of directories to process for each target
# ------------------------------------------------------------------------------------------

# build & test targets
BUILD_DIRS := $(foreach dir,$(DIRECTORIES),$(dir).BUILD)
CLEAN_DIRS := $(foreach dir,$(DIRECTORIES),$(dir).CLEAN)
DISTCLEAN_DIRS := $(foreach dir,$(DIRECTORIES),$(dir).DISTCLEAN)
CLEANALL_DIRS := $(foreach dir,$(DIRECTORIES),$(dir).CLEANALL)
TEST_DIRS := $(foreach dir,$(DIRECTORIES),$(dir).TEST)
TEST_VALGRIND_DIRS := $(foreach dir,$(DIRECTORIES),$(dir).TEST_VALGRIND)
CPPCHECK_DIRS := $(foreach dir,$(DIRECTORIES),$(dir).CPPCHECK)

.PHONY: $(BUILD_DIRS) $(CLEAN_DIRS) $(DISTCLEAN_DIRS) $(CLEANALL_DIRS) $(TEST_DIRS) $(TEST_VALGRIND_DIRS) $(CPPCHECK_DIRS) 

# packaging targets
INSTALL_DIRS := $(foreach dir,$(DIRECTORIES),$(dir).INSTALL)
CONFIG_FILES_DIRS := $(foreach dir,$(DIRECTORIES),$(dir).CONFIG_FILES)
SYMLINKS_DIRS := $(foreach dir,$(DIRECTORIES),$(dir).SYMLINKS)
PACKAGING_DIRS := $(foreach dir,$(DIRECTORIES),$(dir).PACKAGING)

.PHONY: $(INSTALL_DIRS) $(CONFIG_FILES_DIRS) $(SYMLINKS_DIRS) $(PACKAGING_DIRS)

# misc targets
FORMAT_CHECK_DIRS := $(foreach dir,$(DIRECTORIES),$(dir).FORMAT_CHECK)
FORMAT_INPLACE_DIRS := $(foreach dir,$(DIRECTORIES),$(dir).FORMAT_INPLACE)
RUN_DIRS := $(foreach dir,$(DIRECTORIES),$(dir).RUN)
DEBUG_DIRS := $(foreach dir,$(DIRECTORIES),$(dir).DEBUG)
VALGRIND_DIRS := $(foreach dir,$(DIRECTORIES),$(dir).VALGRIND)
DOCUMENTATION_DIRS := $(foreach dir,$(DIRECTORIES),$(dir).DOCUMENTATION)

.PHONY: $(FORMAT_CHECK_DIRS) $(FORMAT_INPLACE_DIRS) $(RUN_DIRS) $(DEBUG_DIRS) $(VALGRIND_DIRS) $(DOCUMENTATION_DIRS)

## docker targets
#DOCKER_RUN_DIRS := $(foreach dir,$(DIRECTORIES),$(dir).DOCKER_RUN)
#DOCKER_DEBUG_DIRS := $(foreach dir,$(DIRECTORIES),$(dir).DOCKER_DEBUG)
#DOCKER_VALGRIND_DIRS := $(foreach dir,$(DIRECTORIES),$(dir).DOCKER_VALGRIND)
#DOCKER_BASH_DIRS := $(foreach dir,$(DIRECTORIES),$(dir).DOCKER_BASH)
#.PHONY: $(DOCKER_RUN_DIRS) $(DOCKER_DEBUG_DIRS) $(DOCKER_VALGRIND_DIRS) $(DOCKER_BASH_DIRS)


# ------------------------------------------------------------------------------------------
# Build&test targets
# ------------------------------------------------------------------------------------------

all:: source_code_generation $(BUILD_DIRS)
	@echo ""
	@echo "COMPLETED RECURSING [target=all] [CFG=$(CFG)] in: $(DIRECTORIES_MSG)"
	@echo ""

clean:: $(CLEAN_DIRS)
	@echo ""
	@echo "COMPLETED RECURSING [target=clean] [CFG=$(CFG)] in: $(DIRECTORIES_MSG)"
	@echo ""

distclean:: $(DISTCLEAN_DIRS)
	@echo ""
	@echo "COMPLETED RECURSING [target=distclean] [CFG=$(CFG)] in: $(DIRECTORIES_MSG)"
	@echo ""

cleanall:: $(CLEANALL_DIRS)
	@echo ""
	@echo "COMPLETED RECURSING [target=cleanall] [CFG=$(CFG)] in: $(DIRECTORIES_MSG)"
	@echo ""

ifeq ($(HAS_UNIT_TESTS),1)
test:: $(TEST_DIRS)
	@echo ""
	@echo "COMPLETED RECURSING [target=test] [CFG=$(CFG)] in: $(DIRECTORIES_MSG)"
	@echo ""

test_valgrind:: $(TEST_VALGRIND_DIRS)
	@echo ""
	@echo "COMPLETED RECURSING [target=test_valgrind] [CFG=$(CFG)] in: $(DIRECTORIES_MSG)"
	@echo ""
endif

ifeq ($(SUPPORTS_CPPCHECK),1)
cppcheck:: $(CPPCHECK_DIRS)
	@echo ""
	@echo "COMPLETED RECURSING [target=cppcheck] [CFG=$(CFG)] in: $(DIRECTORIES_MSG)"
	@echo ""
endif
ifeq ($(SUPPORTS_CPPCHECK),0)
cppcheck::
	@echo ""
	@echo "No cppcheck support in: $(DIRECTORIES_MSG)"
	@echo ""
endif
.PHONY: all clean distclean cleanall test test_valgrind cppcheck



# ------------------------------------------------------------------------------------------
# packaging targets
# ------------------------------------------------------------------------------------------

ifeq ($(HAS_INSTALL_SUPPORT),1)
install:: $(INSTALL_DIRS)
	@echo ""
	@echo "COMPLETED RECURSING [target=install] [CFG=$(CFG)] in: $(DIRECTORIES_MSG)"
	@echo ""
endif

ifeq ($(HAS_CONFIG_FILES),2)

# note that the 'generate_*_from_xml' targets are defined into ConfigFiles-targets.mk
config_files:: generate_yaml_file_from_xml

config_files_clean:
	rm -f $(CONFIG_YAML_FILES)

endif
ifeq ($(HAS_CONFIG_FILES),1)
config_files:: $(CONFIG_FILES_DIRS)
	@echo ""
	@echo "COMPLETED RECURSING [target=config_files] [CFG=$(CFG)] in: $(DIRECTORIES_MSG)"
	@echo ""
endif
ifeq ($(HAS_CONFIG_FILES),0)
config_files::
	@echo ""
	@echo "No config files to regenerate in: $(DIRECTORIES_MSG)"
	@echo ""
endif

symlinks:: $(SYMLINKS_DIRS)
	@echo ""
	@echo "COMPLETED RECURSING [target=symlinks] [CFG=$(CFG)] in: $(DIRECTORIES_MSG)"
	@echo ""

ifeq ($(HAS_PACKAGING),1)

#
# A few conventions:
# - the Packaging*/ subfolder contains the Dockerfile and RPM spec files
# - the TestBundle/ subfolder contains a Conanfile to produce a Conan package
# - the HelmChart/ subfolder contains just 1 helm chart for the git repo
#
# IMPORTANT: please note that very often TestBundles contain Helm charts, so it's important
#            to package HelmChart folder BEFORE the TestBundle folder

packaging::
# Any folder starting with Packaging string is special and triggers a recursion inside it
	@$(foreach dir, $(wildcard Packaging*), $(MAKE) packaging -C $(dir) MAKEFLAGS=;)	
	@# HelmChart folder is special and triggers a recursion inside it
ifneq ($(wildcard HelmChart/*),)
	$(MAKE) packaging -C HelmChart MAKEFLAGS=
endif
ifneq ($(wildcard TestBundle/*),)
	$(MAKE) packaging -C TestBundle MAKEFLAGS=
endif
	@echo ""
	@echo "COMPLETED RECURSING [target=packaging] [CFG=$(CFG)] in: Packaging, HelmChart, TestBundle from folder $(CURRENT_DIR)"
	@echo ""

endif # HAS_PACKAGING=1

ifeq ($(HAS_PACKAGING),0)
packaging::
	@echo ""
	@echo "No packaging support in $(shell readlink -f .)"
	@echo ""
endif

.PHONY: install config_files symlinks packaging



# ------------------------------------------------------------------------------------------
# misc targets
# ------------------------------------------------------------------------------------------

ifeq ($(SUPPORTS_FORMAT_CHECK),1)
format_check:: $(FORMAT_CHECK_DIRS)
	@echo ""
	@echo "COMPLETED RECURSING [target=format_check] [CFG=$(CFG)] in: $(DIRECTORIES_MSG)"
	@echo ""

format_inplace:: $(FORMAT_INPLACE_DIRS)
	@echo ""
	@echo "COMPLETED RECURSING [target=format_inplace] [CFG=$(CFG)] in: $(DIRECTORIES_MSG)"
	@echo ""
else
format_check::
	@echo ""
	@echo "No format check support in: $(DIRECTORIES_MSG)"
	@echo ""

format_inplace::
	@echo ""
	@echo "No reformatting support in: $(DIRECTORIES_MSG)"
	@echo ""
endif

run:: $(RUN_DIRS)
	@echo ""
	@echo "COMPLETED RECURSING [target=run] [CFG=$(CFG)] in: $(DIRECTORIES_MSG)"
	@echo ""

debug:: $(DEBUG_DIRS)
	@echo ""
	@echo "COMPLETED RECURSING [target=debug] [CFG=$(CFG)] in: $(DIRECTORIES_MSG)"
	@echo ""

valgrind:: $(VALGRIND_DIRS)
	@echo ""
	@echo "COMPLETED RECURSING [target=valgrind] [CFG=$(CFG)] in: $(DIRECTORIES_MSG)"
	@echo ""

documentation:: documentation_generation $(DOCUMENTATION_DIRS)
	@echo ""
	@echo "COMPLETED RECURSING [target=documentation] [CFG=$(CFG)] in: $(DIRECTORIES_MSG)"
	@echo ""

.PHONY: format_check format_inplace run debug valgrind documentation

# ------------------------------------------------------------------------------------------
# docker targets
# ------------------------------------------------------------------------------------------

#docker_run:: $(DOCKER_RUN_DIRS)
#	@echo ""
#	@echo "Done running in: $(DIRECTORIES_MSG)"
#	@echo ""
#
#docker_debug:: $(DOCKER_DEBUG_DIRS)
#	@echo ""
#	@echo "Done debugging in: $(DIRECTORIES_MSG)"
#	@echo ""
#
#docker_valgrind:: $(DOCKER_VALGRIND_DIRS)
#	@echo ""
#	@echo "Done debugging in: $(DIRECTORIES_MSG)"
#	@echo ""
#
#docker_bash:: $(DOCKER_BASH_DIRS)
#	@echo ""
#	@echo "Done bashing in: $(DIRECTORIES_MSG)"
#	@echo ""


# ------------------------------------------------------------------------------------------
# Source code generation targets
# ------------------------------------------------------------------------------------------

source_code_generation: generate_syshealth_headers

generate_syshealth_headers:
ifneq ($(SYSTEM_HEALTH_XMLS),)
ifeq ($(V),0)
	@echo "SYSHEALTH $(SYSTEM_HEALTH_XMLS) -> .h"
	@python3 $(SYSTEM_HEALTH_KPI_GENERATOR_SCRIPT) \
		--export-type header \
		--code-formatter $(CLANG_FORMAT_BIN) \
		--system-health-xmls $(SYSTEM_HEALTH_XMLS) \
		--system-health-prefix $(SYSTEM_HEALTH_PREFIX) \
		--output-dir $(SYSTEM_HEALTH_KPI_HEADER_OUTPUT_PATH)
else
	@echo "Generating System Health KPI headers from $(SYSTEM_HEALTH_XMLS)"
	python3 $(SYSTEM_HEALTH_KPI_GENERATOR_SCRIPT) \
		--export-type header \
		--code-formatter $(CLANG_FORMAT_BIN) \
		--system-health-xmls $(SYSTEM_HEALTH_XMLS) \
		--system-health-prefix $(SYSTEM_HEALTH_PREFIX) \
		--output-dir $(SYSTEM_HEALTH_KPI_HEADER_OUTPUT_PATH) \
		--verbose
	@echo "Generated System Health KPI headers from $(SYSTEM_HEALTH_XMLS)"
endif
endif


# ------------------------------------------------------------------------------------------
# Documentation generation targets
# ------------------------------------------------------------------------------------------

documentation_generation:: generate_syshealth_docs

generate_syshealth_docs::
ifeq ($(SYSTEM_HEALTH_XMLS),)
	@echo "No syshealth documentation to generate"
else
ifeq ($(SYSTEM_HEALTH_PREFIX),)
	@echo "Please define the SYSTEM_HEALTH_PREFIX make variable"
	@exit 33
endif
	@mkdir -p $(TOPDIR)/TeamcityArtifacts/documentation
ifeq ($(V),0)
	@echo "SYSHEALTH $(SYSTEM_HEALTH_XMLS) $(SYSTEM_HEALTH_EXTRA_XMLS_FOR_DOCUMENTATION) -> .xlsx"
	@python3 $(SYSTEM_HEALTH_KPI_GENERATOR_SCRIPT) \
		--export-type documentation \
		--system-health-xmls $(SYSTEM_HEALTH_XMLS) $(SYSTEM_HEALTH_EXTRA_XMLS_FOR_DOCUMENTATION) \
		--system-health-prefix $(SYSTEM_HEALTH_PREFIX) \
		--output-dir $(TOPDIR)/TeamcityArtifacts/documentation
else
	@echo "Generating System Health KPI documentation from $(SYSTEM_HEALTH_XMLS) $(SYSTEM_HEALTH_EXTRA_XMLS_FOR_DOCUMENTATION)"
	python3 $(SYSTEM_HEALTH_KPI_GENERATOR_SCRIPT) \
		--export-type documentation \
		--system-health-xmls $(SYSTEM_HEALTH_XMLS) $(SYSTEM_HEALTH_EXTRA_XMLS_FOR_DOCUMENTATION) \
		--system-health-prefix $(SYSTEM_HEALTH_PREFIX) \
		--output-dir $(TOPDIR)/TeamcityArtifacts/documentation \
		--verbose
	@echo "Generated System Health KPI documentation from $(SYSTEM_HEALTH_XMLS) in the [$(TOPDIR)/TeamcityArtifacts/documentation] folder. Please open it with Microsoft Excel."
endif
endif



# ------------------------------------------------------------------------------------------
# set up targets used by GNU make as dependencies of user-friendly targets
# ------------------------------------------------------------------------------------------

# build & test targets
$(foreach dir, $(DIRECTORIES),$(eval $(call build_target,$(dir))))
$(foreach dir, $(DIRECTORIES),$(eval $(call clean_target,$(dir))))
$(foreach dir, $(DIRECTORIES),$(eval $(call distclean_target,$(dir))))
$(foreach dir, $(DIRECTORIES),$(eval $(call cleanall_target,$(dir))))
ifeq ($(HAS_UNIT_TESTS),1)
$(foreach dir, $(DIRECTORIES),$(eval $(call test_target,$(dir))))
$(foreach dir, $(DIRECTORIES),$(eval $(call test_valgrind_target,$(dir))))
endif
ifeq ($(SUPPORTS_CPPCHECK),1)
$(foreach dir, $(DIRECTORIES),$(eval $(call cppcheck_target,$(dir))))
endif

# packaging targets
$(foreach dir, $(DIRECTORIES),$(eval $(call install_target,$(dir))))
ifeq ($(HAS_CONFIG_FILES),1)
$(foreach dir, $(DIRECTORIES),$(eval $(call config_files_target,$(dir))))
endif
$(foreach dir, $(DIRECTORIES),$(eval $(call symlinks_target,$(dir))))
ifeq ($(HAS_PACKAGING),1)
$(foreach dir, $(DIRECTORIES),$(eval $(call packaging_target,$(dir))))
endif

# misc targets
ifeq ($(SUPPORTS_FORMAT_CHECK),1)
$(foreach dir, $(DIRECTORIES),$(eval $(call format_check_target,$(dir))))
$(foreach dir, $(DIRECTORIES),$(eval $(call format_inplace_target,$(dir))))
endif
$(foreach dir, $(DIRECTORIES),$(eval $(call run_target,$(dir))))
$(foreach dir, $(DIRECTORIES),$(eval $(call debug_target,$(dir))))
$(foreach dir, $(DIRECTORIES),$(eval $(call valgrind_target,$(dir))))
$(foreach dir, $(DIRECTORIES),$(eval $(call documentation_target,$(dir))))

# docker targets
#$(foreach dir, $(DIRECTORIES),$(eval $(call docker_run_target,$(dir))))
#$(foreach dir, $(DIRECTORIES),$(eval $(call docker_debug_target,$(dir))))
#$(foreach dir, $(DIRECTORIES),$(eval $(call docker_valgrind_target,$(dir))))
#$(foreach dir, $(DIRECTORIES),$(eval $(call docker_bash_target,$(dir))))

# ------------------------------------------------------------------------------------------
# Help target
# NOTE1: descriptions must be all aligned at column 54 as standard (including the initial TAB)
# NOTE2: only most useful targets are documented; internal/obscure targets must NOT be listed
# ------------------------------------------------------------------------------------------

ifeq ($(SUPPORTS_HELP),1)
help::
	@echo "Recursive targets (to run INSIDE the builder docker):"
	@echo "  BUILD&TEST CATEGORY:"
	@echo "    all:                                  build all the C/C++ code of this folder recursively"
	@echo "    clean:                                clean all the C/C++ code of this folder recursively"
	@echo "    distclean:                            distclean all the C/C++ code of this folder recursively"
	@echo "    cleanall:                             clean all the C/C++ code of this folder recursively for all CFG values"
ifeq ($(HAS_UNIT_TESTS),1)
	@echo "    test:                                 run the UNIT TEST binaries contained in this folder recursively, sequentially one by one"
	@echo "    test_valgrind:                        run VALGRIND on all the UNIT TEST binaries contained in this folder recursively, sequentially one by one"
endif
ifeq ($(SUPPORTS_CPPCHECK),1)
	@echo "    cppcheck:                             run cppecheck on all the C/C++ code of this folder recursively"
endif
	@echo
	@echo "  PACKAGING CATEGORY:"
	@echo "    install:                              installs binaries, config files, etc"
ifeq ($(HAS_CONFIG_FILES),1)
	@echo "    config_files:                         regen the YAML config files from the XMLs of this folder"
endif
	@echo "    symlinks:                             regenerate shared library symlinks"
	@echo "    packaging:                            run the [packaging] target on all the makefiles of this folder recursively"
	@echo
	@echo "  MISC CATEGORY:"
ifeq ($(SUPPORTS_FORMAT_CHECK),1)
	@echo "    format_check:                         run clang-format checks on all the C/C++ code of this folder recursively"
	@echo "    format_inplace:                       apply clang-format formatting on all the C/C++ code of this folder recursively"
endif
	@echo "    run:                                  run all the APPLICATION binaries contained in this folder recursively, sequentially one by one"
	@echo "    debug:                                run GDB on all the APPLICATION binaries contained in this folder recursively, sequentially one by one"
	@echo "    valgrind:                             run VALGRIND on all the APPLICATION binaries contained in this folder recursively, sequentially one by one"
	@echo "    documentation:                        regenerate documentation recursively"
#	@echo
#	@echo "  DOCKER CATEGORY:"
#	@echo "    docker_run:                           run the [docker_run] target on all the makefiles of this folder recursively"
#	@echo "    docker_debug:                         run the [docker_debug] target on all the makefiles of this folder recursively"
#	@echo "    docker_valgrind:                      run the [docker_valgrind] target on all the makefiles of this folder recursively"
#	@echo "    docker_bash:                          run the [docker_bash] target on all the makefiles of this folder recursively"
endif # SUPPORTS_HELP


# ---------------------------------------------
# include shared targets:
# ---------------------------------------------
HAS_CLEAN_SUPPORT=0
SUPPORTS_CPPCHECK=2
SUPPORTS_FORMAT_CHECK=2
include ${EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR}/ConfigFiles-targets.mk
include ${EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR}/BuilderDocker-targets.mk
