#
# This is the file which is included by any Makefiles that wants to 
# build a library. Be sure to include this file at the end
# of the makefile.
#
# The calling Makefile must define:
#     LIBNAME
#         This must be defined to the actual name of the library, excluding
#         the path. It should end with ".so" extension.
#     EXTRA_DEPS
#         Extra dependencies for the application main target; default to empty
#     << All variables supported by Internal-commonvars.mk -- see that file for detailed list >>
#
# Optionally:
#     LIBVERSION
#         To provide explicitly the version postfix to put after ".so" file extension.
#         Default value is $(SOLIB_FULL_VERSION) that is the one obtained from Makefile.version from the "git describe" command.
#     LIBSONAME
#         To provide explicitly the SONAME value to place inside the ".so" shared library.
#         A couple of important gotchas: 
#            a) the standard on Linux would be to just put the libName.MAJORVER as SONAME; however that means that
#               inspecting the shared library with "readelf -d" will not be so much useful when trying to debug the
#               exact version of the library... we default to libName.MAJORVER.MINORVER to provide some more information.
#            b) when you tell the linker "-lX" when building your executable FOO and your libX.so has some a SONAME=libX.1.2.3 written inside, 
#               then the GCC will write in FOO a "NEEDED" tag pointing to "libX.so.1.2.3", not just "libX.so".
#               Thus using as SONAME libName.MAJORVER.MINORVER.RELEASEVER would impact the ability to run incremental builds:
#               since RELEASEVER changes between incremental builds (due to increasing num of checkins), if we included the
#               RELEASEVER in the SONAME we should force re-linking of all executables across 2 incremental builds. To avoid
#               such complications we do NOT put the RELEASEVER in the SONAME.
#         Default value is $(SOLIB_SONAME_VERSION) that is the MAJORVER.MINORVER described above.
#
# Unit testing:
#     HAS_UNIT_TESTS
#         If 2 then the "test" target and the "test_valgrind" target are not defined at all; 
#         the caller makefile must define them if needed.
#         If 1 (default) when "test" target is called, and the "UnitTests" folder is present, the makefile will recursively
#         enter that folder. 
#         NOTE: value 0 is deprecated and not allowed anymore. If the calling makefile is not exposing any unit test, just
#         accept the default value "1" and make sure there is no "UnitTests" subfolder
#
# Installation support:
#     INSTALL_DIRNAME
#         Name of the directory where the binary must be installed; this directory will be created under $(DESTDIR)
#         that is passed to the "install" target. If $(DESTDIR_DEBUG) is provided, then debug symbols are installed there.
#     HDR_INSTALL_DIRNAME
#         Name of the directory where the headers must be installed; this directory will be created under $(DESTDIR)
#         that is passed to the "install_headers" target.
#
# For more variables that can be defined please see:
#   - Common-defines.mk
#   - CppBuild-targets.mk



# ---------------------------------------------
# check calling Makefile parameters:
# ---------------------------------------------

ifndef LIBNAME
$(error LIBNAME must be defined)
endif

ifndef BUILDDIR
$(error BUILDDIR must be defined)
endif

ifeq ($(EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR),)
$(error Please define EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR before including this snippet)
endif


ifndef OUTDIR
OUTDIR := ./Bin/$(BUILDID)
RM_OUTDIR=1
else
RM_OUTDIR=0
endif

ifdef OUTLIB
$(error Cannot override OUTLIB with value $(OUTLIB))
endif

ifndef LIBVERSION
ifeq ($(SOLIB_FULL_VERSION),)
$(error Neither LIBVERSION nor SOLIB_FULL_VERSION variables have been provided. Cannot version the shared library.)
endif

# default value
LIBVERSION:=$(SOLIB_FULL_VERSION)
endif

ifndef LIBSONAME
ifeq ($(SOLIB_SONAME_VERSION),)
$(error Neither LIBSONAME nor SOLIB_SONAME_VERSION variables have been provided. Cannot correctly tag the shared library.)
endif

# default value
LIBSONAME:=$(LIBNAME).$(SOLIB_SONAME_VERSION)
endif

# LIBTARGS_EXTRA_SRCS is the old name for EXTRA_SRCS
ifdef LIBTARGS_EXTRA_SRCS
EXTRA_SRCS:=$(LIBTARGS_EXTRA_SRCS)
endif
ifdef LIBTARGS_OPTS
TARGS_OPTS:=$(LIBTARGS_OPTS)
endif

ifndef HAS_INSTALL_SUPPORT
# default value
HAS_INSTALL_SUPPORT=1
endif

ifndef HAS_REMOTE_INSTALL_SUPPORT
# default value
HAS_REMOTE_INSTALL_SUPPORT=1
endif

ifndef REMOTE_DESTDIR
# default value
REMOTE_DESTDIR=/home/hammer
REMOTE_DESTDIR_DEBUG=/usr/lib/debug/$(REMOTE_DESTDIR)
endif

ifndef SUPPORTS_HELP
# default value
SUPPORTS_HELP=1
endif

ifndef HDR_INSTALL_DIRNAME
ifdef INSTALL_DIRNAME
# default value
HDR_INSTALL_DIRNAME=$(INSTALL_DIRNAME)/include
endif
endif

ifndef SEPARATE_DEBUG_SYMBOLS_RELEASE_BUILDS
# default value
SEPARATE_DEBUG_SYMBOLS_RELEASE_BUILDS=1
endif

ifndef HAS_UNIT_TESTS
# default value
HAS_UNIT_TESTS=1
endif

ifeq ($(HAS_UNIT_TESTS),0)
$(error HAS_UNIT_TESTS=0 is not supported anymore. Please switch to HAS_UNIT_TESTS=1)
endif

ifeq ($(IS_UNIT_TEST),1)
$(error IS_UNIT_TEST=1 makes no sense for a shared library target. Please remove that setting)
endif

# ------------------------------------------------------------------------------------------
# inclusion checks
# ------------------------------------------------------------------------------------------

INCLUDED_SHAREDLIBRARY_TARGETS:=1

# blacklist other makefiles that for some reason are incompatible 
# (reason could be as simple as 'the combination has never been tested' or 'does not make much sense')
ifeq ($(INCLUDED_RECURSIVE_TARGETS),1) 
$(error SharedLibrary-targets.mk is incompatible with Recursive-targets.mk. Don't include both.)
endif

# ---------------------------------------------
# create aux make vars:
# ---------------------------------------------

OUTLIB := $(OUTDIR)/$(LIBNAME).$(LIBVERSION)
OUTLIB_DEBUGINFO := $(OUTDIR)/$(LIBNAME).$(LIBVERSION).debug

#$(info Enabling \
#	$(if $(findstring norecursive,$(TARGS_OPTS)),simple,recursive) \
#	building of shared library $(OUTLIB) with version $(LIBVERSION))

# include the logic that collects source files:
include ${EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR}/Internal-commonvars.mk

ifeq (,$(findstring allowundefsym,$(TARGS_OPTS)))
# allowundefsym NOT present, pass "--no-undefined" to the GCC linker
LINKER_FLAGS += -Wl,--no-undefined
endif

LIBLINKS_SCRIPT=${EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR}/../scripts/liblinks.sh


# ------------------------------------------------------------------------------------------
# Targets
# IMPORTANT #1: the targets ending with double colons can be _extended_ by the caller makefile;
# 
# ABOUT THE conandata.yml DEPENDENCY :
# See Application-targets.mk explanation.
# ---------------------------------------------

.PHONY: all md5sum clean install test

all:: $(OUTLIB)_md5sum
	@$(LIBLINKS_SCRIPT) $(OUTLIB)   # create companion symlinks always, in case they were deleted GNU make would not detect that
	@echo "READY [$(CFG)] $(OUTLIB)"
ifeq ($(HAS_UNIT_TESTS),1)
ifneq ($(wildcard UnitTests/*),)
	@# if present, assume we should recursively build also the UnitTests folder (we assume it contains its own Makefile!)
	$(MAKE) all -C UnitTests
endif
endif

# the difference between "symlinks" and "all" is that "symlinks" will always do just the symlinks without re-triggering the build of the OUTLIB
symlinks::
	@$(LIBLINKS_SCRIPT) $(OUTLIB)
	@echo "SYMLINKS [$(CFG)] $(OUTLIB)"
	
packaging::
	@echo "Nothing to package for shared library $(OUTLIB)"

ifeq ($(ARCH), tile)

$(OUTLIB):: $(TARGS_OBJS) $(EXTRA_TARGS_OBJS) $(EXTRA_DEPS)
	@echo BUILDING SHARED LIBRARIES FOR TILERA NOT YET SUPPORTED

else # ARCH!=tile

$(OUTLIB):: $(TARGS_OBJS) $(EXTRA_TARGS_OBJS) $(EXTRA_LIBS) $(EXTRA_LIBS_WHOLE_ARCHIVE) $(TARGS_FORMATCHECKS) $(TARGS_CPPCHECKS) $(TOPDIR)/conandata.yml $(EXTRA_DEPS)
ifeq ($(V),0)
	$(call print_green,LINKING SHAREDLIB [$(CFG)] $(OUTLIB))
	@rm -f $(OUTDIR)/$(LIBNAME).*   # make sure that different shared library versions, if any, are removed from the same OUTDIR
	@$(LINKER) $(LINKER_FLAGS) \
		$(TARGS_OBJS) $(EXTRA_TARGS_OBJS) \
		$(EXTRA_LIBS_LINKER_LINE) \
		$(USR_LIBS_LINKER_LINE) \
		-shared -Wl,-soname,$(LIBSONAME) -o $(OUTLIB)
	@$(LIBLINKS_SCRIPT) $(OUTLIB)   # create companion symlinks
ifeq ($(CFG), release)
ifeq ($(SEPARATE_DEBUG_SYMBOLS_RELEASE_BUILDS), 1)
	@objcopy --only-keep-debug $(OUTLIB) $(OUTLIB_DEBUGINFO)
	@strip --strip-debug --strip-unneeded $(OUTLIB)
	@objcopy --add-gnu-debuglink=$(OUTLIB_DEBUGINFO) $(OUTLIB)
endif # SEPARATE_DEBUG_SYMBOLS_RELEASE_BUILDS
endif # CFG=release
else # end of V=0 if branch, start of V=1 branch
	rm -f $(OUTDIR)/$(LIBNAME).*   # make sure that different shared library versions, if any, are removed from the same OUTDIR
	$(LINKER) $(LINKER_FLAGS) \
		$(TARGS_OBJS) $(EXTRA_TARGS_OBJS) \
		$(EXTRA_LIBS_LINKER_LINE) \
		$(USR_LIBS_LINKER_LINE) \
		-shared -Wl,-soname,$(LIBSONAME) -o $(OUTLIB)
	$(LIBLINKS_SCRIPT) $(OUTLIB)   # create companion symlinks
ifeq ($(CFG), release)
ifeq ($(SEPARATE_DEBUG_SYMBOLS_RELEASE_BUILDS), 1)
	objcopy --only-keep-debug $(OUTLIB) $(OUTLIB_DEBUGINFO)
	strip --strip-debug --strip-unneeded $(OUTLIB)
	objcopy --add-gnu-debuglink=$(OUTLIB_DEBUGINFO) $(OUTLIB)
endif # SEPARATE_DEBUG_SYMBOLS_RELEASE_BUILDS
endif # CFG=release
endif # V=1

# the rule used to build $(OUTLIB_DEBUGINFO) is actually contained in the rule for building $(OUTLIB):
# inform GNU make about that. Note that we cannot place the strip commands here since they do MODIFY
# also the $(OUTLIB) binary itself!
$(OUTLIB_DEBUGINFO):: $(OUTLIB)

endif # ARCH!=tile

$(OUTLIB)_md5sum:: $(OUTLIB)
	@md5sum $(abspath $^) > MD5SUMS
	@sed 's@$(ABSPATH_TOPDIR)/@@' MD5SUMS >> ${TOPDIR}/MD5SUMS
	@rm -f MD5SUMS

strip::
	strip $(OUTLIB)
	
run::
	@echo "Nothing to run for shared library targets."

debug::
	@echo "Nothing to debug for shared library targets."
	
valgrind::
	@echo "Nothing to valgrind for shared library targets."
	
docker_run::
	@echo "No docker image is generated for shared library targets."

docker_debug::
	@echo "No docker image is generated for shared library targets."

docker_valgrind::
	@echo "No docker image is generated for shared library targets."
	
docker_bash::
	@echo "No docker image is generated for shared library targets."

# add cleaning of debug infos:
clean::
ifeq ($(CFG), release)
	-rm -f $(OUTLIB_DEBUGINFO)
endif
ifeq ($(HAS_UNIT_TESTS),1)
ifneq ($(wildcard UnitTests/*),)
	$(MAKE) clean -C UnitTests
endif
endif

##
## Installation Support
##

ifeq ($(HAS_INSTALL_SUPPORT),1)
install::
ifndef DESTDIR
	@echo "*** ERROR: please call this makefile supplying explicitly the DESTDIR variable"
	@exit 1
endif
	@[[ "$(DESTDIR)" =~ ^/ ]] || ( echo "*** ERROR: please provide an absolute path for DESTDIR variable" ; exit 1 )
ifeq ($(V),1)
	@echo "##################################################################################"
	@echo "Installing $(OUTLIB) shared libraries into $(DESTDIR)/$(INSTALL_DIRNAME)"
else
	@echo "INSTALL SHAREDLIB $(OUTLIB) -> $(DESTDIR)/$(INSTALL_DIRNAME)"
endif
	@mkdir --parents                          $(DESTDIR)/$(INSTALL_DIRNAME)
	@cp $(CP_OPTS) $(OUTLIB)                  $(DESTDIR)/$(INSTALL_DIRNAME)/
	@cp $(CP_OPTS) $(OUTDIR)/$(LIBNAME).*.*   $(DESTDIR)/$(INSTALL_DIRNAME)/
	@cp $(CP_OPTS) $(OUTDIR)/$(LIBNAME).*     $(DESTDIR)/$(INSTALL_DIRNAME)/
	@cp $(CP_OPTS) $(OUTDIR)/$(LIBNAME)       $(DESTDIR)/$(INSTALL_DIRNAME)/
	@chmod a+x                                $(DESTDIR)/$(INSTALL_DIRNAME)/$(LIBNAME) || true
ifeq ($(CFG),debug)
ifeq ($(BUILD_AGENT),1)
	@echo "##################################################################################"
	@echo "GENERATING ABI DUMP"
	@echo "Generating ABI dump for $(OUTDIR)/$(LIBNAME)"
	@if abi-dumper $(OUTDIR)/$(LIBNAME) -lambda -o $(OUTDIR)/$(LIBNAME).abi.dump -lver $(LIBVERSION); then \
		echo "Copying ABI dump from $(OUTDIR)/$(LIBNAME) into $(DESTDIR)/$(INSTALL_DIRNAME)"; \
		cp $(CP_OPTS) $(OUTDIR)/$(LIBNAME).abi.dump $(DESTDIR)/$(INSTALL_DIRNAME)/; \
	elif [ $$? -eq 12 ]; then \
		ABI_RETVAL=$$?; \
		echo abi-dumper exited with code $$ABI_RETVAL; \
		echo Trying to dump an header only library, maybe? Make will continue regardless...;\
	else \
		ABI_RETVAL=$$?; \
		echo abi-dumper failed! && exit $$ABI_RETVAL; \
	fi
endif
endif
ifeq ($(CFG),release)
ifneq ($(DESTDIR_DEBUG),)
	@mkdir --parents                          $(DESTDIR_DEBUG)/$(INSTALL_DIRNAME)
	@cp $(CP_OPTS) $(OUTLIB_DEBUGINFO)        $(DESTDIR_DEBUG)/$(INSTALL_DIRNAME)/$(LIBNAME).debug
endif
else
	@# we're installing a CFG=debug, CFG=debug-gcov etc, build: create a symlink to the actual binary with the debug tag:
	@cd $(DESTDIR)/$(INSTALL_DIRNAME) && $(LN) $(LIBNAME).$(LIBVERSION) $(subst $(DEBUG_TAG),,$(LIBNAME)).$(LIBVERSION)
	@# then run the script that will generate all standard symlinks for shared libraries:
	@$(LIBLINKS_SCRIPT) $(DESTDIR)/$(INSTALL_DIRNAME)/$(subst $(DEBUG_TAG),,$(LIBNAME)).$(LIBVERSION)
endif

#
# Note that the --parents option is used for cp to implement correctly the copy of header files
# living in subdirectories... e.g. consider TARGS_HDRS can contain "subFolder/a.h" which needs to
# be copied in $(DESTDIR)/$(HDR_INSTALL_DIRNAME)/subFolder/a.h
#
install_headers::
ifndef DESTDIR
	@echo "*** ERROR: please call this makefile supplying explicitly the DESTDIR variable"
	@exit 1
endif
	@[[ "$(DESTDIR)" =~ ^/ ]] || ( echo "*** ERROR: please provide an absolute path for DESTDIR variable" ; exit 1 )
ifeq ($(V),1)
	@echo "##################################################################################"
	@echo "Installing shared library's header files into $(DESTDIR)/$(HDR_INSTALL_DIRNAME)"
else
	@echo "INSTALL HEADERS $(LIBNAME) -> $(DESTDIR)/$(HDR_INSTALL_DIRNAME)"
endif
	@mkdir --parents                               $(DESTDIR)/$(HDR_INSTALL_DIRNAME)/
	@cp $(CP_OPTS) --parents $(TARGS_HDRS)         $(DESTDIR)/$(HDR_INSTALL_DIRNAME)/
	
endif # HAS_INSTALL_SUPPORT=1

##
## Unit Testing Support
##

ifeq ($(HAS_UNIT_TESTS),1)
test::
ifeq ($(wildcard UnitTests/*),)
	@echo "UnitTests subfolder not present. Skipping unit tests."
else
	$(MAKE) test -C UnitTests
endif

test_valgrind::
ifeq ($(wildcard UnitTests/*),)
	@echo "UnitTests subfolder not present. Skipping unit tests."
else
	$(MAKE) test_valgrind -C UnitTests
endif
	
docker_test::
ifeq ($(wildcard UnitTests/*),)
	@echo "UnitTests subfolder not present. Skipping unit tests."
else
	$(MAKE) docker_test -C UnitTests
endif

docker_test_valgrind::
ifeq ($(wildcard UnitTests/*),)
	@echo "UnitTests subfolder not present. Skipping unit tests."
else
	$(MAKE) docker_test_valgrind -C UnitTests
endif
endif

##
## Documentation Support
##

# this target is empty... up to the caller Makefile to append commands inside it, if needed:
documentation::

# ------------------------------------------------------------------------------------------
# Help target
# NOTE1: descriptions must be all aligned at column 54 as standard (including the initial TAB)
# NOTE2: only most useful targets are documented; internal/obscure targets must NOT be listed
# ------------------------------------------------------------------------------------------

ifeq ($(SUPPORTS_HELP),1)
help::
	@echo "Shared library targets (to run INSIDE the builder docker):"
	@echo "    all"
	@echo "    run"
	@echo "    debug"
	@echo "    valgrind"
ifeq ($(HAS_INSTALL_SUPPORT),1)
	@echo "    install"
endif
ifeq ($(HAS_REMOTE_INSTALL_SUPPORT),1)
	@echo "    remote_install_root"
endif
ifeq ($(HAS_UNIT_TESTS),1)
	@echo "    test"
	@echo "    test_valgrind"
endif
endif # SUPPORTS_HELP
	
include ${EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR}/CppBuild-targets.mk
include ${EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR}/BuilderDocker-targets.mk

# include all GCC automatically-generated dependency files to allow for smart incremental builds
-include $(TARGS_OBJS:%.o=%.d)
