#!/bin/bash
#
# This script is placed inside pipeline-framework to allow dynamically changing the proxy repositories
# that are controlled by the "LAB" environment variable.
# The task of this script is to manipulate files on the HOST server some files that will be later
# bind-mounted by 
#

set -u

# CLI arguments
THIS_SCRIPT_NAME="$(basename $0)"
MAVEN_SETTINGS_DIR="$1"
NEXUS_PROXY_FOR_RPMS="$2"

# env vars
LAB="${LAB:-billerica}"

# constants
MAVEN_SETTINGS_FILE="${HOME}/.m2/settings.xml"
MAVEN_SETTINGS_NEEDS_UPDATE=false
YUM_REPO_VAR_FILE="/etc/yum/vars/artifactory-yum-repository"


# functions

function maven_settings_check_if_update_is_needed()
{
    if [ ! -f ${MAVEN_SETTINGS_FILE} ]; then
        MAVEN_SETTINGS_NEEDS_UPDATE=true
        return
    fi
    
    grep -q "infovista-artifactory-snapshots" ${MAVEN_SETTINGS_FILE}
    if [ $? -ne 0 ]; then
        # old settings.xml without the URL to push into Infovista Artifactory Maven repos
        MAVEN_SETTINGS_NEEDS_UPDATE=true
        return
    fi

    # in future define more conditions here that will trigger the regeneration of maven settings.xml
}

function update_maven_settings()
{
    if ${MAVEN_SETTINGS_NEEDS_UPDATE}; then
            
        echo "${MAVEN_SETTINGS_FILE} needs to be updated. Configuring Maven to use the ${LAB} Nexus proxy to fetch Maven packages."
        if [ -f ${MAVEN_SETTINGS_FILE} ]; then
		    mv -f ${MAVEN_SETTINGS_FILE} "${MAVEN_SETTINGS_FILE}_$(shell date +%F-%T)"
        fi
        cp -fv $MAVEN_SETTINGS_DIR/maven/maven-settings-$LAB.xml ${MAVEN_SETTINGS_FILE}
    else
        echo "No need to update existing ${MAVEN_SETTINGS_FILE} file. Skipping Maven proxy reconfiguration. Remove that file if you need to change LAB."
    fi
}

function update_yum_var_if_needed()
{
    if [ ! -f ${YUM_REPO_VAR_FILE} ]; then
        echo "${YUM_REPO_VAR_FILE} is absent. Configuring YUM to use the ${LAB} Nexus proxy to fetch RPM packages."
        echo $NEXUS_PROXY_FOR_RPMS > $YUM_REPO_VAR_FILE
    else
        echo "Found existing ${YUM_REPO_VAR_FILE} file. Skipping RPM proxy reconfiguration. Remove that file if you need to change LAB."
    fi
}

# main    
echo "$THIS_SCRIPT_NAME: Found environment variable LAB=${LAB}."
maven_settings_check_if_update_is_needed
update_maven_settings
update_yum_var_if_needed
