import pathlib
import pytest
import xmltodict
import check_abi_compliance as abicc


class TestCheckAbiCompliance:
    SCRIPT_LOCATION = pathlib.Path(__file__).parent.resolve()
    ABI_LOCATION = f"{SCRIPT_LOCATION}/resources/check_abi_compliance"
    COMPAT_REPORTS_PATH = f"{SCRIPT_LOCATION}/compat_reports/test_lib/1_to_2"

    def test_check_abi_compliance(self):
        COMPAT_REPORT_XML = f"{self.COMPAT_REPORTS_PATH}/test_lib_v1_v2.xml"
        print(self.SCRIPT_LOCATION)
        print(self.ABI_LOCATION)
        print(self.COMPAT_REPORTS_PATH)
        ret = abicc.abi_check(
            "libtest",
            f"{self.ABI_LOCATION}/test_lib_v1.abi.dump",
            f"{self.ABI_LOCATION}/test_lib_v2.abi.dump",
            extra_args=[
                "-xml",
                "-report-path",
                COMPAT_REPORT_XML,
            ],
        )

        assert ret[0] == 1

        with open(COMPAT_REPORT_XML) as f:
            xml_tree = xmltodict.parse(f.read())

        binary_reports = [
            report
            for report in xml_tree["reports"]["report"]
            if report["@kind"] == "binary"
        ]
        assert len(binary_reports) == 1
        binary_report = binary_reports[0]
        assert binary_report["test_results"]["verdict"] == "incompatible"
        assert binary_report["test_results"]["affected"] == "50"
        assert binary_report["problem_summary"] == {
            "added_symbols": "1",
            "removed_symbols": "0",
            "problems_with_types": {
                "high": "0",
                "medium": "3",
                "low": "0",
                "safe": "0",
            },
            "problems_with_symbols": {
                "high": "0",
                "medium": "0",
                "low": "0",
                "safe": "0",
            },
            "problems_with_constants": {"low": "0"},
        }

        source_reports = [
            report
            for report in xml_tree["reports"]["report"]
            if report["@kind"] == "source"
        ]
        assert len(source_reports) == 1
        source_report = source_reports[0]
        assert source_report["test_results"]["verdict"] == "compatible"
        assert source_report["test_results"]["affected"] == "0"
        assert source_report["problem_summary"] == {
            "added_symbols": "1",
            "removed_symbols": "0",
            "problems_with_types": {
                "high": "0",
                "medium": "0",
                "low": "0",
                "safe": "3",
            },
            "problems_with_symbols": {
                "high": "0",
                "medium": "0",
                "low": "0",
                "safe": "0",
            },
            "problems_with_constants": {"low": "0"},
        }
