import pytest
import yaml, json
from yaml_to_json_schema import *


class TestYamlToJsonSchema:
    def test_values(self):
        json_schema = process_yaml_file("tests/InputFiles/test-values.yaml")
        with open(
            "tests/Expected/test-values.schema.json", "r", encoding="utf-8"
        ) as expected:
            assert expected.read() == json.dumps(
                json_schema, **JSON_DUMP_DEFAULT_SETTINGS
            )

    def test_config_file_with_root_filename(self):
        json_schema = process_yaml_file("tests/InputFiles/test-config-file.yaml", True)
        with open(
            "tests/Expected/test-config-file.schema.json", "r", encoding="utf-8"
        ) as expected:
            assert expected.read() == json.dumps(
                json_schema, **JSON_DUMP_DEFAULT_SETTINGS
            )
