---
author: Sijie Guo
authorURL: https://twitter.com/sijieg
title: "Announcing: The Apache Pulsar 2020 User Survey Report"
---

For the first time ever, the Apache Pulsar PMC team is publishing a user survey report.
**The 2020 Apache Pulsar User Survey Report** reveals Pulsar’s accelerating rate of global
adoption, details how organizations are leveraging Pulsar to build real-time streaming
applications, and highlights key features on Pulsar’s product roadmap.

![](/img/pulsar-user-ban.jpg)

Pulsar adoption has largely been driven by the market’s increased demand for real-time,
data-enabled technologies. While companies have tried to leverage monolithic messaging
systems to build-out real-time offerings, they’ve hit major roadblocks. Ultimately, these
technologies are not equipped to provide the scale or reliability that mission-critical
applications require.

As a result, companies have sought-out Apache Pulsar for its cloud-native, distributed
messaging and streaming platform capabilities. From asynchronous applications to core
business applications to ETL, companies are increasingly leveraging Pulsar to develop
real-time applications.

Pulsar has received global adoption from major technology companies such as Verizon Media,
Narvar, Overstock, Nutanix, Yahoo! JAPAN, Tencent, OVHCloud, and Clever Cloud, who rely on
its ability to deliver on performance, scalability, and resiliency. As the Pulsar project
and community garner increasing attention, we’re excited to share the **2020 Apache Pulsar User Survey Report**.

![](/img/pulsar-adoption.png)

In the 2020 Apache Pulsar User Survey Report, we hear from 165 users and learn how their
companies are leveraging Pulsar’s cloud-native, multi-layer design architecture, built-in
multi-tenancy, and multi-cluster replication, to build scalable real-time offerings. This
report details insights and use cases on how organizations are deploying Pulsar today.

The report also reveals Pulsar’s top-used features, its most popular applications, and how
it is delivering scalable, reliable, real-time streaming solutions for organizations. In
this quotation from Qiang Fei, Tech Lead for Tencent, we see how [one organization is leveraging Pulsar to improve their offering](https://streamnative.io/whitepaper/case-studay-apache-pulsar-tencent-billing/):

> Pulsar provides us with a highly consistent and highly reliable distributed message queue that
> fits well in our financial use cases. Multi-tenant and storage separation architecture design
> greatly reduces our operational and maintenance overhead. We have used Pulsar on a very large
> scale in our organization and we are impressed that Pulsar is able to provide high consistency
> while supporting high concurrent client connections.
> 
> - Qiang Fei, Tech Lead at Tencent

From its built-in multi-tenancy, which reduces architectural complexity and enables organizations
to scale, to its multi-datacenter replication, which allows Pulsar to handle data center failures,
we see how Pulsar has evolved into a robust and differentiated messaging and streaming platform.
The report also reveals some of the community-driven features on Pulsar’s product roadmap for 2020
and beyond. To find out more, [download the report today](https://streamnative.io/whitepaper/oss-apache-pulsar-user-survey-report-2020/).

Join us for the first-ever Apache Pulsar Summit on August 26, 2020, in San Francisco, CA.
More details on the Summit to come!
