#!/bin/bash

set -x

# vars used below
LIB_NAME=6windgate-x86_64-redhat-8-empirix-v
LIB_VER=5.6.0.ga
DESTDIR_HEADERS=/out-headers
DESTDIR_LIBRARIES=/out-libraries
#DESTDIR_MAKEFILE=/out-makefiles
REALTOP=/source
# RPM_NAME_DISTRO_POSTFIX env var must be set

source /etc/os-release >/dev/null 2>&1

# this script is meant to run in EVA/ECC builder docker:
if [ "$ID" == "fedora" ]; then
    echo "Running inside builder docker... proceeding"
else
    echo "Builder docker image NOT detected... aborting"
    exit 99
fi

dnf install -y intel-ipsec-mb-devel-1.3.0

cd $REALTOP/6wind

# Extract the package
rm -rf ./${LIB_NAME}${LIB_VER}/
tar xf ${LIB_NAME}${LIB_VER}.tar || exit 1
cd ./${LIB_NAME}${LIB_VER}/ 

# Extract the sources
tar xf dl/6windgate-tools-build-framework-${LIB_VER}-src.tgz

# Apply the default config
cd $REALTOP/6wind/${LIB_NAME}${LIB_VER}/tools-build-framework/
make defconfig C=${REALTOP}/6wind/${LIB_NAME}${LIB_VER}/config/pkg.config || exit 2

# Install the packages required for DPDK build
DEPS="$(make -s list-system-reqs) elfutils-devel libarchive-devel"
dnf install -y $DEPS || exit 3

# This is required later on, when running dpdk-pmdinfogen tool:
pip install pyelftools

# https://empirix.atlassian.net/browse/IN-56506?focusedCommentId=404830
dnf erase -y openssl-devel

# Prepare the sources for compilation
make prepare DL=${REALTOP}/6wind/${LIB_NAME}${LIB_VER}/dl || exit 4

cd $REALTOP/6wind

# Apply the empirix patches
echo "=== Applying Empirix patches for build"
patch -p0 < patches/6wind_5.6_fix_include.patch
patch -p0 < patches/6wind_5.6_fix_build.patch
patch -p0 < patches/6wind_5.6_package.patch

# This patch is coming from "./6windgate-x86_64-redhat-8-empirix-v5.6.0.ga/tools-build-framework/make menuconfig"
# Output : 6windgate-x86_64-redhat-8-empirix-v5.6.0.ga/tools-build-framework/output/.config
# Default: 6windgate-x86_64-redhat-8-empirix-v5.6.0.ga/tools-build-framework/output/.defconfig
echo "=== Applying Empirix patches for build options (crypto)"
patch -p0 < patches/6wind_5.6_config.patch

echo "=== Applying Empirix patches for increasing max fragments per packet"
patch -p0 < patches/6wind_5.6_max_ip_frag.patch
echo "=== Applying Empirix patches for handling of duplicate first and/or last fragments"
patch -p0 < patches/6wind_5.6_fix_frag_reassembly.patch

echo "CONFIG_PKG_DPDK_BUILD_SHARED_LIB=y" >>${REALTOP}/6wind/${LIB_NAME}${LIB_VER}/tools-build-framework/output/.config

# Issue the compilation of DPDK package (...this will take a lot of time...)
make -C ./${LIB_NAME}${LIB_VER}/tools-build-framework/ dpdk J=${NUM_CPUS} || exit 5
# Issue the compilation of Mellanox package
make -C ./${LIB_NAME}${LIB_VER}/tools-build-framework/ rdma-core J=${NUM_CPUS} || exit 6

# export HEADER files
rsync -avP /source/6wind/${LIB_NAME}${LIB_VER}/tools-build-framework/output/_packages/dpdk/devel/usr/include/* $DESTDIR_HEADERS/

# export the generated DPDK LIBRARIES
rsync -avP /source/6wind/${LIB_NAME}${LIB_VER}/tools-build-framework/output/_packages/dpdk/devel/usr/lib/ $DESTDIR_LIBRARIES/
mv $DESTDIR_LIBRARIES/dpdk/pmds-22.0/* $DESTDIR_LIBRARIES
rm -rf $DESTDIR_LIBRARIES/dpdk $DESTDIR_LIBRARIES/pkgconfig

# export the generated RDMA LIBRARIES (libmlx*)
rsync -avP /source/6wind/${LIB_NAME}${LIB_VER}/tools-build-framework/output/_packages/rdma-core/devel/opt/6WIND/Mellanox/lib/libmlx* $DESTDIR_LIBRARIES/
rsync -avP /source/6wind/${LIB_NAME}${LIB_VER}/tools-build-framework/output/_packages/rdma-core/devel/opt/6WIND/Mellanox/lib/libibverbs.a $DESTDIR_LIBRARIES/

# export makefile support stuff using pkg-config utility and the 
# DPDK pkgconfig file installed into PKG_CONFIG_PATH
#
# VERY IMPORTANT: we have found that the list of DPDK libs reportedby pkg-config is not complete and, when using dynamic libraries,
#                 the binary produced by linking with $(pkg-config --libs libdpdk) does not work since it's missing for example all PMDs!!!
#                 for this reason we have a static list of DPDK libs defined in support makefile
#export PKG_CONFIG_PATH=/source/6wind/6windgate-x86_64-redhat-8-empirix-v5.6.0.ga/tools-build-framework/output/_packages/dpdk/devel/usr/lib/pkgconfig
#pkg-config --libs libdpdk >>$DESTDIR_MAKEFILE/6WindGateDpdk-support-list.mk
