#
# This is the makefile of third-party-cpp-libs-specific defines
# for C/C++ builds
#

ifeq ($(TOPDIR),)
$(error Please define TOPDIR first)
endif
REALTOP=$(shell readlink -f $(TOPDIR))

# ---------------------------------------------
# integration with Conan
# ---------------------------------------------

EMPIRIX_PIPELINE_FRAMEWORK_DIR:=$(EMPIRIX_PIPELINE_FRAMEWORK_DIR)
EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR:=$(EMPIRIX_PIPELINE_FRAMEWORK_DIR)/makefiles
EMPIRIX_PIPELINE_FRAMEWORK_SCRIPT_SUPPORT_DIR:=$(EMPIRIX_PIPELINE_FRAMEWORK_DIR)/scripts

# ------------------------------------------------------------------------------------------
# main defines
# ------------------------------------------------------------------------------------------

GIT_STABLE_BRANCH=develop
-include ${EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR}/Common-defines.mk
-include ${EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR}/Version-defines.mk
-include ${EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR}/Deploy-defines.mk

CONAN_DEPENDENCIES_DIR=$(TOPDIR)/.conan_dependencies/$(RUNTIME)-$(CONAN_INSTALL_BUILD_TYPE)
-include $(CONAN_DEPENDENCIES_DIR)/conanbuildinfo.mak

EMPIRIX_DOCKER_BASE_DIR:=$(CONAN_ROOT_DOCKER-BASE)
EMPIRIX_DOCKER_BASE_MAKEFILE_SUPPORT_DIR:=$(EMPIRIX_DOCKER_BASE_DIR)/makefiles

-include $(EMPIRIX_DOCKER_BASE_MAKEFILE_SUPPORT_DIR)/DockerBase-support.mk

# to build with the docker toolchain this repository, we use the builder image produced by the
# eva-ecc-cpp-docker-base repo.
BUILDER_DOCKER_IMAGE_VERSION:=$(EMPIRIX_DOCKER_BASE_DOCKER_VERSION)

# ------------------------------------------------------------------------------------------
# per-library defines (caller Makefile should set these)
# ------------------------------------------------------------------------------------------

ifndef HAS_INSTALL_SUPPORT
# default value
HAS_INSTALL_SUPPORT=1
endif

ifndef HAS_INCLUDE_SUPPORT
# default value
HAS_INCLUDE_SUPPORT=1
endif

ifndef HAS_ONLY_RELEASE_MODE_PRECOMPILED
# default value
HAS_ONLY_RELEASE_MODE_PRECOMPILED=1
endif

# to build precompiled binaries faster, set here a number equal to the cores of your machine:
NUM_PROCS=$(NUM_CPUS)

# create the PRECOMPILED_DIR variable:
ifeq ($(HAS_ONLY_RELEASE_MODE_PRECOMPILED),1)
	PRECOMPILED_DIR=$(ARCH)-$(RUNTIME)-release
else
	PRECOMPILED_DIR=$(BUILDID)
endif

# utility for creating links
LIBLINKS=${EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR}/../scripts/liblinks.sh

# used to produce support makefiles and tarballs for downsstreams
BUILD_TIMESTAMP := $(shell date +"%Y-%m-%d %T")
