#
# ThirdpartyTargetHelpers.mk
# This is the file which is included by all makefiles to get some GNU make targets implementations.
# NOTE: This makefile is included AFTER Repo-defines.mk
# 

ifndef LIBNAME
# default value
$(error No LIBNAME variable defined)
endif

#ifndef SHAREDLIBNAME
## default value
#$(error No SHAREDLIBNAME variable defined)
#endif

ifeq ($(V),1)
VERBOSE_FLAG=--verbose
else
VERBOSE_FLAG=
endif

ifeq ($(PRECOMPILED_DIR),)
# default value
$(error No PRECOMPILED_DIR variable defined)
endif



#
# Strip target
#
strip:
ifeq ($(DEBUG),)
	@echo "Skipping stripping of debug symbols from debug build"
else
	-strip --strip-debug $(PRECOMPILED_DIR)/*.a $(PRECOMPILED_DIR)/*.so
	-ranlib $(PRECOMPILED_DIR)/*.a    # after stripping it's important to run ranlib to make sure the static library is usable and linkable
endif

#
# Clean target
#

clean:: clean_build_intermediate_artifacts clean_build_outputs

#
# Install support
#
# NOTE: the ||true part is necessary to avoid cp failures of type:
#    cp: ‘x86_64-release/libssl.so.1.0.0’ and ‘[...]/Third-Party/cpp-libs/Lib/x86_64-release/libssl.so.1.0.0’ are the same file
# In such a case, cp returns with error code 1, even if it's not really an error (at least for us)

ifeq ($(HAS_INSTALL_SUPPORT),1)
install_libs::
ifndef DESTDIR
	@echo "*** ERROR: please call this makefile supplying explicitly the DESTDIR variable"
	@exit 1
endif
	@echo "Installing $(LIBNAME) third party library to $(DESTDIR)"
	@mkdir --parents                   $(DESTDIR)
ifneq ($(wildcard $(PRECOMPILED_DIR)/lib*.so*),)
	@cp -afv $(VERBOSE_FLAG) $(PRECOMPILED_DIR)/lib*.so*      $(DESTDIR)
endif
ifneq ($(wildcard $(PRECOMPILED_DIR)/lib*.a),)
	@cp -afv $(VERBOSE_FLAG) $(PRECOMPILED_DIR)/lib*.a        $(DESTDIR)
endif
ifneq ($(SHAREDLIBNAME),)
	@# NOTE: shared libraries under Linux do not necessarily need executable permissions set. That's only useful if you want to
	@#       run them as binaries... see https://unix.stackexchange.com/questions/40587/why-are-shared-libraries-executable
	@-chmod a+rw $(DESTDIR)/*$(SHAREDLIBNAME)*.so*s
endif

ifeq ($(HAS_INCLUDE_SUPPORT),1)
install_headers::
ifndef DESTDIR
	@echo "*** ERROR: please call this makefile supplying explicitly the DESTDIR variable"
	@exit 1
endif
	@echo "Installing $(LIBNAME) third party library header files to $(DESTDIR)"
	@mkdir --parents                        $(DESTDIR)
	@cp -afr $(VERBOSE_FLAG) include/*      $(DESTDIR)/
endif
endif

.PHONY: install_libs install_headers



#
# Symlink support:
# For now, just re-use the install target
#

symlinks_to_destdir:: install_libs




#
# Format check support:
# disabled for 3rd party stuff!
#

format_check:: 
	@echo "Skipping format check"
	

-include ${EMPIRIX_PIPELINE_FRAMEWORK_MAKEFILE_SUPPORT_DIR}/Common-targets.mk
	
