//
// call_diversion_operations.h
//
// Code automatically generated by asnparser.
//

#ifndef __CALL_DIVERSION_OPERATIONS_H
#define __CALL_DIVERSION_OPERATIONS_H

#include <asn1.h>

#include "remote_operations_information_objects.h"
#include "manufacturer_specific_service_extension_definition.h"
#include "h225_generic_parameters_definition.h"
#include "hm_callidentifier.h"
#include "addressing_data_elements.h"
#include "h4501_general_error_list.h"


namespace Call_Diversion_Operations {

using Remote_Operations_Information_Objects::ERROR;
using Remote_Operations_Information_Objects::OPERATION;
using Manufacturer_specific_service_extension_definition::EXTENSION;
//
// DiversionReason
//

class DiversionReason : public ASN1::ENUMERATED
{
    typedef ASN1::ENUMERATED Inherited;
  protected:
    DiversionReason(const void* info) : Inherited(info) {}
  public:
    DiversionReason() : Inherited(&theInfo) { }
    enum NamedNumber {
      unknownEnumeration_ = -1,
      unknown,
      cfu,
      cfb,
      cfnr
    };

    bool is_unknown() const { return value == unknown; }
    void set_unknown() { value = unknown; }

    bool is_cfu() const { return value == cfu; }
    void set_cfu() { value = cfu; }

    bool is_cfb() const { return value == cfb; }
    void set_cfb() { value = cfb; }

    bool is_cfnr() const { return value == cfnr; }
    void set_cfnr() { value = cfnr; }

    DiversionReason(const NamedNumber value) : Inherited(&theInfo){ setFromInt(value); }
    DiversionReason & operator=(const NamedNumber v) { setFromInt(v);  return *this; }
    operator NamedNumber() const
    { return NamedNumber(asInt()); }

    void swap (DiversionReason & other)
    { ENUMERATED::swap(other); }
    DiversionReason * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
};

//
// Procedure
//

class Procedure : public ASN1::ENUMERATED
{
    typedef ASN1::ENUMERATED Inherited;
  protected:
    Procedure(const void* info) : Inherited(info) {}
  public:
    Procedure() : Inherited(&theInfo) { }
    enum NamedNumber {
      unknownEnumeration_ = -1,
      cfu,
      cfb,
      cfnr
    };

    bool is_cfu() const { return value == cfu; }
    void set_cfu() { value = cfu; }

    bool is_cfb() const { return value == cfb; }
    void set_cfb() { value = cfb; }

    bool is_cfnr() const { return value == cfnr; }
    void set_cfnr() { value = cfnr; }

    Procedure(const NamedNumber value) : Inherited(&theInfo){ setFromInt(value); }
    Procedure & operator=(const NamedNumber v) { setFromInt(v);  return *this; }
    operator NamedNumber() const
    { return NamedNumber(asInt()); }

    void swap (Procedure & other)
    { ENUMERATED::swap(other); }
    Procedure * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
};

//
// SubscriptionOption
//

class SubscriptionOption : public ASN1::ENUMERATED
{
    typedef ASN1::ENUMERATED Inherited;
  protected:
    SubscriptionOption(const void* info) : Inherited(info) {}
  public:
    SubscriptionOption() : Inherited(&theInfo) { }
    enum NamedNumber {
      unknownEnumeration_ = -1,
      noNotification,
      notificationWithoutDivertedToNr,
      notificationWithDivertedToNr
    };

    bool is_noNotification() const { return value == noNotification; }
    void set_noNotification() { value = noNotification; }

    bool is_notificationWithoutDivertedToNr() const { return value == notificationWithoutDivertedToNr; }
    void set_notificationWithoutDivertedToNr() { value = notificationWithoutDivertedToNr; }

    bool is_notificationWithDivertedToNr() const { return value == notificationWithDivertedToNr; }
    void set_notificationWithDivertedToNr() { value = notificationWithDivertedToNr; }

    SubscriptionOption(const NamedNumber value) : Inherited(&theInfo){ setFromInt(value); }
    SubscriptionOption & operator=(const NamedNumber v) { setFromInt(v);  return *this; }
    operator NamedNumber() const
    { return NamedNumber(asInt()); }

    void swap (SubscriptionOption & other)
    { ENUMERATED::swap(other); }
    SubscriptionOption * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
};

//
// BasicService
//

class BasicService : public ASN1::ENUMERATED
{
    typedef ASN1::ENUMERATED Inherited;
  protected:
    BasicService(const void* info) : Inherited(info) {}
  public:
    BasicService() : Inherited(&theInfo) { }
    enum NamedNumber {
      unknownEnumeration_ = -1,
      allServices
    };

    bool is_allServices() const { return value == allServices; }
    void set_allServices() { value = allServices; }

    BasicService(const NamedNumber value) : Inherited(&theInfo){ setFromInt(value); }
    BasicService & operator=(const NamedNumber v) { setFromInt(v);  return *this; }
    operator NamedNumber() const
    { return NamedNumber(asInt()); }

    void swap (BasicService & other)
    { ENUMERATED::swap(other); }
    BasicService * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
};


//
// ExtensionSet
//

class ExtensionSet
{
  public:
    typedef EXTENSION element_type;
    ExtensionSet(ASN1::CoderEnv& env);
    EXTENSION* get() const { return objSet; }
    EXTENSION* operator->() const { return objSet; }
    bool extensible() const { return true; }
  private:
    EXTENSION* objSet;
};

typedef ASN1::SEQUENCE_OF<Manufacturer_specific_service_extension_definition::Extension<ExtensionSet> >  ExtensionSeq;

//
// IntResult_extension
//

class IntResult_extension : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    IntResult_extension(const void* info) : Inherited(info) {}
  public:
    IntResult_extension() : Inherited(&theInfo) {}
    class extensionSeq {
      public:
        enum Id { id_ = 0 };
        typedef ExtensionSeq value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class extensionSeq

    extensionSeq::const_reference get_extensionSeq () const;
    extensionSeq::reference ref_extensionSeq (); 
    extensionSeq::reference select_extensionSeq (); 
    extensionSeq::reference select_extensionSeq (extensionSeq::const_reference value); 
    bool extensionSeq_isSelected() const;

    class nonStandardData {
      public:
        enum Id { id_ = 1 };
        typedef H323_MESSAGES::NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData

    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData (); 
    nonStandardData::reference select_nonStandardData (); 
    nonStandardData::reference select_nonStandardData (nonStandardData::const_reference value); 
    bool nonStandardData_isSelected() const;

    IntResult_extension(extensionSeq::Id id, extensionSeq::const_reference value);
    IntResult_extension(nonStandardData::Id id, nonStandardData::const_reference value);
    void swap(IntResult_extension & other);
    IntResult_extension(const IntResult_extension & other)
    : Inherited(other) {} 

    IntResult_extension & operator = (const IntResult_extension & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    IntResult_extension * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// IntResult
//

class IntResult : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    IntResult(const void* info) : Inherited(info) {}
  public:
    IntResult() : Inherited(&theInfo) {}
    IntResult(const IntResult & other) : Inherited(other)
    {}
    IntResult& operator = (const IntResult& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_extension
    };

    class servedUserNr {
      public:
        typedef Addressing_Data_Elements::EndpointAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class servedUserNr
    servedUserNr::const_reference get_servedUserNr () const;
    servedUserNr::reference ref_servedUserNr ();
    servedUserNr::reference set_servedUserNr ();
    servedUserNr::reference set_servedUserNr (servedUserNr::const_reference value);
    class basicService {
      public:
        typedef BasicService value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class basicService
    basicService::const_reference get_basicService () const;
    basicService::reference ref_basicService ();
    basicService::reference set_basicService ();
    basicService::reference set_basicService (basicService::value_type::NamedNumber value);
    class procedure {
      public:
        typedef Procedure value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class procedure
    procedure::const_reference get_procedure () const;
    procedure::reference ref_procedure ();
    procedure::reference set_procedure ();
    procedure::reference set_procedure (procedure::value_type::NamedNumber value);
    class divertedToAddress {
      public:
        typedef Addressing_Data_Elements::EndpointAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class divertedToAddress
    divertedToAddress::const_reference get_divertedToAddress () const;
    divertedToAddress::reference ref_divertedToAddress ();
    divertedToAddress::reference set_divertedToAddress ();
    divertedToAddress::reference set_divertedToAddress (divertedToAddress::const_reference value);
    class remoteEnabled {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class remoteEnabled
    remoteEnabled::const_reference get_remoteEnabled () const;
    remoteEnabled::reference ref_remoteEnabled ();
    remoteEnabled::reference set_remoteEnabled ();
    remoteEnabled::reference set_remoteEnabled (bool value);
    class extension {
      public:
        typedef IntResult_extension value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class extension
    extension::const_reference get_extension () const;
    extension::reference ref_extension ();
    extension::reference set_extension ();
    extension::reference set_extension (extension::const_reference value);
    void omit_extension ();
    bool extension_isPresent () const;
    void swap(IntResult& other);
    IntResult * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[6];
    static int fieldIds[6];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[6];
#endif
};

typedef ASN1::SET_OF<IntResult,  ASN1::SizeConstraint<ASN1::FixedConstraint, 0, 29> >  IntResultList;

class Module : public ASN1::Module
{
  public:
    Module(H4501_General_Error_List::Module* );
    class activateDiversionQ
    {
      public:
        activateDiversionQ();
        class ArgumentType : public ASN1::SEQUENCE
        {
            typedef ASN1::SEQUENCE Inherited;
          protected:
            ArgumentType(const void* info) : Inherited(info) {}
          public:
            ArgumentType() : Inherited(&theInfo) {}
            ArgumentType(const ArgumentType & other) : Inherited(other)
            {}
            ArgumentType& operator = (const ArgumentType& other)
            { Inherited::operator = (other); return *this; } 
            enum OptionalFields {
              e_extension
            };

            class procedure {
              public:
                typedef Procedure value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class procedure
            procedure::const_reference get_procedure () const;
            procedure::reference ref_procedure ();
            procedure::reference set_procedure ();
            procedure::reference set_procedure (procedure::value_type::NamedNumber value);
            class basicService {
              public:
                typedef BasicService value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class basicService
            basicService::const_reference get_basicService () const;
            basicService::reference ref_basicService ();
            basicService::reference set_basicService ();
            basicService::reference set_basicService (basicService::value_type::NamedNumber value);
            class divertedToAddress {
              public:
                typedef Addressing_Data_Elements::EndpointAddress value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class divertedToAddress
            divertedToAddress::const_reference get_divertedToAddress () const;
            divertedToAddress::reference ref_divertedToAddress ();
            divertedToAddress::reference set_divertedToAddress ();
            divertedToAddress::reference set_divertedToAddress (divertedToAddress::const_reference value);
            class servedUserNr {
              public:
                typedef Addressing_Data_Elements::EndpointAddress value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class servedUserNr
            servedUserNr::const_reference get_servedUserNr () const;
            servedUserNr::reference ref_servedUserNr ();
            servedUserNr::reference set_servedUserNr ();
            servedUserNr::reference set_servedUserNr (servedUserNr::const_reference value);
            class activatingUserNr {
              public:
                typedef Addressing_Data_Elements::EndpointAddress value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class activatingUserNr
            activatingUserNr::const_reference get_activatingUserNr () const;
            activatingUserNr::reference ref_activatingUserNr ();
            activatingUserNr::reference set_activatingUserNr ();
            activatingUserNr::reference set_activatingUserNr (activatingUserNr::const_reference value);
            class extension {
              public:
                class value_type : public ASN1::CHOICE
                {
                    typedef ASN1::CHOICE Inherited;
                  protected:
                    value_type(const void* info) : Inherited(info) {}
                  public:
                    value_type() : Inherited(&theInfo) {}
                    class extensionSeq {
                      public:
                        enum Id { id_ = 0 };
                        typedef ExtensionSeq value_type;
                        typedef value_type&			reference;
                        typedef const value_type&	const_reference;
                        typedef value_type*			pointer;
                        typedef const value_type*	const_pointer;
                    }; // end class extensionSeq

                    extensionSeq::const_reference get_extensionSeq () const;
                    extensionSeq::reference ref_extensionSeq (); 
                    extensionSeq::reference select_extensionSeq (); 
                    extensionSeq::reference select_extensionSeq (extensionSeq::const_reference value); 
                    bool extensionSeq_isSelected() const;

                    class nonStandardData {
                      public:
                        enum Id { id_ = 1 };
                        typedef H323_MESSAGES::NonStandardParameter value_type;
                        typedef value_type&			reference;
                        typedef const value_type&	const_reference;
                        typedef value_type*			pointer;
                        typedef const value_type*	const_pointer;
                    }; // end class nonStandardData

                    nonStandardData::const_reference get_nonStandardData () const;
                    nonStandardData::reference ref_nonStandardData (); 
                    nonStandardData::reference select_nonStandardData (); 
                    nonStandardData::reference select_nonStandardData (nonStandardData::const_reference value); 
                    bool nonStandardData_isSelected() const;

                    value_type(extensionSeq::Id id, extensionSeq::const_reference value);
                    value_type(nonStandardData::Id id, nonStandardData::const_reference value);
                    void swap(value_type & other);
                    value_type(const value_type & other)
                    : Inherited(other) {} 

                    value_type & operator = (const value_type & other)
                    {
                      Inherited::operator=(other);
                      return *this;
                    }

                    value_type * clone() const;
                    static bool equal_type(const ASN1::AbstractData&);
                    static void extract(const ASN1::AbstractData& data);
                    static const InfoType theInfo;
                  private:
                    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
                    static const char* selectionNames[2];
#endif
                };

                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class extension
            extension::const_reference get_extension () const;
            extension::reference ref_extension ();
            extension::reference set_extension ();
            extension::reference set_extension (extension::const_reference value);
            void omit_extension ();
            bool extension_isPresent () const;
            void swap(ArgumentType& other);
            ArgumentType * clone() const;
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
  private:
            static const void* fieldInfos[6];
            static int fieldIds[6];
#ifdef ASN1_HAS_IOSTREAM
            static const char* fieldNames[6];
#endif
        };

        class ResultType : public ASN1::CHOICE
        {
            typedef ASN1::CHOICE Inherited;
          protected:
            ResultType(const void* info) : Inherited(info) {}
          public:
            ResultType() : Inherited(&theInfo) {}
            class extensionSeq {
              public:
                enum Id { id_ = 0 };
                typedef ExtensionSeq value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class extensionSeq

            extensionSeq::const_reference get_extensionSeq () const;
            extensionSeq::reference ref_extensionSeq (); 
            extensionSeq::reference select_extensionSeq (); 
            extensionSeq::reference select_extensionSeq (extensionSeq::const_reference value); 
            bool extensionSeq_isSelected() const;

            class nonStandardData {
              public:
                enum Id { id_ = 1 };
                typedef H323_MESSAGES::NonStandardParameter value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class nonStandardData

            nonStandardData::const_reference get_nonStandardData () const;
            nonStandardData::reference ref_nonStandardData (); 
            nonStandardData::reference select_nonStandardData (); 
            nonStandardData::reference select_nonStandardData (nonStandardData::const_reference value); 
            bool nonStandardData_isSelected() const;

            ResultType(extensionSeq::Id id, extensionSeq::const_reference value);
            ResultType(nonStandardData::Id id, nonStandardData::const_reference value);
            void swap(ResultType & other);
            ResultType(const ResultType & other)
            : Inherited(other) {} 

            ResultType & operator = (const ResultType & other)
            {
              Inherited::operator=(other);
              return *this;
            }

            ResultType * clone() const;
            static bool equal_type(const ASN1::AbstractData&);
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
          private:
            static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
            static const char* selectionNames[2];
#endif
        };

        ERROR Errors;
        const Remote_Operations_Information_Objects::Code operationCode;
        OPERATION::value_type make() const
        { return OPERATION::value_type(operationCode,&info ); }
      private:
        class Info : public OPERATION::info_type
        {
          public:
            Info(activateDiversionQ* parent)
            {
                m_ArgumentType= &ArgumentType::theInfo;
                m_ResultType= &ResultType::theInfo;
                m_Errors= &(parent-> Errors);
            }
        };
        Info info;
    }; // class activateDiversionQ
    class deactivateDiversionQ
    {
      public:
        deactivateDiversionQ();
        class ArgumentType : public ASN1::SEQUENCE
        {
            typedef ASN1::SEQUENCE Inherited;
          protected:
            ArgumentType(const void* info) : Inherited(info) {}
          public:
            ArgumentType() : Inherited(&theInfo) {}
            ArgumentType(const ArgumentType & other) : Inherited(other)
            {}
            ArgumentType& operator = (const ArgumentType& other)
            { Inherited::operator = (other); return *this; } 
            enum OptionalFields {
              e_extension
            };

            class procedure {
              public:
                typedef Procedure value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class procedure
            procedure::const_reference get_procedure () const;
            procedure::reference ref_procedure ();
            procedure::reference set_procedure ();
            procedure::reference set_procedure (procedure::value_type::NamedNumber value);
            class basicService {
              public:
                typedef BasicService value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class basicService
            basicService::const_reference get_basicService () const;
            basicService::reference ref_basicService ();
            basicService::reference set_basicService ();
            basicService::reference set_basicService (basicService::value_type::NamedNumber value);
            class servedUserNr {
              public:
                typedef Addressing_Data_Elements::EndpointAddress value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class servedUserNr
            servedUserNr::const_reference get_servedUserNr () const;
            servedUserNr::reference ref_servedUserNr ();
            servedUserNr::reference set_servedUserNr ();
            servedUserNr::reference set_servedUserNr (servedUserNr::const_reference value);
            class deactivatingUserNr {
              public:
                typedef Addressing_Data_Elements::EndpointAddress value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class deactivatingUserNr
            deactivatingUserNr::const_reference get_deactivatingUserNr () const;
            deactivatingUserNr::reference ref_deactivatingUserNr ();
            deactivatingUserNr::reference set_deactivatingUserNr ();
            deactivatingUserNr::reference set_deactivatingUserNr (deactivatingUserNr::const_reference value);
            class extension {
              public:
                class value_type : public ASN1::CHOICE
                {
                    typedef ASN1::CHOICE Inherited;
                  protected:
                    value_type(const void* info) : Inherited(info) {}
                  public:
                    value_type() : Inherited(&theInfo) {}
                    class extensionSeq {
                      public:
                        enum Id { id_ = 0 };
                        typedef ExtensionSeq value_type;
                        typedef value_type&			reference;
                        typedef const value_type&	const_reference;
                        typedef value_type*			pointer;
                        typedef const value_type*	const_pointer;
                    }; // end class extensionSeq

                    extensionSeq::const_reference get_extensionSeq () const;
                    extensionSeq::reference ref_extensionSeq (); 
                    extensionSeq::reference select_extensionSeq (); 
                    extensionSeq::reference select_extensionSeq (extensionSeq::const_reference value); 
                    bool extensionSeq_isSelected() const;

                    class nonStandardData {
                      public:
                        enum Id { id_ = 1 };
                        typedef H323_MESSAGES::NonStandardParameter value_type;
                        typedef value_type&			reference;
                        typedef const value_type&	const_reference;
                        typedef value_type*			pointer;
                        typedef const value_type*	const_pointer;
                    }; // end class nonStandardData

                    nonStandardData::const_reference get_nonStandardData () const;
                    nonStandardData::reference ref_nonStandardData (); 
                    nonStandardData::reference select_nonStandardData (); 
                    nonStandardData::reference select_nonStandardData (nonStandardData::const_reference value); 
                    bool nonStandardData_isSelected() const;

                    value_type(extensionSeq::Id id, extensionSeq::const_reference value);
                    value_type(nonStandardData::Id id, nonStandardData::const_reference value);
                    void swap(value_type & other);
                    value_type(const value_type & other)
                    : Inherited(other) {} 

                    value_type & operator = (const value_type & other)
                    {
                      Inherited::operator=(other);
                      return *this;
                    }

                    value_type * clone() const;
                    static bool equal_type(const ASN1::AbstractData&);
                    static void extract(const ASN1::AbstractData& data);
                    static const InfoType theInfo;
                  private:
                    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
                    static const char* selectionNames[2];
#endif
                };

                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class extension
            extension::const_reference get_extension () const;
            extension::reference ref_extension ();
            extension::reference set_extension ();
            extension::reference set_extension (extension::const_reference value);
            void omit_extension ();
            bool extension_isPresent () const;
            void swap(ArgumentType& other);
            ArgumentType * clone() const;
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
  private:
            static const void* fieldInfos[5];
            static int fieldIds[5];
#ifdef ASN1_HAS_IOSTREAM
            static const char* fieldNames[5];
#endif
        };

        class ResultType : public ASN1::CHOICE
        {
            typedef ASN1::CHOICE Inherited;
          protected:
            ResultType(const void* info) : Inherited(info) {}
          public:
            ResultType() : Inherited(&theInfo) {}
            class extensionSeq {
              public:
                enum Id { id_ = 0 };
                typedef ExtensionSeq value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class extensionSeq

            extensionSeq::const_reference get_extensionSeq () const;
            extensionSeq::reference ref_extensionSeq (); 
            extensionSeq::reference select_extensionSeq (); 
            extensionSeq::reference select_extensionSeq (extensionSeq::const_reference value); 
            bool extensionSeq_isSelected() const;

            class nonStandardData {
              public:
                enum Id { id_ = 1 };
                typedef H323_MESSAGES::NonStandardParameter value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class nonStandardData

            nonStandardData::const_reference get_nonStandardData () const;
            nonStandardData::reference ref_nonStandardData (); 
            nonStandardData::reference select_nonStandardData (); 
            nonStandardData::reference select_nonStandardData (nonStandardData::const_reference value); 
            bool nonStandardData_isSelected() const;

            ResultType(extensionSeq::Id id, extensionSeq::const_reference value);
            ResultType(nonStandardData::Id id, nonStandardData::const_reference value);
            void swap(ResultType & other);
            ResultType(const ResultType & other)
            : Inherited(other) {} 

            ResultType & operator = (const ResultType & other)
            {
              Inherited::operator=(other);
              return *this;
            }

            ResultType * clone() const;
            static bool equal_type(const ASN1::AbstractData&);
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
          private:
            static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
            static const char* selectionNames[2];
#endif
        };

        ERROR Errors;
        const Remote_Operations_Information_Objects::Code operationCode;
        OPERATION::value_type make() const
        { return OPERATION::value_type(operationCode,&info ); }
      private:
        class Info : public OPERATION::info_type
        {
          public:
            Info(deactivateDiversionQ* parent)
            {
                m_ArgumentType= &ArgumentType::theInfo;
                m_ResultType= &ResultType::theInfo;
                m_Errors= &(parent-> Errors);
            }
        };
        Info info;
    }; // class deactivateDiversionQ
    class interrogateDiversionQ
    {
      public:
        interrogateDiversionQ();
        class ArgumentType : public ASN1::SEQUENCE
        {
            typedef ASN1::SEQUENCE Inherited;
          protected:
            ArgumentType(const void* info) : Inherited(info) {}
          public:
            ArgumentType() : Inherited(&theInfo) {}
            ArgumentType(const ArgumentType & other) : Inherited(other)
            {}
            ArgumentType& operator = (const ArgumentType& other)
            { Inherited::operator = (other); return *this; } 
            enum OptionalFields {
              e_extension
            };

            class procedure {
              public:
                typedef Procedure value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class procedure
            procedure::const_reference get_procedure () const;
            procedure::reference ref_procedure ();
            procedure::reference set_procedure ();
            procedure::reference set_procedure (procedure::value_type::NamedNumber value);
            class basicService {
              public:
                typedef BasicService value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class basicService
            basicService::const_reference get_basicService () const;
            basicService::reference ref_basicService ();
            basicService::reference set_basicService ();
            basicService::reference set_basicService (basicService::value_type::NamedNumber value);
            class servedUserNr {
              public:
                typedef Addressing_Data_Elements::EndpointAddress value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class servedUserNr
            servedUserNr::const_reference get_servedUserNr () const;
            servedUserNr::reference ref_servedUserNr ();
            servedUserNr::reference set_servedUserNr ();
            servedUserNr::reference set_servedUserNr (servedUserNr::const_reference value);
            class interrogatingUserNr {
              public:
                typedef Addressing_Data_Elements::EndpointAddress value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class interrogatingUserNr
            interrogatingUserNr::const_reference get_interrogatingUserNr () const;
            interrogatingUserNr::reference ref_interrogatingUserNr ();
            interrogatingUserNr::reference set_interrogatingUserNr ();
            interrogatingUserNr::reference set_interrogatingUserNr (interrogatingUserNr::const_reference value);
            class extension {
              public:
                class value_type : public ASN1::CHOICE
                {
                    typedef ASN1::CHOICE Inherited;
                  protected:
                    value_type(const void* info) : Inherited(info) {}
                  public:
                    value_type() : Inherited(&theInfo) {}
                    class extensionSeq {
                      public:
                        enum Id { id_ = 0 };
                        typedef ExtensionSeq value_type;
                        typedef value_type&			reference;
                        typedef const value_type&	const_reference;
                        typedef value_type*			pointer;
                        typedef const value_type*	const_pointer;
                    }; // end class extensionSeq

                    extensionSeq::const_reference get_extensionSeq () const;
                    extensionSeq::reference ref_extensionSeq (); 
                    extensionSeq::reference select_extensionSeq (); 
                    extensionSeq::reference select_extensionSeq (extensionSeq::const_reference value); 
                    bool extensionSeq_isSelected() const;

                    class nonStandardData {
                      public:
                        enum Id { id_ = 1 };
                        typedef H323_MESSAGES::NonStandardParameter value_type;
                        typedef value_type&			reference;
                        typedef const value_type&	const_reference;
                        typedef value_type*			pointer;
                        typedef const value_type*	const_pointer;
                    }; // end class nonStandardData

                    nonStandardData::const_reference get_nonStandardData () const;
                    nonStandardData::reference ref_nonStandardData (); 
                    nonStandardData::reference select_nonStandardData (); 
                    nonStandardData::reference select_nonStandardData (nonStandardData::const_reference value); 
                    bool nonStandardData_isSelected() const;

                    value_type(extensionSeq::Id id, extensionSeq::const_reference value);
                    value_type(nonStandardData::Id id, nonStandardData::const_reference value);
                    void swap(value_type & other);
                    value_type(const value_type & other)
                    : Inherited(other) {} 

                    value_type & operator = (const value_type & other)
                    {
                      Inherited::operator=(other);
                      return *this;
                    }

                    value_type * clone() const;
                    static bool equal_type(const ASN1::AbstractData&);
                    static void extract(const ASN1::AbstractData& data);
                    static const InfoType theInfo;
                  private:
                    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
                    static const char* selectionNames[2];
#endif
                };

                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class extension
            extension::const_reference get_extension () const;
            extension::reference ref_extension ();
            extension::reference set_extension ();
            extension::reference set_extension (extension::const_reference value);
            void omit_extension ();
            bool extension_isPresent () const;
            void swap(ArgumentType& other);
            ArgumentType * clone() const;
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
  private:
            static const void* fieldInfos[5];
            static int fieldIds[5];
#ifdef ASN1_HAS_IOSTREAM
            static const char* fieldNames[5];
#endif
        };

        typedef IntResultList ResultType;
        ERROR Errors;
        const Remote_Operations_Information_Objects::Code operationCode;
        OPERATION::value_type make() const
        { return OPERATION::value_type(operationCode,&info ); }
      private:
        class Info : public OPERATION::info_type
        {
          public:
            Info(interrogateDiversionQ* parent)
            {
                m_ArgumentType= &ArgumentType::theInfo;
                m_ResultType= &ResultType::theInfo;
                m_Errors= &(parent-> Errors);
            }
        };
        Info info;
    }; // class interrogateDiversionQ
    class checkRestriction
    {
      public:
        checkRestriction();
        class ArgumentType : public ASN1::SEQUENCE
        {
            typedef ASN1::SEQUENCE Inherited;
          protected:
            ArgumentType(const void* info) : Inherited(info) {}
          public:
            ArgumentType() : Inherited(&theInfo) {}
            ArgumentType(const ArgumentType & other) : Inherited(other)
            {}
            ArgumentType& operator = (const ArgumentType& other)
            { Inherited::operator = (other); return *this; } 
            enum OptionalFields {
              e_extension
            };

            class servedUserNr {
              public:
                typedef Addressing_Data_Elements::EndpointAddress value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class servedUserNr
            servedUserNr::const_reference get_servedUserNr () const;
            servedUserNr::reference ref_servedUserNr ();
            servedUserNr::reference set_servedUserNr ();
            servedUserNr::reference set_servedUserNr (servedUserNr::const_reference value);
            class basicService {
              public:
                typedef BasicService value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class basicService
            basicService::const_reference get_basicService () const;
            basicService::reference ref_basicService ();
            basicService::reference set_basicService ();
            basicService::reference set_basicService (basicService::value_type::NamedNumber value);
            class divertedToNr {
              public:
                typedef Addressing_Data_Elements::EndpointAddress value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class divertedToNr
            divertedToNr::const_reference get_divertedToNr () const;
            divertedToNr::reference ref_divertedToNr ();
            divertedToNr::reference set_divertedToNr ();
            divertedToNr::reference set_divertedToNr (divertedToNr::const_reference value);
            class extension {
              public:
                class value_type : public ASN1::CHOICE
                {
                    typedef ASN1::CHOICE Inherited;
                  protected:
                    value_type(const void* info) : Inherited(info) {}
                  public:
                    value_type() : Inherited(&theInfo) {}
                    class extensionSeq {
                      public:
                        enum Id { id_ = 0 };
                        typedef ExtensionSeq value_type;
                        typedef value_type&			reference;
                        typedef const value_type&	const_reference;
                        typedef value_type*			pointer;
                        typedef const value_type*	const_pointer;
                    }; // end class extensionSeq

                    extensionSeq::const_reference get_extensionSeq () const;
                    extensionSeq::reference ref_extensionSeq (); 
                    extensionSeq::reference select_extensionSeq (); 
                    extensionSeq::reference select_extensionSeq (extensionSeq::const_reference value); 
                    bool extensionSeq_isSelected() const;

                    class nonStandardData {
                      public:
                        enum Id { id_ = 1 };
                        typedef H323_MESSAGES::NonStandardParameter value_type;
                        typedef value_type&			reference;
                        typedef const value_type&	const_reference;
                        typedef value_type*			pointer;
                        typedef const value_type*	const_pointer;
                    }; // end class nonStandardData

                    nonStandardData::const_reference get_nonStandardData () const;
                    nonStandardData::reference ref_nonStandardData (); 
                    nonStandardData::reference select_nonStandardData (); 
                    nonStandardData::reference select_nonStandardData (nonStandardData::const_reference value); 
                    bool nonStandardData_isSelected() const;

                    value_type(extensionSeq::Id id, extensionSeq::const_reference value);
                    value_type(nonStandardData::Id id, nonStandardData::const_reference value);
                    void swap(value_type & other);
                    value_type(const value_type & other)
                    : Inherited(other) {} 

                    value_type & operator = (const value_type & other)
                    {
                      Inherited::operator=(other);
                      return *this;
                    }

                    value_type * clone() const;
                    static bool equal_type(const ASN1::AbstractData&);
                    static void extract(const ASN1::AbstractData& data);
                    static const InfoType theInfo;
                  private:
                    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
                    static const char* selectionNames[2];
#endif
                };

                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class extension
            extension::const_reference get_extension () const;
            extension::reference ref_extension ();
            extension::reference set_extension ();
            extension::reference set_extension (extension::const_reference value);
            void omit_extension ();
            bool extension_isPresent () const;
            void swap(ArgumentType& other);
            ArgumentType * clone() const;
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
  private:
            static const void* fieldInfos[4];
            static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
            static const char* fieldNames[4];
#endif
        };

        class ResultType : public ASN1::CHOICE
        {
            typedef ASN1::CHOICE Inherited;
          protected:
            ResultType(const void* info) : Inherited(info) {}
          public:
            ResultType() : Inherited(&theInfo) {}
            class extensionSeq {
              public:
                enum Id { id_ = 0 };
                typedef ExtensionSeq value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class extensionSeq

            extensionSeq::const_reference get_extensionSeq () const;
            extensionSeq::reference ref_extensionSeq (); 
            extensionSeq::reference select_extensionSeq (); 
            extensionSeq::reference select_extensionSeq (extensionSeq::const_reference value); 
            bool extensionSeq_isSelected() const;

            class nonStandardData {
              public:
                enum Id { id_ = 1 };
                typedef H323_MESSAGES::NonStandardParameter value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class nonStandardData

            nonStandardData::const_reference get_nonStandardData () const;
            nonStandardData::reference ref_nonStandardData (); 
            nonStandardData::reference select_nonStandardData (); 
            nonStandardData::reference select_nonStandardData (nonStandardData::const_reference value); 
            bool nonStandardData_isSelected() const;

            ResultType(extensionSeq::Id id, extensionSeq::const_reference value);
            ResultType(nonStandardData::Id id, nonStandardData::const_reference value);
            void swap(ResultType & other);
            ResultType(const ResultType & other)
            : Inherited(other) {} 

            ResultType & operator = (const ResultType & other)
            {
              Inherited::operator=(other);
              return *this;
            }

            ResultType * clone() const;
            static bool equal_type(const ASN1::AbstractData&);
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
          private:
            static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
            static const char* selectionNames[2];
#endif
        };

        ERROR Errors;
        const Remote_Operations_Information_Objects::Code operationCode;
        OPERATION::value_type make() const
        { return OPERATION::value_type(operationCode,&info ); }
      private:
        class Info : public OPERATION::info_type
        {
          public:
            Info(checkRestriction* parent)
            {
                m_ArgumentType= &ArgumentType::theInfo;
                m_ResultType= &ResultType::theInfo;
                m_Errors= &(parent-> Errors);
            }
        };
        Info info;
    }; // class checkRestriction
    class callRerouting
    {
      public:
        callRerouting();
        class ArgumentType : public ASN1::SEQUENCE
        {
            typedef ASN1::SEQUENCE Inherited;
          protected:
            ArgumentType(const void* info) : Inherited(info) {}
          public:
            ArgumentType() : Inherited(&theInfo) {}
            ArgumentType(const ArgumentType & other) : Inherited(other)
            {}
            ArgumentType& operator = (const ArgumentType& other)
            { Inherited::operator = (other); return *this; } 
            enum OptionalFields {
              e_originalReroutingReason,
              e_callingPartySubaddress,
              e_callingInfo,
              e_originalCalledNr,
              e_redirectingInfo,
              e_originalCalledInfo,
              e_extension
            };

            class reroutingReason {
              public:
                typedef DiversionReason value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class reroutingReason
            reroutingReason::const_reference get_reroutingReason () const;
            reroutingReason::reference ref_reroutingReason ();
            reroutingReason::reference set_reroutingReason ();
            reroutingReason::reference set_reroutingReason (reroutingReason::value_type::NamedNumber value);
            class originalReroutingReason {
              public:
                typedef DiversionReason value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class originalReroutingReason
            originalReroutingReason::const_reference get_originalReroutingReason () const;
            originalReroutingReason::reference ref_originalReroutingReason ();
            originalReroutingReason::reference set_originalReroutingReason ();
            originalReroutingReason::reference set_originalReroutingReason (originalReroutingReason::value_type::NamedNumber value);
            void omit_originalReroutingReason ();
            bool originalReroutingReason_isPresent () const;
            class calledAddress {
              public:
                typedef Addressing_Data_Elements::EndpointAddress value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class calledAddress
            calledAddress::const_reference get_calledAddress () const;
            calledAddress::reference ref_calledAddress ();
            calledAddress::reference set_calledAddress ();
            calledAddress::reference set_calledAddress (calledAddress::const_reference value);
            class diversionCounter {
              public:
                typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 15>  value_type;

                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class diversionCounter
            diversionCounter::const_reference get_diversionCounter () const;
            diversionCounter::reference ref_diversionCounter ();
            diversionCounter::reference set_diversionCounter ();
            diversionCounter::reference set_diversionCounter (diversionCounter::value_type::int_type value);
            class h225InfoElement {
              public:
                typedef H225_generic_parameters_definition::H225InformationElement value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class h225InfoElement
            h225InfoElement::const_reference get_h225InfoElement () const;
            h225InfoElement::reference ref_h225InfoElement ();
            h225InfoElement::reference set_h225InfoElement ();
            h225InfoElement::reference set_h225InfoElement (h225InfoElement::const_reference value);
            class lastReroutingNr {
              public:
                typedef Addressing_Data_Elements::EndpointAddress value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class lastReroutingNr
            lastReroutingNr::const_reference get_lastReroutingNr () const;
            lastReroutingNr::reference ref_lastReroutingNr ();
            lastReroutingNr::reference set_lastReroutingNr ();
            lastReroutingNr::reference set_lastReroutingNr (lastReroutingNr::const_reference value);
            class subscriptionOption {
              public:
                typedef SubscriptionOption value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class subscriptionOption
            subscriptionOption::const_reference get_subscriptionOption () const;
            subscriptionOption::reference ref_subscriptionOption ();
            subscriptionOption::reference set_subscriptionOption ();
            subscriptionOption::reference set_subscriptionOption (subscriptionOption::value_type::NamedNumber value);
            class callingPartySubaddress {
              public:
                typedef Addressing_Data_Elements::PartySubaddress value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class callingPartySubaddress
            callingPartySubaddress::const_reference get_callingPartySubaddress () const;
            callingPartySubaddress::reference ref_callingPartySubaddress ();
            callingPartySubaddress::reference set_callingPartySubaddress ();
            callingPartySubaddress::reference set_callingPartySubaddress (callingPartySubaddress::const_reference value);
            void omit_callingPartySubaddress ();
            bool callingPartySubaddress_isPresent () const;
            class callingNumber {
              public:
                typedef Addressing_Data_Elements::EndpointAddress value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class callingNumber
            callingNumber::const_reference get_callingNumber () const;
            callingNumber::reference ref_callingNumber ();
            callingNumber::reference set_callingNumber ();
            callingNumber::reference set_callingNumber (callingNumber::const_reference value);
            class callingInfo {
              public:
                class value_type : public ASN1::BMPString
                {
                    typedef ASN1::BMPString Inherited;
                  protected:
                    value_type(const void* info) : Inherited(info) {}
                  public:
                    value_type() : Inherited(&theInfo) { }
                    value_type(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
                    value_type(const wchar_t* str, const void* info = &theInfo) : Inherited(str, info) { }
                    value_type(const value_type& other) : Inherited(other) {}
                    value_type& operator = (std::wstring& other)
                    { Inherited::operator=(other); return *this;}
                    value_type& operator = (const wchar_t* other)
                    { Inherited::operator=(other); return *this;}
                    value_type * clone() const;
                    static bool equal_type(const ASN1::AbstractData&);
                    static void extract(const ASN1::AbstractData& data);
                    static const InfoType theInfo;
                };

                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class callingInfo
            callingInfo::const_reference get_callingInfo () const;
            callingInfo::reference ref_callingInfo ();
            callingInfo::reference set_callingInfo ();
            callingInfo::reference set_callingInfo (const std::wstring& value);
            void omit_callingInfo ();
            bool callingInfo_isPresent () const;
            class originalCalledNr {
              public:
                typedef Addressing_Data_Elements::EndpointAddress value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class originalCalledNr
            originalCalledNr::const_reference get_originalCalledNr () const;
            originalCalledNr::reference ref_originalCalledNr ();
            originalCalledNr::reference set_originalCalledNr ();
            originalCalledNr::reference set_originalCalledNr (originalCalledNr::const_reference value);
            void omit_originalCalledNr ();
            bool originalCalledNr_isPresent () const;
            class redirectingInfo {
              public:
                class value_type : public ASN1::BMPString
                {
                    typedef ASN1::BMPString Inherited;
                  protected:
                    value_type(const void* info) : Inherited(info) {}
                  public:
                    value_type() : Inherited(&theInfo) { }
                    value_type(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
                    value_type(const wchar_t* str, const void* info = &theInfo) : Inherited(str, info) { }
                    value_type(const value_type& other) : Inherited(other) {}
                    value_type& operator = (std::wstring& other)
                    { Inherited::operator=(other); return *this;}
                    value_type& operator = (const wchar_t* other)
                    { Inherited::operator=(other); return *this;}
                    value_type * clone() const;
                    static bool equal_type(const ASN1::AbstractData&);
                    static void extract(const ASN1::AbstractData& data);
                    static const InfoType theInfo;
                };

                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class redirectingInfo
            redirectingInfo::const_reference get_redirectingInfo () const;
            redirectingInfo::reference ref_redirectingInfo ();
            redirectingInfo::reference set_redirectingInfo ();
            redirectingInfo::reference set_redirectingInfo (const std::wstring& value);
            void omit_redirectingInfo ();
            bool redirectingInfo_isPresent () const;
            class originalCalledInfo {
              public:
                class value_type : public ASN1::BMPString
                {
                    typedef ASN1::BMPString Inherited;
                  protected:
                    value_type(const void* info) : Inherited(info) {}
                  public:
                    value_type() : Inherited(&theInfo) { }
                    value_type(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
                    value_type(const wchar_t* str, const void* info = &theInfo) : Inherited(str, info) { }
                    value_type(const value_type& other) : Inherited(other) {}
                    value_type& operator = (std::wstring& other)
                    { Inherited::operator=(other); return *this;}
                    value_type& operator = (const wchar_t* other)
                    { Inherited::operator=(other); return *this;}
                    value_type * clone() const;
                    static bool equal_type(const ASN1::AbstractData&);
                    static void extract(const ASN1::AbstractData& data);
                    static const InfoType theInfo;
                };

                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class originalCalledInfo
            originalCalledInfo::const_reference get_originalCalledInfo () const;
            originalCalledInfo::reference ref_originalCalledInfo ();
            originalCalledInfo::reference set_originalCalledInfo ();
            originalCalledInfo::reference set_originalCalledInfo (const std::wstring& value);
            void omit_originalCalledInfo ();
            bool originalCalledInfo_isPresent () const;
            class extension {
              public:
                class value_type : public ASN1::CHOICE
                {
                    typedef ASN1::CHOICE Inherited;
                  protected:
                    value_type(const void* info) : Inherited(info) {}
                  public:
                    value_type() : Inherited(&theInfo) {}
                    class extensionSeq {
                      public:
                        enum Id { id_ = 0 };
                        typedef ExtensionSeq value_type;
                        typedef value_type&			reference;
                        typedef const value_type&	const_reference;
                        typedef value_type*			pointer;
                        typedef const value_type*	const_pointer;
                    }; // end class extensionSeq

                    extensionSeq::const_reference get_extensionSeq () const;
                    extensionSeq::reference ref_extensionSeq (); 
                    extensionSeq::reference select_extensionSeq (); 
                    extensionSeq::reference select_extensionSeq (extensionSeq::const_reference value); 
                    bool extensionSeq_isSelected() const;

                    class nonStandardData {
                      public:
                        enum Id { id_ = 1 };
                        typedef H323_MESSAGES::NonStandardParameter value_type;
                        typedef value_type&			reference;
                        typedef const value_type&	const_reference;
                        typedef value_type*			pointer;
                        typedef const value_type*	const_pointer;
                    }; // end class nonStandardData

                    nonStandardData::const_reference get_nonStandardData () const;
                    nonStandardData::reference ref_nonStandardData (); 
                    nonStandardData::reference select_nonStandardData (); 
                    nonStandardData::reference select_nonStandardData (nonStandardData::const_reference value); 
                    bool nonStandardData_isSelected() const;

                    value_type(extensionSeq::Id id, extensionSeq::const_reference value);
                    value_type(nonStandardData::Id id, nonStandardData::const_reference value);
                    void swap(value_type & other);
                    value_type(const value_type & other)
                    : Inherited(other) {} 

                    value_type & operator = (const value_type & other)
                    {
                      Inherited::operator=(other);
                      return *this;
                    }

                    value_type * clone() const;
                    static bool equal_type(const ASN1::AbstractData&);
                    static void extract(const ASN1::AbstractData& data);
                    static const InfoType theInfo;
                  private:
                    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
                    static const char* selectionNames[2];
#endif
                };

                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class extension
            extension::const_reference get_extension () const;
            extension::reference ref_extension ();
            extension::reference set_extension ();
            extension::reference set_extension (extension::const_reference value);
            void omit_extension ();
            bool extension_isPresent () const;
            void swap(ArgumentType& other);
            ArgumentType * clone() const;
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
  private:
            static const void* fieldInfos[14];
            static int fieldIds[14];
#ifdef ASN1_HAS_IOSTREAM
            static const char* fieldNames[14];
#endif
        };

        class ResultType : public ASN1::CHOICE
        {
            typedef ASN1::CHOICE Inherited;
          protected:
            ResultType(const void* info) : Inherited(info) {}
          public:
            ResultType() : Inherited(&theInfo) {}
            class extensionSeq {
              public:
                enum Id { id_ = 0 };
                typedef ExtensionSeq value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class extensionSeq

            extensionSeq::const_reference get_extensionSeq () const;
            extensionSeq::reference ref_extensionSeq (); 
            extensionSeq::reference select_extensionSeq (); 
            extensionSeq::reference select_extensionSeq (extensionSeq::const_reference value); 
            bool extensionSeq_isSelected() const;

            class nonStandardData {
              public:
                enum Id { id_ = 1 };
                typedef H323_MESSAGES::NonStandardParameter value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class nonStandardData

            nonStandardData::const_reference get_nonStandardData () const;
            nonStandardData::reference ref_nonStandardData (); 
            nonStandardData::reference select_nonStandardData (); 
            nonStandardData::reference select_nonStandardData (nonStandardData::const_reference value); 
            bool nonStandardData_isSelected() const;

            ResultType(extensionSeq::Id id, extensionSeq::const_reference value);
            ResultType(nonStandardData::Id id, nonStandardData::const_reference value);
            void swap(ResultType & other);
            ResultType(const ResultType & other)
            : Inherited(other) {} 

            ResultType & operator = (const ResultType & other)
            {
              Inherited::operator=(other);
              return *this;
            }

            ResultType * clone() const;
            static bool equal_type(const ASN1::AbstractData&);
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
          private:
            static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
            static const char* selectionNames[2];
#endif
        };

        ERROR Errors;
        const Remote_Operations_Information_Objects::Code operationCode;
        OPERATION::value_type make() const
        { return OPERATION::value_type(operationCode,&info ); }
      private:
        class Info : public OPERATION::info_type
        {
          public:
            Info(callRerouting* parent)
            {
                m_ArgumentType= &ArgumentType::theInfo;
                m_ResultType= &ResultType::theInfo;
                m_Errors= &(parent-> Errors);
            }
        };
        Info info;
    }; // class callRerouting
    class divertingLegInformation1
    {
      public:
        divertingLegInformation1();
        class ArgumentType : public ASN1::SEQUENCE
        {
            typedef ASN1::SEQUENCE Inherited;
          protected:
            ArgumentType(const void* info) : Inherited(info) {}
          public:
            ArgumentType() : Inherited(&theInfo) {}
            ArgumentType(const ArgumentType & other) : Inherited(other)
            {}
            ArgumentType& operator = (const ArgumentType& other)
            { Inherited::operator = (other); return *this; } 
            enum OptionalFields {
              e_nominatedInfo,
              e_redirectingNr,
              e_redirectingInfo,
              e_extension
            };

            class diversionReason {
              public:
                typedef DiversionReason value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class diversionReason
            diversionReason::const_reference get_diversionReason () const;
            diversionReason::reference ref_diversionReason ();
            diversionReason::reference set_diversionReason ();
            diversionReason::reference set_diversionReason (diversionReason::value_type::NamedNumber value);
            class subscriptionOption {
              public:
                typedef SubscriptionOption value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class subscriptionOption
            subscriptionOption::const_reference get_subscriptionOption () const;
            subscriptionOption::reference ref_subscriptionOption ();
            subscriptionOption::reference set_subscriptionOption ();
            subscriptionOption::reference set_subscriptionOption (subscriptionOption::value_type::NamedNumber value);
            class nominatedNr {
              public:
                typedef Addressing_Data_Elements::EndpointAddress value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class nominatedNr
            nominatedNr::const_reference get_nominatedNr () const;
            nominatedNr::reference ref_nominatedNr ();
            nominatedNr::reference set_nominatedNr ();
            nominatedNr::reference set_nominatedNr (nominatedNr::const_reference value);
            class nominatedInfo {
              public:
                class value_type : public ASN1::BMPString
                {
                    typedef ASN1::BMPString Inherited;
                  protected:
                    value_type(const void* info) : Inherited(info) {}
                  public:
                    value_type() : Inherited(&theInfo) { }
                    value_type(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
                    value_type(const wchar_t* str, const void* info = &theInfo) : Inherited(str, info) { }
                    value_type(const value_type& other) : Inherited(other) {}
                    value_type& operator = (std::wstring& other)
                    { Inherited::operator=(other); return *this;}
                    value_type& operator = (const wchar_t* other)
                    { Inherited::operator=(other); return *this;}
                    value_type * clone() const;
                    static bool equal_type(const ASN1::AbstractData&);
                    static void extract(const ASN1::AbstractData& data);
                    static const InfoType theInfo;
                };

                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class nominatedInfo
            nominatedInfo::const_reference get_nominatedInfo () const;
            nominatedInfo::reference ref_nominatedInfo ();
            nominatedInfo::reference set_nominatedInfo ();
            nominatedInfo::reference set_nominatedInfo (const std::wstring& value);
            void omit_nominatedInfo ();
            bool nominatedInfo_isPresent () const;
            class redirectingNr {
              public:
                typedef Addressing_Data_Elements::EndpointAddress value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class redirectingNr
            redirectingNr::const_reference get_redirectingNr () const;
            redirectingNr::reference ref_redirectingNr ();
            redirectingNr::reference set_redirectingNr ();
            redirectingNr::reference set_redirectingNr (redirectingNr::const_reference value);
            void omit_redirectingNr ();
            bool redirectingNr_isPresent () const;
            class redirectingInfo {
              public:
                class value_type : public ASN1::BMPString
                {
                    typedef ASN1::BMPString Inherited;
                  protected:
                    value_type(const void* info) : Inherited(info) {}
                  public:
                    value_type() : Inherited(&theInfo) { }
                    value_type(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
                    value_type(const wchar_t* str, const void* info = &theInfo) : Inherited(str, info) { }
                    value_type(const value_type& other) : Inherited(other) {}
                    value_type& operator = (std::wstring& other)
                    { Inherited::operator=(other); return *this;}
                    value_type& operator = (const wchar_t* other)
                    { Inherited::operator=(other); return *this;}
                    value_type * clone() const;
                    static bool equal_type(const ASN1::AbstractData&);
                    static void extract(const ASN1::AbstractData& data);
                    static const InfoType theInfo;
                };

                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class redirectingInfo
            redirectingInfo::const_reference get_redirectingInfo () const;
            redirectingInfo::reference ref_redirectingInfo ();
            redirectingInfo::reference set_redirectingInfo ();
            redirectingInfo::reference set_redirectingInfo (const std::wstring& value);
            void omit_redirectingInfo ();
            bool redirectingInfo_isPresent () const;
            class extension {
              public:
                class value_type : public ASN1::CHOICE
                {
                    typedef ASN1::CHOICE Inherited;
                  protected:
                    value_type(const void* info) : Inherited(info) {}
                  public:
                    value_type() : Inherited(&theInfo) {}
                    class extensionSeq {
                      public:
                        enum Id { id_ = 0 };
                        typedef ExtensionSeq value_type;
                        typedef value_type&			reference;
                        typedef const value_type&	const_reference;
                        typedef value_type*			pointer;
                        typedef const value_type*	const_pointer;
                    }; // end class extensionSeq

                    extensionSeq::const_reference get_extensionSeq () const;
                    extensionSeq::reference ref_extensionSeq (); 
                    extensionSeq::reference select_extensionSeq (); 
                    extensionSeq::reference select_extensionSeq (extensionSeq::const_reference value); 
                    bool extensionSeq_isSelected() const;

                    class nonStandardData {
                      public:
                        enum Id { id_ = 1 };
                        typedef H323_MESSAGES::NonStandardParameter value_type;
                        typedef value_type&			reference;
                        typedef const value_type&	const_reference;
                        typedef value_type*			pointer;
                        typedef const value_type*	const_pointer;
                    }; // end class nonStandardData

                    nonStandardData::const_reference get_nonStandardData () const;
                    nonStandardData::reference ref_nonStandardData (); 
                    nonStandardData::reference select_nonStandardData (); 
                    nonStandardData::reference select_nonStandardData (nonStandardData::const_reference value); 
                    bool nonStandardData_isSelected() const;

                    value_type(extensionSeq::Id id, extensionSeq::const_reference value);
                    value_type(nonStandardData::Id id, nonStandardData::const_reference value);
                    void swap(value_type & other);
                    value_type(const value_type & other)
                    : Inherited(other) {} 

                    value_type & operator = (const value_type & other)
                    {
                      Inherited::operator=(other);
                      return *this;
                    }

                    value_type * clone() const;
                    static bool equal_type(const ASN1::AbstractData&);
                    static void extract(const ASN1::AbstractData& data);
                    static const InfoType theInfo;
                  private:
                    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
                    static const char* selectionNames[2];
#endif
                };

                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class extension
            extension::const_reference get_extension () const;
            extension::reference ref_extension ();
            extension::reference set_extension ();
            extension::reference set_extension (extension::const_reference value);
            void omit_extension ();
            bool extension_isPresent () const;
            void swap(ArgumentType& other);
            ArgumentType * clone() const;
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
  private:
            static const void* fieldInfos[7];
            static int fieldIds[7];
#ifdef ASN1_HAS_IOSTREAM
            static const char* fieldNames[7];
#endif
        };

        const Remote_Operations_Information_Objects::Code operationCode;
        OPERATION::value_type make() const
        { return OPERATION::value_type(operationCode,&info ); }
      private:
        class Info : public OPERATION::info_type
        {
          public:
            Info()
            {
                m_ArgumentType= &ArgumentType::theInfo;
            }
        };
        Info info;
    }; // class divertingLegInformation1
    class divertingLegInformation2
    {
      public:
        divertingLegInformation2();
        class ArgumentType : public ASN1::SEQUENCE
        {
            typedef ASN1::SEQUENCE Inherited;
          protected:
            ArgumentType(const void* info) : Inherited(info) {}
          public:
            ArgumentType() : Inherited(&theInfo) {}
            ArgumentType(const ArgumentType & other) : Inherited(other)
            {}
            ArgumentType& operator = (const ArgumentType& other)
            { Inherited::operator = (other); return *this; } 
            enum OptionalFields {
              e_originalDiversionReason,
              e_divertingNr,
              e_originalCalledNr,
              e_redirectingInfo,
              e_originalCalledInfo,
              e_extension
            };

            class diversionCounter {
              public:
                typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 15>  value_type;

                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class diversionCounter
            diversionCounter::const_reference get_diversionCounter () const;
            diversionCounter::reference ref_diversionCounter ();
            diversionCounter::reference set_diversionCounter ();
            diversionCounter::reference set_diversionCounter (diversionCounter::value_type::int_type value);
            class diversionReason {
              public:
                typedef DiversionReason value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class diversionReason
            diversionReason::const_reference get_diversionReason () const;
            diversionReason::reference ref_diversionReason ();
            diversionReason::reference set_diversionReason ();
            diversionReason::reference set_diversionReason (diversionReason::value_type::NamedNumber value);
            class originalDiversionReason {
              public:
                typedef DiversionReason value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class originalDiversionReason
            originalDiversionReason::const_reference get_originalDiversionReason () const;
            originalDiversionReason::reference ref_originalDiversionReason ();
            originalDiversionReason::reference set_originalDiversionReason ();
            originalDiversionReason::reference set_originalDiversionReason (originalDiversionReason::value_type::NamedNumber value);
            void omit_originalDiversionReason ();
            bool originalDiversionReason_isPresent () const;
            class divertingNr {
              public:
                typedef Addressing_Data_Elements::EndpointAddress value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class divertingNr
            divertingNr::const_reference get_divertingNr () const;
            divertingNr::reference ref_divertingNr ();
            divertingNr::reference set_divertingNr ();
            divertingNr::reference set_divertingNr (divertingNr::const_reference value);
            void omit_divertingNr ();
            bool divertingNr_isPresent () const;
            class originalCalledNr {
              public:
                typedef Addressing_Data_Elements::EndpointAddress value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class originalCalledNr
            originalCalledNr::const_reference get_originalCalledNr () const;
            originalCalledNr::reference ref_originalCalledNr ();
            originalCalledNr::reference set_originalCalledNr ();
            originalCalledNr::reference set_originalCalledNr (originalCalledNr::const_reference value);
            void omit_originalCalledNr ();
            bool originalCalledNr_isPresent () const;
            class redirectingInfo {
              public:
                class value_type : public ASN1::BMPString
                {
                    typedef ASN1::BMPString Inherited;
                  protected:
                    value_type(const void* info) : Inherited(info) {}
                  public:
                    value_type() : Inherited(&theInfo) { }
                    value_type(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
                    value_type(const wchar_t* str, const void* info = &theInfo) : Inherited(str, info) { }
                    value_type(const value_type& other) : Inherited(other) {}
                    value_type& operator = (std::wstring& other)
                    { Inherited::operator=(other); return *this;}
                    value_type& operator = (const wchar_t* other)
                    { Inherited::operator=(other); return *this;}
                    value_type * clone() const;
                    static bool equal_type(const ASN1::AbstractData&);
                    static void extract(const ASN1::AbstractData& data);
                    static const InfoType theInfo;
                };

                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class redirectingInfo
            redirectingInfo::const_reference get_redirectingInfo () const;
            redirectingInfo::reference ref_redirectingInfo ();
            redirectingInfo::reference set_redirectingInfo ();
            redirectingInfo::reference set_redirectingInfo (const std::wstring& value);
            void omit_redirectingInfo ();
            bool redirectingInfo_isPresent () const;
            class originalCalledInfo {
              public:
                class value_type : public ASN1::BMPString
                {
                    typedef ASN1::BMPString Inherited;
                  protected:
                    value_type(const void* info) : Inherited(info) {}
                  public:
                    value_type() : Inherited(&theInfo) { }
                    value_type(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
                    value_type(const wchar_t* str, const void* info = &theInfo) : Inherited(str, info) { }
                    value_type(const value_type& other) : Inherited(other) {}
                    value_type& operator = (std::wstring& other)
                    { Inherited::operator=(other); return *this;}
                    value_type& operator = (const wchar_t* other)
                    { Inherited::operator=(other); return *this;}
                    value_type * clone() const;
                    static bool equal_type(const ASN1::AbstractData&);
                    static void extract(const ASN1::AbstractData& data);
                    static const InfoType theInfo;
                };

                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class originalCalledInfo
            originalCalledInfo::const_reference get_originalCalledInfo () const;
            originalCalledInfo::reference ref_originalCalledInfo ();
            originalCalledInfo::reference set_originalCalledInfo ();
            originalCalledInfo::reference set_originalCalledInfo (const std::wstring& value);
            void omit_originalCalledInfo ();
            bool originalCalledInfo_isPresent () const;
            class extension {
              public:
                class value_type : public ASN1::CHOICE
                {
                    typedef ASN1::CHOICE Inherited;
                  protected:
                    value_type(const void* info) : Inherited(info) {}
                  public:
                    value_type() : Inherited(&theInfo) {}
                    class extensionSeq {
                      public:
                        enum Id { id_ = 0 };
                        typedef ExtensionSeq value_type;
                        typedef value_type&			reference;
                        typedef const value_type&	const_reference;
                        typedef value_type*			pointer;
                        typedef const value_type*	const_pointer;
                    }; // end class extensionSeq

                    extensionSeq::const_reference get_extensionSeq () const;
                    extensionSeq::reference ref_extensionSeq (); 
                    extensionSeq::reference select_extensionSeq (); 
                    extensionSeq::reference select_extensionSeq (extensionSeq::const_reference value); 
                    bool extensionSeq_isSelected() const;

                    class nonStandardData {
                      public:
                        enum Id { id_ = 1 };
                        typedef H323_MESSAGES::NonStandardParameter value_type;
                        typedef value_type&			reference;
                        typedef const value_type&	const_reference;
                        typedef value_type*			pointer;
                        typedef const value_type*	const_pointer;
                    }; // end class nonStandardData

                    nonStandardData::const_reference get_nonStandardData () const;
                    nonStandardData::reference ref_nonStandardData (); 
                    nonStandardData::reference select_nonStandardData (); 
                    nonStandardData::reference select_nonStandardData (nonStandardData::const_reference value); 
                    bool nonStandardData_isSelected() const;

                    value_type(extensionSeq::Id id, extensionSeq::const_reference value);
                    value_type(nonStandardData::Id id, nonStandardData::const_reference value);
                    void swap(value_type & other);
                    value_type(const value_type & other)
                    : Inherited(other) {} 

                    value_type & operator = (const value_type & other)
                    {
                      Inherited::operator=(other);
                      return *this;
                    }

                    value_type * clone() const;
                    static bool equal_type(const ASN1::AbstractData&);
                    static void extract(const ASN1::AbstractData& data);
                    static const InfoType theInfo;
                  private:
                    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
                    static const char* selectionNames[2];
#endif
                };

                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class extension
            extension::const_reference get_extension () const;
            extension::reference ref_extension ();
            extension::reference set_extension ();
            extension::reference set_extension (extension::const_reference value);
            void omit_extension ();
            bool extension_isPresent () const;
            void swap(ArgumentType& other);
            ArgumentType * clone() const;
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
  private:
            static const void* fieldInfos[8];
            static int fieldIds[8];
#ifdef ASN1_HAS_IOSTREAM
            static const char* fieldNames[8];
#endif
        };

        const Remote_Operations_Information_Objects::Code operationCode;
        OPERATION::value_type make() const
        { return OPERATION::value_type(operationCode,&info ); }
      private:
        class Info : public OPERATION::info_type
        {
          public:
            Info()
            {
                m_ArgumentType= &ArgumentType::theInfo;
            }
        };
        Info info;
    }; // class divertingLegInformation2
    class divertingLegInformation3
    {
      public:
        divertingLegInformation3();
        class ArgumentType : public ASN1::SEQUENCE
        {
            typedef ASN1::SEQUENCE Inherited;
          protected:
            ArgumentType(const void* info) : Inherited(info) {}
          public:
            ArgumentType() : Inherited(&theInfo) {}
            ArgumentType(const ArgumentType & other) : Inherited(other)
            {}
            ArgumentType& operator = (const ArgumentType& other)
            { Inherited::operator = (other); return *this; } 
            enum OptionalFields {
              e_redirectionNr,
              e_redirectionInfo,
              e_extension
            };

            class presentationAllowedIndicator {
              public:
                typedef Addressing_Data_Elements::PresentationAllowedIndicator value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class presentationAllowedIndicator
            presentationAllowedIndicator::const_reference get_presentationAllowedIndicator () const;
            presentationAllowedIndicator::reference ref_presentationAllowedIndicator ();
            presentationAllowedIndicator::reference set_presentationAllowedIndicator ();
            presentationAllowedIndicator::reference set_presentationAllowedIndicator (presentationAllowedIndicator::const_reference value);
            class redirectionNr {
              public:
                typedef Addressing_Data_Elements::EndpointAddress value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class redirectionNr
            redirectionNr::const_reference get_redirectionNr () const;
            redirectionNr::reference ref_redirectionNr ();
            redirectionNr::reference set_redirectionNr ();
            redirectionNr::reference set_redirectionNr (redirectionNr::const_reference value);
            void omit_redirectionNr ();
            bool redirectionNr_isPresent () const;
            class redirectionInfo {
              public:
                class value_type : public ASN1::BMPString
                {
                    typedef ASN1::BMPString Inherited;
                  protected:
                    value_type(const void* info) : Inherited(info) {}
                  public:
                    value_type() : Inherited(&theInfo) { }
                    value_type(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
                    value_type(const wchar_t* str, const void* info = &theInfo) : Inherited(str, info) { }
                    value_type(const value_type& other) : Inherited(other) {}
                    value_type& operator = (std::wstring& other)
                    { Inherited::operator=(other); return *this;}
                    value_type& operator = (const wchar_t* other)
                    { Inherited::operator=(other); return *this;}
                    value_type * clone() const;
                    static bool equal_type(const ASN1::AbstractData&);
                    static void extract(const ASN1::AbstractData& data);
                    static const InfoType theInfo;
                };

                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class redirectionInfo
            redirectionInfo::const_reference get_redirectionInfo () const;
            redirectionInfo::reference ref_redirectionInfo ();
            redirectionInfo::reference set_redirectionInfo ();
            redirectionInfo::reference set_redirectionInfo (const std::wstring& value);
            void omit_redirectionInfo ();
            bool redirectionInfo_isPresent () const;
            class extension {
              public:
                class value_type : public ASN1::CHOICE
                {
                    typedef ASN1::CHOICE Inherited;
                  protected:
                    value_type(const void* info) : Inherited(info) {}
                  public:
                    value_type() : Inherited(&theInfo) {}
                    class extensionSeq {
                      public:
                        enum Id { id_ = 0 };
                        typedef ExtensionSeq value_type;
                        typedef value_type&			reference;
                        typedef const value_type&	const_reference;
                        typedef value_type*			pointer;
                        typedef const value_type*	const_pointer;
                    }; // end class extensionSeq

                    extensionSeq::const_reference get_extensionSeq () const;
                    extensionSeq::reference ref_extensionSeq (); 
                    extensionSeq::reference select_extensionSeq (); 
                    extensionSeq::reference select_extensionSeq (extensionSeq::const_reference value); 
                    bool extensionSeq_isSelected() const;

                    class nonStandardData {
                      public:
                        enum Id { id_ = 1 };
                        typedef H323_MESSAGES::NonStandardParameter value_type;
                        typedef value_type&			reference;
                        typedef const value_type&	const_reference;
                        typedef value_type*			pointer;
                        typedef const value_type*	const_pointer;
                    }; // end class nonStandardData

                    nonStandardData::const_reference get_nonStandardData () const;
                    nonStandardData::reference ref_nonStandardData (); 
                    nonStandardData::reference select_nonStandardData (); 
                    nonStandardData::reference select_nonStandardData (nonStandardData::const_reference value); 
                    bool nonStandardData_isSelected() const;

                    value_type(extensionSeq::Id id, extensionSeq::const_reference value);
                    value_type(nonStandardData::Id id, nonStandardData::const_reference value);
                    void swap(value_type & other);
                    value_type(const value_type & other)
                    : Inherited(other) {} 

                    value_type & operator = (const value_type & other)
                    {
                      Inherited::operator=(other);
                      return *this;
                    }

                    value_type * clone() const;
                    static bool equal_type(const ASN1::AbstractData&);
                    static void extract(const ASN1::AbstractData& data);
                    static const InfoType theInfo;
                  private:
                    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
                    static const char* selectionNames[2];
#endif
                };

                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class extension
            extension::const_reference get_extension () const;
            extension::reference ref_extension ();
            extension::reference set_extension ();
            extension::reference set_extension (extension::const_reference value);
            void omit_extension ();
            bool extension_isPresent () const;
            void swap(ArgumentType& other);
            ArgumentType * clone() const;
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
  private:
            static const void* fieldInfos[4];
            static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
            static const char* fieldNames[4];
#endif
        };

        const Remote_Operations_Information_Objects::Code operationCode;
        OPERATION::value_type make() const
        { return OPERATION::value_type(operationCode,&info ); }
      private:
        class Info : public OPERATION::info_type
        {
          public:
            Info()
            {
                m_ArgumentType= &ArgumentType::theInfo;
            }
        };
        Info info;
    }; // class divertingLegInformation3
    class divertingLegInformation4
    {
      public:
        divertingLegInformation4();
        class ArgumentType : public ASN1::SEQUENCE
        {
            typedef ASN1::SEQUENCE Inherited;
          protected:
            ArgumentType(const void* info) : Inherited(info) {}
          public:
            ArgumentType() : Inherited(&theInfo) {}
            ArgumentType(const ArgumentType & other) : Inherited(other)
            {}
            ArgumentType& operator = (const ArgumentType& other)
            { Inherited::operator = (other); return *this; } 
            enum OptionalFields {
              e_callingInfo,
              e_nominatedInfo,
              e_extension
            };

            class diversionReason {
              public:
                typedef DiversionReason value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class diversionReason
            diversionReason::const_reference get_diversionReason () const;
            diversionReason::reference ref_diversionReason ();
            diversionReason::reference set_diversionReason ();
            diversionReason::reference set_diversionReason (diversionReason::value_type::NamedNumber value);
            class subscriptionOption {
              public:
                typedef SubscriptionOption value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class subscriptionOption
            subscriptionOption::const_reference get_subscriptionOption () const;
            subscriptionOption::reference ref_subscriptionOption ();
            subscriptionOption::reference set_subscriptionOption ();
            subscriptionOption::reference set_subscriptionOption (subscriptionOption::value_type::NamedNumber value);
            class callingNr {
              public:
                typedef Addressing_Data_Elements::EndpointAddress value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class callingNr
            callingNr::const_reference get_callingNr () const;
            callingNr::reference ref_callingNr ();
            callingNr::reference set_callingNr ();
            callingNr::reference set_callingNr (callingNr::const_reference value);
            class callingInfo {
              public:
                class value_type : public ASN1::BMPString
                {
                    typedef ASN1::BMPString Inherited;
                  protected:
                    value_type(const void* info) : Inherited(info) {}
                  public:
                    value_type() : Inherited(&theInfo) { }
                    value_type(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
                    value_type(const wchar_t* str, const void* info = &theInfo) : Inherited(str, info) { }
                    value_type(const value_type& other) : Inherited(other) {}
                    value_type& operator = (std::wstring& other)
                    { Inherited::operator=(other); return *this;}
                    value_type& operator = (const wchar_t* other)
                    { Inherited::operator=(other); return *this;}
                    value_type * clone() const;
                    static bool equal_type(const ASN1::AbstractData&);
                    static void extract(const ASN1::AbstractData& data);
                    static const InfoType theInfo;
                };

                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class callingInfo
            callingInfo::const_reference get_callingInfo () const;
            callingInfo::reference ref_callingInfo ();
            callingInfo::reference set_callingInfo ();
            callingInfo::reference set_callingInfo (const std::wstring& value);
            void omit_callingInfo ();
            bool callingInfo_isPresent () const;
            class nominatedNr {
              public:
                typedef Addressing_Data_Elements::EndpointAddress value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class nominatedNr
            nominatedNr::const_reference get_nominatedNr () const;
            nominatedNr::reference ref_nominatedNr ();
            nominatedNr::reference set_nominatedNr ();
            nominatedNr::reference set_nominatedNr (nominatedNr::const_reference value);
            class nominatedInfo {
              public:
                class value_type : public ASN1::BMPString
                {
                    typedef ASN1::BMPString Inherited;
                  protected:
                    value_type(const void* info) : Inherited(info) {}
                  public:
                    value_type() : Inherited(&theInfo) { }
                    value_type(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
                    value_type(const wchar_t* str, const void* info = &theInfo) : Inherited(str, info) { }
                    value_type(const value_type& other) : Inherited(other) {}
                    value_type& operator = (std::wstring& other)
                    { Inherited::operator=(other); return *this;}
                    value_type& operator = (const wchar_t* other)
                    { Inherited::operator=(other); return *this;}
                    value_type * clone() const;
                    static bool equal_type(const ASN1::AbstractData&);
                    static void extract(const ASN1::AbstractData& data);
                    static const InfoType theInfo;
                };

                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class nominatedInfo
            nominatedInfo::const_reference get_nominatedInfo () const;
            nominatedInfo::reference ref_nominatedInfo ();
            nominatedInfo::reference set_nominatedInfo ();
            nominatedInfo::reference set_nominatedInfo (const std::wstring& value);
            void omit_nominatedInfo ();
            bool nominatedInfo_isPresent () const;
            class extension {
              public:
                class value_type : public ASN1::CHOICE
                {
                    typedef ASN1::CHOICE Inherited;
                  protected:
                    value_type(const void* info) : Inherited(info) {}
                  public:
                    value_type() : Inherited(&theInfo) {}
                    class extensionSeq {
                      public:
                        enum Id { id_ = 0 };
                        typedef ExtensionSeq value_type;
                        typedef value_type&			reference;
                        typedef const value_type&	const_reference;
                        typedef value_type*			pointer;
                        typedef const value_type*	const_pointer;
                    }; // end class extensionSeq

                    extensionSeq::const_reference get_extensionSeq () const;
                    extensionSeq::reference ref_extensionSeq (); 
                    extensionSeq::reference select_extensionSeq (); 
                    extensionSeq::reference select_extensionSeq (extensionSeq::const_reference value); 
                    bool extensionSeq_isSelected() const;

                    class nonStandardData {
                      public:
                        enum Id { id_ = 1 };
                        typedef H323_MESSAGES::NonStandardParameter value_type;
                        typedef value_type&			reference;
                        typedef const value_type&	const_reference;
                        typedef value_type*			pointer;
                        typedef const value_type*	const_pointer;
                    }; // end class nonStandardData

                    nonStandardData::const_reference get_nonStandardData () const;
                    nonStandardData::reference ref_nonStandardData (); 
                    nonStandardData::reference select_nonStandardData (); 
                    nonStandardData::reference select_nonStandardData (nonStandardData::const_reference value); 
                    bool nonStandardData_isSelected() const;

                    value_type(extensionSeq::Id id, extensionSeq::const_reference value);
                    value_type(nonStandardData::Id id, nonStandardData::const_reference value);
                    void swap(value_type & other);
                    value_type(const value_type & other)
                    : Inherited(other) {} 

                    value_type & operator = (const value_type & other)
                    {
                      Inherited::operator=(other);
                      return *this;
                    }

                    value_type * clone() const;
                    static bool equal_type(const ASN1::AbstractData&);
                    static void extract(const ASN1::AbstractData& data);
                    static const InfoType theInfo;
                  private:
                    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
                    static const char* selectionNames[2];
#endif
                };

                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class extension
            extension::const_reference get_extension () const;
            extension::reference ref_extension ();
            extension::reference set_extension ();
            extension::reference set_extension (extension::const_reference value);
            void omit_extension ();
            bool extension_isPresent () const;
            void swap(ArgumentType& other);
            ArgumentType * clone() const;
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
  private:
            static const void* fieldInfos[7];
            static int fieldIds[7];
#ifdef ASN1_HAS_IOSTREAM
            static const char* fieldNames[7];
#endif
        };

        const Remote_Operations_Information_Objects::Code operationCode;
        OPERATION::value_type make() const
        { return OPERATION::value_type(operationCode,&info ); }
      private:
        class Info : public OPERATION::info_type
        {
          public:
            Info()
            {
                m_ArgumentType= &ArgumentType::theInfo;
            }
        };
        Info info;
    }; // class divertingLegInformation4
    class cfnrDivertedLegFailed
    {
      public:
        cfnrDivertedLegFailed();
        class ArgumentType : public ASN1::CHOICE
        {
            typedef ASN1::CHOICE Inherited;
          protected:
            ArgumentType(const void* info) : Inherited(info) {}
          public:
            ArgumentType() : Inherited(&theInfo) {}
            class extensionSeq {
              public:
                enum Id { id_ = 0 };
                typedef ExtensionSeq value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class extensionSeq

            extensionSeq::const_reference get_extensionSeq () const;
            extensionSeq::reference ref_extensionSeq (); 
            extensionSeq::reference select_extensionSeq (); 
            extensionSeq::reference select_extensionSeq (extensionSeq::const_reference value); 
            bool extensionSeq_isSelected() const;

            class nonStandardData {
              public:
                enum Id { id_ = 1 };
                typedef H323_MESSAGES::NonStandardParameter value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class nonStandardData

            nonStandardData::const_reference get_nonStandardData () const;
            nonStandardData::reference ref_nonStandardData (); 
            nonStandardData::reference select_nonStandardData (); 
            nonStandardData::reference select_nonStandardData (nonStandardData::const_reference value); 
            bool nonStandardData_isSelected() const;

            ArgumentType(extensionSeq::Id id, extensionSeq::const_reference value);
            ArgumentType(nonStandardData::Id id, nonStandardData::const_reference value);
            void swap(ArgumentType & other);
            ArgumentType(const ArgumentType & other)
            : Inherited(other) {} 

            ArgumentType & operator = (const ArgumentType & other)
            {
              Inherited::operator=(other);
              return *this;
            }

            ArgumentType * clone() const;
            static bool equal_type(const ASN1::AbstractData&);
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
          private:
            static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
            static const char* selectionNames[2];
#endif
        };

        const Remote_Operations_Information_Objects::Code operationCode;
        OPERATION::value_type make() const
        { return OPERATION::value_type(operationCode,&info ); }
      private:
        class Info : public OPERATION::info_type
        {
          public:
            Info()
            {
                m_ArgumentType= &ArgumentType::theInfo;
            }
        };
        Info info;
    }; // class cfnrDivertedLegFailed
    class invalidDivertedNumber
    {
      public:
        invalidDivertedNumber();
        const Remote_Operations_Information_Objects::Code errorCode;
        ERROR::value_type make() const
        { return ERROR::value_type(errorCode,&info ); }
      private:
        typedef ERROR::info_type Info;
        Info info;
    }; // class invalidDivertedNumber
    class specialServiceNumber
    {
      public:
        specialServiceNumber();
        const Remote_Operations_Information_Objects::Code errorCode;
        ERROR::value_type make() const
        { return ERROR::value_type(errorCode,&info ); }
      private:
        typedef ERROR::info_type Info;
        Info info;
    }; // class specialServiceNumber
    class diversionToServedUserNumber
    {
      public:
        diversionToServedUserNumber();
        const Remote_Operations_Information_Objects::Code errorCode;
        ERROR::value_type make() const
        { return ERROR::value_type(errorCode,&info ); }
      private:
        typedef ERROR::info_type Info;
        Info info;
    }; // class diversionToServedUserNumber
    class numberOfDiversionsExceeded
    {
      public:
        numberOfDiversionsExceeded();
        const Remote_Operations_Information_Objects::Code errorCode;
        ERROR::value_type make() const
        { return ERROR::value_type(errorCode,&info ); }
      private:
        typedef ERROR::info_type Info;
        Info info;
    }; // class numberOfDiversionsExceeded
    class temporarilyUnavailable
    {
      public:
        temporarilyUnavailable();
        const Remote_Operations_Information_Objects::Code errorCode;
        ERROR::value_type make() const
        { return ERROR::value_type(errorCode,&info ); }
      private:
        typedef ERROR::info_type Info;
        Info info;
    }; // class temporarilyUnavailable
    class notAuthorized
    {
      public:
        notAuthorized();
        const Remote_Operations_Information_Objects::Code errorCode;
        ERROR::value_type make() const
        { return ERROR::value_type(errorCode,&info ); }
      private:
        typedef ERROR::info_type Info;
        Info info;
    }; // class notAuthorized
    class unspecified
    {
      public:
        unspecified();
        class ParameterType : public ASN1::CHOICE
        {
            typedef ASN1::CHOICE Inherited;
          protected:
            ParameterType(const void* info) : Inherited(info) {}
          public:
            ParameterType() : Inherited(&theInfo) {}
            class extension {
              public:
                enum Id { id_ = 0 };
                typedef Manufacturer_specific_service_extension_definition::Extension<ExtensionSet>  value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class extension

            extension::const_reference get_extension () const;
            extension::reference ref_extension (); 
            extension::reference select_extension (); 
            extension::reference select_extension (extension::const_reference value); 
            bool extension_isSelected() const;

            class nonStandard {
              public:
                enum Id { id_ = 1 };
                typedef H323_MESSAGES::NonStandardParameter value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class nonStandard

            nonStandard::const_reference get_nonStandard () const;
            nonStandard::reference ref_nonStandard (); 
            nonStandard::reference select_nonStandard (); 
            nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
            bool nonStandard_isSelected() const;

            ParameterType(extension::Id id, extension::const_reference value);
            ParameterType(nonStandard::Id id, nonStandard::const_reference value);
            void swap(ParameterType & other);
            ParameterType(const ParameterType & other)
            : Inherited(other) {} 

            ParameterType & operator = (const ParameterType & other)
            {
              Inherited::operator=(other);
              return *this;
            }

            ParameterType * clone() const;
            static bool equal_type(const ASN1::AbstractData&);
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
          private:
            static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
            static const char* selectionNames[2];
#endif
        };

        const Remote_Operations_Information_Objects::Code errorCode;
        ERROR::value_type make() const
        { return ERROR::value_type(errorCode,&info ); }
      private:
        class Info : public ERROR::info_type
        {
          public:
            Info()
            {
                m_ParameterType= &ParameterType::theInfo;
            }
        };
        Info info;
    }; // class unspecified
    const activateDiversionQ& get_activateDiversionQ() const
    {  return m_activateDiversionQ; }
    const deactivateDiversionQ& get_deactivateDiversionQ() const
    {  return m_deactivateDiversionQ; }
    const interrogateDiversionQ& get_interrogateDiversionQ() const
    {  return m_interrogateDiversionQ; }
    const checkRestriction& get_checkRestriction() const
    {  return m_checkRestriction; }
    const callRerouting& get_callRerouting() const
    {  return m_callRerouting; }
    const divertingLegInformation1& get_divertingLegInformation1() const
    {  return m_divertingLegInformation1; }
    const divertingLegInformation2& get_divertingLegInformation2() const
    {  return m_divertingLegInformation2; }
    const divertingLegInformation3& get_divertingLegInformation3() const
    {  return m_divertingLegInformation3; }
    const divertingLegInformation4& get_divertingLegInformation4() const
    {  return m_divertingLegInformation4; }
    const cfnrDivertedLegFailed& get_cfnrDivertedLegFailed() const
    {  return m_cfnrDivertedLegFailed; }
    const invalidDivertedNumber& get_invalidDivertedNumber() const
    {  return m_invalidDivertedNumber; }
    const specialServiceNumber& get_specialServiceNumber() const
    {  return m_specialServiceNumber; }
    const diversionToServedUserNumber& get_diversionToServedUserNumber() const
    {  return m_diversionToServedUserNumber; }
    const numberOfDiversionsExceeded& get_numberOfDiversionsExceeded() const
    {  return m_numberOfDiversionsExceeded; }
    const temporarilyUnavailable& get_temporarilyUnavailable() const
    {  return m_temporarilyUnavailable; }
    const notAuthorized& get_notAuthorized() const
    {  return m_notAuthorized; }
    const unspecified& get_unspecified() const
    {  return m_unspecified; }
    const OPERATION& get_H323CallDiversionOperations() const
    {  return m_H323CallDiversionOperations; }
    EXTENSION& get_ExtensionSet()
    {  return m_ExtensionSet; }
    const EXTENSION& get_ExtensionSet() const
    {  return m_ExtensionSet; }
  private:
    activateDiversionQ m_activateDiversionQ;
    deactivateDiversionQ m_deactivateDiversionQ;
    interrogateDiversionQ m_interrogateDiversionQ;
    checkRestriction m_checkRestriction;
    callRerouting m_callRerouting;
    divertingLegInformation1 m_divertingLegInformation1;
    divertingLegInformation2 m_divertingLegInformation2;
    divertingLegInformation3 m_divertingLegInformation3;
    divertingLegInformation4 m_divertingLegInformation4;
    cfnrDivertedLegFailed m_cfnrDivertedLegFailed;
    invalidDivertedNumber m_invalidDivertedNumber;
    specialServiceNumber m_specialServiceNumber;
    diversionToServedUserNumber m_diversionToServedUserNumber;
    numberOfDiversionsExceeded m_numberOfDiversionsExceeded;
    temporarilyUnavailable m_temporarilyUnavailable;
    notAuthorized m_notAuthorized;
    unspecified m_unspecified;
    OPERATION m_H323CallDiversionOperations;
    EXTENSION m_ExtensionSet;
}; // class Module 
#include "call_diversion_operations.inl"
} // namespace Call_Diversion_Operations

#endif // __CALL_DIVERSION_OPERATIONS_H


// End of call_diversion_operations.h
