//
// call_transfer_operations.h
//
// Code automatically generated by asnparser.
//

#ifndef __CALL_TRANSFER_OPERATIONS_H
#define __CALL_TRANSFER_OPERATIONS_H

#include <asn1.h>

#include "remote_operations_information_objects.h"
#include "manufacturer_specific_service_extension_definition.h"
#include "h4501_general_error_list.h"
#include "addressing_data_elements.h"
#include "hm_callidentifier.h"
#include "h225_generic_parameters_definition.h"


namespace Call_Transfer_Operations {

using Remote_Operations_Information_Objects::ERROR;
using Remote_Operations_Information_Objects::OPERATION;
using Manufacturer_specific_service_extension_definition::EXTENSION;
//
// EndDesignation
//

class EndDesignation : public ASN1::ENUMERATED
{
    typedef ASN1::ENUMERATED Inherited;
  protected:
    EndDesignation(const void* info) : Inherited(info) {}
  public:
    EndDesignation() : Inherited(&theInfo) { }
    enum NamedNumber {
      unknownEnumeration_ = -1,
      primaryEnd,
      secondaryEnd
    };

    bool is_primaryEnd() const { return value == primaryEnd; }
    void set_primaryEnd() { value = primaryEnd; }

    bool is_secondaryEnd() const { return value == secondaryEnd; }
    void set_secondaryEnd() { value = secondaryEnd; }

    EndDesignation(const NamedNumber value) : Inherited(&theInfo){ setFromInt(value); }
    EndDesignation & operator=(const NamedNumber v) { setFromInt(v);  return *this; }
    operator NamedNumber() const
    { return NamedNumber(asInt()); }

    void swap (EndDesignation & other)
    { ENUMERATED::swap(other); }
    EndDesignation * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
};

//
// CallStatus
//

class CallStatus : public ASN1::ENUMERATED
{
    typedef ASN1::ENUMERATED Inherited;
  protected:
    CallStatus(const void* info) : Inherited(info) {}
  public:
    CallStatus() : Inherited(&theInfo) { }
    enum NamedNumber {
      unknownEnumeration_ = -1,
      answered,
      alerting
    };

    bool is_answered() const { return value == answered; }
    void set_answered() { value = answered; }

    bool is_alerting() const { return value == alerting; }
    void set_alerting() { value = alerting; }

    CallStatus(const NamedNumber value) : Inherited(&theInfo){ setFromInt(value); }
    CallStatus & operator=(const NamedNumber v) { setFromInt(v);  return *this; }
    operator NamedNumber() const
    { return NamedNumber(asInt()); }

    void swap (CallStatus & other)
    { ENUMERATED::swap(other); }
    CallStatus * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
};

//
// CallIdentity
//

class CallIdentity : public ASN1::NumericString
{
    typedef ASN1::NumericString Inherited;
  protected:
    CallIdentity(const void* info) : Inherited(info) {}
  public:
    CallIdentity() : Inherited(&theInfo) { }
    CallIdentity(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
    CallIdentity(const char* str, const void* info = &theInfo) : Inherited(str, info) { }
    CallIdentity(const CallIdentity& other) : Inherited(other) {}
    CallIdentity& operator = (const std::string& other)
    { Inherited::operator=(other); return *this;}
    CallIdentity& operator = (const char* other)
    { Inherited::operator=(other); return *this;}
    CallIdentity * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
};


//
// ExtensionSet
//

class ExtensionSet
{
  public:
    typedef EXTENSION element_type;
    ExtensionSet(ASN1::CoderEnv& env);
    EXTENSION* get() const { return objSet; }
    EXTENSION* operator->() const { return objSet; }
    bool extensible() const { return true; }
  private:
    EXTENSION* objSet;
};

typedef ASN1::SEQUENCE_OF<Manufacturer_specific_service_extension_definition::Extension<ExtensionSet> >  ExtensionSeq;

//
// CTInitiateArg_argumentExtension
//

class CTInitiateArg_argumentExtension : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    CTInitiateArg_argumentExtension(const void* info) : Inherited(info) {}
  public:
    CTInitiateArg_argumentExtension() : Inherited(&theInfo) {}
    class extensionSeq {
      public:
        enum Id { id_ = 0 };
        typedef ExtensionSeq value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class extensionSeq

    extensionSeq::const_reference get_extensionSeq () const;
    extensionSeq::reference ref_extensionSeq (); 
    extensionSeq::reference select_extensionSeq (); 
    extensionSeq::reference select_extensionSeq (extensionSeq::const_reference value); 
    bool extensionSeq_isSelected() const;

    class nonStandardData {
      public:
        enum Id { id_ = 1 };
        typedef H323_MESSAGES::NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData

    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData (); 
    nonStandardData::reference select_nonStandardData (); 
    nonStandardData::reference select_nonStandardData (nonStandardData::const_reference value); 
    bool nonStandardData_isSelected() const;

    CTInitiateArg_argumentExtension(extensionSeq::Id id, extensionSeq::const_reference value);
    CTInitiateArg_argumentExtension(nonStandardData::Id id, nonStandardData::const_reference value);
    void swap(CTInitiateArg_argumentExtension & other);
    CTInitiateArg_argumentExtension(const CTInitiateArg_argumentExtension & other)
    : Inherited(other) {} 

    CTInitiateArg_argumentExtension & operator = (const CTInitiateArg_argumentExtension & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    CTInitiateArg_argumentExtension * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// CTSetupArg_argumentExtension
//

class CTSetupArg_argumentExtension : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    CTSetupArg_argumentExtension(const void* info) : Inherited(info) {}
  public:
    CTSetupArg_argumentExtension() : Inherited(&theInfo) {}
    class extensionSeq {
      public:
        enum Id { id_ = 0 };
        typedef ExtensionSeq value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class extensionSeq

    extensionSeq::const_reference get_extensionSeq () const;
    extensionSeq::reference ref_extensionSeq (); 
    extensionSeq::reference select_extensionSeq (); 
    extensionSeq::reference select_extensionSeq (extensionSeq::const_reference value); 
    bool extensionSeq_isSelected() const;

    class nonStandardData {
      public:
        enum Id { id_ = 1 };
        typedef H323_MESSAGES::NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData

    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData (); 
    nonStandardData::reference select_nonStandardData (); 
    nonStandardData::reference select_nonStandardData (nonStandardData::const_reference value); 
    bool nonStandardData_isSelected() const;

    CTSetupArg_argumentExtension(extensionSeq::Id id, extensionSeq::const_reference value);
    CTSetupArg_argumentExtension(nonStandardData::Id id, nonStandardData::const_reference value);
    void swap(CTSetupArg_argumentExtension & other);
    CTSetupArg_argumentExtension(const CTSetupArg_argumentExtension & other)
    : Inherited(other) {} 

    CTSetupArg_argumentExtension & operator = (const CTSetupArg_argumentExtension & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    CTSetupArg_argumentExtension * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// CTIdentifyRes_resultExtension
//

class CTIdentifyRes_resultExtension : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    CTIdentifyRes_resultExtension(const void* info) : Inherited(info) {}
  public:
    CTIdentifyRes_resultExtension() : Inherited(&theInfo) {}
    class extensionSeq {
      public:
        enum Id { id_ = 0 };
        typedef ExtensionSeq value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class extensionSeq

    extensionSeq::const_reference get_extensionSeq () const;
    extensionSeq::reference ref_extensionSeq (); 
    extensionSeq::reference select_extensionSeq (); 
    extensionSeq::reference select_extensionSeq (extensionSeq::const_reference value); 
    bool extensionSeq_isSelected() const;

    class nonStandardData {
      public:
        enum Id { id_ = 1 };
        typedef H323_MESSAGES::NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData

    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData (); 
    nonStandardData::reference select_nonStandardData (); 
    nonStandardData::reference select_nonStandardData (nonStandardData::const_reference value); 
    bool nonStandardData_isSelected() const;

    CTIdentifyRes_resultExtension(extensionSeq::Id id, extensionSeq::const_reference value);
    CTIdentifyRes_resultExtension(nonStandardData::Id id, nonStandardData::const_reference value);
    void swap(CTIdentifyRes_resultExtension & other);
    CTIdentifyRes_resultExtension(const CTIdentifyRes_resultExtension & other)
    : Inherited(other) {} 

    CTIdentifyRes_resultExtension & operator = (const CTIdentifyRes_resultExtension & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    CTIdentifyRes_resultExtension * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// CTUpdateArg_argumentExtension
//

class CTUpdateArg_argumentExtension : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    CTUpdateArg_argumentExtension(const void* info) : Inherited(info) {}
  public:
    CTUpdateArg_argumentExtension() : Inherited(&theInfo) {}
    class extensionSeq {
      public:
        enum Id { id_ = 0 };
        typedef ExtensionSeq value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class extensionSeq

    extensionSeq::const_reference get_extensionSeq () const;
    extensionSeq::reference ref_extensionSeq (); 
    extensionSeq::reference select_extensionSeq (); 
    extensionSeq::reference select_extensionSeq (extensionSeq::const_reference value); 
    bool extensionSeq_isSelected() const;

    class nonStandardData {
      public:
        enum Id { id_ = 1 };
        typedef H323_MESSAGES::NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData

    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData (); 
    nonStandardData::reference select_nonStandardData (); 
    nonStandardData::reference select_nonStandardData (nonStandardData::const_reference value); 
    bool nonStandardData_isSelected() const;

    CTUpdateArg_argumentExtension(extensionSeq::Id id, extensionSeq::const_reference value);
    CTUpdateArg_argumentExtension(nonStandardData::Id id, nonStandardData::const_reference value);
    void swap(CTUpdateArg_argumentExtension & other);
    CTUpdateArg_argumentExtension(const CTUpdateArg_argumentExtension & other)
    : Inherited(other) {} 

    CTUpdateArg_argumentExtension & operator = (const CTUpdateArg_argumentExtension & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    CTUpdateArg_argumentExtension * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// SubaddressTransferArg_argumentExtension
//

class SubaddressTransferArg_argumentExtension : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    SubaddressTransferArg_argumentExtension(const void* info) : Inherited(info) {}
  public:
    SubaddressTransferArg_argumentExtension() : Inherited(&theInfo) {}
    class extensionSeq {
      public:
        enum Id { id_ = 0 };
        typedef ExtensionSeq value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class extensionSeq

    extensionSeq::const_reference get_extensionSeq () const;
    extensionSeq::reference ref_extensionSeq (); 
    extensionSeq::reference select_extensionSeq (); 
    extensionSeq::reference select_extensionSeq (extensionSeq::const_reference value); 
    bool extensionSeq_isSelected() const;

    class nonStandardData {
      public:
        enum Id { id_ = 1 };
        typedef H323_MESSAGES::NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData

    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData (); 
    nonStandardData::reference select_nonStandardData (); 
    nonStandardData::reference select_nonStandardData (nonStandardData::const_reference value); 
    bool nonStandardData_isSelected() const;

    SubaddressTransferArg_argumentExtension(extensionSeq::Id id, extensionSeq::const_reference value);
    SubaddressTransferArg_argumentExtension(nonStandardData::Id id, nonStandardData::const_reference value);
    void swap(SubaddressTransferArg_argumentExtension & other);
    SubaddressTransferArg_argumentExtension(const SubaddressTransferArg_argumentExtension & other)
    : Inherited(other) {} 

    SubaddressTransferArg_argumentExtension & operator = (const SubaddressTransferArg_argumentExtension & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    SubaddressTransferArg_argumentExtension * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// CTCompleteArg_argumentExtension
//

class CTCompleteArg_argumentExtension : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    CTCompleteArg_argumentExtension(const void* info) : Inherited(info) {}
  public:
    CTCompleteArg_argumentExtension() : Inherited(&theInfo) {}
    class extensionSeq {
      public:
        enum Id { id_ = 0 };
        typedef ExtensionSeq value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class extensionSeq

    extensionSeq::const_reference get_extensionSeq () const;
    extensionSeq::reference ref_extensionSeq (); 
    extensionSeq::reference select_extensionSeq (); 
    extensionSeq::reference select_extensionSeq (extensionSeq::const_reference value); 
    bool extensionSeq_isSelected() const;

    class nonStandardData {
      public:
        enum Id { id_ = 1 };
        typedef H323_MESSAGES::NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData

    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData (); 
    nonStandardData::reference select_nonStandardData (); 
    nonStandardData::reference select_nonStandardData (nonStandardData::const_reference value); 
    bool nonStandardData_isSelected() const;

    CTCompleteArg_argumentExtension(extensionSeq::Id id, extensionSeq::const_reference value);
    CTCompleteArg_argumentExtension(nonStandardData::Id id, nonStandardData::const_reference value);
    void swap(CTCompleteArg_argumentExtension & other);
    CTCompleteArg_argumentExtension(const CTCompleteArg_argumentExtension & other)
    : Inherited(other) {} 

    CTCompleteArg_argumentExtension & operator = (const CTCompleteArg_argumentExtension & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    CTCompleteArg_argumentExtension * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// CTActiveArg_argumentExtension
//

class CTActiveArg_argumentExtension : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    CTActiveArg_argumentExtension(const void* info) : Inherited(info) {}
  public:
    CTActiveArg_argumentExtension() : Inherited(&theInfo) {}
    class extensionSeq {
      public:
        enum Id { id_ = 0 };
        typedef ExtensionSeq value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class extensionSeq

    extensionSeq::const_reference get_extensionSeq () const;
    extensionSeq::reference ref_extensionSeq (); 
    extensionSeq::reference select_extensionSeq (); 
    extensionSeq::reference select_extensionSeq (extensionSeq::const_reference value); 
    bool extensionSeq_isSelected() const;

    class nonStandardData {
      public:
        enum Id { id_ = 1 };
        typedef H323_MESSAGES::NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData

    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData (); 
    nonStandardData::reference select_nonStandardData (); 
    nonStandardData::reference select_nonStandardData (nonStandardData::const_reference value); 
    bool nonStandardData_isSelected() const;

    CTActiveArg_argumentExtension(extensionSeq::Id id, extensionSeq::const_reference value);
    CTActiveArg_argumentExtension(nonStandardData::Id id, nonStandardData::const_reference value);
    void swap(CTActiveArg_argumentExtension & other);
    CTActiveArg_argumentExtension(const CTActiveArg_argumentExtension & other)
    : Inherited(other) {} 

    CTActiveArg_argumentExtension & operator = (const CTActiveArg_argumentExtension & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    CTActiveArg_argumentExtension * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// DummyArg
//

class DummyArg : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    DummyArg(const void* info) : Inherited(info) {}
  public:
    DummyArg() : Inherited(&theInfo) {}
    class extensionSeq {
      public:
        enum Id { id_ = 0 };
        typedef ExtensionSeq value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class extensionSeq

    extensionSeq::const_reference get_extensionSeq () const;
    extensionSeq::reference ref_extensionSeq (); 
    extensionSeq::reference select_extensionSeq (); 
    extensionSeq::reference select_extensionSeq (extensionSeq::const_reference value); 
    bool extensionSeq_isSelected() const;

    class nonStandardData {
      public:
        enum Id { id_ = 1 };
        typedef H323_MESSAGES::NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData

    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData (); 
    nonStandardData::reference select_nonStandardData (); 
    nonStandardData::reference select_nonStandardData (nonStandardData::const_reference value); 
    bool nonStandardData_isSelected() const;

    DummyArg(extensionSeq::Id id, extensionSeq::const_reference value);
    DummyArg(nonStandardData::Id id, nonStandardData::const_reference value);
    void swap(DummyArg & other);
    DummyArg(const DummyArg & other)
    : Inherited(other) {} 

    DummyArg & operator = (const DummyArg & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    DummyArg * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// DummyRes
//

class DummyRes : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    DummyRes(const void* info) : Inherited(info) {}
  public:
    DummyRes() : Inherited(&theInfo) {}
    class extensionSeq {
      public:
        enum Id { id_ = 0 };
        typedef ExtensionSeq value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class extensionSeq

    extensionSeq::const_reference get_extensionSeq () const;
    extensionSeq::reference ref_extensionSeq (); 
    extensionSeq::reference select_extensionSeq (); 
    extensionSeq::reference select_extensionSeq (extensionSeq::const_reference value); 
    bool extensionSeq_isSelected() const;

    class nonStandardData {
      public:
        enum Id { id_ = 1 };
        typedef H323_MESSAGES::NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData

    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData (); 
    nonStandardData::reference select_nonStandardData (); 
    nonStandardData::reference select_nonStandardData (nonStandardData::const_reference value); 
    bool nonStandardData_isSelected() const;

    DummyRes(extensionSeq::Id id, extensionSeq::const_reference value);
    DummyRes(nonStandardData::Id id, nonStandardData::const_reference value);
    void swap(DummyRes & other);
    DummyRes(const DummyRes & other)
    : Inherited(other) {} 

    DummyRes & operator = (const DummyRes & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    DummyRes * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// CTInitiateArg
//

class CTInitiateArg : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CTInitiateArg(const void* info) : Inherited(info) {}
  public:
    CTInitiateArg() : Inherited(&theInfo) {}
    CTInitiateArg(const CTInitiateArg & other) : Inherited(other)
    {}
    CTInitiateArg& operator = (const CTInitiateArg& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_argumentExtension
    };

    class callIdentity {
      public:
        typedef CallIdentity value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callIdentity
    callIdentity::const_reference get_callIdentity () const;
    callIdentity::reference ref_callIdentity ();
    callIdentity::reference set_callIdentity ();
    callIdentity::reference set_callIdentity (const std::string& value);
    class reroutingNumber {
      public:
        typedef Addressing_Data_Elements::EndpointAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class reroutingNumber
    reroutingNumber::const_reference get_reroutingNumber () const;
    reroutingNumber::reference ref_reroutingNumber ();
    reroutingNumber::reference set_reroutingNumber ();
    reroutingNumber::reference set_reroutingNumber (reroutingNumber::const_reference value);
    class argumentExtension {
      public:
        typedef CTInitiateArg_argumentExtension value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class argumentExtension
    argumentExtension::const_reference get_argumentExtension () const;
    argumentExtension::reference ref_argumentExtension ();
    argumentExtension::reference set_argumentExtension ();
    argumentExtension::reference set_argumentExtension (argumentExtension::const_reference value);
    void omit_argumentExtension ();
    bool argumentExtension_isPresent () const;
    void swap(CTInitiateArg& other);
    CTInitiateArg * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// CTSetupArg
//

class CTSetupArg : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CTSetupArg(const void* info) : Inherited(info) {}
  public:
    CTSetupArg() : Inherited(&theInfo) {}
    CTSetupArg(const CTSetupArg & other) : Inherited(other)
    {}
    CTSetupArg& operator = (const CTSetupArg& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_transferringNumber,
      e_argumentExtension
    };

    class callIdentity {
      public:
        typedef CallIdentity value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callIdentity
    callIdentity::const_reference get_callIdentity () const;
    callIdentity::reference ref_callIdentity ();
    callIdentity::reference set_callIdentity ();
    callIdentity::reference set_callIdentity (const std::string& value);
    class transferringNumber {
      public:
        typedef Addressing_Data_Elements::EndpointAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class transferringNumber
    transferringNumber::const_reference get_transferringNumber () const;
    transferringNumber::reference ref_transferringNumber ();
    transferringNumber::reference set_transferringNumber ();
    transferringNumber::reference set_transferringNumber (transferringNumber::const_reference value);
    void omit_transferringNumber ();
    bool transferringNumber_isPresent () const;
    class argumentExtension {
      public:
        typedef CTSetupArg_argumentExtension value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class argumentExtension
    argumentExtension::const_reference get_argumentExtension () const;
    argumentExtension::reference ref_argumentExtension ();
    argumentExtension::reference set_argumentExtension ();
    argumentExtension::reference set_argumentExtension (argumentExtension::const_reference value);
    void omit_argumentExtension ();
    bool argumentExtension_isPresent () const;
    void swap(CTSetupArg& other);
    CTSetupArg * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// CTIdentifyRes
//

class CTIdentifyRes : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CTIdentifyRes(const void* info) : Inherited(info) {}
  public:
    CTIdentifyRes() : Inherited(&theInfo) {}
    CTIdentifyRes(const CTIdentifyRes & other) : Inherited(other)
    {}
    CTIdentifyRes& operator = (const CTIdentifyRes& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_resultExtension
    };

    class callIdentity {
      public:
        typedef CallIdentity value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callIdentity
    callIdentity::const_reference get_callIdentity () const;
    callIdentity::reference ref_callIdentity ();
    callIdentity::reference set_callIdentity ();
    callIdentity::reference set_callIdentity (const std::string& value);
    class reroutingNumber {
      public:
        typedef Addressing_Data_Elements::EndpointAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class reroutingNumber
    reroutingNumber::const_reference get_reroutingNumber () const;
    reroutingNumber::reference ref_reroutingNumber ();
    reroutingNumber::reference set_reroutingNumber ();
    reroutingNumber::reference set_reroutingNumber (reroutingNumber::const_reference value);
    class resultExtension {
      public:
        typedef CTIdentifyRes_resultExtension value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class resultExtension
    resultExtension::const_reference get_resultExtension () const;
    resultExtension::reference ref_resultExtension ();
    resultExtension::reference set_resultExtension ();
    resultExtension::reference set_resultExtension (resultExtension::const_reference value);
    void omit_resultExtension ();
    bool resultExtension_isPresent () const;
    void swap(CTIdentifyRes& other);
    CTIdentifyRes * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// CTUpdateArg
//

class CTUpdateArg : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CTUpdateArg(const void* info) : Inherited(info) {}
  public:
    CTUpdateArg() : Inherited(&theInfo) {}
    CTUpdateArg(const CTUpdateArg & other) : Inherited(other)
    {}
    CTUpdateArg& operator = (const CTUpdateArg& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_redirectionInfo,
      e_basicCallInfoElements,
      e_argumentExtension
    };

    class redirectionNumber {
      public:
        typedef Addressing_Data_Elements::EndpointAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class redirectionNumber
    redirectionNumber::const_reference get_redirectionNumber () const;
    redirectionNumber::reference ref_redirectionNumber ();
    redirectionNumber::reference set_redirectionNumber ();
    redirectionNumber::reference set_redirectionNumber (redirectionNumber::const_reference value);
    class redirectionInfo {
      public:
        class value_type : public ASN1::BMPString
        {
            typedef ASN1::BMPString Inherited;
          protected:
            value_type(const void* info) : Inherited(info) {}
          public:
            value_type() : Inherited(&theInfo) { }
            value_type(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const wchar_t* str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const value_type& other) : Inherited(other) {}
            value_type& operator = (std::wstring& other)
            { Inherited::operator=(other); return *this;}
            value_type& operator = (const wchar_t* other)
            { Inherited::operator=(other); return *this;}
            value_type * clone() const;
            static bool equal_type(const ASN1::AbstractData&);
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
        };

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class redirectionInfo
    redirectionInfo::const_reference get_redirectionInfo () const;
    redirectionInfo::reference ref_redirectionInfo ();
    redirectionInfo::reference set_redirectionInfo ();
    redirectionInfo::reference set_redirectionInfo (const std::wstring& value);
    void omit_redirectionInfo ();
    bool redirectionInfo_isPresent () const;
    class basicCallInfoElements {
      public:
        typedef H225_generic_parameters_definition::H225InformationElement value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class basicCallInfoElements
    basicCallInfoElements::const_reference get_basicCallInfoElements () const;
    basicCallInfoElements::reference ref_basicCallInfoElements ();
    basicCallInfoElements::reference set_basicCallInfoElements ();
    basicCallInfoElements::reference set_basicCallInfoElements (basicCallInfoElements::const_reference value);
    void omit_basicCallInfoElements ();
    bool basicCallInfoElements_isPresent () const;
    class argumentExtension {
      public:
        typedef CTUpdateArg_argumentExtension value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class argumentExtension
    argumentExtension::const_reference get_argumentExtension () const;
    argumentExtension::reference ref_argumentExtension ();
    argumentExtension::reference set_argumentExtension ();
    argumentExtension::reference set_argumentExtension (argumentExtension::const_reference value);
    void omit_argumentExtension ();
    bool argumentExtension_isPresent () const;
    void swap(CTUpdateArg& other);
    CTUpdateArg * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// SubaddressTransferArg
//

class SubaddressTransferArg : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    SubaddressTransferArg(const void* info) : Inherited(info) {}
  public:
    SubaddressTransferArg() : Inherited(&theInfo) {}
    SubaddressTransferArg(const SubaddressTransferArg & other) : Inherited(other)
    {}
    SubaddressTransferArg& operator = (const SubaddressTransferArg& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_argumentExtension
    };

    class redirectionSubaddress {
      public:
        typedef Addressing_Data_Elements::PartySubaddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class redirectionSubaddress
    redirectionSubaddress::const_reference get_redirectionSubaddress () const;
    redirectionSubaddress::reference ref_redirectionSubaddress ();
    redirectionSubaddress::reference set_redirectionSubaddress ();
    redirectionSubaddress::reference set_redirectionSubaddress (redirectionSubaddress::const_reference value);
    class argumentExtension {
      public:
        typedef SubaddressTransferArg_argumentExtension value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class argumentExtension
    argumentExtension::const_reference get_argumentExtension () const;
    argumentExtension::reference ref_argumentExtension ();
    argumentExtension::reference set_argumentExtension ();
    argumentExtension::reference set_argumentExtension (argumentExtension::const_reference value);
    void omit_argumentExtension ();
    bool argumentExtension_isPresent () const;
    void swap(SubaddressTransferArg& other);
    SubaddressTransferArg * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// CTCompleteArg
//

class CTCompleteArg : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CTCompleteArg(const void* info) : Inherited(info) {}
  public:
    CTCompleteArg() : Inherited(&theInfo) {}
    CTCompleteArg(const CTCompleteArg & other) : Inherited(other)
    {}
    CTCompleteArg& operator = (const CTCompleteArg& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_basicCallInfoElements,
      e_redirectionInfo,
      e_argumentExtension
    };

    class endDesignation {
      public:
        typedef EndDesignation value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class endDesignation
    endDesignation::const_reference get_endDesignation () const;
    endDesignation::reference ref_endDesignation ();
    endDesignation::reference set_endDesignation ();
    endDesignation::reference set_endDesignation (endDesignation::value_type::NamedNumber value);
    class redirectionNumber {
      public:
        typedef Addressing_Data_Elements::EndpointAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class redirectionNumber
    redirectionNumber::const_reference get_redirectionNumber () const;
    redirectionNumber::reference ref_redirectionNumber ();
    redirectionNumber::reference set_redirectionNumber ();
    redirectionNumber::reference set_redirectionNumber (redirectionNumber::const_reference value);
    class basicCallInfoElements {
      public:
        typedef H225_generic_parameters_definition::H225InformationElement value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class basicCallInfoElements
    basicCallInfoElements::const_reference get_basicCallInfoElements () const;
    basicCallInfoElements::reference ref_basicCallInfoElements ();
    basicCallInfoElements::reference set_basicCallInfoElements ();
    basicCallInfoElements::reference set_basicCallInfoElements (basicCallInfoElements::const_reference value);
    void omit_basicCallInfoElements ();
    bool basicCallInfoElements_isPresent () const;
    class redirectionInfo {
      public:
        class value_type : public ASN1::BMPString
        {
            typedef ASN1::BMPString Inherited;
          protected:
            value_type(const void* info) : Inherited(info) {}
          public:
            value_type() : Inherited(&theInfo) { }
            value_type(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const wchar_t* str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const value_type& other) : Inherited(other) {}
            value_type& operator = (std::wstring& other)
            { Inherited::operator=(other); return *this;}
            value_type& operator = (const wchar_t* other)
            { Inherited::operator=(other); return *this;}
            value_type * clone() const;
            static bool equal_type(const ASN1::AbstractData&);
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
        };

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class redirectionInfo
    redirectionInfo::const_reference get_redirectionInfo () const;
    redirectionInfo::reference ref_redirectionInfo ();
    redirectionInfo::reference set_redirectionInfo ();
    redirectionInfo::reference set_redirectionInfo (const std::wstring& value);
    void omit_redirectionInfo ();
    bool redirectionInfo_isPresent () const;
    class callStatus {
      public:
        typedef CallStatus value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callStatus
    callStatus::const_reference get_callStatus () const;
    callStatus::reference ref_callStatus ();
    callStatus::reference set_callStatus ();
    callStatus::reference set_callStatus (callStatus::value_type::NamedNumber value);
    class argumentExtension {
      public:
        typedef CTCompleteArg_argumentExtension value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class argumentExtension
    argumentExtension::const_reference get_argumentExtension () const;
    argumentExtension::reference ref_argumentExtension ();
    argumentExtension::reference set_argumentExtension ();
    argumentExtension::reference set_argumentExtension (argumentExtension::const_reference value);
    void omit_argumentExtension ();
    bool argumentExtension_isPresent () const;
    void swap(CTCompleteArg& other);
    CTCompleteArg * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[6];
    static int fieldIds[6];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[6];
#endif
};

//
// CTActiveArg
//

class CTActiveArg : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CTActiveArg(const void* info) : Inherited(info) {}
  public:
    CTActiveArg() : Inherited(&theInfo) {}
    CTActiveArg(const CTActiveArg & other) : Inherited(other)
    {}
    CTActiveArg& operator = (const CTActiveArg& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_basicCallInfoElements,
      e_connectedInfo,
      e_argumentExtension
    };

    class connectedAddress {
      public:
        typedef Addressing_Data_Elements::EndpointAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class connectedAddress
    connectedAddress::const_reference get_connectedAddress () const;
    connectedAddress::reference ref_connectedAddress ();
    connectedAddress::reference set_connectedAddress ();
    connectedAddress::reference set_connectedAddress (connectedAddress::const_reference value);
    class basicCallInfoElements {
      public:
        typedef H225_generic_parameters_definition::H225InformationElement value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class basicCallInfoElements
    basicCallInfoElements::const_reference get_basicCallInfoElements () const;
    basicCallInfoElements::reference ref_basicCallInfoElements ();
    basicCallInfoElements::reference set_basicCallInfoElements ();
    basicCallInfoElements::reference set_basicCallInfoElements (basicCallInfoElements::const_reference value);
    void omit_basicCallInfoElements ();
    bool basicCallInfoElements_isPresent () const;
    class connectedInfo {
      public:
        class value_type : public ASN1::BMPString
        {
            typedef ASN1::BMPString Inherited;
          protected:
            value_type(const void* info) : Inherited(info) {}
          public:
            value_type() : Inherited(&theInfo) { }
            value_type(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const wchar_t* str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const value_type& other) : Inherited(other) {}
            value_type& operator = (std::wstring& other)
            { Inherited::operator=(other); return *this;}
            value_type& operator = (const wchar_t* other)
            { Inherited::operator=(other); return *this;}
            value_type * clone() const;
            static bool equal_type(const ASN1::AbstractData&);
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
        };

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class connectedInfo
    connectedInfo::const_reference get_connectedInfo () const;
    connectedInfo::reference ref_connectedInfo ();
    connectedInfo::reference set_connectedInfo ();
    connectedInfo::reference set_connectedInfo (const std::wstring& value);
    void omit_connectedInfo ();
    bool connectedInfo_isPresent () const;
    class argumentExtension {
      public:
        typedef CTActiveArg_argumentExtension value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class argumentExtension
    argumentExtension::const_reference get_argumentExtension () const;
    argumentExtension::reference ref_argumentExtension ();
    argumentExtension::reference set_argumentExtension ();
    argumentExtension::reference set_argumentExtension (argumentExtension::const_reference value);
    void omit_argumentExtension ();
    bool argumentExtension_isPresent () const;
    void swap(CTActiveArg& other);
    CTActiveArg * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

class Module : public ASN1::Module
{
  public:
    Module(H4501_General_Error_List::Module* );
    class callTransferIdentify
    {
      public:
        callTransferIdentify();
        typedef DummyArg ArgumentType;
        typedef CTIdentifyRes ResultType;
        ERROR Errors;
        const Remote_Operations_Information_Objects::Code operationCode;
        OPERATION::value_type make() const
        { return OPERATION::value_type(operationCode,&info ); }
      private:
        class Info : public OPERATION::info_type
        {
          public:
            Info(callTransferIdentify* parent)
            {
                m_ArgumentType= &ArgumentType::theInfo;
                m_ResultType= &ResultType::theInfo;
                m_Errors= &(parent-> Errors);
            }
        };
        Info info;
    }; // class callTransferIdentify
    class callTransferAbandon
    {
      public:
        callTransferAbandon();
        typedef DummyArg ArgumentType;
        const Remote_Operations_Information_Objects::Code operationCode;
        OPERATION::value_type make() const
        { return OPERATION::value_type(operationCode,&info ); }
      private:
        class Info : public OPERATION::info_type
        {
          public:
            Info()
            {
                m_ArgumentType= &ArgumentType::theInfo;
            }
        };
        Info info;
    }; // class callTransferAbandon
    class callTransferInitiate
    {
      public:
        callTransferInitiate();
        typedef CTInitiateArg ArgumentType;
        typedef DummyRes ResultType;
        ERROR Errors;
        const Remote_Operations_Information_Objects::Code operationCode;
        OPERATION::value_type make() const
        { return OPERATION::value_type(operationCode,&info ); }
      private:
        class Info : public OPERATION::info_type
        {
          public:
            Info(callTransferInitiate* parent)
            {
                m_ArgumentType= &ArgumentType::theInfo;
                m_ResultType= &ResultType::theInfo;
                m_Errors= &(parent-> Errors);
            }
        };
        Info info;
    }; // class callTransferInitiate
    class callTransferSetup
    {
      public:
        callTransferSetup();
        typedef CTSetupArg ArgumentType;
        typedef DummyRes ResultType;
        ERROR Errors;
        const Remote_Operations_Information_Objects::Code operationCode;
        OPERATION::value_type make() const
        { return OPERATION::value_type(operationCode,&info ); }
      private:
        class Info : public OPERATION::info_type
        {
          public:
            Info(callTransferSetup* parent)
            {
                m_ArgumentType= &ArgumentType::theInfo;
                m_ResultType= &ResultType::theInfo;
                m_Errors= &(parent-> Errors);
            }
        };
        Info info;
    }; // class callTransferSetup
    class callTransferUpdate
    {
      public:
        callTransferUpdate();
        typedef CTUpdateArg ArgumentType;
        const Remote_Operations_Information_Objects::Code operationCode;
        OPERATION::value_type make() const
        { return OPERATION::value_type(operationCode,&info ); }
      private:
        class Info : public OPERATION::info_type
        {
          public:
            Info()
            {
                m_ArgumentType= &ArgumentType::theInfo;
            }
        };
        Info info;
    }; // class callTransferUpdate
    class subaddressTransfer
    {
      public:
        subaddressTransfer();
        typedef SubaddressTransferArg ArgumentType;
        const Remote_Operations_Information_Objects::Code operationCode;
        OPERATION::value_type make() const
        { return OPERATION::value_type(operationCode,&info ); }
      private:
        class Info : public OPERATION::info_type
        {
          public:
            Info()
            {
                m_ArgumentType= &ArgumentType::theInfo;
            }
        };
        Info info;
    }; // class subaddressTransfer
    class callTransferComplete
    {
      public:
        callTransferComplete();
        typedef CTCompleteArg ArgumentType;
        const Remote_Operations_Information_Objects::Code operationCode;
        OPERATION::value_type make() const
        { return OPERATION::value_type(operationCode,&info ); }
      private:
        class Info : public OPERATION::info_type
        {
          public:
            Info()
            {
                m_ArgumentType= &ArgumentType::theInfo;
            }
        };
        Info info;
    }; // class callTransferComplete
    class callTransferActive
    {
      public:
        callTransferActive();
        typedef CTActiveArg ArgumentType;
        const Remote_Operations_Information_Objects::Code operationCode;
        OPERATION::value_type make() const
        { return OPERATION::value_type(operationCode,&info ); }
      private:
        class Info : public OPERATION::info_type
        {
          public:
            Info()
            {
                m_ArgumentType= &ArgumentType::theInfo;
            }
        };
        Info info;
    }; // class callTransferActive
    class unspecified
    {
      public:
        unspecified();
        class ParameterType : public ASN1::CHOICE
        {
            typedef ASN1::CHOICE Inherited;
          protected:
            ParameterType(const void* info) : Inherited(info) {}
          public:
            ParameterType() : Inherited(&theInfo) {}
            class extension {
              public:
                enum Id { id_ = 0 };
                typedef Manufacturer_specific_service_extension_definition::Extension<ExtensionSet>  value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class extension

            extension::const_reference get_extension () const;
            extension::reference ref_extension (); 
            extension::reference select_extension (); 
            extension::reference select_extension (extension::const_reference value); 
            bool extension_isSelected() const;

            class nonStandard {
              public:
                enum Id { id_ = 1 };
                typedef H323_MESSAGES::NonStandardParameter value_type;
                typedef value_type&			reference;
                typedef const value_type&	const_reference;
                typedef value_type*			pointer;
                typedef const value_type*	const_pointer;
            }; // end class nonStandard

            nonStandard::const_reference get_nonStandard () const;
            nonStandard::reference ref_nonStandard (); 
            nonStandard::reference select_nonStandard (); 
            nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
            bool nonStandard_isSelected() const;

            ParameterType(extension::Id id, extension::const_reference value);
            ParameterType(nonStandard::Id id, nonStandard::const_reference value);
            void swap(ParameterType & other);
            ParameterType(const ParameterType & other)
            : Inherited(other) {} 

            ParameterType & operator = (const ParameterType & other)
            {
              Inherited::operator=(other);
              return *this;
            }

            ParameterType * clone() const;
            static bool equal_type(const ASN1::AbstractData&);
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
          private:
            static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
            static const char* selectionNames[2];
#endif
        };

        const Remote_Operations_Information_Objects::Code errorCode;
        ERROR::value_type make() const
        { return ERROR::value_type(errorCode,&info ); }
      private:
        class Info : public ERROR::info_type
        {
          public:
            Info()
            {
                m_ParameterType= &ParameterType::theInfo;
            }
        };
        Info info;
    }; // class unspecified
    class invalidReroutingNumber
    {
      public:
        invalidReroutingNumber();
        const Remote_Operations_Information_Objects::Code errorCode;
        ERROR::value_type make() const
        { return ERROR::value_type(errorCode,&info ); }
      private:
        typedef ERROR::info_type Info;
        Info info;
    }; // class invalidReroutingNumber
    class unrecognizedCallIdentity
    {
      public:
        unrecognizedCallIdentity();
        const Remote_Operations_Information_Objects::Code errorCode;
        ERROR::value_type make() const
        { return ERROR::value_type(errorCode,&info ); }
      private:
        typedef ERROR::info_type Info;
        Info info;
    }; // class unrecognizedCallIdentity
    class establishmentFailure
    {
      public:
        establishmentFailure();
        const Remote_Operations_Information_Objects::Code errorCode;
        ERROR::value_type make() const
        { return ERROR::value_type(errorCode,&info ); }
      private:
        typedef ERROR::info_type Info;
        Info info;
    }; // class establishmentFailure
    const callTransferIdentify& get_callTransferIdentify() const
    {  return m_callTransferIdentify; }
    const callTransferAbandon& get_callTransferAbandon() const
    {  return m_callTransferAbandon; }
    const callTransferInitiate& get_callTransferInitiate() const
    {  return m_callTransferInitiate; }
    const callTransferSetup& get_callTransferSetup() const
    {  return m_callTransferSetup; }
    const callTransferUpdate& get_callTransferUpdate() const
    {  return m_callTransferUpdate; }
    const subaddressTransfer& get_subaddressTransfer() const
    {  return m_subaddressTransfer; }
    const callTransferComplete& get_callTransferComplete() const
    {  return m_callTransferComplete; }
    const callTransferActive& get_callTransferActive() const
    {  return m_callTransferActive; }
    const unspecified& get_unspecified() const
    {  return m_unspecified; }
    const invalidReroutingNumber& get_invalidReroutingNumber() const
    {  return m_invalidReroutingNumber; }
    const unrecognizedCallIdentity& get_unrecognizedCallIdentity() const
    {  return m_unrecognizedCallIdentity; }
    const establishmentFailure& get_establishmentFailure() const
    {  return m_establishmentFailure; }
    const OPERATION& get_H323CallTransferOperations() const
    {  return m_H323CallTransferOperations; }
    EXTENSION& get_ExtensionSet()
    {  return m_ExtensionSet; }
    const EXTENSION& get_ExtensionSet() const
    {  return m_ExtensionSet; }
  private:
    callTransferIdentify m_callTransferIdentify;
    callTransferAbandon m_callTransferAbandon;
    callTransferInitiate m_callTransferInitiate;
    callTransferSetup m_callTransferSetup;
    callTransferUpdate m_callTransferUpdate;
    subaddressTransfer m_subaddressTransfer;
    callTransferComplete m_callTransferComplete;
    callTransferActive m_callTransferActive;
    unspecified m_unspecified;
    invalidReroutingNumber m_invalidReroutingNumber;
    unrecognizedCallIdentity m_unrecognizedCallIdentity;
    establishmentFailure m_establishmentFailure;
    OPERATION m_H323CallTransferOperations;
    EXTENSION m_ExtensionSet;
}; // class Module 
#include "call_transfer_operations.inl"
} // namespace Call_Transfer_Operations

#endif // __CALL_TRANSFER_OPERATIONS_H


// End of call_transfer_operations.h
