//
// h235_security_messages.h
//
// Code automatically generated by asnparser.
//

#ifndef __H235_SECURITY_MESSAGES_H
#define __H235_SECURITY_MESSAGES_H

#include <asn1.h>

namespace H235_SECURITY_MESSAGES {

typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 8, 128> >  ChallengeString;

typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 4294967295U>  TimeStamp;

typedef ASN1::INTEGER RandomVal;

//
// Password
//

class Password : public ASN1::BMPString
{
    typedef ASN1::BMPString Inherited;
  protected:
    Password(const void* info) : Inherited(info) {}
  public:
    Password() : Inherited(&theInfo) { }
    Password(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
    Password(const wchar_t* str, const void* info = &theInfo) : Inherited(str, info) { }
    Password(const Password& other) : Inherited(other) {}
    Password& operator = (std::wstring& other)
    { Inherited::operator=(other); return *this;}
    Password& operator = (const wchar_t* other)
    { Inherited::operator=(other); return *this;}
    Password * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
};

//
// Identifier
//

class Identifier : public ASN1::BMPString
{
    typedef ASN1::BMPString Inherited;
  protected:
    Identifier(const void* info) : Inherited(info) {}
  public:
    Identifier() : Inherited(&theInfo) { }
    Identifier(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
    Identifier(const wchar_t* str, const void* info = &theInfo) : Inherited(str, info) { }
    Identifier(const Identifier& other) : Inherited(other) {}
    Identifier& operator = (std::wstring& other)
    { Inherited::operator=(other); return *this;}
    Identifier& operator = (const wchar_t* other)
    { Inherited::operator=(other); return *this;}
    Identifier * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
};

typedef ASN1::Constrained_BIT_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 2048> >  KeyMaterial;

//
// NonStandardParameter
//

class NonStandardParameter : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    NonStandardParameter(const void* info) : Inherited(info) {}
  public:
    NonStandardParameter() : Inherited(&theInfo) {}
    NonStandardParameter(const NonStandardParameter & other) : Inherited(other)
    {}
    NonStandardParameter& operator = (const NonStandardParameter& other)
    { Inherited::operator = (other); return *this; } 
    class nonStandardIdentifier {
      public:
        typedef ASN1::OBJECT_IDENTIFIER value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardIdentifier
    nonStandardIdentifier::const_reference get_nonStandardIdentifier () const;
    nonStandardIdentifier::reference ref_nonStandardIdentifier ();
    nonStandardIdentifier::reference set_nonStandardIdentifier ();
    nonStandardIdentifier::reference set_nonStandardIdentifier (nonStandardIdentifier::const_reference value);
    class data {
      public:
        typedef ASN1::OCTET_STRING value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class data
    data::const_reference get_data () const;
    data::reference ref_data ();
    data::reference set_data ();
    data::reference set_data (const std::vector<char>& value);
    void swap(NonStandardParameter& other);
    NonStandardParameter * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// DHset
//

class DHset : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    DHset(const void* info) : Inherited(info) {}
  public:
    DHset() : Inherited(&theInfo) {}
    DHset(const DHset & other) : Inherited(other)
    {}
    DHset& operator = (const DHset& other)
    { Inherited::operator = (other); return *this; } 
    class halfkey {
      public:
        typedef ASN1::Constrained_BIT_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 0, 2048> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class halfkey
    halfkey::const_reference get_halfkey () const;
    halfkey::reference ref_halfkey ();
    halfkey::reference set_halfkey ();
    halfkey::reference set_halfkey (halfkey::const_reference value);
    class modSize {
      public:
        typedef ASN1::Constrained_BIT_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 0, 2048> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class modSize
    modSize::const_reference get_modSize () const;
    modSize::reference ref_modSize ();
    modSize::reference set_modSize ();
    modSize::reference set_modSize (modSize::const_reference value);
    class generator {
      public:
        typedef ASN1::Constrained_BIT_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 0, 2048> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class generator
    generator::const_reference get_generator () const;
    generator::reference ref_generator ();
    generator::reference set_generator ();
    generator::reference set_generator (generator::const_reference value);
    void swap(DHset& other);
    DHset * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// ECpoint
//

class ECpoint : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ECpoint(const void* info) : Inherited(info) {}
  public:
    ECpoint() : Inherited(&theInfo) {}
    ECpoint(const ECpoint & other) : Inherited(other)
    {}
    ECpoint& operator = (const ECpoint& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_x,
      e_y
    };

    class x {
      public:
        typedef ASN1::Constrained_BIT_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 0, 511> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class x
    x::const_reference get_x () const;
    x::reference ref_x ();
    x::reference set_x ();
    x::reference set_x (x::const_reference value);
    void omit_x ();
    bool x_isPresent () const;
    class y {
      public:
        typedef ASN1::Constrained_BIT_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 0, 511> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class y
    y::const_reference get_y () const;
    y::reference ref_y ();
    y::reference set_y ();
    y::reference set_y (y::const_reference value);
    void omit_y ();
    bool y_isPresent () const;
    void swap(ECpoint& other);
    ECpoint * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// ECGDSASignature
//

class ECGDSASignature : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ECGDSASignature(const void* info) : Inherited(info) {}
  public:
    ECGDSASignature() : Inherited(&theInfo) {}
    ECGDSASignature(const ECGDSASignature & other) : Inherited(other)
    {}
    ECGDSASignature& operator = (const ECGDSASignature& other)
    { Inherited::operator = (other); return *this; } 
    class r {
      public:
        typedef ASN1::Constrained_BIT_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 0, 511> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class r
    r::const_reference get_r () const;
    r::reference ref_r ();
    r::reference set_r ();
    r::reference set_r (r::const_reference value);
    class s {
      public:
        typedef ASN1::Constrained_BIT_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 0, 511> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class s
    s::const_reference get_s () const;
    s::reference ref_s ();
    s::reference set_s ();
    s::reference set_s (s::const_reference value);
    void swap(ECGDSASignature& other);
    ECGDSASignature * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// TypedCertificate
//

class TypedCertificate : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    TypedCertificate(const void* info) : Inherited(info) {}
  public:
    TypedCertificate() : Inherited(&theInfo) {}
    TypedCertificate(const TypedCertificate & other) : Inherited(other)
    {}
    TypedCertificate& operator = (const TypedCertificate& other)
    { Inherited::operator = (other); return *this; } 
    class type {
      public:
        typedef ASN1::OBJECT_IDENTIFIER value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class type
    type::const_reference get_type () const;
    type::reference ref_type ();
    type::reference set_type ();
    type::reference set_type (type::const_reference value);
    class certificate {
      public:
        typedef ASN1::OCTET_STRING value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class certificate
    certificate::const_reference get_certificate () const;
    certificate::reference ref_certificate ();
    certificate::reference set_certificate ();
    certificate::reference set_certificate (const std::vector<char>& value);
    void swap(TypedCertificate& other);
    TypedCertificate * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// AuthenticationBES
//

class AuthenticationBES : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    AuthenticationBES(const void* info) : Inherited(info) {}
  public:
    AuthenticationBES() : Inherited(&theInfo) {}
    class default_ {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class default_

    default_::reference select_default (); 
    bool default_isSelected() const;

    class radius {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class radius

    radius::reference select_radius (); 
    bool radius_isSelected() const;

    AuthenticationBES(default_::Id id, default_::const_reference value);
    AuthenticationBES(radius::Id id, radius::const_reference value);
    void swap(AuthenticationBES & other);
    AuthenticationBES(const AuthenticationBES & other)
    : Inherited(other) {} 

    AuthenticationBES & operator = (const AuthenticationBES & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    AuthenticationBES * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// AuthenticationMechanism
//

class AuthenticationMechanism : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    AuthenticationMechanism(const void* info) : Inherited(info) {}
  public:
    AuthenticationMechanism() : Inherited(&theInfo) {}
    class dhExch {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class dhExch

    dhExch::reference select_dhExch (); 
    bool dhExch_isSelected() const;

    class pwdSymEnc {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class pwdSymEnc

    pwdSymEnc::reference select_pwdSymEnc (); 
    bool pwdSymEnc_isSelected() const;

    class pwdHash {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class pwdHash

    pwdHash::reference select_pwdHash (); 
    bool pwdHash_isSelected() const;

    class certSign {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class certSign

    certSign::reference select_certSign (); 
    bool certSign_isSelected() const;

    class ipsec {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class ipsec

    ipsec::reference select_ipsec (); 
    bool ipsec_isSelected() const;

    class tls {
      public:
        enum Id { id_ = 5 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tls

    tls::reference select_tls (); 
    bool tls_isSelected() const;

    class nonStandard {
      public:
        enum Id { id_ = 6 };
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class authenticationBES {
      public:
        enum Id { id_ = 7 };
        typedef AuthenticationBES value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class authenticationBES

    authenticationBES::const_reference get_authenticationBES () const;
    authenticationBES::reference ref_authenticationBES (); 
    authenticationBES::reference select_authenticationBES (); 
    authenticationBES::reference select_authenticationBES (authenticationBES::const_reference value); 
    bool authenticationBES_isSelected() const;

    AuthenticationMechanism(dhExch::Id id, dhExch::const_reference value);
    AuthenticationMechanism(pwdSymEnc::Id id, pwdSymEnc::const_reference value);
    AuthenticationMechanism(pwdHash::Id id, pwdHash::const_reference value);
    AuthenticationMechanism(certSign::Id id, certSign::const_reference value);
    AuthenticationMechanism(ipsec::Id id, ipsec::const_reference value);
    AuthenticationMechanism(tls::Id id, tls::const_reference value);
    AuthenticationMechanism(nonStandard::Id id, nonStandard::const_reference value);
    AuthenticationMechanism(authenticationBES::Id id, authenticationBES::const_reference value);
    void swap(AuthenticationMechanism & other);
    AuthenticationMechanism(const AuthenticationMechanism & other)
    : Inherited(other) {} 

    AuthenticationMechanism & operator = (const AuthenticationMechanism & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    AuthenticationMechanism * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[8];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[8];
#endif
};

typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 8, 8> >  IV8;

typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 16, 16> >  IV16;

//
// Params
//

class Params : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    Params(const void* info) : Inherited(info) {}
  public:
    Params() : Inherited(&theInfo) {}
    Params(const Params & other) : Inherited(other)
    {}
    Params& operator = (const Params& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_ranInt,
      e_iv8,
      e_iv16
    };

    class ranInt {
      public:
        typedef ASN1::INTEGER value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class ranInt
    ranInt::const_reference get_ranInt () const;
    ranInt::reference ref_ranInt ();
    ranInt::reference set_ranInt ();
    ranInt::reference set_ranInt (ranInt::value_type::int_type value);
    void omit_ranInt ();
    bool ranInt_isPresent () const;
    class iv8 {
      public:
        typedef IV8 value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class iv8
    iv8::const_reference get_iv8 () const;
    iv8::reference ref_iv8 ();
    iv8::reference set_iv8 ();
    iv8::reference set_iv8 (const std::vector<char>& value);
    void omit_iv8 ();
    bool iv8_isPresent () const;
    class iv16 {
      public:
        typedef IV16 value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class iv16
    iv16::const_reference get_iv16 () const;
    iv16::reference ref_iv16 ();
    iv16::reference set_iv16 ();
    iv16::reference set_iv16 (const std::vector<char>& value);
    void omit_iv16 ();
    bool iv16_isPresent () const;
    void swap(Params& other);
    Params * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// ReturnSig
//

class ReturnSig : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ReturnSig(const void* info) : Inherited(info) {}
  public:
    ReturnSig() : Inherited(&theInfo) {}
    ReturnSig(const ReturnSig & other) : Inherited(other)
    {}
    ReturnSig& operator = (const ReturnSig& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_requestRandom,
      e_certificate
    };

    class generalId {
      public:
        typedef Identifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class generalId
    generalId::const_reference get_generalId () const;
    generalId::reference ref_generalId ();
    generalId::reference set_generalId ();
    generalId::reference set_generalId (const std::wstring& value);
    class responseRandom {
      public:
        typedef RandomVal value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class responseRandom
    responseRandom::const_reference get_responseRandom () const;
    responseRandom::reference ref_responseRandom ();
    responseRandom::reference set_responseRandom ();
    responseRandom::reference set_responseRandom (responseRandom::value_type::int_type value);
    class requestRandom {
      public:
        typedef RandomVal value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestRandom
    requestRandom::const_reference get_requestRandom () const;
    requestRandom::reference ref_requestRandom ();
    requestRandom::reference set_requestRandom ();
    requestRandom::reference set_requestRandom (requestRandom::value_type::int_type value);
    void omit_requestRandom ();
    bool requestRandom_isPresent () const;
    class certificate {
      public:
        typedef TypedCertificate value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class certificate
    certificate::const_reference get_certificate () const;
    certificate::reference ref_certificate ();
    certificate::reference set_certificate ();
    certificate::reference set_certificate (certificate::const_reference value);
    void omit_certificate ();
    bool certificate_isPresent () const;
    void swap(ReturnSig& other);
    ReturnSig * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

typedef ASN1::Constrained_OpenData<ReturnSig>  EncodedReturnSig;

//
// KeySyncMaterial
//

class KeySyncMaterial : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    KeySyncMaterial(const void* info) : Inherited(info) {}
  public:
    KeySyncMaterial() : Inherited(&theInfo) {}
    KeySyncMaterial(const KeySyncMaterial & other) : Inherited(other)
    {}
    KeySyncMaterial& operator = (const KeySyncMaterial& other)
    { Inherited::operator = (other); return *this; } 
    class generalID {
      public:
        typedef Identifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class generalID
    generalID::const_reference get_generalID () const;
    generalID::reference ref_generalID ();
    generalID::reference set_generalID ();
    generalID::reference set_generalID (const std::wstring& value);
    class keyMaterial {
      public:
        typedef KeyMaterial value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class keyMaterial
    keyMaterial::const_reference get_keyMaterial () const;
    keyMaterial::reference ref_keyMaterial ();
    keyMaterial::reference set_keyMaterial ();
    keyMaterial::reference set_keyMaterial (keyMaterial::const_reference value);
    void swap(KeySyncMaterial& other);
    KeySyncMaterial * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

typedef ASN1::Constrained_OpenData<KeySyncMaterial>  EncodedKeySyncMaterial;

//
// ECKASDH_eckasdhp
//

class ECKASDH_eckasdhp : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ECKASDH_eckasdhp(const void* info) : Inherited(info) {}
  public:
    ECKASDH_eckasdhp() : Inherited(&theInfo) {}
    ECKASDH_eckasdhp(const ECKASDH_eckasdhp & other) : Inherited(other)
    {}
    ECKASDH_eckasdhp& operator = (const ECKASDH_eckasdhp& other)
    { Inherited::operator = (other); return *this; } 
    class public_key {
      public:
        typedef ECpoint value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class public_key
    public_key::const_reference get_public_key () const;
    public_key::reference ref_public_key ();
    public_key::reference set_public_key ();
    public_key::reference set_public_key (public_key::const_reference value);
    class modulus {
      public:
        typedef ASN1::Constrained_BIT_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 0, 511> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class modulus
    modulus::const_reference get_modulus () const;
    modulus::reference ref_modulus ();
    modulus::reference set_modulus ();
    modulus::reference set_modulus (modulus::const_reference value);
    class base {
      public:
        typedef ECpoint value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class base
    base::const_reference get_base () const;
    base::reference ref_base ();
    base::reference set_base ();
    base::reference set_base (base::const_reference value);
    class weierstrassA {
      public:
        typedef ASN1::Constrained_BIT_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 0, 511> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class weierstrassA
    weierstrassA::const_reference get_weierstrassA () const;
    weierstrassA::reference ref_weierstrassA ();
    weierstrassA::reference set_weierstrassA ();
    weierstrassA::reference set_weierstrassA (weierstrassA::const_reference value);
    class weierstrassB {
      public:
        typedef ASN1::Constrained_BIT_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 0, 511> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class weierstrassB
    weierstrassB::const_reference get_weierstrassB () const;
    weierstrassB::reference ref_weierstrassB ();
    weierstrassB::reference set_weierstrassB ();
    weierstrassB::reference set_weierstrassB (weierstrassB::const_reference value);
    void swap(ECKASDH_eckasdhp& other);
    ECKASDH_eckasdhp * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[5];
    static int fieldIds[5];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[5];
#endif
};

//
// ECKASDH_eckasdh2
//

class ECKASDH_eckasdh2 : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ECKASDH_eckasdh2(const void* info) : Inherited(info) {}
  public:
    ECKASDH_eckasdh2() : Inherited(&theInfo) {}
    ECKASDH_eckasdh2(const ECKASDH_eckasdh2 & other) : Inherited(other)
    {}
    ECKASDH_eckasdh2& operator = (const ECKASDH_eckasdh2& other)
    { Inherited::operator = (other); return *this; } 
    class public_key {
      public:
        typedef ECpoint value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class public_key
    public_key::const_reference get_public_key () const;
    public_key::reference ref_public_key ();
    public_key::reference set_public_key ();
    public_key::reference set_public_key (public_key::const_reference value);
    class fieldSize {
      public:
        typedef ASN1::Constrained_BIT_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 0, 511> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class fieldSize
    fieldSize::const_reference get_fieldSize () const;
    fieldSize::reference ref_fieldSize ();
    fieldSize::reference set_fieldSize ();
    fieldSize::reference set_fieldSize (fieldSize::const_reference value);
    class base {
      public:
        typedef ECpoint value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class base
    base::const_reference get_base () const;
    base::reference ref_base ();
    base::reference set_base ();
    base::reference set_base (base::const_reference value);
    class weierstrassA {
      public:
        typedef ASN1::Constrained_BIT_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 0, 511> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class weierstrassA
    weierstrassA::const_reference get_weierstrassA () const;
    weierstrassA::reference ref_weierstrassA ();
    weierstrassA::reference set_weierstrassA ();
    weierstrassA::reference set_weierstrassA (weierstrassA::const_reference value);
    class weierstrassB {
      public:
        typedef ASN1::Constrained_BIT_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 0, 511> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class weierstrassB
    weierstrassB::const_reference get_weierstrassB () const;
    weierstrassB::reference ref_weierstrassB ();
    weierstrassB::reference set_weierstrassB ();
    weierstrassB::reference set_weierstrassB (weierstrassB::const_reference value);
    void swap(ECKASDH_eckasdh2& other);
    ECKASDH_eckasdh2 * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[5];
    static int fieldIds[5];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[5];
#endif
};

//
// ECKASDH
//

class ECKASDH : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    ECKASDH(const void* info) : Inherited(info) {}
  public:
    ECKASDH() : Inherited(&theInfo) {}
    class eckasdhp {
      public:
        enum Id { id_ = 0 };
        typedef ECKASDH_eckasdhp value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class eckasdhp

    eckasdhp::const_reference get_eckasdhp () const;
    eckasdhp::reference ref_eckasdhp (); 
    eckasdhp::reference select_eckasdhp (); 
    eckasdhp::reference select_eckasdhp (eckasdhp::const_reference value); 
    bool eckasdhp_isSelected() const;

    class eckasdh2 {
      public:
        enum Id { id_ = 1 };
        typedef ECKASDH_eckasdh2 value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class eckasdh2

    eckasdh2::const_reference get_eckasdh2 () const;
    eckasdh2::reference ref_eckasdh2 (); 
    eckasdh2::reference select_eckasdh2 (); 
    eckasdh2::reference select_eckasdh2 (eckasdh2::const_reference value); 
    bool eckasdh2_isSelected() const;

    ECKASDH(eckasdhp::Id id, eckasdhp::const_reference value);
    ECKASDH(eckasdh2::Id id, eckasdh2::const_reference value);
    void swap(ECKASDH & other);
    ECKASDH(const ECKASDH & other)
    : Inherited(other) {} 

    ECKASDH & operator = (const ECKASDH & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    ECKASDH * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// ClearToken
//

class ClearToken : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ClearToken(const void* info) : Inherited(info) {}
  public:
    ClearToken() : Inherited(&theInfo) {}
    ClearToken(const ClearToken & other) : Inherited(other)
    {}
    ClearToken& operator = (const ClearToken& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_timeStamp,
      e_password,
      e_dhkey,
      e_challenge,
      e_random,
      e_certificate,
      e_generalID,
      e_nonStandard,
      e_eckasdhkey,
      e_sendersID
    };

    class tokenOID {
      public:
        typedef ASN1::OBJECT_IDENTIFIER value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokenOID
    tokenOID::const_reference get_tokenOID () const;
    tokenOID::reference ref_tokenOID ();
    tokenOID::reference set_tokenOID ();
    tokenOID::reference set_tokenOID (tokenOID::const_reference value);
    class timeStamp {
      public:
        typedef TimeStamp value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class timeStamp
    timeStamp::const_reference get_timeStamp () const;
    timeStamp::reference ref_timeStamp ();
    timeStamp::reference set_timeStamp ();
    timeStamp::reference set_timeStamp (timeStamp::value_type::int_type value);
    void omit_timeStamp ();
    bool timeStamp_isPresent () const;
    class password {
      public:
        typedef Password value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class password
    password::const_reference get_password () const;
    password::reference ref_password ();
    password::reference set_password ();
    password::reference set_password (const std::wstring& value);
    void omit_password ();
    bool password_isPresent () const;
    class dhkey {
      public:
        typedef DHset value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class dhkey
    dhkey::const_reference get_dhkey () const;
    dhkey::reference ref_dhkey ();
    dhkey::reference set_dhkey ();
    dhkey::reference set_dhkey (dhkey::const_reference value);
    void omit_dhkey ();
    bool dhkey_isPresent () const;
    class challenge {
      public:
        typedef ChallengeString value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class challenge
    challenge::const_reference get_challenge () const;
    challenge::reference ref_challenge ();
    challenge::reference set_challenge ();
    challenge::reference set_challenge (const std::vector<char>& value);
    void omit_challenge ();
    bool challenge_isPresent () const;
    class random {
      public:
        typedef RandomVal value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class random
    random::const_reference get_random () const;
    random::reference ref_random ();
    random::reference set_random ();
    random::reference set_random (random::value_type::int_type value);
    void omit_random ();
    bool random_isPresent () const;
    class certificate {
      public:
        typedef TypedCertificate value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class certificate
    certificate::const_reference get_certificate () const;
    certificate::reference ref_certificate ();
    certificate::reference set_certificate ();
    certificate::reference set_certificate (certificate::const_reference value);
    void omit_certificate ();
    bool certificate_isPresent () const;
    class generalID {
      public:
        typedef Identifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class generalID
    generalID::const_reference get_generalID () const;
    generalID::reference ref_generalID ();
    generalID::reference set_generalID ();
    generalID::reference set_generalID (const std::wstring& value);
    void omit_generalID ();
    bool generalID_isPresent () const;
    class nonStandard {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard
    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard ();
    nonStandard::reference set_nonStandard ();
    nonStandard::reference set_nonStandard (nonStandard::const_reference value);
    void omit_nonStandard ();
    bool nonStandard_isPresent () const;
    class eckasdhkey {
      public:
        typedef ECKASDH value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class eckasdhkey
    eckasdhkey::const_reference get_eckasdhkey () const;
    eckasdhkey::reference ref_eckasdhkey ();
    eckasdhkey::reference set_eckasdhkey ();
    eckasdhkey::reference set_eckasdhkey (eckasdhkey::const_reference value);
    void omit_eckasdhkey ();
    bool eckasdhkey_isPresent () const;
    class sendersID {
      public:
        typedef Identifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sendersID
    sendersID::const_reference get_sendersID () const;
    sendersID::reference ref_sendersID ();
    sendersID::reference set_sendersID ();
    sendersID::reference set_sendersID (const std::wstring& value);
    void omit_sendersID ();
    bool sendersID_isPresent () const;
    void swap(ClearToken& other);
    ClearToken * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[11];
    static int fieldIds[11];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[11];
#endif
};

//
// SIGNED<ToBeSigned>
//

template <class ToBeSigned>
class SIGNED : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    SIGNED(const void* info) : Inherited(info) {}
  public:
    SIGNED() : Inherited(&theInfo) {}
    SIGNED(const SIGNED<ToBeSigned> & other) : Inherited(other)
    {}
    SIGNED<ToBeSigned>& operator = (const SIGNED<ToBeSigned>& other)
    { Inherited::operator = (other); return *this; } 
    class toBeSigned {
      public:
        typedef ToBeSigned value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class toBeSigned
    typename toBeSigned::const_reference get_toBeSigned () const;
    typename toBeSigned::reference ref_toBeSigned ();
    typename toBeSigned::reference set_toBeSigned ();
    typename toBeSigned::reference set_toBeSigned (typename toBeSigned::const_reference value);
    class algorithmOID {
      public:
        typedef ASN1::OBJECT_IDENTIFIER value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class algorithmOID
    typename algorithmOID::const_reference get_algorithmOID () const;
    typename algorithmOID::reference ref_algorithmOID ();
    typename algorithmOID::reference set_algorithmOID ();
    typename algorithmOID::reference set_algorithmOID (typename algorithmOID::const_reference value);
    class paramS {
      public:
        typedef Params value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class paramS
    typename paramS::const_reference get_paramS () const;
    typename paramS::reference ref_paramS ();
    typename paramS::reference set_paramS ();
    typename paramS::reference set_paramS (typename paramS::const_reference value);
    class signature {
      public:
        typedef ASN1::BIT_STRING value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class signature
    typename signature::const_reference get_signature () const;
    typename signature::reference ref_signature ();
    typename signature::reference set_signature ();
    typename signature::reference set_signature (typename signature::const_reference value);
    void swap(SIGNED& other);
    SIGNED<ToBeSigned> * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// ENCRYPTED<ToBeEncrypted>
//

template <class ToBeEncrypted>
class ENCRYPTED : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ENCRYPTED(const void* info) : Inherited(info) {}
  public:
    ENCRYPTED() : Inherited(&theInfo) {}
    ENCRYPTED(const ENCRYPTED<ToBeEncrypted> & other) : Inherited(other)
    {}
    ENCRYPTED<ToBeEncrypted>& operator = (const ENCRYPTED<ToBeEncrypted>& other)
    { Inherited::operator = (other); return *this; } 
    class algorithmOID {
      public:
        typedef ASN1::OBJECT_IDENTIFIER value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class algorithmOID
    typename algorithmOID::const_reference get_algorithmOID () const;
    typename algorithmOID::reference ref_algorithmOID ();
    typename algorithmOID::reference set_algorithmOID ();
    typename algorithmOID::reference set_algorithmOID (typename algorithmOID::const_reference value);
    class paramS {
      public:
        typedef Params value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class paramS
    typename paramS::const_reference get_paramS () const;
    typename paramS::reference ref_paramS ();
    typename paramS::reference set_paramS ();
    typename paramS::reference set_paramS (typename paramS::const_reference value);
    class encryptedData {
      public:
        typedef ASN1::OCTET_STRING value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class encryptedData
    typename encryptedData::const_reference get_encryptedData () const;
    typename encryptedData::reference ref_encryptedData ();
    typename encryptedData::reference set_encryptedData ();
    typename encryptedData::reference set_encryptedData (const std::vector<char>& value);
    void swap(ENCRYPTED& other);
    ENCRYPTED<ToBeEncrypted> * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// HASHED<ToBeHashed>
//

template <class ToBeHashed>
class HASHED : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    HASHED(const void* info) : Inherited(info) {}
  public:
    HASHED() : Inherited(&theInfo) {}
    HASHED(const HASHED<ToBeHashed> & other) : Inherited(other)
    {}
    HASHED<ToBeHashed>& operator = (const HASHED<ToBeHashed>& other)
    { Inherited::operator = (other); return *this; } 
    class algorithmOID {
      public:
        typedef ASN1::OBJECT_IDENTIFIER value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class algorithmOID
    typename algorithmOID::const_reference get_algorithmOID () const;
    typename algorithmOID::reference ref_algorithmOID ();
    typename algorithmOID::reference set_algorithmOID ();
    typename algorithmOID::reference set_algorithmOID (typename algorithmOID::const_reference value);
    class paramS {
      public:
        typedef Params value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class paramS
    typename paramS::const_reference get_paramS () const;
    typename paramS::reference ref_paramS ();
    typename paramS::reference set_paramS ();
    typename paramS::reference set_paramS (typename paramS::const_reference value);
    class hash {
      public:
        typedef ASN1::BIT_STRING value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class hash
    typename hash::const_reference get_hash () const;
    typename hash::reference ref_hash ();
    typename hash::reference set_hash ();
    typename hash::reference set_hash (typename hash::const_reference value);
    void swap(HASHED& other);
    HASHED<ToBeHashed> * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

typedef ASN1::Constrained_OpenData<ClearToken>  EncodedGeneralToken;

//
// PwdCertToken
//

class PwdCertToken : public ClearToken
{
    typedef ClearToken Inherited;
  protected:
    PwdCertToken(const void* info) : Inherited(info) {}
  public:
    PwdCertToken() : Inherited(&theInfo) {}
    PwdCertToken(const PwdCertToken& other) : Inherited(other) {}
    PwdCertToken * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
};

typedef ASN1::Constrained_OpenData<PwdCertToken>  EncodedPwdCertToken;

//
// KeySignedMaterial
//

class KeySignedMaterial : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    KeySignedMaterial(const void* info) : Inherited(info) {}
  public:
    KeySignedMaterial() : Inherited(&theInfo) {}
    KeySignedMaterial(const KeySignedMaterial & other) : Inherited(other)
    {}
    KeySignedMaterial& operator = (const KeySignedMaterial& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_srandom,
      e_timeStamp
    };

    class generalId {
      public:
        typedef Identifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class generalId
    generalId::const_reference get_generalId () const;
    generalId::reference ref_generalId ();
    generalId::reference set_generalId ();
    generalId::reference set_generalId (const std::wstring& value);
    class mrandom {
      public:
        typedef RandomVal value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mrandom
    mrandom::const_reference get_mrandom () const;
    mrandom::reference ref_mrandom ();
    mrandom::reference set_mrandom ();
    mrandom::reference set_mrandom (mrandom::value_type::int_type value);
    class srandom {
      public:
        typedef RandomVal value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class srandom
    srandom::const_reference get_srandom () const;
    srandom::reference ref_srandom ();
    srandom::reference set_srandom ();
    srandom::reference set_srandom (srandom::value_type::int_type value);
    void omit_srandom ();
    bool srandom_isPresent () const;
    class timeStamp {
      public:
        typedef TimeStamp value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class timeStamp
    timeStamp::const_reference get_timeStamp () const;
    timeStamp::reference ref_timeStamp ();
    timeStamp::reference set_timeStamp ();
    timeStamp::reference set_timeStamp (timeStamp::value_type::int_type value);
    void omit_timeStamp ();
    bool timeStamp_isPresent () const;
    class encrptval {
      public:
        typedef ENCRYPTED<EncodedKeySyncMaterial>  value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class encrptval
    encrptval::const_reference get_encrptval () const;
    encrptval::reference ref_encrptval ();
    encrptval::reference set_encrptval ();
    encrptval::reference set_encrptval (encrptval::const_reference value);
    void swap(KeySignedMaterial& other);
    KeySignedMaterial * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[5];
    static int fieldIds[5];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[5];
#endif
};

typedef ASN1::Constrained_OpenData<KeySignedMaterial>  EncodedKeySignedMaterial;

//
// H235CertificateSignature
//

class H235CertificateSignature : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    H235CertificateSignature(const void* info) : Inherited(info) {}
  public:
    H235CertificateSignature() : Inherited(&theInfo) {}
    H235CertificateSignature(const H235CertificateSignature & other) : Inherited(other)
    {}
    H235CertificateSignature& operator = (const H235CertificateSignature& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_requesterRandom
    };

    class certificate {
      public:
        typedef TypedCertificate value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class certificate
    certificate::const_reference get_certificate () const;
    certificate::reference ref_certificate ();
    certificate::reference set_certificate ();
    certificate::reference set_certificate (certificate::const_reference value);
    class responseRandom {
      public:
        typedef RandomVal value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class responseRandom
    responseRandom::const_reference get_responseRandom () const;
    responseRandom::reference ref_responseRandom ();
    responseRandom::reference set_responseRandom ();
    responseRandom::reference set_responseRandom (responseRandom::value_type::int_type value);
    class requesterRandom {
      public:
        typedef RandomVal value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requesterRandom
    requesterRandom::const_reference get_requesterRandom () const;
    requesterRandom::reference ref_requesterRandom ();
    requesterRandom::reference set_requesterRandom ();
    requesterRandom::reference set_requesterRandom (requesterRandom::value_type::int_type value);
    void omit_requesterRandom ();
    bool requesterRandom_isPresent () const;
    class signature {
      public:
        typedef SIGNED<EncodedReturnSig>  value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class signature
    signature::const_reference get_signature () const;
    signature::reference ref_signature ();
    signature::reference set_signature ();
    signature::reference set_signature (signature::const_reference value);
    void swap(H235CertificateSignature& other);
    H235CertificateSignature * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// CryptoToken_cryptoEncryptedToken
//

class CryptoToken_cryptoEncryptedToken : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CryptoToken_cryptoEncryptedToken(const void* info) : Inherited(info) {}
  public:
    CryptoToken_cryptoEncryptedToken() : Inherited(&theInfo) {}
    CryptoToken_cryptoEncryptedToken(const CryptoToken_cryptoEncryptedToken & other) : Inherited(other)
    {}
    CryptoToken_cryptoEncryptedToken& operator = (const CryptoToken_cryptoEncryptedToken& other)
    { Inherited::operator = (other); return *this; } 
    class tokenOID {
      public:
        typedef ASN1::OBJECT_IDENTIFIER value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokenOID
    tokenOID::const_reference get_tokenOID () const;
    tokenOID::reference ref_tokenOID ();
    tokenOID::reference set_tokenOID ();
    tokenOID::reference set_tokenOID (tokenOID::const_reference value);
    class token {
      public:
        typedef ENCRYPTED<EncodedGeneralToken>  value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class token
    token::const_reference get_token () const;
    token::reference ref_token ();
    token::reference set_token ();
    token::reference set_token (token::const_reference value);
    void swap(CryptoToken_cryptoEncryptedToken& other);
    CryptoToken_cryptoEncryptedToken * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// CryptoToken_cryptoSignedToken
//

class CryptoToken_cryptoSignedToken : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CryptoToken_cryptoSignedToken(const void* info) : Inherited(info) {}
  public:
    CryptoToken_cryptoSignedToken() : Inherited(&theInfo) {}
    CryptoToken_cryptoSignedToken(const CryptoToken_cryptoSignedToken & other) : Inherited(other)
    {}
    CryptoToken_cryptoSignedToken& operator = (const CryptoToken_cryptoSignedToken& other)
    { Inherited::operator = (other); return *this; } 
    class tokenOID {
      public:
        typedef ASN1::OBJECT_IDENTIFIER value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokenOID
    tokenOID::const_reference get_tokenOID () const;
    tokenOID::reference ref_tokenOID ();
    tokenOID::reference set_tokenOID ();
    tokenOID::reference set_tokenOID (tokenOID::const_reference value);
    class token {
      public:
        typedef SIGNED<EncodedGeneralToken>  value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class token
    token::const_reference get_token () const;
    token::reference ref_token ();
    token::reference set_token ();
    token::reference set_token (token::const_reference value);
    void swap(CryptoToken_cryptoSignedToken& other);
    CryptoToken_cryptoSignedToken * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// CryptoToken_cryptoHashedToken
//

class CryptoToken_cryptoHashedToken : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CryptoToken_cryptoHashedToken(const void* info) : Inherited(info) {}
  public:
    CryptoToken_cryptoHashedToken() : Inherited(&theInfo) {}
    CryptoToken_cryptoHashedToken(const CryptoToken_cryptoHashedToken & other) : Inherited(other)
    {}
    CryptoToken_cryptoHashedToken& operator = (const CryptoToken_cryptoHashedToken& other)
    { Inherited::operator = (other); return *this; } 
    class tokenOID {
      public:
        typedef ASN1::OBJECT_IDENTIFIER value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokenOID
    tokenOID::const_reference get_tokenOID () const;
    tokenOID::reference ref_tokenOID ();
    tokenOID::reference set_tokenOID ();
    tokenOID::reference set_tokenOID (tokenOID::const_reference value);
    class hashedVals {
      public:
        typedef ClearToken value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class hashedVals
    hashedVals::const_reference get_hashedVals () const;
    hashedVals::reference ref_hashedVals ();
    hashedVals::reference set_hashedVals ();
    hashedVals::reference set_hashedVals (hashedVals::const_reference value);
    class token {
      public:
        typedef HASHED<EncodedGeneralToken>  value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class token
    token::const_reference get_token () const;
    token::reference ref_token ();
    token::reference set_token ();
    token::reference set_token (token::const_reference value);
    void swap(CryptoToken_cryptoHashedToken& other);
    CryptoToken_cryptoHashedToken * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// CryptoToken
//

class CryptoToken : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    CryptoToken(const void* info) : Inherited(info) {}
  public:
    CryptoToken() : Inherited(&theInfo) {}
    class cryptoEncryptedToken {
      public:
        enum Id { id_ = 0 };
        typedef CryptoToken_cryptoEncryptedToken value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoEncryptedToken

    cryptoEncryptedToken::const_reference get_cryptoEncryptedToken () const;
    cryptoEncryptedToken::reference ref_cryptoEncryptedToken (); 
    cryptoEncryptedToken::reference select_cryptoEncryptedToken (); 
    cryptoEncryptedToken::reference select_cryptoEncryptedToken (cryptoEncryptedToken::const_reference value); 
    bool cryptoEncryptedToken_isSelected() const;

    class cryptoSignedToken {
      public:
        enum Id { id_ = 1 };
        typedef CryptoToken_cryptoSignedToken value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoSignedToken

    cryptoSignedToken::const_reference get_cryptoSignedToken () const;
    cryptoSignedToken::reference ref_cryptoSignedToken (); 
    cryptoSignedToken::reference select_cryptoSignedToken (); 
    cryptoSignedToken::reference select_cryptoSignedToken (cryptoSignedToken::const_reference value); 
    bool cryptoSignedToken_isSelected() const;

    class cryptoHashedToken {
      public:
        enum Id { id_ = 2 };
        typedef CryptoToken_cryptoHashedToken value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoHashedToken

    cryptoHashedToken::const_reference get_cryptoHashedToken () const;
    cryptoHashedToken::reference ref_cryptoHashedToken (); 
    cryptoHashedToken::reference select_cryptoHashedToken (); 
    cryptoHashedToken::reference select_cryptoHashedToken (cryptoHashedToken::const_reference value); 
    bool cryptoHashedToken_isSelected() const;

    class cryptoPwdEncr {
      public:
        enum Id { id_ = 3 };
        typedef ENCRYPTED<EncodedPwdCertToken>  value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cryptoPwdEncr

    cryptoPwdEncr::const_reference get_cryptoPwdEncr () const;
    cryptoPwdEncr::reference ref_cryptoPwdEncr (); 
    cryptoPwdEncr::reference select_cryptoPwdEncr (); 
    cryptoPwdEncr::reference select_cryptoPwdEncr (cryptoPwdEncr::const_reference value); 
    bool cryptoPwdEncr_isSelected() const;

    CryptoToken(cryptoEncryptedToken::Id id, cryptoEncryptedToken::const_reference value);
    CryptoToken(cryptoSignedToken::Id id, cryptoSignedToken::const_reference value);
    CryptoToken(cryptoHashedToken::Id id, cryptoHashedToken::const_reference value);
    CryptoToken(cryptoPwdEncr::Id id, cryptoPwdEncr::const_reference value);
    void swap(CryptoToken & other);
    CryptoToken(const CryptoToken & other)
    : Inherited(other) {} 

    CryptoToken & operator = (const CryptoToken & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    CryptoToken * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[4];
#endif
};

//
// H235Key
//

class H235Key : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    H235Key(const void* info) : Inherited(info) {}
  public:
    H235Key() : Inherited(&theInfo) {}
    class secureChannel {
      public:
        enum Id { id_ = 0 };
        typedef KeyMaterial value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class secureChannel

    secureChannel::const_reference get_secureChannel () const;
    secureChannel::reference ref_secureChannel (); 
    secureChannel::reference select_secureChannel (); 
    secureChannel::reference select_secureChannel (secureChannel::const_reference value); 
    bool secureChannel_isSelected() const;

    class sharedSecret {
      public:
        enum Id { id_ = 1 };
        typedef ENCRYPTED<EncodedKeySyncMaterial>  value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sharedSecret

    sharedSecret::const_reference get_sharedSecret () const;
    sharedSecret::reference ref_sharedSecret (); 
    sharedSecret::reference select_sharedSecret (); 
    sharedSecret::reference select_sharedSecret (sharedSecret::const_reference value); 
    bool sharedSecret_isSelected() const;

    class certProtectedKey {
      public:
        enum Id { id_ = 2 };
        typedef SIGNED<EncodedKeySignedMaterial>  value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class certProtectedKey

    certProtectedKey::const_reference get_certProtectedKey () const;
    certProtectedKey::reference ref_certProtectedKey (); 
    certProtectedKey::reference select_certProtectedKey (); 
    certProtectedKey::reference select_certProtectedKey (certProtectedKey::const_reference value); 
    bool certProtectedKey_isSelected() const;

    H235Key(secureChannel::Id id, secureChannel::const_reference value);
    H235Key(sharedSecret::Id id, sharedSecret::const_reference value);
    H235Key(certProtectedKey::Id id, certProtectedKey::const_reference value);
    void swap(H235Key & other);
    H235Key(const H235Key & other)
    : Inherited(other) {} 

    H235Key & operator = (const H235Key & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    H235Key * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

#include "h235_security_messages.inl"
} // namespace H235_SECURITY_MESSAGES

#endif // __H235_SECURITY_MESSAGES_H


// End of h235_security_messages.h
