//
// media_gateway_control.h
//
// Code automatically generated by asnparser.
//

#ifndef __MEDIA_GATEWAY_CONTROL_H
#define __MEDIA_GATEWAY_CONTROL_H

#include <asn1.h>

namespace MEDIA_GATEWAY_CONTROL {

typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 4, 4> >  SecurityParmIndex;

typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 4, 4> >  SequenceNum;

typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 12, 32> >  AuthData;

//
// DomainName
//

class DomainName : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    DomainName(const void* info) : Inherited(info) {}
  public:
    DomainName() : Inherited(&theInfo) {}
    DomainName(const DomainName & other) : Inherited(other)
    {}
    DomainName& operator = (const DomainName& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_portNumber
    };

    class name {
      public:
        typedef ASN1::IA5String value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class name
    name::const_reference get_name () const;
    name::reference ref_name ();
    name::reference set_name ();
    name::reference set_name (const std::string& value);
    class portNumber {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class portNumber
    portNumber::const_reference get_portNumber () const;
    portNumber::reference ref_portNumber ();
    portNumber::reference set_portNumber ();
    portNumber::reference set_portNumber (portNumber::value_type::int_type value);
    void omit_portNumber ();
    bool portNumber_isPresent () const;
    void swap(DomainName& other);
    DomainName * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// IP4Address
//

class IP4Address : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    IP4Address(const void* info) : Inherited(info) {}
  public:
    IP4Address() : Inherited(&theInfo) {}
    IP4Address(const IP4Address & other) : Inherited(other)
    {}
    IP4Address& operator = (const IP4Address& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_portNumber
    };

    class address {
      public:
        typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 4, 4> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class address
    address::const_reference get_address () const;
    address::reference ref_address ();
    address::reference set_address ();
    address::reference set_address (const std::vector<char>& value);
    class portNumber {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class portNumber
    portNumber::const_reference get_portNumber () const;
    portNumber::reference ref_portNumber ();
    portNumber::reference set_portNumber ();
    portNumber::reference set_portNumber (portNumber::value_type::int_type value);
    void omit_portNumber ();
    bool portNumber_isPresent () const;
    void swap(IP4Address& other);
    IP4Address * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// IP6Address
//

class IP6Address : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    IP6Address(const void* info) : Inherited(info) {}
  public:
    IP6Address() : Inherited(&theInfo) {}
    IP6Address(const IP6Address & other) : Inherited(other)
    {}
    IP6Address& operator = (const IP6Address& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_portNumber
    };

    class address {
      public:
        typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 16, 16> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class address
    address::const_reference get_address () const;
    address::reference ref_address ();
    address::reference set_address ();
    address::reference set_address (const std::vector<char>& value);
    class portNumber {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class portNumber
    portNumber::const_reference get_portNumber () const;
    portNumber::reference ref_portNumber ();
    portNumber::reference set_portNumber ();
    portNumber::reference set_portNumber (portNumber::value_type::int_type value);
    void omit_portNumber ();
    bool portNumber_isPresent () const;
    void swap(IP6Address& other);
    IP6Address * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// PathName
//

class PathName : public ASN1::IA5String
{
    typedef ASN1::IA5String Inherited;
  protected:
    PathName(const void* info) : Inherited(info) {}
  public:
    PathName() : Inherited(&theInfo) { }
    PathName(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
    PathName(const char* str, const void* info = &theInfo) : Inherited(str, info) { }
    PathName(const PathName& other) : Inherited(other) {}
    PathName& operator = (const std::string& other)
    { Inherited::operator=(other); return *this;}
    PathName& operator = (const char* other)
    { Inherited::operator=(other); return *this;}
    PathName * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
};

typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 4294967295U>  TransactionId;

//
// TransactionPending
//

class TransactionPending : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    TransactionPending(const void* info) : Inherited(info) {}
  public:
    TransactionPending() : Inherited(&theInfo) {}
    TransactionPending(const TransactionPending & other) : Inherited(other)
    {}
    TransactionPending& operator = (const TransactionPending& other)
    { Inherited::operator = (other); return *this; } 
    class transactionId {
      public:
        typedef TransactionId value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class transactionId
    transactionId::const_reference get_transactionId () const;
    transactionId::reference ref_transactionId ();
    transactionId::reference set_transactionId ();
    transactionId::reference set_transactionId (transactionId::value_type::int_type value);
    void swap(TransactionPending& other);
    TransactionPending * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// TransactionResponseAck
//

class TransactionResponseAck : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    TransactionResponseAck(const void* info) : Inherited(info) {}
  public:
    TransactionResponseAck() : Inherited(&theInfo) {}
    TransactionResponseAck(const TransactionResponseAck & other) : Inherited(other)
    {}
    TransactionResponseAck& operator = (const TransactionResponseAck& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_lastAck
    };

    class firstAck {
      public:
        typedef TransactionId value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class firstAck
    firstAck::const_reference get_firstAck () const;
    firstAck::reference ref_firstAck ();
    firstAck::reference set_firstAck ();
    firstAck::reference set_firstAck (firstAck::value_type::int_type value);
    class lastAck {
      public:
        typedef TransactionId value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class lastAck
    lastAck::const_reference get_lastAck () const;
    lastAck::reference ref_lastAck ();
    lastAck::reference set_lastAck ();
    lastAck::reference set_lastAck (lastAck::value_type::int_type value);
    void omit_lastAck ();
    bool lastAck_isPresent () const;
    void swap(TransactionResponseAck& other);
    TransactionResponseAck * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  ErrorCode;

typedef ASN1::IA5String ErrorText;

typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 4294967295U>  ContextID;

//
// ContextAttrAuditRequest
//

class ContextAttrAuditRequest : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ContextAttrAuditRequest(const void* info) : Inherited(info) {}
  public:
    ContextAttrAuditRequest() : Inherited(&theInfo) {}
    ContextAttrAuditRequest(const ContextAttrAuditRequest & other) : Inherited(other)
    {}
    ContextAttrAuditRequest& operator = (const ContextAttrAuditRequest& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_topology,
      e_emergency,
      e_priority
    };

    class topology {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class topology
    topology::reference set_topology ();
    void omit_topology ();
    bool topology_isPresent () const;
    class emergency {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class emergency
    emergency::reference set_emergency ();
    void omit_emergency ();
    bool emergency_isPresent () const;
    class priority {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class priority
    priority::reference set_priority ();
    void omit_priority ();
    bool priority_isPresent () const;
    void swap(ContextAttrAuditRequest& other);
    ContextAttrAuditRequest * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// AuditDescriptor
//

class AuditDescriptor : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    AuditDescriptor(const void* info) : Inherited(info) {}
  public:
    AuditDescriptor() : Inherited(&theInfo) {}
    AuditDescriptor(const AuditDescriptor & other) : Inherited(other)
    {}
    AuditDescriptor& operator = (const AuditDescriptor& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_auditToken
    };

    class auditToken {
      public:
        typedef ASN1::BIT_STRING value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class auditToken
    auditToken::const_reference get_auditToken () const;
    auditToken::reference ref_auditToken ();
    auditToken::reference set_auditToken ();
    auditToken::reference set_auditToken (auditToken::const_reference value);
    void omit_auditToken ();
    bool auditToken_isPresent () const;
    void swap(AuditDescriptor& other);
    AuditDescriptor * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 1> >  WildcardField;

//
// TerminationID
//

class TerminationID : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    TerminationID(const void* info) : Inherited(info) {}
  public:
    TerminationID() : Inherited(&theInfo) {}
    TerminationID(const TerminationID & other) : Inherited(other)
    {}
    TerminationID& operator = (const TerminationID& other)
    { Inherited::operator = (other); return *this; } 
    class wildcard {
      public:
        typedef ASN1::SEQUENCE_OF<WildcardField>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class wildcard
    wildcard::const_reference get_wildcard () const;
    wildcard::reference ref_wildcard ();
    wildcard::reference set_wildcard ();
    wildcard::reference set_wildcard (wildcard::const_reference value);
    class id {
      public:
        typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 8> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class id
    id::const_reference get_id () const;
    id::reference ref_id ();
    id::reference set_id ();
    id::reference set_id (const std::vector<char>& value);
    void swap(TerminationID& other);
    TerminationID * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

typedef ASN1::SEQUENCE_OF<TerminationID>  TerminationIDList;

//
// StreamMode
//

class StreamMode : public ASN1::ENUMERATED
{
    typedef ASN1::ENUMERATED Inherited;
  protected:
    StreamMode(const void* info) : Inherited(info) {}
  public:
    StreamMode() : Inherited(&theInfo) { }
    enum NamedNumber {
      unknownEnumeration_ = -1,
      sendOnly,
      recvOnly,
      sendRecv,
      inactive,
      loopBack
    };

    bool is_sendOnly() const { return value == sendOnly; }
    void set_sendOnly() { value = sendOnly; }

    bool is_recvOnly() const { return value == recvOnly; }
    void set_recvOnly() { value = recvOnly; }

    bool is_sendRecv() const { return value == sendRecv; }
    void set_sendRecv() { value = sendRecv; }

    bool is_inactive() const { return value == inactive; }
    void set_inactive() { value = inactive; }

    bool is_loopBack() const { return value == loopBack; }
    void set_loopBack() { value = loopBack; }

    StreamMode(const NamedNumber value) : Inherited(&theInfo){ setFromInt(value); }
    StreamMode & operator=(const NamedNumber v) { setFromInt(v);  return *this; }
    operator NamedNumber() const
    { return NamedNumber(asInt()); }

    void swap (StreamMode & other)
    { ENUMERATED::swap(other); }
    StreamMode * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
};

typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 2, 2> >  Name;

typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 4, 4> >  PkgdName;

//
// Relation
//

class Relation : public ASN1::ENUMERATED
{
    typedef ASN1::ENUMERATED Inherited;
  protected:
    Relation(const void* info) : Inherited(info) {}
  public:
    Relation() : Inherited(&theInfo) { }
    enum NamedNumber {
      unknownEnumeration_ = -1,
      greaterThan,
      smallerThan,
      unequalTo
    };

    bool is_greaterThan() const { return value == greaterThan; }
    void set_greaterThan() { value = greaterThan; }

    bool is_smallerThan() const { return value == smallerThan; }
    void set_smallerThan() { value = smallerThan; }

    bool is_unequalTo() const { return value == unequalTo; }
    void set_unequalTo() { value = unequalTo; }

    Relation(const NamedNumber value) : Inherited(&theInfo){ setFromInt(value); }
    Relation & operator=(const NamedNumber v) { setFromInt(v);  return *this; }
    operator NamedNumber() const
    { return NamedNumber(asInt()); }

    void swap (Relation & other)
    { ENUMERATED::swap(other); }
    Relation * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
};

//
// EventBufferControl
//

class EventBufferControl : public ASN1::ENUMERATED
{
    typedef ASN1::ENUMERATED Inherited;
  protected:
    EventBufferControl(const void* info) : Inherited(info) {}
  public:
    EventBufferControl() : Inherited(&theInfo) { }
    enum NamedNumber {
      unknownEnumeration_ = -1,
      off,
      lockStep
    };

    bool is_off() const { return value == off; }
    void set_off() { value = off; }

    bool is_lockStep() const { return value == lockStep; }
    void set_lockStep() { value = lockStep; }

    EventBufferControl(const NamedNumber value) : Inherited(&theInfo){ setFromInt(value); }
    EventBufferControl & operator=(const NamedNumber v) { setFromInt(v);  return *this; }
    operator NamedNumber() const
    { return NamedNumber(asInt()); }

    void swap (EventBufferControl & other)
    { ENUMERATED::swap(other); }
    EventBufferControl * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
};

//
// ServiceState
//

class ServiceState : public ASN1::ENUMERATED
{
    typedef ASN1::ENUMERATED Inherited;
  protected:
    ServiceState(const void* info) : Inherited(info) {}
  public:
    ServiceState() : Inherited(&theInfo) { }
    enum NamedNumber {
      unknownEnumeration_ = -1,
      test,
      outOfSvc,
      inSvc
    };

    bool is_test() const { return value == test; }
    void set_test() { value = test; }

    bool is_outOfSvc() const { return value == outOfSvc; }
    void set_outOfSvc() { value = outOfSvc; }

    bool is_inSvc() const { return value == inSvc; }
    void set_inSvc() { value = inSvc; }

    ServiceState(const NamedNumber value) : Inherited(&theInfo){ setFromInt(value); }
    ServiceState & operator=(const NamedNumber v) { setFromInt(v);  return *this; }
    operator NamedNumber() const
    { return NamedNumber(asInt()); }

    void swap (ServiceState & other)
    { ENUMERATED::swap(other); }
    ServiceState * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
};

//
// MuxType
//

class MuxType : public ASN1::ENUMERATED
{
    typedef ASN1::ENUMERATED Inherited;
  protected:
    MuxType(const void* info) : Inherited(info) {}
  public:
    MuxType() : Inherited(&theInfo) { }
    enum NamedNumber {
      unknownEnumeration_ = -1,
      h221,
      h223,
      h226,
      v76
    };

    bool is_h221() const { return value == h221; }
    void set_h221() { value = h221; }

    bool is_h223() const { return value == h223; }
    void set_h223() { value = h223; }

    bool is_h226() const { return value == h226; }
    void set_h226() { value = h226; }

    bool is_v76() const { return value == v76; }
    void set_v76() { value = v76; }

    MuxType(const NamedNumber value) : Inherited(&theInfo){ setFromInt(value); }
    MuxType & operator=(const NamedNumber v) { setFromInt(v);  return *this; }
    operator NamedNumber() const
    { return NamedNumber(asInt()); }

    void swap (MuxType & other)
    { ENUMERATED::swap(other); }
    MuxType * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
};

typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  StreamID;

//
// SignalType
//

class SignalType : public ASN1::ENUMERATED
{
    typedef ASN1::ENUMERATED Inherited;
  protected:
    SignalType(const void* info) : Inherited(info) {}
  public:
    SignalType() : Inherited(&theInfo) { }
    enum NamedNumber {
      unknownEnumeration_ = -1,
      brief,
      onOff,
      timeOut
    };

    bool is_brief() const { return value == brief; }
    void set_brief() { value = brief; }

    bool is_onOff() const { return value == onOff; }
    void set_onOff() { value = onOff; }

    bool is_timeOut() const { return value == timeOut; }
    void set_timeOut() { value = timeOut; }

    SignalType(const NamedNumber value) : Inherited(&theInfo){ setFromInt(value); }
    SignalType & operator=(const NamedNumber v) { setFromInt(v);  return *this; }
    operator NamedNumber() const
    { return NamedNumber(asInt()); }

    void swap (SignalType & other)
    { ENUMERATED::swap(other); }
    SignalType * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
};

typedef PkgdName SignalName;
typedef ASN1::BIT_STRING NotifyCompletion;

typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 4294967295U>  RequestID;

//
// ModemType
//

class ModemType : public ASN1::ENUMERATED
{
    typedef ASN1::ENUMERATED Inherited;
  protected:
    ModemType(const void* info) : Inherited(info) {}
  public:
    ModemType() : Inherited(&theInfo) { }
    enum NamedNumber {
      unknownEnumeration_ = -1,
      v18,
      v22,
      v22bis,
      v32,
      v32bis,
      v34,
      v90,
      v91,
      synchISDN
    };

    bool is_v18() const { return value == v18; }
    void set_v18() { value = v18; }

    bool is_v22() const { return value == v22; }
    void set_v22() { value = v22; }

    bool is_v22bis() const { return value == v22bis; }
    void set_v22bis() { value = v22bis; }

    bool is_v32() const { return value == v32; }
    void set_v32() { value = v32; }

    bool is_v32bis() const { return value == v32bis; }
    void set_v32bis() { value = v32bis; }

    bool is_v34() const { return value == v34; }
    void set_v34() { value = v34; }

    bool is_v90() const { return value == v90; }
    void set_v90() { value = v90; }

    bool is_v91() const { return value == v91; }
    void set_v91() { value = v91; }

    bool is_synchISDN() const { return value == synchISDN; }
    void set_synchISDN() { value = synchISDN; }

    ModemType(const NamedNumber value) : Inherited(&theInfo){ setFromInt(value); }
    ModemType & operator=(const NamedNumber v) { setFromInt(v);  return *this; }
    operator NamedNumber() const
    { return NamedNumber(asInt()); }

    void swap (ModemType & other)
    { ENUMERATED::swap(other); }
    ModemType * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
};

typedef Name DigitMapName;
//
// DigitMapValue
//

class DigitMapValue : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    DigitMapValue(const void* info) : Inherited(info) {}
  public:
    DigitMapValue() : Inherited(&theInfo) {}
    DigitMapValue(const DigitMapValue & other) : Inherited(other)
    {}
    DigitMapValue& operator = (const DigitMapValue& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_startTimer,
      e_shortTimer,
      e_longTimer
    };

    class startTimer {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 99>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class startTimer
    startTimer::const_reference get_startTimer () const;
    startTimer::reference ref_startTimer ();
    startTimer::reference set_startTimer ();
    startTimer::reference set_startTimer (startTimer::value_type::int_type value);
    void omit_startTimer ();
    bool startTimer_isPresent () const;
    class shortTimer {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 99>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class shortTimer
    shortTimer::const_reference get_shortTimer () const;
    shortTimer::reference ref_shortTimer ();
    shortTimer::reference set_shortTimer ();
    shortTimer::reference set_shortTimer (shortTimer::value_type::int_type value);
    void omit_shortTimer ();
    bool shortTimer_isPresent () const;
    class longTimer {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 99>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class longTimer
    longTimer::const_reference get_longTimer () const;
    longTimer::reference ref_longTimer ();
    longTimer::reference set_longTimer ();
    longTimer::reference set_longTimer (longTimer::value_type::int_type value);
    void omit_longTimer ();
    bool longTimer_isPresent () const;
    class digitMapBody {
      public:
        typedef ASN1::IA5String value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class digitMapBody
    digitMapBody::const_reference get_digitMapBody () const;
    digitMapBody::reference ref_digitMapBody ();
    digitMapBody::reference set_digitMapBody ();
    digitMapBody::reference set_digitMapBody (const std::string& value);
    void swap(DigitMapValue& other);
    DigitMapValue * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// ServiceChangeAddress
//

class ServiceChangeAddress : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    ServiceChangeAddress(const void* info) : Inherited(info) {}
  public:
    ServiceChangeAddress() : Inherited(&theInfo) {}
    class portNumber {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class portNumber

    portNumber::const_reference get_portNumber () const;
    portNumber::reference ref_portNumber (); 
    portNumber::reference select_portNumber (); 
    portNumber::reference select_portNumber (portNumber::value_type::int_type value); 
    bool portNumber_isSelected() const;

    class ip4Address {
      public:
        enum Id { id_ = 1 };
        typedef IP4Address value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class ip4Address

    ip4Address::const_reference get_ip4Address () const;
    ip4Address::reference ref_ip4Address (); 
    ip4Address::reference select_ip4Address (); 
    ip4Address::reference select_ip4Address (ip4Address::const_reference value); 
    bool ip4Address_isSelected() const;

    class ip6Address {
      public:
        enum Id { id_ = 2 };
        typedef IP6Address value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class ip6Address

    ip6Address::const_reference get_ip6Address () const;
    ip6Address::reference ref_ip6Address (); 
    ip6Address::reference select_ip6Address (); 
    ip6Address::reference select_ip6Address (ip6Address::const_reference value); 
    bool ip6Address_isSelected() const;

    class domainName {
      public:
        enum Id { id_ = 3 };
        typedef DomainName value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class domainName

    domainName::const_reference get_domainName () const;
    domainName::reference ref_domainName (); 
    domainName::reference select_domainName (); 
    domainName::reference select_domainName (domainName::const_reference value); 
    bool domainName_isSelected() const;

    class deviceName {
      public:
        enum Id { id_ = 4 };
        typedef PathName value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class deviceName

    deviceName::const_reference get_deviceName () const;
    deviceName::reference ref_deviceName (); 
    deviceName::reference select_deviceName (); 
    deviceName::reference select_deviceName (const std::string& value); 
    bool deviceName_isSelected() const;

    class mtpAddress {
      public:
        enum Id { id_ = 5 };
        typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 2, 2> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mtpAddress

    mtpAddress::const_reference get_mtpAddress () const;
    mtpAddress::reference ref_mtpAddress (); 
    mtpAddress::reference select_mtpAddress (); 
    mtpAddress::reference select_mtpAddress (const std::vector<char>& value); 
    bool mtpAddress_isSelected() const;

    ServiceChangeAddress(portNumber::Id id, portNumber::value_type::int_type value);
    ServiceChangeAddress(ip4Address::Id id, ip4Address::const_reference value);
    ServiceChangeAddress(ip6Address::Id id, ip6Address::const_reference value);
    ServiceChangeAddress(domainName::Id id, domainName::const_reference value);
    ServiceChangeAddress(deviceName::Id id, const std::string& value);
    ServiceChangeAddress(mtpAddress::Id id, const std::vector<char>& value);
    void swap(ServiceChangeAddress & other);
    ServiceChangeAddress(const ServiceChangeAddress & other)
    : Inherited(other) {} 

    ServiceChangeAddress & operator = (const ServiceChangeAddress & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    ServiceChangeAddress * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[6];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[6];
#endif
};

//
// ServiceChangeMethod
//

class ServiceChangeMethod : public ASN1::ENUMERATED
{
    typedef ASN1::ENUMERATED Inherited;
  protected:
    ServiceChangeMethod(const void* info) : Inherited(info) {}
  public:
    ServiceChangeMethod() : Inherited(&theInfo) { }
    enum NamedNumber {
      unknownEnumeration_ = -1,
      failover,
      forced,
      graceful,
      restart,
      disconnected,
      handOff
    };

    bool is_failover() const { return value == failover; }
    void set_failover() { value = failover; }

    bool is_forced() const { return value == forced; }
    void set_forced() { value = forced; }

    bool is_graceful() const { return value == graceful; }
    void set_graceful() { value = graceful; }

    bool is_restart() const { return value == restart; }
    void set_restart() { value = restart; }

    bool is_disconnected() const { return value == disconnected; }
    void set_disconnected() { value = disconnected; }

    bool is_handOff() const { return value == handOff; }
    void set_handOff() { value = handOff; }

    ServiceChangeMethod(const NamedNumber value) : Inherited(&theInfo){ setFromInt(value); }
    ServiceChangeMethod & operator=(const NamedNumber v) { setFromInt(v);  return *this; }
    operator NamedNumber() const
    { return NamedNumber(asInt()); }

    void swap (ServiceChangeMethod & other)
    { ENUMERATED::swap(other); }
    ServiceChangeMethod * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
};

//
// ServiceChangeProfile
//

class ServiceChangeProfile : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ServiceChangeProfile(const void* info) : Inherited(info) {}
  public:
    ServiceChangeProfile() : Inherited(&theInfo) {}
    ServiceChangeProfile(const ServiceChangeProfile & other) : Inherited(other)
    {}
    ServiceChangeProfile& operator = (const ServiceChangeProfile& other)
    { Inherited::operator = (other); return *this; } 
    class profileName {
      public:
        typedef Name value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class profileName
    profileName::const_reference get_profileName () const;
    profileName::reference ref_profileName ();
    profileName::reference set_profileName ();
    profileName::reference set_profileName (const std::vector<char>& value);
    class version {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 99>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class version
    version::const_reference get_version () const;
    version::reference ref_version ();
    version::reference set_version ();
    version::reference set_version (version::value_type::int_type value);
    void swap(ServiceChangeProfile& other);
    ServiceChangeProfile * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// PackagesItem
//

class PackagesItem : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    PackagesItem(const void* info) : Inherited(info) {}
  public:
    PackagesItem() : Inherited(&theInfo) {}
    PackagesItem(const PackagesItem & other) : Inherited(other)
    {}
    PackagesItem& operator = (const PackagesItem& other)
    { Inherited::operator = (other); return *this; } 
    class packageName {
      public:
        typedef Name value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class packageName
    packageName::const_reference get_packageName () const;
    packageName::reference ref_packageName ();
    packageName::reference set_packageName ();
    packageName::reference set_packageName (const std::vector<char>& value);
    class packageVersion {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 99>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class packageVersion
    packageVersion::const_reference get_packageVersion () const;
    packageVersion::reference ref_packageVersion ();
    packageVersion::reference set_packageVersion ();
    packageVersion::reference set_packageVersion (packageVersion::value_type::int_type value);
    void swap(PackagesItem& other);
    PackagesItem * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// H221NonStandard
//

class H221NonStandard : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    H221NonStandard(const void* info) : Inherited(info) {}
  public:
    H221NonStandard() : Inherited(&theInfo) {}
    H221NonStandard(const H221NonStandard & other) : Inherited(other)
    {}
    H221NonStandard& operator = (const H221NonStandard& other)
    { Inherited::operator = (other); return *this; } 
    class t35CountryCode1 {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 255>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class t35CountryCode1
    t35CountryCode1::const_reference get_t35CountryCode1 () const;
    t35CountryCode1::reference ref_t35CountryCode1 ();
    t35CountryCode1::reference set_t35CountryCode1 ();
    t35CountryCode1::reference set_t35CountryCode1 (t35CountryCode1::value_type::int_type value);
    class t35CountryCode2 {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 255>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class t35CountryCode2
    t35CountryCode2::const_reference get_t35CountryCode2 () const;
    t35CountryCode2::reference ref_t35CountryCode2 ();
    t35CountryCode2::reference set_t35CountryCode2 ();
    t35CountryCode2::reference set_t35CountryCode2 (t35CountryCode2::value_type::int_type value);
    class t35Extension {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 255>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class t35Extension
    t35Extension::const_reference get_t35Extension () const;
    t35Extension::reference ref_t35Extension ();
    t35Extension::reference set_t35Extension ();
    t35Extension::reference set_t35Extension (t35Extension::value_type::int_type value);
    class manufacturerCode {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class manufacturerCode
    manufacturerCode::const_reference get_manufacturerCode () const;
    manufacturerCode::reference ref_manufacturerCode ();
    manufacturerCode::reference set_manufacturerCode ();
    manufacturerCode::reference set_manufacturerCode (manufacturerCode::value_type::int_type value);
    void swap(H221NonStandard& other);
    H221NonStandard * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// TimeNotation
//

class TimeNotation : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    TimeNotation(const void* info) : Inherited(info) {}
  public:
    TimeNotation() : Inherited(&theInfo) {}
    TimeNotation(const TimeNotation & other) : Inherited(other)
    {}
    TimeNotation& operator = (const TimeNotation& other)
    { Inherited::operator = (other); return *this; } 
    class date {
      public:
        class value_type : public ASN1::IA5String
        {
            typedef ASN1::IA5String Inherited;
          protected:
            value_type(const void* info) : Inherited(info) {}
          public:
            value_type() : Inherited(&theInfo) { }
            value_type(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const char* str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const value_type& other) : Inherited(other) {}
            value_type& operator = (const std::string& other)
            { Inherited::operator=(other); return *this;}
            value_type& operator = (const char* other)
            { Inherited::operator=(other); return *this;}
            value_type * clone() const;
            static bool equal_type(const ASN1::AbstractData&);
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
        };

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class date
    date::const_reference get_date () const;
    date::reference ref_date ();
    date::reference set_date ();
    date::reference set_date (const std::string& value);
    class time {
      public:
        class value_type : public ASN1::IA5String
        {
            typedef ASN1::IA5String Inherited;
          protected:
            value_type(const void* info) : Inherited(info) {}
          public:
            value_type() : Inherited(&theInfo) { }
            value_type(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const char* str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const value_type& other) : Inherited(other) {}
            value_type& operator = (const std::string& other)
            { Inherited::operator=(other); return *this;}
            value_type& operator = (const char* other)
            { Inherited::operator=(other); return *this;}
            value_type * clone() const;
            static bool equal_type(const ASN1::AbstractData&);
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
        };

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class time
    time::const_reference get_time () const;
    time::reference ref_time ();
    time::reference set_time ();
    time::reference set_time (const std::string& value);
    void swap(TimeNotation& other);
    TimeNotation * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

typedef ASN1::OCTET_STRING Value;

//
// TopologyRequest_topologyDirection
//

class TopologyRequest_topologyDirection : public ASN1::ENUMERATED
{
    typedef ASN1::ENUMERATED Inherited;
  protected:
    TopologyRequest_topologyDirection(const void* info) : Inherited(info) {}
  public:
    TopologyRequest_topologyDirection() : Inherited(&theInfo) { }
    enum NamedNumber {
      unknownEnumeration_ = -1,
      bothway,
      isolate,
      oneway
    };

    bool is_bothway() const { return value == bothway; }
    void set_bothway() { value = bothway; }

    bool is_isolate() const { return value == isolate; }
    void set_isolate() { value = isolate; }

    bool is_oneway() const { return value == oneway; }
    void set_oneway() { value = oneway; }

    TopologyRequest_topologyDirection(const NamedNumber value) : Inherited(&theInfo){ setFromInt(value); }
    TopologyRequest_topologyDirection & operator=(const NamedNumber v) { setFromInt(v);  return *this; }
    operator NamedNumber() const
    { return NamedNumber(asInt()); }

    void swap (TopologyRequest_topologyDirection & other)
    { ENUMERATED::swap(other); }
    TopologyRequest_topologyDirection * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
};

//
// PropertyParm_extraInfo
//

class PropertyParm_extraInfo : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    PropertyParm_extraInfo(const void* info) : Inherited(info) {}
  public:
    PropertyParm_extraInfo() : Inherited(&theInfo) {}
    class relation {
      public:
        enum Id { id_ = 0 };
        typedef Relation value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class relation

    relation::const_reference get_relation () const;
    relation::reference ref_relation (); 
    relation::reference select_relation (); 
    relation::reference select_relation (relation::value_type::NamedNumber value); 
    bool relation_isSelected() const;

    class range {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class range

    range::const_reference get_range () const;
    range::reference ref_range (); 
    range::reference select_range (); 
    range::reference select_range (bool value); 
    bool range_isSelected() const;

    class sublist {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sublist

    sublist::const_reference get_sublist () const;
    sublist::reference ref_sublist (); 
    sublist::reference select_sublist (); 
    sublist::reference select_sublist (bool value); 
    bool sublist_isSelected() const;

    PropertyParm_extraInfo(relation::Id id, relation::value_type::NamedNumber value);
    PropertyParm_extraInfo(range::Id id, bool value);
    PropertyParm_extraInfo(sublist::Id id, bool value);
    void swap(PropertyParm_extraInfo & other);
    PropertyParm_extraInfo(const PropertyParm_extraInfo & other)
    : Inherited(other) {} 

    PropertyParm_extraInfo & operator = (const PropertyParm_extraInfo & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    PropertyParm_extraInfo * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// AuthenticationHeader
//

class AuthenticationHeader : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    AuthenticationHeader(const void* info) : Inherited(info) {}
  public:
    AuthenticationHeader() : Inherited(&theInfo) {}
    AuthenticationHeader(const AuthenticationHeader & other) : Inherited(other)
    {}
    AuthenticationHeader& operator = (const AuthenticationHeader& other)
    { Inherited::operator = (other); return *this; } 
    class secParmIndex {
      public:
        typedef SecurityParmIndex value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class secParmIndex
    secParmIndex::const_reference get_secParmIndex () const;
    secParmIndex::reference ref_secParmIndex ();
    secParmIndex::reference set_secParmIndex ();
    secParmIndex::reference set_secParmIndex (const std::vector<char>& value);
    class seqNum {
      public:
        typedef SequenceNum value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class seqNum
    seqNum::const_reference get_seqNum () const;
    seqNum::reference ref_seqNum ();
    seqNum::reference set_seqNum ();
    seqNum::reference set_seqNum (const std::vector<char>& value);
    class ad {
      public:
        typedef AuthData value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class ad
    ad::const_reference get_ad () const;
    ad::reference ref_ad ();
    ad::reference set_ad ();
    ad::reference set_ad (const std::vector<char>& value);
    void swap(AuthenticationHeader& other);
    AuthenticationHeader * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// MId
//

class MId : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    MId(const void* info) : Inherited(info) {}
  public:
    MId() : Inherited(&theInfo) {}
    class ip4Address {
      public:
        enum Id { id_ = 0 };
        typedef IP4Address value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class ip4Address

    ip4Address::const_reference get_ip4Address () const;
    ip4Address::reference ref_ip4Address (); 
    ip4Address::reference select_ip4Address (); 
    ip4Address::reference select_ip4Address (ip4Address::const_reference value); 
    bool ip4Address_isSelected() const;

    class ip6Address {
      public:
        enum Id { id_ = 1 };
        typedef IP6Address value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class ip6Address

    ip6Address::const_reference get_ip6Address () const;
    ip6Address::reference ref_ip6Address (); 
    ip6Address::reference select_ip6Address (); 
    ip6Address::reference select_ip6Address (ip6Address::const_reference value); 
    bool ip6Address_isSelected() const;

    class domainName {
      public:
        enum Id { id_ = 2 };
        typedef DomainName value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class domainName

    domainName::const_reference get_domainName () const;
    domainName::reference ref_domainName (); 
    domainName::reference select_domainName (); 
    domainName::reference select_domainName (domainName::const_reference value); 
    bool domainName_isSelected() const;

    class deviceName {
      public:
        enum Id { id_ = 3 };
        typedef PathName value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class deviceName

    deviceName::const_reference get_deviceName () const;
    deviceName::reference ref_deviceName (); 
    deviceName::reference select_deviceName (); 
    deviceName::reference select_deviceName (const std::string& value); 
    bool deviceName_isSelected() const;

    class mtpAddress {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 2, 2> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mtpAddress

    mtpAddress::const_reference get_mtpAddress () const;
    mtpAddress::reference ref_mtpAddress (); 
    mtpAddress::reference select_mtpAddress (); 
    mtpAddress::reference select_mtpAddress (const std::vector<char>& value); 
    bool mtpAddress_isSelected() const;

    MId(ip4Address::Id id, ip4Address::const_reference value);
    MId(ip6Address::Id id, ip6Address::const_reference value);
    MId(domainName::Id id, domainName::const_reference value);
    MId(deviceName::Id id, const std::string& value);
    MId(mtpAddress::Id id, const std::vector<char>& value);
    void swap(MId & other);
    MId(const MId & other)
    : Inherited(other) {} 

    MId & operator = (const MId & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    MId * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[5];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[5];
#endif
};

//
// ErrorDescriptor
//

class ErrorDescriptor : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ErrorDescriptor(const void* info) : Inherited(info) {}
  public:
    ErrorDescriptor() : Inherited(&theInfo) {}
    ErrorDescriptor(const ErrorDescriptor & other) : Inherited(other)
    {}
    ErrorDescriptor& operator = (const ErrorDescriptor& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_errorText
    };

    class errorCode {
      public:
        typedef ErrorCode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class errorCode
    errorCode::const_reference get_errorCode () const;
    errorCode::reference ref_errorCode ();
    errorCode::reference set_errorCode ();
    errorCode::reference set_errorCode (errorCode::value_type::int_type value);
    class errorText {
      public:
        typedef ErrorText value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class errorText
    errorText::const_reference get_errorText () const;
    errorText::reference ref_errorText ();
    errorText::reference set_errorText ();
    errorText::reference set_errorText (const std::string& value);
    void omit_errorText ();
    bool errorText_isPresent () const;
    void swap(ErrorDescriptor& other);
    ErrorDescriptor * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// TopologyRequest
//

class TopologyRequest : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    TopologyRequest(const void* info) : Inherited(info) {}
  public:
    TopologyRequest() : Inherited(&theInfo) {}
    TopologyRequest(const TopologyRequest & other) : Inherited(other)
    {}
    TopologyRequest& operator = (const TopologyRequest& other)
    { Inherited::operator = (other); return *this; } 
    class terminationFrom {
      public:
        typedef TerminationID value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminationFrom
    terminationFrom::const_reference get_terminationFrom () const;
    terminationFrom::reference ref_terminationFrom ();
    terminationFrom::reference set_terminationFrom ();
    terminationFrom::reference set_terminationFrom (terminationFrom::const_reference value);
    class terminationTo {
      public:
        typedef TerminationID value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminationTo
    terminationTo::const_reference get_terminationTo () const;
    terminationTo::reference ref_terminationTo ();
    terminationTo::reference set_terminationTo ();
    terminationTo::reference set_terminationTo (terminationTo::const_reference value);
    class topologyDirection {
      public:
        typedef TopologyRequest_topologyDirection value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class topologyDirection
    topologyDirection::const_reference get_topologyDirection () const;
    topologyDirection::reference ref_topologyDirection ();
    topologyDirection::reference set_topologyDirection ();
    topologyDirection::reference set_topologyDirection (topologyDirection::value_type::NamedNumber value);
    void swap(TopologyRequest& other);
    TopologyRequest * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// SubtractRequest
//

class SubtractRequest : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    SubtractRequest(const void* info) : Inherited(info) {}
  public:
    SubtractRequest() : Inherited(&theInfo) {}
    SubtractRequest(const SubtractRequest & other) : Inherited(other)
    {}
    SubtractRequest& operator = (const SubtractRequest& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_auditDescriptor
    };

    class terminationID {
      public:
        typedef TerminationIDList value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminationID
    terminationID::const_reference get_terminationID () const;
    terminationID::reference ref_terminationID ();
    terminationID::reference set_terminationID ();
    terminationID::reference set_terminationID (terminationID::const_reference value);
    class auditDescriptor {
      public:
        typedef AuditDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class auditDescriptor
    auditDescriptor::const_reference get_auditDescriptor () const;
    auditDescriptor::reference ref_auditDescriptor ();
    auditDescriptor::reference set_auditDescriptor ();
    auditDescriptor::reference set_auditDescriptor (auditDescriptor::const_reference value);
    void omit_auditDescriptor ();
    bool auditDescriptor_isPresent () const;
    void swap(SubtractRequest& other);
    SubtractRequest * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// AuditRequest
//

class AuditRequest : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    AuditRequest(const void* info) : Inherited(info) {}
  public:
    AuditRequest() : Inherited(&theInfo) {}
    AuditRequest(const AuditRequest & other) : Inherited(other)
    {}
    AuditRequest& operator = (const AuditRequest& other)
    { Inherited::operator = (other); return *this; } 
    class terminationID {
      public:
        typedef TerminationID value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminationID
    terminationID::const_reference get_terminationID () const;
    terminationID::reference ref_terminationID ();
    terminationID::reference set_terminationID ();
    terminationID::reference set_terminationID (terminationID::const_reference value);
    class auditDescriptor {
      public:
        typedef AuditDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class auditDescriptor
    auditDescriptor::const_reference get_auditDescriptor () const;
    auditDescriptor::reference ref_auditDescriptor ();
    auditDescriptor::reference set_auditDescriptor ();
    auditDescriptor::reference set_auditDescriptor (auditDescriptor::const_reference value);
    void swap(AuditRequest& other);
    AuditRequest * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// NotifyReply
//

class NotifyReply : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    NotifyReply(const void* info) : Inherited(info) {}
  public:
    NotifyReply() : Inherited(&theInfo) {}
    NotifyReply(const NotifyReply & other) : Inherited(other)
    {}
    NotifyReply& operator = (const NotifyReply& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_terminationID,
      e_errorDescriptor
    };

    class terminationID {
      public:
        typedef TerminationIDList value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminationID
    terminationID::const_reference get_terminationID () const;
    terminationID::reference ref_terminationID ();
    terminationID::reference set_terminationID ();
    terminationID::reference set_terminationID (terminationID::const_reference value);
    void omit_terminationID ();
    bool terminationID_isPresent () const;
    class errorDescriptor {
      public:
        typedef ErrorDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class errorDescriptor
    errorDescriptor::const_reference get_errorDescriptor () const;
    errorDescriptor::reference ref_errorDescriptor ();
    errorDescriptor::reference set_errorDescriptor ();
    errorDescriptor::reference set_errorDescriptor (errorDescriptor::const_reference value);
    void omit_errorDescriptor ();
    bool errorDescriptor_isPresent () const;
    void swap(NotifyReply& other);
    NotifyReply * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

typedef PkgdName EventName;
//
// EventParameter
//

class EventParameter : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    EventParameter(const void* info) : Inherited(info) {}
  public:
    EventParameter() : Inherited(&theInfo) {}
    EventParameter(const EventParameter & other) : Inherited(other)
    {}
    EventParameter& operator = (const EventParameter& other)
    { Inherited::operator = (other); return *this; } 
    class eventParameterName {
      public:
        typedef Name value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class eventParameterName
    eventParameterName::const_reference get_eventParameterName () const;
    eventParameterName::reference ref_eventParameterName ();
    eventParameterName::reference set_eventParameterName ();
    eventParameterName::reference set_eventParameterName (const std::vector<char>& value);
    class value {
      public:
        typedef Value value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class value
    value::const_reference get_value () const;
    value::reference ref_value ();
    value::reference set_value ();
    value::reference set_value (const std::vector<char>& value);
    void swap(EventParameter& other);
    EventParameter * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// PropertyParm
//

class PropertyParm : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    PropertyParm(const void* info) : Inherited(info) {}
  public:
    PropertyParm() : Inherited(&theInfo) {}
    PropertyParm(const PropertyParm & other) : Inherited(other)
    {}
    PropertyParm& operator = (const PropertyParm& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_extraInfo
    };

    class name {
      public:
        typedef PkgdName value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class name
    name::const_reference get_name () const;
    name::reference ref_name ();
    name::reference set_name ();
    name::reference set_name (const std::vector<char>& value);
    class value {
      public:
        typedef ASN1::SEQUENCE_OF<ASN1::OCTET_STRING>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class value
    value::const_reference get_value () const;
    value::reference ref_value ();
    value::reference set_value ();
    value::reference set_value (value::const_reference value);
    class extraInfo {
      public:
        typedef PropertyParm_extraInfo value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class extraInfo
    extraInfo::const_reference get_extraInfo () const;
    extraInfo::reference ref_extraInfo ();
    extraInfo::reference set_extraInfo ();
    extraInfo::reference set_extraInfo (extraInfo::const_reference value);
    void omit_extraInfo ();
    bool extraInfo_isPresent () const;
    void swap(PropertyParm& other);
    PropertyParm * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

typedef ASN1::SEQUENCE_OF<PropertyParm>  PropertyGroup;

//
// TerminationStateDescriptor
//

class TerminationStateDescriptor : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    TerminationStateDescriptor(const void* info) : Inherited(info) {}
  public:
    TerminationStateDescriptor() : Inherited(&theInfo) {}
    TerminationStateDescriptor(const TerminationStateDescriptor & other) : Inherited(other)
    {}
    TerminationStateDescriptor& operator = (const TerminationStateDescriptor& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_eventBufferControl,
      e_serviceState
    };

    class propertyParms {
      public:
        typedef ASN1::SEQUENCE_OF<PropertyParm>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class propertyParms
    propertyParms::const_reference get_propertyParms () const;
    propertyParms::reference ref_propertyParms ();
    propertyParms::reference set_propertyParms ();
    propertyParms::reference set_propertyParms (propertyParms::const_reference value);
    class eventBufferControl {
      public:
        typedef EventBufferControl value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class eventBufferControl
    eventBufferControl::const_reference get_eventBufferControl () const;
    eventBufferControl::reference ref_eventBufferControl ();
    eventBufferControl::reference set_eventBufferControl ();
    eventBufferControl::reference set_eventBufferControl (eventBufferControl::value_type::NamedNumber value);
    void omit_eventBufferControl ();
    bool eventBufferControl_isPresent () const;
    class serviceState {
      public:
        typedef ServiceState value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceState
    serviceState::const_reference get_serviceState () const;
    serviceState::reference ref_serviceState ();
    serviceState::reference set_serviceState ();
    serviceState::reference set_serviceState (serviceState::value_type::NamedNumber value);
    void omit_serviceState ();
    bool serviceState_isPresent () const;
    void swap(TerminationStateDescriptor& other);
    TerminationStateDescriptor * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// EventDM
//

class EventDM : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    EventDM(const void* info) : Inherited(info) {}
  public:
    EventDM() : Inherited(&theInfo) {}
    class digitMapName {
      public:
        enum Id { id_ = 0 };
        typedef DigitMapName value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class digitMapName

    digitMapName::const_reference get_digitMapName () const;
    digitMapName::reference ref_digitMapName (); 
    digitMapName::reference select_digitMapName (); 
    digitMapName::reference select_digitMapName (const std::vector<char>& value); 
    bool digitMapName_isSelected() const;

    class digitMapValue {
      public:
        enum Id { id_ = 1 };
        typedef DigitMapValue value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class digitMapValue

    digitMapValue::const_reference get_digitMapValue () const;
    digitMapValue::reference ref_digitMapValue (); 
    digitMapValue::reference select_digitMapValue (); 
    digitMapValue::reference select_digitMapValue (digitMapValue::const_reference value); 
    bool digitMapValue_isSelected() const;

    EventDM(digitMapName::Id id, const std::vector<char>& value);
    EventDM(digitMapValue::Id id, digitMapValue::const_reference value);
    void swap(EventDM & other);
    EventDM(const EventDM & other)
    : Inherited(other) {} 

    EventDM & operator = (const EventDM & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    EventDM * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// EventSpec
//

class EventSpec : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    EventSpec(const void* info) : Inherited(info) {}
  public:
    EventSpec() : Inherited(&theInfo) {}
    EventSpec(const EventSpec & other) : Inherited(other)
    {}
    EventSpec& operator = (const EventSpec& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_streamID
    };

    class eventName {
      public:
        typedef EventName value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class eventName
    eventName::const_reference get_eventName () const;
    eventName::reference ref_eventName ();
    eventName::reference set_eventName ();
    eventName::reference set_eventName (const std::vector<char>& value);
    class streamID {
      public:
        typedef StreamID value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class streamID
    streamID::const_reference get_streamID () const;
    streamID::reference ref_streamID ();
    streamID::reference set_streamID ();
    streamID::reference set_streamID (streamID::value_type::int_type value);
    void omit_streamID ();
    bool streamID_isPresent () const;
    class eventParList {
      public:
        typedef ASN1::SEQUENCE_OF<EventParameter>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class eventParList
    eventParList::const_reference get_eventParList () const;
    eventParList::reference ref_eventParList ();
    eventParList::reference set_eventParList ();
    eventParList::reference set_eventParList (eventParList::const_reference value);
    void swap(EventSpec& other);
    EventSpec * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// SigParameter
//

class SigParameter : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    SigParameter(const void* info) : Inherited(info) {}
  public:
    SigParameter() : Inherited(&theInfo) {}
    SigParameter(const SigParameter & other) : Inherited(other)
    {}
    SigParameter& operator = (const SigParameter& other)
    { Inherited::operator = (other); return *this; } 
    class sigParameterName {
      public:
        typedef Name value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sigParameterName
    sigParameterName::const_reference get_sigParameterName () const;
    sigParameterName::reference ref_sigParameterName ();
    sigParameterName::reference set_sigParameterName ();
    sigParameterName::reference set_sigParameterName (const std::vector<char>& value);
    class value {
      public:
        typedef Value value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class value
    value::const_reference get_value () const;
    value::reference ref_value ();
    value::reference set_value ();
    value::reference set_value (const std::vector<char>& value);
    void swap(SigParameter& other);
    SigParameter * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// DigitMapDescriptor
//

class DigitMapDescriptor : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    DigitMapDescriptor(const void* info) : Inherited(info) {}
  public:
    DigitMapDescriptor() : Inherited(&theInfo) {}
    DigitMapDescriptor(const DigitMapDescriptor & other) : Inherited(other)
    {}
    DigitMapDescriptor& operator = (const DigitMapDescriptor& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_digitMapName,
      e_digitMapValue
    };

    class digitMapName {
      public:
        typedef DigitMapName value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class digitMapName
    digitMapName::const_reference get_digitMapName () const;
    digitMapName::reference ref_digitMapName ();
    digitMapName::reference set_digitMapName ();
    digitMapName::reference set_digitMapName (const std::vector<char>& value);
    void omit_digitMapName ();
    bool digitMapName_isPresent () const;
    class digitMapValue {
      public:
        typedef DigitMapValue value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class digitMapValue
    digitMapValue::const_reference get_digitMapValue () const;
    digitMapValue::reference ref_digitMapValue ();
    digitMapValue::reference set_digitMapValue ();
    digitMapValue::reference set_digitMapValue (digitMapValue::const_reference value);
    void omit_digitMapValue ();
    bool digitMapValue_isPresent () const;
    void swap(DigitMapDescriptor& other);
    DigitMapDescriptor * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// ServiceChangeResParm
//

class ServiceChangeResParm : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ServiceChangeResParm(const void* info) : Inherited(info) {}
  public:
    ServiceChangeResParm() : Inherited(&theInfo) {}
    ServiceChangeResParm(const ServiceChangeResParm & other) : Inherited(other)
    {}
    ServiceChangeResParm& operator = (const ServiceChangeResParm& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_serviceChangeMgcId,
      e_serviceChangeAddress,
      e_serviceChangeVersion,
      e_serviceChangeProfile
    };

    class serviceChangeMgcId {
      public:
        typedef MId value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceChangeMgcId
    serviceChangeMgcId::const_reference get_serviceChangeMgcId () const;
    serviceChangeMgcId::reference ref_serviceChangeMgcId ();
    serviceChangeMgcId::reference set_serviceChangeMgcId ();
    serviceChangeMgcId::reference set_serviceChangeMgcId (serviceChangeMgcId::const_reference value);
    void omit_serviceChangeMgcId ();
    bool serviceChangeMgcId_isPresent () const;
    class serviceChangeAddress {
      public:
        typedef ServiceChangeAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceChangeAddress
    serviceChangeAddress::const_reference get_serviceChangeAddress () const;
    serviceChangeAddress::reference ref_serviceChangeAddress ();
    serviceChangeAddress::reference set_serviceChangeAddress ();
    serviceChangeAddress::reference set_serviceChangeAddress (serviceChangeAddress::const_reference value);
    void omit_serviceChangeAddress ();
    bool serviceChangeAddress_isPresent () const;
    class serviceChangeVersion {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 99>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceChangeVersion
    serviceChangeVersion::const_reference get_serviceChangeVersion () const;
    serviceChangeVersion::reference ref_serviceChangeVersion ();
    serviceChangeVersion::reference set_serviceChangeVersion ();
    serviceChangeVersion::reference set_serviceChangeVersion (serviceChangeVersion::value_type::int_type value);
    void omit_serviceChangeVersion ();
    bool serviceChangeVersion_isPresent () const;
    class serviceChangeProfile {
      public:
        typedef ServiceChangeProfile value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceChangeProfile
    serviceChangeProfile::const_reference get_serviceChangeProfile () const;
    serviceChangeProfile::reference ref_serviceChangeProfile ();
    serviceChangeProfile::reference set_serviceChangeProfile ();
    serviceChangeProfile::reference set_serviceChangeProfile (serviceChangeProfile::const_reference value);
    void omit_serviceChangeProfile ();
    bool serviceChangeProfile_isPresent () const;
    void swap(ServiceChangeResParm& other);
    ServiceChangeResParm * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

typedef ASN1::SEQUENCE_OF<PackagesItem>  PackagesDescriptor;

//
// StatisticsParameter
//

class StatisticsParameter : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    StatisticsParameter(const void* info) : Inherited(info) {}
  public:
    StatisticsParameter() : Inherited(&theInfo) {}
    StatisticsParameter(const StatisticsParameter & other) : Inherited(other)
    {}
    StatisticsParameter& operator = (const StatisticsParameter& other)
    { Inherited::operator = (other); return *this; } 
    class statName {
      public:
        typedef PkgdName value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class statName
    statName::const_reference get_statName () const;
    statName::reference ref_statName ();
    statName::reference set_statName ();
    statName::reference set_statName (const std::vector<char>& value);
    class statValue {
      public:
        typedef Value value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class statValue
    statValue::const_reference get_statValue () const;
    statValue::reference ref_statValue ();
    statValue::reference set_statValue ();
    statValue::reference set_statValue (const std::vector<char>& value);
    void swap(StatisticsParameter& other);
    StatisticsParameter * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// NonStandardIdentifier
//

class NonStandardIdentifier : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    NonStandardIdentifier(const void* info) : Inherited(info) {}
  public:
    NonStandardIdentifier() : Inherited(&theInfo) {}
    class object {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::OBJECT_IDENTIFIER value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class object

    object::const_reference get_object () const;
    object::reference ref_object (); 
    object::reference select_object (); 
    object::reference select_object (object::const_reference value); 
    bool object_isSelected() const;

    class h221NonStandard {
      public:
        enum Id { id_ = 1 };
        typedef H221NonStandard value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h221NonStandard

    h221NonStandard::const_reference get_h221NonStandard () const;
    h221NonStandard::reference ref_h221NonStandard (); 
    h221NonStandard::reference select_h221NonStandard (); 
    h221NonStandard::reference select_h221NonStandard (h221NonStandard::const_reference value); 
    bool h221NonStandard_isSelected() const;

    class experimental {
      public:
        enum Id { id_ = 2 };
        class value_type : public ASN1::IA5String
        {
            typedef ASN1::IA5String Inherited;
          protected:
            value_type(const void* info) : Inherited(info) {}
          public:
            value_type() : Inherited(&theInfo) { }
            value_type(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const char* str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const value_type& other) : Inherited(other) {}
            value_type& operator = (const std::string& other)
            { Inherited::operator=(other); return *this;}
            value_type& operator = (const char* other)
            { Inherited::operator=(other); return *this;}
            value_type * clone() const;
            static bool equal_type(const ASN1::AbstractData&);
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
        };

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class experimental

    experimental::const_reference get_experimental () const;
    experimental::reference ref_experimental (); 
    experimental::reference select_experimental (); 
    experimental::reference select_experimental (const std::string& value); 
    bool experimental_isSelected() const;

    NonStandardIdentifier(object::Id id, object::const_reference value);
    NonStandardIdentifier(h221NonStandard::Id id, h221NonStandard::const_reference value);
    NonStandardIdentifier(experimental::Id id, const std::string& value);
    void swap(NonStandardIdentifier & other);
    NonStandardIdentifier(const NonStandardIdentifier & other)
    : Inherited(other) {} 

    NonStandardIdentifier & operator = (const NonStandardIdentifier & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    NonStandardIdentifier * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// ContextRequest
//

class ContextRequest : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ContextRequest(const void* info) : Inherited(info) {}
  public:
    ContextRequest() : Inherited(&theInfo) {}
    ContextRequest(const ContextRequest & other) : Inherited(other)
    {}
    ContextRequest& operator = (const ContextRequest& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_priority,
      e_emergency,
      e_topologyReq
    };

    class priority {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 15>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class priority
    priority::const_reference get_priority () const;
    priority::reference ref_priority ();
    priority::reference set_priority ();
    priority::reference set_priority (priority::value_type::int_type value);
    void omit_priority ();
    bool priority_isPresent () const;
    class emergency {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class emergency
    emergency::const_reference get_emergency () const;
    emergency::reference ref_emergency ();
    emergency::reference set_emergency ();
    emergency::reference set_emergency (bool value);
    void omit_emergency ();
    bool emergency_isPresent () const;
    class topologyReq {
      public:
        typedef ASN1::SEQUENCE_OF<TopologyRequest>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class topologyReq
    topologyReq::const_reference get_topologyReq () const;
    topologyReq::reference ref_topologyReq ();
    topologyReq::reference set_topologyReq ();
    topologyReq::reference set_topologyReq (topologyReq::const_reference value);
    void omit_topologyReq ();
    bool topologyReq_isPresent () const;
    void swap(ContextRequest& other);
    ContextRequest * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// ObservedEvent
//

class ObservedEvent : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ObservedEvent(const void* info) : Inherited(info) {}
  public:
    ObservedEvent() : Inherited(&theInfo) {}
    ObservedEvent(const ObservedEvent & other) : Inherited(other)
    {}
    ObservedEvent& operator = (const ObservedEvent& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_streamID,
      e_timeNotation
    };

    class eventName {
      public:
        typedef EventName value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class eventName
    eventName::const_reference get_eventName () const;
    eventName::reference ref_eventName ();
    eventName::reference set_eventName ();
    eventName::reference set_eventName (const std::vector<char>& value);
    class streamID {
      public:
        typedef StreamID value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class streamID
    streamID::const_reference get_streamID () const;
    streamID::reference ref_streamID ();
    streamID::reference set_streamID ();
    streamID::reference set_streamID (streamID::value_type::int_type value);
    void omit_streamID ();
    bool streamID_isPresent () const;
    class eventParList {
      public:
        typedef ASN1::SEQUENCE_OF<EventParameter>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class eventParList
    eventParList::const_reference get_eventParList () const;
    eventParList::reference ref_eventParList ();
    eventParList::reference set_eventParList ();
    eventParList::reference set_eventParList (eventParList::const_reference value);
    class timeNotation {
      public:
        typedef TimeNotation value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class timeNotation
    timeNotation::const_reference get_timeNotation () const;
    timeNotation::reference ref_timeNotation ();
    timeNotation::reference set_timeNotation ();
    timeNotation::reference set_timeNotation (timeNotation::const_reference value);
    void omit_timeNotation ();
    bool timeNotation_isPresent () const;
    void swap(ObservedEvent& other);
    ObservedEvent * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// ServiceChangeResult
//

class ServiceChangeResult : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    ServiceChangeResult(const void* info) : Inherited(info) {}
  public:
    ServiceChangeResult() : Inherited(&theInfo) {}
    class errorDescriptor {
      public:
        enum Id { id_ = 0 };
        typedef ErrorDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class errorDescriptor

    errorDescriptor::const_reference get_errorDescriptor () const;
    errorDescriptor::reference ref_errorDescriptor (); 
    errorDescriptor::reference select_errorDescriptor (); 
    errorDescriptor::reference select_errorDescriptor (errorDescriptor::const_reference value); 
    bool errorDescriptor_isSelected() const;

    class serviceChangeResParms {
      public:
        enum Id { id_ = 1 };
        typedef ServiceChangeResParm value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceChangeResParms

    serviceChangeResParms::const_reference get_serviceChangeResParms () const;
    serviceChangeResParms::reference ref_serviceChangeResParms (); 
    serviceChangeResParms::reference select_serviceChangeResParms (); 
    serviceChangeResParms::reference select_serviceChangeResParms (serviceChangeResParms::const_reference value); 
    bool serviceChangeResParms_isSelected() const;

    ServiceChangeResult(errorDescriptor::Id id, errorDescriptor::const_reference value);
    ServiceChangeResult(serviceChangeResParms::Id id, serviceChangeResParms::const_reference value);
    void swap(ServiceChangeResult & other);
    ServiceChangeResult(const ServiceChangeResult & other)
    : Inherited(other) {} 

    ServiceChangeResult & operator = (const ServiceChangeResult & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    ServiceChangeResult * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// LocalControlDescriptor
//

class LocalControlDescriptor : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    LocalControlDescriptor(const void* info) : Inherited(info) {}
  public:
    LocalControlDescriptor() : Inherited(&theInfo) {}
    LocalControlDescriptor(const LocalControlDescriptor & other) : Inherited(other)
    {}
    LocalControlDescriptor& operator = (const LocalControlDescriptor& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_streamMode
    };

    class streamMode {
      public:
        typedef StreamMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class streamMode
    streamMode::const_reference get_streamMode () const;
    streamMode::reference ref_streamMode ();
    streamMode::reference set_streamMode ();
    streamMode::reference set_streamMode (streamMode::value_type::NamedNumber value);
    void omit_streamMode ();
    bool streamMode_isPresent () const;
    class reserveValue {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class reserveValue
    reserveValue::const_reference get_reserveValue () const;
    reserveValue::reference ref_reserveValue ();
    reserveValue::reference set_reserveValue ();
    reserveValue::reference set_reserveValue (bool value);
    class reserveGroup {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class reserveGroup
    reserveGroup::const_reference get_reserveGroup () const;
    reserveGroup::reference ref_reserveGroup ();
    reserveGroup::reference set_reserveGroup ();
    reserveGroup::reference set_reserveGroup (bool value);
    class propertyParms {
      public:
        typedef ASN1::SEQUENCE_OF<PropertyParm>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class propertyParms
    propertyParms::const_reference get_propertyParms () const;
    propertyParms::reference ref_propertyParms ();
    propertyParms::reference set_propertyParms ();
    propertyParms::reference set_propertyParms (propertyParms::const_reference value);
    void swap(LocalControlDescriptor& other);
    LocalControlDescriptor * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// LocalRemoteDescriptor
//

class LocalRemoteDescriptor : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    LocalRemoteDescriptor(const void* info) : Inherited(info) {}
  public:
    LocalRemoteDescriptor() : Inherited(&theInfo) {}
    LocalRemoteDescriptor(const LocalRemoteDescriptor & other) : Inherited(other)
    {}
    LocalRemoteDescriptor& operator = (const LocalRemoteDescriptor& other)
    { Inherited::operator = (other); return *this; } 
    class propGrps {
      public:
        typedef ASN1::SEQUENCE_OF<PropertyGroup>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class propGrps
    propGrps::const_reference get_propGrps () const;
    propGrps::reference ref_propGrps ();
    propGrps::reference set_propGrps ();
    propGrps::reference set_propGrps (propGrps::const_reference value);
    void swap(LocalRemoteDescriptor& other);
    LocalRemoteDescriptor * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

typedef ASN1::SEQUENCE_OF<EventSpec>  EventBufferDescriptor;

//
// Signal
//

class Signal : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    Signal(const void* info) : Inherited(info) {}
  public:
    Signal() : Inherited(&theInfo) {}
    Signal(const Signal & other) : Inherited(other)
    {}
    Signal& operator = (const Signal& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_streamID,
      e_sigType,
      e_duration,
      e_notifyCompletion,
      e_keepActive
    };

    class signalName {
      public:
        typedef SignalName value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class signalName
    signalName::const_reference get_signalName () const;
    signalName::reference ref_signalName ();
    signalName::reference set_signalName ();
    signalName::reference set_signalName (const std::vector<char>& value);
    class streamID {
      public:
        typedef StreamID value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class streamID
    streamID::const_reference get_streamID () const;
    streamID::reference ref_streamID ();
    streamID::reference set_streamID ();
    streamID::reference set_streamID (streamID::value_type::int_type value);
    void omit_streamID ();
    bool streamID_isPresent () const;
    class sigType {
      public:
        typedef SignalType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sigType
    sigType::const_reference get_sigType () const;
    sigType::reference ref_sigType ();
    sigType::reference set_sigType ();
    sigType::reference set_sigType (sigType::value_type::NamedNumber value);
    void omit_sigType ();
    bool sigType_isPresent () const;
    class duration {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class duration
    duration::const_reference get_duration () const;
    duration::reference ref_duration ();
    duration::reference set_duration ();
    duration::reference set_duration (duration::value_type::int_type value);
    void omit_duration ();
    bool duration_isPresent () const;
    class notifyCompletion {
      public:
        typedef NotifyCompletion value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class notifyCompletion
    notifyCompletion::const_reference get_notifyCompletion () const;
    notifyCompletion::reference ref_notifyCompletion ();
    notifyCompletion::reference set_notifyCompletion ();
    notifyCompletion::reference set_notifyCompletion (notifyCompletion::const_reference value);
    void omit_notifyCompletion ();
    bool notifyCompletion_isPresent () const;
    class keepActive {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class keepActive
    keepActive::const_reference get_keepActive () const;
    keepActive::reference ref_keepActive ();
    keepActive::reference set_keepActive ();
    keepActive::reference set_keepActive (bool value);
    void omit_keepActive ();
    bool keepActive_isPresent () const;
    class sigParList {
      public:
        typedef ASN1::SEQUENCE_OF<SigParameter>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sigParList
    sigParList::const_reference get_sigParList () const;
    sigParList::reference ref_sigParList ();
    sigParList::reference set_sigParList ();
    sigParList::reference set_sigParList (sigParList::const_reference value);
    void swap(Signal& other);
    Signal * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[7];
    static int fieldIds[7];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[7];
#endif
};

typedef ASN1::SEQUENCE_OF<StatisticsParameter>  StatisticsDescriptor;

//
// NonStandardData
//

class NonStandardData : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    NonStandardData(const void* info) : Inherited(info) {}
  public:
    NonStandardData() : Inherited(&theInfo) {}
    NonStandardData(const NonStandardData & other) : Inherited(other)
    {}
    NonStandardData& operator = (const NonStandardData& other)
    { Inherited::operator = (other); return *this; } 
    class nonStandardIdentifier {
      public:
        typedef NonStandardIdentifier value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardIdentifier
    nonStandardIdentifier::const_reference get_nonStandardIdentifier () const;
    nonStandardIdentifier::reference ref_nonStandardIdentifier ();
    nonStandardIdentifier::reference set_nonStandardIdentifier ();
    nonStandardIdentifier::reference set_nonStandardIdentifier (nonStandardIdentifier::const_reference value);
    class data {
      public:
        typedef ASN1::OCTET_STRING value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class data
    data::const_reference get_data () const;
    data::reference ref_data ();
    data::reference set_data ();
    data::reference set_data (const std::vector<char>& value);
    void swap(NonStandardData& other);
    NonStandardData * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// ObservedEventsDescriptor
//

class ObservedEventsDescriptor : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ObservedEventsDescriptor(const void* info) : Inherited(info) {}
  public:
    ObservedEventsDescriptor() : Inherited(&theInfo) {}
    ObservedEventsDescriptor(const ObservedEventsDescriptor & other) : Inherited(other)
    {}
    ObservedEventsDescriptor& operator = (const ObservedEventsDescriptor& other)
    { Inherited::operator = (other); return *this; } 
    class requestId {
      public:
        typedef RequestID value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestId
    requestId::const_reference get_requestId () const;
    requestId::reference ref_requestId ();
    requestId::reference set_requestId ();
    requestId::reference set_requestId (requestId::value_type::int_type value);
    class observedEventLst {
      public:
        typedef ASN1::SEQUENCE_OF<ObservedEvent>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class observedEventLst
    observedEventLst::const_reference get_observedEventLst () const;
    observedEventLst::reference ref_observedEventLst ();
    observedEventLst::reference set_observedEventLst ();
    observedEventLst::reference set_observedEventLst (observedEventLst::const_reference value);
    void swap(ObservedEventsDescriptor& other);
    ObservedEventsDescriptor * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// ServiceChangeReply
//

class ServiceChangeReply : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ServiceChangeReply(const void* info) : Inherited(info) {}
  public:
    ServiceChangeReply() : Inherited(&theInfo) {}
    ServiceChangeReply(const ServiceChangeReply & other) : Inherited(other)
    {}
    ServiceChangeReply& operator = (const ServiceChangeReply& other)
    { Inherited::operator = (other); return *this; } 
    class terminationID {
      public:
        typedef TerminationIDList value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminationID
    terminationID::const_reference get_terminationID () const;
    terminationID::reference ref_terminationID ();
    terminationID::reference set_terminationID ();
    terminationID::reference set_terminationID (terminationID::const_reference value);
    class serviceChangeResult {
      public:
        typedef ServiceChangeResult value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceChangeResult
    serviceChangeResult::const_reference get_serviceChangeResult () const;
    serviceChangeResult::reference ref_serviceChangeResult ();
    serviceChangeResult::reference set_serviceChangeResult ();
    serviceChangeResult::reference set_serviceChangeResult (serviceChangeResult::const_reference value);
    void swap(ServiceChangeReply& other);
    ServiceChangeReply * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// StreamParms
//

class StreamParms : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    StreamParms(const void* info) : Inherited(info) {}
  public:
    StreamParms() : Inherited(&theInfo) {}
    StreamParms(const StreamParms & other) : Inherited(other)
    {}
    StreamParms& operator = (const StreamParms& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_localControlDescriptor,
      e_localDescriptor,
      e_remoteDescriptor
    };

    class localControlDescriptor {
      public:
        typedef LocalControlDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class localControlDescriptor
    localControlDescriptor::const_reference get_localControlDescriptor () const;
    localControlDescriptor::reference ref_localControlDescriptor ();
    localControlDescriptor::reference set_localControlDescriptor ();
    localControlDescriptor::reference set_localControlDescriptor (localControlDescriptor::const_reference value);
    void omit_localControlDescriptor ();
    bool localControlDescriptor_isPresent () const;
    class localDescriptor {
      public:
        typedef LocalRemoteDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class localDescriptor
    localDescriptor::const_reference get_localDescriptor () const;
    localDescriptor::reference ref_localDescriptor ();
    localDescriptor::reference set_localDescriptor ();
    localDescriptor::reference set_localDescriptor (localDescriptor::const_reference value);
    void omit_localDescriptor ();
    bool localDescriptor_isPresent () const;
    class remoteDescriptor {
      public:
        typedef LocalRemoteDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class remoteDescriptor
    remoteDescriptor::const_reference get_remoteDescriptor () const;
    remoteDescriptor::reference ref_remoteDescriptor ();
    remoteDescriptor::reference set_remoteDescriptor ();
    remoteDescriptor::reference set_remoteDescriptor (remoteDescriptor::const_reference value);
    void omit_remoteDescriptor ();
    bool remoteDescriptor_isPresent () const;
    void swap(StreamParms& other);
    StreamParms * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// MuxDescriptor
//

class MuxDescriptor : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MuxDescriptor(const void* info) : Inherited(info) {}
  public:
    MuxDescriptor() : Inherited(&theInfo) {}
    MuxDescriptor(const MuxDescriptor & other) : Inherited(other)
    {}
    MuxDescriptor& operator = (const MuxDescriptor& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData
    };

    class muxType {
      public:
        typedef MuxType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class muxType
    muxType::const_reference get_muxType () const;
    muxType::reference ref_muxType ();
    muxType::reference set_muxType ();
    muxType::reference set_muxType (muxType::value_type::NamedNumber value);
    class termList {
      public:
        typedef ASN1::SEQUENCE_OF<TerminationID>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class termList
    termList::const_reference get_termList () const;
    termList::reference ref_termList ();
    termList::reference set_termList ();
    termList::reference set_termList (termList::const_reference value);
    class nonStandardData {
      public:
        typedef NonStandardData value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    void swap(MuxDescriptor& other);
    MuxDescriptor * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// SeqSigList
//

class SeqSigList : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    SeqSigList(const void* info) : Inherited(info) {}
  public:
    SeqSigList() : Inherited(&theInfo) {}
    SeqSigList(const SeqSigList & other) : Inherited(other)
    {}
    SeqSigList& operator = (const SeqSigList& other)
    { Inherited::operator = (other); return *this; } 
    class id {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class id
    id::const_reference get_id () const;
    id::reference ref_id ();
    id::reference set_id ();
    id::reference set_id (id::value_type::int_type value);
    class signalList {
      public:
        typedef ASN1::SEQUENCE_OF<Signal>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class signalList
    signalList::const_reference get_signalList () const;
    signalList::reference ref_signalList ();
    signalList::reference set_signalList ();
    signalList::reference set_signalList (signalList::const_reference value);
    void swap(SeqSigList& other);
    SeqSigList * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// ModemDescriptor
//

class ModemDescriptor : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ModemDescriptor(const void* info) : Inherited(info) {}
  public:
    ModemDescriptor() : Inherited(&theInfo) {}
    ModemDescriptor(const ModemDescriptor & other) : Inherited(other)
    {}
    ModemDescriptor& operator = (const ModemDescriptor& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData
    };

    class mtl {
      public:
        typedef ASN1::SEQUENCE_OF<ModemType>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mtl
    mtl::const_reference get_mtl () const;
    mtl::reference ref_mtl ();
    mtl::reference set_mtl ();
    mtl::reference set_mtl (mtl::const_reference value);
    class mpl {
      public:
        typedef ASN1::SEQUENCE_OF<PropertyParm>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mpl
    mpl::const_reference get_mpl () const;
    mpl::reference ref_mpl ();
    mpl::reference set_mpl ();
    mpl::reference set_mpl (mpl::const_reference value);
    class nonStandardData {
      public:
        typedef NonStandardData value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    void swap(ModemDescriptor& other);
    ModemDescriptor * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// ServiceChangeParm
//

class ServiceChangeParm : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ServiceChangeParm(const void* info) : Inherited(info) {}
  public:
    ServiceChangeParm() : Inherited(&theInfo) {}
    ServiceChangeParm(const ServiceChangeParm & other) : Inherited(other)
    {}
    ServiceChangeParm& operator = (const ServiceChangeParm& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_serviceChangeAddress,
      e_serviceChangeVersion,
      e_serviceChangeProfile,
      e_serviceChangeDelay,
      e_serviceChangeMgcId,
      e_timeStamp,
      e_nonStandardData
    };

    class serviceChangeMethod {
      public:
        typedef ServiceChangeMethod value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceChangeMethod
    serviceChangeMethod::const_reference get_serviceChangeMethod () const;
    serviceChangeMethod::reference ref_serviceChangeMethod ();
    serviceChangeMethod::reference set_serviceChangeMethod ();
    serviceChangeMethod::reference set_serviceChangeMethod (serviceChangeMethod::value_type::NamedNumber value);
    class serviceChangeAddress {
      public:
        typedef ServiceChangeAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceChangeAddress
    serviceChangeAddress::const_reference get_serviceChangeAddress () const;
    serviceChangeAddress::reference ref_serviceChangeAddress ();
    serviceChangeAddress::reference set_serviceChangeAddress ();
    serviceChangeAddress::reference set_serviceChangeAddress (serviceChangeAddress::const_reference value);
    void omit_serviceChangeAddress ();
    bool serviceChangeAddress_isPresent () const;
    class serviceChangeVersion {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 99>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceChangeVersion
    serviceChangeVersion::const_reference get_serviceChangeVersion () const;
    serviceChangeVersion::reference ref_serviceChangeVersion ();
    serviceChangeVersion::reference set_serviceChangeVersion ();
    serviceChangeVersion::reference set_serviceChangeVersion (serviceChangeVersion::value_type::int_type value);
    void omit_serviceChangeVersion ();
    bool serviceChangeVersion_isPresent () const;
    class serviceChangeProfile {
      public:
        typedef ServiceChangeProfile value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceChangeProfile
    serviceChangeProfile::const_reference get_serviceChangeProfile () const;
    serviceChangeProfile::reference ref_serviceChangeProfile ();
    serviceChangeProfile::reference set_serviceChangeProfile ();
    serviceChangeProfile::reference set_serviceChangeProfile (serviceChangeProfile::const_reference value);
    void omit_serviceChangeProfile ();
    bool serviceChangeProfile_isPresent () const;
    class serviceChangeReason {
      public:
        typedef Value value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceChangeReason
    serviceChangeReason::const_reference get_serviceChangeReason () const;
    serviceChangeReason::reference ref_serviceChangeReason ();
    serviceChangeReason::reference set_serviceChangeReason ();
    serviceChangeReason::reference set_serviceChangeReason (const std::vector<char>& value);
    class serviceChangeDelay {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 4294967295U>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceChangeDelay
    serviceChangeDelay::const_reference get_serviceChangeDelay () const;
    serviceChangeDelay::reference ref_serviceChangeDelay ();
    serviceChangeDelay::reference set_serviceChangeDelay ();
    serviceChangeDelay::reference set_serviceChangeDelay (serviceChangeDelay::value_type::int_type value);
    void omit_serviceChangeDelay ();
    bool serviceChangeDelay_isPresent () const;
    class serviceChangeMgcId {
      public:
        typedef MId value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceChangeMgcId
    serviceChangeMgcId::const_reference get_serviceChangeMgcId () const;
    serviceChangeMgcId::reference ref_serviceChangeMgcId ();
    serviceChangeMgcId::reference set_serviceChangeMgcId ();
    serviceChangeMgcId::reference set_serviceChangeMgcId (serviceChangeMgcId::const_reference value);
    void omit_serviceChangeMgcId ();
    bool serviceChangeMgcId_isPresent () const;
    class timeStamp {
      public:
        typedef TimeNotation value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class timeStamp
    timeStamp::const_reference get_timeStamp () const;
    timeStamp::reference ref_timeStamp ();
    timeStamp::reference set_timeStamp ();
    timeStamp::reference set_timeStamp (timeStamp::const_reference value);
    void omit_timeStamp ();
    bool timeStamp_isPresent () const;
    class nonStandardData {
      public:
        typedef NonStandardData value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    void swap(ServiceChangeParm& other);
    ServiceChangeParm * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[9];
    static int fieldIds[9];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[9];
#endif
};

//
// NotifyRequest
//

class NotifyRequest : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    NotifyRequest(const void* info) : Inherited(info) {}
  public:
    NotifyRequest() : Inherited(&theInfo) {}
    NotifyRequest(const NotifyRequest & other) : Inherited(other)
    {}
    NotifyRequest& operator = (const NotifyRequest& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_errorDescriptor
    };

    class terminationID {
      public:
        typedef TerminationIDList value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminationID
    terminationID::const_reference get_terminationID () const;
    terminationID::reference ref_terminationID ();
    terminationID::reference set_terminationID ();
    terminationID::reference set_terminationID (terminationID::const_reference value);
    class observedEventsDescriptor {
      public:
        typedef ObservedEventsDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class observedEventsDescriptor
    observedEventsDescriptor::const_reference get_observedEventsDescriptor () const;
    observedEventsDescriptor::reference ref_observedEventsDescriptor ();
    observedEventsDescriptor::reference set_observedEventsDescriptor ();
    observedEventsDescriptor::reference set_observedEventsDescriptor (observedEventsDescriptor::const_reference value);
    class errorDescriptor {
      public:
        typedef ErrorDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class errorDescriptor
    errorDescriptor::const_reference get_errorDescriptor () const;
    errorDescriptor::reference ref_errorDescriptor ();
    errorDescriptor::reference set_errorDescriptor ();
    errorDescriptor::reference set_errorDescriptor (errorDescriptor::const_reference value);
    void omit_errorDescriptor ();
    bool errorDescriptor_isPresent () const;
    void swap(NotifyRequest& other);
    NotifyRequest * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// ServiceChangeRequest
//

class ServiceChangeRequest : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ServiceChangeRequest(const void* info) : Inherited(info) {}
  public:
    ServiceChangeRequest() : Inherited(&theInfo) {}
    ServiceChangeRequest(const ServiceChangeRequest & other) : Inherited(other)
    {}
    ServiceChangeRequest& operator = (const ServiceChangeRequest& other)
    { Inherited::operator = (other); return *this; } 
    class terminationID {
      public:
        typedef TerminationIDList value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminationID
    terminationID::const_reference get_terminationID () const;
    terminationID::reference ref_terminationID ();
    terminationID::reference set_terminationID ();
    terminationID::reference set_terminationID (terminationID::const_reference value);
    class serviceChangeParms {
      public:
        typedef ServiceChangeParm value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceChangeParms
    serviceChangeParms::const_reference get_serviceChangeParms () const;
    serviceChangeParms::reference ref_serviceChangeParms ();
    serviceChangeParms::reference set_serviceChangeParms ();
    serviceChangeParms::reference set_serviceChangeParms (serviceChangeParms::const_reference value);
    void swap(ServiceChangeRequest& other);
    ServiceChangeRequest * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// StreamDescriptor
//

class StreamDescriptor : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    StreamDescriptor(const void* info) : Inherited(info) {}
  public:
    StreamDescriptor() : Inherited(&theInfo) {}
    StreamDescriptor(const StreamDescriptor & other) : Inherited(other)
    {}
    StreamDescriptor& operator = (const StreamDescriptor& other)
    { Inherited::operator = (other); return *this; } 
    class streamID {
      public:
        typedef StreamID value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class streamID
    streamID::const_reference get_streamID () const;
    streamID::reference ref_streamID ();
    streamID::reference set_streamID ();
    streamID::reference set_streamID (streamID::value_type::int_type value);
    class streamParms {
      public:
        typedef StreamParms value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class streamParms
    streamParms::const_reference get_streamParms () const;
    streamParms::reference ref_streamParms ();
    streamParms::reference set_streamParms ();
    streamParms::reference set_streamParms (streamParms::const_reference value);
    void swap(StreamDescriptor& other);
    StreamDescriptor * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// SignalRequest
//

class SignalRequest : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    SignalRequest(const void* info) : Inherited(info) {}
  public:
    SignalRequest() : Inherited(&theInfo) {}
    class signal {
      public:
        enum Id { id_ = 0 };
        typedef Signal value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class signal

    signal::const_reference get_signal () const;
    signal::reference ref_signal (); 
    signal::reference select_signal (); 
    signal::reference select_signal (signal::const_reference value); 
    bool signal_isSelected() const;

    class seqSigList {
      public:
        enum Id { id_ = 1 };
        typedef SeqSigList value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class seqSigList

    seqSigList::const_reference get_seqSigList () const;
    seqSigList::reference ref_seqSigList (); 
    seqSigList::reference select_seqSigList (); 
    seqSigList::reference select_seqSigList (seqSigList::const_reference value); 
    bool seqSigList_isSelected() const;

    SignalRequest(signal::Id id, signal::const_reference value);
    SignalRequest(seqSigList::Id id, seqSigList::const_reference value);
    void swap(SignalRequest & other);
    SignalRequest(const SignalRequest & other)
    : Inherited(other) {} 

    SignalRequest & operator = (const SignalRequest & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    SignalRequest * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// MediaDescriptor_streams
//

class MediaDescriptor_streams : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    MediaDescriptor_streams(const void* info) : Inherited(info) {}
  public:
    MediaDescriptor_streams() : Inherited(&theInfo) {}
    class oneStream {
      public:
        enum Id { id_ = 0 };
        typedef StreamParms value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class oneStream

    oneStream::const_reference get_oneStream () const;
    oneStream::reference ref_oneStream (); 
    oneStream::reference select_oneStream (); 
    oneStream::reference select_oneStream (oneStream::const_reference value); 
    bool oneStream_isSelected() const;

    class multiStream {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::SEQUENCE_OF<StreamDescriptor>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multiStream

    multiStream::const_reference get_multiStream () const;
    multiStream::reference ref_multiStream (); 
    multiStream::reference select_multiStream (); 
    multiStream::reference select_multiStream (multiStream::const_reference value); 
    bool multiStream_isSelected() const;

    MediaDescriptor_streams(oneStream::Id id, oneStream::const_reference value);
    MediaDescriptor_streams(multiStream::Id id, multiStream::const_reference value);
    void swap(MediaDescriptor_streams & other);
    MediaDescriptor_streams(const MediaDescriptor_streams & other)
    : Inherited(other) {} 

    MediaDescriptor_streams & operator = (const MediaDescriptor_streams & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    MediaDescriptor_streams * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// MediaDescriptor
//

class MediaDescriptor : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MediaDescriptor(const void* info) : Inherited(info) {}
  public:
    MediaDescriptor() : Inherited(&theInfo) {}
    MediaDescriptor(const MediaDescriptor & other) : Inherited(other)
    {}
    MediaDescriptor& operator = (const MediaDescriptor& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_termStateDescr
    };

    class termStateDescr {
      public:
        typedef TerminationStateDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class termStateDescr
    termStateDescr::const_reference get_termStateDescr () const;
    termStateDescr::reference ref_termStateDescr ();
    termStateDescr::reference set_termStateDescr ();
    termStateDescr::reference set_termStateDescr (termStateDescr::const_reference value);
    void omit_termStateDescr ();
    bool termStateDescr_isPresent () const;
    class streams {
      public:
        typedef MediaDescriptor_streams value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class streams
    streams::const_reference get_streams () const;
    streams::reference ref_streams ();
    streams::reference set_streams ();
    streams::reference set_streams (streams::const_reference value);
    void swap(MediaDescriptor& other);
    MediaDescriptor * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

typedef ASN1::SEQUENCE_OF<SignalRequest>  SignalsDescriptor;

//
// SecondRequestedActions
//

class SecondRequestedActions : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    SecondRequestedActions(const void* info) : Inherited(info) {}
  public:
    SecondRequestedActions() : Inherited(&theInfo) {}
    SecondRequestedActions(const SecondRequestedActions & other) : Inherited(other)
    {}
    SecondRequestedActions& operator = (const SecondRequestedActions& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_eventDM,
      e_signalsDescriptor
    };

    class keepActive {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class keepActive
    keepActive::const_reference get_keepActive () const;
    keepActive::reference ref_keepActive ();
    keepActive::reference set_keepActive ();
    keepActive::reference set_keepActive (bool value);
    class eventDM {
      public:
        typedef EventDM value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class eventDM
    eventDM::const_reference get_eventDM () const;
    eventDM::reference ref_eventDM ();
    eventDM::reference set_eventDM ();
    eventDM::reference set_eventDM (eventDM::const_reference value);
    void omit_eventDM ();
    bool eventDM_isPresent () const;
    class signalsDescriptor {
      public:
        typedef SignalsDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class signalsDescriptor
    signalsDescriptor::const_reference get_signalsDescriptor () const;
    signalsDescriptor::reference ref_signalsDescriptor ();
    signalsDescriptor::reference set_signalsDescriptor ();
    signalsDescriptor::reference set_signalsDescriptor (signalsDescriptor::const_reference value);
    void omit_signalsDescriptor ();
    bool signalsDescriptor_isPresent () const;
    void swap(SecondRequestedActions& other);
    SecondRequestedActions * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// SecondRequestedEvent
//

class SecondRequestedEvent : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    SecondRequestedEvent(const void* info) : Inherited(info) {}
  public:
    SecondRequestedEvent() : Inherited(&theInfo) {}
    SecondRequestedEvent(const SecondRequestedEvent & other) : Inherited(other)
    {}
    SecondRequestedEvent& operator = (const SecondRequestedEvent& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_streamID,
      e_eventAction
    };

    class pkgdName {
      public:
        typedef PkgdName value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class pkgdName
    pkgdName::const_reference get_pkgdName () const;
    pkgdName::reference ref_pkgdName ();
    pkgdName::reference set_pkgdName ();
    pkgdName::reference set_pkgdName (const std::vector<char>& value);
    class streamID {
      public:
        typedef StreamID value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class streamID
    streamID::const_reference get_streamID () const;
    streamID::reference ref_streamID ();
    streamID::reference set_streamID ();
    streamID::reference set_streamID (streamID::value_type::int_type value);
    void omit_streamID ();
    bool streamID_isPresent () const;
    class eventAction {
      public:
        typedef SecondRequestedActions value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class eventAction
    eventAction::const_reference get_eventAction () const;
    eventAction::reference ref_eventAction ();
    eventAction::reference set_eventAction ();
    eventAction::reference set_eventAction (eventAction::const_reference value);
    void omit_eventAction ();
    bool eventAction_isPresent () const;
    class evParList {
      public:
        typedef ASN1::SEQUENCE_OF<EventParameter>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class evParList
    evParList::const_reference get_evParList () const;
    evParList::reference ref_evParList ();
    evParList::reference set_evParList ();
    evParList::reference set_evParList (evParList::const_reference value);
    void swap(SecondRequestedEvent& other);
    SecondRequestedEvent * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// SecondEventsDescriptor
//

class SecondEventsDescriptor : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    SecondEventsDescriptor(const void* info) : Inherited(info) {}
  public:
    SecondEventsDescriptor() : Inherited(&theInfo) {}
    SecondEventsDescriptor(const SecondEventsDescriptor & other) : Inherited(other)
    {}
    SecondEventsDescriptor& operator = (const SecondEventsDescriptor& other)
    { Inherited::operator = (other); return *this; } 
    class requestID {
      public:
        typedef RequestID value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestID
    requestID::const_reference get_requestID () const;
    requestID::reference ref_requestID ();
    requestID::reference set_requestID ();
    requestID::reference set_requestID (requestID::value_type::int_type value);
    class eventList {
      public:
        typedef ASN1::SEQUENCE_OF<SecondRequestedEvent>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class eventList
    eventList::const_reference get_eventList () const;
    eventList::reference ref_eventList ();
    eventList::reference set_eventList ();
    eventList::reference set_eventList (eventList::const_reference value);
    void swap(SecondEventsDescriptor& other);
    SecondEventsDescriptor * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// RequestedActions
//

class RequestedActions : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RequestedActions(const void* info) : Inherited(info) {}
  public:
    RequestedActions() : Inherited(&theInfo) {}
    RequestedActions(const RequestedActions & other) : Inherited(other)
    {}
    RequestedActions& operator = (const RequestedActions& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_eventDM,
      e_secondEvent,
      e_signalsDescriptor
    };

    class keepActive {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class keepActive
    keepActive::const_reference get_keepActive () const;
    keepActive::reference ref_keepActive ();
    keepActive::reference set_keepActive ();
    keepActive::reference set_keepActive (bool value);
    class eventDM {
      public:
        typedef EventDM value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class eventDM
    eventDM::const_reference get_eventDM () const;
    eventDM::reference ref_eventDM ();
    eventDM::reference set_eventDM ();
    eventDM::reference set_eventDM (eventDM::const_reference value);
    void omit_eventDM ();
    bool eventDM_isPresent () const;
    class secondEvent {
      public:
        typedef SecondEventsDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class secondEvent
    secondEvent::const_reference get_secondEvent () const;
    secondEvent::reference ref_secondEvent ();
    secondEvent::reference set_secondEvent ();
    secondEvent::reference set_secondEvent (secondEvent::const_reference value);
    void omit_secondEvent ();
    bool secondEvent_isPresent () const;
    class signalsDescriptor {
      public:
        typedef SignalsDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class signalsDescriptor
    signalsDescriptor::const_reference get_signalsDescriptor () const;
    signalsDescriptor::reference ref_signalsDescriptor ();
    signalsDescriptor::reference set_signalsDescriptor ();
    signalsDescriptor::reference set_signalsDescriptor (signalsDescriptor::const_reference value);
    void omit_signalsDescriptor ();
    bool signalsDescriptor_isPresent () const;
    void swap(RequestedActions& other);
    RequestedActions * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// RequestedEvent
//

class RequestedEvent : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RequestedEvent(const void* info) : Inherited(info) {}
  public:
    RequestedEvent() : Inherited(&theInfo) {}
    RequestedEvent(const RequestedEvent & other) : Inherited(other)
    {}
    RequestedEvent& operator = (const RequestedEvent& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_streamID,
      e_eventAction
    };

    class pkgdName {
      public:
        typedef PkgdName value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class pkgdName
    pkgdName::const_reference get_pkgdName () const;
    pkgdName::reference ref_pkgdName ();
    pkgdName::reference set_pkgdName ();
    pkgdName::reference set_pkgdName (const std::vector<char>& value);
    class streamID {
      public:
        typedef StreamID value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class streamID
    streamID::const_reference get_streamID () const;
    streamID::reference ref_streamID ();
    streamID::reference set_streamID ();
    streamID::reference set_streamID (streamID::value_type::int_type value);
    void omit_streamID ();
    bool streamID_isPresent () const;
    class eventAction {
      public:
        typedef RequestedActions value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class eventAction
    eventAction::const_reference get_eventAction () const;
    eventAction::reference ref_eventAction ();
    eventAction::reference set_eventAction ();
    eventAction::reference set_eventAction (eventAction::const_reference value);
    void omit_eventAction ();
    bool eventAction_isPresent () const;
    class evParList {
      public:
        typedef ASN1::SEQUENCE_OF<EventParameter>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class evParList
    evParList::const_reference get_evParList () const;
    evParList::reference ref_evParList ();
    evParList::reference set_evParList ();
    evParList::reference set_evParList (evParList::const_reference value);
    void swap(RequestedEvent& other);
    RequestedEvent * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// EventsDescriptor
//

class EventsDescriptor : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    EventsDescriptor(const void* info) : Inherited(info) {}
  public:
    EventsDescriptor() : Inherited(&theInfo) {}
    EventsDescriptor(const EventsDescriptor & other) : Inherited(other)
    {}
    EventsDescriptor& operator = (const EventsDescriptor& other)
    { Inherited::operator = (other); return *this; } 
    class requestID {
      public:
        typedef RequestID value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class requestID
    requestID::const_reference get_requestID () const;
    requestID::reference ref_requestID ();
    requestID::reference set_requestID ();
    requestID::reference set_requestID (requestID::value_type::int_type value);
    class eventList {
      public:
        typedef ASN1::SEQUENCE_OF<RequestedEvent>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class eventList
    eventList::const_reference get_eventList () const;
    eventList::reference ref_eventList ();
    eventList::reference set_eventList ();
    eventList::reference set_eventList (eventList::const_reference value);
    void swap(EventsDescriptor& other);
    EventsDescriptor * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// AmmDescriptor
//

class AmmDescriptor : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    AmmDescriptor(const void* info) : Inherited(info) {}
  public:
    AmmDescriptor() : Inherited(&theInfo) {}
    class mediaDescriptor {
      public:
        enum Id { id_ = 0 };
        typedef MediaDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mediaDescriptor

    mediaDescriptor::const_reference get_mediaDescriptor () const;
    mediaDescriptor::reference ref_mediaDescriptor (); 
    mediaDescriptor::reference select_mediaDescriptor (); 
    mediaDescriptor::reference select_mediaDescriptor (mediaDescriptor::const_reference value); 
    bool mediaDescriptor_isSelected() const;

    class modemDescriptor {
      public:
        enum Id { id_ = 1 };
        typedef ModemDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class modemDescriptor

    modemDescriptor::const_reference get_modemDescriptor () const;
    modemDescriptor::reference ref_modemDescriptor (); 
    modemDescriptor::reference select_modemDescriptor (); 
    modemDescriptor::reference select_modemDescriptor (modemDescriptor::const_reference value); 
    bool modemDescriptor_isSelected() const;

    class muxDescriptor {
      public:
        enum Id { id_ = 2 };
        typedef MuxDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class muxDescriptor

    muxDescriptor::const_reference get_muxDescriptor () const;
    muxDescriptor::reference ref_muxDescriptor (); 
    muxDescriptor::reference select_muxDescriptor (); 
    muxDescriptor::reference select_muxDescriptor (muxDescriptor::const_reference value); 
    bool muxDescriptor_isSelected() const;

    class eventsDescriptor {
      public:
        enum Id { id_ = 3 };
        typedef EventsDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class eventsDescriptor

    eventsDescriptor::const_reference get_eventsDescriptor () const;
    eventsDescriptor::reference ref_eventsDescriptor (); 
    eventsDescriptor::reference select_eventsDescriptor (); 
    eventsDescriptor::reference select_eventsDescriptor (eventsDescriptor::const_reference value); 
    bool eventsDescriptor_isSelected() const;

    class eventBufferDescriptor {
      public:
        enum Id { id_ = 4 };
        typedef EventBufferDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class eventBufferDescriptor

    eventBufferDescriptor::const_reference get_eventBufferDescriptor () const;
    eventBufferDescriptor::reference ref_eventBufferDescriptor (); 
    eventBufferDescriptor::reference select_eventBufferDescriptor (); 
    eventBufferDescriptor::reference select_eventBufferDescriptor (eventBufferDescriptor::const_reference value); 
    bool eventBufferDescriptor_isSelected() const;

    class signalsDescriptor {
      public:
        enum Id { id_ = 5 };
        typedef SignalsDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class signalsDescriptor

    signalsDescriptor::const_reference get_signalsDescriptor () const;
    signalsDescriptor::reference ref_signalsDescriptor (); 
    signalsDescriptor::reference select_signalsDescriptor (); 
    signalsDescriptor::reference select_signalsDescriptor (signalsDescriptor::const_reference value); 
    bool signalsDescriptor_isSelected() const;

    class digitMapDescriptor {
      public:
        enum Id { id_ = 6 };
        typedef DigitMapDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class digitMapDescriptor

    digitMapDescriptor::const_reference get_digitMapDescriptor () const;
    digitMapDescriptor::reference ref_digitMapDescriptor (); 
    digitMapDescriptor::reference select_digitMapDescriptor (); 
    digitMapDescriptor::reference select_digitMapDescriptor (digitMapDescriptor::const_reference value); 
    bool digitMapDescriptor_isSelected() const;

    class auditDescriptor {
      public:
        enum Id { id_ = 7 };
        typedef AuditDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class auditDescriptor

    auditDescriptor::const_reference get_auditDescriptor () const;
    auditDescriptor::reference ref_auditDescriptor (); 
    auditDescriptor::reference select_auditDescriptor (); 
    auditDescriptor::reference select_auditDescriptor (auditDescriptor::const_reference value); 
    bool auditDescriptor_isSelected() const;

    AmmDescriptor(mediaDescriptor::Id id, mediaDescriptor::const_reference value);
    AmmDescriptor(modemDescriptor::Id id, modemDescriptor::const_reference value);
    AmmDescriptor(muxDescriptor::Id id, muxDescriptor::const_reference value);
    AmmDescriptor(eventsDescriptor::Id id, eventsDescriptor::const_reference value);
    AmmDescriptor(eventBufferDescriptor::Id id, eventBufferDescriptor::const_reference value);
    AmmDescriptor(signalsDescriptor::Id id, signalsDescriptor::const_reference value);
    AmmDescriptor(digitMapDescriptor::Id id, digitMapDescriptor::const_reference value);
    AmmDescriptor(auditDescriptor::Id id, auditDescriptor::const_reference value);
    void swap(AmmDescriptor & other);
    AmmDescriptor(const AmmDescriptor & other)
    : Inherited(other) {} 

    AmmDescriptor & operator = (const AmmDescriptor & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    AmmDescriptor * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[8];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[8];
#endif
};

//
// AuditReturnParameter
//

class AuditReturnParameter : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    AuditReturnParameter(const void* info) : Inherited(info) {}
  public:
    AuditReturnParameter() : Inherited(&theInfo) {}
    class errorDescriptor {
      public:
        enum Id { id_ = 0 };
        typedef ErrorDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class errorDescriptor

    errorDescriptor::const_reference get_errorDescriptor () const;
    errorDescriptor::reference ref_errorDescriptor (); 
    errorDescriptor::reference select_errorDescriptor (); 
    errorDescriptor::reference select_errorDescriptor (errorDescriptor::const_reference value); 
    bool errorDescriptor_isSelected() const;

    class mediaDescriptor {
      public:
        enum Id { id_ = 1 };
        typedef MediaDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mediaDescriptor

    mediaDescriptor::const_reference get_mediaDescriptor () const;
    mediaDescriptor::reference ref_mediaDescriptor (); 
    mediaDescriptor::reference select_mediaDescriptor (); 
    mediaDescriptor::reference select_mediaDescriptor (mediaDescriptor::const_reference value); 
    bool mediaDescriptor_isSelected() const;

    class modemDescriptor {
      public:
        enum Id { id_ = 2 };
        typedef ModemDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class modemDescriptor

    modemDescriptor::const_reference get_modemDescriptor () const;
    modemDescriptor::reference ref_modemDescriptor (); 
    modemDescriptor::reference select_modemDescriptor (); 
    modemDescriptor::reference select_modemDescriptor (modemDescriptor::const_reference value); 
    bool modemDescriptor_isSelected() const;

    class muxDescriptor {
      public:
        enum Id { id_ = 3 };
        typedef MuxDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class muxDescriptor

    muxDescriptor::const_reference get_muxDescriptor () const;
    muxDescriptor::reference ref_muxDescriptor (); 
    muxDescriptor::reference select_muxDescriptor (); 
    muxDescriptor::reference select_muxDescriptor (muxDescriptor::const_reference value); 
    bool muxDescriptor_isSelected() const;

    class eventsDescriptor {
      public:
        enum Id { id_ = 4 };
        typedef EventsDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class eventsDescriptor

    eventsDescriptor::const_reference get_eventsDescriptor () const;
    eventsDescriptor::reference ref_eventsDescriptor (); 
    eventsDescriptor::reference select_eventsDescriptor (); 
    eventsDescriptor::reference select_eventsDescriptor (eventsDescriptor::const_reference value); 
    bool eventsDescriptor_isSelected() const;

    class eventBufferDescriptor {
      public:
        enum Id { id_ = 5 };
        typedef EventBufferDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class eventBufferDescriptor

    eventBufferDescriptor::const_reference get_eventBufferDescriptor () const;
    eventBufferDescriptor::reference ref_eventBufferDescriptor (); 
    eventBufferDescriptor::reference select_eventBufferDescriptor (); 
    eventBufferDescriptor::reference select_eventBufferDescriptor (eventBufferDescriptor::const_reference value); 
    bool eventBufferDescriptor_isSelected() const;

    class signalsDescriptor {
      public:
        enum Id { id_ = 6 };
        typedef SignalsDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class signalsDescriptor

    signalsDescriptor::const_reference get_signalsDescriptor () const;
    signalsDescriptor::reference ref_signalsDescriptor (); 
    signalsDescriptor::reference select_signalsDescriptor (); 
    signalsDescriptor::reference select_signalsDescriptor (signalsDescriptor::const_reference value); 
    bool signalsDescriptor_isSelected() const;

    class digitMapDescriptor {
      public:
        enum Id { id_ = 7 };
        typedef DigitMapDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class digitMapDescriptor

    digitMapDescriptor::const_reference get_digitMapDescriptor () const;
    digitMapDescriptor::reference ref_digitMapDescriptor (); 
    digitMapDescriptor::reference select_digitMapDescriptor (); 
    digitMapDescriptor::reference select_digitMapDescriptor (digitMapDescriptor::const_reference value); 
    bool digitMapDescriptor_isSelected() const;

    class observedEventsDescriptor {
      public:
        enum Id { id_ = 8 };
        typedef ObservedEventsDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class observedEventsDescriptor

    observedEventsDescriptor::const_reference get_observedEventsDescriptor () const;
    observedEventsDescriptor::reference ref_observedEventsDescriptor (); 
    observedEventsDescriptor::reference select_observedEventsDescriptor (); 
    observedEventsDescriptor::reference select_observedEventsDescriptor (observedEventsDescriptor::const_reference value); 
    bool observedEventsDescriptor_isSelected() const;

    class statisticsDescriptor {
      public:
        enum Id { id_ = 9 };
        typedef StatisticsDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class statisticsDescriptor

    statisticsDescriptor::const_reference get_statisticsDescriptor () const;
    statisticsDescriptor::reference ref_statisticsDescriptor (); 
    statisticsDescriptor::reference select_statisticsDescriptor (); 
    statisticsDescriptor::reference select_statisticsDescriptor (statisticsDescriptor::const_reference value); 
    bool statisticsDescriptor_isSelected() const;

    class packagesDescriptor {
      public:
        enum Id { id_ = 10 };
        typedef PackagesDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class packagesDescriptor

    packagesDescriptor::const_reference get_packagesDescriptor () const;
    packagesDescriptor::reference ref_packagesDescriptor (); 
    packagesDescriptor::reference select_packagesDescriptor (); 
    packagesDescriptor::reference select_packagesDescriptor (packagesDescriptor::const_reference value); 
    bool packagesDescriptor_isSelected() const;

    class emptyDescriptors {
      public:
        enum Id { id_ = 11 };
        typedef AuditDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class emptyDescriptors

    emptyDescriptors::const_reference get_emptyDescriptors () const;
    emptyDescriptors::reference ref_emptyDescriptors (); 
    emptyDescriptors::reference select_emptyDescriptors (); 
    emptyDescriptors::reference select_emptyDescriptors (emptyDescriptors::const_reference value); 
    bool emptyDescriptors_isSelected() const;

    AuditReturnParameter(errorDescriptor::Id id, errorDescriptor::const_reference value);
    AuditReturnParameter(mediaDescriptor::Id id, mediaDescriptor::const_reference value);
    AuditReturnParameter(modemDescriptor::Id id, modemDescriptor::const_reference value);
    AuditReturnParameter(muxDescriptor::Id id, muxDescriptor::const_reference value);
    AuditReturnParameter(eventsDescriptor::Id id, eventsDescriptor::const_reference value);
    AuditReturnParameter(eventBufferDescriptor::Id id, eventBufferDescriptor::const_reference value);
    AuditReturnParameter(signalsDescriptor::Id id, signalsDescriptor::const_reference value);
    AuditReturnParameter(digitMapDescriptor::Id id, digitMapDescriptor::const_reference value);
    AuditReturnParameter(observedEventsDescriptor::Id id, observedEventsDescriptor::const_reference value);
    AuditReturnParameter(statisticsDescriptor::Id id, statisticsDescriptor::const_reference value);
    AuditReturnParameter(packagesDescriptor::Id id, packagesDescriptor::const_reference value);
    AuditReturnParameter(emptyDescriptors::Id id, emptyDescriptors::const_reference value);
    void swap(AuditReturnParameter & other);
    AuditReturnParameter(const AuditReturnParameter & other)
    : Inherited(other) {} 

    AuditReturnParameter & operator = (const AuditReturnParameter & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    AuditReturnParameter * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[12];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[12];
#endif
};

//
// AmmRequest
//

class AmmRequest : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    AmmRequest(const void* info) : Inherited(info) {}
  public:
    AmmRequest() : Inherited(&theInfo) {}
    AmmRequest(const AmmRequest & other) : Inherited(other)
    {}
    AmmRequest& operator = (const AmmRequest& other)
    { Inherited::operator = (other); return *this; } 
    class terminationID {
      public:
        typedef TerminationIDList value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminationID
    terminationID::const_reference get_terminationID () const;
    terminationID::reference ref_terminationID ();
    terminationID::reference set_terminationID ();
    terminationID::reference set_terminationID (terminationID::const_reference value);
    class descriptors {
      public:
        typedef ASN1::SEQUENCE_OF<AmmDescriptor>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class descriptors
    descriptors::const_reference get_descriptors () const;
    descriptors::reference ref_descriptors ();
    descriptors::reference set_descriptors ();
    descriptors::reference set_descriptors (descriptors::const_reference value);
    void swap(AmmRequest& other);
    AmmRequest * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

typedef ASN1::SEQUENCE_OF<AuditReturnParameter>  TerminationAudit;

//
// Command
//

class Command : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    Command(const void* info) : Inherited(info) {}
  public:
    Command() : Inherited(&theInfo) {}
    class addReq {
      public:
        enum Id { id_ = 0 };
        typedef AmmRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class addReq

    addReq::const_reference get_addReq () const;
    addReq::reference ref_addReq (); 
    addReq::reference select_addReq (); 
    addReq::reference select_addReq (addReq::const_reference value); 
    bool addReq_isSelected() const;

    class moveReq {
      public:
        enum Id { id_ = 1 };
        typedef AmmRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class moveReq

    moveReq::const_reference get_moveReq () const;
    moveReq::reference ref_moveReq (); 
    moveReq::reference select_moveReq (); 
    moveReq::reference select_moveReq (moveReq::const_reference value); 
    bool moveReq_isSelected() const;

    class modReq {
      public:
        enum Id { id_ = 2 };
        typedef AmmRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class modReq

    modReq::const_reference get_modReq () const;
    modReq::reference ref_modReq (); 
    modReq::reference select_modReq (); 
    modReq::reference select_modReq (modReq::const_reference value); 
    bool modReq_isSelected() const;

    class subtractReq {
      public:
        enum Id { id_ = 3 };
        typedef SubtractRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class subtractReq

    subtractReq::const_reference get_subtractReq () const;
    subtractReq::reference ref_subtractReq (); 
    subtractReq::reference select_subtractReq (); 
    subtractReq::reference select_subtractReq (subtractReq::const_reference value); 
    bool subtractReq_isSelected() const;

    class auditCapRequest {
      public:
        enum Id { id_ = 4 };
        typedef AuditRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class auditCapRequest

    auditCapRequest::const_reference get_auditCapRequest () const;
    auditCapRequest::reference ref_auditCapRequest (); 
    auditCapRequest::reference select_auditCapRequest (); 
    auditCapRequest::reference select_auditCapRequest (auditCapRequest::const_reference value); 
    bool auditCapRequest_isSelected() const;

    class auditValueRequest {
      public:
        enum Id { id_ = 5 };
        typedef AuditRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class auditValueRequest

    auditValueRequest::const_reference get_auditValueRequest () const;
    auditValueRequest::reference ref_auditValueRequest (); 
    auditValueRequest::reference select_auditValueRequest (); 
    auditValueRequest::reference select_auditValueRequest (auditValueRequest::const_reference value); 
    bool auditValueRequest_isSelected() const;

    class notifyReq {
      public:
        enum Id { id_ = 6 };
        typedef NotifyRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class notifyReq

    notifyReq::const_reference get_notifyReq () const;
    notifyReq::reference ref_notifyReq (); 
    notifyReq::reference select_notifyReq (); 
    notifyReq::reference select_notifyReq (notifyReq::const_reference value); 
    bool notifyReq_isSelected() const;

    class serviceChangeReq {
      public:
        enum Id { id_ = 7 };
        typedef ServiceChangeRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceChangeReq

    serviceChangeReq::const_reference get_serviceChangeReq () const;
    serviceChangeReq::reference ref_serviceChangeReq (); 
    serviceChangeReq::reference select_serviceChangeReq (); 
    serviceChangeReq::reference select_serviceChangeReq (serviceChangeReq::const_reference value); 
    bool serviceChangeReq_isSelected() const;

    Command(addReq::Id id, addReq::const_reference value);
    Command(moveReq::Id id, moveReq::const_reference value);
    Command(modReq::Id id, modReq::const_reference value);
    Command(subtractReq::Id id, subtractReq::const_reference value);
    Command(auditCapRequest::Id id, auditCapRequest::const_reference value);
    Command(auditValueRequest::Id id, auditValueRequest::const_reference value);
    Command(notifyReq::Id id, notifyReq::const_reference value);
    Command(serviceChangeReq::Id id, serviceChangeReq::const_reference value);
    void swap(Command & other);
    Command(const Command & other)
    : Inherited(other) {} 

    Command & operator = (const Command & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    Command * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[8];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[8];
#endif
};

//
// AmmsReply
//

class AmmsReply : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    AmmsReply(const void* info) : Inherited(info) {}
  public:
    AmmsReply() : Inherited(&theInfo) {}
    AmmsReply(const AmmsReply & other) : Inherited(other)
    {}
    AmmsReply& operator = (const AmmsReply& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_terminationAudit
    };

    class terminationID {
      public:
        typedef TerminationIDList value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminationID
    terminationID::const_reference get_terminationID () const;
    terminationID::reference ref_terminationID ();
    terminationID::reference set_terminationID ();
    terminationID::reference set_terminationID (terminationID::const_reference value);
    class terminationAudit {
      public:
        typedef TerminationAudit value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminationAudit
    terminationAudit::const_reference get_terminationAudit () const;
    terminationAudit::reference ref_terminationAudit ();
    terminationAudit::reference set_terminationAudit ();
    terminationAudit::reference set_terminationAudit (terminationAudit::const_reference value);
    void omit_terminationAudit ();
    bool terminationAudit_isPresent () const;
    void swap(AmmsReply& other);
    AmmsReply * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// AuditResult
//

class AuditResult : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    AuditResult(const void* info) : Inherited(info) {}
  public:
    AuditResult() : Inherited(&theInfo) {}
    class contextAuditResult {
      public:
        enum Id { id_ = 0 };
        typedef TerminationIDList value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class contextAuditResult

    contextAuditResult::const_reference get_contextAuditResult () const;
    contextAuditResult::reference ref_contextAuditResult (); 
    contextAuditResult::reference select_contextAuditResult (); 
    contextAuditResult::reference select_contextAuditResult (contextAuditResult::const_reference value); 
    bool contextAuditResult_isSelected() const;

    class terminationAuditResult {
      public:
        enum Id { id_ = 1 };
        typedef TerminationAudit value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminationAuditResult

    terminationAuditResult::const_reference get_terminationAuditResult () const;
    terminationAuditResult::reference ref_terminationAuditResult (); 
    terminationAuditResult::reference select_terminationAuditResult (); 
    terminationAuditResult::reference select_terminationAuditResult (terminationAuditResult::const_reference value); 
    bool terminationAuditResult_isSelected() const;

    AuditResult(contextAuditResult::Id id, contextAuditResult::const_reference value);
    AuditResult(terminationAuditResult::Id id, terminationAuditResult::const_reference value);
    void swap(AuditResult & other);
    AuditResult(const AuditResult & other)
    : Inherited(other) {} 

    AuditResult & operator = (const AuditResult & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    AuditResult * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// CommandRequest
//

class CommandRequest : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CommandRequest(const void* info) : Inherited(info) {}
  public:
    CommandRequest() : Inherited(&theInfo) {}
    CommandRequest(const CommandRequest & other) : Inherited(other)
    {}
    CommandRequest& operator = (const CommandRequest& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_optional,
      e_wildcardReturn
    };

    class command {
      public:
        typedef Command value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class command
    command::const_reference get_command () const;
    command::reference ref_command ();
    command::reference set_command ();
    command::reference set_command (command::const_reference value);
    class optional {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class optional
    optional::reference set_optional ();
    void omit_optional ();
    bool optional_isPresent () const;
    class wildcardReturn {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class wildcardReturn
    wildcardReturn::reference set_wildcardReturn ();
    void omit_wildcardReturn ();
    bool wildcardReturn_isPresent () const;
    void swap(CommandRequest& other);
    CommandRequest * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// AuditReply
//

class AuditReply : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    AuditReply(const void* info) : Inherited(info) {}
  public:
    AuditReply() : Inherited(&theInfo) {}
    AuditReply(const AuditReply & other) : Inherited(other)
    {}
    AuditReply& operator = (const AuditReply& other)
    { Inherited::operator = (other); return *this; } 
    class terminationID {
      public:
        typedef TerminationID value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminationID
    terminationID::const_reference get_terminationID () const;
    terminationID::reference ref_terminationID ();
    terminationID::reference set_terminationID ();
    terminationID::reference set_terminationID (terminationID::const_reference value);
    class auditResult {
      public:
        typedef AuditResult value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class auditResult
    auditResult::const_reference get_auditResult () const;
    auditResult::reference ref_auditResult ();
    auditResult::reference set_auditResult ();
    auditResult::reference set_auditResult (auditResult::const_reference value);
    void swap(AuditReply& other);
    AuditReply * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// ActionRequest
//

class ActionRequest : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ActionRequest(const void* info) : Inherited(info) {}
  public:
    ActionRequest() : Inherited(&theInfo) {}
    ActionRequest(const ActionRequest & other) : Inherited(other)
    {}
    ActionRequest& operator = (const ActionRequest& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_contextRequest,
      e_contextAttrAuditReq
    };

    class contextId {
      public:
        typedef ContextID value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class contextId
    contextId::const_reference get_contextId () const;
    contextId::reference ref_contextId ();
    contextId::reference set_contextId ();
    contextId::reference set_contextId (contextId::value_type::int_type value);
    class contextRequest {
      public:
        typedef ContextRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class contextRequest
    contextRequest::const_reference get_contextRequest () const;
    contextRequest::reference ref_contextRequest ();
    contextRequest::reference set_contextRequest ();
    contextRequest::reference set_contextRequest (contextRequest::const_reference value);
    void omit_contextRequest ();
    bool contextRequest_isPresent () const;
    class contextAttrAuditReq {
      public:
        typedef ContextAttrAuditRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class contextAttrAuditReq
    contextAttrAuditReq::const_reference get_contextAttrAuditReq () const;
    contextAttrAuditReq::reference ref_contextAttrAuditReq ();
    contextAttrAuditReq::reference set_contextAttrAuditReq ();
    contextAttrAuditReq::reference set_contextAttrAuditReq (contextAttrAuditReq::const_reference value);
    void omit_contextAttrAuditReq ();
    bool contextAttrAuditReq_isPresent () const;
    class commandRequests {
      public:
        typedef ASN1::SEQUENCE_OF<CommandRequest>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class commandRequests
    commandRequests::const_reference get_commandRequests () const;
    commandRequests::reference ref_commandRequests ();
    commandRequests::reference set_commandRequests ();
    commandRequests::reference set_commandRequests (commandRequests::const_reference value);
    void swap(ActionRequest& other);
    ActionRequest * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// CommandReply
//

class CommandReply : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    CommandReply(const void* info) : Inherited(info) {}
  public:
    CommandReply() : Inherited(&theInfo) {}
    class addReply {
      public:
        enum Id { id_ = 0 };
        typedef AmmsReply value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class addReply

    addReply::const_reference get_addReply () const;
    addReply::reference ref_addReply (); 
    addReply::reference select_addReply (); 
    addReply::reference select_addReply (addReply::const_reference value); 
    bool addReply_isSelected() const;

    class moveReply {
      public:
        enum Id { id_ = 1 };
        typedef AmmsReply value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class moveReply

    moveReply::const_reference get_moveReply () const;
    moveReply::reference ref_moveReply (); 
    moveReply::reference select_moveReply (); 
    moveReply::reference select_moveReply (moveReply::const_reference value); 
    bool moveReply_isSelected() const;

    class modReply {
      public:
        enum Id { id_ = 2 };
        typedef AmmsReply value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class modReply

    modReply::const_reference get_modReply () const;
    modReply::reference ref_modReply (); 
    modReply::reference select_modReply (); 
    modReply::reference select_modReply (modReply::const_reference value); 
    bool modReply_isSelected() const;

    class subtractReply {
      public:
        enum Id { id_ = 3 };
        typedef AmmsReply value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class subtractReply

    subtractReply::const_reference get_subtractReply () const;
    subtractReply::reference ref_subtractReply (); 
    subtractReply::reference select_subtractReply (); 
    subtractReply::reference select_subtractReply (subtractReply::const_reference value); 
    bool subtractReply_isSelected() const;

    class auditCapReply {
      public:
        enum Id { id_ = 4 };
        typedef AuditReply value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class auditCapReply

    auditCapReply::const_reference get_auditCapReply () const;
    auditCapReply::reference ref_auditCapReply (); 
    auditCapReply::reference select_auditCapReply (); 
    auditCapReply::reference select_auditCapReply (auditCapReply::const_reference value); 
    bool auditCapReply_isSelected() const;

    class auditValueReply {
      public:
        enum Id { id_ = 5 };
        typedef AuditReply value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class auditValueReply

    auditValueReply::const_reference get_auditValueReply () const;
    auditValueReply::reference ref_auditValueReply (); 
    auditValueReply::reference select_auditValueReply (); 
    auditValueReply::reference select_auditValueReply (auditValueReply::const_reference value); 
    bool auditValueReply_isSelected() const;

    class notifyReply {
      public:
        enum Id { id_ = 6 };
        typedef NotifyReply value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class notifyReply

    notifyReply::const_reference get_notifyReply () const;
    notifyReply::reference ref_notifyReply (); 
    notifyReply::reference select_notifyReply (); 
    notifyReply::reference select_notifyReply (notifyReply::const_reference value); 
    bool notifyReply_isSelected() const;

    class serviceChangeReply {
      public:
        enum Id { id_ = 7 };
        typedef ServiceChangeReply value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class serviceChangeReply

    serviceChangeReply::const_reference get_serviceChangeReply () const;
    serviceChangeReply::reference ref_serviceChangeReply (); 
    serviceChangeReply::reference select_serviceChangeReply (); 
    serviceChangeReply::reference select_serviceChangeReply (serviceChangeReply::const_reference value); 
    bool serviceChangeReply_isSelected() const;

    CommandReply(addReply::Id id, addReply::const_reference value);
    CommandReply(moveReply::Id id, moveReply::const_reference value);
    CommandReply(modReply::Id id, modReply::const_reference value);
    CommandReply(subtractReply::Id id, subtractReply::const_reference value);
    CommandReply(auditCapReply::Id id, auditCapReply::const_reference value);
    CommandReply(auditValueReply::Id id, auditValueReply::const_reference value);
    CommandReply(notifyReply::Id id, notifyReply::const_reference value);
    CommandReply(serviceChangeReply::Id id, serviceChangeReply::const_reference value);
    void swap(CommandReply & other);
    CommandReply(const CommandReply & other)
    : Inherited(other) {} 

    CommandReply & operator = (const CommandReply & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    CommandReply * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[8];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[8];
#endif
};

//
// TransactionRequest
//

class TransactionRequest : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    TransactionRequest(const void* info) : Inherited(info) {}
  public:
    TransactionRequest() : Inherited(&theInfo) {}
    TransactionRequest(const TransactionRequest & other) : Inherited(other)
    {}
    TransactionRequest& operator = (const TransactionRequest& other)
    { Inherited::operator = (other); return *this; } 
    class transactionId {
      public:
        typedef TransactionId value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class transactionId
    transactionId::const_reference get_transactionId () const;
    transactionId::reference ref_transactionId ();
    transactionId::reference set_transactionId ();
    transactionId::reference set_transactionId (transactionId::value_type::int_type value);
    class actions {
      public:
        typedef ASN1::SEQUENCE_OF<ActionRequest>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class actions
    actions::const_reference get_actions () const;
    actions::reference ref_actions ();
    actions::reference set_actions ();
    actions::reference set_actions (actions::const_reference value);
    void swap(TransactionRequest& other);
    TransactionRequest * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// ActionReply
//

class ActionReply : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ActionReply(const void* info) : Inherited(info) {}
  public:
    ActionReply() : Inherited(&theInfo) {}
    ActionReply(const ActionReply & other) : Inherited(other)
    {}
    ActionReply& operator = (const ActionReply& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_errorDescriptor,
      e_contextReply
    };

    class contextId {
      public:
        typedef ContextID value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class contextId
    contextId::const_reference get_contextId () const;
    contextId::reference ref_contextId ();
    contextId::reference set_contextId ();
    contextId::reference set_contextId (contextId::value_type::int_type value);
    class errorDescriptor {
      public:
        typedef ErrorDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class errorDescriptor
    errorDescriptor::const_reference get_errorDescriptor () const;
    errorDescriptor::reference ref_errorDescriptor ();
    errorDescriptor::reference set_errorDescriptor ();
    errorDescriptor::reference set_errorDescriptor (errorDescriptor::const_reference value);
    void omit_errorDescriptor ();
    bool errorDescriptor_isPresent () const;
    class contextReply {
      public:
        typedef ContextRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class contextReply
    contextReply::const_reference get_contextReply () const;
    contextReply::reference ref_contextReply ();
    contextReply::reference set_contextReply ();
    contextReply::reference set_contextReply (contextReply::const_reference value);
    void omit_contextReply ();
    bool contextReply_isPresent () const;
    class commandReply {
      public:
        typedef ASN1::SEQUENCE_OF<CommandReply>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class commandReply
    commandReply::const_reference get_commandReply () const;
    commandReply::reference ref_commandReply ();
    commandReply::reference set_commandReply ();
    commandReply::reference set_commandReply (commandReply::const_reference value);
    void swap(ActionReply& other);
    ActionReply * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// TransactionReply_transactionResult
//

class TransactionReply_transactionResult : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    TransactionReply_transactionResult(const void* info) : Inherited(info) {}
  public:
    TransactionReply_transactionResult() : Inherited(&theInfo) {}
    class transactionError {
      public:
        enum Id { id_ = 0 };
        typedef ErrorDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class transactionError

    transactionError::const_reference get_transactionError () const;
    transactionError::reference ref_transactionError (); 
    transactionError::reference select_transactionError (); 
    transactionError::reference select_transactionError (transactionError::const_reference value); 
    bool transactionError_isSelected() const;

    class actionReplies {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::SEQUENCE_OF<ActionReply>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class actionReplies

    actionReplies::const_reference get_actionReplies () const;
    actionReplies::reference ref_actionReplies (); 
    actionReplies::reference select_actionReplies (); 
    actionReplies::reference select_actionReplies (actionReplies::const_reference value); 
    bool actionReplies_isSelected() const;

    TransactionReply_transactionResult(transactionError::Id id, transactionError::const_reference value);
    TransactionReply_transactionResult(actionReplies::Id id, actionReplies::const_reference value);
    void swap(TransactionReply_transactionResult & other);
    TransactionReply_transactionResult(const TransactionReply_transactionResult & other)
    : Inherited(other) {} 

    TransactionReply_transactionResult & operator = (const TransactionReply_transactionResult & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    TransactionReply_transactionResult * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// TransactionReply
//

class TransactionReply : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    TransactionReply(const void* info) : Inherited(info) {}
  public:
    TransactionReply() : Inherited(&theInfo) {}
    TransactionReply(const TransactionReply & other) : Inherited(other)
    {}
    TransactionReply& operator = (const TransactionReply& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_immAckRequired
    };

    class transactionId {
      public:
        typedef TransactionId value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class transactionId
    transactionId::const_reference get_transactionId () const;
    transactionId::reference ref_transactionId ();
    transactionId::reference set_transactionId ();
    transactionId::reference set_transactionId (transactionId::value_type::int_type value);
    class immAckRequired {
      public:
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class immAckRequired
    immAckRequired::reference set_immAckRequired ();
    void omit_immAckRequired ();
    bool immAckRequired_isPresent () const;
    class transactionResult {
      public:
        typedef TransactionReply_transactionResult value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class transactionResult
    transactionResult::const_reference get_transactionResult () const;
    transactionResult::reference ref_transactionResult ();
    transactionResult::reference set_transactionResult ();
    transactionResult::reference set_transactionResult (transactionResult::const_reference value);
    void swap(TransactionReply& other);
    TransactionReply * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// Transaction
//

class Transaction : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    Transaction(const void* info) : Inherited(info) {}
  public:
    Transaction() : Inherited(&theInfo) {}
    class transactionRequest {
      public:
        enum Id { id_ = 0 };
        typedef TransactionRequest value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class transactionRequest

    transactionRequest::const_reference get_transactionRequest () const;
    transactionRequest::reference ref_transactionRequest (); 
    transactionRequest::reference select_transactionRequest (); 
    transactionRequest::reference select_transactionRequest (transactionRequest::const_reference value); 
    bool transactionRequest_isSelected() const;

    class transactionPending {
      public:
        enum Id { id_ = 1 };
        typedef TransactionPending value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class transactionPending

    transactionPending::const_reference get_transactionPending () const;
    transactionPending::reference ref_transactionPending (); 
    transactionPending::reference select_transactionPending (); 
    transactionPending::reference select_transactionPending (transactionPending::const_reference value); 
    bool transactionPending_isSelected() const;

    class transactionReply {
      public:
        enum Id { id_ = 2 };
        typedef TransactionReply value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class transactionReply

    transactionReply::const_reference get_transactionReply () const;
    transactionReply::reference ref_transactionReply (); 
    transactionReply::reference select_transactionReply (); 
    transactionReply::reference select_transactionReply (transactionReply::const_reference value); 
    bool transactionReply_isSelected() const;

    class transactionResponseAck {
      public:
        enum Id { id_ = 3 };
        typedef TransactionResponseAck value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class transactionResponseAck

    transactionResponseAck::const_reference get_transactionResponseAck () const;
    transactionResponseAck::reference ref_transactionResponseAck (); 
    transactionResponseAck::reference select_transactionResponseAck (); 
    transactionResponseAck::reference select_transactionResponseAck (transactionResponseAck::const_reference value); 
    bool transactionResponseAck_isSelected() const;

    Transaction(transactionRequest::Id id, transactionRequest::const_reference value);
    Transaction(transactionPending::Id id, transactionPending::const_reference value);
    Transaction(transactionReply::Id id, transactionReply::const_reference value);
    Transaction(transactionResponseAck::Id id, transactionResponseAck::const_reference value);
    void swap(Transaction & other);
    Transaction(const Transaction & other)
    : Inherited(other) {} 

    Transaction & operator = (const Transaction & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    Transaction * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[4];
#endif
};

//
// Message_messageBody
//

class Message_messageBody : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    Message_messageBody(const void* info) : Inherited(info) {}
  public:
    Message_messageBody() : Inherited(&theInfo) {}
    class messageError {
      public:
        enum Id { id_ = 0 };
        typedef ErrorDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class messageError

    messageError::const_reference get_messageError () const;
    messageError::reference ref_messageError (); 
    messageError::reference select_messageError (); 
    messageError::reference select_messageError (messageError::const_reference value); 
    bool messageError_isSelected() const;

    class transactions {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::SEQUENCE_OF<Transaction>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class transactions

    transactions::const_reference get_transactions () const;
    transactions::reference ref_transactions (); 
    transactions::reference select_transactions (); 
    transactions::reference select_transactions (transactions::const_reference value); 
    bool transactions_isSelected() const;

    Message_messageBody(messageError::Id id, messageError::const_reference value);
    Message_messageBody(transactions::Id id, transactions::const_reference value);
    void swap(Message_messageBody & other);
    Message_messageBody(const Message_messageBody & other)
    : Inherited(other) {} 

    Message_messageBody & operator = (const Message_messageBody & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    Message_messageBody * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// Message
//

class Message : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    Message(const void* info) : Inherited(info) {}
  public:
    Message() : Inherited(&theInfo) {}
    Message(const Message & other) : Inherited(other)
    {}
    Message& operator = (const Message& other)
    { Inherited::operator = (other); return *this; } 
    class version {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 99>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class version
    version::const_reference get_version () const;
    version::reference ref_version ();
    version::reference set_version ();
    version::reference set_version (version::value_type::int_type value);
    class mId {
      public:
        typedef MId value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mId
    mId::const_reference get_mId () const;
    mId::reference ref_mId ();
    mId::reference set_mId ();
    mId::reference set_mId (mId::const_reference value);
    class messageBody {
      public:
        typedef Message_messageBody value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class messageBody
    messageBody::const_reference get_messageBody () const;
    messageBody::reference ref_messageBody ();
    messageBody::reference set_messageBody ();
    messageBody::reference set_messageBody (messageBody::const_reference value);
    void swap(Message& other);
    Message * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// MegacoMessage
//

class MegacoMessage : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MegacoMessage(const void* info) : Inherited(info) {}
  public:
    MegacoMessage() : Inherited(&theInfo) {}
    MegacoMessage(const MegacoMessage & other) : Inherited(other)
    {}
    MegacoMessage& operator = (const MegacoMessage& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_authHeader
    };

    class authHeader {
      public:
        typedef AuthenticationHeader value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class authHeader
    authHeader::const_reference get_authHeader () const;
    authHeader::reference ref_authHeader ();
    authHeader::reference set_authHeader ();
    authHeader::reference set_authHeader (authHeader::const_reference value);
    void omit_authHeader ();
    bool authHeader_isPresent () const;
    class mess {
      public:
        typedef Message value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mess
    mess::const_reference get_mess () const;
    mess::reference ref_mess ();
    mess::reference set_mess ();
    mess::reference set_mess (mess::const_reference value);
    void swap(MegacoMessage& other);
    MegacoMessage * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

#include "media_gateway_control.inl"
} // namespace MEDIA_GATEWAY_CONTROL

#endif // __MEDIA_GATEWAY_CONTROL_H


// End of media_gateway_control.h
