//
// message_waiting_indication_operations.h
//
// Code automatically generated by asnparser.
//

#ifndef __MESSAGE_WAITING_INDICATION_OPERATIONS_H
#define __MESSAGE_WAITING_INDICATION_OPERATIONS_H

#include <asn1.h>

#include "remote_operations_information_objects.h"
#include "manufacturer_specific_service_extension_definition.h"
#include "h4501_general_error_list.h"
#include "addressing_data_elements.h"
#include "call_hold_operations.h"


namespace Message_Waiting_Indication_Operations {

using Remote_Operations_Information_Objects::ERROR;
using Remote_Operations_Information_Objects::OPERATION;
using Manufacturer_specific_service_extension_definition::EXTENSION;
typedef ASN1::SEQUENCE_OF<Call_Hold_Operations::MixedExtension,  ASN1::SizeConstraint<ASN1::FixedConstraint, 0, 255> >  DummyRes;

//
// MsgCentreId
//

class MsgCentreId : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    MsgCentreId(const void* info) : Inherited(info) {}
  public:
    MsgCentreId() : Inherited(&theInfo) {}
    class integer {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class integer

    integer::const_reference get_integer () const;
    integer::reference ref_integer (); 
    integer::reference select_integer (); 
    integer::reference select_integer (integer::value_type::int_type value); 
    bool integer_isSelected() const;

    class partyNumber {
      public:
        enum Id { id_ = 1 };
        typedef Addressing_Data_Elements::EndpointAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class partyNumber

    partyNumber::const_reference get_partyNumber () const;
    partyNumber::reference ref_partyNumber (); 
    partyNumber::reference select_partyNumber (); 
    partyNumber::reference select_partyNumber (partyNumber::const_reference value); 
    bool partyNumber_isSelected() const;

    class numericString {
      public:
        enum Id { id_ = 2 };
        class value_type : public ASN1::NumericString
        {
            typedef ASN1::NumericString Inherited;
          protected:
            value_type(const void* info) : Inherited(info) {}
          public:
            value_type() : Inherited(&theInfo) { }
            value_type(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const char* str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const value_type& other) : Inherited(other) {}
            value_type& operator = (const std::string& other)
            { Inherited::operator=(other); return *this;}
            value_type& operator = (const char* other)
            { Inherited::operator=(other); return *this;}
            value_type * clone() const;
            static bool equal_type(const ASN1::AbstractData&);
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
        };

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class numericString

    numericString::const_reference get_numericString () const;
    numericString::reference ref_numericString (); 
    numericString::reference select_numericString (); 
    numericString::reference select_numericString (const std::string& value); 
    bool numericString_isSelected() const;

    MsgCentreId(integer::Id id, integer::value_type::int_type value);
    MsgCentreId(partyNumber::Id id, partyNumber::const_reference value);
    MsgCentreId(numericString::Id id, const std::string& value);
    void swap(MsgCentreId & other);
    MsgCentreId(const MsgCentreId & other)
    : Inherited(other) {} 

    MsgCentreId & operator = (const MsgCentreId & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    MsgCentreId * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  NbOfMessages;

typedef ASN1::GeneralizedTime TimeStamp;

//
// BasicService
//

class BasicService : public ASN1::ENUMERATED
{
    typedef ASN1::ENUMERATED Inherited;
  protected:
    BasicService(const void* info) : Inherited(info) {}
  public:
    BasicService() : Inherited(&theInfo) { }
    enum NamedNumber {
      unknownEnumeration_ = -1,
      allServices,
      speech,
      unrestrictedDigitalInformation,
      audio3100Hz,
      telephony = 32,
      teletex,
      telefaxGroup4Class1,
      videotexSyntaxBased,
      videotelephony
    };

    bool is_allServices() const { return value == allServices; }
    void set_allServices() { value = allServices; }

    bool is_speech() const { return value == speech; }
    void set_speech() { value = speech; }

    bool is_unrestrictedDigitalInformation() const { return value == unrestrictedDigitalInformation; }
    void set_unrestrictedDigitalInformation() { value = unrestrictedDigitalInformation; }

    bool is_audio3100Hz() const { return value == audio3100Hz; }
    void set_audio3100Hz() { value = audio3100Hz; }

    bool is_telephony() const { return value == telephony; }
    void set_telephony() { value = telephony; }

    bool is_teletex() const { return value == teletex; }
    void set_teletex() { value = teletex; }

    bool is_telefaxGroup4Class1() const { return value == telefaxGroup4Class1; }
    void set_telefaxGroup4Class1() { value = telefaxGroup4Class1; }

    bool is_videotexSyntaxBased() const { return value == videotexSyntaxBased; }
    void set_videotexSyntaxBased() { value = videotexSyntaxBased; }

    bool is_videotelephony() const { return value == videotelephony; }
    void set_videotelephony() { value = videotelephony; }

    BasicService(const NamedNumber value) : Inherited(&theInfo){ setFromInt(value); }
    BasicService & operator=(const NamedNumber v) { setFromInt(v);  return *this; }
    operator NamedNumber() const
    { return NamedNumber(asInt()); }

    void swap (BasicService & other)
    { ENUMERATED::swap(other); }
    BasicService * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
};

//
// MWIActivateArg
//

class MWIActivateArg : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MWIActivateArg(const void* info) : Inherited(info) {}
  public:
    MWIActivateArg() : Inherited(&theInfo) {}
    MWIActivateArg(const MWIActivateArg & other) : Inherited(other)
    {}
    MWIActivateArg& operator = (const MWIActivateArg& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_msgCentreId,
      e_nbOfMessages,
      e_originatingNr,
      e_timestamp,
      e_priority,
      e_extensionArg
    };

    class servedUserNr {
      public:
        typedef Addressing_Data_Elements::EndpointAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class servedUserNr
    servedUserNr::const_reference get_servedUserNr () const;
    servedUserNr::reference ref_servedUserNr ();
    servedUserNr::reference set_servedUserNr ();
    servedUserNr::reference set_servedUserNr (servedUserNr::const_reference value);
    class basicService {
      public:
        typedef BasicService value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class basicService
    basicService::const_reference get_basicService () const;
    basicService::reference ref_basicService ();
    basicService::reference set_basicService ();
    basicService::reference set_basicService (basicService::value_type::NamedNumber value);
    class msgCentreId {
      public:
        typedef MsgCentreId value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class msgCentreId
    msgCentreId::const_reference get_msgCentreId () const;
    msgCentreId::reference ref_msgCentreId ();
    msgCentreId::reference set_msgCentreId ();
    msgCentreId::reference set_msgCentreId (msgCentreId::const_reference value);
    void omit_msgCentreId ();
    bool msgCentreId_isPresent () const;
    class nbOfMessages {
      public:
        typedef NbOfMessages value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nbOfMessages
    nbOfMessages::const_reference get_nbOfMessages () const;
    nbOfMessages::reference ref_nbOfMessages ();
    nbOfMessages::reference set_nbOfMessages ();
    nbOfMessages::reference set_nbOfMessages (nbOfMessages::value_type::int_type value);
    void omit_nbOfMessages ();
    bool nbOfMessages_isPresent () const;
    class originatingNr {
      public:
        typedef Addressing_Data_Elements::EndpointAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class originatingNr
    originatingNr::const_reference get_originatingNr () const;
    originatingNr::reference ref_originatingNr ();
    originatingNr::reference set_originatingNr ();
    originatingNr::reference set_originatingNr (originatingNr::const_reference value);
    void omit_originatingNr ();
    bool originatingNr_isPresent () const;
    class timestamp {
      public:
        typedef TimeStamp value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class timestamp
    timestamp::const_reference get_timestamp () const;
    timestamp::reference ref_timestamp ();
    timestamp::reference set_timestamp ();
    timestamp::reference set_timestamp (const char* value);
    void omit_timestamp ();
    bool timestamp_isPresent () const;
    class priority {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 9>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class priority
    priority::const_reference get_priority () const;
    priority::reference ref_priority ();
    priority::reference set_priority ();
    priority::reference set_priority (priority::value_type::int_type value);
    void omit_priority ();
    bool priority_isPresent () const;
    class extensionArg {
      public:
        typedef ASN1::SEQUENCE_OF<Call_Hold_Operations::MixedExtension,  ASN1::SizeConstraint<ASN1::FixedConstraint, 0, 255> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class extensionArg
    extensionArg::const_reference get_extensionArg () const;
    extensionArg::reference ref_extensionArg ();
    extensionArg::reference set_extensionArg ();
    extensionArg::reference set_extensionArg (extensionArg::const_reference value);
    void omit_extensionArg ();
    bool extensionArg_isPresent () const;
    void swap(MWIActivateArg& other);
    MWIActivateArg * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[8];
    static int fieldIds[8];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[8];
#endif
};

//
// MWIDeactivateArg
//

class MWIDeactivateArg : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MWIDeactivateArg(const void* info) : Inherited(info) {}
  public:
    MWIDeactivateArg() : Inherited(&theInfo) {}
    MWIDeactivateArg(const MWIDeactivateArg & other) : Inherited(other)
    {}
    MWIDeactivateArg& operator = (const MWIDeactivateArg& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_msgCentreId,
      e_callbackReq,
      e_extensionArg
    };

    class servedUserNr {
      public:
        typedef Addressing_Data_Elements::EndpointAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class servedUserNr
    servedUserNr::const_reference get_servedUserNr () const;
    servedUserNr::reference ref_servedUserNr ();
    servedUserNr::reference set_servedUserNr ();
    servedUserNr::reference set_servedUserNr (servedUserNr::const_reference value);
    class basicService {
      public:
        typedef BasicService value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class basicService
    basicService::const_reference get_basicService () const;
    basicService::reference ref_basicService ();
    basicService::reference set_basicService ();
    basicService::reference set_basicService (basicService::value_type::NamedNumber value);
    class msgCentreId {
      public:
        typedef MsgCentreId value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class msgCentreId
    msgCentreId::const_reference get_msgCentreId () const;
    msgCentreId::reference ref_msgCentreId ();
    msgCentreId::reference set_msgCentreId ();
    msgCentreId::reference set_msgCentreId (msgCentreId::const_reference value);
    void omit_msgCentreId ();
    bool msgCentreId_isPresent () const;
    class callbackReq {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callbackReq
    callbackReq::const_reference get_callbackReq () const;
    callbackReq::reference ref_callbackReq ();
    callbackReq::reference set_callbackReq ();
    callbackReq::reference set_callbackReq (bool value);
    void omit_callbackReq ();
    bool callbackReq_isPresent () const;
    class extensionArg {
      public:
        typedef ASN1::SEQUENCE_OF<Call_Hold_Operations::MixedExtension,  ASN1::SizeConstraint<ASN1::FixedConstraint, 0, 255> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class extensionArg
    extensionArg::const_reference get_extensionArg () const;
    extensionArg::reference ref_extensionArg ();
    extensionArg::reference set_extensionArg ();
    extensionArg::reference set_extensionArg (extensionArg::const_reference value);
    void omit_extensionArg ();
    bool extensionArg_isPresent () const;
    void swap(MWIDeactivateArg& other);
    MWIDeactivateArg * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[5];
    static int fieldIds[5];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[5];
#endif
};

//
// MWIInterrogateArg
//

class MWIInterrogateArg : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MWIInterrogateArg(const void* info) : Inherited(info) {}
  public:
    MWIInterrogateArg() : Inherited(&theInfo) {}
    MWIInterrogateArg(const MWIInterrogateArg & other) : Inherited(other)
    {}
    MWIInterrogateArg& operator = (const MWIInterrogateArg& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_msgCentreId,
      e_callbackReq,
      e_extensionArg
    };

    class servedUserNr {
      public:
        typedef Addressing_Data_Elements::EndpointAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class servedUserNr
    servedUserNr::const_reference get_servedUserNr () const;
    servedUserNr::reference ref_servedUserNr ();
    servedUserNr::reference set_servedUserNr ();
    servedUserNr::reference set_servedUserNr (servedUserNr::const_reference value);
    class basicService {
      public:
        typedef BasicService value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class basicService
    basicService::const_reference get_basicService () const;
    basicService::reference ref_basicService ();
    basicService::reference set_basicService ();
    basicService::reference set_basicService (basicService::value_type::NamedNumber value);
    class msgCentreId {
      public:
        typedef MsgCentreId value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class msgCentreId
    msgCentreId::const_reference get_msgCentreId () const;
    msgCentreId::reference ref_msgCentreId ();
    msgCentreId::reference set_msgCentreId ();
    msgCentreId::reference set_msgCentreId (msgCentreId::const_reference value);
    void omit_msgCentreId ();
    bool msgCentreId_isPresent () const;
    class callbackReq {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class callbackReq
    callbackReq::const_reference get_callbackReq () const;
    callbackReq::reference ref_callbackReq ();
    callbackReq::reference set_callbackReq ();
    callbackReq::reference set_callbackReq (bool value);
    void omit_callbackReq ();
    bool callbackReq_isPresent () const;
    class extensionArg {
      public:
        typedef ASN1::SEQUENCE_OF<Call_Hold_Operations::MixedExtension,  ASN1::SizeConstraint<ASN1::FixedConstraint, 0, 255> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class extensionArg
    extensionArg::const_reference get_extensionArg () const;
    extensionArg::reference ref_extensionArg ();
    extensionArg::reference set_extensionArg ();
    extensionArg::reference set_extensionArg (extensionArg::const_reference value);
    void omit_extensionArg ();
    bool extensionArg_isPresent () const;
    void swap(MWIInterrogateArg& other);
    MWIInterrogateArg * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[5];
    static int fieldIds[5];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[5];
#endif
};

//
// MWIInterrogateResElt
//

class MWIInterrogateResElt : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MWIInterrogateResElt(const void* info) : Inherited(info) {}
  public:
    MWIInterrogateResElt() : Inherited(&theInfo) {}
    MWIInterrogateResElt(const MWIInterrogateResElt & other) : Inherited(other)
    {}
    MWIInterrogateResElt& operator = (const MWIInterrogateResElt& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_msgCentreId,
      e_nbOfMessages,
      e_originatingNr,
      e_timestamp,
      e_priority,
      e_extensionArg
    };

    class basicService {
      public:
        typedef BasicService value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class basicService
    basicService::const_reference get_basicService () const;
    basicService::reference ref_basicService ();
    basicService::reference set_basicService ();
    basicService::reference set_basicService (basicService::value_type::NamedNumber value);
    class msgCentreId {
      public:
        typedef MsgCentreId value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class msgCentreId
    msgCentreId::const_reference get_msgCentreId () const;
    msgCentreId::reference ref_msgCentreId ();
    msgCentreId::reference set_msgCentreId ();
    msgCentreId::reference set_msgCentreId (msgCentreId::const_reference value);
    void omit_msgCentreId ();
    bool msgCentreId_isPresent () const;
    class nbOfMessages {
      public:
        typedef NbOfMessages value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nbOfMessages
    nbOfMessages::const_reference get_nbOfMessages () const;
    nbOfMessages::reference ref_nbOfMessages ();
    nbOfMessages::reference set_nbOfMessages ();
    nbOfMessages::reference set_nbOfMessages (nbOfMessages::value_type::int_type value);
    void omit_nbOfMessages ();
    bool nbOfMessages_isPresent () const;
    class originatingNr {
      public:
        typedef Addressing_Data_Elements::EndpointAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class originatingNr
    originatingNr::const_reference get_originatingNr () const;
    originatingNr::reference ref_originatingNr ();
    originatingNr::reference set_originatingNr ();
    originatingNr::reference set_originatingNr (originatingNr::const_reference value);
    void omit_originatingNr ();
    bool originatingNr_isPresent () const;
    class timestamp {
      public:
        typedef TimeStamp value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class timestamp
    timestamp::const_reference get_timestamp () const;
    timestamp::reference ref_timestamp ();
    timestamp::reference set_timestamp ();
    timestamp::reference set_timestamp (const char* value);
    void omit_timestamp ();
    bool timestamp_isPresent () const;
    class priority {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 9>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class priority
    priority::const_reference get_priority () const;
    priority::reference ref_priority ();
    priority::reference set_priority ();
    priority::reference set_priority (priority::value_type::int_type value);
    void omit_priority ();
    bool priority_isPresent () const;
    class extensionArg {
      public:
        typedef ASN1::SEQUENCE_OF<Call_Hold_Operations::MixedExtension,  ASN1::SizeConstraint<ASN1::FixedConstraint, 0, 255> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class extensionArg
    extensionArg::const_reference get_extensionArg () const;
    extensionArg::reference ref_extensionArg ();
    extensionArg::reference set_extensionArg ();
    extensionArg::reference set_extensionArg (extensionArg::const_reference value);
    void omit_extensionArg ();
    bool extensionArg_isPresent () const;
    void swap(MWIInterrogateResElt& other);
    MWIInterrogateResElt * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[7];
    static int fieldIds[7];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[7];
#endif
};

typedef ASN1::SEQUENCE_OF<MWIInterrogateResElt,  ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 64> >  MWIInterrogateRes;

class Module : public ASN1::Module
{
  public:
    Module(H4501_General_Error_List::Module* );
    class mwiActivate
    {
      public:
        mwiActivate();
        typedef MWIActivateArg ArgumentType;
        typedef DummyRes ResultType;
        ERROR Errors;
        const Remote_Operations_Information_Objects::Code operationCode;
        OPERATION::value_type make() const
        { return OPERATION::value_type(operationCode,&info ); }
      private:
        class Info : public OPERATION::info_type
        {
          public:
            Info(mwiActivate* parent)
            {
                m_ArgumentType= &ArgumentType::theInfo;
                m_ResultType= &ResultType::theInfo;
                m_Errors= &(parent-> Errors);
            }
        };
        Info info;
    }; // class mwiActivate
    class mwiDeactivate
    {
      public:
        mwiDeactivate();
        typedef MWIDeactivateArg ArgumentType;
        typedef DummyRes ResultType;
        ERROR Errors;
        const Remote_Operations_Information_Objects::Code operationCode;
        OPERATION::value_type make() const
        { return OPERATION::value_type(operationCode,&info ); }
      private:
        class Info : public OPERATION::info_type
        {
          public:
            Info(mwiDeactivate* parent)
            {
                m_ArgumentType= &ArgumentType::theInfo;
                m_ResultType= &ResultType::theInfo;
                m_Errors= &(parent-> Errors);
            }
        };
        Info info;
    }; // class mwiDeactivate
    class mwiInterrogate
    {
      public:
        mwiInterrogate();
        typedef MWIInterrogateArg ArgumentType;
        typedef MWIInterrogateRes ResultType;
        ERROR Errors;
        const Remote_Operations_Information_Objects::Code operationCode;
        OPERATION::value_type make() const
        { return OPERATION::value_type(operationCode,&info ); }
      private:
        class Info : public OPERATION::info_type
        {
          public:
            Info(mwiInterrogate* parent)
            {
                m_ArgumentType= &ArgumentType::theInfo;
                m_ResultType= &ResultType::theInfo;
                m_Errors= &(parent-> Errors);
            }
        };
        Info info;
    }; // class mwiInterrogate
    class undefined
    {
      public:
        undefined();
        typedef ASN1::SEQUENCE_OF<Call_Hold_Operations::MixedExtension,  ASN1::SizeConstraint<ASN1::FixedConstraint, 0, 255> >  ParameterType;

        const Remote_Operations_Information_Objects::Code errorCode;
        ERROR::value_type make() const
        { return ERROR::value_type(errorCode,&info ); }
      private:
        class Info : public ERROR::info_type
        {
          public:
            Info()
            {
                m_ParameterType= &ParameterType::theInfo;
            }
        };
        Info info;
    }; // class undefined
    class invalidMsgCentreId
    {
      public:
        invalidMsgCentreId();
        const Remote_Operations_Information_Objects::Code errorCode;
        ERROR::value_type make() const
        { return ERROR::value_type(errorCode,&info ); }
      private:
        typedef ERROR::info_type Info;
        Info info;
    }; // class invalidMsgCentreId
    class notActivated
    {
      public:
        notActivated();
        const Remote_Operations_Information_Objects::Code errorCode;
        ERROR::value_type make() const
        { return ERROR::value_type(errorCode,&info ); }
      private:
        typedef ERROR::info_type Info;
        Info info;
    }; // class notActivated
    const mwiActivate& get_mwiActivate() const
    {  return m_mwiActivate; }
    const mwiDeactivate& get_mwiDeactivate() const
    {  return m_mwiDeactivate; }
    const mwiInterrogate& get_mwiInterrogate() const
    {  return m_mwiInterrogate; }
    const undefined& get_undefined() const
    {  return m_undefined; }
    const invalidMsgCentreId& get_invalidMsgCentreId() const
    {  return m_invalidMsgCentreId; }
    const notActivated& get_notActivated() const
    {  return m_notActivated; }
    const OPERATION& get_H323_MWI_Operations() const
    {  return m_H323_MWI_Operations; }
  private:
    mwiActivate m_mwiActivate;
    mwiDeactivate m_mwiDeactivate;
    mwiInterrogate m_mwiInterrogate;
    undefined m_undefined;
    invalidMsgCentreId m_invalidMsgCentreId;
    notActivated m_notActivated;
    OPERATION m_H323_MWI_Operations;
}; // class Module 
#include "message_waiting_indication_operations.inl"
} // namespace Message_Waiting_Indication_Operations

#endif // __MESSAGE_WAITING_INDICATION_OPERATIONS_H


// End of message_waiting_indication_operations.h
