//
// msc_openlogicalchannel.h
//
// Code automatically generated by asnparser.
//

#ifndef __MSC_OPENLOGICALCHANNEL_H
#define __MSC_OPENLOGICALCHANNEL_H

#include <asn1.h>

#include "msc_t38faxprofile.h"
#include "msc_transportaddress.h"
#include "msc_capabilitytableentry.h"


namespace MULTIMEDIA_SYSTEM_CONTROL {

//
// H222LogicalChannelParameters
//

class H222LogicalChannelParameters : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    H222LogicalChannelParameters(const void* info) : Inherited(info) {}
  public:
    H222LogicalChannelParameters() : Inherited(&theInfo) {}
    H222LogicalChannelParameters(const H222LogicalChannelParameters & other) : Inherited(other)
    {}
    H222LogicalChannelParameters& operator = (const H222LogicalChannelParameters& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_pcr_pid,
      e_programDescriptors,
      e_streamDescriptors
    };

    class resourceID {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class resourceID
    resourceID::const_reference get_resourceID () const;
    resourceID::reference ref_resourceID ();
    resourceID::reference set_resourceID ();
    resourceID::reference set_resourceID (resourceID::value_type::int_type value);
    class subChannelID {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 8191>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class subChannelID
    subChannelID::const_reference get_subChannelID () const;
    subChannelID::reference ref_subChannelID ();
    subChannelID::reference set_subChannelID ();
    subChannelID::reference set_subChannelID (subChannelID::value_type::int_type value);
    class pcr_pid {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 8191>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class pcr_pid
    pcr_pid::const_reference get_pcr_pid () const;
    pcr_pid::reference ref_pcr_pid ();
    pcr_pid::reference set_pcr_pid ();
    pcr_pid::reference set_pcr_pid (pcr_pid::value_type::int_type value);
    void omit_pcr_pid ();
    bool pcr_pid_isPresent () const;
    class programDescriptors {
      public:
        typedef ASN1::OCTET_STRING value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class programDescriptors
    programDescriptors::const_reference get_programDescriptors () const;
    programDescriptors::reference ref_programDescriptors ();
    programDescriptors::reference set_programDescriptors ();
    programDescriptors::reference set_programDescriptors (const std::vector<char>& value);
    void omit_programDescriptors ();
    bool programDescriptors_isPresent () const;
    class streamDescriptors {
      public:
        typedef ASN1::OCTET_STRING value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class streamDescriptors
    streamDescriptors::const_reference get_streamDescriptors () const;
    streamDescriptors::reference ref_streamDescriptors ();
    streamDescriptors::reference set_streamDescriptors ();
    streamDescriptors::reference set_streamDescriptors (const std::vector<char>& value);
    void omit_streamDescriptors ();
    bool streamDescriptors_isPresent () const;
    void swap(H222LogicalChannelParameters& other);
    H222LogicalChannelParameters * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[5];
    static int fieldIds[5];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[5];
#endif
};

typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 65535>  LogicalChannelNumber;

//
// H2250LogicalChannelAckParameters
//

class H2250LogicalChannelAckParameters : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    H2250LogicalChannelAckParameters(const void* info) : Inherited(info) {}
  public:
    H2250LogicalChannelAckParameters() : Inherited(&theInfo) {}
    H2250LogicalChannelAckParameters(const H2250LogicalChannelAckParameters & other) : Inherited(other)
    {}
    H2250LogicalChannelAckParameters& operator = (const H2250LogicalChannelAckParameters& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandard,
      e_sessionID,
      e_mediaChannel,
      e_mediaControlChannel,
      e_dynamicRTPPayloadType,
      e_flowControlToZero,
      e_portNumber
    };

    class nonStandard {
      public:
        typedef ASN1::SEQUENCE_OF<NonStandardParameter>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard
    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard ();
    nonStandard::reference set_nonStandard ();
    nonStandard::reference set_nonStandard (nonStandard::const_reference value);
    void omit_nonStandard ();
    bool nonStandard_isPresent () const;
    class sessionID {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 255>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sessionID
    sessionID::const_reference get_sessionID () const;
    sessionID::reference ref_sessionID ();
    sessionID::reference set_sessionID ();
    sessionID::reference set_sessionID (sessionID::value_type::int_type value);
    void omit_sessionID ();
    bool sessionID_isPresent () const;
    class mediaChannel {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mediaChannel
    mediaChannel::const_reference get_mediaChannel () const;
    mediaChannel::reference ref_mediaChannel ();
    mediaChannel::reference set_mediaChannel ();
    mediaChannel::reference set_mediaChannel (mediaChannel::const_reference value);
    void omit_mediaChannel ();
    bool mediaChannel_isPresent () const;
    class mediaControlChannel {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mediaControlChannel
    mediaControlChannel::const_reference get_mediaControlChannel () const;
    mediaControlChannel::reference ref_mediaControlChannel ();
    mediaControlChannel::reference set_mediaControlChannel ();
    mediaControlChannel::reference set_mediaControlChannel (mediaControlChannel::const_reference value);
    void omit_mediaControlChannel ();
    bool mediaControlChannel_isPresent () const;
    class dynamicRTPPayloadType {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 96, 127>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class dynamicRTPPayloadType
    dynamicRTPPayloadType::const_reference get_dynamicRTPPayloadType () const;
    dynamicRTPPayloadType::reference ref_dynamicRTPPayloadType ();
    dynamicRTPPayloadType::reference set_dynamicRTPPayloadType ();
    dynamicRTPPayloadType::reference set_dynamicRTPPayloadType (dynamicRTPPayloadType::value_type::int_type value);
    void omit_dynamicRTPPayloadType ();
    bool dynamicRTPPayloadType_isPresent () const;
    class flowControlToZero {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class flowControlToZero
    flowControlToZero::const_reference get_flowControlToZero () const;
    flowControlToZero::reference ref_flowControlToZero ();
    flowControlToZero::reference set_flowControlToZero ();
    flowControlToZero::reference set_flowControlToZero (bool value);
    void omit_flowControlToZero ();
    bool flowControlToZero_isPresent () const;
    class portNumber {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class portNumber
    portNumber::const_reference get_portNumber () const;
    portNumber::reference ref_portNumber ();
    portNumber::reference set_portNumber ();
    portNumber::reference set_portNumber (portNumber::value_type::int_type value);
    void omit_portNumber ();
    bool portNumber_isPresent () const;
    void swap(H2250LogicalChannelAckParameters& other);
    H2250LogicalChannelAckParameters * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[7];
    static int fieldIds[7];
    static const char* nonOptionalExtensions;
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[7];
#endif
};

//
// MultiplexedStreamParameter
//

class MultiplexedStreamParameter : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MultiplexedStreamParameter(const void* info) : Inherited(info) {}
  public:
    MultiplexedStreamParameter() : Inherited(&theInfo) {}
    MultiplexedStreamParameter(const MultiplexedStreamParameter & other) : Inherited(other)
    {}
    MultiplexedStreamParameter& operator = (const MultiplexedStreamParameter& other)
    { Inherited::operator = (other); return *this; } 
    class multiplexFormat {
      public:
        typedef MultiplexFormat value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multiplexFormat
    multiplexFormat::const_reference get_multiplexFormat () const;
    multiplexFormat::reference ref_multiplexFormat ();
    multiplexFormat::reference set_multiplexFormat ();
    multiplexFormat::reference set_multiplexFormat (multiplexFormat::const_reference value);
    class controlOnMuxStream {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class controlOnMuxStream
    controlOnMuxStream::const_reference get_controlOnMuxStream () const;
    controlOnMuxStream::reference ref_controlOnMuxStream ();
    controlOnMuxStream::reference set_controlOnMuxStream ();
    controlOnMuxStream::reference set_controlOnMuxStream (bool value);
    void swap(MultiplexedStreamParameter& other);
    MultiplexedStreamParameter * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// EncryptionMode
//

class EncryptionMode : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    EncryptionMode(const void* info) : Inherited(info) {}
  public:
    EncryptionMode() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class h233Encryption {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h233Encryption

    h233Encryption::reference select_h233Encryption (); 
    bool h233Encryption_isSelected() const;

    EncryptionMode(nonStandard::Id id, nonStandard::const_reference value);
    EncryptionMode(h233Encryption::Id id, h233Encryption::const_reference value);
    void swap(EncryptionMode & other);
    EncryptionMode(const EncryptionMode & other)
    : Inherited(other) {} 

    EncryptionMode & operator = (const EncryptionMode & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    EncryptionMode * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// V75Parameters
//

class V75Parameters : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    V75Parameters(const void* info) : Inherited(info) {}
  public:
    V75Parameters() : Inherited(&theInfo) {}
    V75Parameters(const V75Parameters & other) : Inherited(other)
    {}
    V75Parameters& operator = (const V75Parameters& other)
    { Inherited::operator = (other); return *this; } 
    class audioHeaderPresent {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioHeaderPresent
    audioHeaderPresent::const_reference get_audioHeaderPresent () const;
    audioHeaderPresent::reference ref_audioHeaderPresent ();
    audioHeaderPresent::reference set_audioHeaderPresent ();
    audioHeaderPresent::reference set_audioHeaderPresent (bool value);
    void swap(V75Parameters& other);
    V75Parameters * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// EscrowData
//

class EscrowData : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    EscrowData(const void* info) : Inherited(info) {}
  public:
    EscrowData() : Inherited(&theInfo) {}
    EscrowData(const EscrowData & other) : Inherited(other)
    {}
    EscrowData& operator = (const EscrowData& other)
    { Inherited::operator = (other); return *this; } 
    class escrowID {
      public:
        typedef ASN1::OBJECT_IDENTIFIER value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class escrowID
    escrowID::const_reference get_escrowID () const;
    escrowID::reference ref_escrowID ();
    escrowID::reference set_escrowID ();
    escrowID::reference set_escrowID (escrowID::const_reference value);
    class escrowValue {
      public:
        typedef ASN1::Constrained_BIT_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 65535> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class escrowValue
    escrowValue::const_reference get_escrowValue () const;
    escrowValue::reference ref_escrowValue ();
    escrowValue::reference set_escrowValue ();
    escrowValue::reference set_escrowValue (escrowValue::const_reference value);
    void swap(EscrowData& other);
    EscrowData * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// ATMParameters
//

class ATMParameters : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    ATMParameters(const void* info) : Inherited(info) {}
  public:
    ATMParameters() : Inherited(&theInfo) {}
    ATMParameters(const ATMParameters & other) : Inherited(other)
    {}
    ATMParameters& operator = (const ATMParameters& other)
    { Inherited::operator = (other); return *this; } 
    class maxNTUSize {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maxNTUSize
    maxNTUSize::const_reference get_maxNTUSize () const;
    maxNTUSize::reference ref_maxNTUSize ();
    maxNTUSize::reference set_maxNTUSize ();
    maxNTUSize::reference set_maxNTUSize (maxNTUSize::value_type::int_type value);
    class atmUBR {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class atmUBR
    atmUBR::const_reference get_atmUBR () const;
    atmUBR::reference ref_atmUBR ();
    atmUBR::reference set_atmUBR ();
    atmUBR::reference set_atmUBR (bool value);
    class atmrtVBR {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class atmrtVBR
    atmrtVBR::const_reference get_atmrtVBR () const;
    atmrtVBR::reference ref_atmrtVBR ();
    atmrtVBR::reference set_atmrtVBR ();
    atmrtVBR::reference set_atmrtVBR (bool value);
    class atmnrtVBR {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class atmnrtVBR
    atmnrtVBR::const_reference get_atmnrtVBR () const;
    atmnrtVBR::reference ref_atmnrtVBR ();
    atmnrtVBR::reference set_atmnrtVBR ();
    atmnrtVBR::reference set_atmnrtVBR (bool value);
    class atmABR {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class atmABR
    atmABR::const_reference get_atmABR () const;
    atmABR::reference ref_atmABR ();
    atmABR::reference set_atmABR ();
    atmABR::reference set_atmABR (bool value);
    class atmCBR {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class atmCBR
    atmCBR::const_reference get_atmCBR () const;
    atmCBR::reference ref_atmCBR ();
    atmCBR::reference set_atmCBR ();
    atmCBR::reference set_atmCBR (bool value);
    void swap(ATMParameters& other);
    ATMParameters * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[6];
    static int fieldIds[6];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[6];
#endif
};

//
// CRCLength
//

class CRCLength : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    CRCLength(const void* info) : Inherited(info) {}
  public:
    CRCLength() : Inherited(&theInfo) {}
    class crc8bit {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class crc8bit

    crc8bit::reference select_crc8bit (); 
    bool crc8bit_isSelected() const;

    class crc16bit {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class crc16bit

    crc16bit::reference select_crc16bit (); 
    bool crc16bit_isSelected() const;

    class crc32bit {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class crc32bit

    crc32bit::reference select_crc32bit (); 
    bool crc32bit_isSelected() const;

    CRCLength(crc8bit::Id id, crc8bit::const_reference value);
    CRCLength(crc16bit::Id id, crc16bit::const_reference value);
    CRCLength(crc32bit::Id id, crc32bit::const_reference value);
    void swap(CRCLength & other);
    CRCLength(const CRCLength & other)
    : Inherited(other) {} 

    CRCLength & operator = (const CRCLength & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    CRCLength * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 192>  McuNumber;

typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 192>  TerminalNumber;

//
// QOSMode
//

class QOSMode : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    QOSMode(const void* info) : Inherited(info) {}
  public:
    QOSMode() : Inherited(&theInfo) {}
    class guaranteedQOS {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class guaranteedQOS

    guaranteedQOS::reference select_guaranteedQOS (); 
    bool guaranteedQOS_isSelected() const;

    class controlledLoad {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class controlledLoad

    controlledLoad::reference select_controlledLoad (); 
    bool controlledLoad_isSelected() const;

    QOSMode(guaranteedQOS::Id id, guaranteedQOS::const_reference value);
    QOSMode(controlledLoad::Id id, controlledLoad::const_reference value);
    void swap(QOSMode & other);
    QOSMode(const QOSMode & other)
    : Inherited(other) {} 

    QOSMode & operator = (const QOSMode & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    QOSMode * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// RequestChannelCloseReject_cause
//

class RequestChannelCloseReject_cause : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    RequestChannelCloseReject_cause(const void* info) : Inherited(info) {}
  public:
    RequestChannelCloseReject_cause() : Inherited(&theInfo) {}
    class unspecified {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class unspecified

    unspecified::reference select_unspecified (); 
    bool unspecified_isSelected() const;

    RequestChannelCloseReject_cause(unspecified::Id id, unspecified::const_reference value);
    void swap(RequestChannelCloseReject_cause & other);
    RequestChannelCloseReject_cause(const RequestChannelCloseReject_cause & other)
    : Inherited(other) {} 

    RequestChannelCloseReject_cause & operator = (const RequestChannelCloseReject_cause & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    RequestChannelCloseReject_cause * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[1];
#endif
};

//
// RequestChannelClose_reason
//

class RequestChannelClose_reason : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    RequestChannelClose_reason(const void* info) : Inherited(info) {}
  public:
    RequestChannelClose_reason() : Inherited(&theInfo) {}
    class unknown {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class unknown

    unknown::reference select_unknown (); 
    bool unknown_isSelected() const;

    class normal {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class normal

    normal::reference select_normal (); 
    bool normal_isSelected() const;

    class reopen {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class reopen

    reopen::reference select_reopen (); 
    bool reopen_isSelected() const;

    class reservationFailure {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class reservationFailure

    reservationFailure::reference select_reservationFailure (); 
    bool reservationFailure_isSelected() const;

    RequestChannelClose_reason(unknown::Id id, unknown::const_reference value);
    RequestChannelClose_reason(normal::Id id, normal::const_reference value);
    RequestChannelClose_reason(reopen::Id id, reopen::const_reference value);
    RequestChannelClose_reason(reservationFailure::Id id, reservationFailure::const_reference value);
    void swap(RequestChannelClose_reason & other);
    RequestChannelClose_reason(const RequestChannelClose_reason & other)
    : Inherited(other) {} 

    RequestChannelClose_reason & operator = (const RequestChannelClose_reason & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    RequestChannelClose_reason * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[4];
#endif
};

//
// CloseLogicalChannel_source
//

class CloseLogicalChannel_source : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    CloseLogicalChannel_source(const void* info) : Inherited(info) {}
  public:
    CloseLogicalChannel_source() : Inherited(&theInfo) {}
    class user {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class user

    user::reference select_user (); 
    bool user_isSelected() const;

    class lcse {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class lcse

    lcse::reference select_lcse (); 
    bool lcse_isSelected() const;

    CloseLogicalChannel_source(user::Id id, user::const_reference value);
    CloseLogicalChannel_source(lcse::Id id, lcse::const_reference value);
    void swap(CloseLogicalChannel_source & other);
    CloseLogicalChannel_source(const CloseLogicalChannel_source & other)
    : Inherited(other) {} 

    CloseLogicalChannel_source & operator = (const CloseLogicalChannel_source & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    CloseLogicalChannel_source * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// CloseLogicalChannel_reason
//

class CloseLogicalChannel_reason : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    CloseLogicalChannel_reason(const void* info) : Inherited(info) {}
  public:
    CloseLogicalChannel_reason() : Inherited(&theInfo) {}
    class unknown {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class unknown

    unknown::reference select_unknown (); 
    bool unknown_isSelected() const;

    class reopen {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class reopen

    reopen::reference select_reopen (); 
    bool reopen_isSelected() const;

    class reservationFailure {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class reservationFailure

    reservationFailure::reference select_reservationFailure (); 
    bool reservationFailure_isSelected() const;

    CloseLogicalChannel_reason(unknown::Id id, unknown::const_reference value);
    CloseLogicalChannel_reason(reopen::Id id, reopen::const_reference value);
    CloseLogicalChannel_reason(reservationFailure::Id id, reservationFailure::const_reference value);
    void swap(CloseLogicalChannel_reason & other);
    CloseLogicalChannel_reason(const CloseLogicalChannel_reason & other)
    : Inherited(other) {} 

    CloseLogicalChannel_reason & operator = (const CloseLogicalChannel_reason & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    CloseLogicalChannel_reason * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// OpenLogicalChannelReject_cause
//

class OpenLogicalChannelReject_cause : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    OpenLogicalChannelReject_cause(const void* info) : Inherited(info) {}
  public:
    OpenLogicalChannelReject_cause() : Inherited(&theInfo) {}
    class unspecified {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class unspecified

    unspecified::reference select_unspecified (); 
    bool unspecified_isSelected() const;

    class unsuitableReverseParameters {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class unsuitableReverseParameters

    unsuitableReverseParameters::reference select_unsuitableReverseParameters (); 
    bool unsuitableReverseParameters_isSelected() const;

    class dataTypeNotSupported {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class dataTypeNotSupported

    dataTypeNotSupported::reference select_dataTypeNotSupported (); 
    bool dataTypeNotSupported_isSelected() const;

    class dataTypeNotAvailable {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class dataTypeNotAvailable

    dataTypeNotAvailable::reference select_dataTypeNotAvailable (); 
    bool dataTypeNotAvailable_isSelected() const;

    class unknownDataType {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class unknownDataType

    unknownDataType::reference select_unknownDataType (); 
    bool unknownDataType_isSelected() const;

    class dataTypeALCombinationNotSupported {
      public:
        enum Id { id_ = 5 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class dataTypeALCombinationNotSupported

    dataTypeALCombinationNotSupported::reference select_dataTypeALCombinationNotSupported (); 
    bool dataTypeALCombinationNotSupported_isSelected() const;

    class multicastChannelNotAllowed {
      public:
        enum Id { id_ = 6 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multicastChannelNotAllowed

    multicastChannelNotAllowed::reference select_multicastChannelNotAllowed (); 
    bool multicastChannelNotAllowed_isSelected() const;

    class insufficientBandwidth {
      public:
        enum Id { id_ = 7 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class insufficientBandwidth

    insufficientBandwidth::reference select_insufficientBandwidth (); 
    bool insufficientBandwidth_isSelected() const;

    class separateStackEstablishmentFailed {
      public:
        enum Id { id_ = 8 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class separateStackEstablishmentFailed

    separateStackEstablishmentFailed::reference select_separateStackEstablishmentFailed (); 
    bool separateStackEstablishmentFailed_isSelected() const;

    class invalidSessionID {
      public:
        enum Id { id_ = 9 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class invalidSessionID

    invalidSessionID::reference select_invalidSessionID (); 
    bool invalidSessionID_isSelected() const;

    class masterSlaveConflict {
      public:
        enum Id { id_ = 10 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class masterSlaveConflict

    masterSlaveConflict::reference select_masterSlaveConflict (); 
    bool masterSlaveConflict_isSelected() const;

    class waitForCommunicationMode {
      public:
        enum Id { id_ = 11 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class waitForCommunicationMode

    waitForCommunicationMode::reference select_waitForCommunicationMode (); 
    bool waitForCommunicationMode_isSelected() const;

    class invalidDependentChannel {
      public:
        enum Id { id_ = 12 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class invalidDependentChannel

    invalidDependentChannel::reference select_invalidDependentChannel (); 
    bool invalidDependentChannel_isSelected() const;

    class replacementForRejected {
      public:
        enum Id { id_ = 13 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class replacementForRejected

    replacementForRejected::reference select_replacementForRejected (); 
    bool replacementForRejected_isSelected() const;

    OpenLogicalChannelReject_cause(unspecified::Id id, unspecified::const_reference value);
    OpenLogicalChannelReject_cause(unsuitableReverseParameters::Id id, unsuitableReverseParameters::const_reference value);
    OpenLogicalChannelReject_cause(dataTypeNotSupported::Id id, dataTypeNotSupported::const_reference value);
    OpenLogicalChannelReject_cause(dataTypeNotAvailable::Id id, dataTypeNotAvailable::const_reference value);
    OpenLogicalChannelReject_cause(unknownDataType::Id id, unknownDataType::const_reference value);
    OpenLogicalChannelReject_cause(dataTypeALCombinationNotSupported::Id id, dataTypeALCombinationNotSupported::const_reference value);
    OpenLogicalChannelReject_cause(multicastChannelNotAllowed::Id id, multicastChannelNotAllowed::const_reference value);
    OpenLogicalChannelReject_cause(insufficientBandwidth::Id id, insufficientBandwidth::const_reference value);
    OpenLogicalChannelReject_cause(separateStackEstablishmentFailed::Id id, separateStackEstablishmentFailed::const_reference value);
    OpenLogicalChannelReject_cause(invalidSessionID::Id id, invalidSessionID::const_reference value);
    OpenLogicalChannelReject_cause(masterSlaveConflict::Id id, masterSlaveConflict::const_reference value);
    OpenLogicalChannelReject_cause(waitForCommunicationMode::Id id, waitForCommunicationMode::const_reference value);
    OpenLogicalChannelReject_cause(invalidDependentChannel::Id id, invalidDependentChannel::const_reference value);
    OpenLogicalChannelReject_cause(replacementForRejected::Id id, replacementForRejected::const_reference value);
    void swap(OpenLogicalChannelReject_cause & other);
    OpenLogicalChannelReject_cause(const OpenLogicalChannelReject_cause & other)
    : Inherited(other) {} 

    OpenLogicalChannelReject_cause & operator = (const OpenLogicalChannelReject_cause & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    OpenLogicalChannelReject_cause * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[14];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[14];
#endif
};

//
// OpenLogicalChannelAck_forwardMultiplexAckParameters
//

class OpenLogicalChannelAck_forwardMultiplexAckParameters : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    OpenLogicalChannelAck_forwardMultiplexAckParameters(const void* info) : Inherited(info) {}
  public:
    OpenLogicalChannelAck_forwardMultiplexAckParameters() : Inherited(&theInfo) {}
    class h2250LogicalChannelAckParameters {
      public:
        enum Id { id_ = 0 };
        typedef H2250LogicalChannelAckParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h2250LogicalChannelAckParameters

    h2250LogicalChannelAckParameters::const_reference get_h2250LogicalChannelAckParameters () const;
    h2250LogicalChannelAckParameters::reference ref_h2250LogicalChannelAckParameters (); 
    h2250LogicalChannelAckParameters::reference select_h2250LogicalChannelAckParameters (); 
    h2250LogicalChannelAckParameters::reference select_h2250LogicalChannelAckParameters (h2250LogicalChannelAckParameters::const_reference value); 
    bool h2250LogicalChannelAckParameters_isSelected() const;

    OpenLogicalChannelAck_forwardMultiplexAckParameters(h2250LogicalChannelAckParameters::Id id, h2250LogicalChannelAckParameters::const_reference value);
    void swap(OpenLogicalChannelAck_forwardMultiplexAckParameters & other);
    OpenLogicalChannelAck_forwardMultiplexAckParameters(const OpenLogicalChannelAck_forwardMultiplexAckParameters & other)
    : Inherited(other) {} 

    OpenLogicalChannelAck_forwardMultiplexAckParameters & operator = (const OpenLogicalChannelAck_forwardMultiplexAckParameters & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    OpenLogicalChannelAck_forwardMultiplexAckParameters * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[1];
#endif
};

//
// NetworkAccessParameters_distribution
//

class NetworkAccessParameters_distribution : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    NetworkAccessParameters_distribution(const void* info) : Inherited(info) {}
  public:
    NetworkAccessParameters_distribution() : Inherited(&theInfo) {}
    class unicast {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class unicast

    unicast::reference select_unicast (); 
    bool unicast_isSelected() const;

    class multicast {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multicast

    multicast::reference select_multicast (); 
    bool multicast_isSelected() const;

    NetworkAccessParameters_distribution(unicast::Id id, unicast::const_reference value);
    NetworkAccessParameters_distribution(multicast::Id id, multicast::const_reference value);
    void swap(NetworkAccessParameters_distribution & other);
    NetworkAccessParameters_distribution(const NetworkAccessParameters_distribution & other)
    : Inherited(other) {} 

    NetworkAccessParameters_distribution & operator = (const NetworkAccessParameters_distribution & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    NetworkAccessParameters_distribution * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// NetworkAccessParameters_networkAddress
//

class NetworkAccessParameters_networkAddress : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    NetworkAccessParameters_networkAddress(const void* info) : Inherited(info) {}
  public:
    NetworkAccessParameters_networkAddress() : Inherited(&theInfo) {}
    class q2931Address {
      public:
        enum Id { id_ = 0 };
        typedef Q2931Address value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class q2931Address

    q2931Address::const_reference get_q2931Address () const;
    q2931Address::reference ref_q2931Address (); 
    q2931Address::reference select_q2931Address (); 
    q2931Address::reference select_q2931Address (q2931Address::const_reference value); 
    bool q2931Address_isSelected() const;

    class e164Address {
      public:
        enum Id { id_ = 1 };
        class value_type : public ASN1::IA5String
        {
            typedef ASN1::IA5String Inherited;
          protected:
            value_type(const void* info) : Inherited(info) {}
          public:
            value_type() : Inherited(&theInfo) { }
            value_type(const base_string& str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const char* str, const void* info = &theInfo) : Inherited(str, info) { }
            value_type(const value_type& other) : Inherited(other) {}
            value_type& operator = (const std::string& other)
            { Inherited::operator=(other); return *this;}
            value_type& operator = (const char* other)
            { Inherited::operator=(other); return *this;}
            value_type * clone() const;
            static bool equal_type(const ASN1::AbstractData&);
            static void extract(const ASN1::AbstractData& data);
            static const InfoType theInfo;
        };

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class e164Address

    e164Address::const_reference get_e164Address () const;
    e164Address::reference ref_e164Address (); 
    e164Address::reference select_e164Address (); 
    e164Address::reference select_e164Address (const std::string& value); 
    bool e164Address_isSelected() const;

    class localAreaAddress {
      public:
        enum Id { id_ = 2 };
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class localAreaAddress

    localAreaAddress::const_reference get_localAreaAddress () const;
    localAreaAddress::reference ref_localAreaAddress (); 
    localAreaAddress::reference select_localAreaAddress (); 
    localAreaAddress::reference select_localAreaAddress (localAreaAddress::const_reference value); 
    bool localAreaAddress_isSelected() const;

    NetworkAccessParameters_networkAddress(q2931Address::Id id, q2931Address::const_reference value);
    NetworkAccessParameters_networkAddress(e164Address::Id id, const std::string& value);
    NetworkAccessParameters_networkAddress(localAreaAddress::Id id, localAreaAddress::const_reference value);
    void swap(NetworkAccessParameters_networkAddress & other);
    NetworkAccessParameters_networkAddress(const NetworkAccessParameters_networkAddress & other)
    : Inherited(other) {} 

    NetworkAccessParameters_networkAddress & operator = (const NetworkAccessParameters_networkAddress & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    NetworkAccessParameters_networkAddress * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// NetworkAccessParameters_t120SetupProcedure
//

class NetworkAccessParameters_t120SetupProcedure : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    NetworkAccessParameters_t120SetupProcedure(const void* info) : Inherited(info) {}
  public:
    NetworkAccessParameters_t120SetupProcedure() : Inherited(&theInfo) {}
    class originateCall {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class originateCall

    originateCall::reference select_originateCall (); 
    bool originateCall_isSelected() const;

    class waitForCall {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class waitForCall

    waitForCall::reference select_waitForCall (); 
    bool waitForCall_isSelected() const;

    class issueQuery {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class issueQuery

    issueQuery::reference select_issueQuery (); 
    bool issueQuery_isSelected() const;

    NetworkAccessParameters_t120SetupProcedure(originateCall::Id id, originateCall::const_reference value);
    NetworkAccessParameters_t120SetupProcedure(waitForCall::Id id, waitForCall::const_reference value);
    NetworkAccessParameters_t120SetupProcedure(issueQuery::Id id, issueQuery::const_reference value);
    void swap(NetworkAccessParameters_t120SetupProcedure & other);
    NetworkAccessParameters_t120SetupProcedure(const NetworkAccessParameters_t120SetupProcedure & other)
    : Inherited(other) {} 

    NetworkAccessParameters_t120SetupProcedure & operator = (const NetworkAccessParameters_t120SetupProcedure & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    NetworkAccessParameters_t120SetupProcedure * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// V76LogicalChannelParameters_suspendResume
//

class V76LogicalChannelParameters_suspendResume : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    V76LogicalChannelParameters_suspendResume(const void* info) : Inherited(info) {}
  public:
    V76LogicalChannelParameters_suspendResume() : Inherited(&theInfo) {}
    class noSuspendResume {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class noSuspendResume

    noSuspendResume::reference select_noSuspendResume (); 
    bool noSuspendResume_isSelected() const;

    class suspendResumewAddress {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class suspendResumewAddress

    suspendResumewAddress::reference select_suspendResumewAddress (); 
    bool suspendResumewAddress_isSelected() const;

    class suspendResumewoAddress {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class suspendResumewoAddress

    suspendResumewoAddress::reference select_suspendResumewoAddress (); 
    bool suspendResumewoAddress_isSelected() const;

    V76LogicalChannelParameters_suspendResume(noSuspendResume::Id id, noSuspendResume::const_reference value);
    V76LogicalChannelParameters_suspendResume(suspendResumewAddress::Id id, suspendResumewAddress::const_reference value);
    V76LogicalChannelParameters_suspendResume(suspendResumewoAddress::Id id, suspendResumewoAddress::const_reference value);
    void swap(V76LogicalChannelParameters_suspendResume & other);
    V76LogicalChannelParameters_suspendResume(const V76LogicalChannelParameters_suspendResume & other)
    : Inherited(other) {} 

    V76LogicalChannelParameters_suspendResume & operator = (const V76LogicalChannelParameters_suspendResume & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    V76LogicalChannelParameters_suspendResume * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// H235Media_mediaType
//

class H235Media_mediaType : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    H235Media_mediaType(const void* info) : Inherited(info) {}
  public:
    H235Media_mediaType() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class videoData {
      public:
        enum Id { id_ = 1 };
        typedef VideoCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class videoData

    videoData::const_reference get_videoData () const;
    videoData::reference ref_videoData (); 
    videoData::reference select_videoData (); 
    videoData::reference select_videoData (videoData::const_reference value); 
    bool videoData_isSelected() const;

    class audioData {
      public:
        enum Id { id_ = 2 };
        typedef AudioCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioData

    audioData::const_reference get_audioData () const;
    audioData::reference ref_audioData (); 
    audioData::reference select_audioData (); 
    audioData::reference select_audioData (audioData::const_reference value); 
    bool audioData_isSelected() const;

    class data {
      public:
        enum Id { id_ = 3 };
        typedef DataApplicationCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class data

    data::const_reference get_data () const;
    data::reference ref_data (); 
    data::reference select_data (); 
    data::reference select_data (data::const_reference value); 
    bool data_isSelected() const;

    H235Media_mediaType(nonStandard::Id id, nonStandard::const_reference value);
    H235Media_mediaType(videoData::Id id, videoData::const_reference value);
    H235Media_mediaType(audioData::Id id, audioData::const_reference value);
    H235Media_mediaType(data::Id id, data::const_reference value);
    void swap(H235Media_mediaType & other);
    H235Media_mediaType(const H235Media_mediaType & other)
    : Inherited(other) {} 

    H235Media_mediaType & operator = (const H235Media_mediaType & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    H235Media_mediaType * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[4];
#endif
};

//
// H223AL1MParameters_transferMode
//

class H223AL1MParameters_transferMode : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    H223AL1MParameters_transferMode(const void* info) : Inherited(info) {}
  public:
    H223AL1MParameters_transferMode() : Inherited(&theInfo) {}
    class framed {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class framed

    framed::reference select_framed (); 
    bool framed_isSelected() const;

    class unframed {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class unframed

    unframed::reference select_unframed (); 
    bool unframed_isSelected() const;

    H223AL1MParameters_transferMode(framed::Id id, framed::const_reference value);
    H223AL1MParameters_transferMode(unframed::Id id, unframed::const_reference value);
    void swap(H223AL1MParameters_transferMode & other);
    H223AL1MParameters_transferMode(const H223AL1MParameters_transferMode & other)
    : Inherited(other) {} 

    H223AL1MParameters_transferMode & operator = (const H223AL1MParameters_transferMode & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    H223AL1MParameters_transferMode * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// H223AL1MParameters_headerFEC
//

class H223AL1MParameters_headerFEC : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    H223AL1MParameters_headerFEC(const void* info) : Inherited(info) {}
  public:
    H223AL1MParameters_headerFEC() : Inherited(&theInfo) {}
    class sebch16_7 {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sebch16_7

    sebch16_7::reference select_sebch16_7 (); 
    bool sebch16_7_isSelected() const;

    class golay24_12 {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class golay24_12

    golay24_12::reference select_golay24_12 (); 
    bool golay24_12_isSelected() const;

    H223AL1MParameters_headerFEC(sebch16_7::Id id, sebch16_7::const_reference value);
    H223AL1MParameters_headerFEC(golay24_12::Id id, golay24_12::const_reference value);
    void swap(H223AL1MParameters_headerFEC & other);
    H223AL1MParameters_headerFEC(const H223AL1MParameters_headerFEC & other)
    : Inherited(other) {} 

    H223AL1MParameters_headerFEC & operator = (const H223AL1MParameters_headerFEC & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    H223AL1MParameters_headerFEC * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// H223AL1MParameters_crcLength
//

class H223AL1MParameters_crcLength : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    H223AL1MParameters_crcLength(const void* info) : Inherited(info) {}
  public:
    H223AL1MParameters_crcLength() : Inherited(&theInfo) {}
    class crc4bit {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class crc4bit

    crc4bit::reference select_crc4bit (); 
    bool crc4bit_isSelected() const;

    class crc12bit {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class crc12bit

    crc12bit::reference select_crc12bit (); 
    bool crc12bit_isSelected() const;

    class crc20bit {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class crc20bit

    crc20bit::reference select_crc20bit (); 
    bool crc20bit_isSelected() const;

    class crc28bit {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class crc28bit

    crc28bit::reference select_crc28bit (); 
    bool crc28bit_isSelected() const;

    class crc8bit {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class crc8bit

    crc8bit::reference select_crc8bit (); 
    bool crc8bit_isSelected() const;

    class crc16bit {
      public:
        enum Id { id_ = 5 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class crc16bit

    crc16bit::reference select_crc16bit (); 
    bool crc16bit_isSelected() const;

    class crc32bit {
      public:
        enum Id { id_ = 6 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class crc32bit

    crc32bit::reference select_crc32bit (); 
    bool crc32bit_isSelected() const;

    class crcNotUsed {
      public:
        enum Id { id_ = 7 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class crcNotUsed

    crcNotUsed::reference select_crcNotUsed (); 
    bool crcNotUsed_isSelected() const;

    H223AL1MParameters_crcLength(crc4bit::Id id, crc4bit::const_reference value);
    H223AL1MParameters_crcLength(crc12bit::Id id, crc12bit::const_reference value);
    H223AL1MParameters_crcLength(crc20bit::Id id, crc20bit::const_reference value);
    H223AL1MParameters_crcLength(crc28bit::Id id, crc28bit::const_reference value);
    H223AL1MParameters_crcLength(crc8bit::Id id, crc8bit::const_reference value);
    H223AL1MParameters_crcLength(crc16bit::Id id, crc16bit::const_reference value);
    H223AL1MParameters_crcLength(crc32bit::Id id, crc32bit::const_reference value);
    H223AL1MParameters_crcLength(crcNotUsed::Id id, crcNotUsed::const_reference value);
    void swap(H223AL1MParameters_crcLength & other);
    H223AL1MParameters_crcLength(const H223AL1MParameters_crcLength & other)
    : Inherited(other) {} 

    H223AL1MParameters_crcLength & operator = (const H223AL1MParameters_crcLength & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    H223AL1MParameters_crcLength * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[8];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[8];
#endif
};

//
// H223AL2MParameters_headerFEC
//

class H223AL2MParameters_headerFEC : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    H223AL2MParameters_headerFEC(const void* info) : Inherited(info) {}
  public:
    H223AL2MParameters_headerFEC() : Inherited(&theInfo) {}
    class sebch16_5 {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sebch16_5

    sebch16_5::reference select_sebch16_5 (); 
    bool sebch16_5_isSelected() const;

    class golay24_12 {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class golay24_12

    golay24_12::reference select_golay24_12 (); 
    bool golay24_12_isSelected() const;

    H223AL2MParameters_headerFEC(sebch16_5::Id id, sebch16_5::const_reference value);
    H223AL2MParameters_headerFEC(golay24_12::Id id, golay24_12::const_reference value);
    void swap(H223AL2MParameters_headerFEC & other);
    H223AL2MParameters_headerFEC(const H223AL2MParameters_headerFEC & other)
    : Inherited(other) {} 

    H223AL2MParameters_headerFEC & operator = (const H223AL2MParameters_headerFEC & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    H223AL2MParameters_headerFEC * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// H223AL3MParameters_headerFormat
//

class H223AL3MParameters_headerFormat : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    H223AL3MParameters_headerFormat(const void* info) : Inherited(info) {}
  public:
    H223AL3MParameters_headerFormat() : Inherited(&theInfo) {}
    class sebch16_7 {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sebch16_7

    sebch16_7::reference select_sebch16_7 (); 
    bool sebch16_7_isSelected() const;

    class golay24_12 {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class golay24_12

    golay24_12::reference select_golay24_12 (); 
    bool golay24_12_isSelected() const;

    H223AL3MParameters_headerFormat(sebch16_7::Id id, sebch16_7::const_reference value);
    H223AL3MParameters_headerFormat(golay24_12::Id id, golay24_12::const_reference value);
    void swap(H223AL3MParameters_headerFormat & other);
    H223AL3MParameters_headerFormat(const H223AL3MParameters_headerFormat & other)
    : Inherited(other) {} 

    H223AL3MParameters_headerFormat & operator = (const H223AL3MParameters_headerFormat & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    H223AL3MParameters_headerFormat * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// H223AL3MParameters_crcLength
//

class H223AL3MParameters_crcLength : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    H223AL3MParameters_crcLength(const void* info) : Inherited(info) {}
  public:
    H223AL3MParameters_crcLength() : Inherited(&theInfo) {}
    class crc4bit {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class crc4bit

    crc4bit::reference select_crc4bit (); 
    bool crc4bit_isSelected() const;

    class crc12bit {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class crc12bit

    crc12bit::reference select_crc12bit (); 
    bool crc12bit_isSelected() const;

    class crc20bit {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class crc20bit

    crc20bit::reference select_crc20bit (); 
    bool crc20bit_isSelected() const;

    class crc28bit {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class crc28bit

    crc28bit::reference select_crc28bit (); 
    bool crc28bit_isSelected() const;

    class crc8bit {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class crc8bit

    crc8bit::reference select_crc8bit (); 
    bool crc8bit_isSelected() const;

    class crc16bit {
      public:
        enum Id { id_ = 5 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class crc16bit

    crc16bit::reference select_crc16bit (); 
    bool crc16bit_isSelected() const;

    class crc32bit {
      public:
        enum Id { id_ = 6 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class crc32bit

    crc32bit::reference select_crc32bit (); 
    bool crc32bit_isSelected() const;

    class crcNotUsed {
      public:
        enum Id { id_ = 7 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class crcNotUsed

    crcNotUsed::reference select_crcNotUsed (); 
    bool crcNotUsed_isSelected() const;

    H223AL3MParameters_crcLength(crc4bit::Id id, crc4bit::const_reference value);
    H223AL3MParameters_crcLength(crc12bit::Id id, crc12bit::const_reference value);
    H223AL3MParameters_crcLength(crc20bit::Id id, crc20bit::const_reference value);
    H223AL3MParameters_crcLength(crc28bit::Id id, crc28bit::const_reference value);
    H223AL3MParameters_crcLength(crc8bit::Id id, crc8bit::const_reference value);
    H223AL3MParameters_crcLength(crc16bit::Id id, crc16bit::const_reference value);
    H223AL3MParameters_crcLength(crc32bit::Id id, crc32bit::const_reference value);
    H223AL3MParameters_crcLength(crcNotUsed::Id id, crcNotUsed::const_reference value);
    void swap(H223AL3MParameters_crcLength & other);
    H223AL3MParameters_crcLength(const H223AL3MParameters_crcLength & other)
    : Inherited(other) {} 

    H223AL3MParameters_crcLength & operator = (const H223AL3MParameters_crcLength & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    H223AL3MParameters_crcLength * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[8];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[8];
#endif
};

//
// RTPPayloadType_payloadDescriptor
//

class RTPPayloadType_payloadDescriptor : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    RTPPayloadType_payloadDescriptor(const void* info) : Inherited(info) {}
  public:
    RTPPayloadType_payloadDescriptor() : Inherited(&theInfo) {}
    class nonStandardIdentifier {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardIdentifier

    nonStandardIdentifier::const_reference get_nonStandardIdentifier () const;
    nonStandardIdentifier::reference ref_nonStandardIdentifier (); 
    nonStandardIdentifier::reference select_nonStandardIdentifier (); 
    nonStandardIdentifier::reference select_nonStandardIdentifier (nonStandardIdentifier::const_reference value); 
    bool nonStandardIdentifier_isSelected() const;

    class rfc_number {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Constrained_INTEGER<ASN1::ExtendableConstraint, 1, 32768>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rfc_number

    rfc_number::const_reference get_rfc_number () const;
    rfc_number::reference ref_rfc_number (); 
    rfc_number::reference select_rfc_number (); 
    rfc_number::reference select_rfc_number (rfc_number::value_type::int_type value); 
    bool rfc_number_isSelected() const;

    class oid {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::OBJECT_IDENTIFIER value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class oid

    oid::const_reference get_oid () const;
    oid::reference ref_oid (); 
    oid::reference select_oid (); 
    oid::reference select_oid (oid::const_reference value); 
    bool oid_isSelected() const;

    RTPPayloadType_payloadDescriptor(nonStandardIdentifier::Id id, nonStandardIdentifier::const_reference value);
    RTPPayloadType_payloadDescriptor(rfc_number::Id id, rfc_number::value_type::int_type value);
    RTPPayloadType_payloadDescriptor(oid::Id id, oid::const_reference value);
    void swap(RTPPayloadType_payloadDescriptor & other);
    RTPPayloadType_payloadDescriptor(const RTPPayloadType_payloadDescriptor & other)
    : Inherited(other) {} 

    RTPPayloadType_payloadDescriptor & operator = (const RTPPayloadType_payloadDescriptor & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    RTPPayloadType_payloadDescriptor * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// H223AnnexCArqParameters_numberOfRetransmissions
//

class H223AnnexCArqParameters_numberOfRetransmissions : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    H223AnnexCArqParameters_numberOfRetransmissions(const void* info) : Inherited(info) {}
  public:
    H223AnnexCArqParameters_numberOfRetransmissions() : Inherited(&theInfo) {}
    class finite {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 16>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class finite

    finite::const_reference get_finite () const;
    finite::reference ref_finite (); 
    finite::reference select_finite (); 
    finite::reference select_finite (finite::value_type::int_type value); 
    bool finite_isSelected() const;

    class infinite {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class infinite

    infinite::reference select_infinite (); 
    bool infinite_isSelected() const;

    H223AnnexCArqParameters_numberOfRetransmissions(finite::Id id, finite::value_type::int_type value);
    H223AnnexCArqParameters_numberOfRetransmissions(infinite::Id id, infinite::const_reference value);
    void swap(H223AnnexCArqParameters_numberOfRetransmissions & other);
    H223AnnexCArqParameters_numberOfRetransmissions(const H223AnnexCArqParameters_numberOfRetransmissions & other)
    : Inherited(other) {} 

    H223AnnexCArqParameters_numberOfRetransmissions & operator = (const H223AnnexCArqParameters_numberOfRetransmissions & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    H223AnnexCArqParameters_numberOfRetransmissions * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// MediaTransportType_atm_AAL5_compressed
//

class MediaTransportType_atm_AAL5_compressed : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MediaTransportType_atm_AAL5_compressed(const void* info) : Inherited(info) {}
  public:
    MediaTransportType_atm_AAL5_compressed() : Inherited(&theInfo) {}
    MediaTransportType_atm_AAL5_compressed(const MediaTransportType_atm_AAL5_compressed & other) : Inherited(other)
    {}
    MediaTransportType_atm_AAL5_compressed& operator = (const MediaTransportType_atm_AAL5_compressed& other)
    { Inherited::operator = (other); return *this; } 
    class variable_delta {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class variable_delta
    variable_delta::const_reference get_variable_delta () const;
    variable_delta::reference ref_variable_delta ();
    variable_delta::reference set_variable_delta ();
    variable_delta::reference set_variable_delta (bool value);
    void swap(MediaTransportType_atm_AAL5_compressed& other);
    MediaTransportType_atm_AAL5_compressed * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

typedef ASN1::SEQUENCE_OF<ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 15> ,  ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 256> >  RTPH263VideoRedundancyEncoding_containedThreads;

typedef ASN1::SEQUENCE_OF<ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 255> ,  ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 256> >  RTPH263VideoRedundancyFrameMapping_frameSequence;

//
// H223LogicalChannelParameters_adaptationLayerType_al3
//

class H223LogicalChannelParameters_adaptationLayerType_al3 : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    H223LogicalChannelParameters_adaptationLayerType_al3(const void* info) : Inherited(info) {}
  public:
    H223LogicalChannelParameters_adaptationLayerType_al3() : Inherited(&theInfo) {}
    H223LogicalChannelParameters_adaptationLayerType_al3(const H223LogicalChannelParameters_adaptationLayerType_al3 & other) : Inherited(other)
    {}
    H223LogicalChannelParameters_adaptationLayerType_al3& operator = (const H223LogicalChannelParameters_adaptationLayerType_al3& other)
    { Inherited::operator = (other); return *this; } 
    class controlFieldOctets {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 2>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class controlFieldOctets
    controlFieldOctets::const_reference get_controlFieldOctets () const;
    controlFieldOctets::reference ref_controlFieldOctets ();
    controlFieldOctets::reference set_controlFieldOctets ();
    controlFieldOctets::reference set_controlFieldOctets (controlFieldOctets::value_type::int_type value);
    class sendBufferSize {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 16777215>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sendBufferSize
    sendBufferSize::const_reference get_sendBufferSize () const;
    sendBufferSize::reference ref_sendBufferSize ();
    sendBufferSize::reference set_sendBufferSize ();
    sendBufferSize::reference set_sendBufferSize (sendBufferSize::value_type::int_type value);
    void swap(H223LogicalChannelParameters_adaptationLayerType_al3& other);
    H223LogicalChannelParameters_adaptationLayerType_al3 * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// V76LogicalChannelParameters_mode_eRM_recovery
//

class V76LogicalChannelParameters_mode_eRM_recovery : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    V76LogicalChannelParameters_mode_eRM_recovery(const void* info) : Inherited(info) {}
  public:
    V76LogicalChannelParameters_mode_eRM_recovery() : Inherited(&theInfo) {}
    class rej {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rej

    rej::reference select_rej (); 
    bool rej_isSelected() const;

    class sREJ {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sREJ

    sREJ::reference select_sREJ (); 
    bool sREJ_isSelected() const;

    class mSREJ {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mSREJ

    mSREJ::reference select_mSREJ (); 
    bool mSREJ_isSelected() const;

    V76LogicalChannelParameters_mode_eRM_recovery(rej::Id id, rej::const_reference value);
    V76LogicalChannelParameters_mode_eRM_recovery(sREJ::Id id, sREJ::const_reference value);
    V76LogicalChannelParameters_mode_eRM_recovery(mSREJ::Id id, mSREJ::const_reference value);
    void swap(V76LogicalChannelParameters_mode_eRM_recovery & other);
    V76LogicalChannelParameters_mode_eRM_recovery(const V76LogicalChannelParameters_mode_eRM_recovery & other)
    : Inherited(other) {} 

    V76LogicalChannelParameters_mode_eRM_recovery & operator = (const V76LogicalChannelParameters_mode_eRM_recovery & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    V76LogicalChannelParameters_mode_eRM_recovery * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// RequestChannelCloseReject
//

class RequestChannelCloseReject : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RequestChannelCloseReject(const void* info) : Inherited(info) {}
  public:
    RequestChannelCloseReject() : Inherited(&theInfo) {}
    RequestChannelCloseReject(const RequestChannelCloseReject & other) : Inherited(other)
    {}
    RequestChannelCloseReject& operator = (const RequestChannelCloseReject& other)
    { Inherited::operator = (other); return *this; } 
    class forwardLogicalChannelNumber {
      public:
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class forwardLogicalChannelNumber
    forwardLogicalChannelNumber::const_reference get_forwardLogicalChannelNumber () const;
    forwardLogicalChannelNumber::reference ref_forwardLogicalChannelNumber ();
    forwardLogicalChannelNumber::reference set_forwardLogicalChannelNumber ();
    forwardLogicalChannelNumber::reference set_forwardLogicalChannelNumber (forwardLogicalChannelNumber::value_type::int_type value);
    class cause {
      public:
        typedef RequestChannelCloseReject_cause value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cause
    cause::const_reference get_cause () const;
    cause::reference ref_cause ();
    cause::reference set_cause ();
    cause::reference set_cause (cause::const_reference value);
    void swap(RequestChannelCloseReject& other);
    RequestChannelCloseReject * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// RequestChannelCloseRelease
//

class RequestChannelCloseRelease : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RequestChannelCloseRelease(const void* info) : Inherited(info) {}
  public:
    RequestChannelCloseRelease() : Inherited(&theInfo) {}
    RequestChannelCloseRelease(const RequestChannelCloseRelease & other) : Inherited(other)
    {}
    RequestChannelCloseRelease& operator = (const RequestChannelCloseRelease& other)
    { Inherited::operator = (other); return *this; } 
    class forwardLogicalChannelNumber {
      public:
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class forwardLogicalChannelNumber
    forwardLogicalChannelNumber::const_reference get_forwardLogicalChannelNumber () const;
    forwardLogicalChannelNumber::reference ref_forwardLogicalChannelNumber ();
    forwardLogicalChannelNumber::reference set_forwardLogicalChannelNumber ();
    forwardLogicalChannelNumber::reference set_forwardLogicalChannelNumber (forwardLogicalChannelNumber::value_type::int_type value);
    void swap(RequestChannelCloseRelease& other);
    RequestChannelCloseRelease * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// RequestChannelCloseAck
//

class RequestChannelCloseAck : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RequestChannelCloseAck(const void* info) : Inherited(info) {}
  public:
    RequestChannelCloseAck() : Inherited(&theInfo) {}
    RequestChannelCloseAck(const RequestChannelCloseAck & other) : Inherited(other)
    {}
    RequestChannelCloseAck& operator = (const RequestChannelCloseAck& other)
    { Inherited::operator = (other); return *this; } 
    class forwardLogicalChannelNumber {
      public:
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class forwardLogicalChannelNumber
    forwardLogicalChannelNumber::const_reference get_forwardLogicalChannelNumber () const;
    forwardLogicalChannelNumber::reference ref_forwardLogicalChannelNumber ();
    forwardLogicalChannelNumber::reference set_forwardLogicalChannelNumber ();
    forwardLogicalChannelNumber::reference set_forwardLogicalChannelNumber (forwardLogicalChannelNumber::value_type::int_type value);
    void swap(RequestChannelCloseAck& other);
    RequestChannelCloseAck * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// CloseLogicalChannelAck
//

class CloseLogicalChannelAck : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CloseLogicalChannelAck(const void* info) : Inherited(info) {}
  public:
    CloseLogicalChannelAck() : Inherited(&theInfo) {}
    CloseLogicalChannelAck(const CloseLogicalChannelAck & other) : Inherited(other)
    {}
    CloseLogicalChannelAck& operator = (const CloseLogicalChannelAck& other)
    { Inherited::operator = (other); return *this; } 
    class forwardLogicalChannelNumber {
      public:
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class forwardLogicalChannelNumber
    forwardLogicalChannelNumber::const_reference get_forwardLogicalChannelNumber () const;
    forwardLogicalChannelNumber::reference ref_forwardLogicalChannelNumber ();
    forwardLogicalChannelNumber::reference set_forwardLogicalChannelNumber ();
    forwardLogicalChannelNumber::reference set_forwardLogicalChannelNumber (forwardLogicalChannelNumber::value_type::int_type value);
    void swap(CloseLogicalChannelAck& other);
    CloseLogicalChannelAck * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// CloseLogicalChannel
//

class CloseLogicalChannel : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    CloseLogicalChannel(const void* info) : Inherited(info) {}
  public:
    CloseLogicalChannel() : Inherited(&theInfo) {}
    CloseLogicalChannel(const CloseLogicalChannel & other) : Inherited(other)
    {}
    CloseLogicalChannel& operator = (const CloseLogicalChannel& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_reason
    };

    class forwardLogicalChannelNumber {
      public:
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class forwardLogicalChannelNumber
    forwardLogicalChannelNumber::const_reference get_forwardLogicalChannelNumber () const;
    forwardLogicalChannelNumber::reference ref_forwardLogicalChannelNumber ();
    forwardLogicalChannelNumber::reference set_forwardLogicalChannelNumber ();
    forwardLogicalChannelNumber::reference set_forwardLogicalChannelNumber (forwardLogicalChannelNumber::value_type::int_type value);
    class source {
      public:
        typedef CloseLogicalChannel_source value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class source
    source::const_reference get_source () const;
    source::reference ref_source ();
    source::reference set_source ();
    source::reference set_source (source::const_reference value);
    class reason {
      public:
        typedef CloseLogicalChannel_reason value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class reason
    reason::const_reference get_reason () const;
    reason::reference ref_reason ();
    reason::reference set_reason ();
    reason::reference set_reason (reason::const_reference value);
    void omit_reason ();
    bool reason_isPresent () const;
    void swap(CloseLogicalChannel& other);
    CloseLogicalChannel * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
    static const char* nonOptionalExtensions;
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// OpenLogicalChannelReject
//

class OpenLogicalChannelReject : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    OpenLogicalChannelReject(const void* info) : Inherited(info) {}
  public:
    OpenLogicalChannelReject() : Inherited(&theInfo) {}
    OpenLogicalChannelReject(const OpenLogicalChannelReject & other) : Inherited(other)
    {}
    OpenLogicalChannelReject& operator = (const OpenLogicalChannelReject& other)
    { Inherited::operator = (other); return *this; } 
    class forwardLogicalChannelNumber {
      public:
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class forwardLogicalChannelNumber
    forwardLogicalChannelNumber::const_reference get_forwardLogicalChannelNumber () const;
    forwardLogicalChannelNumber::reference ref_forwardLogicalChannelNumber ();
    forwardLogicalChannelNumber::reference set_forwardLogicalChannelNumber ();
    forwardLogicalChannelNumber::reference set_forwardLogicalChannelNumber (forwardLogicalChannelNumber::value_type::int_type value);
    class cause {
      public:
        typedef OpenLogicalChannelReject_cause value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class cause
    cause::const_reference get_cause () const;
    cause::reference ref_cause ();
    cause::reference set_cause ();
    cause::reference set_cause (cause::const_reference value);
    void swap(OpenLogicalChannelReject& other);
    OpenLogicalChannelReject * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// NetworkAccessParameters
//

class NetworkAccessParameters : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    NetworkAccessParameters(const void* info) : Inherited(info) {}
  public:
    NetworkAccessParameters() : Inherited(&theInfo) {}
    NetworkAccessParameters(const NetworkAccessParameters & other) : Inherited(other)
    {}
    NetworkAccessParameters& operator = (const NetworkAccessParameters& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_distribution,
      e_externalReference,
      e_t120SetupProcedure
    };

    class distribution {
      public:
        typedef NetworkAccessParameters_distribution value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class distribution
    distribution::const_reference get_distribution () const;
    distribution::reference ref_distribution ();
    distribution::reference set_distribution ();
    distribution::reference set_distribution (distribution::const_reference value);
    void omit_distribution ();
    bool distribution_isPresent () const;
    class networkAddress {
      public:
        typedef NetworkAccessParameters_networkAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class networkAddress
    networkAddress::const_reference get_networkAddress () const;
    networkAddress::reference ref_networkAddress ();
    networkAddress::reference set_networkAddress ();
    networkAddress::reference set_networkAddress (networkAddress::const_reference value);
    class associateConference {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class associateConference
    associateConference::const_reference get_associateConference () const;
    associateConference::reference ref_associateConference ();
    associateConference::reference set_associateConference ();
    associateConference::reference set_associateConference (bool value);
    class externalReference {
      public:
        typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 255> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class externalReference
    externalReference::const_reference get_externalReference () const;
    externalReference::reference ref_externalReference ();
    externalReference::reference set_externalReference ();
    externalReference::reference set_externalReference (const std::vector<char>& value);
    void omit_externalReference ();
    bool externalReference_isPresent () const;
    class t120SetupProcedure {
      public:
        typedef NetworkAccessParameters_t120SetupProcedure value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class t120SetupProcedure
    t120SetupProcedure::const_reference get_t120SetupProcedure () const;
    t120SetupProcedure::reference ref_t120SetupProcedure ();
    t120SetupProcedure::reference set_t120SetupProcedure ();
    t120SetupProcedure::reference set_t120SetupProcedure (t120SetupProcedure::const_reference value);
    void omit_t120SetupProcedure ();
    bool t120SetupProcedure_isPresent () const;
    void swap(NetworkAccessParameters& other);
    NetworkAccessParameters * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[5];
    static int fieldIds[5];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[5];
#endif
};

//
// EncryptionSync
//

class EncryptionSync : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    EncryptionSync(const void* info) : Inherited(info) {}
  public:
    EncryptionSync() : Inherited(&theInfo) {}
    EncryptionSync(const EncryptionSync & other) : Inherited(other)
    {}
    EncryptionSync& operator = (const EncryptionSync& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandard,
      e_escrowentry
    };

    class nonStandard {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard
    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard ();
    nonStandard::reference set_nonStandard ();
    nonStandard::reference set_nonStandard (nonStandard::const_reference value);
    void omit_nonStandard ();
    bool nonStandard_isPresent () const;
    class synchFlag {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 255>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class synchFlag
    synchFlag::const_reference get_synchFlag () const;
    synchFlag::reference ref_synchFlag ();
    synchFlag::reference set_synchFlag ();
    synchFlag::reference set_synchFlag (synchFlag::value_type::int_type value);
    class h235Key {
      public:
        typedef ASN1::Constrained_OCTET_STRING< ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 65535> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h235Key
    h235Key::const_reference get_h235Key () const;
    h235Key::reference ref_h235Key ();
    h235Key::reference set_h235Key ();
    h235Key::reference set_h235Key (const std::vector<char>& value);
    class escrowentry {
      public:
        typedef ASN1::SEQUENCE_OF<EscrowData,  ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 256> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class escrowentry
    escrowentry::const_reference get_escrowentry () const;
    escrowentry::reference ref_escrowentry ();
    escrowentry::reference set_escrowentry ();
    escrowentry::reference set_escrowentry (escrowentry::const_reference value);
    void omit_escrowentry ();
    bool escrowentry_isPresent () const;
    void swap(EncryptionSync& other);
    EncryptionSync * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// H235Media
//

class H235Media : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    H235Media(const void* info) : Inherited(info) {}
  public:
    H235Media() : Inherited(&theInfo) {}
    H235Media(const H235Media & other) : Inherited(other)
    {}
    H235Media& operator = (const H235Media& other)
    { Inherited::operator = (other); return *this; } 
    class encryptionAuthenticationAndIntegrity {
      public:
        typedef EncryptionAuthenticationAndIntegrity value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class encryptionAuthenticationAndIntegrity
    encryptionAuthenticationAndIntegrity::const_reference get_encryptionAuthenticationAndIntegrity () const;
    encryptionAuthenticationAndIntegrity::reference ref_encryptionAuthenticationAndIntegrity ();
    encryptionAuthenticationAndIntegrity::reference set_encryptionAuthenticationAndIntegrity ();
    encryptionAuthenticationAndIntegrity::reference set_encryptionAuthenticationAndIntegrity (encryptionAuthenticationAndIntegrity::const_reference value);
    class mediaType {
      public:
        typedef H235Media_mediaType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mediaType
    mediaType::const_reference get_mediaType () const;
    mediaType::reference ref_mediaType ();
    mediaType::reference set_mediaType ();
    mediaType::reference set_mediaType (mediaType::const_reference value);
    void swap(H235Media& other);
    H235Media * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// H223AL2MParameters
//

class H223AL2MParameters : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    H223AL2MParameters(const void* info) : Inherited(info) {}
  public:
    H223AL2MParameters() : Inherited(&theInfo) {}
    H223AL2MParameters(const H223AL2MParameters & other) : Inherited(other)
    {}
    H223AL2MParameters& operator = (const H223AL2MParameters& other)
    { Inherited::operator = (other); return *this; } 
    class headerFEC {
      public:
        typedef H223AL2MParameters_headerFEC value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class headerFEC
    headerFEC::const_reference get_headerFEC () const;
    headerFEC::reference ref_headerFEC ();
    headerFEC::reference set_headerFEC ();
    headerFEC::reference set_headerFEC (headerFEC::const_reference value);
    class alpduInterleaving {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alpduInterleaving
    alpduInterleaving::const_reference get_alpduInterleaving () const;
    alpduInterleaving::reference ref_alpduInterleaving ();
    alpduInterleaving::reference set_alpduInterleaving ();
    alpduInterleaving::reference set_alpduInterleaving (bool value);
    void swap(H223AL2MParameters& other);
    H223AL2MParameters * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// V76HDLCParameters
//

class V76HDLCParameters : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    V76HDLCParameters(const void* info) : Inherited(info) {}
  public:
    V76HDLCParameters() : Inherited(&theInfo) {}
    V76HDLCParameters(const V76HDLCParameters & other) : Inherited(other)
    {}
    V76HDLCParameters& operator = (const V76HDLCParameters& other)
    { Inherited::operator = (other); return *this; } 
    class crcLength {
      public:
        typedef CRCLength value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class crcLength
    crcLength::const_reference get_crcLength () const;
    crcLength::reference ref_crcLength ();
    crcLength::reference set_crcLength ();
    crcLength::reference set_crcLength (crcLength::const_reference value);
    class n401 {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 4095>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class n401
    n401::const_reference get_n401 () const;
    n401::reference ref_n401 ();
    n401::reference set_n401 ();
    n401::reference set_n401 (n401::value_type::int_type value);
    class loopbackTestProcedure {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class loopbackTestProcedure
    loopbackTestProcedure::const_reference get_loopbackTestProcedure () const;
    loopbackTestProcedure::reference ref_loopbackTestProcedure ();
    loopbackTestProcedure::reference set_loopbackTestProcedure ();
    loopbackTestProcedure::reference set_loopbackTestProcedure (bool value);
    void swap(V76HDLCParameters& other);
    V76HDLCParameters * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// RTPPayloadType
//

class RTPPayloadType : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RTPPayloadType(const void* info) : Inherited(info) {}
  public:
    RTPPayloadType() : Inherited(&theInfo) {}
    RTPPayloadType(const RTPPayloadType & other) : Inherited(other)
    {}
    RTPPayloadType& operator = (const RTPPayloadType& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_payloadType
    };

    class payloadDescriptor {
      public:
        typedef RTPPayloadType_payloadDescriptor value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class payloadDescriptor
    payloadDescriptor::const_reference get_payloadDescriptor () const;
    payloadDescriptor::reference ref_payloadDescriptor ();
    payloadDescriptor::reference set_payloadDescriptor ();
    payloadDescriptor::reference set_payloadDescriptor (payloadDescriptor::const_reference value);
    class payloadType {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 127>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class payloadType
    payloadType::const_reference get_payloadType () const;
    payloadType::reference ref_payloadType ();
    payloadType::reference set_payloadType ();
    payloadType::reference set_payloadType (payloadType::value_type::int_type value);
    void omit_payloadType ();
    bool payloadType_isPresent () const;
    void swap(RTPPayloadType& other);
    RTPPayloadType * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// TerminalLabel
//

class TerminalLabel : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    TerminalLabel(const void* info) : Inherited(info) {}
  public:
    TerminalLabel() : Inherited(&theInfo) {}
    TerminalLabel(const TerminalLabel & other) : Inherited(other)
    {}
    TerminalLabel& operator = (const TerminalLabel& other)
    { Inherited::operator = (other); return *this; } 
    class mcuNumber {
      public:
        typedef McuNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mcuNumber
    mcuNumber::const_reference get_mcuNumber () const;
    mcuNumber::reference ref_mcuNumber ();
    mcuNumber::reference set_mcuNumber ();
    mcuNumber::reference set_mcuNumber (mcuNumber::value_type::int_type value);
    class terminalNumber {
      public:
        typedef TerminalNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class terminalNumber
    terminalNumber::const_reference get_terminalNumber () const;
    terminalNumber::reference ref_terminalNumber ();
    terminalNumber::reference set_terminalNumber ();
    terminalNumber::reference set_terminalNumber (terminalNumber::value_type::int_type value);
    void swap(TerminalLabel& other);
    TerminalLabel * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// RSVPParameters
//

class RSVPParameters : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RSVPParameters(const void* info) : Inherited(info) {}
  public:
    RSVPParameters() : Inherited(&theInfo) {}
    RSVPParameters(const RSVPParameters & other) : Inherited(other)
    {}
    RSVPParameters& operator = (const RSVPParameters& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_qosMode,
      e_tokenRate,
      e_bucketSize,
      e_peakRate,
      e_minPoliced,
      e_maxPktSize
    };

    class qosMode {
      public:
        typedef QOSMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class qosMode
    qosMode::const_reference get_qosMode () const;
    qosMode::reference ref_qosMode ();
    qosMode::reference set_qosMode ();
    qosMode::reference set_qosMode (qosMode::const_reference value);
    void omit_qosMode ();
    bool qosMode_isPresent () const;
    class tokenRate {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 4294967295U>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class tokenRate
    tokenRate::const_reference get_tokenRate () const;
    tokenRate::reference ref_tokenRate ();
    tokenRate::reference set_tokenRate ();
    tokenRate::reference set_tokenRate (tokenRate::value_type::int_type value);
    void omit_tokenRate ();
    bool tokenRate_isPresent () const;
    class bucketSize {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 4294967295U>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class bucketSize
    bucketSize::const_reference get_bucketSize () const;
    bucketSize::reference ref_bucketSize ();
    bucketSize::reference set_bucketSize ();
    bucketSize::reference set_bucketSize (bucketSize::value_type::int_type value);
    void omit_bucketSize ();
    bool bucketSize_isPresent () const;
    class peakRate {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 4294967295U>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class peakRate
    peakRate::const_reference get_peakRate () const;
    peakRate::reference ref_peakRate ();
    peakRate::reference set_peakRate ();
    peakRate::reference set_peakRate (peakRate::value_type::int_type value);
    void omit_peakRate ();
    bool peakRate_isPresent () const;
    class minPoliced {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 4294967295U>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class minPoliced
    minPoliced::const_reference get_minPoliced () const;
    minPoliced::reference ref_minPoliced ();
    minPoliced::reference set_minPoliced ();
    minPoliced::reference set_minPoliced (minPoliced::value_type::int_type value);
    void omit_minPoliced ();
    bool minPoliced_isPresent () const;
    class maxPktSize {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 4294967295U>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class maxPktSize
    maxPktSize::const_reference get_maxPktSize () const;
    maxPktSize::reference ref_maxPktSize ();
    maxPktSize::reference set_maxPktSize ();
    maxPktSize::reference set_maxPktSize (maxPktSize::value_type::int_type value);
    void omit_maxPktSize ();
    bool maxPktSize_isPresent () const;
    void swap(RSVPParameters& other);
    RSVPParameters * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[6];
    static int fieldIds[6];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[6];
#endif
};

//
// H223AnnexCArqParameters
//

class H223AnnexCArqParameters : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    H223AnnexCArqParameters(const void* info) : Inherited(info) {}
  public:
    H223AnnexCArqParameters() : Inherited(&theInfo) {}
    H223AnnexCArqParameters(const H223AnnexCArqParameters & other) : Inherited(other)
    {}
    H223AnnexCArqParameters& operator = (const H223AnnexCArqParameters& other)
    { Inherited::operator = (other); return *this; } 
    class numberOfRetransmissions {
      public:
        typedef H223AnnexCArqParameters_numberOfRetransmissions value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class numberOfRetransmissions
    numberOfRetransmissions::const_reference get_numberOfRetransmissions () const;
    numberOfRetransmissions::reference ref_numberOfRetransmissions ();
    numberOfRetransmissions::reference set_numberOfRetransmissions ();
    numberOfRetransmissions::reference set_numberOfRetransmissions (numberOfRetransmissions::const_reference value);
    class sendBufferSize {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 16777215>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sendBufferSize
    sendBufferSize::const_reference get_sendBufferSize () const;
    sendBufferSize::reference ref_sendBufferSize ();
    sendBufferSize::reference set_sendBufferSize ();
    sendBufferSize::reference set_sendBufferSize (sendBufferSize::value_type::int_type value);
    void swap(H223AnnexCArqParameters& other);
    H223AnnexCArqParameters * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// MediaTransportType
//

class MediaTransportType : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    MediaTransportType(const void* info) : Inherited(info) {}
  public:
    MediaTransportType() : Inherited(&theInfo) {}
    class ip_UDP {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class ip_UDP

    ip_UDP::reference select_ip_UDP (); 
    bool ip_UDP_isSelected() const;

    class ip_TCP {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class ip_TCP

    ip_TCP::reference select_ip_TCP (); 
    bool ip_TCP_isSelected() const;

    class atm_AAL5_UNIDIR {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class atm_AAL5_UNIDIR

    atm_AAL5_UNIDIR::reference select_atm_AAL5_UNIDIR (); 
    bool atm_AAL5_UNIDIR_isSelected() const;

    class atm_AAL5_BIDIR {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class atm_AAL5_BIDIR

    atm_AAL5_BIDIR::reference select_atm_AAL5_BIDIR (); 
    bool atm_AAL5_BIDIR_isSelected() const;

    class atm_AAL5_compressed {
      public:
        enum Id { id_ = 4 };
        typedef MediaTransportType_atm_AAL5_compressed value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class atm_AAL5_compressed

    atm_AAL5_compressed::const_reference get_atm_AAL5_compressed () const;
    atm_AAL5_compressed::reference ref_atm_AAL5_compressed (); 
    atm_AAL5_compressed::reference select_atm_AAL5_compressed (); 
    atm_AAL5_compressed::reference select_atm_AAL5_compressed (atm_AAL5_compressed::const_reference value); 
    bool atm_AAL5_compressed_isSelected() const;

    MediaTransportType(ip_UDP::Id id, ip_UDP::const_reference value);
    MediaTransportType(ip_TCP::Id id, ip_TCP::const_reference value);
    MediaTransportType(atm_AAL5_UNIDIR::Id id, atm_AAL5_UNIDIR::const_reference value);
    MediaTransportType(atm_AAL5_BIDIR::Id id, atm_AAL5_BIDIR::const_reference value);
    MediaTransportType(atm_AAL5_compressed::Id id, atm_AAL5_compressed::const_reference value);
    void swap(MediaTransportType & other);
    MediaTransportType(const MediaTransportType & other)
    : Inherited(other) {} 

    MediaTransportType & operator = (const MediaTransportType & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    MediaTransportType * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[5];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[5];
#endif
};

//
// RTPH263VideoRedundancyFrameMapping
//

class RTPH263VideoRedundancyFrameMapping : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RTPH263VideoRedundancyFrameMapping(const void* info) : Inherited(info) {}
  public:
    RTPH263VideoRedundancyFrameMapping() : Inherited(&theInfo) {}
    RTPH263VideoRedundancyFrameMapping(const RTPH263VideoRedundancyFrameMapping & other) : Inherited(other)
    {}
    RTPH263VideoRedundancyFrameMapping& operator = (const RTPH263VideoRedundancyFrameMapping& other)
    { Inherited::operator = (other); return *this; } 
    class threadNumber {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 15>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class threadNumber
    threadNumber::const_reference get_threadNumber () const;
    threadNumber::reference ref_threadNumber ();
    threadNumber::reference set_threadNumber ();
    threadNumber::reference set_threadNumber (threadNumber::value_type::int_type value);
    class frameSequence {
      public:
        typedef RTPH263VideoRedundancyFrameMapping_frameSequence value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class frameSequence
    frameSequence::const_reference get_frameSequence () const;
    frameSequence::reference ref_frameSequence ();
    frameSequence::reference set_frameSequence ();
    frameSequence::reference set_frameSequence (frameSequence::const_reference value);
    void swap(RTPH263VideoRedundancyFrameMapping& other);
    RTPH263VideoRedundancyFrameMapping * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// H2250LogicalChannelParameters_mediaPacketization
//

class H2250LogicalChannelParameters_mediaPacketization : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    H2250LogicalChannelParameters_mediaPacketization(const void* info) : Inherited(info) {}
  public:
    H2250LogicalChannelParameters_mediaPacketization() : Inherited(&theInfo) {}
    class h261aVideoPacketization {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h261aVideoPacketization

    h261aVideoPacketization::reference select_h261aVideoPacketization (); 
    bool h261aVideoPacketization_isSelected() const;

    class rtpPayloadType {
      public:
        enum Id { id_ = 1 };
        typedef RTPPayloadType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rtpPayloadType

    rtpPayloadType::const_reference get_rtpPayloadType () const;
    rtpPayloadType::reference ref_rtpPayloadType (); 
    rtpPayloadType::reference select_rtpPayloadType (); 
    rtpPayloadType::reference select_rtpPayloadType (rtpPayloadType::const_reference value); 
    bool rtpPayloadType_isSelected() const;

    H2250LogicalChannelParameters_mediaPacketization(h261aVideoPacketization::Id id, h261aVideoPacketization::const_reference value);
    H2250LogicalChannelParameters_mediaPacketization(rtpPayloadType::Id id, rtpPayloadType::const_reference value);
    void swap(H2250LogicalChannelParameters_mediaPacketization & other);
    H2250LogicalChannelParameters_mediaPacketization(const H2250LogicalChannelParameters_mediaPacketization & other)
    : Inherited(other) {} 

    H2250LogicalChannelParameters_mediaPacketization & operator = (const H2250LogicalChannelParameters_mediaPacketization & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    H2250LogicalChannelParameters_mediaPacketization * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// H223AL1MParameters_arqType
//

class H223AL1MParameters_arqType : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    H223AL1MParameters_arqType(const void* info) : Inherited(info) {}
  public:
    H223AL1MParameters_arqType() : Inherited(&theInfo) {}
    class noArq {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class noArq

    noArq::reference select_noArq (); 
    bool noArq_isSelected() const;

    class typeIArq {
      public:
        enum Id { id_ = 1 };
        typedef H223AnnexCArqParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class typeIArq

    typeIArq::const_reference get_typeIArq () const;
    typeIArq::reference ref_typeIArq (); 
    typeIArq::reference select_typeIArq (); 
    typeIArq::reference select_typeIArq (typeIArq::const_reference value); 
    bool typeIArq_isSelected() const;

    class typeIIArq {
      public:
        enum Id { id_ = 2 };
        typedef H223AnnexCArqParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class typeIIArq

    typeIIArq::const_reference get_typeIIArq () const;
    typeIIArq::reference ref_typeIIArq (); 
    typeIIArq::reference select_typeIIArq (); 
    typeIIArq::reference select_typeIIArq (typeIIArq::const_reference value); 
    bool typeIIArq_isSelected() const;

    H223AL1MParameters_arqType(noArq::Id id, noArq::const_reference value);
    H223AL1MParameters_arqType(typeIArq::Id id, typeIArq::const_reference value);
    H223AL1MParameters_arqType(typeIIArq::Id id, typeIIArq::const_reference value);
    void swap(H223AL1MParameters_arqType & other);
    H223AL1MParameters_arqType(const H223AL1MParameters_arqType & other)
    : Inherited(other) {} 

    H223AL1MParameters_arqType & operator = (const H223AL1MParameters_arqType & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    H223AL1MParameters_arqType * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// H223AL3MParameters_arqType
//

class H223AL3MParameters_arqType : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    H223AL3MParameters_arqType(const void* info) : Inherited(info) {}
  public:
    H223AL3MParameters_arqType() : Inherited(&theInfo) {}
    class noArq {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class noArq

    noArq::reference select_noArq (); 
    bool noArq_isSelected() const;

    class typeIArq {
      public:
        enum Id { id_ = 1 };
        typedef H223AnnexCArqParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class typeIArq

    typeIArq::const_reference get_typeIArq () const;
    typeIArq::reference ref_typeIArq (); 
    typeIArq::reference select_typeIArq (); 
    typeIArq::reference select_typeIArq (typeIArq::const_reference value); 
    bool typeIArq_isSelected() const;

    class typeIIArq {
      public:
        enum Id { id_ = 2 };
        typedef H223AnnexCArqParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class typeIIArq

    typeIIArq::const_reference get_typeIIArq () const;
    typeIIArq::reference ref_typeIIArq (); 
    typeIIArq::reference select_typeIIArq (); 
    typeIIArq::reference select_typeIIArq (typeIIArq::const_reference value); 
    bool typeIIArq_isSelected() const;

    H223AL3MParameters_arqType(noArq::Id id, noArq::const_reference value);
    H223AL3MParameters_arqType(typeIArq::Id id, typeIArq::const_reference value);
    H223AL3MParameters_arqType(typeIIArq::Id id, typeIIArq::const_reference value);
    void swap(H223AL3MParameters_arqType & other);
    H223AL3MParameters_arqType(const H223AL3MParameters_arqType & other)
    : Inherited(other) {} 

    H223AL3MParameters_arqType & operator = (const H223AL3MParameters_arqType & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    H223AL3MParameters_arqType * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// RTPH263VideoRedundancyEncoding_frameToThreadMapping
//

class RTPH263VideoRedundancyEncoding_frameToThreadMapping : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    RTPH263VideoRedundancyEncoding_frameToThreadMapping(const void* info) : Inherited(info) {}
  public:
    RTPH263VideoRedundancyEncoding_frameToThreadMapping() : Inherited(&theInfo) {}
    class roundrobin {
      public:
        enum Id { id_ = 0 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class roundrobin

    roundrobin::reference select_roundrobin (); 
    bool roundrobin_isSelected() const;

    class custom {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::SEQUENCE_OF<RTPH263VideoRedundancyFrameMapping,  ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 256> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class custom

    custom::const_reference get_custom () const;
    custom::reference ref_custom (); 
    custom::reference select_custom (); 
    custom::reference select_custom (custom::const_reference value); 
    bool custom_isSelected() const;

    RTPH263VideoRedundancyEncoding_frameToThreadMapping(roundrobin::Id id, roundrobin::const_reference value);
    RTPH263VideoRedundancyEncoding_frameToThreadMapping(custom::Id id, custom::const_reference value);
    void swap(RTPH263VideoRedundancyEncoding_frameToThreadMapping & other);
    RTPH263VideoRedundancyEncoding_frameToThreadMapping(const RTPH263VideoRedundancyEncoding_frameToThreadMapping & other)
    : Inherited(other) {} 

    RTPH263VideoRedundancyEncoding_frameToThreadMapping & operator = (const RTPH263VideoRedundancyEncoding_frameToThreadMapping & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    RTPH263VideoRedundancyEncoding_frameToThreadMapping * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// V76LogicalChannelParameters_mode_eRM
//

class V76LogicalChannelParameters_mode_eRM : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    V76LogicalChannelParameters_mode_eRM(const void* info) : Inherited(info) {}
  public:
    V76LogicalChannelParameters_mode_eRM() : Inherited(&theInfo) {}
    V76LogicalChannelParameters_mode_eRM(const V76LogicalChannelParameters_mode_eRM & other) : Inherited(other)
    {}
    V76LogicalChannelParameters_mode_eRM& operator = (const V76LogicalChannelParameters_mode_eRM& other)
    { Inherited::operator = (other); return *this; } 
    class windowSize {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 127>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class windowSize
    windowSize::const_reference get_windowSize () const;
    windowSize::reference ref_windowSize ();
    windowSize::reference set_windowSize ();
    windowSize::reference set_windowSize (windowSize::value_type::int_type value);
    class recovery {
      public:
        typedef V76LogicalChannelParameters_mode_eRM_recovery value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class recovery
    recovery::const_reference get_recovery () const;
    recovery::reference ref_recovery ();
    recovery::reference set_recovery ();
    recovery::reference set_recovery (recovery::const_reference value);
    void swap(V76LogicalChannelParameters_mode_eRM& other);
    V76LogicalChannelParameters_mode_eRM * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// DataType
//

class DataType : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    DataType(const void* info) : Inherited(info) {}
  public:
    DataType() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class nullData {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nullData

    nullData::reference select_nullData (); 
    bool nullData_isSelected() const;

    class videoData {
      public:
        enum Id { id_ = 2 };
        typedef VideoCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class videoData

    videoData::const_reference get_videoData () const;
    videoData::reference ref_videoData (); 
    videoData::reference select_videoData (); 
    videoData::reference select_videoData (videoData::const_reference value); 
    bool videoData_isSelected() const;

    class audioData {
      public:
        enum Id { id_ = 3 };
        typedef AudioCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class audioData

    audioData::const_reference get_audioData () const;
    audioData::reference ref_audioData (); 
    audioData::reference select_audioData (); 
    audioData::reference select_audioData (audioData::const_reference value); 
    bool audioData_isSelected() const;

    class data {
      public:
        enum Id { id_ = 4 };
        typedef DataApplicationCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class data

    data::const_reference get_data () const;
    data::reference ref_data (); 
    data::reference select_data (); 
    data::reference select_data (data::const_reference value); 
    bool data_isSelected() const;

    class encryptionData {
      public:
        enum Id { id_ = 5 };
        typedef EncryptionMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class encryptionData

    encryptionData::const_reference get_encryptionData () const;
    encryptionData::reference ref_encryptionData (); 
    encryptionData::reference select_encryptionData (); 
    encryptionData::reference select_encryptionData (encryptionData::const_reference value); 
    bool encryptionData_isSelected() const;

    class h235Control {
      public:
        enum Id { id_ = 6 };
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h235Control

    h235Control::const_reference get_h235Control () const;
    h235Control::reference ref_h235Control (); 
    h235Control::reference select_h235Control (); 
    h235Control::reference select_h235Control (h235Control::const_reference value); 
    bool h235Control_isSelected() const;

    class h235Media {
      public:
        enum Id { id_ = 7 };
        typedef H235Media value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h235Media

    h235Media::const_reference get_h235Media () const;
    h235Media::reference ref_h235Media (); 
    h235Media::reference select_h235Media (); 
    h235Media::reference select_h235Media (h235Media::const_reference value); 
    bool h235Media_isSelected() const;

    class multiplexedStream {
      public:
        enum Id { id_ = 8 };
        typedef MultiplexedStreamParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multiplexedStream

    multiplexedStream::const_reference get_multiplexedStream () const;
    multiplexedStream::reference ref_multiplexedStream (); 
    multiplexedStream::reference select_multiplexedStream (); 
    multiplexedStream::reference select_multiplexedStream (multiplexedStream::const_reference value); 
    bool multiplexedStream_isSelected() const;

    DataType(nonStandard::Id id, nonStandard::const_reference value);
    DataType(nullData::Id id, nullData::const_reference value);
    DataType(videoData::Id id, videoData::const_reference value);
    DataType(audioData::Id id, audioData::const_reference value);
    DataType(data::Id id, data::const_reference value);
    DataType(encryptionData::Id id, encryptionData::const_reference value);
    DataType(h235Control::Id id, h235Control::const_reference value);
    DataType(h235Media::Id id, h235Media::const_reference value);
    DataType(multiplexedStream::Id id, multiplexedStream::const_reference value);
    void swap(DataType & other);
    DataType(const DataType & other)
    : Inherited(other) {} 

    DataType & operator = (const DataType & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    DataType * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[9];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[9];
#endif
};

//
// QOSCapability
//

class QOSCapability : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    QOSCapability(const void* info) : Inherited(info) {}
  public:
    QOSCapability() : Inherited(&theInfo) {}
    QOSCapability(const QOSCapability & other) : Inherited(other)
    {}
    QOSCapability& operator = (const QOSCapability& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandardData,
      e_rsvpParameters,
      e_atmParameters
    };

    class nonStandardData {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandardData
    nonStandardData::const_reference get_nonStandardData () const;
    nonStandardData::reference ref_nonStandardData ();
    nonStandardData::reference set_nonStandardData ();
    nonStandardData::reference set_nonStandardData (nonStandardData::const_reference value);
    void omit_nonStandardData ();
    bool nonStandardData_isPresent () const;
    class rsvpParameters {
      public:
        typedef RSVPParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rsvpParameters
    rsvpParameters::const_reference get_rsvpParameters () const;
    rsvpParameters::reference ref_rsvpParameters ();
    rsvpParameters::reference set_rsvpParameters ();
    rsvpParameters::reference set_rsvpParameters (rsvpParameters::const_reference value);
    void omit_rsvpParameters ();
    bool rsvpParameters_isPresent () const;
    class atmParameters {
      public:
        typedef ATMParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class atmParameters
    atmParameters::const_reference get_atmParameters () const;
    atmParameters::reference ref_atmParameters ();
    atmParameters::reference set_atmParameters ();
    atmParameters::reference set_atmParameters (atmParameters::const_reference value);
    void omit_atmParameters ();
    bool atmParameters_isPresent () const;
    void swap(QOSCapability& other);
    QOSCapability * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// H223AL1MParameters
//

class H223AL1MParameters : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    H223AL1MParameters(const void* info) : Inherited(info) {}
  public:
    H223AL1MParameters() : Inherited(&theInfo) {}
    H223AL1MParameters(const H223AL1MParameters & other) : Inherited(other)
    {}
    H223AL1MParameters& operator = (const H223AL1MParameters& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_rsCodeCorrection
    };

    class transferMode {
      public:
        typedef H223AL1MParameters_transferMode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class transferMode
    transferMode::const_reference get_transferMode () const;
    transferMode::reference ref_transferMode ();
    transferMode::reference set_transferMode ();
    transferMode::reference set_transferMode (transferMode::const_reference value);
    class headerFEC {
      public:
        typedef H223AL1MParameters_headerFEC value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class headerFEC
    headerFEC::const_reference get_headerFEC () const;
    headerFEC::reference ref_headerFEC ();
    headerFEC::reference set_headerFEC ();
    headerFEC::reference set_headerFEC (headerFEC::const_reference value);
    class crcLength {
      public:
        typedef H223AL1MParameters_crcLength value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class crcLength
    crcLength::const_reference get_crcLength () const;
    crcLength::reference ref_crcLength ();
    crcLength::reference set_crcLength ();
    crcLength::reference set_crcLength (crcLength::const_reference value);
    class rcpcCodeRate {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 8, 32>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rcpcCodeRate
    rcpcCodeRate::const_reference get_rcpcCodeRate () const;
    rcpcCodeRate::reference ref_rcpcCodeRate ();
    rcpcCodeRate::reference set_rcpcCodeRate ();
    rcpcCodeRate::reference set_rcpcCodeRate (rcpcCodeRate::value_type::int_type value);
    class arqType {
      public:
        typedef H223AL1MParameters_arqType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class arqType
    arqType::const_reference get_arqType () const;
    arqType::reference ref_arqType ();
    arqType::reference set_arqType ();
    arqType::reference set_arqType (arqType::const_reference value);
    class alpduInterleaving {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alpduInterleaving
    alpduInterleaving::const_reference get_alpduInterleaving () const;
    alpduInterleaving::reference ref_alpduInterleaving ();
    alpduInterleaving::reference set_alpduInterleaving ();
    alpduInterleaving::reference set_alpduInterleaving (bool value);
    class alsduSplitting {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alsduSplitting
    alsduSplitting::const_reference get_alsduSplitting () const;
    alsduSplitting::reference ref_alsduSplitting ();
    alsduSplitting::reference set_alsduSplitting ();
    alsduSplitting::reference set_alsduSplitting (bool value);
    class rsCodeCorrection {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 127>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rsCodeCorrection
    rsCodeCorrection::const_reference get_rsCodeCorrection () const;
    rsCodeCorrection::reference ref_rsCodeCorrection ();
    rsCodeCorrection::reference set_rsCodeCorrection ();
    rsCodeCorrection::reference set_rsCodeCorrection (rsCodeCorrection::value_type::int_type value);
    void omit_rsCodeCorrection ();
    bool rsCodeCorrection_isPresent () const;
    void swap(H223AL1MParameters& other);
    H223AL1MParameters * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[8];
    static int fieldIds[8];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[8];
#endif
};

//
// H223AL3MParameters
//

class H223AL3MParameters : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    H223AL3MParameters(const void* info) : Inherited(info) {}
  public:
    H223AL3MParameters() : Inherited(&theInfo) {}
    H223AL3MParameters(const H223AL3MParameters & other) : Inherited(other)
    {}
    H223AL3MParameters& operator = (const H223AL3MParameters& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_rsCodeCorrection
    };

    class headerFormat {
      public:
        typedef H223AL3MParameters_headerFormat value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class headerFormat
    headerFormat::const_reference get_headerFormat () const;
    headerFormat::reference ref_headerFormat ();
    headerFormat::reference set_headerFormat ();
    headerFormat::reference set_headerFormat (headerFormat::const_reference value);
    class crcLength {
      public:
        typedef H223AL3MParameters_crcLength value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class crcLength
    crcLength::const_reference get_crcLength () const;
    crcLength::reference ref_crcLength ();
    crcLength::reference set_crcLength ();
    crcLength::reference set_crcLength (crcLength::const_reference value);
    class rcpcCodeRate {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 8, 32>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rcpcCodeRate
    rcpcCodeRate::const_reference get_rcpcCodeRate () const;
    rcpcCodeRate::reference ref_rcpcCodeRate ();
    rcpcCodeRate::reference set_rcpcCodeRate ();
    rcpcCodeRate::reference set_rcpcCodeRate (rcpcCodeRate::value_type::int_type value);
    class arqType {
      public:
        typedef H223AL3MParameters_arqType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class arqType
    arqType::const_reference get_arqType () const;
    arqType::reference ref_arqType ();
    arqType::reference set_arqType ();
    arqType::reference set_arqType (arqType::const_reference value);
    class alpduInterleaving {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class alpduInterleaving
    alpduInterleaving::const_reference get_alpduInterleaving () const;
    alpduInterleaving::reference ref_alpduInterleaving ();
    alpduInterleaving::reference set_alpduInterleaving ();
    alpduInterleaving::reference set_alpduInterleaving (bool value);
    class rsCodeCorrection {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 127>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rsCodeCorrection
    rsCodeCorrection::const_reference get_rsCodeCorrection () const;
    rsCodeCorrection::reference ref_rsCodeCorrection ();
    rsCodeCorrection::reference set_rsCodeCorrection ();
    rsCodeCorrection::reference set_rsCodeCorrection (rsCodeCorrection::value_type::int_type value);
    void omit_rsCodeCorrection ();
    bool rsCodeCorrection_isPresent () const;
    void swap(H223AL3MParameters& other);
    H223AL3MParameters * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[6];
    static int fieldIds[6];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[6];
#endif
};

//
// MediaChannelCapability
//

class MediaChannelCapability : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    MediaChannelCapability(const void* info) : Inherited(info) {}
  public:
    MediaChannelCapability() : Inherited(&theInfo) {}
    MediaChannelCapability(const MediaChannelCapability & other) : Inherited(other)
    {}
    MediaChannelCapability& operator = (const MediaChannelCapability& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_mediaTransport
    };

    class mediaTransport {
      public:
        typedef MediaTransportType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mediaTransport
    mediaTransport::const_reference get_mediaTransport () const;
    mediaTransport::reference ref_mediaTransport ();
    mediaTransport::reference set_mediaTransport ();
    mediaTransport::reference set_mediaTransport (mediaTransport::const_reference value);
    void omit_mediaTransport ();
    bool mediaTransport_isPresent () const;
    void swap(MediaChannelCapability& other);
    MediaChannelCapability * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[1];
    static int fieldIds[1];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[1];
#endif
};

//
// RTPH263VideoRedundancyEncoding
//

class RTPH263VideoRedundancyEncoding : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RTPH263VideoRedundancyEncoding(const void* info) : Inherited(info) {}
  public:
    RTPH263VideoRedundancyEncoding() : Inherited(&theInfo) {}
    RTPH263VideoRedundancyEncoding(const RTPH263VideoRedundancyEncoding & other) : Inherited(other)
    {}
    RTPH263VideoRedundancyEncoding& operator = (const RTPH263VideoRedundancyEncoding& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_containedThreads
    };

    class numberOfThreads {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 16>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class numberOfThreads
    numberOfThreads::const_reference get_numberOfThreads () const;
    numberOfThreads::reference ref_numberOfThreads ();
    numberOfThreads::reference set_numberOfThreads ();
    numberOfThreads::reference set_numberOfThreads (numberOfThreads::value_type::int_type value);
    class framesBetweenSyncPoints {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 256>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class framesBetweenSyncPoints
    framesBetweenSyncPoints::const_reference get_framesBetweenSyncPoints () const;
    framesBetweenSyncPoints::reference ref_framesBetweenSyncPoints ();
    framesBetweenSyncPoints::reference set_framesBetweenSyncPoints ();
    framesBetweenSyncPoints::reference set_framesBetweenSyncPoints (framesBetweenSyncPoints::value_type::int_type value);
    class frameToThreadMapping {
      public:
        typedef RTPH263VideoRedundancyEncoding_frameToThreadMapping value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class frameToThreadMapping
    frameToThreadMapping::const_reference get_frameToThreadMapping () const;
    frameToThreadMapping::reference ref_frameToThreadMapping ();
    frameToThreadMapping::reference set_frameToThreadMapping ();
    frameToThreadMapping::reference set_frameToThreadMapping (frameToThreadMapping::const_reference value);
    class containedThreads {
      public:
        typedef RTPH263VideoRedundancyEncoding_containedThreads value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class containedThreads
    containedThreads::const_reference get_containedThreads () const;
    containedThreads::reference ref_containedThreads ();
    containedThreads::reference set_containedThreads ();
    containedThreads::reference set_containedThreads (containedThreads::const_reference value);
    void omit_containedThreads ();
    bool containedThreads_isPresent () const;
    void swap(RTPH263VideoRedundancyEncoding& other);
    RTPH263VideoRedundancyEncoding * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// H223LogicalChannelParameters_adaptationLayerType
//

class H223LogicalChannelParameters_adaptationLayerType : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    H223LogicalChannelParameters_adaptationLayerType(const void* info) : Inherited(info) {}
  public:
    H223LogicalChannelParameters_adaptationLayerType() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class al1Framed {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class al1Framed

    al1Framed::reference select_al1Framed (); 
    bool al1Framed_isSelected() const;

    class al1NotFramed {
      public:
        enum Id { id_ = 2 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class al1NotFramed

    al1NotFramed::reference select_al1NotFramed (); 
    bool al1NotFramed_isSelected() const;

    class al2WithoutSequenceNumbers {
      public:
        enum Id { id_ = 3 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class al2WithoutSequenceNumbers

    al2WithoutSequenceNumbers::reference select_al2WithoutSequenceNumbers (); 
    bool al2WithoutSequenceNumbers_isSelected() const;

    class al2WithSequenceNumbers {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class al2WithSequenceNumbers

    al2WithSequenceNumbers::reference select_al2WithSequenceNumbers (); 
    bool al2WithSequenceNumbers_isSelected() const;

    class al3 {
      public:
        enum Id { id_ = 5 };
        typedef H223LogicalChannelParameters_adaptationLayerType_al3 value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class al3

    al3::const_reference get_al3 () const;
    al3::reference ref_al3 (); 
    al3::reference select_al3 (); 
    al3::reference select_al3 (al3::const_reference value); 
    bool al3_isSelected() const;

    class al1M {
      public:
        enum Id { id_ = 6 };
        typedef H223AL1MParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class al1M

    al1M::const_reference get_al1M () const;
    al1M::reference ref_al1M (); 
    al1M::reference select_al1M (); 
    al1M::reference select_al1M (al1M::const_reference value); 
    bool al1M_isSelected() const;

    class al2M {
      public:
        enum Id { id_ = 7 };
        typedef H223AL2MParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class al2M

    al2M::const_reference get_al2M () const;
    al2M::reference ref_al2M (); 
    al2M::reference select_al2M (); 
    al2M::reference select_al2M (al2M::const_reference value); 
    bool al2M_isSelected() const;

    class al3M {
      public:
        enum Id { id_ = 8 };
        typedef H223AL3MParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class al3M

    al3M::const_reference get_al3M () const;
    al3M::reference ref_al3M (); 
    al3M::reference select_al3M (); 
    al3M::reference select_al3M (al3M::const_reference value); 
    bool al3M_isSelected() const;

    H223LogicalChannelParameters_adaptationLayerType(nonStandard::Id id, nonStandard::const_reference value);
    H223LogicalChannelParameters_adaptationLayerType(al1Framed::Id id, al1Framed::const_reference value);
    H223LogicalChannelParameters_adaptationLayerType(al1NotFramed::Id id, al1NotFramed::const_reference value);
    H223LogicalChannelParameters_adaptationLayerType(al2WithoutSequenceNumbers::Id id, al2WithoutSequenceNumbers::const_reference value);
    H223LogicalChannelParameters_adaptationLayerType(al2WithSequenceNumbers::Id id, al2WithSequenceNumbers::const_reference value);
    H223LogicalChannelParameters_adaptationLayerType(al3::Id id, al3::const_reference value);
    H223LogicalChannelParameters_adaptationLayerType(al1M::Id id, al1M::const_reference value);
    H223LogicalChannelParameters_adaptationLayerType(al2M::Id id, al2M::const_reference value);
    H223LogicalChannelParameters_adaptationLayerType(al3M::Id id, al3M::const_reference value);
    void swap(H223LogicalChannelParameters_adaptationLayerType & other);
    H223LogicalChannelParameters_adaptationLayerType(const H223LogicalChannelParameters_adaptationLayerType & other)
    : Inherited(other) {} 

    H223LogicalChannelParameters_adaptationLayerType & operator = (const H223LogicalChannelParameters_adaptationLayerType & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    H223LogicalChannelParameters_adaptationLayerType * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[9];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[9];
#endif
};

//
// V76LogicalChannelParameters_mode
//

class V76LogicalChannelParameters_mode : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    V76LogicalChannelParameters_mode(const void* info) : Inherited(info) {}
  public:
    V76LogicalChannelParameters_mode() : Inherited(&theInfo) {}
    class eRM {
      public:
        enum Id { id_ = 0 };
        typedef V76LogicalChannelParameters_mode_eRM value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class eRM

    eRM::const_reference get_eRM () const;
    eRM::reference ref_eRM (); 
    eRM::reference select_eRM (); 
    eRM::reference select_eRM (eRM::const_reference value); 
    bool eRM_isSelected() const;

    class uNERM {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class uNERM

    uNERM::reference select_uNERM (); 
    bool uNERM_isSelected() const;

    V76LogicalChannelParameters_mode(eRM::Id id, eRM::const_reference value);
    V76LogicalChannelParameters_mode(uNERM::Id id, uNERM::const_reference value);
    void swap(V76LogicalChannelParameters_mode & other);
    V76LogicalChannelParameters_mode(const V76LogicalChannelParameters_mode & other)
    : Inherited(other) {} 

    V76LogicalChannelParameters_mode & operator = (const V76LogicalChannelParameters_mode & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    V76LogicalChannelParameters_mode * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// RequestChannelClose
//

class RequestChannelClose : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RequestChannelClose(const void* info) : Inherited(info) {}
  public:
    RequestChannelClose() : Inherited(&theInfo) {}
    RequestChannelClose(const RequestChannelClose & other) : Inherited(other)
    {}
    RequestChannelClose& operator = (const RequestChannelClose& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_qosCapability,
      e_reason
    };

    class forwardLogicalChannelNumber {
      public:
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class forwardLogicalChannelNumber
    forwardLogicalChannelNumber::const_reference get_forwardLogicalChannelNumber () const;
    forwardLogicalChannelNumber::reference ref_forwardLogicalChannelNumber ();
    forwardLogicalChannelNumber::reference set_forwardLogicalChannelNumber ();
    forwardLogicalChannelNumber::reference set_forwardLogicalChannelNumber (forwardLogicalChannelNumber::value_type::int_type value);
    class qosCapability {
      public:
        typedef QOSCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class qosCapability
    qosCapability::const_reference get_qosCapability () const;
    qosCapability::reference ref_qosCapability ();
    qosCapability::reference set_qosCapability ();
    qosCapability::reference set_qosCapability (qosCapability::const_reference value);
    void omit_qosCapability ();
    bool qosCapability_isPresent () const;
    class reason {
      public:
        typedef RequestChannelClose_reason value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class reason
    reason::const_reference get_reason () const;
    reason::reference ref_reason ();
    reason::reference set_reason ();
    reason::reference set_reason (reason::const_reference value);
    void omit_reason ();
    bool reason_isPresent () const;
    void swap(RequestChannelClose& other);
    RequestChannelClose * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
    static const char* nonOptionalExtensions;
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// H223LogicalChannelParameters
//

class H223LogicalChannelParameters : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    H223LogicalChannelParameters(const void* info) : Inherited(info) {}
  public:
    H223LogicalChannelParameters() : Inherited(&theInfo) {}
    H223LogicalChannelParameters(const H223LogicalChannelParameters & other) : Inherited(other)
    {}
    H223LogicalChannelParameters& operator = (const H223LogicalChannelParameters& other)
    { Inherited::operator = (other); return *this; } 
    class adaptationLayerType {
      public:
        typedef H223LogicalChannelParameters_adaptationLayerType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class adaptationLayerType
    adaptationLayerType::const_reference get_adaptationLayerType () const;
    adaptationLayerType::reference ref_adaptationLayerType ();
    adaptationLayerType::reference set_adaptationLayerType ();
    adaptationLayerType::reference set_adaptationLayerType (adaptationLayerType::const_reference value);
    class segmentableFlag {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class segmentableFlag
    segmentableFlag::const_reference get_segmentableFlag () const;
    segmentableFlag::reference ref_segmentableFlag ();
    segmentableFlag::reference set_segmentableFlag ();
    segmentableFlag::reference set_segmentableFlag (bool value);
    void swap(H223LogicalChannelParameters& other);
    H223LogicalChannelParameters * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// V76LogicalChannelParameters
//

class V76LogicalChannelParameters : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    V76LogicalChannelParameters(const void* info) : Inherited(info) {}
  public:
    V76LogicalChannelParameters() : Inherited(&theInfo) {}
    V76LogicalChannelParameters(const V76LogicalChannelParameters & other) : Inherited(other)
    {}
    V76LogicalChannelParameters& operator = (const V76LogicalChannelParameters& other)
    { Inherited::operator = (other); return *this; } 
    class hdlcParameters {
      public:
        typedef V76HDLCParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class hdlcParameters
    hdlcParameters::const_reference get_hdlcParameters () const;
    hdlcParameters::reference ref_hdlcParameters ();
    hdlcParameters::reference set_hdlcParameters ();
    hdlcParameters::reference set_hdlcParameters (hdlcParameters::const_reference value);
    class suspendResume {
      public:
        typedef V76LogicalChannelParameters_suspendResume value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class suspendResume
    suspendResume::const_reference get_suspendResume () const;
    suspendResume::reference ref_suspendResume ();
    suspendResume::reference set_suspendResume ();
    suspendResume::reference set_suspendResume (suspendResume::const_reference value);
    class uIH {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class uIH
    uIH::const_reference get_uIH () const;
    uIH::reference ref_uIH ();
    uIH::reference set_uIH ();
    uIH::reference set_uIH (bool value);
    class mode {
      public:
        typedef V76LogicalChannelParameters_mode value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mode
    mode::const_reference get_mode () const;
    mode::reference ref_mode ();
    mode::reference set_mode ();
    mode::reference set_mode (mode::const_reference value);
    class v75Parameters {
      public:
        typedef V75Parameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class v75Parameters
    v75Parameters::const_reference get_v75Parameters () const;
    v75Parameters::reference ref_v75Parameters ();
    v75Parameters::reference set_v75Parameters ();
    v75Parameters::reference set_v75Parameters (v75Parameters::const_reference value);
    void swap(V76LogicalChannelParameters& other);
    V76LogicalChannelParameters * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[5];
    static int fieldIds[5];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[5];
#endif
};

//
// TransportCapability
//

class TransportCapability : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    TransportCapability(const void* info) : Inherited(info) {}
  public:
    TransportCapability() : Inherited(&theInfo) {}
    TransportCapability(const TransportCapability & other) : Inherited(other)
    {}
    TransportCapability& operator = (const TransportCapability& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandard,
      e_qOSCapabilities,
      e_mediaChannelCapabilities
    };

    class nonStandard {
      public:
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard
    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard ();
    nonStandard::reference set_nonStandard ();
    nonStandard::reference set_nonStandard (nonStandard::const_reference value);
    void omit_nonStandard ();
    bool nonStandard_isPresent () const;
    class qOSCapabilities {
      public:
        typedef ASN1::SEQUENCE_OF<QOSCapability,  ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 256> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class qOSCapabilities
    qOSCapabilities::const_reference get_qOSCapabilities () const;
    qOSCapabilities::reference ref_qOSCapabilities ();
    qOSCapabilities::reference set_qOSCapabilities ();
    qOSCapabilities::reference set_qOSCapabilities (qOSCapabilities::const_reference value);
    void omit_qOSCapabilities ();
    bool qOSCapabilities_isPresent () const;
    class mediaChannelCapabilities {
      public:
        typedef ASN1::SEQUENCE_OF<MediaChannelCapability,  ASN1::SizeConstraint<ASN1::FixedConstraint, 1, 256> >  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mediaChannelCapabilities
    mediaChannelCapabilities::const_reference get_mediaChannelCapabilities () const;
    mediaChannelCapabilities::reference ref_mediaChannelCapabilities ();
    mediaChannelCapabilities::reference set_mediaChannelCapabilities ();
    mediaChannelCapabilities::reference set_mediaChannelCapabilities (mediaChannelCapabilities::const_reference value);
    void omit_mediaChannelCapabilities ();
    bool mediaChannelCapabilities_isPresent () const;
    void swap(TransportCapability& other);
    TransportCapability * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[3];
    static int fieldIds[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[3];
#endif
};

//
// RedundancyEncodingMethod
//

class RedundancyEncodingMethod : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    RedundancyEncodingMethod(const void* info) : Inherited(info) {}
  public:
    RedundancyEncodingMethod() : Inherited(&theInfo) {}
    class nonStandard {
      public:
        enum Id { id_ = 0 };
        typedef NonStandardParameter value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard

    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard (); 
    nonStandard::reference select_nonStandard (); 
    nonStandard::reference select_nonStandard (nonStandard::const_reference value); 
    bool nonStandard_isSelected() const;

    class rtpAudioRedundancyEncoding {
      public:
        enum Id { id_ = 1 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rtpAudioRedundancyEncoding

    rtpAudioRedundancyEncoding::reference select_rtpAudioRedundancyEncoding (); 
    bool rtpAudioRedundancyEncoding_isSelected() const;

    class rtpH263VideoRedundancyEncoding {
      public:
        enum Id { id_ = 2 };
        typedef RTPH263VideoRedundancyEncoding value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class rtpH263VideoRedundancyEncoding

    rtpH263VideoRedundancyEncoding::const_reference get_rtpH263VideoRedundancyEncoding () const;
    rtpH263VideoRedundancyEncoding::reference ref_rtpH263VideoRedundancyEncoding (); 
    rtpH263VideoRedundancyEncoding::reference select_rtpH263VideoRedundancyEncoding (); 
    rtpH263VideoRedundancyEncoding::reference select_rtpH263VideoRedundancyEncoding (rtpH263VideoRedundancyEncoding::const_reference value); 
    bool rtpH263VideoRedundancyEncoding_isSelected() const;

    RedundancyEncodingMethod(nonStandard::Id id, nonStandard::const_reference value);
    RedundancyEncodingMethod(rtpAudioRedundancyEncoding::Id id, rtpAudioRedundancyEncoding::const_reference value);
    RedundancyEncodingMethod(rtpH263VideoRedundancyEncoding::Id id, rtpH263VideoRedundancyEncoding::const_reference value);
    void swap(RedundancyEncodingMethod & other);
    RedundancyEncodingMethod(const RedundancyEncodingMethod & other)
    : Inherited(other) {} 

    RedundancyEncodingMethod & operator = (const RedundancyEncodingMethod & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    RedundancyEncodingMethod * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// RedundancyEncoding
//

class RedundancyEncoding : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    RedundancyEncoding(const void* info) : Inherited(info) {}
  public:
    RedundancyEncoding() : Inherited(&theInfo) {}
    RedundancyEncoding(const RedundancyEncoding & other) : Inherited(other)
    {}
    RedundancyEncoding& operator = (const RedundancyEncoding& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_secondaryEncoding
    };

    class redundancyEncodingMethod {
      public:
        typedef RedundancyEncodingMethod value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class redundancyEncodingMethod
    redundancyEncodingMethod::const_reference get_redundancyEncodingMethod () const;
    redundancyEncodingMethod::reference ref_redundancyEncodingMethod ();
    redundancyEncodingMethod::reference set_redundancyEncodingMethod ();
    redundancyEncodingMethod::reference set_redundancyEncodingMethod (redundancyEncodingMethod::const_reference value);
    class secondaryEncoding {
      public:
        typedef DataType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class secondaryEncoding
    secondaryEncoding::const_reference get_secondaryEncoding () const;
    secondaryEncoding::reference ref_secondaryEncoding ();
    secondaryEncoding::reference set_secondaryEncoding ();
    secondaryEncoding::reference set_secondaryEncoding (secondaryEncoding::const_reference value);
    void omit_secondaryEncoding ();
    bool secondaryEncoding_isPresent () const;
    void swap(RedundancyEncoding& other);
    RedundancyEncoding * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[2];
    static int fieldIds[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[2];
#endif
};

//
// H2250LogicalChannelParameters
//

class H2250LogicalChannelParameters : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    H2250LogicalChannelParameters(const void* info) : Inherited(info) {}
  public:
    H2250LogicalChannelParameters() : Inherited(&theInfo) {}
    H2250LogicalChannelParameters(const H2250LogicalChannelParameters & other) : Inherited(other)
    {}
    H2250LogicalChannelParameters& operator = (const H2250LogicalChannelParameters& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_nonStandard,
      e_associatedSessionID,
      e_mediaChannel,
      e_mediaGuaranteedDelivery,
      e_mediaControlChannel,
      e_mediaControlGuaranteedDelivery,
      e_silenceSuppression,
      e_destination,
      e_dynamicRTPPayloadType,
      e_mediaPacketization,
      e_transportCapability,
      e_redundancyEncoding,
      e_source
    };

    class nonStandard {
      public:
        typedef ASN1::SEQUENCE_OF<NonStandardParameter>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class nonStandard
    nonStandard::const_reference get_nonStandard () const;
    nonStandard::reference ref_nonStandard ();
    nonStandard::reference set_nonStandard ();
    nonStandard::reference set_nonStandard (nonStandard::const_reference value);
    void omit_nonStandard ();
    bool nonStandard_isPresent () const;
    class sessionID {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 255>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class sessionID
    sessionID::const_reference get_sessionID () const;
    sessionID::reference ref_sessionID ();
    sessionID::reference set_sessionID ();
    sessionID::reference set_sessionID (sessionID::value_type::int_type value);
    class associatedSessionID {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 1, 255>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class associatedSessionID
    associatedSessionID::const_reference get_associatedSessionID () const;
    associatedSessionID::reference ref_associatedSessionID ();
    associatedSessionID::reference set_associatedSessionID ();
    associatedSessionID::reference set_associatedSessionID (associatedSessionID::value_type::int_type value);
    void omit_associatedSessionID ();
    bool associatedSessionID_isPresent () const;
    class mediaChannel {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mediaChannel
    mediaChannel::const_reference get_mediaChannel () const;
    mediaChannel::reference ref_mediaChannel ();
    mediaChannel::reference set_mediaChannel ();
    mediaChannel::reference set_mediaChannel (mediaChannel::const_reference value);
    void omit_mediaChannel ();
    bool mediaChannel_isPresent () const;
    class mediaGuaranteedDelivery {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mediaGuaranteedDelivery
    mediaGuaranteedDelivery::const_reference get_mediaGuaranteedDelivery () const;
    mediaGuaranteedDelivery::reference ref_mediaGuaranteedDelivery ();
    mediaGuaranteedDelivery::reference set_mediaGuaranteedDelivery ();
    mediaGuaranteedDelivery::reference set_mediaGuaranteedDelivery (bool value);
    void omit_mediaGuaranteedDelivery ();
    bool mediaGuaranteedDelivery_isPresent () const;
    class mediaControlChannel {
      public:
        typedef TransportAddress value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mediaControlChannel
    mediaControlChannel::const_reference get_mediaControlChannel () const;
    mediaControlChannel::reference ref_mediaControlChannel ();
    mediaControlChannel::reference set_mediaControlChannel ();
    mediaControlChannel::reference set_mediaControlChannel (mediaControlChannel::const_reference value);
    void omit_mediaControlChannel ();
    bool mediaControlChannel_isPresent () const;
    class mediaControlGuaranteedDelivery {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mediaControlGuaranteedDelivery
    mediaControlGuaranteedDelivery::const_reference get_mediaControlGuaranteedDelivery () const;
    mediaControlGuaranteedDelivery::reference ref_mediaControlGuaranteedDelivery ();
    mediaControlGuaranteedDelivery::reference set_mediaControlGuaranteedDelivery ();
    mediaControlGuaranteedDelivery::reference set_mediaControlGuaranteedDelivery (bool value);
    void omit_mediaControlGuaranteedDelivery ();
    bool mediaControlGuaranteedDelivery_isPresent () const;
    class silenceSuppression {
      public:
        typedef ASN1::BOOLEAN value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class silenceSuppression
    silenceSuppression::const_reference get_silenceSuppression () const;
    silenceSuppression::reference ref_silenceSuppression ();
    silenceSuppression::reference set_silenceSuppression ();
    silenceSuppression::reference set_silenceSuppression (bool value);
    void omit_silenceSuppression ();
    bool silenceSuppression_isPresent () const;
    class destination {
      public:
        typedef TerminalLabel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class destination
    destination::const_reference get_destination () const;
    destination::reference ref_destination ();
    destination::reference set_destination ();
    destination::reference set_destination (destination::const_reference value);
    void omit_destination ();
    bool destination_isPresent () const;
    class dynamicRTPPayloadType {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 96, 127>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class dynamicRTPPayloadType
    dynamicRTPPayloadType::const_reference get_dynamicRTPPayloadType () const;
    dynamicRTPPayloadType::reference ref_dynamicRTPPayloadType ();
    dynamicRTPPayloadType::reference set_dynamicRTPPayloadType ();
    dynamicRTPPayloadType::reference set_dynamicRTPPayloadType (dynamicRTPPayloadType::value_type::int_type value);
    void omit_dynamicRTPPayloadType ();
    bool dynamicRTPPayloadType_isPresent () const;
    class mediaPacketization {
      public:
        typedef H2250LogicalChannelParameters_mediaPacketization value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class mediaPacketization
    mediaPacketization::const_reference get_mediaPacketization () const;
    mediaPacketization::reference ref_mediaPacketization ();
    mediaPacketization::reference set_mediaPacketization ();
    mediaPacketization::reference set_mediaPacketization (mediaPacketization::const_reference value);
    void omit_mediaPacketization ();
    bool mediaPacketization_isPresent () const;
    class transportCapability {
      public:
        typedef TransportCapability value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class transportCapability
    transportCapability::const_reference get_transportCapability () const;
    transportCapability::reference ref_transportCapability ();
    transportCapability::reference set_transportCapability ();
    transportCapability::reference set_transportCapability (transportCapability::const_reference value);
    void omit_transportCapability ();
    bool transportCapability_isPresent () const;
    class redundancyEncoding {
      public:
        typedef RedundancyEncoding value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class redundancyEncoding
    redundancyEncoding::const_reference get_redundancyEncoding () const;
    redundancyEncoding::reference ref_redundancyEncoding ();
    redundancyEncoding::reference set_redundancyEncoding ();
    redundancyEncoding::reference set_redundancyEncoding (redundancyEncoding::const_reference value);
    void omit_redundancyEncoding ();
    bool redundancyEncoding_isPresent () const;
    class source {
      public:
        typedef TerminalLabel value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class source
    source::const_reference get_source () const;
    source::reference ref_source ();
    source::reference set_source ();
    source::reference set_source (source::const_reference value);
    void omit_source ();
    bool source_isPresent () const;
    void swap(H2250LogicalChannelParameters& other);
    H2250LogicalChannelParameters * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[14];
    static int fieldIds[14];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[14];
#endif
};

//
// OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters
//

class OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters(const void* info) : Inherited(info) {}
  public:
    OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters() : Inherited(&theInfo) {}
    class h222LogicalChannelParameters {
      public:
        enum Id { id_ = 0 };
        typedef H222LogicalChannelParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h222LogicalChannelParameters

    h222LogicalChannelParameters::const_reference get_h222LogicalChannelParameters () const;
    h222LogicalChannelParameters::reference ref_h222LogicalChannelParameters (); 
    h222LogicalChannelParameters::reference select_h222LogicalChannelParameters (); 
    h222LogicalChannelParameters::reference select_h222LogicalChannelParameters (h222LogicalChannelParameters::const_reference value); 
    bool h222LogicalChannelParameters_isSelected() const;

    class h223LogicalChannelParameters {
      public:
        enum Id { id_ = 1 };
        typedef H223LogicalChannelParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h223LogicalChannelParameters

    h223LogicalChannelParameters::const_reference get_h223LogicalChannelParameters () const;
    h223LogicalChannelParameters::reference ref_h223LogicalChannelParameters (); 
    h223LogicalChannelParameters::reference select_h223LogicalChannelParameters (); 
    h223LogicalChannelParameters::reference select_h223LogicalChannelParameters (h223LogicalChannelParameters::const_reference value); 
    bool h223LogicalChannelParameters_isSelected() const;

    class v76LogicalChannelParameters {
      public:
        enum Id { id_ = 2 };
        typedef V76LogicalChannelParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class v76LogicalChannelParameters

    v76LogicalChannelParameters::const_reference get_v76LogicalChannelParameters () const;
    v76LogicalChannelParameters::reference ref_v76LogicalChannelParameters (); 
    v76LogicalChannelParameters::reference select_v76LogicalChannelParameters (); 
    v76LogicalChannelParameters::reference select_v76LogicalChannelParameters (v76LogicalChannelParameters::const_reference value); 
    bool v76LogicalChannelParameters_isSelected() const;

    class h2250LogicalChannelParameters {
      public:
        enum Id { id_ = 3 };
        typedef H2250LogicalChannelParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h2250LogicalChannelParameters

    h2250LogicalChannelParameters::const_reference get_h2250LogicalChannelParameters () const;
    h2250LogicalChannelParameters::reference ref_h2250LogicalChannelParameters (); 
    h2250LogicalChannelParameters::reference select_h2250LogicalChannelParameters (); 
    h2250LogicalChannelParameters::reference select_h2250LogicalChannelParameters (h2250LogicalChannelParameters::const_reference value); 
    bool h2250LogicalChannelParameters_isSelected() const;

    class none {
      public:
        enum Id { id_ = 4 };
        typedef ASN1::Null value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class none

    none::reference select_none (); 
    bool none_isSelected() const;

    OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters(h222LogicalChannelParameters::Id id, h222LogicalChannelParameters::const_reference value);
    OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters(h223LogicalChannelParameters::Id id, h223LogicalChannelParameters::const_reference value);
    OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters(v76LogicalChannelParameters::Id id, v76LogicalChannelParameters::const_reference value);
    OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters(h2250LogicalChannelParameters::Id id, h2250LogicalChannelParameters::const_reference value);
    OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters(none::Id id, none::const_reference value);
    void swap(OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters & other);
    OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters(const OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters & other)
    : Inherited(other) {} 

    OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters & operator = (const OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[5];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[5];
#endif
};

//
// OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters
//

class OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters(const void* info) : Inherited(info) {}
  public:
    OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters() : Inherited(&theInfo) {}
    class h223LogicalChannelParameters {
      public:
        enum Id { id_ = 0 };
        typedef H223LogicalChannelParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h223LogicalChannelParameters

    h223LogicalChannelParameters::const_reference get_h223LogicalChannelParameters () const;
    h223LogicalChannelParameters::reference ref_h223LogicalChannelParameters (); 
    h223LogicalChannelParameters::reference select_h223LogicalChannelParameters (); 
    h223LogicalChannelParameters::reference select_h223LogicalChannelParameters (h223LogicalChannelParameters::const_reference value); 
    bool h223LogicalChannelParameters_isSelected() const;

    class v76LogicalChannelParameters {
      public:
        enum Id { id_ = 1 };
        typedef V76LogicalChannelParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class v76LogicalChannelParameters

    v76LogicalChannelParameters::const_reference get_v76LogicalChannelParameters () const;
    v76LogicalChannelParameters::reference ref_v76LogicalChannelParameters (); 
    v76LogicalChannelParameters::reference select_v76LogicalChannelParameters (); 
    v76LogicalChannelParameters::reference select_v76LogicalChannelParameters (v76LogicalChannelParameters::const_reference value); 
    bool v76LogicalChannelParameters_isSelected() const;

    class h2250LogicalChannelParameters {
      public:
        enum Id { id_ = 2 };
        typedef H2250LogicalChannelParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h2250LogicalChannelParameters

    h2250LogicalChannelParameters::const_reference get_h2250LogicalChannelParameters () const;
    h2250LogicalChannelParameters::reference ref_h2250LogicalChannelParameters (); 
    h2250LogicalChannelParameters::reference select_h2250LogicalChannelParameters (); 
    h2250LogicalChannelParameters::reference select_h2250LogicalChannelParameters (h2250LogicalChannelParameters::const_reference value); 
    bool h2250LogicalChannelParameters_isSelected() const;

    OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters(h223LogicalChannelParameters::Id id, h223LogicalChannelParameters::const_reference value);
    OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters(v76LogicalChannelParameters::Id id, v76LogicalChannelParameters::const_reference value);
    OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters(h2250LogicalChannelParameters::Id id, h2250LogicalChannelParameters::const_reference value);
    void swap(OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters & other);
    OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters(const OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters & other)
    : Inherited(other) {} 

    OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters & operator = (const OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[3];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[3];
#endif
};

//
// OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters
//

class OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters : public ASN1::CHOICE
{
    typedef ASN1::CHOICE Inherited;
  protected:
    OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters(const void* info) : Inherited(info) {}
  public:
    OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters() : Inherited(&theInfo) {}
    class h222LogicalChannelParameters {
      public:
        enum Id { id_ = 0 };
        typedef H222LogicalChannelParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h222LogicalChannelParameters

    h222LogicalChannelParameters::const_reference get_h222LogicalChannelParameters () const;
    h222LogicalChannelParameters::reference ref_h222LogicalChannelParameters (); 
    h222LogicalChannelParameters::reference select_h222LogicalChannelParameters (); 
    h222LogicalChannelParameters::reference select_h222LogicalChannelParameters (h222LogicalChannelParameters::const_reference value); 
    bool h222LogicalChannelParameters_isSelected() const;

    class h2250LogicalChannelParameters {
      public:
        enum Id { id_ = 1 };
        typedef H2250LogicalChannelParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class h2250LogicalChannelParameters

    h2250LogicalChannelParameters::const_reference get_h2250LogicalChannelParameters () const;
    h2250LogicalChannelParameters::reference ref_h2250LogicalChannelParameters (); 
    h2250LogicalChannelParameters::reference select_h2250LogicalChannelParameters (); 
    h2250LogicalChannelParameters::reference select_h2250LogicalChannelParameters (h2250LogicalChannelParameters::const_reference value); 
    bool h2250LogicalChannelParameters_isSelected() const;

    OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters(h222LogicalChannelParameters::Id id, h222LogicalChannelParameters::const_reference value);
    OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters(h2250LogicalChannelParameters::Id id, h2250LogicalChannelParameters::const_reference value);
    void swap(OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters & other);
    OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters(const OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters & other)
    : Inherited(other) {} 

    OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters & operator = (const OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters & other)
    {
      Inherited::operator=(other);
      return *this;
    }

    OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters * clone() const;
    static bool equal_type(const ASN1::AbstractData&);
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* selectionInfos[2];
#ifdef ASN1_HAS_IOSTREAM
    static const char* selectionNames[2];
#endif
};

//
// OpenLogicalChannel_forwardLogicalChannelParameters
//

class OpenLogicalChannel_forwardLogicalChannelParameters : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    OpenLogicalChannel_forwardLogicalChannelParameters(const void* info) : Inherited(info) {}
  public:
    OpenLogicalChannel_forwardLogicalChannelParameters() : Inherited(&theInfo) {}
    OpenLogicalChannel_forwardLogicalChannelParameters(const OpenLogicalChannel_forwardLogicalChannelParameters & other) : Inherited(other)
    {}
    OpenLogicalChannel_forwardLogicalChannelParameters& operator = (const OpenLogicalChannel_forwardLogicalChannelParameters& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_portNumber,
      e_forwardLogicalChannelDependency,
      e_replacementFor
    };

    class portNumber {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class portNumber
    portNumber::const_reference get_portNumber () const;
    portNumber::reference ref_portNumber ();
    portNumber::reference set_portNumber ();
    portNumber::reference set_portNumber (portNumber::value_type::int_type value);
    void omit_portNumber ();
    bool portNumber_isPresent () const;
    class dataType {
      public:
        typedef DataType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class dataType
    dataType::const_reference get_dataType () const;
    dataType::reference ref_dataType ();
    dataType::reference set_dataType ();
    dataType::reference set_dataType (dataType::const_reference value);
    class multiplexParameters {
      public:
        typedef OpenLogicalChannel_forwardLogicalChannelParameters_multiplexParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multiplexParameters
    multiplexParameters::const_reference get_multiplexParameters () const;
    multiplexParameters::reference ref_multiplexParameters ();
    multiplexParameters::reference set_multiplexParameters ();
    multiplexParameters::reference set_multiplexParameters (multiplexParameters::const_reference value);
    class forwardLogicalChannelDependency {
      public:
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class forwardLogicalChannelDependency
    forwardLogicalChannelDependency::const_reference get_forwardLogicalChannelDependency () const;
    forwardLogicalChannelDependency::reference ref_forwardLogicalChannelDependency ();
    forwardLogicalChannelDependency::reference set_forwardLogicalChannelDependency ();
    forwardLogicalChannelDependency::reference set_forwardLogicalChannelDependency (forwardLogicalChannelDependency::value_type::int_type value);
    void omit_forwardLogicalChannelDependency ();
    bool forwardLogicalChannelDependency_isPresent () const;
    class replacementFor {
      public:
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class replacementFor
    replacementFor::const_reference get_replacementFor () const;
    replacementFor::reference ref_replacementFor ();
    replacementFor::reference set_replacementFor ();
    replacementFor::reference set_replacementFor (replacementFor::value_type::int_type value);
    void omit_replacementFor ();
    bool replacementFor_isPresent () const;
    void swap(OpenLogicalChannel_forwardLogicalChannelParameters& other);
    OpenLogicalChannel_forwardLogicalChannelParameters * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[5];
    static int fieldIds[5];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[5];
#endif
};

//
// OpenLogicalChannel_reverseLogicalChannelParameters
//

class OpenLogicalChannel_reverseLogicalChannelParameters : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    OpenLogicalChannel_reverseLogicalChannelParameters(const void* info) : Inherited(info) {}
  public:
    OpenLogicalChannel_reverseLogicalChannelParameters() : Inherited(&theInfo) {}
    OpenLogicalChannel_reverseLogicalChannelParameters(const OpenLogicalChannel_reverseLogicalChannelParameters & other) : Inherited(other)
    {}
    OpenLogicalChannel_reverseLogicalChannelParameters& operator = (const OpenLogicalChannel_reverseLogicalChannelParameters& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_multiplexParameters,
      e_reverseLogicalChannelDependency,
      e_replacementFor
    };

    class dataType {
      public:
        typedef DataType value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class dataType
    dataType::const_reference get_dataType () const;
    dataType::reference ref_dataType ();
    dataType::reference set_dataType ();
    dataType::reference set_dataType (dataType::const_reference value);
    class multiplexParameters {
      public:
        typedef OpenLogicalChannel_reverseLogicalChannelParameters_multiplexParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multiplexParameters
    multiplexParameters::const_reference get_multiplexParameters () const;
    multiplexParameters::reference ref_multiplexParameters ();
    multiplexParameters::reference set_multiplexParameters ();
    multiplexParameters::reference set_multiplexParameters (multiplexParameters::const_reference value);
    void omit_multiplexParameters ();
    bool multiplexParameters_isPresent () const;
    class reverseLogicalChannelDependency {
      public:
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class reverseLogicalChannelDependency
    reverseLogicalChannelDependency::const_reference get_reverseLogicalChannelDependency () const;
    reverseLogicalChannelDependency::reference ref_reverseLogicalChannelDependency ();
    reverseLogicalChannelDependency::reference set_reverseLogicalChannelDependency ();
    reverseLogicalChannelDependency::reference set_reverseLogicalChannelDependency (reverseLogicalChannelDependency::value_type::int_type value);
    void omit_reverseLogicalChannelDependency ();
    bool reverseLogicalChannelDependency_isPresent () const;
    class replacementFor {
      public:
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class replacementFor
    replacementFor::const_reference get_replacementFor () const;
    replacementFor::reference ref_replacementFor ();
    replacementFor::reference set_replacementFor ();
    replacementFor::reference set_replacementFor (replacementFor::value_type::int_type value);
    void omit_replacementFor ();
    bool replacementFor_isPresent () const;
    void swap(OpenLogicalChannel_reverseLogicalChannelParameters& other);
    OpenLogicalChannel_reverseLogicalChannelParameters * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// OpenLogicalChannelAck_reverseLogicalChannelParameters
//

class OpenLogicalChannelAck_reverseLogicalChannelParameters : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    OpenLogicalChannelAck_reverseLogicalChannelParameters(const void* info) : Inherited(info) {}
  public:
    OpenLogicalChannelAck_reverseLogicalChannelParameters() : Inherited(&theInfo) {}
    OpenLogicalChannelAck_reverseLogicalChannelParameters(const OpenLogicalChannelAck_reverseLogicalChannelParameters & other) : Inherited(other)
    {}
    OpenLogicalChannelAck_reverseLogicalChannelParameters& operator = (const OpenLogicalChannelAck_reverseLogicalChannelParameters& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_portNumber,
      e_multiplexParameters,
      e_replacementFor
    };

    class reverseLogicalChannelNumber {
      public:
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class reverseLogicalChannelNumber
    reverseLogicalChannelNumber::const_reference get_reverseLogicalChannelNumber () const;
    reverseLogicalChannelNumber::reference ref_reverseLogicalChannelNumber ();
    reverseLogicalChannelNumber::reference set_reverseLogicalChannelNumber ();
    reverseLogicalChannelNumber::reference set_reverseLogicalChannelNumber (reverseLogicalChannelNumber::value_type::int_type value);
    class portNumber {
      public:
        typedef ASN1::Constrained_INTEGER<ASN1::FixedConstraint, 0, 65535>  value_type;

        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class portNumber
    portNumber::const_reference get_portNumber () const;
    portNumber::reference ref_portNumber ();
    portNumber::reference set_portNumber ();
    portNumber::reference set_portNumber (portNumber::value_type::int_type value);
    void omit_portNumber ();
    bool portNumber_isPresent () const;
    class multiplexParameters {
      public:
        typedef OpenLogicalChannelAck_reverseLogicalChannelParameters_multiplexParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class multiplexParameters
    multiplexParameters::const_reference get_multiplexParameters () const;
    multiplexParameters::reference ref_multiplexParameters ();
    multiplexParameters::reference set_multiplexParameters ();
    multiplexParameters::reference set_multiplexParameters (multiplexParameters::const_reference value);
    void omit_multiplexParameters ();
    bool multiplexParameters_isPresent () const;
    class replacementFor {
      public:
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class replacementFor
    replacementFor::const_reference get_replacementFor () const;
    replacementFor::reference ref_replacementFor ();
    replacementFor::reference set_replacementFor ();
    replacementFor::reference set_replacementFor (replacementFor::value_type::int_type value);
    void omit_replacementFor ();
    bool replacementFor_isPresent () const;
    void swap(OpenLogicalChannelAck_reverseLogicalChannelParameters& other);
    OpenLogicalChannelAck_reverseLogicalChannelParameters * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[4];
    static int fieldIds[4];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[4];
#endif
};

//
// OpenLogicalChannel
//

class OpenLogicalChannel : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    OpenLogicalChannel(const void* info) : Inherited(info) {}
  public:
    OpenLogicalChannel() : Inherited(&theInfo) {}
    OpenLogicalChannel(const OpenLogicalChannel & other) : Inherited(other)
    {}
    OpenLogicalChannel& operator = (const OpenLogicalChannel& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_reverseLogicalChannelParameters,
      e_separateStack,
      e_encryptionSync
    };

    class forwardLogicalChannelNumber {
      public:
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class forwardLogicalChannelNumber
    forwardLogicalChannelNumber::const_reference get_forwardLogicalChannelNumber () const;
    forwardLogicalChannelNumber::reference ref_forwardLogicalChannelNumber ();
    forwardLogicalChannelNumber::reference set_forwardLogicalChannelNumber ();
    forwardLogicalChannelNumber::reference set_forwardLogicalChannelNumber (forwardLogicalChannelNumber::value_type::int_type value);
    class forwardLogicalChannelParameters {
      public:
        typedef OpenLogicalChannel_forwardLogicalChannelParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class forwardLogicalChannelParameters
    forwardLogicalChannelParameters::const_reference get_forwardLogicalChannelParameters () const;
    forwardLogicalChannelParameters::reference ref_forwardLogicalChannelParameters ();
    forwardLogicalChannelParameters::reference set_forwardLogicalChannelParameters ();
    forwardLogicalChannelParameters::reference set_forwardLogicalChannelParameters (forwardLogicalChannelParameters::const_reference value);
    class reverseLogicalChannelParameters {
      public:
        typedef OpenLogicalChannel_reverseLogicalChannelParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class reverseLogicalChannelParameters
    reverseLogicalChannelParameters::const_reference get_reverseLogicalChannelParameters () const;
    reverseLogicalChannelParameters::reference ref_reverseLogicalChannelParameters ();
    reverseLogicalChannelParameters::reference set_reverseLogicalChannelParameters ();
    reverseLogicalChannelParameters::reference set_reverseLogicalChannelParameters (reverseLogicalChannelParameters::const_reference value);
    void omit_reverseLogicalChannelParameters ();
    bool reverseLogicalChannelParameters_isPresent () const;
    class separateStack {
      public:
        typedef NetworkAccessParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class separateStack
    separateStack::const_reference get_separateStack () const;
    separateStack::reference ref_separateStack ();
    separateStack::reference set_separateStack ();
    separateStack::reference set_separateStack (separateStack::const_reference value);
    void omit_separateStack ();
    bool separateStack_isPresent () const;
    class encryptionSync {
      public:
        typedef EncryptionSync value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class encryptionSync
    encryptionSync::const_reference get_encryptionSync () const;
    encryptionSync::reference ref_encryptionSync ();
    encryptionSync::reference set_encryptionSync ();
    encryptionSync::reference set_encryptionSync (encryptionSync::const_reference value);
    void omit_encryptionSync ();
    bool encryptionSync_isPresent () const;
    void swap(OpenLogicalChannel& other);
    OpenLogicalChannel * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[5];
    static int fieldIds[5];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[5];
#endif
};

//
// OpenLogicalChannelAck
//

class OpenLogicalChannelAck : public ASN1::SEQUENCE
{
    typedef ASN1::SEQUENCE Inherited;
  protected:
    OpenLogicalChannelAck(const void* info) : Inherited(info) {}
  public:
    OpenLogicalChannelAck() : Inherited(&theInfo) {}
    OpenLogicalChannelAck(const OpenLogicalChannelAck & other) : Inherited(other)
    {}
    OpenLogicalChannelAck& operator = (const OpenLogicalChannelAck& other)
    { Inherited::operator = (other); return *this; } 
    enum OptionalFields {
      e_reverseLogicalChannelParameters,
      e_separateStack,
      e_forwardMultiplexAckParameters,
      e_encryptionSync
    };

    class forwardLogicalChannelNumber {
      public:
        typedef LogicalChannelNumber value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class forwardLogicalChannelNumber
    forwardLogicalChannelNumber::const_reference get_forwardLogicalChannelNumber () const;
    forwardLogicalChannelNumber::reference ref_forwardLogicalChannelNumber ();
    forwardLogicalChannelNumber::reference set_forwardLogicalChannelNumber ();
    forwardLogicalChannelNumber::reference set_forwardLogicalChannelNumber (forwardLogicalChannelNumber::value_type::int_type value);
    class reverseLogicalChannelParameters {
      public:
        typedef OpenLogicalChannelAck_reverseLogicalChannelParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class reverseLogicalChannelParameters
    reverseLogicalChannelParameters::const_reference get_reverseLogicalChannelParameters () const;
    reverseLogicalChannelParameters::reference ref_reverseLogicalChannelParameters ();
    reverseLogicalChannelParameters::reference set_reverseLogicalChannelParameters ();
    reverseLogicalChannelParameters::reference set_reverseLogicalChannelParameters (reverseLogicalChannelParameters::const_reference value);
    void omit_reverseLogicalChannelParameters ();
    bool reverseLogicalChannelParameters_isPresent () const;
    class separateStack {
      public:
        typedef NetworkAccessParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class separateStack
    separateStack::const_reference get_separateStack () const;
    separateStack::reference ref_separateStack ();
    separateStack::reference set_separateStack ();
    separateStack::reference set_separateStack (separateStack::const_reference value);
    void omit_separateStack ();
    bool separateStack_isPresent () const;
    class forwardMultiplexAckParameters {
      public:
        typedef OpenLogicalChannelAck_forwardMultiplexAckParameters value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class forwardMultiplexAckParameters
    forwardMultiplexAckParameters::const_reference get_forwardMultiplexAckParameters () const;
    forwardMultiplexAckParameters::reference ref_forwardMultiplexAckParameters ();
    forwardMultiplexAckParameters::reference set_forwardMultiplexAckParameters ();
    forwardMultiplexAckParameters::reference set_forwardMultiplexAckParameters (forwardMultiplexAckParameters::const_reference value);
    void omit_forwardMultiplexAckParameters ();
    bool forwardMultiplexAckParameters_isPresent () const;
    class encryptionSync {
      public:
        typedef EncryptionSync value_type;
        typedef value_type&			reference;
        typedef const value_type&	const_reference;
        typedef value_type*			pointer;
        typedef const value_type*	const_pointer;
    }; // end class encryptionSync
    encryptionSync::const_reference get_encryptionSync () const;
    encryptionSync::reference ref_encryptionSync ();
    encryptionSync::reference set_encryptionSync ();
    encryptionSync::reference set_encryptionSync (encryptionSync::const_reference value);
    void omit_encryptionSync ();
    bool encryptionSync_isPresent () const;
    void swap(OpenLogicalChannelAck& other);
    OpenLogicalChannelAck * clone() const;
    static void extract(const ASN1::AbstractData& data);
    static const InfoType theInfo;
  private:
    static const void* fieldInfos[5];
    static int fieldIds[5];
#ifdef ASN1_HAS_IOSTREAM
    static const char* fieldNames[5];
#endif
};

#include "msc_openlogicalchannel.inl"
} // namespace MULTIMEDIA_SYSTEM_CONTROL

#endif // __MSC_OPENLOGICALCHANNEL_H


// End of msc_openlogicalchannel.h
