/*
*   This file is a part of Qosmos ixEngine.
*   Copyright  Qosmos 2018-2018 - All rights reserved
*/

#ifndef __COMMON_H__
#define __COMMON_H__

#define ARRAY_SIZE(a) (sizeof(a)/sizeof(a[0]))

#define PRINT_ERR(...) \
    fprintf(stderr, __VA_ARGS__);

#define DBG_PRINTF_0(...) \
    fprintf(stdout, __VA_ARGS__);

#define DBG_PRINTF_1(...) do { \
        if (debug_level >= 1) {\
            fprintf(stdout, __VA_ARGS__);\
        }\
    } while (0)

#define DBG_PRINTF_2(...) do { \
        if (debug_level >= 2) {\
            fprintf(stdout, __VA_ARGS__);\
        }\
    } while (0)


#define FILENAME_SIZE  128
#define MIME_TYPE_SIZE 64
#define ENCODING_SIZE  64
#define EXTENSION_SIZE 16

/* file context */
struct file_context {
    FILE           *file;
    struct timeval  ts;
    /* size of the file */
    uint64_t        file_size;
    /* size currently received */
    uint64_t        current_size;
    uint64_t        content_offset;
    uint32_t        chunks;
    int             eot;
    /* id of the filetype */
    uint32_t        file_id;
    uint8_t         offset_present;

    char            fs_name[FILENAME_SIZE]; /* name on file system */
    char            name[FILENAME_SIZE];
    char            mime_type[MIME_TYPE_SIZE];
    char            encoding[ENCODING_SIZE];
    /* extension of the file */
    char            extension[EXTENSION_SIZE];
    /* decoded file */
    uint64_t
    decoded_file_size;          /*!< decoded file size (sum of all decoded chunk length) */
    uint32_t
    decoded_chunks;             /*!< counter for the number of decoded chunks */
    FILE
    *decoded_file;               /*!< file descriptor for the decoded file */
    uint64_t
    current_size_decoded;       /*!< current size of all decoded chunks */
    char
    fs_name_dec[FILENAME_SIZE]; /*!< name of decoded file on file system */
};

void fr_table_init(void);
void fr_table_destroy(void);


int fr_table_get_entry(uint32_t file_id, struct file_context **fc);
int fr_table_add_entry(uint32_t file_id, struct file_context *fc);
int fr_table_remove_entry(uint32_t file_id);
#endif /* __COMMON_H__ */
