#error "This header should not be used. It is provided for documentation only."
/*
  This file is a part of Qosmos ixEngine.

  Copyright  Qosmos 2000-2020 - All rights reserved

  This computer program and all its components are protected by
  authors' rights and copyright law and by international treaties.
  Any representation, reproduction, distribution or modification
  of this program or any portion of it is forbidden without
  Qosmos explicit and written agreement and may result in severe
  civil and criminal penalties, and will be prosecuted
  to the maximum extent possible under the law.
*/
/**
 * @file cpuid_current.h
 * This header contains the prototypes of functions
 * that users can override,
 * it is not meant to be included.
 * @attention
 * Overriding "cpuid_current" is only required on the operating systems NOT supporting Thread Local Storage (TLS).
 * The user provided overriding function must return a unique cpu_id between 0 and nb_workers.
 */

/**
 * Prototype for cpuid_current.
 *   Overriding "cpuid_current" is only required on the operating systems NOT supporting Thread Local Storage (TLS).
 *   The user provided overriding function must return a unique cpu_id between 0 and nb_workers.
 *
 * @return unsigned long between 0 and nb_workers.
 */
unsigned long cpuid_current(void);
