/*
*   This file is a part of Qosmos ixEngine.
*   Copyright  Qosmos 2000-2016 - All rights reserved
*/
#ifndef __HOOKS__
#define __HOOKS__


/**
 * Structure that define a protocol's attribute hook
 */
struct hook {
    /**
     * Protocol layer name
     */
    char *layer;
    /**
     * Protocol's attribute name
     */
    char *attr;
    /**
     * User defined attribute id
     */
    int attr_id;
};

#define HOOK_SET_LAYER(h, l) ((h)->layer = l)
#define HOOK_SET_ATTR(h, a) ((h)->attr = a)
#define HOOK_SET(h, l, a) do {                                          \
        HOOK_SET_LAYER(h, l);                                               \
        HOOK_SET_ATTR(h, a);                                                \
    } while(0);
#define HOOK_LAYER(h) ((h)->layer)
#define HOOK_ATTR(h) ((h)->attr)


#define MAX_HOOKS   512

/**
 * Structure to keeps a list of protocols' attribute hooks
 */
struct hook_store {
    /**
     * List of hooks
     */
    struct hook hook[MAX_HOOKS];
    /**
     * Number of hook in the list
     */
    size_t nb;
};

#define HOOK_STORE_INIT(hs) ((hs)->nb = 0)
#define HOOK_STORE_ADD(hs, l, a) do {                                       \
        if((hs)->nb == MAX_HOOKS) {                                         \
            fprintf(stderr,                                             \
                    "Max hook reached; cannot hook %s:%s", l, a);       \
        } else {                                                            \
            HOOK_SET(&((hs)->hook[(hs)->nb]), l, a);                        \
            ++(hs)->nb;                                                     \
        }                                                                   \
    } while(0);
#define HOOK_STORE_GET(hs, i) (&(hs)->hook[i])

int pa_metadata_add(struct hook_store *hs);

void pa_metadata_del(struct hook_store const *hs);

#endif
