/*
*   This file is a part of Qosmos ixEngine.
*   Copyright  Qosmos 2010-2017 - All rights reserved
*/
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "config.h"
#include "exclusion.h"

#define CONFIG_LINE_LEN 256

enum config_section {
    SECTION_UNDEF,
    SECTION_ATTR,
    SECTION_EXCL
};

void
config_parse(struct opt *opt)
{
    int          section = SECTION_UNDEF;
    unsigned int line_count = 0;
    unsigned int line_len = 0;
    char         line[CONFIG_LINE_LEN] = "";
    FILE        *config_file = NULL;

    config_file = fopen(OPT_CONFIG_FILENAME(opt), "r");
    if (config_file == NULL) {
        fprintf(stderr, "\r[ERR] %s: can't open file\n", OPT_CONFIG_FILENAME(opt));
        exit(-1);
    }

    /* pre-processing */
    excls_setup();

    while (fgets(line, CONFIG_LINE_LEN, config_file)) {
        line_len = strlen(line);
        line_count++;

        if (!line_len || !strncmp(line, "\n", 1) || !strncmp(line, "#", 1)) {
            continue;
        }

        if (line[line_len - 1] == '\x0a') {
            line[line_len - 1] = '\0';
        }

        if (line[0] == '[') {
            if (!strncmp(line + 1, "attributes", 10)) {
                section = SECTION_ATTR;
            } else if (!strncmp(line + 1, "exclude", 7)) {
                section = SECTION_EXCL;
            } else {
                section = SECTION_UNDEF;
            }
            continue;
        }

        switch (section) {
            case SECTION_ATTR:
                hooks_setup_line(line, line_count, &OPT_HOOK_STORE(opt));
                break;
            case SECTION_EXCL:
                excls_setup_line(line, line_count);
                break;
            default:
                break;
        }
    }

    fclose(config_file);
}
