/*
*   This file is a part of Qosmos ixEngine.
*   Copyright  Qosmos 2000-2015 - All rights reserved
*/
#ifndef __DNS_LOOKUP__
#define __DNS_LOOKUP__

#define DNS_HT_SIZE 4096

/**
 * DNS Caching HT resolved name entry.
 * The key is the destination IPv4 address of the flow.
 */
struct dns_ht_entry {
    char    *hostname;    /* the queried host */
    uint32_t dest_addr;   /* the solved IP address */
    struct dns_ht_entry *next;
};

/**
 * DNS HT.
 */
struct dns_ht {
    struct dns_ht_entry *ht[DNS_HT_SIZE];
    int ht_size;
};

/**
 * DNS Caching hashtable <ht> initialization and destruction
 */
void dns_ht_init(struct dns_ht *ht);
void dns_ht_clean(struct dns_ht *ht);

/**
 * Fetch in a <ht> DNS Caching hashtable
 * an IPv4 <address> corresponding to DNS resolved name entry.
 *
 * Returns: the DNS Caching hashtable entry,
 *          NULL if there's no match.
 */
struct dns_ht_entry *dns_ht_entry_fetch(struct dns_ht *ht, uint32_t address);

/**
 * Insert in a <ht> DNS Caching hashtable a DNS Caching resolved name entry,
 * providing the IPv4 <address>, and resolved <name> found in
 * a DNS Response packet.
 *
 * Returns: the DNS Caching hashtable entry,
 *          NULL if the entry creation failed.
 */
struct dns_ht_entry *dns_ht_entry_insert(struct dns_ht *ht, uint32_t address,
                                         char *name, unsigned int name_len);

#endif
