/*
  This file is a part of Qosmos ixEngine.

  Copyright  Qosmos 2000-2017 - All rights reserved

  This computer program and all its components are protected by
  authors' rights and copyright law and by international treaties.
  Any representation, reproduction, distribution or modification
  of this program or any portion of it is forbidden without
  Qosmos explicit and written agreement and may result in severe
  civil and criminal penalties, and will be prosecuted
  to the maximum extent possible under the law.
*/

#ifndef _FASTHASH_H
#define _FASTHASH_H

#include <stdint.h>

static inline uint32_t
pcap_logger_get_unaligned_32(const void *data)
{
    uint32_t r;
    const unsigned char *p = (const unsigned char *)data;

    r = ((uint32_t)(*(p + 0)) << 24) |
        ((uint32_t)(*(p + 1)) << 16) |
        ((uint32_t)(*(p + 2)) << 8)  |
        ((uint32_t)(*(p + 3)));

    return r;
}

static inline uint32_t
pcap_logger_fasthash_32(const void *data)
{
    const uint64_t m = 7319936632422683419ULL;
    uint64_t v = pcap_logger_get_unaligned_32(data);

    v ^= v >> 32;
    v *= m;
    v ^= v >> 32;
    v *= m;
    v >>= 32;

    return (uint32_t)v;
}

#endif
