// Copyright 2020 Nubeva, Inc. All rights reserved. 
#ifndef NUDEC_KEY_LOG_READER_H
#define NUDEC_KEY_LOG_READER_H

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/param.h>

#if (defined(BSD)) 
typedef u_char __u8;
typedef u_short __u16;
typedef u_int __u32;  
typedef unsigned long long __u64;
typedef char __s8;
typedef short __s16;
typedef int __s32;
#else
#include <linux/uuid.h>
#endif

#include "uthash.h" // remove dependency of glib GHashTable

typedef struct StringInfo_s {
    __u8 *data;      /* Backing storage which may be larger than data_len */
    __u32 data_len;   /* Length of the meaningful part of data */

    __u8 *keyd;         // uthash
    __u32 keyd_len;     // uthash
    UT_hash_handle hh; // uthash requirement
} StringInfo;

extern nu_get_master_key_fptr get_key_function_from_keylog(char *filename);
extern void keylog_reader_cleanup();
typedef struct lls { char x[29]; } lls;
extern lls lltos(long long n);

static inline int
xdigit_value(char c) {
    if (c >= '0' && c <= '9')
	return (c-'0');
    if (c >= 'a' && c <= 'f')
	return (c-'a'+10);
    if (c >= 'A' && c <= 'F')
	return (c-'A'+10);
    return -1;
}
    
    
#ifdef __cplusplus
}
#endif

#endif //NUDEC_KEY_LOG_READER_H
