/*
 * ===================================================================
 *  TS 26.104
 *  R99   V3.5.0 2003-03
 *  REL-4 V4.4.0 2003-03
 *  REL-5 V5.1.0 2003-03
 *  3GPP AMR Floating-point Speech Codec
 * ===================================================================
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <memory.h>
#include "interf_dec.h"
#include "typedef.h"
#include "decoder.h"
#ifdef WIN32
#include "..\nlbis.h"
#else
#include "nlbis.h"
#endif

#ifndef ETSI
#ifndef IF2
#include <string.h>
#define AMR_MAGIC_NUMBER "#!AMR\n"
#endif
#endif

enum RXFrameType { RX_SPEECH_GOOD = 0,
RX_SPEECH_DEGRADED,
RX_ONSET,
RX_SPEECH_BAD,
RX_SID_FIRST,
RX_SID_UPDATE,
RX_SID_BAD,
RX_NO_DATA,
RX_N_FRAMETYPES     /* number of frame types */
};

enum RXFrameType getRXType(unsigned short frameType, unsigned short frameQuality)
{
	enum RXFrameType ret;

	static int lastSIDFrame = 0;

	//SPEECH MODE
	int nFrameType = frameType;
	if(nFrameType >= 0 && nFrameType <= 7)
	{
		if(frameQuality == 0)
		{
			ret = RX_SPEECH_BAD;
		}
		else
		{
			ret = RX_SPEECH_GOOD;
		}
		lastSIDFrame = 0;
	}
	//COMFORT NOISE MODE
	else if(frameType == 8)
	{
		if(frameQuality == 0)
		{
			ret = RX_SID_BAD;
		}
		else
		{
			if(lastSIDFrame == 1)
			{
				ret = RX_SID_UPDATE;
			}
			else
			{
				ret = RX_SID_FIRST;
			}
		}
		lastSIDFrame = 1;
	}
	else 
	{
		ret = RX_NO_DATA;
	}
	return ret;
}

void createSerial(NlBis *bis, Word16 *serial, unsigned short frameType, unsigned short frameQuality)
{
	Word32 i = 0;
	Word32 bit_num = 0;
	const Word16 mode_bits[] = {95, 103, 118, 134, 148,	159, 204, 244, 35};

	memset(serial, 0, SERIAL_FRAMESIZE*2);

	serial[0] = (Word16) getRXType(frameType, frameQuality);

	int nFrameType = frameType;
	if(frameQuality == 1 && nFrameType >= 0 && nFrameType <= 8)
	{
		bit_num = (Word32)mode_bits[frameType];

		for(;i < bit_num; i++)
		{
			serial[i + 1] = (Word16) NlBis_FieldValue(bis,1);
			NlBis_AdvanceB(bis,1);
		}
	}

	serial[1+MAX_SERIAL_SIZE] = (Word16)frameType;

}

int AmrNBDecoderInit(void **destate)
{
	if (NULL == (*destate = Decoder_Interface_init()))
	{
		return 0;
	}
	else
	{
		return 1;
	}
}
/*
* apiAmrNBDecode
*
*
* Function:
*    Speech decoder program
*
*    Usage: decoder bitstream_file synthesis_file
*
*    Format for ETSI bitstream file:
*       1 word (2-byte) for the TX frame type
*       244 words (2-byte) containing 244 bits.
*          Bit 0 = 0x0000 and Bit 1 = 0x0001
*       1 word (2-byte) for the mode indication
*       4 words for future use, currently written as zero
*
*    Format for 3GPP bitstream file:
*       Holds mode information and bits packed to octets.
*       Size is from 1 byte to 31 bytes.
*
*    Format for synthesis_file:
*       Speech is written to a 16 bit 8kHz file.
*
*    ETSI bitstream file format is defined using ETSI as preprocessor
*    definition
* Returns:
*    0
*/
void apiAmrNBDecode (const char* buf, unsigned short bufLen, unsigned shift, Word16* decodedData, unsigned short frameType, unsigned short frameQuality, void *destate)
{
	NlBis bis; 
	int i;

#ifndef ETSI
	unsigned char analysis[32];
#ifdef IF2
	short block_size[16]={ 12, 13, 15, 17, 18, 20, 25, 30, 5, 0, 0, 0, 0, 0, 0, 0 };
#else
	short block_size[16]={ 12, 13, 15, 17, 19, 20, 26, 31, 5, 0, 0, 0, 0, 0, 0, 0 };
#endif
#else
	short analysis[250];
#endif

	NlBis_InitFromBuf(&bis, (unsigned char*)buf, bufLen * 8, 0, shift);
	memset(analysis, 0, sizeof analysis);

#ifndef ETSI 
	analysis[0] = ((frameType << 1) | frameQuality) << 2;
	for( i = 1; i <= block_size[frameType]; i++)
	{
		analysis[i] = NlBis_FieldValue(&bis, 8);
		NlBis_AdvanceB(&bis, 8);
	}
#else
	createSerial(&bis, analysis, frameType, frameQuality);
#endif
	
	Decoder_Interface_Decode(destate, analysis, decodedData, 0);
}

void AmrNBDecoderExit(void **destate)
{
	Decoder_Interface_exit(destate);
}
