
/*********************************************************************
                              NOVILIT, INC                            
 The  following  code  is  the sole property of NOVILIT Inc., and     
 contains its proprietary and confidential information.  This code    
 is  used under license.  No reproduction of this code may be made    
 in  any  form  without  the express written consent of NOVILIT Inc.. 
 Copyright (c) 1999-2002  NOVILIT, Inc., Marlborough, MA  USA        
 For inquires call Toll-Free: 1.877.529.4196                          
 or                                                                   
 email to: sales@novilit.com                                          
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 CMDE, CMDL, and NOVILIT are trademarks of NOVILIT Inc.               
 CMDE/CMDL are US patent 6,356,950                                         
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                                                                      
 File:        nlbis.c           
 Author:      novilit-102                                             
 Created:     1/29/2000 2:15pm    
 Comments:                                                                
                                                                      
*********************************************************************/

#include "nlbis.h"

/***************************************************************************************
   Call the function to initialize structure from input data stream.
   Input:
      Parameter:
         ap_bisD: a pointer that point to structure NlBis.
         ap_pduO: pointer to the begining of the PDU.
         a_lenPduB: length of the PDU (bits).
         a_offPduO: offset of the first octet of the current PDU relating to the
                    begining of the protocol of topmost level.
         a_shiftPduB: shift of the first bit of first octet of the pdu (bits)
   Return: void.
***************************************************************************************/
void NlBis_InitFromBuf(NlBis *ap_bisD, u1 *ap_pduO, u4 a_lenPduB, u4 a_offPduO, u4 a_shiftPduB) 
{
   if (ap_bisD != ULM(0)) 
   {
      ap_bisD->mp_pduO      = ap_pduO;
      ap_bisD->m_shiftPduB  = a_shiftPduB;
      ap_bisD->m_lenPduB    = a_lenPduB;
      ap_bisD->m_offPduO    = a_offPduO;
      ap_bisD->m_indCurO    = 0;
      ap_bisD->m_shiftCurB  = a_shiftPduB;

      ap_bisD->m_lsbf       = NLFALSE;
      ap_bisD->m_lsof       = NLFALSE;

      ap_bisD->m_pend       = 0;
   }
}

/***************************************************************************************
   Call the function to copy a structure NlBis to another.
   Input:
      Parameter:
         ap_bisD: a pointer that point to structure NlBis (Destination).
         ap_bisS: a pointer that point to structure NlBis (source).
   Return: void.
***************************************************************************************/
void NlBis_InitCopy(NlBis *ap_bisD, NlBis *ap_bisS) 
{
   if ((ap_bisD != ULM(0)) && (ap_bisS != ULM(0))) 
   {
      ap_bisD->mp_pduO     = ap_bisS->mp_pduO;
      ap_bisD->m_shiftPduB = ap_bisS->m_shiftPduB;
      ap_bisD->m_lenPduB   = ap_bisS->m_lenPduB;
      ap_bisD->m_offPduO   = ap_bisS->m_offPduO;
      ap_bisD->m_indCurO   = ap_bisS->m_indCurO,
      ap_bisD->m_shiftCurB = ap_bisS->m_shiftCurB;

      ap_bisD->m_lsbf       = ap_bisS->m_lsbf;
      ap_bisD->m_lsof       = ap_bisS->m_lsof;

      ap_bisD->m_pend       = 0;

#ifdef G_OPT
	  /*gan*/
	  ap_bisD->m_previndCurO = ap_bisS->m_previndCurO;
#endif
   }
}

/***************************************************************************************
   Call the function to initialize structure from super packet.
   Input:
      Parameter:
         ap_bisD: a pointer that point to structure NlBis (Destination).
         ap_bisS: a pointer that point to structure NlBis (source).
   Return: void.
***************************************************************************************/
void NlBis_InitFromSuper(NlBis *ap_bisD, NlBis *ap_bisS) 
{
   if ((ap_bisD != ULM(0)) && (ap_bisS != ULM(0))) 
   {
      ap_bisD->mp_pduO     = NlBis_PtrCurO(ap_bisS);
      ap_bisD->m_shiftPduB = ap_bisS->m_shiftCurB;
      ap_bisD->m_lenPduB   = NlBis_LenCurB(ap_bisS);
      ap_bisD->m_offPduO   = NlBis_OffCurO(ap_bisS);
      ap_bisD->m_indCurO   = 0,
      ap_bisD->m_shiftCurB = ap_bisS->m_shiftCurB;

      ap_bisD->m_lsbf       = ap_bisS->m_lsbf;
      ap_bisD->m_lsof       = ap_bisS->m_lsof;

      ap_bisD->m_pend       = 0;
#ifdef G_OPT
	  /*gan*/
	  ap_bisD->m_previndCurO = 0;
#endif

   }
}

/***************************************************************************************
   Call the function to initialize one structure NlBis with data from super packet 
   except the length of pdu.
   Input:
      Parameter:
         ap_bisD: a pointer that point to structure NlBis (Destination).
         ap_bisS: a pointer that point to structure NlBis (source).
         a_lenPduB: length of the PDU (bits).
   Return: void.
***************************************************************************************/
void NlBis_InitFromSuperLen(NlBis *ap_bisD, NlBis *ap_bisS, u4 a_lenPduB) 
{
   if ((ap_bisD != ULM(0)) && (ap_bisS != ULM(0))) 
   {
      ap_bisD->mp_pduO     = NlBis_PtrCurO(ap_bisS);
      ap_bisD->m_shiftPduB = ap_bisS->m_shiftCurB;
      ap_bisD->m_lenPduB   = MIN(a_lenPduB, NlBis_LenCurB(ap_bisS));
      ap_bisD->m_offPduO   = NlBis_OffCurO(ap_bisS);
      ap_bisD->m_indCurO   = 0,
      ap_bisD->m_shiftCurB = ap_bisS->m_shiftCurB;

      ap_bisD->m_lsbf      = ap_bisS->m_lsbf;
      ap_bisD->m_lsof      = ap_bisS->m_lsof;

      ap_bisD->m_pend      = 0;
#ifdef G_OPT
	  /*gan*/
	  ap_bisD->m_previndCurO=0;
#endif
   }
}

/***************************************************************************************
   Call the function to set current length.
   Input:
      Parameter:
         ap_bis: a pointer that point to structure NlBis.
         a_lenCurB: cuurent length of the PDU (bits).
   Return: void.
***************************************************************************************/
void NlBis_SetCurLen(NlBis *ap_bis, u4 a_lenCurB) 
{
   if (ap_bis != ULM(0)) 
      ap_bis->m_lenPduB = NlBis_IndCurB(ap_bis) + MIN(a_lenCurB, NlBis_LenCurB(ap_bis));
}

/***************************************************************************************
   Call the function to set least significant bit first flag.
   Input:
      Parameter:
         ap_bis: a pointer that point to structure NlBis.
         a_lsbf: least significant bit first flag.
   Return: void.
***************************************************************************************/
void  NlBis_SetLsbf (NlBis *ap_bis, u4 a_lsbf)
{
   if (ap_bis != ULM(0))
      ap_bis->m_lsbf = a_lsbf; /*finaly set direction*/
}

/***************************************************************************************
   Call the function to set least significant octet first flag.
   Input:
      Parameter:
         ap_bis: a pointer that point to structure NlBis.
         a_lsof: least significant octet first flag.
   Return: void.
***************************************************************************************/
void  NlBis_SetLsof (NlBis *ap_bis, u4 a_lsof)
{
   if (ap_bis != ULM(0)) 
      ap_bis->m_lsof = a_lsof; /*finaly set direction*/
}

/***************************************************************************************
   Call the function to get least significant bit first flag.
   Input:
      Parameter:
         ap_bis: a pointer that point to structure NlBis.
   Return: least significant bit first flag.
***************************************************************************************/
u4  NlBis_GetLsbf (NlBis *ap_bis)
{
   if (ap_bis != ULM(0)) 
      return ap_bis->m_lsbf;
   else return 0;
}

/***************************************************************************************
   Call the function to get least significant octet first flag.
   Input:
      Parameter:
         ap_bis: a pointer that point to structure NlBis.
   Return: least significant octet first flag.
***************************************************************************************/
u4  NlBis_GetLsof (NlBis *ap_bis) 
{
   if (ap_bis != ULM(0)) 
      return ap_bis->m_lsof;   
   else return 0;
}

/***************************************************************************************
   Call the function to Advance bit.
   Input:
      Parameter:
         ap_bis: a pointer that point to structure NlBis.
         a_numB: number of bit to be advanced.
   Return: void.
***************************************************************************************/
void NlBis_AdvanceB(NlBis *ap_bis, u4 a_numB)
{
   u4 bpdu_ind_b;

   if (ap_bis != ULM(0)) 
   {
      bpdu_ind_b = NlBis_IndCurB(ap_bis)  
         + MIN(a_numB, NlBis_LenCurB(ap_bis)) 
         + ap_bis->m_shiftPduB;
#ifdef G_OPT
	  /*gan*/
	  ap_bis->m_previndCurO=ap_bis->m_indCurO;
#endif

      ap_bis->m_indCurO    = bpdu_ind_b / ULM(8);
      ap_bis->m_shiftCurB  = bpdu_ind_b % ULM(8);

	  
   }
}

/***************************************************************************************
   Call the function to Align Value.
   Input:
      Parameter:
         ap_bis: a pointer that point to structure NlBis.
         a_AlignSizeB: an Align Size of bit.
   Return: alignment.
***************************************************************************************/
u4 NlBis_AlignValue (NlBis *ap_bis, u4 a_AlignSizeB)
{
   u4 last_fragment_bit_size, alignment; 
   
   if (ap_bis != ULM(0)) 
   {
      if(a_AlignSizeB == ULM(8)) 
         last_fragment_bit_size = ap_bis->m_shiftCurB;
      else 
         last_fragment_bit_size = 
            ((NlBis_OffCurO(ap_bis) << ULM(3)) + ap_bis->m_shiftCurB) % a_AlignSizeB;

      alignment = last_fragment_bit_size ? (a_AlignSizeB - last_fragment_bit_size) : 0;

      return alignment;
   } else return 0;
}

/***************************************************************************************
   Call the function to get field value.
   Input:
      Parameter:
         ap_bis: a pointer that point to structure NlBis.
         a_lenB: a length of field(bits).
   Return: value of field.
***************************************************************************************/
u4 NlBis_FieldValue(NlBis *ap_bis, u4 a_lenB) 
{
   u1 *fptr; 
   u4 fmas[9]  = {ULM(0xff),ULM(0x7f),ULM(0x3f),ULM(0x1f),ULM(0x0f)
      ,ULM(0x07),ULM(0x03),ULM(0x01),ULM(0x00)}
      ,val, curval, shift, lbitlen, bitpad, fo_num, ls,rs, i;

   if (ap_bis != ULM(0)) 
   {
      fptr    = NlBis_PtrCurO(ap_bis);
      val     = 0;
      curval  = 0;
      shift   = ap_bis->m_shiftCurB;
      lbitlen = shift+a_lenB;
      bitpad  = (ULM(8)- (lbitlen & ULM(7))) & ULM(7);
      fo_num  = (lbitlen + ULM(7)) >> ULM(3);
      /* |8|7|6|5|4|3|2|1| <- (traffic goes in left direction) */
      if(ap_bis->m_lsbf == NLTRUE) 
      { 
         /*for the short fields witch fit to the one current octet (for improving timeing)*/
         if(lbitlen <= ULM(8))  val =  (((u4)*fptr) >> shift) & fmas[ULM(8) - a_lenB];
         /*for the fields witch do not fit to the one current octet*/
         else if(ap_bis->m_lsof == NLTRUE) 
         { /* --------------- lsbf, lsof*/
            ls = 0;
            rs = shift;
            for(i = 0; i < fo_num; i++) 
            {
               /*take curval*/
               curval = (u4)(fptr[i]);
            
               /*clean unused bits with mask if nesessary*/
               if(i == ULM(0) && shift != ULM(0)) curval &= ~fmas[ULM(8)-shift]; /*first octet*/
               if(i == (fo_num - ULM(1)) && bitpad != ULM(0)) curval &= fmas[bitpad]; /*last octet*/
            
               /*move curval to the appropriate position*/
               if(ls > rs) curval <<= (ls - rs); else curval >>= (rs - ls);

               /*update value*/
               val |= curval;
            
               /*update ls and rs as apropriate*/
               ls += ULM(8);
            }
         }
         else {/* ------------------------------------------- lsbf,lsol*/
            ls = (fo_num-ULM(1))<<ULM(3);
            rs = shift + bitpad;
            for(i = 0; i < fo_num; i++) 
            {
               /*take curval*/
               curval = (u4)(fptr[i]);
            
               /*clean unused bits with mask if nesessary*/
               if(i == ULM(0) && shift != ULM(0)) curval &= ~fmas[ULM(8)-shift]; /* first octet*/
               if(i == (fo_num - ULM(1)) && bitpad != ULM(0)) curval &= fmas[bitpad]; /* last octet*/
            
               /*correction of the rs for the last octet*/
               if(i == fo_num - ULM(1)) rs = 0;

               /*move curval to the appropriate position*/
               if(ls > rs) curval <<= (ls - rs); else curval >>= (rs - ls);

               /*update value*/
               val |= curval;
            
               /*update ls and rs as apropriate*/
               ls -= ULM(8);
               rs = bitpad;
            }
         }
      }
      /* (traffic goes in right direction) -> |8|7|6|5|4|3|2|1| */
      else 
      {
         /*for the short fields witch fit to the one current octet (for improving timeing)*/
         if(lbitlen < ULM(8)) val =  ((((u4)*fptr) >> (ULM(8) - lbitlen)) & fmas[ULM(8) - a_lenB]);
         /*for the fields witch do not fit to the one current octet*/
         else if(ap_bis->m_lsof == NLTRUE) 
         {/* ---------------- lsbl, lsof*/
            ls = 0;
            rs = 0;
            for(i = 0; i < fo_num; i++) 
            {
               /*take curval*/
               curval = (u4)(fptr[i]);
            
               /*clean unused bits with mask if nesessary*/
               if(i == ULM(0) && shift != ULM(0)) curval &= fmas[shift]; /*first octet*/
               if(i == (fo_num - ULM(1)) && bitpad != ULM(0)) curval &= ~fmas[ULM(8) - bitpad]; /*last octet*/
            
               /*correction of the rs for the last octet*/
               if(i == fo_num - ULM(1)) rs = shift + bitpad;

               /*move curval to the appropriate position*/
               if(ls > rs) curval <<= (ls - rs); else curval >>= (rs - ls);

               /*update value*/
               val |= curval;
            
               /*update ls and rs as apropriate*/
               ls += ULM(8);
               rs = shift;
            }
         }
         else 
         {/* ------------------------------------------- lsbl, lsol*/
            ls = (fo_num - ULM(1)) << ULM(3);
            rs = bitpad;
            for(i = 0; i < fo_num; i++) 
            {
               /* take curval*/
               curval = (u4)(fptr[i]);
            
               /* clean unused bits with mask if nesessary*/
               if(i == ULM(0) && shift != ULM(0)) curval &= fmas[shift]; /*first octet*/
               if(i == (fo_num - ULM(1)) && bitpad != ULM(0)) curval &= ~fmas[ULM(8) - bitpad]; /*last octet*/
            
               /*move curval to the appropriate position*/
               if(ls > rs) curval <<= (ls - rs); else curval >>= (rs - ls);

               /* update value*/
               val |= curval;
            
               /* update ls and rs as apropriate*/
               ls -= ULM(8);
            }
         }
      }

      return val;
   } else return 0;
}

/***************************************************************************************
   Call the function to check checsum value.
   Input:
      Parameter:
         a_pduO: pointer to the beggining of checksum data block.
         a_curO: pointer to the checksum field.
         a_lenO: length of the data for checksum calculation (octets).
         a_lenB: length of the checksum field (bits).
         a_num1: pseudofield which added to the data block for the checksum.
         a_num2: pseudofield which added to the data block for the checksum.
   Return: value of being checked.
***************************************************************************************/
u4 NlBis_ChecksValue(u1 *a_pduO, /*pointer to the beggining of checksum data block*/
                     u1 *a_curO, /*pointer to the checksum field*/
                     u4 a_lenO,  /*length of the data for checksum calculation (octets)*/
                     u4 a_lenB,  /*length of the checksum field (bits)*/ 
                     u4 a_num1,  /*pseudofield which added to the data block for the checksum*/
                     u4 a_num2)  /*pseudofield which added to the data block for the checksum*/ 
{
   u4 sum = 0,       /*complement sum of all 16 bit words of the data block for checksum calculation*/
      tmp = 0;       /*varables with lower or upper octet set to 0x00 if lower or upper octet of current word is part of checksum field and 0xff otherwise*/
   u2 checksum = 0;  /*checksum value*/
   u1 *addr = 0,     /*current pointer to the beggining of checksum data block*/
      *addr1 = 0,    /*pointer to the checksum field*/
      *addr2 = 0;    /*pointer to the end of the checksum field*/

   if ((!a_pduO) || (!a_curO))
      return ULM(0xffffffff);

   /*set pointers to the beggining of data block for checksum calculation, start and end of checksum field*/
   addr = a_pduO;
   addr1 = a_curO;
   addr2 = addr1 + a_lenB / ULM(8);

   /*calculate sum of all 16 bit words of the data block for checksum calculation*/
   while(a_lenO > ULM(1)) 
   {
      /*set lower or upper octets of tmp variable to 0x00 if lower or upper octet of current word is part of checksum field and to 0xff otherwise*/
      tmp = ULM(0xffff);
      if ((addr >= addr1) && (addr < addr2)) 
         tmp &= ULM(0x00ff);
      if ((addr + 1 >= addr1) && (addr + 1 < addr2)) 
         tmp &= ULM(0xff00);
      
      /*add value of the current word*/
      sum += (((u4)addr[0] << ULM(8)) | (u4)addr[1]) & tmp;
      
      /*increase current pointer to data block for checksum calculation, and decrease the length of the part left*/
      addr += 2;
      a_lenO -= ULM(2);
   }

   /*add last octet if the number of octets in data block for checksum calculation is odd*/
   if (a_lenO > ULM(0)) {
      tmp = ULM(0xffff);
      if ((addr >= addr1) && (addr < addr2)) 
         tmp = ULM(0);
      sum += ((u4)addr[0] << ULM(8)) & tmp;
   }
   
   /*add pseudo fields values*/
   if (a_num1 || a_num2) {
      sum += (a_num1 >> ULM(16)) + (a_num1 & ULM(0xffff));
      sum += (a_num2 >> ULM(16)) + (a_num2 & ULM(0xffff));
   }

   /*calculate one's complement sum of all 16 bit words of the data block for checksum calculation*/
   while(sum >> ULM(16)) 
      sum = (sum >> ULM(16)) + (sum & ULM(0xffff));
   checksum = (u2)~(u2)sum;
   return checksum;
}

/***************************************************************************************
   Call the function to check ls checsum value.
   Input:
      Parameter:
         a_pduO: pointer to the beggining of checksum data block.
         a_curO: pointer to the checksum field.
         a_lenO: length of the data for checksum calculation (octets).
         a_lenB: length of the checksum field (bits).
         a_num1: pseudofield which added to the data block for the checksum.
         a_num2: pseudofield which added to the data block for the checksum.
   Return: value of being checked.
***************************************************************************************/
u4 NlBis_LSChecksValue(u1 *a_pduO,/*pointer to the beggining of checksum data block*/
                     u1 *a_curO,  /*pointer to the checksum field*/
                     u4 a_lenO,   /*length of the data for checksum calculation (octets)*/
                     u4 a_lenB,   /*length of the checksum field (bits)*/ 
                     u4 a_num1,   /*pseudofield which added to the data block for the checksum*/
                     u4 a_num2)   /*pseudofield which added to the data block for the checksum*/
{
   w4 C0 = 0, C1 = 0, L = 0, n = 0, X = 0, Y = 0, tmp = 0;
   u2 checksum = 0;  /*checksum value*/
   u1 *addr = 0,     /*current pointer to the beggining of checksum data block*/
      *addr1 = 0,    /*pointer to the checksum field*/
      *addr2 = 0;    /*pointer to the end of the checksum field*/

   if ((!a_pduO) || (!a_curO))
      return ULM(0xffffffff);

   /*set pointers to the beggining of data block for checksum calculation, start and end of checksum field*/
   addr = a_pduO;
   addr1 = a_curO;
   addr2 = addr1 + a_lenB / ULM(8);
   L = (w4)a_lenO;
   n = addr1 - addr + 1;

   while(a_lenO > ULM(0)) 
   {
      tmp = ((addr < addr1) || (addr >= addr2)) ? addr[0] : 0;
      
      C0 = (C0 + tmp) % 255;
      C1 = (C1 + C0) % 255;

      addr++;
      a_lenO--;
   }

   /*add pseudo fields values*/
   if (a_num1 || a_num2) {
      for(tmp = 24; tmp; tmp -= 8) {C0 = (C0 + (w4)(a_num1 >> tmp) & 255) % 255; C1 = (C1 + C0) % 255;}
      for(tmp = 24; tmp; tmp -= 8) {C0 = (C0 + (w4)(a_num2 >> tmp) & 255) % 255; C1 = (C1 + C0) % 255;}
   }

   X = (-C1 + ((L - n) * C0) % 255) % 255;
   Y = (C1 - ((L - n + 1) * C0) % 255);

   if (X <= 0) X += 255;
   if (Y <= 0) Y += 255;

   checksum = (u2)(((u1)X << ULM(8)) | (u1)Y);
   return checksum;
}

/*********************************************************************
 End of File: nlbis.c
*********************************************************************/

