/*
 *===================================================================
 *  3GPP AMR Wideband Floating-point Speech Codec
 *===================================================================
 */

#include <stdio.h>
#include <stdlib.h>
#include "typedef.h"
#include "dec_if.h"
#ifdef WIN32
#include "..\nlbis.h"
#else
#include "nlbis.h"
#endif


#ifndef IF2
#include <string.h>
#define AMRWB_MAGIC_NUMBER "#!AMR-WB\n"
#endif

void *st = NULL;

/* One encoded frame (bytes) */
/*
 * 6 bytes are used both for mode 9 and 10.
 * Mode 9 is used in encoder and mode 10 in IF2
 */
#ifdef IF2
const UWord8 block_size[16]= {18, 23, 33, 37, 41, 47, 51, 59, 61, 6, 6, 0, 0, 0, 1, 1};
#else
const UWord8 block_size[16]= {18, 24, 33, 37, 41, 47, 51, 59, 61, 6, 6, 0, 0, 0, 1, 1};
#endif


/*
 * DECODER.C
 *
 * Main program of the AMR WB ACELP wideband decoder.
 *
 *    Usage : decoder bitstream_file synth_file
 *
 *    Format for bitstream_file:
 *        Described in TS26.201
 *
 *    Format for synth_file:
 *      Synthesis is written to a binary file of 16 bits data.
 *
 */

//extern const UWord8 block_size[];

int AmrWBDecoderInit(void **st)
{
	if (NULL == (*st = D_IF_init()))
	{
		return 0;
	}
	else
	{
		return 1;
	}
}

void AmrWBDecode (const char* buf, unsigned short bufLen, unsigned shift, Word16* decodedData, unsigned short frameType, unsigned short frameQuality, void *st)
{
	NlBis bis; 
	int i;
	UWord8 serial[NB_SERIAL_MAX];

	NlBis_InitFromBuf(&bis, (unsigned char*)buf, bufLen * 8, 0, shift);
	memset(serial, 0, sizeof serial);

	serial[0] = ((frameType << 1) | frameQuality) << 2;
	for( i = 1; i < block_size[frameType]; i++)
	{
		serial[i] = NlBis_FieldValue(&bis, 8);
		NlBis_AdvanceB(&bis, 8);
	}
	
	D_IF_decode(st, serial, decodedData, 0);
}

void AmrWBDecoderExit(void **st)
{
	D_IF_exit(st);
}
