/**********************************************************************
Each of the companies; Motorola, and Lucent, and Qualcomm, and Nokia (hereinafter 
referred to individually as "Source" or collectively as "Sources") do 
hereby state:

To the extent to which the Source(s) may legally and freely do so, the 
Source(s), upon submission of a Contribution, grant(s) a free, 
irrevocable, non-exclusive, license to the Third Generation Partnership 
Project 2 (3GPP2) and its Organizational Partners: ARIB, CCSA, TIA, TTA, 
and TTC, under the Source's copyright or copyright license rights in the 
Contribution, to, in whole or in part, copy, make derivative works, 
perform, display and distribute the Contribution and derivative works 
thereof consistent with 3GPP2's and each Organizational Partner's 
policies and procedures, with the right to (i) sublicense the foregoing 
rights consistent with 3GPP2's and each Organizational Partner's  policies 
and procedures and (ii) copyright and sell, if applicable) in 3GPP2's name 
or each Organizational Partner's name any 3GPP2 or transposed Publication 
even though this Publication may contain the Contribution or a derivative 
work thereof.  The Contribution shall disclose any known limitations on 
the Source's rights to license as herein provided.

When a Contribution is submitted by the Source(s) to assist the 
formulating groups of 3GPP2 or any of its Organizational Partners, it 
is proposed to the Committee as a basis for discussion and is not to 
be construed as a binding proposal on the Source(s).  The Source(s) 
specifically reserve(s) the right to amend or modify the material 
contained in the Contribution. Nothing contained in the Contribution 
shall, except as herein expressly provided, be construed as conferring 
by implication, estoppel or otherwise, any license or right under (i) 
any existing or later issuing patent, whether or not the use of 
information in the document necessarily employs an invention of any 
existing or later issued patent, (ii) any copyright, (iii) any 
trademark, or (iv) any other intellectual property right.

With respect to the Software necessary for the practice of any or 
all Normative portions of the EVRC-B Variable Rate Speech Codec as 
it exists on the date of submittal of this form, should the EVRC-B be 
approved as a Specification or Report by 3GPP2, or as a transposed 
Standard by any of the 3GPP2's Organizational Partners, the Source(s) 
state(s) that a worldwide license to reproduce, use and distribute the 
Software, the license rights to which are held by the Source(s), will 
be made available to applicants under terms and conditions that are 
reasonable and non-discriminatory, which may include monetary compensation, 
and only to the extent necessary for the practice of any or all of the 
Normative portions of the EVRC-B or the field of use of practice of the 
EVRC-B Specification, Report, or Standard.  The statement contained above 
is irrevocable and shall be binding upon the Source(s).  In the event 
the rights of the Source(s) in and to copyright or copyright license 
rights subject to such commitment are assigned or transferred, the 
Source(s) shall notify the assignee or transferee of the existence of 
such commitments.
*******************************************************************/

static char const rcsid[]="$Id: //E-XMS/GIT/csa/Utilities/cpp/RtpCodecUtil/evrc_b/acelp.cpp#1 $";

/*======================================================================*/
/*     Enhanced Variable Rate Codec - Master C code Specification       */
/*     Copyright (C) 1997-1998 Telecommunications Industry Association. */
/*     All rights reserved.                                             */
/*----------------------------------------------------------------------*/
/* Note:  Reproduction and use of this software for the design and      */
/*     development of North American Wideband CDMA Digital              */
/*     Cellular Telephony Standards is authorized by the TIA.           */
/*     The TIA does not authorize the use of this software for any      */
/*     other purpose.                                                   */
/*                                                                      */
/*     The availability of this software does not provide any license   */
/*     by implication, estoppel, or otherwise under any patent rights   */
/*     of TIA member companies or others covering any use of the        */
/*     contents herein.                                                 */
/*                                                                      */
/*     Any copies of this software or derivative works must include     */
/*     this and all other proprietary notices.                          */
/*======================================================================*/

#include "macro.h"
#include "acelp.h"
#define L_SUBFR  54
#define L_SUBFR2 55
#define L_CODE    55

#ifdef WIN32
#define rint(x)  (int)((x) + 0.5)     /*...define non-ANSI function...*/
#endif


/*Note: Vector xn[], res2[], code[], y2[] and h1[] should be of lenght 55 !!! */

/*---------------------------------------------------------------------------*
 *  Function  ACELP_code()                                                   *
 *  ~~~~~~~~~~~~~~~~~~~~~~                                                   *
 *   Find Algebraic codebook.                                                *
 *--------------------------------------------------------------------------*/

void ACELP_Code(
  float xn[],         /* (i)     :Target signal for codebook.       */
  float res2[],       /* (i)     :Residual after pitch contribution */
  float h1[],         /* (i)     :Impulse response of filters.      */
  int   T0,           /* (i)     :Pitch lag.                        */
  float pitch_gain,   /* (i)     :Pitch gain.                       */
  int   l_subfr,      /* (i)     :Subframe lenght.                  */
  float code[],       /* (o)     :Innovative vector.                */
  float *gain_code,   /* (o)     :Innovative vector gain.           */
  float y2[],         /* (o)     :Filtered innovative vector.       */
  int  *index,        /* (o)     :Index of codebook + signs         */
  int  choice         /* (i)     :Choice of innovative codebook     */
                      /*          0 -> 10 bits                      */
                      /*          1 -> 35 bits                      */
)
{
  int i;
  float pit_sharp;
  float dn[L_SUBFR2];

  /*-----------------------------------------------------------------*
   * - Find pitch sharpening.                                        *
   *-----------------------------------------------------------------*/

  pit_sharp = pitch_gain;
  
  if(pit_sharp > 0.9) pit_sharp = 0.9;
  if(pit_sharp < 0.2) pit_sharp = 0.2;
  

  /*-----------------------------------------------------------------*
   * - Include fixed-gain pitch contribution into impulse resp. h1[] *
   * - Correlation between target xn[] and impulse response h1[]     *
   * - Innovative codebook search                                    *
   *-----------------------------------------------------------------*/

  pit_shrp(h1, T0, pit_sharp, L_SUBFR);
  
  corr_xh(xn, dn, h1, L_SUBFR);
  
  if (choice == 0) {
    fprintf(stderr,"ERROR: Choice should not be 0 in ACELP_Code\n");
    exit(1);
  }
  else {

    cod7_35(xn, res2, l_subfr, h1, code, y2, gain_code, index);

  }
  
  pit_shrp(code, T0, pit_sharp, l_subfr);
  return;
}

/* Copyright Nokia Mobile Phones/University of Sherbrooke,  1995 */
/* History :  */
/* Version 1.0 -- 3/19/96, initial version. */
/* Version 1.1 -- 9/10/96, (TJ) Changed L_CODE parameter in rr[][] build
                           to l_subfr */
/* Version 1.2 -- 3/5/97, (DJY) Changed L_CODE to l_subfr in line 77 to
                          fix bug with half-rate max mode. */

#include <float.h>
#include <math.h>

#define NB_PULSE310  3
#define STEP310      7
#define NB_TRACK310  3




#include <math.h>
#include <float.h>





void dec_fpmp(int *index, float *cb_out)
{
  int64 code;
  int tmp_cb[MAX_TLEN];
  int indx;
  
  code = (((index[3]>>8) & 0x00000007L)<<8) + (index[3] & 0x000000ffL);
  code = (code<<8) + (index[2] & 0x000000ffL);
  code = (code<<8) + (index[1] & 0x000000ffL);
  code = (code<<8) + (index[0] & 0x000000ffL);
  
  
  /*
    code = (((index[0]>>8) & 0x000000ffL)<<8) + (index[0] & 0x000000ffL);
    code = code<<16+(((index[1]>>8)&0x000000ffL)<<8)+(index[1]&0x000000ffL);
    code = code<<16+(((index[2]>>8)&0x000000ffL)<<8)+(index[2]&0x000000ffL);
  */
  
  factorial_unpack(code, 54, N_PULSES, tmp_cb);
  for (indx=54; indx<MAX_TLEN; indx++) tmp_cb[indx]=0; //initializing to prevent UMR in decoder
  for (indx=0; indx<MAX_TLEN; indx++) cb_out[indx] = (float)tmp_cb[indx];
  for (indx=MAX_TLEN; indx<L_CODE; indx++) cb_out[indx] = 0.0;

}




/* Copyright Nokia Mobile Phones/University of Sherbrooke,  1995 */
/* History :  */
/* Version 1.0 -- 3/19/96, initial version. */
/* Version 1.1 -- 9/10/96, (TJ) Changed VCM_L parameter in rr[][] build
                           to l_subfr */
/* Version 1.2 -- 3/5/97, (DJY) Changed VCM_L to l_subfr in line 77 to
                          fix bug with half-rate max mode. */
#include <float.h>
#include <math.h>
#include <stdio.h>


  		   

void build_rr(
	float	h[],	/* input */
	float	rr[][VCM_L0],	/* output */
	int	l_subfr /* input */
)
{
  int	i, j, k, dec;
  float	s;
  
  /* Put h[i] = 0; for i>l_subfr */
  for(i=l_subfr; i<VCM_L0; i++) h[i] = 0.0;
  
  for (k = 0, s = 0.0, i = l_subfr-1; k < l_subfr; k++, i--) {
    s += h[k]*h[k];
    rr[i][i] = s;
  }
  
  for (dec = 1; dec < l_subfr; dec++) {
    j = l_subfr - 1;
    i = j - dec;
    for (k = 0, s = 0.0; k < (l_subfr-dec); k++, i--, j--) {
      s += h[k]*h[k+dec];
      rr[i][j] = rr[j][i] = s;
    }
  }
  
  /* Put rr[i][j] = 0; for i,j>l_subfr */
  for(i=l_subfr; i<VCM_L0; i++)
    for(j=0; j<VCM_L0; j++)
      rr[i][j] = rr[j][i] = 0.0;
}
/* Copyright Nokia Mobile Phones/University of Sherbrooke,  1995 */

/* Pitch sharpening:  */

void pit_shrp(
	float *x,	/* in/out: impulse response (or algebraic code) */
	int pit_lag,	/* input : pitch lag                            */
	float sharp,	/* input : pitch sharpening factor              */
	int L_subfr	/* input : subframe size                        */
)
{
  int     i;
  
  if (pit_lag < L_subfr)
    for (i = pit_lag; i < L_subfr; i++)
      x[i] += sharp * x[i - pit_lag];
}
/* Copyright Nokia Mobile Phones/University of Sherbrooke,  1995 */

/*----------------------------------------------------------------------*
 * procedure corr_xh:                                                   *
 *           ~~~~~~~~                                                   *
 *  Compute the correlation between the target signal and the impulse   *
 *  response of the weighted synthesis filter.                          *
 *                                                                      *
 *           y[i]=sum(j=i,l-1) x[j]*h[j-i], i=0,l-1                     *
 *                                                                      *
 *----------------------------------------------------------------------*
 *         Claude Laflamme 2  oct  89                                   *
 *----------------------------------------------------------------------*
 * Version C: R.A.Salami  24 oct 1990                                   *
 *----------------------------------------------------------------------*/

void corr_xh(
	float *x,/* input : target signal                                   */
	float *y,/* output: correlation between x[] and h[]                 */
	float *h,/* input : impulse response (of weighted synthesis filter) */
	int l	 /* input : vector size                                     */
)
{
  int     i, j, l_1, l2;
  float   s, *px, *px2, *ph;
  
  l_1 = l - 1;
  l2 = l_1;
  px2 = x;
  for (i = 0; i <= l_1; i++) {
    px = px2;
    ph = h;
    s = 0.0;
    for (j = 0; j <= l2; j++) s += (*px++) * (*ph++);
    *y++ = s;
    l2--;
    px2++;
  }
  return;
}

/********************************************************
 Version with indices

 for (i = 0; i < l; i++) {
  s = 0.0;
  for (j = i; j < l; j++) s += x[j]*h[j-i];
  y[i] = s;
 }
 return;
}
*********************************************************/
/*
 * Factorial Packing C Language function.
 * 
 * By:   Edgardo M. Cruz-Zeno
 * Date: Aug/17/1998
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>	/* For rint() */

int64 F(int n, int m)
{
  int64 retval;
  int num, den;
  double dval;
  int max;
  
  if((n<m) || (m<0)) {
    retval=0;
  }
  else {
    if((n-m)>m) {
      max = n-m;
      den = m;
    }
    else {
      max = m;
      den = n-m;
    }
    dval=1;
    for (num=n; num>max; num--) {
      dval=dval*(double)(num)/(double)(den);
      den=den-1;
    }
    retval=(int64)rint(dval);
  }
  return(retval);
}

int64 D(int n, int m)
{
  return(F(n-1,m-1));
}

int64 Ipos(int *posvect, int vectlen)
{
  int indx;
  int64 pos=0;
  
  for(indx=0; indx<vectlen; indx++) {
    pos += F(posvect[indx], indx+1);
  }
  return(pos);
}

int64 Ioff(int Nd, int Np, int len)
{
  int64 off=0;
  int indx;
  
  for(indx=Nd+1; indx<=Np; indx++) {
    off += F(len, indx)*D(Np, indx);
  }
  return(off);
}

int64 Ioff_S(int Nd, int Np, int len)
{
  int64 off=0;
  int indx;
  
  for(indx=Nd+1; indx<=Np; indx++) {
    off += F(len, indx)*D(Np, indx)*(0x0001<<indx);
  }
  return(off);
}


int64 factorial_pack(int Tlen, float *vector)
{
  int indx;
  int indx2;
  int Tvect[L_MAXSIZE];
  int TLam[L_MAXSIZE];
  int Spos;
  int Soff;
  int TLamindx;
  int Td, Tn, Tm;
  int Niter;
  int64 Tcode, code;
  int64 Toff;
  
  
  Td = 0;
  Tm = 0;
  Tn = Tlen;
  TLamindx=0;
  for (indx=0; indx<Tlen; indx++) {
    Tvect[indx]=abs((int)(vector[indx]));
    if(Tvect[indx]!=0) {
      Td++;
      Tm += Tvect[indx];
      TLam[TLamindx] = indx;
      TLamindx++;
    }
  }
  
  Spos = 0;
  Soff = 0x01<<Td;
  for (indx=0; indx<Td; indx++) {
    if(vector[TLam[indx]]<0) {
      Spos += (0x01<<(Td-indx-1));
    }
  }
  
  code = Ioff_S(Td, Tm, Tn) + Spos;
  Niter = Tm-Td+1;
  Toff=0;
  Tcode=0;
  for(indx=0; indx<Niter; indx++) {
    Tcode += Toff + Ipos(TLam, Td)*D(Tm,Td);
    Tn = TLamindx;
    Tm=Tm-Tn;
    Td = 0;
    TLamindx=0;
    for(indx2=0; indx2<Tn; indx2++) {
      Tvect[indx2] = Tvect[TLam[indx2]] - 1;
      if(Tvect[indx2]!=0) {
	Td++;
	TLam[TLamindx] = indx2;
	TLamindx++;
      }
    }
    Toff = Ioff(Td, Tm, Tn);
  }
  code += Soff*Tcode;
  return(code);
}



void factorial_unpack(int64 code, int len, int Np, int *retvector)
{
  int Nd;
  int64 Tcode;
  int64 Tpos;
  int64 pos;
  int Spos;
  int *posvect;
  int TNd;
  int Tlen;
  int indx;
  int signvector[L_MAXSIZE];
  int pv_offset;
  
  Tlen = len;
  
  for (indx=0; indx<Tlen; indx++) {
    retvector[indx]=0;
    signvector[indx]=1;
  }

  Nd=0;
  do {
    Tcode = Ioff_S(Nd, Np, Tlen);
    Nd++;
  } while(Tcode>code);
  Nd--;
  Spos = code & ((0x0001<<Nd) - 1);
  
  Tcode = (code-Ioff_S(Nd, Np, Tlen))>>Nd;
  pos = Tcode/D(Np,Nd);
  posvect = (int *)malloc(Nd*sizeof(int));
  for(indx=0; indx<Nd; indx++) {
    TNd=Nd-indx-1;
    while(F(TNd, Nd-indx)<=pos) {
      TNd++;
    }
    TNd--;
    posvect[Nd-indx-1]=TNd;
    retvector[TNd]++;
    signvector[TNd]=(Spos & (0x0001<<(indx)))?-1:1;
    pos=pos-F(TNd, Nd-indx);
  }
  
  Tcode = (code-Ioff_S(Nd, Np, Tlen))>>Nd;
  pos = Tcode/D(Np,Nd);
  code = Tcode - pos*D(Np,Nd);
  Np = Np - Nd;
  Tlen = Nd;
  pv_offset=Tlen;
  while(Np>0) {
    Nd=0;
    while(Ioff(Nd, Np, Tlen)>code) {
      Nd++;
    }
  
    Tcode = (code-Ioff(Nd, Np, Tlen));
    pos = Tcode/D(Np,Nd);
    for(indx=0; indx<Nd; indx++) {
      TNd=Nd-indx-1;
      while(F(TNd, Nd-indx) <= pos) {
	TNd++;
      }
      TNd--;
      retvector[posvect[TNd+pv_offset-Tlen]]++;
      posvect[pv_offset-indx-1]=posvect[TNd+pv_offset-Tlen];
      pos=pos-F(TNd, Nd-indx);
    }
    Tcode = (code-Ioff(Nd, Np, Tlen));
    pos = Tcode/D(Np,Nd);
    code = Tcode - pos*D(Np,Nd);
    Np = Np - Nd;
    Tlen = Nd;
  }
  for(indx=0; indx<len; indx++) {
    retvector[indx]=retvector[indx]*signvector[indx];
  }
  
  free(posvect);
}

