/**********************************************************************
Each of the companies; Motorola, and Lucent, and Qualcomm, and Nokia (hereinafter 
referred to individually as "Source" or collectively as "Sources") do 
hereby state:

To the extent to which the Source(s) may legally and freely do so, the 
Source(s), upon submission of a Contribution, grant(s) a free, 
irrevocable, non-exclusive, license to the Third Generation Partnership 
Project 2 (3GPP2) and its Organizational Partners: ARIB, CCSA, TIA, TTA, 
and TTC, under the Source's copyright or copyright license rights in the 
Contribution, to, in whole or in part, copy, make derivative works, 
perform, display and distribute the Contribution and derivative works 
thereof consistent with 3GPP2's and each Organizational Partner's 
policies and procedures, with the right to (i) sublicense the foregoing 
rights consistent with 3GPP2's and each Organizational Partner's  policies 
and procedures and (ii) copyright and sell, if applicable) in 3GPP2's name 
or each Organizational Partner's name any 3GPP2 or transposed Publication 
even though this Publication may contain the Contribution or a derivative 
work thereof.  The Contribution shall disclose any known limitations on 
the Source's rights to license as herein provided.

When a Contribution is submitted by the Source(s) to assist the 
formulating groups of 3GPP2 or any of its Organizational Partners, it 
is proposed to the Committee as a basis for discussion and is not to 
be construed as a binding proposal on the Source(s).  The Source(s) 
specifically reserve(s) the right to amend or modify the material 
contained in the Contribution. Nothing contained in the Contribution 
shall, except as herein expressly provided, be construed as conferring 
by implication, estoppel or otherwise, any license or right under (i) 
any existing or later issuing patent, whether or not the use of 
information in the document necessarily employs an invention of any 
existing or later issued patent, (ii) any copyright, (iii) any 
trademark, or (iv) any other intellectual property right.

With respect to the Software necessary for the practice of any or 
all Normative portions of the EVRC-B Variable Rate Speech Codec as 
it exists on the date of submittal of this form, should the EVRC-B be 
approved as a Specification or Report by 3GPP2, or as a transposed 
Standard by any of the 3GPP2's Organizational Partners, the Source(s) 
state(s) that a worldwide license to reproduce, use and distribute the 
Software, the license rights to which are held by the Source(s), will 
be made available to applicants under terms and conditions that are 
reasonable and non-discriminatory, which may include monetary compensation, 
and only to the extent necessary for the practice of any or all of the 
Normative portions of the EVRC-B or the field of use of practice of the 
EVRC-B Specification, Report, or Standard.  The statement contained above 
is irrevocable and shall be binding upon the Source(s).  In the event 
the rights of the Source(s) in and to copyright or copyright license 
rights subject to such commitment are assigned or transferred, the 
Source(s) shall notify the assignee or transferee of the existence of 
such commitments.
*******************************************************************/
#include <math.h>
#include "struct.h"
#include "macro.h"
#include "rom.h"
#include "proto.h"

#if MOT_SUPPRESSED_EIGHTH_RATE

#define MOT_ADJUST_BG_ESTIMATE 1


#ifndef SPEECH_BUFFER_LEN
#define SPEECH_BUFFER_LEN 160
#endif

/* These are defined in silence.cc.  Consider moving them to macro.h to avoid
 * multiple definitions
 */
#ifndef MAX_LOG_ENERGY
#define MAX_LOG_ENERGY	(2.6)	/* set to about 2.1 for is-127 equivalent */
#endif
#ifndef MIN_LOG_ENERGY
#define MIN_LOG_ENERGY	(0.2)
#endif
#ifndef LOG_ZERO_ENERGY
#define LOG_ZERO_ENERGY	(-2.0)
#endif

/*======================================================================*/
/*         ..For use when eighth rate frames are dropped.               */
/*----------------------------------------------------------------------*/
#define BBG_WINDOW_LEN 104
#define BBG_M 80
//#define BBG_DELAY 24
#define BBG_FFTLEN 128

#define BBG_ALPHA 0.82
#define BBG_BETA1 0.60
#define BBG_BETA1_MINUS1 -0.40
#define BBG_BETA2 0.9925
#define BBG_BETA2_MINUS1 -0.0075
#define BBG_BETA2r 0.794
#define BBG_MIN_LEVEL -15

extern float ran0(long *seed0);
extern void r_fft_flt(float *ptr, int isign);

//#define BBG_NUM_CHAN 16

#if 1
/* This should be defined global or in the class so it can be
 * shared with preproc.cc
 */
  static int	ch_tbl[BBG_NUM_CHAN][2] = {
    
    { 2,  3},
    { 4,  5},	
    { 6,  7},
    { 8,  9},
    {10, 11},
    {12, 13},
    {14, 16},
    {17, 19},
    {20, 22},
    {23, 26},
    {27, 30},
    {31, 35},
    {36, 41},
    {42, 48},
    {49, 55},
    {56, 63}
  };

/* This can be replaced by the window[] variable in the class, but we need to
 * be sure that init_window() in preproc.cc is called before being used here.
 * For now define a copy here.
 */
static float BBG_window[BBG_WINDOW_LEN] = {
  0.001068, 0.009613, 0.026520, 0.051575,
  0.084259, 0.124084, 0.170319, 0.222198,
  0.278839, 0.339264, 0.402435, 0.467285,
  0.532684, 0.597534, 0.660706, 0.721130,
  0.777771, 0.829651, 0.875885, 0.915710,
  0.948395, 0.973450, 0.990356, 0.998901,
  0.999969, 0.999969, 0.999969, 0.999969,
  0.999969, 0.999969, 0.999969, 0.999969,
  0.999969, 0.999969, 0.999969, 0.999969,
  0.999969, 0.999969, 0.999969, 0.999969,
  0.999969, 0.999969, 0.999969, 0.999969,
  0.999969, 0.999969, 0.999969, 0.999969,
  0.999969, 0.999969, 0.999969, 0.999969,
  0.999969, 0.999969, 0.999969, 0.999969,
  0.999969, 0.999969, 0.999969, 0.999969,
  0.999969, 0.999969, 0.999969, 0.999969,
  0.999969, 0.999969, 0.999969, 0.999969,
  0.999969, 0.999969, 0.999969, 0.999969,
  0.999969, 0.999969, 0.999969, 0.999969,
  0.999969, 0.999969, 0.999969, 0.999969,
  0.998901, 0.990356, 0.973450, 0.948395,
  0.915710, 0.875885, 0.829651, 0.777771,
  0.721130, 0.660706, 0.597534, 0.532684,
  0.467285, 0.402435, 0.339264, 0.278839,
  0.222198, 0.170319, 0.124084, 0.084259,
  0.051575, 0.026520, 0.009613, 0.001068
};

/* Consider using ftreal() instead. For now define r_fft_flt here. */

#endif

//static void update_bgestimate(short *buf16, int rate, float walpha)
void FGV_MEM::update_bgestimate(float *bufF, int rate, float walpha)
  {
  static int firstTime = 1;
  float s_m[BBG_FFTLEN];
  //static float bbg_window_overlap[BBG_DELAY];
  float E_ch[BBG_NUM_CHAN+2];
  float *s_m_ptr;
  float *win_ptr;
  int indx;
  float tmpF;

  if (firstTime)
    {
    /* Move these to init_bbg() */
    firstTime = 0;
    for (indx=0; indx<BBG_DELAY; indx++)
      {
      bbg_window_overlap[indx] = 0;
      }
    for (indx=0; indx<BBG_NUM_CHAN+2; indx++)
      {
      E_bgn[indx] = -10.0;
      E_ch_mem[indx] = 0.0;
      E_bgn_smooth[indx] = -10.0;
      }
    }

  /* Do actual update in this section */
  BBG_frmSkipCnt++;

  /* Process first "subframe" of 80 samples */
  s_m_ptr = &s_m[0];
  win_ptr = &BBG_window[0];
  for (indx=0; indx<BBG_DELAY; indx++)
    {
    (*s_m_ptr++) = bbg_window_overlap[indx] * (*win_ptr++);
    }
  for (indx=0; indx<BBG_M; indx++)
    {
    (*s_m_ptr++) = bufF[indx] * (*win_ptr++);
    }
  for (indx=0; indx<BBG_FFTLEN-(BBG_M+BBG_DELAY); indx++)
    {
    (*s_m_ptr++) = 0;
    }
  for (indx=0; indx<BBG_DELAY; indx++)
    {
    bbg_window_overlap[indx] = bufF[BBG_M - BBG_DELAY + indx];
    }
  if (rate == 1)
    {
    /* There seems to be a 4-6dB drop in energy when an eighth rate
     * packet is decoded, reencoded, and then decoded again.
     * Compensate for that before reenconding. */
    s_m_ptr = &s_m[0];
    for (indx=0; indx<BBG_M; indx++)
      {
      (*s_m_ptr++) = 2*(*s_m_ptr);
      }
    for (indx=0; indx<BBG_DELAY; indx++)
      {
      bbg_window_overlap[indx] = 2*bbg_window_overlap[indx];
      }
    }

  /* Compute fft of real signal */
  r_fft_flt(s_m, +1);

  /* Now compute magnitude in dB */
  for (indx=0; indx<BBG_FFTLEN/2; indx++)
    {
    tmpF = s_m[2*indx]*s_m[2*indx] + s_m[2*indx+1]*s_m[2*indx+1];
    if (tmpF<0.0001)
      {
      tmpF = 0.0001;
      }
    s_m[indx] = 10.0*log10(tmpF);
    }
  if (BBG_frmSkipCnt < 3)
    {
    int chan;
    int j1, j2;
    j1 = ch_tbl[0][0];
    for (indx=0; indx<j1; indx++)
      {
      E_ch[indx] = s_m[indx];
      }
    for (chan=0; chan<BBG_NUM_CHAN; chan++)
      {
      j1 = ch_tbl[chan][0];
      j2 = ch_tbl[chan][1];
      tmpF = 0;
      for (indx=j1; indx<=j2; indx++)
	{
	tmpF += s_m[indx];
	}
      tmpF = tmpF/(float)(j2-j1+1);
      E_ch[chan+2] = tmpF;
      }
    for (indx=0; indx<BBG_NUM_CHAN+2; indx++)
      {
      E_bgn[indx] = E_ch[indx];
      if (E_bgn[indx]<BBG_MIN_LEVEL)
	{
	E_bgn[indx] = BBG_MIN_LEVEL;
	E_ch[indx] = E_bgn[indx];
	}
#if 1
      /* Initialization was done without bin grouping. Fixed here.*/
      E_ch_mem[indx] = E_ch[indx];
#endif
      }
    }
  else
    {
    int chan;
    int j1, j2;
    j1 = ch_tbl[0][0];
    for (indx=0; indx<j1; indx++)
      {
      E_ch[indx] = s_m[indx];
      }
    for (chan=0; chan<BBG_NUM_CHAN; chan++)
      {
      j1 = ch_tbl[chan][0];
      j2 = ch_tbl[chan][1];
      tmpF = 0;
      for (indx=j1; indx<=j2; indx++)
	{
	tmpF += s_m[indx];
	}
      tmpF = tmpF/(float)(j2-j1+1);
      E_ch[chan+2] = tmpF;
      }
    walpha = walpha*BBG_ALPHA;

    if (rate == 1)
      {
      walpha = walpha*0.6;
      for (indx=0; indx<BBG_NUM_CHAN+2; indx++)
	{
	E_ch_mem[indx] = walpha*E_ch_mem[indx] + (1.0-walpha)*E_ch[indx];
	}
      }
    else
      {
      for (indx=0; indx<BBG_NUM_CHAN+2; indx++)
	{
	E_ch_mem[indx] = walpha*E_ch_mem[indx] + (1.0-walpha)*(E_ch[indx]+20*log10(1.5));
	}
      }
    }

  if (rate == 1)
    {
    for (indx=0; indx<BBG_NUM_CHAN+2; indx++)
      {
      E_bgn[indx] = BBG_BETA1*E_ch_mem[indx] + (1-BBG_BETA1)*E_ch[indx];
      }
    }
  else
    {
    for (indx=0; indx<BBG_NUM_CHAN+2; indx++)
      {
      if (E_ch_mem[indx]<E_bgn[indx])
	{
#if 1
	if (E_ch_mem[indx]>BBG_MIN_LEVEL)
	  {
	  E_bgn[indx] = E_ch_mem[indx];
	  }
	else
	  {
	  E_bgn[indx] = BBG_MIN_LEVEL;
	  E_ch_mem[indx] = E_bgn[indx];
	  }
#else
	E_bgn[indx] = E_ch_mem[indx];
#endif
	}
      else
	{
	/* Prevent noise floor from rising too fast when signal is suspected
	 * to be high energy speech.
	 */
	  if ((E_ch_mem[indx]-E_bgn[indx])>12)
	    {
//	    E_bgn[indx] += 0.01;
	    E_bgn[indx] += 0.0078;
	    }
	  else
	    {
//	    E_bgn[indx] += 0.02;
	    E_bgn[indx] += 0.0234;
	    }
	}
      }
    }

  }


/*
 * Generates noise using estimated background noise shape
 */
//static void gen_bg_fromestimate(float *bufF)
void FGV_MEM::gen_bg_fromestimate(float *bufF)
  {
  int indx;
  static long seed0 = 19267;
  static float X_dec_ph[2];
  static float X_dec_overlap[BBG_DELAY];
  float X_dec[BBG_FFTLEN];
  float tmpF;
  int chan;
  int j1, j2;

#if 1
  /* SMOOTH E_BGN BEFORE RE-GENERATING COMFORT NOISE */
  if (BBG_frmSkipCnt2 < 10) // Wait for first true estimate
    {
    BBG_frmSkipCnt2++;
    for (indx=0; indx<(BBG_NUM_CHAN+2); indx++)
      {
      E_bgn_smooth[indx] = BBG_BETA2r*E_bgn_smooth[indx] + (1-BBG_BETA2r)*E_bgn[indx];
      }
    }
  else
    {
    for (indx=0; indx<(BBG_NUM_CHAN+2); indx++)
      {
      E_bgn_smooth[indx] = BBG_BETA2*E_bgn_smooth[indx] + (1-BBG_BETA2)*E_bgn[indx];
      }
    }
#endif

  X_dec[0] = 0;
  X_dec[1] = 0;
  tmpF = ran0(&seed0);
  X_dec_ph[0] = cos(2*PI*tmpF);
  X_dec_ph[1] = sin(2*PI*tmpF);
/* USE SMOOTHED E_BGN FOR RE-GENERATING COMFORT NOISE */
  tmpF = pow(10.0, E_bgn_smooth[1]/20.0);
  X_dec[2] = tmpF * X_dec_ph[0];
  X_dec[2+1] = tmpF * X_dec_ph[1];

  for (chan=0; chan<(BBG_NUM_CHAN); chan++)
    {
    j1 = ch_tbl[chan][0];
    j2 = ch_tbl[chan][1];
    for (indx=j1; indx<=j2; indx++)
      {
      tmpF = ran0(&seed0);
      X_dec_ph[0] = cos(2*PI*tmpF);
      X_dec_ph[1] = sin(2*PI*tmpF);
      tmpF = pow(10.0, E_bgn_smooth[chan+2]/20.0);
      X_dec[2*indx] = tmpF * X_dec_ph[0];
      X_dec[2*indx+1] = tmpF * X_dec_ph[1];
      }
    }
  r_fft_flt(X_dec, -1);

  if (BBG_frmSkipCnt < 1)	// Wait for first true estimate
    {
    for (indx=0; indx<(BBG_M+BBG_DELAY); indx++)
      {
//      X_dec[indx] = 12.0*(ran0(&seed0) - 0.5);
      X_dec[indx] = 12.0*(ran0(&seed0) - 0.5);
      }
    }
  for (indx=0; indx<BBG_M+BBG_DELAY; indx++)
    {
    X_dec[indx] = X_dec[indx]*BBG_window[indx];
    }
  for (indx=0; indx<BBG_DELAY; indx++)
    {
    X_dec[indx] += X_dec_overlap[indx];
    X_dec_overlap[indx] = X_dec[indx+BBG_M];
    }

  for (indx=0; indx<BBG_M; indx++)
    {
    tmpF = (X_dec[indx]<-32768.0)?(-32768.0):(X_dec[indx]);
    tmpF = ((tmpF+0.5)>32767.0)?(32767.0):(tmpF+0.5);
    bufF[indx] = tmpF;
    }

  }


static float speechBufHist[GUARD+LOOKAHEAD_LEN];

//static void bbg_eighth_rate_encode(float inBufF[SPEECH_BUFFER_LEN], short *outBuf16)
void FGV_MEM::bbg_eighth_rate_encode(float inBufF[SPEECH_BUFFER_LEN], short *outBuf16)
  {
  register int i, j;
  float lpc_noise[ORDER];
  float lsp_noise[ORDER];
  float lspQ_noise[ORDER];
  float H_noise[Hlength];
  float lpc_i[ORDER];
  float lsp_i[ORDER];
  short lspindx[2];
  int sf;
  int sfSize;
  int indx;
  float sum;
  float scale;
  float Sum[3];
  float tmp;
  int best;
  float lresidual[SubFrameSize];
  float speechBuf[GUARD+FrameSize+LOOKAHEAD_LEN];
  float maxEnergy;
  float resmem[ORDER];
  float tmpScratch[ORDER+1];
  float tmpRs[17];
  float D;

  PktPtr[0]=16;
  PktPtr[1]=0;
  for (indx=0; indx<PACKWDSNUM; indx++)
    {
    RxPkt[indx]=0;
    }

#if 1
  /* Process Data */
  for (j = 0; j < FrameSize; j++)
    {
    speechBuf[j + GUARD + LOOKAHEAD_LEN] = inBufF[j];
    }
  
  /* Make sure HPspeech - HPspeech+2*GUARD have the right memory */
  for (j=0; j<GUARD+LOOKAHEAD_LEN; j++)
    {
    speechBuf[j] = speechBufHist[j];
    }

  /* Update ConstHPspeech for next frame */
  for (j=0; j<GUARD+LOOKAHEAD_LEN; j++)
    {
    speechBufHist[j] = speechBuf[j+GUARD+LOOKAHEAD_LEN];
    }


#else
  /* Process Data */
  for (j = 0; j < FrameSize + LOOKAHEAD_LEN; j++)
  {
    speechBuf[j + GUARD] = inBufF[j];
  }
  
  /* Make sure HPspeech - HPspeech+2*GUARD have the right memory */
  for (j=0; j<GUARD; j++)
  {
	  speechBuf[j] = speechBufHist[j];
  }

  /* Update ConstHPspeech for next frame */
  for (j=0; j<GUARD; j++)
  {
	  speechBufHist[j] = speechBuf[j + FrameSize];
  }

#endif

  /* Run lpcanalysis on generated noise */
  lpcanalys(lpc_noise, tmpScratch, speechBuf, ORDER, LPC_ANALYSIS_WINDOW_LENGTH, tmpRs);
  /* Bandwidth expansion */
  weight(lpc_noise, lpc_noise, _Gamma_4, ORDER);
  /* Convert to lsp */
  a2lsp(lsp_noise, lpc_noise);
  /* Quantize lsps using eighth rate quantizer */
  lspmaq(lsp_noise, ORDER, 1, 2, nsub8, nsize8,
      0.5, lspQ_noise, lspindx, 0, lsptab8);
  for (indx=0; indx < 2; indx++)
    {
    Bitpack(lspindx[indx],
	(unsigned short *)RxPkt,
	lognsize8[indx], PktPtr);
    }

  for (indx=0; indx<ORDER; indx++)
    {
    resmem[indx] = 0;
    }

  lsp2a(lpc_i, OldlspD);

  for (sf=0; sf < NoOfSubFrames; sf++)
    {
    // This should be moved inside if statement below, and use sf+1 for sf<2
    Interpol(lsp_i, OldlspD, lspQ_noise, sf, ORDER);
    //using lspQ_noise above instead of the previously used lsp_noise
    // to ensure the LSP used to compute the residual signal and the
    //impulse response energy are the same
    lsp2a(lpc_i, lsp_i);
    if (sf < 2)
      {
      sfSize = SubFrameSize - 1;
      }
    else
      {
      sfSize = SubFrameSize;
      }
//    GetResidual(lresidual+sf*(SubFrameSize - 1),
    GetResidual(lresidual,
	&inBufF[sf*(SubFrameSize - 1)], lpc_i,
	resmem, ORDER, sfSize);

#if 1
    scale = pow(10.0, FIXED_EIGHTH_RATE_ATTEN_AMT/20.0);
    scale = scale * 1.1;
#else
    Interpol(lsp_i, OldlspD, lspQ_noise, sf, ORDER);
    /* Convert to lpcs */
    lsp2a(lpc_i, lsp_i);

    /* Get lpc gain */
    /* Generate impulse response */
    ImpulseRzp(H_noise, lpc_i, lpc_i, 1.0, 1.0, ORDER, Hlength);

    /* Get energy of H */
    sum = 0.0;
    for (indx=0; indx<sfSize; indx++)
      {
      sum += H_noise[indx]*H_noise[indx];
      }
    scale = sqrt(sum);
#endif
   
    sum = 0;
    for (indx=0; indx<sfSize; indx++)
      {
      sum += fabs(lresidual[indx]);
      }
    sum = sum/sfSize;
    sum = sum*2;	//EMCZ manual adjust for testing only
#if 1
    sum = sum*(0.707/0.656);
//    sum = sum*(0.707/0.656);
#endif
    if (sum<1)
      {
      sum = 1;
      }
    Sum[sf] = log10(sum/scale);
    }

  maxEnergy = Sum[0];
  for (sf=1; sf<NoOfSubFrames; sf++)
    {
    if (Sum[sf] > maxEnergy)
      {
      maxEnergy = Sum[sf];
      }
    }

  sum = 1e30;
  for (i = 0; i < NUM_Q_LEVELS; i++)
    {
    D = maxEnergy - (MIN_LOG_ENERGY + (float)i * (MAX_LOG_ENERGY - MIN_LOG_ENERGY)/(float)NUM_Q_LEVELS);
    tmp = D * D;
    if (tmp < sum)
      {
      best=i;
      sum=tmp;
      }
    }

  Bitpack(best, (unsigned short *)RxPkt, NUM_EQ_BITS, PktPtr);

  for (indx = 0; indx < PACKWDSNUM; indx++)
    {
    outBuf16[indx] = RxPkt[indx];
    }
  }



/*
 * Updates the background noise envelope shape
 */
//void update_bbg_estimate(short *buf16, int rate, float walpha)
void FGV_MEM::update_bbg_estimate(float *bufF, int rate, float walpha)
  {

  update_bgestimate(bufF, rate, walpha);
  update_bgestimate(&bufF[SPEECH_BUFFER_LEN/2], rate, walpha);
  }



void FGV_MEM::gen_encode_bbg(short *buf16)
  {
  float bufF[SPEECH_BUFFER_LEN];

  gen_bg_fromestimate(bufF);
  gen_bg_fromestimate(&bufF[80]);

  bbg_eighth_rate_encode(bufF, buf16);
  }


void FGV_MEM::init_bbg()
  {
  unsigned int indx;
  /* Clear out memory for bbg_eighth_rate_encode */
    for (indx=0; indx<GUARD; indx++)
      {
      speechBufHist[indx] = 0;
      }
  BBG_frmSkipCnt=0;
  BBG_frmSkipCnt2=0;
  }




#endif //MOT_SUPPRESSED_EIGHTH_RATE
