/**********************************************************************
Each of the companies; Motorola, and Lucent, and Qualcomm, and Nokia (hereinafter 
referred to individually as "Source" or collectively as "Sources") do 
hereby state:

To the extent to which the Source(s) may legally and freely do so, the 
Source(s), upon submission of a Contribution, grant(s) a free, 
irrevocable, non-exclusive, license to the Third Generation Partnership 
Project 2 (3GPP2) and its Organizational Partners: ARIB, CCSA, TIA, TTA, 
and TTC, under the Source's copyright or copyright license rights in the 
Contribution, to, in whole or in part, copy, make derivative works, 
perform, display and distribute the Contribution and derivative works 
thereof consistent with 3GPP2's and each Organizational Partner's 
policies and procedures, with the right to (i) sublicense the foregoing 
rights consistent with 3GPP2's and each Organizational Partner's  policies 
and procedures and (ii) copyright and sell, if applicable) in 3GPP2's name 
or each Organizational Partner's name any 3GPP2 or transposed Publication 
even though this Publication may contain the Contribution or a derivative 
work thereof.  The Contribution shall disclose any known limitations on 
the Source's rights to license as herein provided.

When a Contribution is submitted by the Source(s) to assist the 
formulating groups of 3GPP2 or any of its Organizational Partners, it 
is proposed to the Committee as a basis for discussion and is not to 
be construed as a binding proposal on the Source(s).  The Source(s) 
specifically reserve(s) the right to amend or modify the material 
contained in the Contribution. Nothing contained in the Contribution 
shall, except as herein expressly provided, be construed as conferring 
by implication, estoppel or otherwise, any license or right under (i) 
any existing or later issuing patent, whether or not the use of 
information in the document necessarily employs an invention of any 
existing or later issued patent, (ii) any copyright, (iii) any 
trademark, or (iv) any other intellectual property right.

With respect to the Software necessary for the practice of any or 
all Normative portions of the EVRC-B Variable Rate Speech Codec as 
it exists on the date of submittal of this form, should the EVRC-B be 
approved as a Specification or Report by 3GPP2, or as a transposed 
Standard by any of the 3GPP2's Organizational Partners, the Source(s) 
state(s) that a worldwide license to reproduce, use and distribute the 
Software, the license rights to which are held by the Source(s), will 
be made available to applicants under terms and conditions that are 
reasonable and non-discriminatory, which may include monetary compensation, 
and only to the extent necessary for the practice of any or all of the 
Normative portions of the EVRC-B or the field of use of practice of the 
EVRC-B Specification, Report, or Standard.  The statement contained above 
is irrevocable and shall be binding upon the Source(s).  In the event 
the rights of the Source(s) in and to copyright or copyright license 
rights subject to such commitment are assigned or transferred, the 
Source(s) shall notify the assignee or transferee of the existence of 
such commitments.
*******************************************************************/

static char const rcsid[]="$Id: //E-XMS/GIT/csa/Utilities/cpp/RtpCodecUtil/evrc_b/celp.cpp#1 $";

/*======================================================================*/
/*  4GV - Fourth Generation Vocoder Speech Service Option for             */
/*  Wideband Spread Spectrum Digital System                             */
/*  C Source Code Simulation                                            */
/*                                                                      */
/*  Copyright (C) 1999 Qualcomm Incorporated. All rights                */
/*  reserved.                                                           */
/*----------------------------------------------------------------------*/

#ifdef WIN32
#include <iostream>
using namespace std;
#endif

/* This is the original EVRC full rate coder with ACELP */
#include  "macro.h"
#include  "proto.h"
#include  "rom.h"
#include  "acelp.h"	/* for ACELP fixed codebook */
#include  "struct.h"
#include  "lu_mod.h"


#ifdef NEWMALSPVQ3
//extern float cbprevprev_E3[LPCORDER],cbprev_E3[LPCORDER];
#endif //NEWMALSPVQ3


void FGV_MEM::celp_encoder(int bit_rate)
{
  register int i, j, n;
  float   delayi[3];
  short   subframesize;
  short   Aveidxppg;
  float   sum1;
  float   tmpf;

  // Gain Quantization Setups
  if (bit_rate==3)
    {FCBGainSize=16; gnvq=gnvq_4;}
  else
    {FCBGainSize=32; gnvq=gnvq_8;}
  
  // LSP Quantization
  float tmplsi[ORDER], tmplsc[ORDER];
  if (bit_rate==3) {
    knum=3;
    enc_lsp_vq_22(lsp_nq, SScratch, lsp);
    for (i=0; i<knum; i++)
      data_packet.LSP_IDX[i]=SScratch[i];
  }
  else {
    knum=4;
    enc_lsp_vq_28(lsp_nq, SScratch, lsp);
    for (i=0; i<knum; i++)
      data_packet.LSP_IDX[i]=SScratch[i];
  }
#ifdef NEWMALSPVQ
    for (i=0;i<ORDER;i++) cbprevprev_E[i]=cbprev_E[i]=lsp[i];    
#else //NEWMALSPVQ
#ifdef NEWMALSPVQ3
    for (i=0;i<ORDER;i++) cbprevprev_E3[i]=cbprev_E3[i]=lsp[i];    
#endif//NEWMALSPVQ3
  /* Compute lsi for backing up for MA LPC in PPP */
  for (i=0; i<ORDER; i++) tmplsc[i]=cos(pi2*lsp[i]);
  for (i=0;i<ORDER;i++)
    tmplsi[i]=(tmplsc[i]<0.)+(SIGN(tmplsc[i]))*0.5*sqrt(1-fabs(tmplsc[i]));
  for (i=0;i<ORDER;i++) cbprevprev_E[i]=cbprev_E[i]=tmplsi[i];  
#endif //NEWMALSPVQ

 
#ifdef LSP_SPRD
    lsp_spread(lsp);
#endif
  
  /* copied quantized LSPs */
  //extern float global_lsp[ORDER];
  for (j=0;j<ORDER;j++) global_lsp[j]=lsp[j];
  

#ifdef USE_RCELP_WITH_UQ_LSP
  for (i=0;i<ORDER;i++) GetResidualFIRmem[i]=mspeech[FrameSize-1-i];
#else //USE_RCELP_WITH_UQ_LSP
  /* Compute residual with quantized LSPs */
  /* Get residual signal */
  for (j=0; j<ORDER; j++) Scratch[j]=0;	/* Scratch is used as filter memory */

  lsp2a(pci, OldlspE);
  
  GetResidual(residual, HPspeech, pci, Scratch, ORDER, GUARD);
  
  for (i=0; i<NoOfSubFrames; i++) {
    
    Interpol(lspi, OldlspE, lsp, i, ORDER);
    lsp2a(pci, lspi);
    if (i < 2)
      GetResidual(residual + i * (SubFrameSize - 1) + GUARD,
		  HPspeech + i * (SubFrameSize - 1) + GUARD, pci, Scratch,
		  ORDER, SubFrameSize - 1);
    else
      GetResidual(residual + i * (SubFrameSize - 1) + GUARD,
		  HPspeech + i * (SubFrameSize - 1) + GUARD, pci, Scratch,
		  ORDER, SubFrameSize);
  }
  
  lsp2a(pci,lsp);
  GetResidual(residual + FrameSize + GUARD,
	      HPspeech + FrameSize + GUARD, pci,Scratch, ORDER, GUARD);

  // Start Full/Half CELP Processing
  
  //Do standalone RCELP - to get modified res, mod. speech, mod wspeech
  get_rcelp();
#endif //USE_RCELP_WITH_UQ_LSP
  
  Aveidxppg = 0;
  
  /*********************************
   * CELP codebook search procedure *
   *********************************/
  for (i=0; i<NoOfSubFrames; i++) {
    
    if (i < 2) subframesize = SubFrameSize - 1;
    else subframesize = SubFrameSize;

    /* interpolate lsp */
    Interpol(lspi, OldlspE, lsp, i, ORDER);
    Interpol(lspi_nq, Oldlsp_nq, lsp_nq, i, ORDER);
    
    /* Convert lsp to PC */
    lsp2a(pci, lspi);
    lsp2a(pci_nq, lspi_nq);
    
    /* Get zir */
    ZeroInput(zir,pci_nq,pci,Excitation+ACBMemSize,GAMMA_1,GAMMA2,ORDER,
	      subframesize,0);

    /* Calculate impulse response of 1/A(z) * A(z/g1) / A(z/g2) */
    ImpulseRzp(H, pci_nq, pci, GAMMA_1, GAMMA2, ORDER, Hlength);
    

    
    /* Interpolate delay */
    Interpol_delay(delayi, &pdelay, &delay, i);
    
    for (j=0;j<subframesize;j++)
       residualm[j]=residualm_frame[i*(SubFrameSize-1)+j];
    //get excitation, by extending ACB
    putacbc(Excitation+ACBMemSize,Excitation+ACBMemSize,0,subframesize,10,delayi,BLFREQ,BLPRECISION);

    
  /*   
     for (j=0;j<subframesize;j++)
      residualm[j]=residual[GUARD+i*(SubFrameSize-1)+j];
 */   
    


   # ifdef RES
    for(j=0;j<subframesize;j++)
      printf("%f\n",residual[GUARD+i*(SubFrameSize-1)+j]);
   # endif



   # ifdef MRES
    for(j=0;j<subframesize;j++)
      printf("%f\n",residualm[j]);
   # endif

    for (j=0;j<subframesize;j++) copy[i*(SubFrameSize-1)+j]=residualm[j];
             
    //origm being copied into only for writing out target_speech_out
    for (j=0;j<subframesize;j++) origm[j]=mspeech[i*(SubFrameSize-1)+j];

    for (j=0;j<subframesize;j++) worigm[j]=wspeech[i*(SubFrameSize-1)+j];

    
    /* Remove Zero input response from weighted speech */
    for (j=0; j<subframesize; j++) worigm[j] -= zir[j];

    /* Calculate closed loop gain */
    getgain(Excitation + ACBMemSize, &sum1, H, &idxppg, ppvq, ppvq_mid,
	    ACBGainSize, 1, worigm, subframesize, Hlength);
    
    Aveidxppg += idxppg;
    
    /* Get TARGET for fixed c.b. */
    /* Convolve excitation with H */
    /* ExconvH stored in Scratch memory */
    ConvolveImpulseR(ExconvH,Excitation+ACBMemSize,H,Hlength,subframesize);
    for (j=0; j<subframesize; j++) TARGETw[j] = worigm[j] - ExconvH[j];
    for (;j<SubFrameSize;j++) TARGETw[j]=0.0; //to avoid UMR in Weight2Res function

    /* Convert TARGET from weighted domain to residual domain */
    Weight2Res(TARGET,TARGETw,pci_nq,pci,GAMMA_1,GAMMA2,ORDER,SubFrameSize);

    if (subframesize < SubFrameSize)
      TARGETw[subframesize]=TARGET[subframesize]=Scratch[subframesize]=0.0;

    /* get delay for current subframe */
    n = (short) ((delayi[1] + delayi[0]) / 2.0 + 0.5);
    /* Compute fixed codebook contribution */
    if (n > subframesize) n = 200;

    if (bit_rate==4) {
      /* ACELP fixed codebook search */
      ACELP_Code(TARGETw, TARGET, H, (int) n, sum1, subframesize, Scratch,
		 &fcbGain, y2, fcbIndexVector, 1);
    }
    else {//bit_rate==3 case
      cod3_10jcelp(TARGETw, H, (int)n, ppvq[idxppg], subframesize, Scratch, &fcbGain, fcbIndexVector);
    }
   
    
    /* constrain fcb gain */
    fcbGain *= (1.0 - ppvq[idxppg] * 0.15);
    
    if (lastrateE<=2 ) {
      if (i==0)
	fcbGain *= 0.45;
      else if (i==1)
	fcbGain *= 0.7 ;
      else	
	fcbGain *= 0.85;
    }
    /* quantize fcb gain */
    for (idxcbg=0,j=1; j<FCBGainSize; ++j) {
      if (fcbGain > (gnvq[j] + gnvq[j - 1]) / 2.0) idxcbg = j;
    }
    fcbGain = gnvq[idxcbg];
    
    /* Add to total excitation */
    for (j=0; j<subframesize; j++)Excitation[j+ACBMemSize]+=Scratch[j]*fcbGain;


    /* Update filters memory */
    ZeroInput(zir, pci_nq, pci, Excitation + ACBMemSize, GAMMA_1, GAMMA2, ORDER,
	      subframesize, 1);

    //even though this is done already in get_rcelp
    //we need to do this for next frame (i.e. effective
    // in the last sf of this frame) because we are
    //clobbering the state variable residualm (used
    //used by RCELP) just to be able to continue to print
    // out mform_res (diagnostic, if you dont care about
    // this diagnostic printout, you dont have to ahve
    //the following line....but you need to remember to
    // remove the clobbering of residualm...ie. dont
    // dont use residualm in celp)
    /* Update residualm */
    for (j=0; j<dpm; j++) residualm[j] = residualm[j + subframesize];

    /* Update excitation */
    for (j=0; j<ACBMemSize; j++) Excitation[j] = Excitation[j + subframesize];

    if (bit_rate==4) {
      /* Pack bits */
      /* ACB gain index */
      data_packet.ACBG_IDX[i]=idxppg;
      idxcb = fcbIndexVector[0];
      data_packet.FCB_PULSE_IDX[i][0]=idxcb;
      idxcb = fcbIndexVector[1];
      data_packet.FCB_PULSE_IDX[i][1]=idxcb;
      idxcb = fcbIndexVector[2];
      data_packet.FCB_PULSE_IDX[i][2]=idxcb;
      idxcb = fcbIndexVector[3];
      data_packet.FCB_PULSE_IDX[i][3]=idxcb;
      /* FCB gain index */
      data_packet.FCBG_IDX[i]=idxcbg;
    }
    else {//bit_rate==3 case
      /* Pack bits */
      /* ACB gain index */
      data_packet.ACBG_IDX[i]=idxppg;
      idxcb = fcbIndexVector[0];
      //Bitpack(idxcb, (unsigned short *) PackedWords, 11, PackWdsPtr);
      data_packet.FCB_PULSE_IDX[i][0]=idxcb;
      /* FCB gain index */
      data_packet.FCBG_IDX[i]=idxcbg;
    }
  }
  
  
  pdelay = delay;

  //packing routine
  PktPtr[0]=16;PktPtr[1]=0;

  if (bit_rate==4){//full rate
    data_packet.PACKET_RATE=4; data_packet.MODE_BIT=0;
  }
  else{ //for(bit_rate==3) 
    data_packet.PACKET_RATE=3;
  }
}


short FGV_MEM::celp_decoder(float *outFbuf,short post_filter,int bit_rate,
				   short run_length, short phase_offset, float	time_warp_fraction, short*	obuf_len)
{
  register int i, j, n;
  register float *foutP;
  float   delayi[3];
  short   subframesize;
  float   sum1;
  float   sum_acb;
  float   PitchMemoryD_Frame[160*2]; //Phase Matching: Increased size to support PM, Warping
  DTFS    LAST_BAD_CW;
  bool    local_lpc_flag=FALSE;
  
  float   g2;  // For 2nd pitch filter
  //extern char LAST_PPP_MODE_D;
  //extern int prev_rcelp_half;

  //Variables used for Phase Matching and Warping

  short		do_phase_matching = 0;
  int		num_residual = 160;
  int		pm_var1 = 0, pm_var2;
  int		temp_samples_count = 0;
  int		num_samples;
  float		temp_pitch[320];
  int		b, c, merge_start, merge_end, merge_stop, sample_counter;
  float		store_ddelay;

  float prev_ave_fcb_gain=0.0,curr_ave_acb_gain=0.0;
  int ct=0;

  //End Variables used for Phase Matching and Warping
 
  if (phase_offset != 10) //Phase Offset == 10 denotes Phase Matching disabled
	do_phase_matching = 1; //check for Phase Matching

  LAST_BAD_CW.lag=0;
  
  // Gain Quantization Setups
  if (bit_rate==3)
    {FCBGainSize=16; gnvq=gnvq_4;}
  else
    {FCBGainSize=32; gnvq=gnvq_8;
    //gautam:check to see if mode bit rate is 4
//    if(data_packet.MODE_BIT!=0){
//      cerr<<"The mode bit rate is not set to 0 in Frame no :"<<decode_fcnt<<"\n";
//    }
}

  // LSP De-Quantization
  float tmplsi[ORDER], tmplsc[ORDER];
  if (bit_rate==3) {
    dec_lsp_vq_22((short int *)data_packet.LSP_IDX, lsp);
  }
  else {
    dec_lsp_vq_28((short int *)data_packet.LSP_IDX, lsp);
  }

  /* Check for monontonic LSP */
  for (j=1; j<ORDER; j++) if (lsp[j] <= lsp[j - 1]) errorFlag=1;  
#ifdef NEWMALSPVQ
    for (i=0;i<ORDER;i++) cbprevprev_D[i]=cbprev_D[i]=lsp[i];    
#else //NEWMALSPVQ
  /* Compute lsi for backing up for MA LPC in PPP */
  for (i=0; i<ORDER; i++) tmplsc[i]=cos(pi2*lsp[i]);
  for (i=0;i<ORDER;i++)
    tmplsi[i]=(tmplsc[i]<0.)+(SIGN(tmplsc[i]))*0.5*sqrt(1-fabs(tmplsc[i]));
  for (i=0;i<ORDER;i++) cbprevprev_D[i]=cbprev_D[i]=tmplsi[i];
#endif //NEWMALSPVQ



#ifdef LSP_SPRD
   lsp_spread(lsp);
#endif
      
      
  // Do CELP Decoding
  
  data_packet.DELAY_IDX += DMIN;
  delay = (float) data_packet.DELAY_IDX;

  store_ddelay = data_packet.DELTA_DELAY_IDX; //Phase Matching: need to store ddelay

  if (lastrateD <3) pdelayD=delay;
  
  /* Fix delay countour of previous erased frame */
  // Fix delay contour only if no Phase Matching; else PM fixes it anyway

  if (do_phase_matching)
	LAST_BAD_CW.to_fs(PitchMemoryD+ACBMemSize-(int)pdelayD,(int)pdelayD);

  if (!do_phase_matching)
  {
	if (fer_counter==2) {
		float lpc_gain1, lpc_gain2;
		float LPCG_THD;

		if (lastrateD==4) LPCG_THD=2.5; 
		else LPCG_THD=5.0;
	    
		lsp2a(pci,OldlspD);
		ImpulseRzp(H, pci, pci, 1.0, 1.0, ORDER, Hlength);
		/* Get energy of H */
		for (j=0,lpc_gain1=0; j<Hlength; j++) lpc_gain1 += H[j] * H[j];    
		lsp2a(pci,lsp);
		ImpulseRzp(H, pci, pci, 1.0, 1.0, ORDER, Hlength);
		/* Get energy of H */
		for (j=0,lpc_gain2=0; j<Hlength; j++) lpc_gain2 += H[j] * H[j];    
		/* determine spectral transistion degree (set flag if large) --
		for frame erasures */
		if (lpc_gain1 / lpc_gain2 > LPCG_THD) {
		local_lpc_flag = TRUE;
		//      for (i=0;i<ORDER;i++) OldlspD[i]=lsp[i];
		}
	}

	j=data_packet.DELTA_DELAY_IDX;
	if (lastrateD<=2 && fer_counter==2) data_packet.ACBG_IDX[0]=0;
	if (bit_rate==4 && lastrateD>2 && j!=0  && (fer_counter==2 || (fer_counter==1 && lastrateD ==3 && prev_rcelp_half==0 && LAST_PPP_MODE_D =='Q'))) {
	    
		pdelayD=delay-(float)(j-16);

		LAST_BAD_CW.to_fs(PitchMemoryD+ACBMemSize-(int)pdelayD,(int)pdelayD);
	    
		if (fer_counter==2) {
		  if (!prev_prev_frame_error) {
		    if (fabs(pdelayD-pdelayD2) >15 ) pdelayD2=pdelayD;
		    for (i=0; i<ACBMemSize; i++) PitchMemoryD[i] = PitchMemoryD2[i];
		    for (i=0; i<NoOfSubFrames; i++) {	
		      if (i < 2) subframesize = SubFrameSize - 1;
		      else subframesize = SubFrameSize;      
		      // Interpolate delay
		      Interpol_delay(delayi, &pdelayD2, &pdelayD, i);      
		      // Compute adaptive codebook contribution
		      if (i==0) sum_acb=ave_acb_gain;
		      else sum_acb=1.0;
		      acb_excitation(PitchMemoryD + ACBMemSize, sum_acb, delayi,
				PitchMemoryD,subframesize);      
		      for (j=0; j<ACBMemSize; j++)PitchMemoryD[j]=PitchMemoryD[j+subframesize];
		    }
		  }
		}
		else {
		  pdelayD2=pdelayD-pdeltaD;
		  for (i=0; i<ACBMemSize; i++) PitchMemoryD[i] = PitchMemoryD3[i];
		  for (i=0; i<NoOfSubFrames; i++) {	
		    if (i < 2) subframesize = SubFrameSize - 1;
		    else subframesize = SubFrameSize;      
		    // Interpolate delay
		    Interpol_delay(delayi, &pdelayD3, &pdelayD2, i);      
		    // Compute adaptive codebook contribution
		    if (i==0) sum_acb=ave_acb_gain_back;
		    else sum_acb=1.0;
		    acb_excitation(PitchMemoryD + ACBMemSize, sum_acb, delayi,
				PitchMemoryD,subframesize);      
		    for (j=0; j<ACBMemSize; j++)PitchMemoryD[j]=PitchMemoryD[j+subframesize];
		  }      
	      
		  // Do QPPP synthesis here
		  //Do the QPPP to correct the ACB Memory
		  DTFS prev, curr, TMP;
		  float out[FSIZE], tmplsp[ORDER], lpc1[ORDER], lpc2[ORDER], ph_offset = 0.0;
	      
		  //Get the lsps for this Q frame
		  lsp2a(lpc1,OldOldlspD);
	      
		  Interpol(tmplsp, OldOldlspD, OldlspD, 2, ORDER);
		  lsp2a(lpc2,tmplsp);
	      
		  //Extract the previous prototype and back up the memory
		  prev.to_fs(PitchMemoryD+ACBMemSize-(int)pdelayD2, (int)pdelayD2);
		  TMP = prev;
		  TMP.car2pol();
		  lastLgainD=log10(TMP.lag*TMP.setEngyHarm(92.0,1104.5,0.0,1104.5,1.0));
		  lastHgainD=log10(TMP.lag*TMP.setEngyHarm(1104.5,3300.0,1104.5,4000.0,1.0));
		  TMP.to_erb(lasterbD);
	      
		  curr.lag = (int)pdelayD;
		  ppp_quarter_decoder(&curr, prev, lpc2);
		  WIsyn(prev,&curr,lpc1,lpc2,&ph_offset,out,FSIZE);
	      
		  for(j=0;j<ACBMemSize;j++)
		  PitchMemoryD[j]=out[FSIZE-ACBMemSize+j];
		}
	}
  }
  // End: Fix delay contour only if no Phase Matching; else PM fixes it anyway
  
  /* Smooth interpolation if the difference between delays is too big */
  if (fabs(delay - pdelayD) > 15) pdelayD = delay;

#if 1
  if (SPL_HCELP==1)
    {
      ct=0;
      for(i=0;i<3;i++)
	{
	  if (ppvq[data_packet.ACBG_IDX[i]] < 0.5499) 
	    ct+=1;

	  curr_ave_acb_gain+=ppvq[data_packet.ACBG_IDX[i]]*(i+1)/6.0;
	  
	}
      if (curr_ave_acb_gain==0)
	curr_ave_acb_gain = ave_acb_gain;
	
	prev_ave_fcb_gain = ave_fcb_gain;
    }
  
  
#endif
  
  ave_acb_gain = ave_fcb_gain = 0.0;

  
  
  
  foutP = outFbuf;
  for (i=0; i<NoOfSubFrames; i++) {
    
    if (i < 2) subframesize = SubFrameSize - 1;
    else subframesize = SubFrameSize;
    
    Interpol(lspi, OldlspD, lsp, i, ORDER);
    
    /* Convert lsp to PC */
    lsp2a(pci, lspi);

    /* No to be used with Motorola Code
    // Bandwidth expansion after frame erasure only if LPCflag is set
    if (LPCflag && prev_frame_error) weight(pci, pci, 0.75, ORDER);
    */
    
    Interpol_delay(delayi, &pdelayD, &delay, i);

    if (SPL_HCELP==0)
      {
	if (bit_rate==4) {
	  fcbIndexVector[0]=data_packet.FCB_PULSE_IDX[i][0];
	  fcbIndexVector[1]=data_packet.FCB_PULSE_IDX[i][1];
	  fcbIndexVector[2]=data_packet.FCB_PULSE_IDX[i][2];
	  fcbIndexVector[3]=data_packet.FCB_PULSE_IDX[i][3];
	  /* FCB gain index */
	}
	else {//bit_rate==3 case
	  //BitUnpack(SScratch, (unsigned short *) PackedWords, 11, PackWdsPtr);
	  fcbIndexVector[0] = data_packet.FCB_PULSE_IDX[i][0];
	}
      } //for SPL_HCELP fcb indices are undefined
    
    
    /* Compute adaptive codebook contribution */
    sum_acb = ppvq[data_packet.ACBG_IDX[i]];


    if (SPL_HCELP==1) //additional processing for SPL_HCELP
      {
	if (sum_acb < 0.5499) 
	  sum_acb = curr_ave_acb_gain;
	
	if ((i!=0) && (ct==3))
	  sum_acb=1.0;
      }
    
    //    ave_acb_gain += sum_acb / NoOfSubFrames;
    
    if (ct!=3) //if regular celp ct always=0 
      ave_acb_gain += sum_acb*(i+1) / 6;
    else //SPL_HCELP
      ave_acb_gain = curr_ave_acb_gain ;
    
    if (lastrateD==1) ave_acb_gain=0.0;
    g2=MIN(0.5,0.5*sum_acb);
    
    acb_excitation(PitchMemoryD + ACBMemSize, sum_acb, delayi, PitchMemoryD,
		   subframesize);
    
    if (SPL_HCELP==1)
      {
	if (curr_ave_acb_gain < 0.4) 	{	
	  for (j=0; j<subframesize; j++) PitchMemoryD[ACBMemSize + j]*=FadeScale;
	  
	}
	/* Compute fixed codebook contribution */
	ave_fcb_gain = 0.0;
      }
    else
      /* Compute fixed codebook contribution */
      ave_fcb_gain += gnvq[ data_packet.FCBG_IDX[i] ] / NoOfSubFrames;
    
    if (sum_acb > 0.9) sum_acb = 0.9;
    if (sum_acb < 0.2) sum_acb = 0.2;

    /* get intrpolated delay for this subframe */
    n = (short) ((delayi[1] + delayi[0]) / 2.0 + 0.5);
    if (n > subframesize) n = 200;

    if (SPL_HCELP==0)
      {
	
	/* Compute fixed codebook contribution */
	if (bit_rate==4) {
	  
	  dec_fpmp(fcbIndexVector, Scratch);
	  
	}
	else {// bit_rate==3 case
	  dec3_10jcelp(n, sum_acb, subframesize, fcbIndexVector, Scratch);
	}
	
	if (bit_rate==4) pit_shrp(Scratch, (int) (n), sum_acb, subframesize);
	sum1 = gnvq[data_packet.FCBG_IDX[i]];
      }
    else //SPL_HCELP => zero out the fcb contribution
      {
	for(j=0;j<subframesize;j++)
	  Scratch[j]=0.0;
	sum1=0.0;



      }

    


	if (do_phase_matching) //check for Phase Matching: main Phase Matching processing
	{
		//calculation of phase here
		if (i == 0)
		{
			double prev_delay, prev_delay2;
			double prev_delay_end, prev_delay2_end;
			double encoder_phase, decoder_phase;
								
			//if (idxppg != 0) //get delay of previous frame from current frame
			{
				prev_delay_end = delay - (float) (store_ddelay - 16);
				prev_delay2_end = (prev_delay_end + pdelayD)/2;
	
				if ((phase_offset == 0 && run_length == 1) || (phase_offset == 1 && run_length == 2))
					prev_delay = (prev_delay_end + pdelayD)/2;
				else
					prev_delay = (prev_delay_end + prev_delay2_end)/2;

				prev_delay2 = (prev_delay2_end + pdelayD)/2;
			}
						
			//Different cases using Phase Matching
			//Get phase of encoder and current phase of decoder
			//The difference between these is the amount of Phase Matching to be done

			decoder_phase = encoder_phase = 0;

			if (phase_offset == 0) 
			{
				if (run_length == 1)
				{
					encoder_phase = fmod (160, prev_delay)/prev_delay;
					decoder_phase = fmod (160, pdelayD)/pdelayD;
				}
				else if (run_length == 2)
				{
					encoder_phase = fmod (fmod (160, prev_delay) + fmod (160, prev_delay2), prev_delay)/prev_delay;
					decoder_phase = fmod (fmod (160, pdelayD) * 2, pdelayD)/pdelayD;
				}
			}
			else if (phase_offset == 1)
			{
				if (run_length == 1)
				{
					encoder_phase = 0;
					decoder_phase = fmod (160, pdelayD)/pdelayD;
				}
				else if (run_length == 2)
				{
					encoder_phase = fmod (160, prev_delay)/prev_delay;
					decoder_phase = fmod (fmod (160, pdelayD) * 2, pdelayD)/pdelayD;
				}
			}
			else if (phase_offset == 2)
			{
				encoder_phase = 0;
				decoder_phase = fmod (fmod (160, pdelayD) * 2, pdelayD)/pdelayD;
			}
			else if (phase_offset == -1)
			{
				encoder_phase = fmod (fmod (160, prev_delay) + fmod (160, prev_delay2), prev_delay)/prev_delay;
				decoder_phase = fmod (160, pdelayD)/pdelayD;
			}

			//End Different cases using Phase Matching

			if (decoder_phase >= encoder_phase)
			{
				pm_var1 = (int) ((decoder_phase - encoder_phase) * prev_delay);
			}
			else
				pm_var1 = (int) (prev_delay - prev_delay * (encoder_phase - decoder_phase));

			num_residual = 160 - pm_var1;
                 	if (pm_var1 >= 100)
			{
				//printf (" PM too large");
				pm_var1 = 0;
			}

			//printf ("\n delays %f %f %f %f %d phases %f %f", prev_delay_end, pdelayD, delay, prev_delay, pm_var1, encoder_phase, decoder_phase); //fflush(stdout);

			//If Phase Matching delta > subframesize, PM extends to two subframes
			if (pm_var1 > 53)
			{
				pm_var2 = pm_var1 - 53;
				pm_var1 = 53;
			}
			else
				pm_var2 = 0;
		}
		else
		{
			//If Phase Matching delta > subframesize, PM extends to two subframes

			pm_var1 = pm_var2;
			pm_var2 = 0;
		}

		for (j = 0; j < subframesize - pm_var1; j++)
			PitchMemoryD[j + ACBMemSize] += sum1 * Scratch[j + pm_var1];
	}
	else
	{
		pm_var1 = 0;

		for (j = 0; j < subframesize; j++)
			PitchMemoryD[j + ACBMemSize] += sum1 * Scratch[j];
	}

      	//Changed to support Phase Matching
	for (j = 0; j < ACBMemSize; j++)
		PitchMemoryD[j] = PitchMemoryD[j + subframesize - pm_var1];
	//End Changed to support Phase Matching
  
     #ifdef QRES
         for(j=0;j<subframesize;j++)
           printf("%f\n",PitchMemoryD[j+ACBMemSize]);
     # endif


	 if (SPL_HCELP==1)
	   {
	     if (ave_acb_gain < 0.4) {
	       FadeScale -= 0.05;
	       if (FadeScale<0.0) FadeScale = 0.0;
	       /* Add some gaussian noise */
	       
	       for (j=0; j<subframesize; j++)
		 PitchMemoryD[ACBMemSize+j]+=0.1*prev_ave_fcb_gain*ran_g(&celpSPL_HCELPSeed);
	     }
	   }
	 
    /* Collecting the entire frame of excitation */
	//Changed to support Phase Matching
	for (j=0; j<subframesize - pm_var1; j++)
		PitchMemoryD_Frame [temp_samples_count+j]=PitchMemoryD[ACBMemSize+j];

	temp_samples_count += subframesize - pm_var1;	//Added to support Phase Matching
  }

  //Post WI synthesis for the purpose of smoothing
  if (LAST_BAD_CW.lag!=0 && fabs(delay-pdelayD)<8.0 && local_lpc_flag == FALSE &&
      ppvq[data_packet.ACBG_IDX[0]]>0 && ppvq[data_packet.ACBG_IDX[1]]>0 &&
      ppvq[data_packet.ACBG_IDX[2]]>0) {
    
    float enratio, out[FSIZE], tmplsp[ORDER], lpc1[ORDER], lpc2[ORDER], ph_offset = 0.0;
    DTFS CURR_GOOD_CW;
    
    CURR_GOOD_CW.to_fs(PitchMemoryD+ACBMemSize-(int)delay,(int)delay);

    enratio = CURR_GOOD_CW.getEngy()/LAST_BAD_CW.getEngy();
    
    //Ensure there is no drastic energy change between successive CWs before interp
    if (enratio > 0.025 && enratio < 14.5) {
      Interpol(tmplsp, OldOldlspD, OldlspD, 2, ORDER);
      lsp2a(lpc1,tmplsp);
    
      Interpol(tmplsp, OldlspD, lsp, 2, ORDER);
      lsp2a(lpc2,tmplsp);

	  //printf ("\n post_WI_SYN");

	  if (do_phase_matching)
	  {
                //WIsyn(LAST_BAD_CW,&CURR_GOOD_CW,lpc1,lpc2,&ph_offset,out,num_residual);
		//for(j=0;j<ACBMemSize;j++) PitchMemoryD[j]=out[num_residual-ACBMemSize+j];
		//for(j=0;j<num_residual;j++) PitchMemoryD_Frame[j]=out[j];

	  }
	  else
	  {
		WIsyn(LAST_BAD_CW,&CURR_GOOD_CW,lpc1,lpc2,&ph_offset,out,FSIZE);
        for(j=0;j<ACBMemSize;j++) PitchMemoryD[j]=out[FSIZE-ACBMemSize+j];
        for(j=0;j<FSIZE;j++) PitchMemoryD_Frame[j]=out[j];
	  }
    }
  }

  num_samples = temp_samples_count;

  //Warping-expanding or compressing

	if (num_samples <= 120)
	{
		if (time_warp_fraction < 1)
			time_warp_fraction = 1;
		else
			time_warp_fraction = 1.5;
	}

  if (time_warp_fraction > 1 || time_warp_fraction < 1) //Expansion or Compression
  {
   	  merge_start = 0;
					  
	  if ((delay) - floor (delay) > 0.5)
		merge_end = (int) delay + 1;
	  else
		merge_end = (int) delay;

	  if (merge_end - merge_start > num_residual/2)
		merge_stop = num_residual - (merge_end - merge_start);
	  else
		merge_stop = merge_end - merge_start;

				
	  if (num_residual <= delay)
	  	merge_stop = 0;

   	  num_samples = num_residual;
			
	  for (b = 0; b < num_residual; b++)
	  	temp_pitch[b] = PitchMemoryD_Frame[b];

	  sample_counter = 0;

	  if (merge_stop != 0)
	  {
	 	if (time_warp_fraction > 1) //Expansion
		{
			for (b = merge_start; b < merge_end; b++)
				PitchMemoryD_Frame[b] = temp_pitch[b];

			sample_counter += merge_end;

			for (b = merge_start; b < merge_stop; b++)
				PitchMemoryD_Frame[b+merge_end] = temp_pitch[b + (merge_end-merge_start)] * (1.0 * (merge_stop-merge_start-b)/(merge_stop-merge_start)) + temp_pitch[b] * (1.0 * (b)/(merge_stop-merge_start));	

			sample_counter += merge_stop - merge_start;

			 //If erased packet is being reconstructed, need to produce two extra pitch periods
			// But only two produce two extra pitch periods if length will be less than 320
			if (phase_offset == -1 && (num_residual + 2 * (merge_end - merge_start)) <= 320)
			{
				if (merge_end - merge_stop > 0)
				{
					for (b = sample_counter, c = 0; b < merge_end+merge_end; b++, c++)
						PitchMemoryD_Frame[b] = temp_pitch[merge_stop+c];

					sample_counter += merge_end - merge_stop;
				}

				for (b = 0; b < merge_stop; b++)
					PitchMemoryD_Frame[b+sample_counter] = temp_pitch[b + (merge_end-merge_start)] * (1.0 * (merge_stop-merge_start-b)/(merge_stop-merge_start)) + temp_pitch[b] * (1.0 * (b)/(merge_stop-merge_start));	
				sample_counter += merge_stop;


				for (b = merge_start + merge_end + merge_stop; b < num_residual + merge_end - merge_start; b++)
					PitchMemoryD_Frame[b+merge_end] = temp_pitch[b - (merge_end - merge_start)];
							
				num_samples = num_residual + 2 * (merge_end - merge_start);
				//printf ("\n 1expand_num_samples = %d %d %f %d %d %f", num_residual, num_samples, delay, merge_end, merge_stop, time_warp_fraction);
			}
			else //Else, regular expansion as requested by de-jitter: produce one extra pitch period
			{
				for (b = merge_start + merge_end + merge_stop; b < num_residual + merge_end - merge_start; b++)
					PitchMemoryD_Frame[b] = temp_pitch[b - (merge_end - merge_start)];
							
				num_samples = num_residual + (merge_end - merge_start);
				//printf ("\n expand_num_samples = %d %d %f %d %d %f", num_residual, num_samples, delay, merge_end, merge_stop, time_warp_fraction);
			}
		}
		//Regular compression as requested by de-jitter: produce one less pitch period
		//Compress only if compressed samples >= 40
		else if (time_warp_fraction < 1 && (num_residual - (merge_end - merge_start)) >= 20)
		{
			for (b = merge_start; b < merge_stop; b++)
				PitchMemoryD_Frame[b] = PitchMemoryD_Frame[b] * (1.0 * (merge_stop-merge_start-b)/(merge_stop-merge_start)) + PitchMemoryD_Frame[b+(merge_end-merge_start)] * (1.0 * (b)/(merge_stop-merge_start));	

			for (b = merge_stop; b + merge_end - merge_start < num_residual; b++)
				PitchMemoryD_Frame[b] = PitchMemoryD_Frame[b + merge_end - merge_start];

			num_samples = num_residual - (merge_end - merge_start);
		}
	}
  }
  //End Warping-expanding or compressing

  //More support for Phase Matching/Warping

  //printf ("\n num_samples %d", num_samples);

  temp_samples_count = 0;
  *obuf_len = num_samples;
  //End: More support for Phase Matching/Warping
  
  //SECOND PART OF THE SYNTHESIS
  for (i=0; i<NoOfSubFrames; i++) {
    
	//Warping: Change in size of subframesize, not always equal to 53 since residual size may not be = 160

	if (num_samples % 3 == 0)
		subframesize = num_samples/3;
	else if (num_samples % 3 == 1)
	{
		if (i < 2)
			subframesize = num_samples/3;
		else
			subframesize = num_samples/3 + 1;
	}
	else if (num_samples % 3 == 2)
	{
		if (i < 1)
			subframesize = num_samples/3;
		else
			subframesize = num_samples/3 + 1;
	}
	//End Change in size of subframesize, not always equal to 53
    
    Interpol(lspi, OldlspD, lsp, i, ORDER);
    
    /* Convert lsp to PC */
    lsp2a(pci, lspi);

    Interpol_delay(delayi, &pdelayD, &delay, i);

    
    /* Synthesis of decoder output signal and postfilter output signal */
	//Warping: Slight change in call to support smaller/larger number of samples
    SynthesisFilter(DECspeech, PitchMemoryD_Frame+temp_samples_count, pci, SynMemory,ORDER,
		    subframesize);
    
    /* Postfilter */
    if (post_filter) {
	Post_Filter(DECspeech, lspi, pci, DECspeechPF, 
		    (delayi[0]+delayi[1])/2.0, 0.4, 0.15, 
		    subframesize);
    }
    else V_copy(DECspeech,DECspeechPF,subframesize);
    
    /* Write p.f. decoder output and variables to files */
    for (j = 0; j < subframesize; j++) {
      if (DECspeechPF[j] > 32767.0) *foutP++ = 32767.0;
      else {
	if (DECspeechPF[j] < -32768) *foutP++ = -32768.0;
	else *foutP++ = DECspeechPF[j];
      }
     }
	
	temp_samples_count += subframesize; //Phase Matching: counting number of samples syntthesized
  }

  pdelayD = delay;
  
  return(0);
}

void FGV_MEM::celp_erasure_decoder(float *outFbuf,short post_filter)
{
  register int i, j;
  register float *foutP;
  float   delayi[3];
  short   subframesize;
  float   sum_acb;

  float   g2;  // For 2nd pitch filter
    
  delay=pdelayD;
  /* Convert lsp to PC */
  lsp2a(pci, OldlspD);
  if (!prev_frame_error) celpErasureSeed = (long) (OldlspD[ORDER - 1] * 65536.0);       /* A random number */
  
  foutP = outFbuf;
  for (i=0; i<NoOfSubFrames; i++) {
    
    if (i < 2) subframesize = SubFrameSize - 1;
    else subframesize = SubFrameSize;

    Interpol(lspi, OldlspD, OldlspD, i, ORDER);
    
    Interpol_delay(delayi, &pdelayD, &delay, i);
    
    /* Compute adaptive codebook contribution */
    g2=MIN(0.5,0.5*ave_acb_gain);
    sum_acb=1.0;
    if (ave_acb_gain>0.8) sum_acb=1.0; else sum_acb=ave_acb_gain;
    if (i==0) sum_acb=ave_acb_gain;    
    acb_excitation(PitchMemoryD+ACBMemSize,sum_acb,delayi,PitchMemoryD,
		   subframesize);

    /* Compute fixed codebook contribution */
    for (j=0; j<subframesize; j++) PitchMemoryD[ACBMemSize + j]*=FadeScale;
    for (j=0; j<ACBMemSize; j++) PitchMemoryD[j]=PitchMemoryD[j+subframesize];
    FadeScale -= 0.05;
    if (FadeScale<0.0) FadeScale = 0.0;
    /* Add some gaussian noise */
    if (ave_acb_gain < 0.4) {
      for (j=0; j<subframesize; j++)
	PitchMemoryD[ACBMemSize+j]+=0.1*ave_fcb_gain*ran_g(&celpErasureSeed);
    }
      

    //    for (j=0; j<ACBMemSize; j++) PitchMemoryD[j]=PitchMemoryD[j+subframesize];
    
    /* Synthesis of decoder output signal and postfilter output signal */
    SynthesisFilter(DECspeech, PitchMemoryD + ACBMemSize, pci, SynMemory,ORDER,
		    subframesize);
    
    /* Postfilter */
    if (post_filter) {
	Post_Filter(DECspeech, lspi, pci, DECspeechPF, 
		    (delayi[0]+delayi[1])/2.0, ave_acb_gain, 0.15, 
		    subframesize);
    }
    else V_copy(DECspeech,DECspeechPF,subframesize);
    
    /* Write p.f. decoder output and variables to files */
    for (j = 0; j < subframesize; j++) {
      if (DECspeechPF[j] > 32767.0) *foutP++ = 32767.0;
      else {
	if (DECspeechPF[j] < -32768) *foutP++ = -32768.0;
	else *foutP++ = DECspeechPF[j];
      }
    }
  }

  pdelayD = delay; 
}

/*======================================================================*/
/*  Lucent Technologies Network Wireless Systems                        */
/*  EVRC Floating-point C Simulation.                                   */
/*                                                                      */
/*  Copyright (C) 1996 Lucent Technologies Incorporated. All rights     */
/*  reserved.                                                           */
/*----------------------------------------------------------------------*/
/*  Module:     w2res                                                   */
/*----------------------------------------------------------------------*/
/*  History:                                                            */
/*     01/01/95  Written By Dror Nahumi, AT&T                           */
/*----------------------------------------------------------------------*/

void Weight2Res(
     float *output,
     float *input,
     float *coef_uq,
     float *coef,
     float gamma1,
     float gamma2,
     short order,
     short length
)
{
  register short i, j;
  float   SUM;
  float   memory[ORDER];
  float   wcoef[ORDER];
  
  /* A(Z) */
  for (i=1; i<ORDER; i++) memory[i] = 0;
  memory[0] = input[0];
  output[0] = input[0];
  for (i=1; i<length; i++) {
    for (j=order-1,SUM=input[i]; j>0; j--) {
      SUM += coef[j] * memory[j];
      memory[j] = memory[j - 1];
    }
    SUM += coef[0] * memory[0];
    *memory = input[i];
    output[i] = SUM;
  }

  /* Cascade with of 1/A(Z/gamma1) */
  weight(wcoef, coef_uq, gamma1, order);
  
  for (i=1; i<ORDER; i++) memory[i] = 0;
  memory[0] = output[0];
  for (i=1; i<length; i++) {
    for (j=order-1,SUM=output[i]; j>0; j--) {
      SUM -= wcoef[j] * memory[j];
      memory[j] = memory[j - 1];
    }
    SUM -= wcoef[0] * memory[0];
    *memory = SUM;
    output[i] = SUM;
  }
  
  /* Cascade with of A(Z/gamma2) */
  weight(wcoef, coef_uq, gamma2, order);
  
  for (i=1; i<ORDER; i++) memory[i] = 0;
  memory[0] = output[0];
  for (i=1; i<length; i++) {
    for (j=order-1,SUM=output[i]; j>0; j--) {
      SUM += wcoef[j] * memory[j];
      memory[j] = memory[j - 1];
    }
    SUM += wcoef[0] * memory[0];
    *memory = output[i];
    output[i] = SUM;
  }
}







