/**********************************************************************
Each of the companies; Motorola, and Lucent, and Qualcomm, and Nokia (hereinafter 
referred to individually as "Source" or collectively as "Sources") do 
hereby state:

To the extent to which the Source(s) may legally and freely do so, the 
Source(s), upon submission of a Contribution, grant(s) a free, 
irrevocable, non-exclusive, license to the Third Generation Partnership 
Project 2 (3GPP2) and its Organizational Partners: ARIB, CCSA, TIA, TTA, 
and TTC, under the Source's copyright or copyright license rights in the 
Contribution, to, in whole or in part, copy, make derivative works, 
perform, display and distribute the Contribution and derivative works 
thereof consistent with 3GPP2's and each Organizational Partner's 
policies and procedures, with the right to (i) sublicense the foregoing 
rights consistent with 3GPP2's and each Organizational Partner's  policies 
and procedures and (ii) copyright and sell, if applicable) in 3GPP2's name 
or each Organizational Partner's name any 3GPP2 or transposed Publication 
even though this Publication may contain the Contribution or a derivative 
work thereof.  The Contribution shall disclose any known limitations on 
the Source's rights to license as herein provided.

When a Contribution is submitted by the Source(s) to assist the 
formulating groups of 3GPP2 or any of its Organizational Partners, it 
is proposed to the Committee as a basis for discussion and is not to 
be construed as a binding proposal on the Source(s).  The Source(s) 
specifically reserve(s) the right to amend or modify the material 
contained in the Contribution. Nothing contained in the Contribution 
shall, except as herein expressly provided, be construed as conferring 
by implication, estoppel or otherwise, any license or right under (i) 
any existing or later issuing patent, whether or not the use of 
information in the document necessarily employs an invention of any 
existing or later issued patent, (ii) any copyright, (iii) any 
trademark, or (iv) any other intellectual property right.

With respect to the Software necessary for the practice of any or 
all Normative portions of the EVRC-B Variable Rate Speech Codec as 
it exists on the date of submittal of this form, should the EVRC-B be 
approved as a Specification or Report by 3GPP2, or as a transposed 
Standard by any of the 3GPP2's Organizational Partners, the Source(s) 
state(s) that a worldwide license to reproduce, use and distribute the 
Software, the license rights to which are held by the Source(s), will 
be made available to applicants under terms and conditions that are 
reasonable and non-discriminatory, which may include monetary compensation, 
and only to the extent necessary for the practice of any or all of the 
Normative portions of the EVRC-B or the field of use of practice of the 
EVRC-B Specification, Report, or Standard.  The statement contained above 
is irrevocable and shall be binding upon the Source(s).  In the event 
the rights of the Source(s) in and to copyright or copyright license 
rights subject to such commitment are assigned or transferred, the 
Source(s) shall notify the assignee or transferee of the existence of 
such commitments.
*******************************************************************/
/*****************************************************************
 *   (C) COPYRIGHT 1999,2000 Motorola, Inc.
 *    MOTOROLA CONFIDENTIAL PROPRIETARY
 *****************************************************************/
#include <stdio.h>
#include <math.h>
#include <float.h>
#include "macro.h"
#include "acelp.h"
//#include "cod_fpmp.h"
//#include "fact_pack.h"
//#include "dump.h"

#define PRINT_OUT 0

#define	PRINT_NUM_ITERATION	NO

#define	CONFIG	1

#define	N0	4	/* # of candidate positions for pulse 1 */
#define	N1	8	/* # of candidate positions for pulse 2 */	
#define	N2	12	/* # of candidate positions for pulse 3 */
#define N3	16

#define N_PRE	24 //10	/* # of candidate combinations for pulse 1, 2 and 3 */
#define	N_POST	7 //21

void cod7_35(
	float *xw,	/* (input)  Target signal. */
   	float *x,	/* (input)  Target signal (through inverse weighting filter). */
   	int l_subfr,	/* (input)  Length of current subframe. */
   	float *h,	/* (input)  Weighted filter impulse response. */
   	float *ck,	/* (output) Multipulse excitation. */
   	float y[],   /* (output) Filtered fixed codebook excitation. */
   	float *gain, /* (output) Excitation gain parameter. */
   	int *indx)	/* (output) Factorial Packed codeword. */
{
   	float rr0[L_CODE], alpn[N_PRE], sqn[N_PRE];
   	float d2[MAX_TLEN], sign[MAX_TLEN], accum[MAX_TLEN];
   	int ordered_pos[MAX_TLEN], ivect[N_PULSES], jvect[N_PULSES];
   	int i, j, k, m, n, l, dec, pos, vect3[N_PRE][4];
   	register int i0, i1, i2, ia, ib, i3, i4, i5, i6;
   	int64 codeword;
   	float ps, ps0, ps1, ps2, psk;
	float alp, alp0, alp1, alp2, alpk;
   	float sq, sq2, sqk, *ptr;

  	/* Generate backward filtered target vector d[n] (d' = xw'H) */
  	for(i=0; i<l_subfr; i++) {
    		ps=0;
    		for(j=i; j<l_subfr; j++) ps += h[j-i]*xw[j];
    		d2[i] = ps;
    	}

  	/* Put h[i]= d2[i] = x[i] = 0; for i>l_subfr */
  	for(i=l_subfr; i<L_CODE; i++) h[i] = d2[i] = x[i] = 0.0;

 	/*----------------------------------------------------------------*
  	*     BUILD "d2[]", "sign[]" AND "d6[]" VECTORS.                 *
  	*----------------------------------------------------------------*/

	ps1 = 1e-20;
  	ps2 = 1e-20;
  	for (i=0; i<l_subfr; i++) {
  		ps1 += (x[i]*x[i]);
    		ps2 += (d2[i]*d2[i]);
    	}
  	ps = sqrt(ps2/ps1);

  	for (j=0; j<l_subfr; j++) {
    		ps2 = (ps*x[j]) + (2.0*d2[j]);
    		if (ps2 >= 0.0)
      			sign[j] = 1.0;
      		else {
      			sign[j] = -1.0;
      			d2[j] = -d2[j];
      			ps2 = -ps2;
      		}
    		accum[j] = ps2;
    	}

 	/*----------------------------------------------------------------*
  	*        BUILD "rr[][]", MATRIX OF AUTOCORRELATION.              *
  	*----------------------------------------------------------------*/

	//Doing regular diag elements
  	for (k=0, ps=0.0; k<l_subfr; k++) {
    		ps += h[k]*h[k];
  	}
    	rr0[0] = ps; //note rr0 has the first row of matrix instead of 
		     //     of diagonal in EVRC

	//Make first row
  	for (dec=1; dec<l_subfr; dec++) {
    		for (k=0, ps=0.0; k<(l_subfr-dec); k++) {
      			ps += h[k]*h[k+dec];
    		}
      		rr0[dec] = ps;
  	}

	/******************************************************************
	     Stage #1:	Pre-pre-select
	 	Select number of candidate positions for the first 3 pulses
		by searching for the positions with largest d6[] values.
	******************************************************************/
    	for(k=0; k<N3; k++) {
      		for (ps= -FLT_MAX, i=0, j=0; j<l_subfr; j++) {
			if (accum[j] > ps) {
	  			ps = accum[j];
	  			i = j;
	  		}
        	}
      		accum[i] = -FLT_MAX;
		ordered_pos[k] = i;
      	}

	/******************************************************************
	     Stage #2:	Pre-select
	 	Select candidate combinations of pulse 1, 2 and 3
		by searching for the highest gain.
	******************************************************************/
	for(i=0; i<N_PRE; i++) {
		alpn[i] = 1.0;
		sqn[i]  = -1.0;
	}

	alpk = 1.0;
	sqk = -1.0;
	pos = 0;

#ifdef FIX_BUG_IN_COD7_35
	ia = 0;
#endif //FIX_BUG_IN_COD7_35
 	for(i=0; i<N0; i++) {
 		i0 = ordered_pos[i];

		for(j=i+1; j<N1; j++) {
	    		i1   = ordered_pos[j];
			ps0  = d2[i0] + d2[i1];
     	    		alp0 = 0.5*rr0[0] + 0.5*rr0[0] +rr0[abs(i0-i1)]*sign[i0]*sign[i1];

	    		for(k=j+1; k<N2-i; k++) {
				i2  = ordered_pos[k];
				ps1  = ps0 + d2[i2];
     	    			alp1 = alp0 + 0.5*rr0[0] + rr0[abs(i0-i2)]*sign[i0]*sign[i2] + rr0[abs(i1-i2)]*sign[i1]*sign[i2];

				for(n=k+1; n<N3-j; n++) {
					i3  = ordered_pos[n];
					ps  = ps1 + d2[i3];
     	    				alp = alp1 + 0.5*rr0[0] + rr0[abs(i0-i3)]*sign[i0]*sign[i3] + rr0[abs(i1-i3)]*sign[i1]*sign[i3] + rr0[abs(i2-i3)]*sign[i2]*sign[i3];


					sq = ps * ps;
	 			
#ifdef FIX_BUG_IN_COD7_35
                   			if(sq*alpk > alp*sqk) {

			                       sqn[ia] = sq;
                       				alpn[ia] = alp;
			                       vect3[ia][0] = i0;
			                       vect3[ia][1] = i1;
			                       vect3[ia][2] = i2;
			                       vect3[ia][3] = i3;

                         			alpk = alpn[0];
			                         sqk = sqn[0];
                       			  	ia = 0;
			                         for(ib=1; ib<N_PRE; ib++) {
			                           if(sqn[ib] *alpk < alpn[ib] * sqk) {
			                             ia = ib;
			                             alpk = alpn[ib];
			                             sqk = sqn[ib];
			                           }
			                         }
                   			}
#else //FIX_BUG_IN_COD7_35
					//if(sq*alpk > alp*sqk) {}
					if(sq*alpn[0] > alp*sqn[0]) {
						alpk = alp;
						sqk = sq;
						ia = 0;
						for(ib=1; ib<N_PRE; ib++) {
							if(sqn[ib] *alpk < alpn[ib] * sqk) {
								ia = ib;
								alpk = alpn[ib];
								sqk = sqn[ib];
							}
						}
						
						pos++;
						sqn[0] = sqn[ia];
						alpn[0] = alpn[ia];
						vect3[0][0] = vect3[ia][0];
						vect3[0][1] = vect3[ia][1];
						vect3[0][2] = vect3[ia][2];
						vect3[0][3] = vect3[ia][3];

						sqn[ia] = sq;
						alpn[ia] = alp;
						vect3[ia][0] = i0;
						vect3[ia][1] = i1;
						vect3[ia][2] = i2;
						vect3[ia][3] = i3;
					}
#endif //FIX_BUG_IN_COD7_35
				}
			}
		}
	}

/*for(i=0; i<N3; i++)
{
	i0 = vect3[i][0];
	i1 = vect3[i][1];
	i2 = vect3[i][2];

	ps = d2[i0] + d2[i1]+d2[i2];
	alp = rr0[i0]+rr0[i1]+rr0[i2];
	alp += rr[i0][i1]+rr[i0][i2];
	alp += rr[i1][i2];

	fprintf(dp4, "\n		alpn = %f; alp = %f", alpn[i], alp);
}*/

	/*********************************************************************
	    Stage #3:	Search
		Search the rest of the pulses over the candidate combinations
		of the first 3 pulses.
	*********************************************************************/
  	alpk = 1.0;
   	sqk = -1.0;
   	psk = 0.0;

	for(i=0; i<N_PRE; i++) {
		i0 = vect3[i][0];
		i1 = vect3[i][1];
		i2 = vect3[i][2];
		i3 = vect3[i][3];

		alp0 = alpn[i];
		ps0 = d2[i0] + d2[i1] + d2[i2] + d2[i3];

		for(j=0; j<l_subfr; j++) accum[j] = rr0[abs(i0-j)]*sign[i0]*sign[j] + rr0[abs(i1-j)]*sign[i1]*sign[j] + rr0[abs(i2-j)]*sign[i2]*sign[j] + 0.5*rr0[0];
				
		ia = i3;
		for(j=0; j<3; j++) {
			alp =  1.0;
			sq  = -1.0;

			for(k=0; k<l_subfr; k++) accum[k] += rr0[abs(ia-k)]*sign[ia]*sign[k];

	 		for(k=0; k<l_subfr; k++) {
				ps2  = ps0 + d2[k];
				alp2 = alp0 + accum[k];
				sq2  = ps2 * ps2;

	 			if(alp*sq2 > sq*alp2) {
					sq  = sq2;
	   				ps  = ps2;
	   				alp = alp2;
  					jvect[j] = k;
				}
			}
		
			ia   = jvect[j];
			ps0  = ps;
			alp0 = alp;
	    	}

	    	if(alpk*sq > sqk*alp) {
			sqk  = sq;
	   		psk  = ps;
	   		alpk = alp;
			
			for(j=0; j<4; j++) ivect[j] = vect3[i][j];		
			for(j=0; j<3; j++) ivect[j+4] = jvect[j];
	    	}
	}

	i0 = ivect[0];
	i1 = ivect[1];
	i2 = ivect[2];
	i3 = ivect[3];
	i4 = ivect[4];
	i5 = ivect[5];
	i6 = ivect[6];

	for(i=0; i<l_subfr; i++) 
		accum[i] = 0.5*rr0[0] +rr0[abs(i0-i)]*sign[i0]*sign[i] +rr0[abs(i1-i)]*sign[i1]*sign[i] +rr0[abs(i2-i)]*sign[i2]*sign[i] +rr0[abs(i3-i)]*sign[i3]*sign[i] +rr0[abs(i4-i)]*sign[i4]*sign[i] +rr0[abs(i5-i)]*sign[i5]*sign[i] +rr0[abs(i6-i)]*sign[i6]*sign[i];

	for(i=0; i<N_POST; i++) {
		ia = ivect[i%7];
		ps0 = psk - d2[ia];
		alp0 = alpk - (accum[ia] - rr0[0]);

	 	for(j=0; j<l_subfr; j++) {
			ps2  = ps0 + d2[j];
			alp2 = alp0 + (accum[j] - rr0[abs(ia-j)]*sign[ia]*sign[j]);
			sq2  = ps2 * ps2;

	 		if(alpk*sq2 > sqk*alp2) {
				sqk  = sq2;
	   			psk  = ps2;
	   			alpk = alp2;
  				ivect[i%7] = j;
			}
		}
		
		ib = ivect[i%7];
		if(ib != ia) {
			for(j=0; j<l_subfr; j++) accum[j] += (rr0[abs(ib-j)]*sign[ib]*sign[j] - rr0[abs(ia-j)]*sign[ia]*sign[j]);
		}
	}

	i0 = ivect[0];
	i1 = ivect[1];
	i2 = ivect[2];
	i3 = ivect[3];
	i4 = ivect[4];
	i5 = ivect[5];
	i6 = ivect[6];

	/*alp = rr0[i0]+rr0[i1]+rr0[i2]+rr0[i3]+rr0[i4]+rr0[i5]+rr0[i6];
	alp += rr[i0][i1]+rr[i0][i2]+rr[i0][i3]+rr[i0][i4]+rr[i0][i5]+rr[i0][i6];
	alp += 	    	  rr[i1][i2]+rr[i1][i3]+rr[i1][i4]+rr[i1][i5]+rr[i1][i6];
	alp += 			     rr[i2][i3]+rr[i2][i4]+rr[i2][i5]+rr[i2][i6];
	alp += 				        rr[i3][i4]+rr[i3][i5]+rr[i3][i6];
	alp += 						   rr[i4][i5]+rr[i4][i6];
	alp += 							      rr[i5][i6];

	fprintf(dp4, "\nalpk = %f, %f", alpk, alp);*/


 	/*--------------------------------------------------------------------*
  	* BUILD THE CODEWORD, THE FILTERED CODEWORD AND INDEX OF CODEVECTOR. *
  	*--------------------------------------------------------------------*/

   	for (i=0; i<L_CODE; i++) { ck[i] = 0.0; y[i] = 0.0; }
   	*gain = 0.5 * psk / alpk;


   	for (k=0; k<N_PULSES; k++) {
     		pos = ivect[k];
     		ps = sign[pos];
     		ck[pos] += ps;

     		for (i=pos, ptr=h; i<L_CODE; i++) y[i] += ps * (*ptr++);
	}


      codeword=factorial_pack(54,ck);

   	indx[0] = (unsigned int)(codeword & 0x000000ffL);
   	indx[1] = (unsigned int)(codeword>>8 & 0x000000ffL);
   	indx[2] = (unsigned int)(codeword>>16 & 0x000000ffL);
   	indx[3] = (unsigned int)(codeword>>24 & 0x000000ffL);
   	indx[3] += (unsigned int)((codeword>>32 & 0x00000007L)<<8);
    


   	return;
}





