#include <cstring>
/**********************************************************************
Each of the companies; Motorola, and Lucent, and Qualcomm, and Nokia (hereinafter 
referred to individually as "Source" or collectively as "Sources") do 
hereby state:

To the extent to which the Source(s) may legally and freely do so, the 
Source(s), upon submission of a Contribution, grant(s) a free, 
irrevocable, non-exclusive, license to the Third Generation Partnership 
Project 2 (3GPP2) and its Organizational Partners: ARIB, CCSA, TIA, TTA, 
and TTC, under the Source's copyright or copyright license rights in the 
Contribution, to, in whole or in part, copy, make derivative works, 
perform, display and distribute the Contribution and derivative works 
thereof consistent with 3GPP2's and each Organizational Partner's 
policies and procedures, with the right to (i) sublicense the foregoing 
rights consistent with 3GPP2's and each Organizational Partner's  policies 
and procedures and (ii) copyright and sell, if applicable) in 3GPP2's name 
or each Organizational Partner's name any 3GPP2 or transposed Publication 
even though this Publication may contain the Contribution or a derivative 
work thereof.  The Contribution shall disclose any known limitations on 
the Source's rights to license as herein provided.

When a Contribution is submitted by the Source(s) to assist the 
formulating groups of 3GPP2 or any of its Organizational Partners, it 
is proposed to the Committee as a basis for discussion and is not to 
be construed as a binding proposal on the Source(s).  The Source(s) 
specifically reserve(s) the right to amend or modify the material 
contained in the Contribution. Nothing contained in the Contribution 
shall, except as herein expressly provided, be construed as conferring 
by implication, estoppel or otherwise, any license or right under (i) 
any existing or later issuing patent, whether or not the use of 
information in the document necessarily employs an invention of any 
existing or later issued patent, (ii) any copyright, (iii) any 
trademark, or (iv) any other intellectual property right.

With respect to the Software necessary for the practice of any or 
all Normative portions of the EVRC-B Variable Rate Speech Codec as 
it exists on the date of submittal of this form, should the EVRC-B be 
approved as a Specification or Report by 3GPP2, or as a transposed 
Standard by any of the 3GPP2's Organizational Partners, the Source(s) 
state(s) that a worldwide license to reproduce, use and distribute the 
Software, the license rights to which are held by the Source(s), will 
be made available to applicants under terms and conditions that are 
reasonable and non-discriminatory, which may include monetary compensation, 
and only to the extent necessary for the practice of any or all of the 
Normative portions of the EVRC-B or the field of use of practice of the 
EVRC-B Specification, Report, or Standard.  The statement contained above 
is irrevocable and shall be binding upon the Source(s).  In the event 
the rights of the Source(s) in and to copyright or copyright license 
rights subject to such commitment are assigned or transferred, the 
Source(s) shall notify the assignee or transferee of the existence of 
such commitments.
*******************************************************************/

static char const rcsid[]="$Id: //E-XMS/GIT/csa/Utilities/cpp/RtpCodecUtil/evrc_b/decoder_evrcb.cpp#1 $";

/*=======================================================================*/
/*  4GV - Fourth Generation Vocoder Speech Service Option for             */
/*  Wideband Spread Spectrum Digital System                             */
/*  C Source Code Simulation                                            */
/*                                                                      */
/*  Copyright (C) 1999 Qualcomm Incorporated. All rights                */
/*  reserved.                                                           */
/*----------------------------------------------------------------------*/

/*======================================================================*/
/*  4GV - Fourth Generation Vocoder Speech Service Option for             */
/*  Wideband Spread Spectrum Digital System                             */
/*  C Source Code Simulation                                            */
/*                                                                      */
/*  Copyright (C) 1999 Qualcomm Incorporated. All rights                */
/*  reserved.                                                           */
/*----------------------------------------------------------------------*/
/*======================================================================*/
/*  IS-127 Enhanced Variable Rate Codec, Speech Service Option 3 for    */
/*  Wideband Spread Spectrum Digital System                             */
/*  C Source Code Simulation                                            */
/*                                                                      */
/*  Copyright (C) 1996 Lucent Technologies Incorporated. All rights     */
/*  reserved.                                                           */
/*----------------------------------------------------------------------*/
/*  Module:     main.c                                                  */
/*----------------------------------------------------------------------*/
/*  History:                                                            */
/*     11/20/95  Born                                                   */
/*----------------------------------------------------------------------*/
/*#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef WIN32
#include <iostream>
using namespace std;

#else
#include  <unistd.h>
#endif

#include "preproc.h"*/
#include "struct.h"
/*#include "rda.h"

#include "hpf80.h"
#include "io.h"

#define PROGRAM_VERSION "1.5"
#define PROGRAM_DATE    "01 Nov 2006"*/

int apiEVRCBdecode(const char*payload, int ibuf_len, short *buf, short rate, FGV_MEM* FGV_B)
{
	int16  obuf_len;
	int16  k;

	int16 i,j;

	short run_length = 0;
	short phase_offset = 10;
	float time_warp_fraction = 1;


	obuf_len = 160;


	for (k=0;k<FSIZE;k++) FGV_B->buf[k]=0.0;

	int16 *buf16 = FGV_B->buf16;

	int flag = ibuf_len%2;

	ibuf_len = ibuf_len/2;
	for(i=0,j=0; i<ibuf_len; i++,j++)
	{
		buf16[i] = ((int16)((unsigned char)payload[j])) << 8;
		j++;
		buf16[i] = buf16[i] | ((unsigned char)payload[j]);
	}

    if(0 != flag)
	{
        buf16[i] = ((int16)((unsigned char)payload[ibuf_len*2])) << 8;
		buf16[i] = buf16[i] | ((unsigned char)0);
	}

	FGV_B->decode(FGV_B->buf16,rate,1,FGV_B->buf, run_length, phase_offset, time_warp_fraction, &obuf_len);

	for (FGV_B->buf16P=FGV_B->buf16,FGV_B->bufP=FGV_B->buf,k=0; k<obuf_len; k++,FGV_B->buf16P++,FGV_B->bufP++) {
	  if (*(FGV_B->bufP) > 32767.0) *FGV_B->buf16P = (int16)32767;
	  else if (*(FGV_B->bufP) < -32767.0) *FGV_B->buf16P = (int16)-32767;
	  else *FGV_B->buf16P = (int16)*(FGV_B->bufP);
	}

	memcpy((void*)buf, (void*)FGV_B->buf16, 320);

	return obuf_len;
}
