/**********************************************************************
Each of the companies; Motorola, and Lucent, and Qualcomm, and Nokia (hereinafter 
referred to individually as "Source" or collectively as "Sources") do 
hereby state:

To the extent to which the Source(s) may legally and freely do so, the 
Source(s), upon submission of a Contribution, grant(s) a free, 
irrevocable, non-exclusive, license to the Third Generation Partnership 
Project 2 (3GPP2) and its Organizational Partners: ARIB, CCSA, TIA, TTA, 
and TTC, under the Source's copyright or copyright license rights in the 
Contribution, to, in whole or in part, copy, make derivative works, 
perform, display and distribute the Contribution and derivative works 
thereof consistent with 3GPP2's and each Organizational Partner's 
policies and procedures, with the right to (i) sublicense the foregoing 
rights consistent with 3GPP2's and each Organizational Partner's  policies 
and procedures and (ii) copyright and sell, if applicable) in 3GPP2's name 
or each Organizational Partner's name any 3GPP2 or transposed Publication 
even though this Publication may contain the Contribution or a derivative 
work thereof.  The Contribution shall disclose any known limitations on 
the Source's rights to license as herein provided.

When a Contribution is submitted by the Source(s) to assist the 
formulating groups of 3GPP2 or any of its Organizational Partners, it 
is proposed to the Committee as a basis for discussion and is not to 
be construed as a binding proposal on the Source(s).  The Source(s) 
specifically reserve(s) the right to amend or modify the material 
contained in the Contribution. Nothing contained in the Contribution 
shall, except as herein expressly provided, be construed as conferring 
by implication, estoppel or otherwise, any license or right under (i) 
any existing or later issuing patent, whether or not the use of 
information in the document necessarily employs an invention of any 
existing or later issued patent, (ii) any copyright, (iii) any 
trademark, or (iv) any other intellectual property right.

With respect to the Software necessary for the practice of any or 
all Normative portions of the EVRC-B Variable Rate Speech Codec as 
it exists on the date of submittal of this form, should the EVRC-B be 
approved as a Specification or Report by 3GPP2, or as a transposed 
Standard by any of the 3GPP2's Organizational Partners, the Source(s) 
state(s) that a worldwide license to reproduce, use and distribute the 
Software, the license rights to which are held by the Source(s), will 
be made available to applicants under terms and conditions that are 
reasonable and non-discriminatory, which may include monetary compensation, 
and only to the extent necessary for the practice of any or all of the 
Normative portions of the EVRC-B or the field of use of practice of the 
EVRC-B Specification, Report, or Standard.  The statement contained above 
is irrevocable and shall be binding upon the Source(s).  In the event 
the rights of the Source(s) in and to copyright or copyright license 
rights subject to such commitment are assigned or transferred, the 
Source(s) shall notify the assignee or transferee of the existence of 
such commitments.
*******************************************************************/

static char const rcsid[]="$Id: //E-XMS/GIT/csa/Utilities/cpp/RtpCodecUtil/evrc_b/lspq.cpp#1 $";

/*======================================================================*/
/*  4GV - Fourth Generation Vocoder Speech Service Option for             */
/*  Wideband Spread Spectrum Digital System                             */
/*  C Source Code Simulation                                            */
/*                                                                      */
/*  Copyright (C) 1999 Qualcomm Incorporated. All rights                */
/*  reserved.                                                           */
/*----------------------------------------------------------------------*/

/**************************************************************************
****        Globalstar Vocoder C/C++ Simulation  - Version 3           ****
****                Copyright 1996 - Qualcomm, Inc.                    ****
***************************************************************************

Globalstar Vocoder Main Defines File (defines, static arrays, etc.)
Sharath Manjunath; Ver 1 - 25 July 1996
		   Ver 2 - 12 October 1996
Modifications:	23 January 1997 - Quantization of ACELP Gains
		10 March 1997   - NELP SF Energies Quantization
		27 March 1997   - Added Hooks for Decode Only Case
	        11 April 1997   - Added option for compile to get 5 stage LSI
To Do: Selective NELP SFE Quantization, Update LSI MSVQ Quantization
**************************************************************************/

#include <stdio.h>

#ifdef WIN32
#include <iostream>
using namespace std;
#pragma warning( once : 4305 )
#else
#include  <unistd.h>
#include <iostream>
#endif

#include "defines.h"

#define K 8
#define VECDIM 10
//#define INFINITY 1e30

#define VECDIMa_NEW 6
#define VECDIMb_NEW 4
#define VECSIZEa_NEW 1024
#define VECSIZEb_NEW 64

/* 16-bit MA LSP VQ for voiced speech */
#ifdef NEWMALSPVQ
# if 0
static float cba_new[VECSIZEa_NEW][VECDIMa_NEW] = {
{  2.017699E-02,   3.247875E-02,   4.613430E-02,   5.239014E-02,   7.242569E-02,   9.421491E-02, },
{  4.548437E-03,   1.724272E-03,   4.839789E-02,   6.292462E-02,   7.571768E-02,   1.161559E-01, },
{  1.740299E-02,   2.289238E-02,   3.237878E-02,   4.165741E-02,   7.215573E-02,   9.967381E-02, },
{  1.533808E-02,   2.142540E-02,   4.660997E-02,   4.956320E-02,   9.173052E-02,   1.068373E-01, },
{  2.146210E-02,   2.746753E-02,   5.162166E-02,   5.366941E-02,   6.249662E-02,   8.102281E-02, },
{  1.634639E-02,   2.895356E-02,   9.543332E-02,   1.219438E-01,   1.065826E-01,   1.258989E-01, },
{  1.149055E-02,   1.522904E-02,   2.766180E-02,   3.833728E-02,   8.188299E-02,   1.023095E-01, },
{  1.306690E-02,   1.606736E-02,   5.527560E-02,   1.285115E-01,   1.480855E-01,   1.401152E-01, },
{  2.120657E-02,   2.776543E-02,   4.036344E-02,   6.744962E-02,   8.976594E-02,   9.731838E-02, },
{  2.227647E-02,   2.696392E-02,   3.284142E-02,   7.666880E-02,   8.736313E-02,   9.393009E-02, },
{  1.358891E-02,   1.878651E-02,   2.240999E-02,   3.085952E-02,   4.505269E-02,   6.048514E-02, },
{  1.486667E-02,   2.046185E-02,   4.520315E-02,   5.957670E-02,   1.174389E-01,   1.257631E-01, },
{  1.775144E-02,   2.739472E-02,   4.021676E-02,   5.706950E-02,   8.357243E-02,   8.767028E-02, },
{  1.595547E-02,   1.918809E-02,   4.151045E-02,   8.231509E-02,   8.914400E-02,   1.094128E-01, },
{  1.391870E-02,   1.891461E-02,   3.171433E-02,   5.708908E-02,   9.923576E-02,   9.834048E-02, },
{  1.380581E-02,   1.788116E-02,   3.764854E-02,   5.819270E-02,   8.771821E-02,   1.120415E-01, },
{  2.071893E-02,   3.376758E-02,   4.419503E-02,   5.920142E-02,   7.299111E-02,   8.718168E-02, },
{  1.138947E-02,   1.568082E-02,   3.435001E-02,   5.773872E-02,   8.576915E-02,   9.381439E-02, },
{  1.196059E-02,   1.468103E-02,   2.389708E-02,   5.194908E-02,   6.015165E-02,   1.014177E-01, },
{  1.767093E-02,   3.065930E-02,   4.454877E-02,   6.073852E-02,   1.015451E-01,   1.114008E-01, },
{  1.792927E-02,   2.302773E-02,   2.968053E-02,   4.096594E-02,   4.404763E-02,   5.590930E-02, },
{  3.133547E-02,   7.715580E-02,   7.941303E-02,   9.057902E-02,   1.035149E-01,   1.166027E-01, },
{  1.217546E-02,   1.591787E-02,   3.300876E-02,   6.063904E-02,   6.950519E-02,   8.989113E-02, },
{  9.277439E-03,   1.132545E-02,   4.488470E-02,   8.262527E-02,   8.880470E-02,   1.120468E-01, },
{  2.329855E-02,   3.335763E-02,   4.833462E-02,   7.712966E-02,   8.419348E-02,   9.368254E-02, },
{  2.091246E-02,   2.653604E-02,   4.855137E-02,   8.149972E-02,   8.682100E-02,   1.096638E-01, },
{  1.617141E-02,   2.199936E-02,   2.786511E-02,   3.775961E-02,   6.014976E-02,   8.230177E-02, },
{  1.884726E-02,   2.418347E-02,   3.185740E-02,   6.142039E-02,   9.066546E-02,   1.179641E-01, },
{  1.521085E-02,   1.980447E-02,   4.799168E-02,   6.466720E-02,   7.895684E-02,   8.400878E-02, },
{  1.898662E-02,   3.284197E-02,   5.357287E-02,   7.583489E-02,   1.052570E-01,   1.162408E-01, },
{  9.112629E-03,   1.094493E-02,   2.908796E-02,   2.788889E-02,   6.503532E-02,   1.039870E-01, },
{  2.222694E-02,   2.627151E-02,   4.074047E-02,   7.401063E-02,   1.075486E-01,   1.226059E-01, },
{  3.042186E-02,   3.842936E-02,   5.362064E-02,   7.037108E-02,   7.476793E-02,   1.086751E-01, },
{  1.310502E-02,   1.641117E-02,   5.518719E-02,   5.931174E-02,   7.549062E-02,   1.046553E-01, },
{  2.421688E-02,   3.041859E-02,   4.209798E-02,   5.266572E-02,   6.174548E-02,   1.123060E-01, },
{  1.420606E-02,   1.750896E-02,   3.323680E-02,   5.320513E-02,   7.042648E-02,   1.281398E-01, },
{  2.033797E-02,   2.711490E-02,   4.454248E-02,   4.726487E-02,   6.442315E-02,   8.635864E-02, },
{  3.264339E-03,   6.712838E-03,   7.145266E-02,   8.241447E-02,   9.940168E-02,   1.188957E-01, },
{  1.073976E-02,   1.336512E-02,   1.757157E-02,   4.533423E-02,   6.558635E-02,   8.927178E-02, },
{  1.428653E-02,   1.747249E-02,   6.660896E-02,   1.054070E-01,   1.084305E-01,   1.128192E-01, },
{  1.625926E-02,   1.983034E-02,   5.760950E-02,   7.613715E-02,   8.014674E-02,   1.012986E-01, },
{  1.260386E-02,   1.561636E-02,   4.468972E-02,   8.269521E-02,   9.377667E-02,   1.014348E-01, },
{  1.582259E-02,   2.018862E-02,   1.884460E-02,   2.786521E-02,   6.142968E-02,   7.754399E-02, },
{  1.586725E-02,   2.363601E-02,   3.679852E-02,   7.304742E-02,   1.462226E-01,   1.341549E-01, },
{  2.053700E-02,   2.626847E-02,   4.906115E-02,   6.162774E-02,   6.944220E-02,   8.387575E-02, },
{  1.474496E-02,   2.307407E-02,   6.551777E-02,   7.780196E-02,   9.276142E-02,   9.249960E-02, },
{  9.930763E-03,   9.994547E-03,   2.895742E-02,   5.499814E-02,   9.063033E-02,   1.112834E-01, },
{  2.114108E-02,   2.676094E-02,   4.045252E-02,   8.038043E-02,   1.262487E-01,   1.305108E-01, },
{  2.299144E-02,   4.269292E-02,   6.330181E-02,   6.349155E-02,   7.365540E-02,   9.094412E-02, },
{  1.723518E-02,   2.066397E-02,   3.815584E-02,   7.597569E-02,   8.406764E-02,   9.474467E-02, },
{  1.897005E-02,   2.229227E-02,   3.259903E-02,   4.041292E-02,   4.933997E-02,   1.202367E-01, },
{  2.106088E-02,   3.816491E-02,   4.803337E-02,   5.799232E-02,   8.430802E-02,   8.949979E-02, },
{  1.913087E-02,   2.833543E-02,   3.423150E-02,   5.658871E-02,   6.262927E-02,   6.615196E-02, },
{  1.340069E-02,   5.638127E-02,   1.314150E-01,   1.101840E-01,   8.850108E-02,   1.059199E-01, },
{  1.940067E-02,   2.462596E-02,   3.023805E-02,   6.228973E-02,   6.438488E-02,   7.952422E-02, },
{  1.395237E-02,   1.691991E-02,   1.858416E-02,   8.220373E-02,   1.068730E-01,   1.060895E-01, },
{  2.483113E-02,   3.281337E-02,   4.519390E-02,   7.327629E-02,   7.967140E-02,   1.015656E-01, },
{  1.112950E-02,   1.678479E-02,   1.892029E-02,   7.461304E-02,   9.084870E-02,   9.716331E-02, },
{  1.155870E-02,   1.608523E-02,   1.618202E-02,   4.132788E-02,   4.974555E-02,   9.018013E-02, },
{  4.913697E-03,   9.599810E-03,   1.431667E-02,   4.365523E-02,   1.104780E-01,   1.272584E-01, },
{  1.226020E-02,   1.581880E-02,   4.392374E-02,   5.746729E-02,   6.639231E-02,   8.955053E-02, },
{  2.331304E-02,   2.959305E-02,   4.381082E-02,   8.367359E-02,   8.856211E-02,   9.218106E-02, },
{  1.092625E-02,   1.516155E-02,   1.355779E-02,  -1.840691E-02,   5.505983E-02,   8.693460E-02, },
{  8.374553E-03,   1.478288E-02,   6.728583E-02,   6.824677E-02,   1.198102E-01,   1.127241E-01, },
{  2.157059E-02,   2.902514E-02,   4.136404E-02,   5.555848E-02,   6.352452E-02,   9.406638E-02, },
{  1.505335E-02,   1.840495E-02,   3.442100E-02,   6.813537E-02,   7.178347E-02,   1.010338E-01, },
{  1.531827E-02,   1.928026E-02,   4.285930E-02,   4.647639E-02,   6.130041E-02,   8.042894E-02, },
{  2.977480E-03,   5.192068E-03,   5.470674E-02,   5.770749E-02,   9.893079E-02,   1.012340E-01, },
{  2.918410E-02,   3.761962E-02,   4.497162E-02,   6.133674E-02,   6.349609E-02,   8.620983E-02, },
{  9.221297E-03,   2.999911E-02,   1.275874E-01,   1.024791E-01,   1.207742E-01,   1.318636E-01, },
{  8.095198E-03,   1.030628E-02,   1.336074E-02,   3.210572E-02,   8.125053E-02,   1.017212E-01, },
{  1.263686E-02,   1.557137E-02,   1.533369E-02,   9.080391E-02,   1.216256E-01,   1.148420E-01, },
{  1.542076E-02,   2.067158E-02,   4.924643E-02,   7.905457E-02,   8.451841E-02,   8.306566E-02, },
{  1.291647E-02,   1.620991E-02,   5.380358E-02,   8.707938E-02,   9.162560E-02,   8.693370E-02, },
{  1.211426E-02,   1.657993E-02,   2.832412E-02,   3.027308E-02,   2.184825E-02,   6.030287E-02, },
{  1.532719E-02,   2.068672E-02,   2.383086E-02,   6.613539E-02,   1.060231E-01,   1.318274E-01, },
{  1.812837E-02,   2.249584E-02,   3.221678E-02,   6.641265E-02,   7.137030E-02,   8.290484E-02, },
{  2.433811E-02,   3.267257E-02,   5.893971E-02,   8.606325E-02,   8.892006E-02,   1.151853E-01, },
{  7.146595E-03,   7.126715E-03,   1.421759E-02,   5.099842E-02,   9.802030E-02,   1.037037E-01, },
{  2.252108E-02,   2.629262E-02,   4.530183E-02,   7.693447E-02,   1.051258E-01,   1.128501E-01, },
{  2.901030E-02,   3.574438E-02,   4.879251E-02,   6.629650E-02,   7.321051E-02,   8.599658E-02, },
{  1.391637E-02,   2.250339E-02,   3.979060E-02,   4.804909E-02,   8.505359E-02,   9.123988E-02, },
{  1.082784E-02,   1.200838E-02,   2.639393E-02,   4.458541E-02,   6.407778E-02,   1.209462E-01, },
{  1.537828E-02,   2.271123E-02,   3.624196E-02,   5.380582E-02,   1.028153E-01,   1.101227E-01, },
{  1.727095E-02,   2.261639E-02,   3.610639E-02,   7.102333E-02,   6.133576E-02,   7.367833E-02, },
{  2.871336E-02,   4.217762E-02,   7.428286E-02,   9.024320E-02,   1.093638E-01,   1.255733E-01, },
{  1.091344E-02,   1.640563E-02,   1.663757E-02,   5.920109E-02,   8.506068E-02,   9.496120E-02, },
{  1.478960E-02,   1.974554E-02,   3.884511E-02,   9.463674E-02,   1.088259E-01,   9.769627E-02, },
{  3.277742E-02,   5.738633E-02,   6.578534E-02,   7.272279E-02,   7.779411E-02,   8.354896E-02, },
{  1.780603E-02,   2.125164E-02,   5.043926E-02,   9.106517E-02,   8.214819E-02,   9.325451E-02, },
{  1.882153E-02,   2.457873E-02,   3.674215E-02,   4.990724E-02,   5.284731E-02,   6.984563E-02, },
{  1.234764E-02,   1.754746E-02,   2.781754E-02,   5.086186E-02,   1.061413E-01,   1.294858E-01, },
{  1.957420E-02,   2.544439E-02,   5.419941E-02,   7.405966E-02,   8.252364E-02,   8.802708E-02, },
{  1.835619E-02,   2.840494E-02,   4.172413E-02,   5.604003E-02,   9.757788E-02,   1.051299E-01, },
{  1.010845E-02,   1.394130E-02,   1.262792E-02,   3.879391E-02,   8.996367E-02,   1.166333E-01, },
{  1.873158E-02,   2.615028E-02,   3.368149E-02,   5.764396E-02,   1.106429E-01,   1.308779E-01, },
{  2.394083E-02,   2.989627E-02,   4.942437E-02,   5.638006E-02,   6.839170E-02,   1.132840E-01, },
{  1.405545E-02,   1.749429E-02,   4.841236E-02,   6.930706E-02,   7.544918E-02,   1.080256E-01, },
{  1.583343E-02,   1.830451E-02,   4.637198E-02,   5.178517E-02,   5.760442E-02,   1.182542E-01, },
{  1.020151E-02,   1.292385E-02,   3.490240E-02,   7.018381E-02,   9.080695E-02,   1.097456E-01, },
{  1.801167E-02,   2.266639E-02,   4.692888E-02,   5.382405E-02,   6.565278E-02,   6.422349E-02, },
{  1.022929E-02,   1.797328E-02,   9.359190E-02,   8.929078E-02,   1.239040E-01,   1.338253E-01, },
{  1.077252E-02,   1.639032E-02,   2.018753E-02,   4.260018E-02,   7.935295E-02,   7.615489E-02, },
{  1.096440E-02,   1.124945E-02,   7.041502E-02,   1.243952E-01,   1.135814E-01,   1.280742E-01, },
{  1.974123E-02,   2.385992E-02,   4.105194E-02,   6.736031E-02,   7.301763E-02,   8.861179E-02, },
{  4.390481E-03,   5.921926E-03,   5.418013E-02,   7.837507E-02,   8.708723E-02,   9.513121E-02, },
{  5.372070E-03,   7.536950E-03,   1.951401E-02,   4.930743E-02,   6.016624E-02,   6.244878E-02, },
{  1.268592E-02,   1.484316E-02,   2.382831E-02,   7.139440E-02,   1.260525E-01,   1.402098E-01, },
{  2.022281E-02,   2.761855E-02,   3.662689E-02,   6.772475E-02,   8.295484E-02,   7.586932E-02, },
{  1.420502E-02,   2.011072E-02,   7.322620E-02,   7.527966E-02,   8.673848E-02,   1.225917E-01, },
{  1.044615E-02,   1.258802E-02,   2.002669E-02,   5.852528E-02,   7.571769E-02,   1.037735E-01, },
{  1.839631E-02,   2.854892E-02,   3.614214E-02,   6.485911E-02,   1.091316E-01,   1.140818E-01, },
{  2.781523E-02,   4.806902E-02,   5.601836E-02,   6.895995E-02,   6.567271E-02,   7.117714E-02, },
{  1.272084E-02,   1.779906E-02,   2.192863E-02,   6.724898E-02,   8.253110E-02,   8.695286E-02, },
{  1.816219E-02,   2.143635E-02,   3.190507E-02,   3.755584E-02,   6.821242E-02,   1.283051E-01, },
{  1.755509E-02,   2.935315E-02,   4.380950E-02,   6.521741E-02,   9.508036E-02,   1.046691E-01, },
{  1.970508E-02,   2.552934E-02,   3.930553E-02,   4.786653E-02,   5.437936E-02,   8.076927E-02, },
{  1.456140E-02,   3.374544E-02,   7.970592E-02,   9.438460E-02,   1.032006E-01,   1.161548E-01, },
{  1.254021E-02,   1.869307E-02,   2.502363E-02,   4.745002E-02,   6.727120E-02,   6.453113E-02, },
{  1.890480E-02,   2.218918E-02,   4.602625E-02,   9.446239E-02,   9.930771E-02,   1.134703E-01, },
{  3.076965E-02,   3.976490E-02,   6.809391E-02,   8.123162E-02,   8.914848E-02,   1.172939E-01, },
{  2.113168E-02,   2.667804E-02,   3.663198E-02,   6.774890E-02,   1.012834E-01,   1.106191E-01, },
{  1.254015E-02,   1.733322E-02,   2.500843E-02,   2.884530E-02,   5.708722E-02,   9.177581E-02, },
{  1.494961E-02,   2.195896E-02,   2.753909E-02,   4.741632E-02,   1.061790E-01,   1.209860E-01, },
{  1.542365E-02,   2.052717E-02,   3.150580E-02,   4.938787E-02,   5.929995E-02,   8.269921E-02, },
{  2.477136E-02,   3.502809E-02,   5.504937E-02,   1.009507E-01,   9.814050E-02,   1.000485E-01, },
{  2.140547E-03,   5.432943E-03,   1.144482E-02,   1.531361E-02,   6.803262E-02,   9.481294E-02, },
{  1.438909E-02,   1.775833E-02,   3.996982E-02,   7.656893E-02,   8.984922E-02,   1.264812E-01, },
{  2.056809E-02,   3.790429E-02,   5.155328E-02,   6.035441E-02,   6.975576E-02,   7.644927E-02, },
{  1.791306E-02,   2.232038E-02,   3.581432E-02,   5.794728E-02,   6.738850E-02,   1.153306E-01, },
{  2.395748E-02,   3.106401E-02,   4.465618E-02,   5.586687E-02,   4.569519E-02,   1.010537E-01, },
{  1.189054E-02,   1.493856E-02,   5.329443E-02,   5.093915E-02,   9.003162E-02,   1.165685E-01, },
{  2.388112E-02,   3.332297E-02,   4.025440E-02,   4.940575E-02,   4.250983E-02,   6.302252E-02, },
{  2.382375E-02,   5.765958E-02,   9.265622E-02,   1.242902E-01,   1.215259E-01,   1.334003E-01, },
{  5.513841E-03,   4.747041E-03,   3.245656E-02,   3.550939E-02,   9.139678E-02,   1.069879E-01, },
{  1.573472E-02,   1.908277E-02,   3.118569E-02,   1.398652E-01,   1.319468E-01,   1.271327E-01, },
{  2.249561E-02,   2.877764E-02,   4.669652E-02,   7.013720E-02,   7.544043E-02,   9.182989E-02, },
{  2.621221E-02,   3.450988E-02,   3.012528E-02,   6.938832E-02,   9.286957E-02,   9.249997E-02, },
{  8.942313E-03,   1.330399E-02,   9.473300E-03,   2.251220E-02,   4.039366E-02,   7.555976E-02, },
{  1.488587E-02,   1.843153E-02,   4.133486E-02,   5.522937E-02,   1.007443E-01,   1.306439E-01, },
{  1.398944E-02,   2.000492E-02,   3.476138E-02,   6.462494E-02,   8.672043E-02,   9.141352E-02, },
{  1.838012E-02,   2.259786E-02,   5.219611E-02,   7.409216E-02,   8.106936E-02,   1.118493E-01, },
{  1.551834E-02,   2.060737E-02,   3.172813E-02,   3.890283E-02,   8.891291E-02,   9.359080E-02, },
{  1.630184E-02,   2.357645E-02,   2.934366E-02,   6.792309E-02,   1.049366E-01,   1.025137E-01, },
{  1.953843E-02,   3.955731E-02,   5.540157E-02,   6.034509E-02,   7.807854E-02,   8.936764E-02, },
{  1.466383E-02,   2.086192E-02,   2.819517E-02,   6.182044E-02,   9.139388E-02,   9.412517E-02, },
{  1.375805E-02,   1.703742E-02,   5.065813E-02,   2.734108E-02,   4.568600E-02,   9.383906E-02, },
{  2.152253E-02,   3.927809E-02,   4.439674E-02,   5.416629E-02,   9.573271E-02,   1.120029E-01, },
{  1.100294E-02,   1.549346E-02,   2.325106E-02,   4.414870E-02,   5.202418E-02,   6.314795E-02, },
{  3.237129E-02,   7.449112E-02,   1.094652E-01,   1.123284E-01,   1.170360E-01,   1.296260E-01, },
{  3.748916E-03,   2.989488E-04,   3.751295E-02,   6.184539E-02,   8.301106E-02,   8.365525E-02, },
{  8.627373E-03,   9.234969E-03,   5.469951E-02,   9.234212E-02,   9.456439E-02,   9.582944E-02, },
{  2.711350E-02,   3.946085E-02,   5.132606E-02,   7.298095E-02,   8.697209E-02,   9.138281E-02, },
{  1.518880E-02,   1.828621E-02,   3.236559E-02,   7.716100E-02,   8.522712E-02,   1.039338E-01, },
{  9.277091E-03,   1.083171E-02,   3.455346E-02,   4.943473E-02,   5.367633E-02,   7.366951E-02, },
{  1.586837E-02,   2.337304E-02,   2.930283E-02,   4.729477E-02,   9.672550E-02,   1.122177E-01, },
{  9.072026E-03,   8.635786E-03,   5.411867E-02,   5.231262E-02,   6.828445E-02,   8.991403E-02, },
{  2.425126E-02,   3.241503E-02,   3.832982E-02,   8.060231E-02,   9.875039E-02,   1.019062E-01, },
{  1.271851E-02,   1.617134E-02,   2.513448E-02,   3.228980E-02,   6.669324E-02,   1.074638E-01, },
{  1.614184E-02,   2.187882E-02,   3.591268E-02,   6.518870E-02,   1.159916E-01,   1.232195E-01, },
{  2.507768E-02,   3.127383E-02,   4.641970E-02,   5.175427E-02,   8.053382E-02,   1.189329E-01, },
{  1.100013E-02,   1.492332E-02,   4.647105E-02,   5.626120E-02,   8.309829E-02,   9.384995E-02, },
{  2.117633E-02,   2.805466E-02,   4.502802E-02,   5.330428E-02,   6.367092E-02,   1.041649E-01, },
{  1.376714E-02,   1.727978E-02,   4.868936E-02,   6.615950E-02,   7.711219E-02,   1.337999E-01, },
{  1.961934E-02,   2.548778E-02,   3.860282E-02,   6.082034E-02,   6.527518E-02,   7.095866E-02, },
{  8.484291E-03,   1.090654E-02,   5.260550E-02,   1.064594E-01,   1.169485E-01,   1.493964E-01, },
{  1.142316E-02,   1.523504E-02,   2.462418E-02,   4.979848E-02,   7.167937E-02,   8.503621E-02, },
{  2.390824E-02,   3.160741E-02,   3.709028E-02,   1.049810E-01,   1.083897E-01,   9.819835E-02, },
{  2.055582E-02,   2.513885E-02,   5.024496E-02,   6.907119E-02,   7.178680E-02,   1.098587E-01, },
{  6.750337E-03,   5.859039E-03,   4.573860E-02,   7.240298E-02,   7.939578E-02,   1.094488E-01, },
{  8.361095E-03,   1.336298E-02,   1.816839E-02,   2.716211E-02,   7.928541E-02,   8.230546E-02, },
{  1.417397E-02,   2.002466E-02,   3.794175E-02,   5.949761E-02,   1.277864E-01,   1.605456E-01, },
{  1.764979E-02,   3.463446E-02,   5.154979E-02,   6.308770E-02,   7.916047E-02,   8.617295E-02, },
{  1.648615E-02,   2.501295E-02,   8.711032E-02,   1.148575E-01,   8.218017E-02,   1.041873E-01, },
{  1.133088E-02,   1.490669E-02,   2.962531E-02,   6.753262E-02,   9.056436E-02,   9.591735E-02, },
{  1.428247E-02,   1.723447E-02,   2.933368E-02,   7.382032E-02,   1.045931E-01,   1.100603E-01, },
{  2.218001E-02,   4.374704E-02,   6.028049E-02,   6.498372E-02,   7.345216E-02,   7.534293E-02, },
{  1.612832E-02,   2.091733E-02,   3.024051E-02,   7.297852E-02,   7.829662E-02,   8.396848E-02, },
{  1.935827E-02,   2.268478E-02,   3.754214E-02,   4.367575E-02,   6.635286E-02,   1.218574E-01, },
{  2.007258E-02,   3.276682E-02,   3.669733E-02,   5.099705E-02,   9.422134E-02,   9.822448E-02, },
{  2.102394E-02,   2.897188E-02,   3.548442E-02,   5.057205E-02,   5.592877E-02,   7.082160E-02, },
{  1.027175E-02,   2.323011E-02,   9.963716E-02,   9.370287E-02,   9.359061E-02,   1.162529E-01, },
{  1.087582E-02,   1.476512E-02,   2.632638E-02,   6.156012E-02,   7.478257E-02,   8.056306E-02, },
{  1.480754E-02,   1.764167E-02,   3.041470E-02,   9.257700E-02,   1.007991E-01,   1.055582E-01, },
{  2.462674E-02,   3.151778E-02,   5.318328E-02,   7.046448E-02,   7.591493E-02,   9.579493E-02, },
{  1.461349E-02,   1.764543E-02,   3.162815E-02,   8.893679E-02,   8.626747E-02,   1.110185E-01, },
{  8.857517E-03,   1.115180E-02,   2.590487E-02,   3.728833E-02,   4.999082E-02,   9.243679E-02, },
{  1.072549E-02,   1.543587E-02,   2.384638E-02,   3.132002E-02,   9.484308E-02,   1.241837E-01, },
{  1.547104E-02,   2.027084E-02,   5.486665E-02,   5.890738E-02,   6.552946E-02,   8.787940E-02, },
{  1.502599E-02,   1.951680E-02,   6.619958E-02,   9.308999E-02,   9.559319E-02,   1.001661E-01, },
{  2.119399E-03,   1.488839E-03,   1.744308E-02,  -1.131702E-02,   7.213296E-02,   8.860678E-02, },
{  5.459763E-03,   4.485594E-03,   5.574665E-02,   9.576525E-02,   1.114021E-01,   1.289954E-01, },
{  2.405513E-02,   3.702498E-02,   4.840209E-02,   5.967111E-02,   6.619365E-02,   7.976551E-02, },
{  1.299813E-02,   1.700152E-02,   3.457162E-02,   5.333084E-02,   7.396351E-02,   9.714278E-02, },
{  1.336636E-02,   1.705404E-02,   2.800472E-02,   5.450557E-02,   5.535728E-02,   9.163663E-02, },
{  8.002247E-03,   1.031353E-02,   4.818459E-02,   7.596017E-02,   9.530676E-02,   1.288665E-01, },
{  2.045995E-02,   3.905342E-02,   5.275989E-02,   5.338823E-02,   6.608153E-02,   6.215352E-02, },
{  4.660379E-03,   1.732369E-02,   1.169888E-01,   1.061280E-01,   1.339893E-01,   1.555749E-01, },
{  1.272987E-02,   1.703755E-02,   3.174540E-02,   4.295365E-02,   8.150528E-02,   8.658902E-02, },
{  1.413461E-02,   1.597117E-02,   4.022562E-02,   1.095385E-01,   1.148796E-01,   1.215641E-01, },
{  2.045792E-02,   2.862510E-02,   4.486842E-02,   7.675208E-02,   9.049145E-02,   8.940981E-02, },
{  1.824463E-02,   2.323618E-02,   3.808663E-02,   7.153753E-02,   8.963325E-02,   9.486583E-02, },
{  1.044025E-02,   1.171749E-02,   3.033792E-02,   4.776789E-02,   3.432175E-02,   8.863192E-02, },
{  1.620543E-02,   2.273987E-02,   2.937031E-02,   6.759913E-02,   1.100030E-01,   1.235521E-01, },
{  1.511984E-02,   2.065771E-02,   3.141240E-02,   6.294540E-02,   7.829356E-02,   8.791505E-02, },
{  1.742879E-02,   2.177426E-02,   5.444184E-02,   9.083996E-02,   9.622348E-02,   1.170658E-01, },
{  5.603725E-03,   8.676967E-03,   2.259751E-02,   5.978147E-02,   9.037420E-02,   9.276509E-02, },
{  1.477546E-02,   2.045261E-02,   4.679557E-02,   6.213375E-02,   1.106310E-01,   1.167212E-01, },
{  2.496554E-02,   4.029833E-02,   4.299406E-02,   6.080973E-02,   7.927529E-02,   9.241896E-02, },
{  1.382050E-02,   1.883717E-02,   3.660823E-02,   5.509482E-02,   8.202045E-02,   8.620513E-02, },
{  1.484839E-02,   1.828061E-02,   3.798604E-02,   5.551167E-02,   6.068840E-02,   1.016080E-01, },
{  1.885894E-02,   3.134612E-02,   3.405343E-02,   4.857222E-02,   9.195026E-02,   1.182383E-01, },
{  1.508539E-02,   1.838027E-02,   3.696565E-02,   4.310050E-02,   5.584783E-02,   6.912038E-02, },
{  4.191570E-02,   7.168960E-02,   7.492454E-02,   6.178412E-02,   9.318558E-02,   1.078144E-01, },
{  2.368398E-03,   9.292097E-03,   2.662490E-02,   4.827095E-02,   7.651051E-02,   8.230894E-02, },
{  1.807505E-02,   2.364894E-02,   3.227238E-02,   8.225134E-02,   1.121423E-01,   1.055654E-01, },
{  2.040610E-02,   4.147734E-02,   5.775642E-02,   6.099444E-02,   9.002206E-02,   9.868455E-02, },
{  1.642525E-02,   1.989056E-02,   4.045601E-02,   8.673607E-02,   9.446568E-02,   1.162277E-01, },
{  1.565782E-02,   2.071209E-02,   2.972881E-02,   3.847324E-02,   4.536819E-02,   7.132462E-02, },
{  8.570382E-03,   9.845965E-03,   2.732299E-02,   4.824733E-02,   9.136889E-02,   1.319239E-01, },
{  1.908257E-02,   2.588197E-02,   4.991061E-02,   6.779939E-02,   7.562132E-02,   8.294676E-02, },
{  2.218631E-02,   4.092733E-02,   5.330252E-02,   6.413483E-02,   9.783566E-02,   1.110686E-01, },
{  1.208177E-02,   1.580604E-02,   2.838160E-02,   4.139227E-02,   8.976157E-02,   1.156221E-01, },
{  1.367652E-02,   1.782706E-02,   3.144650E-02,   6.359998E-02,   1.154359E-01,   1.295785E-01, },
{  2.440817E-02,   3.211228E-02,   4.428553E-02,   6.014686E-02,   6.646165E-02,   9.821805E-02, },
{  2.168443E-02,   2.793970E-02,   4.454876E-02,   5.893308E-02,   6.671065E-02,   1.060657E-01, },
{  1.899569E-02,   2.312777E-02,   4.842060E-02,   6.009443E-02,   7.082538E-02,   1.134947E-01, },
{  1.640294E-02,   2.040768E-02,   3.755331E-02,   6.990249E-02,   7.872420E-02,   1.089004E-01, },
{  1.944004E-02,   2.453169E-02,   4.413945E-02,   6.231820E-02,   6.847980E-02,   7.803793E-02, },
{  1.643963E-02,   3.243069E-02,   9.760329E-02,   1.001539E-01,   1.245620E-01,   1.175128E-01, },
{  7.412642E-03,   1.263097E-02,   4.198807E-02,   3.539239E-02,   6.886702E-02,   8.219776E-02, },
{  1.088844E-02,   1.444076E-02,   4.286588E-02,   9.433912E-02,   9.789364E-02,   1.240283E-01, },
{  1.940309E-02,   2.975278E-02,   4.775611E-02,   7.115624E-02,   8.864951E-02,   9.495689E-02, },
{  5.952160E-03,   2.595853E-03,   3.595306E-02,   6.434460E-02,   7.381600E-02,   1.002850E-01, },
{  1.689940E-03,  -4.186537E-03,   2.752788E-02,   5.074700E-02,   6.304737E-02,   8.038974E-02, },
{  1.313101E-02,   1.686070E-02,   3.478034E-02,   5.771947E-02,   1.247268E-01,   1.359654E-01, },
{  2.564802E-02,   3.611115E-02,   4.453651E-02,   6.378682E-02,   7.292905E-02,   8.134476E-02, },
{  9.253179E-03,   1.442176E-02,   6.760730E-02,   6.676494E-02,   9.090480E-02,   1.092560E-01, },
{  1.240425E-02,   1.555268E-02,   3.112327E-02,   5.540482E-02,   7.447956E-02,   1.117342E-01, },
{  1.220580E-02,   1.578806E-02,   2.907635E-02,   6.275490E-02,   1.047898E-01,   1.150716E-01, },
{  2.732297E-02,   3.930169E-02,   5.019616E-02,   6.248133E-02,   7.032091E-02,   8.394231E-02, },
{  1.602703E-02,   2.292871E-02,   3.231790E-02,   7.702241E-02,   9.631370E-02,   8.403173E-02, },
{  1.866141E-02,   2.175413E-02,   4.388484E-02,   4.652397E-02,   5.444971E-02,   1.322430E-01, },
{  2.123490E-02,   3.511054E-02,   4.591912E-02,   6.430713E-02,   9.313315E-02,   1.019426E-01, },
{  2.001116E-02,   2.682120E-02,   4.012801E-02,   4.425955E-02,   4.727145E-02,   7.335066E-02, },
{  6.435100E-03,   9.518159E-03,   9.065847E-02,   9.026228E-02,   1.113917E-01,   1.099405E-01, },
{  1.617957E-02,   2.172471E-02,   1.782066E-02,   5.834112E-02,   6.268644E-02,   6.815810E-02, },
{  2.014832E-02,   2.512785E-02,   4.176527E-02,   9.541237E-02,   1.095277E-01,   1.173856E-01, },
{  2.292135E-02,   3.443663E-02,   6.955652E-02,   8.180029E-02,   9.545894E-02,   1.027133E-01, },
{  1.711223E-02,   2.221980E-02,   3.477676E-02,   6.700297E-02,   9.662024E-02,   1.037149E-01, },
{  1.315137E-02,   1.665870E-02,   2.214608E-02,   2.902966E-02,   4.493884E-02,   1.052064E-01, },
{  1.102308E-02,   1.504533E-02,   2.113995E-02,   3.261760E-02,   9.846945E-02,   1.005551E-01, },
{  1.591186E-02,   2.886544E-02,   4.167309E-02,   3.865687E-02,   7.497532E-02,   7.798815E-02, },
{  2.422193E-02,   2.716409E-02,   4.848965E-02,   8.868967E-02,   9.605062E-02,   1.030092E-01, },
{  1.611911E-03,   4.480762E-03,  -3.886791E-04,   2.234290E-02,   8.427998E-02,   9.058037E-02, },
{  1.515223E-02,   1.867846E-02,   5.245223E-02,   8.043297E-02,   8.732629E-02,   1.459396E-01, },
{  2.599899E-02,   3.326190E-02,   5.002174E-02,   6.351748E-02,   7.091885E-02,   1.010574E-01, },
{  1.279021E-02,   1.630052E-02,   4.294074E-02,   6.484811E-02,   7.487640E-02,   9.743884E-02, },
{  1.915862E-02,   2.440432E-02,   4.157422E-02,   4.979281E-02,   6.458893E-02,   9.575012E-02, },
{  1.402867E-02,   1.800022E-02,   4.752038E-02,   6.810308E-02,   9.173104E-02,   1.102783E-01, },
{  2.332436E-02,   3.371871E-02,   4.336500E-02,   5.158219E-02,   5.799010E-02,   7.470336E-02, },
{  1.015476E-02,   1.906830E-02,   1.140118E-01,   1.447692E-01,   1.117668E-01,   1.215128E-01, },
{  1.026376E-02,   1.454400E-02,   2.609081E-02,   3.241053E-02,   8.514611E-02,   8.867758E-02, },
{  1.159576E-02,   1.759059E-02,   6.981061E-02,   1.041662E-01,   1.226657E-01,   1.122906E-01, },
{  2.052068E-02,   2.590016E-02,   3.817445E-02,   7.212251E-02,   8.576358E-02,   8.924501E-02, },
{  1.927773E-02,   2.398309E-02,   3.334648E-02,   8.269129E-02,   8.271442E-02,   9.212294E-02, },
{  3.374523E-03,   4.376128E-03,   3.196694E-02,   1.697132E-02,   6.285971E-02,   7.734112E-02, },
{  1.507108E-02,   2.033973E-02,   4.343933E-02,   5.352955E-02,   9.863135E-02,   1.180238E-01, },
{  2.184873E-02,   3.157028E-02,   4.282216E-02,   6.549653E-02,   8.631370E-02,   8.799402E-02, },
{  8.925583E-03,   1.135999E-02,   5.992771E-02,   9.862841E-02,   9.008706E-02,   1.310581E-01, },
{  1.509759E-02,   2.099851E-02,   2.960142E-02,   5.962358E-02,   9.329299E-02,   1.045940E-01, },
{  1.153708E-02,   1.497233E-02,   3.510540E-02,   5.703729E-02,   9.027520E-02,   1.038161E-01, },
{  2.399269E-02,   3.539506E-02,   4.499040E-02,   6.330494E-02,   8.039618E-02,   8.501282E-02, },
{  1.179249E-02,   1.684390E-02,   2.782041E-02,   6.476456E-02,   9.797358E-02,   9.070356E-02, },
{  1.841335E-02,   2.171775E-02,   3.481634E-02,   4.387790E-02,   5.690813E-02,   1.120348E-01, },
{  2.058422E-02,   3.366131E-02,   3.556656E-02,   5.224960E-02,   1.073344E-01,   1.223066E-01, },
{  1.489191E-02,   1.916092E-02,   3.956279E-02,   5.105715E-02,   4.938538E-02,   3.729884E-02, },
{  3.979306E-02,   5.740193E-02,   9.808309E-02,   1.170020E-01,   9.221900E-02,   1.196407E-01, },
{  8.122885E-03,   1.287926E-02,   3.866110E-02,   5.084251E-02,   6.295597E-02,   8.439716E-02, },
{  2.312444E-03,   1.032564E-05,   5.524535E-02,   8.797891E-02,   9.921809E-02,   1.124538E-01, },
{  2.719297E-02,   3.219257E-02,   4.843793E-02,   7.193358E-02,   8.310207E-02,   8.963312E-02, },
{  1.904957E-02,   2.319126E-02,   3.912419E-02,   7.794990E-02,   8.434908E-02,   1.136095E-01, },
{  1.478999E-02,   2.021531E-02,   3.153813E-02,   4.800700E-02,   4.883219E-02,   7.547466E-02, },
{  1.365779E-02,   1.812209E-02,   2.986828E-02,   5.489312E-02,   9.550583E-02,   1.203611E-01, },
{  1.223797E-02,   1.569144E-02,   4.482687E-02,   6.680732E-02,   6.293172E-02,   8.467969E-02, },
{  3.143463E-02,   3.297851E-02,   5.328258E-02,   8.492979E-02,   1.028611E-01,   1.057896E-01, },
{  1.459369E-02,   1.836392E-02,   2.677124E-02,   3.977294E-02,   6.284354E-02,   1.155754E-01, },
{  1.338105E-02,   1.765153E-02,   4.563559E-02,   7.520471E-02,   1.071729E-01,   1.318243E-01, },
{  2.961938E-02,   3.725953E-02,   5.185459E-02,   5.954196E-02,   7.091828E-02,   1.082267E-01, },
{  7.964667E-03,   9.935347E-03,   5.833729E-02,   6.522263E-02,   7.746804E-02,   9.786808E-02, },
{  2.362202E-02,   2.970938E-02,   4.544120E-02,   5.210104E-02,   6.286221E-02,   1.228906E-01, },
{  1.592163E-02,   2.245604E-02,   4.039635E-02,   6.032389E-02,   8.767682E-02,   1.313998E-01, },
{  2.348589E-02,   3.441890E-02,   3.879755E-02,   5.753128E-02,   6.461181E-02,   7.256910E-02, },
{  6.137011E-03,   8.576566E-03,   7.711483E-02,   1.016813E-01,   1.092267E-01,   1.315698E-01, },
{  1.192969E-02,   1.572260E-02,   2.752455E-02,   5.091844E-02,   6.805249E-02,   9.410036E-02, },
{  1.648328E-02,   2.306562E-02,   5.955320E-02,   1.127671E-01,   9.925937E-02,   1.219629E-01, },
{  1.846583E-02,   2.321151E-02,   5.139705E-02,   7.474002E-02,   7.510324E-02,   9.019126E-02, },
{  1.612360E-02,   2.178258E-02,   4.715623E-02,   8.417795E-02,   9.204819E-02,   9.594985E-02, },
{  1.084019E-02,   1.455214E-02,   2.345144E-02,   3.434942E-02,   6.907176E-02,   7.629285E-02, },
{  2.214845E-02,   3.731681E-02,   4.980011E-02,   6.934687E-02,   1.387885E-01,   1.467837E-01, },
{  1.759849E-02,   2.367655E-02,   5.095108E-02,   6.114435E-02,   7.387634E-02,   9.011591E-02, },
{  1.143073E-02,   1.634339E-02,   7.022680E-02,   8.557770E-02,   8.269419E-02,   1.032762E-01, },
{  5.034150E-03,   6.043725E-03,   2.597589E-02,   6.826866E-02,   9.960168E-02,   1.178218E-01, },
{  1.087875E-02,   1.484513E-02,   3.625630E-02,   7.862848E-02,   1.231600E-01,   1.247406E-01, },
{  1.790286E-02,   3.364456E-02,   5.667640E-02,   7.338869E-02,   7.342370E-02,   7.524300E-02, },
{  1.247415E-02,   1.786998E-02,   3.829363E-02,   6.357346E-02,   7.637321E-02,   8.561161E-02, },
{  1.886912E-02,   2.216343E-02,   3.390265E-02,   3.876196E-02,   6.383350E-02,   1.118878E-01, },
{  1.845089E-02,   3.017697E-02,   3.764229E-02,   5.201171E-02,   8.148708E-02,   9.796843E-02, },
{  1.882507E-02,   2.680442E-02,   4.907686E-02,   6.134569E-02,   5.353727E-02,   6.475925E-02, },
{  2.396166E-02,   6.998947E-02,   1.163665E-01,   9.499165E-02,   8.642259E-02,   9.062236E-02, },
{  1.571377E-02,   2.102034E-02,   2.838630E-02,   6.134923E-02,   7.034638E-02,   7.556564E-02, },
{  9.489777E-03,   6.314479E-03,   2.977442E-02,   7.874474E-02,   1.059098E-01,   1.115218E-01, },
{  2.706502E-02,   3.722602E-02,   6.134390E-02,   7.374523E-02,   8.096151E-02,   9.648418E-02, },
{  1.558293E-02,   2.102157E-02,   3.789068E-02,   6.404704E-02,   8.941075E-02,   9.901531E-02, },
{  3.689839E-03,  -3.256803E-03,   2.437059E-02,   2.419704E-02,   2.625071E-02,   9.998896E-02, },
{  7.664678E-03,   6.589273E-03,   1.253130E-02,   2.017274E-02,   1.168120E-01,   1.080445E-01, },
{  1.886314E-02,   2.420134E-02,   4.408668E-02,   5.927902E-02,   6.374656E-02,   8.402442E-02, },
{  2.247920E-02,   2.812869E-02,   4.671583E-02,   7.878347E-02,   8.420969E-02,   9.892771E-02, },
{  7.806912E-03,   1.062895E-02,  -2.658204E-03,   2.260853E-03,   6.043758E-02,   9.559103E-02, },
{  1.363508E-02,   1.981667E-02,   5.976759E-02,   7.503720E-02,   1.224587E-01,   1.252867E-01, },
{  2.259505E-02,   3.582435E-02,   4.693095E-02,   5.800370E-02,   6.354489E-02,   8.988063E-02, },
{  1.628984E-02,   2.055166E-02,   3.796727E-02,   6.170445E-02,   6.762355E-02,   9.257493E-02, },
{  1.287878E-02,   1.634711E-02,   4.597766E-02,   4.640548E-02,   5.665176E-02,   9.654348E-02, },
{  6.322193E-03,   8.095905E-03,   5.257995E-02,   5.546989E-02,   1.087350E-01,   1.223975E-01, },
{  2.992271E-02,   4.504331E-02,   4.845795E-02,   6.094912E-02,   7.790992E-02,   6.855871E-02, },
{  8.788923E-03,   1.659068E-02,   9.709379E-02,   1.030036E-01,   1.214441E-01,   1.487586E-01, },
{  1.217857E-02,   1.636701E-02,   2.190734E-02,   4.482294E-02,   7.949980E-02,   8.847397E-02, },
{  1.457409E-02,   1.692320E-02,   3.840008E-02,   9.622904E-02,   1.176266E-01,   1.219970E-01, },
{  2.390720E-02,   3.585388E-02,   4.459535E-02,   7.145938E-02,   8.003280E-02,   7.576426E-02, },
{  1.316554E-02,   1.643549E-02,   2.980152E-02,   7.947161E-02,   8.312609E-02,   9.032796E-02, },
{  1.168289E-02,   1.441664E-02,   2.683204E-02,   2.642278E-02,   2.726879E-02,   8.364395E-02, },
{  1.467555E-02,   2.061441E-02,   2.738834E-02,   5.421122E-02,   1.161716E-01,   1.254662E-01, },
{  1.660980E-02,   2.279703E-02,   4.306986E-02,   6.528750E-02,   7.254754E-02,   8.346804E-02, },
{  2.219295E-02,   2.897340E-02,   7.361217E-02,   9.808009E-02,   8.370855E-02,   1.264586E-01, },
{  9.986193E-03,   1.557308E-02,   1.793708E-02,   5.054372E-02,   1.041820E-01,   1.087823E-01, },
{  1.771283E-02,   2.240226E-02,   3.816140E-02,   6.906273E-02,   1.052519E-01,   1.238268E-01, },
{  2.696792E-02,   3.816712E-02,   5.455200E-02,   6.870723E-02,   7.654406E-02,   8.884296E-02, },
{  1.580913E-02,   2.477832E-02,   3.193618E-02,   5.452290E-02,   8.243711E-02,   8.475383E-02, },
{  1.120345E-02,   1.409331E-02,   3.972082E-02,   4.910075E-02,   7.027742E-02,   1.081835E-01, },
{  1.714046E-02,   2.826518E-02,   4.335815E-02,   5.062371E-02,   1.092520E-01,   1.197717E-01, },
{  9.247967E-03,   9.442923E-03,   4.232470E-02,   6.347714E-02,   6.183712E-02,   6.723353E-02, },
{  2.366710E-02,   5.000990E-02,   6.097954E-02,   7.639781E-02,   1.114591E-01,   1.377205E-01, },
{  7.153635E-03,   7.497279E-03,   3.036668E-02,   6.220948E-02,   6.682636E-02,   8.012770E-02, },
{  1.278575E-02,   1.491660E-02,   2.824869E-02,   9.298212E-02,   1.097185E-01,   1.103373E-01, },
{  2.912549E-02,   4.074913E-02,   5.205938E-02,   7.139898E-02,   8.024339E-02,   8.762156E-02, },
{  1.581055E-02,   1.898350E-02,   5.253120E-02,   8.459358E-02,   8.970007E-02,   1.014768E-01, },
{  1.827951E-02,   2.216544E-02,   3.507323E-02,   4.102996E-02,   4.741287E-02,   8.015882E-02, },
{  1.200989E-02,   1.617555E-02,   2.151395E-02,   5.351506E-02,   1.053259E-01,   1.252813E-01, },
{  6.572818E-03,   9.764429E-03,   6.376912E-02,   7.778806E-02,   7.447746E-02,   8.419107E-02, },
{  1.893770E-02,   2.439946E-02,   4.156638E-02,   6.921931E-02,   9.719600E-02,   1.075982E-01, },
{  8.232879E-03,   1.316679E-02,   1.389157E-02,   5.604989E-03,   1.003650E-01,   1.117649E-01, },
{  2.007001E-02,   3.413030E-02,   4.950589E-02,   7.017331E-02,   1.221044E-01,   1.199976E-01, },
{  3.163407E-02,   4.125733E-02,   5.264509E-02,   6.384484E-02,   6.548474E-02,   9.417089E-02, },
{  1.762709E-02,   2.132418E-02,   4.491323E-02,   6.294285E-02,   6.915218E-02,   9.943427E-02, },
{  2.245277E-02,   2.714780E-02,   4.283777E-02,   4.829383E-02,   5.357414E-02,   1.157988E-01, },
{  1.309955E-02,   1.696696E-02,   3.022883E-02,   7.296107E-02,   7.667473E-02,   1.096088E-01, },
{  1.890640E-02,   2.948302E-02,   4.331952E-02,   6.249177E-02,   7.298846E-02,   7.122432E-02, },
{  1.483366E-02,   2.286144E-02,   7.077068E-02,   1.015134E-01,   1.269828E-01,   1.317120E-01, },
{  1.525401E-02,   2.517735E-02,   3.014394E-02,   4.444054E-02,   7.364945E-02,   8.000347E-02, },
{  1.426637E-02,   1.752276E-02,   4.744677E-02,   1.028749E-01,   1.145039E-01,   1.334188E-01, },
{  2.389943E-02,   3.038932E-02,   5.388458E-02,   6.783254E-02,   7.978520E-02,   8.242037E-02, },
{  1.157922E-02,   1.269624E-02,   3.732977E-02,   8.673580E-02,   7.887326E-02,   9.646977E-02, },
{  7.912940E-03,   1.209513E-02,   1.165394E-02,   5.286375E-02,   6.625434E-02,   7.008211E-02, },
{  1.904757E-02,   2.512962E-02,   2.686913E-02,   7.475535E-02,   1.179007E-01,   1.398764E-01, },
{  2.758727E-02,   3.300526E-02,   3.977947E-02,   7.603474E-02,   6.403792E-02,   7.101061E-02, },
{  1.133938E-02,   1.682542E-02,   7.783628E-02,   8.540535E-02,   9.179700E-02,   1.129417E-01, },
{  1.218423E-02,   1.528762E-02,   2.466779E-02,   4.751115E-02,   7.359077E-02,   1.025366E-01, },
{  1.720963E-02,   2.408062E-02,   3.312471E-02,   5.977313E-02,   1.016358E-01,   1.149919E-01, },
{  3.227557E-02,   4.718862E-02,   5.738890E-02,   7.379523E-02,   7.072328E-02,   8.521764E-02, },
{  7.838527E-03,   1.100696E-02,   1.572514E-02,   7.172102E-02,   8.236127E-02,   8.886485E-02, },
{  1.935368E-02,   2.169023E-02,   2.748599E-02,   3.098545E-02,   5.672927E-02,   1.509402E-01, },
{  1.695667E-02,   2.551327E-02,   4.273283E-02,   6.543839E-02,   9.258628E-02,   9.798855E-02, },
{  2.373524E-02,   2.863935E-02,   3.872848E-02,   5.914312E-02,   5.691530E-02,   7.722986E-02, },
{  1.100662E-02,   2.809416E-02,   8.637756E-02,   8.638753E-02,   9.674811E-02,   9.920835E-02, },
{  1.006975E-02,   1.353991E-02,   3.392461E-02,   4.687385E-02,   6.728703E-02,   7.012154E-02, },
{  1.391395E-02,   1.582188E-02,   4.357116E-02,   9.333952E-02,   9.914866E-02,   1.093289E-01, },
{  2.955855E-02,   3.905132E-02,   5.608138E-02,   6.493489E-02,   7.676604E-02,   1.230007E-01, },
{  2.302547E-02,   3.192957E-02,   3.595866E-02,   6.685435E-02,   9.463611E-02,   9.989009E-02, },
{  1.751388E-02,   2.226060E-02,   3.445840E-02,   3.884953E-02,   5.851308E-02,   9.312227E-02, },
{  1.305741E-02,   1.752899E-02,   2.315482E-02,   5.554090E-02,   1.119815E-01,   1.142905E-01, },
{  1.735442E-02,   2.429493E-02,   2.960045E-02,   5.249490E-02,   6.394314E-02,   7.483511E-02, },
{  3.045961E-02,   4.498087E-02,   5.916244E-02,   7.873767E-02,   8.943266E-02,   9.556546E-02, },
{  6.162574E-03,   1.036511E-02,   3.018452E-02,   1.130674E-02,   7.610225E-02,   1.014711E-01, },
{  1.258272E-02,   1.727962E-02,   2.772240E-02,   7.685965E-02,   9.237673E-02,   1.483922E-01, },
{  2.223794E-02,   2.894979E-02,   4.707412E-02,   5.952776E-02,   6.713516E-02,   9.001402E-02, },
{  1.266740E-02,   1.540541E-02,   5.031353E-02,   6.871319E-02,   6.432721E-02,   1.003283E-01, },
{  2.281359E-02,   3.092372E-02,   4.428404E-02,   5.171031E-02,   5.742606E-02,   9.082704E-02, },
{  9.556140E-03,   1.116375E-02,   3.521447E-02,   5.157351E-02,   8.389982E-02,   1.157449E-01, },
{  2.712919E-02,   3.645462E-02,   4.401009E-02,   5.892179E-02,   5.813101E-02,   7.132809E-02, },
{  2.822248E-02,   8.149555E-02,   1.234187E-01,   1.382337E-01,   1.221444E-01,   1.324247E-01, },
{  8.343549E-03,   1.326757E-02,   1.776301E-02,   4.132765E-02,   9.255921E-02,   9.217725E-02, },
{  1.315752E-02,   1.534833E-02,   4.095973E-02,   1.147898E-01,   1.275004E-01,   1.180905E-01, },
{  2.333613E-02,   3.197543E-02,   4.754569E-02,   6.501931E-02,   7.603519E-02,   8.574599E-02, },
{  1.950199E-02,   2.465779E-02,   4.030043E-02,   7.558572E-02,   9.685009E-02,   1.038266E-01, },
{  8.914517E-03,   1.077029E-02,   1.592457E-02,  -7.251844E-04,   2.835490E-02,   7.336167E-02, },
{  1.793985E-02,   2.641711E-02,   4.029904E-02,   5.279456E-02,   9.879159E-02,   1.535311E-01, },
{  1.936748E-02,   2.551357E-02,   3.199980E-02,   6.261838E-02,   8.702062E-02,   9.086880E-02, },
{  1.655261E-02,   2.066593E-02,   6.047280E-02,   7.588098E-02,   8.196060E-02,   1.208410E-01, },
{  9.207167E-03,   1.209808E-02,   2.296865E-02,   4.604761E-02,   9.030021E-02,   9.895577E-02, },
{  1.449111E-02,   1.810137E-02,   3.378086E-02,   5.622435E-02,   1.073309E-01,   1.159677E-01, },
{  2.651695E-02,   4.354978E-02,   4.896944E-02,   6.633777E-02,   8.368195E-02,   8.638583E-02, },
{  1.756268E-02,   2.642071E-02,   3.595901E-02,   5.880322E-02,   8.829893E-02,   9.449306E-02, },
{  2.139214E-02,   2.645269E-02,   3.832979E-02,   4.362762E-02,   5.459877E-02,   1.028349E-01, },
{  1.554784E-02,   3.123913E-02,   4.788488E-02,   5.473898E-02,   9.371774E-02,   1.128749E-01, },
{  1.145921E-02,   1.502437E-02,   3.380640E-02,   5.322543E-02,   5.545181E-02,   5.260113E-02, },
{  3.948929E-02,   1.062714E-01,   1.189197E-01,   1.015280E-01,   1.117867E-01,   1.211310E-01, },
{  4.865493E-03,   1.099096E-03,   3.673660E-02,   4.749116E-02,   8.031729E-02,   9.530591E-02, },
{  1.254208E-02,   1.635889E-02,   4.483850E-02,   1.100567E-01,   9.056575E-02,   1.033305E-01, },
{  3.196430E-02,   3.621390E-02,   4.814444E-02,   7.749096E-02,   9.206474E-02,   9.726605E-02, },
{  1.536439E-02,   1.844557E-02,   4.174439E-02,   7.612869E-02,   8.504895E-02,   1.144308E-01, },
{  1.165442E-02,   1.535629E-02,   2.350371E-02,   3.585338E-02,   4.470600E-02,   7.857856E-02, },
{  1.730932E-02,   2.606500E-02,   2.961790E-02,   4.588902E-02,   9.873172E-02,   1.217809E-01, },
{  9.285505E-03,   1.842717E-02,   6.080849E-02,   6.261966E-02,   7.424768E-02,   8.155175E-02, },
{  2.185628E-02,   3.310676E-02,   4.317066E-02,   7.193280E-02,   1.029553E-01,   1.077609E-01, },
{  1.075460E-02,   1.312181E-02,   2.413819E-02,   3.576681E-02,   6.530348E-02,   9.622084E-02, },
{  1.486295E-02,   1.875446E-02,   3.408770E-02,   7.170266E-02,   1.104813E-01,   1.190493E-01, },
{  2.641333E-02,   3.492358E-02,   4.475432E-02,   6.111701E-02,   6.958067E-02,   1.309761E-01, },
{  1.278132E-02,   1.750499E-02,   4.253059E-02,   4.704645E-02,   7.875836E-02,   1.005170E-01, },
{  2.731648E-02,   3.306383E-02,   4.594393E-02,   5.340759E-02,   6.675166E-02,   1.093932E-01, },
{  1.390499E-02,   1.799122E-02,   4.828137E-02,   4.889549E-02,   7.514922E-02,   1.329747E-01, },
{  1.859558E-02,   2.570608E-02,   3.655853E-02,   4.812220E-02,   6.023946E-02,   7.567991E-02, },
{  1.194816E-02,   1.528388E-02,   6.865578E-02,   7.975380E-02,   1.165029E-01,   1.455292E-01, },
{  1.166374E-02,   1.390279E-02,   1.704171E-02,   6.105227E-02,   6.618477E-02,   9.020539E-02, },
{  1.270024E-02,   2.377192E-02,   6.096773E-02,   8.382383E-02,   1.029931E-01,   1.084016E-01, },
{  1.507387E-02,   3.104616E-02,   5.898633E-02,   6.867682E-02,   8.710654E-02,   1.032664E-01, },
{  1.296617E-02,   1.821033E-02,   5.149477E-02,   6.907398E-02,   8.494699E-02,   9.986313E-02, },
{  5.700113E-03,   8.021395E-03,   7.289399E-03,   3.760920E-02,   7.482159E-02,   7.623930E-02, },
{  1.411396E-02,   1.839170E-02,   3.379190E-02,   8.812639E-02,   1.349543E-01,   1.438487E-01, },
{  2.009461E-02,   2.482144E-02,   4.047376E-02,   6.826928E-02,   7.748926E-02,   8.457430E-02, },
{  1.691141E-02,   2.489877E-02,   8.991350E-02,   8.392862E-02,   8.206347E-02,   8.663212E-02, },
{  1.342293E-02,   1.767973E-02,   2.816608E-02,   6.153697E-02,   1.002814E-01,   1.067264E-01, },
{  2.134497E-02,   2.409457E-02,   2.944932E-02,   7.893699E-02,   1.034288E-01,   1.215309E-01, },
{  2.327876E-02,   4.060890E-02,   5.111766E-02,   6.248703E-02,   7.674031E-02,   8.127824E-02, },
{  8.894089E-03,   8.865018E-03,   4.004605E-02,   6.984351E-02,   7.827468E-02,   7.934665E-02, },
{  1.862925E-02,   2.656469E-02,   3.096593E-02,   4.150274E-02,   8.054524E-02,   1.157653E-01, },
{  1.715904E-02,   2.722483E-02,   3.389409E-02,   5.240255E-02,   9.280948E-02,   1.044719E-01, },
{  1.726714E-02,   2.654325E-02,   3.383467E-02,   4.200719E-02,   5.253385E-02,   6.681640E-02, },
{  8.457881E-03,   3.282512E-02,   1.162420E-01,   8.560431E-02,   9.141515E-02,   9.980198E-02, },
{  1.476752E-02,   2.010877E-02,   2.897956E-02,   5.837540E-02,   7.348493E-02,   8.473411E-02, },
{  1.670215E-02,   2.138737E-02,   2.678791E-02,   8.130454E-02,   9.999279E-02,   1.114363E-01, },
{  2.444899E-02,   3.650081E-02,   4.772292E-02,   7.452831E-02,   7.970840E-02,   1.099438E-01, },
{  1.698514E-02,   2.082391E-02,   2.729123E-02,   8.066765E-02,   9.981830E-02,   9.712416E-02, },
{  1.043975E-02,   1.145416E-02,   3.890807E-02,   4.877735E-02,   5.031862E-02,   9.902620E-02, },
{  1.084090E-02,   1.507730E-02,   1.849555E-02,   2.767579E-02,   1.115149E-01,   1.347792E-01, },
{  1.786550E-02,   2.189423E-02,   5.385242E-02,   6.056613E-02,   4.883777E-02,   8.266257E-02, },
{  2.119648E-02,   3.206086E-02,   5.548284E-02,   7.822802E-02,   9.949095E-02,   9.998103E-02, },
{  2.174640E-03,  -3.327869E-04,   1.976386E-02,   1.051926E-02,   6.849391E-02,   7.815277E-02, },
{  1.272788E-02,   1.551968E-02,   4.290670E-02,   7.822374E-02,   1.105201E-01,   1.124453E-01, },
{  2.263182E-02,   3.642591E-02,   5.552606E-02,   6.390729E-02,   5.871817E-02,   8.731143E-02, },
{  1.484914E-02,   1.997789E-02,   3.002956E-02,   5.518424E-02,   8.445769E-02,   9.134162E-02, },
{  1.759773E-02,   2.207383E-02,   4.009669E-02,   4.640949E-02,   5.595699E-02,   8.700344E-02, },
{  1.125535E-02,   1.306701E-02,   4.267463E-02,   6.199129E-02,   9.109763E-02,   1.196655E-01, },
{  2.456567E-02,   3.834126E-02,   4.890463E-02,   5.510650E-02,   6.273646E-02,   7.982997E-02, },
{  1.083866E-02,   2.397698E-02,   1.304575E-01,   1.262270E-01,   1.316193E-01,   1.476179E-01, },
{  1.385901E-02,   2.238638E-02,   2.278713E-02,   4.865484E-02,   8.522647E-02,   8.738758E-02, },
{  1.739459E-02,   2.004248E-02,   3.408201E-02,   9.966703E-02,   1.094578E-01,   1.147707E-01, },
{  2.843784E-02,   3.341265E-02,   5.208847E-02,   8.185692E-02,   9.285686E-02,   8.349011E-02, },
{  1.657201E-02,   2.274588E-02,   5.249144E-02,   6.863480E-02,   8.139601E-02,   9.382013E-02, },
{  9.550044E-03,   9.787398E-03,   2.176021E-02,   3.767412E-02,   1.935836E-02,   8.905565E-02, },
{  1.719228E-02,   2.149510E-02,   2.663867E-02,   5.758213E-02,   9.676388E-02,   1.237527E-01, },
{  1.855243E-02,   2.468624E-02,   3.510188E-02,   6.063308E-02,   7.919507E-02,   8.358708E-02, },
{  9.936852E-03,   1.409672E-02,   6.946001E-02,   8.568332E-02,   1.068278E-01,   1.222405E-01, },
{  7.415713E-03,   1.928408E-04,   1.280270E-02,   6.109373E-02,   9.060449E-02,   9.524086E-02, },
{  1.623189E-02,   1.987705E-02,   3.810113E-02,   8.473285E-02,   1.146056E-01,   1.199542E-01, },
{  2.144506E-02,   3.605592E-02,   5.023266E-02,   6.995492E-02,   8.115241E-02,   8.549543E-02, },
{  4.933934E-03,   1.806742E-02,   3.972157E-02,   5.560617E-02,   7.967100E-02,   8.072194E-02, },
{  1.921199E-02,   2.327872E-02,   4.233484E-02,   4.603347E-02,   6.372513E-02,   1.038398E-01, },
{  1.548886E-02,   2.367448E-02,   3.905779E-02,   5.153278E-02,   8.624490E-02,   1.143654E-01, },
{  1.681627E-02,   2.233587E-02,   3.797271E-02,   4.711895E-02,   4.919119E-02,   6.112078E-02, },
{  2.496898E-02,   6.750349E-02,   6.148431E-02,   8.687825E-02,   8.598502E-02,   1.097072E-01, },
{  5.938500E-03,   8.380995E-03,   1.120129E-02,   4.981027E-02,   8.255072E-02,   8.771057E-02, },
{  2.075766E-02,   2.574089E-02,   4.026173E-02,   8.927364E-02,   9.694068E-02,   9.217285E-02, },
{  2.360060E-02,   4.320366E-02,   5.028880E-02,   6.212697E-02,   9.004837E-02,   1.008713E-01, },
{  1.666369E-02,   1.985381E-02,   5.478602E-02,   8.431240E-02,   8.824166E-02,   1.141371E-01, },
{  1.882471E-02,   2.409265E-02,   2.876541E-02,   3.702326E-02,   4.859445E-02,   8.556039E-02, },
{  1.229886E-02,   1.629756E-02,   3.512328E-02,   4.741363E-02,   9.125299E-02,   1.284885E-01, },
{  1.398895E-02,   1.945373E-02,   5.169281E-02,   8.502908E-02,   5.677450E-02,   7.924180E-02, },
{  1.743957E-02,   2.517975E-02,   4.479414E-02,   7.742182E-02,   1.024858E-01,   9.537053E-02, },
{  1.288352E-02,   2.270993E-02,   2.242239E-02,   3.038807E-02,   9.225716E-02,   1.151791E-01, },
{  1.477303E-02,   1.901046E-02,   3.084250E-02,   6.225030E-02,   1.154338E-01,   1.146007E-01, },
{  2.100498E-02,   2.770876E-02,   5.127205E-02,   6.171256E-02,   7.034399E-02,   9.832722E-02, },
{  1.511360E-02,   1.895759E-02,   4.701429E-02,   5.466788E-02,   7.093770E-02,   9.809879E-02, },
{  1.792544E-02,   2.146124E-02,   4.444160E-02,   4.809205E-02,   7.275240E-02,   1.192102E-01, },
{  1.288270E-02,   1.659859E-02,   3.264119E-02,   6.551302E-02,   7.858308E-02,   1.191055E-01, },
{  2.118268E-02,   2.833311E-02,   5.849356E-02,   6.593202E-02,   6.592046E-02,   7.117618E-02, },
{  9.663038E-03,   2.758298E-02,   9.208857E-02,   8.208720E-02,   1.037238E-01,   1.266260E-01, },
{  1.122301E-02,   1.470382E-02,   3.395548E-02,   4.131745E-02,   6.880760E-02,   9.243520E-02, },
{  1.444207E-02,   1.629588E-02,   4.796751E-02,   1.010786E-01,   1.111132E-01,   1.139987E-01, },
{  1.792898E-02,   2.196458E-02,   4.561102E-02,   6.997085E-02,   7.620976E-02,   9.956429E-02, },
{  7.429552E-03,   8.722958E-03,   2.528140E-02,   7.552325E-02,   8.534224E-02,   1.144277E-01, },
{  9.532318E-04,  -1.790080E-04,   2.142853E-02,   2.873554E-02,   5.835916E-02,   6.806990E-02, },
{  1.049647E-02,   1.341440E-02,   1.588573E-02,   5.189050E-02,   1.224024E-01,   1.380873E-01, },
{  1.847657E-02,   3.669929E-02,   5.463709E-02,   5.833806E-02,   7.204936E-02,   7.851185E-02, },
{  1.435510E-02,   2.168282E-02,   5.711555E-02,   7.363146E-02,   9.349137E-02,   1.049243E-01, },
{  1.356717E-02,   1.787069E-02,   3.034902E-02,   4.914930E-02,   7.859029E-02,   1.079711E-01, },
{  7.960433E-03,   8.734673E-03,   1.731190E-02,   6.320779E-02,   1.142436E-01,   1.150666E-01, },
{  2.749036E-02,   4.165154E-02,   4.963616E-02,   6.753865E-02,   7.621891E-02,   8.510539E-02, },
{  1.651058E-02,   2.183837E-02,   3.072633E-02,   6.793939E-02,   8.393376E-02,   9.158440E-02, },
{  2.246808E-02,   2.746749E-02,   4.000294E-02,   4.473196E-02,   8.243233E-02,   1.284692E-01, },
{  2.793742E-02,   4.005259E-02,   4.424189E-02,   6.385754E-02,   9.381379E-02,   9.161928E-02, },
{  2.200342E-02,   2.963646E-02,   4.206550E-02,   5.125102E-02,   5.051043E-02,   8.117743E-02, },
{  1.027574E-02,   1.457768E-02,   8.321155E-02,   1.045318E-01,   9.785793E-02,   1.067814E-01, },
{  9.219193E-03,   1.078329E-02,   1.671907E-02,   4.836104E-02,   5.234426E-02,   7.815544E-02, },
{  1.563711E-02,   1.820442E-02,   4.343764E-02,   8.742377E-02,   1.091629E-01,   1.151506E-01, },
{  2.704968E-02,   3.559764E-02,   5.440482E-02,   8.009787E-02,   8.708649E-02,   1.104357E-01, },
{  1.410952E-02,   2.081970E-02,   4.536140E-02,   5.836404E-02,   9.395616E-02,   1.008095E-01, },
{  1.531255E-02,   1.889464E-02,   2.466303E-02,   4.217208E-02,   4.422734E-02,   1.008173E-01, },
{  1.082971E-02,   1.556793E-02,   2.553125E-02,   3.358139E-02,   1.089884E-01,   1.104306E-01, },
{  1.576337E-02,   2.112008E-02,   4.532982E-02,   5.332723E-02,   6.730361E-02,   7.472676E-02, },
{  2.180709E-02,   2.910514E-02,   4.754697E-02,   8.203667E-02,   9.182331E-02,   1.039495E-01, },
{  6.621230E-03,   9.533316E-03,   1.567027E-02,   3.007769E-02,   9.425495E-02,   9.967673E-02, },
{  1.464931E-02,   2.332903E-02,   6.464962E-02,   7.204189E-02,   9.536973E-02,   1.410298E-01, },
{  1.393632E-02,   2.054834E-02,   4.662026E-02,   5.575232E-02,   7.482363E-02,   8.711251E-02, },
{  8.758323E-03,   9.251885E-03,   4.288552E-02,   6.016100E-02,   6.863953E-02,   1.109609E-01, },
{  2.094302E-02,   2.742100E-02,   3.735355E-02,   4.356285E-02,   6.490756E-02,   9.802685E-02, },
{  1.400480E-02,   1.740425E-02,   4.695609E-02,   6.006256E-02,   8.208611E-02,   1.093717E-01, },
{  1.930245E-02,   2.456088E-02,   3.926039E-02,   5.554913E-02,   6.247940E-02,   7.590707E-02, },
{  1.687302E-02,   3.207367E-02,   1.080005E-01,   1.193308E-01,   1.185610E-01,   1.201404E-01, },
{  1.267945E-02,   1.716611E-02,   2.543628E-02,   3.855478E-02,   7.846043E-02,   9.574006E-02, },
{  1.734485E-02,   2.394049E-02,   5.141907E-02,   9.604980E-02,   1.584871E-01,   1.224827E-01, },
{  2.107694E-02,   3.141370E-02,   4.070751E-02,   6.492853E-02,   9.073921E-02,   9.431187E-02, },
{  1.482589E-02,   1.942447E-02,   3.194421E-02,   7.662051E-02,   8.986621E-02,   9.348818E-02, },
{  7.846413E-03,   9.513406E-03,   2.012508E-02,   3.033895E-02,   4.638605E-02,   6.595655E-02, },
{  1.397380E-02,   1.687131E-02,   4.325655E-02,   4.563284E-02,   1.135233E-01,   1.251338E-01, },
{  2.242911E-02,   2.968295E-02,   3.835522E-02,   6.497852E-02,   7.616106E-02,   8.098794E-02, },
{  1.310782E-02,   1.614793E-02,   5.396548E-02,   7.584178E-02,   8.140460E-02,   1.161651E-01, },
{  1.774685E-02,   2.490063E-02,   3.446746E-02,   5.893418E-02,   9.459517E-02,   1.073311E-01, },
{  1.066225E-02,   1.296222E-02,   3.959232E-02,   5.151627E-02,   9.650981E-02,   1.109332E-01, },
{  1.691014E-02,   2.881218E-02,   4.488787E-02,   6.077447E-02,   7.865074E-02,   8.268554E-02, },
{  1.175052E-02,   1.554532E-02,   2.666170E-02,   5.267510E-02,   8.335232E-02,   9.784005E-02, },
{  1.432988E-02,   1.742171E-02,   3.038908E-02,   5.089655E-02,   5.501435E-02,   1.093223E-01, },
{  2.234282E-02,   3.316874E-02,   4.143141E-02,   6.296199E-02,   1.004279E-01,   1.166677E-01, },
{  1.660246E-02,   2.267683E-02,   2.110983E-02,   4.362302E-02,   3.933736E-02,   3.660458E-02, },
{  4.739711E-02,   6.299704E-02,   8.299998E-02,   9.286358E-02,   1.014512E-01,   1.137900E-01, },
{  8.947307E-03,   9.023297E-03,   2.815413E-02,   5.334258E-02,   7.142524E-02,   9.446492E-02, },
{  7.407443E-03,   1.451424E-02,   5.707322E-02,   8.315843E-02,   9.203232E-02,   1.075463E-01, },
{  2.774402E-02,   3.602867E-02,   4.339630E-02,   7.072768E-02,   8.809414E-02,   9.320533E-02, },
{  1.624170E-02,   1.903670E-02,   4.992951E-02,   7.912172E-02,   8.415679E-02,   1.054177E-01, },
{  1.370928E-02,   1.903694E-02,   3.276609E-02,   4.549559E-02,   6.388518E-02,   7.726326E-02, },
{  1.550007E-02,   2.129879E-02,   3.638969E-02,   5.557910E-02,   9.568175E-02,   1.222585E-01, },
{  1.716324E-02,   2.657761E-02,   4.300665E-02,   4.959300E-02,   7.464716E-02,   8.216386E-02, },
{  2.561838E-02,   4.076767E-02,   4.747974E-02,   7.632811E-02,   1.115496E-01,   1.118715E-01, },
{  9.205919E-03,   6.119647E-03,   3.684157E-02,   3.635359E-02,   6.862369E-02,   1.107556E-01, },
{  1.702724E-02,   2.180624E-02,   4.643450E-02,   7.242612E-02,   1.135158E-01,   1.243776E-01, },
{  2.798908E-02,   3.531609E-02,   5.959610E-02,   6.633020E-02,   7.390208E-02,   1.083279E-01, },
{  1.332180E-02,   1.622935E-02,   6.025650E-02,   6.744980E-02,   7.398344E-02,   1.125091E-01, },
{  2.026706E-02,   2.397121E-02,   4.317534E-02,   4.990407E-02,   6.310951E-02,   1.146774E-01, },
{  1.397161E-02,   1.955844E-02,   2.677026E-02,   5.137222E-02,   7.926398E-02,   1.254107E-01, },
{  2.122141E-02,   3.224741E-02,   4.109677E-02,   5.408087E-02,   6.635696E-02,   8.053143E-02, },
{  9.321720E-03,   1.010414E-02,   6.548748E-02,   9.089755E-02,   9.804994E-02,   1.133397E-01, },
{  1.385278E-02,   1.813541E-02,   2.909483E-02,   4.779564E-02,   6.414149E-02,   1.000198E-01, },
{  2.004172E-02,   2.544068E-02,   6.278428E-02,   1.034667E-01,   1.077830E-01,   1.104905E-01, },
{  1.851682E-02,   2.299859E-02,   4.786814E-02,   7.832788E-02,   8.394481E-02,   1.000773E-01, },
{  1.669855E-02,   1.951802E-02,   5.047056E-02,   8.850464E-02,   9.443430E-02,   1.078356E-01, },
{  7.806336E-03,   7.582585E-03,   2.417730E-02,   3.850682E-02,   6.571728E-02,   8.374979E-02, },
{  1.392222E-02,   2.073464E-02,   2.896035E-02,   5.646798E-02,   1.490159E-01,   1.437590E-01, },
{  2.152306E-02,   2.635106E-02,   5.336282E-02,   6.868629E-02,   7.439274E-02,   7.450108E-02, },
{  1.204523E-02,   1.634082E-02,   7.249661E-02,   7.539285E-02,   8.619966E-02,   9.339899E-02, },
{  9.713203E-03,   1.256177E-02,   2.074491E-02,   5.703613E-02,   9.355055E-02,   1.093311E-01, },
{  1.591943E-02,   2.006401E-02,   3.007732E-02,   7.733424E-02,   1.166694E-01,   1.238210E-01, },
{  1.845095E-02,   3.691530E-02,   5.663943E-02,   7.042198E-02,   8.409772E-02,   9.380475E-02, },
{  1.564242E-02,   2.077319E-02,   3.899659E-02,   7.123853E-02,   8.132751E-02,   8.874550E-02, },
{  1.595952E-02,   1.864999E-02,   3.048374E-02,   3.471471E-02,   5.001536E-02,   1.194975E-01, },
{  2.144440E-02,   3.293250E-02,   4.379681E-02,   5.729870E-02,   8.877363E-02,   9.593644E-02, },
{  1.843583E-02,   2.950514E-02,   3.748840E-02,   4.912008E-02,   6.661154E-02,   6.974302E-02, },
{  1.426504E-02,   2.971794E-02,   1.140546E-01,   1.124929E-01,   9.568585E-02,   9.873397E-02, },
{  1.311363E-02,   1.738220E-02,   4.123707E-02,   6.258629E-02,   6.955480E-02,   7.686185E-02, },
{  1.127091E-02,   1.453179E-02,   1.578894E-02,   7.772853E-02,   1.061472E-01,   1.138087E-01, },
{  2.626770E-02,   3.347454E-02,   4.243782E-02,   7.658441E-02,   7.518777E-02,   9.182765E-02, },
{  1.225594E-02,   1.586557E-02,   3.745291E-02,   7.061746E-02,   8.896542E-02,   1.002527E-01, },
{  8.927349E-03,   1.176848E-02,   9.942472E-03,   3.360293E-02,   5.734500E-02,   9.506916E-02, },
{  9.101685E-03,   1.017148E-02,   1.947100E-02,   2.899673E-02,   1.143703E-01,   1.174388E-01, },
{  1.792335E-02,   2.628643E-02,   4.003911E-02,   5.448022E-02,   7.224550E-02,   9.016800E-02, },
{  1.799222E-02,   2.320675E-02,   4.502308E-02,   7.578284E-02,   9.122714E-02,   1.002122E-01, },
{  1.042575E-02,   1.423362E-02,   1.424013E-02,  -9.830125E-03,   6.760945E-02,   1.063956E-01, },
{  1.324361E-02,   2.734812E-02,   7.059836E-02,   8.092129E-02,   1.184749E-01,   1.188229E-01, },
{  2.349147E-02,   2.944021E-02,   4.926733E-02,   5.606457E-02,   6.573452E-02,   9.852327E-02, },
{  1.330456E-02,   1.792695E-02,   2.917120E-02,   6.311352E-02,   7.554723E-02,   9.962087E-02, },
{  1.860048E-02,   2.471291E-02,   3.886309E-02,   4.048495E-02,   6.046597E-02,   7.796476E-02, },
{  5.796139E-03,   2.671263E-03,   3.994569E-02,   6.402928E-02,   9.265896E-02,   1.015308E-01, },
{  2.439293E-02,   3.261954E-02,   4.500747E-02,   5.575331E-02,   6.069196E-02,   8.168970E-02, },
{  9.734107E-03,   1.553072E-02,   1.055976E-01,   1.149924E-01,   1.197701E-01,   1.305724E-01, },
{  1.102782E-02,   1.538942E-02,   1.401145E-02,   3.982878E-02,   8.129170E-02,   9.260337E-02, },
{  1.111254E-02,   1.362153E-02,   2.749068E-02,   9.794538E-02,   1.174043E-01,   1.240513E-01, },
{  2.265248E-02,   2.872608E-02,   4.169457E-02,   7.064226E-02,   7.966686E-02,   8.632394E-02, },
{  1.677627E-02,   2.048656E-02,   5.267737E-02,   7.855141E-02,   8.705654E-02,   9.326656E-02, },
{  8.749585E-03,   9.585666E-03,   2.639599E-02,   2.048716E-02,   3.200886E-02,   5.000599E-02, },
{  1.272519E-02,   1.766320E-02,   2.622571E-02,   6.513416E-02,   1.069834E-01,   1.276563E-01, },
{  2.189684E-02,   3.116973E-02,   4.115282E-02,   5.930227E-02,   7.347277E-02,   8.139128E-02, },
{  2.122909E-02,   2.462125E-02,   6.177166E-02,   9.295033E-02,   9.466185E-02,   1.189668E-01, },
{  1.008209E-02,   1.395559E-02,   1.763077E-02,   5.766147E-02,   1.034545E-01,   9.833443E-02, },
{  2.242399E-02,   2.968320E-02,   4.198881E-02,   8.100251E-02,   1.104241E-01,   1.137535E-01, },
{  3.430866E-02,   4.157231E-02,   5.200862E-02,   7.207436E-02,   7.611095E-02,   9.510172E-02, },
{  8.225203E-03,   2.646172E-02,   4.810114E-02,   5.408786E-02,   8.442562E-02,   8.787350E-02, },
{  1.299393E-02,   1.552483E-02,   3.777816E-02,   4.918366E-02,   5.879000E-02,   1.268083E-01, },
{  1.847924E-02,   2.844318E-02,   3.925803E-02,   5.630358E-02,   9.573017E-02,   1.176790E-01, },
{  1.395293E-02,   1.784008E-02,   3.651968E-02,   6.743067E-02,   5.268240E-02,   6.385001E-02, },
{  2.732660E-02,   4.604819E-02,   6.174632E-02,   1.130367E-01,   1.096790E-01,   1.191666E-01, },
{  1.062238E-02,   1.272666E-02,   2.655351E-02,   6.132423E-02,   7.971044E-02,   9.350007E-02, },
{  1.100936E-02,   1.550607E-02,   4.667465E-02,   8.301184E-02,   1.037604E-01,   1.097919E-01, },
{  3.049964E-02,   4.677598E-02,   5.755453E-02,   7.181891E-02,   8.182863E-02,   8.954516E-02, },
{  1.955513E-02,   2.344723E-02,   4.951376E-02,   8.484536E-02,   9.209087E-02,   1.036951E-01, },
{  1.950960E-02,   2.474458E-02,   3.391268E-02,   4.489760E-02,   5.263106E-02,   7.575303E-02, },
{  1.530754E-02,   2.080754E-02,   3.297257E-02,   5.645834E-02,   1.070897E-01,   1.244047E-01, },
{  1.710358E-02,   2.110494E-02,   6.040485E-02,   7.454502E-02,   7.944277E-02,   8.547102E-02, },
{  2.232754E-02,   3.270460E-02,   3.736605E-02,   5.794620E-02,   9.072865E-02,   1.090939E-01, },
{  9.119238E-03,   1.099410E-02,   1.624937E-02,   2.478341E-02,   8.528427E-02,   1.243111E-01, },
{  1.760340E-02,   2.798186E-02,   4.158148E-02,   5.183706E-02,   1.174682E-01,   1.338144E-01, },
{  2.739028E-02,   3.497185E-02,   4.807539E-02,   5.640921E-02,   6.276165E-02,   1.030446E-01, },
{  1.799089E-02,   2.150576E-02,   5.333967E-02,   6.807740E-02,   7.653545E-02,   1.065876E-01, },
{  1.538582E-02,   1.818708E-02,   3.816174E-02,   4.489460E-02,   6.269469E-02,   1.160894E-01, },
{  1.309859E-02,   1.619476E-02,   3.420315E-02,   7.486023E-02,   9.590028E-02,   1.155310E-01, },
{  1.563509E-02,   2.036917E-02,   4.362368E-02,   5.023553E-02,   5.833490E-02,   7.129235E-02, },
{  1.218768E-02,   1.968190E-02,   8.321258E-02,   8.938784E-02,   1.428977E-01,   1.435448E-01, },
{  1.079910E-02,   1.455196E-02,   2.797681E-02,   3.890403E-02,   7.541416E-02,   8.177247E-02, },
{  1.554339E-02,   1.852260E-02,   6.687989E-02,   1.161718E-01,   1.167415E-01,   1.221880E-01, },
{  1.478459E-02,   1.801471E-02,   4.764801E-02,   7.622182E-02,   8.023681E-02,   8.969499E-02, },
{  1.052079E-02,   1.174710E-02,   5.107736E-02,   6.830847E-02,   8.996201E-02,   9.177419E-02, },
{  1.536044E-03,   8.593575E-03,   2.627152E-02,   5.068293E-02,   6.786434E-02,   5.861022E-02, },
{  1.436968E-02,   1.713053E-02,   3.781892E-02,   7.438669E-02,   1.271869E-01,   1.339241E-01, },
{  2.010362E-02,   2.612399E-02,   3.350286E-02,   7.296919E-02,   7.511677E-02,   7.831064E-02, },
{  9.636811E-03,   1.573537E-02,   8.215805E-02,   7.088615E-02,   8.867266E-02,   1.188998E-01, },
{  1.155155E-02,   1.372160E-02,   1.335075E-02,   4.702937E-02,   7.709872E-02,   1.116277E-01, },
{  2.011055E-02,   2.642818E-02,   3.271788E-02,   6.084460E-02,   1.018536E-01,   1.206506E-01, },
{  2.961786E-02,   4.076309E-02,   4.917252E-02,   6.589685E-02,   6.629707E-02,   7.724146E-02, },
{  1.866485E-02,   2.538325E-02,   1.445812E-02,   6.572970E-02,   8.644153E-02,   9.247067E-02, },
{  1.643522E-02,   1.947476E-02,   3.653986E-02,   4.023791E-02,   7.278551E-02,   1.302477E-01, },
{  2.179911E-02,   2.776676E-02,   3.844598E-02,   6.754302E-02,   9.566121E-02,   1.043434E-01, },
{  2.095495E-02,   2.683494E-02,   3.130913E-02,   4.338745E-02,   6.225278E-02,   8.418869E-02, },
{  1.045012E-02,   4.621904E-02,   8.996192E-02,   9.455791E-02,   1.077489E-01,   1.137731E-01, },
{  1.570755E-02,   2.579912E-02,   2.597126E-02,   4.068256E-02,   6.401216E-02,   6.747222E-02, },
{  1.619469E-02,   1.870571E-02,   4.671076E-02,   9.378221E-02,   1.027357E-01,   1.092120E-01, },
{  4.009282E-02,   4.233134E-02,   6.631407E-02,   7.433956E-02,   8.197260E-02,   1.221306E-01, },
{  2.007734E-02,   3.062884E-02,   3.273709E-02,   5.895973E-02,   1.020398E-01,   1.072983E-01, },
{  1.472061E-02,   1.794642E-02,   2.979257E-02,   3.759512E-02,   5.629276E-02,   1.006823E-01, },
{  1.347547E-02,   1.825904E-02,   3.287771E-02,   4.119160E-02,   1.035832E-01,   1.132766E-01, },
{  1.508155E-02,   2.015553E-02,   3.804711E-02,   5.708145E-02,   6.441681E-02,   8.259794E-02, },
{  3.074109E-02,   3.764917E-02,   7.269148E-02,   1.020556E-01,   8.600576E-02,   9.783016E-02, },
{  3.371343E-03,  -3.197920E-04,   2.037311E-02,   1.292714E-02,   7.766175E-02,   9.880718E-02, },
{  1.323303E-02,   1.618691E-02,   4.726653E-02,   7.527808E-02,   9.938338E-02,   1.223063E-01, },
{  1.840537E-02,   3.169198E-02,   5.491208E-02,   6.451470E-02,   7.170613E-02,   8.538363E-02, },
{  1.556228E-02,   1.852325E-02,   3.626377E-02,   6.365859E-02,   6.919333E-02,   1.106793E-01, },
{  2.352478E-02,   2.869807E-02,   3.429586E-02,   5.491251E-02,   5.621874E-02,   9.672856E-02, },
{  8.983618E-03,   1.131668E-02,   5.523050E-02,   5.947902E-02,   8.216808E-02,   1.132449E-01, },
{  2.399935E-02,   3.471181E-02,   4.717349E-02,   5.313098E-02,   5.260551E-02,   6.043972E-02, },
{  2.133498E-02,   5.716271E-02,   1.184389E-01,   1.200471E-01,   1.189542E-01,   1.338608E-01, },
{  6.811771E-03,   9.630881E-03,   3.384033E-02,   4.809806E-02,   9.509526E-02,   9.811406E-02, },
{  1.298933E-02,   1.740321E-02,   6.819029E-02,   1.455544E-01,   1.252662E-01,   1.320285E-01, },
{  2.370536E-02,   3.020747E-02,   4.230115E-02,   7.187599E-02,   8.293665E-02,   9.349198E-02, },
{  2.018400E-02,   2.402838E-02,   3.322180E-02,   8.166001E-02,   9.288009E-02,   9.950165E-02, },
{  7.818039E-03,   1.136255E-02,  -1.281961E-03,   1.132940E-02,   5.969098E-02,   6.453270E-02, },
{  1.471413E-02,   1.980968E-02,   4.381753E-02,   5.296276E-02,   1.078819E-01,   1.398545E-01, },
{  1.512563E-02,   1.958633E-02,   4.051283E-02,   5.727385E-02,   8.039137E-02,   9.374186E-02, },
{  2.250312E-02,   2.736981E-02,   5.203422E-02,   7.406296E-02,   7.819079E-02,   1.065823E-01, },
{  1.483728E-02,   2.401470E-02,   2.580619E-02,   4.634131E-02,   9.322762E-02,   1.003972E-01, },
{  1.482669E-02,   1.791755E-02,   3.748254E-02,   6.510465E-02,   9.849043E-02,   1.134672E-01, },
{  2.352009E-02,   4.384816E-02,   5.510713E-02,   6.470485E-02,   8.379941E-02,   9.297448E-02, },
{  1.441303E-02,   2.060692E-02,   2.901056E-02,   5.944801E-02,   8.902651E-02,   9.860845E-02, },
{  1.192053E-02,   1.518188E-02,   3.854572E-02,   4.006546E-02,   5.067950E-02,   8.686898E-02, },
{  2.094153E-02,   3.433551E-02,   4.773771E-02,   5.411312E-02,   8.600418E-02,   1.068113E-01, },
{  1.392188E-02,   2.042500E-02,   2.748124E-02,   3.974135E-02,   5.524814E-02,   5.533823E-02, },
{  2.663646E-02,   7.425635E-02,   9.596237E-02,   9.274474E-02,   1.134584E-01,   1.364113E-01, },
{  3.867032E-03,   5.803127E-03,   2.887262E-02,   5.847437E-02,   7.897139E-02,   8.754519E-02, },
{  7.693186E-03,   9.177930E-03,   4.986922E-02,   1.047370E-01,   9.876424E-02,   1.041320E-01, },
{  2.226637E-02,   4.266775E-02,   5.928032E-02,   8.054599E-02,   8.568616E-02,   8.867234E-02, },
{  1.067421E-02,   1.750016E-02,   4.563706E-02,   6.705198E-02,   8.847706E-02,   1.017650E-01, },
{  1.096551E-02,   1.448285E-02,   3.337239E-02,   4.049550E-02,   4.576501E-02,   7.790931E-02, },
{  1.557200E-02,   2.127740E-02,   2.752759E-02,   4.897593E-02,   8.706324E-02,   1.170359E-01, },
{  4.658009E-03,   3.116453E-03,   4.483873E-02,   5.414321E-02,   6.274677E-02,   9.280898E-02, },
{  3.121119E-02,   3.982907E-02,   4.931892E-02,   7.999004E-02,   9.853307E-02,   1.014823E-01, },
{  1.253003E-02,   1.577948E-02,   2.279324E-02,   3.010948E-02,   6.718402E-02,   1.207042E-01, },
{  1.285623E-02,   1.561875E-02,   3.527222E-02,   6.648321E-02,   1.067436E-01,   1.238127E-01, },
{  1.935241E-02,   2.459510E-02,   5.247713E-02,   6.461671E-02,   7.638720E-02,   1.194878E-01, },
{  1.638084E-02,   2.551602E-02,   4.499814E-02,   5.524371E-02,   8.154253E-02,   1.026563E-01, },
{  1.856157E-02,   2.242445E-02,   5.309001E-02,   5.848944E-02,   5.861398E-02,   1.076048E-01, },
{  1.530388E-02,   1.908472E-02,   4.532496E-02,   6.478376E-02,   6.746827E-02,   1.412272E-01, },
{  2.256117E-02,   3.193459E-02,   4.180401E-02,   6.074430E-02,   6.703760E-02,   7.755833E-02, },
{  7.948651E-03,   9.999090E-03,   7.291212E-02,   9.624377E-02,   1.207044E-01,   1.526589E-01, },
{  1.290869E-02,   1.733416E-02,   2.876582E-02,   5.467818E-02,   6.799117E-02,   8.094031E-02, },
{  2.186960E-02,   3.713562E-02,   5.538446E-02,   9.514922E-02,   1.159804E-01,   9.791828E-02, },
{  1.974477E-02,   2.970192E-02,   5.701562E-02,   6.534646E-02,   7.521852E-02,   1.071081E-01, },
{  9.997164E-03,   1.327352E-02,   4.619017E-02,   6.945159E-02,   8.665682E-02,   1.068458E-01, },
{  1.000298E-02,   1.183381E-02,   1.591479E-02,   1.980916E-02,   6.534205E-02,   7.934827E-02, },
{  1.743860E-02,   2.549490E-02,   3.672470E-02,   5.266814E-02,   1.339835E-01,   1.718654E-01, },
{  2.384754E-02,   3.841133E-02,   4.405610E-02,   5.441187E-02,   7.391426E-02,   7.578908E-02, },
{  1.529037E-02,   2.031703E-02,   8.302731E-02,   9.868279E-02,   7.382987E-02,   9.044083E-02, },
{  9.498886E-03,   1.162757E-02,   3.538653E-02,   6.714149E-02,   1.000218E-01,   1.032125E-01, },
{  1.624407E-02,   2.201558E-02,   2.921004E-02,   6.823733E-02,   1.047385E-01,   1.116160E-01, },
{  2.654346E-02,   4.508181E-02,   5.127484E-02,   5.978295E-02,   6.737401E-02,   7.993594E-02, },
{  1.171906E-02,   1.574466E-02,   2.963462E-02,   7.480756E-02,   7.308786E-02,   7.811144E-02, },
{  2.306711E-02,   2.790416E-02,   3.976379E-02,   4.587048E-02,   6.854528E-02,   1.156816E-01, },
{  1.526309E-02,   3.381973E-02,   4.127626E-02,   4.535946E-02,   8.552431E-02,   9.259135E-02, },
{  1.920899E-02,   2.816750E-02,   3.047858E-02,   5.061642E-02,   5.737267E-02,   5.964818E-02, },
{  8.728478E-03,   1.602802E-02,   1.121923E-01,   9.614796E-02,   1.020787E-01,   1.256645E-01, },
{  1.340043E-02,   1.834433E-02,   2.818318E-02,   5.865609E-02,   8.035299E-02,   7.796843E-02, },
{  1.450107E-02,   1.732176E-02,   3.264306E-02,   7.953696E-02,   9.985061E-02,   1.061207E-01, },
{  2.670221E-02,   3.420285E-02,   5.108552E-02,   6.533193E-02,   7.249351E-02,   1.114690E-01, },
{  9.177726E-03,   1.308097E-02,   2.776736E-02,   8.403837E-02,   9.342735E-02,   1.031673E-01, },
{  1.155045E-02,   1.555367E-02,   2.677711E-02,   4.252499E-02,   5.882700E-02,   9.293993E-02, },
{  1.268490E-02,   2.016813E-02,   2.051894E-02,   3.865229E-02,   1.052577E-01,   1.230152E-01, },
{  1.806283E-02,   2.465310E-02,   5.799314E-02,   6.642219E-02,   6.398860E-02,   9.103245E-02, },
{  2.245169E-02,   2.753768E-02,   5.564948E-02,   8.550910E-02,   8.942751E-02,   9.807817E-02, },
{  6.939094E-03,   1.065195E-02,   1.860376E-02,  -4.732856E-03,   7.136740E-02,   7.723148E-02, },
{  6.229535E-03,   5.919501E-03,   6.231620E-02,   9.078528E-02,   1.239105E-01,   1.229570E-01, },
{  2.280886E-02,   3.858058E-02,   4.785368E-02,   5.716950E-02,   7.372174E-02,   8.360780E-02, },
{  1.465213E-02,   1.967087E-02,   2.804273E-02,   5.097373E-02,   7.495014E-02,   9.768220E-02, },
{  1.136805E-02,   1.388916E-02,   3.101383E-02,   5.688095E-02,   6.155951E-02,   8.672938E-02, },
{  6.687614E-03,   6.223236E-03,   5.052690E-02,   6.105727E-02,   9.410097E-02,   1.381369E-01, },
{  2.684098E-02,   4.194218E-02,   5.177096E-02,   5.736279E-02,   6.259237E-02,   6.896691E-02, },
{  1.449829E-02,   2.716935E-02,   9.941191E-02,   1.242856E-01,   1.405342E-01,   1.409914E-01, },
{  8.574665E-03,   1.087513E-02,   2.628288E-02,   4.587233E-02,   8.412548E-02,   9.170259E-02, },
{  1.412343E-02,   1.626386E-02,   3.413786E-02,   1.019740E-01,   1.107503E-01,   1.186436E-01, },
{  2.750210E-02,   3.378142E-02,   4.269944E-02,   8.178338E-02,   8.205062E-02,   9.015429E-02, },
{  1.436287E-02,   2.074994E-02,   4.503096E-02,   6.718099E-02,   8.684545E-02,   9.165085E-02, },
{  9.716318E-03,   1.129806E-02,   2.364368E-02,   4.918339E-02,   2.653440E-02,   6.592206E-02, },
{  1.884816E-02,   2.308384E-02,   3.294144E-02,   6.847513E-02,   1.009797E-01,   1.301696E-01, },
{  2.286748E-02,   2.730349E-02,   3.435752E-02,   7.028851E-02,   7.059550E-02,   8.467046E-02, },
{  1.635165E-02,   2.122921E-02,   5.091331E-02,   9.167393E-02,   1.028597E-01,   1.272909E-01, },
{  1.017377E-02,   1.491976E-02,   2.133428E-02,   5.798276E-02,   8.443021E-02,   8.558770E-02, },
{  1.460183E-02,   2.073223E-02,   5.080082E-02,   7.114033E-02,   1.056425E-01,   1.111843E-01, },
{  2.050320E-02,   3.217179E-02,   4.596412E-02,   6.483503E-02,   8.167420E-02,   8.973824E-02, },
{  1.487671E-02,   2.244821E-02,   3.970715E-02,   5.231930E-02,   9.333495E-02,   9.357676E-02, },
{  1.965716E-02,   2.335063E-02,   4.151801E-02,   5.524617E-02,   6.229937E-02,   1.058092E-01, },
{  1.944200E-02,   2.870941E-02,   3.301359E-02,   5.465472E-02,   8.652286E-02,   1.162796E-01, },
{  1.553518E-02,   2.061659E-02,   3.667101E-02,   5.154631E-02,   6.015941E-02,   6.791088E-02, },
{  1.952967E-02,   5.788021E-02,   7.557671E-02,   8.326265E-02,   1.019926E-01,   1.135880E-01, },
{  8.536062E-03,   7.239885E-03,   2.321343E-02,   4.430253E-02,   7.883027E-02,   8.287785E-02, },
{  2.065509E-02,   2.448000E-02,   3.673123E-02,   8.169222E-02,   1.021950E-01,   1.102860E-01, },
{  2.201062E-02,   4.512489E-02,   6.176856E-02,   6.737173E-02,   8.675215E-02,   9.735625E-02, },
{  1.779828E-02,   2.134089E-02,   4.078465E-02,   8.602714E-02,   1.010029E-01,   1.073731E-01, },
{  1.272718E-02,   1.676856E-02,   2.836548E-02,   4.583608E-02,   3.913139E-02,   6.118828E-02, },
{  1.204233E-02,   1.572443E-02,   3.239256E-02,   4.497214E-02,   1.037088E-01,   1.363748E-01, },
{  1.882379E-02,   2.233382E-02,   4.892731E-02,   7.335100E-02,   7.489855E-02,   8.206961E-02, },
{  2.086734E-02,   3.817604E-02,   4.938999E-02,   5.992583E-02,   9.214198E-02,   1.087651E-01, },
{  1.220596E-02,   1.696964E-02,   2.614102E-02,   3.921492E-02,   7.869226E-02,   1.150916E-01, },
{  1.541878E-02,   2.154877E-02,   2.722855E-02,   6.716368E-02,   1.209752E-01,   1.276564E-01, },
{  2.528765E-02,   3.361834E-02,   4.869484E-02,   6.985155E-02,   7.518045E-02,   1.037385E-01, },
{  2.171577E-02,   2.865864E-02,   4.366491E-02,   6.623344E-02,   7.271847E-02,   1.011112E-01, },
{  1.496722E-02,   1.841542E-02,   4.544643E-02,   5.748553E-02,   6.471466E-02,   1.139958E-01, },
{  2.063164E-02,   2.566604E-02,   4.407715E-02,   7.501540E-02,   8.062620E-02,   1.051506E-01, },
{  1.763169E-02,   2.473179E-02,   5.457448E-02,   6.175009E-02,   7.104986E-02,   7.652926E-02, },
{  8.037008E-03,   3.874894E-02,   1.070009E-01,   8.823013E-02,   1.188524E-01,   1.270676E-01, },
{  1.128582E-02,   1.464058E-02,   3.013888E-02,   3.761276E-02,   6.355113E-02,   8.255979E-02, },
{  8.813639E-03,   9.743391E-03,   4.768514E-02,   9.673334E-02,   1.091934E-01,   1.169322E-01, },
{  2.050932E-02,   2.473377E-02,   4.478461E-02,   7.695323E-02,   8.331868E-02,   9.224111E-02, },
{  7.783598E-03,   9.156605E-03,   3.891075E-02,   6.855569E-02,   8.002302E-02,   9.157219E-02, },
{  7.191617E-04,   3.431133E-03,   2.302044E-02,   4.669996E-02,   5.880043E-02,   7.563461E-02, },
{  1.293039E-02,   1.904603E-02,   2.601458E-02,   4.872895E-02,   1.224350E-01,   1.317470E-01, },
{  2.090718E-02,   3.227470E-02,   4.740544E-02,   6.113510E-02,   7.284956E-02,   7.928375E-02, },
{  1.619066E-02,   2.099928E-02,   6.070492E-02,   5.763042E-02,   8.794537E-02,   1.060232E-01, },
{  1.492572E-02,   2.099526E-02,   2.634824E-02,   4.831173E-02,   8.281038E-02,   1.051302E-01, },
{  1.586992E-02,   2.135378E-02,   2.593952E-02,   6.740353E-02,   1.100820E-01,   1.177115E-01, },
{  2.390420E-02,   3.840698E-02,   4.743241E-02,   6.854169E-02,   7.080520E-02,   8.774565E-02, },
{  1.423989E-02,   1.895399E-02,   3.291340E-02,   7.562146E-02,   8.919244E-02,   6.410746E-02, },
{  2.138437E-02,   2.551086E-02,   3.860922E-02,   4.075262E-02,   5.461093E-02,   1.341227E-01, },
{  2.233639E-02,   3.114054E-02,   4.578041E-02,   7.151920E-02,   9.392901E-02,   9.926005E-02, },
{  2.062722E-02,   2.570865E-02,   3.513499E-02,   3.823684E-02,   3.566584E-02,   8.118582E-02, },
{  8.955045E-03,   1.166258E-02,   9.179271E-02,   9.942281E-02,   1.078368E-01,   1.195057E-01, },
{  1.284398E-02,   1.706536E-02,   2.586056E-02,   6.014422E-02,   6.351044E-02,   7.085156E-02, },
{  1.398904E-02,   1.664043E-02,   3.486967E-02,   9.438733E-02,   1.105218E-01,   1.163475E-01, },
{  1.591188E-02,   4.105469E-02,   6.808043E-02,   7.860176E-02,   9.537904E-02,   1.112853E-01, },
{  1.684614E-02,   2.061633E-02,   3.762699E-02,   7.510386E-02,   9.468022E-02,   1.000412E-01, },
{  1.311694E-02,   1.561701E-02,   2.355469E-02,   1.824870E-02,   2.873295E-02,   1.094085E-01, },
{  1.190618E-02,   1.681286E-02,   2.740752E-02,   4.183846E-02,   9.771603E-02,   1.047206E-01, },
{  1.516442E-02,   2.036768E-02,   3.705029E-02,   4.672020E-02,   7.023918E-02,   8.537009E-02, },
{  2.911236E-02,   3.535819E-02,   4.175444E-02,   9.272050E-02,   9.406425E-02,   1.097566E-01, },
{ -1.761020E-05,  -1.854286E-03,   1.197604E-02,   3.490386E-02,   8.890644E-02,   1.007672E-01, },
{  1.433712E-02,   1.969422E-02,   4.996158E-02,   8.509464E-02,   9.483294E-02,   1.604944E-01, },
{  2.621614E-02,   3.572387E-02,   4.509404E-02,   5.305612E-02,   6.138136E-02,   8.984481E-02, },
{  1.132409E-02,   1.419806E-02,   3.928128E-02,   6.814754E-02,   7.966055E-02,   1.038929E-01, },
{  2.194649E-02,   3.026321E-02,   3.949850E-02,   4.773623E-02,   5.875377E-02,   8.599954E-02, },
{  1.536427E-02,   2.061768E-02,   4.845292E-02,   5.961266E-02,   9.824361E-02,   1.109931E-01, },
{  1.873916E-02,   3.080003E-02,   4.478670E-02,   4.803719E-02,   5.980126E-02,   6.423478E-02, },
{  1.252889E-02,   1.839948E-02,   9.835203E-02,   1.359044E-01,   9.917965E-02,   1.086786E-01, },
{  1.158098E-02,   1.513801E-02,   2.116881E-02,   2.748024E-02,   7.583544E-02,   9.736944E-02, },
{  1.156152E-02,   1.866218E-02,   6.447041E-02,   9.298393E-02,   1.392024E-01,   1.023491E-01, },
{  1.968105E-02,   2.513985E-02,   3.837521E-02,   7.083793E-02,   8.189347E-02,   9.513786E-02, },
{  1.609368E-02,   1.932043E-02,   3.909044E-02,   8.144689E-02,   8.791333E-02,   1.003541E-01, },
{  1.145783E-02,   1.622352E-02,   2.572385E-02,   2.888302E-02,   5.575769E-02,   7.060379E-02, },
{  1.649473E-02,   2.513433E-02,   4.265878E-02,   5.903698E-02,   1.024468E-01,   1.277951E-01, },
{  1.966739E-02,   2.696612E-02,   3.983889E-02,   6.535823E-02,   8.234109E-02,   8.962698E-02, },
{  1.202045E-02,   1.548668E-02,   5.795574E-02,   8.520279E-02,   8.852654E-02,   1.235741E-01, },
{  1.231940E-02,   1.617999E-02,   2.530684E-02,   4.948342E-02,   9.001706E-02,   1.070460E-01, },
{  1.328600E-02,   1.685423E-02,   3.673116E-02,   6.032882E-02,   8.085083E-02,   1.036504E-01, },
{  1.810037E-02,   3.416302E-02,   4.634240E-02,   5.569492E-02,   7.967522E-02,   8.529765E-02, },
{  1.134977E-02,   1.639684E-02,   3.401054E-02,   6.521585E-02,   9.190650E-02,   8.633030E-02, },
{  1.511517E-02,   1.799733E-02,   4.053402E-02,   4.579524E-02,   5.205211E-02,   1.099581E-01, },
{  2.231397E-02,   3.494103E-02,   4.268251E-02,   6.217641E-02,   1.009713E-01,   1.251215E-01, },
{  1.548379E-02,   1.964793E-02,   4.010969E-02,   5.265514E-02,   3.954133E-02,   5.275821E-02, },
{  1.986715E-02,   5.646308E-02,   1.029630E-01,   1.036828E-01,   1.073260E-01,   1.147098E-01, },
{  1.440078E-02,   1.829805E-02,   3.710253E-02,   5.198972E-02,   6.402480E-02,   9.078789E-02, },
{  5.586542E-03,   5.630434E-03,   3.899521E-02,   8.789331E-02,   9.719134E-02,   1.133463E-01, },
{  3.253646E-02,   4.283063E-02,   4.820789E-02,   7.828231E-02,   8.404305E-02,   9.128725E-02, },
{  2.034502E-02,   2.539416E-02,   3.880741E-02,   8.553068E-02,   9.402981E-02,   1.083012E-01, },
{  1.602536E-02,   2.084386E-02,   3.051091E-02,   5.521449E-02,   5.612074E-02,   7.846323E-02, },
{  1.245379E-02,   1.618886E-02,   3.024170E-02,   4.623642E-02,   1.023288E-01,   1.218591E-01, },
{  9.645765E-03,   1.134088E-02,   4.655281E-02,   6.503396E-02,   7.187021E-02,   8.727666E-02, },
{  2.253255E-02,   2.911011E-02,   4.676496E-02,   8.752730E-02,   1.064733E-01,   1.063567E-01, },
{  9.330584E-03,   8.944493E-03,   1.741974E-02,   4.210367E-02,   6.040140E-02,   1.076990E-01, },
{  1.707189E-02,   2.162706E-02,   3.825130E-02,   7.520610E-02,   1.115368E-01,   1.325846E-01, },
{  2.498237E-02,   3.349686E-02,   4.817551E-02,   6.190615E-02,   6.758707E-02,   1.115471E-01, },
{  7.693173E-03,   1.534359E-02,   5.419007E-02,   4.615197E-02,   7.802145E-02,   1.013523E-01, },
{  2.870108E-02,   3.634092E-02,   4.478399E-02,   5.000990E-02,   5.957998E-02,   1.172899E-01, },
{  1.389121E-02,   1.886393E-02,   3.596367E-02,   5.238487E-02,   8.164697E-02,   1.235713E-01, },
{  1.796861E-02,   2.793545E-02,   4.265724E-02,   5.642237E-02,   7.290686E-02,   7.984073E-02, },
{  6.165272E-03,   1.233165E-02,   8.444113E-02,   8.879394E-02,   1.032362E-01,   1.358392E-01, },
{  1.751720E-02,   2.124021E-02,   3.596410E-02,   4.771356E-02,   5.646011E-02,   9.912360E-02, },
{  1.547700E-02,   1.958381E-02,   5.801001E-02,   1.096928E-01,   8.336266E-02,   1.243110E-01, },
{  2.100264E-02,   2.574560E-02,   5.412842E-02,   7.533002E-02,   7.935150E-02,   9.633113E-02, },
{  1.551122E-02,   1.915788E-02,   4.184179E-02,   7.417878E-02,   8.237421E-02,   1.036722E-01, },
{  1.224817E-02,   1.593228E-02,   1.792129E-02,   3.397741E-02,   6.813254E-02,   6.556402E-02, },
{  1.159031E-02,   1.759555E-02,   5.108670E-02,   7.078053E-02,   1.294405E-01,   1.492765E-01, },
{  1.771407E-02,   2.455183E-02,   5.375426E-02,   5.912437E-02,   8.126567E-02,   8.439751E-02, },
{  1.824088E-02,   2.281758E-02,   6.227442E-02,   8.102935E-02,   8.551067E-02,   1.017574E-01, },
{  4.179908E-03,  -2.762453E-03,   2.418445E-02,   6.055324E-02,   9.167450E-02,   1.148192E-01, },
{  1.559755E-02,   1.886167E-02,   2.738089E-02,   8.174025E-02,   1.104767E-01,   1.147926E-01, },
{  2.228167E-02,   4.187582E-02,   5.462653E-02,   6.288394E-02,   7.296177E-02,   8.198875E-02, },
{  1.277298E-02,   1.722771E-02,   3.441982E-02,   6.864771E-02,   8.053993E-02,   9.456105E-02, },
{  1.737834E-02,   2.117309E-02,   2.916685E-02,   3.386080E-02,   6.825127E-02,   1.106563E-01, },
{  2.051604E-02,   3.254288E-02,   3.933957E-02,   6.040629E-02,   8.162270E-02,   9.340141E-02, },
{  2.091342E-02,   3.080663E-02,   3.960942E-02,   5.510752E-02,   5.831343E-02,   6.079024E-02, },
{  1.994793E-02,   4.828078E-02,   9.309632E-02,   9.708751E-02,   9.254253E-02,   9.148157E-02, },
{  1.881919E-02,   2.711143E-02,   2.876549E-02,   6.178218E-02,   7.494569E-02,   6.763395E-02, },
{  8.906414E-03,   1.173879E-02,   3.192403E-02,   7.742177E-02,   1.093307E-01,   1.051643E-01, },
{  2.820534E-02,   3.623979E-02,   5.195064E-02,   7.558792E-02,   7.974703E-02,   9.993019E-02, },
{  1.903235E-02,   2.525505E-02,   3.093719E-02,   6.622717E-02,   9.186785E-02,   9.881845E-02, },
{  7.415025E-03,   6.597229E-03,   1.984629E-02,   1.912643E-02,   4.491028E-02,   1.019085E-01, },
{  9.498753E-03,   1.114563E-02,   6.873898E-03,   3.764293E-02,   1.121659E-01,   1.094361E-01, },
{  2.061887E-02,   2.595708E-02,   3.762132E-02,   6.086574E-02,   6.858942E-02,   8.353516E-02, },
{  2.497460E-02,   3.308247E-02,   4.936177E-02,   7.825755E-02,   8.445405E-02,   1.045082E-01, },
{  7.597373E-03,   1.057203E-02,   5.933477E-03,  -3.273260E-03,   7.978280E-02,   9.728847E-02, },
{  1.058577E-02,   1.886465E-02,   6.002593E-02,   6.342305E-02,   1.104921E-01,   1.265372E-01, },
{  2.302043E-02,   2.666797E-02,   4.631398E-02,   4.770519E-02,   5.234165E-02,   9.077051E-02, },
{  1.024165E-02,   1.251414E-02,   3.141133E-02,   6.727887E-02,   6.825091E-02,   9.898287E-02, },
{  1.719696E-02,   2.240861E-02,   4.740598E-02,   5.395003E-02,   6.278338E-02,   8.978091E-02, },
{  3.654096E-03,   4.415175E-03,   4.950324E-02,   6.536126E-02,   9.951147E-02,   1.138780E-01, },
{  1.996215E-02,   3.540800E-02,   4.798105E-02,   5.505053E-02,   6.666118E-02,   7.591963E-02, },
{  8.030481E-03,   1.304748E-02,   8.708621E-02,   1.178092E-01,   1.137160E-01,   1.510715E-01, },
{  1.002594E-02,   1.268949E-02,   2.223281E-02,   4.064576E-02,   7.849725E-02,   9.593330E-02, },
{  1.549529E-02,   1.876282E-02,   2.973704E-02,   9.715081E-02,   1.251507E-01,   1.274535E-01, },
{  2.107903E-02,   2.938497E-02,   4.435376E-02,   7.622032E-02,   8.254489E-02,   8.023231E-02, },
{  1.166046E-02,   1.568410E-02,   3.393895E-02,   8.494941E-02,   8.193771E-02,   8.192688E-02, },
{  1.300173E-02,   1.824511E-02,   2.225135E-02,   2.606948E-02,   3.948467E-02,   8.081343E-02, },
{  1.218699E-02,   1.738186E-02,   1.964764E-02,   6.211364E-02,   1.175724E-01,   1.215212E-01, },
{  1.815164E-02,   2.385794E-02,   3.781433E-02,   6.318809E-02,   7.528239E-02,   7.949688E-02, },
{  2.090015E-02,   2.567020E-02,   6.730044E-02,   8.912025E-02,   9.466079E-02,   1.088322E-01, },
{  1.383303E-02,   1.951758E-02,   1.332347E-02,   6.068396E-02,   1.036593E-01,   1.073519E-01, },
{  2.010342E-02,   2.582834E-02,   4.177777E-02,   7.043779E-02,   1.018560E-01,   1.165980E-01, },
{  2.721694E-02,   3.647024E-02,   5.499028E-02,   7.378204E-02,   7.757968E-02,   8.264411E-02, },
{  2.121747E-02,   3.191525E-02,   3.735503E-02,   5.740886E-02,   8.093350E-02,   8.444119E-02, },
{  1.594924E-02,   1.911230E-02,   4.579085E-02,   5.381059E-02,   7.276539E-02,   1.098792E-01, },
{  1.690420E-02,   2.751299E-02,   4.153215E-02,   4.520013E-02,   1.009809E-01,   1.289608E-01, },
{  1.183859E-02,   1.654400E-02,   3.192209E-02,   6.446035E-02,   7.187176E-02,   6.234758E-02, },
{  1.577613E-02,   5.716901E-02,   7.445642E-02,   9.367424E-02,   1.268903E-01,   1.233605E-01, },
{  7.001652E-03,   8.710513E-03,   1.459395E-02,   6.796276E-02,   7.210871E-02,   8.184474E-02, },
{  1.367917E-02,   1.558312E-02,   2.872566E-02,   9.393050E-02,   1.028936E-01,   1.147333E-01, },
{  2.728060E-02,   4.888520E-02,   5.543847E-02,   6.424494E-02,   8.356433E-02,   8.664259E-02, },
{  2.009816E-02,   2.505305E-02,   4.802344E-02,   8.727456E-02,   9.568610E-02,   1.101500E-01, },
{  1.572786E-02,   2.171422E-02,   3.023720E-02,   4.209336E-02,   5.395622E-02,   7.625773E-02, },
{  1.437907E-02,   2.009067E-02,   1.993008E-02,   4.957626E-02,   1.017632E-01,   1.351654E-01, },
{  1.537046E-02,   2.125172E-02,   5.688990E-02,   7.208610E-02,   8.221379E-02,   6.600381E-02, },
{  1.841448E-02,   2.894096E-02,   5.027487E-02,   7.443822E-02,   1.005034E-01,   1.078382E-01, },
{  6.266807E-03,   5.780402E-03,   2.191185E-02,   1.986563E-02,   8.915054E-02,   1.117054E-01, },
{  2.328718E-02,   3.024352E-02,   3.571912E-02,   7.152741E-02,   1.157413E-01,   1.241848E-01, },
{  3.018517E-02,   3.614674E-02,   5.279391E-02,   6.672592E-02,   7.319556E-02,   9.791561E-02, },
{  1.520236E-02,   2.107226E-02,   4.219122E-02,   6.252956E-02,   7.824916E-02,   1.015041E-01, },
{  2.206445E-02,   2.630366E-02,   3.746872E-02,   4.085470E-02,   5.603856E-02,   1.201468E-01, },
{  1.442697E-02,   1.845104E-02,   2.488927E-02,   6.846813E-02,   8.617703E-02,   1.093911E-01, },
{  2.042649E-02,   2.990809E-02,   4.438132E-02,   6.607605E-02,   6.964072E-02,   5.880419E-02, },
{  1.329560E-02,   3.720956E-02,   8.807788E-02,   9.957019E-02,   1.206878E-01,   1.323209E-01, },
{  1.586589E-02,   2.190774E-02,   2.651558E-02,   5.181373E-02,   7.328216E-02,   7.494737E-02, },
{  1.309369E-02,   1.562961E-02,   5.585308E-02,   1.052936E-01,   1.088866E-01,   1.227673E-01, },
{  2.141978E-02,   2.547896E-02,   5.788724E-02,   6.940208E-02,   7.366081E-02,   8.412745E-02, },
{  8.260801E-03,   1.051398E-02,   3.739659E-02,   7.620624E-02,   8.733090E-02,   9.431524E-02, },
{  1.006735E-02,   1.381254E-02,   2.133789E-02,   5.594322E-02,   7.149754E-02,   7.313528E-02, },
{  1.435431E-02,   1.866912E-02,   2.771846E-02,   7.090147E-02,   1.143312E-01,   1.370063E-01, },
{  2.350827E-02,   3.302307E-02,   4.545939E-02,   7.009938E-02,   7.218733E-02,   7.695245E-02, },
{  1.234790E-02,   1.906054E-02,   7.706499E-02,   7.791933E-02,   9.402603E-02,   1.041908E-01, },
{  1.011209E-02,   1.180385E-02,   2.645735E-02,   4.095926E-02,   7.074231E-02,   1.049270E-01, },
{  1.464571E-02,   2.065853E-02,   2.695906E-02,   5.794560E-02,   9.805924E-02,   1.122967E-01, },
{  2.856206E-02,   4.234143E-02,   5.479452E-02,   6.747436E-02,   7.058305E-02,   8.513996E-02, },
{  1.197975E-02,   1.485327E-02,   2.796461E-02,   7.117215E-02,   7.569394E-02,   8.763968E-02, },
{  1.353941E-02,   1.509949E-02,   2.225774E-02,   2.172843E-02,   6.017898E-02,   1.351637E-01, },
{  1.800798E-02,   2.649268E-02,   4.506814E-02,   6.198959E-02,   8.765135E-02,   9.218795E-02, },
{  2.134211E-02,   2.789534E-02,   4.212850E-02,   5.127710E-02,   5.785788E-02,   7.804564E-02, },
{  1.236281E-02,   2.420221E-02,   8.861879E-02,   9.655615E-02,   1.148887E-01,   9.650159E-02, },
{  1.383048E-02,   1.908450E-02,   2.672127E-02,   4.824063E-02,   5.970953E-02,   7.102355E-02, },
{  1.684844E-02,   1.979451E-02,   3.851215E-02,   9.449255E-02,   1.039623E-01,   1.152428E-01, },
{  2.692179E-02,   3.447444E-02,   6.042144E-02,   6.354405E-02,   7.742282E-02,   1.344837E-01, },
{  1.960895E-02,   2.590655E-02,   3.045410E-02,   7.165352E-02,   1.001407E-01,   1.094606E-01, },
{  1.842527E-02,   2.178841E-02,   2.942565E-02,   3.659077E-02,   4.918254E-02,   1.057118E-01, },
{  9.954032E-03,   1.227639E-02,   2.879102E-02,   5.091325E-02,   1.134516E-01,   1.182354E-01, },
{  1.537565E-02,   2.007940E-02,   3.331252E-02,   5.883175E-02,   6.162786E-02,   7.470520E-02, },
{  2.903994E-02,   4.785432E-02,   5.153417E-02,   7.511055E-02,   9.430858E-02,   1.014823E-01, },
{  8.717011E-03,   1.260710E-02,   2.408422E-02,   1.403154E-02,   8.061927E-02,   9.231308E-02, },
{  1.197891E-02,   1.420568E-02,   3.498973E-02,   6.777179E-02,   1.035838E-01,   1.374600E-01, },
{  2.422762E-02,   3.001601E-02,   4.553860E-02,   6.553669E-02,   6.566284E-02,   8.324208E-02, },
{  1.629306E-02,   2.093706E-02,   3.882325E-02,   6.561878E-02,   5.141761E-02,   9.861604E-02, },
{  2.618454E-02,   3.195097E-02,   3.902538E-02,   4.496732E-02,   5.098064E-02,   9.087247E-02, },
{  8.043125E-03,   7.715969E-03,   4.130161E-02,   4.634281E-02,   7.861872E-02,   1.230556E-01, },
{  2.175397E-02,   3.391497E-02,   4.852179E-02,   5.601743E-02,   5.635830E-02,   7.771001E-02, },
{  4.401888E-02,   7.912847E-02,   1.256354E-01,   1.384011E-01,   1.427012E-01,   1.496054E-01, },
{  4.631868E-03,   4.313816E-03,   1.957007E-02,   3.187425E-02,   8.102398E-02,   8.963235E-02, },
{  1.988491E-02,   2.532103E-02,   3.575230E-02,   1.082089E-01,   1.256755E-01,   1.218207E-01, },
{  2.806638E-02,   3.670616E-02,   4.488455E-02,   6.944504E-02,   7.954485E-02,   8.874477E-02, },
{  2.205383E-02,   2.737888E-02,   4.288671E-02,   7.872037E-02,   9.127880E-02,   9.720778E-02, },
{  5.139630E-03,   3.363988E-03,   3.381327E-02,   6.753461E-03,   2.805012E-02,   8.078719E-02, },
{  1.732346E-02,   2.153420E-02,   3.678713E-02,   4.370644E-02,   9.010518E-02,   1.407950E-01, },
{  1.752107E-02,   2.356571E-02,   3.750403E-02,   6.387833E-02,   8.037478E-02,   8.773182E-02, },
{  1.991542E-02,   2.461885E-02,   4.923230E-02,   7.886521E-02,   8.035410E-02,   1.219791E-01, },
{  1.216301E-02,   1.725686E-02,   2.671229E-02,   4.049257E-02,   9.167572E-02,   9.695184E-02, },
{  1.298615E-02,   1.793400E-02,   4.010883E-02,   5.711711E-02,   1.005182E-01,   1.075548E-01, },
{  2.794773E-02,   4.169740E-02,   5.150544E-02,   6.300317E-02,   7.981770E-02,   8.726172E-02, },
{  1.708822E-02,   2.214230E-02,   3.293179E-02,   5.670769E-02,   7.982510E-02,   1.048445E-01, },
{  2.081073E-02,   2.514757E-02,   3.667451E-02,   5.005789E-02,   5.472966E-02,   1.078999E-01, },
{  1.564555E-02,   3.103829E-02,   5.208394E-02,   5.993908E-02,   9.330647E-02,   1.001528E-01, },
{  1.475030E-02,   1.976979E-02,   2.753966E-02,   5.571409E-02,   5.571654E-02,   6.212192E-02, },
{  2.540000E-02,   1.109660E-01,   1.243010E-01,   7.048500E-02,   7.175500E-02,   9.874200E-02, },
{  8.356157E-03,   6.942623E-03,   4.098197E-02,   5.196113E-02,   8.126926E-02,   8.736414E-02, },
{  1.465877E-02,   1.589760E-02,   6.099465E-02,   1.231368E-01,   8.014717E-02,   8.884873E-02, },
{  2.438193E-02,   4.052104E-02,   5.051652E-02,   7.682950E-02,   9.233534E-02,   9.555955E-02, },
{  1.624430E-02,   1.978774E-02,   4.331602E-02,   7.770738E-02,   7.888474E-02,   1.079453E-01, },
{  1.565929E-02,   2.007029E-02,   3.014859E-02,   3.310657E-02,   4.899913E-02,   8.520083E-02, },
{  1.326508E-02,   1.969602E-02,   2.480876E-02,   4.239437E-02,   9.081622E-02,   1.234142E-01, },
{  1.048302E-02,   1.970384E-02,   7.666807E-02,   5.380878E-02,   5.969105E-02,   7.923944E-02, },
{  2.502178E-02,   3.678102E-02,   4.251120E-02,   6.950245E-02,   9.765372E-02,   1.050306E-01, },
{  1.081341E-02,   1.302991E-02,   1.651499E-02,   2.056329E-02,   6.238823E-02,   1.035815E-01, },
{  1.641126E-02,   2.160063E-02,   3.133165E-02,   6.720576E-02,   1.027560E-01,   1.189162E-01, },
{  2.941074E-02,   3.648847E-02,   5.096251E-02,   5.875405E-02,   6.769179E-02,   1.200295E-01, },
{  1.372234E-02,   1.904085E-02,   3.387472E-02,   4.981538E-02,   8.776491E-02,   9.979058E-02, },
{  2.493880E-02,   3.100212E-02,   4.245989E-02,   4.861357E-02,   6.013642E-02,   1.023174E-01, },
{  1.678074E-02,   2.005457E-02,   4.524550E-02,   5.282503E-02,   7.822200E-02,   1.274504E-01, },
{  1.931154E-02,   2.853312E-02,   4.296141E-02,   5.385050E-02,   6.226518E-02,   7.508850E-02, },
{  1.446425E-02,   2.247232E-02,   7.714434E-02,   9.135953E-02,   1.071775E-01,   1.470091E-01, },
{  1.564133E-02,   1.946264E-02,   2.583724E-02,   6.480144E-02,   6.570606E-02,   9.400335E-02, },
{  1.704029E-02,   2.064519E-02,   5.461599E-02,   9.690039E-02,   1.033850E-01,   1.044560E-01, },
{  1.962386E-02,   2.514270E-02,   6.544063E-02,   6.964326E-02,   7.954278E-02,   9.244923E-02, },
{  1.347723E-02,   1.890079E-02,   5.467831E-02,   6.447194E-02,   7.699258E-02,   9.662570E-02, },
{  8.525596E-03,   1.192408E-02,  -2.276356E-03,   1.756824E-02,   7.971502E-02,   8.076035E-02, },
{  1.433495E-02,   1.926139E-02,   3.185936E-02,   8.777995E-02,   1.500492E-01,   1.656458E-01, },
{  2.238478E-02,   2.970941E-02,   4.335055E-02,   6.759135E-02,   7.294933E-02,   8.490516E-02, },
{  2.279121E-02,   3.420921E-02,   6.943406E-02,   8.313960E-02,   7.160605E-02,   9.297488E-02, },
{  9.793274E-03,   1.410074E-02,   2.266586E-02,   6.459888E-02,   9.382483E-02,   1.004214E-01, },
{  1.794714E-02,   2.218889E-02,   3.794623E-02,   7.745360E-02,   1.081674E-01,   1.147201E-01, },
{  2.272289E-02,   4.306323E-02,   5.624044E-02,   6.773741E-02,   7.744711E-02,   8.576053E-02, },
{  1.299560E-02,   1.634545E-02,   4.432876E-02,   7.003776E-02,   7.568491E-02,   7.770209E-02, },
{  1.967214E-02,   2.536679E-02,   3.726346E-02,   4.202616E-02,   8.057429E-02,   1.070165E-01, },
{  1.883922E-02,   2.748246E-02,   3.834353E-02,   5.853973E-02,   9.189871E-02,   1.004521E-01, },
{  1.593033E-02,   2.134345E-02,   3.093617E-02,   4.584718E-02,   5.439078E-02,   6.382211E-02, },
{  1.440162E-02,   4.469713E-02,   9.677333E-02,   7.693892E-02,   9.503974E-02,   1.174393E-01, },
{  1.675656E-02,   2.356289E-02,   3.571539E-02,   5.646564E-02,   7.020168E-02,   7.805370E-02, },
{  1.475726E-02,   1.742735E-02,   3.463308E-02,   8.822747E-02,   1.062116E-01,   1.102208E-01, },
{  2.598650E-02,   3.361722E-02,   5.518528E-02,   7.373677E-02,   7.991530E-02,   1.136490E-01, },
{  1.493318E-02,   2.021036E-02,   2.840172E-02,   7.132426E-02,   9.424514E-02,   1.014458E-01, },
{  1.418929E-02,   1.734186E-02,   3.210269E-02,   4.726307E-02,   5.110744E-02,   8.718623E-02, },
{  1.207583E-02,   1.699930E-02,   2.720679E-02,   3.490423E-02,   1.154720E-01,   1.251752E-01, },
{  1.398967E-02,   1.757398E-02,   4.299816E-02,   5.305115E-02,   4.964308E-02,   8.090326E-02, },
{  2.032301E-02,   3.793666E-02,   5.419656E-02,   7.843951E-02,   9.421813E-02,   1.034499E-01, },
{  4.799204E-03,  -1.027899E-03,   1.206993E-02,   1.526902E-02,   5.515609E-02,   8.636779E-02, },
{  9.447182E-03,   1.084177E-02,   5.408564E-02,   7.579217E-02,   1.109150E-01,   1.173514E-01, },
{  2.708500E-02,   3.718907E-02,   5.294084E-02,   5.794316E-02,   6.459495E-02,   8.921185E-02, },
{  1.255941E-02,   1.673973E-02,   2.829886E-02,   5.243008E-02,   7.873495E-02,   8.856669E-02, },
{  1.919363E-02,   2.352040E-02,   3.791475E-02,   5.402071E-02,   5.931153E-02,   8.643736E-02, },
{  1.373559E-02,   1.721084E-02,   5.496369E-02,   6.517555E-02,   9.219778E-02,   1.235371E-01, },
{  2.069835E-02,   3.333731E-02,   4.579376E-02,   5.761477E-02,   6.498900E-02,   6.874965E-02, },
{  9.491142E-03,   3.478718E-02,   1.359202E-01,   1.341335E-01,   1.407470E-01,   1.551626E-01, },
{  1.234982E-02,   1.643816E-02,   2.766869E-02,   4.804917E-02,   8.878672E-02,   9.244449E-02, },
{  1.465494E-02,   1.699790E-02,   3.268575E-02,   1.027723E-01,   1.162926E-01,   1.125889E-01, },
{  2.046226E-02,   2.563195E-02,   5.276975E-02,   9.020744E-02,   9.509142E-02,   7.511153E-02, },
{  1.847053E-02,   3.000312E-02,   5.641485E-02,   7.050432E-02,   8.783666E-02,   8.895542E-02, },
{  1.261945E-02,   1.389840E-02,   3.154468E-02,   4.653074E-02,   1.783118E-03,   8.694508E-02, },
{  1.424654E-02,   1.923119E-02,   2.497837E-02,   6.234127E-02,   1.052243E-01,   1.225190E-01, },
{  1.830878E-02,   2.500746E-02,   4.468678E-02,   7.105059E-02,   8.083325E-02,   8.821615E-02, },
{  1.573293E-02,   2.351451E-02,   7.221704E-02,   8.629748E-02,   9.875100E-02,   1.234404E-01, },
{  6.547524E-03,   1.016849E-02,   6.536401E-03,   6.535678E-02,   8.952584E-02,   9.761936E-02, },
{  1.710742E-02,   2.213298E-02,   3.950528E-02,   7.007205E-02,   1.032119E-01,   1.080360E-01, },
{  2.352424E-02,   3.917277E-02,   4.935594E-02,   6.595606E-02,   8.429364E-02,   9.133154E-02, },
{  1.140674E-02,   1.495722E-02,   4.080821E-02,   5.160682E-02,   7.531045E-02,   8.166180E-02, },
{  1.271983E-02,   1.623484E-02,   4.234032E-02,   5.564689E-02,   6.966655E-02,   1.051876E-01, },
{  1.599213E-02,   2.449233E-02,   4.567000E-02,   5.871967E-02,   8.956748E-02,   1.172570E-01, },
{  1.930774E-02,   2.399247E-02,   4.300584E-02,   5.562012E-02,   5.404434E-02,   6.962171E-02, },
{  3.934798E-02,   5.472530E-02,   6.562281E-02,   7.619655E-02,   9.538361E-02,   1.102524E-01, },
{  3.502156E-03,   2.931166E-03,   1.308703E-02,   5.506205E-02,   7.290967E-02,   8.298626E-02, },
{  1.655326E-02,   1.946578E-02,   3.895758E-02,   8.771968E-02,   9.517211E-02,   1.035028E-01, },
{  1.973851E-02,   3.659956E-02,   4.824506E-02,   6.048141E-02,   8.560514E-02,   9.627345E-02, },
{  2.137525E-02,   2.752568E-02,   4.674464E-02,   8.707046E-02,   9.298479E-02,   1.172247E-01, },
{  1.699155E-02,   2.223320E-02,   2.361702E-02,   4.246245E-02,   4.685692E-02,   7.597940E-02, },
{  1.567585E-02,   2.118400E-02,   3.085418E-02,   4.799395E-02,   9.564142E-02,   1.303839E-01, },
{  1.835719E-02,   2.174804E-02,   4.773516E-02,   6.912734E-02,   7.009360E-02,   7.539675E-02, },
{  2.172008E-02,   2.902312E-02,   4.431384E-02,   6.906790E-02,   1.003369E-01,   1.014787E-01, },
{  1.090453E-02,   1.601957E-02,   2.347860E-02,   2.702867E-02,   8.662541E-02,   1.079974E-01, },
{  1.384770E-02,   1.997406E-02,   3.401456E-02,   6.719957E-02,   1.301361E-01,   1.180674E-01, },
{  2.462159E-02,   3.476520E-02,   5.040969E-02,   6.169565E-02,   7.046475E-02,   9.207647E-02, },
{  1.314941E-02,   1.639913E-02,   3.608584E-02,   6.047748E-02,   6.812324E-02,   1.031916E-01, },
{  2.239567E-02,   2.775489E-02,   5.486096E-02,   5.370956E-02,   6.916674E-02,   1.278935E-01, },
{  1.703454E-02,   2.047219E-02,   4.119687E-02,   7.029995E-02,   7.475601E-02,   1.199532E-01, },
{  1.806514E-02,   2.307528E-02,   5.177036E-02,   6.161942E-02,   6.159787E-02,   7.054174E-02, },
{  1.453431E-02,   2.296042E-02,   8.897572E-02,   9.237062E-02,   1.097047E-01,   1.240955E-01, },
{  1.312902E-02,   1.800782E-02,   2.667081E-02,   3.910588E-02,   7.013735E-02,   8.738370E-02, },
{  1.468422E-02,   1.718226E-02,   4.877216E-02,   9.862047E-02,   1.049419E-01,   1.158774E-01, },
{  1.631475E-02,   2.028370E-02,   3.929835E-02,   7.235549E-02,   7.526462E-02,   9.268711E-02, },
{  6.776016E-03,   7.293253E-03,   2.597095E-02,   7.232245E-02,   7.924933E-02,   1.025273E-01, },
{ -3.172375E-03,  -5.790930E-03,   2.293219E-02,   3.711039E-02,   7.212306E-02,   7.659391E-02, },
{  1.232182E-02,   1.891504E-02,   2.596884E-02,   4.198169E-02,   1.174141E-01,   1.455406E-01, },
{  1.753131E-02,   2.919450E-02,   4.714086E-02,   5.744911E-02,   6.578999E-02,   7.939213E-02, },
{  1.105186E-02,   1.640055E-02,   5.855621E-02,   6.863516E-02,   1.003645E-01,   1.105921E-01, },
{  1.447234E-02,   1.762728E-02,   3.394504E-02,   4.695668E-02,   8.612069E-02,   1.130594E-01, },
{  1.015546E-02,   1.406789E-02,   1.536133E-02,   7.041996E-02,   9.582874E-02,   1.265419E-01, },
{  2.750642E-02,   3.281520E-02,   5.708392E-02,   6.048051E-02,   6.596222E-02,   8.125960E-02, },
{  1.442310E-02,   1.987189E-02,   3.148611E-02,   6.903538E-02,   8.405726E-02,   8.318180E-02, },
{  2.213064E-02,   2.668277E-02,   4.430215E-02,   4.619871E-02,   6.846063E-02,   1.380130E-01, },
{  2.389136E-02,   3.751652E-02,   4.433405E-02,   7.044938E-02,   8.999150E-02,   9.717633E-02, },
{  2.038237E-02,   2.660964E-02,   3.738104E-02,   4.502429E-02,   5.176268E-02,   8.774910E-02, },
{  5.407670E-03,   7.669280E-03,   8.095613E-02,   1.035703E-01,   9.476902E-02,   1.139914E-01, },
{  1.133998E-02,   1.477670E-02,   2.629656E-02,   4.556369E-02,   5.950111E-02,   7.981666E-02, },
{  1.276451E-02,   1.525862E-02,   2.850702E-02,   8.506246E-02,   1.137642E-01,   1.175337E-01, },
{  2.399251E-02,   2.936397E-02,   6.291426E-02,   7.901232E-02,   8.355970E-02,   1.081408E-01, },
{  1.454466E-02,   1.824439E-02,   4.766233E-02,   7.039310E-02,   9.581260E-02,   9.738025E-02, },
{  1.670847E-02,   2.007454E-02,   3.332061E-02,   3.910476E-02,   4.047330E-02,   1.040292E-01, },
{  1.177367E-02,   1.636311E-02,   2.517579E-02,   4.598691E-02,   1.009155E-01,   1.130767E-01, },
{  1.511697E-02,   2.035882E-02,   4.223660E-02,   5.471331E-02,   7.757046E-02,   7.424962E-02, },
{  2.369149E-02,   3.112579E-02,   3.970981E-02,   7.907734E-02,   8.691142E-02,   1.081090E-01, },
{  8.849379E-03,   1.296352E-02,  -1.466606E-04,   3.040950E-02,   9.666959E-02,   1.039090E-01, },
{  1.162835E-02,   1.628573E-02,   6.366351E-02,   7.708903E-02,   9.765091E-02,   1.378701E-01, },
};
static float cbb_new[VECSIZEb_NEW][VECDIMb_NEW] = {
{  1.028946E-01,   1.429001E-01,   1.690572E-01,   1.732624E-01, },
{  1.202891E-01,   1.358667E-01,   1.783948E-01,   1.797000E-01, },
{  1.046043E-01,   1.279615E-01,   1.517462E-01,   1.549688E-01, },
{  1.219325E-01,   1.483746E-01,   1.585376E-01,   1.631185E-01, },
{  7.866949E-02,   8.595246E-02,   1.397013E-01,   1.667717E-01, },
{  1.301067E-01,   1.466079E-01,   1.516102E-01,   1.578570E-01, },
{  1.134451E-01,   1.224300E-01,   1.332093E-01,   1.468314E-01, },
{  1.238168E-01,   1.315865E-01,   1.575402E-01,   1.650747E-01, },
{  1.009568E-01,   1.167480E-01,   1.557529E-01,   1.650461E-01, },
{  1.687751E-01,   1.700358E-01,   1.721783E-01,   1.775260E-01, },
{  1.132635E-01,   1.294658E-01,   1.350492E-01,   1.670164E-01, },
{  1.138025E-01,   1.382233E-01,   1.456656E-01,   1.551468E-01, },
{  9.340192E-02,   1.079911E-01,   1.440780E-01,   1.534684E-01, },
{  1.387070E-01,   1.588183E-01,   1.682713E-01,   1.720211E-01, },
{  1.237252E-01,   1.276098E-01,   1.311874E-01,   1.425099E-01, },
{  1.125187E-01,   1.190763E-01,   1.694397E-01,   1.766393E-01, },
{  9.352287E-02,   1.406467E-01,   1.544965E-01,   1.602719E-01, },
{  1.322105E-01,   1.431098E-01,   1.668036E-01,   1.750401E-01, },
{  1.096195E-01,   1.324317E-01,   1.484282E-01,   1.613644E-01, },
{  1.239595E-01,   1.409094E-01,   1.470458E-01,   1.572686E-01, },
{  8.433813E-02,   1.083855E-01,   1.580322E-01,   1.662142E-01, },
{  1.400675E-01,   1.452530E-01,   1.619088E-01,   1.691324E-01, },
{  9.007670E-02,   1.259605E-01,   1.319836E-01,   1.462214E-01, },
{  1.278968E-01,   1.350451E-01,   1.661980E-01,   1.719272E-01, },
{  1.016506E-01,   1.204853E-01,   1.663802E-01,   1.712871E-01, },
{  1.392849E-01,   1.427271E-01,   1.895724E-01,   1.909042E-01, },
{  1.110312E-01,   1.189064E-01,   1.480765E-01,   1.586512E-01, },
{  1.304127E-01,   1.350912E-01,   1.446692E-01,   1.615949E-01, },
{  1.059663E-01,   1.185289E-01,   1.343831E-01,   1.557215E-01, },
{  1.523558E-01,   1.584233E-01,   1.576702E-01,   1.644879E-01, },
{  1.077938E-01,   1.139043E-01,   1.172091E-01,   1.547683E-01, },
{  1.158996E-01,   1.260214E-01,   1.540011E-01,   1.706774E-01, },
{  8.598196E-02,   1.340990E-01,   1.660513E-01,   1.714258E-01, },
{  1.204801E-01,   1.512455E-01,   1.672835E-01,   1.708365E-01, },
{  9.196066E-02,   1.277497E-01,   1.455189E-01,   1.586575E-01, },
{  1.111267E-01,   1.451867E-01,   1.543033E-01,   1.638313E-01, },
{  9.053543E-02,   9.711701E-02,   1.448142E-01,   1.663028E-01, },
{  1.390226E-01,   1.421330E-01,   1.504011E-01,   1.618296E-01, },
{  1.143608E-01,   1.291879E-01,   1.411417E-01,   1.524363E-01, },
{  1.282901E-01,   1.331767E-01,   1.547906E-01,   1.729154E-01, },
{  1.054598E-01,   1.064779E-01,   1.534063E-01,   1.684881E-01, },
{  1.492138E-01,   1.669245E-01,   1.833990E-01,   1.813288E-01, },
{  1.190870E-01,   1.219872E-01,   1.402428E-01,   1.662979E-01, },
{  1.245782E-01,   1.352989E-01,   1.408846E-01,   1.481753E-01, },
{  9.464782E-02,   1.013755E-01,   1.247584E-01,   1.563693E-01, },
{  1.512695E-01,   1.532475E-01,   1.667209E-01,   1.735275E-01, },
{  1.234004E-01,   1.358001E-01,   1.258594E-01,   1.512631E-01, },
{  1.207495E-01,   1.274543E-01,   1.660312E-01,   1.728560E-01, },
{  1.014935E-01,   1.315258E-01,   1.570202E-01,   1.687510E-01, },
{  1.401947E-01,   1.419451E-01,   1.709453E-01,   1.751982E-01, },
{  1.171856E-01,   1.359765E-01,   1.533801E-01,   1.594169E-01, },
{  1.270418E-01,   1.380499E-01,   1.535557E-01,   1.625633E-01, },
{  6.995779E-02,   1.247152E-01,   1.440217E-01,   1.570551E-01, },
{  1.318954E-01,   1.410221E-01,   1.596246E-01,   1.666262E-01, },
{  1.003133E-01,   1.340955E-01,   1.415070E-01,   1.474043E-01, },
{  1.187883E-01,   1.383332E-01,   1.621059E-01,   1.690763E-01, },
{  9.095367E-02,   1.051201E-01,   1.724481E-01,   1.770562E-01, },
{  1.327819E-01,   1.506402E-01,   1.802915E-01,   1.795952E-01, },
{  1.187037E-01,   1.230887E-01,   1.551124E-01,   1.618775E-01, },
{  1.223993E-01,   1.305190E-01,   1.439494E-01,   1.607284E-01, },
{  1.049620E-01,   1.102881E-01,   1.359525E-01,   1.650455E-01, },
{  1.387640E-01,   1.522843E-01,   1.571966E-01,   1.656725E-01, },
{  1.079475E-01,   1.191716E-01,   1.186914E-01,   1.303933E-01, },
{  1.105329E-01,   1.321016E-01,   1.612938E-01,   1.649749E-01, },
};

#endif

# if 1

static float cba_new[VECSIZEa_NEW][VECDIMa_NEW] = {
{3/128.0, 4/128.0, 6/128.0, 7/128.0, 9/128.0, 12/128.0, },
{1/128.0, 0/128.0, 6/128.0, 8/128.0, 10/128.0, 15/128.0, },
{2/128.0, 3/128.0, 4/128.0, 5/128.0, 9/128.0, 13/128.0, },
{2/128.0, 3/128.0, 6/128.0, 6/128.0, 12/128.0, 14/128.0, },
{3/128.0, 4/128.0, 7/128.0, 7/128.0, 8/128.0, 10/128.0, },
{2/128.0, 4/128.0, 12/128.0, 16/128.0, 14/128.0, 16/128.0, },
{1/128.0, 2/128.0, 4/128.0, 5/128.0, 10/128.0, 13/128.0, },
{2/128.0, 2/128.0, 7/128.0, 16/128.0, 19/128.0, 18/128.0, },
{3/128.0, 4/128.0, 5/128.0, 9/128.0, 11/128.0, 12/128.0, },
{3/128.0, 3/128.0, 4/128.0, 10/128.0, 11/128.0, 12/128.0, },
{2/128.0, 2/128.0, 3/128.0, 4/128.0, 6/128.0, 8/128.0, },
{2/128.0, 3/128.0, 6/128.0, 8/128.0, 15/128.0, 16/128.0, },
{2/128.0, 4/128.0, 5/128.0, 7/128.0, 11/128.0, 11/128.0, },
{2/128.0, 2/128.0, 5/128.0, 11/128.0, 11/128.0, 14/128.0, },
{2/128.0, 2/128.0, 4/128.0, 7/128.0, 13/128.0, 13/128.0, },
{2/128.0, 2/128.0, 5/128.0, 7/128.0, 11/128.0, 14/128.0, },
{3/128.0, 4/128.0, 6/128.0, 8/128.0, 9/128.0, 11/128.0, },
{1/128.0, 2/128.0, 4/128.0, 7/128.0, 11/128.0, 12/128.0, },
{2/128.0, 2/128.0, 3/128.0, 7/128.0, 8/128.0, 13/128.0, },
{2/128.0, 4/128.0, 6/128.0, 8/128.0, 13/128.0, 14/128.0, },
{2/128.0, 3/128.0, 4/128.0, 5/128.0, 6/128.0, 7/128.0, },
{4/128.0, 10/128.0, 10/128.0, 12/128.0, 13/128.0, 15/128.0, },
{2/128.0, 2/128.0, 4/128.0, 8/128.0, 9/128.0, 12/128.0, },
{1/128.0, 1/128.0, 6/128.0, 11/128.0, 11/128.0, 14/128.0, },
{3/128.0, 4/128.0, 6/128.0, 10/128.0, 11/128.0, 12/128.0, },
{3/128.0, 3/128.0, 6/128.0, 10/128.0, 11/128.0, 14/128.0, },
{2/128.0, 3/128.0, 4/128.0, 5/128.0, 8/128.0, 11/128.0, },
{2/128.0, 3/128.0, 4/128.0, 8/128.0, 12/128.0, 15/128.0, },
{2/128.0, 3/128.0, 6/128.0, 8/128.0, 10/128.0, 11/128.0, },
{2/128.0, 4/128.0, 7/128.0, 10/128.0, 13/128.0, 15/128.0, },
{1/128.0, 1/128.0, 4/128.0, 4/128.0, 8/128.0, 13/128.0, },
{3/128.0, 3/128.0, 5/128.0, 9/128.0, 14/128.0, 16/128.0, },
{4/128.0, 5/128.0, 7/128.0, 9/128.0, 10/128.0, 14/128.0, },
{2/128.0, 2/128.0, 7/128.0, 8/128.0, 10/128.0, 13/128.0, },
{3/128.0, 4/128.0, 5/128.0, 7/128.0, 8/128.0, 14/128.0, },
{2/128.0, 2/128.0, 4/128.0, 7/128.0, 9/128.0, 16/128.0, },
{3/128.0, 3/128.0, 6/128.0, 6/128.0, 8/128.0, 11/128.0, },
{0/128.0, 1/128.0, 9/128.0, 11/128.0, 13/128.0, 15/128.0, },
{1/128.0, 2/128.0, 2/128.0, 6/128.0, 8/128.0, 11/128.0, },
{2/128.0, 2/128.0, 9/128.0, 13/128.0, 14/128.0, 14/128.0, },
{2/128.0, 3/128.0, 7/128.0, 10/128.0, 10/128.0, 13/128.0, },
{2/128.0, 2/128.0, 6/128.0, 11/128.0, 12/128.0, 13/128.0, },
{2/128.0, 3/128.0, 2/128.0, 4/128.0, 8/128.0, 10/128.0, },
{2/128.0, 3/128.0, 5/128.0, 9/128.0, 19/128.0, 17/128.0, },
{3/128.0, 3/128.0, 6/128.0, 8/128.0, 9/128.0, 11/128.0, },
{2/128.0, 3/128.0, 8/128.0, 10/128.0, 12/128.0, 12/128.0, },
{1/128.0, 1/128.0, 4/128.0, 7/128.0, 12/128.0, 14/128.0, },
{3/128.0, 3/128.0, 5/128.0, 10/128.0, 16/128.0, 17/128.0, },
{3/128.0, 5/128.0, 8/128.0, 8/128.0, 9/128.0, 12/128.0, },
{2/128.0, 3/128.0, 5/128.0, 10/128.0, 11/128.0, 12/128.0, },
{2/128.0, 3/128.0, 4/128.0, 5/128.0, 6/128.0, 15/128.0, },
{3/128.0, 5/128.0, 6/128.0, 7/128.0, 11/128.0, 11/128.0, },
{2/128.0, 4/128.0, 4/128.0, 7/128.0, 8/128.0, 8/128.0, },
{2/128.0, 7/128.0, 17/128.0, 14/128.0, 11/128.0, 14/128.0, },
{2/128.0, 3/128.0, 4/128.0, 8/128.0, 8/128.0, 10/128.0, },
{2/128.0, 2/128.0, 2/128.0, 11/128.0, 14/128.0, 14/128.0, },
{3/128.0, 4/128.0, 6/128.0, 9/128.0, 10/128.0, 13/128.0, },
{1/128.0, 2/128.0, 2/128.0, 10/128.0, 12/128.0, 12/128.0, },
{1/128.0, 2/128.0, 2/128.0, 5/128.0, 6/128.0, 12/128.0, },
{1/128.0, 1/128.0, 2/128.0, 6/128.0, 14/128.0, 16/128.0, },
{2/128.0, 2/128.0, 6/128.0, 7/128.0, 8/128.0, 11/128.0, },
{3/128.0, 4/128.0, 6/128.0, 11/128.0, 11/128.0, 12/128.0, },
{1/128.0, 2/128.0, 2/128.0, -2/128.0, 7/128.0, 11/128.0, },
{1/128.0, 2/128.0, 9/128.0, 9/128.0, 15/128.0, 14/128.0, },
{3/128.0, 4/128.0, 5/128.0, 7/128.0, 8/128.0, 12/128.0, },
{2/128.0, 2/128.0, 4/128.0, 9/128.0, 9/128.0, 13/128.0, },
{2/128.0, 2/128.0, 5/128.0, 6/128.0, 8/128.0, 10/128.0, },
{0/128.0, 1/128.0, 7/128.0, 7/128.0, 13/128.0, 13/128.0, },
{4/128.0, 5/128.0, 6/128.0, 8/128.0, 8/128.0, 11/128.0, },
{1/128.0, 4/128.0, 16/128.0, 13/128.0, 15/128.0, 17/128.0, },
{1/128.0, 1/128.0, 2/128.0, 4/128.0, 10/128.0, 13/128.0, },
{2/128.0, 2/128.0, 2/128.0, 12/128.0, 16/128.0, 15/128.0, },
{2/128.0, 3/128.0, 6/128.0, 10/128.0, 11/128.0, 11/128.0, },
{2/128.0, 2/128.0, 7/128.0, 11/128.0, 12/128.0, 11/128.0, },
{2/128.0, 2/128.0, 4/128.0, 4/128.0, 3/128.0, 8/128.0, },
{2/128.0, 3/128.0, 3/128.0, 8/128.0, 14/128.0, 17/128.0, },
{2/128.0, 3/128.0, 4/128.0, 9/128.0, 9/128.0, 11/128.0, },
{3/128.0, 4/128.0, 8/128.0, 11/128.0, 11/128.0, 15/128.0, },
{1/128.0, 1/128.0, 2/128.0, 7/128.0, 13/128.0, 13/128.0, },
{3/128.0, 3/128.0, 6/128.0, 10/128.0, 13/128.0, 14/128.0, },
{4/128.0, 5/128.0, 6/128.0, 8/128.0, 9/128.0, 11/128.0, },
{2/128.0, 3/128.0, 5/128.0, 6/128.0, 11/128.0, 12/128.0, },
{1/128.0, 2/128.0, 3/128.0, 6/128.0, 8/128.0, 15/128.0, },
{2/128.0, 3/128.0, 5/128.0, 7/128.0, 13/128.0, 14/128.0, },
{2/128.0, 3/128.0, 5/128.0, 9/128.0, 8/128.0, 9/128.0, },
{4/128.0, 5/128.0, 10/128.0, 12/128.0, 14/128.0, 16/128.0, },
{1/128.0, 2/128.0, 2/128.0, 8/128.0, 11/128.0, 12/128.0, },
{2/128.0, 3/128.0, 5/128.0, 12/128.0, 14/128.0, 13/128.0, },
{4/128.0, 7/128.0, 8/128.0, 9/128.0, 10/128.0, 11/128.0, },
{2/128.0, 3/128.0, 6/128.0, 12/128.0, 11/128.0, 12/128.0, },
{2/128.0, 3/128.0, 5/128.0, 6/128.0, 7/128.0, 9/128.0, },
{2/128.0, 2/128.0, 4/128.0, 7/128.0, 14/128.0, 17/128.0, },
{3/128.0, 3/128.0, 7/128.0, 9/128.0, 11/128.0, 11/128.0, },
{2/128.0, 4/128.0, 5/128.0, 7/128.0, 12/128.0, 13/128.0, },
{1/128.0, 2/128.0, 2/128.0, 5/128.0, 12/128.0, 15/128.0, },
{2/128.0, 3/128.0, 4/128.0, 7/128.0, 14/128.0, 17/128.0, },
{3/128.0, 4/128.0, 6/128.0, 7/128.0, 9/128.0, 15/128.0, },
{2/128.0, 2/128.0, 6/128.0, 9/128.0, 10/128.0, 14/128.0, },
{2/128.0, 2/128.0, 6/128.0, 7/128.0, 7/128.0, 15/128.0, },
{1/128.0, 2/128.0, 4/128.0, 9/128.0, 12/128.0, 14/128.0, },
{2/128.0, 3/128.0, 6/128.0, 7/128.0, 8/128.0, 8/128.0, },
{1/128.0, 2/128.0, 12/128.0, 11/128.0, 16/128.0, 17/128.0, },
{1/128.0, 2/128.0, 3/128.0, 5/128.0, 10/128.0, 10/128.0, },
{1/128.0, 1/128.0, 9/128.0, 16/128.0, 15/128.0, 16/128.0, },
{3/128.0, 3/128.0, 5/128.0, 9/128.0, 9/128.0, 11/128.0, },
{1/128.0, 1/128.0, 7/128.0, 10/128.0, 11/128.0, 12/128.0, },
{1/128.0, 1/128.0, 2/128.0, 6/128.0, 8/128.0, 8/128.0, },
{2/128.0, 2/128.0, 3/128.0, 9/128.0, 16/128.0, 18/128.0, },
{3/128.0, 4/128.0, 5/128.0, 9/128.0, 11/128.0, 10/128.0, },
{2/128.0, 3/128.0, 9/128.0, 10/128.0, 11/128.0, 16/128.0, },
{1/128.0, 2/128.0, 3/128.0, 7/128.0, 10/128.0, 13/128.0, },
{2/128.0, 4/128.0, 5/128.0, 8/128.0, 14/128.0, 15/128.0, },
{4/128.0, 6/128.0, 7/128.0, 9/128.0, 8/128.0, 9/128.0, },
{2/128.0, 2/128.0, 3/128.0, 9/128.0, 11/128.0, 11/128.0, },
{2/128.0, 3/128.0, 4/128.0, 5/128.0, 9/128.0, 16/128.0, },
{2/128.0, 4/128.0, 6/128.0, 8/128.0, 12/128.0, 13/128.0, },
{3/128.0, 3/128.0, 5/128.0, 6/128.0, 7/128.0, 10/128.0, },
{2/128.0, 4/128.0, 10/128.0, 12/128.0, 13/128.0, 15/128.0, },
{2/128.0, 2/128.0, 3/128.0, 6/128.0, 9/128.0, 8/128.0, },
{2/128.0, 3/128.0, 6/128.0, 12/128.0, 13/128.0, 15/128.0, },
{4/128.0, 5/128.0, 9/128.0, 10/128.0, 11/128.0, 15/128.0, },
{3/128.0, 3/128.0, 5/128.0, 9/128.0, 13/128.0, 14/128.0, },
{2/128.0, 2/128.0, 3/128.0, 4/128.0, 7/128.0, 12/128.0, },
{2/128.0, 3/128.0, 4/128.0, 6/128.0, 14/128.0, 15/128.0, },
{2/128.0, 3/128.0, 4/128.0, 6/128.0, 8/128.0, 11/128.0, },
{3/128.0, 4/128.0, 7/128.0, 13/128.0, 13/128.0, 13/128.0, },
{0/128.0, 1/128.0, 1/128.0, 2/128.0, 9/128.0, 12/128.0, },
{2/128.0, 2/128.0, 5/128.0, 10/128.0, 12/128.0, 16/128.0, },
{3/128.0, 5/128.0, 7/128.0, 8/128.0, 9/128.0, 10/128.0, },
{2/128.0, 3/128.0, 5/128.0, 7/128.0, 9/128.0, 15/128.0, },
{3/128.0, 4/128.0, 6/128.0, 7/128.0, 6/128.0, 13/128.0, },
{2/128.0, 2/128.0, 7/128.0, 7/128.0, 12/128.0, 15/128.0, },
{3/128.0, 4/128.0, 5/128.0, 6/128.0, 5/128.0, 8/128.0, },
{3/128.0, 7/128.0, 12/128.0, 16/128.0, 16/128.0, 17/128.0, },
{1/128.0, 1/128.0, 4/128.0, 5/128.0, 12/128.0, 14/128.0, },
{2/128.0, 2/128.0, 4/128.0, 18/128.0, 17/128.0, 16/128.0, },
{3/128.0, 4/128.0, 6/128.0, 9/128.0, 10/128.0, 12/128.0, },
{3/128.0, 4/128.0, 4/128.0, 9/128.0, 12/128.0, 12/128.0, },
{1/128.0, 2/128.0, 1/128.0, 3/128.0, 5/128.0, 10/128.0, },
{2/128.0, 2/128.0, 5/128.0, 7/128.0, 13/128.0, 17/128.0, },
{2/128.0, 3/128.0, 4/128.0, 8/128.0, 11/128.0, 12/128.0, },
{2/128.0, 3/128.0, 7/128.0, 9/128.0, 10/128.0, 14/128.0, },
{2/128.0, 3/128.0, 4/128.0, 5/128.0, 11/128.0, 12/128.0, },
{2/128.0, 3/128.0, 4/128.0, 9/128.0, 13/128.0, 13/128.0, },
{3/128.0, 5/128.0, 7/128.0, 8/128.0, 10/128.0, 11/128.0, },
{2/128.0, 3/128.0, 4/128.0, 8/128.0, 12/128.0, 12/128.0, },
{2/128.0, 2/128.0, 6/128.0, 3/128.0, 6/128.0, 12/128.0, },
{3/128.0, 5/128.0, 6/128.0, 7/128.0, 12/128.0, 14/128.0, },
{1/128.0, 2/128.0, 3/128.0, 6/128.0, 7/128.0, 8/128.0, },
{4/128.0, 10/128.0, 14/128.0, 14/128.0, 15/128.0, 17/128.0, },
{0/128.0, 0/128.0, 5/128.0, 8/128.0, 11/128.0, 11/128.0, },
{1/128.0, 1/128.0, 7/128.0, 12/128.0, 12/128.0, 12/128.0, },
{3/128.0, 5/128.0, 7/128.0, 9/128.0, 11/128.0, 12/128.0, },
{2/128.0, 2/128.0, 4/128.0, 10/128.0, 11/128.0, 13/128.0, },
{1/128.0, 1/128.0, 4/128.0, 6/128.0, 7/128.0, 9/128.0, },
{2/128.0, 3/128.0, 4/128.0, 6/128.0, 12/128.0, 14/128.0, },
{1/128.0, 1/128.0, 7/128.0, 7/128.0, 9/128.0, 12/128.0, },
{3/128.0, 4/128.0, 5/128.0, 10/128.0, 13/128.0, 13/128.0, },
{2/128.0, 2/128.0, 3/128.0, 4/128.0, 9/128.0, 14/128.0, },
{2/128.0, 3/128.0, 5/128.0, 8/128.0, 15/128.0, 16/128.0, },
{3/128.0, 4/128.0, 6/128.0, 7/128.0, 10/128.0, 15/128.0, },
{1/128.0, 2/128.0, 6/128.0, 7/128.0, 11/128.0, 12/128.0, },
{3/128.0, 4/128.0, 6/128.0, 7/128.0, 8/128.0, 13/128.0, },
{2/128.0, 2/128.0, 6/128.0, 8/128.0, 10/128.0, 17/128.0, },
{3/128.0, 3/128.0, 5/128.0, 8/128.0, 8/128.0, 9/128.0, },
{1/128.0, 1/128.0, 7/128.0, 14/128.0, 15/128.0, 19/128.0, },
{1/128.0, 2/128.0, 3/128.0, 6/128.0, 9/128.0, 11/128.0, },
{3/128.0, 4/128.0, 5/128.0, 13/128.0, 14/128.0, 13/128.0, },
{3/128.0, 3/128.0, 6/128.0, 9/128.0, 9/128.0, 14/128.0, },
{1/128.0, 1/128.0, 6/128.0, 9/128.0, 10/128.0, 14/128.0, },
{1/128.0, 2/128.0, 2/128.0, 3/128.0, 10/128.0, 11/128.0, },
{2/128.0, 3/128.0, 5/128.0, 8/128.0, 16/128.0, 21/128.0, },
{2/128.0, 4/128.0, 7/128.0, 8/128.0, 10/128.0, 11/128.0, },
{2/128.0, 3/128.0, 11/128.0, 15/128.0, 11/128.0, 13/128.0, },
{1/128.0, 2/128.0, 4/128.0, 9/128.0, 12/128.0, 12/128.0, },
{2/128.0, 2/128.0, 4/128.0, 9/128.0, 13/128.0, 14/128.0, },
{3/128.0, 6/128.0, 8/128.0, 8/128.0, 9/128.0, 10/128.0, },
{2/128.0, 3/128.0, 4/128.0, 9/128.0, 10/128.0, 11/128.0, },
{2/128.0, 3/128.0, 5/128.0, 6/128.0, 8/128.0, 16/128.0, },
{3/128.0, 4/128.0, 5/128.0, 7/128.0, 12/128.0, 13/128.0, },
{3/128.0, 4/128.0, 5/128.0, 6/128.0, 7/128.0, 9/128.0, },
{1/128.0, 3/128.0, 13/128.0, 12/128.0, 12/128.0, 15/128.0, },
{1/128.0, 2/128.0, 3/128.0, 8/128.0, 10/128.0, 10/128.0, },
{2/128.0, 2/128.0, 4/128.0, 12/128.0, 13/128.0, 14/128.0, },
{3/128.0, 4/128.0, 7/128.0, 9/128.0, 10/128.0, 12/128.0, },
{2/128.0, 2/128.0, 4/128.0, 11/128.0, 11/128.0, 14/128.0, },
{1/128.0, 1/128.0, 3/128.0, 5/128.0, 6/128.0, 12/128.0, },
{1/128.0, 2/128.0, 3/128.0, 4/128.0, 12/128.0, 16/128.0, },
{2/128.0, 3/128.0, 7/128.0, 8/128.0, 8/128.0, 11/128.0, },
{2/128.0, 2/128.0, 8/128.0, 12/128.0, 12/128.0, 13/128.0, },
{0/128.0, 0/128.0, 2/128.0, -1/128.0, 9/128.0, 11/128.0, },
{1/128.0, 1/128.0, 7/128.0, 12/128.0, 14/128.0, 17/128.0, },
{3/128.0, 5/128.0, 6/128.0, 8/128.0, 8/128.0, 10/128.0, },
{2/128.0, 2/128.0, 4/128.0, 7/128.0, 9/128.0, 12/128.0, },
{2/128.0, 2/128.0, 4/128.0, 7/128.0, 7/128.0, 12/128.0, },
{1/128.0, 1/128.0, 6/128.0, 10/128.0, 12/128.0, 16/128.0, },
{3/128.0, 5/128.0, 7/128.0, 7/128.0, 8/128.0, 8/128.0, },
{1/128.0, 2/128.0, 15/128.0, 14/128.0, 17/128.0, 20/128.0, },
{2/128.0, 2/128.0, 4/128.0, 5/128.0, 10/128.0, 11/128.0, },
{2/128.0, 2/128.0, 5/128.0, 14/128.0, 15/128.0, 16/128.0, },
{3/128.0, 4/128.0, 6/128.0, 10/128.0, 12/128.0, 11/128.0, },
{2/128.0, 3/128.0, 5/128.0, 9/128.0, 11/128.0, 12/128.0, },
{1/128.0, 1/128.0, 4/128.0, 6/128.0, 4/128.0, 11/128.0, },
{2/128.0, 3/128.0, 4/128.0, 9/128.0, 14/128.0, 16/128.0, },
{2/128.0, 3/128.0, 4/128.0, 8/128.0, 10/128.0, 11/128.0, },
{2/128.0, 3/128.0, 7/128.0, 12/128.0, 12/128.0, 15/128.0, },
{1/128.0, 1/128.0, 3/128.0, 8/128.0, 12/128.0, 12/128.0, },
{2/128.0, 3/128.0, 6/128.0, 8/128.0, 14/128.0, 15/128.0, },
{3/128.0, 5/128.0, 6/128.0, 8/128.0, 10/128.0, 12/128.0, },
{2/128.0, 2/128.0, 5/128.0, 7/128.0, 10/128.0, 11/128.0, },
{2/128.0, 2/128.0, 5/128.0, 7/128.0, 8/128.0, 13/128.0, },
{2/128.0, 4/128.0, 4/128.0, 6/128.0, 12/128.0, 15/128.0, },
{2/128.0, 2/128.0, 5/128.0, 6/128.0, 7/128.0, 9/128.0, },
{5/128.0, 9/128.0, 10/128.0, 8/128.0, 12/128.0, 14/128.0, },
{0/128.0, 1/128.0, 3/128.0, 6/128.0, 10/128.0, 11/128.0, },
{2/128.0, 3/128.0, 4/128.0, 11/128.0, 14/128.0, 14/128.0, },
{3/128.0, 5/128.0, 7/128.0, 8/128.0, 12/128.0, 13/128.0, },
{2/128.0, 3/128.0, 5/128.0, 11/128.0, 12/128.0, 15/128.0, },
{2/128.0, 3/128.0, 4/128.0, 5/128.0, 6/128.0, 9/128.0, },
{1/128.0, 1/128.0, 3/128.0, 6/128.0, 12/128.0, 17/128.0, },
{2/128.0, 3/128.0, 6/128.0, 9/128.0, 10/128.0, 11/128.0, },
{3/128.0, 5/128.0, 7/128.0, 8/128.0, 13/128.0, 14/128.0, },
{2/128.0, 2/128.0, 4/128.0, 5/128.0, 11/128.0, 15/128.0, },
{2/128.0, 2/128.0, 4/128.0, 8/128.0, 15/128.0, 17/128.0, },
{3/128.0, 4/128.0, 6/128.0, 8/128.0, 9/128.0, 13/128.0, },
{3/128.0, 4/128.0, 6/128.0, 8/128.0, 9/128.0, 14/128.0, },
{2/128.0, 3/128.0, 6/128.0, 8/128.0, 9/128.0, 15/128.0, },
{2/128.0, 3/128.0, 5/128.0, 9/128.0, 10/128.0, 14/128.0, },
{2/128.0, 3/128.0, 6/128.0, 8/128.0, 9/128.0, 10/128.0, },
{2/128.0, 4/128.0, 12/128.0, 13/128.0, 16/128.0, 15/128.0, },
{1/128.0, 2/128.0, 5/128.0, 5/128.0, 9/128.0, 11/128.0, },
{1/128.0, 2/128.0, 5/128.0, 12/128.0, 13/128.0, 16/128.0, },
{2/128.0, 4/128.0, 6/128.0, 9/128.0, 11/128.0, 12/128.0, },
{1/128.0, 0/128.0, 5/128.0, 8/128.0, 9/128.0, 13/128.0, },
{0/128.0, -1/128.0, 4/128.0, 6/128.0, 8/128.0, 10/128.0, },
{2/128.0, 2/128.0, 4/128.0, 7/128.0, 16/128.0, 17/128.0, },
{3/128.0, 5/128.0, 6/128.0, 8/128.0, 9/128.0, 10/128.0, },
{1/128.0, 2/128.0, 9/128.0, 9/128.0, 12/128.0, 14/128.0, },
{2/128.0, 2/128.0, 4/128.0, 7/128.0, 10/128.0, 14/128.0, },
{2/128.0, 2/128.0, 4/128.0, 8/128.0, 13/128.0, 15/128.0, },
{3/128.0, 5/128.0, 6/128.0, 8/128.0, 9/128.0, 11/128.0, },
{2/128.0, 3/128.0, 4/128.0, 10/128.0, 12/128.0, 11/128.0, },
{2/128.0, 3/128.0, 6/128.0, 6/128.0, 7/128.0, 17/128.0, },
{3/128.0, 4/128.0, 6/128.0, 8/128.0, 12/128.0, 13/128.0, },
{3/128.0, 3/128.0, 5/128.0, 6/128.0, 6/128.0, 9/128.0, },
{1/128.0, 1/128.0, 12/128.0, 12/128.0, 14/128.0, 14/128.0, },
{2/128.0, 3/128.0, 2/128.0, 7/128.0, 8/128.0, 9/128.0, },
{3/128.0, 3/128.0, 5/128.0, 12/128.0, 14/128.0, 15/128.0, },
{3/128.0, 4/128.0, 9/128.0, 10/128.0, 12/128.0, 13/128.0, },
{2/128.0, 3/128.0, 4/128.0, 9/128.0, 12/128.0, 13/128.0, },
{2/128.0, 2/128.0, 3/128.0, 4/128.0, 6/128.0, 13/128.0, },
{1/128.0, 2/128.0, 3/128.0, 4/128.0, 13/128.0, 13/128.0, },
{2/128.0, 4/128.0, 5/128.0, 5/128.0, 10/128.0, 10/128.0, },
{3/128.0, 3/128.0, 6/128.0, 11/128.0, 12/128.0, 13/128.0, },
{0/128.0, 1/128.0, 0/128.0, 3/128.0, 11/128.0, 12/128.0, },
{2/128.0, 2/128.0, 7/128.0, 10/128.0, 11/128.0, 19/128.0, },
{3/128.0, 4/128.0, 6/128.0, 8/128.0, 9/128.0, 13/128.0, },
{2/128.0, 2/128.0, 5/128.0, 8/128.0, 10/128.0, 12/128.0, },
{2/128.0, 3/128.0, 5/128.0, 6/128.0, 8/128.0, 12/128.0, },
{2/128.0, 2/128.0, 6/128.0, 9/128.0, 12/128.0, 14/128.0, },
{3/128.0, 4/128.0, 6/128.0, 7/128.0, 7/128.0, 10/128.0, },
{1/128.0, 2/128.0, 15/128.0, 19/128.0, 14/128.0, 16/128.0, },
{1/128.0, 2/128.0, 3/128.0, 4/128.0, 11/128.0, 11/128.0, },
{1/128.0, 2/128.0, 9/128.0, 13/128.0, 16/128.0, 14/128.0, },
{3/128.0, 3/128.0, 5/128.0, 9/128.0, 11/128.0, 11/128.0, },
{2/128.0, 3/128.0, 4/128.0, 11/128.0, 11/128.0, 12/128.0, },
{0/128.0, 1/128.0, 4/128.0, 2/128.0, 8/128.0, 10/128.0, },
{2/128.0, 3/128.0, 6/128.0, 7/128.0, 13/128.0, 15/128.0, },
{3/128.0, 4/128.0, 5/128.0, 8/128.0, 11/128.0, 11/128.0, },
{1/128.0, 1/128.0, 8/128.0, 13/128.0, 12/128.0, 17/128.0, },
{2/128.0, 3/128.0, 4/128.0, 8/128.0, 12/128.0, 13/128.0, },
{1/128.0, 2/128.0, 4/128.0, 7/128.0, 12/128.0, 13/128.0, },
{3/128.0, 5/128.0, 6/128.0, 8/128.0, 10/128.0, 11/128.0, },
{2/128.0, 2/128.0, 4/128.0, 8/128.0, 13/128.0, 12/128.0, },
{2/128.0, 3/128.0, 4/128.0, 6/128.0, 7/128.0, 14/128.0, },
{3/128.0, 4/128.0, 5/128.0, 7/128.0, 14/128.0, 16/128.0, },
{2/128.0, 2/128.0, 5/128.0, 7/128.0, 6/128.0, 5/128.0, },
{5/128.0, 7/128.0, 13/128.0, 15/128.0, 12/128.0, 15/128.0, },
{1/128.0, 2/128.0, 5/128.0, 7/128.0, 8/128.0, 11/128.0, },
{0/128.0, 0/128.0, 7/128.0, 11/128.0, 13/128.0, 14/128.0, },
{3/128.0, 4/128.0, 6/128.0, 9/128.0, 11/128.0, 11/128.0, },
{2/128.0, 3/128.0, 5/128.0, 10/128.0, 11/128.0, 15/128.0, },
{2/128.0, 3/128.0, 4/128.0, 6/128.0, 6/128.0, 10/128.0, },
{2/128.0, 2/128.0, 4/128.0, 7/128.0, 12/128.0, 15/128.0, },
{2/128.0, 2/128.0, 6/128.0, 9/128.0, 8/128.0, 11/128.0, },
{4/128.0, 4/128.0, 7/128.0, 11/128.0, 13/128.0, 14/128.0, },
{2/128.0, 2/128.0, 3/128.0, 5/128.0, 8/128.0, 15/128.0, },
{2/128.0, 2/128.0, 6/128.0, 10/128.0, 14/128.0, 17/128.0, },
{4/128.0, 5/128.0, 7/128.0, 8/128.0, 9/128.0, 14/128.0, },
{1/128.0, 1/128.0, 7/128.0, 8/128.0, 10/128.0, 13/128.0, },
{3/128.0, 4/128.0, 6/128.0, 7/128.0, 8/128.0, 16/128.0, },
{2/128.0, 3/128.0, 5/128.0, 8/128.0, 11/128.0, 17/128.0, },
{3/128.0, 4/128.0, 5/128.0, 7/128.0, 8/128.0, 9/128.0, },
{1/128.0, 1/128.0, 10/128.0, 13/128.0, 14/128.0, 17/128.0, },
{2/128.0, 2/128.0, 4/128.0, 7/128.0, 9/128.0, 12/128.0, },
{2/128.0, 3/128.0, 8/128.0, 14/128.0, 13/128.0, 16/128.0, },
{2/128.0, 3/128.0, 7/128.0, 10/128.0, 10/128.0, 12/128.0, },
{2/128.0, 3/128.0, 6/128.0, 11/128.0, 12/128.0, 12/128.0, },
{1/128.0, 2/128.0, 3/128.0, 4/128.0, 9/128.0, 10/128.0, },
{3/128.0, 5/128.0, 6/128.0, 9/128.0, 18/128.0, 19/128.0, },
{2/128.0, 3/128.0, 7/128.0, 8/128.0, 9/128.0, 12/128.0, },
{1/128.0, 2/128.0, 9/128.0, 11/128.0, 11/128.0, 13/128.0, },
{1/128.0, 1/128.0, 3/128.0, 9/128.0, 13/128.0, 15/128.0, },
{1/128.0, 2/128.0, 5/128.0, 10/128.0, 16/128.0, 16/128.0, },
{2/128.0, 4/128.0, 7/128.0, 9/128.0, 9/128.0, 10/128.0, },
{2/128.0, 2/128.0, 5/128.0, 8/128.0, 10/128.0, 11/128.0, },
{2/128.0, 3/128.0, 4/128.0, 5/128.0, 8/128.0, 14/128.0, },
{2/128.0, 4/128.0, 5/128.0, 7/128.0, 10/128.0, 13/128.0, },
{2/128.0, 3/128.0, 6/128.0, 8/128.0, 7/128.0, 8/128.0, },
{3/128.0, 9/128.0, 15/128.0, 12/128.0, 11/128.0, 12/128.0, },
{2/128.0, 3/128.0, 4/128.0, 8/128.0, 9/128.0, 10/128.0, },
{1/128.0, 1/128.0, 4/128.0, 10/128.0, 14/128.0, 14/128.0, },
{3/128.0, 5/128.0, 8/128.0, 9/128.0, 10/128.0, 12/128.0, },
{2/128.0, 3/128.0, 5/128.0, 8/128.0, 11/128.0, 13/128.0, },
{0/128.0, 0/128.0, 3/128.0, 3/128.0, 3/128.0, 13/128.0, },
{1/128.0, 1/128.0, 2/128.0, 3/128.0, 15/128.0, 14/128.0, },
{2/128.0, 3/128.0, 6/128.0, 8/128.0, 8/128.0, 11/128.0, },
{3/128.0, 4/128.0, 6/128.0, 10/128.0, 11/128.0, 13/128.0, },
{1/128.0, 1/128.0, 0/128.0, 0/128.0, 8/128.0, 12/128.0, },
{2/128.0, 3/128.0, 8/128.0, 10/128.0, 16/128.0, 16/128.0, },
{3/128.0, 5/128.0, 6/128.0, 7/128.0, 8/128.0, 12/128.0, },
{2/128.0, 3/128.0, 5/128.0, 8/128.0, 9/128.0, 12/128.0, },
{2/128.0, 2/128.0, 6/128.0, 6/128.0, 7/128.0, 12/128.0, },
{1/128.0, 1/128.0, 7/128.0, 7/128.0, 14/128.0, 16/128.0, },
{4/128.0, 6/128.0, 6/128.0, 8/128.0, 10/128.0, 9/128.0, },
{1/128.0, 2/128.0, 12/128.0, 13/128.0, 16/128.0, 19/128.0, },
{2/128.0, 2/128.0, 3/128.0, 6/128.0, 10/128.0, 11/128.0, },
{2/128.0, 2/128.0, 5/128.0, 12/128.0, 15/128.0, 16/128.0, },
{3/128.0, 5/128.0, 6/128.0, 9/128.0, 10/128.0, 10/128.0, },
{2/128.0, 2/128.0, 4/128.0, 10/128.0, 11/128.0, 12/128.0, },
{1/128.0, 2/128.0, 3/128.0, 3/128.0, 3/128.0, 11/128.0, },
{2/128.0, 3/128.0, 4/128.0, 7/128.0, 15/128.0, 16/128.0, },
{2/128.0, 3/128.0, 6/128.0, 8/128.0, 9/128.0, 11/128.0, },
{3/128.0, 4/128.0, 9/128.0, 13/128.0, 11/128.0, 16/128.0, },
{1/128.0, 2/128.0, 2/128.0, 6/128.0, 13/128.0, 14/128.0, },
{2/128.0, 3/128.0, 5/128.0, 9/128.0, 13/128.0, 16/128.0, },
{3/128.0, 5/128.0, 7/128.0, 9/128.0, 10/128.0, 11/128.0, },
{2/128.0, 3/128.0, 4/128.0, 7/128.0, 11/128.0, 11/128.0, },
{1/128.0, 2/128.0, 5/128.0, 6/128.0, 9/128.0, 14/128.0, },
{2/128.0, 4/128.0, 6/128.0, 6/128.0, 14/128.0, 15/128.0, },
{1/128.0, 1/128.0, 5/128.0, 8/128.0, 8/128.0, 9/128.0, },
{3/128.0, 6/128.0, 8/128.0, 10/128.0, 14/128.0, 18/128.0, },
{1/128.0, 1/128.0, 4/128.0, 8/128.0, 9/128.0, 10/128.0, },
{2/128.0, 2/128.0, 4/128.0, 12/128.0, 14/128.0, 14/128.0, },
{4/128.0, 5/128.0, 7/128.0, 9/128.0, 10/128.0, 11/128.0, },
{2/128.0, 2/128.0, 7/128.0, 11/128.0, 11/128.0, 13/128.0, },
{2/128.0, 3/128.0, 4/128.0, 5/128.0, 6/128.0, 10/128.0, },
{2/128.0, 2/128.0, 3/128.0, 7/128.0, 13/128.0, 16/128.0, },
{1/128.0, 1/128.0, 8/128.0, 10/128.0, 10/128.0, 11/128.0, },
{2/128.0, 3/128.0, 5/128.0, 9/128.0, 12/128.0, 14/128.0, },
{1/128.0, 2/128.0, 2/128.0, 1/128.0, 13/128.0, 14/128.0, },
{3/128.0, 4/128.0, 6/128.0, 9/128.0, 16/128.0, 15/128.0, },
{4/128.0, 5/128.0, 7/128.0, 8/128.0, 8/128.0, 12/128.0, },
{2/128.0, 3/128.0, 6/128.0, 8/128.0, 9/128.0, 13/128.0, },
{3/128.0, 3/128.0, 5/128.0, 6/128.0, 7/128.0, 15/128.0, },
{2/128.0, 2/128.0, 4/128.0, 9/128.0, 10/128.0, 14/128.0, },
{2/128.0, 4/128.0, 6/128.0, 8/128.0, 9/128.0, 9/128.0, },
{2/128.0, 3/128.0, 9/128.0, 13/128.0, 16/128.0, 17/128.0, },
{2/128.0, 3/128.0, 4/128.0, 6/128.0, 9/128.0, 10/128.0, },
{2/128.0, 2/128.0, 6/128.0, 13/128.0, 15/128.0, 17/128.0, },
{3/128.0, 4/128.0, 7/128.0, 9/128.0, 10/128.0, 11/128.0, },
{1/128.0, 2/128.0, 5/128.0, 11/128.0, 10/128.0, 12/128.0, },
{1/128.0, 2/128.0, 1/128.0, 7/128.0, 8/128.0, 9/128.0, },
{2/128.0, 3/128.0, 3/128.0, 10/128.0, 15/128.0, 18/128.0, },
{4/128.0, 4/128.0, 5/128.0, 10/128.0, 8/128.0, 9/128.0, },
{1/128.0, 2/128.0, 10/128.0, 11/128.0, 12/128.0, 14/128.0, },
{2/128.0, 2/128.0, 3/128.0, 6/128.0, 9/128.0, 13/128.0, },
{2/128.0, 3/128.0, 4/128.0, 8/128.0, 13/128.0, 15/128.0, },
{4/128.0, 6/128.0, 7/128.0, 9/128.0, 9/128.0, 11/128.0, },
{1/128.0, 1/128.0, 2/128.0, 9/128.0, 11/128.0, 11/128.0, },
{2/128.0, 3/128.0, 4/128.0, 4/128.0, 7/128.0, 19/128.0, },
{2/128.0, 3/128.0, 5/128.0, 8/128.0, 12/128.0, 13/128.0, },
{3/128.0, 4/128.0, 5/128.0, 8/128.0, 7/128.0, 10/128.0, },
{1/128.0, 4/128.0, 11/128.0, 11/128.0, 12/128.0, 13/128.0, },
{1/128.0, 2/128.0, 4/128.0, 6/128.0, 9/128.0, 9/128.0, },
{2/128.0, 2/128.0, 6/128.0, 12/128.0, 13/128.0, 14/128.0, },
{4/128.0, 5/128.0, 7/128.0, 8/128.0, 10/128.0, 16/128.0, },
{3/128.0, 4/128.0, 5/128.0, 9/128.0, 12/128.0, 13/128.0, },
{2/128.0, 3/128.0, 4/128.0, 5/128.0, 7/128.0, 12/128.0, },
{2/128.0, 2/128.0, 3/128.0, 7/128.0, 14/128.0, 15/128.0, },
{2/128.0, 3/128.0, 4/128.0, 7/128.0, 8/128.0, 10/128.0, },
{4/128.0, 6/128.0, 8/128.0, 10/128.0, 11/128.0, 12/128.0, },
{1/128.0, 1/128.0, 4/128.0, 1/128.0, 10/128.0, 13/128.0, },
{2/128.0, 2/128.0, 4/128.0, 10/128.0, 12/128.0, 19/128.0, },
{3/128.0, 4/128.0, 6/128.0, 8/128.0, 9/128.0, 12/128.0, },
{2/128.0, 2/128.0, 6/128.0, 9/128.0, 8/128.0, 13/128.0, },
{3/128.0, 4/128.0, 6/128.0, 7/128.0, 7/128.0, 12/128.0, },
{1/128.0, 1/128.0, 5/128.0, 7/128.0, 11/128.0, 15/128.0, },
{3/128.0, 5/128.0, 6/128.0, 8/128.0, 7/128.0, 9/128.0, },
{4/128.0, 10/128.0, 16/128.0, 18/128.0, 16/128.0, 17/128.0, },
{1/128.0, 2/128.0, 2/128.0, 5/128.0, 12/128.0, 12/128.0, },
{2/128.0, 2/128.0, 5/128.0, 15/128.0, 16/128.0, 15/128.0, },
{3/128.0, 4/128.0, 6/128.0, 8/128.0, 10/128.0, 11/128.0, },
{2/128.0, 3/128.0, 5/128.0, 10/128.0, 12/128.0, 13/128.0, },
{1/128.0, 1/128.0, 2/128.0, 0/128.0, 4/128.0, 9/128.0, },
{2/128.0, 3/128.0, 5/128.0, 7/128.0, 13/128.0, 20/128.0, },
{2/128.0, 3/128.0, 4/128.0, 8/128.0, 11/128.0, 12/128.0, },
{2/128.0, 3/128.0, 8/128.0, 10/128.0, 10/128.0, 15/128.0, },
{1/128.0, 2/128.0, 3/128.0, 6/128.0, 12/128.0, 13/128.0, },
{2/128.0, 2/128.0, 4/128.0, 7/128.0, 14/128.0, 15/128.0, },
{3/128.0, 6/128.0, 6/128.0, 8/128.0, 11/128.0, 11/128.0, },
{2/128.0, 3/128.0, 5/128.0, 8/128.0, 11/128.0, 12/128.0, },
{3/128.0, 3/128.0, 5/128.0, 6/128.0, 7/128.0, 13/128.0, },
{2/128.0, 4/128.0, 6/128.0, 7/128.0, 12/128.0, 14/128.0, },
{1/128.0, 2/128.0, 4/128.0, 7/128.0, 7/128.0, 7/128.0, },
{5/128.0, 14/128.0, 15/128.0, 13/128.0, 14/128.0, 16/128.0, },
{1/128.0, 0/128.0, 5/128.0, 6/128.0, 10/128.0, 12/128.0, },
{2/128.0, 2/128.0, 6/128.0, 14/128.0, 12/128.0, 13/128.0, },
{4/128.0, 5/128.0, 6/128.0, 10/128.0, 12/128.0, 12/128.0, },
{2/128.0, 2/128.0, 5/128.0, 10/128.0, 11/128.0, 15/128.0, },
{1/128.0, 2/128.0, 3/128.0, 5/128.0, 6/128.0, 10/128.0, },
{2/128.0, 3/128.0, 4/128.0, 6/128.0, 13/128.0, 16/128.0, },
{1/128.0, 2/128.0, 8/128.0, 8/128.0, 10/128.0, 10/128.0, },
{3/128.0, 4/128.0, 6/128.0, 9/128.0, 13/128.0, 14/128.0, },
{1/128.0, 2/128.0, 3/128.0, 5/128.0, 8/128.0, 12/128.0, },
{2/128.0, 2/128.0, 4/128.0, 9/128.0, 14/128.0, 15/128.0, },
{3/128.0, 4/128.0, 6/128.0, 8/128.0, 9/128.0, 17/128.0, },
{2/128.0, 2/128.0, 5/128.0, 6/128.0, 10/128.0, 13/128.0, },
{3/128.0, 4/128.0, 6/128.0, 7/128.0, 9/128.0, 14/128.0, },
{2/128.0, 2/128.0, 6/128.0, 6/128.0, 10/128.0, 17/128.0, },
{2/128.0, 3/128.0, 5/128.0, 6/128.0, 8/128.0, 10/128.0, },
{2/128.0, 2/128.0, 9/128.0, 10/128.0, 15/128.0, 19/128.0, },
{1/128.0, 2/128.0, 2/128.0, 8/128.0, 8/128.0, 12/128.0, },
{2/128.0, 3/128.0, 8/128.0, 11/128.0, 13/128.0, 14/128.0, },
{2/128.0, 4/128.0, 8/128.0, 9/128.0, 11/128.0, 13/128.0, },
{2/128.0, 2/128.0, 7/128.0, 9/128.0, 11/128.0, 13/128.0, },
{1/128.0, 1/128.0, 1/128.0, 5/128.0, 10/128.0, 10/128.0, },
{2/128.0, 2/128.0, 4/128.0, 11/128.0, 17/128.0, 18/128.0, },
{3/128.0, 3/128.0, 5/128.0, 9/128.0, 10/128.0, 11/128.0, },
{2/128.0, 3/128.0, 12/128.0, 11/128.0, 11/128.0, 11/128.0, },
{2/128.0, 2/128.0, 4/128.0, 8/128.0, 13/128.0, 14/128.0, },
{3/128.0, 3/128.0, 4/128.0, 10/128.0, 13/128.0, 16/128.0, },
{3/128.0, 5/128.0, 7/128.0, 8/128.0, 10/128.0, 10/128.0, },
{1/128.0, 1/128.0, 5/128.0, 9/128.0, 10/128.0, 10/128.0, },
{2/128.0, 3/128.0, 4/128.0, 5/128.0, 10/128.0, 15/128.0, },
{2/128.0, 3/128.0, 4/128.0, 7/128.0, 12/128.0, 13/128.0, },
{2/128.0, 3/128.0, 4/128.0, 5/128.0, 7/128.0, 9/128.0, },
{1/128.0, 4/128.0, 15/128.0, 11/128.0, 12/128.0, 13/128.0, },
{2/128.0, 3/128.0, 4/128.0, 7/128.0, 9/128.0, 11/128.0, },
{2/128.0, 3/128.0, 3/128.0, 10/128.0, 13/128.0, 14/128.0, },
{3/128.0, 5/128.0, 6/128.0, 10/128.0, 10/128.0, 14/128.0, },
{2/128.0, 3/128.0, 3/128.0, 10/128.0, 13/128.0, 12/128.0, },
{1/128.0, 1/128.0, 5/128.0, 6/128.0, 6/128.0, 13/128.0, },
{1/128.0, 2/128.0, 2/128.0, 4/128.0, 14/128.0, 17/128.0, },
{2/128.0, 3/128.0, 7/128.0, 8/128.0, 6/128.0, 11/128.0, },
{3/128.0, 4/128.0, 7/128.0, 10/128.0, 13/128.0, 13/128.0, },
{0/128.0, 0/128.0, 3/128.0, 1/128.0, 9/128.0, 10/128.0, },
{2/128.0, 2/128.0, 5/128.0, 10/128.0, 14/128.0, 14/128.0, },
{3/128.0, 5/128.0, 7/128.0, 8/128.0, 8/128.0, 11/128.0, },
{2/128.0, 3/128.0, 4/128.0, 7/128.0, 11/128.0, 12/128.0, },
{2/128.0, 3/128.0, 5/128.0, 6/128.0, 7/128.0, 11/128.0, },
{1/128.0, 2/128.0, 5/128.0, 8/128.0, 12/128.0, 15/128.0, },
{3/128.0, 5/128.0, 6/128.0, 7/128.0, 8/128.0, 10/128.0, },
{1/128.0, 3/128.0, 17/128.0, 16/128.0, 17/128.0, 19/128.0, },
{2/128.0, 3/128.0, 3/128.0, 6/128.0, 11/128.0, 11/128.0, },
{2/128.0, 3/128.0, 4/128.0, 13/128.0, 14/128.0, 15/128.0, },
{4/128.0, 4/128.0, 7/128.0, 10/128.0, 12/128.0, 11/128.0, },
{2/128.0, 3/128.0, 7/128.0, 9/128.0, 10/128.0, 12/128.0, },
{1/128.0, 1/128.0, 3/128.0, 5/128.0, 2/128.0, 11/128.0, },
{2/128.0, 3/128.0, 3/128.0, 7/128.0, 12/128.0, 16/128.0, },
{2/128.0, 3/128.0, 4/128.0, 8/128.0, 10/128.0, 11/128.0, },
{1/128.0, 2/128.0, 9/128.0, 11/128.0, 14/128.0, 16/128.0, },
{1/128.0, 0/128.0, 2/128.0, 8/128.0, 12/128.0, 12/128.0, },
{2/128.0, 3/128.0, 5/128.0, 11/128.0, 15/128.0, 15/128.0, },
{3/128.0, 5/128.0, 6/128.0, 9/128.0, 10/128.0, 11/128.0, },
{1/128.0, 2/128.0, 5/128.0, 7/128.0, 10/128.0, 10/128.0, },
{2/128.0, 3/128.0, 5/128.0, 6/128.0, 8/128.0, 13/128.0, },
{2/128.0, 3/128.0, 5/128.0, 7/128.0, 11/128.0, 15/128.0, },
{2/128.0, 3/128.0, 5/128.0, 6/128.0, 6/128.0, 8/128.0, },
{3/128.0, 9/128.0, 8/128.0, 11/128.0, 11/128.0, 14/128.0, },
{1/128.0, 1/128.0, 1/128.0, 6/128.0, 11/128.0, 11/128.0, },
{3/128.0, 3/128.0, 5/128.0, 11/128.0, 12/128.0, 12/128.0, },
{3/128.0, 6/128.0, 6/128.0, 8/128.0, 12/128.0, 13/128.0, },
{2/128.0, 3/128.0, 7/128.0, 11/128.0, 11/128.0, 15/128.0, },
{2/128.0, 3/128.0, 4/128.0, 5/128.0, 6/128.0, 11/128.0, },
{2/128.0, 2/128.0, 4/128.0, 6/128.0, 12/128.0, 16/128.0, },
{2/128.0, 2/128.0, 7/128.0, 11/128.0, 7/128.0, 10/128.0, },
{2/128.0, 3/128.0, 6/128.0, 10/128.0, 13/128.0, 12/128.0, },
{2/128.0, 3/128.0, 3/128.0, 4/128.0, 12/128.0, 15/128.0, },
{2/128.0, 2/128.0, 4/128.0, 8/128.0, 15/128.0, 15/128.0, },
{3/128.0, 4/128.0, 7/128.0, 8/128.0, 9/128.0, 13/128.0, },
{2/128.0, 2/128.0, 6/128.0, 7/128.0, 9/128.0, 13/128.0, },
{2/128.0, 3/128.0, 6/128.0, 6/128.0, 9/128.0, 15/128.0, },
{2/128.0, 2/128.0, 4/128.0, 8/128.0, 10/128.0, 15/128.0, },
{3/128.0, 4/128.0, 7/128.0, 8/128.0, 8/128.0, 9/128.0, },
{1/128.0, 4/128.0, 12/128.0, 11/128.0, 13/128.0, 16/128.0, },
{1/128.0, 2/128.0, 4/128.0, 5/128.0, 9/128.0, 12/128.0, },
{2/128.0, 2/128.0, 6/128.0, 13/128.0, 14/128.0, 15/128.0, },
{2/128.0, 3/128.0, 6/128.0, 9/128.0, 10/128.0, 13/128.0, },
{1/128.0, 1/128.0, 3/128.0, 10/128.0, 11/128.0, 15/128.0, },
{0/128.0, 0/128.0, 3/128.0, 4/128.0, 7/128.0, 9/128.0, },
{1/128.0, 2/128.0, 2/128.0, 7/128.0, 16/128.0, 18/128.0, },
{2/128.0, 5/128.0, 7/128.0, 7/128.0, 9/128.0, 10/128.0, },
{2/128.0, 3/128.0, 7/128.0, 9/128.0, 12/128.0, 13/128.0, },
{2/128.0, 2/128.0, 4/128.0, 6/128.0, 10/128.0, 14/128.0, },
{1/128.0, 1/128.0, 2/128.0, 8/128.0, 15/128.0, 15/128.0, },
{4/128.0, 5/128.0, 6/128.0, 9/128.0, 10/128.0, 11/128.0, },
{2/128.0, 3/128.0, 4/128.0, 9/128.0, 11/128.0, 12/128.0, },
{3/128.0, 4/128.0, 5/128.0, 6/128.0, 11/128.0, 16/128.0, },
{4/128.0, 5/128.0, 6/128.0, 8/128.0, 12/128.0, 12/128.0, },
{3/128.0, 4/128.0, 5/128.0, 7/128.0, 6/128.0, 10/128.0, },
{1/128.0, 2/128.0, 11/128.0, 13/128.0, 13/128.0, 14/128.0, },
{1/128.0, 1/128.0, 2/128.0, 6/128.0, 7/128.0, 10/128.0, },
{2/128.0, 2/128.0, 6/128.0, 11/128.0, 14/128.0, 15/128.0, },
{3/128.0, 5/128.0, 7/128.0, 10/128.0, 11/128.0, 14/128.0, },
{2/128.0, 3/128.0, 6/128.0, 7/128.0, 12/128.0, 13/128.0, },
{2/128.0, 2/128.0, 3/128.0, 5/128.0, 6/128.0, 13/128.0, },
{1/128.0, 2/128.0, 3/128.0, 4/128.0, 14/128.0, 14/128.0, },
{2/128.0, 3/128.0, 6/128.0, 7/128.0, 9/128.0, 10/128.0, },
{3/128.0, 4/128.0, 6/128.0, 11/128.0, 12/128.0, 13/128.0, },
{1/128.0, 1/128.0, 2/128.0, 4/128.0, 12/128.0, 13/128.0, },
{2/128.0, 3/128.0, 8/128.0, 9/128.0, 12/128.0, 18/128.0, },
{2/128.0, 3/128.0, 6/128.0, 7/128.0, 10/128.0, 11/128.0, },
{1/128.0, 1/128.0, 5/128.0, 8/128.0, 9/128.0, 14/128.0, },
{3/128.0, 4/128.0, 5/128.0, 6/128.0, 8/128.0, 13/128.0, },
{2/128.0, 2/128.0, 6/128.0, 8/128.0, 11/128.0, 14/128.0, },
{2/128.0, 3/128.0, 5/128.0, 7/128.0, 8/128.0, 10/128.0, },
{2/128.0, 4/128.0, 14/128.0, 15/128.0, 15/128.0, 15/128.0, },
{2/128.0, 2/128.0, 3/128.0, 5/128.0, 10/128.0, 12/128.0, },
{2/128.0, 3/128.0, 7/128.0, 12/128.0, 20/128.0, 16/128.0, },
{3/128.0, 4/128.0, 5/128.0, 8/128.0, 12/128.0, 12/128.0, },
{2/128.0, 2/128.0, 4/128.0, 10/128.0, 12/128.0, 12/128.0, },
{1/128.0, 1/128.0, 3/128.0, 4/128.0, 6/128.0, 8/128.0, },
{2/128.0, 2/128.0, 6/128.0, 6/128.0, 15/128.0, 16/128.0, },
{3/128.0, 4/128.0, 5/128.0, 8/128.0, 10/128.0, 10/128.0, },
{2/128.0, 2/128.0, 7/128.0, 10/128.0, 10/128.0, 15/128.0, },
{2/128.0, 3/128.0, 4/128.0, 8/128.0, 12/128.0, 14/128.0, },
{1/128.0, 2/128.0, 5/128.0, 7/128.0, 12/128.0, 14/128.0, },
{2/128.0, 4/128.0, 6/128.0, 8/128.0, 10/128.0, 11/128.0, },
{2/128.0, 2/128.0, 3/128.0, 7/128.0, 11/128.0, 13/128.0, },
{2/128.0, 2/128.0, 4/128.0, 7/128.0, 7/128.0, 14/128.0, },
{3/128.0, 4/128.0, 5/128.0, 8/128.0, 13/128.0, 15/128.0, },
{2/128.0, 3/128.0, 3/128.0, 6/128.0, 5/128.0, 5/128.0, },
{6/128.0, 8/128.0, 11/128.0, 12/128.0, 13/128.0, 15/128.0, },
{1/128.0, 1/128.0, 4/128.0, 7/128.0, 9/128.0, 12/128.0, },
{1/128.0, 2/128.0, 7/128.0, 11/128.0, 12/128.0, 14/128.0, },
{4/128.0, 5/128.0, 6/128.0, 9/128.0, 11/128.0, 12/128.0, },
{2/128.0, 2/128.0, 6/128.0, 10/128.0, 11/128.0, 13/128.0, },
{2/128.0, 2/128.0, 4/128.0, 6/128.0, 8/128.0, 10/128.0, },
{2/128.0, 3/128.0, 5/128.0, 7/128.0, 12/128.0, 16/128.0, },
{2/128.0, 3/128.0, 6/128.0, 6/128.0, 10/128.0, 11/128.0, },
{3/128.0, 5/128.0, 6/128.0, 10/128.0, 14/128.0, 14/128.0, },
{1/128.0, 1/128.0, 5/128.0, 5/128.0, 9/128.0, 14/128.0, },
{2/128.0, 3/128.0, 6/128.0, 9/128.0, 15/128.0, 16/128.0, },
{4/128.0, 5/128.0, 8/128.0, 8/128.0, 9/128.0, 14/128.0, },
{2/128.0, 2/128.0, 8/128.0, 9/128.0, 9/128.0, 14/128.0, },
{3/128.0, 3/128.0, 6/128.0, 6/128.0, 8/128.0, 15/128.0, },
{2/128.0, 3/128.0, 3/128.0, 7/128.0, 10/128.0, 16/128.0, },
{3/128.0, 4/128.0, 5/128.0, 7/128.0, 8/128.0, 10/128.0, },
{1/128.0, 1/128.0, 8/128.0, 12/128.0, 13/128.0, 15/128.0, },
{2/128.0, 2/128.0, 4/128.0, 6/128.0, 8/128.0, 13/128.0, },
{3/128.0, 3/128.0, 8/128.0, 13/128.0, 14/128.0, 14/128.0, },
{2/128.0, 3/128.0, 6/128.0, 10/128.0, 11/128.0, 13/128.0, },
{2/128.0, 2/128.0, 6/128.0, 11/128.0, 12/128.0, 14/128.0, },
{1/128.0, 1/128.0, 3/128.0, 5/128.0, 8/128.0, 11/128.0, },
{2/128.0, 3/128.0, 4/128.0, 7/128.0, 19/128.0, 18/128.0, },
{3/128.0, 3/128.0, 7/128.0, 9/128.0, 10/128.0, 10/128.0, },
{2/128.0, 2/128.0, 9/128.0, 10/128.0, 11/128.0, 12/128.0, },
{1/128.0, 2/128.0, 3/128.0, 7/128.0, 12/128.0, 14/128.0, },
{2/128.0, 3/128.0, 4/128.0, 10/128.0, 15/128.0, 16/128.0, },
{2/128.0, 5/128.0, 7/128.0, 9/128.0, 11/128.0, 12/128.0, },
{2/128.0, 3/128.0, 5/128.0, 9/128.0, 10/128.0, 11/128.0, },
{2/128.0, 2/128.0, 4/128.0, 4/128.0, 6/128.0, 15/128.0, },
{3/128.0, 4/128.0, 6/128.0, 7/128.0, 11/128.0, 12/128.0, },
{2/128.0, 4/128.0, 5/128.0, 6/128.0, 9/128.0, 9/128.0, },
{2/128.0, 4/128.0, 15/128.0, 14/128.0, 12/128.0, 13/128.0, },
{2/128.0, 2/128.0, 5/128.0, 8/128.0, 9/128.0, 10/128.0, },
{1/128.0, 2/128.0, 2/128.0, 10/128.0, 14/128.0, 15/128.0, },
{3/128.0, 4/128.0, 5/128.0, 10/128.0, 10/128.0, 12/128.0, },
{2/128.0, 2/128.0, 5/128.0, 9/128.0, 11/128.0, 13/128.0, },
{1/128.0, 2/128.0, 1/128.0, 4/128.0, 7/128.0, 12/128.0, },
{1/128.0, 1/128.0, 2/128.0, 4/128.0, 15/128.0, 15/128.0, },
{2/128.0, 3/128.0, 5/128.0, 7/128.0, 9/128.0, 12/128.0, },
{2/128.0, 3/128.0, 6/128.0, 10/128.0, 12/128.0, 13/128.0, },
{1/128.0, 2/128.0, 2/128.0, -1/128.0, 9/128.0, 14/128.0, },
{2/128.0, 4/128.0, 9/128.0, 10/128.0, 15/128.0, 15/128.0, },
{3/128.0, 4/128.0, 6/128.0, 7/128.0, 8/128.0, 13/128.0, },
{2/128.0, 2/128.0, 4/128.0, 8/128.0, 10/128.0, 13/128.0, },
{2/128.0, 3/128.0, 5/128.0, 5/128.0, 8/128.0, 10/128.0, },
{1/128.0, 0/128.0, 5/128.0, 8/128.0, 12/128.0, 13/128.0, },
{3/128.0, 4/128.0, 6/128.0, 7/128.0, 8/128.0, 10/128.0, },
{1/128.0, 2/128.0, 14/128.0, 15/128.0, 15/128.0, 17/128.0, },
{1/128.0, 2/128.0, 2/128.0, 5/128.0, 10/128.0, 12/128.0, },
{1/128.0, 2/128.0, 4/128.0, 13/128.0, 15/128.0, 16/128.0, },
{3/128.0, 4/128.0, 5/128.0, 9/128.0, 10/128.0, 11/128.0, },
{2/128.0, 3/128.0, 7/128.0, 10/128.0, 11/128.0, 12/128.0, },
{1/128.0, 1/128.0, 3/128.0, 3/128.0, 4/128.0, 6/128.0, },
{2/128.0, 2/128.0, 3/128.0, 8/128.0, 14/128.0, 16/128.0, },
{3/128.0, 4/128.0, 5/128.0, 8/128.0, 9/128.0, 10/128.0, },
{3/128.0, 3/128.0, 8/128.0, 12/128.0, 12/128.0, 15/128.0, },
{1/128.0, 2/128.0, 2/128.0, 7/128.0, 13/128.0, 13/128.0, },
{3/128.0, 4/128.0, 5/128.0, 10/128.0, 14/128.0, 15/128.0, },
{4/128.0, 5/128.0, 7/128.0, 9/128.0, 10/128.0, 12/128.0, },
{1/128.0, 3/128.0, 6/128.0, 7/128.0, 11/128.0, 11/128.0, },
{2/128.0, 2/128.0, 5/128.0, 6/128.0, 8/128.0, 16/128.0, },
{2/128.0, 4/128.0, 5/128.0, 7/128.0, 12/128.0, 15/128.0, },
{2/128.0, 2/128.0, 5/128.0, 9/128.0, 7/128.0, 8/128.0, },
{3/128.0, 6/128.0, 8/128.0, 14/128.0, 14/128.0, 15/128.0, },
{1/128.0, 2/128.0, 3/128.0, 8/128.0, 10/128.0, 12/128.0, },
{1/128.0, 2/128.0, 6/128.0, 11/128.0, 13/128.0, 14/128.0, },
{4/128.0, 6/128.0, 7/128.0, 9/128.0, 10/128.0, 11/128.0, },
{3/128.0, 3/128.0, 6/128.0, 11/128.0, 12/128.0, 13/128.0, },
{2/128.0, 3/128.0, 4/128.0, 6/128.0, 7/128.0, 10/128.0, },
{2/128.0, 3/128.0, 4/128.0, 7/128.0, 14/128.0, 16/128.0, },
{2/128.0, 3/128.0, 8/128.0, 10/128.0, 10/128.0, 11/128.0, },
{3/128.0, 4/128.0, 5/128.0, 7/128.0, 12/128.0, 14/128.0, },
{1/128.0, 1/128.0, 2/128.0, 3/128.0, 11/128.0, 16/128.0, },
{2/128.0, 4/128.0, 5/128.0, 7/128.0, 15/128.0, 17/128.0, },
{4/128.0, 4/128.0, 6/128.0, 7/128.0, 8/128.0, 13/128.0, },
{2/128.0, 3/128.0, 7/128.0, 9/128.0, 10/128.0, 14/128.0, },
{2/128.0, 2/128.0, 5/128.0, 6/128.0, 8/128.0, 15/128.0, },
{2/128.0, 2/128.0, 4/128.0, 10/128.0, 12/128.0, 15/128.0, },
{2/128.0, 3/128.0, 6/128.0, 6/128.0, 7/128.0, 9/128.0, },
{2/128.0, 3/128.0, 11/128.0, 11/128.0, 18/128.0, 18/128.0, },
{1/128.0, 2/128.0, 4/128.0, 5/128.0, 10/128.0, 10/128.0, },
{2/128.0, 2/128.0, 9/128.0, 15/128.0, 15/128.0, 16/128.0, },
{2/128.0, 2/128.0, 6/128.0, 10/128.0, 10/128.0, 11/128.0, },
{1/128.0, 2/128.0, 7/128.0, 9/128.0, 12/128.0, 12/128.0, },
{0/128.0, 1/128.0, 3/128.0, 6/128.0, 9/128.0, 8/128.0, },
{2/128.0, 2/128.0, 5/128.0, 10/128.0, 16/128.0, 17/128.0, },
{3/128.0, 3/128.0, 4/128.0, 9/128.0, 10/128.0, 10/128.0, },
{1/128.0, 2/128.0, 11/128.0, 9/128.0, 11/128.0, 15/128.0, },
{1/128.0, 2/128.0, 2/128.0, 6/128.0, 10/128.0, 14/128.0, },
{3/128.0, 3/128.0, 4/128.0, 8/128.0, 13/128.0, 15/128.0, },
{4/128.0, 5/128.0, 6/128.0, 8/128.0, 8/128.0, 10/128.0, },
{2/128.0, 3/128.0, 2/128.0, 8/128.0, 11/128.0, 12/128.0, },
{2/128.0, 2/128.0, 5/128.0, 5/128.0, 9/128.0, 17/128.0, },
{3/128.0, 4/128.0, 5/128.0, 9/128.0, 12/128.0, 13/128.0, },
{3/128.0, 3/128.0, 4/128.0, 6/128.0, 8/128.0, 11/128.0, },
{1/128.0, 6/128.0, 12/128.0, 12/128.0, 14/128.0, 15/128.0, },
{2/128.0, 3/128.0, 3/128.0, 5/128.0, 8/128.0, 9/128.0, },
{2/128.0, 2/128.0, 6/128.0, 12/128.0, 13/128.0, 14/128.0, },
{5/128.0, 5/128.0, 8/128.0, 10/128.0, 10/128.0, 16/128.0, },
{3/128.0, 4/128.0, 4/128.0, 8/128.0, 13/128.0, 14/128.0, },
{2/128.0, 2/128.0, 4/128.0, 5/128.0, 7/128.0, 13/128.0, },
{2/128.0, 2/128.0, 4/128.0, 5/128.0, 13/128.0, 14/128.0, },
{2/128.0, 3/128.0, 5/128.0, 7/128.0, 8/128.0, 11/128.0, },
{4/128.0, 5/128.0, 9/128.0, 13/128.0, 11/128.0, 13/128.0, },
{0/128.0, 0/128.0, 3/128.0, 2/128.0, 10/128.0, 13/128.0, },
{2/128.0, 2/128.0, 6/128.0, 10/128.0, 13/128.0, 16/128.0, },
{2/128.0, 4/128.0, 7/128.0, 8/128.0, 9/128.0, 11/128.0, },
{2/128.0, 2/128.0, 5/128.0, 8/128.0, 9/128.0, 14/128.0, },
{3/128.0, 4/128.0, 4/128.0, 7/128.0, 7/128.0, 12/128.0, },
{1/128.0, 1/128.0, 7/128.0, 8/128.0, 11/128.0, 14/128.0, },
{3/128.0, 4/128.0, 6/128.0, 7/128.0, 7/128.0, 8/128.0, },
{3/128.0, 7/128.0, 15/128.0, 15/128.0, 15/128.0, 17/128.0, },
{1/128.0, 1/128.0, 4/128.0, 6/128.0, 12/128.0, 13/128.0, },
{2/128.0, 2/128.0, 9/128.0, 19/128.0, 16/128.0, 17/128.0, },
{3/128.0, 4/128.0, 5/128.0, 9/128.0, 11/128.0, 12/128.0, },
{3/128.0, 3/128.0, 4/128.0, 10/128.0, 12/128.0, 13/128.0, },
{1/128.0, 1/128.0, 0/128.0, 1/128.0, 8/128.0, 8/128.0, },
{2/128.0, 3/128.0, 6/128.0, 7/128.0, 14/128.0, 18/128.0, },
{2/128.0, 3/128.0, 5/128.0, 7/128.0, 10/128.0, 12/128.0, },
{3/128.0, 4/128.0, 7/128.0, 9/128.0, 10/128.0, 14/128.0, },
{2/128.0, 3/128.0, 3/128.0, 6/128.0, 12/128.0, 13/128.0, },
{2/128.0, 2/128.0, 5/128.0, 8/128.0, 13/128.0, 15/128.0, },
{3/128.0, 6/128.0, 7/128.0, 8/128.0, 11/128.0, 12/128.0, },
{2/128.0, 3/128.0, 4/128.0, 8/128.0, 11/128.0, 13/128.0, },
{2/128.0, 2/128.0, 5/128.0, 5/128.0, 6/128.0, 11/128.0, },
{3/128.0, 4/128.0, 6/128.0, 7/128.0, 11/128.0, 14/128.0, },
{2/128.0, 3/128.0, 4/128.0, 5/128.0, 7/128.0, 7/128.0, },
{3/128.0, 10/128.0, 12/128.0, 12/128.0, 15/128.0, 17/128.0, },
{0/128.0, 1/128.0, 4/128.0, 7/128.0, 10/128.0, 11/128.0, },
{1/128.0, 1/128.0, 6/128.0, 13/128.0, 13/128.0, 13/128.0, },
{3/128.0, 5/128.0, 8/128.0, 10/128.0, 11/128.0, 11/128.0, },
{1/128.0, 2/128.0, 6/128.0, 9/128.0, 11/128.0, 13/128.0, },
{1/128.0, 2/128.0, 4/128.0, 5/128.0, 6/128.0, 10/128.0, },
{2/128.0, 3/128.0, 4/128.0, 6/128.0, 11/128.0, 15/128.0, },
{1/128.0, 0/128.0, 6/128.0, 7/128.0, 8/128.0, 12/128.0, },
{4/128.0, 5/128.0, 6/128.0, 10/128.0, 13/128.0, 13/128.0, },
{2/128.0, 2/128.0, 3/128.0, 4/128.0, 9/128.0, 15/128.0, },
{2/128.0, 2/128.0, 5/128.0, 9/128.0, 14/128.0, 16/128.0, },
{2/128.0, 3/128.0, 7/128.0, 8/128.0, 10/128.0, 15/128.0, },
{2/128.0, 3/128.0, 6/128.0, 7/128.0, 10/128.0, 13/128.0, },
{2/128.0, 3/128.0, 7/128.0, 7/128.0, 8/128.0, 14/128.0, },
{2/128.0, 2/128.0, 6/128.0, 8/128.0, 9/128.0, 18/128.0, },
{3/128.0, 4/128.0, 5/128.0, 8/128.0, 9/128.0, 10/128.0, },
{1/128.0, 1/128.0, 9/128.0, 12/128.0, 15/128.0, 20/128.0, },
{2/128.0, 2/128.0, 4/128.0, 7/128.0, 9/128.0, 10/128.0, },
{3/128.0, 5/128.0, 7/128.0, 12/128.0, 15/128.0, 13/128.0, },
{3/128.0, 4/128.0, 7/128.0, 8/128.0, 10/128.0, 14/128.0, },
{1/128.0, 2/128.0, 6/128.0, 9/128.0, 11/128.0, 14/128.0, },
{1/128.0, 2/128.0, 2/128.0, 3/128.0, 8/128.0, 10/128.0, },
{2/128.0, 3/128.0, 5/128.0, 7/128.0, 17/128.0, 22/128.0, },
{3/128.0, 5/128.0, 6/128.0, 7/128.0, 9/128.0, 10/128.0, },
{2/128.0, 3/128.0, 11/128.0, 13/128.0, 9/128.0, 12/128.0, },
{1/128.0, 1/128.0, 5/128.0, 9/128.0, 13/128.0, 13/128.0, },
{2/128.0, 3/128.0, 4/128.0, 9/128.0, 13/128.0, 14/128.0, },
{3/128.0, 6/128.0, 7/128.0, 8/128.0, 9/128.0, 10/128.0, },
{2/128.0, 2/128.0, 4/128.0, 10/128.0, 9/128.0, 10/128.0, },
{3/128.0, 4/128.0, 5/128.0, 6/128.0, 9/128.0, 15/128.0, },
{2/128.0, 4/128.0, 5/128.0, 6/128.0, 11/128.0, 12/128.0, },
{2/128.0, 4/128.0, 4/128.0, 6/128.0, 7/128.0, 8/128.0, },
{1/128.0, 2/128.0, 14/128.0, 12/128.0, 13/128.0, 16/128.0, },
{2/128.0, 2/128.0, 4/128.0, 8/128.0, 10/128.0, 10/128.0, },
{2/128.0, 2/128.0, 4/128.0, 10/128.0, 13/128.0, 14/128.0, },
{3/128.0, 4/128.0, 7/128.0, 8/128.0, 9/128.0, 14/128.0, },
{1/128.0, 2/128.0, 4/128.0, 11/128.0, 12/128.0, 13/128.0, },
{1/128.0, 2/128.0, 3/128.0, 5/128.0, 8/128.0, 12/128.0, },
{2/128.0, 3/128.0, 3/128.0, 5/128.0, 13/128.0, 16/128.0, },
{2/128.0, 3/128.0, 7/128.0, 9/128.0, 8/128.0, 12/128.0, },
{3/128.0, 4/128.0, 7/128.0, 11/128.0, 11/128.0, 13/128.0, },
{1/128.0, 1/128.0, 2/128.0, -1/128.0, 9/128.0, 10/128.0, },
{1/128.0, 1/128.0, 8/128.0, 12/128.0, 16/128.0, 16/128.0, },
{3/128.0, 5/128.0, 6/128.0, 7/128.0, 9/128.0, 11/128.0, },
{2/128.0, 3/128.0, 4/128.0, 7/128.0, 10/128.0, 13/128.0, },
{1/128.0, 2/128.0, 4/128.0, 7/128.0, 8/128.0, 11/128.0, },
{1/128.0, 1/128.0, 6/128.0, 8/128.0, 12/128.0, 18/128.0, },
{3/128.0, 5/128.0, 7/128.0, 7/128.0, 8/128.0, 9/128.0, },
{2/128.0, 3/128.0, 13/128.0, 16/128.0, 18/128.0, 18/128.0, },
{1/128.0, 1/128.0, 3/128.0, 6/128.0, 11/128.0, 12/128.0, },
{2/128.0, 2/128.0, 4/128.0, 13/128.0, 14/128.0, 15/128.0, },
{4/128.0, 4/128.0, 5/128.0, 10/128.0, 11/128.0, 12/128.0, },
{2/128.0, 3/128.0, 6/128.0, 9/128.0, 11/128.0, 12/128.0, },
{1/128.0, 1/128.0, 3/128.0, 6/128.0, 3/128.0, 8/128.0, },
{2/128.0, 3/128.0, 4/128.0, 9/128.0, 13/128.0, 17/128.0, },
{3/128.0, 3/128.0, 4/128.0, 9/128.0, 9/128.0, 11/128.0, },
{2/128.0, 3/128.0, 7/128.0, 12/128.0, 13/128.0, 16/128.0, },
{1/128.0, 2/128.0, 3/128.0, 7/128.0, 11/128.0, 11/128.0, },
{2/128.0, 3/128.0, 7/128.0, 9/128.0, 14/128.0, 14/128.0, },
{3/128.0, 4/128.0, 6/128.0, 8/128.0, 10/128.0, 11/128.0, },
{2/128.0, 3/128.0, 5/128.0, 7/128.0, 12/128.0, 12/128.0, },
{3/128.0, 3/128.0, 5/128.0, 7/128.0, 8/128.0, 14/128.0, },
{2/128.0, 4/128.0, 4/128.0, 7/128.0, 11/128.0, 15/128.0, },
{2/128.0, 3/128.0, 5/128.0, 7/128.0, 8/128.0, 9/128.0, },
{2/128.0, 7/128.0, 10/128.0, 11/128.0, 13/128.0, 15/128.0, },
{1/128.0, 1/128.0, 3/128.0, 6/128.0, 10/128.0, 11/128.0, },
{3/128.0, 3/128.0, 5/128.0, 10/128.0, 13/128.0, 14/128.0, },
{3/128.0, 6/128.0, 8/128.0, 9/128.0, 11/128.0, 12/128.0, },
{2/128.0, 3/128.0, 5/128.0, 11/128.0, 13/128.0, 14/128.0, },
{2/128.0, 2/128.0, 4/128.0, 6/128.0, 5/128.0, 8/128.0, },
{2/128.0, 2/128.0, 4/128.0, 6/128.0, 13/128.0, 17/128.0, },
{2/128.0, 3/128.0, 6/128.0, 9/128.0, 10/128.0, 11/128.0, },
{3/128.0, 5/128.0, 6/128.0, 8/128.0, 12/128.0, 14/128.0, },
{2/128.0, 2/128.0, 3/128.0, 5/128.0, 10/128.0, 15/128.0, },
{2/128.0, 3/128.0, 3/128.0, 9/128.0, 15/128.0, 16/128.0, },
{3/128.0, 4/128.0, 6/128.0, 9/128.0, 10/128.0, 13/128.0, },
{3/128.0, 4/128.0, 6/128.0, 8/128.0, 9/128.0, 13/128.0, },
{2/128.0, 2/128.0, 6/128.0, 7/128.0, 8/128.0, 15/128.0, },
{3/128.0, 3/128.0, 6/128.0, 10/128.0, 10/128.0, 13/128.0, },
{2/128.0, 3/128.0, 7/128.0, 8/128.0, 9/128.0, 10/128.0, },
{1/128.0, 5/128.0, 14/128.0, 11/128.0, 15/128.0, 16/128.0, },
{1/128.0, 2/128.0, 4/128.0, 5/128.0, 8/128.0, 11/128.0, },
{1/128.0, 1/128.0, 6/128.0, 12/128.0, 14/128.0, 15/128.0, },
{3/128.0, 3/128.0, 6/128.0, 10/128.0, 11/128.0, 12/128.0, },
{1/128.0, 1/128.0, 5/128.0, 9/128.0, 10/128.0, 12/128.0, },
{0/128.0, 0/128.0, 3/128.0, 6/128.0, 8/128.0, 10/128.0, },
{2/128.0, 2/128.0, 3/128.0, 6/128.0, 16/128.0, 17/128.0, },
{3/128.0, 4/128.0, 6/128.0, 8/128.0, 9/128.0, 10/128.0, },
{2/128.0, 3/128.0, 8/128.0, 7/128.0, 11/128.0, 14/128.0, },
{2/128.0, 3/128.0, 3/128.0, 6/128.0, 11/128.0, 13/128.0, },
{2/128.0, 3/128.0, 3/128.0, 9/128.0, 14/128.0, 15/128.0, },
{3/128.0, 5/128.0, 6/128.0, 9/128.0, 9/128.0, 11/128.0, },
{2/128.0, 2/128.0, 4/128.0, 10/128.0, 11/128.0, 8/128.0, },
{3/128.0, 3/128.0, 5/128.0, 5/128.0, 7/128.0, 17/128.0, },
{3/128.0, 4/128.0, 6/128.0, 9/128.0, 12/128.0, 13/128.0, },
{3/128.0, 3/128.0, 4/128.0, 5/128.0, 5/128.0, 10/128.0, },
{1/128.0, 1/128.0, 12/128.0, 13/128.0, 14/128.0, 15/128.0, },
{2/128.0, 2/128.0, 3/128.0, 8/128.0, 8/128.0, 9/128.0, },
{2/128.0, 2/128.0, 4/128.0, 12/128.0, 14/128.0, 15/128.0, },
{2/128.0, 5/128.0, 9/128.0, 10/128.0, 12/128.0, 14/128.0, },
{2/128.0, 3/128.0, 5/128.0, 10/128.0, 12/128.0, 13/128.0, },
{2/128.0, 2/128.0, 3/128.0, 2/128.0, 4/128.0, 14/128.0, },
{2/128.0, 2/128.0, 4/128.0, 5/128.0, 13/128.0, 13/128.0, },
{2/128.0, 3/128.0, 5/128.0, 6/128.0, 9/128.0, 11/128.0, },
{4/128.0, 5/128.0, 5/128.0, 12/128.0, 12/128.0, 14/128.0, },
{0/128.0, 0/128.0, 2/128.0, 4/128.0, 11/128.0, 13/128.0, },
{2/128.0, 3/128.0, 6/128.0, 11/128.0, 12/128.0, 21/128.0, },
{3/128.0, 5/128.0, 6/128.0, 7/128.0, 8/128.0, 12/128.0, },
{1/128.0, 2/128.0, 5/128.0, 9/128.0, 10/128.0, 13/128.0, },
{3/128.0, 4/128.0, 5/128.0, 6/128.0, 8/128.0, 11/128.0, },
{2/128.0, 3/128.0, 6/128.0, 8/128.0, 13/128.0, 14/128.0, },
{2/128.0, 4/128.0, 6/128.0, 6/128.0, 8/128.0, 8/128.0, },
{2/128.0, 2/128.0, 13/128.0, 17/128.0, 13/128.0, 14/128.0, },
{1/128.0, 2/128.0, 3/128.0, 4/128.0, 10/128.0, 12/128.0, },
{1/128.0, 2/128.0, 8/128.0, 12/128.0, 18/128.0, 13/128.0, },
{3/128.0, 3/128.0, 5/128.0, 9/128.0, 10/128.0, 12/128.0, },
{2/128.0, 2/128.0, 5/128.0, 10/128.0, 11/128.0, 13/128.0, },
{1/128.0, 2/128.0, 3/128.0, 4/128.0, 7/128.0, 9/128.0, },
{2/128.0, 3/128.0, 5/128.0, 8/128.0, 13/128.0, 16/128.0, },
{3/128.0, 3/128.0, 5/128.0, 8/128.0, 11/128.0, 11/128.0, },
{2/128.0, 2/128.0, 7/128.0, 11/128.0, 11/128.0, 16/128.0, },
{2/128.0, 2/128.0, 3/128.0, 6/128.0, 12/128.0, 14/128.0, },
{2/128.0, 2/128.0, 5/128.0, 8/128.0, 10/128.0, 13/128.0, },
{2/128.0, 4/128.0, 6/128.0, 7/128.0, 10/128.0, 11/128.0, },
{1/128.0, 2/128.0, 4/128.0, 8/128.0, 12/128.0, 11/128.0, },
{2/128.0, 2/128.0, 5/128.0, 6/128.0, 7/128.0, 14/128.0, },
{3/128.0, 4/128.0, 5/128.0, 8/128.0, 13/128.0, 16/128.0, },
{2/128.0, 3/128.0, 5/128.0, 7/128.0, 5/128.0, 7/128.0, },
{3/128.0, 7/128.0, 13/128.0, 13/128.0, 14/128.0, 15/128.0, },
{2/128.0, 2/128.0, 5/128.0, 7/128.0, 8/128.0, 12/128.0, },
{1/128.0, 1/128.0, 5/128.0, 11/128.0, 12/128.0, 15/128.0, },
{4/128.0, 5/128.0, 6/128.0, 10/128.0, 11/128.0, 12/128.0, },
{3/128.0, 3/128.0, 5/128.0, 11/128.0, 12/128.0, 14/128.0, },
{2/128.0, 3/128.0, 4/128.0, 7/128.0, 7/128.0, 10/128.0, },
{2/128.0, 2/128.0, 4/128.0, 6/128.0, 13/128.0, 16/128.0, },
{1/128.0, 1/128.0, 6/128.0, 8/128.0, 9/128.0, 11/128.0, },
{3/128.0, 4/128.0, 6/128.0, 11/128.0, 14/128.0, 14/128.0, },
{1/128.0, 1/128.0, 2/128.0, 5/128.0, 8/128.0, 14/128.0, },
{2/128.0, 3/128.0, 5/128.0, 10/128.0, 14/128.0, 17/128.0, },
{3/128.0, 4/128.0, 6/128.0, 8/128.0, 9/128.0, 14/128.0, },
{1/128.0, 2/128.0, 7/128.0, 6/128.0, 10/128.0, 13/128.0, },
{4/128.0, 5/128.0, 6/128.0, 6/128.0, 8/128.0, 15/128.0, },
{2/128.0, 2/128.0, 5/128.0, 7/128.0, 10/128.0, 16/128.0, },
{2/128.0, 4/128.0, 5/128.0, 7/128.0, 9/128.0, 10/128.0, },
{1/128.0, 2/128.0, 11/128.0, 11/128.0, 13/128.0, 17/128.0, },
{2/128.0, 3/128.0, 5/128.0, 6/128.0, 7/128.0, 13/128.0, },
{2/128.0, 3/128.0, 7/128.0, 14/128.0, 11/128.0, 16/128.0, },
{3/128.0, 3/128.0, 7/128.0, 10/128.0, 10/128.0, 12/128.0, },
{2/128.0, 2/128.0, 5/128.0, 9/128.0, 11/128.0, 13/128.0, },
{2/128.0, 2/128.0, 2/128.0, 4/128.0, 9/128.0, 8/128.0, },
{1/128.0, 2/128.0, 7/128.0, 9/128.0, 17/128.0, 19/128.0, },
{2/128.0, 3/128.0, 7/128.0, 8/128.0, 10/128.0, 11/128.0, },
{2/128.0, 3/128.0, 8/128.0, 10/128.0, 11/128.0, 13/128.0, },
{1/128.0, 0/128.0, 3/128.0, 8/128.0, 12/128.0, 15/128.0, },
{2/128.0, 2/128.0, 4/128.0, 10/128.0, 14/128.0, 15/128.0, },
{3/128.0, 5/128.0, 7/128.0, 8/128.0, 9/128.0, 10/128.0, },
{2/128.0, 2/128.0, 4/128.0, 9/128.0, 10/128.0, 12/128.0, },
{2/128.0, 3/128.0, 4/128.0, 4/128.0, 9/128.0, 14/128.0, },
{3/128.0, 4/128.0, 5/128.0, 8/128.0, 10/128.0, 12/128.0, },
{3/128.0, 4/128.0, 5/128.0, 7/128.0, 7/128.0, 8/128.0, },
{3/128.0, 6/128.0, 12/128.0, 12/128.0, 12/128.0, 12/128.0, },
{2/128.0, 3/128.0, 4/128.0, 8/128.0, 10/128.0, 9/128.0, },
{1/128.0, 2/128.0, 4/128.0, 10/128.0, 14/128.0, 13/128.0, },
{4/128.0, 5/128.0, 7/128.0, 10/128.0, 10/128.0, 13/128.0, },
{2/128.0, 3/128.0, 4/128.0, 8/128.0, 12/128.0, 13/128.0, },
{1/128.0, 1/128.0, 3/128.0, 2/128.0, 6/128.0, 13/128.0, },
{1/128.0, 1/128.0, 1/128.0, 5/128.0, 14/128.0, 14/128.0, },
{3/128.0, 3/128.0, 5/128.0, 8/128.0, 9/128.0, 11/128.0, },
{3/128.0, 4/128.0, 6/128.0, 10/128.0, 11/128.0, 13/128.0, },
{1/128.0, 1/128.0, 1/128.0, 0/128.0, 10/128.0, 12/128.0, },
{1/128.0, 2/128.0, 8/128.0, 8/128.0, 14/128.0, 16/128.0, },
{3/128.0, 3/128.0, 6/128.0, 6/128.0, 7/128.0, 12/128.0, },
{1/128.0, 2/128.0, 4/128.0, 9/128.0, 9/128.0, 13/128.0, },
{2/128.0, 3/128.0, 6/128.0, 7/128.0, 8/128.0, 11/128.0, },
{0/128.0, 1/128.0, 6/128.0, 8/128.0, 13/128.0, 15/128.0, },
{3/128.0, 5/128.0, 6/128.0, 7/128.0, 9/128.0, 10/128.0, },
{1/128.0, 2/128.0, 11/128.0, 15/128.0, 15/128.0, 19/128.0, },
{1/128.0, 2/128.0, 3/128.0, 5/128.0, 10/128.0, 12/128.0, },
{2/128.0, 2/128.0, 4/128.0, 12/128.0, 16/128.0, 16/128.0, },
{3/128.0, 4/128.0, 6/128.0, 10/128.0, 11/128.0, 10/128.0, },
{1/128.0, 2/128.0, 4/128.0, 11/128.0, 10/128.0, 10/128.0, },
{2/128.0, 2/128.0, 3/128.0, 3/128.0, 5/128.0, 10/128.0, },
{2/128.0, 2/128.0, 3/128.0, 8/128.0, 15/128.0, 16/128.0, },
{2/128.0, 3/128.0, 5/128.0, 8/128.0, 10/128.0, 10/128.0, },
{3/128.0, 3/128.0, 9/128.0, 11/128.0, 12/128.0, 14/128.0, },
{2/128.0, 2/128.0, 2/128.0, 8/128.0, 13/128.0, 14/128.0, },
{3/128.0, 3/128.0, 5/128.0, 9/128.0, 13/128.0, 15/128.0, },
{3/128.0, 5/128.0, 7/128.0, 9/128.0, 10/128.0, 11/128.0, },
{3/128.0, 4/128.0, 5/128.0, 7/128.0, 10/128.0, 11/128.0, },
{2/128.0, 2/128.0, 6/128.0, 7/128.0, 9/128.0, 14/128.0, },
{2/128.0, 4/128.0, 5/128.0, 6/128.0, 13/128.0, 17/128.0, },
{2/128.0, 2/128.0, 4/128.0, 8/128.0, 9/128.0, 8/128.0, },
{2/128.0, 7/128.0, 10/128.0, 12/128.0, 16/128.0, 16/128.0, },
{1/128.0, 1/128.0, 2/128.0, 9/128.0, 9/128.0, 10/128.0, },
{2/128.0, 2/128.0, 4/128.0, 12/128.0, 13/128.0, 15/128.0, },
{3/128.0, 6/128.0, 7/128.0, 8/128.0, 11/128.0, 11/128.0, },
{3/128.0, 3/128.0, 6/128.0, 11/128.0, 12/128.0, 14/128.0, },
{2/128.0, 3/128.0, 4/128.0, 5/128.0, 7/128.0, 10/128.0, },
{2/128.0, 3/128.0, 3/128.0, 6/128.0, 13/128.0, 17/128.0, },
{2/128.0, 3/128.0, 7/128.0, 9/128.0, 11/128.0, 8/128.0, },
{2/128.0, 4/128.0, 6/128.0, 10/128.0, 13/128.0, 14/128.0, },
{1/128.0, 1/128.0, 3/128.0, 3/128.0, 11/128.0, 14/128.0, },
{3/128.0, 4/128.0, 5/128.0, 9/128.0, 15/128.0, 16/128.0, },
{4/128.0, 5/128.0, 7/128.0, 9/128.0, 9/128.0, 13/128.0, },
{2/128.0, 3/128.0, 5/128.0, 8/128.0, 10/128.0, 13/128.0, },
{3/128.0, 3/128.0, 5/128.0, 5/128.0, 7/128.0, 15/128.0, },
{2/128.0, 2/128.0, 3/128.0, 9/128.0, 11/128.0, 14/128.0, },
{3/128.0, 4/128.0, 6/128.0, 8/128.0, 9/128.0, 8/128.0, },
{2/128.0, 5/128.0, 11/128.0, 13/128.0, 15/128.0, 17/128.0, },
{2/128.0, 3/128.0, 3/128.0, 7/128.0, 9/128.0, 10/128.0, },
{2/128.0, 2/128.0, 7/128.0, 13/128.0, 14/128.0, 16/128.0, },
{3/128.0, 3/128.0, 7/128.0, 9/128.0, 9/128.0, 11/128.0, },
{1/128.0, 1/128.0, 5/128.0, 10/128.0, 11/128.0, 12/128.0, },
{1/128.0, 2/128.0, 3/128.0, 7/128.0, 9/128.0, 9/128.0, },
{2/128.0, 2/128.0, 4/128.0, 9/128.0, 15/128.0, 18/128.0, },
{3/128.0, 4/128.0, 6/128.0, 9/128.0, 9/128.0, 10/128.0, },
{2/128.0, 2/128.0, 10/128.0, 10/128.0, 12/128.0, 13/128.0, },
{1/128.0, 2/128.0, 3/128.0, 5/128.0, 9/128.0, 13/128.0, },
{2/128.0, 3/128.0, 3/128.0, 7/128.0, 13/128.0, 14/128.0, },
{4/128.0, 5/128.0, 7/128.0, 9/128.0, 9/128.0, 11/128.0, },
{2/128.0, 2/128.0, 4/128.0, 9/128.0, 10/128.0, 11/128.0, },
{2/128.0, 2/128.0, 3/128.0, 3/128.0, 8/128.0, 17/128.0, },
{2/128.0, 3/128.0, 6/128.0, 8/128.0, 11/128.0, 12/128.0, },
{3/128.0, 4/128.0, 5/128.0, 7/128.0, 7/128.0, 10/128.0, },
{2/128.0, 3/128.0, 11/128.0, 12/128.0, 15/128.0, 12/128.0, },
{2/128.0, 2/128.0, 3/128.0, 6/128.0, 8/128.0, 9/128.0, },
{2/128.0, 3/128.0, 5/128.0, 12/128.0, 13/128.0, 15/128.0, },
{3/128.0, 4/128.0, 8/128.0, 8/128.0, 10/128.0, 17/128.0, },
{3/128.0, 3/128.0, 4/128.0, 9/128.0, 13/128.0, 14/128.0, },
{2/128.0, 3/128.0, 4/128.0, 5/128.0, 6/128.0, 14/128.0, },
{1/128.0, 2/128.0, 4/128.0, 7/128.0, 15/128.0, 15/128.0, },
{2/128.0, 3/128.0, 4/128.0, 8/128.0, 8/128.0, 10/128.0, },
{4/128.0, 6/128.0, 7/128.0, 10/128.0, 12/128.0, 13/128.0, },
{1/128.0, 2/128.0, 3/128.0, 2/128.0, 10/128.0, 12/128.0, },
{2/128.0, 2/128.0, 4/128.0, 9/128.0, 13/128.0, 18/128.0, },
{3/128.0, 4/128.0, 6/128.0, 8/128.0, 8/128.0, 11/128.0, },
{2/128.0, 3/128.0, 5/128.0, 8/128.0, 7/128.0, 13/128.0, },
{3/128.0, 4/128.0, 5/128.0, 6/128.0, 7/128.0, 12/128.0, },
{1/128.0, 1/128.0, 5/128.0, 6/128.0, 10/128.0, 16/128.0, },
{3/128.0, 4/128.0, 6/128.0, 7/128.0, 7/128.0, 10/128.0, },
{6/128.0, 10/128.0, 16/128.0, 18/128.0, 18/128.0, 19/128.0, },
{1/128.0, 1/128.0, 3/128.0, 4/128.0, 10/128.0, 11/128.0, },
{3/128.0, 3/128.0, 5/128.0, 14/128.0, 16/128.0, 16/128.0, },
{4/128.0, 5/128.0, 6/128.0, 9/128.0, 10/128.0, 11/128.0, },
{3/128.0, 4/128.0, 5/128.0, 10/128.0, 12/128.0, 12/128.0, },
{1/128.0, 0/128.0, 4/128.0, 1/128.0, 4/128.0, 10/128.0, },
{2/128.0, 3/128.0, 5/128.0, 6/128.0, 12/128.0, 18/128.0, },
{2/128.0, 3/128.0, 5/128.0, 8/128.0, 10/128.0, 11/128.0, },
{3/128.0, 3/128.0, 6/128.0, 10/128.0, 10/128.0, 16/128.0, },
{2/128.0, 2/128.0, 3/128.0, 5/128.0, 12/128.0, 12/128.0, },
{2/128.0, 2/128.0, 5/128.0, 7/128.0, 13/128.0, 14/128.0, },
{4/128.0, 5/128.0, 7/128.0, 8/128.0, 10/128.0, 11/128.0, },
{2/128.0, 3/128.0, 4/128.0, 7/128.0, 10/128.0, 13/128.0, },
{3/128.0, 3/128.0, 5/128.0, 6/128.0, 7/128.0, 14/128.0, },
{2/128.0, 4/128.0, 7/128.0, 8/128.0, 12/128.0, 13/128.0, },
{2/128.0, 3/128.0, 4/128.0, 7/128.0, 7/128.0, 8/128.0, },
{3/128.0, 14/128.0, 16/128.0, 9/128.0, 9/128.0, 13/128.0, },
{1/128.0, 1/128.0, 5/128.0, 7/128.0, 10/128.0, 11/128.0, },
{2/128.0, 2/128.0, 8/128.0, 16/128.0, 10/128.0, 11/128.0, },
{3/128.0, 5/128.0, 6/128.0, 10/128.0, 12/128.0, 12/128.0, },
{2/128.0, 3/128.0, 6/128.0, 10/128.0, 10/128.0, 14/128.0, },
{2/128.0, 3/128.0, 4/128.0, 4/128.0, 6/128.0, 11/128.0, },
{2/128.0, 3/128.0, 3/128.0, 5/128.0, 12/128.0, 16/128.0, },
{1/128.0, 3/128.0, 10/128.0, 7/128.0, 8/128.0, 10/128.0, },
{3/128.0, 5/128.0, 5/128.0, 9/128.0, 12/128.0, 13/128.0, },
{1/128.0, 2/128.0, 2/128.0, 3/128.0, 8/128.0, 13/128.0, },
{2/128.0, 3/128.0, 4/128.0, 9/128.0, 13/128.0, 15/128.0, },
{4/128.0, 5/128.0, 7/128.0, 8/128.0, 9/128.0, 15/128.0, },
{2/128.0, 2/128.0, 4/128.0, 6/128.0, 11/128.0, 13/128.0, },
{3/128.0, 4/128.0, 5/128.0, 6/128.0, 8/128.0, 13/128.0, },
{2/128.0, 3/128.0, 6/128.0, 7/128.0, 10/128.0, 16/128.0, },
{2/128.0, 4/128.0, 5/128.0, 7/128.0, 8/128.0, 10/128.0, },
{2/128.0, 3/128.0, 10/128.0, 12/128.0, 14/128.0, 19/128.0, },
{2/128.0, 2/128.0, 3/128.0, 8/128.0, 8/128.0, 12/128.0, },
{2/128.0, 3/128.0, 7/128.0, 12/128.0, 13/128.0, 13/128.0, },
{3/128.0, 3/128.0, 8/128.0, 9/128.0, 10/128.0, 12/128.0, },
{2/128.0, 2/128.0, 7/128.0, 8/128.0, 10/128.0, 12/128.0, },
{1/128.0, 2/128.0, 0/128.0, 2/128.0, 10/128.0, 10/128.0, },
{2/128.0, 2/128.0, 4/128.0, 11/128.0, 19/128.0, 21/128.0, },
{3/128.0, 4/128.0, 6/128.0, 9/128.0, 9/128.0, 11/128.0, },
{3/128.0, 4/128.0, 9/128.0, 11/128.0, 9/128.0, 12/128.0, },
{1/128.0, 2/128.0, 3/128.0, 8/128.0, 12/128.0, 13/128.0, },
{2/128.0, 3/128.0, 5/128.0, 10/128.0, 14/128.0, 15/128.0, },
{3/128.0, 6/128.0, 7/128.0, 9/128.0, 10/128.0, 11/128.0, },
{2/128.0, 2/128.0, 6/128.0, 9/128.0, 10/128.0, 10/128.0, },
{3/128.0, 3/128.0, 5/128.0, 5/128.0, 10/128.0, 14/128.0, },
{2/128.0, 4/128.0, 5/128.0, 7/128.0, 12/128.0, 13/128.0, },
{2/128.0, 3/128.0, 4/128.0, 6/128.0, 7/128.0, 8/128.0, },
{2/128.0, 6/128.0, 12/128.0, 10/128.0, 12/128.0, 15/128.0, },
{2/128.0, 3/128.0, 5/128.0, 7/128.0, 9/128.0, 10/128.0, },
{2/128.0, 2/128.0, 4/128.0, 11/128.0, 14/128.0, 14/128.0, },
{3/128.0, 4/128.0, 7/128.0, 9/128.0, 10/128.0, 15/128.0, },
{2/128.0, 3/128.0, 4/128.0, 9/128.0, 12/128.0, 13/128.0, },
{2/128.0, 2/128.0, 4/128.0, 6/128.0, 7/128.0, 11/128.0, },
{2/128.0, 2/128.0, 3/128.0, 4/128.0, 15/128.0, 16/128.0, },
{2/128.0, 2/128.0, 6/128.0, 7/128.0, 6/128.0, 10/128.0, },
{3/128.0, 5/128.0, 7/128.0, 10/128.0, 12/128.0, 13/128.0, },
{1/128.0, 0/128.0, 2/128.0, 2/128.0, 7/128.0, 11/128.0, },
{1/128.0, 1/128.0, 7/128.0, 10/128.0, 14/128.0, 15/128.0, },
{3/128.0, 5/128.0, 7/128.0, 7/128.0, 8/128.0, 11/128.0, },
{2/128.0, 2/128.0, 4/128.0, 7/128.0, 10/128.0, 11/128.0, },
{2/128.0, 3/128.0, 5/128.0, 7/128.0, 8/128.0, 11/128.0, },
{2/128.0, 2/128.0, 7/128.0, 8/128.0, 12/128.0, 16/128.0, },
{3/128.0, 4/128.0, 6/128.0, 7/128.0, 8/128.0, 9/128.0, },
{1/128.0, 4/128.0, 17/128.0, 17/128.0, 18/128.0, 20/128.0, },
{2/128.0, 2/128.0, 4/128.0, 6/128.0, 11/128.0, 12/128.0, },
{2/128.0, 2/128.0, 4/128.0, 13/128.0, 15/128.0, 14/128.0, },
{3/128.0, 3/128.0, 7/128.0, 12/128.0, 12/128.0, 10/128.0, },
{2/128.0, 4/128.0, 7/128.0, 9/128.0, 11/128.0, 11/128.0, },
{2/128.0, 2/128.0, 4/128.0, 6/128.0, 0/128.0, 11/128.0, },
{2/128.0, 2/128.0, 3/128.0, 8/128.0, 13/128.0, 16/128.0, },
{2/128.0, 3/128.0, 6/128.0, 9/128.0, 10/128.0, 11/128.0, },
{2/128.0, 3/128.0, 9/128.0, 11/128.0, 13/128.0, 16/128.0, },
{1/128.0, 1/128.0, 1/128.0, 8/128.0, 11/128.0, 12/128.0, },
{2/128.0, 3/128.0, 5/128.0, 9/128.0, 13/128.0, 14/128.0, },
{3/128.0, 5/128.0, 6/128.0, 8/128.0, 11/128.0, 12/128.0, },
{1/128.0, 2/128.0, 5/128.0, 7/128.0, 10/128.0, 10/128.0, },
{2/128.0, 2/128.0, 5/128.0, 7/128.0, 9/128.0, 13/128.0, },
{2/128.0, 3/128.0, 6/128.0, 8/128.0, 11/128.0, 15/128.0, },
{2/128.0, 3/128.0, 6/128.0, 7/128.0, 7/128.0, 9/128.0, },
{5/128.0, 7/128.0, 8/128.0, 10/128.0, 12/128.0, 14/128.0, },
{0/128.0, 0/128.0, 2/128.0, 7/128.0, 9/128.0, 11/128.0, },
{2/128.0, 2/128.0, 5/128.0, 11/128.0, 12/128.0, 13/128.0, },
{3/128.0, 5/128.0, 6/128.0, 8/128.0, 11/128.0, 12/128.0, },
{3/128.0, 4/128.0, 6/128.0, 11/128.0, 12/128.0, 15/128.0, },
{2/128.0, 3/128.0, 3/128.0, 5/128.0, 6/128.0, 10/128.0, },
{2/128.0, 3/128.0, 4/128.0, 6/128.0, 12/128.0, 17/128.0, },
{2/128.0, 3/128.0, 6/128.0, 9/128.0, 9/128.0, 10/128.0, },
{3/128.0, 4/128.0, 6/128.0, 9/128.0, 13/128.0, 13/128.0, },
{1/128.0, 2/128.0, 3/128.0, 3/128.0, 11/128.0, 14/128.0, },
{2/128.0, 3/128.0, 4/128.0, 9/128.0, 17/128.0, 15/128.0, },
{3/128.0, 4/128.0, 6/128.0, 8/128.0, 9/128.0, 12/128.0, },
{2/128.0, 2/128.0, 5/128.0, 8/128.0, 9/128.0, 13/128.0, },
{3/128.0, 4/128.0, 7/128.0, 7/128.0, 9/128.0, 16/128.0, },
{2/128.0, 3/128.0, 5/128.0, 9/128.0, 10/128.0, 15/128.0, },
{2/128.0, 3/128.0, 7/128.0, 8/128.0, 8/128.0, 9/128.0, },
{2/128.0, 3/128.0, 11/128.0, 12/128.0, 14/128.0, 16/128.0, },
{2/128.0, 2/128.0, 3/128.0, 5/128.0, 9/128.0, 11/128.0, },
{2/128.0, 2/128.0, 6/128.0, 13/128.0, 13/128.0, 15/128.0, },
{2/128.0, 3/128.0, 5/128.0, 9/128.0, 10/128.0, 12/128.0, },
{1/128.0, 1/128.0, 3/128.0, 9/128.0, 10/128.0, 13/128.0, },
{0/128.0, -1/128.0, 3/128.0, 5/128.0, 9/128.0, 10/128.0, },
{2/128.0, 2/128.0, 3/128.0, 5/128.0, 15/128.0, 19/128.0, },
{2/128.0, 4/128.0, 6/128.0, 7/128.0, 8/128.0, 10/128.0, },
{1/128.0, 2/128.0, 7/128.0, 9/128.0, 13/128.0, 14/128.0, },
{2/128.0, 2/128.0, 4/128.0, 6/128.0, 11/128.0, 14/128.0, },
{1/128.0, 2/128.0, 2/128.0, 9/128.0, 12/128.0, 16/128.0, },
{4/128.0, 4/128.0, 7/128.0, 8/128.0, 8/128.0, 10/128.0, },
{2/128.0, 3/128.0, 4/128.0, 9/128.0, 11/128.0, 11/128.0, },
{3/128.0, 3/128.0, 6/128.0, 6/128.0, 9/128.0, 18/128.0, },
{3/128.0, 5/128.0, 6/128.0, 9/128.0, 12/128.0, 12/128.0, },
{3/128.0, 3/128.0, 5/128.0, 6/128.0, 7/128.0, 11/128.0, },
{1/128.0, 1/128.0, 10/128.0, 13/128.0, 12/128.0, 15/128.0, },
{1/128.0, 2/128.0, 3/128.0, 6/128.0, 8/128.0, 10/128.0, },
{2/128.0, 2/128.0, 4/128.0, 11/128.0, 15/128.0, 15/128.0, },
{3/128.0, 4/128.0, 8/128.0, 10/128.0, 11/128.0, 14/128.0, },
{2/128.0, 2/128.0, 6/128.0, 9/128.0, 12/128.0, 12/128.0, },
{2/128.0, 3/128.0, 4/128.0, 5/128.0, 5/128.0, 13/128.0, },
{2/128.0, 2/128.0, 3/128.0, 6/128.0, 13/128.0, 14/128.0, },
{2/128.0, 3/128.0, 5/128.0, 7/128.0, 10/128.0, 10/128.0, },
{3/128.0, 4/128.0, 5/128.0, 10/128.0, 11/128.0, 14/128.0, },
{1/128.0, 2/128.0, 0/128.0, 4/128.0, 12/128.0, 13/128.0, },
{1/128.0, 2/128.0, 8/128.0, 10/128.0, 12/128.0, 18/128.0, },
};

static float cbb_new[VECSIZEb_NEW][VECDIMb_NEW] = {
{13/128.0, 18/128.0, 22/128.0, 22/128.0, },
{15/128.0, 17/128.0, 23/128.0, 23/128.0, },
{13/128.0, 16/128.0, 19/128.0, 20/128.0, },
{16/128.0, 19/128.0, 20/128.0, 21/128.0, },
{10/128.0, 11/128.0, 18/128.0, 21/128.0, },
{17/128.0, 19/128.0, 19/128.0, 20/128.0, },
{15/128.0, 16/128.0, 17/128.0, 19/128.0, },
{16/128.0, 17/128.0, 20/128.0, 21/128.0, },
{13/128.0, 15/128.0, 20/128.0, 21/128.0, },
{22/128.0, 22/128.0, 22/128.0, 23/128.0, },
{14/128.0, 17/128.0, 17/128.0, 21/128.0, },
{15/128.0, 18/128.0, 19/128.0, 20/128.0, },
{12/128.0, 14/128.0, 18/128.0, 20/128.0, },
{18/128.0, 20/128.0, 22/128.0, 22/128.0, },
{16/128.0, 16/128.0, 17/128.0, 18/128.0, },
{14/128.0, 15/128.0, 22/128.0, 23/128.0, },
{12/128.0, 18/128.0, 20/128.0, 21/128.0, },
{17/128.0, 18/128.0, 21/128.0, 22/128.0, },
{14/128.0, 17/128.0, 19/128.0, 21/128.0, },
{16/128.0, 18/128.0, 19/128.0, 20/128.0, },
{11/128.0, 14/128.0, 20/128.0, 21/128.0, },
{18/128.0, 19/128.0, 21/128.0, 22/128.0, },
{12/128.0, 16/128.0, 17/128.0, 19/128.0, },
{16/128.0, 17/128.0, 21/128.0, 22/128.0, },
{13/128.0, 15/128.0, 21/128.0, 22/128.0, },
{18/128.0, 18/128.0, 24/128.0, 24/128.0, },
{14/128.0, 15/128.0, 19/128.0, 20/128.0, },
{17/128.0, 17/128.0, 19/128.0, 21/128.0, },
{14/128.0, 15/128.0, 17/128.0, 20/128.0, },
{20/128.0, 20/128.0, 20/128.0, 21/128.0, },
{14/128.0, 15/128.0, 15/128.0, 20/128.0, },
{15/128.0, 16/128.0, 20/128.0, 22/128.0, },
{11/128.0, 17/128.0, 21/128.0, 22/128.0, },
{15/128.0, 19/128.0, 21/128.0, 22/128.0, },
{12/128.0, 16/128.0, 19/128.0, 20/128.0, },
{14/128.0, 19/128.0, 20/128.0, 21/128.0, },
{12/128.0, 12/128.0, 19/128.0, 21/128.0, },
{18/128.0, 18/128.0, 19/128.0, 21/128.0, },
{15/128.0, 17/128.0, 18/128.0, 20/128.0, },
{16/128.0, 17/128.0, 20/128.0, 22/128.0, },
{13/128.0, 14/128.0, 20/128.0, 22/128.0, },
{19/128.0, 21/128.0, 23/128.0, 23/128.0, },
{15/128.0, 16/128.0, 18/128.0, 21/128.0, },
{16/128.0, 17/128.0, 18/128.0, 19/128.0, },
{12/128.0, 13/128.0, 16/128.0, 20/128.0, },
{19/128.0, 20/128.0, 21/128.0, 22/128.0, },
{16/128.0, 17/128.0, 16/128.0, 19/128.0, },
{15/128.0, 16/128.0, 21/128.0, 22/128.0, },
{13/128.0, 17/128.0, 20/128.0, 22/128.0, },
{18/128.0, 18/128.0, 22/128.0, 22/128.0, },
{15/128.0, 17/128.0, 20/128.0, 20/128.0, },
{16/128.0, 18/128.0, 20/128.0, 21/128.0, },
{9/128.0, 16/128.0, 18/128.0, 20/128.0, },
{17/128.0, 18/128.0, 20/128.0, 21/128.0, },
{13/128.0, 17/128.0, 18/128.0, 19/128.0, },
{15/128.0, 18/128.0, 21/128.0, 22/128.0, },
{12/128.0, 13/128.0, 22/128.0, 23/128.0, },
{17/128.0, 19/128.0, 23/128.0, 23/128.0, },
{15/128.0, 16/128.0, 20/128.0, 21/128.0, },
{16/128.0, 17/128.0, 18/128.0, 21/128.0, },
{13/128.0, 14/128.0, 17/128.0, 21/128.0, },
{18/128.0, 19/128.0, 20/128.0, 21/128.0, },
{14/128.0, 15/128.0, 15/128.0, 17/128.0, },
{14/128.0, 17/128.0, 21/128.0, 21/128.0, },
};


# endif

#else //NEWMALSPVQ
#ifdef NEWMALSPVQ3
static float cba_new3[VECSIZEa_NEW][VECDIMa_NEW] = {
{  2.017699E-02,   3.247875E-02,   4.613430E-02,   5.239014E-02,   7.242569E-02,   9.421491E-02, },
{  4.548437E-03,   1.724272E-03,   4.839789E-02,   6.292462E-02,   7.571768E-02,   1.161559E-01, },
{  1.740299E-02,   2.289238E-02,   3.237878E-02,   4.165741E-02,   7.215573E-02,   9.967381E-02, },
{  1.533808E-02,   2.142540E-02,   4.660997E-02,   4.956320E-02,   9.173052E-02,   1.068373E-01, },
{  2.146210E-02,   2.746753E-02,   5.162166E-02,   5.366941E-02,   6.249662E-02,   8.102281E-02, },
{  1.634639E-02,   2.895356E-02,   9.543332E-02,   1.219438E-01,   1.065826E-01,   1.258989E-01, },
{  1.149055E-02,   1.522904E-02,   2.766180E-02,   3.833728E-02,   8.188299E-02,   1.023095E-01, },
{  1.306690E-02,   1.606736E-02,   5.527560E-02,   1.285115E-01,   1.480855E-01,   1.401152E-01, },
{  2.120657E-02,   2.776543E-02,   4.036344E-02,   6.744962E-02,   8.976594E-02,   9.731838E-02, },
{  2.227647E-02,   2.696392E-02,   3.284142E-02,   7.666880E-02,   8.736313E-02,   9.393009E-02, },
{  1.358891E-02,   1.878651E-02,   2.240999E-02,   3.085952E-02,   4.505269E-02,   6.048514E-02, },
{  1.486667E-02,   2.046185E-02,   4.520315E-02,   5.957670E-02,   1.174389E-01,   1.257631E-01, },
{  1.775144E-02,   2.739472E-02,   4.021676E-02,   5.706950E-02,   8.357243E-02,   8.767028E-02, },
{  1.595547E-02,   1.918809E-02,   4.151045E-02,   8.231509E-02,   8.914400E-02,   1.094128E-01, },
{  1.391870E-02,   1.891461E-02,   3.171433E-02,   5.708908E-02,   9.923576E-02,   9.834048E-02, },
{  1.380581E-02,   1.788116E-02,   3.764854E-02,   5.819270E-02,   8.771821E-02,   1.120415E-01, },
{  2.071893E-02,   3.376758E-02,   4.419503E-02,   5.920142E-02,   7.299111E-02,   8.718168E-02, },
{  1.138947E-02,   1.568082E-02,   3.435001E-02,   5.773872E-02,   8.576915E-02,   9.381439E-02, },
{  1.196059E-02,   1.468103E-02,   2.389708E-02,   5.194908E-02,   6.015165E-02,   1.014177E-01, },
{  1.767093E-02,   3.065930E-02,   4.454877E-02,   6.073852E-02,   1.015451E-01,   1.114008E-01, },
{  1.792927E-02,   2.302773E-02,   2.968053E-02,   4.096594E-02,   4.404763E-02,   5.590930E-02, },
{  3.133547E-02,   7.715580E-02,   7.941303E-02,   9.057902E-02,   1.035149E-01,   1.166027E-01, },
{  1.217546E-02,   1.591787E-02,   3.300876E-02,   6.063904E-02,   6.950519E-02,   8.989113E-02, },
{  9.277439E-03,   1.132545E-02,   4.488470E-02,   8.262527E-02,   8.880470E-02,   1.120468E-01, },
{  2.329855E-02,   3.335763E-02,   4.833462E-02,   7.712966E-02,   8.419348E-02,   9.368254E-02, },
{  2.091246E-02,   2.653604E-02,   4.855137E-02,   8.149972E-02,   8.682100E-02,   1.096638E-01, },
{  1.617141E-02,   2.199936E-02,   2.786511E-02,   3.775961E-02,   6.014976E-02,   8.230177E-02, },
{  1.884726E-02,   2.418347E-02,   3.185740E-02,   6.142039E-02,   9.066546E-02,   1.179641E-01, },
{  1.521085E-02,   1.980447E-02,   4.799168E-02,   6.466720E-02,   7.895684E-02,   8.400878E-02, },
{  1.898662E-02,   3.284197E-02,   5.357287E-02,   7.583489E-02,   1.052570E-01,   1.162408E-01, },
{  9.112629E-03,   1.094493E-02,   2.908796E-02,   2.788889E-02,   6.503532E-02,   1.039870E-01, },
{  2.222694E-02,   2.627151E-02,   4.074047E-02,   7.401063E-02,   1.075486E-01,   1.226059E-01, },
{  3.042186E-02,   3.842936E-02,   5.362064E-02,   7.037108E-02,   7.476793E-02,   1.086751E-01, },
{  1.310502E-02,   1.641117E-02,   5.518719E-02,   5.931174E-02,   7.549062E-02,   1.046553E-01, },
{  2.421688E-02,   3.041859E-02,   4.209798E-02,   5.266572E-02,   6.174548E-02,   1.123060E-01, },
{  1.420606E-02,   1.750896E-02,   3.323680E-02,   5.320513E-02,   7.042648E-02,   1.281398E-01, },
{  2.033797E-02,   2.711490E-02,   4.454248E-02,   4.726487E-02,   6.442315E-02,   8.635864E-02, },
{  3.264339E-03,   6.712838E-03,   7.145266E-02,   8.241447E-02,   9.940168E-02,   1.188957E-01, },
{  1.073976E-02,   1.336512E-02,   1.757157E-02,   4.533423E-02,   6.558635E-02,   8.927178E-02, },
{  1.428653E-02,   1.747249E-02,   6.660896E-02,   1.054070E-01,   1.084305E-01,   1.128192E-01, },
{  1.625926E-02,   1.983034E-02,   5.760950E-02,   7.613715E-02,   8.014674E-02,   1.012986E-01, },
{  1.260386E-02,   1.561636E-02,   4.468972E-02,   8.269521E-02,   9.377667E-02,   1.014348E-01, },
{  1.582259E-02,   2.018862E-02,   1.884460E-02,   2.786521E-02,   6.142968E-02,   7.754399E-02, },
{  1.586725E-02,   2.363601E-02,   3.679852E-02,   7.304742E-02,   1.462226E-01,   1.341549E-01, },
{  2.053700E-02,   2.626847E-02,   4.906115E-02,   6.162774E-02,   6.944220E-02,   8.387575E-02, },
{  1.474496E-02,   2.307407E-02,   6.551777E-02,   7.780196E-02,   9.276142E-02,   9.249960E-02, },
{  9.930763E-03,   9.994547E-03,   2.895742E-02,   5.499814E-02,   9.063033E-02,   1.112834E-01, },
{  2.114108E-02,   2.676094E-02,   4.045252E-02,   8.038043E-02,   1.262487E-01,   1.305108E-01, },
{  2.299144E-02,   4.269292E-02,   6.330181E-02,   6.349155E-02,   7.365540E-02,   9.094412E-02, },
{  1.723518E-02,   2.066397E-02,   3.815584E-02,   7.597569E-02,   8.406764E-02,   9.474467E-02, },
{  1.897005E-02,   2.229227E-02,   3.259903E-02,   4.041292E-02,   4.933997E-02,   1.202367E-01, },
{  2.106088E-02,   3.816491E-02,   4.803337E-02,   5.799232E-02,   8.430802E-02,   8.949979E-02, },
{  1.913087E-02,   2.833543E-02,   3.423150E-02,   5.658871E-02,   6.262927E-02,   6.615196E-02, },
{  1.340069E-02,   5.638127E-02,   1.314150E-01,   1.101840E-01,   8.850108E-02,   1.059199E-01, },
{  1.940067E-02,   2.462596E-02,   3.023805E-02,   6.228973E-02,   6.438488E-02,   7.952422E-02, },
{  1.395237E-02,   1.691991E-02,   1.858416E-02,   8.220373E-02,   1.068730E-01,   1.060895E-01, },
{  2.483113E-02,   3.281337E-02,   4.519390E-02,   7.327629E-02,   7.967140E-02,   1.015656E-01, },
{  1.112950E-02,   1.678479E-02,   1.892029E-02,   7.461304E-02,   9.084870E-02,   9.716331E-02, },
{  1.155870E-02,   1.608523E-02,   1.618202E-02,   4.132788E-02,   4.974555E-02,   9.018013E-02, },
{  4.913697E-03,   9.599810E-03,   1.431667E-02,   4.365523E-02,   1.104780E-01,   1.272584E-01, },
{  1.226020E-02,   1.581880E-02,   4.392374E-02,   5.746729E-02,   6.639231E-02,   8.955053E-02, },
{  2.331304E-02,   2.959305E-02,   4.381082E-02,   8.367359E-02,   8.856211E-02,   9.218106E-02, },
{  1.092625E-02,   1.516155E-02,   1.355779E-02,  -1.840691E-02,   5.505983E-02,   8.693460E-02, },
{  8.374553E-03,   1.478288E-02,   6.728583E-02,   6.824677E-02,   1.198102E-01,   1.127241E-01, },
{  2.157059E-02,   2.902514E-02,   4.136404E-02,   5.555848E-02,   6.352452E-02,   9.406638E-02, },
{  1.505335E-02,   1.840495E-02,   3.442100E-02,   6.813537E-02,   7.178347E-02,   1.010338E-01, },
{  1.531827E-02,   1.928026E-02,   4.285930E-02,   4.647639E-02,   6.130041E-02,   8.042894E-02, },
{  2.977480E-03,   5.192068E-03,   5.470674E-02,   5.770749E-02,   9.893079E-02,   1.012340E-01, },
{  2.918410E-02,   3.761962E-02,   4.497162E-02,   6.133674E-02,   6.349609E-02,   8.620983E-02, },
{  9.221297E-03,   2.999911E-02,   1.275874E-01,   1.024791E-01,   1.207742E-01,   1.318636E-01, },
{  8.095198E-03,   1.030628E-02,   1.336074E-02,   3.210572E-02,   8.125053E-02,   1.017212E-01, },
{  1.263686E-02,   1.557137E-02,   1.533369E-02,   9.080391E-02,   1.216256E-01,   1.148420E-01, },
{  1.542076E-02,   2.067158E-02,   4.924643E-02,   7.905457E-02,   8.451841E-02,   8.306566E-02, },
{  1.291647E-02,   1.620991E-02,   5.380358E-02,   8.707938E-02,   9.162560E-02,   8.693370E-02, },
{  1.211426E-02,   1.657993E-02,   2.832412E-02,   3.027308E-02,   2.184825E-02,   6.030287E-02, },
{  1.532719E-02,   2.068672E-02,   2.383086E-02,   6.613539E-02,   1.060231E-01,   1.318274E-01, },
{  1.812837E-02,   2.249584E-02,   3.221678E-02,   6.641265E-02,   7.137030E-02,   8.290484E-02, },
{  2.433811E-02,   3.267257E-02,   5.893971E-02,   8.606325E-02,   8.892006E-02,   1.151853E-01, },
{  7.146595E-03,   7.126715E-03,   1.421759E-02,   5.099842E-02,   9.802030E-02,   1.037037E-01, },
{  2.252108E-02,   2.629262E-02,   4.530183E-02,   7.693447E-02,   1.051258E-01,   1.128501E-01, },
{  2.901030E-02,   3.574438E-02,   4.879251E-02,   6.629650E-02,   7.321051E-02,   8.599658E-02, },
{  1.391637E-02,   2.250339E-02,   3.979060E-02,   4.804909E-02,   8.505359E-02,   9.123988E-02, },
{  1.082784E-02,   1.200838E-02,   2.639393E-02,   4.458541E-02,   6.407778E-02,   1.209462E-01, },
{  1.537828E-02,   2.271123E-02,   3.624196E-02,   5.380582E-02,   1.028153E-01,   1.101227E-01, },
{  1.727095E-02,   2.261639E-02,   3.610639E-02,   7.102333E-02,   6.133576E-02,   7.367833E-02, },
{  2.871336E-02,   4.217762E-02,   7.428286E-02,   9.024320E-02,   1.093638E-01,   1.255733E-01, },
{  1.091344E-02,   1.640563E-02,   1.663757E-02,   5.920109E-02,   8.506068E-02,   9.496120E-02, },
{  1.478960E-02,   1.974554E-02,   3.884511E-02,   9.463674E-02,   1.088259E-01,   9.769627E-02, },
{  3.277742E-02,   5.738633E-02,   6.578534E-02,   7.272279E-02,   7.779411E-02,   8.354896E-02, },
{  1.780603E-02,   2.125164E-02,   5.043926E-02,   9.106517E-02,   8.214819E-02,   9.325451E-02, },
{  1.882153E-02,   2.457873E-02,   3.674215E-02,   4.990724E-02,   5.284731E-02,   6.984563E-02, },
{  1.234764E-02,   1.754746E-02,   2.781754E-02,   5.086186E-02,   1.061413E-01,   1.294858E-01, },
{  1.957420E-02,   2.544439E-02,   5.419941E-02,   7.405966E-02,   8.252364E-02,   8.802708E-02, },
{  1.835619E-02,   2.840494E-02,   4.172413E-02,   5.604003E-02,   9.757788E-02,   1.051299E-01, },
{  1.010845E-02,   1.394130E-02,   1.262792E-02,   3.879391E-02,   8.996367E-02,   1.166333E-01, },
{  1.873158E-02,   2.615028E-02,   3.368149E-02,   5.764396E-02,   1.106429E-01,   1.308779E-01, },
{  2.394083E-02,   2.989627E-02,   4.942437E-02,   5.638006E-02,   6.839170E-02,   1.132840E-01, },
{  1.405545E-02,   1.749429E-02,   4.841236E-02,   6.930706E-02,   7.544918E-02,   1.080256E-01, },
{  1.583343E-02,   1.830451E-02,   4.637198E-02,   5.178517E-02,   5.760442E-02,   1.182542E-01, },
{  1.020151E-02,   1.292385E-02,   3.490240E-02,   7.018381E-02,   9.080695E-02,   1.097456E-01, },
{  1.801167E-02,   2.266639E-02,   4.692888E-02,   5.382405E-02,   6.565278E-02,   6.422349E-02, },
{  1.022929E-02,   1.797328E-02,   9.359190E-02,   8.929078E-02,   1.239040E-01,   1.338253E-01, },
{  1.077252E-02,   1.639032E-02,   2.018753E-02,   4.260018E-02,   7.935295E-02,   7.615489E-02, },
{  1.096440E-02,   1.124945E-02,   7.041502E-02,   1.243952E-01,   1.135814E-01,   1.280742E-01, },
{  1.974123E-02,   2.385992E-02,   4.105194E-02,   6.736031E-02,   7.301763E-02,   8.861179E-02, },
{  4.390481E-03,   5.921926E-03,   5.418013E-02,   7.837507E-02,   8.708723E-02,   9.513121E-02, },
{  5.372070E-03,   7.536950E-03,   1.951401E-02,   4.930743E-02,   6.016624E-02,   6.244878E-02, },
{  1.268592E-02,   1.484316E-02,   2.382831E-02,   7.139440E-02,   1.260525E-01,   1.402098E-01, },
{  2.022281E-02,   2.761855E-02,   3.662689E-02,   6.772475E-02,   8.295484E-02,   7.586932E-02, },
{  1.420502E-02,   2.011072E-02,   7.322620E-02,   7.527966E-02,   8.673848E-02,   1.225917E-01, },
{  1.044615E-02,   1.258802E-02,   2.002669E-02,   5.852528E-02,   7.571769E-02,   1.037735E-01, },
{  1.839631E-02,   2.854892E-02,   3.614214E-02,   6.485911E-02,   1.091316E-01,   1.140818E-01, },
{  2.781523E-02,   4.806902E-02,   5.601836E-02,   6.895995E-02,   6.567271E-02,   7.117714E-02, },
{  1.272084E-02,   1.779906E-02,   2.192863E-02,   6.724898E-02,   8.253110E-02,   8.695286E-02, },
{  1.816219E-02,   2.143635E-02,   3.190507E-02,   3.755584E-02,   6.821242E-02,   1.283051E-01, },
{  1.755509E-02,   2.935315E-02,   4.380950E-02,   6.521741E-02,   9.508036E-02,   1.046691E-01, },
{  1.970508E-02,   2.552934E-02,   3.930553E-02,   4.786653E-02,   5.437936E-02,   8.076927E-02, },
{  1.456140E-02,   3.374544E-02,   7.970592E-02,   9.438460E-02,   1.032006E-01,   1.161548E-01, },
{  1.254021E-02,   1.869307E-02,   2.502363E-02,   4.745002E-02,   6.727120E-02,   6.453113E-02, },
{  1.890480E-02,   2.218918E-02,   4.602625E-02,   9.446239E-02,   9.930771E-02,   1.134703E-01, },
{  3.076965E-02,   3.976490E-02,   6.809391E-02,   8.123162E-02,   8.914848E-02,   1.172939E-01, },
{  2.113168E-02,   2.667804E-02,   3.663198E-02,   6.774890E-02,   1.012834E-01,   1.106191E-01, },
{  1.254015E-02,   1.733322E-02,   2.500843E-02,   2.884530E-02,   5.708722E-02,   9.177581E-02, },
{  1.494961E-02,   2.195896E-02,   2.753909E-02,   4.741632E-02,   1.061790E-01,   1.209860E-01, },
{  1.542365E-02,   2.052717E-02,   3.150580E-02,   4.938787E-02,   5.929995E-02,   8.269921E-02, },
{  2.477136E-02,   3.502809E-02,   5.504937E-02,   1.009507E-01,   9.814050E-02,   1.000485E-01, },
{  2.140547E-03,   5.432943E-03,   1.144482E-02,   1.531361E-02,   6.803262E-02,   9.481294E-02, },
{  1.438909E-02,   1.775833E-02,   3.996982E-02,   7.656893E-02,   8.984922E-02,   1.264812E-01, },
{  2.056809E-02,   3.790429E-02,   5.155328E-02,   6.035441E-02,   6.975576E-02,   7.644927E-02, },
{  1.791306E-02,   2.232038E-02,   3.581432E-02,   5.794728E-02,   6.738850E-02,   1.153306E-01, },
{  2.395748E-02,   3.106401E-02,   4.465618E-02,   5.586687E-02,   4.569519E-02,   1.010537E-01, },
{  1.189054E-02,   1.493856E-02,   5.329443E-02,   5.093915E-02,   9.003162E-02,   1.165685E-01, },
{  2.388112E-02,   3.332297E-02,   4.025440E-02,   4.940575E-02,   4.250983E-02,   6.302252E-02, },
{  2.382375E-02,   5.765958E-02,   9.265622E-02,   1.242902E-01,   1.215259E-01,   1.334003E-01, },
{  5.513841E-03,   4.747041E-03,   3.245656E-02,   3.550939E-02,   9.139678E-02,   1.069879E-01, },
{  1.573472E-02,   1.908277E-02,   3.118569E-02,   1.398652E-01,   1.319468E-01,   1.271327E-01, },
{  2.249561E-02,   2.877764E-02,   4.669652E-02,   7.013720E-02,   7.544043E-02,   9.182989E-02, },
{  2.621221E-02,   3.450988E-02,   3.012528E-02,   6.938832E-02,   9.286957E-02,   9.249997E-02, },
{  8.942313E-03,   1.330399E-02,   9.473300E-03,   2.251220E-02,   4.039366E-02,   7.555976E-02, },
{  1.488587E-02,   1.843153E-02,   4.133486E-02,   5.522937E-02,   1.007443E-01,   1.306439E-01, },
{  1.398944E-02,   2.000492E-02,   3.476138E-02,   6.462494E-02,   8.672043E-02,   9.141352E-02, },
{  1.838012E-02,   2.259786E-02,   5.219611E-02,   7.409216E-02,   8.106936E-02,   1.118493E-01, },
{  1.551834E-02,   2.060737E-02,   3.172813E-02,   3.890283E-02,   8.891291E-02,   9.359080E-02, },
{  1.630184E-02,   2.357645E-02,   2.934366E-02,   6.792309E-02,   1.049366E-01,   1.025137E-01, },
{  1.953843E-02,   3.955731E-02,   5.540157E-02,   6.034509E-02,   7.807854E-02,   8.936764E-02, },
{  1.466383E-02,   2.086192E-02,   2.819517E-02,   6.182044E-02,   9.139388E-02,   9.412517E-02, },
{  1.375805E-02,   1.703742E-02,   5.065813E-02,   2.734108E-02,   4.568600E-02,   9.383906E-02, },
{  2.152253E-02,   3.927809E-02,   4.439674E-02,   5.416629E-02,   9.573271E-02,   1.120029E-01, },
{  1.100294E-02,   1.549346E-02,   2.325106E-02,   4.414870E-02,   5.202418E-02,   6.314795E-02, },
{  3.237129E-02,   7.449112E-02,   1.094652E-01,   1.123284E-01,   1.170360E-01,   1.296260E-01, },
{  3.748916E-03,   2.989488E-04,   3.751295E-02,   6.184539E-02,   8.301106E-02,   8.365525E-02, },
{  8.627373E-03,   9.234969E-03,   5.469951E-02,   9.234212E-02,   9.456439E-02,   9.582944E-02, },
{  2.711350E-02,   3.946085E-02,   5.132606E-02,   7.298095E-02,   8.697209E-02,   9.138281E-02, },
{  1.518880E-02,   1.828621E-02,   3.236559E-02,   7.716100E-02,   8.522712E-02,   1.039338E-01, },
{  9.277091E-03,   1.083171E-02,   3.455346E-02,   4.943473E-02,   5.367633E-02,   7.366951E-02, },
{  1.586837E-02,   2.337304E-02,   2.930283E-02,   4.729477E-02,   9.672550E-02,   1.122177E-01, },
{  9.072026E-03,   8.635786E-03,   5.411867E-02,   5.231262E-02,   6.828445E-02,   8.991403E-02, },
{  2.425126E-02,   3.241503E-02,   3.832982E-02,   8.060231E-02,   9.875039E-02,   1.019062E-01, },
{  1.271851E-02,   1.617134E-02,   2.513448E-02,   3.228980E-02,   6.669324E-02,   1.074638E-01, },
{  1.614184E-02,   2.187882E-02,   3.591268E-02,   6.518870E-02,   1.159916E-01,   1.232195E-01, },
{  2.507768E-02,   3.127383E-02,   4.641970E-02,   5.175427E-02,   8.053382E-02,   1.189329E-01, },
{  1.100013E-02,   1.492332E-02,   4.647105E-02,   5.626120E-02,   8.309829E-02,   9.384995E-02, },
{  2.117633E-02,   2.805466E-02,   4.502802E-02,   5.330428E-02,   6.367092E-02,   1.041649E-01, },
{  1.376714E-02,   1.727978E-02,   4.868936E-02,   6.615950E-02,   7.711219E-02,   1.337999E-01, },
{  1.961934E-02,   2.548778E-02,   3.860282E-02,   6.082034E-02,   6.527518E-02,   7.095866E-02, },
{  8.484291E-03,   1.090654E-02,   5.260550E-02,   1.064594E-01,   1.169485E-01,   1.493964E-01, },
{  1.142316E-02,   1.523504E-02,   2.462418E-02,   4.979848E-02,   7.167937E-02,   8.503621E-02, },
{  2.390824E-02,   3.160741E-02,   3.709028E-02,   1.049810E-01,   1.083897E-01,   9.819835E-02, },
{  2.055582E-02,   2.513885E-02,   5.024496E-02,   6.907119E-02,   7.178680E-02,   1.098587E-01, },
{  6.750337E-03,   5.859039E-03,   4.573860E-02,   7.240298E-02,   7.939578E-02,   1.094488E-01, },
{  8.361095E-03,   1.336298E-02,   1.816839E-02,   2.716211E-02,   7.928541E-02,   8.230546E-02, },
{  1.417397E-02,   2.002466E-02,   3.794175E-02,   5.949761E-02,   1.277864E-01,   1.605456E-01, },
{  1.764979E-02,   3.463446E-02,   5.154979E-02,   6.308770E-02,   7.916047E-02,   8.617295E-02, },
{  1.648615E-02,   2.501295E-02,   8.711032E-02,   1.148575E-01,   8.218017E-02,   1.041873E-01, },
{  1.133088E-02,   1.490669E-02,   2.962531E-02,   6.753262E-02,   9.056436E-02,   9.591735E-02, },
{  1.428247E-02,   1.723447E-02,   2.933368E-02,   7.382032E-02,   1.045931E-01,   1.100603E-01, },
{  2.218001E-02,   4.374704E-02,   6.028049E-02,   6.498372E-02,   7.345216E-02,   7.534293E-02, },
{  1.612832E-02,   2.091733E-02,   3.024051E-02,   7.297852E-02,   7.829662E-02,   8.396848E-02, },
{  1.935827E-02,   2.268478E-02,   3.754214E-02,   4.367575E-02,   6.635286E-02,   1.218574E-01, },
{  2.007258E-02,   3.276682E-02,   3.669733E-02,   5.099705E-02,   9.422134E-02,   9.822448E-02, },
{  2.102394E-02,   2.897188E-02,   3.548442E-02,   5.057205E-02,   5.592877E-02,   7.082160E-02, },
{  1.027175E-02,   2.323011E-02,   9.963716E-02,   9.370287E-02,   9.359061E-02,   1.162529E-01, },
{  1.087582E-02,   1.476512E-02,   2.632638E-02,   6.156012E-02,   7.478257E-02,   8.056306E-02, },
{  1.480754E-02,   1.764167E-02,   3.041470E-02,   9.257700E-02,   1.007991E-01,   1.055582E-01, },
{  2.462674E-02,   3.151778E-02,   5.318328E-02,   7.046448E-02,   7.591493E-02,   9.579493E-02, },
{  1.461349E-02,   1.764543E-02,   3.162815E-02,   8.893679E-02,   8.626747E-02,   1.110185E-01, },
{  8.857517E-03,   1.115180E-02,   2.590487E-02,   3.728833E-02,   4.999082E-02,   9.243679E-02, },
{  1.072549E-02,   1.543587E-02,   2.384638E-02,   3.132002E-02,   9.484308E-02,   1.241837E-01, },
{  1.547104E-02,   2.027084E-02,   5.486665E-02,   5.890738E-02,   6.552946E-02,   8.787940E-02, },
{  1.502599E-02,   1.951680E-02,   6.619958E-02,   9.308999E-02,   9.559319E-02,   1.001661E-01, },
{  2.119399E-03,   1.488839E-03,   1.744308E-02,  -1.131702E-02,   7.213296E-02,   8.860678E-02, },
{  5.459763E-03,   4.485594E-03,   5.574665E-02,   9.576525E-02,   1.114021E-01,   1.289954E-01, },
{  2.405513E-02,   3.702498E-02,   4.840209E-02,   5.967111E-02,   6.619365E-02,   7.976551E-02, },
{  1.299813E-02,   1.700152E-02,   3.457162E-02,   5.333084E-02,   7.396351E-02,   9.714278E-02, },
{  1.336636E-02,   1.705404E-02,   2.800472E-02,   5.450557E-02,   5.535728E-02,   9.163663E-02, },
{  8.002247E-03,   1.031353E-02,   4.818459E-02,   7.596017E-02,   9.530676E-02,   1.288665E-01, },
{  2.045995E-02,   3.905342E-02,   5.275989E-02,   5.338823E-02,   6.608153E-02,   6.215352E-02, },
{  4.660379E-03,   1.732369E-02,   1.169888E-01,   1.061280E-01,   1.339893E-01,   1.555749E-01, },
{  1.272987E-02,   1.703755E-02,   3.174540E-02,   4.295365E-02,   8.150528E-02,   8.658902E-02, },
{  1.413461E-02,   1.597117E-02,   4.022562E-02,   1.095385E-01,   1.148796E-01,   1.215641E-01, },
{  2.045792E-02,   2.862510E-02,   4.486842E-02,   7.675208E-02,   9.049145E-02,   8.940981E-02, },
{  1.824463E-02,   2.323618E-02,   3.808663E-02,   7.153753E-02,   8.963325E-02,   9.486583E-02, },
{  1.044025E-02,   1.171749E-02,   3.033792E-02,   4.776789E-02,   3.432175E-02,   8.863192E-02, },
{  1.620543E-02,   2.273987E-02,   2.937031E-02,   6.759913E-02,   1.100030E-01,   1.235521E-01, },
{  1.511984E-02,   2.065771E-02,   3.141240E-02,   6.294540E-02,   7.829356E-02,   8.791505E-02, },
{  1.742879E-02,   2.177426E-02,   5.444184E-02,   9.083996E-02,   9.622348E-02,   1.170658E-01, },
{  5.603725E-03,   8.676967E-03,   2.259751E-02,   5.978147E-02,   9.037420E-02,   9.276509E-02, },
{  1.477546E-02,   2.045261E-02,   4.679557E-02,   6.213375E-02,   1.106310E-01,   1.167212E-01, },
{  2.496554E-02,   4.029833E-02,   4.299406E-02,   6.080973E-02,   7.927529E-02,   9.241896E-02, },
{  1.382050E-02,   1.883717E-02,   3.660823E-02,   5.509482E-02,   8.202045E-02,   8.620513E-02, },
{  1.484839E-02,   1.828061E-02,   3.798604E-02,   5.551167E-02,   6.068840E-02,   1.016080E-01, },
{  1.885894E-02,   3.134612E-02,   3.405343E-02,   4.857222E-02,   9.195026E-02,   1.182383E-01, },
{  1.508539E-02,   1.838027E-02,   3.696565E-02,   4.310050E-02,   5.584783E-02,   6.912038E-02, },
{  4.191570E-02,   7.168960E-02,   7.492454E-02,   6.178412E-02,   9.318558E-02,   1.078144E-01, },
{  2.368398E-03,   9.292097E-03,   2.662490E-02,   4.827095E-02,   7.651051E-02,   8.230894E-02, },
{  1.807505E-02,   2.364894E-02,   3.227238E-02,   8.225134E-02,   1.121423E-01,   1.055654E-01, },
{  2.040610E-02,   4.147734E-02,   5.775642E-02,   6.099444E-02,   9.002206E-02,   9.868455E-02, },
{  1.642525E-02,   1.989056E-02,   4.045601E-02,   8.673607E-02,   9.446568E-02,   1.162277E-01, },
{  1.565782E-02,   2.071209E-02,   2.972881E-02,   3.847324E-02,   4.536819E-02,   7.132462E-02, },
{  8.570382E-03,   9.845965E-03,   2.732299E-02,   4.824733E-02,   9.136889E-02,   1.319239E-01, },
{  1.908257E-02,   2.588197E-02,   4.991061E-02,   6.779939E-02,   7.562132E-02,   8.294676E-02, },
{  2.218631E-02,   4.092733E-02,   5.330252E-02,   6.413483E-02,   9.783566E-02,   1.110686E-01, },
{  1.208177E-02,   1.580604E-02,   2.838160E-02,   4.139227E-02,   8.976157E-02,   1.156221E-01, },
{  1.367652E-02,   1.782706E-02,   3.144650E-02,   6.359998E-02,   1.154359E-01,   1.295785E-01, },
{  2.440817E-02,   3.211228E-02,   4.428553E-02,   6.014686E-02,   6.646165E-02,   9.821805E-02, },
{  2.168443E-02,   2.793970E-02,   4.454876E-02,   5.893308E-02,   6.671065E-02,   1.060657E-01, },
{  1.899569E-02,   2.312777E-02,   4.842060E-02,   6.009443E-02,   7.082538E-02,   1.134947E-01, },
{  1.640294E-02,   2.040768E-02,   3.755331E-02,   6.990249E-02,   7.872420E-02,   1.089004E-01, },
{  1.944004E-02,   2.453169E-02,   4.413945E-02,   6.231820E-02,   6.847980E-02,   7.803793E-02, },
{  1.643963E-02,   3.243069E-02,   9.760329E-02,   1.001539E-01,   1.245620E-01,   1.175128E-01, },
{  7.412642E-03,   1.263097E-02,   4.198807E-02,   3.539239E-02,   6.886702E-02,   8.219776E-02, },
{  1.088844E-02,   1.444076E-02,   4.286588E-02,   9.433912E-02,   9.789364E-02,   1.240283E-01, },
{  1.940309E-02,   2.975278E-02,   4.775611E-02,   7.115624E-02,   8.864951E-02,   9.495689E-02, },
{  5.952160E-03,   2.595853E-03,   3.595306E-02,   6.434460E-02,   7.381600E-02,   1.002850E-01, },
{  1.689940E-03,  -4.186537E-03,   2.752788E-02,   5.074700E-02,   6.304737E-02,   8.038974E-02, },
{  1.313101E-02,   1.686070E-02,   3.478034E-02,   5.771947E-02,   1.247268E-01,   1.359654E-01, },
{  2.564802E-02,   3.611115E-02,   4.453651E-02,   6.378682E-02,   7.292905E-02,   8.134476E-02, },
{  9.253179E-03,   1.442176E-02,   6.760730E-02,   6.676494E-02,   9.090480E-02,   1.092560E-01, },
{  1.240425E-02,   1.555268E-02,   3.112327E-02,   5.540482E-02,   7.447956E-02,   1.117342E-01, },
{  1.220580E-02,   1.578806E-02,   2.907635E-02,   6.275490E-02,   1.047898E-01,   1.150716E-01, },
{  2.732297E-02,   3.930169E-02,   5.019616E-02,   6.248133E-02,   7.032091E-02,   8.394231E-02, },
{  1.602703E-02,   2.292871E-02,   3.231790E-02,   7.702241E-02,   9.631370E-02,   8.403173E-02, },
{  1.866141E-02,   2.175413E-02,   4.388484E-02,   4.652397E-02,   5.444971E-02,   1.322430E-01, },
{  2.123490E-02,   3.511054E-02,   4.591912E-02,   6.430713E-02,   9.313315E-02,   1.019426E-01, },
{  2.001116E-02,   2.682120E-02,   4.012801E-02,   4.425955E-02,   4.727145E-02,   7.335066E-02, },
{  6.435100E-03,   9.518159E-03,   9.065847E-02,   9.026228E-02,   1.113917E-01,   1.099405E-01, },
{  1.617957E-02,   2.172471E-02,   1.782066E-02,   5.834112E-02,   6.268644E-02,   6.815810E-02, },
{  2.014832E-02,   2.512785E-02,   4.176527E-02,   9.541237E-02,   1.095277E-01,   1.173856E-01, },
{  2.292135E-02,   3.443663E-02,   6.955652E-02,   8.180029E-02,   9.545894E-02,   1.027133E-01, },
{  1.711223E-02,   2.221980E-02,   3.477676E-02,   6.700297E-02,   9.662024E-02,   1.037149E-01, },
{  1.315137E-02,   1.665870E-02,   2.214608E-02,   2.902966E-02,   4.493884E-02,   1.052064E-01, },
{  1.102308E-02,   1.504533E-02,   2.113995E-02,   3.261760E-02,   9.846945E-02,   1.005551E-01, },
{  1.591186E-02,   2.886544E-02,   4.167309E-02,   3.865687E-02,   7.497532E-02,   7.798815E-02, },
{  2.422193E-02,   2.716409E-02,   4.848965E-02,   8.868967E-02,   9.605062E-02,   1.030092E-01, },
{  1.611911E-03,   4.480762E-03,  -3.886791E-04,   2.234290E-02,   8.427998E-02,   9.058037E-02, },
{  1.515223E-02,   1.867846E-02,   5.245223E-02,   8.043297E-02,   8.732629E-02,   1.459396E-01, },
{  2.599899E-02,   3.326190E-02,   5.002174E-02,   6.351748E-02,   7.091885E-02,   1.010574E-01, },
{  1.279021E-02,   1.630052E-02,   4.294074E-02,   6.484811E-02,   7.487640E-02,   9.743884E-02, },
{  1.915862E-02,   2.440432E-02,   4.157422E-02,   4.979281E-02,   6.458893E-02,   9.575012E-02, },
{  1.402867E-02,   1.800022E-02,   4.752038E-02,   6.810308E-02,   9.173104E-02,   1.102783E-01, },
{  2.332436E-02,   3.371871E-02,   4.336500E-02,   5.158219E-02,   5.799010E-02,   7.470336E-02, },
{  1.015476E-02,   1.906830E-02,   1.140118E-01,   1.447692E-01,   1.117668E-01,   1.215128E-01, },
{  1.026376E-02,   1.454400E-02,   2.609081E-02,   3.241053E-02,   8.514611E-02,   8.867758E-02, },
{  1.159576E-02,   1.759059E-02,   6.981061E-02,   1.041662E-01,   1.226657E-01,   1.122906E-01, },
{  2.052068E-02,   2.590016E-02,   3.817445E-02,   7.212251E-02,   8.576358E-02,   8.924501E-02, },
{  1.927773E-02,   2.398309E-02,   3.334648E-02,   8.269129E-02,   8.271442E-02,   9.212294E-02, },
{  3.374523E-03,   4.376128E-03,   3.196694E-02,   1.697132E-02,   6.285971E-02,   7.734112E-02, },
{  1.507108E-02,   2.033973E-02,   4.343933E-02,   5.352955E-02,   9.863135E-02,   1.180238E-01, },
{  2.184873E-02,   3.157028E-02,   4.282216E-02,   6.549653E-02,   8.631370E-02,   8.799402E-02, },
{  8.925583E-03,   1.135999E-02,   5.992771E-02,   9.862841E-02,   9.008706E-02,   1.310581E-01, },
{  1.509759E-02,   2.099851E-02,   2.960142E-02,   5.962358E-02,   9.329299E-02,   1.045940E-01, },
{  1.153708E-02,   1.497233E-02,   3.510540E-02,   5.703729E-02,   9.027520E-02,   1.038161E-01, },
{  2.399269E-02,   3.539506E-02,   4.499040E-02,   6.330494E-02,   8.039618E-02,   8.501282E-02, },
{  1.179249E-02,   1.684390E-02,   2.782041E-02,   6.476456E-02,   9.797358E-02,   9.070356E-02, },
{  1.841335E-02,   2.171775E-02,   3.481634E-02,   4.387790E-02,   5.690813E-02,   1.120348E-01, },
{  2.058422E-02,   3.366131E-02,   3.556656E-02,   5.224960E-02,   1.073344E-01,   1.223066E-01, },
{  1.489191E-02,   1.916092E-02,   3.956279E-02,   5.105715E-02,   4.938538E-02,   3.729884E-02, },
{  3.979306E-02,   5.740193E-02,   9.808309E-02,   1.170020E-01,   9.221900E-02,   1.196407E-01, },
{  8.122885E-03,   1.287926E-02,   3.866110E-02,   5.084251E-02,   6.295597E-02,   8.439716E-02, },
{  2.312444E-03,   1.032564E-05,   5.524535E-02,   8.797891E-02,   9.921809E-02,   1.124538E-01, },
{  2.719297E-02,   3.219257E-02,   4.843793E-02,   7.193358E-02,   8.310207E-02,   8.963312E-02, },
{  1.904957E-02,   2.319126E-02,   3.912419E-02,   7.794990E-02,   8.434908E-02,   1.136095E-01, },
{  1.478999E-02,   2.021531E-02,   3.153813E-02,   4.800700E-02,   4.883219E-02,   7.547466E-02, },
{  1.365779E-02,   1.812209E-02,   2.986828E-02,   5.489312E-02,   9.550583E-02,   1.203611E-01, },
{  1.223797E-02,   1.569144E-02,   4.482687E-02,   6.680732E-02,   6.293172E-02,   8.467969E-02, },
{  3.143463E-02,   3.297851E-02,   5.328258E-02,   8.492979E-02,   1.028611E-01,   1.057896E-01, },
{  1.459369E-02,   1.836392E-02,   2.677124E-02,   3.977294E-02,   6.284354E-02,   1.155754E-01, },
{  1.338105E-02,   1.765153E-02,   4.563559E-02,   7.520471E-02,   1.071729E-01,   1.318243E-01, },
{  2.961938E-02,   3.725953E-02,   5.185459E-02,   5.954196E-02,   7.091828E-02,   1.082267E-01, },
{  7.964667E-03,   9.935347E-03,   5.833729E-02,   6.522263E-02,   7.746804E-02,   9.786808E-02, },
{  2.362202E-02,   2.970938E-02,   4.544120E-02,   5.210104E-02,   6.286221E-02,   1.228906E-01, },
{  1.592163E-02,   2.245604E-02,   4.039635E-02,   6.032389E-02,   8.767682E-02,   1.313998E-01, },
{  2.348589E-02,   3.441890E-02,   3.879755E-02,   5.753128E-02,   6.461181E-02,   7.256910E-02, },
{  6.137011E-03,   8.576566E-03,   7.711483E-02,   1.016813E-01,   1.092267E-01,   1.315698E-01, },
{  1.192969E-02,   1.572260E-02,   2.752455E-02,   5.091844E-02,   6.805249E-02,   9.410036E-02, },
{  1.648328E-02,   2.306562E-02,   5.955320E-02,   1.127671E-01,   9.925937E-02,   1.219629E-01, },
{  1.846583E-02,   2.321151E-02,   5.139705E-02,   7.474002E-02,   7.510324E-02,   9.019126E-02, },
{  1.612360E-02,   2.178258E-02,   4.715623E-02,   8.417795E-02,   9.204819E-02,   9.594985E-02, },
{  1.084019E-02,   1.455214E-02,   2.345144E-02,   3.434942E-02,   6.907176E-02,   7.629285E-02, },
{  2.214845E-02,   3.731681E-02,   4.980011E-02,   6.934687E-02,   1.387885E-01,   1.467837E-01, },
{  1.759849E-02,   2.367655E-02,   5.095108E-02,   6.114435E-02,   7.387634E-02,   9.011591E-02, },
{  1.143073E-02,   1.634339E-02,   7.022680E-02,   8.557770E-02,   8.269419E-02,   1.032762E-01, },
{  5.034150E-03,   6.043725E-03,   2.597589E-02,   6.826866E-02,   9.960168E-02,   1.178218E-01, },
{  1.087875E-02,   1.484513E-02,   3.625630E-02,   7.862848E-02,   1.231600E-01,   1.247406E-01, },
{  1.790286E-02,   3.364456E-02,   5.667640E-02,   7.338869E-02,   7.342370E-02,   7.524300E-02, },
{  1.247415E-02,   1.786998E-02,   3.829363E-02,   6.357346E-02,   7.637321E-02,   8.561161E-02, },
{  1.886912E-02,   2.216343E-02,   3.390265E-02,   3.876196E-02,   6.383350E-02,   1.118878E-01, },
{  1.845089E-02,   3.017697E-02,   3.764229E-02,   5.201171E-02,   8.148708E-02,   9.796843E-02, },
{  1.882507E-02,   2.680442E-02,   4.907686E-02,   6.134569E-02,   5.353727E-02,   6.475925E-02, },
{  2.396166E-02,   6.998947E-02,   1.163665E-01,   9.499165E-02,   8.642259E-02,   9.062236E-02, },
{  1.571377E-02,   2.102034E-02,   2.838630E-02,   6.134923E-02,   7.034638E-02,   7.556564E-02, },
{  9.489777E-03,   6.314479E-03,   2.977442E-02,   7.874474E-02,   1.059098E-01,   1.115218E-01, },
{  2.706502E-02,   3.722602E-02,   6.134390E-02,   7.374523E-02,   8.096151E-02,   9.648418E-02, },
{  1.558293E-02,   2.102157E-02,   3.789068E-02,   6.404704E-02,   8.941075E-02,   9.901531E-02, },
{  3.689839E-03,  -3.256803E-03,   2.437059E-02,   2.419704E-02,   2.625071E-02,   9.998896E-02, },
{  7.664678E-03,   6.589273E-03,   1.253130E-02,   2.017274E-02,   1.168120E-01,   1.080445E-01, },
{  1.886314E-02,   2.420134E-02,   4.408668E-02,   5.927902E-02,   6.374656E-02,   8.402442E-02, },
{  2.247920E-02,   2.812869E-02,   4.671583E-02,   7.878347E-02,   8.420969E-02,   9.892771E-02, },
{  7.806912E-03,   1.062895E-02,  -2.658204E-03,   2.260853E-03,   6.043758E-02,   9.559103E-02, },
{  1.363508E-02,   1.981667E-02,   5.976759E-02,   7.503720E-02,   1.224587E-01,   1.252867E-01, },
{  2.259505E-02,   3.582435E-02,   4.693095E-02,   5.800370E-02,   6.354489E-02,   8.988063E-02, },
{  1.628984E-02,   2.055166E-02,   3.796727E-02,   6.170445E-02,   6.762355E-02,   9.257493E-02, },
{  1.287878E-02,   1.634711E-02,   4.597766E-02,   4.640548E-02,   5.665176E-02,   9.654348E-02, },
{  6.322193E-03,   8.095905E-03,   5.257995E-02,   5.546989E-02,   1.087350E-01,   1.223975E-01, },
{  2.992271E-02,   4.504331E-02,   4.845795E-02,   6.094912E-02,   7.790992E-02,   6.855871E-02, },
{  8.788923E-03,   1.659068E-02,   9.709379E-02,   1.030036E-01,   1.214441E-01,   1.487586E-01, },
{  1.217857E-02,   1.636701E-02,   2.190734E-02,   4.482294E-02,   7.949980E-02,   8.847397E-02, },
{  1.457409E-02,   1.692320E-02,   3.840008E-02,   9.622904E-02,   1.176266E-01,   1.219970E-01, },
{  2.390720E-02,   3.585388E-02,   4.459535E-02,   7.145938E-02,   8.003280E-02,   7.576426E-02, },
{  1.316554E-02,   1.643549E-02,   2.980152E-02,   7.947161E-02,   8.312609E-02,   9.032796E-02, },
{  1.168289E-02,   1.441664E-02,   2.683204E-02,   2.642278E-02,   2.726879E-02,   8.364395E-02, },
{  1.467555E-02,   2.061441E-02,   2.738834E-02,   5.421122E-02,   1.161716E-01,   1.254662E-01, },
{  1.660980E-02,   2.279703E-02,   4.306986E-02,   6.528750E-02,   7.254754E-02,   8.346804E-02, },
{  2.219295E-02,   2.897340E-02,   7.361217E-02,   9.808009E-02,   8.370855E-02,   1.264586E-01, },
{  9.986193E-03,   1.557308E-02,   1.793708E-02,   5.054372E-02,   1.041820E-01,   1.087823E-01, },
{  1.771283E-02,   2.240226E-02,   3.816140E-02,   6.906273E-02,   1.052519E-01,   1.238268E-01, },
{  2.696792E-02,   3.816712E-02,   5.455200E-02,   6.870723E-02,   7.654406E-02,   8.884296E-02, },
{  1.580913E-02,   2.477832E-02,   3.193618E-02,   5.452290E-02,   8.243711E-02,   8.475383E-02, },
{  1.120345E-02,   1.409331E-02,   3.972082E-02,   4.910075E-02,   7.027742E-02,   1.081835E-01, },
{  1.714046E-02,   2.826518E-02,   4.335815E-02,   5.062371E-02,   1.092520E-01,   1.197717E-01, },
{  9.247967E-03,   9.442923E-03,   4.232470E-02,   6.347714E-02,   6.183712E-02,   6.723353E-02, },
{  2.366710E-02,   5.000990E-02,   6.097954E-02,   7.639781E-02,   1.114591E-01,   1.377205E-01, },
{  7.153635E-03,   7.497279E-03,   3.036668E-02,   6.220948E-02,   6.682636E-02,   8.012770E-02, },
{  1.278575E-02,   1.491660E-02,   2.824869E-02,   9.298212E-02,   1.097185E-01,   1.103373E-01, },
{  2.912549E-02,   4.074913E-02,   5.205938E-02,   7.139898E-02,   8.024339E-02,   8.762156E-02, },
{  1.581055E-02,   1.898350E-02,   5.253120E-02,   8.459358E-02,   8.970007E-02,   1.014768E-01, },
{  1.827951E-02,   2.216544E-02,   3.507323E-02,   4.102996E-02,   4.741287E-02,   8.015882E-02, },
{  1.200989E-02,   1.617555E-02,   2.151395E-02,   5.351506E-02,   1.053259E-01,   1.252813E-01, },
{  6.572818E-03,   9.764429E-03,   6.376912E-02,   7.778806E-02,   7.447746E-02,   8.419107E-02, },
{  1.893770E-02,   2.439946E-02,   4.156638E-02,   6.921931E-02,   9.719600E-02,   1.075982E-01, },
{  8.232879E-03,   1.316679E-02,   1.389157E-02,   5.604989E-03,   1.003650E-01,   1.117649E-01, },
{  2.007001E-02,   3.413030E-02,   4.950589E-02,   7.017331E-02,   1.221044E-01,   1.199976E-01, },
{  3.163407E-02,   4.125733E-02,   5.264509E-02,   6.384484E-02,   6.548474E-02,   9.417089E-02, },
{  1.762709E-02,   2.132418E-02,   4.491323E-02,   6.294285E-02,   6.915218E-02,   9.943427E-02, },
{  2.245277E-02,   2.714780E-02,   4.283777E-02,   4.829383E-02,   5.357414E-02,   1.157988E-01, },
{  1.309955E-02,   1.696696E-02,   3.022883E-02,   7.296107E-02,   7.667473E-02,   1.096088E-01, },
{  1.890640E-02,   2.948302E-02,   4.331952E-02,   6.249177E-02,   7.298846E-02,   7.122432E-02, },
{  1.483366E-02,   2.286144E-02,   7.077068E-02,   1.015134E-01,   1.269828E-01,   1.317120E-01, },
{  1.525401E-02,   2.517735E-02,   3.014394E-02,   4.444054E-02,   7.364945E-02,   8.000347E-02, },
{  1.426637E-02,   1.752276E-02,   4.744677E-02,   1.028749E-01,   1.145039E-01,   1.334188E-01, },
{  2.389943E-02,   3.038932E-02,   5.388458E-02,   6.783254E-02,   7.978520E-02,   8.242037E-02, },
{  1.157922E-02,   1.269624E-02,   3.732977E-02,   8.673580E-02,   7.887326E-02,   9.646977E-02, },
{  7.912940E-03,   1.209513E-02,   1.165394E-02,   5.286375E-02,   6.625434E-02,   7.008211E-02, },
{  1.904757E-02,   2.512962E-02,   2.686913E-02,   7.475535E-02,   1.179007E-01,   1.398764E-01, },
{  2.758727E-02,   3.300526E-02,   3.977947E-02,   7.603474E-02,   6.403792E-02,   7.101061E-02, },
{  1.133938E-02,   1.682542E-02,   7.783628E-02,   8.540535E-02,   9.179700E-02,   1.129417E-01, },
{  1.218423E-02,   1.528762E-02,   2.466779E-02,   4.751115E-02,   7.359077E-02,   1.025366E-01, },
{  1.720963E-02,   2.408062E-02,   3.312471E-02,   5.977313E-02,   1.016358E-01,   1.149919E-01, },
{  3.227557E-02,   4.718862E-02,   5.738890E-02,   7.379523E-02,   7.072328E-02,   8.521764E-02, },
{  7.838527E-03,   1.100696E-02,   1.572514E-02,   7.172102E-02,   8.236127E-02,   8.886485E-02, },
{  1.935368E-02,   2.169023E-02,   2.748599E-02,   3.098545E-02,   5.672927E-02,   1.509402E-01, },
{  1.695667E-02,   2.551327E-02,   4.273283E-02,   6.543839E-02,   9.258628E-02,   9.798855E-02, },
{  2.373524E-02,   2.863935E-02,   3.872848E-02,   5.914312E-02,   5.691530E-02,   7.722986E-02, },
{  1.100662E-02,   2.809416E-02,   8.637756E-02,   8.638753E-02,   9.674811E-02,   9.920835E-02, },
{  1.006975E-02,   1.353991E-02,   3.392461E-02,   4.687385E-02,   6.728703E-02,   7.012154E-02, },
{  1.391395E-02,   1.582188E-02,   4.357116E-02,   9.333952E-02,   9.914866E-02,   1.093289E-01, },
{  2.955855E-02,   3.905132E-02,   5.608138E-02,   6.493489E-02,   7.676604E-02,   1.230007E-01, },
{  2.302547E-02,   3.192957E-02,   3.595866E-02,   6.685435E-02,   9.463611E-02,   9.989009E-02, },
{  1.751388E-02,   2.226060E-02,   3.445840E-02,   3.884953E-02,   5.851308E-02,   9.312227E-02, },
{  1.305741E-02,   1.752899E-02,   2.315482E-02,   5.554090E-02,   1.119815E-01,   1.142905E-01, },
{  1.735442E-02,   2.429493E-02,   2.960045E-02,   5.249490E-02,   6.394314E-02,   7.483511E-02, },
{  3.045961E-02,   4.498087E-02,   5.916244E-02,   7.873767E-02,   8.943266E-02,   9.556546E-02, },
{  6.162574E-03,   1.036511E-02,   3.018452E-02,   1.130674E-02,   7.610225E-02,   1.014711E-01, },
{  1.258272E-02,   1.727962E-02,   2.772240E-02,   7.685965E-02,   9.237673E-02,   1.483922E-01, },
{  2.223794E-02,   2.894979E-02,   4.707412E-02,   5.952776E-02,   6.713516E-02,   9.001402E-02, },
{  1.266740E-02,   1.540541E-02,   5.031353E-02,   6.871319E-02,   6.432721E-02,   1.003283E-01, },
{  2.281359E-02,   3.092372E-02,   4.428404E-02,   5.171031E-02,   5.742606E-02,   9.082704E-02, },
{  9.556140E-03,   1.116375E-02,   3.521447E-02,   5.157351E-02,   8.389982E-02,   1.157449E-01, },
{  2.712919E-02,   3.645462E-02,   4.401009E-02,   5.892179E-02,   5.813101E-02,   7.132809E-02, },
{  2.822248E-02,   8.149555E-02,   1.234187E-01,   1.382337E-01,   1.221444E-01,   1.324247E-01, },
{  8.343549E-03,   1.326757E-02,   1.776301E-02,   4.132765E-02,   9.255921E-02,   9.217725E-02, },
{  1.315752E-02,   1.534833E-02,   4.095973E-02,   1.147898E-01,   1.275004E-01,   1.180905E-01, },
{  2.333613E-02,   3.197543E-02,   4.754569E-02,   6.501931E-02,   7.603519E-02,   8.574599E-02, },
{  1.950199E-02,   2.465779E-02,   4.030043E-02,   7.558572E-02,   9.685009E-02,   1.038266E-01, },
{  8.914517E-03,   1.077029E-02,   1.592457E-02,  -7.251844E-04,   2.835490E-02,   7.336167E-02, },
{  1.793985E-02,   2.641711E-02,   4.029904E-02,   5.279456E-02,   9.879159E-02,   1.535311E-01, },
{  1.936748E-02,   2.551357E-02,   3.199980E-02,   6.261838E-02,   8.702062E-02,   9.086880E-02, },
{  1.655261E-02,   2.066593E-02,   6.047280E-02,   7.588098E-02,   8.196060E-02,   1.208410E-01, },
{  9.207167E-03,   1.209808E-02,   2.296865E-02,   4.604761E-02,   9.030021E-02,   9.895577E-02, },
{  1.449111E-02,   1.810137E-02,   3.378086E-02,   5.622435E-02,   1.073309E-01,   1.159677E-01, },
{  2.651695E-02,   4.354978E-02,   4.896944E-02,   6.633777E-02,   8.368195E-02,   8.638583E-02, },
{  1.756268E-02,   2.642071E-02,   3.595901E-02,   5.880322E-02,   8.829893E-02,   9.449306E-02, },
{  2.139214E-02,   2.645269E-02,   3.832979E-02,   4.362762E-02,   5.459877E-02,   1.028349E-01, },
{  1.554784E-02,   3.123913E-02,   4.788488E-02,   5.473898E-02,   9.371774E-02,   1.128749E-01, },
{  1.145921E-02,   1.502437E-02,   3.380640E-02,   5.322543E-02,   5.545181E-02,   5.260113E-02, },
{  3.948929E-02,   1.062714E-01,   1.189197E-01,   1.015280E-01,   1.117867E-01,   1.211310E-01, },
{  4.865493E-03,   1.099096E-03,   3.673660E-02,   4.749116E-02,   8.031729E-02,   9.530591E-02, },
{  1.254208E-02,   1.635889E-02,   4.483850E-02,   1.100567E-01,   9.056575E-02,   1.033305E-01, },
{  3.196430E-02,   3.621390E-02,   4.814444E-02,   7.749096E-02,   9.206474E-02,   9.726605E-02, },
{  1.536439E-02,   1.844557E-02,   4.174439E-02,   7.612869E-02,   8.504895E-02,   1.144308E-01, },
{  1.165442E-02,   1.535629E-02,   2.350371E-02,   3.585338E-02,   4.470600E-02,   7.857856E-02, },
{  1.730932E-02,   2.606500E-02,   2.961790E-02,   4.588902E-02,   9.873172E-02,   1.217809E-01, },
{  9.285505E-03,   1.842717E-02,   6.080849E-02,   6.261966E-02,   7.424768E-02,   8.155175E-02, },
{  2.185628E-02,   3.310676E-02,   4.317066E-02,   7.193280E-02,   1.029553E-01,   1.077609E-01, },
{  1.075460E-02,   1.312181E-02,   2.413819E-02,   3.576681E-02,   6.530348E-02,   9.622084E-02, },
{  1.486295E-02,   1.875446E-02,   3.408770E-02,   7.170266E-02,   1.104813E-01,   1.190493E-01, },
{  2.641333E-02,   3.492358E-02,   4.475432E-02,   6.111701E-02,   6.958067E-02,   1.309761E-01, },
{  1.278132E-02,   1.750499E-02,   4.253059E-02,   4.704645E-02,   7.875836E-02,   1.005170E-01, },
{  2.731648E-02,   3.306383E-02,   4.594393E-02,   5.340759E-02,   6.675166E-02,   1.093932E-01, },
{  1.390499E-02,   1.799122E-02,   4.828137E-02,   4.889549E-02,   7.514922E-02,   1.329747E-01, },
{  1.859558E-02,   2.570608E-02,   3.655853E-02,   4.812220E-02,   6.023946E-02,   7.567991E-02, },
{  1.194816E-02,   1.528388E-02,   6.865578E-02,   7.975380E-02,   1.165029E-01,   1.455292E-01, },
{  1.166374E-02,   1.390279E-02,   1.704171E-02,   6.105227E-02,   6.618477E-02,   9.020539E-02, },
{  1.270024E-02,   2.377192E-02,   6.096773E-02,   8.382383E-02,   1.029931E-01,   1.084016E-01, },
{  1.507387E-02,   3.104616E-02,   5.898633E-02,   6.867682E-02,   8.710654E-02,   1.032664E-01, },
{  1.296617E-02,   1.821033E-02,   5.149477E-02,   6.907398E-02,   8.494699E-02,   9.986313E-02, },
{  5.700113E-03,   8.021395E-03,   7.289399E-03,   3.760920E-02,   7.482159E-02,   7.623930E-02, },
{  1.411396E-02,   1.839170E-02,   3.379190E-02,   8.812639E-02,   1.349543E-01,   1.438487E-01, },
{  2.009461E-02,   2.482144E-02,   4.047376E-02,   6.826928E-02,   7.748926E-02,   8.457430E-02, },
{  1.691141E-02,   2.489877E-02,   8.991350E-02,   8.392862E-02,   8.206347E-02,   8.663212E-02, },
{  1.342293E-02,   1.767973E-02,   2.816608E-02,   6.153697E-02,   1.002814E-01,   1.067264E-01, },
{  2.134497E-02,   2.409457E-02,   2.944932E-02,   7.893699E-02,   1.034288E-01,   1.215309E-01, },
{  2.327876E-02,   4.060890E-02,   5.111766E-02,   6.248703E-02,   7.674031E-02,   8.127824E-02, },
{  8.894089E-03,   8.865018E-03,   4.004605E-02,   6.984351E-02,   7.827468E-02,   7.934665E-02, },
{  1.862925E-02,   2.656469E-02,   3.096593E-02,   4.150274E-02,   8.054524E-02,   1.157653E-01, },
{  1.715904E-02,   2.722483E-02,   3.389409E-02,   5.240255E-02,   9.280948E-02,   1.044719E-01, },
{  1.726714E-02,   2.654325E-02,   3.383467E-02,   4.200719E-02,   5.253385E-02,   6.681640E-02, },
{  8.457881E-03,   3.282512E-02,   1.162420E-01,   8.560431E-02,   9.141515E-02,   9.980198E-02, },
{  1.476752E-02,   2.010877E-02,   2.897956E-02,   5.837540E-02,   7.348493E-02,   8.473411E-02, },
{  1.670215E-02,   2.138737E-02,   2.678791E-02,   8.130454E-02,   9.999279E-02,   1.114363E-01, },
{  2.444899E-02,   3.650081E-02,   4.772292E-02,   7.452831E-02,   7.970840E-02,   1.099438E-01, },
{  1.698514E-02,   2.082391E-02,   2.729123E-02,   8.066765E-02,   9.981830E-02,   9.712416E-02, },
{  1.043975E-02,   1.145416E-02,   3.890807E-02,   4.877735E-02,   5.031862E-02,   9.902620E-02, },
{  1.084090E-02,   1.507730E-02,   1.849555E-02,   2.767579E-02,   1.115149E-01,   1.347792E-01, },
{  1.786550E-02,   2.189423E-02,   5.385242E-02,   6.056613E-02,   4.883777E-02,   8.266257E-02, },
{  2.119648E-02,   3.206086E-02,   5.548284E-02,   7.822802E-02,   9.949095E-02,   9.998103E-02, },
{  2.174640E-03,  -3.327869E-04,   1.976386E-02,   1.051926E-02,   6.849391E-02,   7.815277E-02, },
{  1.272788E-02,   1.551968E-02,   4.290670E-02,   7.822374E-02,   1.105201E-01,   1.124453E-01, },
{  2.263182E-02,   3.642591E-02,   5.552606E-02,   6.390729E-02,   5.871817E-02,   8.731143E-02, },
{  1.484914E-02,   1.997789E-02,   3.002956E-02,   5.518424E-02,   8.445769E-02,   9.134162E-02, },
{  1.759773E-02,   2.207383E-02,   4.009669E-02,   4.640949E-02,   5.595699E-02,   8.700344E-02, },
{  1.125535E-02,   1.306701E-02,   4.267463E-02,   6.199129E-02,   9.109763E-02,   1.196655E-01, },
{  2.456567E-02,   3.834126E-02,   4.890463E-02,   5.510650E-02,   6.273646E-02,   7.982997E-02, },
{  1.083866E-02,   2.397698E-02,   1.304575E-01,   1.262270E-01,   1.316193E-01,   1.476179E-01, },
{  1.385901E-02,   2.238638E-02,   2.278713E-02,   4.865484E-02,   8.522647E-02,   8.738758E-02, },
{  1.739459E-02,   2.004248E-02,   3.408201E-02,   9.966703E-02,   1.094578E-01,   1.147707E-01, },
{  2.843784E-02,   3.341265E-02,   5.208847E-02,   8.185692E-02,   9.285686E-02,   8.349011E-02, },
{  1.657201E-02,   2.274588E-02,   5.249144E-02,   6.863480E-02,   8.139601E-02,   9.382013E-02, },
{  9.550044E-03,   9.787398E-03,   2.176021E-02,   3.767412E-02,   1.935836E-02,   8.905565E-02, },
{  1.719228E-02,   2.149510E-02,   2.663867E-02,   5.758213E-02,   9.676388E-02,   1.237527E-01, },
{  1.855243E-02,   2.468624E-02,   3.510188E-02,   6.063308E-02,   7.919507E-02,   8.358708E-02, },
{  9.936852E-03,   1.409672E-02,   6.946001E-02,   8.568332E-02,   1.068278E-01,   1.222405E-01, },
{  7.415713E-03,   1.928408E-04,   1.280270E-02,   6.109373E-02,   9.060449E-02,   9.524086E-02, },
{  1.623189E-02,   1.987705E-02,   3.810113E-02,   8.473285E-02,   1.146056E-01,   1.199542E-01, },
{  2.144506E-02,   3.605592E-02,   5.023266E-02,   6.995492E-02,   8.115241E-02,   8.549543E-02, },
{  4.933934E-03,   1.806742E-02,   3.972157E-02,   5.560617E-02,   7.967100E-02,   8.072194E-02, },
{  1.921199E-02,   2.327872E-02,   4.233484E-02,   4.603347E-02,   6.372513E-02,   1.038398E-01, },
{  1.548886E-02,   2.367448E-02,   3.905779E-02,   5.153278E-02,   8.624490E-02,   1.143654E-01, },
{  1.681627E-02,   2.233587E-02,   3.797271E-02,   4.711895E-02,   4.919119E-02,   6.112078E-02, },
{  2.496898E-02,   6.750349E-02,   6.148431E-02,   8.687825E-02,   8.598502E-02,   1.097072E-01, },
{  5.938500E-03,   8.380995E-03,   1.120129E-02,   4.981027E-02,   8.255072E-02,   8.771057E-02, },
{  2.075766E-02,   2.574089E-02,   4.026173E-02,   8.927364E-02,   9.694068E-02,   9.217285E-02, },
{  2.360060E-02,   4.320366E-02,   5.028880E-02,   6.212697E-02,   9.004837E-02,   1.008713E-01, },
{  1.666369E-02,   1.985381E-02,   5.478602E-02,   8.431240E-02,   8.824166E-02,   1.141371E-01, },
{  1.882471E-02,   2.409265E-02,   2.876541E-02,   3.702326E-02,   4.859445E-02,   8.556039E-02, },
{  1.229886E-02,   1.629756E-02,   3.512328E-02,   4.741363E-02,   9.125299E-02,   1.284885E-01, },
{  1.398895E-02,   1.945373E-02,   5.169281E-02,   8.502908E-02,   5.677450E-02,   7.924180E-02, },
{  1.743957E-02,   2.517975E-02,   4.479414E-02,   7.742182E-02,   1.024858E-01,   9.537053E-02, },
{  1.288352E-02,   2.270993E-02,   2.242239E-02,   3.038807E-02,   9.225716E-02,   1.151791E-01, },
{  1.477303E-02,   1.901046E-02,   3.084250E-02,   6.225030E-02,   1.154338E-01,   1.146007E-01, },
{  2.100498E-02,   2.770876E-02,   5.127205E-02,   6.171256E-02,   7.034399E-02,   9.832722E-02, },
{  1.511360E-02,   1.895759E-02,   4.701429E-02,   5.466788E-02,   7.093770E-02,   9.809879E-02, },
{  1.792544E-02,   2.146124E-02,   4.444160E-02,   4.809205E-02,   7.275240E-02,   1.192102E-01, },
{  1.288270E-02,   1.659859E-02,   3.264119E-02,   6.551302E-02,   7.858308E-02,   1.191055E-01, },
{  2.118268E-02,   2.833311E-02,   5.849356E-02,   6.593202E-02,   6.592046E-02,   7.117618E-02, },
{  9.663038E-03,   2.758298E-02,   9.208857E-02,   8.208720E-02,   1.037238E-01,   1.266260E-01, },
{  1.122301E-02,   1.470382E-02,   3.395548E-02,   4.131745E-02,   6.880760E-02,   9.243520E-02, },
{  1.444207E-02,   1.629588E-02,   4.796751E-02,   1.010786E-01,   1.111132E-01,   1.139987E-01, },
{  1.792898E-02,   2.196458E-02,   4.561102E-02,   6.997085E-02,   7.620976E-02,   9.956429E-02, },
{  7.429552E-03,   8.722958E-03,   2.528140E-02,   7.552325E-02,   8.534224E-02,   1.144277E-01, },
{  9.532318E-04,  -1.790080E-04,   2.142853E-02,   2.873554E-02,   5.835916E-02,   6.806990E-02, },
{  1.049647E-02,   1.341440E-02,   1.588573E-02,   5.189050E-02,   1.224024E-01,   1.380873E-01, },
{  1.847657E-02,   3.669929E-02,   5.463709E-02,   5.833806E-02,   7.204936E-02,   7.851185E-02, },
{  1.435510E-02,   2.168282E-02,   5.711555E-02,   7.363146E-02,   9.349137E-02,   1.049243E-01, },
{  1.356717E-02,   1.787069E-02,   3.034902E-02,   4.914930E-02,   7.859029E-02,   1.079711E-01, },
{  7.960433E-03,   8.734673E-03,   1.731190E-02,   6.320779E-02,   1.142436E-01,   1.150666E-01, },
{  2.749036E-02,   4.165154E-02,   4.963616E-02,   6.753865E-02,   7.621891E-02,   8.510539E-02, },
{  1.651058E-02,   2.183837E-02,   3.072633E-02,   6.793939E-02,   8.393376E-02,   9.158440E-02, },
{  2.246808E-02,   2.746749E-02,   4.000294E-02,   4.473196E-02,   8.243233E-02,   1.284692E-01, },
{  2.793742E-02,   4.005259E-02,   4.424189E-02,   6.385754E-02,   9.381379E-02,   9.161928E-02, },
{  2.200342E-02,   2.963646E-02,   4.206550E-02,   5.125102E-02,   5.051043E-02,   8.117743E-02, },
{  1.027574E-02,   1.457768E-02,   8.321155E-02,   1.045318E-01,   9.785793E-02,   1.067814E-01, },
{  9.219193E-03,   1.078329E-02,   1.671907E-02,   4.836104E-02,   5.234426E-02,   7.815544E-02, },
{  1.563711E-02,   1.820442E-02,   4.343764E-02,   8.742377E-02,   1.091629E-01,   1.151506E-01, },
{  2.704968E-02,   3.559764E-02,   5.440482E-02,   8.009787E-02,   8.708649E-02,   1.104357E-01, },
{  1.410952E-02,   2.081970E-02,   4.536140E-02,   5.836404E-02,   9.395616E-02,   1.008095E-01, },
{  1.531255E-02,   1.889464E-02,   2.466303E-02,   4.217208E-02,   4.422734E-02,   1.008173E-01, },
{  1.082971E-02,   1.556793E-02,   2.553125E-02,   3.358139E-02,   1.089884E-01,   1.104306E-01, },
{  1.576337E-02,   2.112008E-02,   4.532982E-02,   5.332723E-02,   6.730361E-02,   7.472676E-02, },
{  2.180709E-02,   2.910514E-02,   4.754697E-02,   8.203667E-02,   9.182331E-02,   1.039495E-01, },
{  6.621230E-03,   9.533316E-03,   1.567027E-02,   3.007769E-02,   9.425495E-02,   9.967673E-02, },
{  1.464931E-02,   2.332903E-02,   6.464962E-02,   7.204189E-02,   9.536973E-02,   1.410298E-01, },
{  1.393632E-02,   2.054834E-02,   4.662026E-02,   5.575232E-02,   7.482363E-02,   8.711251E-02, },
{  8.758323E-03,   9.251885E-03,   4.288552E-02,   6.016100E-02,   6.863953E-02,   1.109609E-01, },
{  2.094302E-02,   2.742100E-02,   3.735355E-02,   4.356285E-02,   6.490756E-02,   9.802685E-02, },
{  1.400480E-02,   1.740425E-02,   4.695609E-02,   6.006256E-02,   8.208611E-02,   1.093717E-01, },
{  1.930245E-02,   2.456088E-02,   3.926039E-02,   5.554913E-02,   6.247940E-02,   7.590707E-02, },
{  1.687302E-02,   3.207367E-02,   1.080005E-01,   1.193308E-01,   1.185610E-01,   1.201404E-01, },
{  1.267945E-02,   1.716611E-02,   2.543628E-02,   3.855478E-02,   7.846043E-02,   9.574006E-02, },
{  1.734485E-02,   2.394049E-02,   5.141907E-02,   9.604980E-02,   1.584871E-01,   1.224827E-01, },
{  2.107694E-02,   3.141370E-02,   4.070751E-02,   6.492853E-02,   9.073921E-02,   9.431187E-02, },
{  1.482589E-02,   1.942447E-02,   3.194421E-02,   7.662051E-02,   8.986621E-02,   9.348818E-02, },
{  7.846413E-03,   9.513406E-03,   2.012508E-02,   3.033895E-02,   4.638605E-02,   6.595655E-02, },
{  1.397380E-02,   1.687131E-02,   4.325655E-02,   4.563284E-02,   1.135233E-01,   1.251338E-01, },
{  2.242911E-02,   2.968295E-02,   3.835522E-02,   6.497852E-02,   7.616106E-02,   8.098794E-02, },
{  1.310782E-02,   1.614793E-02,   5.396548E-02,   7.584178E-02,   8.140460E-02,   1.161651E-01, },
{  1.774685E-02,   2.490063E-02,   3.446746E-02,   5.893418E-02,   9.459517E-02,   1.073311E-01, },
{  1.066225E-02,   1.296222E-02,   3.959232E-02,   5.151627E-02,   9.650981E-02,   1.109332E-01, },
{  1.691014E-02,   2.881218E-02,   4.488787E-02,   6.077447E-02,   7.865074E-02,   8.268554E-02, },
{  1.175052E-02,   1.554532E-02,   2.666170E-02,   5.267510E-02,   8.335232E-02,   9.784005E-02, },
{  1.432988E-02,   1.742171E-02,   3.038908E-02,   5.089655E-02,   5.501435E-02,   1.093223E-01, },
{  2.234282E-02,   3.316874E-02,   4.143141E-02,   6.296199E-02,   1.004279E-01,   1.166677E-01, },
{  1.660246E-02,   2.267683E-02,   2.110983E-02,   4.362302E-02,   3.933736E-02,   3.660458E-02, },
{  4.739711E-02,   6.299704E-02,   8.299998E-02,   9.286358E-02,   1.014512E-01,   1.137900E-01, },
{  8.947307E-03,   9.023297E-03,   2.815413E-02,   5.334258E-02,   7.142524E-02,   9.446492E-02, },
{  7.407443E-03,   1.451424E-02,   5.707322E-02,   8.315843E-02,   9.203232E-02,   1.075463E-01, },
{  2.774402E-02,   3.602867E-02,   4.339630E-02,   7.072768E-02,   8.809414E-02,   9.320533E-02, },
{  1.624170E-02,   1.903670E-02,   4.992951E-02,   7.912172E-02,   8.415679E-02,   1.054177E-01, },
{  1.370928E-02,   1.903694E-02,   3.276609E-02,   4.549559E-02,   6.388518E-02,   7.726326E-02, },
{  1.550007E-02,   2.129879E-02,   3.638969E-02,   5.557910E-02,   9.568175E-02,   1.222585E-01, },
{  1.716324E-02,   2.657761E-02,   4.300665E-02,   4.959300E-02,   7.464716E-02,   8.216386E-02, },
{  2.561838E-02,   4.076767E-02,   4.747974E-02,   7.632811E-02,   1.115496E-01,   1.118715E-01, },
{  9.205919E-03,   6.119647E-03,   3.684157E-02,   3.635359E-02,   6.862369E-02,   1.107556E-01, },
{  1.702724E-02,   2.180624E-02,   4.643450E-02,   7.242612E-02,   1.135158E-01,   1.243776E-01, },
{  2.798908E-02,   3.531609E-02,   5.959610E-02,   6.633020E-02,   7.390208E-02,   1.083279E-01, },
{  1.332180E-02,   1.622935E-02,   6.025650E-02,   6.744980E-02,   7.398344E-02,   1.125091E-01, },
{  2.026706E-02,   2.397121E-02,   4.317534E-02,   4.990407E-02,   6.310951E-02,   1.146774E-01, },
{  1.397161E-02,   1.955844E-02,   2.677026E-02,   5.137222E-02,   7.926398E-02,   1.254107E-01, },
{  2.122141E-02,   3.224741E-02,   4.109677E-02,   5.408087E-02,   6.635696E-02,   8.053143E-02, },
{  9.321720E-03,   1.010414E-02,   6.548748E-02,   9.089755E-02,   9.804994E-02,   1.133397E-01, },
{  1.385278E-02,   1.813541E-02,   2.909483E-02,   4.779564E-02,   6.414149E-02,   1.000198E-01, },
{  2.004172E-02,   2.544068E-02,   6.278428E-02,   1.034667E-01,   1.077830E-01,   1.104905E-01, },
{  1.851682E-02,   2.299859E-02,   4.786814E-02,   7.832788E-02,   8.394481E-02,   1.000773E-01, },
{  1.669855E-02,   1.951802E-02,   5.047056E-02,   8.850464E-02,   9.443430E-02,   1.078356E-01, },
{  7.806336E-03,   7.582585E-03,   2.417730E-02,   3.850682E-02,   6.571728E-02,   8.374979E-02, },
{  1.392222E-02,   2.073464E-02,   2.896035E-02,   5.646798E-02,   1.490159E-01,   1.437590E-01, },
{  2.152306E-02,   2.635106E-02,   5.336282E-02,   6.868629E-02,   7.439274E-02,   7.450108E-02, },
{  1.204523E-02,   1.634082E-02,   7.249661E-02,   7.539285E-02,   8.619966E-02,   9.339899E-02, },
{  9.713203E-03,   1.256177E-02,   2.074491E-02,   5.703613E-02,   9.355055E-02,   1.093311E-01, },
{  1.591943E-02,   2.006401E-02,   3.007732E-02,   7.733424E-02,   1.166694E-01,   1.238210E-01, },
{  1.845095E-02,   3.691530E-02,   5.663943E-02,   7.042198E-02,   8.409772E-02,   9.380475E-02, },
{  1.564242E-02,   2.077319E-02,   3.899659E-02,   7.123853E-02,   8.132751E-02,   8.874550E-02, },
{  1.595952E-02,   1.864999E-02,   3.048374E-02,   3.471471E-02,   5.001536E-02,   1.194975E-01, },
{  2.144440E-02,   3.293250E-02,   4.379681E-02,   5.729870E-02,   8.877363E-02,   9.593644E-02, },
{  1.843583E-02,   2.950514E-02,   3.748840E-02,   4.912008E-02,   6.661154E-02,   6.974302E-02, },
{  1.426504E-02,   2.971794E-02,   1.140546E-01,   1.124929E-01,   9.568585E-02,   9.873397E-02, },
{  1.311363E-02,   1.738220E-02,   4.123707E-02,   6.258629E-02,   6.955480E-02,   7.686185E-02, },
{  1.127091E-02,   1.453179E-02,   1.578894E-02,   7.772853E-02,   1.061472E-01,   1.138087E-01, },
{  2.626770E-02,   3.347454E-02,   4.243782E-02,   7.658441E-02,   7.518777E-02,   9.182765E-02, },
{  1.225594E-02,   1.586557E-02,   3.745291E-02,   7.061746E-02,   8.896542E-02,   1.002527E-01, },
{  8.927349E-03,   1.176848E-02,   9.942472E-03,   3.360293E-02,   5.734500E-02,   9.506916E-02, },
{  9.101685E-03,   1.017148E-02,   1.947100E-02,   2.899673E-02,   1.143703E-01,   1.174388E-01, },
{  1.792335E-02,   2.628643E-02,   4.003911E-02,   5.448022E-02,   7.224550E-02,   9.016800E-02, },
{  1.799222E-02,   2.320675E-02,   4.502308E-02,   7.578284E-02,   9.122714E-02,   1.002122E-01, },
{  1.042575E-02,   1.423362E-02,   1.424013E-02,  -9.830125E-03,   6.760945E-02,   1.063956E-01, },
{  1.324361E-02,   2.734812E-02,   7.059836E-02,   8.092129E-02,   1.184749E-01,   1.188229E-01, },
{  2.349147E-02,   2.944021E-02,   4.926733E-02,   5.606457E-02,   6.573452E-02,   9.852327E-02, },
{  1.330456E-02,   1.792695E-02,   2.917120E-02,   6.311352E-02,   7.554723E-02,   9.962087E-02, },
{  1.860048E-02,   2.471291E-02,   3.886309E-02,   4.048495E-02,   6.046597E-02,   7.796476E-02, },
{  5.796139E-03,   2.671263E-03,   3.994569E-02,   6.402928E-02,   9.265896E-02,   1.015308E-01, },
{  2.439293E-02,   3.261954E-02,   4.500747E-02,   5.575331E-02,   6.069196E-02,   8.168970E-02, },
{  9.734107E-03,   1.553072E-02,   1.055976E-01,   1.149924E-01,   1.197701E-01,   1.305724E-01, },
{  1.102782E-02,   1.538942E-02,   1.401145E-02,   3.982878E-02,   8.129170E-02,   9.260337E-02, },
{  1.111254E-02,   1.362153E-02,   2.749068E-02,   9.794538E-02,   1.174043E-01,   1.240513E-01, },
{  2.265248E-02,   2.872608E-02,   4.169457E-02,   7.064226E-02,   7.966686E-02,   8.632394E-02, },
{  1.677627E-02,   2.048656E-02,   5.267737E-02,   7.855141E-02,   8.705654E-02,   9.326656E-02, },
{  8.749585E-03,   9.585666E-03,   2.639599E-02,   2.048716E-02,   3.200886E-02,   5.000599E-02, },
{  1.272519E-02,   1.766320E-02,   2.622571E-02,   6.513416E-02,   1.069834E-01,   1.276563E-01, },
{  2.189684E-02,   3.116973E-02,   4.115282E-02,   5.930227E-02,   7.347277E-02,   8.139128E-02, },
{  2.122909E-02,   2.462125E-02,   6.177166E-02,   9.295033E-02,   9.466185E-02,   1.189668E-01, },
{  1.008209E-02,   1.395559E-02,   1.763077E-02,   5.766147E-02,   1.034545E-01,   9.833443E-02, },
{  2.242399E-02,   2.968320E-02,   4.198881E-02,   8.100251E-02,   1.104241E-01,   1.137535E-01, },
{  3.430866E-02,   4.157231E-02,   5.200862E-02,   7.207436E-02,   7.611095E-02,   9.510172E-02, },
{  8.225203E-03,   2.646172E-02,   4.810114E-02,   5.408786E-02,   8.442562E-02,   8.787350E-02, },
{  1.299393E-02,   1.552483E-02,   3.777816E-02,   4.918366E-02,   5.879000E-02,   1.268083E-01, },
{  1.847924E-02,   2.844318E-02,   3.925803E-02,   5.630358E-02,   9.573017E-02,   1.176790E-01, },
{  1.395293E-02,   1.784008E-02,   3.651968E-02,   6.743067E-02,   5.268240E-02,   6.385001E-02, },
{  2.732660E-02,   4.604819E-02,   6.174632E-02,   1.130367E-01,   1.096790E-01,   1.191666E-01, },
{  1.062238E-02,   1.272666E-02,   2.655351E-02,   6.132423E-02,   7.971044E-02,   9.350007E-02, },
{  1.100936E-02,   1.550607E-02,   4.667465E-02,   8.301184E-02,   1.037604E-01,   1.097919E-01, },
{  3.049964E-02,   4.677598E-02,   5.755453E-02,   7.181891E-02,   8.182863E-02,   8.954516E-02, },
{  1.955513E-02,   2.344723E-02,   4.951376E-02,   8.484536E-02,   9.209087E-02,   1.036951E-01, },
{  1.950960E-02,   2.474458E-02,   3.391268E-02,   4.489760E-02,   5.263106E-02,   7.575303E-02, },
{  1.530754E-02,   2.080754E-02,   3.297257E-02,   5.645834E-02,   1.070897E-01,   1.244047E-01, },
{  1.710358E-02,   2.110494E-02,   6.040485E-02,   7.454502E-02,   7.944277E-02,   8.547102E-02, },
{  2.232754E-02,   3.270460E-02,   3.736605E-02,   5.794620E-02,   9.072865E-02,   1.090939E-01, },
{  9.119238E-03,   1.099410E-02,   1.624937E-02,   2.478341E-02,   8.528427E-02,   1.243111E-01, },
{  1.760340E-02,   2.798186E-02,   4.158148E-02,   5.183706E-02,   1.174682E-01,   1.338144E-01, },
{  2.739028E-02,   3.497185E-02,   4.807539E-02,   5.640921E-02,   6.276165E-02,   1.030446E-01, },
{  1.799089E-02,   2.150576E-02,   5.333967E-02,   6.807740E-02,   7.653545E-02,   1.065876E-01, },
{  1.538582E-02,   1.818708E-02,   3.816174E-02,   4.489460E-02,   6.269469E-02,   1.160894E-01, },
{  1.309859E-02,   1.619476E-02,   3.420315E-02,   7.486023E-02,   9.590028E-02,   1.155310E-01, },
{  1.563509E-02,   2.036917E-02,   4.362368E-02,   5.023553E-02,   5.833490E-02,   7.129235E-02, },
{  1.218768E-02,   1.968190E-02,   8.321258E-02,   8.938784E-02,   1.428977E-01,   1.435448E-01, },
{  1.079910E-02,   1.455196E-02,   2.797681E-02,   3.890403E-02,   7.541416E-02,   8.177247E-02, },
{  1.554339E-02,   1.852260E-02,   6.687989E-02,   1.161718E-01,   1.167415E-01,   1.221880E-01, },
{  1.478459E-02,   1.801471E-02,   4.764801E-02,   7.622182E-02,   8.023681E-02,   8.969499E-02, },
{  1.052079E-02,   1.174710E-02,   5.107736E-02,   6.830847E-02,   8.996201E-02,   9.177419E-02, },
{  1.536044E-03,   8.593575E-03,   2.627152E-02,   5.068293E-02,   6.786434E-02,   5.861022E-02, },
{  1.436968E-02,   1.713053E-02,   3.781892E-02,   7.438669E-02,   1.271869E-01,   1.339241E-01, },
{  2.010362E-02,   2.612399E-02,   3.350286E-02,   7.296919E-02,   7.511677E-02,   7.831064E-02, },
{  9.636811E-03,   1.573537E-02,   8.215805E-02,   7.088615E-02,   8.867266E-02,   1.188998E-01, },
{  1.155155E-02,   1.372160E-02,   1.335075E-02,   4.702937E-02,   7.709872E-02,   1.116277E-01, },
{  2.011055E-02,   2.642818E-02,   3.271788E-02,   6.084460E-02,   1.018536E-01,   1.206506E-01, },
{  2.961786E-02,   4.076309E-02,   4.917252E-02,   6.589685E-02,   6.629707E-02,   7.724146E-02, },
{  1.866485E-02,   2.538325E-02,   1.445812E-02,   6.572970E-02,   8.644153E-02,   9.247067E-02, },
{  1.643522E-02,   1.947476E-02,   3.653986E-02,   4.023791E-02,   7.278551E-02,   1.302477E-01, },
{  2.179911E-02,   2.776676E-02,   3.844598E-02,   6.754302E-02,   9.566121E-02,   1.043434E-01, },
{  2.095495E-02,   2.683494E-02,   3.130913E-02,   4.338745E-02,   6.225278E-02,   8.418869E-02, },
{  1.045012E-02,   4.621904E-02,   8.996192E-02,   9.455791E-02,   1.077489E-01,   1.137731E-01, },
{  1.570755E-02,   2.579912E-02,   2.597126E-02,   4.068256E-02,   6.401216E-02,   6.747222E-02, },
{  1.619469E-02,   1.870571E-02,   4.671076E-02,   9.378221E-02,   1.027357E-01,   1.092120E-01, },
{  4.009282E-02,   4.233134E-02,   6.631407E-02,   7.433956E-02,   8.197260E-02,   1.221306E-01, },
{  2.007734E-02,   3.062884E-02,   3.273709E-02,   5.895973E-02,   1.020398E-01,   1.072983E-01, },
{  1.472061E-02,   1.794642E-02,   2.979257E-02,   3.759512E-02,   5.629276E-02,   1.006823E-01, },
{  1.347547E-02,   1.825904E-02,   3.287771E-02,   4.119160E-02,   1.035832E-01,   1.132766E-01, },
{  1.508155E-02,   2.015553E-02,   3.804711E-02,   5.708145E-02,   6.441681E-02,   8.259794E-02, },
{  3.074109E-02,   3.764917E-02,   7.269148E-02,   1.020556E-01,   8.600576E-02,   9.783016E-02, },
{  3.371343E-03,  -3.197920E-04,   2.037311E-02,   1.292714E-02,   7.766175E-02,   9.880718E-02, },
{  1.323303E-02,   1.618691E-02,   4.726653E-02,   7.527808E-02,   9.938338E-02,   1.223063E-01, },
{  1.840537E-02,   3.169198E-02,   5.491208E-02,   6.451470E-02,   7.170613E-02,   8.538363E-02, },
{  1.556228E-02,   1.852325E-02,   3.626377E-02,   6.365859E-02,   6.919333E-02,   1.106793E-01, },
{  2.352478E-02,   2.869807E-02,   3.429586E-02,   5.491251E-02,   5.621874E-02,   9.672856E-02, },
{  8.983618E-03,   1.131668E-02,   5.523050E-02,   5.947902E-02,   8.216808E-02,   1.132449E-01, },
{  2.399935E-02,   3.471181E-02,   4.717349E-02,   5.313098E-02,   5.260551E-02,   6.043972E-02, },
{  2.133498E-02,   5.716271E-02,   1.184389E-01,   1.200471E-01,   1.189542E-01,   1.338608E-01, },
{  6.811771E-03,   9.630881E-03,   3.384033E-02,   4.809806E-02,   9.509526E-02,   9.811406E-02, },
{  1.298933E-02,   1.740321E-02,   6.819029E-02,   1.455544E-01,   1.252662E-01,   1.320285E-01, },
{  2.370536E-02,   3.020747E-02,   4.230115E-02,   7.187599E-02,   8.293665E-02,   9.349198E-02, },
{  2.018400E-02,   2.402838E-02,   3.322180E-02,   8.166001E-02,   9.288009E-02,   9.950165E-02, },
{  7.818039E-03,   1.136255E-02,  -1.281961E-03,   1.132940E-02,   5.969098E-02,   6.453270E-02, },
{  1.471413E-02,   1.980968E-02,   4.381753E-02,   5.296276E-02,   1.078819E-01,   1.398545E-01, },
{  1.512563E-02,   1.958633E-02,   4.051283E-02,   5.727385E-02,   8.039137E-02,   9.374186E-02, },
{  2.250312E-02,   2.736981E-02,   5.203422E-02,   7.406296E-02,   7.819079E-02,   1.065823E-01, },
{  1.483728E-02,   2.401470E-02,   2.580619E-02,   4.634131E-02,   9.322762E-02,   1.003972E-01, },
{  1.482669E-02,   1.791755E-02,   3.748254E-02,   6.510465E-02,   9.849043E-02,   1.134672E-01, },
{  2.352009E-02,   4.384816E-02,   5.510713E-02,   6.470485E-02,   8.379941E-02,   9.297448E-02, },
{  1.441303E-02,   2.060692E-02,   2.901056E-02,   5.944801E-02,   8.902651E-02,   9.860845E-02, },
{  1.192053E-02,   1.518188E-02,   3.854572E-02,   4.006546E-02,   5.067950E-02,   8.686898E-02, },
{  2.094153E-02,   3.433551E-02,   4.773771E-02,   5.411312E-02,   8.600418E-02,   1.068113E-01, },
{  1.392188E-02,   2.042500E-02,   2.748124E-02,   3.974135E-02,   5.524814E-02,   5.533823E-02, },
{  2.663646E-02,   7.425635E-02,   9.596237E-02,   9.274474E-02,   1.134584E-01,   1.364113E-01, },
{  3.867032E-03,   5.803127E-03,   2.887262E-02,   5.847437E-02,   7.897139E-02,   8.754519E-02, },
{  7.693186E-03,   9.177930E-03,   4.986922E-02,   1.047370E-01,   9.876424E-02,   1.041320E-01, },
{  2.226637E-02,   4.266775E-02,   5.928032E-02,   8.054599E-02,   8.568616E-02,   8.867234E-02, },
{  1.067421E-02,   1.750016E-02,   4.563706E-02,   6.705198E-02,   8.847706E-02,   1.017650E-01, },
{  1.096551E-02,   1.448285E-02,   3.337239E-02,   4.049550E-02,   4.576501E-02,   7.790931E-02, },
{  1.557200E-02,   2.127740E-02,   2.752759E-02,   4.897593E-02,   8.706324E-02,   1.170359E-01, },
{  4.658009E-03,   3.116453E-03,   4.483873E-02,   5.414321E-02,   6.274677E-02,   9.280898E-02, },
{  3.121119E-02,   3.982907E-02,   4.931892E-02,   7.999004E-02,   9.853307E-02,   1.014823E-01, },
{  1.253003E-02,   1.577948E-02,   2.279324E-02,   3.010948E-02,   6.718402E-02,   1.207042E-01, },
{  1.285623E-02,   1.561875E-02,   3.527222E-02,   6.648321E-02,   1.067436E-01,   1.238127E-01, },
{  1.935241E-02,   2.459510E-02,   5.247713E-02,   6.461671E-02,   7.638720E-02,   1.194878E-01, },
{  1.638084E-02,   2.551602E-02,   4.499814E-02,   5.524371E-02,   8.154253E-02,   1.026563E-01, },
{  1.856157E-02,   2.242445E-02,   5.309001E-02,   5.848944E-02,   5.861398E-02,   1.076048E-01, },
{  1.530388E-02,   1.908472E-02,   4.532496E-02,   6.478376E-02,   6.746827E-02,   1.412272E-01, },
{  2.256117E-02,   3.193459E-02,   4.180401E-02,   6.074430E-02,   6.703760E-02,   7.755833E-02, },
{  7.948651E-03,   9.999090E-03,   7.291212E-02,   9.624377E-02,   1.207044E-01,   1.526589E-01, },
{  1.290869E-02,   1.733416E-02,   2.876582E-02,   5.467818E-02,   6.799117E-02,   8.094031E-02, },
{  2.186960E-02,   3.713562E-02,   5.538446E-02,   9.514922E-02,   1.159804E-01,   9.791828E-02, },
{  1.974477E-02,   2.970192E-02,   5.701562E-02,   6.534646E-02,   7.521852E-02,   1.071081E-01, },
{  9.997164E-03,   1.327352E-02,   4.619017E-02,   6.945159E-02,   8.665682E-02,   1.068458E-01, },
{  1.000298E-02,   1.183381E-02,   1.591479E-02,   1.980916E-02,   6.534205E-02,   7.934827E-02, },
{  1.743860E-02,   2.549490E-02,   3.672470E-02,   5.266814E-02,   1.339835E-01,   1.718654E-01, },
{  2.384754E-02,   3.841133E-02,   4.405610E-02,   5.441187E-02,   7.391426E-02,   7.578908E-02, },
{  1.529037E-02,   2.031703E-02,   8.302731E-02,   9.868279E-02,   7.382987E-02,   9.044083E-02, },
{  9.498886E-03,   1.162757E-02,   3.538653E-02,   6.714149E-02,   1.000218E-01,   1.032125E-01, },
{  1.624407E-02,   2.201558E-02,   2.921004E-02,   6.823733E-02,   1.047385E-01,   1.116160E-01, },
{  2.654346E-02,   4.508181E-02,   5.127484E-02,   5.978295E-02,   6.737401E-02,   7.993594E-02, },
{  1.171906E-02,   1.574466E-02,   2.963462E-02,   7.480756E-02,   7.308786E-02,   7.811144E-02, },
{  2.306711E-02,   2.790416E-02,   3.976379E-02,   4.587048E-02,   6.854528E-02,   1.156816E-01, },
{  1.526309E-02,   3.381973E-02,   4.127626E-02,   4.535946E-02,   8.552431E-02,   9.259135E-02, },
{  1.920899E-02,   2.816750E-02,   3.047858E-02,   5.061642E-02,   5.737267E-02,   5.964818E-02, },
{  8.728478E-03,   1.602802E-02,   1.121923E-01,   9.614796E-02,   1.020787E-01,   1.256645E-01, },
{  1.340043E-02,   1.834433E-02,   2.818318E-02,   5.865609E-02,   8.035299E-02,   7.796843E-02, },
{  1.450107E-02,   1.732176E-02,   3.264306E-02,   7.953696E-02,   9.985061E-02,   1.061207E-01, },
{  2.670221E-02,   3.420285E-02,   5.108552E-02,   6.533193E-02,   7.249351E-02,   1.114690E-01, },
{  9.177726E-03,   1.308097E-02,   2.776736E-02,   8.403837E-02,   9.342735E-02,   1.031673E-01, },
{  1.155045E-02,   1.555367E-02,   2.677711E-02,   4.252499E-02,   5.882700E-02,   9.293993E-02, },
{  1.268490E-02,   2.016813E-02,   2.051894E-02,   3.865229E-02,   1.052577E-01,   1.230152E-01, },
{  1.806283E-02,   2.465310E-02,   5.799314E-02,   6.642219E-02,   6.398860E-02,   9.103245E-02, },
{  2.245169E-02,   2.753768E-02,   5.564948E-02,   8.550910E-02,   8.942751E-02,   9.807817E-02, },
{  6.939094E-03,   1.065195E-02,   1.860376E-02,  -4.732856E-03,   7.136740E-02,   7.723148E-02, },
{  6.229535E-03,   5.919501E-03,   6.231620E-02,   9.078528E-02,   1.239105E-01,   1.229570E-01, },
{  2.280886E-02,   3.858058E-02,   4.785368E-02,   5.716950E-02,   7.372174E-02,   8.360780E-02, },
{  1.465213E-02,   1.967087E-02,   2.804273E-02,   5.097373E-02,   7.495014E-02,   9.768220E-02, },
{  1.136805E-02,   1.388916E-02,   3.101383E-02,   5.688095E-02,   6.155951E-02,   8.672938E-02, },
{  6.687614E-03,   6.223236E-03,   5.052690E-02,   6.105727E-02,   9.410097E-02,   1.381369E-01, },
{  2.684098E-02,   4.194218E-02,   5.177096E-02,   5.736279E-02,   6.259237E-02,   6.896691E-02, },
{  1.449829E-02,   2.716935E-02,   9.941191E-02,   1.242856E-01,   1.405342E-01,   1.409914E-01, },
{  8.574665E-03,   1.087513E-02,   2.628288E-02,   4.587233E-02,   8.412548E-02,   9.170259E-02, },
{  1.412343E-02,   1.626386E-02,   3.413786E-02,   1.019740E-01,   1.107503E-01,   1.186436E-01, },
{  2.750210E-02,   3.378142E-02,   4.269944E-02,   8.178338E-02,   8.205062E-02,   9.015429E-02, },
{  1.436287E-02,   2.074994E-02,   4.503096E-02,   6.718099E-02,   8.684545E-02,   9.165085E-02, },
{  9.716318E-03,   1.129806E-02,   2.364368E-02,   4.918339E-02,   2.653440E-02,   6.592206E-02, },
{  1.884816E-02,   2.308384E-02,   3.294144E-02,   6.847513E-02,   1.009797E-01,   1.301696E-01, },
{  2.286748E-02,   2.730349E-02,   3.435752E-02,   7.028851E-02,   7.059550E-02,   8.467046E-02, },
{  1.635165E-02,   2.122921E-02,   5.091331E-02,   9.167393E-02,   1.028597E-01,   1.272909E-01, },
{  1.017377E-02,   1.491976E-02,   2.133428E-02,   5.798276E-02,   8.443021E-02,   8.558770E-02, },
{  1.460183E-02,   2.073223E-02,   5.080082E-02,   7.114033E-02,   1.056425E-01,   1.111843E-01, },
{  2.050320E-02,   3.217179E-02,   4.596412E-02,   6.483503E-02,   8.167420E-02,   8.973824E-02, },
{  1.487671E-02,   2.244821E-02,   3.970715E-02,   5.231930E-02,   9.333495E-02,   9.357676E-02, },
{  1.965716E-02,   2.335063E-02,   4.151801E-02,   5.524617E-02,   6.229937E-02,   1.058092E-01, },
{  1.944200E-02,   2.870941E-02,   3.301359E-02,   5.465472E-02,   8.652286E-02,   1.162796E-01, },
{  1.553518E-02,   2.061659E-02,   3.667101E-02,   5.154631E-02,   6.015941E-02,   6.791088E-02, },
{  1.952967E-02,   5.788021E-02,   7.557671E-02,   8.326265E-02,   1.019926E-01,   1.135880E-01, },
{  8.536062E-03,   7.239885E-03,   2.321343E-02,   4.430253E-02,   7.883027E-02,   8.287785E-02, },
{  2.065509E-02,   2.448000E-02,   3.673123E-02,   8.169222E-02,   1.021950E-01,   1.102860E-01, },
{  2.201062E-02,   4.512489E-02,   6.176856E-02,   6.737173E-02,   8.675215E-02,   9.735625E-02, },
{  1.779828E-02,   2.134089E-02,   4.078465E-02,   8.602714E-02,   1.010029E-01,   1.073731E-01, },
{  1.272718E-02,   1.676856E-02,   2.836548E-02,   4.583608E-02,   3.913139E-02,   6.118828E-02, },
{  1.204233E-02,   1.572443E-02,   3.239256E-02,   4.497214E-02,   1.037088E-01,   1.363748E-01, },
{  1.882379E-02,   2.233382E-02,   4.892731E-02,   7.335100E-02,   7.489855E-02,   8.206961E-02, },
{  2.086734E-02,   3.817604E-02,   4.938999E-02,   5.992583E-02,   9.214198E-02,   1.087651E-01, },
{  1.220596E-02,   1.696964E-02,   2.614102E-02,   3.921492E-02,   7.869226E-02,   1.150916E-01, },
{  1.541878E-02,   2.154877E-02,   2.722855E-02,   6.716368E-02,   1.209752E-01,   1.276564E-01, },
{  2.528765E-02,   3.361834E-02,   4.869484E-02,   6.985155E-02,   7.518045E-02,   1.037385E-01, },
{  2.171577E-02,   2.865864E-02,   4.366491E-02,   6.623344E-02,   7.271847E-02,   1.011112E-01, },
{  1.496722E-02,   1.841542E-02,   4.544643E-02,   5.748553E-02,   6.471466E-02,   1.139958E-01, },
{  2.063164E-02,   2.566604E-02,   4.407715E-02,   7.501540E-02,   8.062620E-02,   1.051506E-01, },
{  1.763169E-02,   2.473179E-02,   5.457448E-02,   6.175009E-02,   7.104986E-02,   7.652926E-02, },
{  8.037008E-03,   3.874894E-02,   1.070009E-01,   8.823013E-02,   1.188524E-01,   1.270676E-01, },
{  1.128582E-02,   1.464058E-02,   3.013888E-02,   3.761276E-02,   6.355113E-02,   8.255979E-02, },
{  8.813639E-03,   9.743391E-03,   4.768514E-02,   9.673334E-02,   1.091934E-01,   1.169322E-01, },
{  2.050932E-02,   2.473377E-02,   4.478461E-02,   7.695323E-02,   8.331868E-02,   9.224111E-02, },
{  7.783598E-03,   9.156605E-03,   3.891075E-02,   6.855569E-02,   8.002302E-02,   9.157219E-02, },
{  7.191617E-04,   3.431133E-03,   2.302044E-02,   4.669996E-02,   5.880043E-02,   7.563461E-02, },
{  1.293039E-02,   1.904603E-02,   2.601458E-02,   4.872895E-02,   1.224350E-01,   1.317470E-01, },
{  2.090718E-02,   3.227470E-02,   4.740544E-02,   6.113510E-02,   7.284956E-02,   7.928375E-02, },
{  1.619066E-02,   2.099928E-02,   6.070492E-02,   5.763042E-02,   8.794537E-02,   1.060232E-01, },
{  1.492572E-02,   2.099526E-02,   2.634824E-02,   4.831173E-02,   8.281038E-02,   1.051302E-01, },
{  1.586992E-02,   2.135378E-02,   2.593952E-02,   6.740353E-02,   1.100820E-01,   1.177115E-01, },
{  2.390420E-02,   3.840698E-02,   4.743241E-02,   6.854169E-02,   7.080520E-02,   8.774565E-02, },
{  1.423989E-02,   1.895399E-02,   3.291340E-02,   7.562146E-02,   8.919244E-02,   6.410746E-02, },
{  2.138437E-02,   2.551086E-02,   3.860922E-02,   4.075262E-02,   5.461093E-02,   1.341227E-01, },
{  2.233639E-02,   3.114054E-02,   4.578041E-02,   7.151920E-02,   9.392901E-02,   9.926005E-02, },
{  2.062722E-02,   2.570865E-02,   3.513499E-02,   3.823684E-02,   3.566584E-02,   8.118582E-02, },
{  8.955045E-03,   1.166258E-02,   9.179271E-02,   9.942281E-02,   1.078368E-01,   1.195057E-01, },
{  1.284398E-02,   1.706536E-02,   2.586056E-02,   6.014422E-02,   6.351044E-02,   7.085156E-02, },
{  1.398904E-02,   1.664043E-02,   3.486967E-02,   9.438733E-02,   1.105218E-01,   1.163475E-01, },
{  1.591188E-02,   4.105469E-02,   6.808043E-02,   7.860176E-02,   9.537904E-02,   1.112853E-01, },
{  1.684614E-02,   2.061633E-02,   3.762699E-02,   7.510386E-02,   9.468022E-02,   1.000412E-01, },
{  1.311694E-02,   1.561701E-02,   2.355469E-02,   1.824870E-02,   2.873295E-02,   1.094085E-01, },
{  1.190618E-02,   1.681286E-02,   2.740752E-02,   4.183846E-02,   9.771603E-02,   1.047206E-01, },
{  1.516442E-02,   2.036768E-02,   3.705029E-02,   4.672020E-02,   7.023918E-02,   8.537009E-02, },
{  2.911236E-02,   3.535819E-02,   4.175444E-02,   9.272050E-02,   9.406425E-02,   1.097566E-01, },
{ -1.761020E-05,  -1.854286E-03,   1.197604E-02,   3.490386E-02,   8.890644E-02,   1.007672E-01, },
{  1.433712E-02,   1.969422E-02,   4.996158E-02,   8.509464E-02,   9.483294E-02,   1.604944E-01, },
{  2.621614E-02,   3.572387E-02,   4.509404E-02,   5.305612E-02,   6.138136E-02,   8.984481E-02, },
{  1.132409E-02,   1.419806E-02,   3.928128E-02,   6.814754E-02,   7.966055E-02,   1.038929E-01, },
{  2.194649E-02,   3.026321E-02,   3.949850E-02,   4.773623E-02,   5.875377E-02,   8.599954E-02, },
{  1.536427E-02,   2.061768E-02,   4.845292E-02,   5.961266E-02,   9.824361E-02,   1.109931E-01, },
{  1.873916E-02,   3.080003E-02,   4.478670E-02,   4.803719E-02,   5.980126E-02,   6.423478E-02, },
{  1.252889E-02,   1.839948E-02,   9.835203E-02,   1.359044E-01,   9.917965E-02,   1.086786E-01, },
{  1.158098E-02,   1.513801E-02,   2.116881E-02,   2.748024E-02,   7.583544E-02,   9.736944E-02, },
{  1.156152E-02,   1.866218E-02,   6.447041E-02,   9.298393E-02,   1.392024E-01,   1.023491E-01, },
{  1.968105E-02,   2.513985E-02,   3.837521E-02,   7.083793E-02,   8.189347E-02,   9.513786E-02, },
{  1.609368E-02,   1.932043E-02,   3.909044E-02,   8.144689E-02,   8.791333E-02,   1.003541E-01, },
{  1.145783E-02,   1.622352E-02,   2.572385E-02,   2.888302E-02,   5.575769E-02,   7.060379E-02, },
{  1.649473E-02,   2.513433E-02,   4.265878E-02,   5.903698E-02,   1.024468E-01,   1.277951E-01, },
{  1.966739E-02,   2.696612E-02,   3.983889E-02,   6.535823E-02,   8.234109E-02,   8.962698E-02, },
{  1.202045E-02,   1.548668E-02,   5.795574E-02,   8.520279E-02,   8.852654E-02,   1.235741E-01, },
{  1.231940E-02,   1.617999E-02,   2.530684E-02,   4.948342E-02,   9.001706E-02,   1.070460E-01, },
{  1.328600E-02,   1.685423E-02,   3.673116E-02,   6.032882E-02,   8.085083E-02,   1.036504E-01, },
{  1.810037E-02,   3.416302E-02,   4.634240E-02,   5.569492E-02,   7.967522E-02,   8.529765E-02, },
{  1.134977E-02,   1.639684E-02,   3.401054E-02,   6.521585E-02,   9.190650E-02,   8.633030E-02, },
{  1.511517E-02,   1.799733E-02,   4.053402E-02,   4.579524E-02,   5.205211E-02,   1.099581E-01, },
{  2.231397E-02,   3.494103E-02,   4.268251E-02,   6.217641E-02,   1.009713E-01,   1.251215E-01, },
{  1.548379E-02,   1.964793E-02,   4.010969E-02,   5.265514E-02,   3.954133E-02,   5.275821E-02, },
{  1.986715E-02,   5.646308E-02,   1.029630E-01,   1.036828E-01,   1.073260E-01,   1.147098E-01, },
{  1.440078E-02,   1.829805E-02,   3.710253E-02,   5.198972E-02,   6.402480E-02,   9.078789E-02, },
{  5.586542E-03,   5.630434E-03,   3.899521E-02,   8.789331E-02,   9.719134E-02,   1.133463E-01, },
{  3.253646E-02,   4.283063E-02,   4.820789E-02,   7.828231E-02,   8.404305E-02,   9.128725E-02, },
{  2.034502E-02,   2.539416E-02,   3.880741E-02,   8.553068E-02,   9.402981E-02,   1.083012E-01, },
{  1.602536E-02,   2.084386E-02,   3.051091E-02,   5.521449E-02,   5.612074E-02,   7.846323E-02, },
{  1.245379E-02,   1.618886E-02,   3.024170E-02,   4.623642E-02,   1.023288E-01,   1.218591E-01, },
{  9.645765E-03,   1.134088E-02,   4.655281E-02,   6.503396E-02,   7.187021E-02,   8.727666E-02, },
{  2.253255E-02,   2.911011E-02,   4.676496E-02,   8.752730E-02,   1.064733E-01,   1.063567E-01, },
{  9.330584E-03,   8.944493E-03,   1.741974E-02,   4.210367E-02,   6.040140E-02,   1.076990E-01, },
{  1.707189E-02,   2.162706E-02,   3.825130E-02,   7.520610E-02,   1.115368E-01,   1.325846E-01, },
{  2.498237E-02,   3.349686E-02,   4.817551E-02,   6.190615E-02,   6.758707E-02,   1.115471E-01, },
{  7.693173E-03,   1.534359E-02,   5.419007E-02,   4.615197E-02,   7.802145E-02,   1.013523E-01, },
{  2.870108E-02,   3.634092E-02,   4.478399E-02,   5.000990E-02,   5.957998E-02,   1.172899E-01, },
{  1.389121E-02,   1.886393E-02,   3.596367E-02,   5.238487E-02,   8.164697E-02,   1.235713E-01, },
{  1.796861E-02,   2.793545E-02,   4.265724E-02,   5.642237E-02,   7.290686E-02,   7.984073E-02, },
{  6.165272E-03,   1.233165E-02,   8.444113E-02,   8.879394E-02,   1.032362E-01,   1.358392E-01, },
{  1.751720E-02,   2.124021E-02,   3.596410E-02,   4.771356E-02,   5.646011E-02,   9.912360E-02, },
{  1.547700E-02,   1.958381E-02,   5.801001E-02,   1.096928E-01,   8.336266E-02,   1.243110E-01, },
{  2.100264E-02,   2.574560E-02,   5.412842E-02,   7.533002E-02,   7.935150E-02,   9.633113E-02, },
{  1.551122E-02,   1.915788E-02,   4.184179E-02,   7.417878E-02,   8.237421E-02,   1.036722E-01, },
{  1.224817E-02,   1.593228E-02,   1.792129E-02,   3.397741E-02,   6.813254E-02,   6.556402E-02, },
{  1.159031E-02,   1.759555E-02,   5.108670E-02,   7.078053E-02,   1.294405E-01,   1.492765E-01, },
{  1.771407E-02,   2.455183E-02,   5.375426E-02,   5.912437E-02,   8.126567E-02,   8.439751E-02, },
{  1.824088E-02,   2.281758E-02,   6.227442E-02,   8.102935E-02,   8.551067E-02,   1.017574E-01, },
{  4.179908E-03,  -2.762453E-03,   2.418445E-02,   6.055324E-02,   9.167450E-02,   1.148192E-01, },
{  1.559755E-02,   1.886167E-02,   2.738089E-02,   8.174025E-02,   1.104767E-01,   1.147926E-01, },
{  2.228167E-02,   4.187582E-02,   5.462653E-02,   6.288394E-02,   7.296177E-02,   8.198875E-02, },
{  1.277298E-02,   1.722771E-02,   3.441982E-02,   6.864771E-02,   8.053993E-02,   9.456105E-02, },
{  1.737834E-02,   2.117309E-02,   2.916685E-02,   3.386080E-02,   6.825127E-02,   1.106563E-01, },
{  2.051604E-02,   3.254288E-02,   3.933957E-02,   6.040629E-02,   8.162270E-02,   9.340141E-02, },
{  2.091342E-02,   3.080663E-02,   3.960942E-02,   5.510752E-02,   5.831343E-02,   6.079024E-02, },
{  1.994793E-02,   4.828078E-02,   9.309632E-02,   9.708751E-02,   9.254253E-02,   9.148157E-02, },
{  1.881919E-02,   2.711143E-02,   2.876549E-02,   6.178218E-02,   7.494569E-02,   6.763395E-02, },
{  8.906414E-03,   1.173879E-02,   3.192403E-02,   7.742177E-02,   1.093307E-01,   1.051643E-01, },
{  2.820534E-02,   3.623979E-02,   5.195064E-02,   7.558792E-02,   7.974703E-02,   9.993019E-02, },
{  1.903235E-02,   2.525505E-02,   3.093719E-02,   6.622717E-02,   9.186785E-02,   9.881845E-02, },
{  7.415025E-03,   6.597229E-03,   1.984629E-02,   1.912643E-02,   4.491028E-02,   1.019085E-01, },
{  9.498753E-03,   1.114563E-02,   6.873898E-03,   3.764293E-02,   1.121659E-01,   1.094361E-01, },
{  2.061887E-02,   2.595708E-02,   3.762132E-02,   6.086574E-02,   6.858942E-02,   8.353516E-02, },
{  2.497460E-02,   3.308247E-02,   4.936177E-02,   7.825755E-02,   8.445405E-02,   1.045082E-01, },
{  7.597373E-03,   1.057203E-02,   5.933477E-03,  -3.273260E-03,   7.978280E-02,   9.728847E-02, },
{  1.058577E-02,   1.886465E-02,   6.002593E-02,   6.342305E-02,   1.104921E-01,   1.265372E-01, },
{  2.302043E-02,   2.666797E-02,   4.631398E-02,   4.770519E-02,   5.234165E-02,   9.077051E-02, },
{  1.024165E-02,   1.251414E-02,   3.141133E-02,   6.727887E-02,   6.825091E-02,   9.898287E-02, },
{  1.719696E-02,   2.240861E-02,   4.740598E-02,   5.395003E-02,   6.278338E-02,   8.978091E-02, },
{  3.654096E-03,   4.415175E-03,   4.950324E-02,   6.536126E-02,   9.951147E-02,   1.138780E-01, },
{  1.996215E-02,   3.540800E-02,   4.798105E-02,   5.505053E-02,   6.666118E-02,   7.591963E-02, },
{  8.030481E-03,   1.304748E-02,   8.708621E-02,   1.178092E-01,   1.137160E-01,   1.510715E-01, },
{  1.002594E-02,   1.268949E-02,   2.223281E-02,   4.064576E-02,   7.849725E-02,   9.593330E-02, },
{  1.549529E-02,   1.876282E-02,   2.973704E-02,   9.715081E-02,   1.251507E-01,   1.274535E-01, },
{  2.107903E-02,   2.938497E-02,   4.435376E-02,   7.622032E-02,   8.254489E-02,   8.023231E-02, },
{  1.166046E-02,   1.568410E-02,   3.393895E-02,   8.494941E-02,   8.193771E-02,   8.192688E-02, },
{  1.300173E-02,   1.824511E-02,   2.225135E-02,   2.606948E-02,   3.948467E-02,   8.081343E-02, },
{  1.218699E-02,   1.738186E-02,   1.964764E-02,   6.211364E-02,   1.175724E-01,   1.215212E-01, },
{  1.815164E-02,   2.385794E-02,   3.781433E-02,   6.318809E-02,   7.528239E-02,   7.949688E-02, },
{  2.090015E-02,   2.567020E-02,   6.730044E-02,   8.912025E-02,   9.466079E-02,   1.088322E-01, },
{  1.383303E-02,   1.951758E-02,   1.332347E-02,   6.068396E-02,   1.036593E-01,   1.073519E-01, },
{  2.010342E-02,   2.582834E-02,   4.177777E-02,   7.043779E-02,   1.018560E-01,   1.165980E-01, },
{  2.721694E-02,   3.647024E-02,   5.499028E-02,   7.378204E-02,   7.757968E-02,   8.264411E-02, },
{  2.121747E-02,   3.191525E-02,   3.735503E-02,   5.740886E-02,   8.093350E-02,   8.444119E-02, },
{  1.594924E-02,   1.911230E-02,   4.579085E-02,   5.381059E-02,   7.276539E-02,   1.098792E-01, },
{  1.690420E-02,   2.751299E-02,   4.153215E-02,   4.520013E-02,   1.009809E-01,   1.289608E-01, },
{  1.183859E-02,   1.654400E-02,   3.192209E-02,   6.446035E-02,   7.187176E-02,   6.234758E-02, },
{  1.577613E-02,   5.716901E-02,   7.445642E-02,   9.367424E-02,   1.268903E-01,   1.233605E-01, },
{  7.001652E-03,   8.710513E-03,   1.459395E-02,   6.796276E-02,   7.210871E-02,   8.184474E-02, },
{  1.367917E-02,   1.558312E-02,   2.872566E-02,   9.393050E-02,   1.028936E-01,   1.147333E-01, },
{  2.728060E-02,   4.888520E-02,   5.543847E-02,   6.424494E-02,   8.356433E-02,   8.664259E-02, },
{  2.009816E-02,   2.505305E-02,   4.802344E-02,   8.727456E-02,   9.568610E-02,   1.101500E-01, },
{  1.572786E-02,   2.171422E-02,   3.023720E-02,   4.209336E-02,   5.395622E-02,   7.625773E-02, },
{  1.437907E-02,   2.009067E-02,   1.993008E-02,   4.957626E-02,   1.017632E-01,   1.351654E-01, },
{  1.537046E-02,   2.125172E-02,   5.688990E-02,   7.208610E-02,   8.221379E-02,   6.600381E-02, },
{  1.841448E-02,   2.894096E-02,   5.027487E-02,   7.443822E-02,   1.005034E-01,   1.078382E-01, },
{  6.266807E-03,   5.780402E-03,   2.191185E-02,   1.986563E-02,   8.915054E-02,   1.117054E-01, },
{  2.328718E-02,   3.024352E-02,   3.571912E-02,   7.152741E-02,   1.157413E-01,   1.241848E-01, },
{  3.018517E-02,   3.614674E-02,   5.279391E-02,   6.672592E-02,   7.319556E-02,   9.791561E-02, },
{  1.520236E-02,   2.107226E-02,   4.219122E-02,   6.252956E-02,   7.824916E-02,   1.015041E-01, },
{  2.206445E-02,   2.630366E-02,   3.746872E-02,   4.085470E-02,   5.603856E-02,   1.201468E-01, },
{  1.442697E-02,   1.845104E-02,   2.488927E-02,   6.846813E-02,   8.617703E-02,   1.093911E-01, },
{  2.042649E-02,   2.990809E-02,   4.438132E-02,   6.607605E-02,   6.964072E-02,   5.880419E-02, },
{  1.329560E-02,   3.720956E-02,   8.807788E-02,   9.957019E-02,   1.206878E-01,   1.323209E-01, },
{  1.586589E-02,   2.190774E-02,   2.651558E-02,   5.181373E-02,   7.328216E-02,   7.494737E-02, },
{  1.309369E-02,   1.562961E-02,   5.585308E-02,   1.052936E-01,   1.088866E-01,   1.227673E-01, },
{  2.141978E-02,   2.547896E-02,   5.788724E-02,   6.940208E-02,   7.366081E-02,   8.412745E-02, },
{  8.260801E-03,   1.051398E-02,   3.739659E-02,   7.620624E-02,   8.733090E-02,   9.431524E-02, },
{  1.006735E-02,   1.381254E-02,   2.133789E-02,   5.594322E-02,   7.149754E-02,   7.313528E-02, },
{  1.435431E-02,   1.866912E-02,   2.771846E-02,   7.090147E-02,   1.143312E-01,   1.370063E-01, },
{  2.350827E-02,   3.302307E-02,   4.545939E-02,   7.009938E-02,   7.218733E-02,   7.695245E-02, },
{  1.234790E-02,   1.906054E-02,   7.706499E-02,   7.791933E-02,   9.402603E-02,   1.041908E-01, },
{  1.011209E-02,   1.180385E-02,   2.645735E-02,   4.095926E-02,   7.074231E-02,   1.049270E-01, },
{  1.464571E-02,   2.065853E-02,   2.695906E-02,   5.794560E-02,   9.805924E-02,   1.122967E-01, },
{  2.856206E-02,   4.234143E-02,   5.479452E-02,   6.747436E-02,   7.058305E-02,   8.513996E-02, },
{  1.197975E-02,   1.485327E-02,   2.796461E-02,   7.117215E-02,   7.569394E-02,   8.763968E-02, },
{  1.353941E-02,   1.509949E-02,   2.225774E-02,   2.172843E-02,   6.017898E-02,   1.351637E-01, },
{  1.800798E-02,   2.649268E-02,   4.506814E-02,   6.198959E-02,   8.765135E-02,   9.218795E-02, },
{  2.134211E-02,   2.789534E-02,   4.212850E-02,   5.127710E-02,   5.785788E-02,   7.804564E-02, },
{  1.236281E-02,   2.420221E-02,   8.861879E-02,   9.655615E-02,   1.148887E-01,   9.650159E-02, },
{  1.383048E-02,   1.908450E-02,   2.672127E-02,   4.824063E-02,   5.970953E-02,   7.102355E-02, },
{  1.684844E-02,   1.979451E-02,   3.851215E-02,   9.449255E-02,   1.039623E-01,   1.152428E-01, },
{  2.692179E-02,   3.447444E-02,   6.042144E-02,   6.354405E-02,   7.742282E-02,   1.344837E-01, },
{  1.960895E-02,   2.590655E-02,   3.045410E-02,   7.165352E-02,   1.001407E-01,   1.094606E-01, },
{  1.842527E-02,   2.178841E-02,   2.942565E-02,   3.659077E-02,   4.918254E-02,   1.057118E-01, },
{  9.954032E-03,   1.227639E-02,   2.879102E-02,   5.091325E-02,   1.134516E-01,   1.182354E-01, },
{  1.537565E-02,   2.007940E-02,   3.331252E-02,   5.883175E-02,   6.162786E-02,   7.470520E-02, },
{  2.903994E-02,   4.785432E-02,   5.153417E-02,   7.511055E-02,   9.430858E-02,   1.014823E-01, },
{  8.717011E-03,   1.260710E-02,   2.408422E-02,   1.403154E-02,   8.061927E-02,   9.231308E-02, },
{  1.197891E-02,   1.420568E-02,   3.498973E-02,   6.777179E-02,   1.035838E-01,   1.374600E-01, },
{  2.422762E-02,   3.001601E-02,   4.553860E-02,   6.553669E-02,   6.566284E-02,   8.324208E-02, },
{  1.629306E-02,   2.093706E-02,   3.882325E-02,   6.561878E-02,   5.141761E-02,   9.861604E-02, },
{  2.618454E-02,   3.195097E-02,   3.902538E-02,   4.496732E-02,   5.098064E-02,   9.087247E-02, },
{  8.043125E-03,   7.715969E-03,   4.130161E-02,   4.634281E-02,   7.861872E-02,   1.230556E-01, },
{  2.175397E-02,   3.391497E-02,   4.852179E-02,   5.601743E-02,   5.635830E-02,   7.771001E-02, },
{  4.401888E-02,   7.912847E-02,   1.256354E-01,   1.384011E-01,   1.427012E-01,   1.496054E-01, },
{  4.631868E-03,   4.313816E-03,   1.957007E-02,   3.187425E-02,   8.102398E-02,   8.963235E-02, },
{  1.988491E-02,   2.532103E-02,   3.575230E-02,   1.082089E-01,   1.256755E-01,   1.218207E-01, },
{  2.806638E-02,   3.670616E-02,   4.488455E-02,   6.944504E-02,   7.954485E-02,   8.874477E-02, },
{  2.205383E-02,   2.737888E-02,   4.288671E-02,   7.872037E-02,   9.127880E-02,   9.720778E-02, },
{  5.139630E-03,   3.363988E-03,   3.381327E-02,   6.753461E-03,   2.805012E-02,   8.078719E-02, },
{  1.732346E-02,   2.153420E-02,   3.678713E-02,   4.370644E-02,   9.010518E-02,   1.407950E-01, },
{  1.752107E-02,   2.356571E-02,   3.750403E-02,   6.387833E-02,   8.037478E-02,   8.773182E-02, },
{  1.991542E-02,   2.461885E-02,   4.923230E-02,   7.886521E-02,   8.035410E-02,   1.219791E-01, },
{  1.216301E-02,   1.725686E-02,   2.671229E-02,   4.049257E-02,   9.167572E-02,   9.695184E-02, },
{  1.298615E-02,   1.793400E-02,   4.010883E-02,   5.711711E-02,   1.005182E-01,   1.075548E-01, },
{  2.794773E-02,   4.169740E-02,   5.150544E-02,   6.300317E-02,   7.981770E-02,   8.726172E-02, },
{  1.708822E-02,   2.214230E-02,   3.293179E-02,   5.670769E-02,   7.982510E-02,   1.048445E-01, },
{  2.081073E-02,   2.514757E-02,   3.667451E-02,   5.005789E-02,   5.472966E-02,   1.078999E-01, },
{  1.564555E-02,   3.103829E-02,   5.208394E-02,   5.993908E-02,   9.330647E-02,   1.001528E-01, },
{  1.475030E-02,   1.976979E-02,   2.753966E-02,   5.571409E-02,   5.571654E-02,   6.212192E-02, },
{  2.540000E-02,   1.109660E-01,   1.243010E-01,   7.048500E-02,   7.175500E-02,   9.874200E-02, },
{  8.356157E-03,   6.942623E-03,   4.098197E-02,   5.196113E-02,   8.126926E-02,   8.736414E-02, },
{  1.465877E-02,   1.589760E-02,   6.099465E-02,   1.231368E-01,   8.014717E-02,   8.884873E-02, },
{  2.438193E-02,   4.052104E-02,   5.051652E-02,   7.682950E-02,   9.233534E-02,   9.555955E-02, },
{  1.624430E-02,   1.978774E-02,   4.331602E-02,   7.770738E-02,   7.888474E-02,   1.079453E-01, },
{  1.565929E-02,   2.007029E-02,   3.014859E-02,   3.310657E-02,   4.899913E-02,   8.520083E-02, },
{  1.326508E-02,   1.969602E-02,   2.480876E-02,   4.239437E-02,   9.081622E-02,   1.234142E-01, },
{  1.048302E-02,   1.970384E-02,   7.666807E-02,   5.380878E-02,   5.969105E-02,   7.923944E-02, },
{  2.502178E-02,   3.678102E-02,   4.251120E-02,   6.950245E-02,   9.765372E-02,   1.050306E-01, },
{  1.081341E-02,   1.302991E-02,   1.651499E-02,   2.056329E-02,   6.238823E-02,   1.035815E-01, },
{  1.641126E-02,   2.160063E-02,   3.133165E-02,   6.720576E-02,   1.027560E-01,   1.189162E-01, },
{  2.941074E-02,   3.648847E-02,   5.096251E-02,   5.875405E-02,   6.769179E-02,   1.200295E-01, },
{  1.372234E-02,   1.904085E-02,   3.387472E-02,   4.981538E-02,   8.776491E-02,   9.979058E-02, },
{  2.493880E-02,   3.100212E-02,   4.245989E-02,   4.861357E-02,   6.013642E-02,   1.023174E-01, },
{  1.678074E-02,   2.005457E-02,   4.524550E-02,   5.282503E-02,   7.822200E-02,   1.274504E-01, },
{  1.931154E-02,   2.853312E-02,   4.296141E-02,   5.385050E-02,   6.226518E-02,   7.508850E-02, },
{  1.446425E-02,   2.247232E-02,   7.714434E-02,   9.135953E-02,   1.071775E-01,   1.470091E-01, },
{  1.564133E-02,   1.946264E-02,   2.583724E-02,   6.480144E-02,   6.570606E-02,   9.400335E-02, },
{  1.704029E-02,   2.064519E-02,   5.461599E-02,   9.690039E-02,   1.033850E-01,   1.044560E-01, },
{  1.962386E-02,   2.514270E-02,   6.544063E-02,   6.964326E-02,   7.954278E-02,   9.244923E-02, },
{  1.347723E-02,   1.890079E-02,   5.467831E-02,   6.447194E-02,   7.699258E-02,   9.662570E-02, },
{  8.525596E-03,   1.192408E-02,  -2.276356E-03,   1.756824E-02,   7.971502E-02,   8.076035E-02, },
{  1.433495E-02,   1.926139E-02,   3.185936E-02,   8.777995E-02,   1.500492E-01,   1.656458E-01, },
{  2.238478E-02,   2.970941E-02,   4.335055E-02,   6.759135E-02,   7.294933E-02,   8.490516E-02, },
{  2.279121E-02,   3.420921E-02,   6.943406E-02,   8.313960E-02,   7.160605E-02,   9.297488E-02, },
{  9.793274E-03,   1.410074E-02,   2.266586E-02,   6.459888E-02,   9.382483E-02,   1.004214E-01, },
{  1.794714E-02,   2.218889E-02,   3.794623E-02,   7.745360E-02,   1.081674E-01,   1.147201E-01, },
{  2.272289E-02,   4.306323E-02,   5.624044E-02,   6.773741E-02,   7.744711E-02,   8.576053E-02, },
{  1.299560E-02,   1.634545E-02,   4.432876E-02,   7.003776E-02,   7.568491E-02,   7.770209E-02, },
{  1.967214E-02,   2.536679E-02,   3.726346E-02,   4.202616E-02,   8.057429E-02,   1.070165E-01, },
{  1.883922E-02,   2.748246E-02,   3.834353E-02,   5.853973E-02,   9.189871E-02,   1.004521E-01, },
{  1.593033E-02,   2.134345E-02,   3.093617E-02,   4.584718E-02,   5.439078E-02,   6.382211E-02, },
{  1.440162E-02,   4.469713E-02,   9.677333E-02,   7.693892E-02,   9.503974E-02,   1.174393E-01, },
{  1.675656E-02,   2.356289E-02,   3.571539E-02,   5.646564E-02,   7.020168E-02,   7.805370E-02, },
{  1.475726E-02,   1.742735E-02,   3.463308E-02,   8.822747E-02,   1.062116E-01,   1.102208E-01, },
{  2.598650E-02,   3.361722E-02,   5.518528E-02,   7.373677E-02,   7.991530E-02,   1.136490E-01, },
{  1.493318E-02,   2.021036E-02,   2.840172E-02,   7.132426E-02,   9.424514E-02,   1.014458E-01, },
{  1.418929E-02,   1.734186E-02,   3.210269E-02,   4.726307E-02,   5.110744E-02,   8.718623E-02, },
{  1.207583E-02,   1.699930E-02,   2.720679E-02,   3.490423E-02,   1.154720E-01,   1.251752E-01, },
{  1.398967E-02,   1.757398E-02,   4.299816E-02,   5.305115E-02,   4.964308E-02,   8.090326E-02, },
{  2.032301E-02,   3.793666E-02,   5.419656E-02,   7.843951E-02,   9.421813E-02,   1.034499E-01, },
{  4.799204E-03,  -1.027899E-03,   1.206993E-02,   1.526902E-02,   5.515609E-02,   8.636779E-02, },
{  9.447182E-03,   1.084177E-02,   5.408564E-02,   7.579217E-02,   1.109150E-01,   1.173514E-01, },
{  2.708500E-02,   3.718907E-02,   5.294084E-02,   5.794316E-02,   6.459495E-02,   8.921185E-02, },
{  1.255941E-02,   1.673973E-02,   2.829886E-02,   5.243008E-02,   7.873495E-02,   8.856669E-02, },
{  1.919363E-02,   2.352040E-02,   3.791475E-02,   5.402071E-02,   5.931153E-02,   8.643736E-02, },
{  1.373559E-02,   1.721084E-02,   5.496369E-02,   6.517555E-02,   9.219778E-02,   1.235371E-01, },
{  2.069835E-02,   3.333731E-02,   4.579376E-02,   5.761477E-02,   6.498900E-02,   6.874965E-02, },
{  9.491142E-03,   3.478718E-02,   1.359202E-01,   1.341335E-01,   1.407470E-01,   1.551626E-01, },
{  1.234982E-02,   1.643816E-02,   2.766869E-02,   4.804917E-02,   8.878672E-02,   9.244449E-02, },
{  1.465494E-02,   1.699790E-02,   3.268575E-02,   1.027723E-01,   1.162926E-01,   1.125889E-01, },
{  2.046226E-02,   2.563195E-02,   5.276975E-02,   9.020744E-02,   9.509142E-02,   7.511153E-02, },
{  1.847053E-02,   3.000312E-02,   5.641485E-02,   7.050432E-02,   8.783666E-02,   8.895542E-02, },
{  1.261945E-02,   1.389840E-02,   3.154468E-02,   4.653074E-02,   1.783118E-03,   8.694508E-02, },
{  1.424654E-02,   1.923119E-02,   2.497837E-02,   6.234127E-02,   1.052243E-01,   1.225190E-01, },
{  1.830878E-02,   2.500746E-02,   4.468678E-02,   7.105059E-02,   8.083325E-02,   8.821615E-02, },
{  1.573293E-02,   2.351451E-02,   7.221704E-02,   8.629748E-02,   9.875100E-02,   1.234404E-01, },
{  6.547524E-03,   1.016849E-02,   6.536401E-03,   6.535678E-02,   8.952584E-02,   9.761936E-02, },
{  1.710742E-02,   2.213298E-02,   3.950528E-02,   7.007205E-02,   1.032119E-01,   1.080360E-01, },
{  2.352424E-02,   3.917277E-02,   4.935594E-02,   6.595606E-02,   8.429364E-02,   9.133154E-02, },
{  1.140674E-02,   1.495722E-02,   4.080821E-02,   5.160682E-02,   7.531045E-02,   8.166180E-02, },
{  1.271983E-02,   1.623484E-02,   4.234032E-02,   5.564689E-02,   6.966655E-02,   1.051876E-01, },
{  1.599213E-02,   2.449233E-02,   4.567000E-02,   5.871967E-02,   8.956748E-02,   1.172570E-01, },
{  1.930774E-02,   2.399247E-02,   4.300584E-02,   5.562012E-02,   5.404434E-02,   6.962171E-02, },
{  3.934798E-02,   5.472530E-02,   6.562281E-02,   7.619655E-02,   9.538361E-02,   1.102524E-01, },
{  3.502156E-03,   2.931166E-03,   1.308703E-02,   5.506205E-02,   7.290967E-02,   8.298626E-02, },
{  1.655326E-02,   1.946578E-02,   3.895758E-02,   8.771968E-02,   9.517211E-02,   1.035028E-01, },
{  1.973851E-02,   3.659956E-02,   4.824506E-02,   6.048141E-02,   8.560514E-02,   9.627345E-02, },
{  2.137525E-02,   2.752568E-02,   4.674464E-02,   8.707046E-02,   9.298479E-02,   1.172247E-01, },
{  1.699155E-02,   2.223320E-02,   2.361702E-02,   4.246245E-02,   4.685692E-02,   7.597940E-02, },
{  1.567585E-02,   2.118400E-02,   3.085418E-02,   4.799395E-02,   9.564142E-02,   1.303839E-01, },
{  1.835719E-02,   2.174804E-02,   4.773516E-02,   6.912734E-02,   7.009360E-02,   7.539675E-02, },
{  2.172008E-02,   2.902312E-02,   4.431384E-02,   6.906790E-02,   1.003369E-01,   1.014787E-01, },
{  1.090453E-02,   1.601957E-02,   2.347860E-02,   2.702867E-02,   8.662541E-02,   1.079974E-01, },
{  1.384770E-02,   1.997406E-02,   3.401456E-02,   6.719957E-02,   1.301361E-01,   1.180674E-01, },
{  2.462159E-02,   3.476520E-02,   5.040969E-02,   6.169565E-02,   7.046475E-02,   9.207647E-02, },
{  1.314941E-02,   1.639913E-02,   3.608584E-02,   6.047748E-02,   6.812324E-02,   1.031916E-01, },
{  2.239567E-02,   2.775489E-02,   5.486096E-02,   5.370956E-02,   6.916674E-02,   1.278935E-01, },
{  1.703454E-02,   2.047219E-02,   4.119687E-02,   7.029995E-02,   7.475601E-02,   1.199532E-01, },
{  1.806514E-02,   2.307528E-02,   5.177036E-02,   6.161942E-02,   6.159787E-02,   7.054174E-02, },
{  1.453431E-02,   2.296042E-02,   8.897572E-02,   9.237062E-02,   1.097047E-01,   1.240955E-01, },
{  1.312902E-02,   1.800782E-02,   2.667081E-02,   3.910588E-02,   7.013735E-02,   8.738370E-02, },
{  1.468422E-02,   1.718226E-02,   4.877216E-02,   9.862047E-02,   1.049419E-01,   1.158774E-01, },
{  1.631475E-02,   2.028370E-02,   3.929835E-02,   7.235549E-02,   7.526462E-02,   9.268711E-02, },
{  6.776016E-03,   7.293253E-03,   2.597095E-02,   7.232245E-02,   7.924933E-02,   1.025273E-01, },
{ -3.172375E-03,  -5.790930E-03,   2.293219E-02,   3.711039E-02,   7.212306E-02,   7.659391E-02, },
{  1.232182E-02,   1.891504E-02,   2.596884E-02,   4.198169E-02,   1.174141E-01,   1.455406E-01, },
{  1.753131E-02,   2.919450E-02,   4.714086E-02,   5.744911E-02,   6.578999E-02,   7.939213E-02, },
{  1.105186E-02,   1.640055E-02,   5.855621E-02,   6.863516E-02,   1.003645E-01,   1.105921E-01, },
{  1.447234E-02,   1.762728E-02,   3.394504E-02,   4.695668E-02,   8.612069E-02,   1.130594E-01, },
{  1.015546E-02,   1.406789E-02,   1.536133E-02,   7.041996E-02,   9.582874E-02,   1.265419E-01, },
{  2.750642E-02,   3.281520E-02,   5.708392E-02,   6.048051E-02,   6.596222E-02,   8.125960E-02, },
{  1.442310E-02,   1.987189E-02,   3.148611E-02,   6.903538E-02,   8.405726E-02,   8.318180E-02, },
{  2.213064E-02,   2.668277E-02,   4.430215E-02,   4.619871E-02,   6.846063E-02,   1.380130E-01, },
{  2.389136E-02,   3.751652E-02,   4.433405E-02,   7.044938E-02,   8.999150E-02,   9.717633E-02, },
{  2.038237E-02,   2.660964E-02,   3.738104E-02,   4.502429E-02,   5.176268E-02,   8.774910E-02, },
{  5.407670E-03,   7.669280E-03,   8.095613E-02,   1.035703E-01,   9.476902E-02,   1.139914E-01, },
{  1.133998E-02,   1.477670E-02,   2.629656E-02,   4.556369E-02,   5.950111E-02,   7.981666E-02, },
{  1.276451E-02,   1.525862E-02,   2.850702E-02,   8.506246E-02,   1.137642E-01,   1.175337E-01, },
{  2.399251E-02,   2.936397E-02,   6.291426E-02,   7.901232E-02,   8.355970E-02,   1.081408E-01, },
{  1.454466E-02,   1.824439E-02,   4.766233E-02,   7.039310E-02,   9.581260E-02,   9.738025E-02, },
{  1.670847E-02,   2.007454E-02,   3.332061E-02,   3.910476E-02,   4.047330E-02,   1.040292E-01, },
{  1.177367E-02,   1.636311E-02,   2.517579E-02,   4.598691E-02,   1.009155E-01,   1.130767E-01, },
{  1.511697E-02,   2.035882E-02,   4.223660E-02,   5.471331E-02,   7.757046E-02,   7.424962E-02, },
{  2.369149E-02,   3.112579E-02,   3.970981E-02,   7.907734E-02,   8.691142E-02,   1.081090E-01, },
{  8.849379E-03,   1.296352E-02,  -1.466606E-04,   3.040950E-02,   9.666959E-02,   1.039090E-01, },
{  1.162835E-02,   1.628573E-02,   6.366351E-02,   7.708903E-02,   9.765091E-02,   1.378701E-01, },
};
static float cbb_new3[VECSIZEb_NEW][VECDIMb_NEW] = {
{  1.028946E-01,   1.429001E-01,   1.690572E-01,   1.732624E-01, },
{  1.202891E-01,   1.358667E-01,   1.783948E-01,   1.797000E-01, },
{  1.046043E-01,   1.279615E-01,   1.517462E-01,   1.549688E-01, },
{  1.219325E-01,   1.483746E-01,   1.585376E-01,   1.631185E-01, },
{  7.866949E-02,   8.595246E-02,   1.397013E-01,   1.667717E-01, },
{  1.301067E-01,   1.466079E-01,   1.516102E-01,   1.578570E-01, },
{  1.134451E-01,   1.224300E-01,   1.332093E-01,   1.468314E-01, },
{  1.238168E-01,   1.315865E-01,   1.575402E-01,   1.650747E-01, },
{  1.009568E-01,   1.167480E-01,   1.557529E-01,   1.650461E-01, },
{  1.687751E-01,   1.700358E-01,   1.721783E-01,   1.775260E-01, },
{  1.132635E-01,   1.294658E-01,   1.350492E-01,   1.670164E-01, },
{  1.138025E-01,   1.382233E-01,   1.456656E-01,   1.551468E-01, },
{  9.340192E-02,   1.079911E-01,   1.440780E-01,   1.534684E-01, },
{  1.387070E-01,   1.588183E-01,   1.682713E-01,   1.720211E-01, },
{  1.237252E-01,   1.276098E-01,   1.311874E-01,   1.425099E-01, },
{  1.125187E-01,   1.190763E-01,   1.694397E-01,   1.766393E-01, },
{  9.352287E-02,   1.406467E-01,   1.544965E-01,   1.602719E-01, },
{  1.322105E-01,   1.431098E-01,   1.668036E-01,   1.750401E-01, },
{  1.096195E-01,   1.324317E-01,   1.484282E-01,   1.613644E-01, },
{  1.239595E-01,   1.409094E-01,   1.470458E-01,   1.572686E-01, },
{  8.433813E-02,   1.083855E-01,   1.580322E-01,   1.662142E-01, },
{  1.400675E-01,   1.452530E-01,   1.619088E-01,   1.691324E-01, },
{  9.007670E-02,   1.259605E-01,   1.319836E-01,   1.462214E-01, },
{  1.278968E-01,   1.350451E-01,   1.661980E-01,   1.719272E-01, },
{  1.016506E-01,   1.204853E-01,   1.663802E-01,   1.712871E-01, },
{  1.392849E-01,   1.427271E-01,   1.895724E-01,   1.909042E-01, },
{  1.110312E-01,   1.189064E-01,   1.480765E-01,   1.586512E-01, },
{  1.304127E-01,   1.350912E-01,   1.446692E-01,   1.615949E-01, },
{  1.059663E-01,   1.185289E-01,   1.343831E-01,   1.557215E-01, },
{  1.523558E-01,   1.584233E-01,   1.576702E-01,   1.644879E-01, },
{  1.077938E-01,   1.139043E-01,   1.172091E-01,   1.547683E-01, },
{  1.158996E-01,   1.260214E-01,   1.540011E-01,   1.706774E-01, },
{  8.598196E-02,   1.340990E-01,   1.660513E-01,   1.714258E-01, },
{  1.204801E-01,   1.512455E-01,   1.672835E-01,   1.708365E-01, },
{  9.196066E-02,   1.277497E-01,   1.455189E-01,   1.586575E-01, },
{  1.111267E-01,   1.451867E-01,   1.543033E-01,   1.638313E-01, },
{  9.053543E-02,   9.711701E-02,   1.448142E-01,   1.663028E-01, },
{  1.390226E-01,   1.421330E-01,   1.504011E-01,   1.618296E-01, },
{  1.143608E-01,   1.291879E-01,   1.411417E-01,   1.524363E-01, },
{  1.282901E-01,   1.331767E-01,   1.547906E-01,   1.729154E-01, },
{  1.054598E-01,   1.064779E-01,   1.534063E-01,   1.684881E-01, },
{  1.492138E-01,   1.669245E-01,   1.833990E-01,   1.813288E-01, },
{  1.190870E-01,   1.219872E-01,   1.402428E-01,   1.662979E-01, },
{  1.245782E-01,   1.352989E-01,   1.408846E-01,   1.481753E-01, },
{  9.464782E-02,   1.013755E-01,   1.247584E-01,   1.563693E-01, },
{  1.512695E-01,   1.532475E-01,   1.667209E-01,   1.735275E-01, },
{  1.234004E-01,   1.358001E-01,   1.258594E-01,   1.512631E-01, },
{  1.207495E-01,   1.274543E-01,   1.660312E-01,   1.728560E-01, },
{  1.014935E-01,   1.315258E-01,   1.570202E-01,   1.687510E-01, },
{  1.401947E-01,   1.419451E-01,   1.709453E-01,   1.751982E-01, },
{  1.171856E-01,   1.359765E-01,   1.533801E-01,   1.594169E-01, },
{  1.270418E-01,   1.380499E-01,   1.535557E-01,   1.625633E-01, },
{  6.995779E-02,   1.247152E-01,   1.440217E-01,   1.570551E-01, },
{  1.318954E-01,   1.410221E-01,   1.596246E-01,   1.666262E-01, },
{  1.003133E-01,   1.340955E-01,   1.415070E-01,   1.474043E-01, },
{  1.187883E-01,   1.383332E-01,   1.621059E-01,   1.690763E-01, },
{  9.095367E-02,   1.051201E-01,   1.724481E-01,   1.770562E-01, },
{  1.327819E-01,   1.506402E-01,   1.802915E-01,   1.795952E-01, },
{  1.187037E-01,   1.230887E-01,   1.551124E-01,   1.618775E-01, },
{  1.223993E-01,   1.305190E-01,   1.439494E-01,   1.607284E-01, },
{  1.049620E-01,   1.102881E-01,   1.359525E-01,   1.650455E-01, },
{  1.387640E-01,   1.522843E-01,   1.571966E-01,   1.656725E-01, },
{  1.079475E-01,   1.191716E-01,   1.186914E-01,   1.303933E-01, },
{  1.105329E-01,   1.321016E-01,   1.612938E-01,   1.649749E-01, },
};
#endif //NEWMALSPVQ3
static float cba_new[VECSIZEa_NEW][VECDIMa_NEW] = {

{1.27351877e-01, 1.54915063e-01, 2.40385964e-01, 3.46707599e-01, 3.74569016e-01, 5.04600067e-01},
{8.53451388e-02, 1.15979739e-01, 2.07150300e-01, 3.50751230e-01, 4.31883836e-01, 4.61029562e-01},
{1.30065524e-01, 1.58868697e-01, 2.14261117e-01, 2.44850792e-01, 3.23100621e-01, 5.31306839e-01},
{1.10725491e-01, 1.51281118e-01, 2.18654624e-01, 3.25166114e-01, 5.03173195e-01, 5.81156506e-01},
{1.25835058e-01, 1.65148930e-01, 2.49201223e-01, 2.97347950e-01, 3.40676102e-01, 4.40307995e-01},
{1.20148849e-01, 2.24846838e-01, 3.07730919e-01, 3.74095103e-01, 5.20503290e-01, 5.73713538e-01},
{8.16405360e-02, 1.16659052e-01, 2.19868792e-01, 2.90231902e-01, 4.11112590e-01, 5.36517834e-01},
{8.85279770e-02, 1.01836543e-01, 1.93536114e-01, 4.69664495e-01, 5.81217206e-01, 6.01025022e-01},
{1.09877623e-01, 1.78742401e-01, 2.33391734e-01, 3.15466576e-01, 4.15405930e-01, 4.64498782e-01},
{8.46931125e-02, 1.04288467e-01, 2.27806392e-01, 3.40477635e-01, 3.76830065e-01, 5.10908923e-01},
{9.08851764e-02, 1.25407281e-01, 1.57843668e-01, 2.38000760e-01, 3.31419400e-01, 4.28270482e-01},
{9.18712729e-02, 1.16147347e-01, 2.02804190e-01, 4.09019324e-01, 5.56329913e-01, 5.81001043e-01},
{9.79325727e-02, 1.52705630e-01, 2.12395130e-01, 2.89285638e-01, 3.95875115e-01, 4.35380265e-01},
{1.26798291e-01, 1.69674490e-01, 2.44331061e-01, 3.95123272e-01, 4.20458857e-01, 5.13805154e-01},
{7.97519257e-02, 1.14096573e-01, 1.53679410e-01, 3.34218505e-01, 4.75168607e-01, 4.97924593e-01},
{6.91104672e-02, 9.48376020e-02, 2.52157267e-01, 3.72275474e-01, 4.31614043e-01, 5.10963046e-01},
{1.48274432e-01, 2.04038851e-01, 2.54964674e-01, 3.46833903e-01, 3.89563307e-01, 4.34536339e-01},
{6.61009810e-02, 9.27384185e-02, 1.76977006e-01, 3.17124840e-01, 4.46072613e-01, 4.92506448e-01},
{9.37563349e-02, 1.15653358e-01, 2.07971506e-01, 2.61552812e-01, 3.29625661e-01, 4.91479878e-01},
{1.09760834e-01, 1.33010150e-01, 1.81333976e-01, 4.10238389e-01, 5.19420745e-01, 5.53877881e-01},
{9.84091012e-02, 1.47631717e-01, 1.98152781e-01, 2.65604722e-01, 3.21512930e-01, 3.70911773e-01},
{1.48962521e-01, 1.95450004e-01, 2.35593331e-01, 3.75395081e-01, 4.82143990e-01, 5.04479585e-01},
{7.55164012e-02, 1.00525015e-01, 1.76651777e-01, 3.29981865e-01, 3.72861952e-01, 4.61358334e-01},
{7.28093054e-02, 9.00759840e-02, 1.96826629e-01, 4.12457023e-01, 4.64359884e-01, 5.19951453e-01},
{1.23301822e-01, 1.84830664e-01, 2.45167900e-01, 3.52901814e-01, 4.28231184e-01, 4.58100508e-01},
{1.12102913e-01, 1.35616633e-01, 2.71355920e-01, 3.86453231e-01, 4.11560203e-01, 5.14807488e-01},
{9.27468959e-02, 1.29450719e-01, 1.66803561e-01, 2.67954849e-01, 3.19980471e-01, 3.77046060e-01},
{7.95750241e-02, 1.13819852e-01, 1.81264411e-01, 2.97675020e-01, 4.15824281e-01, 5.74836397e-01},
{9.26432305e-02, 1.24703017e-01, 2.46234840e-01, 3.15135936e-01, 3.87877109e-01, 4.32816151e-01},
{9.30659067e-02, 1.32253635e-01, 1.87294837e-01, 3.07617589e-01, 4.87782818e-01, 5.40722705e-01},
{7.00868883e-02, 9.54517332e-02, 1.40540230e-01, 2.27287415e-01, 3.78744131e-01, 5.17496300e-01},
{1.27285808e-01, 1.65075426e-01, 2.35817227e-01, 4.09162441e-01, 4.72650323e-01, 5.02265551e-01},
{1.31722793e-01, 1.68388313e-01, 2.66946253e-01, 3.38886185e-01, 3.72847855e-01, 5.46999608e-01},
{9.54214447e-02, 1.24934492e-01, 2.42028893e-01, 3.11709494e-01, 4.34876341e-01, 4.83959485e-01},
{1.22899727e-01, 1.51861725e-01, 2.22634856e-01, 2.63072418e-01, 3.32717658e-01, 5.78320858e-01},
{9.51762945e-02, 1.35053369e-01, 1.79863236e-01, 2.67345369e-01, 4.59564006e-01, 5.69932787e-01},
{1.36639628e-01, 1.62605996e-01, 2.57605851e-01, 3.13292283e-01, 3.60927640e-01, 4.65759109e-01},
{6.39159865e-02, 1.10352927e-01, 3.32054083e-01, 3.95205376e-01, 4.44994594e-01, 4.94532912e-01},
{7.30994992e-02, 9.30788488e-02, 1.95459078e-01, 2.98536994e-01, 3.48043730e-01, 5.08508478e-01},
{7.95553198e-02, 9.37961210e-02, 2.34696147e-01, 4.47069572e-01, 5.33724558e-01, 5.61493186e-01},
{1.02707157e-01, 1.20949182e-01, 3.10050105e-01, 3.71346176e-01, 4.04324957e-01, 4.53567527e-01},
{6.89505103e-02, 9.20123714e-02, 1.84067393e-01, 3.49148205e-01, 4.24901612e-01, 4.86069151e-01},
{9.02694139e-02, 1.17292740e-01, 2.03333553e-01, 2.82857372e-01, 3.14884425e-01, 4.51562032e-01},
{8.79584023e-02, 1.20326116e-01, 1.71072933e-01, 3.61191430e-01, 5.50827161e-01, 5.95818769e-01},
{1.11201759e-01, 1.83110332e-01, 2.54895745e-01, 3.19389817e-01, 3.79136828e-01, 4.29356697e-01},
{1.21527408e-01, 1.49990372e-01, 2.21685285e-01, 3.80318212e-01, 4.49603023e-01, 4.73038280e-01},
{6.46922303e-02, 8.20741312e-02, 1.55492781e-01, 3.21995247e-01, 4.82204909e-01, 5.31397294e-01},
{9.01329664e-02, 1.16948722e-01, 3.10919236e-01, 4.10927431e-01, 4.53380025e-01, 5.72327882e-01},
{9.44250690e-02, 1.89696395e-01, 2.98196368e-01, 3.32790672e-01, 3.90401765e-01, 4.32734690e-01},
{8.76512638e-02, 1.13815815e-01, 2.42595252e-01, 3.47014186e-01, 4.10959714e-01, 4.63516957e-01},
{9.96341463e-02, 1.18080481e-01, 1.83828438e-01, 2.28152706e-01, 2.86257706e-01, 5.40624488e-01},
{1.13262609e-01, 1.88702205e-01, 2.30152861e-01, 2.99777815e-01, 4.39851399e-01, 5.24605609e-01},
{1.08394837e-01, 1.66607993e-01, 2.35957738e-01, 3.00978749e-01, 3.42963429e-01, 3.79667021e-01},
{9.28413851e-02, 1.87949866e-01, 2.95139865e-01, 3.25823590e-01, 4.18957437e-01, 5.17209121e-01},
{6.66250867e-02, 8.93598169e-02, 1.55026610e-01, 2.98419141e-01, 3.67851428e-01, 4.25501904e-01},
{9.18152321e-02, 1.05471291e-01, 2.47227673e-01, 4.82729030e-01, 5.12009689e-01, 5.53519245e-01},
{1.38413810e-01, 1.95649912e-01, 2.58870007e-01, 3.74848784e-01, 4.06184359e-01, 5.09486017e-01},
{6.68539764e-02, 9.44246416e-02, 2.32831396e-01, 3.49237878e-01, 4.09205667e-01, 4.85590658e-01},
{8.38101277e-02, 1.13972357e-01, 1.68108658e-01, 2.37851841e-01, 3.61185974e-01, 4.57959424e-01},
{7.87940874e-02, 1.10983187e-01, 1.52458712e-01, 3.16594383e-01, 5.28002488e-01, 5.79275946e-01},
{9.59762320e-02, 1.17856109e-01, 2.18271688e-01, 3.10657886e-01, 3.41397427e-01, 4.45043609e-01},
{1.05302280e-01, 1.53817257e-01, 2.14382915e-01, 3.23218764e-01, 4.59145415e-01, 4.90249399e-01},
{6.77309781e-02, 9.67543254e-02, 1.42771694e-01, 2.31629977e-01, 4.12396750e-01, 4.82774666e-01},
{1.08343778e-01, 1.28708154e-01, 2.43288645e-01, 4.22780457e-01, 4.60560855e-01, 5.02996311e-01},
{1.38071577e-01, 1.88843105e-01, 2.55016684e-01, 3.30324805e-01, 3.60083623e-01, 5.01459916e-01},
{1.05993153e-01, 1.58401197e-01, 2.34265735e-01, 3.40172879e-01, 4.41655303e-01, 4.71669792e-01},
{1.06578136e-01, 1.51812086e-01, 2.29569543e-01, 2.89286083e-01, 3.46998186e-01, 4.35561853e-01},
{8.28394802e-02, 1.16374874e-01, 2.28787335e-01, 3.33362615e-01, 5.18817688e-01, 5.53927549e-01},
{1.47327397e-01, 2.08097530e-01, 2.59172361e-01, 3.24634130e-01, 3.53914314e-01, 4.32278774e-01},
{6.80150245e-02, 1.33521932e-01, 3.71011570e-01, 4.20489431e-01, 5.06652484e-01, 5.42795683e-01},
{6.70957690e-02, 8.63298234e-02, 1.58762091e-01, 2.53649714e-01, 3.67485948e-01, 5.11648038e-01},
{7.90205497e-02, 9.42086930e-02, 1.45476352e-01, 3.94370735e-01, 5.46720726e-01, 5.64183564e-01},
{1.34117909e-01, 1.64131102e-01, 2.76753475e-01, 3.70977890e-01, 4.11167342e-01, 4.53779046e-01},
{7.29213682e-02, 1.01813212e-01, 2.34650856e-01, 3.48792494e-01, 4.31388117e-01, 4.96478198e-01},
{9.66506490e-02, 1.24175491e-01, 1.55608459e-01, 2.01322786e-01, 2.95406470e-01, 4.40457418e-01},
{9.87782969e-02, 1.31207843e-01, 1.58933622e-01, 3.69564626e-01, 5.23344168e-01, 5.90435366e-01},
{1.00509774e-01, 1.24215855e-01, 2.21404625e-01, 3.49929683e-01, 3.74207859e-01, 4.22937212e-01},
{1.26356467e-01, 1.67111908e-01, 2.35571157e-01, 4.15319358e-01, 4.45054739e-01, 5.18623460e-01},
{9.23485686e-02, 1.15686593e-01, 1.77770282e-01, 3.72183710e-01, 4.68320336e-01, 5.02572077e-01},
{8.73280421e-02, 1.21495838e-01, 2.55222669e-01, 3.93896274e-01, 4.84749818e-01, 5.16337998e-01},
{1.60614147e-01, 2.33775741e-01, 2.88434956e-01, 3.50038030e-01, 3.76906295e-01, 4.40879446e-01},
{8.48496452e-02, 1.16825608e-01, 1.66482295e-01, 3.15692195e-01, 4.24373629e-01, 4.84268446e-01},
{9.04916893e-02, 1.05850397e-01, 1.96024371e-01, 2.40672098e-01, 3.59283662e-01, 5.63297349e-01},
{9.17323444e-02, 1.22831290e-01, 1.65675300e-01, 3.65891587e-01, 5.17189733e-01, 5.42796911e-01},
{1.03239600e-01, 1.28063019e-01, 2.03316465e-01, 2.98803042e-01, 3.26646520e-01, 4.20024686e-01},
{1.46714461e-01, 2.03779336e-01, 2.44076702e-01, 3.67199528e-01, 4.54517253e-01, 4.78578636e-01},
{7.82002544e-02, 1.04803093e-01, 1.60498105e-01, 2.79838905e-01, 4.15495990e-01, 4.51185860e-01},
{7.64707525e-02, 9.09903574e-02, 1.47368342e-01, 4.01701184e-01, 5.10384541e-01, 5.30329991e-01},
{1.17244759e-01, 2.25299981e-01, 3.07738696e-01, 3.56921425e-01, 4.14568369e-01, 4.53658957e-01},
{9.28173273e-02, 1.11541611e-01, 2.76752896e-01, 3.97488296e-01, 4.21813873e-01, 5.06349396e-01},
{1.13630104e-01, 1.44809291e-01, 2.07066187e-01, 2.68663612e-01, 2.95202747e-01, 4.03895094e-01},
{6.88527434e-02, 1.01123835e-01, 1.41250220e-01, 2.10390731e-01, 4.61522584e-01, 5.72866549e-01},
{9.42118820e-02, 1.17223822e-01, 1.99763182e-01, 3.44156909e-01, 3.80501875e-01, 4.82753504e-01},
{8.36808710e-02, 1.14371104e-01, 2.41930956e-01, 3.05621749e-01, 4.53756073e-01, 5.26567199e-01},
{7.58397893e-02, 1.11386356e-01, 1.39661224e-01, 2.42503127e-01, 4.38586810e-01, 5.46334842e-01},
{1.27816155e-01, 1.52587691e-01, 2.21117437e-01, 3.76432158e-01, 4.98683064e-01, 5.30072441e-01},
{1.33964579e-01, 1.74275711e-01, 2.44802955e-01, 3.01673836e-01, 3.56769040e-01, 5.61982824e-01},
{8.70234706e-02, 1.23026325e-01, 2.06389679e-01, 3.65969788e-01, 4.55582464e-01, 4.99132317e-01},
{1.00654826e-01, 1.20233681e-01, 2.33306762e-01, 2.85528592e-01, 3.36817319e-01, 5.66275371e-01},
{7.97488707e-02, 1.03848993e-01, 1.88290462e-01, 2.67664041e-01, 4.73660700e-01, 6.14563952e-01},
{9.86251613e-02, 1.47466395e-01, 2.34236054e-01, 3.12387964e-01, 3.70793706e-01, 3.98712487e-01},
{6.01799396e-02, 9.73147967e-02, 3.17666907e-01, 3.97599864e-01, 4.94925905e-01, 5.37574618e-01},
{8.25420151e-02, 1.15848104e-01, 1.98047334e-01, 2.78574455e-01, 3.85468770e-01, 4.46159146e-01},
{7.22262050e-02, 8.61306170e-02, 2.30047600e-01, 5.04113098e-01, 5.44225024e-01, 5.78569121e-01},
{1.10226464e-01, 1.37308612e-01, 2.63287253e-01, 3.50931966e-01, 3.85948408e-01, 4.56521279e-01},
{5.77367820e-02, 7.45173262e-02, 2.02215137e-01, 3.35546205e-01, 4.22994219e-01, 5.10707210e-01},
{7.88574181e-02, 1.05196637e-01, 1.63469299e-01, 2.98742521e-01, 3.53034515e-01, 4.15287103e-01},
{8.14165717e-02, 1.01728494e-01, 1.54799271e-01, 3.06658757e-01, 4.87190474e-01, 6.01258851e-01},
{1.05194484e-01, 1.49523291e-01, 2.29919898e-01, 3.37341527e-01, 3.91458628e-01, 4.23671947e-01},
{9.83671663e-02, 1.50672520e-01, 2.58967676e-01, 3.72498858e-01, 4.39030763e-01, 4.64718204e-01},
{6.63235093e-02, 8.24006377e-02, 1.56730705e-01, 3.15304578e-01, 4.24669138e-01, 5.15719395e-01},
{8.90325422e-02, 1.12951860e-01, 2.10403912e-01, 3.83749882e-01, 4.47563707e-01, 4.76335877e-01},
{1.32296109e-01, 2.17067427e-01, 2.75554544e-01, 3.25866803e-01, 3.62205586e-01, 4.24015020e-01},
{9.83705093e-02, 1.19523054e-01, 2.06149324e-01, 3.81145339e-01, 4.11630378e-01, 4.67052836e-01},
{1.09843615e-01, 1.29590284e-01, 1.86753470e-01, 2.16558009e-01, 3.50184207e-01, 5.93058004e-01},
{9.66142509e-02, 1.67121345e-01, 2.41223307e-01, 3.33148056e-01, 5.31062987e-01, 5.82088565e-01},
{1.06068625e-01, 1.35232021e-01, 2.22654394e-01, 2.76299167e-01, 3.07431177e-01, 4.43981975e-01},
{1.20855796e-01, 2.13741413e-01, 2.59339521e-01, 3.15380013e-01, 4.52002153e-01, 5.36614278e-01},
{6.33887894e-02, 8.43520102e-02, 1.52865110e-01, 2.32437800e-01, 3.73465914e-01, 4.13086182e-01},
{1.09524043e-01, 1.39850070e-01, 2.71071423e-01, 4.64148556e-01, 4.94357840e-01, 5.61807545e-01},
{1.28954760e-01, 2.63631841e-01, 3.25222377e-01, 3.83079685e-01, 4.29815435e-01, 5.02838630e-01},
{1.05787239e-01, 1.25023568e-01, 2.71444604e-01, 3.31086464e-01, 3.76859894e-01, 5.20826260e-01},
{1.17446726e-01, 1.46063264e-01, 1.95100503e-01, 2.34708974e-01, 3.86746582e-01, 5.16864955e-01},
{9.72896726e-02, 1.32192120e-01, 1.59278604e-01, 3.21286717e-01, 4.96893558e-01, 5.44160379e-01},
{8.93634023e-02, 1.21375667e-01, 1.75382233e-01, 3.21028238e-01, 3.55046999e-01, 4.33242304e-01},
{1.30999160e-01, 1.64768105e-01, 2.36523307e-01, 3.72309729e-01, 4.53472787e-01, 4.76217144e-01},
{5.80238205e-02, 7.85465241e-02, 1.21966856e-01, 2.32888730e-01, 4.28178113e-01, 4.74678721e-01},
{1.09267082e-01, 1.26215391e-01, 2.35940294e-01, 4.38747861e-01, 4.71473543e-01, 5.15335874e-01},
{1.24993368e-01, 1.76047970e-01, 2.68644342e-01, 3.44053963e-01, 3.83450283e-01, 4.46714635e-01},
{9.93379967e-02, 1.42759548e-01, 2.15080766e-01, 3.52839582e-01, 4.22874767e-01, 4.54100152e-01},
{1.24037476e-01, 1.59415676e-01, 2.30569200e-01, 2.91370877e-01, 3.33594702e-01, 5.15699282e-01},
{9.10020609e-02, 1.34238154e-01, 2.28451703e-01, 3.13077297e-01, 5.18652417e-01, 6.27682964e-01},
{1.43187587e-01, 1.94798082e-01, 2.49287402e-01, 2.90192957e-01, 3.22959352e-01, 4.07013227e-01},
{1.30429586e-01, 2.56104873e-01, 3.43876842e-01, 4.13298788e-01, 4.64258525e-01, 5.27418306e-01},
{7.47685676e-02, 9.57974022e-02, 2.21354015e-01, 2.99044096e-01, 4.23034833e-01, 5.38998280e-01},
{7.45957383e-02, 1.00915429e-01, 2.02148603e-01, 3.86431424e-01, 5.50062910e-01, 6.02288755e-01},
{8.72482135e-02, 1.55881661e-01, 2.62731953e-01, 3.19650321e-01, 3.98072750e-01, 4.48942478e-01},
{1.13543102e-01, 1.35943348e-01, 2.54512702e-01, 2.97780648e-01, 3.61708590e-01, 5.51987895e-01},
{7.33316467e-02, 1.03620232e-01, 1.52091416e-01, 2.61800062e-01, 3.08933932e-01, 3.88434247e-01},
{1.10658381e-01, 1.24301253e-01, 1.96082391e-01, 3.74680309e-01, 4.99217508e-01, 5.90795512e-01},
{9.09545004e-02, 1.17357505e-01, 1.78843705e-01, 3.41227804e-01, 4.15912568e-01, 4.42446539e-01},
{1.33531046e-01, 1.86018940e-01, 2.63851694e-01, 3.91886009e-01, 4.27492691e-01, 4.92135685e-01},
{8.60083838e-02, 1.21782669e-01, 1.76094105e-01, 3.25099891e-01, 4.53488888e-01, 4.79412858e-01},
{6.61001987e-02, 1.08535517e-01, 2.78048060e-01, 3.87346135e-01, 4.59849460e-01, 4.98847176e-01},
{1.51839539e-01, 2.06004708e-01, 2.72249497e-01, 3.74632741e-01, 4.10963293e-01, 4.56421550e-01},
{7.47972293e-02, 1.00006136e-01, 1.63714344e-01, 2.80511574e-01, 4.39378123e-01, 4.57198553e-01},
{1.13926297e-01, 1.32563912e-01, 1.95459429e-01, 2.28351237e-01, 3.50551168e-01, 5.55868461e-01},
{1.08181268e-01, 1.39759650e-01, 2.25159073e-01, 3.81095848e-01, 5.24139578e-01, 5.62675350e-01},
{9.92832274e-02, 1.30279820e-01, 1.82624621e-01, 3.05353272e-01, 3.46927277e-01, 3.85606002e-01},
{1.31510941e-01, 1.89347007e-01, 2.70913181e-01, 3.93737949e-01, 4.95925002e-01, 5.27439261e-01},
{6.11396296e-02, 8.44663019e-02, 1.90973838e-01, 3.17392802e-01, 3.94904254e-01, 4.41125527e-01},
{8.39326467e-02, 9.81522800e-02, 2.37307736e-01, 4.48233911e-01, 4.79158342e-01, 5.19141997e-01},
{1.37760782e-01, 1.95494664e-01, 2.61651060e-01, 3.58838127e-01, 4.41597319e-01, 4.63314833e-01},
{9.74106107e-02, 1.17097560e-01, 2.34319490e-01, 3.71160619e-01, 3.96838876e-01, 5.07257473e-01},
{8.46606428e-02, 1.08747282e-01, 2.01071695e-01, 2.69981069e-01, 3.02048664e-01, 3.82018806e-01},
{8.83604365e-02, 1.25594677e-01, 1.59964310e-01, 2.77082834e-01, 4.59396181e-01, 5.50615421e-01},
{7.25214787e-02, 1.00401479e-01, 2.67906423e-01, 3.28375853e-01, 4.02028127e-01, 4.67478048e-01},
{9.71006161e-02, 1.48362166e-01, 1.84598447e-01, 2.88554280e-01, 4.64297022e-01, 4.98961101e-01},
{6.25413371e-02, 8.78581212e-02, 1.44648137e-01, 2.01091873e-01, 3.95031516e-01, 5.11745986e-01},
{1.08661602e-01, 1.41586869e-01, 2.17155036e-01, 3.66222571e-01, 4.79347598e-01, 5.04107209e-01},
{1.20197577e-01, 1.65754174e-01, 2.52149906e-01, 3.00584848e-01, 3.79583709e-01, 4.94306327e-01},
{7.74184026e-02, 1.30739552e-01, 2.25801855e-01, 3.16081098e-01, 4.44784060e-01, 4.75522880e-01},
{1.34773660e-01, 1.71036614e-01, 2.33375732e-01, 2.70753179e-01, 3.31442749e-01, 5.49353356e-01},
{1.07437962e-01, 1.51381285e-01, 1.98914593e-01, 3.03435479e-01, 4.85197108e-01, 5.78539429e-01},
{1.19891359e-01, 1.49443080e-01, 2.27634870e-01, 3.19649210e-01, 3.48658134e-01, 4.08071052e-01},
{9.20134213e-02, 1.54718905e-01, 2.79222492e-01, 3.79032461e-01, 4.70761881e-01, 5.20013475e-01},
{9.45102742e-02, 1.17308942e-01, 2.35455454e-01, 2.94440674e-01, 3.70581067e-01, 5.15974538e-01},
{8.28819977e-02, 9.77929451e-02, 1.75340248e-01, 4.20990137e-01, 5.19496380e-01, 5.43277249e-01},
{1.19507104e-01, 1.50202344e-01, 2.38038726e-01, 3.72452417e-01, 3.97015446e-01, 5.00029432e-01},
{6.68627638e-02, 8.40786833e-02, 2.02521534e-01, 3.31752607e-01, 3.82944029e-01, 5.08702971e-01},
{6.47345322e-02, 8.76640108e-02, 1.95235410e-01, 2.70708641e-01, 3.17530441e-01, 4.60274189e-01},
{7.36651484e-02, 1.03885101e-01, 1.54472170e-01, 3.46472307e-01, 5.13489940e-01, 6.20691783e-01},
{1.29134352e-01, 1.92250428e-01, 2.41655547e-01, 3.18502515e-01, 3.87837421e-01, 4.25176157e-01},
{1.11671378e-01, 1.36435040e-01, 2.79709149e-01, 4.13029796e-01, 4.42720496e-01, 4.95181342e-01},
{6.75829386e-02, 8.91790693e-02, 1.68893291e-01, 3.46765933e-01, 4.62576865e-01, 4.94025612e-01},
{8.20732069e-02, 9.63675318e-02, 2.38295940e-01, 4.22753540e-01, 4.45615461e-01, 5.27302709e-01},
{1.04504008e-01, 1.98917872e-01, 2.81203008e-01, 3.20213182e-01, 3.65551086e-01, 3.99878599e-01},
{8.80938884e-02, 1.18204199e-01, 1.72599589e-01, 3.38942175e-01, 3.99645813e-01, 4.49321534e-01},
{1.01082518e-01, 1.18772161e-01, 1.69666195e-01, 1.98585305e-01, 3.11439921e-01, 5.27764665e-01},
{1.00082623e-01, 1.55274871e-01, 2.19686198e-01, 3.18606093e-01, 4.86456993e-01, 5.34529598e-01},
{1.22691356e-01, 1.79422547e-01, 2.41160053e-01, 2.91267228e-01, 3.21920633e-01, 4.06127681e-01},
{1.26018148e-01, 2.25233049e-01, 2.79641905e-01, 3.23407228e-01, 4.48213594e-01, 5.12517520e-01},
{6.63102685e-02, 9.23360497e-02, 1.33033431e-01, 2.47277213e-01, 3.88081755e-01, 4.43032918e-01},
{8.32935131e-02, 9.60765600e-02, 2.10318273e-01, 4.58619908e-01, 4.97670778e-01, 5.26582976e-01},
{1.34829065e-01, 1.75908219e-01, 2.83860418e-01, 3.77422187e-01, 4.06250033e-01, 4.96002829e-01},
{8.77695651e-02, 1.04618475e-01, 2.11018210e-01, 3.87426639e-01, 4.17863005e-01, 5.39202913e-01},
{9.14747037e-02, 1.14957524e-01, 1.87274736e-01, 2.24692650e-01, 3.16702394e-01, 4.67992715e-01},
{6.35574729e-02, 1.03752098e-01, 2.01820804e-01, 2.81291617e-01, 4.97915206e-01, 5.76838023e-01},
{1.01710480e-01, 1.21519120e-01, 2.56786653e-01, 3.14825338e-01, 3.59046420e-01, 4.03476281e-01},
{1.02076684e-01, 1.54868873e-01, 2.39800060e-01, 3.55523165e-01, 4.74177278e-01, 4.97750137e-01},
{5.76149284e-02, 7.73981694e-02, 1.52563785e-01, 2.05595414e-01, 4.03499825e-01, 4.79037898e-01},
{8.57408444e-02, 1.02989492e-01, 2.38667805e-01, 4.29422027e-01, 4.55983826e-01, 4.97476725e-01},
{1.49583367e-01, 1.81896262e-01, 2.78022263e-01, 3.49495246e-01, 3.80440804e-01, 4.92038166e-01},
{1.06922650e-01, 1.66222364e-01, 2.10843006e-01, 3.05039231e-01, 4.26608462e-01, 4.73980394e-01},
{1.17616135e-01, 1.53252361e-01, 2.29104104e-01, 3.10650176e-01, 3.46396473e-01, 4.78397125e-01},
{8.79200197e-02, 1.21842256e-01, 2.37095985e-01, 3.17286829e-01, 4.68458495e-01, 5.64663805e-01},
{1.10920338e-01, 1.93135531e-01, 2.58698870e-01, 3.05228427e-01, 3.57586033e-01, 3.88587357e-01},
{9.52789094e-02, 1.78709120e-01, 3.75238454e-01, 4.46760971e-01, 5.44870061e-01, 6.05226737e-01},
{6.96146547e-02, 9.19761486e-02, 1.87876273e-01, 3.02761531e-01, 3.79309691e-01, 4.96765010e-01},
{7.90950878e-02, 1.01011947e-01, 1.89283484e-01, 3.96372033e-01, 5.17158527e-01, 5.69162952e-01},
{1.26062393e-01, 1.67154293e-01, 2.54017610e-01, 3.82994818e-01, 4.26025378e-01, 4.68289387e-01},
{8.72471279e-02, 1.05160787e-01, 2.44745468e-01, 3.08023090e-01, 3.83513011e-01, 5.29733276e-01},
{1.02090371e-01, 1.33484262e-01, 1.94240114e-01, 2.39706827e-01, 2.83396750e-01, 4.25392401e-01},
{1.04236959e-01, 1.39854291e-01, 1.68923367e-01, 3.32870346e-01, 5.08758094e-01, 5.72807149e-01},
{1.00291205e-01, 1.20746210e-01, 2.06284810e-01, 3.59958072e-01, 3.91562071e-01, 4.39252085e-01},
{1.31667629e-01, 1.69679145e-01, 2.86344943e-01, 4.26787719e-01, 4.53189933e-01, 5.36452110e-01},
{6.81224295e-02, 9.81019710e-02, 2.09117082e-01, 3.37045560e-01, 4.57457866e-01, 4.87806900e-01},
{6.79599584e-02, 1.01370957e-01, 2.79055433e-01, 3.25003491e-01, 4.53512498e-01, 5.37245601e-01},
{1.27738432e-01, 2.14880421e-01, 2.68489455e-01, 3.37100674e-01, 4.13659375e-01, 4.43103266e-01},
{7.17398440e-02, 9.83924532e-02, 1.66001122e-01, 3.47922324e-01, 4.39867278e-01, 4.66809512e-01},
{8.13892978e-02, 9.87222391e-02, 1.81751614e-01, 2.77819780e-01, 3.15330651e-01, 5.04548147e-01},
{1.00891788e-01, 1.42165369e-01, 1.96866019e-01, 3.40594440e-01, 5.07529198e-01, 5.54067123e-01},
{9.62879257e-02, 1.42589365e-01, 2.31050991e-01, 2.66480952e-01, 3.28807997e-01, 4.10163684e-01},
{1.16684956e-01, 1.94770009e-01, 2.47819790e-01, 3.22746970e-01, 4.39126195e-01, 4.69246496e-01},
{6.53807309e-02, 9.32961698e-02, 1.54746918e-01, 2.66315998e-01, 4.01926531e-01, 4.35289078e-01},
{8.73972531e-02, 1.24881206e-01, 1.63138737e-01, 3.70267703e-01, 4.95177329e-01, 5.25892571e-01},
{1.24416649e-01, 2.19520928e-01, 2.73976575e-01, 3.26874138e-01, 4.32544652e-01, 4.73080377e-01},
{7.95653451e-02, 1.03719057e-01, 3.08615673e-01, 3.73845199e-01, 4.19256216e-01, 5.47145217e-01},
{1.06519587e-01, 1.40620881e-01, 1.96143057e-01, 2.37210383e-01, 2.77467939e-01, 3.81633551e-01},
{6.57811821e-02, 8.93918389e-02, 1.49449609e-01, 2.65873395e-01, 4.90871173e-01, 5.75566514e-01},
{9.11847453e-02, 1.33328297e-01, 2.41789017e-01, 3.18456880e-01, 3.69513477e-01, 4.62825412e-01},
{9.03960914e-02, 1.53653708e-01, 2.39389205e-01, 3.32002928e-01, 4.80382771e-01, 5.12380934e-01},
{7.52845961e-02, 1.01816597e-01, 1.55005713e-01, 2.50837963e-01, 4.31411178e-01, 5.06067646e-01},
{1.07692429e-01, 1.29255517e-01, 1.98292445e-01, 3.89364832e-01, 4.94577739e-01, 5.32173066e-01},
{1.23954625e-01, 1.74283790e-01, 2.45146896e-01, 3.03334549e-01, 3.37109820e-01, 5.04206433e-01},
{1.03892074e-01, 1.47662838e-01, 1.97701292e-01, 3.39255623e-01, 4.46822279e-01, 4.80947731e-01},
{1.15150966e-01, 1.41261168e-01, 2.42042562e-01, 2.98021721e-01, 3.39577614e-01, 5.17634338e-01},
{9.86633668e-02, 1.39592544e-01, 1.94647838e-01, 3.05022331e-01, 4.60092624e-01, 5.54954333e-01},
{9.68964914e-02, 1.54112709e-01, 2.39221253e-01, 3.14280178e-01, 3.84273220e-01, 4.16701871e-01},
{6.80715481e-02, 1.21873292e-01, 3.07141643e-01, 4.18132799e-01, 4.80644077e-01, 5.15993143e-01},
{6.72707913e-02, 9.50553154e-02, 2.35596372e-01, 2.86633715e-01, 3.78264346e-01, 4.71115867e-01},
{8.33163162e-02, 9.63926425e-02, 2.34610989e-01, 5.02570932e-01, 5.39099749e-01, 5.76130024e-01},
{1.04175503e-01, 1.59104963e-01, 2.45818222e-01, 3.59631355e-01, 4.16724634e-01, 4.46340204e-01},
{5.49609465e-02, 6.67636910e-02, 1.50095084e-01, 3.12118738e-01, 3.96101433e-01, 4.91687971e-01},
{7.48649364e-02, 9.70820126e-02, 1.69120688e-01, 2.93988450e-01, 3.50760731e-01, 4.50757931e-01},
{6.65094490e-02, 9.33705369e-02, 1.53271331e-01, 2.93189795e-01, 5.24087240e-01, 6.18656077e-01},
{1.23725639e-01, 1.58534764e-01, 2.48332328e-01, 3.38443104e-01, 3.63934938e-01, 4.48194927e-01},
{9.52649828e-02, 1.65979736e-01, 2.65122669e-01, 3.66438138e-01, 4.60262097e-01, 4.80726938e-01},
{7.40579727e-02, 9.66571760e-02, 1.70311052e-01, 3.06223420e-01, 4.61857764e-01, 5.57675182e-01},
{7.80674555e-02, 9.61716688e-02, 1.97710928e-01, 3.87055535e-01, 4.31793039e-01, 4.99257234e-01},
{1.42113980e-01, 2.11773738e-01, 2.62890168e-01, 3.25372103e-01, 3.80407119e-01, 4.39946677e-01},
{8.92784611e-02, 1.08687386e-01, 2.67956675e-01, 4.04264902e-01, 4.37155585e-01, 4.76463016e-01},
{1.02034504e-01, 1.16916987e-01, 2.39063745e-01, 2.74213157e-01, 3.82064732e-01, 5.96055225e-01},
{1.09967038e-01, 1.87112763e-01, 2.61230105e-01, 3.70453704e-01, 5.14664833e-01, 5.57869719e-01},
{1.12007866e-01, 1.65930503e-01, 2.17731790e-01, 2.63527980e-01, 3.09649209e-01, 4.21518361e-01},
{1.13347366e-01, 1.90571709e-01, 2.52220491e-01, 2.95199889e-01, 4.61970460e-01, 5.46528196e-01},
{6.44523692e-02, 8.27112081e-02, 1.46539448e-01, 2.64537541e-01, 3.76447962e-01, 4.73533486e-01},
{1.01529195e-01, 1.19745705e-01, 2.10678389e-01, 4.77648301e-01, 5.20491768e-01, 5.65707552e-01},
{1.40986444e-01, 2.28503662e-01, 2.90091234e-01, 3.87817564e-01, 4.53052514e-01, 4.78910780e-01},
{9.20935202e-02, 1.13895374e-01, 2.58827822e-01, 3.38915413e-01, 3.74418971e-01, 4.94087365e-01},
{1.06737295e-01, 1.33189282e-01, 1.99029188e-01, 2.35305223e-01, 3.29199967e-01, 4.91373749e-01},
{7.01730672e-02, 1.00706881e-01, 1.39802717e-01, 2.25179838e-01, 4.81770034e-01, 5.14892936e-01},
{9.33562685e-02, 1.35699401e-01, 1.75594422e-01, 2.91215671e-01, 4.04252938e-01, 4.29293539e-01},
{1.20143764e-01, 1.66221086e-01, 2.45153009e-01, 3.66941846e-01, 4.67829173e-01, 4.89597576e-01},
{5.82314234e-02, 7.52738250e-02, 1.20751333e-01, 2.10215133e-01, 4.07600891e-01, 4.99464114e-01},
{9.57265305e-02, 1.14797475e-01, 2.77714545e-01, 4.38992193e-01, 4.62567415e-01, 5.30172559e-01},
{1.29660573e-01, 1.64725418e-01, 2.65119979e-01, 3.66190341e-01, 3.94832435e-01, 5.41416381e-01},
{1.06346941e-01, 1.42855225e-01, 2.22804049e-01, 3.65270323e-01, 4.35263302e-01, 4.58570707e-01},
{1.19033421e-01, 1.57276207e-01, 2.32230558e-01, 2.69327422e-01, 3.24276954e-01, 4.87366354e-01},
{1.01549043e-01, 1.52000057e-01, 2.07282321e-01, 3.52424539e-01, 5.30637020e-01, 6.05313729e-01},
{1.29252230e-01, 1.91625821e-01, 2.35056041e-01, 2.89273165e-01, 3.48461495e-01, 4.40123154e-01},
{8.96379966e-02, 1.67668364e-01, 3.12396601e-01, 4.16587027e-01, 5.03827671e-01, 5.58927485e-01},
{7.17851942e-02, 9.53394062e-02, 1.92486837e-01, 2.86291178e-01, 4.17232649e-01, 5.08414953e-01},
{8.03869589e-02, 9.60704555e-02, 1.72595422e-01, 4.75909148e-01, 5.62527205e-01, 5.81860139e-01},
{1.14260110e-01, 1.62851264e-01, 2.20466215e-01, 3.33107034e-01, 4.21625891e-01, 4.45594189e-01},
{9.69073029e-02, 1.14374353e-01, 2.23565643e-01, 3.34993184e-01, 3.68588497e-01, 5.37668342e-01},
{7.95196887e-02, 1.00295915e-01, 1.66347866e-01, 2.31090094e-01, 2.99256783e-01, 4.55006480e-01},
{9.37067609e-02, 1.28694538e-01, 1.98945386e-01, 3.04699570e-01, 5.25149636e-01, 5.81299463e-01},
{1.03500212e-01, 1.44040936e-01, 2.23071027e-01, 3.20165685e-01, 4.14235356e-01, 4.37264624e-01},
{1.20565798e-01, 1.48831706e-01, 2.73934362e-01, 4.15906792e-01, 4.41963176e-01, 5.29936292e-01},
{7.99761060e-02, 1.08658078e-01, 1.71391237e-01, 3.28033618e-01, 4.61002412e-01, 5.03716560e-01},
{6.30551627e-02, 9.86287716e-02, 2.70806333e-01, 3.64430044e-01, 4.33213413e-01, 4.63738182e-01},
{1.46639206e-01, 2.06123875e-01, 2.54387906e-01, 3.47695901e-01, 4.06850257e-01, 4.38819493e-01},
{7.12357833e-02, 9.51870462e-02, 1.59563945e-01, 3.03096757e-01, 4.58266662e-01, 4.77485579e-01},
{1.01775074e-01, 1.21927353e-01, 1.96641209e-01, 2.46673202e-01, 3.03940909e-01, 5.44679773e-01},
{1.14208189e-01, 1.51981458e-01, 1.88938155e-01, 3.77381508e-01, 5.17621749e-01, 5.70193212e-01},
{1.00371069e-01, 1.48758119e-01, 2.17452469e-01, 2.79784290e-01, 3.29854698e-01, 3.57408942e-01},
{1.06163940e-01, 1.98520793e-01, 2.95722875e-01, 3.95378222e-01, 4.58475074e-01, 4.93129864e-01},
{7.95571558e-02, 1.04153320e-01, 1.95963835e-01, 3.03787791e-01, 3.63254632e-01, 4.34677946e-01},
{6.92286859e-02, 8.79906321e-02, 2.23408833e-01, 4.33481178e-01, 4.99296383e-01, 5.41548844e-01},
{1.43519228e-01, 1.88290032e-01, 2.53537933e-01, 3.59028738e-01, 4.17771286e-01, 4.48579123e-01},
{1.06656718e-01, 1.31285572e-01, 2.43610889e-01, 3.68065671e-01, 4.11697850e-01, 4.95969262e-01},
{9.66991649e-02, 1.28187896e-01, 2.06001646e-01, 2.66867881e-01, 3.06806022e-01, 3.84026446e-01},
{7.49592226e-02, 1.08399514e-01, 1.61153621e-01, 2.66837809e-01, 4.33696084e-01, 5.77450642e-01},
{7.54415057e-02, 1.16840331e-01, 2.47732914e-01, 3.17180733e-01, 3.69205095e-01, 4.26991551e-01},
{1.07521557e-01, 1.39207641e-01, 1.70790499e-01, 3.59454868e-01, 4.71503640e-01, 5.05993812e-01},
{7.69702216e-02, 1.02690411e-01, 1.57562013e-01, 2.65524226e-01, 4.15978938e-01, 5.34888471e-01},
{1.00088073e-01, 1.43527161e-01, 2.58293410e-01, 4.03319966e-01, 4.69279244e-01, 4.97178524e-01},
{1.14400721e-01, 1.60353577e-01, 2.50477107e-01, 3.19671587e-01, 3.78449013e-01, 5.46378410e-01},
{7.46322601e-02, 1.03452725e-01, 2.23552721e-01, 3.07073723e-01, 4.35992140e-01, 4.67044283e-01},
{1.27793651e-01, 1.62618764e-01, 2.34062686e-01, 2.61256934e-01, 3.78863560e-01, 6.12165286e-01},
{1.04288567e-01, 1.59240583e-01, 1.80487228e-01, 2.76929448e-01, 4.39088629e-01, 5.68644895e-01},
{1.40199657e-01, 1.78271646e-01, 2.36687250e-01, 3.21814682e-01, 3.56631283e-01, 4.29574908e-01},
{9.17238616e-02, 1.80147893e-01, 3.40449106e-01, 4.07029212e-01, 4.57373546e-01, 5.18103011e-01},
{8.82765617e-02, 1.04718287e-01, 2.04690731e-01, 3.04877572e-01, 3.45967452e-01, 5.43506483e-01},
{7.90161305e-02, 9.24440125e-02, 2.31124587e-01, 4.96338212e-01, 5.27566453e-01, 5.64704383e-01},
{9.62610009e-02, 1.13076978e-01, 2.57148580e-01, 3.74794408e-01, 4.03809779e-01, 4.34952267e-01},
{8.41838807e-02, 1.09546335e-01, 2.13589850e-01, 3.34369169e-01, 4.11490151e-01, 4.93651298e-01},
{7.46266791e-02, 1.13254113e-01, 2.26127509e-01, 2.72114369e-01, 3.41098025e-01, 4.55064363e-01},
{8.48912981e-02, 1.20556125e-01, 1.57411109e-01, 3.53646031e-01, 5.40982979e-01, 6.16122655e-01},
{1.02130784e-01, 1.69634314e-01, 2.36955501e-01, 3.15275899e-01, 3.94675838e-01, 4.38061918e-01},
{1.17878884e-01, 1.50607460e-01, 2.14066287e-01, 3.93963794e-01, 4.32843946e-01, 4.99606208e-01},
{5.88250155e-02, 7.38187257e-02, 1.81577699e-01, 3.62311520e-01, 4.79816903e-01, 5.56969596e-01},
{7.91801591e-02, 9.96155259e-02, 3.12499846e-01, 4.33389199e-01, 4.73524173e-01, 5.87025859e-01},
{9.04496002e-02, 1.79358334e-01, 2.89396750e-01, 3.37404083e-01, 3.77619307e-01, 4.14239458e-01},
{6.68549558e-02, 1.02370833e-01, 2.28800690e-01, 3.13818997e-01, 4.06168063e-01, 4.40969090e-01},
{8.45929221e-02, 1.02146578e-01, 1.64690386e-01, 2.14342507e-01, 3.14261215e-01, 5.20763221e-01},
{1.06685078e-01, 1.67205252e-01, 1.95264728e-01, 2.92949890e-01, 4.68486870e-01, 5.33960490e-01},
{1.14068511e-01, 1.45536995e-01, 2.44920266e-01, 2.99277241e-01, 3.28400849e-01, 3.96188567e-01},
{9.22461803e-02, 1.83791365e-01, 2.89163462e-01, 3.30227299e-01, 4.20231735e-01, 4.64534346e-01},
{7.82775045e-02, 1.08262592e-01, 1.58627478e-01, 3.06561976e-01, 3.78854456e-01, 4.15144625e-01},
{8.29339299e-02, 9.59144554e-02, 2.00105151e-01, 4.67782538e-01, 5.08678325e-01, 5.47409160e-01},
{1.75822703e-01, 2.07144970e-01, 2.92323838e-01, 3.72916381e-01, 4.05973945e-01, 4.84843008e-01},
{6.76653629e-02, 9.59485003e-02, 2.90809035e-01, 3.55179739e-01, 4.01540137e-01, 4.87983660e-01},
{7.39062233e-02, 9.63600915e-02, 1.63185992e-01, 2.49878615e-01, 3.32972105e-01, 4.85511736e-01},
{6.92518782e-02, 9.27130275e-02, 1.65373638e-01, 2.62880127e-01, 5.11629776e-01, 5.55192538e-01},
{1.05089684e-01, 1.31493701e-01, 2.10097716e-01, 3.11899423e-01, 3.43817479e-01, 4.18073760e-01},
{1.03020699e-01, 1.65406985e-01, 2.24586873e-01, 2.96271457e-01, 4.40955055e-01, 4.96677751e-01},
{7.32820476e-02, 9.33894016e-02, 1.30854378e-01, 2.45376354e-01, 4.20515983e-01, 4.57422098e-01},
{1.04876700e-01, 1.31742499e-01, 2.28124271e-01, 4.30895128e-01, 4.57458792e-01, 5.41645432e-01},
{1.34729182e-01, 1.91136729e-01, 2.68500576e-01, 3.11793803e-01, 3.58684552e-01, 4.84087389e-01},
{1.04176338e-01, 1.59225823e-01, 2.35758158e-01, 3.34821105e-01, 4.32062460e-01, 4.54932375e-01},
{1.04533997e-01, 1.31231215e-01, 2.37023498e-01, 2.78225900e-01, 3.58275501e-01, 4.81110615e-01},
{8.25876446e-02, 1.13396770e-01, 2.79692436e-01, 3.52843781e-01, 5.16056605e-01, 5.74726782e-01},
{1.37319264e-01, 1.98349252e-01, 2.45041187e-01, 3.16346448e-01, 3.61889772e-01, 4.19707855e-01},
{6.84267840e-02, 1.04812748e-01, 3.48601506e-01, 4.18925222e-01, 5.24886008e-01, 5.90526943e-01},
{6.82881738e-02, 8.89685969e-02, 1.63986323e-01, 2.90886382e-01, 3.44813097e-01, 4.79169787e-01},
{8.27806744e-02, 1.06387499e-01, 1.75307303e-01, 3.69984373e-01, 5.52007033e-01, 5.77104133e-01},
{1.37664651e-01, 1.93707633e-01, 2.37958674e-01, 3.52680617e-01, 4.00523569e-01, 4.51270545e-01},
{7.48341801e-02, 9.49666152e-02, 2.20422893e-01, 3.20612012e-01, 4.16677295e-01, 5.05587588e-01},
{1.04494318e-01, 1.29209865e-01, 1.80364504e-01, 2.15092793e-01, 2.92338288e-01, 4.52701172e-01},
{1.02228663e-01, 1.33702716e-01, 1.79070971e-01, 3.79024905e-01, 5.39334730e-01, 5.75678788e-01},
{9.92700454e-02, 1.19890643e-01, 2.68982282e-01, 3.55607372e-01, 3.86092239e-01, 4.23559787e-01},
{1.29827007e-01, 1.76526220e-01, 2.66872025e-01, 4.06614303e-01, 4.36537324e-01, 4.98023736e-01},
{9.22907179e-02, 1.20736473e-01, 1.82966328e-01, 3.91177844e-01, 4.80481222e-01, 5.04297841e-01},
{7.59603940e-02, 1.01382208e-01, 2.51024688e-01, 3.57130562e-01, 4.82692259e-01, 5.47875708e-01},
{1.32753462e-01, 2.17709762e-01, 2.75433246e-01, 3.45460865e-01, 3.91666816e-01, 4.36356914e-01},
{8.44458514e-02, 1.22769568e-01, 1.56462860e-01, 3.08562886e-01, 4.32771758e-01, 4.55982359e-01},
{8.41574855e-02, 9.99024743e-02, 2.14402174e-01, 2.77552725e-01, 3.45209605e-01, 5.53064400e-01},
{9.11847399e-02, 1.19210112e-01, 1.82237119e-01, 3.17067533e-01, 5.17185933e-01, 5.55193871e-01},
{8.64936725e-02, 1.10781607e-01, 2.23325523e-01, 2.88516627e-01, 3.30007465e-01, 4.16231298e-01},
{1.37592068e-01, 2.16805877e-01, 2.56713035e-01, 3.43876231e-01, 4.56128597e-01, 4.92362184e-01},
{7.52416234e-02, 1.05059014e-01, 1.72981712e-01, 3.06906085e-01, 3.93689602e-01, 4.46554434e-01},
{7.71690420e-02, 1.05504376e-01, 1.49683821e-01, 3.39137002e-01, 5.12007574e-01, 5.35614140e-01},
{1.29344290e-01, 2.14074644e-01, 2.76188518e-01, 3.63187377e-01, 4.26487136e-01, 4.53119678e-01},
{1.00044551e-01, 1.18725473e-01, 2.40877637e-01, 3.87814080e-01, 4.13032811e-01, 5.37295300e-01},
{1.14900792e-01, 1.38582485e-01, 2.09065163e-01, 2.38126745e-01, 2.97113602e-01, 4.24093659e-01},
{7.08969587e-02, 1.04208868e-01, 1.31620759e-01, 2.40387457e-01, 5.06116106e-01, 5.90974203e-01},
{7.87058675e-02, 1.13960242e-01, 2.18103173e-01, 3.32348298e-01, 3.82012685e-01, 4.36057752e-01},
{7.32824238e-02, 1.05274531e-01, 2.03125987e-01, 3.04194157e-01, 4.60706396e-01, 5.08119501e-01},
{6.70544275e-02, 8.97915188e-02, 1.56734609e-01, 2.31947843e-01, 4.59398776e-01, 5.53799097e-01},
{1.09566833e-01, 1.62565190e-01, 2.54012884e-01, 3.75954861e-01, 4.93338227e-01, 5.19566626e-01},
{1.59485799e-01, 1.97815014e-01, 2.66972706e-01, 3.12550325e-01, 3.53477229e-01, 5.33420113e-01},
{1.07697329e-01, 1.27399484e-01, 2.15459514e-01, 3.91409697e-01, 4.48362053e-01, 4.78615891e-01},
{1.13630324e-01, 1.39614987e-01, 2.25349158e-01, 2.78603162e-01, 3.16174167e-01, 5.21372739e-01},
{7.62805568e-02, 1.13347743e-01, 2.12061778e-01, 3.08358953e-01, 4.50552642e-01, 6.06048199e-01},
{1.16399085e-01, 1.72431767e-01, 2.26644525e-01, 3.14202913e-01, 3.79129442e-01, 4.13295343e-01},
{5.99384286e-02, 7.59858927e-02, 2.54949139e-01, 4.24637270e-01, 4.82033702e-01, 5.43361859e-01},
{9.71194040e-02, 1.63733241e-01, 2.09611041e-01, 2.67385304e-01, 3.78215631e-01, 4.64368599e-01},
{7.92943528e-02, 9.24749701e-02, 1.79959256e-01, 4.82230641e-01, 5.48195626e-01, 5.69918240e-01},
{1.15761538e-01, 1.66784449e-01, 2.60671122e-01, 3.48760805e-01, 3.98329275e-01, 4.29412196e-01},
{6.05419612e-02, 7.48606924e-02, 1.83534116e-01, 3.57667498e-01, 4.08675628e-01, 4.81456389e-01},
{8.42041271e-02, 1.21946324e-01, 1.58786482e-01, 2.84036107e-01, 3.40136181e-01, 4.01226038e-01},
{8.46177161e-02, 1.21683053e-01, 1.56575045e-01, 2.93435223e-01, 5.20902737e-01, 5.99652596e-01},
{1.12660169e-01, 1.54197758e-01, 2.30713853e-01, 3.46419433e-01, 3.71895269e-01, 4.27995080e-01},
{1.13377932e-01, 1.83173515e-01, 3.05911840e-01, 3.86376862e-01, 4.42493138e-01, 4.77778919e-01},
{7.27911927e-02, 9.34649498e-02, 1.68878590e-01, 2.77076077e-01, 4.64769363e-01, 5.15928827e-01},
{8.85451236e-02, 1.14048445e-01, 1.84525186e-01, 3.81862687e-01, 4.34521599e-01, 4.76815998e-01},
{1.32183576e-01, 2.22198636e-01, 2.83762846e-01, 3.42562944e-01, 3.76427782e-01, 4.31529047e-01},
{8.22743596e-02, 1.05559739e-01, 1.90785800e-01, 3.69502505e-01, 4.08449565e-01, 4.82908415e-01},
{1.02207785e-01, 1.20876772e-01, 1.80009731e-01, 2.08861169e-01, 3.87707567e-01, 5.98063316e-01},
{9.71193937e-02, 1.64770758e-01, 2.31790812e-01, 3.33959353e-01, 5.12834750e-01, 5.57153508e-01},
{1.17654561e-01, 1.49658368e-01, 1.96044878e-01, 2.93790023e-01, 3.17336602e-01, 4.21177342e-01},
{1.07462662e-01, 1.90851502e-01, 2.57090340e-01, 3.00204901e-01, 4.27237473e-01, 4.96235504e-01},
{6.10085885e-02, 7.68033700e-02, 1.73911301e-01, 2.16265423e-01, 3.60199119e-01, 4.42081613e-01},
{9.76066821e-02, 1.13874591e-01, 2.37549342e-01, 4.64232080e-01, 4.96371164e-01, 5.44049201e-01},
{1.20732321e-01, 2.34958189e-01, 2.98868255e-01, 3.34820379e-01, 4.25541842e-01, 4.72120839e-01},
{1.10663763e-01, 1.40536761e-01, 2.62809481e-01, 3.34781779e-01, 3.72507825e-01, 4.73718995e-01},
{1.14453169e-01, 1.50963546e-01, 2.34986862e-01, 2.67109546e-01, 3.81122909e-01, 5.13852355e-01},
{8.46795138e-02, 1.16060551e-01, 1.52036607e-01, 3.26350156e-01, 4.86958113e-01, 5.32373888e-01},
{1.02949877e-01, 1.37361168e-01, 1.73265345e-01, 3.15918812e-01, 3.63060378e-01, 4.18572987e-01},
{1.30249862e-01, 1.83174586e-01, 2.37886530e-01, 3.44741300e-01, 4.47618004e-01, 4.71365223e-01},
{5.83366506e-02, 7.84001573e-02, 1.37314050e-01, 2.18354010e-01, 4.44021150e-01, 5.00566359e-01},
{1.08979581e-01, 1.31995462e-01, 2.27610450e-01, 4.47748073e-01, 4.87814713e-01, 5.49346754e-01},
{1.26486724e-01, 1.71834244e-01, 2.57595950e-01, 3.37250399e-01, 3.72142748e-01, 4.85045422e-01},
{1.07252759e-01, 1.29862954e-01, 2.28644972e-01, 3.76245217e-01, 4.18661306e-01, 4.52334230e-01},
{1.38215745e-01, 1.75638972e-01, 2.45202513e-01, 2.88291653e-01, 3.31031423e-01, 4.69748983e-01},
{9.07425269e-02, 1.33970724e-01, 2.18862869e-01, 3.00088528e-01, 4.98041330e-01, 5.94557526e-01},
{1.44711647e-01, 2.09842028e-01, 2.57274841e-01, 3.08987986e-01, 3.42582069e-01, 4.18699987e-01},
{1.08695013e-01, 2.17978930e-01, 3.72231729e-01, 4.36291199e-01, 4.79252931e-01, 5.30426368e-01},
{6.77945896e-02, 8.78775484e-02, 1.87181683e-01, 2.92703327e-01, 4.06274554e-01, 5.49742550e-01},
{8.18581039e-02, 9.85093505e-02, 2.05653669e-01, 3.57817068e-01, 5.12968281e-01, 6.04367213e-01},
{1.05011539e-01, 1.79867973e-01, 2.61967733e-01, 3.38570472e-01, 4.08323483e-01, 4.37270491e-01},
{9.06006464e-02, 1.05193920e-01, 2.49265305e-01, 3.11870610e-01, 3.69440522e-01, 5.68953284e-01},
{7.26178469e-02, 1.11996085e-01, 1.43675145e-01, 2.24595839e-01, 2.99279513e-01, 3.63763217e-01},
{9.44200036e-02, 1.29964977e-01, 1.88128534e-01, 3.56816285e-01, 5.32962057e-01, 6.23649286e-01},
{1.04688725e-01, 1.35571378e-01, 1.82412661e-01, 3.46947428e-01, 4.17190626e-01, 4.44438015e-01},
{1.46329140e-01, 1.73435802e-01, 3.07207894e-01, 4.04289386e-01, 4.35534405e-01, 5.23965791e-01},
{7.66526866e-02, 1.09703789e-01, 1.49410328e-01, 3.18523477e-01, 4.54082108e-01, 4.82966039e-01},
{5.74561757e-02, 8.27129063e-02, 2.57807903e-01, 3.71641990e-01, 4.77248349e-01, 5.19276920e-01},
{1.54568135e-01, 2.26479512e-01, 2.75109059e-01, 3.51656716e-01, 4.09981998e-01, 4.42452093e-01},
{7.23329115e-02, 1.04110988e-01, 1.89387567e-01, 2.97414945e-01, 4.22548723e-01, 4.84645608e-01},
{1.10849231e-01, 1.31606071e-01, 2.12534838e-01, 2.45851763e-01, 3.40661986e-01, 5.44819277e-01},
{9.45825559e-02, 1.28904079e-01, 2.37290692e-01, 3.95588294e-01, 5.03440428e-01, 5.54833698e-01},
{1.06938305e-01, 1.62166851e-01, 2.01756828e-01, 2.83768915e-01, 3.40745017e-01, 3.71150214e-01},
{1.34322259e-01, 2.19166979e-01, 2.73765956e-01, 3.86072817e-01, 4.84682350e-01, 5.17491998e-01},
{6.41837149e-02, 8.35804584e-02, 2.03273355e-01, 3.20849273e-01, 3.74535463e-01, 4.70052287e-01},
{9.27358029e-02, 1.12794378e-01, 2.03385465e-01, 4.34498384e-01, 4.79238087e-01, 5.31300802e-01},
{1.56901326e-01, 1.92168152e-01, 2.56654150e-01, 3.80925028e-01, 4.33572648e-01, 4.63745173e-01},
{1.09872693e-01, 1.34209771e-01, 2.52515736e-01, 3.54207854e-01, 3.92962460e-01, 5.50808834e-01},
{9.24938812e-02, 1.26847515e-01, 1.73888734e-01, 2.59062404e-01, 3.02911164e-01, 4.06032374e-01},
{9.07435267e-02, 1.33437140e-01, 1.57681844e-01, 2.58272775e-01, 4.90737772e-01, 5.75987977e-01},
{6.91169628e-02, 1.29800029e-01, 2.92678897e-01, 3.40817305e-01, 3.91945660e-01, 4.46967377e-01},
{9.49904649e-02, 1.35718404e-01, 1.94892026e-01, 3.05632167e-01, 4.62535334e-01, 5.17388199e-01},
{6.94961686e-02, 8.87477445e-02, 1.32414054e-01, 2.28522318e-01, 3.77726643e-01, 4.83765661e-01},
{1.09323203e-01, 1.34440663e-01, 2.14403486e-01, 3.85743898e-01, 4.66632980e-01, 4.90584867e-01},
{1.22604385e-01, 1.46651200e-01, 2.56945151e-01, 3.12685220e-01, 3.52524830e-01, 5.38904280e-01},
{8.74361618e-02, 1.06791318e-01, 2.07692192e-01, 3.02164777e-01, 4.46085146e-01, 4.90144144e-01},
{1.51842363e-01, 1.80438335e-01, 2.52295262e-01, 2.83727438e-01, 3.66032884e-01, 5.50183934e-01},
{1.22009555e-01, 1.82061623e-01, 2.05541689e-01, 3.07864763e-01, 4.78025955e-01, 5.71683824e-01},
{1.11907205e-01, 1.51285634e-01, 2.07976008e-01, 2.93030387e-01, 3.38700108e-01, 4.10506073e-01},
{7.28138546e-02, 1.29240239e-01, 3.06895955e-01, 3.45969216e-01, 4.62577754e-01, 5.03486687e-01},
{8.85541694e-02, 1.06599706e-01, 1.97134705e-01, 3.22794654e-01, 3.56102099e-01, 4.96838823e-01},
{6.27399951e-02, 8.17874558e-02, 2.17707861e-01, 4.04056749e-01, 5.20843576e-01, 5.63193180e-01},
{1.25113041e-01, 1.48565385e-01, 2.75962414e-01, 3.91443010e-01, 4.18215803e-01, 4.77744291e-01},
{7.60465424e-02, 9.68749263e-02, 1.99390592e-01, 3.29523670e-01, 3.92177251e-01, 4.86244174e-01},
{7.83693947e-02, 1.03691083e-01, 1.68081121e-01, 2.79876241e-01, 3.14737526e-01, 4.22705968e-01},
{7.05923635e-02, 9.20878354e-02, 1.77627100e-01, 3.21071207e-01, 5.22667396e-01, 6.05988422e-01},
{1.29757349e-01, 1.73637941e-01, 2.33497609e-01, 3.38543139e-01, 3.93456471e-01, 4.31597707e-01},
{1.10589908e-01, 1.30163123e-01, 2.58853931e-01, 3.99930119e-01, 4.35580162e-01, 4.67381475e-01},
{6.70111663e-02, 1.00300419e-01, 1.57520602e-01, 2.81109365e-01, 4.79883403e-01, 5.02053858e-01},
{9.64881667e-02, 1.14308285e-01, 2.26931214e-01, 4.05727759e-01, 4.31199024e-01, 5.42850770e-01},
{1.17599001e-01, 1.92169955e-01, 2.56035681e-01, 3.17832256e-01, 3.75440606e-01, 4.07314532e-01},
{7.02488046e-02, 9.60899427e-02, 1.75846785e-01, 3.44958698e-01, 4.08959172e-01, 4.55333405e-01},
{1.01554101e-01, 1.22384167e-01, 1.71818644e-01, 2.12502802e-01, 3.70362053e-01, 5.37754534e-01},
{1.11490380e-01, 1.46837903e-01, 2.00268756e-01, 3.34526302e-01, 4.80138348e-01, 5.23679210e-01},
{1.14604011e-01, 1.75917071e-01, 2.38519143e-01, 2.73589342e-01, 3.08571983e-01, 3.83980346e-01},
{9.57061820e-02, 1.94558096e-01, 2.77948130e-01, 3.40238390e-01, 4.59382151e-01, 4.97328700e-01},
{7.29353853e-02, 9.81764453e-02, 1.60821769e-01, 2.70636591e-01, 3.78428290e-01, 4.61716922e-01},
{9.66936195e-02, 1.13387139e-01, 2.05422168e-01, 4.31645024e-01, 4.96235987e-01, 5.24886962e-01},
{1.41345450e-01, 1.93768796e-01, 2.76072347e-01, 3.80387990e-01, 4.07386924e-01, 5.36132339e-01},
{9.03952314e-02, 1.07965537e-01, 2.12044098e-01, 3.66894542e-01, 3.93354887e-01, 5.40446088e-01},
{8.86684224e-02, 1.27138889e-01, 2.16657964e-01, 2.50935015e-01, 3.14321624e-01, 4.36475717e-01},
{6.71603715e-02, 8.51850291e-02, 1.69345048e-01, 3.40148663e-01, 5.07267062e-01, 5.80817350e-01},
{8.79363367e-02, 1.17192509e-01, 2.53367214e-01, 3.06566275e-01, 3.48869650e-01, 4.07714840e-01},
{1.19172584e-01, 1.70640252e-01, 2.23375511e-01, 3.63493069e-01, 4.82051237e-01, 5.09695310e-01},
{5.81939940e-02, 7.41031700e-02, 1.29933539e-01, 2.36362292e-01, 3.98940429e-01, 4.48316240e-01},
{9.97604069e-02, 1.15645472e-01, 2.53103022e-01, 4.19834342e-01, 4.49880217e-01, 4.85081358e-01},
{1.46352194e-01, 1.93322231e-01, 2.69017748e-01, 3.52821940e-01, 3.80079867e-01, 5.26671231e-01},
{9.71842556e-02, 1.40993538e-01, 2.09501347e-01, 3.14725850e-01, 4.33778809e-01, 4.59950327e-01},
{1.11371886e-01, 1.53863982e-01, 2.34508653e-01, 2.87058088e-01, 3.26871390e-01, 4.52246606e-01},
{8.07978753e-02, 1.29778120e-01, 2.36785048e-01, 2.89454838e-01, 4.57601831e-01, 5.59402323e-01},
{1.22842678e-01, 1.92490520e-01, 2.49008305e-01, 3.03990254e-01, 3.48610444e-01, 4.04975285e-01},
{7.21003916e-02, 1.25865430e-01, 3.83008733e-01, 4.70027248e-01, 5.12263016e-01, 5.79721221e-01},
{7.77057507e-02, 1.04914836e-01, 1.69193973e-01, 2.82246661e-01, 3.61739814e-01, 4.77379324e-01},
{9.42901835e-02, 1.11005854e-01, 1.69609227e-01, 3.77756616e-01, 5.11792855e-01, 5.52165134e-01},
{1.30768843e-01, 1.64853018e-01, 2.23941037e-01, 3.63298918e-01, 4.26461371e-01, 4.55963028e-01},
{8.12416341e-02, 1.06185720e-01, 2.69254717e-01, 3.25183373e-01, 4.03796378e-01, 5.15924761e-01},
{8.14529746e-02, 1.10051921e-01, 1.69597155e-01, 2.23254796e-01, 2.77854624e-01, 4.14968460e-01},
{9.99437457e-02, 1.29634349e-01, 1.69731013e-01, 3.05910920e-01, 4.83747210e-01, 5.85856985e-01},
{9.83297601e-02, 1.28509766e-01, 2.15782852e-01, 3.47766674e-01, 4.08815132e-01, 4.41594130e-01},
{1.14887125e-01, 1.42243768e-01, 2.55674796e-01, 4.45777504e-01, 4.76813118e-01, 5.44670994e-01},
{7.92891722e-02, 1.05070127e-01, 1.81503685e-01, 3.72718082e-01, 4.58207971e-01, 4.87592931e-01},
{6.42388130e-02, 8.54541458e-02, 2.22842648e-01, 3.58415227e-01, 4.63859475e-01, 5.43976360e-01},
{1.17762533e-01, 2.21487250e-01, 2.82511163e-01, 3.31948852e-01, 4.00071174e-01, 4.29327592e-01},
{7.52729324e-02, 1.05652443e-01, 1.78448978e-01, 3.35045083e-01, 4.27513674e-01, 4.48052991e-01},
{8.79992010e-02, 1.03722821e-01, 1.84233290e-01, 2.42784531e-01, 3.04803490e-01, 5.16600319e-01},
{7.93427031e-02, 1.10724464e-01, 2.01426518e-01, 3.29452223e-01, 5.01496567e-01, 5.32028083e-01},
{9.58722385e-02, 1.20627348e-01, 2.34907829e-01, 2.84198546e-01, 3.35538696e-01, 3.81821421e-01},
{1.17923711e-01, 1.84853157e-01, 2.31303393e-01, 3.32137250e-01, 4.64851653e-01, 5.01028518e-01},
{6.81252259e-02, 9.51074240e-02, 1.41441026e-01, 2.97604392e-01, 4.24358406e-01, 4.64403613e-01},
{8.46202937e-02, 1.12828715e-01, 1.73306542e-01, 3.52934789e-01, 4.86748759e-01, 5.09986008e-01},
{1.20647244e-01, 2.10871853e-01, 2.62515781e-01, 3.29824654e-01, 4.29729515e-01, 4.62807433e-01},
{8.91996323e-02, 1.05840925e-01, 2.59689404e-01, 3.63697963e-01, 4.10079429e-01, 5.68606306e-01},
{9.98569263e-02, 1.58018520e-01, 1.88261441e-01, 2.47124675e-01, 2.94874403e-01, 3.63196723e-01},
{7.67947202e-02, 9.86294749e-02, 1.66910183e-01, 2.49470050e-01, 4.76447187e-01, 5.70913629e-01},
{9.03700416e-02, 1.11227218e-01, 2.16888939e-01, 3.33870102e-01, 3.63666954e-01, 4.33104714e-01},
{8.44282007e-02, 1.13296588e-01, 2.42031584e-01, 3.65696153e-01, 4.68520999e-01, 4.96119521e-01},
{6.70688870e-02, 9.29621578e-02, 1.61341015e-01, 2.56896412e-01, 4.59437421e-01, 4.95434431e-01},
{1.16053661e-01, 1.42596909e-01, 2.01257660e-01, 3.89863190e-01, 4.86121583e-01, 5.18193061e-01},
{1.40613025e-01, 1.69478092e-01, 2.55880113e-01, 2.97225400e-01, 3.48916522e-01, 5.05796133e-01},
{9.32487869e-02, 1.28847141e-01, 1.94792323e-01, 3.23416476e-01, 4.46520788e-01, 4.70038223e-01},
{1.16689115e-01, 1.38286266e-01, 2.36625990e-01, 2.78247951e-01, 3.59497045e-01, 5.63642650e-01},
{8.38745215e-02, 1.25847961e-01, 1.97186320e-01, 2.76145978e-01, 4.51087396e-01, 5.76630672e-01},
{1.05173586e-01, 1.71242183e-01, 2.64856673e-01, 3.18205222e-01, 3.54141743e-01, 4.19335267e-01},
{6.37595787e-02, 1.22178348e-01, 3.25468990e-01, 3.83549117e-01, 4.68893436e-01, 5.26432982e-01},
{7.24442056e-02, 9.51475135e-02, 2.53367040e-01, 3.05409520e-01, 3.74390779e-01, 4.98085981e-01},
{8.84295509e-02, 1.03807184e-01, 1.86831987e-01, 4.45571061e-01, 5.49229273e-01, 5.71059511e-01},
{1.24137833e-01, 1.57523493e-01, 2.16917678e-01, 3.58252063e-01, 4.01136279e-01, 4.51035301e-01},
{5.73332943e-02, 7.09744601e-02, 1.40162672e-01, 2.96907085e-01, 4.42521836e-01, 5.28567859e-01},
{6.20758958e-02, 8.41171081e-02, 1.93999443e-01, 2.76437238e-01, 3.41537596e-01, 3.99558621e-01},
{7.36788718e-02, 1.02712670e-01, 1.28773733e-01, 3.24223755e-01, 5.33230683e-01, 6.07914949e-01},
{1.18365434e-01, 1.42308536e-01, 2.61821204e-01, 3.06236300e-01, 3.64298441e-01, 4.31101141e-01},
{1.07380459e-01, 1.46658484e-01, 2.55332951e-01, 3.98076062e-01, 4.53389549e-01, 4.80392826e-01},
{7.35726868e-02, 9.81761899e-02, 1.95312204e-01, 3.03652898e-01, 4.78166785e-01, 5.38080507e-01},
{6.55303174e-02, 8.42372041e-02, 2.08566085e-01, 4.00806535e-01, 4.51428529e-01, 4.98264233e-01},
{1.60062544e-01, 2.09170682e-01, 2.64747951e-01, 3.46239429e-01, 3.77979121e-01, 4.46023016e-01},
{1.03278559e-01, 1.21098123e-01, 2.64589577e-01, 3.89478572e-01, 4.17083064e-01, 4.64358040e-01},
{1.19124626e-01, 1.41932228e-01, 2.08559441e-01, 2.38847698e-01, 3.87435602e-01, 5.93260460e-01},
{1.12440612e-01, 1.88224842e-01, 2.37768688e-01, 3.30704369e-01, 4.98587030e-01, 5.34144097e-01},
{1.26918785e-01, 1.61468076e-01, 2.28537762e-01, 2.87839007e-01, 3.14713303e-01, 4.29140147e-01},
{9.72256650e-02, 1.82461726e-01, 2.55773843e-01, 3.28161870e-01, 4.78097655e-01, 5.29351354e-01},
{5.70525717e-02, 7.49290467e-02, 1.37131766e-01, 2.22881998e-01, 3.38651168e-01, 4.74109802e-01},
{9.81907818e-02, 1.31973634e-01, 2.48267075e-01, 4.43146190e-01, 5.33955720e-01, 5.66318875e-01},
{1.63735896e-01, 2.41969731e-01, 2.92022239e-01, 3.90080218e-01, 4.44197628e-01, 4.72766973e-01},
{8.22484047e-02, 1.39211794e-01, 2.84054608e-01, 3.34661272e-01, 4.03697868e-01, 4.75108268e-01},
{1.12763322e-01, 1.33800657e-01, 2.03550245e-01, 2.54425424e-01, 3.03034868e-01, 4.80077512e-01},
{6.41945822e-02, 8.99571163e-02, 1.53882400e-01, 2.32270992e-01, 5.02191601e-01, 5.34259395e-01},
{9.30780663e-02, 1.37634564e-01, 1.95023111e-01, 2.93377117e-01, 3.76120128e-01, 4.06122953e-01},
{1.08246718e-01, 1.55825323e-01, 2.30951167e-01, 3.60675332e-01, 4.59142282e-01, 4.81152461e-01},
{6.29884956e-02, 8.23877977e-02, 1.51690525e-01, 2.51426924e-01, 4.29698884e-01, 5.13461141e-01},
{1.02835755e-01, 1.20106938e-01, 2.99340822e-01, 4.60059973e-01, 4.86713993e-01, 5.47156526e-01},
{1.11621087e-01, 1.55920882e-01, 2.71094468e-01, 3.49990223e-01, 3.85581430e-01, 4.97415696e-01},
{1.01907039e-01, 1.24024085e-01, 1.87020593e-01, 3.52078030e-01, 4.32059991e-01, 4.57495849e-01},
{1.31852620e-01, 1.63497960e-01, 2.17637438e-01, 2.51548683e-01, 3.11308784e-01, 4.90696230e-01},
{1.05982567e-01, 1.37168649e-01, 2.05653201e-01, 3.51562772e-01, 5.06128280e-01, 5.77323094e-01},
{1.20601955e-01, 1.64373242e-01, 2.34635870e-01, 3.08488187e-01, 3.35742028e-01, 4.29484281e-01},
{1.34923523e-01, 2.59809646e-01, 3.36388039e-01, 4.25167878e-01, 5.30732385e-01, 5.65449341e-01},
{9.28163743e-02, 1.31602063e-01, 2.16001572e-01, 2.71296657e-01, 4.10607741e-01, 5.17379388e-01},
{7.42801134e-02, 9.57166877e-02, 1.56258140e-01, 4.60149227e-01, 5.79413042e-01, 5.97354990e-01},
{1.20087537e-01, 1.88312710e-01, 2.35131473e-01, 3.22703815e-01, 4.21191420e-01, 4.46465068e-01},
{7.55366052e-02, 9.44266074e-02, 2.46204624e-01, 3.39184302e-01, 3.79171938e-01, 5.12296584e-01},
{7.96944981e-02, 1.07151502e-01, 1.68851457e-01, 2.28186057e-01, 3.27088454e-01, 4.12526881e-01},
{8.58427403e-02, 1.11111368e-01, 2.27770880e-01, 3.60903739e-01, 5.51899023e-01, 5.85610721e-01},
{1.15919824e-01, 1.67022724e-01, 2.11382626e-01, 3.16276243e-01, 3.93810953e-01, 4.22154331e-01},
{1.34692798e-01, 1.66209276e-01, 2.78486530e-01, 3.85860170e-01, 4.11227133e-01, 5.24201137e-01},
{8.64121194e-02, 1.24015001e-01, 1.60629760e-01, 2.98052733e-01, 4.73263354e-01, 5.06298588e-01},
{5.78930208e-02, 8.30523054e-02, 2.68611178e-01, 3.60145549e-01, 4.41855485e-01, 5.05056472e-01},
{1.51710475e-01, 1.86459258e-01, 2.58549593e-01, 3.56690435e-01, 3.95404097e-01, 4.38797166e-01},
{5.89321951e-02, 7.43513547e-02, 1.47579443e-01, 3.12467625e-01, 4.45236721e-01, 4.82201581e-01},
{1.03292358e-01, 1.23420164e-01, 2.03263639e-01, 2.71891286e-01, 3.07404828e-01, 5.22904502e-01},
{1.23800341e-01, 1.44404847e-01, 1.88671110e-01, 3.87504348e-01, 5.10748057e-01, 5.52809308e-01},
{1.01596663e-01, 1.55917659e-01, 2.07705471e-01, 2.69192981e-01, 3.04851059e-01, 3.51381864e-01},
{1.45838629e-01, 2.00334866e-01, 2.43048260e-01, 3.74287364e-01, 4.69408023e-01, 4.93341202e-01},
{7.05805752e-02, 9.54389734e-02, 1.43711525e-01, 3.17069453e-01, 3.75294908e-01, 4.60435595e-01},
{7.04676472e-02, 9.55121853e-02, 2.08267104e-01, 4.07548831e-01, 4.80528238e-01, 5.34867241e-01},
{1.32584629e-01, 1.86863920e-01, 2.23394955e-01, 3.40008202e-01, 4.35044914e-01, 4.57365437e-01},
{1.01947098e-01, 1.23846084e-01, 2.78896242e-01, 3.81449846e-01, 4.07666166e-01, 4.89507090e-01},
{8.60756348e-02, 1.22660783e-01, 1.77205470e-01, 2.76917181e-01, 3.29379413e-01, 3.60464052e-01},
{7.06441384e-02, 9.98559118e-02, 1.89740259e-01, 2.79260588e-01, 4.23790339e-01, 5.87781561e-01},
{8.94235426e-02, 1.16014195e-01, 2.52830583e-01, 2.89628286e-01, 3.76771407e-01, 4.35278315e-01},
{9.78211351e-02, 1.52504184e-01, 1.81380028e-01, 2.95366331e-01, 4.89090844e-01, 5.27645960e-01},
{8.19986636e-02, 1.02739051e-01, 1.68241722e-01, 2.28186692e-01, 3.78979359e-01, 5.33843538e-01},
{1.26553039e-01, 1.48208308e-01, 2.24356355e-01, 3.89779838e-01, 4.77651593e-01, 5.01852145e-01},
{1.39082083e-01, 1.72001701e-01, 2.65091961e-01, 3.23876441e-01, 3.59278839e-01, 5.44268834e-01},
{8.43612047e-02, 1.44083065e-01, 2.58651038e-01, 3.30473520e-01, 4.43238282e-01, 4.91327334e-01},
{1.19453003e-01, 1.43019224e-01, 2.17497783e-01, 2.48839380e-01, 3.28296584e-01, 5.85806947e-01},
{9.80943967e-02, 1.46483420e-01, 1.70607593e-01, 2.64737687e-01, 4.77054016e-01, 5.82162345e-01},
{1.23544417e-01, 1.72332669e-01, 2.41925741e-01, 3.20355806e-01, 3.49676109e-01, 4.75824631e-01},
{7.75767790e-02, 1.36915147e-01, 3.55021977e-01, 4.00093857e-01, 4.34353059e-01, 4.85639274e-01},
{8.12125182e-02, 9.98968873e-02, 2.21080805e-01, 2.95982475e-01, 3.41268580e-01, 5.14768488e-01},
{8.33575158e-02, 9.64799127e-02, 2.08674620e-01, 4.64168679e-01, 5.23084697e-01, 5.48781306e-01},
{8.03326405e-02, 1.38297124e-01, 3.08727230e-01, 3.68871559e-01, 4.11058878e-01, 4.53701508e-01},
{7.86319555e-02, 1.03203138e-01, 1.82386356e-01, 3.50934225e-01, 4.36037177e-01, 5.07895543e-01},
{8.76908485e-02, 1.08578061e-01, 2.21839257e-01, 2.91388002e-01, 3.35421471e-01, 4.68678417e-01},
{8.19843367e-02, 1.05308527e-01, 1.68229011e-01, 3.40965529e-01, 5.51133772e-01, 6.06194859e-01},
{1.13369306e-01, 1.92397853e-01, 2.60998664e-01, 3.30941334e-01, 3.91732598e-01, 4.22585797e-01},
{1.24265457e-01, 1.41482941e-01, 2.29900374e-01, 3.88780888e-01, 4.42674118e-01, 4.68417634e-01},
{6.78323208e-02, 9.74429074e-02, 1.54145390e-01, 3.03447993e-01, 4.92197051e-01, 5.20097679e-01},
{8.47597182e-02, 1.00097641e-01, 2.34004590e-01, 4.04247963e-01, 4.46947822e-01, 5.87174693e-01},
{8.91938006e-02, 1.82274853e-01, 2.80645289e-01, 3.39109939e-01, 4.01680083e-01, 4.37566666e-01},
{8.23841455e-02, 1.17843423e-01, 2.52850113e-01, 3.57221696e-01, 4.12620828e-01, 4.41500216e-01},
{9.34615205e-02, 1.09896379e-01, 1.77322916e-01, 2.19004050e-01, 3.06277780e-01, 5.51741678e-01},
{1.23096926e-01, 1.77076153e-01, 2.27301804e-01, 3.23739575e-01, 4.71356896e-01, 5.23570606e-01},
{1.00909233e-01, 1.74217105e-01, 2.44860088e-01, 2.91100696e-01, 3.49600237e-01, 3.89632345e-01},
{1.09593418e-01, 1.98587318e-01, 2.86618618e-01, 3.18203776e-01, 4.24628556e-01, 4.99725163e-01},
{6.34050395e-02, 8.62111626e-02, 1.52985242e-01, 2.88237680e-01, 3.84635840e-01, 4.22034187e-01},
{8.17100285e-02, 9.62491364e-02, 2.62817707e-01, 4.76151899e-01, 5.02346647e-01, 5.59826460e-01},
{1.49655251e-01, 1.93037960e-01, 2.66005062e-01, 3.75769168e-01, 4.02016157e-01, 4.85590222e-01},
{7.30286414e-02, 9.14934506e-02, 2.32528142e-01, 3.60918707e-01, 3.99096913e-01, 5.01418117e-01},
{8.17505461e-02, 1.04527965e-01, 1.67602850e-01, 2.25699741e-01, 3.74456536e-01, 4.82650267e-01},
{7.71126376e-02, 1.04651192e-01, 1.42895225e-01, 3.17681537e-01, 5.28192053e-01, 5.65068836e-01},
{1.03338525e-01, 1.31378577e-01, 2.24797834e-01, 3.01840110e-01, 3.48012942e-01, 4.43678957e-01},
{1.01275731e-01, 1.46587372e-01, 2.07485557e-01, 3.25684404e-01, 4.68928174e-01, 5.02943539e-01},
{6.58655621e-02, 8.47616175e-02, 1.56849263e-01, 2.55241393e-01, 4.10054575e-01, 4.79458559e-01},
{1.17813885e-01, 1.37074278e-01, 2.88628402e-01, 4.29444029e-01, 4.57179597e-01, 5.20081228e-01},
{1.50991157e-01, 1.82098533e-01, 2.78501337e-01, 3.29011260e-01, 3.71900822e-01, 5.04073027e-01},
{1.12506932e-01, 1.53973600e-01, 2.06961819e-01, 3.40467317e-01, 4.43890057e-01, 4.64945517e-01},
{8.97091492e-02, 1.62864392e-01, 2.36988200e-01, 2.68956548e-01, 3.60585378e-01, 4.29600986e-01},
{9.20787095e-02, 1.09248608e-01, 2.19214968e-01, 3.51222088e-01, 5.06913078e-01, 5.56564937e-01},
{1.50631940e-01, 1.98235103e-01, 2.47530045e-01, 3.21700469e-01, 3.44462113e-01, 4.38754058e-01},
{6.88009190e-02, 1.18194810e-01, 3.60796162e-01, 4.46436672e-01, 4.88988713e-01, 5.42221370e-01},
{7.21859534e-02, 9.80300143e-02, 1.57371259e-01, 2.66662147e-01, 3.69761382e-01, 5.01641142e-01},
{7.13543047e-02, 8.90841729e-02, 1.57419288e-01, 4.15633743e-01, 5.53756262e-01, 5.76060558e-01},
{1.41591841e-01, 1.69546392e-01, 2.49426185e-01, 3.69919228e-01, 3.99448867e-01, 4.59254521e-01},
{7.39619417e-02, 1.17468849e-01, 2.54413715e-01, 3.27429149e-01, 4.24589156e-01, 5.02652519e-01},
{8.07310303e-02, 1.09402623e-01, 1.50988113e-01, 1.93085047e-01, 2.92281617e-01, 4.45429155e-01},
{9.03399008e-02, 1.18105154e-01, 1.69186733e-01, 3.73164407e-01, 5.23235719e-01, 5.86568630e-01},
{1.10636652e-01, 1.35196444e-01, 2.41712981e-01, 3.42424116e-01, 3.72354776e-01, 4.29160780e-01},
{1.15086416e-01, 1.50096651e-01, 2.41011386e-01, 4.15790439e-01, 4.52885725e-01, 5.09081571e-01},
{9.30740377e-02, 1.26697283e-01, 1.86380123e-01, 3.59756869e-01, 4.72261076e-01, 4.93505888e-01},
{7.79041714e-02, 1.14507646e-01, 2.54896128e-01, 3.75809738e-01, 4.99808075e-01, 5.27191725e-01},
{1.49084884e-01, 2.36148841e-01, 2.94594038e-01, 3.60714576e-01, 3.93961334e-01, 4.43164098e-01},
{9.17325049e-02, 1.29378319e-01, 1.85590817e-01, 3.29478059e-01, 4.12523404e-01, 4.75022374e-01},
{9.16991421e-02, 1.08077877e-01, 2.15129822e-01, 2.55950795e-01, 3.39486870e-01, 5.93397515e-01},
{9.43566025e-02, 1.25986806e-01, 1.82719869e-01, 3.60266384e-01, 5.04238632e-01, 5.56520392e-01},
{9.19478454e-02, 1.18573025e-01, 1.84902147e-01, 2.89500626e-01, 3.15804969e-01, 4.11499271e-01},
{1.47544784e-01, 1.89320973e-01, 2.33375976e-01, 3.81012693e-01, 4.53258392e-01, 4.79294622e-01},
{8.54438439e-02, 1.04462162e-01, 1.88600426e-01, 2.83017894e-01, 4.20475542e-01, 4.56539424e-01},
{8.30912027e-02, 1.01377383e-01, 1.64026407e-01, 3.90882785e-01, 5.01255745e-01, 5.25807805e-01},
{1.49190975e-01, 2.34881779e-01, 2.93542946e-01, 3.65137405e-01, 4.15730737e-01, 4.50406544e-01},
{8.63766755e-02, 1.18722956e-01, 2.78456153e-01, 3.89621801e-01, 4.38913099e-01, 5.18119018e-01},
{1.08822038e-01, 1.35086594e-01, 1.99237709e-01, 2.57426040e-01, 2.94187704e-01, 4.15549446e-01},
{7.63351702e-02, 1.20537388e-01, 1.46992991e-01, 2.34786208e-01, 4.75004208e-01, 5.62072599e-01},
{7.98485832e-02, 1.06750085e-01, 2.23225927e-01, 3.47653820e-01, 3.77348170e-01, 4.65940802e-01},
{8.48131486e-02, 1.08650270e-01, 2.16907206e-01, 3.22141690e-01, 4.31318235e-01, 5.31782702e-01},
{6.81215034e-02, 9.75197012e-02, 1.49827749e-01, 2.17636423e-01, 4.20596722e-01, 5.57801723e-01},
{1.30336541e-01, 1.63238382e-01, 2.27729784e-01, 3.80151371e-01, 5.00193439e-01, 5.45020075e-01},
{1.40985943e-01, 1.80266757e-01, 2.47775502e-01, 2.93551982e-01, 3.41511142e-01, 5.44118346e-01},
{9.99394893e-02, 1.18957890e-01, 1.97555819e-01, 3.96117966e-01, 4.61057681e-01, 4.89139295e-01},
{1.06652644e-01, 1.25618185e-01, 2.31121979e-01, 2.68333064e-01, 3.42381652e-01, 5.68628983e-01},
{8.19344552e-02, 1.15938462e-01, 1.79239899e-01, 2.81726408e-01, 5.03436259e-01, 6.17994514e-01},
{1.02149514e-01, 1.49847337e-01, 2.14054539e-01, 2.92954548e-01, 3.56836295e-01, 4.00839050e-01},
{6.44592074e-02, 1.13007254e-01, 2.88848675e-01, 3.68273482e-01, 5.08157793e-01, 5.47437397e-01},
{8.87289104e-02, 1.10691480e-01, 2.04827584e-01, 2.52624753e-01, 3.76844236e-01, 4.70157997e-01},
{7.86649683e-02, 8.99907240e-02, 2.23124675e-01, 4.99299238e-01, 5.57135574e-01, 5.83656619e-01},
{1.07948055e-01, 1.31784116e-01, 2.68895401e-01, 3.62174714e-01, 3.92334410e-01, 4.43192611e-01},
{6.10193961e-02, 7.86812590e-02, 1.95360832e-01, 3.49441040e-01, 4.48481003e-01, 5.05414911e-01},
{8.28447128e-02, 1.19043271e-01, 1.65948753e-01, 2.97315581e-01, 3.65356831e-01, 4.01371609e-01},
{7.77985903e-02, 1.09446158e-01, 1.48524260e-01, 3.23209527e-01, 4.97706333e-01, 5.95087319e-01},
{1.06064794e-01, 1.39957425e-01, 2.11957349e-01, 3.31427915e-01, 3.81400300e-01, 4.22975657e-01},
{8.37549851e-02, 1.50976752e-01, 2.73161811e-01, 3.45410601e-01, 4.26990181e-01, 4.56567683e-01},
{7.25398733e-02, 9.15555187e-02, 1.53005015e-01, 2.86636567e-01, 4.12981622e-01, 5.24096650e-01},
{1.00023560e-01, 1.21495999e-01, 2.07083700e-01, 3.93421085e-01, 4.35611777e-01, 4.94251828e-01},
{1.52666088e-01, 2.21527591e-01, 2.67128863e-01, 3.33774134e-01, 3.65451847e-01, 4.33084544e-01},
{1.00383551e-01, 1.21225963e-01, 1.97317414e-01, 3.92724932e-01, 4.23978053e-01, 4.72792380e-01},
{1.01454195e-01, 1.18968238e-01, 1.94901259e-01, 2.26037502e-01, 3.46619855e-01, 6.16904585e-01},
{1.17576052e-01, 1.72774635e-01, 2.24816954e-01, 3.16342351e-01, 5.08987282e-01, 5.82555122e-01},
{1.07425403e-01, 1.43788320e-01, 2.14390346e-01, 2.63265020e-01, 3.26238158e-01, 4.57854803e-01},
{1.21026929e-01, 2.20595336e-01, 2.71759316e-01, 3.29316648e-01, 4.75756561e-01, 5.40223841e-01},
{6.50635271e-02, 9.00367714e-02, 1.41346993e-01, 2.28080085e-01, 3.48431540e-01, 4.34749079e-01},
{1.08369676e-01, 1.24640484e-01, 2.61545643e-01, 4.74774512e-01, 5.07930643e-01, 5.58192045e-01},
{1.33954675e-01, 2.42621163e-01, 3.19592149e-01, 3.49939098e-01, 4.39063366e-01, 4.88751177e-01},
{1.07572743e-01, 1.34061663e-01, 2.46980042e-01, 3.40478100e-01, 3.68545925e-01, 5.24479684e-01},
{1.11588979e-01, 1.35472093e-01, 2.14544802e-01, 2.45172987e-01, 3.86663002e-01, 5.11528822e-01},
{8.23710569e-02, 1.27187039e-01, 1.58692087e-01, 2.78415347e-01, 4.88338209e-01, 5.28941192e-01},
{9.47103082e-02, 1.23463432e-01, 1.90583906e-01, 3.29558990e-01, 3.61894762e-01, 4.12681213e-01},
{1.22797228e-01, 1.71262524e-01, 2.43835810e-01, 3.74124044e-01, 4.41099138e-01, 4.68710936e-01},
{5.42077066e-02, 6.69666123e-02, 1.25181220e-01, 2.71839439e-01, 4.22340284e-01, 4.93568780e-01},
{1.08212334e-01, 1.25790611e-01, 2.65787079e-01, 4.43206448e-01, 4.83959031e-01, 5.17292290e-01},
{1.26957835e-01, 1.67861416e-01, 2.57250155e-01, 3.55713091e-01, 3.90260853e-01, 4.60815920e-01},
{1.06002903e-01, 1.35371015e-01, 1.98878832e-01, 3.71706867e-01, 4.28484349e-01, 4.61867786e-01},
{1.25501215e-01, 1.54882020e-01, 2.31137237e-01, 2.87316339e-01, 3.30371282e-01, 4.90334034e-01},
{8.56055764e-02, 1.36518526e-01, 2.37018369e-01, 3.29619218e-01, 4.85447273e-01, 6.21990072e-01},
{1.43243899e-01, 1.91030573e-01, 2.36152493e-01, 3.07458813e-01, 3.30228572e-01, 4.16139109e-01},
{1.31239635e-01, 2.17375391e-01, 3.37667896e-01, 4.16884867e-01, 4.78987304e-01, 5.44092645e-01},
{7.04867760e-02, 8.98095290e-02, 2.02940717e-01, 3.26802857e-01, 4.27520971e-01, 5.42592337e-01},
{7.79967391e-02, 1.01449831e-01, 2.14960784e-01, 3.90669946e-01, 5.52165153e-01, 6.28082058e-01},
{9.50466775e-02, 1.69969925e-01, 2.53519043e-01, 3.16960926e-01, 4.20516135e-01, 4.48929567e-01},
{1.07034353e-01, 1.25645130e-01, 2.48229651e-01, 3.14587413e-01, 3.62651545e-01, 5.63965752e-01},
{6.64150103e-02, 1.00351779e-01, 1.43144050e-01, 2.67091265e-01, 3.36773030e-01, 3.83729606e-01},
{9.80500203e-02, 1.17216229e-01, 2.22300871e-01, 3.73222257e-01, 5.20987457e-01, 5.99246001e-01},
{8.24304150e-02, 1.17857462e-01, 2.06435199e-01, 3.21749878e-01, 4.09819310e-01, 4.42346800e-01},
{1.46675365e-01, 1.99091887e-01, 2.68667380e-01, 3.90907571e-01, 4.18190430e-01, 5.07397316e-01},
{9.37663341e-02, 1.26213735e-01, 1.63205053e-01, 3.42911345e-01, 4.59421080e-01, 4.90122608e-01},
{6.31251671e-02, 8.79514931e-02, 2.86178285e-01, 3.94179840e-01, 4.52155433e-01, 5.26383277e-01},
{1.61762272e-01, 2.15186916e-01, 2.64451296e-01, 3.67976743e-01, 4.22631276e-01, 4.54553014e-01},
{7.38539123e-02, 1.05481126e-01, 1.67329273e-01, 2.71001548e-01, 4.29811109e-01, 4.72176737e-01},
{1.02065423e-01, 1.20309192e-01, 1.91377161e-01, 2.34250996e-01, 3.40801510e-01, 5.44055685e-01},
{1.14166045e-01, 1.34877583e-01, 2.27466888e-01, 3.78565693e-01, 5.04760927e-01, 5.46995041e-01},
{9.00267917e-02, 1.41265979e-01, 1.81086158e-01, 2.75414311e-01, 3.53586335e-01, 3.79422992e-01},
{1.40547210e-01, 1.80017128e-01, 2.41389307e-01, 3.80768200e-01, 4.91673274e-01, 5.23914745e-01},
{6.51572113e-02, 8.09868639e-02, 1.60036535e-01, 3.11109722e-01, 3.82183360e-01, 4.54394855e-01},
{7.80245817e-02, 9.32894711e-02, 2.26180657e-01, 4.55213007e-01, 4.83028669e-01, 5.48949022e-01},
{1.27997766e-01, 2.11323133e-01, 2.73362443e-01, 3.75170533e-01, 4.44875465e-01, 4.70774756e-01},
{9.35938424e-02, 1.17098593e-01, 2.63429204e-01, 3.57061086e-01, 4.03194236e-01, 5.13214896e-01},
{8.52255407e-02, 1.18471894e-01, 1.77913896e-01, 2.56634104e-01, 2.88900956e-01, 3.82606975e-01},
{9.31382687e-02, 1.18246022e-01, 1.57682475e-01, 2.60924480e-01, 4.52264115e-01, 5.72226139e-01},
{6.61299099e-02, 9.20503131e-02, 2.53147696e-01, 3.30597236e-01, 3.69427033e-01, 4.56090812e-01},
{1.09617277e-01, 1.67622374e-01, 1.99140581e-01, 3.06140499e-01, 4.66068675e-01, 5.08648777e-01},
{6.95550832e-02, 9.19565969e-02, 1.29009164e-01, 2.08991072e-01, 4.19089534e-01, 5.26667300e-01},
{1.06629358e-01, 1.28304640e-01, 2.12888919e-01, 3.90313768e-01, 4.74480136e-01, 5.06101268e-01},
{1.09656370e-01, 1.47690129e-01, 2.71241387e-01, 3.12494799e-01, 3.72363265e-01, 5.03140412e-01},
{8.76737861e-02, 1.38073591e-01, 2.16087334e-01, 3.19405446e-01, 4.53842562e-01, 4.88669111e-01},
{1.29405934e-01, 1.62020799e-01, 2.33777605e-01, 2.78903679e-01, 3.23845205e-01, 5.41507436e-01},
{1.05055387e-01, 1.64812131e-01, 2.10623008e-01, 2.95113149e-01, 4.63563223e-01, 5.78412387e-01},
{1.16848646e-01, 1.59930608e-01, 2.28654455e-01, 3.17914483e-01, 3.59542440e-01, 4.21928386e-01},
{6.80225482e-02, 1.70037862e-01, 3.00750423e-01, 3.65900820e-01, 4.85993310e-01, 5.17808062e-01},
{8.86049055e-02, 1.09760246e-01, 2.59785826e-01, 3.07222178e-01, 3.75124924e-01, 4.92612756e-01},
{7.73046298e-02, 9.12441811e-02, 1.63471656e-01, 4.50893392e-01, 5.29185667e-01, 5.49733246e-01},
{1.21177275e-01, 1.56028632e-01, 2.63593891e-01, 3.70542120e-01, 4.04088852e-01, 4.79318907e-01},
{7.01490390e-02, 9.02923372e-02, 1.81607249e-01, 3.27760562e-01, 4.06414862e-01, 4.99809301e-01},
{6.69188818e-02, 8.10608047e-02, 1.58279127e-01, 2.54022834e-01, 3.05940217e-01, 4.28246093e-01},
{7.81566394e-02, 1.13018640e-01, 1.60293803e-01, 3.30375890e-01, 5.19133619e-01, 6.26433542e-01},
{1.44291550e-01, 1.93201824e-01, 2.41659240e-01, 3.27641441e-01, 3.76397982e-01, 4.14328308e-01},
{1.05253288e-01, 1.30239315e-01, 2.62944962e-01, 4.05640428e-01, 4.31809755e-01, 5.06030180e-01},
{6.85371578e-02, 9.08145273e-02, 1.90261407e-01, 3.56675729e-01, 4.79558137e-01, 5.08785001e-01},
{8.60479985e-02, 1.07906337e-01, 2.16012782e-01, 4.06526023e-01, 4.54630456e-01, 5.34380469e-01},
{1.21328468e-01, 2.11105761e-01, 2.69646548e-01, 3.09245163e-01, 3.58393915e-01, 4.02938508e-01},
{8.12868782e-02, 1.07019316e-01, 1.81157944e-01, 3.46946392e-01, 3.88018796e-01, 4.37712534e-01},
{1.09063526e-01, 1.27955315e-01, 1.80649081e-01, 2.15923238e-01, 3.09613727e-01, 5.31358123e-01},
{1.01880425e-01, 1.67606229e-01, 2.30991049e-01, 3.24172650e-01, 4.81014075e-01, 5.20378613e-01},
{1.24940957e-01, 1.74947447e-01, 2.21065893e-01, 2.88013681e-01, 3.32887509e-01, 3.98450539e-01},
{1.21047167e-01, 2.16268337e-01, 2.98528275e-01, 3.51836056e-01, 4.59522516e-01, 5.16197026e-01},
{7.94110870e-02, 1.00025131e-01, 1.43358421e-01, 2.51352177e-01, 4.02359174e-01, 4.42857928e-01},
{8.93176194e-02, 1.04467348e-01, 2.10624428e-01, 4.49521787e-01, 4.87235709e-01, 5.54319174e-01},
{1.42391396e-01, 1.78181762e-01, 2.64605858e-01, 3.65679549e-01, 3.92643079e-01, 4.92101212e-01},
{7.80695799e-02, 9.53674434e-02, 2.10589571e-01, 3.81888965e-01, 4.12858341e-01, 5.27858411e-01},
{9.73452573e-02, 1.20808767e-01, 1.86744969e-01, 2.41080146e-01, 3.46190251e-01, 4.70581703e-01},
{8.14361282e-02, 1.10959417e-01, 1.99383449e-01, 3.08931636e-01, 4.97368048e-01, 5.77597382e-01},
{1.08044010e-01, 1.31373528e-01, 2.46354455e-01, 3.26509609e-01, 3.60292823e-01, 4.11500750e-01},
{1.17679147e-01, 1.60977175e-01, 2.16023367e-01, 3.54040443e-01, 4.69724108e-01, 4.97744165e-01},
{6.58765439e-02, 8.65096968e-02, 1.60073538e-01, 2.22321863e-01, 3.87225447e-01, 4.63802276e-01},
{8.97868329e-02, 1.07511495e-01, 2.72064184e-01, 4.25824293e-01, 4.65715478e-01, 5.00092785e-01},
{1.61664487e-01, 2.00812556e-01, 2.73811087e-01, 3.58655034e-01, 3.88097758e-01, 4.91169443e-01},
{9.99266037e-02, 1.60439997e-01, 1.91155451e-01, 2.93196464e-01, 4.36293161e-01, 4.81360476e-01},
{1.15369304e-01, 1.39887000e-01, 2.36652721e-01, 3.24912202e-01, 3.54609089e-01, 4.80042681e-01},
{8.36588831e-02, 1.41171620e-01, 2.45007182e-01, 3.18113437e-01, 4.64083988e-01, 5.80840760e-01},
{1.25668013e-01, 2.01768033e-01, 2.59181138e-01, 2.95544142e-01, 3.34171051e-01, 3.90823229e-01},
{1.41228264e-01, 2.82932960e-01, 4.05369697e-01, 4.62227571e-01, 5.42172136e-01, 5.90211920e-01},
{6.43694273e-02, 7.93063600e-02, 1.66362041e-01, 2.91104335e-01, 3.95364024e-01, 4.99766457e-01},
{8.71334125e-02, 1.07100213e-01, 1.73436164e-01, 3.55948787e-01, 5.14008520e-01, 5.75050927e-01},
{1.36375669e-01, 1.71545521e-01, 2.43160476e-01, 3.83632975e-01, 4.14921826e-01, 4.74886946e-01},
{7.50751706e-02, 1.03339708e-01, 2.57243949e-01, 2.87470972e-01, 4.18939023e-01, 5.16889712e-01},
{9.99988029e-02, 1.23114558e-01, 1.75213172e-01, 2.41364437e-01, 2.77181820e-01, 4.09743704e-01},
{1.08955850e-01, 1.41107664e-01, 1.88731610e-01, 3.19245465e-01, 4.96377736e-01, 5.97650692e-01},
{1.10800886e-01, 1.30893344e-01, 1.97745607e-01, 3.55769731e-01, 3.84010484e-01, 4.35852855e-01},
{1.32263203e-01, 1.59243898e-01, 2.74019404e-01, 4.36764811e-01, 4.66344126e-01, 5.13966003e-01},
{7.48679259e-02, 1.01639280e-01, 2.05694979e-01, 3.62716132e-01, 4.47661637e-01, 4.76871559e-01},
{7.49782786e-02, 1.00661435e-01, 2.63696785e-01, 3.51716340e-01, 4.42944430e-01, 5.23586655e-01},
{1.14368576e-01, 2.12293562e-01, 2.79395130e-01, 3.27074970e-01, 4.14982235e-01, 4.47732872e-01},
{8.23603058e-02, 1.12519617e-01, 1.67246086e-01, 3.29533419e-01, 4.45109251e-01, 4.66220935e-01},
{9.02526376e-02, 1.08062327e-01, 2.02773142e-01, 2.77633759e-01, 3.21148442e-01, 5.12729993e-01},
{1.09287435e-01, 1.47621700e-01, 2.06399999e-01, 3.52883384e-01, 5.01534653e-01, 5.40067199e-01},
{8.47693663e-02, 1.42246697e-01, 2.38822602e-01, 2.83593213e-01, 3.24576406e-01, 4.02296813e-01},
{1.08226009e-01, 1.91883939e-01, 2.50131460e-01, 3.24124644e-01, 4.52167680e-01, 4.84930908e-01},
{6.49731080e-02, 8.56467490e-02, 1.60972081e-01, 2.70132717e-01, 4.20295104e-01, 4.45286733e-01},
{8.93596164e-02, 1.11889426e-01, 1.84555666e-01, 3.61122170e-01, 4.90647796e-01, 5.29883708e-01},
{1.26485037e-01, 2.27288494e-01, 2.83563278e-01, 3.29376342e-01, 4.43686471e-01, 4.90250008e-01},
{8.03219186e-02, 9.87621925e-02, 2.97161010e-01, 3.96510403e-01, 4.32384447e-01, 5.45435868e-01},
{9.91855118e-02, 1.35039384e-01, 2.00294308e-01, 2.53970600e-01, 2.84304468e-01, 3.69676672e-01},
{6.89633550e-02, 9.33851164e-02, 1.61123343e-01, 2.78391846e-01, 4.99797942e-01, 5.95234945e-01},
{1.01002013e-01, 1.25231897e-01, 2.29324562e-01, 3.34607898e-01, 3.65372197e-01, 4.52124081e-01},
{8.69562142e-02, 1.43624652e-01, 2.37342429e-01, 3.19501263e-01, 4.66793571e-01, 5.00083947e-01},
{7.44962519e-02, 9.74719338e-02, 1.42024623e-01, 2.49035309e-01, 4.06347184e-01, 4.98481511e-01},
{1.13401505e-01, 1.40827436e-01, 1.75609812e-01, 3.71948208e-01, 4.98673226e-01, 5.27457611e-01},
{1.40087857e-01, 1.76601079e-01, 2.51232000e-01, 3.12398064e-01, 3.51479959e-01, 5.18508659e-01},
{1.07794957e-01, 1.39456405e-01, 1.83829374e-01, 3.42239751e-01, 4.54778019e-01, 4.76236643e-01},
{1.06130567e-01, 1.27126450e-01, 2.27554900e-01, 2.91003303e-01, 3.25507717e-01, 5.05926341e-01},
{9.47962014e-02, 1.40486202e-01, 2.04933400e-01, 2.95966189e-01, 4.90034013e-01, 5.59465447e-01},
{8.88542274e-02, 1.60504045e-01, 2.62526498e-01, 3.18126466e-01, 3.76743760e-01, 4.11857737e-01},
{6.11026095e-02, 1.14507061e-01, 3.53905689e-01, 4.15466810e-01, 4.69315046e-01, 5.25592446e-01},
{7.65964255e-02, 9.91877441e-02, 2.11842626e-01, 2.74700168e-01, 3.72139935e-01, 4.51709089e-01},
{9.01367825e-02, 1.05118724e-01, 2.01190657e-01, 4.95823775e-01, 5.50860791e-01, 5.80109412e-01},
{1.21935406e-01, 1.48935719e-01, 2.28925330e-01, 3.60174418e-01, 4.09477908e-01, 4.39490620e-01},
{5.82692589e-02, 7.31378335e-02, 1.40410752e-01, 3.03417427e-01, 4.08923953e-01, 4.59452447e-01},
{7.98074471e-02, 1.08522852e-01, 1.79574364e-01, 3.00818526e-01, 3.32225112e-01, 4.36419471e-01},
{6.86020432e-02, 9.17620764e-02, 1.47105122e-01, 2.82737984e-01, 5.35446646e-01, 5.93433675e-01},
{1.23292280e-01, 1.54280789e-01, 2.72860020e-01, 3.32975588e-01, 3.69707847e-01, 4.27007965e-01},
{1.08235882e-01, 1.77166236e-01, 2.63227257e-01, 3.63496196e-01, 4.51147515e-01, 4.89084241e-01},
{8.64105103e-02, 1.05573092e-01, 1.85369186e-01, 2.74379089e-01, 4.71346708e-01, 5.39950924e-01},
{8.55883454e-02, 1.02901982e-01, 1.90205848e-01, 4.06005427e-01, 4.42576468e-01, 5.08743851e-01},
{1.21354910e-01, 1.99015409e-01, 2.68904509e-01, 3.33666928e-01, 3.71646243e-01, 4.44269952e-01},
{8.83778092e-02, 1.16639338e-01, 2.48145684e-01, 3.77500465e-01, 4.34481231e-01, 4.66901176e-01},
{1.00028545e-01, 1.16987642e-01, 2.19901045e-01, 2.57385060e-01, 4.36106677e-01, 6.11327968e-01},
{1.00198134e-01, 1.59230781e-01, 2.62293733e-01, 3.76774890e-01, 5.04670209e-01, 5.40725022e-01},
{1.25829046e-01, 1.60763918e-01, 2.16456776e-01, 2.53504421e-01, 2.92137844e-01, 4.06932925e-01},
{1.27530279e-01, 1.99216571e-01, 2.46298891e-01, 3.11811025e-01, 4.86717126e-01, 5.61972163e-01},
{5.92324357e-02, 7.20577158e-02, 1.49845797e-01, 2.70787381e-01, 3.56616144e-01, 4.49336348e-01},
{9.36708043e-02, 1.08531769e-01, 2.09386993e-01, 4.76867933e-01, 5.27156717e-01, 5.57985736e-01},
{1.42994232e-01, 2.38970599e-01, 3.00120859e-01, 3.88684051e-01, 4.69156118e-01, 4.97089955e-01},
{9.54824686e-02, 1.17705665e-01, 2.56695136e-01, 3.58224515e-01, 3.84721278e-01, 4.77971105e-01},
{1.17441759e-01, 1.38859859e-01, 1.95812911e-01, 2.30963314e-01, 3.08766091e-01, 5.07967964e-01},
{7.02040244e-02, 1.06194046e-01, 1.43860592e-01, 2.45109141e-01, 4.74779933e-01, 5.28888700e-01},
{9.31800329e-02, 1.28921357e-01, 1.71343416e-01, 3.22220234e-01, 3.93099219e-01, 4.28260752e-01},
{1.18169680e-01, 1.78429641e-01, 2.40937551e-01, 3.84820214e-01, 4.62886624e-01, 4.93810846e-01},
{5.66813446e-02, 6.97745725e-02, 1.33414844e-01, 2.47607726e-01, 3.85921042e-01, 4.95821494e-01},
{9.77262137e-02, 1.15623161e-01, 2.58450218e-01, 4.50716864e-01, 4.75936127e-01, 5.40891155e-01},
{1.28299974e-01, 1.76810061e-01, 2.75041833e-01, 3.56489043e-01, 3.84459408e-01, 5.25238710e-01},
{1.01523943e-01, 1.34886517e-01, 2.13290487e-01, 3.68013770e-01, 4.43628394e-01, 4.67933341e-01},
{1.34824330e-01, 1.72061239e-01, 2.25026437e-01, 2.64036528e-01, 3.09076659e-01, 4.78786337e-01},
{1.10550051e-01, 1.35324369e-01, 2.20536106e-01, 3.83120172e-01, 5.30024979e-01, 5.98392283e-01},
{1.24754307e-01, 1.84650932e-01, 2.37724081e-01, 2.75353527e-01, 3.27509318e-01, 4.33483596e-01},
{9.96523990e-02, 1.80652068e-01, 3.19704779e-01, 3.82238724e-01, 4.83756804e-01, 5.43206747e-01},
{8.36440769e-02, 1.04941055e-01, 1.88214975e-01, 2.73925664e-01, 4.13351083e-01, 5.22985664e-01},
{7.22920529e-02, 8.44547240e-02, 1.86246740e-01, 4.90548822e-01, 5.67616868e-01, 5.88360126e-01},
{1.07561618e-01, 1.69072632e-01, 2.21925265e-01, 3.17075398e-01, 4.08008681e-01, 4.43153522e-01},
{8.64023842e-02, 1.01800492e-01, 1.96859837e-01, 3.37534454e-01, 3.85106191e-01, 5.64575988e-01},
{8.72507067e-02, 1.13222693e-01, 1.72242448e-01, 2.39710889e-01, 2.94370138e-01, 4.34038533e-01},
{9.35261997e-02, 1.27755874e-01, 1.96304017e-01, 3.37891856e-01, 5.38320113e-01, 5.92758415e-01},
{1.06986415e-01, 1.44843705e-01, 2.08009368e-01, 3.29995120e-01, 4.01366746e-01, 4.25161702e-01},
{1.25571471e-01, 1.63076735e-01, 2.57650817e-01, 4.05639167e-01, 4.34434495e-01, 5.32214384e-01},
{7.52186542e-02, 1.04011794e-01, 1.52499046e-01, 3.01878240e-01, 4.51760864e-01, 5.19038920e-01},
{7.47203380e-02, 9.72285852e-02, 2.32629760e-01, 3.76849349e-01, 4.23902083e-01, 4.67364276e-01},
{1.25874940e-01, 2.02888859e-01, 2.53921547e-01, 3.26851995e-01, 4.02926813e-01, 4.39007128e-01},
{6.52309341e-02, 8.88242376e-02, 1.72303950e-01, 2.95918647e-01, 4.47599744e-01, 4.69902167e-01},
{9.61896573e-02, 1.13108372e-01, 2.05424336e-01, 2.59834297e-01, 3.07141482e-01, 5.33747960e-01},
{1.23670797e-01, 1.54272412e-01, 2.22249224e-01, 3.83507506e-01, 5.11812945e-01, 5.77900325e-01},
{1.11353040e-01, 1.61421324e-01, 2.11752996e-01, 2.82004040e-01, 3.21968411e-01, 3.75144086e-01},
{1.18243085e-01, 1.90271101e-01, 2.76113725e-01, 3.94449139e-01, 4.75400227e-01, 5.00366884e-01},
{8.50368651e-02, 1.16978317e-01, 1.89299475e-01, 3.08179589e-01, 3.64260221e-01, 4.58165005e-01},
{6.94549939e-02, 8.82261007e-02, 1.70948569e-01, 4.04047776e-01, 4.94449637e-01, 5.19463928e-01},
{1.48671494e-01, 2.05050395e-01, 2.48556081e-01, 3.50150461e-01, 4.20681801e-01, 4.55430912e-01},
{9.36085150e-02, 1.32813804e-01, 2.40247288e-01, 3.74720183e-01, 4.24190148e-01, 4.95012971e-01},
{1.04002975e-01, 1.37908531e-01, 1.96941863e-01, 2.84175170e-01, 3.15046995e-01, 3.95263699e-01},
{7.29713650e-02, 1.06941675e-01, 1.63320985e-01, 2.56416276e-01, 4.54619740e-01, 6.08826009e-01},
{8.42127802e-02, 1.09242160e-01, 2.34832245e-01, 3.04740177e-01, 3.62067714e-01, 4.54074831e-01},
{9.99738793e-02, 1.29247123e-01, 1.80779001e-01, 3.44002644e-01, 4.80175076e-01, 5.18691371e-01},
{7.20595793e-02, 9.89129826e-02, 1.46745571e-01, 2.51050946e-01, 3.86295943e-01, 5.52836920e-01},
{1.10750434e-01, 1.48514033e-01, 2.52553777e-01, 4.22152675e-01, 4.77356860e-01, 5.11031868e-01},
{1.15860765e-01, 1.41998008e-01, 2.49364881e-01, 3.25274316e-01, 3.57026865e-01, 5.47008828e-01},
{7.81202685e-02, 1.36080604e-01, 2.37970949e-01, 3.02884027e-01, 4.17190601e-01, 4.60765096e-01},
{1.38910763e-01, 1.63604358e-01, 2.25292448e-01, 2.54752210e-01, 3.63660642e-01, 5.77771005e-01},
{1.08062142e-01, 1.62852223e-01, 1.85937675e-01, 2.81871494e-01, 4.76178808e-01, 5.72592266e-01},
{1.24618617e-01, 1.73266071e-01, 2.41836675e-01, 3.22619614e-01, 3.66484074e-01, 4.41585724e-01},
{8.23961842e-02, 1.84437997e-01, 3.31027330e-01, 3.77991412e-01, 4.54935055e-01, 5.20596094e-01},
{9.82067454e-02, 1.18363826e-01, 2.12832836e-01, 3.03857060e-01, 3.36822681e-01, 5.26408623e-01},
{7.74054595e-02, 9.01759247e-02, 2.42079730e-01, 4.89869502e-01, 5.15542022e-01, 5.57159090e-01},
{1.07519800e-01, 1.27319641e-01, 2.61663400e-01, 3.76633311e-01, 4.04164584e-01, 4.48008057e-01},
{8.38048846e-02, 1.04032700e-01, 1.90663953e-01, 3.20445886e-01, 3.99960202e-01, 5.09657949e-01},
{8.37173215e-02, 1.06327940e-01, 2.05006465e-01, 2.64474276e-01, 3.43736748e-01, 4.32990566e-01},
{8.09667743e-02, 1.09258750e-01, 1.53242451e-01, 3.65561496e-01, 5.31392473e-01, 6.39094577e-01},
{1.07032188e-01, 1.83276894e-01, 2.47343640e-01, 3.14036695e-01, 4.04191217e-01, 4.27207102e-01},
{1.30496853e-01, 1.53698989e-01, 2.36531883e-01, 3.94853905e-01, 4.39905326e-01, 4.84045647e-01},
{5.66019272e-02, 7.04236584e-02, 1.77564103e-01, 3.41401468e-01, 4.49211104e-01, 5.33302443e-01},
{8.24839867e-02, 9.79333112e-02, 2.50579333e-01, 4.37679497e-01, 4.64428444e-01, 5.59213359e-01},
{1.11569705e-01, 2.09930794e-01, 2.87279845e-01, 3.24601489e-01, 3.84757263e-01, 4.15130175e-01},
{7.04013063e-02, 9.66210032e-02, 2.13742621e-01, 3.37151339e-01, 4.06567007e-01, 4.66003788e-01},
{8.11592653e-02, 9.69728915e-02, 1.47428521e-01, 1.97826683e-01, 3.28290674e-01, 5.08698091e-01},
{1.19728184e-01, 1.73915985e-01, 2.13143389e-01, 3.07635744e-01, 4.65242975e-01, 5.41968427e-01},
{9.86151126e-02, 1.78836862e-01, 2.50418016e-01, 2.87458703e-01, 3.24610744e-01, 3.69174410e-01},
{9.03714760e-02, 1.83398021e-01, 2.68762038e-01, 3.31380224e-01, 4.39757776e-01, 4.73947841e-01},
{7.96570527e-02, 1.23239837e-01, 1.48972477e-01, 2.68032224e-01, 3.92748753e-01, 4.16524585e-01},
{7.21723442e-02, 8.66103263e-02, 2.03684080e-01, 4.69434411e-01, 5.14394642e-01, 5.39575526e-01},
{1.60454028e-01, 2.17003948e-01, 2.72722080e-01, 3.80584983e-01, 4.05414777e-01, 5.00143541e-01},
{8.27606991e-02, 1.07920297e-01, 2.92447655e-01, 3.69112096e-01, 4.10808280e-01, 4.92853392e-01},
{8.50026529e-02, 1.05697120e-01, 1.78939955e-01, 2.36949987e-01, 3.41107507e-01, 4.96770913e-01},
{6.92484385e-02, 9.68497569e-02, 1.49501385e-01, 3.06604761e-01, 5.11751548e-01, 5.59576132e-01},
{1.03707479e-01, 1.40820705e-01, 2.05232700e-01, 3.19066739e-01, 3.57767358e-01, 4.28776293e-01},
{9.85048782e-02, 1.55715407e-01, 2.26657551e-01, 3.05380931e-01, 4.26642357e-01, 5.17713829e-01},
{6.28608795e-02, 8.75341890e-02, 1.48484051e-01, 2.38406037e-01, 4.27413872e-01, 4.59264426e-01},
{1.01782406e-01, 1.19339066e-01, 2.61960553e-01, 4.19519536e-01, 4.47361481e-01, 5.41075257e-01},
{1.53373439e-01, 1.83954030e-01, 2.60310991e-01, 3.10258535e-01, 3.45498740e-01, 4.86606914e-01},
{1.00909009e-01, 1.71538070e-01, 2.32163277e-01, 3.03484347e-01, 4.33731352e-01, 4.66831729e-01},
{1.11775691e-01, 1.48062214e-01, 2.52284469e-01, 2.83549864e-01, 3.70604491e-01, 4.62859280e-01},
{6.80153259e-02, 9.87998522e-02, 2.56234835e-01, 3.76439579e-01, 5.44214494e-01, 5.76935142e-01},
{1.21856476e-01, 1.90470012e-01, 2.58079815e-01, 3.13057038e-01, 3.57020371e-01, 4.29079301e-01},
{8.56281941e-02, 1.17491819e-01, 3.03750122e-01, 4.26005438e-01, 5.21334459e-01, 6.06587011e-01},
{6.33366623e-02, 7.93710438e-02, 1.65836784e-01, 2.73319601e-01, 3.34447589e-01, 4.99559121e-01},
{7.33865771e-02, 1.02307657e-01, 1.62457658e-01, 3.55383394e-01, 5.50705911e-01, 5.92281647e-01},
{1.29520245e-01, 1.75203187e-01, 2.30905952e-01, 3.55469628e-01, 4.09759809e-01, 4.47215004e-01},
{6.55213919e-02, 8.92631009e-02, 2.44392483e-01, 3.08885930e-01, 4.19565328e-01, 5.03023332e-01},
{1.05827788e-01, 1.34552155e-01, 1.68023123e-01, 2.25731015e-01, 3.04715520e-01, 4.21866352e-01},
{8.81179977e-02, 1.28255218e-01, 1.60532574e-01, 3.41610762e-01, 5.28282864e-01, 5.69548537e-01},
{1.07894541e-01, 1.25979014e-01, 2.78222306e-01, 3.40034079e-01, 3.76539790e-01, 4.15622996e-01},
{1.32203105e-01, 1.72035377e-01, 2.54101932e-01, 4.08381862e-01, 4.46475963e-01, 4.86117377e-01},
{9.97604287e-02, 1.24395547e-01, 1.98691153e-01, 4.03702067e-01, 4.89471573e-01, 5.11748708e-01},
{8.51585441e-02, 1.09877470e-01, 2.34675236e-01, 3.54689417e-01, 4.65716753e-01, 5.34033026e-01},
{1.21232023e-01, 2.07729261e-01, 2.87432731e-01, 3.62215975e-01, 3.99666728e-01, 4.45068575e-01},
{9.71059277e-02, 1.34427732e-01, 1.68571326e-01, 3.33345529e-01, 4.32293511e-01, 4.59450428e-01},
{9.52641228e-02, 1.11578853e-01, 2.28823475e-01, 2.67002076e-01, 3.65904735e-01, 5.49799731e-01},
{8.98135549e-02, 1.25254234e-01, 1.83383339e-01, 3.19224449e-01, 5.14459667e-01, 5.69150471e-01},
{8.56585673e-02, 1.12793668e-01, 1.99247192e-01, 2.78823515e-01, 3.34780006e-01, 3.96324655e-01},
{1.39377343e-01, 2.21643310e-01, 2.72428845e-01, 3.80222249e-01, 4.63884700e-01, 4.88803831e-01},
{7.40521884e-02, 9.75285113e-02, 1.53985494e-01, 3.14621160e-01, 4.06171981e-01, 4.35608443e-01},
{7.70070147e-02, 9.94447548e-02, 1.67040792e-01, 3.35204794e-01, 5.08704748e-01, 5.46530167e-01},
{1.43040318e-01, 2.29807889e-01, 2.78109667e-01, 3.51649517e-01, 4.33872878e-01, 4.62768618e-01},
{1.09588729e-01, 1.31430668e-01, 2.46768948e-01, 3.99611821e-01, 4.26477158e-01, 5.47805553e-01},
{1.10486831e-01, 1.50269177e-01, 2.04785541e-01, 2.48813343e-01, 3.02024230e-01, 4.38057059e-01},
{7.71905368e-02, 1.16383405e-01, 1.37615311e-01, 2.40725461e-01, 4.82799626e-01, 5.99885180e-01},
{8.82673464e-02, 1.16900364e-01, 2.19381290e-01, 3.39300958e-01, 3.97210938e-01, 4.25182700e-01},
{7.94224276e-02, 1.17491536e-01, 2.19002014e-01, 3.20318844e-01, 4.80058031e-01, 5.18993580e-01},
{6.31792433e-02, 8.00415588e-02, 1.42091781e-01, 2.61522559e-01, 4.34610296e-01, 5.52529591e-01},
{1.25659491e-01, 1.60535971e-01, 2.40721835e-01, 3.89978122e-01, 4.84574448e-01, 5.13202054e-01},
{1.59807947e-01, 1.88088123e-01, 2.73899207e-01, 3.10782081e-01, 3.73901329e-01, 5.56885848e-01},
{9.97984200e-02, 1.30332922e-01, 2.07331154e-01, 3.61904865e-01, 4.58150958e-01, 4.80212080e-01},
{1.19403268e-01, 1.41675417e-01, 2.27466377e-01, 2.69163713e-01, 3.34321040e-01, 5.33951200e-01},
{8.19392395e-02, 1.17404692e-01, 1.83979388e-01, 2.92965174e-01, 4.69575620e-01, 5.97658913e-01},
{1.21424862e-01, 1.79597465e-01, 2.25930314e-01, 3.08914372e-01, 3.63129242e-01, 4.03213138e-01},
{6.58157855e-02, 9.51803434e-02, 2.84853681e-01, 4.05834082e-01, 4.86836649e-01, 5.70179943e-01},
{9.22575809e-02, 1.31231998e-01, 1.89787454e-01, 2.72770430e-01, 3.66293641e-01, 4.73181497e-01},
{7.24587277e-02, 8.54644054e-02, 1.71794161e-01, 4.72530276e-01, 5.38880082e-01, 5.60401921e-01},
{1.20830128e-01, 1.50245321e-01, 2.61918965e-01, 3.59999669e-01, 3.90273955e-01, 4.32041724e-01},
{5.60685043e-02, 7.17522399e-02, 2.07671048e-01, 3.67154622e-01, 4.32446944e-01, 4.80207243e-01},
{9.11134179e-02, 1.21141171e-01, 1.83783173e-01, 3.03656755e-01, 3.43122783e-01, 4.16053965e-01},
{8.11916333e-02, 1.11501378e-01, 1.66560772e-01, 3.07384015e-01, 5.32298217e-01, 5.94368423e-01},
{1.23025950e-01, 1.54299136e-01, 2.30403368e-01, 3.45394745e-01, 3.81669923e-01, 4.39621365e-01},
{1.05889665e-01, 1.84511310e-01, 2.92170991e-01, 3.74781005e-01, 4.31483100e-01, 4.57889075e-01},
{6.55606322e-02, 8.81861794e-02, 1.70895846e-01, 2.57017109e-01, 4.62538648e-01, 5.33927569e-01},
{8.36324771e-02, 1.06214697e-01, 1.90455036e-01, 3.74722201e-01, 4.21370060e-01, 4.73372784e-01},
{1.45234379e-01, 2.22232359e-01, 2.76573860e-01, 3.26220823e-01, 3.80148433e-01, 4.14418318e-01},
{8.44049579e-02, 1.10189911e-01, 2.15663226e-01, 3.68644904e-01, 3.98356734e-01, 4.69662783e-01},
{8.90037964e-02, 1.06736203e-01, 1.60566560e-01, 1.97946735e-01, 3.42740451e-01, 5.77295658e-01},
{1.04153753e-01, 1.70106504e-01, 2.31956521e-01, 3.07058877e-01, 4.79182398e-01, 5.56540366e-01},
{1.17090556e-01, 1.43533564e-01, 2.23019496e-01, 2.76143021e-01, 3.22030986e-01, 4.13549926e-01},
{1.19761252e-01, 2.05283089e-01, 2.57790093e-01, 3.12501414e-01, 4.45571129e-01, 5.16801895e-01},
{6.28887107e-02, 8.24554938e-02, 1.51379109e-01, 2.06548779e-01, 3.23176618e-01, 4.56394044e-01},
{9.96251891e-02, 1.17769376e-01, 2.09312130e-01, 4.54505934e-01, 5.08993917e-01, 5.48193480e-01},
{1.07735641e-01, 2.23206951e-01, 3.11883514e-01, 3.40369130e-01, 4.24194633e-01, 4.90996493e-01},
{1.06532216e-01, 1.28169630e-01, 2.28436686e-01, 3.50765842e-01, 3.83594359e-01, 4.98939121e-01},
{1.28747677e-01, 1.57877973e-01, 2.25647665e-01, 2.59439185e-01, 3.57476259e-01, 5.26193687e-01},
{7.94266484e-02, 1.12414079e-01, 1.61867689e-01, 3.07119471e-01, 4.95898283e-01, 5.45997157e-01},
{1.00343905e-01, 1.27830555e-01, 1.84598494e-01, 3.36223165e-01, 3.74402876e-01, 4.20406995e-01},
{1.17025736e-01, 1.80888393e-01, 2.23465760e-01, 3.38973756e-01, 4.47131649e-01, 4.77784403e-01},
{6.47292097e-02, 8.68139055e-02, 1.29800537e-01, 2.47428494e-01, 4.49693686e-01, 4.90056976e-01},
{1.11126119e-01, 1.32371342e-01, 2.33056611e-01, 4.23189777e-01, 4.97949457e-01, 5.25464146e-01},
{1.38986383e-01, 1.84107640e-01, 2.46987599e-01, 3.44220514e-01, 3.76901470e-01, 4.69716731e-01},
{1.13840475e-01, 1.36557613e-01, 2.11437420e-01, 3.76287031e-01, 4.09946566e-01, 4.62485568e-01},
{1.39409206e-01, 1.74826397e-01, 2.39871706e-01, 2.77455525e-01, 3.21989612e-01, 4.91519005e-01},
{8.49887730e-02, 1.10874208e-01, 2.36192813e-01, 2.80737033e-01, 4.93932224e-01, 6.12656849e-01},
{1.26325009e-01, 1.99208491e-01, 2.60609953e-01, 3.02611532e-01, 3.39185790e-01, 4.22863709e-01},
{9.25296828e-02, 2.08990603e-01, 3.55536663e-01, 4.10458527e-01, 4.88463374e-01, 5.50355538e-01},
{6.99576192e-02, 8.70657957e-02, 1.89688836e-01, 2.78834887e-01, 3.76921280e-01, 5.34794172e-01},
{9.07391799e-02, 1.05993041e-01, 2.43916743e-01, 3.71992910e-01, 5.28064428e-01, 6.12837084e-01},
{1.12210396e-01, 1.87099620e-01, 2.65631390e-01, 3.52736662e-01, 4.16556287e-01, 4.47493299e-01},
{9.51928043e-02, 1.16425036e-01, 2.80240518e-01, 3.22654052e-01, 4.15565152e-01, 5.58573066e-01},
{7.18628016e-02, 1.06567969e-01, 1.46649910e-01, 2.08731447e-01, 3.10137462e-01, 4.12669026e-01},
{9.40017747e-02, 1.23228605e-01, 1.74951367e-01, 3.37032996e-01, 5.11464530e-01, 6.04933699e-01},
{1.03414471e-01, 1.34715623e-01, 1.88594722e-01, 3.40581017e-01, 4.00115476e-01, 4.40482015e-01},
{1.47677087e-01, 1.93884537e-01, 2.80257757e-01, 4.04009319e-01, 4.32104837e-01, 5.24263930e-01},
{8.06053168e-02, 1.19810224e-01, 1.54532006e-01, 2.69182380e-01, 4.54085145e-01, 4.85901552e-01},
{5.61916651e-02, 8.48974183e-02, 2.93231577e-01, 3.84078984e-01, 4.70918850e-01, 5.07190318e-01},
{1.63293628e-01, 2.15690802e-01, 2.68990225e-01, 3.52962978e-01, 3.97431153e-01, 4.43304151e-01},
{7.18376214e-02, 9.78137868e-02, 1.63309186e-01, 2.94905193e-01, 4.09580878e-01, 4.90671284e-01},
{1.08139795e-01, 1.30170955e-01, 2.18172437e-01, 2.60346017e-01, 3.22495129e-01, 5.53525284e-01},
{9.02124962e-02, 1.20754794e-01, 2.43950188e-01, 4.00677393e-01, 5.17785321e-01, 5.42800815e-01},
{1.07705744e-01, 1.65571745e-01, 2.01923496e-01, 3.01158297e-01, 3.55967445e-01, 3.82388604e-01},
{1.28179648e-01, 2.04039910e-01, 2.55041415e-01, 3.71154369e-01, 4.88582004e-01, 5.16759643e-01},
{7.12915048e-02, 9.24820999e-02, 2.12967543e-01, 3.23120653e-01, 3.60061212e-01, 4.52855852e-01},
{8.74557268e-02, 1.01284686e-01, 1.98031267e-01, 4.34017639e-01, 4.68883954e-01, 5.15728332e-01},
{1.53464806e-01, 2.06080744e-01, 2.41307956e-01, 3.69525501e-01, 4.38546025e-01, 4.68176982e-01},
{1.10438931e-01, 1.40393180e-01, 2.71671206e-01, 3.68494380e-01, 3.95305751e-01, 5.25322061e-01},
{9.69021881e-02, 1.19055246e-01, 1.91170289e-01, 2.64946531e-01, 3.03160908e-01, 4.30071368e-01},
{8.06279223e-02, 1.20180908e-01, 1.45287565e-01, 2.77369900e-01, 4.91103694e-01, 5.77133979e-01},
{7.96569668e-02, 1.17526002e-01, 2.76738144e-01, 3.20581879e-01, 3.88248081e-01, 4.42830231e-01},
{9.33502046e-02, 1.44731451e-01, 1.82694501e-01, 2.75579895e-01, 4.47256393e-01, 5.27049960e-01},
{7.38678724e-02, 8.95137858e-02, 1.24451018e-01, 1.98184397e-01, 3.94936201e-01, 4.95704482e-01},
{1.19245082e-01, 1.43291810e-01, 2.00937540e-01, 3.88307667e-01, 4.57678878e-01, 4.88342259e-01},
{1.32142709e-01, 1.61345903e-01, 2.54784984e-01, 3.07684780e-01, 3.52699001e-01, 5.28791097e-01},
{8.02779978e-02, 1.09768216e-01, 1.89361280e-01, 2.91134451e-01, 4.60954620e-01, 4.83594069e-01},
{1.45286328e-01, 1.71307431e-01, 2.42715427e-01, 2.72914923e-01, 3.62858464e-01, 5.32281142e-01},
{1.16043993e-01, 1.67549746e-01, 2.00194738e-01, 3.19321692e-01, 4.97886795e-01, 5.55299954e-01},
{1.15416087e-01, 1.65953143e-01, 2.23796068e-01, 2.95769899e-01, 3.44677606e-01, 4.06090645e-01},
{7.75217209e-02, 1.40872110e-01, 2.92339502e-01, 3.60336321e-01, 4.44501267e-01, 4.98110036e-01},
{1.00485592e-01, 1.19828905e-01, 2.28209801e-01, 3.19678188e-01, 3.49163317e-01, 4.89022143e-01},
{6.76432062e-02, 8.63531300e-02, 1.49188000e-01, 3.96849989e-01, 5.23827228e-01, 5.47701890e-01},
{1.19007933e-01, 1.40573557e-01, 2.72672653e-01, 3.79798081e-01, 4.05800965e-01, 4.57629726e-01},
{7.67380431e-02, 1.08239325e-01, 2.15691923e-01, 3.13107849e-01, 3.85809444e-01, 4.78352819e-01},
{7.55796531e-02, 1.01657141e-01, 1.73033497e-01, 2.57879258e-01, 3.33734104e-01, 4.38232622e-01},
{7.52129348e-02, 9.81183359e-02, 1.73592034e-01, 3.33836148e-01, 5.56098785e-01, 6.27214829e-01},
{1.34661743e-01, 1.79950281e-01, 2.35449413e-01, 3.46529097e-01, 3.80357255e-01, 4.32583486e-01},
{1.12803207e-01, 1.38098085e-01, 2.43789363e-01, 3.95553460e-01, 4.25724837e-01, 4.80233443e-01},
{6.42877427e-02, 8.78807627e-02, 1.49541455e-01, 3.07246872e-01, 4.70239398e-01, 4.98066164e-01},
{8.68223260e-02, 1.01302571e-01, 2.28391940e-01, 4.08891140e-01, 4.34798407e-01, 5.52670426e-01},
{1.07015282e-01, 2.05679770e-01, 2.69135533e-01, 3.13280201e-01, 3.80141455e-01, 4.18866464e-01},
{7.31006148e-02, 9.81725504e-02, 1.69880592e-01, 3.59294058e-01, 3.95675865e-01, 4.79729095e-01},
{9.75041512e-02, 1.38254526e-01, 1.80182136e-01, 2.24896494e-01, 3.83463330e-01, 5.13601979e-01},
{1.15271678e-01, 1.56685818e-01, 2.08320133e-01, 3.48153343e-01, 4.84430986e-01, 5.18991097e-01},
{1.25624052e-01, 1.71269212e-01, 2.20002711e-01, 2.81218292e-01, 3.11772131e-01, 3.85538455e-01},
{1.06401189e-01, 1.96908726e-01, 2.58722230e-01, 3.25941714e-01, 4.66456895e-01, 5.06824291e-01},
{6.97553031e-02, 9.58366348e-02, 1.73202662e-01, 2.60335752e-01, 3.63985288e-01, 4.40816802e-01},
{9.07179927e-02, 1.05883797e-01, 1.93646484e-01, 4.38061868e-01, 5.09185319e-01, 5.35322691e-01},
{1.62007307e-01, 1.90197065e-01, 3.00407418e-01, 3.62684877e-01, 3.95433064e-01, 5.31553195e-01},
{8.01866154e-02, 9.87068852e-02, 2.09891606e-01, 3.54529068e-01, 3.98245738e-01, 5.38463121e-01},
{9.68518444e-02, 1.41591822e-01, 2.00108626e-01, 2.45043684e-01, 3.28498599e-01, 4.11455670e-01},
{7.50370655e-02, 9.36577191e-02, 1.81598076e-01, 3.32825793e-01, 5.19621648e-01, 5.70443221e-01},
{8.81051857e-02, 1.15079978e-01, 2.28656515e-01, 2.97225592e-01, 3.60806302e-01, 3.98429393e-01},
{1.27109851e-01, 1.83951650e-01, 2.39570628e-01, 3.60367599e-01, 4.75609742e-01, 5.09104879e-01},
{6.09423118e-02, 7.78298160e-02, 1.27442475e-01, 2.08355336e-01, 3.84946078e-01, 4.72811467e-01},
{9.41360675e-02, 1.11159195e-01, 2.35443646e-01, 4.12026981e-01, 4.43845035e-01, 5.03667000e-01},
{1.57276045e-01, 1.95895314e-01, 2.73729414e-01, 3.35919479e-01, 3.69614059e-01, 5.34540892e-01},
{9.78068552e-02, 1.48235395e-01, 1.87628703e-01, 2.95606746e-01, 4.23077205e-01, 4.51332690e-01},
{1.17550771e-01, 1.39273859e-01, 2.31998821e-01, 2.98047796e-01, 3.31709509e-01, 4.54391971e-01},
{8.50801454e-02, 1.56724176e-01, 2.54137771e-01, 2.99775423e-01, 4.75037162e-01, 5.54639765e-01},
{1.24086804e-01, 1.86477003e-01, 2.26781096e-01, 3.11565419e-01, 3.46142339e-01, 4.01522909e-01},
{6.99683925e-02, 1.64582861e-01, 4.12952478e-01, 4.82704452e-01, 5.49181481e-01, 6.04503754e-01},
{7.75146815e-02, 1.04524514e-01, 1.80030186e-01, 2.85002574e-01, 3.78996927e-01, 4.97108196e-01},
{8.52514927e-02, 1.09475105e-01, 1.68181432e-01, 3.74480733e-01, 5.32222295e-01, 5.55883580e-01},
{1.24935570e-01, 1.49631932e-01, 2.22729916e-01, 3.73923768e-01, 4.28893174e-01, 4.58917357e-01},
{8.94227943e-02, 1.26295391e-01, 2.86236302e-01, 3.31107351e-01, 4.23499012e-01, 5.12832734e-01},
{9.61192586e-02, 1.23942194e-01, 1.74612792e-01, 2.12766328e-01, 2.63038436e-01, 4.01935491e-01},
{9.29666152e-02, 1.18484467e-01, 1.64005215e-01, 3.17723653e-01, 4.88857166e-01, 5.74548791e-01},
{9.84358888e-02, 1.39300730e-01, 2.33695595e-01, 3.52896742e-01, 3.99596095e-01, 4.54261813e-01},
{1.18581197e-01, 1.47566429e-01, 2.54143499e-01, 4.34949308e-01, 4.63217836e-01, 5.41383163e-01},
{7.51730225e-02, 1.02607774e-01, 1.68111445e-01, 3.76248509e-01, 4.71545451e-01, 4.94876506e-01},
{6.76681892e-02, 9.15498699e-02, 2.33027662e-01, 3.43844845e-01, 4.48288495e-01, 5.28075261e-01},
{1.26409596e-01, 2.26789051e-01, 2.91862818e-01, 3.31033137e-01, 4.04648397e-01, 4.42661772e-01},
{7.61074286e-02, 1.00631724e-01, 1.70102334e-01, 3.19754764e-01, 4.22123387e-01, 4.67521307e-01},
{8.07964346e-02, 9.61936950e-02, 1.83758179e-01, 2.51959623e-01, 3.15177980e-01, 5.33889422e-01},
{9.50403629e-02, 1.19033502e-01, 2.10541482e-01, 3.50433116e-01, 5.04924561e-01, 5.30764086e-01},
{1.05428362e-01, 1.28651151e-01, 2.42739243e-01, 2.90653248e-01, 3.41383550e-01, 4.02828479e-01},
{1.24673032e-01, 1.81012140e-01, 2.31956961e-01, 3.17209580e-01, 4.48931837e-01, 4.93020504e-01},
{6.56105917e-02, 8.41576353e-02, 1.68059299e-01, 2.94736813e-01, 4.13698987e-01, 4.66567546e-01},
{8.23331682e-02, 1.02260418e-01, 1.61705029e-01, 3.65782965e-01, 4.80015098e-01, 5.17000138e-01},
{1.11863573e-01, 1.99393897e-01, 2.57836033e-01, 3.13697230e-01, 4.22690270e-01, 4.52052976e-01},
{1.00093499e-01, 1.17255242e-01, 2.62314401e-01, 3.75525363e-01, 4.20547220e-01, 5.73696615e-01},
{9.35344695e-02, 1.39056822e-01, 1.73839977e-01, 2.46780539e-01, 2.98513644e-01, 3.61713493e-01},
{8.02874919e-02, 1.11009369e-01, 1.66319977e-01, 2.61683345e-01, 5.06296047e-01, 5.73666248e-01},
{8.91125671e-02, 1.15809663e-01, 1.94131558e-01, 3.33892003e-01, 3.73224936e-01, 4.47680511e-01},
{9.59375669e-02, 1.23793597e-01, 2.28760142e-01, 3.47289250e-01, 4.76561575e-01, 5.07153813e-01},
{6.85218743e-02, 9.46507203e-02, 1.57644524e-01, 2.51944839e-01, 4.44886637e-01, 4.84070020e-01},
{9.90717725e-02, 1.41277520e-01, 2.24751012e-01, 3.70085100e-01, 4.95986658e-01, 5.24299763e-01},
{1.53746492e-01, 1.84326745e-01, 2.54728053e-01, 2.92986581e-01, 3.39301113e-01, 5.05983830e-01},
{9.43247437e-02, 1.28188359e-01, 1.72421615e-01, 3.63289115e-01, 4.47963074e-01, 4.71379498e-01},
{1.25482282e-01, 1.54373899e-01, 2.52310902e-01, 2.88670648e-01, 3.55794018e-01, 5.65305436e-01},
{8.68409849e-02, 1.37379567e-01, 2.17337160e-01, 2.91553584e-01, 4.34484673e-01, 5.62579759e-01},
{9.31861712e-02, 1.68512093e-01, 2.56207449e-01, 2.99195714e-01, 3.63049109e-01, 4.37294164e-01},
{7.85855787e-02, 1.10860307e-01, 3.12072519e-01, 4.05057432e-01, 4.61346589e-01, 5.17801610e-01},
{8.09282298e-02, 1.09757167e-01, 2.27826486e-01, 2.81122681e-01, 3.77855326e-01, 4.94037195e-01},
{8.66627603e-02, 1.00885846e-01, 1.88575422e-01, 4.65857702e-01, 5.37913790e-01, 5.60683536e-01},
{1.14874430e-01, 1.42565105e-01, 2.18965947e-01, 3.60120949e-01, 3.97513231e-01, 4.36136917e-01},
{5.27350814e-02, 6.48103107e-02, 1.41985867e-01, 3.29051084e-01, 4.29998277e-01, 5.11846178e-01},
{6.33272210e-02, 8.43840046e-02, 2.05716030e-01, 2.97180920e-01, 3.48365975e-01, 4.40030298e-01},
{7.55209202e-02, 1.10825161e-01, 1.46350311e-01, 2.89035960e-01, 5.31891085e-01, 6.17273831e-01},
{1.07293424e-01, 1.36364752e-01, 2.45305906e-01, 3.21555152e-01, 3.51404253e-01, 4.39266416e-01},
{9.46432930e-02, 1.36550133e-01, 2.45992183e-01, 3.79935512e-01, 4.55673372e-01, 4.85933655e-01},
{7.73850458e-02, 9.71021230e-02, 2.20499676e-01, 3.14182790e-01, 4.74397318e-01, 5.49969694e-01},
{7.28523672e-02, 9.16876727e-02, 1.84975670e-01, 3.98137241e-01, 4.39716704e-01, 5.40951396e-01},
{1.60133209e-01, 1.95318743e-01, 2.60623527e-01, 3.38142944e-01, 3.68289300e-01, 4.40064435e-01},
{9.47791112e-02, 1.12074936e-01, 2.89958319e-01, 3.95831982e-01, 4.21595255e-01, 4.56626111e-01},
{1.08617928e-01, 1.28507437e-01, 2.12631956e-01, 2.42414923e-01, 3.42947061e-01, 5.98567812e-01},
{1.22604691e-01, 1.85144694e-01, 2.31848831e-01, 3.61387792e-01, 5.06319961e-01, 5.45967384e-01},
{1.26566133e-01, 1.53186767e-01, 2.28256194e-01, 2.71382528e-01, 3.06352732e-01, 4.37581395e-01},
{8.75879047e-02, 1.66770988e-01, 2.55777293e-01, 3.11939074e-01, 4.61919049e-01, 5.27712821e-01},
{6.01422958e-02, 7.21094530e-02, 1.57119318e-01, 2.25748882e-01, 3.54473315e-01, 4.91097276e-01},
{9.76803703e-02, 1.19259167e-01, 2.05898962e-01, 4.18001596e-01, 5.36173926e-01, 5.63353108e-01},
{1.55430498e-01, 2.32553127e-01, 2.95063956e-01, 3.86206591e-01, 4.30051915e-01, 4.61540907e-01},
{9.23889069e-02, 1.14882649e-01, 2.73983636e-01, 3.34471422e-01, 4.08536531e-01, 4.77643185e-01},
{1.11326355e-01, 1.37165264e-01, 2.23922510e-01, 2.60079281e-01, 3.35237794e-01, 4.95639397e-01},
{6.95109028e-02, 9.48946221e-02, 1.40335702e-01, 2.34851556e-01, 5.05320696e-01, 5.46383607e-01},
{7.66469342e-02, 1.18100200e-01, 2.07188006e-01, 3.01300280e-01, 3.89694669e-01, 4.17878439e-01},
{1.21158676e-01, 1.65925628e-01, 2.11283998e-01, 3.38405493e-01, 4.55829516e-01, 4.84606963e-01},
{6.49721367e-02, 8.42760249e-02, 1.58529377e-01, 2.26938569e-01, 4.15326062e-01, 5.02998619e-01},
{8.88510406e-02, 1.04741014e-01, 2.94647110e-01, 4.62828914e-01, 4.89439306e-01, 5.37265780e-01},

};

static float cbb_new[VECSIZEb_NEW][VECDIMb_NEW] = {

{5.77457760e-01, 6.34237563e-01, 8.24438260e-01, 8.59274814e-01},
{5.01109918e-01, 6.07444086e-01, 7.17292064e-01, 7.56862102e-01},
{5.57203795e-01, 6.59385929e-01, 7.64716603e-01, 7.91677950e-01},
{5.25737155e-01, 5.67084904e-01, 7.32345690e-01, 7.93680200e-01},
{6.43556770e-01, 6.91869719e-01, 7.48895712e-01, 7.93411821e-01},
{5.30478853e-01, 6.20338197e-01, 6.73443699e-01, 7.27325749e-01},
{6.13081207e-01, 6.58075718e-01, 7.15209143e-01, 7.79021799e-01},
{5.39055000e-01, 6.12218913e-01, 7.73447591e-01, 8.06664690e-01},
{6.11381605e-01, 6.67792180e-01, 7.82736508e-01, 8.23755119e-01},
{5.78583191e-01, 6.18676153e-01, 7.34531898e-01, 8.23050355e-01},
{5.68023897e-01, 6.61058508e-01, 7.48770672e-01, 8.48269285e-01},
{4.33028824e-01, 5.40435127e-01, 7.30416013e-01, 8.36111424e-01},
{6.53084316e-01, 7.03102285e-01, 8.23105142e-01, 8.55125911e-01},
{5.67464843e-01, 6.49135093e-01, 7.04203079e-01, 8.00139355e-01},
{5.86748401e-01, 6.53257452e-01, 7.35915759e-01, 7.71486694e-01},
{4.54111421e-01, 5.98017984e-01, 8.08342566e-01, 8.44411591e-01},
{5.73144192e-01, 6.32298545e-01, 7.90561341e-01, 8.24232007e-01},
{5.30367332e-01, 6.54966215e-01, 7.21782968e-01, 7.90673613e-01},
{5.69160267e-01, 6.76810696e-01, 7.72035315e-01, 8.11502837e-01},
{5.25106065e-01, 5.65432827e-01, 6.21051922e-01, 7.47924004e-01},
{6.39087100e-01, 6.78280750e-01, 7.76134973e-01, 8.16185050e-01},
{5.68977077e-01, 6.11948866e-01, 6.84448213e-01, 7.98868749e-01},
{5.90671046e-01, 6.86320016e-01, 7.38091537e-01, 7.87467173e-01},
{5.37544042e-01, 6.71926971e-01, 8.03332716e-01, 8.33112064e-01},
{6.28589082e-01, 6.82875974e-01, 8.05094818e-01, 8.39363930e-01},
{5.56058852e-01, 5.87977943e-01, 7.41477001e-01, 8.30246400e-01},
{5.86944390e-01, 6.33900693e-01, 7.60197181e-01, 8.01064719e-01},
{5.00923602e-01, 5.35754707e-01, 6.69138614e-01, 8.00820242e-01},
{7.14127803e-01, 7.50444637e-01, 8.04073580e-01, 8.37671614e-01},
{6.02048243e-01, 6.46189990e-01, 6.87391589e-01, 7.47646033e-01},
{5.80866312e-01, 6.49753924e-01, 7.07352531e-01, 7.60931318e-01},
{4.99975298e-01, 6.16019249e-01, 7.42211014e-01, 8.19111322e-01},
{5.46577418e-01, 6.36087358e-01, 8.18320738e-01, 8.50303415e-01},
{4.65467299e-01, 6.32201850e-01, 6.95354499e-01, 7.60516067e-01},
{5.39500409e-01, 6.71093221e-01, 7.49171707e-01, 7.87230413e-01},
{5.05003054e-01, 5.54868841e-01, 7.44162558e-01, 8.26009333e-01},
{6.66470515e-01, 7.07041144e-01, 7.69965357e-01, 8.06893406e-01},
{5.59447872e-01, 6.03433063e-01, 6.47483339e-01, 7.48155304e-01},
{6.25762741e-01, 6.71648860e-01, 7.35798685e-01, 7.88456354e-01},
{5.39035253e-01, 6.24415599e-01, 7.60718420e-01, 8.41861001e-01},
{6.26166952e-01, 6.55512050e-01, 7.70253366e-01, 8.33430127e-01},
{5.63898510e-01, 6.14930928e-01, 7.42177190e-01, 7.85121619e-01},
{5.97849938e-01, 6.50839006e-01, 7.38906438e-01, 8.18664718e-01},
{4.65815250e-01, 5.16500874e-01, 7.36573472e-01, 8.20029519e-01},
{6.57776437e-01, 6.97521978e-01, 7.91723724e-01, 8.31004498e-01},
{5.96296662e-01, 6.31901006e-01, 7.01378621e-01, 7.96948664e-01},
{5.80209674e-01, 6.74933171e-01, 7.17936720e-01, 7.74477384e-01},
{4.91975835e-01, 6.31935167e-01, 8.11453167e-01, 8.42227539e-01},
{5.95729644e-01, 6.28927257e-01, 7.92959382e-01, 8.38939170e-01},
{5.46335236e-01, 6.37102502e-01, 7.33106065e-01, 7.64173828e-01},
{5.87446661e-01, 6.93666154e-01, 7.89444726e-01, 8.16304959e-01},
{5.37555186e-01, 5.74064360e-01, 6.64019161e-01, 7.95053930e-01},
{6.14043598e-01, 7.08340567e-01, 7.68113309e-01, 8.08225273e-01},
{5.44540421e-01, 6.07457565e-01, 6.95093021e-01, 7.69271065e-01},
{6.01829954e-01, 6.80080423e-01, 7.57733095e-01, 7.90701647e-01},
{5.11270396e-01, 6.63590387e-01, 7.82259940e-01, 8.12859118e-01},
{6.10588227e-01, 6.56371318e-01, 8.16185286e-01, 8.50589063e-01},
{5.38565346e-01, 6.10947418e-01, 7.13539929e-01, 8.17432933e-01},
{6.11014127e-01, 6.44248736e-01, 7.63820331e-01, 8.10745163e-01},
{4.76186551e-01, 5.07419190e-01, 6.61948696e-01, 8.08610457e-01},
{6.87920355e-01, 7.24015475e-01, 7.91990680e-01, 8.32192997e-01},
{5.74464988e-01, 6.32199348e-01, 6.74470114e-01, 7.54569972e-01},
{5.51453361e-01, 6.49605734e-01, 7.00781456e-01, 7.46100937e-01},
{4.73373858e-01, 6.35978296e-01, 7.53236363e-01, 7.90814362e-01},

};
#endif //NEWMALSPVQ


static float LSI_SPREAD_FACTOR=0.005;

float wvq_a(float *z,int SIZE,int *path1,float (*cb1)[VECDIMa_NEW],float *wt,
	   float *wmse)
   /* wt-ed VQ encoding */
{
  int k,n, ind=0, N=VECDIMa_NEW;
  float mindist=INFINITY, dist, temp, mse;
  
  for(n=0;n<SIZE;n++) {
    /* for each codevectors */
    dist=0;
    
    for(k=0;k<N;k++) {
      temp = (z[k]- cb1[n][k]);
      dist += temp * temp * wt[k];
      if (dist > mindist) k = N+10; 
    }
    
    if (dist<=mindist) {
      mindist=dist; 
      ind=n;	
    }  
      
  } /* for-n */
  
  mse = mindist;
  
  path1[0] = ind;
  wmse[0] = mindist;
  
   return(mse);
   
}/********************* end wvq2 **********************/

float wvq_b(float *z,int SIZE,int *path1,float (*cb1)[VECDIMb_NEW],float *wt,
	   float *wmse)
   /* wt-ed VQ encoding */
{
  int k,n, ind=0, N=VECDIMb_NEW;
  float mindist=INFINITY, dist, temp, mse;
  
  for(n=0;n<SIZE;n++) {
    /* for each codevectors */
    dist=0;
    
    for(k=0;k<N;k++) {
      temp = (z[k]- cb1[n][k]);
      dist += temp * temp * wt[k];
      if (dist > mindist) k = N+10; 
    }
    
    if (dist<=mindist) {
      mindist=dist; 
      ind=n;	
    }  
      
  } /* for-n */
  
  mse = mindist;
  
  path1[0] = ind;
  wmse[0] = mindist;
  
   return(mse);
   
}/********************* end wvq2 **********************/
		

void quantize_LSI2(float *x, double *sens, float *xq, unsigned short *qindex)
{
  float wt[VECDIM];
  float best_mse, lspq[10], sd, err[10];
  int i, j, best_index;
  float std;
  float part1a[VECDIMa_NEW], part1b[VECDIMb_NEW ], wt1a[VECDIMa_NEW], wt1b[VECDIMb_NEW];
  int path1a[K], path1b[K];
  float sigP, noiseP;
  
  float mse1, mse2, dist, temp, out[VECDIM], mse, wmse1a[K], wmse1b[K];
  int worst, sel_index1[K], sel1a[K], sel1b[K];

  float wtsum = 0.0;

  static int open_lsi_file=NO;


  for(j=0;j<10;j++) wtsum += (float) sens[j];
  for(j=0;j<10;j++) wt[j] = (float) sens[j]/wtsum;
  
  for(j=0;j<VECDIMa_NEW;j++) {
    part1a[j] = x[j];
    wt1a[j]   = wt[j];
  }
  for(j=0;j<VECDIMb_NEW ;j++) {
    part1b[j] = x[j+VECDIMa_NEW];
    wt1b[j]   = wt[j+VECDIMa_NEW];
  }

  /****** code for new first stage ***/
  mse1 = wvq_a(part1a, VECSIZEa_NEW, path1a, cba_new, wt1a, wmse1a);
  mse2 = wvq_b(part1b, VECSIZEb_NEW, path1b, cbb_new, wt1b, wmse1b);
  best_index=64*path1a[0]+path1b[0];
  for (j=0;j<6;j++) xq[j]=cba_new[path1a[0]][j];
  for (j=0;j<4;j++) xq[6+j]=cbb_new[path1b[0]][j];

  qindex[0]=path1a[0];
  qindex[1]=path1b[0];

}
#ifdef NEWMALSPVQ3
void quantize_LSI3(float *x, double *sens, float *xq, unsigned short *qindex)
{
  float wt[VECDIM];
  float best_mse, lspq[10], sd, err[10];
  int i, j, best_index;
  float std;
  float part1a[VECDIMa_NEW], part1b[VECDIMb_NEW ], wt1a[VECDIMa_NEW], wt1b[VECDIMb_NEW];
  int path1a[K], path1b[K];
  float sigP, noiseP;
  
  float mse1, mse2, dist, temp, out[VECDIM], mse, wmse1a[K], wmse1b[K];
  int worst, sel_index1[K], sel1a[K], sel1b[K];

  float wtsum = 0.0;

  static int open_lsi_file=NO;


  for(j=0;j<10;j++) wtsum += (float) sens[j];
  for(j=0;j<10;j++) wt[j] = (float) sens[j]/wtsum;
  
  for(j=0;j<VECDIMa_NEW;j++) {
    part1a[j] = x[j];
    wt1a[j]   = wt[j];
  }
  for(j=0;j<VECDIMb_NEW ;j++) {
    part1b[j] = x[j+VECDIMa_NEW];
    wt1b[j]   = wt[j+VECDIMa_NEW];
  }

  /****** code for new first stage ***/
  mse1 = wvq_a(part1a, VECSIZEa_NEW, path1a, cba_new3, wt1a, wmse1a);
  mse2 = wvq_b(part1b, VECSIZEb_NEW, path1b, cbb_new3, wt1b, wmse1b);
  best_index=64*path1a[0]+path1b[0];
  for (j=0;j<6;j++) xq[j]=cba_new3[path1a[0]][j];
  for (j=0;j<4;j++) xq[6+j]=cbb_new3[path1b[0]][j];

  qindex[0]=path1a[0];
  qindex[1]=path1b[0];

}
#endif //NEWMALSPVQ3

void  unquantize_LSI2(unsigned short *qindex, float *lspq)
{
  int j, ind1a, ind1b;

  ind1a = qindex[0];
  ind1b = qindex[1];
  for (j=0;j<6;j++) lspq[j]=cba_new[ind1a][j];
  for (j=0;j<4;j++) lspq[6+j]=cbb_new[ind1b][j];
 
}
/************* end new_vq ***************************/


void stabilize(float *qlsi)
{
  int i;
  if (qlsi[0]<LSI_SPREAD_FACTOR) qlsi[0]=LSI_SPREAD_FACTOR;
  for (i=1; i<LPCORDER; i++)
    if (qlsi[i]-qlsi[i-1]<LSI_SPREAD_FACTOR)
      qlsi[i]=qlsi[i-1]+LSI_SPREAD_FACTOR;
  if (1.0-qlsi[LPCORDER-1]<2*LSI_SPREAD_FACTOR) { 
    qlsi[LPCORDER-1]=1.0-2*LSI_SPREAD_FACTOR;
    i=LPCORDER-2;
    while (qlsi[i+1]-qlsi[i]<LSI_SPREAD_FACTOR) {
      qlsi[i]=qlsi[i+1]-LSI_SPREAD_FACTOR;
      i--;
    }
  }
}

#ifdef EVRC_LSPQ
/*======================================================================*/
/*  Lucent Technologies Network Wireless Systems                        */
/*  EVRC Floating-point C Simulation.                                   */
/*                                                                      */
/*  Copyright (C) 1996 Lucent Technologies Incorporated. All rights     */
/*  reserved.                                                           */
/*----------------------------------------------------------------------*/
/*  Module:     lspmaq.c                                                */
/*----------------------------------------------------------------------*/
/*  History:                                                            */
/*     01/01/95  Written By Dror Nahumi, AT&T                           */
/*----------------------------------------------------------------------*/

/************************************************************************
*            *****   LSP matrix quantization  ************              *
*                                                                       *
* Input Arguments                                                       *
* ***************                                                       *
* x		Input LSP matrix  x(ndimx,kdim), i.e., kdim rows of     *
*		ndimx elements.                                         *
*		LSP vectors row by row.                                 *
* ndim		Actual vector dimension (LSP order).  ndim <= ndimx     *
* kdim		Number of LSP vectors, i.e., number of rows in the main matrix.
* many		Number of sub-matrices.                                 *
* nsub		Array containing "many" sub-matrices sizes. nsub(i) is the size
*		of the rows in the ith sub-matrix. Sum(i)[ nsub(i) ] = ndim *
* book		(1D). Contains "many" codebooks in series. The ith codebook *
*		contains matices of size kdim rows by nsub(i) columns.      *
*		i.e., kdim vectors of size nsub(i) in series.               *
* alp		Weight adjustment factor.  alp=0  no weight                 *
*                                          alp >0 input is weighted         *
* nsiz		Contain "many" size values. nsiz(i) is the number of matrices *
*		in codebook i.                                                *
*                                                                       *
* Output arguments                                                      *
* ****************                                                      *
* y		Output matrix. The quantized version of x (same size).        *
* index		Contains "many" indices of the best matrix from each codebook *
* d		Aux. array, at least the size of max( nsiz(i) )               *
*                                                                       *
*************************************************************************/
#include "macro.h"
#include "rom.h"

void lspmaq(float *x,short ndim,short kdim,short many,short *nsub,short *nsiz,
	    float alp,float *y,short *index,short br,float *lsptab)
{
#define OneDivPI2 0.15915494
  register int i, j, k, m, im, jp, km, jm, jk, jpm, jj, jpmk, kn;
  float   dm;
  static float df = 0.05 * OneDivPI2;
  float   d[2048];
  
  jj = 0;
  
  /* Find weights */
  for (k=0; k<kdim; k++) {
    kn = k * ndim;
    y[kn] = x[kn + 1] - x[kn];
    y[kn + ndim - 1] = x[kn + ndim - 1] - x[kn + ndim - 2];
    for (i=1; i<ndim-1; i++) {
      y[i + kn] = Min(x[i + kn] - x[i - 1 + kn], x[i + 1 + kn] - x[i + kn]);
    }
    for (i=0; i<ndim; i++) {
      if (y[i + kn] != 0) y[i + kn] = alp / y[i + kn] * OneDivPI2 + 1.0;
      else y[i + kn] = 50.0 * OneDivPI2 + 1.0;
    }
  }

  /* Code all sub-matrices */
  im = 0;
  jp = 0;
  for (m=0; m<many; m++) {
    for (j=0; j<nsiz[m]; j++) d[j] = 0;
    km = nsub[m] * kdim;
    for (j=0; j<nsiz[m]; j++) {
      jm = km * j;
      for (k=0; k<kdim; k++) {
	jk = k * nsub[m];
	kn = k * ndim;
	jpm = jp + jm + jk;
	for (i=0; i<nsub[m]; i++)
	  d[j] = d[j] + y[i + im + kn] * (x[i + im + kn] - lsptab[jpm + i]) *
	    (x[i + im + kn] - lsptab[jpm + i]);
      }
    }
    
    if (im > 0) {
      for (k=0; k<kdim; k++) {
	jk = k * nsub[m];
	kn = k * ndim;
	for (j=0; j<nsiz[m]; j++) {
	  jm = km * j;
	  jpm = jp + jm + jk;
	  if (lsptab[jpm] <= y[im - 1 + kn] + df) d[j] = 1.0e38;
	}
      }
    }

    dm = 1.0e38;
    for (j=0; j<nsiz[m]; j++) {
      if (d[j] < dm) {
	dm = d[j];
	jj = j;
      }
    }
    
    index[m] = jj;
    
    jpm = jp + km * index[m];
    for (k=0; k<kdim; k++) {
      jpmk = jpm + k * nsub[m];
      kn = k * ndim;
      for (i=0; i<nsub[m]; i++) y[im + i + kn] = lsptab[jpmk + i];
    }
    
    im += nsub[m];
    jp += km * nsiz[m];
  }

}

/***************************************************************************
* Routine name: lspmaq_dec                                                 *
* Function: VQ of line spectral frequencies - Decoder part.                *
* Inputs:                                                                  *
*         ndim	- Actual vector dimension (LSP order).                     *
*         kdim	- Number of LSP vectors, i.e., number of rows in the main  *
*                matrix.                                                   *
*         many	- Number of sub-matrices.                                  *
*         nsub	- Array containing "many" sub-matrices sizes. nsub(i) is   *
*                the size of the rows in the ith sub-matrix.               *
*                Sum(i)[ nsub(i) ] = ndim.                                 *
*         book	- (1D). Contains "many" codebooks in series. The ith       *
*                codebook contains matices of size kdim rows by nsub(i)    *
*                columns. i.e., kdim vectors of size nsub(i) in series.    *
*         alp	- Weight adjustment factor. alp=0 no weight. alp >0 input  *
*                is weighted.                                              *
*         nsiz	- Contain "many" size values. nsiz(i) is the number of     *
*                matrices in codebook i.                                   *
*                                                                          *
* Outputs: y	- Output matrix. The quantized version of x (same size).   *
*          index - Contains "many" indices of the best matrix from each    *
*                  codebook.                                               *
*                                                                          *
*                                                                          *
*  Program written by Dror Nahumi, Dep. 45370H                             *
***************************************************************************/
void lspmaq_dec(short ndim, short kdim, short many, short *nsub,
		short *nsiz, float *y, short *index, short br, float *lsptab)
{
  register int i, k, m, im, jp, km, jpm, jpmk, kn;
  
  /* Code all sub-matrices */
  im = 0;
  jp = 0;
  for (m=0; m<many; m++) {
    km = nsub[m] * kdim;
    jpm = jp + km * index[m];
    for (k=0; k<kdim; k++) {
      jpmk = jpm + k * nsub[m];
      kn = k * ndim;
      for (i=0; i<nsub[m]; i++) y[im + i + kn] = lsptab[jpmk + i];
    }
    im += nsub[m];
    jp += km * nsiz[m];
  }
}
#endif //EVRC_LSPQ
