/**********************************************************************
Each of the companies; Motorola, and Lucent, and Qualcomm, and Nokia (hereinafter 
referred to individually as "Source" or collectively as "Sources") do 
hereby state:

To the extent to which the Source(s) may legally and freely do so, the 
Source(s), upon submission of a Contribution, grant(s) a free, 
irrevocable, non-exclusive, license to the Third Generation Partnership 
Project 2 (3GPP2) and its Organizational Partners: ARIB, CCSA, TIA, TTA, 
and TTC, under the Source's copyright or copyright license rights in the 
Contribution, to, in whole or in part, copy, make derivative works, 
perform, display and distribute the Contribution and derivative works 
thereof consistent with 3GPP2's and each Organizational Partner's 
policies and procedures, with the right to (i) sublicense the foregoing 
rights consistent with 3GPP2's and each Organizational Partner's  policies 
and procedures and (ii) copyright and sell, if applicable) in 3GPP2's name 
or each Organizational Partner's name any 3GPP2 or transposed Publication 
even though this Publication may contain the Contribution or a derivative 
work thereof.  The Contribution shall disclose any known limitations on 
the Source's rights to license as herein provided.

When a Contribution is submitted by the Source(s) to assist the 
formulating groups of 3GPP2 or any of its Organizational Partners, it 
is proposed to the Committee as a basis for discussion and is not to 
be construed as a binding proposal on the Source(s).  The Source(s) 
specifically reserve(s) the right to amend or modify the material 
contained in the Contribution. Nothing contained in the Contribution 
shall, except as herein expressly provided, be construed as conferring 
by implication, estoppel or otherwise, any license or right under (i) 
any existing or later issuing patent, whether or not the use of 
information in the document necessarily employs an invention of any 
existing or later issued patent, (ii) any copyright, (iii) any 
trademark, or (iv) any other intellectual property right.

With respect to the Software necessary for the practice of any or 
all Normative portions of the EVRC-B Variable Rate Speech Codec as 
it exists on the date of submittal of this form, should the EVRC-B be 
approved as a Specification or Report by 3GPP2, or as a transposed 
Standard by any of the 3GPP2's Organizational Partners, the Source(s) 
state(s) that a worldwide license to reproduce, use and distribute the 
Software, the license rights to which are held by the Source(s), will 
be made available to applicants under terms and conditions that are 
reasonable and non-discriminatory, which may include monetary compensation, 
and only to the extent necessary for the practice of any or all of the 
Normative portions of the EVRC-B or the field of use of practice of the 
EVRC-B Specification, Report, or Standard.  The statement contained above 
is irrevocable and shall be binding upon the Source(s).  In the event 
the rights of the Source(s) in and to copyright or copyright license 
rights subject to such commitment are assigned or transferred, the 
Source(s) shall notify the assignee or transferee of the existence of 
such commitments.
*******************************************************************/
/*===========================================================================*/
/*  Lucent Technologies Network Wireless Systems                             */
/*                                                                           */
/*  Copyright (C) 1999 Lucent Technologies.  All rights reserved.            */
/*  Lucent Technologies proprietary and confidential.                        */
/*---------------------------------------------------------------------------*/

#ifndef _LU_MOD_H
#define _LU_MOD_H

#define LU_MOD0       0
#define LU_MOD0_LSFVQ 0 //1
#define LU_MOD0_FCB   0 //1

#define LU_HR_LSFVQ   0 //1
#define LU_HR_GAINVQ  0 //1
#define LU_HR_FCB     0 //1

#define LU_POSTFILT   1 //1

#define LU_PHSFILT    0

#if LU_MOD0_LSFVQ
#include "lsfvq2.h"
#endif
#if LU_HR_LSFVQ
#include "lsfvq22.h"
#endif

#if LU_POSTFILT
extern void Post_Filter(
    float * syn,    /* in/out: synthesis speech (postfiltered is output)    */
    float * Lsp,
    float * Az,     /* input : interpolated LPC parameters in all subframes */
    float * synpf,
    float delayi,
    float agc_fac,
    float mu,
    short l_subfr
);
#endif

#if LU_PHSFILT
extern void  ph_filt (
	float*  x,          /* (i/o) Q0  : excitation signal                     */
	short   lg,         /* (i)       : vector dimension (subframe length)    */
	float   cbGain,     /* (i)   Q1  : Codebook gain                         */
	float   acbg,       /* (i)   Q14 : LTP gain                              */
	float*  inno        /* (i)   Q13 : Innovation vector                     */
);
#endif


#if LU_HR_GAINVQ
short qua_gain(         /* output: quantizer index */
 float code[],          /* input : fixed codebook vector */
 short lcode,           /* input : fcb vector length */
 float *gain_pit,       /* in/out: acbh gain /quantized acb gain*/
 float *gain_code,      /* in/out: fcb gain /quantized fcb gain */
 float *coeff,          /* input : correlation factors */
 short fcbg_only
);
void dec_gain(
 short indice,          /* input : quantizer index */
 float code[],          /* input : fixed code book vector */
 short lcode,           /* input : subframe size */
 float *gain_pit,       /* output: quantized acb gain */
 float *gain_code,      /* output: quantized fcb gain */
 short fcbg_only,
 short bfi              /* input : bad frame indicator good = 0 */
);
void gainq_update(
    float* code,
    float  gain_code,
    short  lcode,
    short  bfi,
    short  ed_flag       /* Encoder/ decoder flag */
);
#endif

#endif
