/**********************************************************************
Each of the companies; Motorola, and Lucent, and Qualcomm, and Nokia (hereinafter 
referred to individually as "Source" or collectively as "Sources") do 
hereby state:

To the extent to which the Source(s) may legally and freely do so, the 
Source(s), upon submission of a Contribution, grant(s) a free, 
irrevocable, non-exclusive, license to the Third Generation Partnership 
Project 2 (3GPP2) and its Organizational Partners: ARIB, CCSA, TIA, TTA, 
and TTC, under the Source's copyright or copyright license rights in the 
Contribution, to, in whole or in part, copy, make derivative works, 
perform, display and distribute the Contribution and derivative works 
thereof consistent with 3GPP2's and each Organizational Partner's 
policies and procedures, with the right to (i) sublicense the foregoing 
rights consistent with 3GPP2's and each Organizational Partner's  policies 
and procedures and (ii) copyright and sell, if applicable) in 3GPP2's name 
or each Organizational Partner's name any 3GPP2 or transposed Publication 
even though this Publication may contain the Contribution or a derivative 
work thereof.  The Contribution shall disclose any known limitations on 
the Source's rights to license as herein provided.

When a Contribution is submitted by the Source(s) to assist the 
formulating groups of 3GPP2 or any of its Organizational Partners, it 
is proposed to the Committee as a basis for discussion and is not to 
be construed as a binding proposal on the Source(s).  The Source(s) 
specifically reserve(s) the right to amend or modify the material 
contained in the Contribution. Nothing contained in the Contribution 
shall, except as herein expressly provided, be construed as conferring 
by implication, estoppel or otherwise, any license or right under (i) 
any existing or later issuing patent, whether or not the use of 
information in the document necessarily employs an invention of any 
existing or later issued patent, (ii) any copyright, (iii) any 
trademark, or (iv) any other intellectual property right.

With respect to the Software necessary for the practice of any or 
all Normative portions of the EVRC-B Variable Rate Speech Codec as 
it exists on the date of submittal of this form, should the EVRC-B be 
approved as a Specification or Report by 3GPP2, or as a transposed 
Standard by any of the 3GPP2's Organizational Partners, the Source(s) 
state(s) that a worldwide license to reproduce, use and distribute the 
Software, the license rights to which are held by the Source(s), will 
be made available to applicants under terms and conditions that are 
reasonable and non-discriminatory, which may include monetary compensation, 
and only to the extent necessary for the practice of any or all of the 
Normative portions of the EVRC-B or the field of use of practice of the 
EVRC-B Specification, Report, or Standard.  The statement contained above 
is irrevocable and shall be binding upon the Source(s).  In the event 
the rights of the Source(s) in and to copyright or copyright license 
rights subject to such commitment are assigned or transferred, the 
Source(s) shall notify the assignee or transferee of the existence of 
such commitments.
*******************************************************************/

//static char const rcsid[]="$Id: //E-XMS/GIT/csa/Utilities/cpp/RtpCodecUtil/evrc_b/nelp.cpp#1 $";

/*======================================================================*/
/*  4GV - Fourth Generation Vocoder Speech Service Option for             */
/*  Wideband Spread Spectrum Digital System                             */
/*  C Source Code Simulation                                            */
/*                                                                      */
/*  Copyright (C) 1999 Qualcomm Incorporated. All rights                */
/*  reserved.                                                           */
/*----------------------------------------------------------------------*/

/**************************************************************************
****        Globalstar Vocoder C/C++ Simulation  - Version 3           ****
****                Copyright 1996 - Qualcomm, Inc.                    ****
***************************************************************************

Globalstar Vocoder NELP Coder Routines
Sharath Manjunath; Ver 1 - 25 July 1996
                   Ver 2 - 10 October 1996
Modifications: 10 March 1997 - SF Energies Quantized
               20 March 1997 - Seed Transfer from Tx to Rx Removed
	       24 March 1997 - Added UnWeighted Reconstruction in Encode
	       25 March 1997 - Zero Rate Adjustments made
	       02 April 1997 - Backup Comments and moved some Backups
	                       from gsv.cc
	       10 April 1997 - Added hooks for not quantizing NELP frame
**************************************************************************/
#ifdef WIN32
#include <iostream>
#else
#include <iostream>
#endif
using namespace std;
#include "defines.h"
#include "filt.h"
#include  "macro.h"
#include  "proto.h"
#include  "rom.h"
#include  "struct.h"
#include  "lu_mod.h"

#ifdef NEWMALSPVQ3
//extern float cbprevprev_E3[LPCORDER],cbprev_E3[LPCORDER];
#endif //NEWMALSPVQ3

//static float sanity_check;


# if 1

static float bp1_num_coef[13]={
  0.33935546875000, 0, -2.03564453125000, 0, 5.08886718750000, 0, -6.78515625000000,
  0, 5.08886718750000, 0, -2.03564453125000, 0, 0.33935546875000};

static float bp1_den_coef[13]={1,
  -0.43505859375000, -3.78784179687500, 1.28784179687500, 6.33081054687500, 
  -1.62207031250000, -5.86523437500000, 1.06396484375000, 3.14868164062500, 
  -0.36035156250000, -0.92333984375000, 0.05004882812500, 0.11499023437500};

static float shape1_num_coef[11]={ 
  0.959381103515625, -0.074554443359375, -0.4161376953125, 0.1317138671875, 
  -0.3109130859375, 0.00146484375, 0.080535888671875, -0.109100341796875,
  -0.023681640625, 0.03192138671875, 0.012176513671875};

static float shape1_den_coef[11]={1,
  0.0897216796875, -0.373443603515625, 0.123046875, -0.293243408203125, 
  -0.06097412109375, 0.071258544921875, -0.1190185546875, -0.048675537109375,
  0.026153564453125,  0.007720947265625};

static float shape2_num_coef[11]={
  0.938720703125, 0.000946044921875, -0.295989990234375, 0.2904052734375, 
  -0.17938232421875, -0.221221923828125, -0.3194580078125, 0.01348876953125,
  0.10003662109375, -0.001922607421875, 0.034027099609375};

static float shape2_den_coef[11]={1,
  0.488861083984375, -0.02716064453125, 0.390594482421875, 0.07159423828125, 
  -0.213165283203125, -0.402587890625, -0.176849365234375, -0.028961181640625,
  -0.0455322265625, -0.00927734375};

static float shape3_num_coef[11]={
  0.936431884765625, -0.011688232421875, -0.303253173828125, -0.293121337890625,
  -0.183013916015625, 0.232269287109375, -0.317169189453125, -0.010833740234375,
  0.098846435546875, 0.0003662109375, 0.0364990234375};

static float shape3_den_coef[11]={1,
  -0.50347900390625, -0.027801513671875, -0.395111083984375, 0.06976318359375,
  0.22674560546875, -0.408477783203125, 0.18511962890625, -0.03607177734375, 
  0.0482177734375, -0.008331298828125};

static float txlpf1_num_coef[11]={
  0.016845703125, 0.024169921875, 0.062744140625, 0.0831298828125, 0.1124267578125, 
  0.11767578125, 0.1124267578125, 0.0831298828125, 0.062744140625, 0.024169921875, 
  0.016845703125};

static float txlpf1_den_coef[11]={1, 
  -2.3126220703125, 3.8590087890625, -3.8023681640625, 2.989990234375, 
  -1.5567626953125, 0.6748046875, -0.17529296875, 0.0423583984375, -0.0030517578125,
  0.00048828125};

static float txhpf1_num_coef[11]={
  0.016845703125, -0.024169921875, 0.062744140625, -0.0831298828125, 0.1124267578125,
  -0.11767578125, 0.1124267578125, -0.0831298828125, 0.062744140625, -0.024169921875,
  0.016845703125};

static float txhpf1_den_coef[11]={1,
  2.3126220703125, 3.8590087890625, 3.8023681640625, 2.989990234375, 1.5567626953125, 
  0.6748046875, 0.17529296875, 0.0423583984375, 0.0030517578125, 0.00048828125};

#endif




//static float rxlpf_num_coef[7]={0.59994581615663, 3.53683594633538, 8.74948168164726, 11.62517663542182, 8.74948168164726, 3.53683594633538, 0.59994581615663};
//static float rxlpf_den_coef[7]={ 1.0, 4.88981078104793, 10.11919486460807, 11.32491170693722, 7.22004529057673, 2.48380589810452, 0.35993498242596};


//static float copy[FSIZE];

void FGV_MEM::nelp_decoder(float *outFbuf,short post_filter,
				  float	time_warp_fraction, short*	obuf_len)
{
  register float *foutP;
  float   delayi[3];
  short   subframesize;

  int i,j,k;
  float *ptr=outFbuf;
    
  int lag=16;
  float Gains[10];
  int iG1,  iG2[2], fid;
  short packet_data;

  //  float tmp;
  float E2, E3, R;
  float filtRes[FSIZE*2]; //Increased size of filtRes to support Warping

  //static double bp1_filt_mem_dec[12];
  //static double shape1_filt_mem_dec[10];
  //static double shape2_filt_mem_dec[10];
  //static double shape3_filt_mem_dec[10];

  //Additions to support Warping
  int NUM_SAMPLES = 160;

  if (time_warp_fraction > 1)
		NUM_SAMPLES = 192;
  else if (time_warp_fraction < 1)
		NUM_SAMPLES = 128;

  *obuf_len = NUM_SAMPLES;

  //printf ("\n NELP warping %d", NUM_SAMPLES);
  //End: Additions to support Warping

  

  if (lastrateD !=2 || prev_frame_error) {
    for (i=0;i<12;i++) bp1_filt_mem_dec[i]=0;
    for (i=0;i<10;i++) shape1_filt_mem_dec[i]=0;
    for (i=0;i<10;i++) shape2_filt_mem_dec[i]=0;
    for (i=0;i<10;i++) shape3_filt_mem_dec[i]=0;
  }

  
  POLEZERO_FILTER bp1_filter={12,12,12,0,bp1_filt_mem_dec};
  POLEZERO_FILTER shape1_filter={10,10,10,0,shape1_filt_mem_dec};
  POLEZERO_FILTER shape2_filter={10,10,10,0,shape2_filt_mem_dec};
  POLEZERO_FILTER shape3_filter={10,10,10,0,shape3_filt_mem_dec};

  if(data_packet.PACKET_RATE!=2) cerr<<"Rate_Mode not set to 2 for NELP in Frame #:"<<decode_fcnt<<"\n";
  if(data_packet.MODE_BIT!=0) cerr<<"Here1:Rate not set for NELP in Frame #:"<<decode_fcnt<<"\n";
  // LSP De-Quantization
  float tmplsi[ORDER], tmplsc[ORDER];
  dec_lsp_vq_16((short int *)data_packet.LSP_IDX, lsp);
  /* Check for monontonic LSP */
  for (j=1; j<ORDER; j++) if (lsp[j] <= lsp[j - 1]) errorFlag=1;
#ifdef NEWMALSPVQ
    for (i=0;i<ORDER;i++) cbprevprev_D[i]=cbprev_D[i]=lsp[i];    
#else //NEWMALSPVQ
  /* Compute lsi for backing up for MA LPC in PPP */
  for (i=0; i<LPCORDER; i++) tmplsc[i]=cos(pi2*lsp[i]);
  for (i=0;i<ORDER;i++)
    tmplsi[i]=(tmplsc[i]<0.)+(SIGN(tmplsc[i]))*0.5*sqrt(1-fabs(tmplsc[i]));
  for (i=0;i<ORDER;i++) cbprevprev_D[i]=cbprev_D[i]=tmplsi[i];  
#endif //NEWMALSPVQ


#ifdef LSP_SPRD
  lsp_spread(lsp);
#endif 

      
  // Do Unvoiced/NELP Decoding
  
  iG1=data_packet.NELP_GAIN_IDX[0][0];

  iG2[0]=data_packet.NELP_GAIN_IDX[1][0];

  iG2[1]=data_packet.NELP_GAIN_IDX[1][1];
  
  fid=data_packet.NELP_FID;
      
  float dequantize_uvg(int iG1, int *iG2, float *G);
  dequantize_uvg(iG1,iG2,Gains);
  
  for (i=0;i<NUM_SAMPLES/16;i++) {//Small change to support Warping
    float tmp[16], tmp1[16], tmpf;
    int k1,k2, I[16], tmpi;
    for (j=0;j<16;j++) {
      tmp[j]=(nelp_dec_seed=521*nelp_dec_seed+259)/32768.0;
      tmp1[j]=ABS(tmp[j]);
      I[j]=j;
    }
    for (k1=0;k1<15;k1++) {
      for (k2=k1+1;k2<16;k2++) {
	if (tmp1[k2]>tmp1[k1]) {
	  tmpi=I[k2]; tmpf=tmp1[k2];
	  tmp1[k2]=tmp1[k1]; I[k2]=I[k1];
	  tmp1[k1]=tmpf; I[k1]=tmpi;
	}
      }
    }
	//Warping: Changes to support when NUM_SAMPLES > 160
	if (i < 10)
	{
		for (j=0;j<4;j++) ptr[i*16+I[j]]=Gains[i]*sqrt(3.0)*tmp[I[j]];
	}
	else
	{
		for (j=0;j<4;j++) ptr[i*16+I[j]]=Gains[9]*sqrt(3.0)*tmp[I[j]];
	}
	//End: Warping: Changes to support when NUM_SAMPLES > 160

    for (;j<16;j++) ptr[i*16+I[j]]=0;
  }

  //Small change to support Warping
  polezero_filter(ptr,ptr,NUM_SAMPLES,bp1_num_coef,bp1_den_coef,bp1_filter); 
  for (i=0, E3=0;i<FSIZE;i++) E3+=SQR(ptr[i]);

  //Small change to support Warping
  polezero_filter(ptr,ptr,NUM_SAMPLES,shape1_num_coef,shape1_den_coef,shape1_filter);
  
  for (i=0, E2=0;i<FSIZE;i++) E2+=SQR(ptr[i]);

  switch(fid) {
  case 1:
    // Update other filter memory
	//Small change to support Warping
    polezero_filter(ptr,filtRes,NUM_SAMPLES,shape3_num_coef,shape3_den_coef,
		    shape3_filter); 
    // filter the residual to desired shape
	//Small change to support Warping
    polezero_filter(ptr,ptr,NUM_SAMPLES,shape2_num_coef,shape2_den_coef,
		    shape2_filter);
    break;
  case 2:
    // Update other filter memory
	//Small change to support Warping
    polezero_filter(ptr,filtRes,NUM_SAMPLES,shape2_num_coef,shape2_den_coef,
		    shape2_filter);
    // filter the residual to desired shape
	//Small change to support Warping
    polezero_filter(ptr,ptr,NUM_SAMPLES,shape3_num_coef,shape3_den_coef,
		    shape3_filter);
    break;
  default:
    // Update other filter memory
	//Small change to support Warping
    polezero_filter(ptr,filtRes,NUM_SAMPLES,shape2_num_coef,shape2_den_coef,
		    shape2_filter);

	//Small change to support Warping
    polezero_filter(ptr,filtRes,NUM_SAMPLES,shape3_num_coef,shape3_den_coef,
		    shape3_filter);
    break;
  }
  for (i=0, E2=0;i<FSIZE;i++) E2+=SQR(ptr[i]);
  R=sqrt(E3/E2);
  for (i=0;i<FSIZE;i++) ptr[i]*=R;

  delayi[0] = (float) (DMIN);
  delayi[1] = (float) (DMIN);
  delayi[2] = (float) (DMIN);

  foutP = outFbuf;

  //More support for Warping
  int temp_samples_count = 0;
  //End: More support for Warping

  for (i = 0; i < NoOfSubFrames; i++) {
	
	//Warping: Change in size of subframesize, not always equal to 53 since residual size may not be = 160

	if (NUM_SAMPLES % 3 == 0)
		subframesize = NUM_SAMPLES/3;
	else if (NUM_SAMPLES % 3 == 1)
	{
		if (i < 2)
			subframesize = NUM_SAMPLES/3;
		else
			subframesize = NUM_SAMPLES/3 + 1;
	}
	else if (NUM_SAMPLES % 3 == 2)
	{
		if (i < 1)
			subframesize = NUM_SAMPLES/3;
		else
			subframesize = NUM_SAMPLES/3 + 1;
	}
	//End Change in size of subframesize, not always equal to 53

	//Warping: Slight change in call to support smaller/larger number of samples
    for (j=0;j<subframesize;j++)
      PitchMemoryD[ACBMemSize+j]=ptr[temp_samples_count+j];
			
    for (j = 0; j < ACBMemSize; j++)
      PitchMemoryD[j] = PitchMemoryD[j + subframesize];
    for (j = 0; j < ACBMemSize; j++)
      PitchPreFiltMemoryD[j] = PitchMemoryD[j];
    
    # ifdef QRES
      for(j=0;j<subframesize;j++)
       printf("%f\n",PitchMemoryD[j+ACBMemSize]);
    # endif

    
    /* Linear interpolation of lsp */
    Interpol(lspi, OldlspD, lsp, i, ORDER);
    /* Convert lsp to PC */
    lsp2a(pci, lspi);

    /* Synthesis of decoder output signal and postfilter output signal */
    SynthesisFilter(DECspeech,PitchMemoryD+ACBMemSize,pci,SynMemory,ORDER,
		    subframesize);

    if (post_filter) {
	Post_Filter(DECspeech, lspi, pci, DECspeechPF, 
		    (delayi[0]+delayi[1])/2.0, 0.0, 0.0, 
		    subframesize);
    }
    else V_copy(DECspeech, DECspeechPF, subframesize);

    /* Write decoder output and variables to files */
    for (j = 0; j < subframesize; j++) {
      if (DECspeechPF[j] > 32767.0) *foutP++ = 32767.0;
      else {
	if (DECspeechPF[j] < -32768) *foutP++ = -32768.0;
	else *foutP++ = DECspeechPF[j];
      }
	}
	temp_samples_count += subframesize; //Addition to support Warping
  }
}


void FGV_MEM::nelp_erasure_decoder(float *outFbuf,short post_filter)
{
  register float *foutP;
  float   delayi[3];
  short   subframesize;

  int i,j,k;
  float *ptr=outFbuf;
    
  int lag=16;
  double Gain;
  int iG1,  iG2[2], fid=0;
  short packet_data;

  //  float tmp;
  float E2, E3, R;
  float filtRes[FSIZE];
  
  //static double bp1_filt_mem_erasure_dec[12];
  //static double shape1_filt_mem_erasure_dec[10];
  //static double shape2_filt_mem_erasure_dec[10];
  //static double shape3_filt_mem_erasure_dec[10];

  if (!prev_frame_error) {
    for (i=0;i<12;i++) bp1_filt_mem_erasure_dec[i]=0;
    for (i=0;i<10;i++) shape1_filt_mem_erasure_dec[i]=0;
    for (i=0;i<10;i++) shape2_filt_mem_erasure_dec[i]=0;
    for (i=0;i<10;i++) shape3_filt_mem_erasure_dec[i]=0;
  }

  POLEZERO_FILTER bp1_filter={12,12,12,0,bp1_filt_mem_erasure_dec};
  POLEZERO_FILTER shape1_filter={10,10,10,0,shape1_filt_mem_erasure_dec};
  POLEZERO_FILTER shape2_filter={10,10,10,0,shape2_filt_mem_erasure_dec};
  POLEZERO_FILTER shape3_filter={10,10,10,0,shape3_filt_mem_erasure_dec};


  for (i=0,Gain=0;i<SubFrameSize;i++) Gain+=SQR(PitchMemoryD[ACBMemSize-i]);
  Gain=sqrt(Gain/SubFrameSize);
  Gain*=0.8;// Some scale down of energy since it is an erasure
  
  for (i=0;i<10;i++) {

    float tmp[16], tmp1[16], tmpf;
    int k1,k2, I[16], tmpi;
    for (j=0;j<16;j++) {
      tmp[j]=(nelp_erasure_seed=521*nelp_erasure_seed+259)/32768.0;
      tmp1[j]=ABS(tmp[j]);
      I[j]=j;
    }
    for (k1=0;k1<15;k1++) {
      for (k2=k1+1;k2<16;k2++) {
	if (tmp1[k2]>tmp1[k1]) {
	  tmpi=I[k2]; tmpf=tmp1[k2];
	  tmp1[k2]=tmp1[k1]; I[k2]=I[k1];
	  tmp1[k1]=tmpf; I[k1]=tmpi;
	}
      }
    }
    for (j=0;j<4;j++) ptr[i*16+I[j]]=Gain*sqrt(3.0)*tmp[I[j]];
    for (;j<16;j++) ptr[i*16+I[j]]=0;
  }

  polezero_filter(ptr,ptr,FSIZE,bp1_num_coef,bp1_den_coef,bp1_filter);
  for (i=0, E3=0;i<FSIZE;i++) E3+=SQR(ptr[i]);

  polezero_filter(ptr,ptr,FSIZE,shape1_num_coef,shape1_den_coef,shape1_filter);
  
  for (i=0, E2=0;i<FSIZE;i++) E2+=SQR(ptr[i]);

  switch(fid) {
  case 1:
    // Update other filter memory
    polezero_filter(ptr,filtRes,FSIZE,shape3_num_coef,shape3_den_coef,
		    shape3_filter);
    // filter the residual to desired shape
    polezero_filter(ptr,ptr,FSIZE,shape2_num_coef,shape2_den_coef,
		    shape2_filter);
    break;
  case 2:
    // Update other filter memory
    polezero_filter(ptr,filtRes,FSIZE,shape2_num_coef,shape2_den_coef,
		    shape2_filter);
    // filter the residual to desired shape
    polezero_filter(ptr,ptr,FSIZE,shape3_num_coef,shape3_den_coef,
		    shape3_filter);
    break;
  default:
    // Update other filter memory
    polezero_filter(ptr,filtRes,FSIZE,shape2_num_coef,shape2_den_coef,
		    shape2_filter);
    polezero_filter(ptr,filtRes,FSIZE,shape3_num_coef,shape3_den_coef,
		    shape3_filter);
    break;
  }
  for (i=0, E2=0;i<FSIZE;i++) E2+=SQR(ptr[i]);
  R=sqrt(E3/E2);
  for (i=0;i<FSIZE;i++) ptr[i]*=R;

  delayi[0] = (float) (DMIN);
  delayi[1] = (float) (DMIN);
  delayi[2] = (float) (DMIN);

  foutP = outFbuf;

  /* Convert lsp to PC */
  lsp2a(pci, OldlspD);

  for (i = 0; i < NoOfSubFrames; i++) {
    if (i < 2)
      subframesize = SubFrameSize - 1;
    else
      subframesize = SubFrameSize;
    Interpol(lspi, OldlspD, OldlspD, i, ORDER);
    for (j=0;j<subframesize;j++)
      PitchMemoryD[ACBMemSize+j]=ptr[i*(SubFrameSize-1)+j];
			
    for (j = 0; j < ACBMemSize; j++)
      PitchMemoryD[j] = PitchMemoryD[j + subframesize];
    for (j = 0; j < ACBMemSize; j++)
      PitchPreFiltMemoryD[j] = PitchMemoryD[j];

    
    /* Synthesis of decoder output signal and postfilter output signal */
    SynthesisFilter(DECspeech,PitchMemoryD+ACBMemSize,pci,SynMemory,ORDER,
		    subframesize);

    if (post_filter) {
	Post_Filter(DECspeech, lspi, pci, DECspeechPF, 
		    (delayi[0]+delayi[1])/2.0, 0.0, 0.0, 
		    subframesize);
    }
    else V_copy(DECspeech, DECspeechPF, subframesize);

    /* Write decoder output and variables to files */
    for (j = 0; j < subframesize; j++) {
      if (DECspeechPF[j] > 32767.0) *foutP++ = 32767.0;
      else {
	if (DECspeechPF[j] < -32768) *foutP++ = -32768.0;
	else *foutP++ = DECspeechPF[j];
      }
    }
  }
}


