/**********************************************************************
Each of the companies; Motorola, and Lucent, and Qualcomm, and Nokia (hereinafter 
referred to individually as "Source" or collectively as "Sources") do 
hereby state:

To the extent to which the Source(s) may legally and freely do so, the 
Source(s), upon submission of a Contribution, grant(s) a free, 
irrevocable, non-exclusive, license to the Third Generation Partnership 
Project 2 (3GPP2) and its Organizational Partners: ARIB, CCSA, TIA, TTA, 
and TTC, under the Source's copyright or copyright license rights in the 
Contribution, to, in whole or in part, copy, make derivative works, 
perform, display and distribute the Contribution and derivative works 
thereof consistent with 3GPP2's and each Organizational Partner's 
policies and procedures, with the right to (i) sublicense the foregoing 
rights consistent with 3GPP2's and each Organizational Partner's  policies 
and procedures and (ii) copyright and sell, if applicable) in 3GPP2's name 
or each Organizational Partner's name any 3GPP2 or transposed Publication 
even though this Publication may contain the Contribution or a derivative 
work thereof.  The Contribution shall disclose any known limitations on 
the Source's rights to license as herein provided.

When a Contribution is submitted by the Source(s) to assist the 
formulating groups of 3GPP2 or any of its Organizational Partners, it 
is proposed to the Committee as a basis for discussion and is not to 
be construed as a binding proposal on the Source(s).  The Source(s) 
specifically reserve(s) the right to amend or modify the material 
contained in the Contribution. Nothing contained in the Contribution 
shall, except as herein expressly provided, be construed as conferring 
by implication, estoppel or otherwise, any license or right under (i) 
any existing or later issuing patent, whether or not the use of 
information in the document necessarily employs an invention of any 
existing or later issued patent, (ii) any copyright, (iii) any 
trademark, or (iv) any other intellectual property right.

With respect to the Software necessary for the practice of any or 
all Normative portions of the EVRC-B Variable Rate Speech Codec as 
it exists on the date of submittal of this form, should the EVRC-B be 
approved as a Specification or Report by 3GPP2, or as a transposed 
Standard by any of the 3GPP2's Organizational Partners, the Source(s) 
state(s) that a worldwide license to reproduce, use and distribute the 
Software, the license rights to which are held by the Source(s), will 
be made available to applicants under terms and conditions that are 
reasonable and non-discriminatory, which may include monetary compensation, 
and only to the extent necessary for the practice of any or all of the 
Normative portions of the EVRC-B or the field of use of practice of the 
EVRC-B Specification, Report, or Standard.  The statement contained above 
is irrevocable and shall be binding upon the Source(s).  In the event 
the rights of the Source(s) in and to copyright or copyright license 
rights subject to such commitment are assigned or transferred, the 
Source(s) shall notify the assignee or transferee of the existence of 
such commitments.
*******************************************************************/
#if 0
/*****************************************************************
 *   (C) COPYRIGHT 1999, 2000 Motorola, Inc.
 *    MOTOROLA CONFIDENTIAL PROPRIETARY
 *****************************************************************/
/* noise_suprs_master.c */
/*
* The starting point for this program is "nsrda.c".  The latter
* program has been cleaned up and also modified to work with the
* AMR speech coder. This program is to be used as a reference to
* the fixed-point implementation.
*/

/****************************************************************/
/*								*/
/*								*/
/*        COPYRIGHT 1995, 1996, 1998, 1999 MOTOROLA INC.        */
/*								*/
/*								*/
/****************************************************************/

/*****************************************************************
*
* Noise Suppression
*
* Input:  The input to the function is a Word16 pointer to the
*         array of data to be noise suppressed.
*
* Output: There is no return value.  The input array is replaced
*         with the noise suppressed values.
*
*
* Written by:			Tenkasi V. Ramabadran
* Date:				December 28, 1994
*
* Last Modified:		Tenkasi V. Ramabadran
* Date:				August 16, 1999
*
*
* Version    Date      Description
*
*   1.0    12/01/95    Released to TIA TR45.5.1.1
*   1.1	   02/14/96    Init Noise to first 4 frames	 
*   1.2	   02/19/96    Bug fix in frame_cnt declaration	 
*   1.0    08/28/96    Integrate NS based Rate Determination
*                      Algorithm (RDA), rename to nsrda.c
*   1.1    05/15/97    Make SNR available as output for V/UV mode
*   1.2    09/28/98    Use LTP gain (beta) from speech coder to
*                      inhibit forced update
*   1.3    08/16/99    Modified to work with the AMR speech coder
*
*****************************************************************/

/* Includes */

#include		<stdio.h>
#include		<math.h>

#include		"nsvad.h"
#include		"macro.h"
#include		"struct.h"
//#include		"dump.h"

/* Local prototypes */
static void init_window (float *x, int n, float ovlap);
static void fill_tbl (void);
static void real_fft (float *farray_ptr, int isign);
static void cmplx_fft (float *, int);

/* Defines */

/* #define			NOISE_SUPPRESSION_20MS	0	now in noise_suprs.h */


#define			NS_ATTEN		13

#define			FRM_LEN1		160
#define			DELAY0			0
#define			DELAY1			40
#define			FFT_LEN1		256

//#define			UPDATE_CNT_THLD1	25
#define			UPDATE_CNT_THLD1	15

//#define			INIT_FRAMES		50
#define			INIT_FRAMES		5

#define			CNE_SM_FAC1		0.19
#define			CEE_SM_FAC1		0.9

#define			HYSTER_CNT_THLD1	3	/* forced update constants... */
#define			HIGH_ALPHA1		0.81
#define			LOW_ALPHA1		0.49



#define			NORM_ENRG		(1.0)	/* No division by 2 in the HPF (4.0 -> 6 dB)*/
    #define		MIN_CHAN_ENRG		(0.03 / NORM_ENRG)
    #define	        INE			(MIN_CHAN_ENRG)
    #define		NOISE_FLOOR		(NUM_CHAN*MIN_CHAN_ENRG)


#define			MIN_GAIN		(-13.0)
#define			GAIN_SLOPE		0.39

#define			PRE_EMP_FAC1		(-0.8)
#define			DE_EMP_FAC1		0.8

#define			NUM_CHAN		16
#define			LO_CHAN			0
#define			MID_CHAN		5
#define			HI_CHAN			15

#define			INDEX_CNT_THLD		5
#define			UPDATE_THLD		35
#define			METRIC_THLD		45
#define			INDEX_THLD		12
#define			SETBACK_THLD		12
#define			SNR_THLD		6

#define			SINE_START_CHAN		2
#define			P2A_THRESH		10.0
#define			DEV_THLD1		32.0

#define			ALPHA_RANGE1		(HIGH_ALPHA1-LOW_ALPHA1)

/* Defines for the FFT function */

#define			SIZE			256
#define			SIZE_BY_TWO		128
#define			NUM_STAGE		7

#define			PI			3.141592653589793

#define			TRUE			1
#define			FALSE			0

/* Macros */

#define			min(a,b)		((a)<(b)?(a):(b))
#define			max(a,b)		((a)>(b)?(a):(b))
#define			square(a)		((a)*(a))


/* The noise supression/VAD function */

int		FGV_MEM::nsvad (float *farray_ptr, nsState *st)

{

/* Static variables */

/* The channel table is defined below.  In this table, the
lower and higher frequency coefficients for each of the 16
channels are specified.  The table excludes the coefficients
with numbers 0 (DC), 1, and 64 (Foldover frequency).  For
these coefficients, the gain is always set at 1.0 (0 dB). */

static int	ch_tbl [NUM_CHAN][2] = {


			{  2,   5},
			{  6,   9},
			{ 10,  13},
			{ 14,  17},
			{ 18,  21},
			{ 22,  25},
			{ 26,  31},
			{ 32,  37},
			{ 38,  43},
			{ 44,  51},
			{ 52,  59},
			{ 60,  69},
			{ 70,  81},
			{ 82,  95},
			{ 96, 109},
			{110, 127}

		};

/* The voice metric table is defined below.  It is a non-
linear table with a deadband near zero.  It maps the SNR
index (quantized SNR value) to a number that is a measure
of voice quality. */ 

/*******
% matlab code for vm_threshold_table[] generation
min=2;          % FOURGV VAD
num_min=11;
exp=0.0212;

min=2;          % FOURGV VAD
num_min=0;
exp=0.0232;

for i=1:90,
  if (i<=num_min),      table(i)=min;
  else                  table(i)=floor(min+(10^((i-min+1)*exp))-1);
  end;
end;
table'
******/

static int	vm_tbl [90] = {2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
		3, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 7, 7, 7,
		8, 8, 9, 9, 10, 10, 11, 12, 12, 13, 13, 14, 15,
		15, 16, 17, 17, 18, 19, 20, 20, 21, 22, 23, 24,
		24, 25, 26, 27, 28, 28, 29, 30, 31, 32, 33, 34,
		35, 36, 37, 37, 38, 39, 40, 41, 42, 43, 44, 45,
		46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57,
		58, 59};

/* This table is used to de-emphasize the channel energy estimates */

static float		shape_tbl [NUM_CHAN] = {


                        5.55,
                        3.90,
                        2.54,
                        1.69,
                        1.18,
                        0.86,
                        0.62,
                        0.44,
                        0.33,
                        0.25,
                        0.19,
                        0.15,
                        0.12,
                        0.10,
                        0.09,
                        0.08


};

/*******
% matlab code for vm_threshold_table[] generation
min=38;         % ORIGINAL NS RDA
num_min=8;
exp=2.25;

min=34          % v40 AMR VAD
num_min=11;
exp=2.6;

min=35          % FOURGV VAD
num_min=7;
exp=2.26;

min=0;          % FOR SOFT_VAD:
num_min=9;
exp=1.9;

min=35          % FOURGV VAD
num_min=6.5;
exp=2.22;

for i=1:20,
  if (i<=num_min),      table(i)=min;
  else                  table(i)=round(min+(i-num_min+1)^exp);
  end;
end;
table'
******/


	/* voice metric sensitivity as a function of peak SNR (3 dB steps) */
	static Word16 vm_threshold_table[20] =
	{
	  //	35, 35, 35, 35, 35, 35, 35, 40, 47, 58, 73,  92, 116, 145, 178, 217, 261, 310, 364, 424
	  //    35, 35, 35, 35, 35, 35, 40, 46, 56, 69, 87, 107, 132, 161, 193, 230, 272, 317, 367, 422
		35, 35, 35, 35, 35, 35, 37, 43, 51, 63, 79,  99, 123, 151, 183, 220, 261, 307, 358, 414
	};

	/* voice metric sensitivity as a function of peak SNR (3 dB steps) */
	static Word16 vm_threshold_table2[20] =
	{
	   	0, 0, 0, 0, 0, 0, 0, 0, 0, 4,    8,   14,   21, 30,   40,   52,   65,   79,   95,  112
	};
	/* hangover as a function of peak SNR (3 dB steps) */
	static Word16 hangover_table[20] =
	{
		6,  6,  5,  4,  3,  2,  1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	};

	/* burst sensitivity as a function of peak SNR (3 dB steps) */
	static Word16 burstcount_table[20] =
	{
		4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 2, 2, 1, 1, 1, 1
	};




/*******
% matlab code for update_thresh_table[] generation
min=35          % FOURGV VAD
num_min=7;
exp=1.4;

for i=1:20,
  if (i<=num_min),      table(i)=min;
  else                  table(i)=round(min+(i-num_min+1)^exp);
  end;
end;
table'
******/



//static int	nsvad_first = TRUE;

//static float	pre_emp_mem = 0.0, de_emp_mem = 0.0;

//static float	ch_enrg [NUM_CHAN];

//static float	ch_noise [NUM_CHAN];

//static float	overlap [FFT_LEN1-FRM_LEN1];	/* initialized to 0.0 automatically */

//static float	ch_gain [FFT_LEN1/2];

//static int	update_cnt = 0; 

//static float	window [DELAY1+FRM_LEN1];

//static float	window_overlap [DELAY1];

//static int	hyster_cnt;		/* forced update statics... */
//static int	fupdate_flag;
//static int	last_update_cnt;
//static float	ch_enrg_long_db [NUM_CHAN];

//static unsigned long frame_cnt;
				


/* Automatic variables */

float		data_buffer [FFT_LEN1], enrg, snr;
float		tne, tce, gain, ftmp1, ftmp2;
int		ch_snr [NUM_CHAN];
int		i, j, j1, j2;
int		vm_sum;
int		update_flag, modify_flag, index_cnt;

float		ch_enrg_dev;		/* for forced update... */
float		ch_enrg_db [NUM_CHAN];
float		alpha;


/* For detecting sine waves */
float		peak, avg, peak2avg;
int		sine_wave_flag;

/* For computing frame SNR and long-term SNR */
float		tce_tmp;
float		xt;
//static float	tsnr;			/* total signal-to-noise ratio */



    #define	PEAK_SP_SM_UP	0.81
    #define	PEAK_SP_SM_DN	0.996
    #define	TNE_SM		0.990
    #define	MIN_GAIN_SM	0.98
    #define	PEAK_SP_INIT	50.0

float		max_ch_enrg, peak_sp_dB, tne_sh, tne_dB, peak_snr;
//static float	peak_sp_dB_filt, tne_dB_filt;
float		min_gain, gain_slope;
//static float	min_gain_filt;
float		net_gain;



//static	float	negSNRvar, negSNRbias;
	int	tsnrq;
	int	ivad;
//static	int	hangover, burstcount;




/* Functions */

void		real_fft (float *, int);
void		init_window (float *, int, float);


/* Executable code starts here */

/* Init the window function, channel gains one time */
  if (nsvad_first == TRUE) {

    init_window (window,
		DELAY1+FRM_LEN1,
		(float)DELAY1/(DELAY1+FRM_LEN1));
    fupdate_flag = 0;
    tsnr = 0.0;

  }

/* Increment frame counter */
  frame_cnt++;



/* Preemphasize the input data and store in the data buffer with
appropriate delay */

  for (i = 0; i < DELAY0; i++)
    data_buffer [i] = 0.0;

  for (i = DELAY0; i < DELAY0+DELAY1; i++)
    data_buffer [i] = window_overlap [i-DELAY0];

  data_buffer [DELAY0+DELAY1] = *farray_ptr + PRE_EMP_FAC1 * pre_emp_mem;

  for (i = DELAY0+DELAY1+1, j = 1; i < DELAY0+DELAY1+FRM_LEN1; i++, j++) 
    data_buffer [i] = *(farray_ptr + j) + PRE_EMP_FAC1 * 
                      *(farray_ptr + j - 1); 

  pre_emp_mem = *(farray_ptr + FRM_LEN1 - 1);

  for (i = DELAY0+DELAY1+FRM_LEN1; i < FFT_LEN1; i++)
    data_buffer [i] = 0.0;


/* update window_overlap buffer */

  for (i = 0, j = DELAY0+FRM_LEN1; i < DELAY1; i++, j++) 
    window_overlap [i] = data_buffer [j];


/* Apply window to frame prior to FFT */

  for (i = DELAY0; i < DELAY0+DELAY1+FRM_LEN1; i++)
    data_buffer [i] *= window [i-DELAY0];


/* Perform FFT on the data buffer */

  real_fft (data_buffer, +1);


/* Estimate the energy in each channel */

  alpha = (nsvad_first == TRUE) ? 1.0 : CEE_SM_FAC1;

  for (i = LO_CHAN; i <= HI_CHAN; i++) {

    enrg = 0.0;
    j1 = ch_tbl [i][0], j2 = ch_tbl [i][1];
    for (j = j1; j <= j2; j++)
      enrg += square(data_buffer [2*j]) + square(data_buffer [2*j+1]); 
    enrg /= (float) (j2 - j1 + 1);
    ch_enrg [i] = (1 - alpha) * ch_enrg [i] + alpha * enrg;
    if (ch_enrg [i] < MIN_CHAN_ENRG) ch_enrg [i] = MIN_CHAN_ENRG;

  }


/* Calculate spectral peak-to-average ratio */

  peak = avg = 0.;
  for (i = LO_CHAN; i <= HI_CHAN; i++) {
    if (i >= SINE_START_CHAN && ch_enrg [i] > peak)	/* Sine waves not valid for low frequencies */
    {
      peak = ch_enrg [i];
    }
    avg += ch_enrg [i];
  }
  avg /= HI_CHAN - LO_CHAN + 1;

  peak2avg = (avg < 1./NORM_ENRG) ? 0. : 10.*log10( peak/avg );


/* Initialize channel noise estimate to channel energy of first frame
   (if sufficiently low Peak-to-Average ratio) */

  if (frame_cnt <= 2) {
    if (peak2avg <= P2A_THRESH) {
      for (i = LO_CHAN; i <= HI_CHAN; i++)
        ch_noise [i] = max(ch_enrg [i], INE);
    }
    else {
      for (i = LO_CHAN; i <= HI_CHAN; i++)
        ch_noise [i] = INE;
    }
  }


/* Compute the channel SNR indices */

  for (i = LO_CHAN; i <= HI_CHAN; i++) {

    snr = 10.0 * log10 ((double) (ch_enrg [i] / ch_noise [i]));
    if (snr < 0.0) snr = 0.0;
    ch_snr [i] = (int)((snr + 0.1875) / 0.375);

  }


/* Compute the sum of voice metrics */

  vm_sum = 0;
  for (i = LO_CHAN; i <= HI_CHAN; i++) {

    j = min(ch_snr[i],89);
    vm_sum += vm_tbl [j];

  }


/* Compute the total noise estimate (tne) and total channel energy estimate (tce) */

  tne = tce = 0.0;

  for (i = LO_CHAN; i <= HI_CHAN; i++) {

    tne += ch_noise [i];
    tce += ch_enrg [i];

  }

  /* calculate SNR for mode decision */
  float band_eng, band_noise;
  band_eng=0; band_noise=0;
  for (i=LO_CHAN;i<11;i++) {
    band_eng+=ch_enrg[i];
    band_noise+=ch_noise[i];
  }
  st->snr[0]=max(0,10*log10(band_eng/band_noise));

  band_eng=0; band_noise=0;
  for (i=11;i<=HI_CHAN;i++) {
    band_eng+=ch_enrg[i];
    band_noise+=ch_noise[i];
  }
  st->snr[1]=max(0,10*log10(band_eng/band_noise));


  if (frame_cnt <= INIT_FRAMES || fupdate_flag == TRUE)
  {
    negSNRvar = 0;
    negSNRbias = 0;
  }

  /* Calculate instantaneous frame signal-to-noise ratio */
  /* xt = 10*log10 (sum (10.^(ch_snr/10))/length(ch_snr)) */
  ftmp1 = 0;
  for (i = LO_CHAN; i <= HI_CHAN; i++)
  {
    ftmp1 += ch_enrg[i]/ch_noise[i];
  }
  xt = 10.*log10 (ftmp1/NUM_CHAN);

  tsnr = peak_sp_dB_filt - tne_dB_filt;



  /* Quantize the long-term SNR in 3 dB steps */
  tsnrq = (int)(tsnr/3.);
  tsnrq = min(19, max(0, tsnrq));

  /* Calculate the negative SNR sensitivity bias */
  if (xt < 0)
  {
    negSNRvar = min (0.99*negSNRvar + 0.01*xt*xt, 4.0);
    negSNRbias = max (12.0*(negSNRvar - 0.65), 0.0);
  }





#define RELAX_VAD_THSH_FOR_MODE_2 1     // nsvad2 without this + 80 Hz HPF
  float vad_threshold;
  if (st->fourgv_mode == 2) {
    vad_threshold = (vm_threshold_table[tsnrq]-vm_threshold_table[0])*0.2 + vm_threshold_table[tsnrq] + negSNRbias;
  } else {
    vad_threshold = vm_threshold_table[tsnrq] + negSNRbias;
  }
  /* Determine VAD as a function of the voice metric sum and quantized SNR */
  if (vm_sum > vad_threshold)
  {

    // if (vm_sum > (vm_threshold_table[tsnrq] + vm_threshold_table2[tsnrq] + negSNRbias)) {
    if (st->fourgv_mode == 0) {
      if (vm_sum > ((vm_threshold_table[tsnrq]-10)*1.5 + negSNRbias)) {
	ivad = 2;
      } else {
	ivad = 1;
      }
    }
    else if (st->fourgv_mode == 1) {
      if (vm_sum > ((vm_threshold_table[tsnrq]-5)*1.4 + negSNRbias)) {
	ivad = 2;
      } else {
	ivad = 1;
      }
    }
    else {
      if (vm_sum > ((vm_threshold_table[tsnrq]-15)*1.8 + negSNRbias))
      {
	ivad = 2;
      } else {
	ivad = 1;
      }
    }

    if (++burstcount > burstcount_table[tsnrq]) {
      hangover = hangover_table[tsnrq];
    }
  } else {
    burstcount = 0;
    if (--hangover <= 0) {
      ivad = 0;
      hangover = 0;
    } else {
      ivad = 1;
    }
  }


/* Calculate log spectral deviation */

  for (i = LO_CHAN; i <= HI_CHAN; i++)
    ch_enrg_db [i] = 10.*log10( ch_enrg [i] );

  if (nsvad_first == TRUE)
    for (i = LO_CHAN; i <= HI_CHAN; i++)
      ch_enrg_long_db [i] = ch_enrg_db [i];

  ch_enrg_dev = 0.;
  for (i = LO_CHAN; i <= HI_CHAN; i++)
    ch_enrg_dev += fabs( ch_enrg_long_db [i] - ch_enrg_db [i] );


/* Calculate long term integration constant as a function of
   instantaneous SNR (i.e., high SNR (tsnr dB) -> slower integration,
   low  SNR (0 dB) -> faster integration */
  if (tsnr <= 0.0 || tsnr <= xt)
    alpha = HIGH_ALPHA1;
  else if (xt <= 0.0)
    alpha = LOW_ALPHA1;
  else
    alpha = HIGH_ALPHA1 - ALPHA_RANGE1 * (tsnr - xt)/tsnr;

/* Calc long term log spectral energy */

  for (i = LO_CHAN; i <= HI_CHAN; i++) {
    ch_enrg_long_db[i] = alpha*ch_enrg_long_db[i] + (1.-alpha)*ch_enrg_db[i];
  }


/* Detect sine waves by using Peak-to-Average spectrum ratio and
   channel energy deviation */

/*  if (peak2avg > 10. && ch_enrg_dev < DEV_THLD1) */
  if (peak2avg > 10.)
    sine_wave_flag = TRUE;
  else
    sine_wave_flag = FALSE;


/* Set or reset the update flag */

  update_flag = FALSE;
  fupdate_flag = FALSE;

  if (frame_cnt <= INIT_FRAMES && sine_wave_flag == FALSE) {

    update_flag = TRUE;
    update_cnt = 0;

  } else if (vm_sum <= UPDATE_THLD) {

    if (burstcount == 0) {
      update_flag = TRUE;
      update_cnt = 0;
    }

  }
  else if (tce > NOISE_FLOOR && ch_enrg_dev < DEV_THLD1 &&
           sine_wave_flag == FALSE && st->LTP_flag == FALSE) {

    update_cnt++;
    if (update_cnt >= UPDATE_CNT_THLD1) {
      update_flag = TRUE;
      fupdate_flag = TRUE;
      // fprintf(stderr, "\r  FLOAT: Forced update: frame %ld       \n", frame_cnt);
    }
  }

  if ( update_cnt == last_update_cnt )
    hyster_cnt++;
  else
    hyster_cnt = 0;
  last_update_cnt = update_cnt;

  if ( hyster_cnt > HYSTER_CNT_THLD1 )
    update_cnt = 0;

/*
	fprintf(stderr, "\rLTP flag = %d update_flag = %d fupdate_flag = %d             \n",
	st->LTP_flag, update_flag, fupdate_flag);
*/



/* Compute the peak SNR */

  if (frame_cnt <= INIT_FRAMES || fupdate_flag == TRUE)
  {
    peak_sp_dB_filt = PEAK_SP_INIT;
  }
  else
  {
    if (vm_sum > 150)
    {
      max_ch_enrg = 0.0;
      for (i = LO_CHAN; i <= HI_CHAN; i++)
      {
        ftmp1 = ch_enrg [i] * shape_tbl [i];
        if (ftmp1 > max_ch_enrg)
          max_ch_enrg = ftmp1;
      }

      peak_sp_dB = 10. * log10(max_ch_enrg);

      if (peak_sp_dB > peak_sp_dB_filt)
      {
        peak_sp_dB_filt = PEAK_SP_SM_UP * peak_sp_dB_filt + (1.0-PEAK_SP_SM_UP) * peak_sp_dB;
      }
      else
      {
        peak_sp_dB_filt = PEAK_SP_SM_DN * peak_sp_dB_filt + (1.0-PEAK_SP_SM_DN) * peak_sp_dB;
      }
    }
  }

  //  if (first == TRUE)
  if (frame_cnt <= INIT_FRAMES )
  {
    tne_sh = 0.0;
    for (i = LO_CHAN; i <= HI_CHAN; i++)
      tne_sh += ch_noise[i] * shape_tbl[i];
    tne_dB = 10. * log10(tne_sh);
    tne_dB_filt = tne_dB;
  }
  else
  {
    if (update_flag == TRUE)
    {
      tne_sh = 0.0;
      for (i = LO_CHAN; i <= HI_CHAN; i++)
        tne_sh += ch_noise[i] * shape_tbl[i];
      tne_dB = 10. * log10(tne_sh);
      tne_dB_filt = TNE_SM * tne_dB_filt + (1.0-TNE_SM) * tne_dB;


    }
  }

  peak_snr = peak_sp_dB_filt - tne_dB_filt;



/* Set or reset modify flag */

  index_cnt = 0;

  for (i = MID_CHAN; i <= HI_CHAN; i++)
    if (ch_snr [i] >= INDEX_THLD)
      index_cnt++;

  modify_flag = (index_cnt < INDEX_CNT_THLD)? TRUE : FALSE;
 

/* Modify the SNR indices */

  if (modify_flag == TRUE)
    for (i = LO_CHAN; i <= HI_CHAN; i++)
      if ((vm_sum <= METRIC_THLD) || (ch_snr [i] <= SETBACK_THLD))
        ch_snr [i] = 1;


/* Compute the channel gains */

/* First, select min_gain_filt and gain_slope */


  if (peak_snr > 15.0)
  {
    min_gain = -13.0;
  }
  else
  {
    min_gain = -13.0 + (15.0 - peak_snr) * (3.0/4.0);
    if (min_gain > -9.0)
    {
       min_gain = -9.0;
    }
  }

  if (nsvad_first == TRUE)
  {
    min_gain_filt = min_gain;
  }
  else
  {
    min_gain_filt = MIN_GAIN_SM * min_gain_filt + (1.0-MIN_GAIN_SM) * min_gain;
  }


  if (min_gain_filt <= -13.0)
  {
    gain_slope = 0.39;
  }
  else
  {
    gain_slope = 0.39 + (-13.0 - min_gain_filt) * (0.01);
  }




  if (ivad == 0)
    net_gain = min_gain_filt - MORE_NSVAD_ATTEN;
  else
    net_gain = min_gain_filt;
  ftmp1 = 10.0 * log10 ((double) (NOISE_FLOOR / tne));
  ftmp1 = max(ftmp1,net_gain);

  for (i = LO_CHAN; i <= HI_CHAN; i++) {

    if (ch_snr [i] <= SNR_THLD)
      ch_snr [i] = SNR_THLD;

    gain = (ch_snr [i] - SNR_THLD) * gain_slope + ftmp1;

    gain = min(0.0,gain);

    ftmp2 = pow (10.0, (double) (gain / 20.0));

    j1 = ch_tbl [i][0], j2 = ch_tbl [i][1];

    for (j = j1; j <= j2; j++)
      ch_gain [j] = ftmp2; 

  } 


  j = ch_tbl [0][0];
  for (i = 0; i < j; i++)
    ch_gain [i] = ch_gain [j];


/* Update the channel noise estimates */

  if (update_flag == TRUE)
    for (i = LO_CHAN; i <= HI_CHAN; i++) {

      ch_noise [i] = (1.0 - CNE_SM_FAC1) * ch_noise [i] +
                      CNE_SM_FAC1 * ch_enrg [i];

      if (ch_noise [i] < MIN_CHAN_ENRG) ch_noise [i] = MIN_CHAN_ENRG;

    }





  /* Filter the input data in the frequency domain and perform IFFT */

  data_buffer [0] *= ch_gain [0];
  data_buffer [1] *= ch_gain [FFT_LEN1/2 - 1];

  for (i = 1; i < FFT_LEN1 / 2; i++) {

    data_buffer [2*i] *= ch_gain [i];
    data_buffer [2*i+1] *= ch_gain [i];

  }





  real_fft (data_buffer, -1);

/* Overlap add the filtered data from previous block.
Save data from this block for the next. */ 

  for (i = 0; i < FFT_LEN1 - FRM_LEN1; i++)
    data_buffer [i] += overlap [i];

  for (i = FRM_LEN1; i < FFT_LEN1; i++)
    overlap [i - FRM_LEN1] = data_buffer [i];


/* Deemphasize the filtered speech and write it out to farray */

  *farray_ptr = data_buffer [0] + DE_EMP_FAC1 * de_emp_mem;

  for (i = 1; i < FRM_LEN1; i++) 
    *(farray_ptr + i) = data_buffer [i] + DE_EMP_FAC1 * 
                      *(farray_ptr + i - 1); 

  de_emp_mem = *(farray_ptr + FRM_LEN1 - 1);


  nsvad_first = FALSE;






  return (ivad);


}		/* end noise_suprs () */


/***************************************************************************/

static void init_window (float *x, int n, float ovlap)
{
	int i;
	float arg;
	int n1;

	/* use smoothed trapezoidal window */

	n1 = (int)(ovlap * n);
	arg = 2.*atan(1.)/n1;
	for (i=0; i<n1; i++) {
		x[i] = pow( sin( (i+0.5)*arg ), 2. );
	}
	for (i=n1; i<n-n1; i++) {
		x[i] = 1.;
	}
	for (i=n-n1; i<n; i++) {
		x[i] = pow( sin( ((i-n)+0.5)*arg ), 2. );
	}


	return;

}	/* end of init_window() */

/***************************************************************************/


/* FFT/IFFT function for real sequences */


/* Local global variables */

static double	phs_tbl [SIZE];		/* holds the complex sinusoids */


static void real_fft (float *farray_ptr, int isign)

{

float		ftmp1_real,ftmp1_imag,ftmp2_real,ftmp2_imag;
int		i,j;
static int	real_fft_first = TRUE;


/* If this is the first call to the function, fill up the
   phase table  */

  if (real_fft_first == TRUE)
  {
    fill_tbl ();
    real_fft_first = FALSE;
  }

/* The FFT part */

  if (isign == 1) {

/* Perform the complex FFT */

    cmplx_fft (farray_ptr, isign);

/* First, handle the DC and foldover frequencies */

    ftmp1_real = *farray_ptr;
    ftmp2_real = *(farray_ptr + 1);
    *farray_ptr = ftmp1_real + ftmp2_real;
    *(farray_ptr + 1) = ftmp1_real - ftmp2_real;

/* Now, handle the remaining positive frequencies */

    for (i = 2, j = SIZE - i; i <= SIZE_BY_TWO; i = i + 2, j = SIZE - i) {

      ftmp1_real = *(farray_ptr + i) + *(farray_ptr + j);
      ftmp1_imag = *(farray_ptr + i + 1) - *(farray_ptr + j + 1);
      ftmp2_real = *(farray_ptr + i + 1) + *(farray_ptr + j + 1);
      ftmp2_imag = *(farray_ptr + j) - *(farray_ptr + i);

      *(farray_ptr + i) = (ftmp1_real + phs_tbl [i] * ftmp2_real -
                          phs_tbl [i + 1] * ftmp2_imag) / 2.0;
      *(farray_ptr + i + 1) = (ftmp1_imag + phs_tbl [i] * ftmp2_imag +
                          phs_tbl [i + 1] * ftmp2_real) / 2.0;
      *(farray_ptr + j) = (ftmp1_real + phs_tbl [j] * ftmp2_real +
                          phs_tbl [j + 1] * ftmp2_imag) / 2.0;
      *(farray_ptr + j + 1) = (-ftmp1_imag - phs_tbl [j] * ftmp2_imag +
                          phs_tbl [j + 1] * ftmp2_real) / 2.0;

    }

  }

/* The IFFT part */

  else {

/* First, handle the DC and foldover frequencies */

    ftmp1_real = *farray_ptr;
    ftmp2_real = *(farray_ptr + 1);
    *farray_ptr = (ftmp1_real + ftmp2_real) / 2.0;
    *(farray_ptr + 1) = (ftmp1_real - ftmp2_real) / 2.0;

/* Now, handle the remaining positive frequencies */

    for (i = 2, j = SIZE - i; i <= SIZE_BY_TWO; i = i + 2, j = SIZE - i) {

      ftmp1_real = *(farray_ptr + i) + *(farray_ptr + j);
      ftmp1_imag = *(farray_ptr + i + 1) - *(farray_ptr + j + 1);
      ftmp2_real = -(*(farray_ptr + i + 1) + *(farray_ptr + j + 1));
      ftmp2_imag = -(*(farray_ptr + j) - *(farray_ptr + i));

      *(farray_ptr + i) = (ftmp1_real + phs_tbl [i] * ftmp2_real +
                          phs_tbl [i + 1] * ftmp2_imag) / 2.0;
      *(farray_ptr + i + 1) = (ftmp1_imag + phs_tbl [i] * ftmp2_imag -
                          phs_tbl [i + 1] * ftmp2_real) / 2.0;
      *(farray_ptr + j) = (ftmp1_real + phs_tbl [j] * ftmp2_real -
                          phs_tbl [j + 1] * ftmp2_imag) / 2.0;
      *(farray_ptr + j + 1) = (-ftmp1_imag - phs_tbl [j] * ftmp2_imag -
                          phs_tbl [j + 1] * ftmp2_real) / 2.0;

    }

/* Perform the complex IFFT */

    cmplx_fft (farray_ptr, isign);

  }
  
  return;

}		/* end real_fft () */



/* FFT/IFFT function for complex sequences */

/* The decimation-in-time complex FFT/IFFT is implemented below.
The input complex numbers are presented as real part followed by
imaginary part for each sample.  The counters are therefore
incremented by two to access the complex valued samples. */

static void		cmplx_fft (float *farray_ptr, int isign)

{

int		i,j,k,ii,jj,kk,ji,kj;
float		ftmp,ftmp_real,ftmp_imag;


/* Rearrange the input array in bit reversed order */

  for (i = 0, j = 0; i < SIZE-2; i = i + 2) {

    if (j > i) {

      ftmp = *(farray_ptr+i);
      *(farray_ptr+i) = *(farray_ptr+j);
      *(farray_ptr+j) = ftmp;

      ftmp = *(farray_ptr+i+1);
      *(farray_ptr+i+1) = *(farray_ptr+j+1);
      *(farray_ptr+j+1) = ftmp;

    }

    k = SIZE_BY_TWO;

    while (j >= k) {
      j -= k;
      k >>= 1;
    }

    j += k;

  }


/* The FFT part */

  if (isign == 1) {

    for (i = 0; i < NUM_STAGE; i++) {		/* i is stage counter */

      jj = (2 << i);				/* FFT size */
      kk = (jj << 1);				/* 2 * FFT size */
      ii = SIZE / jj;				/* 2 * number of FFT's */

      for (j = 0; j < jj; j = j + 2) {		/* j is sample counter */

        ji = j * ii;				/* ji is phase table index */

        for (k = j; k < SIZE; k = k + kk) {	/* k is butterfly top */

          kj = k + jj;				/* kj is butterfly bottom */

/* Butterfly computations */

          ftmp_real = *(farray_ptr + kj) * phs_tbl [ji] - 
                      *(farray_ptr + kj + 1) * phs_tbl [ji + 1];

          ftmp_imag = *(farray_ptr + kj + 1) * phs_tbl [ji] +
                      *(farray_ptr + kj) * phs_tbl [ji + 1];

          *(farray_ptr + kj) = (*(farray_ptr + k) - ftmp_real) / 2.0;
          *(farray_ptr + kj + 1) = (*(farray_ptr + k + 1) - ftmp_imag) / 2.0;

          *(farray_ptr + k) = (*(farray_ptr + k) + ftmp_real) / 2.0;
          *(farray_ptr + k + 1) = (*(farray_ptr + k + 1) + ftmp_imag) / 2.0;

        }

      }

    }

  }

/* The IFFT part */

  else {

    for (i = 0; i < NUM_STAGE; i++) {		/* i is stage counter */

      jj = (2 << i);				/* FFT size */
      kk = (jj << 1);				/* 2 * FFT size */
      ii = SIZE / jj;				/* 2 * number of FFT's */

      for (j = 0; j < jj; j = j + 2) {		/* j is sample counter */

        ji = j * ii;				/* ji is phase table index */

        for (k = j; k < SIZE; k = k + kk) {	/* k is butterfly top */

          kj = k + jj;				/* kj is butterfly bottom */

/* Butterfly computations */

          ftmp_real = *(farray_ptr + kj) * phs_tbl [ji] + 
                      *(farray_ptr + kj + 1) * phs_tbl [ji + 1];

          ftmp_imag = *(farray_ptr + kj + 1) * phs_tbl [ji] -
                      *(farray_ptr + kj) * phs_tbl [ji + 1];

          *(farray_ptr + kj) = *(farray_ptr + k) - ftmp_real;
          *(farray_ptr + kj + 1) = *(farray_ptr + k + 1) - ftmp_imag;

          *(farray_ptr + k) = *(farray_ptr + k) + ftmp_real;
          *(farray_ptr + k + 1) = *(farray_ptr + k + 1) + ftmp_imag;

        }

      }

    }

  }

  return;

}		/* end of cmplx_fft () */        



/* Function to fill the phase table values */

static void		fill_tbl ()

{

int		i;
double		delta_f, theta;

  delta_f = - PI / (double) SIZE_BY_TWO; 

  for (i = 0; i < SIZE_BY_TWO; i++) {

    theta = delta_f * (double) i;
    phs_tbl[2*i] = cos(theta);
    phs_tbl[2*i+1] = sin(theta);

  }



  return;

}		/* end fill_tbl () */


/**************************************************************************************/

#endif
