/**********************************************************************
Each of the companies; Motorola, and Lucent, and Qualcomm, and Nokia (hereinafter 
referred to individually as "Source" or collectively as "Sources") do 
hereby state:

To the extent to which the Source(s) may legally and freely do so, the 
Source(s), upon submission of a Contribution, grant(s) a free, 
irrevocable, non-exclusive, license to the Third Generation Partnership 
Project 2 (3GPP2) and its Organizational Partners: ARIB, CCSA, TIA, TTA, 
and TTC, under the Source's copyright or copyright license rights in the 
Contribution, to, in whole or in part, copy, make derivative works, 
perform, display and distribute the Contribution and derivative works 
thereof consistent with 3GPP2's and each Organizational Partner's 
policies and procedures, with the right to (i) sublicense the foregoing 
rights consistent with 3GPP2's and each Organizational Partner's  policies 
and procedures and (ii) copyright and sell, if applicable) in 3GPP2's name 
or each Organizational Partner's name any 3GPP2 or transposed Publication 
even though this Publication may contain the Contribution or a derivative 
work thereof.  The Contribution shall disclose any known limitations on 
the Source's rights to license as herein provided.

When a Contribution is submitted by the Source(s) to assist the 
formulating groups of 3GPP2 or any of its Organizational Partners, it 
is proposed to the Committee as a basis for discussion and is not to 
be construed as a binding proposal on the Source(s).  The Source(s) 
specifically reserve(s) the right to amend or modify the material 
contained in the Contribution. Nothing contained in the Contribution 
shall, except as herein expressly provided, be construed as conferring 
by implication, estoppel or otherwise, any license or right under (i) 
any existing or later issuing patent, whether or not the use of 
information in the document necessarily employs an invention of any 
existing or later issued patent, (ii) any copyright, (iii) any 
trademark, or (iv) any other intellectual property right.

With respect to the Software necessary for the practice of any or 
all Normative portions of the EVRC-B Variable Rate Speech Codec as 
it exists on the date of submittal of this form, should the EVRC-B be 
approved as a Specification or Report by 3GPP2, or as a transposed 
Standard by any of the 3GPP2's Organizational Partners, the Source(s) 
state(s) that a worldwide license to reproduce, use and distribute the 
Software, the license rights to which are held by the Source(s), will 
be made available to applicants under terms and conditions that are 
reasonable and non-discriminatory, which may include monetary compensation, 
and only to the extent necessary for the practice of any or all of the 
Normative portions of the EVRC-B or the field of use of practice of the 
EVRC-B Specification, Report, or Standard.  The statement contained above 
is irrevocable and shall be binding upon the Source(s).  In the event 
the rights of the Source(s) in and to copyright or copyright license 
rights subject to such commitment are assigned or transferred, the 
Source(s) shall notify the assignee or transferee of the existence of 
such commitments.
*******************************************************************/
/*======================================================================*/
/*  4GV - Fourth Generation Vocoder Speech Service Option for             */
/*  Wideband Spread Spectrum Digital System                             */
/*  C Source Code Simulation                                            */
/*                                                                      */
/*  Copyright (C) 1999 Qualcomm Incorporated. All rights                */
/*  reserved.                                                           */
/*----------------------------------------------------------------------*/

/**************************************************************************
****        Globalstar Vocoder C/C++ Simulation  - Version 3           ****
****                Copyright 1996 - Qualcomm, Inc.                    ****
***************************************************************************

Globalstar Vocoder Data Structures
Sharath Manjunath; Ver 1 - 25 July 1996
		   Ver 2 - 12 October 1996
Modifications: 29 April 1997 - Removed qlsicode, AB, BVQ
                               and some other control stuff
			       Added some control stuff, encoder LPC filter
**************************************************************************/

#ifndef _struct_h_
#define _struct_h_

#include "defines.h"
#include "macro.h"
#include "upgrades.h"
#include "SmartBlanking.h"

/**** Structures ****/

typedef struct {
	float  band_noise_sm[FREQBANDS];
	int    last_rate;           /* rate decisision after 2nd stage select_mode2() */
	int    last_rate_1st_stage; /* rate decision after 1st stage */
	int    last_rate_2nd_stage; /* rate decision after 2nd stage */
	int    num_full_frames;
	int    hangover, hangover_in_progress;
	int    band_rate[FREQBANDS];
	float  band_power[4];
	float  signal_energy[FREQBANDS];
	float  frame_energy_sm[FREQBANDS];
	int    adaptcount;
	int    pitchrun;
	float  band_power_last[FREQBANDS];
	int    snr_stat_once;
	int    snr_map[FREQBANDS];
	float  snr[FREQBANDS];
	float  r_filt[FREQBANDS][FILTERORDER];
	int    frame_num;
} ENCODER_MEM;

typedef struct  {
  double b[5];
  double a[5];
} HPFMem;

//added by gautam
struct PACKET {
unsigned short LSP_IDX[4];
unsigned short PACKET_RATE; //4-Full;3-Half;2-Quarter;1-Eighth
unsigned short MODE_BIT;//for the bit rate
unsigned short DELAY_IDX;
unsigned short DELTA_DELAY_IDX;

#if   ACCSHIFT_DELAY_ADJ
unsigned short DELAY_ADJ_IDX[3];
#endif

unsigned short ACBG_IDX[3];
unsigned short FCB_PULSE_IDX[3][4];//3=NoOfSubFrames 
unsigned short FCBG_IDX[3];
unsigned short NELP_GAIN_IDX[2][2];
unsigned short NELP_FID;
unsigned short SILENCE_GAIN;

short Q_delta_lag; /*Delta pitch for QPPP*/
short     POWER_IDX;     /*Codebook index for the power quantization for QPPP*/
short     AMP_IDX[2];    /*Codebook index for the Amplitude quantization for QPPP*/
unsigned short LSF_IDX[4];    /*Codebook index for the LSF codebooks*/

short delayindex;/*Pitch for PPP*/
unsigned short F_ROT_IDX; /*Codebook index for the global alignment for FPPP*/
short     A_POWER_IDX;     /*Codebook index for the absolute power quantization for FPPP*/
short     A_AMP_IDX[3];    /*Codebook index for the absolute amplitude quantization for FPPP*/
unsigned short F_ALIGN_IDX[17];  /*Codebook index for the alignment shifts for FPPP*/
unsigned short VC_IDX; /* Voicing cutoff index */

};

struct VLB {
  int ptr;
  float sig_ene_sm[2];
  float sig_ene[2];
  float noise_ene[2];
  float bn_update_factor;
  float bn_min[2][2];
  float bn_max;
  int decay_flag;
  int next_va;
  float prev_snr[2];
  float curr_snr[2];
  float next_snr[2];
};

struct VLBPARAMS {
  double R[BPFORDER+1];
  double E[LPCORDER+1];
  float lpc[LPCORDER];
  int S;
  float band_ene[2];
};

struct POLEZERO_FILTER {
  int order;
  int numord, denord;
  int ptr;
  double *mem;
};

struct POLE_FILTER {
  int order;
  int ptr;
  double *mem;
};

struct ZERO_FILTER {
  int order;
  int ptr;
  float *mem;
};

struct PITCH_FILTER {
  int order;
  int ptr;
  double *mem;
};

/*======================================================================*/
/*         ..Typedefs.                                                  */
/*----------------------------------------------------------------------*/
#include <stdint.h>
typedef int32_t int32;
typedef short  int16;

typedef struct {

  char*   input_filename;
  char*   output_filename;
  int16   encode_only;
  int16   decode_only;
  int16   max_rate;             int16  max_rate_default;
  int16   min_rate;             int16  min_rate_default;
  int16   post_filter;          int16  post_filter_default;
  int16   noise_suppression;    int16  noise_suppression_default;
  int16   ibuf_len;
  int16   obuf_len;

  int16   highpass_filter;
  int16   olr_calibration;
 
  int16 unquantized_lsp;
  int16 partial_file_processing;
  int16 starting_frame_num;
  int16 num_frames;
  int16 form_res_out;
  int16 qform_res_out;
  int16 mform_res_out;
  int16 target_speech_out;
  int16 rate_out;
  int16 lag_out;
  int16 nacf_out;
  int16 unquantized_prototype;
  int16 unquantized_zero_rate;
  int16 unquantized_quarter_rate;
  int16 unquantized_half_rate;
  int16 unquantized_full_rate;
  FILE *rfileP;
  char* rate_filename;
  int16 packet_out;
  int16 vad_out;
  int16 forced_count;
  int16 forced_rate[10];
  int16 forced_frame[10];
  int16 accshift_out;
  int16 avg_rate_control;
  float PPP_to_CELP_threshold;
  float avg_rate_target;
  int16 ratewin;
  int operating_point;
  char pattern[10];
  FILE* erasure_file;
  FILE* signalling_file;
  int16 verbose;

  //Added for Support of Phase Matching/Warping
  int phase_matching;
  int double_erasures_pm;
  int time_warping;
  //End:Added for Support of Phase Matching/Warping

  int dtx;
  
} EvrcArgs;

class DTFS {

public:
  float a[MAXLAG_WI_EVRC];
  float b[MAXLAG_WI_EVRC];

  int lag;
  DTFS(); //constructor
  DTFS operator=(DTFS );
  DTFS operator+(DTFS );
  DTFS operator-(DTFS );
  DTFS operator*(float );
  int operator==(DTFS X2);
  float operator^(DTFS );
  void print();
  void print_time();
  void print_time(float lband, float hband) ;
  void to_fs(const float *, int );
  void fs_inv(float *, int, float );
  void phaseShift(float );
  void zeroPadd(int );
  void zeroInsert(int );
  float alignment(DTFS, float);
  unsigned int glbl_alignment_QPPP(DTFS, float, int *, unsigned int);
  float alignment_fine(DTFS, float );
  float alignment_extract(DTFS, float, const float *);
  float alignment_full(DTFS, int );
  unsigned int glbl_alignment_FPPP(DTFS, int);
  float alignment_weight(DTFS, float, const float *, const float *);
  double freq_corr(DTFS, float, float);
  void transform(DTFS ,const float *, float *, int );
  void zeroFilter(const float *, int );
  void poleFilter(const float *, int );
  float getEngy();
  float getEngy(float, float) ;
  float setEngy(float );
  float getSpEngyFromResAmp(float, float, const float *);
  void deNormalizeResAmp(float, float, float, float, float, const float *);
  void randph();
  void car2pol();
  void pol2car();
  float setEngyHarm(float, float, float, float, float);
  float SCR(DTFS );
  float getSCR(const float *, int);
  void injectnoise(float);
  void adjustLag(int );
  bool quant_cw(int, const float *, int&, int *, float&, float&, float *);
  void quant_cw_memless(const float *, int&, int *);
  void dequant_cw(int, int&, int *, float&, float&, float *);
  void dequant_cw_memless(int&, int *);
  void to_erb(float *);
  void erb_inv(float *,int *, float *);
  void sortamp(float *outfreq, int m);
  float alignment_band(DTFS X2, float Eshift, float lband, float hband, float, float);
  void phaseShift_band(float ph, float lband, float hband);
  unsigned int align_band_FPPP(DTFS X2, float Eshift, float lband, float hband, float samp_resol, int num_steps);
  int alignment_CB(DTFS X2, float Eshift, const float *border, double *CB, int DIM, int SIZE, float *SNR);
  void peaktoaverage(float *,float *);
#ifdef TDTRANSFORM
  void fast_fs_inv(float *out, int N);
#endif //TDTRANSFORM
};

class FGV_MEM {
public:
	FGV_MEM();

  	float      buf[SPEECH_BUFFER_LEN*2+LOOKAHEAD_LEN];
  	float*     bufP;
  	int16      buf16[SPEECH_BUFFER_LEN*2];
  	int16*     buf16P;
	float   Scratch[SubFrameSize + 6];
	//float  *ExconvH = Scratch;
	float  *ExconvH;
	short   SScratch[6];		/* scratch short memory */
	float   lsp[ORDER];		/* Correlation coefficients                */
	float   lspi[ORDER];		/* Interpolation of correlation coeff      */

	float   pci[ORDER];		/* Interpolated prediction coefficients    */
	float  *gnvq;			/* Quantization table for fcb gain */

	short   idxppg;			/* Pitch gain c.b. - selected gain index   */
	short   idxcb;			/* Shape c.b. - selected shape index       */
	short   idxcbg;			/* FCB gain c.b. - selected gain index     */
	int     bit_rate;		/* Current coding scheme for encoder/decoder */
	int16     rate;

	int     PACKET_RATE;            /* Current bitrate for encoder/decoder */
	int     MODE_BIT;               /* Used to distinguish between CELP(0) and FPPP(1), */
	short	PktPtr[2];
	short	TxPkt[PACKWDSNUM];
	short	RxPkt[PACKWDSNUM];
	int     FCBGainSize;	        /* Current Fixed Codebook Gain Size */
	float	delay;			/* current frames delay */
	short	LPCflag;		/* LPC spectral transistion flag */  
	int		fcbIndexVector[10]; /* ACELP fixed codebook index vector */
	short	PackWdsPtr[2];		    /* Pointer to current TX/RX receive word */
	short	PackedWords[PACKWDSNUM];    /* TX/RX memory */
	short *nsize, *nsub, *lognsize, knum;
	float *lsptab;
	int     Q_delta_lag; /*Delta pitch for QPPP*/
	int     POWER_IDX;        /*Codebook index for the power quantization*/
	int     AMP_IDX[2];       /*Codebook index for the Amplitude quantization*/
	unsigned short LSF_IDX[3];/*Codebook index for the LSF quantization*/

	unsigned int F_ROT_IDX; /*Codebook index for the global alignment for FPPP*/
	int     A_POWER_IDX;     /*Codebook index for the absolute power quantization for FPPP*/
	int     A_AMP_IDX[3];    /*Codebook index for the absolute amplitude quantization for FPPP*/
	unsigned int F_ALIGN_IDX[17];  /*Codebook index for the alignment shifts for FPPP*/
	long    encode_fcnt;		/* Frame counter */
	float   HPspeech[GUARD+FrameSize+LOOKAHEAD_LEN]; /* changed by J. Huang on 12/09/98, then changed on 01/19/00 */
	float   ConstHPspeech[GUARD];	/* temporary buffer to store HPspech  */
	float   OldlspE[ORDER];		/* Last frame quantized lsp                */
	float   OldOldlspE[ORDER];      /* Last Last frame quantized lsp           */
	float   ppvq_mid[ACBGainSize - 1];	/* Intermidiate values in ppvq */
	float   lsp_nq[ORDER];	 /* Correlation coefficients                */
	float   Oldlsp_nq[ORDER];/* Last frame quantized lsp                */
	float   lspi_nq[ORDER];	 /* Interpolation of correlation coeff      */
	float   pci_nq[ORDER];	 /* Interpolated prediction coefficients    */
	float   wpci[ORDER];	 /* Interpolated weighted prediction coefficients */

	float   Excitation[ACBMemSize + SubFrameSize + EXTRA];
	float   H[Hlength+1];		/* Impulse response [Hlength]              */
	float   HtH[Hlength+1];		/* Impulse response ^2 [Hlength]           */
	float   SynMemoryM[ORDER];	/* weighted speech synthesis filter memory */
	
	float   TARGET[SubFrameSize+1];	/* Residual - Zero input response       */
	float	TARGETw[SubFrameSize+1];	/* weighted target */

	float   WFmemFIR[ORDER];   /* Weighting filter memory                 */
	float   WFmemIIR[ORDER];   /* Weighting filter memory                 */

	float   zir[SubFrameSize]; /* Zero Input Response (can share memory w/ HtH)*/

	float   residual[GUARD + FrameSize + LOOKAHEAD_LEN];
	float   residualm[SubFrameSize + EXTRA];

	float   mspeech[FSIZE];
	float   wspeech[FSIZE];
	float   residualm_frame[FrameSize+EXTRA];

	float   origm[SubFrameSize];
	float  *worigm;		/* shared weighted original memory */
	float   accshift;
	float   delay1;
	float   pdelay;
	float   beta, beta1;
	short   dpm;

	float   LPCgain;		/* used for frame erasures */
	short   shiftSTATE;
	short   lastrateE;		/* last bitrate used for encoder*/

	int     LAST_PACKET_RATE_E;
	int     LAST_MODE_BIT_E;

	float   fcbGain;                /* ACELP fixed codebook gain */
	float   y2[55];                 /* Filtered innovative vector (debug only) */

	float   lastLgainE;             /*Previous gain value for the low band*/
	float   lastHgainE;             /*Previous gain value for the high band*/
	float   lasterbE[NUM_ERB];           /*Previous Amplitude spectrum (ERB)*/

	float cbprev_E[ORDER];
	float cbprevprev_E[ORDER];
	long    decode_fcnt;		/* Frame counter */

	float   OldlspD[ORDER];		/* Last frame quantized lsp                */
	float   OldOldlspD[ORDER];	/* Last last frame quantized lsp           */

	float   PitchMemoryD[ACBMemSize + SubFrameSize * 2 + EXTRA];
	float   PitchPreFiltMemoryD[ACBMemSize + SubFrameSize + EXTRA];
	float   PitchMemoryD2[ACBMemSize], PitchMemoryD3[ACBMemSize];

	//Sizes increased to support Warping
	float   DECspeech[SubFrameSize*2];/* Output decoder speech           */
	float   DECspeechPF[SubFrameSize*2];/* Output decoder speech with post filter */
	//End: Sizes increased to support Warping

	float   SynMemory[ORDER];	/* Synthesis filter's memory             */

	short   lastrateD;
	float   pdelayD;
	float   pdelayD2, pdelayD3;
	short   pdeltaD;
	short   fer_counter;
	short   erasureFlag;
	short   errorFlag;
	int     LAST_PACKET_RATE_D;
	int     LAST_MODE_BIT_D;

	short   prev_frame_error;
	short   prev_prev_frame_error;
	float   FadeScale;
	float   ave_acb_gain;
	float   ave_fcb_gain;
	float   ave_acb_gain_back;
	
	short	last_valid_rate;        /* last valid decoder rate of operation */

	float   lastLgainD;             /*Previous gain value for the low band*/
	float   lastHgainD;             /*Previous gain value for the high band*/
	float   lasterbD[NUM_ERB];           /*Previous Amplitude spectrum (ERB)*/

	float   cbprev_D[ORDER];
	/* Memory needed for the moving average LPC Quantization */
	float   cbprevprev_D[ORDER];
	int		go_back_input;

	struct PACKET data_packet;

	float prevpD[ACBMemSize];
	char PPP_MODE_D;
	int rcelp_half_rateD;
	int prev_rcelp_half;

	char LAST_PPP_MODE_D;
	int PPP_BUMPUP;
	int pppcountE;
	char PPP_MODE_E;
  	char LASTLAST_PPP_MODE_E, LAST_PPP_MODE_E;
  	float prev_cw_en;
	float cbprevprev_E2[LPCORDER],cbprev_E2[LPCORDER];
	DTFS currp_nq, prev_cw_E, prev_cw_D ;
	float scr, ph_offset_E , ph_offset_D ;
	float SANITYCHECK[FSIZE];

	int rcelp_half_rateE, prev_dim_and_burstE,dim_and_burstE;

	float SynMemoryM2[ORDER];
	float WFmemFIR2[ORDER];
	float WFmemIIR2[ORDER];
	float Excitation2[ACBMemSize];
	float residualm2[EXTRA];
	short shiftSTATE2, dpm2;
	float accshift2;
	float bufferm2[ACBMemSize];
	float delay2;

	float prev_en[ACBMemSize];

	float NS_SNR;

	float bufferm[ACBMemSize+SubFrameSize+EXTRA];
	short acbevrcFirstTime;

	long  celpErasureSeed;
        long  celpSPL_HCELPSeed;
	int cod3_10_offset[3];

  	float  last_delay, last_beta;

  	/* primary copy of filter memory */
  	float memA[ORDER], memA1[ORDER], memA2[ORDER];
  	/* secondary copy of filter memory for half rate processing */
  	float memB[ORDER], memB1[ORDER], memB2[ORDER];	
	int zeroInputFirstTime;	/* init flag - sim only */

  	short autocorrelationFirstTime;
	float w[ORDER + 1 + 6];   /*...add 6 for rate determination...*/
	float HammingWindow[LPC_ANALYSIS_WINDOW_LENGTH];	/* Window coefficients */

	HPFMem hpfmem;
	int get_nacf_at_pitch_FirstTime;
	float lpfr[LPFRMEM_LEN+(FSIZE+LOOKAHEAD_LEN)/SUBSAMP];
  	float rlpf_filt_mem[RLPF_ORDER];
	double rhpf_filt_mem[RHPF_ORDER];

	short nelp_enc_seed;
	short nelp_dec_seed;
	short nelp_erasure_seed;

	//can avoid some redundancy by making a separate enc and dec struct
	double bp1_filt_mem[12];
	double shape1_filt_mem[10];
	double shape2_filt_mem[10];
	double shape3_filt_mem[10];
	double txlpf1_filt1_mem[10];
	double txlpf1_filt2_mem[10];
	double txhpf1_filt1_mem[10];
	double txhpf1_filt2_mem[10];

	double bp1_filt_mem_dec[12];
	double shape1_filt_mem_dec[10];
	double shape2_filt_mem_dec[10];
	double shape3_filt_mem_dec[10];

	double bp1_filt_mem_erasure_dec[12];
	double shape1_filt_mem_erasure_dec[10];
	double shape2_filt_mem_erasure_dec[10];
	double shape3_filt_mem_erasure_dec[10];
	/* some vars for average rate control */
	short int pattern_m;
	long ave_rate_kbps;
	short patterncount;
	long ave_rate;
	short numactive;
	float AV_TH;
	long int NUMFRAMES[4];//zero,quarter,half,full

 	//some diagnostic globals
	float global_lsp[ORDER];
	float copy[FrameSize];
	float sanity_check;
		
	float Eprev;
	float Eavg;
	float LOWVOICEDTH; //0.6
	float VOICEDTH; //0.75 
	float UNVOICEDTH;
	float SNRTH;
  
	int mode_decision_FirstTime;

	double lpf_filt_mem[12];
	double hpf_filt_mem[12];
	int FirstHVframe;

	int vcount;
	float vE[3], vEav;
	float vEprev;
  	int prev_voiced, prev_mode;

	float prev_snr_diff;
	float prev_snr[2], prev_ns_snr[2];
  	float curr_snr[2];
#if NEW_NOISE_SUPPRESSION
	whatever
	int	nsvad_first ;
	float	pre_emp_mem , de_emp_mem ;
	float	ch_enrg [NUM_CHAN];
	float	ch_noise [NUM_CHAN];
	float	overlap [FFT_LEN1-FRM_LEN1];	/* initialized to 0.0 automatically */
	float	ch_gain [FFT_LEN1/2];
	int	update_cnt ; 
	float	window [DELAY1+FRM_LEN1];
	float	window_overlap [DELAY1];
	int	hyster_cnt;		/* forced update statics... */
	int	fupdate_flag;
	int	last_update_cnt;
	float	ch_enrg_long_db [NUM_CHAN];
	unsigned long frame_cnt;
	float	tsnr;			/* total signal-to-noise ratio */
	float	peak_sp_dB_filt, tne_dB_filt;
	float	min_gain_filt;
	float	negSNRvar, negSNRbias;
	int	hangover, burstcount;
#else //NEW_NOISE_SUPPRESSION
	int	noise_suprs_first;
  
	float	pre_emp_mem , de_emp_mem ;
  
	float	ch_enrg[NUM_CHAN];
  
	float	ch_noise[NUM_CHAN];
  
	float	overlap[FFT_LEN-FRM_LEN]; /* initialized to 0 automatically */
  
	float	ch_gain[FFT_LEN/2];
  
	int	update_cnt ; 
  
	float	window[DELAY+FRM_LEN];
	float	window_overlap[DELAY];
  
	int	hyster_cnt;		/* forced update statics... */
	int	last_update_cnt;
	float	ch_enrg_long_db[NUM_CHAN];
	short   evrc_rate;
  
	unsigned long frame_cnt;
#endif //NEW_NOISE_SUPPRESSION

  	float DECbuf[FrameSize / 4];
  	short lastgoodpitch;
  	float lastbeta;
  	float olp_memory[3]; //for olpitch
  	int fndppf_FirstTime;
	float PF_mem_syn_pst[ORDER];
	float FIRmem[ORDER];
	float mem_pre;
	float past_gain; 
	float Residual[ACBMemSize + SubFrameSize*2];
	float GetResidualFIRmem[ORDER];


	short modifyorig_FirstTime;
	float modifyorig_a1[RRESOLUTION];
	float modifyorig_a2[RRESOLUTION];
	float modifyorig_a3[RRESOLUTION];
	float Table[8 * (2 * 16 + 1)];	/* Largest practical size */
	float Table1[8 * (2 * 16 + 1)];	/* Largest practical size */
	float factor1;
	float factor2;
	short  update_backgroud_first;
	short  select_rate_first;
	float (*THRESH_SNR)[TLEVELS][2];
	int *hangover;
  	ENCODER_MEM  rate_mem;
	ENCODER_MEM *e_mem;

    	short post_filter_first_time;
  	long silence_erasure_seed;
  	int iset;
  	float gset;
  	long GetExc800bps_Seed;
  	float GetExc800bps_Sum[NoOfSubFrames];
	float maxSFEnergyQLast;
  	long GetExc800bps_dec_Seed;
  	float GetExc800bps_dec_Sum[NoOfSubFrames];
  	short PrevBest;
	float maxSFEnergyQLast_dec;

  	float nacf_ap[5];
  	float prev_nacf;

  	float curr_ns_snr[2], next_ns_snr[2][2];

	bool lpcgflag;
	short noSID;
	SBEncoder SB_enc;
	SBDecoder SB_dec;
	short SILFrame;

#if MOT_SUPPRESSED_EIGHTH_RATE
	float E_bgn[BBG_NUM_CHAN+2];
	float E_bgn_smooth[BBG_NUM_CHAN+2];
	float E_ch_mem[BBG_NUM_CHAN+2];
	float bbg_window_overlap[BBG_DELAY];
	unsigned long BBG_frmSkipCnt;
	unsigned long BBG_frmSkipCnt2;
	float resmem[ORDER];
	unsigned long consec_eighth_rates;
#endif

	short SPL_HCELP;
	short SPL_HNELP;
	short SPL_HPPP;
	short N_consec_ers;
	short ones_dec_cnt;
	short zrbit[2];
	short BAD_RATE;


	void Init_Post_Filter(void);
	void preemphasis(
	    float * signal, /* (i/o) : input signal overwritten by the output */
	    float g,        /* (i)   : preemphasis coefficient                */
	    int16 L         /* (i)   : size of filtering                      */
	);
	void Post_Filter(
	    float * syn,    /* in/out: synthesis speech (postfiltered is output)    */
	    float * Lsp,
	    float * Az,     /* input : interpolated LPC parameters in all subframes */
	    float * synpf,
	    float delayi,
	    float agc_fac,
	    float mu,
	    int16 l_subfr
	);
	void agc(
	    float * sig_in,    /* (i)     : postfilter input signal  */
	    float * sig_out,   /* (i)     : postfilter output signal */
	    float * res_out,
	    float agc_fac,     /* (i)     : AGC factor               */
	    int16 l_trm        /* (i)     : subframe size            */
	);
	void ltf (float * res,
		  float delayi,
		  float ltgain,
		  short len
	);

  	//MODE new_mode_decision(float*);
	//void update_average_rate(int rate); //valid rates are 1,2,3,4
	void get_nacf_at_pitch(float *resid, int pitch1, int pitch, float *nacf);
	void ZeroInput(float *output, float *coef_uq, float *coef, float *in, float gamma1, float gamma2, short order, short length, short type);
	void autocorrelation(float *r,float *input,short len,short order);
	void lpcanalys(float *pc, float *rc, float *input, short order, short len,float*);
	void   InitEncoder();
	void   InitDecoder();
	void pre_encode (float*  inFbuf,float*  Rs);
	void  encode (short& rate,short* codeBuf);
	void  decode (short*  codeBuf,short  rate,short  post_filter,float*  outFbuf, short run_length, short phase_offset, float time_warp_fraction, short *obuf_len);
	void ComputeACB(float *residualm, float *excitation, float *delay, float *residual, short guard, short *dpm, float *accshift, float beta, short length, short rshift);
	void get_rcelp();
			  
	void celp_encoder(int bit_rate);
	short celp_decoder(float *outFbuf,short post_filter,int bit_rate, short run_length, short phase_offset, float time_warp_fraction, short* obuf_len);
	void celp_erasure_decoder(float *outFbuf,short post_filter);
	void 	cod3_10jcelp(float xn[], float h[], int pit_lag, float pit_gain, int l_subfr, float cod[], float *gain_code, int *indices);
	void 	dec3_10jcelp(int pit_lag, float pit_gain, int l_subfr, int *indices, float cod[]);
	//void nelp_encoder(float *out);
	void nelp_decoder(float *outFbuf,short post_filter, float	time_warp_fraction, short*	obuf_len);
	void nelp_erasure_decoder(float *outFbuf,short post_filter);
	//void silence_encoder();
	void silence_decoder(float *outFbuf,short post_filter);
	void silence_erasure_decoder(float *outFbuf,short post_filter);
	void GetExc800bps(float *output, short *best, float scale, float *input, short length, short flag, short n);
	void GetExc800bps_dec(float *output, short length, short best, short flag, short n);
#if 0
	short get_rcelpmres_for_voiced(float *mres,float *targ_speech,float *acc3);
#endif
	//void voiced_encoder(float *out, int& rate);
	void ppp_full_encoder(DTFS *CWout, DTFS CWin, const float *curr_lsp);
	bool ppp_quarter_encoder(DTFS *, DTFS, DTFS, const float *,DTFS *);
	short voiced_decoder(float *outFbuf,short post_filter, short run_length, short phase_offset, float	time_warp_fraction, short*	obuf_len);
	void ppp_full_decoder(DTFS *CWout, const float *curr_lsp);
	void ppp_quarter_decoder(DTFS *, DTFS, const float *);
	void voiced_erasure_decoder(float *outFbuf,short post_filter);
	void fer_processing(float *out,short pf,short prev_rate);
				  
	void jumptofullcelp(int& rate);
#if NEW_NOISE_SUPPRESSION
	int nsvad (float *farray_ptr, nsState *st);
#else //NEW_NOISE_SUPPRESSION
	void noise_suprs(float* farray_ptr, float *ns_snr);
#endif //NEW_NOISE_SUPPRESSION
	void fndppf(float *delay,float *beta,float *buf,short dmin,short dmax, short length);
	    

	void bl_intrp(float *output, float *input, float delay, float factor, short fl);
	void mod(float *residualm, float *accshift, float beta, short shiftr, short resolution, float *exctation, float *Dresidual, float *residual, short guard, short *dpm, float delay, short subframel, short extra);
	void putacbc(float *exctation, float *input, short dpl, short subframel, short extra, float *delay3, float freq, short prec);
	void acb_excitation(float *Ex1, float gain, float *delay3, float *PitchMemory, short length);
	void modifyorig(float *residualm,float *accshift,float beta,short *dpm, short shiftrange,short resolution,float *TARGET, float *residual,short dp,short sfend);
	
		
	void  update_background (
		short         rate,
		ENCODER_MEM  *e_mem,
		float         beta
	);

	short bad_rate_check(short opt,short* cbuf);
                                   
	float ran_g(long *seed0);
void lsp_spread(float *lsp);

#if MOT_SUPPRESSED_EIGHTH_RATE
	void init_bbg();
	void update_bbg_estimate(float *buf16, int rate, float walpha);
	void gen_encode_bbg(short *buf16);
//private:
	void update_bgestimate(float *buf16, int rate, float walpha);
	void gen_bg_fromestimate(float *bufF);
	void bbg_eighth_rate_encode(float inBufF[SPEECH_BUFFER_LEN], short *outBuf16);

#endif

};

#endif
