/**********************************************************************
Each of the companies; Motorola, and Lucent, and Qualcomm, and Nokia (hereinafter 
referred to individually as "Source" or collectively as "Sources") do 
hereby state:

To the extent to which the Source(s) may legally and freely do so, the 
Source(s), upon submission of a Contribution, grant(s) a free, 
irrevocable, non-exclusive, license to the Third Generation Partnership 
Project 2 (3GPP2) and its Organizational Partners: ARIB, CCSA, TIA, TTA, 
and TTC, under the Source's copyright or copyright license rights in the 
Contribution, to, in whole or in part, copy, make derivative works, 
perform, display and distribute the Contribution and derivative works 
thereof consistent with 3GPP2's and each Organizational Partner's 
policies and procedures, with the right to (i) sublicense the foregoing 
rights consistent with 3GPP2's and each Organizational Partner's  policies 
and procedures and (ii) copyright and sell, if applicable) in 3GPP2's name 
or each Organizational Partner's name any 3GPP2 or transposed Publication 
even though this Publication may contain the Contribution or a derivative 
work thereof.  The Contribution shall disclose any known limitations on 
the Source's rights to license as herein provided.

When a Contribution is submitted by the Source(s) to assist the 
formulating groups of 3GPP2 or any of its Organizational Partners, it 
is proposed to the Committee as a basis for discussion and is not to 
be construed as a binding proposal on the Source(s).  The Source(s) 
specifically reserve(s) the right to amend or modify the material 
contained in the Contribution. Nothing contained in the Contribution 
shall, except as herein expressly provided, be construed as conferring 
by implication, estoppel or otherwise, any license or right under (i) 
any existing or later issuing patent, whether or not the use of 
information in the document necessarily employs an invention of any 
existing or later issued patent, (ii) any copyright, (iii) any 
trademark, or (iv) any other intellectual property right.

With respect to the Software necessary for the practice of any or 
all Normative portions of the EVRC-B Variable Rate Speech Codec as 
it exists on the date of submittal of this form, should the EVRC-B be 
approved as a Specification or Report by 3GPP2, or as a transposed 
Standard by any of the 3GPP2's Organizational Partners, the Source(s) 
state(s) that a worldwide license to reproduce, use and distribute the 
Software, the license rights to which are held by the Source(s), will 
be made available to applicants under terms and conditions that are 
reasonable and non-discriminatory, which may include monetary compensation, 
and only to the extent necessary for the practice of any or all of the 
Normative portions of the EVRC-B or the field of use of practice of the 
EVRC-B Specification, Report, or Standard.  The statement contained above 
is irrevocable and shall be binding upon the Source(s).  In the event 
the rights of the Source(s) in and to copyright or copyright license 
rights subject to such commitment are assigned or transferred, the 
Source(s) shall notify the assignee or transferee of the existence of 
such commitments.
*******************************************************************/
/*****************************************************************
 *   (C) COPYRIGHT 1999,2000 Motorola, Inc.
 *    MOTOROLA CONFIDENTIAL PROPRIETARY
 *****************************************************************/
#ifndef _UPGRADES_H
#define _UPGRADES_H

#include "defines.h"

/* upgrades.h - Header for FOURGV enhancements (based on EVRC) */

#ifdef TRUE
#undef TRUE
#endif
#define	TRUE		1
#ifdef FALSE
#undef FALSE
#endif
#define	FALSE		0
#define	YES		1
#define	NO		0
#define	ENABLED		1
#define	DISABLED	0

#define EIGHTY_HZ_HPF                   YES     /* replace 120 Hz bqiir with 4th order 80 Hz Cheby II */
#define NEW_NOISE_SUPPRESSION           NO     /* Use Motorola candidate AMR Noise Suppression */
#define NS_VAD                          NO     /* Use Noise Suppression based Voice activity detection */
#define MOT_VUV_DECISION                NO
#define EXTENDED_LPC_ANALYSIS_WINDOW	YES	/* Extended LPC analysis (320 samples) with center at 240 */
#define NEW_FNDPPF	                YES
#define FRACTIONAL_DELAY_ESTIMATE	NO
#define NORMALIZED_DELTA_LSP_VQ         YES
#define NDVQ_TRAINING                   NO     /* Abort after mode decision & output appropriate LSPs */
#define	ACCSHIFT_DELAY_ADJ		NO
#define	FP_7_35	                        YES     /* Factorial Packing 7 pulses over 54 positions using 35 bits */
#define NEW_FP_7_35_SEARCH              YES     /* Use more efficient search for above */
#define VARIABLE_CONFIG_ACELP		YES	/* make ACELP FCB pulse configuration dependent of the pitch delay */
#define VCM_JCELP_3D			YES	/* Combine 3D JCELP with VCM */
#define VCM_JCELP_3_11		        NO	/* use 11 bit codebook instead of 10 bit */

#define DECAY_OFF_ACB_GAIN              NO     /* Mult ACB gain by a constant to reduce memory effect for FERs */
#define TWEAK_FCB_GAIN_CONSTRAINT	NO      /* Remove FCB gain constraint */

#define NEW_EIGHTH_RATE_ENERGY          YES     /* New rate 1/8 energy quantizer (6 bit frame energy) */
#define EIGHTH_RATE_ZEROS               YES     /* Code lowest quantization level @ zero energy (i.e., 10^(-2)) */
#define FIXED_EIGHTH_RATE_ATTEN         YES      /* Disables lpc prediction based attenuation */
#define FIXED_EIGHTH_RATE_ATTEN_AMT     3.0      /* Specifies ER attenuation level in dB */

#ifdef QCDTX
#define MOT_SUPPRESSED_EIGHTH_RATE	NO
#else //QCDTX
#define MOT_SUPPRESSED_EIGHTH_RATE	YES
#endif //QCDTX


/***************************** MOTOROLA OBJECTIVE MEASURE ENHANCEMENTS *********************************************/

#define CALC_SPECTRAL_DISTORTION_MEASURE	NO
#define SD_MODE				         4             // 4 FR CELP, 3 HR CELP, 2 QR UV, 1 ER
double sd (float *lpc, float *lpcq, int rate);
void sd_print (void);

#define CALC_ITAKURA_SAITO_GAIN                 NO
double dLpResidualEnergy (float *pfR, float *pfAc, int iOrder);

#define CALC_EXCITATION_SNR			NO		/* Do weighted SNR on encoder synthesis output */
void wsnr (float *signal, float *synth, int i, int subframesize);
void print_wsnr (void);

#define CALC_ACCSHIFT_METRICS                   NO


/**************************************************************************************************************/

#if         NEW_EIGHTH_RATE_ENERGY
#define     NUM_Q_LEVELS    64
#define     NUM_EQ_BITS     6
#endif

#if MOT_SUPPRESSED_EIGHTH_RATE
#define BBG_NUM_CHAN 16
#define BBG_DELAY 24
#endif

int amr_ns (
    float *new_speech,         /* (i): speech input (L_FRAME)         */
    float beta                  /* (i): open loop pitch gain           */
);

#include "nsvad.h"
int nsvad (
    float *new_speech,         /* (i): speech input (L_FRAME)         */
    nsState *st
);

#define LPC_ANALYSIS_WINDOW_LENGTH      320

void	frac_delay_enc(float *delay, float *beta, float *input);
void	init_quantizer_table();
int	frac_delay_q(float *delay);
float	frac_delay_dec(int index);

/* ND LSP VQ */

#define	PRESELECT_LSP		  YES	/* Use multi-candidates to search delta segments */
#define GEOMETRIC_MEAN_LSP_WEIGHT YES	/* Use geometric mean weighting instead */

#if     NDVQ_TRAINING
#define FIRST_PASS                YES   /* NO for 2nd pass */
#define OUTPUT_LSP28		  NO   /* Output LSP's for FR codebook training */
#define OUTPUT_LSP22		  NO    /* Output LSP's for HR codebook training */
#define OUTPUT_LSP16		  NO    /* Output LSP's for QR codebook training */
#define OUTPUT_LSP8		  NO    /* Output LSP's for ER codebook training */
#endif

int	quant_lsp (	        /* return index for quantized lsp */
	float	lsp_nq[],	/* input unquantized lsp segment */
	float	ref_l,		/* lower end reference */
	float	ref_u,		/* upper end reference */
	float	codebook[],	/* lsp quantization table */
	int	codebook_size,	/* # of entries in codebook */
	int	vec_dimension,	/* size of lsp segment */
	float	w[],		/* weight */
	float	lsp_q[]);	/* output quantized lsp segment */
void	dequant_lsp (
	int	index,
	float	ref_l,
	float	ref_u,
	float	codebook[],
	int	vec_dimension,
	float	lsp[]);
void	enc_lsp_vq_28 (float lsp_nq[], short codes[], float lsp[]);
void    dec_lsp_vq_28 (short codes[], float lsp[]);
void	enc_lsp_vq_22 (float lsp_nq[], short codes[], float lsp[]);
void    dec_lsp_vq_22 (short codes[], float lsp[]);
void	enc_lsp_vq_16 (float lsp_nq[], short codes[], float lsp[]);
void    dec_lsp_vq_16 (short codes[], float lsp[]);
void	enc_lsp_vq_8 (float lsp_nq[], short codes[], float lsp[]);
void    dec_lsp_vq_8 (short codes[], float lsp[]);
void    output_lsp28 (float lsp_nq[]);
void    output_lsp22 (float lsp_nq[]);
void    output_lsp16 (float lsp_nq[]);
void    output_lsp8 (float lsp_nq[]);
/* End ND LSP VQ */


/* Configure AccShift delay shift adjustment */

#define	ACCSHIFT_PHASE			YES		/* Do linear phase shift adjustment instead of endpoint adjustment */
#define	SIMPLIFIED_BIAS			NO		/* Make bias (shifter) a function of the slope only */
  #define	DELAY_2BIT_SHIFT	YES
  #define	DELAY_3BIT_SHIFT	NO

  #if	REDUCED_LOOKAHEAD
    #if  DELAY_2BIT_SHIFT
      #define	DELAY_INC		(2.0 / 8.0)
    #endif
    #if  DELAY_3BIT_SHIFT
      #define	DELAY_INC		(1.5 / 8.0)
    #endif
  #else	 /* !REDUCED_LOOKAHEAD */
    #define	DELAY_INC		(1.5 / 8.0)
  #endif /* REDUCED_LOOKAHEAD */

  #if	DELAY_2BIT_SHIFT
    #define	DELAY_SHIFT_BIT		2
    #define	DELAY_SHIFT_LEVEL	4
  #endif

  #if	DELAY_3BIT_SHIFT
    #define	DELAY_SHIFT_BIT		3
    #define	DELAY_SHIFT_LEVEL	8
  #endif

  #define	DELAY_FRAC0_0		(53.0 / 160.0)
  #define	DELAY_FRAC0_1		(106.0 / 160.0)
  #define	DELAY_FRAC1_1		(53.0 / (160.0 - 53.0))

  #define	DELAY_CENTROID		160.0
  #define	DELAY_FRAC0_pr		(45.0 / DELAY_CENTROID)
  #define	DELAY_FRAC0_0r		(93.0 / DELAY_CENTROID)
  #define	DELAY_FRAC0_1r		(146.0 / DELAY_CENTROID)
  #define	DELAY_FRAC1_1r		(160.0 / DELAY_CENTROID)

  #define	DELAY_CENTROIDe		120.0
  #define	DELAY_FRAC0_pe		(5.0 / DELAY_CENTROID)
  #define	DELAY_FRAC0_0e		(58.0 / DELAY_CENTROID)
  #define	DELAY_FRAC0_1e		(106.0 / DELAY_CENTROID)
  #define	DELAY_FRAC1_1e		(120.0 / DELAY_CENTROID)

int	ComputeAcb(
	float	residualm[], 
	float	excitation[], 
	float	delay3[],
	float	residual[], 
	short	guard, 
	short*	dpm,
	float*	accshift, 
	float	beta, 
	short	length, 
	short	rshift,
	float	delay_adj[],
	int	shifter,
	int	sfrm_indx);     

int	Interp_delay_adj(
	float	out[], 
	float	last, 
	float	current, 
	float	delay_adj[],
	short	sfrm_indx);

void	Interp_delay_adj_dec(
	float	out[], 
	float	last, 
	float	current, 
	int	indx,
	short	sfrm_indx);

/* End of AccShift delay shift adjustment configuration */

/* New F_P_7_35 search */
void cod7_35(
	float *xw,	/* (input)  Target signal. */
   	float *x,	/* (input)  Target signal (through inverse weighting filter). */
   	int l_subfr,	/* (input)  Length of current subframe. */
   	float *h,	/* (input)  Weighted filter impulse response. */
   	float *ck,	/* (output) Multipulse excitation. */
   	float y[],      /* (output) Filtered fixed codebook excitation. */
   	float *gain,    /* (output) Excitation gain parameter. */
   	int *indx);	/* (output) Factorial Packed codeword. */


/* Half rate Variable configuration ACELP codebook */

#define VCM_L0    			55
#define VCM_L    			54
#define VCM_UDU_OVERSTEP		3
#define VCM_UuU_OVERSTEP		2	/* glottal side pulse */
#define VCM_UDU_PIT			66	/* roughly (1 + 1/4) * subframesize */
#define VCM_UD_PIT			95	/* roughly (1 + 3/4) * subframesize */
#define VCM_FAC			0.9 / (120 - VCM_UD_PIT)
#define PIT_THRSH			0.3

  int	VCM_Config(int lag, float gain, int l_subfr, int offset[], int *step, int *max, float *sign, float *ratio);
  void	build_rr(float h[], float rr[][VCM_L0], int l_subfr);
  void 	cod3_10vcm(float xn[], float h[], int pit_lag, float pit_gain, int l_subfr, float cod[], float *gain_code, int *indices);
  void 	dec3_10vcm(int pit_lag, float pit_gain, int l_subfr, int *indices, float cod[]);

  //void 	cod3_10jcelp(float xn[], float h[], int pit_lag, float pit_gain, int l_subfr, float cod[], float *gain_code, int *indices);
  //void 	dec3_10jcelp(int pit_lag, float pit_gain, int l_subfr, int *indices, float cod[]);
  void 	cod3_11jcelp(float xn[], float h[], int pit_lag, float pit_gain, int l_subfr, float cod[], float *gain_code, int *indices);
  void 	dec3_11jcelp(int pit_lag, float pit_gain, int l_subfr, int *indices, float cod[]);
  int	JCELP_Config(
	int	lag,		/* input */
	float	gain,
	int	l_subfr,
	int	pos[512][3],	/* output */
	int	offset[],	
	int	*step,
	int	*max,
	float	*sign,
	float	*ratio
  );
  int	JCELP_Config3_11(
	int	lag,		/* input */
	float	gain,
	int	l_subfr,
	int	pos[512][3],	/* output */
	int	offset[],	
	int	*step,
	int	*max,
	float	*sign,
	float	*ratio
  );

/* END Half rate Variable configuration ACELP codebook */

#endif

