/**********************************************************************
Each of the companies; Motorola, and Lucent, and Qualcomm, and Nokia (hereinafter 
referred to individually as "Source" or collectively as "Sources") do 
hereby state:

To the extent to which the Source(s) may legally and freely do so, the 
Source(s), upon submission of a Contribution, grant(s) a free, 
irrevocable, non-exclusive, license to the Third Generation Partnership 
Project 2 (3GPP2) and its Organizational Partners: ARIB, CCSA, TIA, TTA, 
and TTC, under the Source's copyright or copyright license rights in the 
Contribution, to, in whole or in part, copy, make derivative works, 
perform, display and distribute the Contribution and derivative works 
thereof consistent with 3GPP2's and each Organizational Partner's 
policies and procedures, with the right to (i) sublicense the foregoing 
rights consistent with 3GPP2's and each Organizational Partner's  policies 
and procedures and (ii) copyright and sell, if applicable) in 3GPP2's name 
or each Organizational Partner's name any 3GPP2 or transposed Publication 
even though this Publication may contain the Contribution or a derivative 
work thereof.  The Contribution shall disclose any known limitations on 
the Source's rights to license as herein provided.

When a Contribution is submitted by the Source(s) to assist the 
formulating groups of 3GPP2 or any of its Organizational Partners, it 
is proposed to the Committee as a basis for discussion and is not to 
be construed as a binding proposal on the Source(s).  The Source(s) 
specifically reserve(s) the right to amend or modify the material 
contained in the Contribution. Nothing contained in the Contribution 
shall, except as herein expressly provided, be construed as conferring 
by implication, estoppel or otherwise, any license or right under (i) 
any existing or later issuing patent, whether or not the use of 
information in the document necessarily employs an invention of any 
existing or later issued patent, (ii) any copyright, (iii) any 
trademark, or (iv) any other intellectual property right.

With respect to the Software necessary for the practice of any or 
all Normative portions of the EVRC-B Variable Rate Speech Codec as 
it exists on the date of submittal of this form, should the EVRC-B be 
approved as a Specification or Report by 3GPP2, or as a transposed 
Standard by any of the 3GPP2's Organizational Partners, the Source(s) 
state(s) that a worldwide license to reproduce, use and distribute the 
Software, the license rights to which are held by the Source(s), will 
be made available to applicants under terms and conditions that are 
reasonable and non-discriminatory, which may include monetary compensation, 
and only to the extent necessary for the practice of any or all of the 
Normative portions of the EVRC-B or the field of use of practice of the 
EVRC-B Specification, Report, or Standard.  The statement contained above 
is irrevocable and shall be binding upon the Source(s).  In the event 
the rights of the Source(s) in and to copyright or copyright license 
rights subject to such commitment are assigned or transferred, the 
Source(s) shall notify the assignee or transferee of the existence of 
such commitments.
*******************************************************************/
static char const rcsid[]="$Id: //E-XMS/GIT/csa/Utilities/cpp/RtpCodecUtil/evrc_b/uvgq.cpp#1 $";

/*======================================================================*/
/*  4GV - Fourth Generation Vocoder Speech Service Option for             */
/*  Wideband Spread Spectrum Digital System                             */
/*  C Source Code Simulation                                            */
/*                                                                      */
/*  Copyright (C) 1999 Qualcomm Incorporated. All rights                */
/*  reserved.                                                           */
/*----------------------------------------------------------------------*/

#include <math.h>
#include "uvgq.h"

#define SQR(a) ((a)*(a))

float dequantize_uvg(int iG1, int *iG2, float *G)
{
  int i, k;
  
  for (i=0;i<2;i++) {
    for (k=0;k<5;k++)
      G[i*5+k]=pow(10.0,UVG1CB[iG1][i])*UVG2CB[i][iG2[i]][k];
  }
  return(0.0);
}

float quantize_uvg(float *G, int& iG1, int *iG2, float *quantG)
{

  float G1[2], G2[10];
  int i, j, k;

  float mse, mmse, snr;

  // The G's are all ensured to be non-zero since I changed nelp.cc
  // So, I don't need to keep a minimum value for G1 or G2
  // Without this, with NS (even on clean speech) gives a seg. fault due to
  // infinities and iG1 is also some unknown value. Also initialized iG1=0
  // to be safe, iG2[] was already initialized - Sharath
  
  for (i=0;i<2;i++) {
    G1[i]=0;
    for (j=0;j<5;j++)
      G1[i]+=SQR(G[i*5+j]);
    G1[i]=log10(sqrt(G1[i]/5));
  }
  
  mmse=1e30;
  iG1=0;
  for (i=0;i< UVG1_CBSIZE; i++) {
    mse=SQR(G1[0]-UVG1CB[i][0])+SQR(G1[1]-UVG1CB[i][1]);
    if (mse<mmse) {
      iG1=i;
      mmse=mse;
    }
      
  }

  G1[0]=pow(10.0,UVG1CB[iG1][0]);
  G1[1]=pow(10.0,UVG1CB[iG1][1]);
  
  for (i=0;i<2;i++) {
    for (j=0;j<5;j++)
      G2[i*5+j]=G[i*5+j]/G1[i];
  }

  for (i=0;i<2;i++) {
    mmse=1e30;
    iG2[i]=0;
    for (j=0;j<UVG2_CBSIZE;j++) {
      mse=0;
      for (k=0;k<5;k++)
	mse+=SQR(G2[i*5+k]-UVG2CB[i][j][k]);
      if (mse<mmse) {
	mmse=mse;
	iG2[i]=j;
      }
    }
  }  

  for (i=0;i<10;i++) G2[i]=G[i];
  dequantize_uvg(iG1, iG2, quantG);
  
  mmse=mse=0;
  for (i=0;i<10;i++) {
    mmse+=SQR(quantG[i]-G2[i]);
    mse+=SQR(G2[i]);
  }
  snr=10*log10(mse/mmse);
  
  return snr;
}
