/**********************************************************************
Each of the companies; Motorola, and Lucent, and Qualcomm, and Nokia (hereinafter 
referred to individually as "Source" or collectively as "Sources") do 
hereby state:

To the extent to which the Source(s) may legally and freely do so, the 
Source(s), upon submission of a Contribution, grant(s) a free, 
irrevocable, non-exclusive, license to the Third Generation Partnership 
Project 2 (3GPP2) and its Organizational Partners: ARIB, CCSA, TIA, TTA, 
and TTC, under the Source's copyright or copyright license rights in the 
Contribution, to, in whole or in part, copy, make derivative works, 
perform, display and distribute the Contribution and derivative works 
thereof consistent with 3GPP2's and each Organizational Partner's 
policies and procedures, with the right to (i) sublicense the foregoing 
rights consistent with 3GPP2's and each Organizational Partner's  policies 
and procedures and (ii) copyright and sell, if applicable) in 3GPP2's name 
or each Organizational Partner's name any 3GPP2 or transposed Publication 
even though this Publication may contain the Contribution or a derivative 
work thereof.  The Contribution shall disclose any known limitations on 
the Source's rights to license as herein provided.

When a Contribution is submitted by the Source(s) to assist the 
formulating groups of 3GPP2 or any of its Organizational Partners, it 
is proposed to the Committee as a basis for discussion and is not to 
be construed as a binding proposal on the Source(s).  The Source(s) 
specifically reserve(s) the right to amend or modify the material 
contained in the Contribution. Nothing contained in the Contribution 
shall, except as herein expressly provided, be construed as conferring 
by implication, estoppel or otherwise, any license or right under (i) 
any existing or later issuing patent, whether or not the use of 
information in the document necessarily employs an invention of any 
existing or later issued patent, (ii) any copyright, (iii) any 
trademark, or (iv) any other intellectual property right.

With respect to the Software necessary for the practice of any or 
all Normative portions of the EVRC-B Variable Rate Speech Codec as 
it exists on the date of submittal of this form, should the EVRC-B be 
approved as a Specification or Report by 3GPP2, or as a transposed 
Standard by any of the 3GPP2's Organizational Partners, the Source(s) 
state(s) that a worldwide license to reproduce, use and distribute the 
Software, the license rights to which are held by the Source(s), will 
be made available to applicants under terms and conditions that are 
reasonable and non-discriminatory, which may include monetary compensation, 
and only to the extent necessary for the practice of any or all of the 
Normative portions of the EVRC-B or the field of use of practice of the 
EVRC-B Specification, Report, or Standard.  The statement contained above 
is irrevocable and shall be binding upon the Source(s).  In the event 
the rights of the Source(s) in and to copyright or copyright license 
rights subject to such commitment are assigned or transferred, the 
Source(s) shall notify the assignee or transferee of the existence of 
such commitments.
*******************************************************************/
static char const rcsid[]="$Id: //E-XMS/GIT/csa/Utilities/cpp/RtpCodecUtil/evrc_b/voiced.cpp#1 $";

/*======================================================================*/
/*  4GV - Fourth Generation Vocoder Speech Service Option for             */
/*  Wideband Spread Spectrum Digital System                             */
/*  C Source Code Simulation                                            */
/*                                                                      */
/*  Copyright (C) 1999 Qualcomm Incorporated. All rights                */
/*  reserved.                                                           */
/*----------------------------------------------------------------------*/

#ifdef WIN32
#include <iostream>

#endif
using namespace std;

/* This is the new half rate coding in the EVRC shell */
#include "macro.h"
#include "proto.h"
#include "rom.h"
#include "defines.h"
#include "struct.h"
#include "filt.h"
#include "lu_mod.h"

#define LSP28FP 1

#ifdef WIN32
#define rint(x)  (int)((x) + 0.5)     /*...define non-ANSI function...*/
#endif
// static float LSP_SPREAD_FACTOR=0.0025;
// static float  LSP_SPREAD_FACTOR = 0.05/(2*3.141592653589);
  //static float LSP_SPREAD_FACTOR = 0.008;
#define LSP_SPREAD_FACTOR_QPPP 0.01

  
//extern float prev_en[ACBMemSize];

//extern float NS_SNR;

//extern int prev_dim_and_burstE;

//static float   copy[FrameSize];  

// RCELP and Encoder Contingency Backup for Bumpup stuff
//extern float bufferm[ACBMemSize + SubFrameSize + EXTRA];
//float SynMemoryM2[ORDER];
//float WFmemFIR2[ORDER];
//float WFmemIIR2[ORDER];
//float Excitation2[ACBMemSize];
//float residualm2[EXTRA];
//short shiftSTATE2, dpm2;
//float accshift2;
//float bufferm2[ACBMemSize];
//float delay2;

// MA LSP Backup for Bumpup stuff
//float cbprevprev_E2[LPCORDER],cbprev_E2[LPCORDER];
#ifdef NEWMALSPVQ3
float cbprevprev_E3[LPCORDER],cbprev_E3[LPCORDER];
#endif //NEWMALSPVQ3

// PPP Specific Stuff
//extern char PPP_MODE_E, PPP_MODE_D;
//char LAST_PPP_MODE_D='Q';
//int PPP_BUMPUP;
//int pppcountE;
//DTFS currp_nq, prev_cw_E, prev_cw_D ;
//float scr=0.0, ph_offset_E = 0.0, ph_offset_D = 0.0 ;
//float SANITYCHECK[FSIZE];


void FGV_MEM::lsp_spread(float *lsp)
{
  int i;

  if (lsp[0]<LSP_SPREAD_FACTOR_FX) lsp[0]=LSP_SPREAD_FACTOR_FX;
      for (i=1; i<LPCORDER; i++)
        if (lsp[i]-lsp[i-1]<LSP_SPREAD_FACTOR_FX)
          lsp[i]=lsp[i-1]+LSP_SPREAD_FACTOR_FX;
      if (0.5-lsp[LPCORDER-1]<2*LSP_SPREAD_FACTOR_FX) { 
        lsp[LPCORDER-1]=0.5-2*LSP_SPREAD_FACTOR_FX;
        i=LPCORDER-2;
        while ((lsp[i+1]-lsp[i]<LSP_SPREAD_FACTOR_FX) && (i>=0)) {
	   lsp[i]=MIN(lsp[i+1]-LSP_SPREAD_FACTOR_FX,0);
          i--;
        }
      }  

 
}

#if 0
short FGV_MEM::get_rcelpmres_for_voiced(float *mres,float *targ_speech,float *acc3)
{
  register int i, j;
  float   delayi[3];
  short   subframesize;
  short   Aveidxppg;
  float   sum1;
  short delayindex;
  
  /* Update shiftSTATE with hysteresis */

  // Prepare not to do RCELP for PPP
  /*
  accshift = 0;
  dpm = 0;
  shiftSTATE = 0;
  */
  if (beta < 0.1) {
    accshift = 0;
    dpm = 0;
    shiftSTATE = 0;
  }

  if (accshift > 20) shiftSTATE = -1;
  if (accshift < -20) shiftSTATE = 1;
  if (accshift <= 10 && shiftSTATE == -1) shiftSTATE = 0;
  if (accshift >= -10 && shiftSTATE == 1) shiftSTATE = 0;
  
  /* Control accshift */
  
  if (shiftSTATE == 1 && beta < 0.4) delay += 1.0;
  else if (shiftSTATE == -1 && beta < 0.4) delay -= 1.0;
  if (delay > DMAX) delay = DMAX;
  if (delay < DMIN) delay = DMIN;
  

  delayindex=(short)(delay-DMIN);

  Aveidxppg = 0;
  assert(fabs(delay-pdelay)<=15);

  /***********************************
   * Generate RCELP modified residual*
   **********************************/
  for (i=0; i<NoOfSubFrames; i++) {   
    if (i < 2) subframesize = SubFrameSize - 1;
    else subframesize = SubFrameSize;
    /* interpolate lsp */
    Interpol(lspi, OldlspE, lsp, i, ORDER);
    Interpol(lspi_nq, Oldlsp_nq, lsp_nq, i, ORDER);
    /* Convert lsp to PC */
    lsp2a(pci, lspi);
    lsp2a(pci_nq, lspi_nq);
#if 0
    /* Get zir */
    ZeroInput(zir, pci_nq, pci, Excitation + ACBMemSize, GAMMA_1, GAMMA2, ORDER,
	      subframesize, 0);
    /* Calculate impulse response of 1/A(z) * A(z/g1) / A(z/g2) */
    ImpulseRzp(H, pci_nq, pci, GAMMA_1, GAMMA2, ORDER, Hlength);
#endif
    /* Interpolate delay */
    Interpol_delay(delayi, &pdelay, &delay, i);
    ComputeACB(residualm,Excitation+ACBMemSize,delayi,
	       residual+GUARD+i*(SubFrameSize-1),
	       FrameSize+GUARD-i*(SubFrameSize-1),&dpm,&accshift,beta,
	       subframesize,RSHIFT);
    /*    
     // No RCELP as front end 
     for (j=0;j<subframesize;j++)
     residualm[j+dpm]=residual[GUARD+i*(SubFrameSize-1)+j];
    */
#if 0
    acc3[i]=10*accshift;
#endif
    for (j=0;j<subframesize;j++)
      copy[i*(SubFrameSize-1)+j]=mres[i*(SubFrameSize-1)+j]=residualm[j];
    /* Get weighted speech ORIGM */
    SynthesisFilter(origm, residualm, pci, SynMemoryM, ORDER, subframesize);  
    for (j=0;j<subframesize;j++) targ_speech[i*(SubFrameSize-1)+j]=origm[j];
    /* Weighting filter */
    weight(wpci, pci_nq, GAMMA_1, ORDER);
    fir(Scratch, origm, wpci, WFmemFIR, ORDER, subframesize);
    weight(wpci, pci_nq, GAMMA2, ORDER);
    iir(worigm, Scratch, wpci, WFmemIIR, ORDER, subframesize);
#if 0
    /* Remove Zero input response from weighted speech */
    for (j = 0; j < subframesize; j++) worigm[j] -= zir[j];
    /* Calculate closed loop gain */
    getgain(Excitation+ACBMemSize,&sum1,H,&idxppg,ppvq,ppvq_mid,ACBGainSize, 1,
	    worigm, subframesize, Hlength);
    Aveidxppg += idxppg;
    /* Update filters memory */
    ZeroInput(zir,pci_nq,pci,residualm,GAMMA_1,GAMMA2,ORDER,subframesize,2);
#endif
    /* Update residualm */
    for (j = 0; j < dpm; j++) residualm[j] = residualm[j + subframesize];
#if 0
    /* Update excitation */
    for (j=0;j<ACBMemSize-subframesize;j++)
      Excitation[j]=Excitation[j+subframesize];
    for (j=0;j<subframesize;j++)
      Excitation[j+ACBMemSize-subframesize]=copy[i*(SubFrameSize-1)+j];
#endif
  } /* End of subframe loop */


  return delayindex;
}
#endif

void FGV_MEM::jumptofullcelp(int& rate)
{
  int i;
  bit_rate=rate=PACKET_RATE=4;
  MODE_BIT=0;
  
  // Revert back to old memory at the end of previous frame
  delay=delay2, accshift=accshift2, dpm=dpm2, shiftSTATE=shiftSTATE2;
  for (i=0;i<ORDER;i++) SynMemoryM[i]= SynMemoryM2[i];
  for (i=0;i<ORDER;i++) WFmemFIR[i]= WFmemFIR2[i];
  for (i=0;i<ORDER;i++) WFmemIIR[i]= WFmemIIR2[i];
  for (i=0;i<ACBMemSize;i++) Excitation[i]=Excitation2[i];
  for (i=0;i<dpm;i++) residualm[i]=residualm2[i];
  for (i=0;i<ACBMemSize;i++) bufferm[i]=bufferm2[i];

  /* Re-initialize PackWdsPtr */
  PackWdsPtr[0] = 16;
  PackWdsPtr[1] = 0;
  for (i = 0; i < PACKWDSNUM; i++) PackedWords[i] = 0;

  celp_encoder(bit_rate);
}

#if 0
int jumptofullppp(DTFS& currp_q_E,float *lpc1,float*lpc2)
{
  int i;

  // Set packet rate to 4
  data_packet.PACKET_RATE=4;

  // Restore MA LSP memories
  for (i=0;i<LPCORDER;i++) cbprevprev_E[i]=cbprevprev_E2[i];
  for (i=0;i<LPCORDER;i++) cbprev_E[i]=cbprev_E2[i];

  // Revert back to old memory at the end of previous frame
  delay=delay2, accshift=accshift2, dpm=dpm2, shiftSTATE=shiftSTATE2;
  for (i=0;i<ORDER;i++) SynMemoryM[i]= SynMemoryM2[i];
  for (i=0;i<ORDER;i++) WFmemFIR[i]= WFmemFIR2[i];
  for (i=0;i<ORDER;i++) WFmemIIR[i]= WFmemIIR2[i];
  for (i=0;i<ACBMemSize;i++) Excitation[i]=Excitation2[i];
  for (i=0;i<dpm;i++) residualm[i]=residualm2[i];
  for (i=0;i<ACBMemSize;i++) bufferm[i]=bufferm2[i];

  // Don't need to look at rfileP here
  // Don't need to do pattern stuff
  // Don't need to do operating point specific stuff
  // Don't need to look for additional FC bumpup, but since residual may be 
  //       different, we can have it in
  
  /* Re-initialize PackWdsPtr */
  PackWdsPtr[0] = 16;
  PackWdsPtr[1] = 0;
  for (i = 0; i < PACKWDSNUM; i++) PackedWords[i] = 0;

  // LSP Quantization
  float tmplsi[ORDER], tmplsc[ORDER];
    knum=4;
    enc_lsp_vq_28(lsp_nq, SScratch, lsp);
    for (i=0; i<knum; i++)
      data_packet.LSP_IDX[i]=SScratch[i];
  /* Compute lsi for backing up for MA LPC in Q/H PPP */
  for (i=0; i<ORDER; i++) tmplsc[i]=cos(pi2*lsp[i]);
  for (i=0;i<ORDER;i++)
    tmplsi[i]=(tmplsc[i]<0.)+(SIGN(tmplsc[i]))*0.5*sqrt(1-fabs(tmplsc[i]));
  for (i=0;i<ORDER;i++) cbprevprev_E[i]=cbprev_E[i]=tmplsi[i];  
  /* copied quantized LSPs */
  //extern float global_lsp[ORDER];
  for (i=0;i<ORDER;i++) global_lsp[i]=lsp[i];
  
  if (Eargs->unquantized_lsp) {
    for (i=0;i<ORDER;i++) global_lsp[i]=lsp_nq[i]; 
    for (i=0;i<ORDER;i++) lsp[i]=lsp_nq[i];
  }

  /* Compute residual with quantized LSPs */
  /* Get residual signal */
  for (i=0; i<ORDER; i++) Scratch[i]=0;	/* Scratch is used as filter memory */
  lsp2a(pci, OldlspE);
  GetResidual(residual, HPspeech, pci, Scratch, ORDER, GUARD);
  for (i=0; i<NoOfSubFrames; i++) {
    Interpol(lspi, OldlspE, lsp, i, ORDER);
    lsp2a(pci, lspi);
    if (i < 2)
      GetResidual(residual + i * (SubFrameSize - 1) + GUARD,
		  HPspeech + i * (SubFrameSize - 1) + GUARD, pci, Scratch,
		  ORDER, SubFrameSize - 1);
    else
      GetResidual(residual + i * (SubFrameSize - 1) + GUARD,
		  HPspeech + i * (SubFrameSize - 1) + GUARD, pci, Scratch,
		  ORDER, SubFrameSize);
  }
  lsp2a(pci,lsp);
  GetResidual(residual + FrameSize + GUARD,
	      HPspeech + FrameSize + GUARD, pci,Scratch, ORDER, GUARD);

  // Start Voiced Processing
  
  float   mres[FrameSize];
  float   targ_speech[FrameSize];
  float   acc3[NoOfSubFrames];
    
  /* Save target filters' memory for closed loop processing */
  for (i=0;i<ORDER;i++) SynMemoryM2[i]= SynMemoryM[i];
  for (i=0;i<ORDER;i++) WFmemFIR2[i]= WFmemFIR[i];
  for (i=0;i<ORDER;i++) WFmemIIR2[i]= WFmemIIR[i];
  for (i=0;i<ACBMemSize;i++) Excitation2[i]=Excitation[i];
  for (i=0;i<dpm;i++) residualm2[i]=residualm[i];
  delay2=delay, accshift2=accshift, dpm2=dpm, shiftSTATE2=shiftSTATE;
  for (i=0;i<ACBMemSize;i++) bufferm2[i]=bufferm[i];
  
  short delayindex=get_rcelpmres_for_voiced(mres,targ_speech,acc3);
  data_packet.delayindex=delayindex; 
    
  int pl=(int)rint(pdelay),l=(int)rint(delay);
  float *in=mres;

  float tmp, tmplsp[ORDER];
  DTFS TMP;
  
  Interpol(tmplsp, OldOldlspE, OldlspE, 2, ORDER);
  lsp2a(lpc1,tmplsp);
  Interpol(tmplsp, OldlspE, lsp, 2, ORDER);
  lsp2a(lpc2,tmplsp);
  
  if (lastrateE !=3 && lastrateE !=4) pl=l;
  if (pl>(int)anint(1.85*l)) pl/=2;
  if (pl*2<=MAXLAG_PPP && pl<=(int)anint(0.54*l)) pl*=2;

  float currp[FrameSize];
  ppp_extract_pitch_period(in, currp, l) ;
  currp_nq.to_fs(currp, l);

  //Ensure the extracted prototype is time-synchronous to the
  //last l samples of the frame. This proves to eliminate
  //some of the PPP-CELP transition problems.
  TMP.to_fs(in+FSIZE-l,l);
  tmp = TMP.alignment_extract(currp_nq, 0.0, lpc2) ;
  currp_nq.phaseShift(TWO_PI*tmp/l) ;

  //Need to make sure the "in" array has the past 160 samples as well as
  //the current 160 samples available before using the getSCR function!
  //scr = getSCR(in, (pl+l)>>1) ;
  scr=0.0;  /***TURN off SCR feature for the time being***/

  ppp_full_encoder(&currp_q_E, currp_nq, lpc2);

  return 0;  
}
#endif

short FGV_MEM::voiced_decoder(float *outFbuf,short post_filter,
				   short run_length, short phase_offset, float	time_warp_fraction, short*	obuf_len)
{
  register int i, j;
  register float *foutP;
  short   subframesize;
  float  *ppp_res=new float[FrameSize * 2]; //Phase Matching: Increased size to support PM, Warping
  
  //extern float prevpD[ACBMemSize];

  //Variables used for Phase Matching

  short		do_phase_matching = 0;
  int		pm_var1 = 0;
  int		temp_samples_count = 0;
  int		num_samples;
  float		store_ddelay;

  //End Variables used for Phase Matching

  if (phase_offset != 10) //Phase Offset == 10 denotes Phase Matching disabled
	do_phase_matching = 1; //check for Phase Matching


  // LSP De-Quantization
  float tmplsi[ORDER], tmplsc[ORDER];

  if (PPP_MODE_D=='Q' || PPP_MODE_D=='H') {
    LSF_IDX[0]=data_packet.LSP_IDX[0];
    LSF_IDX[1]=data_packet.LSP_IDX[1];
    unquantize_LSI2(LSF_IDX, tmplsi);
#ifdef NEWMALSPVQ
    for (i=0;i<LPCORDER;i++) {
      lsp[i]=0.2*cbprevprev_D[i]+0.4*cbprev_D[i]+tmplsi[i];
      cbprevprev_D[i]=cbprev_D[i];
      cbprev_D[i]=2.5*tmplsi[i];//need this to make it MALSPVQ
    }    
    //stabilize_lsp(lsp);
    {
      if (lsp[0]<LSP_SPREAD_FACTOR_QPPP) lsp[0]=LSP_SPREAD_FACTOR_QPPP;
      for (i=1; i<LPCORDER; i++)
        if (lsp[i]-lsp[i-1]<LSP_SPREAD_FACTOR_QPPP)
          lsp[i]=lsp[i-1]+LSP_SPREAD_FACTOR_QPPP;
      if (0.5-lsp[LPCORDER-1]<2*LSP_SPREAD_FACTOR_QPPP) { 
        lsp[LPCORDER-1]=0.5-2*LSP_SPREAD_FACTOR_QPPP;
        i=LPCORDER-2;
	while ((lsp[i+1]-lsp[i]<LSP_SPREAD_FACTOR_QPPP) && (i>=0)) {
          lsp[i]=MIN(lsp[i+1]-LSP_SPREAD_FACTOR_QPPP,0);
          i--;
        }
      }
    }
        
    /* Check for monontonic LSP */
    for (j=1; j<ORDER; j++) if (lsp[j] <= lsp[j - 1]) errorFlag=1;

     
#else //NEWMALSPVQ
    for (i=0;i<LPCORDER;i++) {
      lsp[i]=0.2*cbprevprev_D[i]+0.4*cbprev_D[i]+0.4*tmplsi[i];
      cbprevprev_D[i]=cbprev_D[i];
      cbprev_D[i]=tmplsi[i];
    }    
    stabilize(lsp);
    for (i=0;i<ORDER;i++) {
      lsp[i]=((lsp[i])>0.5) ? (SQR(2.0-2.0*lsp[i])-1):(1-SQR(2.0*lsp[i]));
      lsp[i]=acos(lsp[i])/pi2;
    
    }    
    /* Check for monontonic LSP */
    for (j=1; j<ORDER; j++) if (lsp[j] <= lsp[j - 1]) errorFlag=1;
#endif //NEWMALSPVQ
  }
  else if (PPP_MODE_D=='F') {
    dec_lsp_vq_28((short int *)data_packet.LSP_IDX, lsp);
    /* Check for monontonic LSP */
    for (j=1; j<ORDER; j++) if (lsp[j] <= lsp[j - 1]) errorFlag=1;    
#ifdef NEWMALSPVQ
    for (i=0;i<ORDER;i++) cbprevprev_D[i]=cbprev_D[i]=lsp[i];    
#else //NEWMALSPVQ
    /* Compute lsi for backing up for MA LPC in Q/H PPP */
    for (i=0; i<ORDER; i++) tmplsc[i]=cos(pi2*lsp[i]);
    for (i=0;i<ORDER;i++)
      tmplsi[i]=(tmplsc[i]<0.)+(SIGN(tmplsc[i]))*0.5*sqrt(1-fabs(tmplsc[i]));
    for (i=0;i<ORDER;i++) cbprevprev_D[i]=cbprev_D[i]=tmplsi[i];
#endif //NEWMALSPVQ

#ifdef LSP_SPRD
  lsp_spread(lsp);
#endif
  
  }
  

      
  // Do Voiced/PPP Decoding
  
  short delayindex;
  delayindex=data_packet.delayindex;
  
  delay = (float) (delayindex+DMIN);
  if (PPP_MODE_D=='Q') Q_delta_lag=data_packet.Q_delta_lag;
  int delta_lag_D=Q_delta_lag-7;
  if (PPP_MODE_D=='Q' || PPP_MODE_D=='H') {
    if (!(delta_lag_D<=8 && delta_lag_D>=-7)) {
      cerr<<"voiced.cc - Delta pitch out of range at the decoder -";
      cerr<<"FrameNum: "<<decode_fcnt<<"\n";
    }
    delay=rint(pdelayD)+delta_lag_D;
    pdeltaD=delta_lag_D;
    if (delay>DMAX) delay=DMAX;
    else if (delay<DMIN) delay=DMIN;
  }

  float *out=ppp_res;
  int pl=(int)rint(pdelayD),l=(int)rint(delay);
  float tmplsp[ORDER], lpc1[ORDER], lpc2[ORDER];
  DTFS TMP, currp_q_D ;
  
  Interpol(tmplsp, OldOldlspD, OldlspD, 2, ORDER);
  lsp2a(lpc1,tmplsp);
  Interpol(tmplsp, OldlspD, lsp, 2, ORDER);
  lsp2a(lpc2,tmplsp);
  
  if (lastrateD !=3 && lastrateD !=4) pl=l;

  if (pl>(int)anint(1.85*l)) pl/=2;
  if (pl*2<=MAXLAG_PPP && pl<=(int)anint(0.54*l)) pl*=2;

  //Restoring PPP memories when the last frame is non-PPP or full-rate PPP
  if (LAST_PACKET_RATE_D==1 || LAST_PACKET_RATE_D==3 || LAST_MODE_BIT_D==0 || prev_frame_error) {
    prev_cw_D.to_fs(prevpD+ACBMemSize-pl, pl);
    ph_offset_D = 0.0 ;

    TMP = prev_cw_D ;
    TMP.car2pol();
    lastLgainD=log10(TMP.lag*TMP.setEngyHarm(92.0,1104.5,0.0,1104.5,1.0));
    lastHgainD=log10(TMP.lag*TMP.setEngyHarm(1104.5,3300.0,1104.5,4000.0,1.0));


    TMP.to_erb(lasterbD);
  }
  else if (LAST_PACKET_RATE_D==4 && LAST_MODE_BIT_D==1) {
    TMP = prev_cw_D ;
    TMP.car2pol();
    lastLgainD=log10(TMP.lag*TMP.setEngyHarm(92.0,1104.5,0.0,1104.5,1.0));
    lastHgainD=log10(TMP.lag*TMP.setEngyHarm(1104.5,3300.0,1104.5,4000.0,1.0));
    TMP.to_erb(lasterbD);
  }
  //If QPPP put amp quant and power indices in data_packet structure
  if (PPP_MODE_D == 'Q') {
    POWER_IDX=data_packet.POWER_IDX; // Power idx
    AMP_IDX[0]=data_packet.AMP_IDX[0]; // Low-band power idx
    AMP_IDX[1]=data_packet.AMP_IDX[1]; // hi-band power idx
  }
  //If FPPP put amp quant, power indices, and aligns in data_packet structure
  else if (PPP_MODE_D == 'F') {
    F_ROT_IDX=data_packet.F_ROT_IDX; // Rotation
    A_POWER_IDX=data_packet.A_POWER_IDX; // Power idx
    A_AMP_IDX[0]=data_packet.A_AMP_IDX[0]; // Low-band power idx
    A_AMP_IDX[1]=data_packet.A_AMP_IDX[1]; // hi-band power idx
    A_AMP_IDX[2]=data_packet.A_AMP_IDX[2]; // hi-band power idx
    for (i=0; i<NUM_FIXED_BAND; i++) 
      F_ALIGN_IDX[i]=data_packet.F_ALIGN_IDX[i]; 
  }

  //Prototype Dequantization
  //NOTE that currp_q_D has garbage at this point
  currp_q_D.lag = l ;
    
  if (PPP_MODE_D == 'F') 
    ppp_full_decoder(&currp_q_D, lpc2);
  else if (PPP_MODE_D == 'Q') 
    ppp_quarter_decoder(&currp_q_D, prev_cw_D, lpc2);
  else
    assert(1==0);
    
  LAST_PPP_MODE_D = PPP_MODE_D ;



  if (do_phase_matching)
  {
	double prev_delay, prev_delay2;
	double prev_delay_end, prev_delay2_end;
	double encoder_phase, decoder_phase;
	
	//if (idxppg != 0) //get delay of previous frame from current frame
	{
		prev_delay_end = pdelayD;
		prev_delay2_end = pdelayD;
	
		prev_delay = pdelayD;
		prev_delay2 = pdelayD;
	}
						
	//Different cases using Phase Matching
	//Get phase of encoder and current phase of decoder
	//The difference between these is the amount of Phase Matching to be done

	decoder_phase = encoder_phase = 0;

	if (phase_offset == 0) 
	{
		if (run_length == 1)
		{
			encoder_phase = fmod (160, prev_delay)/prev_delay;
			decoder_phase = fmod (160, pdelayD)/pdelayD;
		}
		else if (run_length == 2)
		{
			encoder_phase = fmod (fmod (160, prev_delay) + fmod (160, prev_delay2), prev_delay)/prev_delay;
			decoder_phase = fmod (fmod (160, pdelayD) * 2, pdelayD)/pdelayD;
		}
	}
	else if (phase_offset == 1)
	{
		if (run_length == 1)
		{
			encoder_phase = 0;
			decoder_phase = fmod (160, pdelayD)/pdelayD;
		}
		else if (run_length == 2)
		{
			encoder_phase = fmod (160, prev_delay)/prev_delay;
			decoder_phase = fmod (fmod (160, pdelayD) * 2, pdelayD)/pdelayD;
		}
	}
	else if (phase_offset == 2)
	{
		encoder_phase = 0;
		decoder_phase = fmod (fmod (160, pdelayD) * 2, pdelayD)/pdelayD;
	}
	else if (phase_offset == -1)
	{
		encoder_phase = fmod (fmod (160, prev_delay) + fmod (160, prev_delay2), prev_delay)/prev_delay;
		decoder_phase = fmod (160, pdelayD)/pdelayD;
	}

	//End Different cases using Phase Matching

	if (decoder_phase >= encoder_phase)
	{
		pm_var1 = (int) ((decoder_phase - encoder_phase) * prev_delay);
	}
	else
		pm_var1 = (int) (prev_delay - prev_delay * (encoder_phase - decoder_phase));

       if (fabs(encoder_phase-decoder_phase) <= 0.05){
          pm_var1 = 0; /* pm_var1 too small */
         }
       if (pm_var1 >=100) pm_var1 = 0; /* pm_var1 too large */

	num_samples = 160 - pm_var1;
	if (num_samples < delay)
		num_samples = 160;

	if (num_samples <= 120)
	{
		if (time_warp_fraction < 1)
			time_warp_fraction = 1;
		else
	                time_warp_fraction = 1.5;
	}

	//printf ("\n ppp_delays %f %f %f %d %f", pdelayD, delay, delay, pm_var1, ph_offset_D); //fflush(stdout);

	if (time_warp_fraction > 1 || time_warp_fraction < 1)
	{
		if (time_warp_fraction > 1) //Expansion
		{
			if (phase_offset == -1 && (num_samples + 3 * delay) <= 320)
			{
				WIsyn(prev_cw_D,&currp_q_D,lpc1,lpc2,&ph_offset_D,out, (int)(num_samples + 3 * delay));
				num_samples += (int)(3 * delay);
			}
			else if (phase_offset == -1 && (num_samples + 2 * delay) <= 320)
			{
				WIsyn(prev_cw_D,&currp_q_D,lpc1,lpc2,&ph_offset_D,out, (int)(num_samples + 2 * delay));
				num_samples += (int)(2 * delay);
			}
			else
			{
				WIsyn(prev_cw_D,&currp_q_D,lpc1,lpc2,&ph_offset_D,out, (int)(num_samples + delay));
				num_samples += (int)delay;
			}
		}
		else if (time_warp_fraction < 1) //Compression
		{
			//printf ("\n Checking PPP condition PM %d %d", (int)(num_samples - delay), currp_q_D.lag);
			//Do PPP compression only if num_samples - delay > currp_q_D.lag
			//Else do CELP-like compression
			if ((int)(num_samples - delay) > currp_q_D.lag)
			{
			WIsyn(prev_cw_D,&currp_q_D,lpc1,lpc2,&ph_offset_D,out, (int)(num_samples - delay));
			num_samples -= (int)delay;
		}
			else
			{
				WIsyn(prev_cw_D,&currp_q_D,lpc1,lpc2,&ph_offset_D,out, num_samples);
				int	b, merge_start, merge_end, merge_stop;

				merge_start = 0;
								  
				if ((prev_cw_D.lag) - floor ((float)prev_cw_D.lag) > 0.5)
					merge_end = (int) prev_cw_D.lag + 1;
				else
					merge_end = (int) prev_cw_D.lag;

				if (merge_end - merge_start > num_samples/2)
					merge_stop = num_samples - (merge_end - merge_start);
				else
					merge_stop = merge_end - merge_start;

				if (num_samples <= prev_cw_D.lag)
	  				merge_stop = 0;

				if (merge_stop != 0)
				{		
					//Regular compression as requested by de-jitter: produce one less pitch period
					//Compress only if compressed samples >= 40
					if ((num_samples - (merge_end - merge_start)) >= 20)
					{
						for (b = merge_start; b < merge_stop; b++)
							ppp_res[b] = ppp_res[b] * (1.0 * (merge_stop-merge_start-b)/(merge_stop-merge_start)) + ppp_res[b+(merge_end-merge_start)] * (1.0 * (b)/(merge_stop-merge_start));	

						for (b = merge_stop; b + merge_end - merge_start < num_samples; b++)
							ppp_res[b] = ppp_res[b + merge_end - merge_start];

						num_samples -= (merge_end - merge_start);
					}
				}
			}
		}
	}
	else // No Compression or Expansion
		//WI 2-D SYNTHESIS SCHEME
		WIsyn(prev_cw_D,&currp_q_D,lpc1,lpc2,&ph_offset_D,out,num_samples);
  }
  else
  {
	num_samples = 160;

	if (time_warp_fraction > 1 || time_warp_fraction < 1)
	{
		if (time_warp_fraction > 1) //Expansion
		{
			WIsyn(prev_cw_D,&currp_q_D,lpc1,lpc2,&ph_offset_D,out, (int)(num_samples + delay));
			num_samples += (int)delay;
		}
		else if (time_warp_fraction < 1) //Compression
		{
			//printf ("\n Checking PPP condition %d %d", (int)(num_samples - delay), currp_q_D.lag);
			//Do PPP compression only if num_samples - delay > currp_q_D.lag
			//Else do CELP-like compression
			if ((int)(num_samples - delay) > currp_q_D.lag)
			{
			WIsyn(prev_cw_D,&currp_q_D,lpc1,lpc2,&ph_offset_D,out, (int)(num_samples - delay));
			num_samples -= (int)delay;
		}
			else
			{
				WIsyn(prev_cw_D,&currp_q_D,lpc1,lpc2,&ph_offset_D,out, num_samples);

				int	b, merge_start, merge_end, merge_stop;

				merge_start = 0;
								  
				if ((prev_cw_D.lag) - floor ((float)prev_cw_D.lag) > 0.5)
					merge_end = (int) prev_cw_D.lag + 1;
				else
					merge_end = (int) prev_cw_D.lag;

				if (merge_end - merge_start > num_samples/2)
					merge_stop = num_samples - (merge_end - merge_start);
				else
					merge_stop = merge_end - merge_start;

				if (num_samples <= prev_cw_D.lag)
	  				merge_stop = 0;
				//merge_stop = 0;
				//printf ("\n Checking PPP %d %d %d %d %d %f", merge_stop, num_samples, merge_end, currp_q_D.lag, prev_cw_D.lag, delay);
				if (merge_stop != 0)
				{		
					//Regular compression as requested by de-jitter: produce one less pitch period
					//Compress only if compressed samples >= 40
					if ((num_samples - (merge_end - merge_start)) >= 20)
					{
						for (b = merge_start; b < merge_stop; b++)
							ppp_res[b] = ppp_res[b] * (1.0 * (merge_stop-merge_start-b)/(merge_stop-merge_start)) + ppp_res[b+(merge_end-merge_start)] * (1.0 * (b)/(merge_stop-merge_start));	

						for (b = merge_stop; b + merge_end - merge_start < num_samples; b++)
							ppp_res[b] = ppp_res[b + merge_end - merge_start];

						num_samples -= (merge_end - merge_start);
					}
				}
			}
		}
	}
	else {// No Compression or Expansion
		WIsyn(prev_cw_D,&currp_q_D,lpc1,lpc2,&ph_offset_D,out,num_samples);

	  //printf ("\n voiced num_samples %d", num_samples);
          }
  }
  
  /* Update fer coefficients */
  ave_acb_gain = MIN(1.0,sqrt(sqrt(currp_q_D.getEngy()/prev_cw_D.getEngy())));
  ave_fcb_gain = 0.0;

  prev_cw_D = currp_q_D ;

   
  foutP = outFbuf;

  //More support for Phase Matching/Warping
  //printf ("\n voiced num_samples %d, fr_cnt:%d", num_samples,decode_fcnt);
  *obuf_len = num_samples;
  temp_samples_count = 0;

  //End: More support for Phase Matching/Warping

  for (i=0; i<NoOfSubFrames; i++) {    
	
	//Warping: Change in size of subframesize, not always equal to 53 since residual size may not be = 160

	if (num_samples % 3 == 0)
		subframesize = num_samples/3;
	else if (num_samples % 3 == 1)
	{
		if (i < 2)
			subframesize = num_samples/3;
		else
			subframesize = num_samples/3 + 1;
	}
	else if (num_samples % 3 == 2)
	{
		if (i < 1)
			subframesize = num_samples/3;
		else
			subframesize = num_samples/3 + 1;
	}
	//End Change in size of subframesize, not always equal to 53

    Interpol(lspi, OldlspD, lsp, i, ORDER);
    /* Convert lsp to PC */
    lsp2a(pci, lspi);

	//Warping: Slight change in call to support smaller/larger number of samples
    for (j=0;j<subframesize;j++)
      PitchMemoryD[ACBMemSize+j]=ppp_res[temp_samples_count+j];	

	PitchMemoryD[ACBMemSize+j]=copy[i*(SubFrameSize-1)+j];    
    for (j = 0; j < ACBMemSize; j++)
      PitchMemoryD[j] = PitchMemoryD[j + subframesize];
    for (j = 0; j < ACBMemSize; j++)
      PitchPreFiltMemoryD[j] = PitchMemoryD[j];

     # ifdef QRES 
        for(j=0;j<subframesize;j++)
           printf("%f\n",PitchMemoryD[j+ACBMemSize]);
     # endif
      
    /* Synthesis of decoder output signal and postfilter output signal */
    SynthesisFilter(DECspeech, PitchMemoryD + ACBMemSize, pci, SynMemory,
		    ORDER, subframesize);
    /* Postfilter */
    if (post_filter) {
	Post_Filter(DECspeech, lspi, pci, DECspeechPF, 
		    delay, 0.4, 0.15, 
		    subframesize);
    }
    else V_copy(DECspeech,DECspeechPF,subframesize);
    /* Write p.f. decoder output and variables to files */
    for (j = 0; j < subframesize; j++) {
      if (DECspeechPF[j] > 32767.0) *foutP++ = 32767.0;
      else {
	if (DECspeechPF[j] < -32768) *foutP++ = -32768.0;
	else *foutP++ = DECspeechPF[j];
      }
    }
	
	temp_samples_count += subframesize; //Addition to support Warping
  }
  delete[] ppp_res;
  pdelayD = delay;
  
  return (0);  
}

void FGV_MEM::voiced_erasure_decoder(float *outFbuf,short post_filter)
{
  register int i, j;
  register float *foutP;
  short   subframesize;
  float  *ppp_res=new float[FrameSize];
  
  //extern float prevpD[ACBMemSize];
  
  delay=rint(pdelayD);

  float *out=ppp_res;
  int pl=(int)rint(pdelayD),l=pl;
  float tmp, tmplsp[ORDER], lpc1[ORDER], lpc2[ORDER];
  DTFS TMP, currp_q_D ;
    PPP_MODE_D= 'E';
  
  Interpol(tmplsp, OldOldlspD, OldlspD, 2, ORDER);
  lsp2a(lpc1,tmplsp);
  Interpol(tmplsp, OldlspD, lsp, 2, ORDER);
  lsp2a(lpc2,tmplsp);
  
  if (lastrateD !=3 && lastrateD !=4) pl=l;

  if (pl>(int)anint(1.85*l)) pl/=2;
  if (pl*2<=MAXLAG_PPP && pl<=(int)anint(0.54*l)) pl*=2;

  //Restoring PPP memories when the last frame is non-PPP or full-rate PPP
  if (LAST_PACKET_RATE_D==1 || LAST_PACKET_RATE_D==3 || LAST_MODE_BIT_D==0 || prev_frame_error) {
    prev_cw_D.to_fs(prevpD+ACBMemSize-pl, pl);
    ph_offset_D = 0.0 ;

    TMP = prev_cw_D ;
    TMP.car2pol();
    lastLgainD=log10(TMP.lag*TMP.setEngyHarm(92.0,1104.5,0.0,1104.5,1.0));
    lastHgainD=log10(TMP.lag*TMP.setEngyHarm(1104.5,3300.0,1104.5,4000.0,1.0));
    TMP.to_erb(lasterbD);
  }
  else if (LAST_PACKET_RATE_D==4 && LAST_MODE_BIT_D==1) {
    TMP = prev_cw_D ;
    TMP.car2pol();
    lastLgainD=log10(TMP.lag*TMP.setEngyHarm(92.0,1104.5,0.0,1104.5,1.0));
    lastHgainD=log10(TMP.lag*TMP.setEngyHarm(1104.5,3300.0,1104.5,4000.0,1.0));
    TMP.to_erb(lasterbD);
  }

  //Prototype Repeat with an appropriate scaling
  currp_q_D = prev_cw_D*ave_acb_gain;
  
  //Use the RCELP extended pitch memory to get the phase of the current prototype
  {
    DTFS TMP, TMP2;
    float temp_pl=pdelayD, temp_l=l; //delay, pdelayD
    float temp_acb[ACBMemSize+SubFrameSize+10], temp_res[160], delayD3[3];

    //Extending the ACB memory
    for (i=0;i<ACBMemSize; i++) temp_acb[i]=PitchMemoryD[i];
    for (i=0; i<NoOfSubFrames; i++) {      
      if (i < 2) subframesize = SubFrameSize - 1;
      else subframesize = SubFrameSize;
      
      // Interpolate delay
      Interpol_delay(delayD3, &temp_pl, &temp_l, i);
      // Compute adaptive codebook contribution
      acb_excitation(temp_acb + ACBMemSize, 1, delayD3, temp_acb, subframesize);
      
      for (j=0; j<subframesize; j++)temp_res[j+i*(SubFrameSize-1)]=temp_acb[j+ACBMemSize];
      for (j=0; j<ACBMemSize; j++)temp_acb[j]=temp_acb[j+subframesize];
    }
    
    //Perform extraction on the ACB extended memory
    //Using temp_acb as a temporary storage for the extracted prototype
    ppp_extract_pitch_period(temp_res, temp_acb, l) ;
    TMP.to_fs(temp_acb, l);
    
    //Ensure the extracted prototype is time-synchronous to the
    //last l samples of the frame. This proves to eliminate
    //some of the PPP-CELP transition problems.
    TMP2.to_fs(temp_res+FSIZE-l,l);
    tmp = TMP2.alignment_extract(TMP, 0.0, lpc2) ;
    TMP.phaseShift(TWO_PI*tmp/l) ;
    
    //Copying phase spectrum over
    TMP.car2pol(); currp_q_D.car2pol();
    for (i=0;i<=currp_q_D.lag>>1;i++) currp_q_D.b[i] = TMP.b[i];
    currp_q_D.pol2car();
  }
    
  LAST_PPP_MODE_D = PPP_MODE_D ;


  //WI 2-D SYNTHESIS SCHEME
  WIsyn(prev_cw_D,&currp_q_D,lpc1,lpc2,&ph_offset_D,out,FSIZE);

  prev_cw_D = currp_q_D ;


  foutP = outFbuf;
  for (i=0; i<NoOfSubFrames; i++) {    
    if (i < 2) subframesize = SubFrameSize - 1;
    else subframesize = SubFrameSize;
    Interpol(lspi, OldlspD, lsp, i, ORDER);    
    /* Convert lsp to PC */
    lsp2a(pci, lspi);
    for (j=0;j<subframesize;j++)
      PitchMemoryD[ACBMemSize+j]=ppp_res[i*(SubFrameSize-1)+j];	

    for (j = 0; j < ACBMemSize; j++)
      PitchMemoryD[j] = PitchMemoryD[j + subframesize];
    for (j = 0; j < ACBMemSize; j++)
      PitchPreFiltMemoryD[j] = PitchMemoryD[j];

    /* Synthesis of decoder output signal and postfilter output signal */
    SynthesisFilter(DECspeech, PitchMemoryD + ACBMemSize, pci, SynMemory,
		    ORDER, subframesize);
    /* Postfilter */
    if (post_filter) {
	Post_Filter(DECspeech, lspi, pci, DECspeechPF, 
		    delay, 0.4, 0.15, 
		    subframesize);
    }
    else V_copy(DECspeech,DECspeechPF,subframesize);
    /* Write p.f. decoder output and variables to files */
    for (j = 0; j < subframesize; j++) {
      if (DECspeechPF[j] > 32767.0) *foutP++ = 32767.0;
      else {
	if (DECspeechPF[j] < -32768) *foutP++ = -32768.0;
	else *foutP++ = DECspeechPF[j];
      }
    }
  }
  delete[] ppp_res;
  pdelayD = delay;  
}

DTFS freq_trim(DTFS freqtrim_in, float cutoff, float *ENERGY_TO_B_ADDED, float *SIGNAL_ENERGY, float *LP_SIGNAL_ENERGY, int *subframecount)
{
  int ncount;
  float freq;
  *ENERGY_TO_B_ADDED=0.0;
  DTFS freqtrim_out;
  freqtrim_out =freqtrim_in;
  
  for(ncount=0;ncount<=freqtrim_in.lag>>1;ncount++){
    freq=8000*ncount/freqtrim_in.lag;
    if(freq>cutoff){
      //Removing only 1/2 the energy above voicing threshold
      freqtrim_out.a[ncount]/=sqrt(2.0);
      freqtrim_out.b[ncount]/=sqrt(2.0);
    }
  }
  
  *ENERGY_TO_B_ADDED=(freqtrim_out.getEngy(cutoff,4000.0))*160;
  *SIGNAL_ENERGY=(freqtrim_in.lag*(freqtrim_in.getEngy(0,4000.0)))*160/freqtrim_in.lag;
  *LP_SIGNAL_ENERGY=(freqtrim_out.lag*(freqtrim_out.getEngy(0,4000.0)))*160/freqtrim_out.lag;
  *subframecount=(int) floor((double)FSIZE/freqtrim_in.lag);
  
  return freqtrim_out;
}

#if 0
void addnoise(float *out, float *ENERGY_TO_B_ADDED, float *SIGNAL_ENERGY, float *LP_SIGNAL_ENERGY, int (*subframesize), float  *out_prev_fr, float *PREV_FRAME_LAST_ENERGY, float *noisehp_filt_num, float *noisehp_filt_den, int filter_order, short fcnt_diff, int *prevfr_lag_noiseflag)
{
  float noisein[FSIZE];
  float noiseout[FSIZE];
  float noise1[FSIZE];
  int ncount,ncount1;
  
  //filter parameters
  static double *noisehpfilter_mem;
  noisehpfilter_mem=(double *)calloc(filter_order,sizeof(double));
  POLEZERO_FILTER noisehp_filter={filter_order,filter_order,filter_order,0,noisehpfilter_mem};
  
  static int INITIALISR=0;
  if(INITIALISR==0){
    for (ncount=0;ncount<7;ncount++) noisehpfilter_mem[ncount]=0;
    for (ncount=0;ncount<FSIZE;ncount++) out_prev_fr[ncount]=0.0;  
    *PREV_FRAME_LAST_ENERGY=0.0;
    INITIALISR=1;
  }
  
  float ENERGY_HP_NOISE=0.0;
  float ENERGY_HP_NOISE_ADDED=0.0;
  float ENERGY_OUT_B4=0.0;
  float ENERGY_OUT_AFTER=0.0;
  double ENERGY_SCALE_MAX=0.0;
  
  double var=0.0;
  double mean=0.0;
  double oldvar, newvar;
  float ntemp=0.0;
  float step_size=0.0;
  double ENERGY_SCALE[FSIZE+1];

  //Initialize ENERGY_SCALE to zeros
  {
    int i;
    for (i=0;i<FSIZE+1;i++) ENERGY_SCALE[i]=0.0;
  }
  
  for(ncount=0;ncount<FSIZE;ncount++) noisein[ncount]=rand()/1000;	
  
  polezero_filter(noisein, noiseout, FSIZE, noisehp_filt_num, noisehp_filt_den, noisehp_filter);
  
  // to find energy in each subframe, subframesize=pitch prototype lag
  //finding energy from the last subframe and going in the reverse
  for(ncount1=(FSIZE-1);((ncount1-(*subframesize))>=0);ncount1=(ncount1-(*subframesize))){
    for(ncount=((*subframesize)-1);ncount>=0;ncount--){		ENERGY_SCALE[ncount1]+=out[ncount1-ncount]*out[ncount1-ncount];
    }
  }
  // to find the energy for the first subframe
  for(ncount=(ncount1);ncount>= 0;ncount--)  ENERGY_SCALE[0]+=out[ncount]*out[ncount];
  for(ncount=(FSIZE-1);ncount>(FSIZE-((*subframesize)-ncount1));ncount--)	ENERGY_SCALE[0]+=out_prev_fr[ncount]*out_prev_fr[ncount];
  
  // storing the energy of the last prototype
  ntemp=ENERGY_SCALE[FSIZE-1]; 
  
  //to scale all the energies with respect to the last prototype energy
  for(ncount=0;ncount<FSIZE;ncount++)   ENERGY_SCALE[ncount]=ENERGY_SCALE[ncount]/ntemp;
  *PREV_FRAME_LAST_ENERGY=*PREV_FRAME_LAST_ENERGY/ntemp;
  
  //to find the step size and scale energy
  for(ncount1=(FSIZE-1);((ncount1-(*subframesize))>=0);ncount1=(ncount1-(*subframesize))){
    step_size=(ENERGY_SCALE[ncount1]-ENERGY_SCALE[ncount1-(*subframesize)])/((*subframesize));
    for(ncount=((*subframesize)-1);ncount>=0;ncount--){
      ENERGY_SCALE[ncount1-ncount]=ENERGY_SCALE[ncount1-ncount-1]+step_size;
    }
  }
  
  // for remainder of the frame in the start
  step_size=(ENERGY_SCALE[0]-*PREV_FRAME_LAST_ENERGY)/ncount1;
  for(ncount=(ncount1-1);ncount> 0;ncount--){
    ENERGY_SCALE[ncount]=ENERGY_SCALE[ncount-1]-step_size;
  }
  *PREV_FRAME_LAST_ENERGY=ntemp;
  
  for(ncount=0;ncount<FSIZE;ncount++) mean +=noiseout[ncount];
  mean=mean/160;
  for(ncount=0;ncount<FSIZE;ncount++) var+=(noiseout[ncount]-mean)*(noiseout[ncount]-mean);
  var=var/160;
  oldvar=var;
  
  for(ncount=0;ncount<FSIZE;ncount++) noiseout[ncount]=noiseout[ncount]/sqrt(var);
  
  mean=0.0;var=0.0;
  for(ncount=0;ncount<FSIZE;ncount++) mean +=noiseout[ncount];		
  mean=mean/160;
  for(ncount=0;ncount<FSIZE;ncount++) noiseout[ncount]=noiseout[ncount]-mean;
  for(ncount=0;ncount<FSIZE;ncount++) var+=(noiseout[ncount]-mean)*(noiseout[ncount]-mean);
  var=var/160;
  newvar=var;
  
  for(ncount=0;ncount<FSIZE;ncount++){
    ENERGY_HP_NOISE+=noiseout[ncount]*noiseout[ncount];
    ENERGY_OUT_B4+=out[ncount]*out[ncount];
  }
  
  *out_prev_fr=*out;//update memory
  for(ncount=0;ncount<FSIZE;ncount++){
    noise1[ncount]=noiseout[ncount]*sqrt(((*ENERGY_TO_B_ADDED)/ENERGY_HP_NOISE));
    out[ncount]=(out[ncount]+noise1[ncount]);
    ENERGY_HP_NOISE_ADDED+=noise1[ncount]*noise1[ncount];
    ENERGY_OUT_AFTER+=out[ncount]*out[ncount];
  }
  free(noisehpfilter_mem);
}
#endif
