/**********************************************************************
Each of the companies; Motorola, and Lucent, and Qualcomm, and Nokia (hereinafter 
referred to individually as "Source" or collectively as "Sources") do 
hereby state:

To the extent to which the Source(s) may legally and freely do so, the 
Source(s), upon submission of a Contribution, grant(s) a free, 
irrevocable, non-exclusive, license to the Third Generation Partnership 
Project 2 (3GPP2) and its Organizational Partners: ARIB, CCSA, TIA, TTA, 
and TTC, under the Source's copyright or copyright license rights in the 
Contribution, to, in whole or in part, copy, make derivative works, 
perform, display and distribute the Contribution and derivative works 
thereof consistent with 3GPP2's and each Organizational Partner's 
policies and procedures, with the right to (i) sublicense the foregoing 
rights consistent with 3GPP2's and each Organizational Partner's  policies 
and procedures and (ii) copyright and sell, if applicable) in 3GPP2's name 
or each Organizational Partner's name any 3GPP2 or transposed Publication 
even though this Publication may contain the Contribution or a derivative 
work thereof.  The Contribution shall disclose any known limitations on 
the Source's rights to license as herein provided.

When a Contribution is submitted by the Source(s) to assist the 
formulating groups of 3GPP2 or any of its Organizational Partners, it 
is proposed to the Committee as a basis for discussion and is not to 
be construed as a binding proposal on the Source(s).  The Source(s) 
specifically reserve(s) the right to amend or modify the material 
contained in the Contribution. Nothing contained in the Contribution 
shall, except as herein expressly provided, be construed as conferring 
by implication, estoppel or otherwise, any license or right under (i) 
any existing or later issuing patent, whether or not the use of 
information in the document necessarily employs an invention of any 
existing or later issued patent, (ii) any copyright, (iii) any 
trademark, or (iv) any other intellectual property right.

With respect to the Software necessary for the practice of any or 
all Normative portions of the EVRC-B Variable Rate Speech Codec as 
it exists on the date of submittal of this form, should the EVRC-B be 
approved as a Specification or Report by 3GPP2, or as a transposed 
Standard by any of the 3GPP2's Organizational Partners, the Source(s) 
state(s) that a worldwide license to reproduce, use and distribute the 
Software, the license rights to which are held by the Source(s), will 
be made available to applicants under terms and conditions that are 
reasonable and non-discriminatory, which may include monetary compensation, 
and only to the extent necessary for the practice of any or all of the 
Normative portions of the EVRC-B or the field of use of practice of the 
EVRC-B Specification, Report, or Standard.  The statement contained above 
is irrevocable and shall be binding upon the Source(s).  In the event 
the rights of the Source(s) in and to copyright or copyright license 
rights subject to such commitment are assigned or transferred, the 
Source(s) shall notify the assignee or transferee of the existence of 
such commitments.
*******************************************************************/
/* Generate voiced_mode indicator */

/*** Includes ***/
#include <math.h>		/* for fabs() */
#include "macro.h"		/* for FrameSize & GUARD (look-ahead) */

/* define parameters */
#define	UV_THRESHOLD	0.5 / 11	/* 0.0454545 spacing if lsp[i] is perfectly even spaced */
#define V_THRESHOLD	0.5 / 9		/* 0.0555556 spacing if lsp[0] & lasp[N-1] stretched to outmost limit */
#define	BETA_THRESHOLD	0.3		/* dividing value if der_max falls in between */

#define	BETA_THRESHOLD1	0.3
#define	RC1_THRESHOLD	-0.4


#define VUV_DECISION_TWEAK YES
#define VUV_DECISION_TWEAK2 YES
#define VUV_DECISION_TWEAK3 YES


/*** Function ***/
short vuv_decision(float beta, float uq_lsp[])
	{

	int	i, j, k;
	short	voiced;
	float	der, der_min,der_max;
	float	dev;
	
	/*float	ww[10] = {65.0, 60.0, 55.0, 50.0, 45.0, 40.0, 35.0, 30.0, 25.0, 20.0};*/

	float	wb[10] = {120.0, 75.0, 60.0, 50.0, 45.0, 40.0, 35.0, 30.0, 25.0, 20.0};
	float	wa[10] = { 80.0, 70.0, 60.0, 55.0, 50.0, 45.0, 40.0, 35.0, 30.0, 25.0};

	/* float	wb[10] = { 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0};
	float	wa[10] = { 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0, 100.0}; */


	/************************************************
	Flatness: 
		determine the differential bwtween the largest and the smallest first order derivatives.
		Degree of bending is described by the differential of the max and min of the first order 
		derivative.
	*************************************************/
	
	for(i=1, der_min = uq_lsp[0], der_max = uq_lsp[0]; i<10; i++) {
		if((der = uq_lsp[i] - uq_lsp[i-1]) < der_min) der_min = der;
		else if(der > der_max) 			      der_max = der;
	}
	der_max -= der_min;
	
	/************************************************
	Polarized Deviation: 
		determine the average deviation from the even spacing line. lsp[i] below the even spacing 
		line contribute positively to the summation, a voiced bias. lsp[i] above the line contribute 
		negatively to the summation, an unvoiced bias 
	*************************************************/
	
	dev = 0.0;
	for(i=0; i< 10; i++) {
		der = uq_lsp[i] - 0.5 / 11.0 * (i+1);
		/**** der = uq_lsp[i] - avgBkgndLSP[i]; *****/
		if(der >= 0.0) 	     { der *= wa[i]; if (der > 0.02) der *= 1.5; der = -der * der; }
		else if(der < -0.02 && i <= 2) { der *= wb[i]*2.5; der =  der * der; }
		else 		     { der *= wb[i]; der =  der * der; }
		dev += der;
	}	
	der_max *= dev;




	/* make U/UV decision */
	if(der_max < 0.32)			voiced = 0;
	else if(der_max < 0.40 && beta < 0.27)	voiced = 0;
	else if(der_max < 1.2 && beta < 0.2)	voiced = 0;
	else					voiced = 1;


	if(beta > 0.27) voiced = 1;






/**************************************************************************************************************/
#define		OUTPUT_TEST_POINTS	0
/**************************************************************************************************************/


	return voiced;
}
