/**********************************************************************
Each of the companies; Qualcomm, Motorola, Lucent, and Nokia (hereinafter 
referred to individually as "Source" or collectively as "Sources") do 
hereby state:

To the extent to which the Source(s) may legally and freely do so, the 
Source(s), upon submission of a Contribution, grant(s) a free, 
irrevocable, non-exclusive, license to the Third Generation Partnership 
Project 2 (3GPP2) and its Organizational Partners: ARIB, CCSA, TIA, TTA, 
and TTC, under the Source's copyright or copyright license rights in the 
Contribution, to, in whole or in part, copy, make derivative works, 
perform, display and distribute the Contribution and derivative works 
thereof consistent with 3GPP2's and each Organizational Partner's 
policies and procedures, with the right to (i) sublicense the foregoing 
rights consistent with 3GPP2's and each Organizational Partner's  policies 
and procedures and (ii) copyright and sell, if applicable) in 3GPP2's name 
or each Organizational Partner's name any 3GPP2 or transposed Publication 
even though this Publication may contain the Contribution or a derivative 
work thereof.  The Contribution shall disclose any known limitations on 
the Source's rights to license as herein provided.

When a Contribution is submitted by the Source(s) to assist the 
formulating groups of 3GPP2 or any of its Organizational Partners, it 
is proposed to the Committee as a basis for discussion and is not to 
be construed as a binding proposal on the Source(s).  The Source(s) 
specifically reserve(s) the right to amend or modify the material 
contained in the Contribution. Nothing contained in the Contribution 
shall, except as herein expressly provided, be construed as conferring 
by implication, estoppel or otherwise, any license or right under (i) 
any existing or later issuing patent, whether or not the use of 
information in the document necessarily employs an invention of any 
existing or later issued patent, (ii) any copyright, (iii) any 
trademark, or (iv) any other intellectual property right.

With respect to the Software necessary for the practice of any or 
all Normative portions of the EVRC-WB Variable Rate Speech Codec as 
it exists on the date of submittal of this form, should the EVRC-WB be 
approved as a Specification or Report by 3GPP2, or as a transposed 
Standard by any of the 3GPP2's Organizational Partners, the Source(s) 
state(s) that a worldwide license to reproduce, use and distribute the 
Software, the license rights to which are held by the Source(s), will 
be made available to applicants under terms and conditions that are 
reasonable and non-discriminatory, which may include monetary compensation, 
and only to the extent necessary for the practice of any or all of the 
Normative portions of the EVRC-WB or the field of use of practice of the 
EVRC-WB Specification, Report, or Standard.  The statement contained above 
is irrevocable and shall be binding upon the Source(s).  In the event 
the rights of the Source(s) in and to copyright or copyright license 
rights subject to such commitment are assigned or transferred, the 
Source(s) shall notify the assignee or transferee of the existence of 
such commitments.
*******************************************************************/

/*======================================================================*/
/*  4GV - Fourth Generation Vocoder Speech Service Option for             */
/*  Wideband Spread Spectrum Digital System                             */
/*  C Source Code Simulation                                            */
/*                                                                      */
/*  Copyright (C) 1999 Qualcomm Incorporated. All rights                */
/*  reserved.                                                           */
/*----------------------------------------------------------------------*/

#include "struct.h"
#include "filt.h"

#include <stdio.h>
#include <stdlib.h>


//extern EvrcArgs *Eargs;

//extern int16 ibuf_len;

//void clearBitTotal ();
void printBitTotal ();


void
FGV_MEM::WB_encoder ()
{
    int k;
    MODE m;
    float R[17];

    char operSwitch;

   

    
   /* This flag is used to initialize wideband specific filters when operating point switches
   Music mode initialization depends on the celp_mdct_flag */
    if (Eargs->operating_point== 3 && prev_frame_op < 3) OPSwitchFlag=1;
    else OPSwitchFlag=0;

    if (Eargs->avg_rate_control) {
        if (Eargs->avg_rate_target > 7.5)
            Eargs->operating_point = 0;
        else if (Eargs->avg_rate_target > 6.6)
            Eargs->operating_point = 1;
        else if (Eargs->avg_rate_target > 5.7)
            Eargs->operating_point = 2;

	if (Eargs->avg_rate_target == (float) 4.8) {
	    Eargs->operating_point =0;  
	    Eargs->max_rate=3; 
	}
    }

    if (Eargs->operatingpoint_file != NULL) {
        short tmpx=0,tc=0;

        tc=fread (&tmpx, sizeof(short), 1, Eargs->operatingpoint_file);

        if (tc!=0) {

            if (tmpx==6) {
                Eargs->operating_point =0;Eargs->max_rate=3;
            } else {
                Eargs->operating_point =tmpx;Eargs->max_rate=4;
            }
            operatingpoint_backup = Eargs->operating_point;
        }else{
            if(WB_encoder_first_time==1){
                fprintf (stderr,"Operating Point File is Empty.\n");
                exit (-1);
            }

        }

    } else {
        if (WB_encoder_first_time ==1)
            operatingpoint_backup = Eargs->operating_point;
    }

     
    Eargs->operating_point=operatingpoint_backup;

	       // every frame
    switch (Eargs->operating_point) {
    case 0:                            //allowed in SO 68 and 70. FCELP_171/HCELP/NB_SIL used
        data_packet.WB_MODE_BIT=0;     // 16K Fsinp allowed which will be downsamped.
//        fullrate_coding_method=0;     
        break;

    case 1:                            //allowed only in SO 68. FCELP_171/HCELP/QNELP/QPPP/NB_SIL modes 
        data_packet.WB_MODE_BIT=0;     // used. 16K Fsinp allowed which will be downsampled
	//      fullrate_coding_method=0;
        break;

    case 2:                           
        data_packet.WB_MODE_BIT=0;     //allowed only in SO 68. FCELP_171/HCELP/QNELP/QPPP/FPPP/NB_SIL modes
//        fullrate_coding_method=0;      // used. 16K Fsinp allowed which will be downsampled
        break;

    case 3:
        if(Eargs->Fsinp == 8000){      //allowed only in SO 70. WB+ FCELP_153/HNELP/WB_SIL modes used.
            data_packet.WB_MODE_BIT=0; // 8K Fsinp not allowed. If Fsinp=8K, then OP0 encoding will be done
            Eargs->operating_point=0;  // because the upperband cannot carry zero energy signal.
        }else
            data_packet.WB_MODE_BIT=1;
        //fullrate_coding_method=0;
        break;

/*
    case 4:                            //allowed only in SO 70.
        if(Eargs->Fsinp == 16000){     // WB+ FCELP_153/MDCT_23/HNELP/WB_SIL modes used.
            data_packet.WB_MODE_BIT=1;
	    Eargs->operating_point=3;
            MDCT_NPULSES = 23;	
            MDCT_NWORDS = 8;	       // 23 pulses on 144 position = 114 bits => 7*15 bits + 9 bits 
            MDCT_REMAINDER = 9;
        }
        else{                          //  FCELP_171/MDCT_28/HCELP/NB_SIL modes used.
            data_packet.WB_MODE_BIT=0;
	    Eargs->operating_point=0;
            MDCT_NPULSES = 28;	
            MDCT_NWORDS = 9;	       // 28 pulses on 144 position = 131 bits => 8*15 bits + 11 bits 
            MDCT_REMAINDER = 11;
        }
        fullrate_coding_method=2;
        break;

    case 5:                            //allowed only in SO 70.
        if(Eargs->Fsinp == 16000){     // WB+ MDCT_23/HNELP/WB_SIL modes used.
            data_packet.WB_MODE_BIT=1;
	    Eargs->operating_point=3;
            MDCT_NPULSES = 23;	
            MDCT_NWORDS = 8;	       // 23 pulses on 144 position = 114 bits => 7*15 bits + 9 bits 
            MDCT_REMAINDER = 9;
        }
        else{                          // MDCT_28/HCELP/NB_SIL modes used.
            data_packet.WB_MODE_BIT=0;
	    Eargs->operating_point=0;
            MDCT_NPULSES = 28;	
            MDCT_NWORDS = 9;	       // 28 pulses on 144 position = 131 bits => 8*15 bits + 11 bits 
            MDCT_REMAINDER = 11;
        }
        fullrate_coding_method=1;
        break;
*/
 

    }


    if (Eargs->fullrate_coding_method == MDCT_ALLFR || Eargs->fullrate_coding_method == MDCT_AUTODET) {
        if(Eargs->Fsinp == 16000){     // WB+ MDCT_23/HNELP/WB_SIL modes used.
            data_packet.WB_MODE_BIT=1;
	    Eargs->avg_rate_control = 0; 
	    Eargs->operating_point=3;
            MDCT_NPULSES = 23;	
            MDCT_NWORDS = 8;	       // 23 pulses on 144 position = 114 bits => 7*15 bits + 9 bits 
            MDCT_REMAINDER = 9;
        }
        else{                          // MDCT_28/HCELP/NB_SIL modes used.
            data_packet.WB_MODE_BIT=0;
	    Eargs->avg_rate_control = 0;
	    Eargs->operating_point=0;
            MDCT_NPULSES = 28;	
            MDCT_NWORDS = 9;	       // 28 pulses on 144 position = 131 bits => 8*15 bits + 11 bits 
            MDCT_REMAINDER = 11;
        }
    }
























































    if (WB_encoder_first_time == 1){
	if(Eargs->Fsinp == 16000){
          /* initialize filter banks */	
 	  filterbank_init_ana_lb (&S_ana_lb);
	  filterbank_init_ana_hb (&S_ana_hb);
	}
	for (k = 0; k < 17; k++)
	    R[k] = 0.0;
	WB_encoder_first_time = 0;
    }















    if (Eargs->Fsinp == 16000) {

	for (k = 0; k < 2 * ibuf_len; k++)
	    buf_float[k] = (float) buf16[k];

      /*=====================================================================*/
      /*        ..Hi-Level limiter AGC                                       */
      /*---------------------------------------------------------------------*/

#define THR_1 82		// RMS threshold, approx 10*log10(16000.0*16000.0)
#define THR_2 87		// PEAK threshold, approx 10*log10(32767.0*32767.0)
#define MIN_AGC_GAIN 0.707
#define AGC_SM_FAC 0.999f

	{
	    int j;
	    float peak = 0;
	    float rms = 0;
	    float xt, p2rms = 0;
	    //static float agc = 1.0;

	    peak = buf_float[0] * buf_float[0];
	    rms = peak;
	    for (j = 1; j < 2 * ibuf_len; j++) {
		xt = buf_float[j] * buf_float[j];
		if (xt > peak) {
		    peak = xt;
		}
		rms += xt;
	    }
	    rms *= 1.0 / (2 * ibuf_len);

	    peak = 10.0 * log10 (peak);
	    rms = 10.0 * log10 (rms);
	    p2rms = peak - rms;
	    if (peak > THR_2 && rms > THR_1) {
		agc1 = MIN_AGC_GAIN;
	    }
	    else {
		agc1 *= 1.1;
	    }
	    agc1 = Min (1.0, Max (MIN_AGC_GAIN, agc1));


	    //static float agc_sm = 1.0;

	    static float agc_filt_num_coef[3] = {
		0.000009825916820471736201625390094704926013946533203125,
		0.000019651833640943472403250780189409852027893066406250,
		0.000009825916820471736201625390094704926013946533203125
	    };

	    static float agc_filt_den_coef[3] = {
		1.000000000000000000000000000000000000000000000000000000,
		-1.991114292201653590552723471773788332939147949218750000,
		0.991153595868935477497529973334167152643203735351562500
	    };
	    //static double agc_lpfmem[2];
	    POLEZERO_FILTER agc_filt = { 2, 2, 2, 0, agc_lpfmem };

	    for (j = 0; j < 2 * ibuf_len; j++) {
	      polezero_filter (&agc1, &agc_sm, 1, agc_filt_num_coef,
			       agc_filt_den_coef, agc_filt);
	      buf_float[j] *= agc_sm;
	    }
	}



      /*=====================================================================*/
      /*        ..Hi-pass filter with 50 Hz Cheby II.                        */
      /*---------------------------------------------------------------------*/

	if (Eargs->highpass_filter)
	    hpf80 (buf_float, buf_float, &hpfmem, 2 * ibuf_len);

	/*=====================================================================*/
	/*        ..Noise suppression on 10ms buffer.                          */
	/*---------------------------------------------------------------------*/
	if (Eargs->noise_suppression) {
	    noise_suprs (buf_float, next_ns_snr[0]);
	    noise_suprs (buf_float + ibuf_len, next_ns_snr[1]);
	}

	if (Eargs->noise_suppression) {

	    /* low-band analysis filter */
	    filterbank_ana_lb (buf + LOOKAHEAD_LEN - DELAY / 2, buf_float,
			       2 * ibuf_len, &S_ana_lb);
	    STATE_ANA_LB S_ana_lb_TMP = S_ana_lb;	// Save LB filter state

	    filterbank_ana_lb (buf + LOOKAHEAD_LEN - DELAY / 2 + ibuf_len,
			       buf_float + 2 * ibuf_len, DELAY, &S_ana_lb);
	    S_ana_lb = S_ana_lb_TMP;	// Restore LB filter state


	    /* high-band analysis filter */
	    filterbank_ana_hb (buf_HB + (LOOKAHEAD_LEN - DELAY / 2) * 7 / 8 +
			       hb_ana_delay,
			       buf_WB14 + (LOOKAHEAD_LEN -
					   DELAY / 2) * 7 / 4 +
			       hb_ana_delay * 2, buf_float, 2 * ibuf_len,
			       &S_ana_hb);
	    STATE_ANA_HB S_ana_hb_TMP = S_ana_hb;	// Save HB filter state

	    filterbank_ana_hb (buf_HB + (LOOKAHEAD_LEN - DELAY / 2) * 7 / 8 +
			       hb_ana_delay + ibuf_len * 7 / 8,
			       buf_WB14 + (LOOKAHEAD_LEN -
					   DELAY / 2) * 7 / 4 +
			       hb_ana_delay * 2 + ibuf_len * 7 / 4,
			       buf_float + 2 * ibuf_len, DELAY, &S_ana_hb);
	    S_ana_hb = S_ana_hb_TMP;	// Restore HB filter state

	}
	else {

	    /* low-band analysis filter */
	    filterbank_ana_lb (buf + LOOKAHEAD_LEN, buf_float, 2 * ibuf_len,
			       &S_ana_lb);

	    /* high-band analysis filter */
	    filterbank_ana_hb (buf_HB + LOOKAHEAD_LEN * 7 / 8 + hb_ana_delay,
			       buf_WB14 + LOOKAHEAD_LEN * 7 / 4 +
			       hb_ana_delay * 2, buf_float, 2 * ibuf_len,
			       &S_ana_hb);
	}

	for (k = 0; k < SPEECH_BUFFER_LEN + LOOKAHEAD_LEN; k++) {
	  buf_backup[k] = buf[k];
	}

    }				// above code applicable only to wideband
    else {

      /*=====================================================================*/
      /*        ..Hi-pass filter with 80 Hz Cheby II.                        */
      /*---------------------------------------------------------------------*/

	if (Eargs->highpass_filter) {
	    hpf80_8k (buf + LOOKAHEAD_LEN, buf + LOOKAHEAD_LEN, &hpfmem8k,
		      SPEECH_BUFFER_LEN);
	}

	/*=====================================================================*/
	/*        ..Noise suppression on 10ms buffer.                          */
	/*---------------------------------------------------------------------*/
	if (Eargs->noise_suppression) {
	    noise_suprs_8k (buf + LOOKAHEAD_LEN, next_ns_snr[0]);
	    noise_suprs_8k (buf + LOOKAHEAD_LEN + ibuf_len / 2,
			    next_ns_snr[1]);
	}

    }


    pre_encode (buf, R);


    if (data_packet.WB_MODE_BIT == 1) {
	/* Use either vad decision from nsvad() or EVRC rate selection: */
	/* WB lpc analysis; to be shared with 8th rate encoder */

	float HBnrg;

	HBnrg = 0.0;
	for (k = 0; k < 140; k++)
	    HBnrg +=
		buf_HB[LOOKAHEAD_LEN * 7 / 8 + HB_ANA_DELAY_NS_LB +
		       k] * buf_HB[LOOKAHEAD_LEN * 7 / 8 +
				   HB_ANA_DELAY_NS_LB + k];
	HBnrg /= 16.0;		// scaling

	select_rate (R, Eargs->max_rate, Eargs->min_rate, beta, HBnrg);

    }
    else {			//narrowband case

	select_rate (R, Eargs->max_rate, Eargs->min_rate, beta, 0);


    }

		m = new_mode_decision (buf,buf_HB);

    clearBitTotal ();


    
    if (!Eargs->olr_calibration)
	encode (rate, buf16);

    if (data_packet.WB_MODE_BIT == 1) {
     UB_enc ();
    }

    lastrateE = bit_rate;

    prev_frame_op = Eargs->operating_point;


    printBitTotal ();

    if (data_packet.WB_MODE_BIT == 1) {
	if (rate == 2)
	    rate = 3;
	if (data_packet.PACKET_RATE == 2)
	    data_packet.PACKET_RATE = 3;
    }
    

    update_average_rate (data_packet.PACKET_RATE);




    /* update buf, buf_HB, buf */
    for (k = 0; k < LOOKAHEAD_LEN; k++)
         buf[k] =  buf[k + FSIZE];
    for (k = 0; k < LOOKAHEAD_LEN; k++)
         buf_backup[k] =  buf_backup[k + FSIZE];


    /* copy back the de-clicked input for buf_HB update */
    for (k = 0; k <  hb_ana_delay; k++)
         buf_HB[k] =  buf_HB[7 * ibuf_len / 8 + k];
    /* copy back the un-de-clicked input for buf_HB update */
    for (k = 0; k < LOOKAHEAD_LEN * 7 / 8; k++)
         buf_HB[k +  hb_ana_delay] = lookahead_UB[k];

    /* shifting the 14K buf , not modified by de-click */
    for (k = 0; k < LOOKAHEAD_LEN * 7 / 4 +  hb_ana_delay * 2;  k++)
         buf_WB14[k] =  buf_WB14[7 * ibuf_len / 4 + k];


    if (Eargs->joint_source_modem_dtx) {
	if (data_packet.PACKET_RATE == 0) {
	    data_packet.PACKET_RATE = JSM_DTX_RATE;
	    buf16[0] = eighth_rate_bits_save;
	}
    }


}
