
static char const rcsid[]="$Id: //E-XMS/GIT/csa/Utilities/cpp/RtpCodecUtil/evrc_nw/gs_olpitch.cpp#1 $";

/************************************************************************
* Routine name: gs_fndppf                                                  *
* Function: forward pitch predictor.									*
* Inputs:   buf    - data buffer.                                       *
* Outputs:  delay  - predicted delay.                                   *
*           beta   - gain value.                                        *
*                                                                       *
************************************************************************/
#include "macro.h"
#include "defines.h"
#include "struct.h"

void FGV_MEM::gs_fndppf(float *delay,float *beta, float *buf)
{
  int i,j,lag,oll_temp;
  float *ptr;
  double corr[2][LAGRANGE/SUBSAMP];
  double Eyy[(MAXLAG_PPP+1)/SUBSAMP];
  double Exy[LAGRANGE/SUBSAMP];
  double *Exyptr;
  double max,m;
  double rightmax[LAGRANGE/SUBSAMP];
  double maxcorr[LAGRANGE];
  static float decim_filt[DECIM_FILTER_LENGTH]={
	0.0800,0.1256,0.2532,0.4376,0.6424,0.8268,0.9544,1.000,0.9544,0.8268,
	0.6424,0.4376,0.2532,0.1256,0.0800
      };
  static int FAN[LAGRANGE/SUBSAMP][2]={
	{0,2},{0,3},{2,2},{2,3},{2,4},{3,4},{4,4},{5,4},{5,5},{6,5},{7,5},
	{8,6},{9,6},{10,6},{11,6},{11,7},{12,7},{13,7},{14,8},{15,8},{16,8},
	{16,9},{17,9},{18,9},{19,9},{20,10},{21,10},{22,10},{22,11},{23,11},
	{24,11},{25,12},{26,12},{27,12},{28,12},{28,13},{29,13},{30,13},
	{31,14},{32,14},{33,14},{33,15},{34,15},{35,15},{36,15},{37,16},
	{38,16},{39,16},{39,17},{40,17},{41,16},{42,16},{43,15},{44,14},
	{45,13},{45,13},{46,12},{47,11}
      };
  
  /*static int FAN[LAGRANGE/SUBSAMP][2]={
	{0,2},{0,3},{2,2},{2,3},{2,4},{3,4},{4,4},{5,4},{5,5},{6,5},{7,5},
	{8,6},{9,6},{10,6},{11,6},{11,7},{12,7},{13,7},{14,8},{15,8},{16,8},
	{16,9},{17,9},{18,9},{19,9},{20,10},{21,10},{22,10},{22,11},{23,11},
	{24,11},{25,12},{26,12},{27,12},{28,12},{28,13},{29,13},{30,13},
	{31,14},{32,14},{33,14},{33,15},{34,15},{35,15},{36,15},{37,16},
	{38,16},{39,16},{39,17},{40,17},{41,17},{42,17},{43,18},{44,18},
	{45,18},{46,18},{47,17},{48,16},{49,15},{50,14},{51,13},{52,12},
	{53,11},{54,10}};*/
	
	
	//{41,16},{42,16},{43,15},{44,14},
	//{45,13},{45,13},{46,12},{47,11}
    //  };
  static float PREV_NACF_THRESH_FOR_OLP_SEARCH=0.84;
  /* init static variables (should be in init routine for implementation) */
  if (fndppf_FirstTime) {
    fndppf_FirstTime = 0;
    for (i=0;i<DECIM_FILTER_LENGTH-1;i++) decimate_mem[i] = 0.0;
    for (i=0;i<(MAXLAG_PPP+1)/SUBSAMP;i++) gslpfr[i] = 0.0;
    for (i=0;i<LAGRANGE/SUBSAMP;i++)for (j=0;j<2;j++) prev_corr[j][i]= 0.0;
	prev_oll = MINLAG_PPP;
	prev_nacf = 0;
  }
   // Decimate the Residual of Next Frame
      for (i=0;i<DECIM_FILTER_LENGTH-1;i++) decim_buf[i]=decimate_mem[i];
      for(i=0;i<FSIZE;i++)decim_buf[i+DECIM_FILTER_LENGTH-1]=buf[i];
      ptr=gslpfr+(MAXLAG_PPP+1)/SUBSAMP;
      for (i=0;i<FSIZE/SUBSAMP;i++) {
	   ptr[i]=0.0;
	   for (j=0;j<DECIM_FILTER_LENGTH;j++)
	   ptr[i]+=decim_buf[j+SUBSAMP*i]*decim_filt[j];
      }
      for (i=0;i<DECIM_FILTER_LENGTH-1;i++)
	   decimate_mem[i]=decim_buf[i+FSIZE];
    // Compute NACFs for all lags for two subframes
    {// First Subframe
	ptr=gslpfr+(MAXLAG_PPP+1)/SUBSAMP;
	Eyy[0]=0.0;for (i=0;i<FSIZE/2/SUBSAMP;i++) Eyy[0]+=SQR(ptr[i]);
	for (i=1;i<(MAXLAG_PPP+1)/SUBSAMP;i++,ptr--){
	  Eyy[i]=Eyy[i-1]+SQR(ptr[-1])-SQR(ptr[FSIZE/2/SUBSAMP-1]);
	}
	ptr=gslpfr+(MAXLAG_PPP+1)/SUBSAMP;
	Exyptr=Exy;
	for (i=MINLAG_TRK/SUBSAMP;i<(MAXLAG_PPP+1)/SUBSAMP;i++) {
	  *Exyptr=0.0;
	  for (j=0;j<FSIZE/2/SUBSAMP;j++) *Exyptr+=ptr[j]*(*(ptr-i+j));
	  Exyptr++;
	}
	
	Eyy[0]=((Eyy[0]==0.0)?1.0:Eyy[0]);
	for (i=0,j=MINLAG_TRK/SUBSAMP;i<LAGRANGE/SUBSAMP;i++,j++) {
	  Eyy[j]=((Eyy[j]==0.0)?1.0:Eyy[j]);
	  corr[0][i]=SIGN(Exy[i])*SQR(Exy[i])/Eyy[0]/Eyy[j];
	}
      }// End First Subframe
      {// Second Subframe
	ptr=gslpfr+(MAXLAG_PPP+1)/SUBSAMP+FSIZE/2/SUBSAMP;
	Eyy[0]=0.0;for (i=0;i<FSIZE/SUBSAMP/2;i++) Eyy[0]+=SQR(ptr[i]);    
	for (i=1;i<(MAXLAG_PPP+1)/SUBSAMP;i++,ptr--)
	  Eyy[i]=Eyy[i-1]+SQR(ptr[-1])-SQR(ptr[FSIZE/2/SUBSAMP-1]);
	
	ptr=gslpfr+(MAXLAG_PPP+1)/SUBSAMP+FSIZE/2/SUBSAMP;
	Exyptr=Exy;
	for (i=MINLAG_TRK/SUBSAMP;i<(MAXLAG_PPP+1)/SUBSAMP;i++) {
	  *Exyptr=0.0;
	  for (j=0;j<FSIZE/2/SUBSAMP;j++) *Exyptr+=ptr[j]*(*(ptr-i+j));
	  Exyptr++;
	}
	
	Eyy[0]=((Eyy[0]==0.0)?1.0:Eyy[0]);
	for (i=0,j=MINLAG_TRK/SUBSAMP;i<LAGRANGE/SUBSAMP;i++,j++) {
	  Eyy[j]=((Eyy[j]==0.0)?1.0:Eyy[j]);
	  corr[1][i]=SIGN(Exy[i])*SQR(Exy[i])/Eyy[0]/Eyy[j];
	}
      }// End Second Subframe
    // End Compute NACFs for all lags
    {// Pitch Track

      for (i=0;i<LAGRANGE/SUBSAMP;i++) {
	for (j=0,max=0.0;j<FAN[i][1];j++) max=MAX(max,corr[1][j+FAN[i][0]]);
	rightmax[i]=corr[0][i]+max;
      }
      for (i=0;i<LAGRANGE/SUBSAMP;i++) {
	for (j=0,max=0.0;j<FAN[i][1];j++) max=MAX(max,rightmax[j+FAN[i][0]]);
	maxcorr[SUBSAMP*i]=prev_corr[1][i]+max;
      }
      for (i=0;i<LAGRANGE/SUBSAMP;i++) {
	for (j=0,max=0.0;j<FAN[i][1];j++) max=MAX(max,prev_corr[0][j+FAN[i][0]]);
	maxcorr[SUBSAMP*i]+=max;
      }
      static double corr_filt[4]={-0.0625,0.5625,0.5625,-0.0625};
      {// Interpolate maxcorr to get values at odd positions, SUBSAMP=2 assumed
	for (i=1;i<LAGRANGE/2-2;i++) {
	  maxcorr[2*i+1]=0.0;
	  for (j=0;j<4;j++) maxcorr[2*i+1]+=corr_filt[j]*maxcorr[2*(i-1+j)];
	}
	maxcorr[1]=(maxcorr[0]+maxcorr[2])/2;
	maxcorr[LAGRANGE-3]=(maxcorr[LAGRANGE-4]+maxcorr[LAGRANGE-2])/2;
	maxcorr[LAGRANGE-1]=maxcorr[LAGRANGE-2];
      }// End Interp maxcorr
      for (i=MINLAG_PPP-MINLAG_TRK,max=0.0,oll=MINLAG_PPP;i<LAGRANGE;i++)
	if (max<maxcorr[i]) {max=maxcorr[i];oll=i+MINLAG_TRK;}

      {// New Stuff - Interpolate prev_corr[1] also
	/*extern double secsfcorr[LAGRANGE];
	for (i=1;i<LAGRANGE/2-2;i++) {
	  secsfcorr[2*i]=prev_corr[1][i];
	  secsfcorr[2*i+1]=0.0;
	  for (j=0;j<4;j++) secsfcorr[2*i+1]+=corr_filt[j]*prev_corr[1][i-1+j];
	}
	secsfcorr[1]=((secsfcorr[0]=prev_corr[1][0])+secsfcorr[2])/2;
	secsfcorr[LAGRANGE-4]=prev_corr[1][LAGRANGE/2-2];
	secsfcorr[LAGRANGE-2]=prev_corr[1][LAGRANGE/2-1];
	secsfcorr[LAGRANGE-3]=(secsfcorr[LAGRANGE-4]+secsfcorr[LAGRANGE-2])/2;
	secsfcorr[LAGRANGE-1]=secsfcorr[LAGRANGE-2];*/
      }// End New Stuff - Interpolate prev_corr[1] also

      nacf=max/4.0;
      {// Check for Pitch Lag submultiples to remove doubles, triples, etc.
	// No Pitch Lag multiples since Higher Harmonics have been Filtered out
	i=1;
	lag=oll;
	m=max;
	if (m>=3.0) m*=1.1;
	while ((int)((lag*1.)/++i)>=MINLAG_PPP) {
	  max=0.9*m;
	  for(j=MAX(MINLAG_PPP,(int)(lag*1./i)-2);j<=(int)(lag*1./i)+2;j++)
	    if(max<=maxcorr[j-MINLAG_TRK]){max=maxcorr[j-MINLAG_TRK];oll=j;}
	}
	oll_temp=oll;
	if (oll/2>=MINLAG_PPP && oll>=1.9*prev_oll-10) {
	  if (prev_nacf>=PREV_NACF_THRESH_FOR_OLP_SEARCH) oll_temp=oll/2;
	}
	if (oll/3>=MINLAG_PPP && oll>=2.9*prev_oll-10) {
	  if (prev_nacf>=PREV_NACF_THRESH_FOR_OLP_SEARCH) oll_temp=oll/3;
	}
	if (oll/4>=MINLAG_PPP && oll>=3.9*prev_oll-10) {
	  if (prev_nacf>=PREV_NACF_THRESH_FOR_OLP_SEARCH) oll_temp=oll/4;
	}
	if (oll/5>=MINLAG_PPP && oll>=4.9*prev_oll-10) {
	  if (prev_nacf>=PREV_NACF_THRESH_FOR_OLP_SEARCH) oll_temp=oll/5;
	}
	oll=oll_temp;

      }// End Pitch Lag Submultiple check

    }// End Pitch Track
	prev_nacf = nacf;
	prev_oll = oll;
    for (i=0;i<(MAXLAG_PPP+1)/SUBSAMP;i++) gslpfr[i]=gslpfr[i+FSIZE/SUBSAMP];
    for (i=0;i<LAGRANGE/SUBSAMP;i++)for (j=0;j<2;j++) prev_corr[j][i]=corr[j][i];
	*delay = (float) oll;
	*beta = nacf;
  }

