#include "struct.h"
#include <cstring>

using namespace std;

/****************************************************************************
* Routine name: init_eargs                                                  *
* Function: Initialization of eargs                                         *
****************************************************************************/
void init_eargs(
    EvrcArgs *eargs /* i/o: EvrcArgs struct to configure the codec */
    )
{
    /* 
     * Some of the following parameters are inconsequential when codec
     * API is used. These parameters can be set as anything; 
     * 
     * Some others is for debug purpose only. They can't be changed when used
     * via APIs
     */

    eargs->input_filename = NULL;
    eargs->output_filename = NULL;
    eargs->max_rate = 4;
    eargs->max_rate_default = 1;
    eargs->min_rate = 1;
    eargs->min_rate_default = 1;
    eargs->post_filter = 1;
    eargs->post_filter_default = 1;
    eargs->noise_suppression = 1;
    eargs->noise_suppression_default = 1;
    eargs->highpass_filter = 1;
    eargs->olr_calibration = 0;
    eargs->fullrate_coding_method = NO_MDCT;
    eargs->unquantized_lsp = 0;
    eargs->partial_file_processing = 0;
    eargs->starting_frame_num = 0;
    eargs->num_frames = 0;
    eargs->form_res_out = 0;
    eargs->qform_res_out = 0;
    eargs->mform_res_out = 0;
    eargs->target_speech_out = 0;
    eargs->rate_out = 0;
    eargs->lag_out = 0;
    eargs->nacf_out = 0;
    eargs->unquantized_prototype = 0;
    eargs->unquantized_zero_rate = 0;
    eargs->unquantized_quarter_rate = 0;
    eargs->unquantized_half_rate = 0;
    eargs->unquantized_full_rate = 0;
    eargs->rfileP = NULL;
    eargs->packet_out = 0;
    eargs->vad_out = 0;
    eargs->forced_count = 0;
    eargs->accshift_out = 0;
    eargs->avg_rate_target = 5.3;
    eargs->avg_rate_control = 0;
    eargs->PPP_to_CELP_threshold = -150.0;
    eargs->ratewin = 600;
    eargs->write_accshift = 0;
    eargs->Fsop = 16000;
    eargs->Fsinp = 16000;
    eargs->operating_point = 3;
    eargs->operatingpoint_file = NULL;
    strcpy (eargs->pattern, "QQF");
    eargs->erasure_file = NULL;
    eargs->signalling_file = NULL;
    eargs->verbose = NO;
    eargs->dtx = 0;
    eargs->time_warping = 0;
    eargs->phase_matching = 0;
    eargs->double_erasures_pm = 0;
	eargs->ENC_FOURGV_2KBPSMODE =0;
	eargs->DEC_FOURGV_2KBPSMODE =0;
}

void FGV_MEM::init_config(EvrcArgs *Eargs_in)
{
    Eargs = &CodecConfiguration;
    *Eargs = *Eargs_in;
}


void FGV_MEM::set_operating_point(int OP)
{
    Eargs->operating_point = OP;
    operatingpoint_backup = OP;
}
