/**********************************************************************
Each of the companies; Qualcomm, Motorola, Lucent, and Nokia (hereinafter 
referred to individually as "Source" or collectively as "Sources") do 
hereby state:

To the extent to which the Source(s) may legally and freely do so, the 
Source(s), upon submission of a Contribution, grant(s) a free, 
irrevocable, non-exclusive, license to the Third Generation Partnership 
Project 2 (3GPP2) and its Organizational Partners: ARIB, CCSA, TIA, TTA, 
and TTC, under the Source's copyright or copyright license rights in the 
Contribution, to, in whole or in part, copy, make derivative works, 
perform, display and distribute the Contribution and derivative works 
thereof consistent with 3GPP2's and each Organizational Partner's 
policies and procedures, with the right to (i) sublicense the foregoing 
rights consistent with 3GPP2's and each Organizational Partner's  policies 
and procedures and (ii) copyright and sell, if applicable) in 3GPP2's name 
or each Organizational Partner's name any 3GPP2 or transposed Publication 
even though this Publication may contain the Contribution or a derivative 
work thereof.  The Contribution shall disclose any known limitations on 
the Source's rights to license as herein provided.

When a Contribution is submitted by the Source(s) to assist the 
formulating groups of 3GPP2 or any of its Organizational Partners, it 
is proposed to the Committee as a basis for discussion and is not to 
be construed as a binding proposal on the Source(s).  The Source(s) 
specifically reserve(s) the right to amend or modify the material 
contained in the Contribution. Nothing contained in the Contribution 
shall, except as herein expressly provided, be construed as conferring 
by implication, estoppel or otherwise, any license or right under (i) 
any existing or later issuing patent, whether or not the use of 
information in the document necessarily employs an invention of any 
existing or later issued patent, (ii) any copyright, (iii) any 
trademark, or (iv) any other intellectual property right.

With respect to the Software necessary for the practice of any or 
all Normative portions of the EVRC-WB Variable Rate Speech Codec as 
it exists on the date of submittal of this form, should the EVRC-WB be 
approved as a Specification or Report by 3GPP2, or as a transposed 
Standard by any of the 3GPP2's Organizational Partners, the Source(s) 
state(s) that a worldwide license to reproduce, use and distribute the 
Software, the license rights to which are held by the Source(s), will 
be made available to applicants under terms and conditions that are 
reasonable and non-discriminatory, which may include monetary compensation, 
and only to the extent necessary for the practice of any or all of the 
Normative portions of the EVRC-WB or the field of use of practice of the 
EVRC-WB Specification, Report, or Standard.  The statement contained above 
is irrevocable and shall be binding upon the Source(s).  In the event 
the rights of the Source(s) in and to copyright or copyright license 
rights subject to such commitment are assigned or transferred, the 
Source(s) shall notify the assignee or transferee of the existence of 
such commitments.
*******************************************************************/

static char const rcsid[] =
    "$Id: //E-XMS/GIT/csa/Utilities/cpp/RtpCodecUtil/evrc_nw/lspq.cpp#1 $";

/*======================================================================*/
/*  4GV - Fourth Generation Vocoder Speech Service Option for             */
/*  Wideband Spread Spectrum Digital System                             */
/*  C Source Code Simulation                                            */
/*                                                                      */
/*  Copyright (C) 1999 Qualcomm Incorporated. All rights                */
/*  reserved.                                                           */
/*----------------------------------------------------------------------*/

#include <stdio.h>


#ifndef WIN32
#include <unistd.h>
#endif


#include <iostream>



#include "macro.h"

#include "defines.h"
#include "struct.h"

#define K 8
#define VECDIM 10
//#define INFINITY 1e30

#define VECDIMa_NEW 6
#define VECDIMb_NEW 4
#define VECSIZEa_NEW 1024
#define VECSIZEb_NEW 64
#define VECSIZEa_NEW_2KBPS 256
#define VECSIZEb_NEW_2KBPS 32

//extern EvrcArgs *Eargs;

/* 16-bit MA LSP VQ for voiced speech */
static float cba_new_2kbps[VECSIZEa_NEW_2KBPS][VECDIMa_NEW] = {
/*{ 4.656583e-03, 2.178628e-03, -7.175362e-03, 3.692405e-03, 3.505833e-03, 3.240666e-02, },
{ -3.125811e-03, -1.245738e-02, -1.895206e-02, 4.865245e-02, 6.350140e-02, 8.644621e-02, },
{ 2.338789e-03, 4.135035e-03, 1.047193e-02, 4.841845e-02, 5.834698e-02, 5.521444e-02, },
{ 3.397825e-03, 2.235511e-03, 3.522212e-02, 6.110838e-02, 7.210428e-02, 8.954305e-02, },
{ 9.715016e-05, -2.261229e-03, 7.205341e-03, 2.382006e-02, 6.877743e-02, 7.042778e-02, },
{ 6.535736e-03, 8.913721e-03, 1.683841e-02, 3.733132e-02, 9.428644e-02, 1.028344e-01, },
{ 7.529092e-03, 1.195302e-02, 1.649473e-02, 5.434935e-02, 6.849888e-02, 7.886247e-02, },
{ 6.931857e-03, 9.559441e-03, 3.467353e-02, 8.363854e-02, 8.403447e-02, 9.457983e-02, },
{ 1.224281e-02, 1.739701e-02, 1.000492e-02, 1.655513e-02, 1.509268e-02, 2.009561e-02, },
{ 4.433424e-03, 3.593587e-03, 2.172021e-02, 2.275189e-02, 7.823963e-02, 9.324832e-02, },
{ 9.189884e-03, 1.466332e-02, 3.421420e-02, 4.933250e-02, 5.574379e-02, 5.632397e-02, },
{ 1.448133e-02, 2.157599e-02, 3.291223e-02, 5.708471e-02, 6.264123e-02, 1.072765e-01, },
{ 1.075632e-02, 1.408133e-02, 1.158542e-02, 2.243037e-02, 2.490456e-02, 1.210080e-01, },
{ 5.959720e-03, 7.332958e-03, 2.816595e-02, 6.454951e-02, 9.152530e-02, 1.046325e-01, },
{ 1.121031e-02, 1.779931e-02, 4.419190e-02, 5.891010e-02, 6.218898e-02, 7.740685e-02, },
{ 7.974552e-03, 1.553187e-02, 6.742206e-02, 7.280165e-02, 7.270598e-02, 9.430613e-02, },
{ 1.229528e-04, -6.753855e-03, -2.292543e-02, -4.007095e-03, 7.284874e-02, 9.076650e-02, },
{ 1.775179e-03, -3.624260e-04, 6.020865e-03, 4.012993e-02, 7.555441e-02, 1.194790e-01, },
{ 1.207279e-02, 1.868515e-02, 2.681415e-02, 3.618845e-02, 5.148169e-02, 7.361754e-02, },
{ 8.744158e-03, 1.315984e-02, 4.133568e-02, 5.441849e-02, 7.673960e-02, 8.611670e-02, },
{ 7.119786e-03, 1.061561e-02, 1.960363e-02, 6.139898e-03, 5.504548e-02, 7.536288e-02, },
{ 3.696203e-03, 9.159482e-04, -1.777919e-02, 8.135868e-02, 1.089720e-01, 1.060551e-01, },
{ 1.136984e-02, 1.734768e-02, 3.064681e-02, 4.594726e-02, 6.848639e-02, 8.203281e-02, },
{ 8.139603e-03, 1.166611e-02, 3.273689e-02, 8.528454e-02, 9.048032e-02, 1.160815e-01, },
{ 1.220534e-02, 1.976546e-02, 2.109287e-02, 1.971431e-02, 1.093996e-02, 7.336900e-02, },
{ 1.316671e-02, 2.401337e-02, 2.315866e-02, 3.457327e-02, 8.770854e-02, 9.072407e-02, },
{ 1.432778e-02, 2.465832e-02, 3.338413e-02, 4.419498e-02, 4.982769e-02, 7.989208e-02, },
{ 1.364574e-02, 2.976453e-02, 5.123806e-02, 5.620774e-02, 8.065026e-02, 9.201048e-02, },
{ 7.540212e-03, 1.002980e-02, 2.011248e-02, 4.952226e-02, 6.339812e-02, 9.420405e-02, },
{ 1.206200e-02, 1.735662e-02, 2.589900e-02, 4.195053e-02, 9.369461e-02, 1.232724e-01, },
{ 1.461674e-02, 3.028722e-02, 4.594334e-02, 5.135194e-02, 7.001770e-02, 7.553647e-02, },
{ 9.055438e-03, 1.353849e-02, 5.549249e-02, 9.355525e-02, 1.163287e-01, 1.226538e-01, },
{ 1.690724e-04, -9.507846e-03, -2.867733e-02, 7.501150e-03, 4.609323e-02, 5.912104e-02, },
{ 3.618673e-03, -5.661770e-04, -1.748475e-02, 1.293233e-02, 1.068827e-01, 1.175760e-01, },
{ 1.002935e-02, 1.522309e-02, 2.250427e-02, 4.748861e-02, 4.700692e-02, 7.462876e-02, },
{ 8.399810e-03, 1.318847e-02, 2.650599e-02, 5.669963e-02, 8.804801e-02, 8.396269e-02, },
{ 5.563752e-03, 6.531787e-03, 1.020299e-02, 5.275804e-03, 7.341392e-02, 8.497974e-02, },
{ 7.848727e-03, 1.221392e-02, 1.295433e-02, 1.745372e-02, 9.913229e-02, 1.128367e-01, },
{ 8.963749e-03, 1.687191e-02, 2.512328e-02, 5.569028e-02, 7.858840e-02, 6.203939e-02, },
{ 1.069695e-02, 1.614052e-02, 4.251507e-02, 9.653705e-02, 7.369005e-02, 8.420807e-02, },
{ 7.014642e-03, 1.084669e-02, 1.306607e-02, 2.151943e-02, 5.703801e-02, 4.686001e-02, },
{ 3.921447e-03, 6.470100e-03, 3.886472e-02, 4.513076e-02, 8.122186e-02, 9.815858e-02, },
{ 1.171180e-02, 1.954715e-02, 3.562656e-02, 5.035417e-02, 6.332507e-02, 7.133917e-02, },
{ 1.474416e-02, 2.338901e-02, 3.253734e-02, 7.028958e-02, 7.770266e-02, 9.320802e-02, },
{ 1.052023e-02, 1.576434e-02, 2.471812e-02, 4.934276e-02, 5.103861e-02, 1.048236e-01, },
{ 7.971436e-03, 1.218588e-02, 3.578534e-02, 6.855830e-02, 7.631052e-02, 1.231883e-01, },
{ 1.445598e-02, 2.231407e-02, 2.905373e-02, 6.521531e-02, 6.695589e-02, 8.258968e-02, },
{ 8.723481e-03, 1.528202e-02, 7.277171e-02, 9.642877e-02, 9.663373e-02, 1.011832e-01, },
{ 3.875010e-03, 3.468730e-03, -1.192185e-02, 8.317015e-03, 6.711985e-02, 6.846552e-02, },
{ 8.522685e-03, 1.141626e-02, 2.196744e-02, 4.079214e-02, 5.556057e-02, 1.191026e-01, },
{ 1.279098e-02, 2.083943e-02, 2.755444e-02, 4.918984e-02, 5.550942e-02, 6.602094e-02, },
{ 1.337157e-02, 2.231848e-02, 3.105858e-02, 5.922501e-02, 8.612292e-02, 9.037620e-02, },
{ 7.699506e-03, 1.157719e-02, 1.458922e-02, 2.997539e-02, 6.926092e-02, 7.231053e-02, },
{ 8.572665e-03, 1.103223e-02, 3.655491e-03, 6.013813e-04, 1.353062e-01, 1.411054e-01, },
{ 1.464048e-02, 2.529606e-02, 3.394070e-02, 5.343143e-02, 5.859105e-02, 8.427142e-02, },
{ 1.030108e-02, 1.400100e-02, 2.354852e-02, 1.041944e-01, 1.142434e-01, 1.171278e-01, },
{ 1.024862e-02, 1.668403e-02, 2.428519e-02, 3.755552e-02, 4.819977e-02, 5.338661e-02, },
{ 1.220636e-02, 2.215971e-02, 3.799770e-02, 4.476346e-02, 8.994620e-02, 9.626246e-02, },
{ 1.525373e-02, 3.014434e-02, 4.165955e-02, 5.130609e-02, 6.135975e-02, 7.202378e-02, },
{ 1.769665e-02, 3.390138e-02, 6.046994e-02, 6.404957e-02, 8.168772e-02, 1.054225e-01, },
{ 9.591575e-03, 1.583405e-02, 2.078408e-02, 4.304064e-02, 7.860795e-02, 7.846827e-02, },
{ 1.359712e-02, 2.003238e-02, 3.807316e-02, 6.570288e-02, 1.085274e-01, 1.222856e-01, },
{ 1.918449e-02, 4.139043e-02, 4.337591e-02, 4.132815e-02, 7.677242e-02, 8.562198e-02, },
{ 1.050975e-02, 1.863473e-02, 9.254627e-02, 1.283125e-01, 1.053567e-01, 1.199707e-01, },
{ 5.918454e-03, 6.080266e-03, -7.129963e-03, 2.446413e-03, 8.310454e-03, 8.368436e-02, },
{ 5.458348e-03, 6.198443e-03, 1.535544e-02, 4.178208e-02, 7.824758e-02, 8.586185e-02, },
{ 1.132066e-02, 1.903751e-02, 2.557056e-02, 4.109728e-02, 6.230402e-02, 5.995725e-02, },
{ 9.085885e-03, 1.276621e-02, 3.853114e-02, 7.070125e-02, 6.351903e-02, 9.697020e-02, },
{ 7.746599e-03, 7.915598e-03, 1.284159e-02, 2.281519e-02, 3.773596e-02, 8.842938e-02, },
{ 9.514555e-03, 1.501918e-02, 2.169119e-02, 5.355273e-02, 1.013855e-01, 1.041097e-01, },
{ 8.900842e-03, 1.172973e-02, 2.906523e-02, 7.260499e-02, 5.839652e-02, 7.678492e-02, },
{ 1.138450e-02, 1.739888e-02, 2.240779e-02, 7.636852e-02, 9.725868e-02, 1.027513e-01, },
{ 1.355493e-02, 2.288965e-02, 8.260706e-03, 2.007755e-02, 4.300341e-02, 3.900796e-02, },
{ 9.891015e-03, 1.385347e-02, 2.428886e-02, 3.651466e-02, 8.751778e-02, 9.426162e-02, },
{ 1.391190e-02, 2.047712e-02, 3.248138e-02, 6.004102e-02, 4.798779e-02, 6.777416e-02, },
{ 1.902456e-02, 3.331503e-02, 4.578545e-02, 5.663755e-02, 6.439867e-02, 1.062531e-01, },
{ 9.564419e-03, 1.403566e-02, 2.477088e-02, 4.261459e-02, 5.200429e-02, 8.820881e-02, },
{ 1.205970e-02, 1.689558e-02, 3.531651e-02, 6.628097e-02, 9.748124e-02, 1.088641e-01, },
{ 1.288644e-02, 2.231389e-02, 3.649607e-02, 5.610364e-02, 7.075558e-02, 7.964497e-02, },
{ 1.553735e-02, 2.666385e-02, 5.825480e-02, 8.822496e-02, 8.702231e-02, 1.127007e-01, },
{ 9.096000e-03, 9.072083e-03, -2.497576e-02, -2.502761e-02, 7.977983e-02, 1.032555e-01, },
{ 7.333625e-03, 9.572126e-03, 1.862230e-02, 4.789012e-02, 7.628116e-02, 1.058214e-01, },
{ 1.097244e-02, 1.811336e-02, 3.506999e-02, 3.954222e-02, 5.789039e-02, 6.825149e-02, },
{ 7.792993e-03, 1.451610e-02, 5.340312e-02, 5.388265e-02, 7.050533e-02, 1.057514e-01, },
{ 8.214470e-03, 1.095206e-02, 1.436050e-02, 2.891614e-02, 6.978688e-02, 9.375148e-02, },
{ 9.639482e-03, 1.419862e-02, 2.143420e-02, 7.176226e-02, 1.065959e-01, 1.112459e-01, },
{ 1.136914e-02, 2.207686e-02, 4.278969e-02, 4.474858e-02, 6.979439e-02, 8.143581e-02, },
{ 7.003636e-03, 1.259565e-02, 6.235220e-02, 7.676248e-02, 9.325203e-02, 1.234214e-01, },
{ 9.737400e-03, 1.418472e-02, 1.322197e-02, 3.930484e-02, 3.251881e-02, 4.704874e-02, },
{ 1.258879e-02, 1.986855e-02, 2.957129e-02, 3.706107e-02, 7.742193e-02, 9.918442e-02, },
{ 1.795916e-02, 3.329033e-02, 3.592786e-02, 4.101311e-02, 3.259834e-02, 8.484413e-02, },
{ 1.841436e-02, 3.626098e-02, 4.613198e-02, 6.238762e-02, 8.946720e-02, 9.815589e-02, },
{ 9.956243e-03, 1.422402e-02, 2.395520e-02, 4.314957e-02, 7.418438e-02, 9.186244e-02, },
{ 1.455736e-02, 2.367722e-02, 3.257153e-02, 5.047949e-02, 9.957614e-02, 1.165632e-01, },
{ 1.327975e-02, 2.519194e-02, 5.324598e-02, 6.333015e-02, 7.147826e-02, 8.219094e-02, },
{ 1.358913e-02, 3.036441e-02, 6.303539e-02, 7.773861e-02, 1.107195e-01, 1.331858e-01, },
{ 1.192407e-02, 1.332826e-02, -2.848085e-02, 1.789828e-02, 5.533464e-02, 5.518269e-02, },
{ 8.398976e-03, 1.293899e-02, 1.655889e-02, 3.966486e-02, 9.708422e-02, 8.677962e-02, },
{ 1.260320e-02, 2.041536e-02, 1.485852e-02, 6.019588e-02, 6.072725e-02, 6.315859e-02, },
{ 1.231732e-02, 1.886101e-02, 2.485610e-02, 7.766679e-02, 8.156609e-02, 8.881552e-02, },
{ 8.845816e-03, 1.152232e-02, 1.543732e-02, 9.966677e-03, 6.336125e-02, 1.073536e-01, },
{ 9.630740e-03, 1.494704e-02, 1.983327e-02, 3.968608e-02, 1.052168e-01, 1.147619e-01, },
{ 1.109502e-02, 1.808664e-02, 3.068586e-02, 6.584834e-02, 7.078055e-02, 7.280418e-02, },
{ 1.333203e-02, 2.283243e-02, 3.803346e-02, 8.929606e-02, 1.032020e-01, 7.642663e-02, },
{ 9.487488e-03, 1.396754e-02, 1.985947e-02, 3.155421e-02, 4.385937e-02, 7.090779e-02, },
{ 8.636302e-03, 1.217350e-02, 2.791958e-02, 5.870291e-02, 6.727581e-02, 1.089158e-01, },
{ 1.513879e-02, 2.605487e-02, 3.410574e-02, 5.678941e-02, 6.137971e-02, 6.138873e-02, },
{ 1.627535e-02, 2.450705e-02, 3.475043e-02, 8.119153e-02, 8.633206e-02, 1.089034e-01, },
{ 1.391008e-02, 2.063600e-02, 2.779286e-02, 3.824717e-02, 4.498410e-02, 1.211496e-01, },
{ 7.576017e-03, 1.330912e-02, 4.774473e-02, 5.595764e-02, 9.197225e-02, 1.099847e-01, },
{ 1.200827e-02, 1.924210e-02, 3.853167e-02, 6.923991e-02, 7.650977e-02, 8.398125e-02, },
{ 1.496825e-02, 3.495487e-02, 8.101650e-02, 7.546417e-02, 8.969326e-02, 9.778836e-02, },
{ 1.056465e-02, 1.613309e-02, 2.382339e-03, -9.287237e-03, 6.464728e-02, 6.404828e-02, },
{ 9.223061e-03, 1.283639e-02, 2.020261e-02, 2.560855e-02, 8.111286e-02, 1.246765e-01, },
{ 1.415461e-02, 2.622442e-02, 3.460154e-02, 4.179441e-02, 6.527641e-02, 6.953667e-02, },
{ 1.524615e-02, 2.498100e-02, 3.596317e-02, 6.215922e-02, 8.995465e-02, 9.926517e-02, },
{ 9.546704e-03, 1.403917e-02, 2.144710e-02, 2.769878e-02, 7.899776e-02, 8.525801e-02, },
{ 1.114525e-02, 1.634627e-02, 2.235647e-02, 4.337943e-02, 1.192778e-01, 1.501898e-01, },
{ 1.450873e-02, 2.486483e-02, 3.928377e-02, 4.554508e-02, 6.515517e-02, 1.001259e-01, },
{ 1.234595e-02, 2.053672e-02, 4.903908e-02, 8.465239e-02, 1.022350e-01, 1.081524e-01, },
{ 1.367792e-02, 2.355440e-02, 2.518647e-02, 4.853933e-02, 5.008110e-02, 4.168710e-02, },
{ 1.425342e-02, 2.453593e-02, 4.197185e-02, 5.081797e-02, 8.329341e-02, 1.072616e-01, },
{ 1.960642e-02, 3.898838e-02, 4.207265e-02, 6.001564e-02, 6.504488e-02, 6.932728e-02, },
{ 2.460008e-02, 4.965419e-02, 5.890319e-02, 7.295647e-02, 8.568417e-02, 9.563655e-02, },
{ 1.205512e-02, 1.889956e-02, 2.752815e-02, 5.232022e-02, 7.946993e-02, 8.617730e-02, },
{ 9.663960e-03, 1.614339e-02, 4.126473e-02, 6.325716e-02, 1.053434e-01, 1.541804e-01, },
{ 1.822110e-02, 3.781947e-02, 4.968612e-02, 6.187595e-02, 8.099774e-02, 8.663334e-02, },
{ 1.109863e-02, 1.763011e-02, 7.500531e-02, 1.384445e-01, 1.492926e-01, 1.551792e-01, },
{ 5.303191e-03, 6.163319e-03, -9.935876e-03, 1.263475e-02, 3.648182e-02, 3.176402e-02, },
{ 7.656326e-03, 8.292204e-03, -1.146161e-02, 6.346560e-02, 7.629093e-02, 8.108710e-02, },
{ 8.900962e-03, 1.329566e-02, 2.178679e-02, 4.411919e-02, 5.991705e-02, 6.852204e-02, },
{ 7.636544e-03, 1.045651e-02, 2.464017e-02, 6.533542e-02, 7.650775e-02, 9.471563e-02, },
{ 2.532512e-03, 2.136457e-03, 3.021476e-02, 4.136602e-02, 6.454775e-02, 7.664100e-02, },
{ 1.044527e-02, 1.643768e-02, 2.088479e-02, 3.205047e-02, 9.942918e-02, 1.017902e-01, },
{ 7.996326e-03, 1.207311e-02, 2.904822e-02, 5.457655e-02, 7.079440e-02, 7.869253e-02, },
{ 9.668930e-03, 1.439760e-02, 2.571769e-02, 9.697291e-02, 9.605262e-02, 9.999122e-02, },
{ 1.436717e-02, 2.645883e-02, 2.822158e-02, 3.477480e-02, 2.270752e-02, 2.770985e-02, },
{ 9.762389e-03, 1.375725e-02, 2.083862e-02, 2.924645e-02, 7.951931e-02, 1.040125e-01, },
{ 1.309336e-02, 2.478392e-02, 4.149975e-02, 4.772484e-02, 5.628620e-02, 6.386657e-02, },
{ 1.536021e-02, 2.549829e-02, 3.988964e-02, 6.816467e-02, 7.265893e-02, 1.087334e-01, },
{ 1.247890e-02, 1.949221e-02, 2.470249e-02, 3.474911e-02, 4.255147e-02, 9.593607e-02, },
{ 1.103190e-02, 1.628336e-02, 2.308081e-02, 5.936553e-02, 8.705869e-02, 1.110797e-01, },
{ 1.270605e-02, 2.084559e-02, 4.293571e-02, 5.779853e-02, 7.309847e-02, 9.493118e-02, },
{ 1.392727e-02, 2.562002e-02, 8.628931e-02, 1.039428e-01, 5.858992e-02, 7.667745e-02, },
{ 4.089074e-03, 3.462401e-03, -5.632688e-03, 2.197151e-02, 8.874319e-02, 9.526871e-02, },
{ 7.024502e-03, 7.744252e-03, 1.391010e-02, 7.072181e-02, 7.100502e-02, 1.119163e-01, },
{ 1.321130e-02, 2.262441e-02, 3.167370e-02, 4.294255e-02, 4.978762e-02, 6.027971e-02, },
{ 1.022026e-02, 1.720904e-02, 4.526216e-02, 5.901125e-02, 9.011628e-02, 9.097002e-02, },
{ 9.797220e-03, 1.402764e-02, 2.123848e-02, 2.430695e-02, 5.469101e-02, 8.801915e-02, },
{ 8.082367e-03, 1.223360e-02, 9.553279e-03, 5.670672e-02, 1.179917e-01, 1.161145e-01, },
{ 1.320055e-02, 2.345801e-02, 3.273856e-02, 4.714497e-02, 7.684546e-02, 7.717757e-02, },
{ 8.955231e-03, 1.265015e-02, 2.765347e-02, 6.749362e-02, 9.701269e-02, 1.279953e-01, },
{ 9.855485e-03, 1.300584e-02, 2.384328e-02, 4.356547e-02, 2.470480e-02, 9.079430e-02, },
{ 1.151917e-02, 1.881033e-02, 2.519547e-02, 4.978248e-02, 9.135729e-02, 9.597386e-02, },
{ 1.064732e-02, 1.804666e-02, 4.335415e-02, 4.893394e-02, 5.391434e-02, 8.595121e-02, },
{ 1.527190e-02, 2.602275e-02, 5.476671e-02, 7.633000e-02, 8.897177e-02, 9.402770e-02, },
{ 8.905875e-03, 1.335151e-02, 3.492639e-02, 4.892637e-02, 6.327695e-02, 9.770146e-02, },
{ 1.312467e-02, 1.925649e-02, 2.793764e-02, 4.945602e-02, 1.070659e-01, 1.293118e-01, },
{ 1.731018e-02, 3.509098e-02, 4.684478e-02, 5.744139e-02, 7.237209e-02, 8.026575e-02, },
{ 6.664837e-03, 1.471213e-02, 7.830968e-02, 9.968643e-02, 1.211035e-01, 1.593063e-01, },
{ 2.365581e-03, -1.869171e-03, -5.474351e-03, 3.635935e-02, 3.714038e-02, 5.178194e-02, },
{ 1.066048e-02, 1.502958e-02, -1.088471e-03, -8.811041e-03, 9.949283e-02, 1.151136e-01, },
{ 1.100146e-02, 1.709266e-02, 2.724989e-02, 5.312778e-02, 5.785235e-02, 7.830223e-02, },
{ 9.978566e-03, 1.588900e-02, 2.224291e-02, 6.859052e-02, 9.017739e-02, 9.425363e-02, },
{ 9.592239e-03, 1.567743e-02, 1.931609e-02, 8.760298e-03, 8.620425e-02, 9.471077e-02, },
{ 1.214308e-02, 1.972927e-02, 2.335258e-02, 2.074681e-02, 1.009557e-01, 1.170583e-01, },
{ 7.966644e-03, 1.309495e-02, 2.304281e-02, 6.980241e-02, 7.665675e-02, 8.160758e-02, },
{ 8.976206e-03, 1.212284e-02, 4.885978e-02, 1.067864e-01, 8.398529e-02, 1.096782e-01, },
{ 1.527207e-02, 2.514902e-02, 6.819671e-03, 3.073835e-02, 6.700204e-02, 6.081747e-02, },
{ 1.058665e-02, 1.541418e-02, 3.229257e-02, 5.321593e-02, 8.234696e-02, 9.967718e-02, },
{ 1.188961e-02, 2.275046e-02, 4.728765e-02, 5.384886e-02, 6.843225e-02, 6.810638e-02, },
{ 1.678928e-02, 3.034505e-02, 4.760033e-02, 7.426842e-02, 7.856887e-02, 9.728899e-02, },
{ 1.471486e-02, 2.325538e-02, 3.110789e-02, 4.590007e-02, 4.996742e-02, 9.923586e-02, },
{ 1.926970e-02, 2.749938e-02, 4.478497e-02, 6.293630e-02, 7.267881e-02, 1.375662e-01, },
{ 1.921595e-02, 3.223718e-02, 4.124602e-02, 8.193524e-02, 6.978901e-02, 8.386155e-02, },
{ 8.764529e-03, 2.137742e-02, 9.964002e-02, 9.023790e-02, 1.044598e-01, 1.229824e-01, },
{ 1.090919e-02, 1.557207e-02, -1.113650e-02, 1.011002e-02, 8.292004e-02, 8.214651e-02, },
{ 1.156206e-02, 1.685395e-02, 2.677811e-02, 4.310050e-02, 6.865470e-02, 1.106265e-01, },
{ 1.723227e-02, 3.023481e-02, 3.486528e-02, 5.046401e-02, 5.337592e-02, 6.744035e-02, },
{ 1.647507e-02, 3.174573e-02, 3.356298e-02, 5.407691e-02, 9.271983e-02, 8.392100e-02, },
{ 9.921863e-03, 1.448725e-02, 2.320880e-02, 3.773380e-02, 6.579331e-02, 8.025959e-02, },
{ 1.001064e-02, 1.472081e-02, 2.030826e-02, 3.304216e-02, 1.054859e-01, 1.298034e-01, },
{ 1.562087e-02, 3.037538e-02, 3.748892e-02, 6.156708e-02, 6.648883e-02, 9.197737e-02, },
{ 1.048021e-02, 1.454357e-02, 4.822939e-02, 1.329603e-01, 1.067346e-01, 1.296919e-01, },
{ 1.350757e-02, 2.221021e-02, 2.707653e-02, 3.798168e-02, 4.029766e-02, 6.454406e-02, },
{ 1.341219e-02, 2.174065e-02, 3.046407e-02, 4.861112e-02, 9.473447e-02, 1.045863e-01, },
{ 1.755489e-02, 3.127820e-02, 4.439767e-02, 5.637407e-02, 6.177903e-02, 8.264297e-02, },
{ 2.599594e-02, 4.135239e-02, 5.454427e-02, 7.855251e-02, 8.611720e-02, 1.213436e-01, },
{ 1.084672e-02, 1.746186e-02, 3.392268e-02, 4.189505e-02, 8.179289e-02, 8.679552e-02, },
{ 1.401170e-02, 2.655162e-02, 4.501818e-02, 6.912407e-02, 1.266041e-01, 1.104494e-01, },
{ 2.163378e-02, 3.394595e-02, 4.061906e-02, 6.535209e-02, 7.414776e-02, 8.721416e-02, },
{ 2.123426e-02, 4.145775e-02, 8.398825e-02, 1.117465e-01, 1.088563e-01, 1.270311e-01, },
{ 1.365023e-02, 1.757321e-02, -3.103160e-03, 2.798911e-02, 2.258746e-02, 6.586535e-02, },
{ 7.948541e-03, 1.212766e-02, 1.916004e-02, 5.208111e-02, 8.403005e-02, 9.343157e-02, },
{ 1.248946e-02, 2.217023e-02, 3.088442e-02, 6.064757e-02, 7.056952e-02, 4.324210e-02, },
{ 1.144341e-02, 1.671017e-02, 2.789987e-02, 7.387075e-02, 7.854795e-02, 1.059698e-01, },
{ 7.710245e-03, 1.048577e-02, 1.102443e-02, 4.192092e-02, 5.053857e-02, 9.058210e-02, },
{ 1.059740e-02, 1.693553e-02, 2.741390e-02, 6.639491e-02, 1.150300e-01, 9.548834e-02, },
{ 1.050003e-02, 1.606420e-02, 2.484823e-02, 5.865883e-02, 6.073172e-02, 9.161714e-02, },
{ 1.332379e-02, 1.900005e-02, 2.827127e-02, 9.016292e-02, 1.027516e-01, 1.118753e-01, },
{ 1.113363e-02, 2.035875e-02, 2.914079e-02, 3.582013e-02, 4.482924e-02, 2.419326e-02, },
{ 1.142835e-02, 1.666066e-02, 2.681447e-02, 3.915064e-02, 9.023532e-02, 1.093200e-01, },
{ 1.709774e-02, 2.811970e-02, 5.252940e-02, 6.828706e-02, 4.784852e-02, 5.947258e-02, },
{ 2.720175e-02, 3.782394e-02, 4.418793e-02, 6.745537e-02, 7.309327e-02, 1.052259e-01, },
{ 1.236268e-02, 1.949321e-02, 3.087984e-02, 3.946717e-02, 5.861009e-02, 9.241929e-02, },
{ 1.693191e-02, 2.613623e-02, 2.731599e-02, 6.455534e-02, 9.962901e-02, 1.059066e-01, },
{ 1.543622e-02, 2.828809e-02, 3.670112e-02, 6.237217e-02, 7.666051e-02, 8.103070e-02, },
{ 2.194186e-02, 4.194985e-02, 6.562757e-02, 1.003349e-01, 8.735770e-02, 1.004197e-01, },
{ 8.449619e-03, 1.214902e-02, 9.911264e-03, -2.263107e-02, 6.741963e-02, 9.523895e-02, },
{ 9.652783e-03, 1.370022e-02, 2.102411e-02, 4.198332e-02, 8.285850e-02, 1.166894e-01, },
{ 1.416882e-02, 2.870093e-02, 3.723999e-02, 4.411218e-02, 5.845729e-02, 4.934694e-02, },
{ 8.847794e-03, 1.547444e-02, 4.905083e-02, 7.076934e-02, 8.335875e-02, 1.021464e-01, },
{ 9.604824e-03, 1.304139e-02, 2.249504e-02, 3.387841e-02, 6.031143e-02, 1.004826e-01, },
{ 1.046875e-02, 1.543936e-02, 2.432846e-02, 7.287004e-02, 1.164448e-01, 1.207011e-01, },
{ 1.375569e-02, 2.669445e-02, 4.216389e-02, 5.234947e-02, 7.786584e-02, 8.481407e-02, },
{ 7.335438e-03, 1.205429e-02, 4.689126e-02, 9.328733e-02, 9.399007e-02, 1.462841e-01, },
{ 1.287533e-02, 2.133653e-02, 3.166180e-02, 5.672319e-02, 2.381741e-02, 5.525041e-02, },
{ 1.419121e-02, 2.687909e-02, 3.138959e-02, 3.529942e-02, 8.542363e-02, 1.127939e-01, },
{ 1.791194e-02, 3.159679e-02, 3.727095e-02, 5.146832e-02, 5.400905e-02, 9.675787e-02, },
{ 2.087287e-02, 3.473615e-02, 5.137384e-02, 7.466143e-02, 1.006730e-01, 1.072778e-01, },
{ 1.120949e-02, 1.766367e-02, 2.487732e-02, 6.136104e-02, 7.287911e-02, 9.365183e-02, },
{ 1.834129e-02, 3.482774e-02, 4.936274e-02, 4.978013e-02, 1.057778e-01, 1.223207e-01, },
{ 1.755426e-02, 3.197756e-02, 5.190440e-02, 7.156381e-02, 8.284405e-02, 6.325768e-02, },
{ 1.723299e-02, 3.441321e-02, 6.250231e-02, 9.866171e-02, 1.459559e-01, 1.338643e-01, },
{ 1.140635e-02, 1.487604e-02, -8.878063e-03, 4.811695e-02, 5.368769e-02, 6.320773e-02, },
{ 1.192981e-02, 1.753481e-02, -2.913684e-03, 5.369503e-02, 9.571518e-02, 9.764151e-02, },
{ 1.268512e-02, 2.102691e-02, 2.459843e-02, 5.340676e-02, 6.700817e-02, 7.346574e-02, },
{ 1.354562e-02, 2.055935e-02, 3.385966e-02, 7.754423e-02, 9.066568e-02, 9.602289e-02, },
{ 1.135348e-02, 1.669607e-02, 2.666650e-02, 2.353711e-02, 6.297729e-02, 1.105112e-01, },
{ 1.230077e-02, 1.875056e-02, 2.609818e-02, 4.854506e-02, 1.079429e-01, 1.146352e-01, },
{ 1.399468e-02, 2.270400e-02, 2.373018e-02, 6.552222e-02, 7.875840e-02, 7.989031e-02, },
{ 1.319152e-02, 2.084730e-02, 4.503671e-02, 1.290975e-01, 9.397151e-02, 1.015461e-01, },
{ 1.368499e-02, 2.508411e-02, 2.672089e-02, 2.268044e-02, 6.035163e-02, 5.834530e-02, },
{ 1.276301e-02, 1.787832e-02, 3.457643e-02, 4.930740e-02, 8.126841e-02, 1.193686e-01, },
{ 1.625248e-02, 2.899817e-02, 3.558495e-02, 5.989975e-02, 6.817398e-02, 7.318249e-02, },
{ 2.087867e-02, 3.258535e-02, 4.010204e-02, 8.946844e-02, 9.076896e-02, 9.688027e-02, },
{ 1.551426e-02, 2.405572e-02, 3.578076e-02, 4.915773e-02, 5.523612e-02, 1.235003e-01, },
{ 1.581586e-02, 2.609035e-02, 4.797950e-02, 6.746434e-02, 9.190799e-02, 1.186483e-01, },
{ 1.635978e-02, 2.869529e-02, 3.828697e-02, 7.013810e-02, 8.365562e-02, 8.823450e-02, },
{ 2.092320e-02, 5.083029e-02, 1.044057e-01, 1.057645e-01, 9.451101e-02, 8.754539e-02, },
{ 1.451793e-02, 2.486681e-02, 9.099091e-03, 1.642133e-02, 8.044284e-02, 8.423615e-02, },
{ 9.687901e-03, 1.401109e-02, 2.812168e-02, 4.864512e-02, 6.800064e-02, 1.382065e-01, },
{ 1.970343e-02, 3.436188e-02, 2.604558e-02, 4.621613e-02, 7.262416e-02, 6.902476e-02, },
{ 1.467168e-02, 2.512416e-02, 4.624603e-02, 5.631066e-02, 9.913168e-02, 1.033926e-01, },
{ 1.236415e-02, 2.169018e-02, 2.734600e-02, 2.900175e-02, 7.295955e-02, 7.620005e-02, },
{ 1.085741e-02, 1.690202e-02, 2.197172e-02, 3.523201e-02, 1.262250e-01, 1.243420e-01, },
{ 1.572469e-02, 3.017960e-02, 4.075398e-02, 5.166241e-02, 8.451352e-02, 9.353647e-02, },
{ 1.970711e-02, 2.900865e-02, 4.996922e-02, 1.006921e-01, 1.060958e-01, 1.206799e-01, },
{ 1.735244e-02, 3.449156e-02, 3.908913e-02, 4.768430e-02, 4.252715e-02, 3.699933e-02, },
{ 1.945347e-02, 3.443485e-02, 3.606386e-02, 4.762195e-02, 9.457853e-02, 1.040000e-01, },
{ 2.210732e-02, 4.680754e-02, 5.742858e-02, 5.704020e-02, 5.832452e-02, 5.877091e-02, },
{ 2.474180e-02, 4.944438e-02, 6.852394e-02, 8.235002e-02, 1.020230e-01, 1.115192e-01, },
{ 1.508350e-02, 2.722573e-02, 3.131892e-02, 4.745496e-02, 7.978091e-02, 9.108847e-02, },
{ 1.166190e-02, 1.923598e-02, 3.012556e-02, 7.199394e-02, 1.439955e-01, 1.346194e-01, },
{ 2.158555e-02, 4.269935e-02, 5.618436e-02, 7.027412e-02, 7.117978e-02, 8.405051e-02, },
{ 1.745286e-02, 4.605361e-02, 1.083641e-01, 1.273782e-01, 1.311669e-01, 1.368730e-01, },*/
{ 1/128.0, 0/128.0, -1/128.0, 0/128.0, 0/128.0, 4/128.0, },
{ 0/128.0, -2/128.0, -2/128.0, 6/128.0, 8/128.0, 11/128.0, },
{ 0/128.0, 1/128.0, 1/128.0, 6/128.0, 7/128.0, 7/128.0, },
{ 0/128.0, 0/128.0, 5/128.0, 8/128.0, 9/128.0, 11/128.0, },
{ 0/128.0, 0/128.0, 1/128.0, 3/128.0, 9/128.0, 9/128.0, },
{ 1/128.0, 1/128.0, 2/128.0, 5/128.0, 12/128.0, 13/128.0, },
{ 1/128.0, 2/128.0, 2/128.0, 7/128.0, 9/128.0, 10/128.0, },
{ 1/128.0, 1/128.0, 4/128.0, 11/128.0, 11/128.0, 12/128.0, },
{ 2/128.0, 2/128.0, 1/128.0, 2/128.0, 2/128.0, 3/128.0, },
{ 1/128.0, 0/128.0, 3/128.0, 3/128.0, 10/128.0, 12/128.0, },
{ 1/128.0, 2/128.0, 4/128.0, 6/128.0, 7/128.0, 7/128.0, },
{ 2/128.0, 3/128.0, 4/128.0, 7/128.0, 8/128.0, 14/128.0, },
{ 1/128.0, 2/128.0, 1/128.0, 3/128.0, 3/128.0, 15/128.0, },
{ 1/128.0, 1/128.0, 4/128.0, 8/128.0, 12/128.0, 13/128.0, },
{ 1/128.0, 2/128.0, 6/128.0, 8/128.0, 8/128.0, 10/128.0, },
{ 1/128.0, 2/128.0, 9/128.0, 9/128.0, 9/128.0, 12/128.0, },
{ 0/128.0, -1/128.0, -3/128.0, -1/128.0, 9/128.0, 12/128.0, },
{ 0/128.0, 0/128.0, 1/128.0, 5/128.0, 10/128.0, 15/128.0, },
{ 2/128.0, 2/128.0, 3/128.0, 5/128.0, 7/128.0, 9/128.0, },
{ 1/128.0, 2/128.0, 5/128.0, 7/128.0, 10/128.0, 11/128.0, },
{ 1/128.0, 1/128.0, 3/128.0, 1/128.0, 7/128.0, 10/128.0, },
{ 0/128.0, 0/128.0, -2/128.0, 10/128.0, 14/128.0, 14/128.0, },
{ 1/128.0, 2/128.0, 4/128.0, 6/128.0, 9/128.0, 11/128.0, },
{ 1/128.0, 1/128.0, 4/128.0, 11/128.0, 12/128.0, 15/128.0, },
{ 2/128.0, 3/128.0, 3/128.0, 3/128.0, 1/128.0, 9/128.0, },
{ 2/128.0, 3/128.0, 3/128.0, 4/128.0, 11/128.0, 12/128.0, },
{ 2/128.0, 3/128.0, 4/128.0, 6/128.0, 6/128.0, 10/128.0, },
{ 2/128.0, 4/128.0, 7/128.0, 7/128.0, 10/128.0, 12/128.0, },
{ 1/128.0, 1/128.0, 3/128.0, 6/128.0, 8/128.0, 12/128.0, },
{ 2/128.0, 2/128.0, 3/128.0, 5/128.0, 12/128.0, 16/128.0, },
{ 2/128.0, 4/128.0, 6/128.0, 7/128.0, 9/128.0, 10/128.0, },
{ 1/128.0, 2/128.0, 7/128.0, 12/128.0, 15/128.0, 16/128.0, },
{ 0/128.0, -1/128.0, -4/128.0, 1/128.0, 6/128.0, 8/128.0, },
{ 0/128.0, 0/128.0, -2/128.0, 2/128.0, 14/128.0, 15/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 6/128.0, 6/128.0, 10/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 7/128.0, 11/128.0, 11/128.0, },
{ 1/128.0, 1/128.0, 1/128.0, 1/128.0, 9/128.0, 11/128.0, },
{ 1/128.0, 2/128.0, 2/128.0, 2/128.0, 13/128.0, 14/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 7/128.0, 10/128.0, 8/128.0, },
{ 1/128.0, 2/128.0, 5/128.0, 12/128.0, 9/128.0, 11/128.0, },
{ 1/128.0, 1/128.0, 2/128.0, 3/128.0, 7/128.0, 6/128.0, },
{ 1/128.0, 1/128.0, 5/128.0, 6/128.0, 10/128.0, 13/128.0, },
{ 1/128.0, 3/128.0, 5/128.0, 6/128.0, 8/128.0, 9/128.0, },
{ 2/128.0, 3/128.0, 4/128.0, 9/128.0, 10/128.0, 12/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 6/128.0, 7/128.0, 13/128.0, },
{ 1/128.0, 2/128.0, 5/128.0, 9/128.0, 10/128.0, 16/128.0, },
{ 2/128.0, 3/128.0, 4/128.0, 8/128.0, 9/128.0, 11/128.0, },
{ 1/128.0, 2/128.0, 9/128.0, 12/128.0, 12/128.0, 13/128.0, },
{ 0/128.0, 0/128.0, -2/128.0, 1/128.0, 9/128.0, 9/128.0, },
{ 1/128.0, 1/128.0, 3/128.0, 5/128.0, 7/128.0, 15/128.0, },
{ 2/128.0, 3/128.0, 4/128.0, 6/128.0, 7/128.0, 8/128.0, },
{ 2/128.0, 3/128.0, 4/128.0, 8/128.0, 11/128.0, 12/128.0, },
{ 1/128.0, 1/128.0, 2/128.0, 4/128.0, 9/128.0, 9/128.0, },
{ 1/128.0, 1/128.0, 0/128.0, 0/128.0, 17/128.0, 18/128.0, },
{ 2/128.0, 3/128.0, 4/128.0, 7/128.0, 7/128.0, 11/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 13/128.0, 15/128.0, 15/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 5/128.0, 6/128.0, 7/128.0, },
{ 2/128.0, 3/128.0, 5/128.0, 6/128.0, 12/128.0, 12/128.0, },
{ 2/128.0, 4/128.0, 5/128.0, 7/128.0, 8/128.0, 9/128.0, },
{ 2/128.0, 4/128.0, 8/128.0, 8/128.0, 10/128.0, 13/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 6/128.0, 10/128.0, 10/128.0, },
{ 2/128.0, 3/128.0, 5/128.0, 8/128.0, 14/128.0, 16/128.0, },
{ 2/128.0, 5/128.0, 6/128.0, 5/128.0, 10/128.0, 11/128.0, },
{ 1/128.0, 2/128.0, 12/128.0, 16/128.0, 13/128.0, 15/128.0, },
{ 1/128.0, 1/128.0, -1/128.0, 0/128.0, 1/128.0, 11/128.0, },
{ 1/128.0, 1/128.0, 2/128.0, 5/128.0, 10/128.0, 11/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 5/128.0, 8/128.0, 8/128.0, },
{ 1/128.0, 2/128.0, 5/128.0, 9/128.0, 8/128.0, 12/128.0, },
{ 1/128.0, 1/128.0, 2/128.0, 3/128.0, 5/128.0, 11/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 7/128.0, 13/128.0, 13/128.0, },
{ 1/128.0, 2/128.0, 4/128.0, 9/128.0, 7/128.0, 10/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 10/128.0, 12/128.0, 13/128.0, },
{ 2/128.0, 3/128.0, 1/128.0, 3/128.0, 6/128.0, 5/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 5/128.0, 11/128.0, 12/128.0, },
{ 2/128.0, 3/128.0, 4/128.0, 8/128.0, 6/128.0, 9/128.0, },
{ 2/128.0, 4/128.0, 6/128.0, 7/128.0, 8/128.0, 14/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 5/128.0, 7/128.0, 11/128.0, },
{ 2/128.0, 2/128.0, 5/128.0, 8/128.0, 12/128.0, 14/128.0, },
{ 2/128.0, 3/128.0, 5/128.0, 7/128.0, 9/128.0, 10/128.0, },
{ 2/128.0, 3/128.0, 7/128.0, 11/128.0, 11/128.0, 14/128.0, },
{ 1/128.0, 1/128.0, -3/128.0, -3/128.0, 10/128.0, 13/128.0, },
{ 1/128.0, 1/128.0, 2/128.0, 6/128.0, 10/128.0, 14/128.0, },
{ 1/128.0, 2/128.0, 4/128.0, 5/128.0, 7/128.0, 9/128.0, },
{ 1/128.0, 2/128.0, 7/128.0, 7/128.0, 9/128.0, 14/128.0, },
{ 1/128.0, 1/128.0, 2/128.0, 4/128.0, 9/128.0, 12/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 9/128.0, 14/128.0, 14/128.0, },
{ 1/128.0, 3/128.0, 5/128.0, 6/128.0, 9/128.0, 10/128.0, },
{ 1/128.0, 2/128.0, 8/128.0, 10/128.0, 12/128.0, 16/128.0, },
{ 1/128.0, 2/128.0, 2/128.0, 5/128.0, 4/128.0, 6/128.0, },
{ 2/128.0, 3/128.0, 4/128.0, 5/128.0, 10/128.0, 13/128.0, },
{ 2/128.0, 4/128.0, 5/128.0, 5/128.0, 4/128.0, 11/128.0, },
{ 2/128.0, 5/128.0, 6/128.0, 8/128.0, 11/128.0, 13/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 6/128.0, 9/128.0, 12/128.0, },
{ 2/128.0, 3/128.0, 4/128.0, 6/128.0, 13/128.0, 15/128.0, },
{ 2/128.0, 3/128.0, 7/128.0, 8/128.0, 9/128.0, 11/128.0, },
{ 2/128.0, 4/128.0, 8/128.0, 10/128.0, 14/128.0, 17/128.0, },
{ 2/128.0, 2/128.0, -4/128.0, 2/128.0, 7/128.0, 7/128.0, },
{ 1/128.0, 2/128.0, 2/128.0, 5/128.0, 12/128.0, 11/128.0, },
{ 2/128.0, 3/128.0, 2/128.0, 8/128.0, 8/128.0, 8/128.0, },
{ 2/128.0, 2/128.0, 3/128.0, 10/128.0, 10/128.0, 11/128.0, },
{ 1/128.0, 1/128.0, 2/128.0, 1/128.0, 8/128.0, 14/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 5/128.0, 13/128.0, 15/128.0, },
{ 1/128.0, 2/128.0, 4/128.0, 8/128.0, 9/128.0, 9/128.0, },
{ 2/128.0, 3/128.0, 5/128.0, 11/128.0, 13/128.0, 10/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 4/128.0, 6/128.0, 9/128.0, },
{ 1/128.0, 2/128.0, 4/128.0, 8/128.0, 9/128.0, 14/128.0, },
{ 2/128.0, 3/128.0, 4/128.0, 7/128.0, 8/128.0, 8/128.0, },
{ 2/128.0, 3/128.0, 4/128.0, 10/128.0, 11/128.0, 14/128.0, },
{ 2/128.0, 3/128.0, 4/128.0, 5/128.0, 6/128.0, 16/128.0, },
{ 1/128.0, 2/128.0, 6/128.0, 7/128.0, 12/128.0, 14/128.0, },
{ 2/128.0, 2/128.0, 5/128.0, 9/128.0, 10/128.0, 11/128.0, },
{ 2/128.0, 4/128.0, 10/128.0, 10/128.0, 11/128.0, 13/128.0, },
{ 1/128.0, 2/128.0, 0/128.0, -1/128.0, 8/128.0, 8/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 3/128.0, 10/128.0, 16/128.0, },
{ 2/128.0, 3/128.0, 4/128.0, 5/128.0, 8/128.0, 9/128.0, },
{ 2/128.0, 3/128.0, 5/128.0, 8/128.0, 12/128.0, 13/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 4/128.0, 10/128.0, 11/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 6/128.0, 15/128.0, 19/128.0, },
{ 2/128.0, 3/128.0, 5/128.0, 6/128.0, 8/128.0, 13/128.0, },
{ 2/128.0, 3/128.0, 6/128.0, 11/128.0, 13/128.0, 14/128.0, },
{ 2/128.0, 3/128.0, 3/128.0, 6/128.0, 6/128.0, 5/128.0, },
{ 2/128.0, 3/128.0, 5/128.0, 7/128.0, 11/128.0, 14/128.0, },
{ 3/128.0, 5/128.0, 5/128.0, 8/128.0, 8/128.0, 9/128.0, },
{ 3/128.0, 6/128.0, 8/128.0, 9/128.0, 11/128.0, 12/128.0, },
{ 2/128.0, 2/128.0, 4/128.0, 7/128.0, 10/128.0, 11/128.0, },
{ 1/128.0, 2/128.0, 5/128.0, 8/128.0, 13/128.0, 20/128.0, },
{ 2/128.0, 5/128.0, 6/128.0, 8/128.0, 10/128.0, 11/128.0, },
{ 1/128.0, 2/128.0, 10/128.0, 18/128.0, 19/128.0, 20/128.0, },
{ 1/128.0, 1/128.0, -1/128.0, 2/128.0, 5/128.0, 4/128.0, },
{ 1/128.0, 1/128.0, -1/128.0, 8/128.0, 10/128.0, 10/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 6/128.0, 8/128.0, 9/128.0, },
{ 1/128.0, 1/128.0, 3/128.0, 8/128.0, 10/128.0, 12/128.0, },
{ 0/128.0, 0/128.0, 4/128.0, 5/128.0, 8/128.0, 10/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 4/128.0, 13/128.0, 13/128.0, },
{ 1/128.0, 2/128.0, 4/128.0, 7/128.0, 9/128.0, 10/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 12/128.0, 12/128.0, 13/128.0, },
{ 2/128.0, 3/128.0, 4/128.0, 4/128.0, 3/128.0, 4/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 4/128.0, 10/128.0, 13/128.0, },
{ 2/128.0, 3/128.0, 5/128.0, 6/128.0, 7/128.0, 8/128.0, },
{ 2/128.0, 3/128.0, 5/128.0, 9/128.0, 9/128.0, 14/128.0, },
{ 2/128.0, 2/128.0, 3/128.0, 4/128.0, 5/128.0, 12/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 8/128.0, 11/128.0, 14/128.0, },
{ 2/128.0, 3/128.0, 5/128.0, 7/128.0, 9/128.0, 12/128.0, },
{ 2/128.0, 3/128.0, 11/128.0, 13/128.0, 7/128.0, 10/128.0, },
{ 1/128.0, 0/128.0, -1/128.0, 3/128.0, 11/128.0, 12/128.0, },
{ 1/128.0, 1/128.0, 2/128.0, 9/128.0, 9/128.0, 14/128.0, },
{ 2/128.0, 3/128.0, 4/128.0, 5/128.0, 6/128.0, 8/128.0, },
{ 1/128.0, 2/128.0, 6/128.0, 8/128.0, 12/128.0, 12/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 3/128.0, 7/128.0, 11/128.0, },
{ 1/128.0, 2/128.0, 1/128.0, 7/128.0, 15/128.0, 15/128.0, },
{ 2/128.0, 3/128.0, 4/128.0, 6/128.0, 10/128.0, 10/128.0, },
{ 1/128.0, 2/128.0, 4/128.0, 9/128.0, 12/128.0, 16/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 6/128.0, 3/128.0, 12/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 6/128.0, 12/128.0, 12/128.0, },
{ 1/128.0, 2/128.0, 6/128.0, 6/128.0, 7/128.0, 11/128.0, },
{ 2/128.0, 3/128.0, 7/128.0, 10/128.0, 11/128.0, 12/128.0, },
{ 1/128.0, 2/128.0, 4/128.0, 6/128.0, 8/128.0, 13/128.0, },
{ 2/128.0, 2/128.0, 4/128.0, 6/128.0, 14/128.0, 17/128.0, },
{ 2/128.0, 4/128.0, 6/128.0, 7/128.0, 9/128.0, 10/128.0, },
{ 1/128.0, 2/128.0, 10/128.0, 13/128.0, 16/128.0, 20/128.0, },
{ 0/128.0, 0/128.0, -1/128.0, 5/128.0, 5/128.0, 7/128.0, },
{ 1/128.0, 2/128.0, 0/128.0, -1/128.0, 13/128.0, 15/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 7/128.0, 7/128.0, 10/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 9/128.0, 12/128.0, 12/128.0, },
{ 1/128.0, 2/128.0, 2/128.0, 1/128.0, 11/128.0, 12/128.0, },
{ 2/128.0, 3/128.0, 3/128.0, 3/128.0, 13/128.0, 15/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 9/128.0, 10/128.0, 10/128.0, },
{ 1/128.0, 2/128.0, 6/128.0, 14/128.0, 11/128.0, 14/128.0, },
{ 2/128.0, 3/128.0, 1/128.0, 4/128.0, 9/128.0, 8/128.0, },
{ 1/128.0, 2/128.0, 4/128.0, 7/128.0, 11/128.0, 13/128.0, },
{ 2/128.0, 3/128.0, 6/128.0, 7/128.0, 9/128.0, 9/128.0, },
{ 2/128.0, 4/128.0, 6/128.0, 10/128.0, 10/128.0, 12/128.0, },
{ 2/128.0, 3/128.0, 4/128.0, 6/128.0, 6/128.0, 13/128.0, },
{ 2/128.0, 4/128.0, 6/128.0, 8/128.0, 9/128.0, 18/128.0, },
{ 2/128.0, 4/128.0, 5/128.0, 10/128.0, 9/128.0, 11/128.0, },
{ 1/128.0, 3/128.0, 13/128.0, 12/128.0, 13/128.0, 16/128.0, },
{ 1/128.0, 2/128.0, -1/128.0, 1/128.0, 11/128.0, 11/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 6/128.0, 9/128.0, 14/128.0, },
{ 2/128.0, 4/128.0, 4/128.0, 6/128.0, 7/128.0, 9/128.0, },
{ 2/128.0, 4/128.0, 4/128.0, 7/128.0, 12/128.0, 11/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 5/128.0, 8/128.0, 10/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 4/128.0, 14/128.0, 17/128.0, },
{ 2/128.0, 4/128.0, 5/128.0, 8/128.0, 9/128.0, 12/128.0, },
{ 1/128.0, 2/128.0, 6/128.0, 17/128.0, 14/128.0, 17/128.0, },
{ 2/128.0, 3/128.0, 3/128.0, 5/128.0, 5/128.0, 8/128.0, },
{ 2/128.0, 3/128.0, 4/128.0, 6/128.0, 12/128.0, 13/128.0, },
{ 2/128.0, 4/128.0, 6/128.0, 7/128.0, 8/128.0, 11/128.0, },
{ 3/128.0, 5/128.0, 7/128.0, 10/128.0, 11/128.0, 16/128.0, },
{ 1/128.0, 2/128.0, 4/128.0, 5/128.0, 10/128.0, 11/128.0, },
{ 2/128.0, 3/128.0, 6/128.0, 9/128.0, 16/128.0, 14/128.0, },
{ 3/128.0, 4/128.0, 5/128.0, 8/128.0, 9/128.0, 11/128.0, },
{ 3/128.0, 5/128.0, 11/128.0, 14/128.0, 14/128.0, 16/128.0, },
{ 2/128.0, 2/128.0, 0/128.0, 4/128.0, 3/128.0, 8/128.0, },
{ 1/128.0, 2/128.0, 2/128.0, 7/128.0, 11/128.0, 12/128.0, },
{ 2/128.0, 3/128.0, 4/128.0, 8/128.0, 9/128.0, 6/128.0, },
{ 1/128.0, 2/128.0, 4/128.0, 9/128.0, 10/128.0, 14/128.0, },
{ 1/128.0, 1/128.0, 1/128.0, 5/128.0, 6/128.0, 12/128.0, },
{ 1/128.0, 2/128.0, 4/128.0, 8/128.0, 15/128.0, 12/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 8/128.0, 8/128.0, 12/128.0, },
{ 2/128.0, 2/128.0, 4/128.0, 12/128.0, 13/128.0, 14/128.0, },
{ 1/128.0, 3/128.0, 4/128.0, 5/128.0, 6/128.0, 3/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 5/128.0, 12/128.0, 14/128.0, },
{ 2/128.0, 4/128.0, 7/128.0, 9/128.0, 6/128.0, 8/128.0, },
{ 3/128.0, 5/128.0, 6/128.0, 9/128.0, 9/128.0, 13/128.0, },
{ 2/128.0, 2/128.0, 4/128.0, 5/128.0, 8/128.0, 12/128.0, },
{ 2/128.0, 3/128.0, 3/128.0, 8/128.0, 13/128.0, 14/128.0, },
{ 2/128.0, 4/128.0, 5/128.0, 8/128.0, 10/128.0, 10/128.0, },
{ 3/128.0, 5/128.0, 8/128.0, 13/128.0, 11/128.0, 13/128.0, },
{ 1/128.0, 2/128.0, 1/128.0, -3/128.0, 9/128.0, 12/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 5/128.0, 11/128.0, 15/128.0, },
{ 2/128.0, 4/128.0, 5/128.0, 6/128.0, 7/128.0, 6/128.0, },
{ 1/128.0, 2/128.0, 6/128.0, 9/128.0, 11/128.0, 13/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 4/128.0, 8/128.0, 13/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 9/128.0, 15/128.0, 15/128.0, },
{ 2/128.0, 3/128.0, 5/128.0, 7/128.0, 10/128.0, 11/128.0, },
{ 1/128.0, 2/128.0, 6/128.0, 12/128.0, 12/128.0, 19/128.0, },
{ 2/128.0, 3/128.0, 4/128.0, 7/128.0, 3/128.0, 7/128.0, },
{ 2/128.0, 3/128.0, 4/128.0, 5/128.0, 11/128.0, 14/128.0, },
{ 2/128.0, 4/128.0, 5/128.0, 7/128.0, 7/128.0, 12/128.0, },
{ 3/128.0, 4/128.0, 7/128.0, 10/128.0, 13/128.0, 14/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 8/128.0, 9/128.0, 12/128.0, },
{ 2/128.0, 4/128.0, 6/128.0, 6/128.0, 14/128.0, 16/128.0, },
{ 2/128.0, 4/128.0, 7/128.0, 9/128.0, 11/128.0, 8/128.0, },
{ 2/128.0, 4/128.0, 8/128.0, 13/128.0, 19/128.0, 17/128.0, },
{ 1/128.0, 2/128.0, -1/128.0, 6/128.0, 7/128.0, 8/128.0, },
{ 2/128.0, 2/128.0, 0/128.0, 7/128.0, 12/128.0, 12/128.0, },
{ 2/128.0, 3/128.0, 3/128.0, 7/128.0, 9/128.0, 9/128.0, },
{ 2/128.0, 3/128.0, 4/128.0, 10/128.0, 12/128.0, 12/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 3/128.0, 8/128.0, 14/128.0, },
{ 2/128.0, 2/128.0, 3/128.0, 6/128.0, 14/128.0, 15/128.0, },
{ 2/128.0, 3/128.0, 3/128.0, 8/128.0, 10/128.0, 10/128.0, },
{ 2/128.0, 3/128.0, 6/128.0, 17/128.0, 12/128.0, 13/128.0, },
{ 2/128.0, 3/128.0, 3/128.0, 3/128.0, 8/128.0, 7/128.0, },
{ 2/128.0, 2/128.0, 4/128.0, 6/128.0, 10/128.0, 15/128.0, },
{ 2/128.0, 4/128.0, 5/128.0, 8/128.0, 9/128.0, 9/128.0, },
{ 3/128.0, 4/128.0, 5/128.0, 11/128.0, 12/128.0, 12/128.0, },
{ 2/128.0, 3/128.0, 5/128.0, 6/128.0, 7/128.0, 16/128.0, },
{ 2/128.0, 3/128.0, 6/128.0, 9/128.0, 12/128.0, 15/128.0, },
{ 2/128.0, 4/128.0, 5/128.0, 9/128.0, 11/128.0, 11/128.0, },
{ 3/128.0, 7/128.0, 13/128.0, 14/128.0, 12/128.0, 11/128.0, },
{ 2/128.0, 3/128.0, 1/128.0, 2/128.0, 10/128.0, 11/128.0, },
{ 1/128.0, 2/128.0, 4/128.0, 6/128.0, 9/128.0, 18/128.0, },
{ 3/128.0, 4/128.0, 3/128.0, 6/128.0, 9/128.0, 9/128.0, },
{ 2/128.0, 3/128.0, 6/128.0, 7/128.0, 13/128.0, 13/128.0, },
{ 2/128.0, 3/128.0, 4/128.0, 4/128.0, 9/128.0, 10/128.0, },
{ 1/128.0, 2/128.0, 3/128.0, 5/128.0, 16/128.0, 16/128.0, },
{ 2/128.0, 4/128.0, 5/128.0, 7/128.0, 11/128.0, 12/128.0, },
{ 3/128.0, 4/128.0, 6/128.0, 13/128.0, 14/128.0, 15/128.0, },
{ 2/128.0, 4/128.0, 5/128.0, 6/128.0, 5/128.0, 5/128.0, },
{ 2/128.0, 4/128.0, 5/128.0, 6/128.0, 12/128.0, 13/128.0, },
{ 3/128.0, 6/128.0, 7/128.0, 7/128.0, 7/128.0, 8/128.0, },
{ 3/128.0, 6/128.0, 9/128.0, 11/128.0, 13/128.0, 14/128.0, },
{ 2/128.0, 3/128.0, 4/128.0, 6/128.0, 10/128.0, 12/128.0, },
{ 1/128.0, 2/128.0, 4/128.0, 9/128.0, 18/128.0, 17/128.0, },
{ 3/128.0, 5/128.0, 7/128.0, 9/128.0, 9/128.0, 11/128.0, },
{ 2/128.0, 6/128.0, 14/128.0, 16/128.0, 17/128.0, 18/128.0, },
};
static float cbb_new_2kbps[VECSIZEb_NEW_2KBPS][VECDIMb_NEW] = {
/*{ 6.208056e-02, 7.477076e-02, 1.423969e-01, 1.700822e-01, },
{ 1.225756e-01, 1.311538e-01, 1.444104e-01, 1.516270e-01, },
{ 9.616904e-02, 1.223356e-01, 1.376753e-01, 1.460324e-01, },
{ 1.130224e-01, 1.489502e-01, 1.651068e-01, 1.733385e-01, },
{ 9.742060e-02, 1.130903e-01, 1.134073e-01, 1.536922e-01, },
{ 1.182832e-01, 1.414633e-01, 1.531520e-01, 1.618955e-01, },
{ 1.102583e-01, 1.132905e-01, 1.613952e-01, 1.710629e-01, },
{ 1.343293e-01, 1.583298e-01, 1.549358e-01, 1.665651e-01, },
{ 9.140600e-02, 9.686225e-02, 1.374435e-01, 1.671914e-01, },
{ 1.237521e-01, 1.226860e-01, 1.538898e-01, 1.691233e-01, },
{ 1.035638e-01, 1.364799e-01, 1.401655e-01, 1.585466e-01, },
{ 1.290414e-01, 1.334290e-01, 1.707217e-01, 1.787854e-01, },
{ 1.079159e-01, 1.140831e-01, 1.360966e-01, 1.671482e-01, },
{ 1.371496e-01, 1.399661e-01, 1.516342e-01, 1.604622e-01, },
{ 1.061864e-01, 1.282737e-01, 1.518167e-01, 1.786974e-01, },
{ 1.320726e-01, 1.555993e-01, 1.748945e-01, 1.779676e-01, },
{ 7.503726e-02, 1.261574e-01, 1.458380e-01, 1.626444e-01, },
{ 1.262109e-01, 1.457549e-01, 1.371358e-01, 1.590509e-01, },
{ 1.073223e-01, 1.240376e-01, 1.525487e-01, 1.588309e-01, },
{ 1.193443e-01, 1.390541e-01, 1.595118e-01, 1.956630e-01, },
{ 1.173710e-01, 1.273372e-01, 1.226846e-01, 1.519450e-01, },
{ 1.184975e-01, 1.314470e-01, 1.640717e-01, 1.694115e-01, },
{ 8.783529e-02, 1.310374e-01, 1.687269e-01, 1.755562e-01, },
{ 1.522232e-01, 1.536649e-01, 1.658142e-01, 1.741868e-01, },
{ 9.185043e-02, 1.044940e-01, 1.597929e-01, 1.707477e-01, },
{ 1.274252e-01, 1.361541e-01, 1.525096e-01, 1.736927e-01, },
{ 9.837874e-02, 1.419539e-01, 1.553614e-01, 1.641918e-01, },
{ 1.316760e-01, 1.414280e-01, 1.919352e-01, 1.881448e-01, },
{ 1.183328e-01, 1.293738e-01, 1.389249e-01, 1.710850e-01, },
{ 1.348259e-01, 1.435931e-01, 1.631786e-01, 1.711393e-01, },
{ 1.124384e-01, 1.229316e-01, 1.772661e-01, 1.817891e-01, },
{ 1.565102e-01, 1.713467e-01, 1.885431e-01, 1.860870e-01, },*/
{ 8/128.0, 10/128.0, 18/128.0, 22/128.0, },
{ 16/128.0, 17/128.0, 18/128.0, 19/128.0, },
{ 12/128.0, 16/128.0, 18/128.0, 19/128.0, },
{ 14/128.0, 19/128.0, 21/128.0, 22/128.0, },
{ 12/128.0, 14/128.0, 15/128.0, 20/128.0, },
{ 15/128.0, 18/128.0, 20/128.0, 21/128.0, },
{ 14/128.0, 15/128.0, 21/128.0, 22/128.0, },
{ 17/128.0, 20/128.0, 20/128.0, 21/128.0, },
{ 12/128.0, 12/128.0, 18/128.0, 21/128.0, },
{ 16/128.0, 16/128.0, 20/128.0, 22/128.0, },
{ 13/128.0, 17/128.0, 18/128.0, 20/128.0, },
{ 17/128.0, 17/128.0, 22/128.0, 23/128.0, },
{ 14/128.0, 15/128.0, 17/128.0, 21/128.0, },
{ 18/128.0, 18/128.0, 19/128.0, 21/128.0, },
{ 14/128.0, 16/128.0, 19/128.0, 23/128.0, },
{ 17/128.0, 20/128.0, 22/128.0, 23/128.0, },
{ 10/128.0, 16/128.0, 19/128.0, 21/128.0, },
{ 16/128.0, 19/128.0, 18/128.0, 20/128.0, },
{ 14/128.0, 16/128.0, 20/128.0, 20/128.0, },
{ 15/128.0, 18/128.0, 20/128.0, 25/128.0, },
{ 15/128.0, 16/128.0, 16/128.0, 19/128.0, },
{ 15/128.0, 17/128.0, 21/128.0, 22/128.0, },
{ 11/128.0, 17/128.0, 22/128.0, 22/128.0, },
{ 19/128.0, 20/128.0, 21/128.0, 22/128.0, },
{ 12/128.0, 13/128.0, 20/128.0, 22/128.0, },
{ 16/128.0, 17/128.0, 20/128.0, 22/128.0, },
{ 13/128.0, 18/128.0, 20/128.0, 21/128.0, },
{ 17/128.0, 18/128.0, 25/128.0, 24/128.0, },
{ 15/128.0, 17/128.0, 18/128.0, 22/128.0, },
{ 17/128.0, 18/128.0, 21/128.0, 22/128.0, },
{ 14/128.0, 16/128.0, 23/128.0, 23/128.0, },
{ 20/128.0, 22/128.0, 24/128.0, 24/128.0, },
};


static float cba_new[VECSIZEa_NEW][VECDIMa_NEW] = {
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 7 / 128.0, 9 / 128.0, 12 / 128.0,},
    {1 / 128.0, 0 / 128.0, 6 / 128.0, 8 / 128.0, 10 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 5 / 128.0, 9 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 6 / 128.0, 12 / 128.0, 14 / 128.0,},
    {3 / 128.0, 4 / 128.0, 7 / 128.0, 7 / 128.0, 8 / 128.0, 10 / 128.0,},
    {2 / 128.0, 4 / 128.0, 12 / 128.0, 16 / 128.0, 14 / 128.0, 16 / 128.0,},
    {1 / 128.0, 2 / 128.0, 4 / 128.0, 5 / 128.0, 10 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 7 / 128.0, 16 / 128.0, 19 / 128.0, 18 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 9 / 128.0, 11 / 128.0, 12 / 128.0,},
    {3 / 128.0, 3 / 128.0, 4 / 128.0, 10 / 128.0, 11 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 4 / 128.0, 6 / 128.0, 8 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 8 / 128.0, 15 / 128.0, 16 / 128.0,},
    {2 / 128.0, 4 / 128.0, 5 / 128.0, 7 / 128.0, 11 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 11 / 128.0, 11 / 128.0, 14 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 7 / 128.0, 13 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 7 / 128.0, 11 / 128.0, 14 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 8 / 128.0, 9 / 128.0, 11 / 128.0,},
    {1 / 128.0, 2 / 128.0, 4 / 128.0, 7 / 128.0, 11 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 7 / 128.0, 8 / 128.0, 13 / 128.0,},
    {2 / 128.0, 4 / 128.0, 6 / 128.0, 8 / 128.0, 13 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 5 / 128.0, 6 / 128.0, 7 / 128.0,},
    {4 / 128.0, 10 / 128.0, 10 / 128.0, 12 / 128.0, 13 / 128.0, 15 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 8 / 128.0, 9 / 128.0, 12 / 128.0,},
    {1 / 128.0, 1 / 128.0, 6 / 128.0, 11 / 128.0, 11 / 128.0, 14 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 10 / 128.0, 11 / 128.0, 12 / 128.0,},
    {3 / 128.0, 3 / 128.0, 6 / 128.0, 10 / 128.0, 11 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 5 / 128.0, 8 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 8 / 128.0, 12 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 8 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 4 / 128.0, 7 / 128.0, 10 / 128.0, 13 / 128.0, 15 / 128.0,},
    {1 / 128.0, 1 / 128.0, 4 / 128.0, 4 / 128.0, 8 / 128.0, 13 / 128.0,},
    {3 / 128.0, 3 / 128.0, 5 / 128.0, 9 / 128.0, 14 / 128.0, 16 / 128.0,},
    {4 / 128.0, 5 / 128.0, 7 / 128.0, 9 / 128.0, 10 / 128.0, 14 / 128.0,},
    {2 / 128.0, 2 / 128.0, 7 / 128.0, 8 / 128.0, 10 / 128.0, 13 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 7 / 128.0, 8 / 128.0, 14 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 7 / 128.0, 9 / 128.0, 16 / 128.0,},
    {3 / 128.0, 3 / 128.0, 6 / 128.0, 6 / 128.0, 8 / 128.0, 11 / 128.0,},
    {0 / 128.0, 1 / 128.0, 9 / 128.0, 11 / 128.0, 13 / 128.0, 15 / 128.0,},
    {1 / 128.0, 2 / 128.0, 2 / 128.0, 6 / 128.0, 8 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 9 / 128.0, 13 / 128.0, 14 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 7 / 128.0, 10 / 128.0, 10 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 11 / 128.0, 12 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 2 / 128.0, 4 / 128.0, 8 / 128.0, 10 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 9 / 128.0, 19 / 128.0, 17 / 128.0,},
    {3 / 128.0, 3 / 128.0, 6 / 128.0, 8 / 128.0, 9 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 8 / 128.0, 10 / 128.0, 12 / 128.0, 12 / 128.0,},
    {1 / 128.0, 1 / 128.0, 4 / 128.0, 7 / 128.0, 12 / 128.0, 14 / 128.0,},
    {3 / 128.0, 3 / 128.0, 5 / 128.0, 10 / 128.0, 16 / 128.0, 17 / 128.0,},
    {3 / 128.0, 5 / 128.0, 8 / 128.0, 8 / 128.0, 9 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 10 / 128.0, 11 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 5 / 128.0, 6 / 128.0, 15 / 128.0,},
    {3 / 128.0, 5 / 128.0, 6 / 128.0, 7 / 128.0, 11 / 128.0, 11 / 128.0,},
    {2 / 128.0, 4 / 128.0, 4 / 128.0, 7 / 128.0, 8 / 128.0, 8 / 128.0,},
    {2 / 128.0, 7 / 128.0, 17 / 128.0, 14 / 128.0, 11 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 8 / 128.0, 8 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 2 / 128.0, 11 / 128.0, 14 / 128.0, 14 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 9 / 128.0, 10 / 128.0, 13 / 128.0,},
    {1 / 128.0, 2 / 128.0, 2 / 128.0, 10 / 128.0, 12 / 128.0, 12 / 128.0,},
    {1 / 128.0, 2 / 128.0, 2 / 128.0, 5 / 128.0, 6 / 128.0, 12 / 128.0,},
    {1 / 128.0, 1 / 128.0, 2 / 128.0, 6 / 128.0, 14 / 128.0, 16 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 7 / 128.0, 8 / 128.0, 11 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 11 / 128.0, 11 / 128.0, 12 / 128.0,},
    {1 / 128.0, 2 / 128.0, 2 / 128.0, -2 / 128.0, 7 / 128.0, 11 / 128.0,},
    {1 / 128.0, 2 / 128.0, 9 / 128.0, 9 / 128.0, 15 / 128.0, 14 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 7 / 128.0, 8 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 9 / 128.0, 9 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 6 / 128.0, 8 / 128.0, 10 / 128.0,},
    {0 / 128.0, 1 / 128.0, 7 / 128.0, 7 / 128.0, 13 / 128.0, 13 / 128.0,},
    {4 / 128.0, 5 / 128.0, 6 / 128.0, 8 / 128.0, 8 / 128.0, 11 / 128.0,},
    {1 / 128.0, 4 / 128.0, 16 / 128.0, 13 / 128.0, 15 / 128.0, 17 / 128.0,},
    {1 / 128.0, 1 / 128.0, 2 / 128.0, 4 / 128.0, 10 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 2 / 128.0, 12 / 128.0, 16 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 10 / 128.0, 11 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 7 / 128.0, 11 / 128.0, 12 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 4 / 128.0, 3 / 128.0, 8 / 128.0,},
    {2 / 128.0, 3 / 128.0, 3 / 128.0, 8 / 128.0, 14 / 128.0, 17 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 9 / 128.0, 9 / 128.0, 11 / 128.0,},
    {3 / 128.0, 4 / 128.0, 8 / 128.0, 11 / 128.0, 11 / 128.0, 15 / 128.0,},
    {1 / 128.0, 1 / 128.0, 2 / 128.0, 7 / 128.0, 13 / 128.0, 13 / 128.0,},
    {3 / 128.0, 3 / 128.0, 6 / 128.0, 10 / 128.0, 13 / 128.0, 14 / 128.0,},
    {4 / 128.0, 5 / 128.0, 6 / 128.0, 8 / 128.0, 9 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 6 / 128.0, 11 / 128.0, 12 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 6 / 128.0, 8 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 7 / 128.0, 13 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 9 / 128.0, 8 / 128.0, 9 / 128.0,},
    {4 / 128.0, 5 / 128.0, 10 / 128.0, 12 / 128.0, 14 / 128.0, 16 / 128.0,},
    {1 / 128.0, 2 / 128.0, 2 / 128.0, 8 / 128.0, 11 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 12 / 128.0, 14 / 128.0, 13 / 128.0,},
    {4 / 128.0, 7 / 128.0, 8 / 128.0, 9 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 12 / 128.0, 11 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 6 / 128.0, 7 / 128.0, 9 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 7 / 128.0, 14 / 128.0, 17 / 128.0,},
    {3 / 128.0, 3 / 128.0, 7 / 128.0, 9 / 128.0, 11 / 128.0, 11 / 128.0,},
    {2 / 128.0, 4 / 128.0, 5 / 128.0, 7 / 128.0, 12 / 128.0, 13 / 128.0,},
    {1 / 128.0, 2 / 128.0, 2 / 128.0, 5 / 128.0, 12 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 7 / 128.0, 14 / 128.0, 17 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 7 / 128.0, 9 / 128.0, 15 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 9 / 128.0, 10 / 128.0, 14 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 7 / 128.0, 7 / 128.0, 15 / 128.0,},
    {1 / 128.0, 2 / 128.0, 4 / 128.0, 9 / 128.0, 12 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 7 / 128.0, 8 / 128.0, 8 / 128.0,},
    {1 / 128.0, 2 / 128.0, 12 / 128.0, 11 / 128.0, 16 / 128.0, 17 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 5 / 128.0, 10 / 128.0, 10 / 128.0,},
    {1 / 128.0, 1 / 128.0, 9 / 128.0, 16 / 128.0, 15 / 128.0, 16 / 128.0,},
    {3 / 128.0, 3 / 128.0, 5 / 128.0, 9 / 128.0, 9 / 128.0, 11 / 128.0,},
    {1 / 128.0, 1 / 128.0, 7 / 128.0, 10 / 128.0, 11 / 128.0, 12 / 128.0,},
    {1 / 128.0, 1 / 128.0, 2 / 128.0, 6 / 128.0, 8 / 128.0, 8 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 9 / 128.0, 16 / 128.0, 18 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 9 / 128.0, 11 / 128.0, 10 / 128.0,},
    {2 / 128.0, 3 / 128.0, 9 / 128.0, 10 / 128.0, 11 / 128.0, 16 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 7 / 128.0, 10 / 128.0, 13 / 128.0,},
    {2 / 128.0, 4 / 128.0, 5 / 128.0, 8 / 128.0, 14 / 128.0, 15 / 128.0,},
    {4 / 128.0, 6 / 128.0, 7 / 128.0, 9 / 128.0, 8 / 128.0, 9 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 9 / 128.0, 11 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 5 / 128.0, 9 / 128.0, 16 / 128.0,},
    {2 / 128.0, 4 / 128.0, 6 / 128.0, 8 / 128.0, 12 / 128.0, 13 / 128.0,},
    {3 / 128.0, 3 / 128.0, 5 / 128.0, 6 / 128.0, 7 / 128.0, 10 / 128.0,},
    {2 / 128.0, 4 / 128.0, 10 / 128.0, 12 / 128.0, 13 / 128.0, 15 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 6 / 128.0, 9 / 128.0, 8 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 12 / 128.0, 13 / 128.0, 15 / 128.0,},
    {4 / 128.0, 5 / 128.0, 9 / 128.0, 10 / 128.0, 11 / 128.0, 15 / 128.0,},
    {3 / 128.0, 3 / 128.0, 5 / 128.0, 9 / 128.0, 13 / 128.0, 14 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 4 / 128.0, 7 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 6 / 128.0, 14 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 6 / 128.0, 8 / 128.0, 11 / 128.0,},
    {3 / 128.0, 4 / 128.0, 7 / 128.0, 13 / 128.0, 13 / 128.0, 13 / 128.0,},
    {0 / 128.0, 1 / 128.0, 1 / 128.0, 2 / 128.0, 9 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 10 / 128.0, 12 / 128.0, 16 / 128.0,},
    {3 / 128.0, 5 / 128.0, 7 / 128.0, 8 / 128.0, 9 / 128.0, 10 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 7 / 128.0, 9 / 128.0, 15 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 7 / 128.0, 6 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 7 / 128.0, 7 / 128.0, 12 / 128.0, 15 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 6 / 128.0, 5 / 128.0, 8 / 128.0,},
    {3 / 128.0, 7 / 128.0, 12 / 128.0, 16 / 128.0, 16 / 128.0, 17 / 128.0,},
    {1 / 128.0, 1 / 128.0, 4 / 128.0, 5 / 128.0, 12 / 128.0, 14 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 18 / 128.0, 17 / 128.0, 16 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 9 / 128.0, 10 / 128.0, 12 / 128.0,},
    {3 / 128.0, 4 / 128.0, 4 / 128.0, 9 / 128.0, 12 / 128.0, 12 / 128.0,},
    {1 / 128.0, 2 / 128.0, 1 / 128.0, 3 / 128.0, 5 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 7 / 128.0, 13 / 128.0, 17 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 8 / 128.0, 11 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 7 / 128.0, 9 / 128.0, 10 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 5 / 128.0, 11 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 9 / 128.0, 13 / 128.0, 13 / 128.0,},
    {3 / 128.0, 5 / 128.0, 7 / 128.0, 8 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 8 / 128.0, 12 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 3 / 128.0, 6 / 128.0, 12 / 128.0,},
    {3 / 128.0, 5 / 128.0, 6 / 128.0, 7 / 128.0, 12 / 128.0, 14 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 6 / 128.0, 7 / 128.0, 8 / 128.0,},
    {4 / 128.0, 10 / 128.0, 14 / 128.0, 14 / 128.0, 15 / 128.0, 17 / 128.0,},
    {0 / 128.0, 0 / 128.0, 5 / 128.0, 8 / 128.0, 11 / 128.0, 11 / 128.0,},
    {1 / 128.0, 1 / 128.0, 7 / 128.0, 12 / 128.0, 12 / 128.0, 12 / 128.0,},
    {3 / 128.0, 5 / 128.0, 7 / 128.0, 9 / 128.0, 11 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 10 / 128.0, 11 / 128.0, 13 / 128.0,},
    {1 / 128.0, 1 / 128.0, 4 / 128.0, 6 / 128.0, 7 / 128.0, 9 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 6 / 128.0, 12 / 128.0, 14 / 128.0,},
    {1 / 128.0, 1 / 128.0, 7 / 128.0, 7 / 128.0, 9 / 128.0, 12 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 10 / 128.0, 13 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 4 / 128.0, 9 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 8 / 128.0, 15 / 128.0, 16 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 7 / 128.0, 10 / 128.0, 15 / 128.0,},
    {1 / 128.0, 2 / 128.0, 6 / 128.0, 7 / 128.0, 11 / 128.0, 12 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 7 / 128.0, 8 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 8 / 128.0, 10 / 128.0, 17 / 128.0,},
    {3 / 128.0, 3 / 128.0, 5 / 128.0, 8 / 128.0, 8 / 128.0, 9 / 128.0,},
    {1 / 128.0, 1 / 128.0, 7 / 128.0, 14 / 128.0, 15 / 128.0, 19 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 6 / 128.0, 9 / 128.0, 11 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 13 / 128.0, 14 / 128.0, 13 / 128.0,},
    {3 / 128.0, 3 / 128.0, 6 / 128.0, 9 / 128.0, 9 / 128.0, 14 / 128.0,},
    {1 / 128.0, 1 / 128.0, 6 / 128.0, 9 / 128.0, 10 / 128.0, 14 / 128.0,},
    {1 / 128.0, 2 / 128.0, 2 / 128.0, 3 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 8 / 128.0, 16 / 128.0, 21 / 128.0,},
    {2 / 128.0, 4 / 128.0, 7 / 128.0, 8 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 11 / 128.0, 15 / 128.0, 11 / 128.0, 13 / 128.0,},
    {1 / 128.0, 2 / 128.0, 4 / 128.0, 9 / 128.0, 12 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 9 / 128.0, 13 / 128.0, 14 / 128.0,},
    {3 / 128.0, 6 / 128.0, 8 / 128.0, 8 / 128.0, 9 / 128.0, 10 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 9 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 6 / 128.0, 8 / 128.0, 16 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 7 / 128.0, 12 / 128.0, 13 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 6 / 128.0, 7 / 128.0, 9 / 128.0,},
    {1 / 128.0, 3 / 128.0, 13 / 128.0, 12 / 128.0, 12 / 128.0, 15 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 8 / 128.0, 10 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 12 / 128.0, 13 / 128.0, 14 / 128.0,},
    {3 / 128.0, 4 / 128.0, 7 / 128.0, 9 / 128.0, 10 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 11 / 128.0, 11 / 128.0, 14 / 128.0,},
    {1 / 128.0, 1 / 128.0, 3 / 128.0, 5 / 128.0, 6 / 128.0, 12 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 4 / 128.0, 12 / 128.0, 16 / 128.0,},
    {2 / 128.0, 3 / 128.0, 7 / 128.0, 8 / 128.0, 8 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 8 / 128.0, 12 / 128.0, 12 / 128.0, 13 / 128.0,},
    {0 / 128.0, 0 / 128.0, 2 / 128.0, -1 / 128.0, 9 / 128.0, 11 / 128.0,},
    {1 / 128.0, 1 / 128.0, 7 / 128.0, 12 / 128.0, 14 / 128.0, 17 / 128.0,},
    {3 / 128.0, 5 / 128.0, 6 / 128.0, 8 / 128.0, 8 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 7 / 128.0, 9 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 7 / 128.0, 7 / 128.0, 12 / 128.0,},
    {1 / 128.0, 1 / 128.0, 6 / 128.0, 10 / 128.0, 12 / 128.0, 16 / 128.0,},
    {3 / 128.0, 5 / 128.0, 7 / 128.0, 7 / 128.0, 8 / 128.0, 8 / 128.0,},
    {1 / 128.0, 2 / 128.0, 15 / 128.0, 14 / 128.0, 17 / 128.0, 20 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 5 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 14 / 128.0, 15 / 128.0, 16 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 10 / 128.0, 12 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 9 / 128.0, 11 / 128.0, 12 / 128.0,},
    {1 / 128.0, 1 / 128.0, 4 / 128.0, 6 / 128.0, 4 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 9 / 128.0, 14 / 128.0, 16 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 8 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 7 / 128.0, 12 / 128.0, 12 / 128.0, 15 / 128.0,},
    {1 / 128.0, 1 / 128.0, 3 / 128.0, 8 / 128.0, 12 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 8 / 128.0, 14 / 128.0, 15 / 128.0,},
    {3 / 128.0, 5 / 128.0, 6 / 128.0, 8 / 128.0, 10 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 7 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 7 / 128.0, 8 / 128.0, 13 / 128.0,},
    {2 / 128.0, 4 / 128.0, 4 / 128.0, 6 / 128.0, 12 / 128.0, 15 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 6 / 128.0, 7 / 128.0, 9 / 128.0,},
    {5 / 128.0, 9 / 128.0, 10 / 128.0, 8 / 128.0, 12 / 128.0, 14 / 128.0,},
    {0 / 128.0, 1 / 128.0, 3 / 128.0, 6 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 11 / 128.0, 14 / 128.0, 14 / 128.0,},
    {3 / 128.0, 5 / 128.0, 7 / 128.0, 8 / 128.0, 12 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 11 / 128.0, 12 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 5 / 128.0, 6 / 128.0, 9 / 128.0,},
    {1 / 128.0, 1 / 128.0, 3 / 128.0, 6 / 128.0, 12 / 128.0, 17 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 9 / 128.0, 10 / 128.0, 11 / 128.0,},
    {3 / 128.0, 5 / 128.0, 7 / 128.0, 8 / 128.0, 13 / 128.0, 14 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 5 / 128.0, 11 / 128.0, 15 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 8 / 128.0, 15 / 128.0, 17 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 8 / 128.0, 9 / 128.0, 13 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 8 / 128.0, 9 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 8 / 128.0, 9 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 9 / 128.0, 10 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 8 / 128.0, 9 / 128.0, 10 / 128.0,},
    {2 / 128.0, 4 / 128.0, 12 / 128.0, 13 / 128.0, 16 / 128.0, 15 / 128.0,},
    {1 / 128.0, 2 / 128.0, 5 / 128.0, 5 / 128.0, 9 / 128.0, 11 / 128.0,},
    {1 / 128.0, 2 / 128.0, 5 / 128.0, 12 / 128.0, 13 / 128.0, 16 / 128.0,},
    {2 / 128.0, 4 / 128.0, 6 / 128.0, 9 / 128.0, 11 / 128.0, 12 / 128.0,},
    {1 / 128.0, 0 / 128.0, 5 / 128.0, 8 / 128.0, 9 / 128.0, 13 / 128.0,},
    {0 / 128.0, -1 / 128.0, 4 / 128.0, 6 / 128.0, 8 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 7 / 128.0, 16 / 128.0, 17 / 128.0,},
    {3 / 128.0, 5 / 128.0, 6 / 128.0, 8 / 128.0, 9 / 128.0, 10 / 128.0,},
    {1 / 128.0, 2 / 128.0, 9 / 128.0, 9 / 128.0, 12 / 128.0, 14 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 7 / 128.0, 10 / 128.0, 14 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 8 / 128.0, 13 / 128.0, 15 / 128.0,},
    {3 / 128.0, 5 / 128.0, 6 / 128.0, 8 / 128.0, 9 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 10 / 128.0, 12 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 6 / 128.0, 7 / 128.0, 17 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 8 / 128.0, 12 / 128.0, 13 / 128.0,},
    {3 / 128.0, 3 / 128.0, 5 / 128.0, 6 / 128.0, 6 / 128.0, 9 / 128.0,},
    {1 / 128.0, 1 / 128.0, 12 / 128.0, 12 / 128.0, 14 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 2 / 128.0, 7 / 128.0, 8 / 128.0, 9 / 128.0,},
    {3 / 128.0, 3 / 128.0, 5 / 128.0, 12 / 128.0, 14 / 128.0, 15 / 128.0,},
    {3 / 128.0, 4 / 128.0, 9 / 128.0, 10 / 128.0, 12 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 9 / 128.0, 12 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 4 / 128.0, 6 / 128.0, 13 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 4 / 128.0, 13 / 128.0, 13 / 128.0,},
    {2 / 128.0, 4 / 128.0, 5 / 128.0, 5 / 128.0, 10 / 128.0, 10 / 128.0,},
    {3 / 128.0, 3 / 128.0, 6 / 128.0, 11 / 128.0, 12 / 128.0, 13 / 128.0,},
    {0 / 128.0, 1 / 128.0, 0 / 128.0, 3 / 128.0, 11 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 7 / 128.0, 10 / 128.0, 11 / 128.0, 19 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 8 / 128.0, 9 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 8 / 128.0, 10 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 6 / 128.0, 8 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 9 / 128.0, 12 / 128.0, 14 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 7 / 128.0, 7 / 128.0, 10 / 128.0,},
    {1 / 128.0, 2 / 128.0, 15 / 128.0, 19 / 128.0, 14 / 128.0, 16 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 4 / 128.0, 11 / 128.0, 11 / 128.0,},
    {1 / 128.0, 2 / 128.0, 9 / 128.0, 13 / 128.0, 16 / 128.0, 14 / 128.0,},
    {3 / 128.0, 3 / 128.0, 5 / 128.0, 9 / 128.0, 11 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 11 / 128.0, 11 / 128.0, 12 / 128.0,},
    {0 / 128.0, 1 / 128.0, 4 / 128.0, 2 / 128.0, 8 / 128.0, 10 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 7 / 128.0, 13 / 128.0, 15 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 8 / 128.0, 11 / 128.0, 11 / 128.0,},
    {1 / 128.0, 1 / 128.0, 8 / 128.0, 13 / 128.0, 12 / 128.0, 17 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 8 / 128.0, 12 / 128.0, 13 / 128.0,},
    {1 / 128.0, 2 / 128.0, 4 / 128.0, 7 / 128.0, 12 / 128.0, 13 / 128.0,},
    {3 / 128.0, 5 / 128.0, 6 / 128.0, 8 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 8 / 128.0, 13 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 6 / 128.0, 7 / 128.0, 14 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 7 / 128.0, 14 / 128.0, 16 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 7 / 128.0, 6 / 128.0, 5 / 128.0,},
    {5 / 128.0, 7 / 128.0, 13 / 128.0, 15 / 128.0, 12 / 128.0, 15 / 128.0,},
    {1 / 128.0, 2 / 128.0, 5 / 128.0, 7 / 128.0, 8 / 128.0, 11 / 128.0,},
    {0 / 128.0, 0 / 128.0, 7 / 128.0, 11 / 128.0, 13 / 128.0, 14 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 9 / 128.0, 11 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 10 / 128.0, 11 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 6 / 128.0, 6 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 7 / 128.0, 12 / 128.0, 15 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 9 / 128.0, 8 / 128.0, 11 / 128.0,},
    {4 / 128.0, 4 / 128.0, 7 / 128.0, 11 / 128.0, 13 / 128.0, 14 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 5 / 128.0, 8 / 128.0, 15 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 10 / 128.0, 14 / 128.0, 17 / 128.0,},
    {4 / 128.0, 5 / 128.0, 7 / 128.0, 8 / 128.0, 9 / 128.0, 14 / 128.0,},
    {1 / 128.0, 1 / 128.0, 7 / 128.0, 8 / 128.0, 10 / 128.0, 13 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 7 / 128.0, 8 / 128.0, 16 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 8 / 128.0, 11 / 128.0, 17 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 7 / 128.0, 8 / 128.0, 9 / 128.0,},
    {1 / 128.0, 1 / 128.0, 10 / 128.0, 13 / 128.0, 14 / 128.0, 17 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 7 / 128.0, 9 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 8 / 128.0, 14 / 128.0, 13 / 128.0, 16 / 128.0,},
    {2 / 128.0, 3 / 128.0, 7 / 128.0, 10 / 128.0, 10 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 11 / 128.0, 12 / 128.0, 12 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 4 / 128.0, 9 / 128.0, 10 / 128.0,},
    {3 / 128.0, 5 / 128.0, 6 / 128.0, 9 / 128.0, 18 / 128.0, 19 / 128.0,},
    {2 / 128.0, 3 / 128.0, 7 / 128.0, 8 / 128.0, 9 / 128.0, 12 / 128.0,},
    {1 / 128.0, 2 / 128.0, 9 / 128.0, 11 / 128.0, 11 / 128.0, 13 / 128.0,},
    {1 / 128.0, 1 / 128.0, 3 / 128.0, 9 / 128.0, 13 / 128.0, 15 / 128.0,},
    {1 / 128.0, 2 / 128.0, 5 / 128.0, 10 / 128.0, 16 / 128.0, 16 / 128.0,},
    {2 / 128.0, 4 / 128.0, 7 / 128.0, 9 / 128.0, 9 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 8 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 5 / 128.0, 8 / 128.0, 14 / 128.0,},
    {2 / 128.0, 4 / 128.0, 5 / 128.0, 7 / 128.0, 10 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 8 / 128.0, 7 / 128.0, 8 / 128.0,},
    {3 / 128.0, 9 / 128.0, 15 / 128.0, 12 / 128.0, 11 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 8 / 128.0, 9 / 128.0, 10 / 128.0,},
    {1 / 128.0, 1 / 128.0, 4 / 128.0, 10 / 128.0, 14 / 128.0, 14 / 128.0,},
    {3 / 128.0, 5 / 128.0, 8 / 128.0, 9 / 128.0, 10 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 8 / 128.0, 11 / 128.0, 13 / 128.0,},
    {0 / 128.0, 0 / 128.0, 3 / 128.0, 3 / 128.0, 3 / 128.0, 13 / 128.0,},
    {1 / 128.0, 1 / 128.0, 2 / 128.0, 3 / 128.0, 15 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 8 / 128.0, 8 / 128.0, 11 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 10 / 128.0, 11 / 128.0, 13 / 128.0,},
    {1 / 128.0, 1 / 128.0, 0 / 128.0, 0 / 128.0, 8 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 8 / 128.0, 10 / 128.0, 16 / 128.0, 16 / 128.0,},
    {3 / 128.0, 5 / 128.0, 6 / 128.0, 7 / 128.0, 8 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 8 / 128.0, 9 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 6 / 128.0, 7 / 128.0, 12 / 128.0,},
    {1 / 128.0, 1 / 128.0, 7 / 128.0, 7 / 128.0, 14 / 128.0, 16 / 128.0,},
    {4 / 128.0, 6 / 128.0, 6 / 128.0, 8 / 128.0, 10 / 128.0, 9 / 128.0,},
    {1 / 128.0, 2 / 128.0, 12 / 128.0, 13 / 128.0, 16 / 128.0, 19 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 6 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 12 / 128.0, 15 / 128.0, 16 / 128.0,},
    {3 / 128.0, 5 / 128.0, 6 / 128.0, 9 / 128.0, 10 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 10 / 128.0, 11 / 128.0, 12 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 3 / 128.0, 3 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 7 / 128.0, 15 / 128.0, 16 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 8 / 128.0, 9 / 128.0, 11 / 128.0,},
    {3 / 128.0, 4 / 128.0, 9 / 128.0, 13 / 128.0, 11 / 128.0, 16 / 128.0,},
    {1 / 128.0, 2 / 128.0, 2 / 128.0, 6 / 128.0, 13 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 9 / 128.0, 13 / 128.0, 16 / 128.0,},
    {3 / 128.0, 5 / 128.0, 7 / 128.0, 9 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 7 / 128.0, 11 / 128.0, 11 / 128.0,},
    {1 / 128.0, 2 / 128.0, 5 / 128.0, 6 / 128.0, 9 / 128.0, 14 / 128.0,},
    {2 / 128.0, 4 / 128.0, 6 / 128.0, 6 / 128.0, 14 / 128.0, 15 / 128.0,},
    {1 / 128.0, 1 / 128.0, 5 / 128.0, 8 / 128.0, 8 / 128.0, 9 / 128.0,},
    {3 / 128.0, 6 / 128.0, 8 / 128.0, 10 / 128.0, 14 / 128.0, 18 / 128.0,},
    {1 / 128.0, 1 / 128.0, 4 / 128.0, 8 / 128.0, 9 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 12 / 128.0, 14 / 128.0, 14 / 128.0,},
    {4 / 128.0, 5 / 128.0, 7 / 128.0, 9 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 7 / 128.0, 11 / 128.0, 11 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 5 / 128.0, 6 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 7 / 128.0, 13 / 128.0, 16 / 128.0,},
    {1 / 128.0, 1 / 128.0, 8 / 128.0, 10 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 9 / 128.0, 12 / 128.0, 14 / 128.0,},
    {1 / 128.0, 2 / 128.0, 2 / 128.0, 1 / 128.0, 13 / 128.0, 14 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 9 / 128.0, 16 / 128.0, 15 / 128.0,},
    {4 / 128.0, 5 / 128.0, 7 / 128.0, 8 / 128.0, 8 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 8 / 128.0, 9 / 128.0, 13 / 128.0,},
    {3 / 128.0, 3 / 128.0, 5 / 128.0, 6 / 128.0, 7 / 128.0, 15 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 9 / 128.0, 10 / 128.0, 14 / 128.0,},
    {2 / 128.0, 4 / 128.0, 6 / 128.0, 8 / 128.0, 9 / 128.0, 9 / 128.0,},
    {2 / 128.0, 3 / 128.0, 9 / 128.0, 13 / 128.0, 16 / 128.0, 17 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 6 / 128.0, 9 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 13 / 128.0, 15 / 128.0, 17 / 128.0,},
    {3 / 128.0, 4 / 128.0, 7 / 128.0, 9 / 128.0, 10 / 128.0, 11 / 128.0,},
    {1 / 128.0, 2 / 128.0, 5 / 128.0, 11 / 128.0, 10 / 128.0, 12 / 128.0,},
    {1 / 128.0, 2 / 128.0, 1 / 128.0, 7 / 128.0, 8 / 128.0, 9 / 128.0,},
    {2 / 128.0, 3 / 128.0, 3 / 128.0, 10 / 128.0, 15 / 128.0, 18 / 128.0,},
    {4 / 128.0, 4 / 128.0, 5 / 128.0, 10 / 128.0, 8 / 128.0, 9 / 128.0,},
    {1 / 128.0, 2 / 128.0, 10 / 128.0, 11 / 128.0, 12 / 128.0, 14 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 6 / 128.0, 9 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 8 / 128.0, 13 / 128.0, 15 / 128.0,},
    {4 / 128.0, 6 / 128.0, 7 / 128.0, 9 / 128.0, 9 / 128.0, 11 / 128.0,},
    {1 / 128.0, 1 / 128.0, 2 / 128.0, 9 / 128.0, 11 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 4 / 128.0, 7 / 128.0, 19 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 8 / 128.0, 12 / 128.0, 13 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 8 / 128.0, 7 / 128.0, 10 / 128.0,},
    {1 / 128.0, 4 / 128.0, 11 / 128.0, 11 / 128.0, 12 / 128.0, 13 / 128.0,},
    {1 / 128.0, 2 / 128.0, 4 / 128.0, 6 / 128.0, 9 / 128.0, 9 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 12 / 128.0, 13 / 128.0, 14 / 128.0,},
    {4 / 128.0, 5 / 128.0, 7 / 128.0, 8 / 128.0, 10 / 128.0, 16 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 9 / 128.0, 12 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 5 / 128.0, 7 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 7 / 128.0, 14 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 7 / 128.0, 8 / 128.0, 10 / 128.0,},
    {4 / 128.0, 6 / 128.0, 8 / 128.0, 10 / 128.0, 11 / 128.0, 12 / 128.0,},
    {1 / 128.0, 1 / 128.0, 4 / 128.0, 1 / 128.0, 10 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 10 / 128.0, 12 / 128.0, 19 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 8 / 128.0, 9 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 9 / 128.0, 8 / 128.0, 13 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 7 / 128.0, 7 / 128.0, 12 / 128.0,},
    {1 / 128.0, 1 / 128.0, 5 / 128.0, 7 / 128.0, 11 / 128.0, 15 / 128.0,},
    {3 / 128.0, 5 / 128.0, 6 / 128.0, 8 / 128.0, 7 / 128.0, 9 / 128.0,},
    {4 / 128.0, 10 / 128.0, 16 / 128.0, 18 / 128.0, 16 / 128.0, 17 / 128.0,},
    {1 / 128.0, 2 / 128.0, 2 / 128.0, 5 / 128.0, 12 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 15 / 128.0, 16 / 128.0, 15 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 8 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 10 / 128.0, 12 / 128.0, 13 / 128.0,},
    {1 / 128.0, 1 / 128.0, 2 / 128.0, 0 / 128.0, 4 / 128.0, 9 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 7 / 128.0, 13 / 128.0, 20 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 8 / 128.0, 11 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 8 / 128.0, 10 / 128.0, 10 / 128.0, 15 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 6 / 128.0, 12 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 7 / 128.0, 14 / 128.0, 15 / 128.0,},
    {3 / 128.0, 6 / 128.0, 6 / 128.0, 8 / 128.0, 11 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 8 / 128.0, 11 / 128.0, 12 / 128.0,},
    {3 / 128.0, 3 / 128.0, 5 / 128.0, 6 / 128.0, 7 / 128.0, 13 / 128.0,},
    {2 / 128.0, 4 / 128.0, 6 / 128.0, 7 / 128.0, 12 / 128.0, 14 / 128.0,},
    {1 / 128.0, 2 / 128.0, 4 / 128.0, 7 / 128.0, 7 / 128.0, 7 / 128.0,},
    {5 / 128.0, 14 / 128.0, 15 / 128.0, 13 / 128.0, 14 / 128.0, 16 / 128.0,},
    {1 / 128.0, 0 / 128.0, 5 / 128.0, 6 / 128.0, 10 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 14 / 128.0, 12 / 128.0, 13 / 128.0,},
    {4 / 128.0, 5 / 128.0, 6 / 128.0, 10 / 128.0, 12 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 10 / 128.0, 11 / 128.0, 15 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 5 / 128.0, 6 / 128.0, 10 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 6 / 128.0, 13 / 128.0, 16 / 128.0,},
    {1 / 128.0, 2 / 128.0, 8 / 128.0, 8 / 128.0, 10 / 128.0, 10 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 9 / 128.0, 13 / 128.0, 14 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 5 / 128.0, 8 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 9 / 128.0, 14 / 128.0, 15 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 8 / 128.0, 9 / 128.0, 17 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 6 / 128.0, 10 / 128.0, 13 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 7 / 128.0, 9 / 128.0, 14 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 6 / 128.0, 10 / 128.0, 17 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 6 / 128.0, 8 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 9 / 128.0, 10 / 128.0, 15 / 128.0, 19 / 128.0,},
    {1 / 128.0, 2 / 128.0, 2 / 128.0, 8 / 128.0, 8 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 8 / 128.0, 11 / 128.0, 13 / 128.0, 14 / 128.0,},
    {2 / 128.0, 4 / 128.0, 8 / 128.0, 9 / 128.0, 11 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 7 / 128.0, 9 / 128.0, 11 / 128.0, 13 / 128.0,},
    {1 / 128.0, 1 / 128.0, 1 / 128.0, 5 / 128.0, 10 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 11 / 128.0, 17 / 128.0, 18 / 128.0,},
    {3 / 128.0, 3 / 128.0, 5 / 128.0, 9 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 12 / 128.0, 11 / 128.0, 11 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 8 / 128.0, 13 / 128.0, 14 / 128.0,},
    {3 / 128.0, 3 / 128.0, 4 / 128.0, 10 / 128.0, 13 / 128.0, 16 / 128.0,},
    {3 / 128.0, 5 / 128.0, 7 / 128.0, 8 / 128.0, 10 / 128.0, 10 / 128.0,},
    {1 / 128.0, 1 / 128.0, 5 / 128.0, 9 / 128.0, 10 / 128.0, 10 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 5 / 128.0, 10 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 7 / 128.0, 12 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 5 / 128.0, 7 / 128.0, 9 / 128.0,},
    {1 / 128.0, 4 / 128.0, 15 / 128.0, 11 / 128.0, 12 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 7 / 128.0, 9 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 3 / 128.0, 10 / 128.0, 13 / 128.0, 14 / 128.0,},
    {3 / 128.0, 5 / 128.0, 6 / 128.0, 10 / 128.0, 10 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 3 / 128.0, 10 / 128.0, 13 / 128.0, 12 / 128.0,},
    {1 / 128.0, 1 / 128.0, 5 / 128.0, 6 / 128.0, 6 / 128.0, 13 / 128.0,},
    {1 / 128.0, 2 / 128.0, 2 / 128.0, 4 / 128.0, 14 / 128.0, 17 / 128.0,},
    {2 / 128.0, 3 / 128.0, 7 / 128.0, 8 / 128.0, 6 / 128.0, 11 / 128.0,},
    {3 / 128.0, 4 / 128.0, 7 / 128.0, 10 / 128.0, 13 / 128.0, 13 / 128.0,},
    {0 / 128.0, 0 / 128.0, 3 / 128.0, 1 / 128.0, 9 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 10 / 128.0, 14 / 128.0, 14 / 128.0,},
    {3 / 128.0, 5 / 128.0, 7 / 128.0, 8 / 128.0, 8 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 7 / 128.0, 11 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 6 / 128.0, 7 / 128.0, 11 / 128.0,},
    {1 / 128.0, 2 / 128.0, 5 / 128.0, 8 / 128.0, 12 / 128.0, 15 / 128.0,},
    {3 / 128.0, 5 / 128.0, 6 / 128.0, 7 / 128.0, 8 / 128.0, 10 / 128.0,},
    {1 / 128.0, 3 / 128.0, 17 / 128.0, 16 / 128.0, 17 / 128.0, 19 / 128.0,},
    {2 / 128.0, 3 / 128.0, 3 / 128.0, 6 / 128.0, 11 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 13 / 128.0, 14 / 128.0, 15 / 128.0,},
    {4 / 128.0, 4 / 128.0, 7 / 128.0, 10 / 128.0, 12 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 7 / 128.0, 9 / 128.0, 10 / 128.0, 12 / 128.0,},
    {1 / 128.0, 1 / 128.0, 3 / 128.0, 5 / 128.0, 2 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 3 / 128.0, 7 / 128.0, 12 / 128.0, 16 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 8 / 128.0, 10 / 128.0, 11 / 128.0,},
    {1 / 128.0, 2 / 128.0, 9 / 128.0, 11 / 128.0, 14 / 128.0, 16 / 128.0,},
    {1 / 128.0, 0 / 128.0, 2 / 128.0, 8 / 128.0, 12 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 11 / 128.0, 15 / 128.0, 15 / 128.0,},
    {3 / 128.0, 5 / 128.0, 6 / 128.0, 9 / 128.0, 10 / 128.0, 11 / 128.0,},
    {1 / 128.0, 2 / 128.0, 5 / 128.0, 7 / 128.0, 10 / 128.0, 10 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 6 / 128.0, 8 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 7 / 128.0, 11 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 6 / 128.0, 6 / 128.0, 8 / 128.0,},
    {3 / 128.0, 9 / 128.0, 8 / 128.0, 11 / 128.0, 11 / 128.0, 14 / 128.0,},
    {1 / 128.0, 1 / 128.0, 1 / 128.0, 6 / 128.0, 11 / 128.0, 11 / 128.0,},
    {3 / 128.0, 3 / 128.0, 5 / 128.0, 11 / 128.0, 12 / 128.0, 12 / 128.0,},
    {3 / 128.0, 6 / 128.0, 6 / 128.0, 8 / 128.0, 12 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 7 / 128.0, 11 / 128.0, 11 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 5 / 128.0, 6 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 6 / 128.0, 12 / 128.0, 16 / 128.0,},
    {2 / 128.0, 2 / 128.0, 7 / 128.0, 11 / 128.0, 7 / 128.0, 10 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 10 / 128.0, 13 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 3 / 128.0, 4 / 128.0, 12 / 128.0, 15 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 8 / 128.0, 15 / 128.0, 15 / 128.0,},
    {3 / 128.0, 4 / 128.0, 7 / 128.0, 8 / 128.0, 9 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 7 / 128.0, 9 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 6 / 128.0, 9 / 128.0, 15 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 8 / 128.0, 10 / 128.0, 15 / 128.0,},
    {3 / 128.0, 4 / 128.0, 7 / 128.0, 8 / 128.0, 8 / 128.0, 9 / 128.0,},
    {1 / 128.0, 4 / 128.0, 12 / 128.0, 11 / 128.0, 13 / 128.0, 16 / 128.0,},
    {1 / 128.0, 2 / 128.0, 4 / 128.0, 5 / 128.0, 9 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 13 / 128.0, 14 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 9 / 128.0, 10 / 128.0, 13 / 128.0,},
    {1 / 128.0, 1 / 128.0, 3 / 128.0, 10 / 128.0, 11 / 128.0, 15 / 128.0,},
    {0 / 128.0, 0 / 128.0, 3 / 128.0, 4 / 128.0, 7 / 128.0, 9 / 128.0,},
    {1 / 128.0, 2 / 128.0, 2 / 128.0, 7 / 128.0, 16 / 128.0, 18 / 128.0,},
    {2 / 128.0, 5 / 128.0, 7 / 128.0, 7 / 128.0, 9 / 128.0, 10 / 128.0,},
    {2 / 128.0, 3 / 128.0, 7 / 128.0, 9 / 128.0, 12 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 6 / 128.0, 10 / 128.0, 14 / 128.0,},
    {1 / 128.0, 1 / 128.0, 2 / 128.0, 8 / 128.0, 15 / 128.0, 15 / 128.0,},
    {4 / 128.0, 5 / 128.0, 6 / 128.0, 9 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 9 / 128.0, 11 / 128.0, 12 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 6 / 128.0, 11 / 128.0, 16 / 128.0,},
    {4 / 128.0, 5 / 128.0, 6 / 128.0, 8 / 128.0, 12 / 128.0, 12 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 7 / 128.0, 6 / 128.0, 10 / 128.0,},
    {1 / 128.0, 2 / 128.0, 11 / 128.0, 13 / 128.0, 13 / 128.0, 14 / 128.0,},
    {1 / 128.0, 1 / 128.0, 2 / 128.0, 6 / 128.0, 7 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 11 / 128.0, 14 / 128.0, 15 / 128.0,},
    {3 / 128.0, 5 / 128.0, 7 / 128.0, 10 / 128.0, 11 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 7 / 128.0, 12 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 5 / 128.0, 6 / 128.0, 13 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 4 / 128.0, 14 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 7 / 128.0, 9 / 128.0, 10 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 11 / 128.0, 12 / 128.0, 13 / 128.0,},
    {1 / 128.0, 1 / 128.0, 2 / 128.0, 4 / 128.0, 12 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 8 / 128.0, 9 / 128.0, 12 / 128.0, 18 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 7 / 128.0, 10 / 128.0, 11 / 128.0,},
    {1 / 128.0, 1 / 128.0, 5 / 128.0, 8 / 128.0, 9 / 128.0, 14 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 6 / 128.0, 8 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 8 / 128.0, 11 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 7 / 128.0, 8 / 128.0, 10 / 128.0,},
    {2 / 128.0, 4 / 128.0, 14 / 128.0, 15 / 128.0, 15 / 128.0, 15 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 5 / 128.0, 10 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 7 / 128.0, 12 / 128.0, 20 / 128.0, 16 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 8 / 128.0, 12 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 10 / 128.0, 12 / 128.0, 12 / 128.0,},
    {1 / 128.0, 1 / 128.0, 3 / 128.0, 4 / 128.0, 6 / 128.0, 8 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 6 / 128.0, 15 / 128.0, 16 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 8 / 128.0, 10 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 7 / 128.0, 10 / 128.0, 10 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 8 / 128.0, 12 / 128.0, 14 / 128.0,},
    {1 / 128.0, 2 / 128.0, 5 / 128.0, 7 / 128.0, 12 / 128.0, 14 / 128.0,},
    {2 / 128.0, 4 / 128.0, 6 / 128.0, 8 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 7 / 128.0, 11 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 7 / 128.0, 7 / 128.0, 14 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 8 / 128.0, 13 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 3 / 128.0, 6 / 128.0, 5 / 128.0, 5 / 128.0,},
    {6 / 128.0, 8 / 128.0, 11 / 128.0, 12 / 128.0, 13 / 128.0, 15 / 128.0,},
    {1 / 128.0, 1 / 128.0, 4 / 128.0, 7 / 128.0, 9 / 128.0, 12 / 128.0,},
    {1 / 128.0, 2 / 128.0, 7 / 128.0, 11 / 128.0, 12 / 128.0, 14 / 128.0,},
    {4 / 128.0, 5 / 128.0, 6 / 128.0, 9 / 128.0, 11 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 10 / 128.0, 11 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 6 / 128.0, 8 / 128.0, 10 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 7 / 128.0, 12 / 128.0, 16 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 6 / 128.0, 10 / 128.0, 11 / 128.0,},
    {3 / 128.0, 5 / 128.0, 6 / 128.0, 10 / 128.0, 14 / 128.0, 14 / 128.0,},
    {1 / 128.0, 1 / 128.0, 5 / 128.0, 5 / 128.0, 9 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 9 / 128.0, 15 / 128.0, 16 / 128.0,},
    {4 / 128.0, 5 / 128.0, 8 / 128.0, 8 / 128.0, 9 / 128.0, 14 / 128.0,},
    {2 / 128.0, 2 / 128.0, 8 / 128.0, 9 / 128.0, 9 / 128.0, 14 / 128.0,},
    {3 / 128.0, 3 / 128.0, 6 / 128.0, 6 / 128.0, 8 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 3 / 128.0, 7 / 128.0, 10 / 128.0, 16 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 7 / 128.0, 8 / 128.0, 10 / 128.0,},
    {1 / 128.0, 1 / 128.0, 8 / 128.0, 12 / 128.0, 13 / 128.0, 15 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 6 / 128.0, 8 / 128.0, 13 / 128.0,},
    {3 / 128.0, 3 / 128.0, 8 / 128.0, 13 / 128.0, 14 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 10 / 128.0, 11 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 11 / 128.0, 12 / 128.0, 14 / 128.0,},
    {1 / 128.0, 1 / 128.0, 3 / 128.0, 5 / 128.0, 8 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 7 / 128.0, 19 / 128.0, 18 / 128.0,},
    {3 / 128.0, 3 / 128.0, 7 / 128.0, 9 / 128.0, 10 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 9 / 128.0, 10 / 128.0, 11 / 128.0, 12 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 7 / 128.0, 12 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 10 / 128.0, 15 / 128.0, 16 / 128.0,},
    {2 / 128.0, 5 / 128.0, 7 / 128.0, 9 / 128.0, 11 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 9 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 4 / 128.0, 6 / 128.0, 15 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 7 / 128.0, 11 / 128.0, 12 / 128.0,},
    {2 / 128.0, 4 / 128.0, 5 / 128.0, 6 / 128.0, 9 / 128.0, 9 / 128.0,},
    {2 / 128.0, 4 / 128.0, 15 / 128.0, 14 / 128.0, 12 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 8 / 128.0, 9 / 128.0, 10 / 128.0,},
    {1 / 128.0, 2 / 128.0, 2 / 128.0, 10 / 128.0, 14 / 128.0, 15 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 10 / 128.0, 10 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 9 / 128.0, 11 / 128.0, 13 / 128.0,},
    {1 / 128.0, 2 / 128.0, 1 / 128.0, 4 / 128.0, 7 / 128.0, 12 / 128.0,},
    {1 / 128.0, 1 / 128.0, 2 / 128.0, 4 / 128.0, 15 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 7 / 128.0, 9 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 10 / 128.0, 12 / 128.0, 13 / 128.0,},
    {1 / 128.0, 2 / 128.0, 2 / 128.0, -1 / 128.0, 9 / 128.0, 14 / 128.0,},
    {2 / 128.0, 4 / 128.0, 9 / 128.0, 10 / 128.0, 15 / 128.0, 15 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 7 / 128.0, 8 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 8 / 128.0, 10 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 5 / 128.0, 8 / 128.0, 10 / 128.0,},
    {1 / 128.0, 0 / 128.0, 5 / 128.0, 8 / 128.0, 12 / 128.0, 13 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 7 / 128.0, 8 / 128.0, 10 / 128.0,},
    {1 / 128.0, 2 / 128.0, 14 / 128.0, 15 / 128.0, 15 / 128.0, 17 / 128.0,},
    {1 / 128.0, 2 / 128.0, 2 / 128.0, 5 / 128.0, 10 / 128.0, 12 / 128.0,},
    {1 / 128.0, 2 / 128.0, 4 / 128.0, 13 / 128.0, 15 / 128.0, 16 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 9 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 7 / 128.0, 10 / 128.0, 11 / 128.0, 12 / 128.0,},
    {1 / 128.0, 1 / 128.0, 3 / 128.0, 3 / 128.0, 4 / 128.0, 6 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 8 / 128.0, 14 / 128.0, 16 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 8 / 128.0, 9 / 128.0, 10 / 128.0,},
    {3 / 128.0, 3 / 128.0, 8 / 128.0, 12 / 128.0, 12 / 128.0, 15 / 128.0,},
    {1 / 128.0, 2 / 128.0, 2 / 128.0, 7 / 128.0, 13 / 128.0, 13 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 10 / 128.0, 14 / 128.0, 15 / 128.0,},
    {4 / 128.0, 5 / 128.0, 7 / 128.0, 9 / 128.0, 10 / 128.0, 12 / 128.0,},
    {1 / 128.0, 3 / 128.0, 6 / 128.0, 7 / 128.0, 11 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 6 / 128.0, 8 / 128.0, 16 / 128.0,},
    {2 / 128.0, 4 / 128.0, 5 / 128.0, 7 / 128.0, 12 / 128.0, 15 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 9 / 128.0, 7 / 128.0, 8 / 128.0,},
    {3 / 128.0, 6 / 128.0, 8 / 128.0, 14 / 128.0, 14 / 128.0, 15 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 8 / 128.0, 10 / 128.0, 12 / 128.0,},
    {1 / 128.0, 2 / 128.0, 6 / 128.0, 11 / 128.0, 13 / 128.0, 14 / 128.0,},
    {4 / 128.0, 6 / 128.0, 7 / 128.0, 9 / 128.0, 10 / 128.0, 11 / 128.0,},
    {3 / 128.0, 3 / 128.0, 6 / 128.0, 11 / 128.0, 12 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 6 / 128.0, 7 / 128.0, 10 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 7 / 128.0, 14 / 128.0, 16 / 128.0,},
    {2 / 128.0, 3 / 128.0, 8 / 128.0, 10 / 128.0, 10 / 128.0, 11 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 7 / 128.0, 12 / 128.0, 14 / 128.0,},
    {1 / 128.0, 1 / 128.0, 2 / 128.0, 3 / 128.0, 11 / 128.0, 16 / 128.0,},
    {2 / 128.0, 4 / 128.0, 5 / 128.0, 7 / 128.0, 15 / 128.0, 17 / 128.0,},
    {4 / 128.0, 4 / 128.0, 6 / 128.0, 7 / 128.0, 8 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 7 / 128.0, 9 / 128.0, 10 / 128.0, 14 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 6 / 128.0, 8 / 128.0, 15 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 10 / 128.0, 12 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 6 / 128.0, 7 / 128.0, 9 / 128.0,},
    {2 / 128.0, 3 / 128.0, 11 / 128.0, 11 / 128.0, 18 / 128.0, 18 / 128.0,},
    {1 / 128.0, 2 / 128.0, 4 / 128.0, 5 / 128.0, 10 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 9 / 128.0, 15 / 128.0, 15 / 128.0, 16 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 10 / 128.0, 10 / 128.0, 11 / 128.0,},
    {1 / 128.0, 2 / 128.0, 7 / 128.0, 9 / 128.0, 12 / 128.0, 12 / 128.0,},
    {0 / 128.0, 1 / 128.0, 3 / 128.0, 6 / 128.0, 9 / 128.0, 8 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 10 / 128.0, 16 / 128.0, 17 / 128.0,},
    {3 / 128.0, 3 / 128.0, 4 / 128.0, 9 / 128.0, 10 / 128.0, 10 / 128.0,},
    {1 / 128.0, 2 / 128.0, 11 / 128.0, 9 / 128.0, 11 / 128.0, 15 / 128.0,},
    {1 / 128.0, 2 / 128.0, 2 / 128.0, 6 / 128.0, 10 / 128.0, 14 / 128.0,},
    {3 / 128.0, 3 / 128.0, 4 / 128.0, 8 / 128.0, 13 / 128.0, 15 / 128.0,},
    {4 / 128.0, 5 / 128.0, 6 / 128.0, 8 / 128.0, 8 / 128.0, 10 / 128.0,},
    {2 / 128.0, 3 / 128.0, 2 / 128.0, 8 / 128.0, 11 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 5 / 128.0, 9 / 128.0, 17 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 9 / 128.0, 12 / 128.0, 13 / 128.0,},
    {3 / 128.0, 3 / 128.0, 4 / 128.0, 6 / 128.0, 8 / 128.0, 11 / 128.0,},
    {1 / 128.0, 6 / 128.0, 12 / 128.0, 12 / 128.0, 14 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 3 / 128.0, 5 / 128.0, 8 / 128.0, 9 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 12 / 128.0, 13 / 128.0, 14 / 128.0,},
    {5 / 128.0, 5 / 128.0, 8 / 128.0, 10 / 128.0, 10 / 128.0, 16 / 128.0,},
    {3 / 128.0, 4 / 128.0, 4 / 128.0, 8 / 128.0, 13 / 128.0, 14 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 5 / 128.0, 7 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 5 / 128.0, 13 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 7 / 128.0, 8 / 128.0, 11 / 128.0,},
    {4 / 128.0, 5 / 128.0, 9 / 128.0, 13 / 128.0, 11 / 128.0, 13 / 128.0,},
    {0 / 128.0, 0 / 128.0, 3 / 128.0, 2 / 128.0, 10 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 10 / 128.0, 13 / 128.0, 16 / 128.0,},
    {2 / 128.0, 4 / 128.0, 7 / 128.0, 8 / 128.0, 9 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 8 / 128.0, 9 / 128.0, 14 / 128.0,},
    {3 / 128.0, 4 / 128.0, 4 / 128.0, 7 / 128.0, 7 / 128.0, 12 / 128.0,},
    {1 / 128.0, 1 / 128.0, 7 / 128.0, 8 / 128.0, 11 / 128.0, 14 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 7 / 128.0, 7 / 128.0, 8 / 128.0,},
    {3 / 128.0, 7 / 128.0, 15 / 128.0, 15 / 128.0, 15 / 128.0, 17 / 128.0,},
    {1 / 128.0, 1 / 128.0, 4 / 128.0, 6 / 128.0, 12 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 9 / 128.0, 19 / 128.0, 16 / 128.0, 17 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 9 / 128.0, 11 / 128.0, 12 / 128.0,},
    {3 / 128.0, 3 / 128.0, 4 / 128.0, 10 / 128.0, 12 / 128.0, 13 / 128.0,},
    {1 / 128.0, 1 / 128.0, 0 / 128.0, 1 / 128.0, 8 / 128.0, 8 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 7 / 128.0, 14 / 128.0, 18 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 7 / 128.0, 10 / 128.0, 12 / 128.0,},
    {3 / 128.0, 4 / 128.0, 7 / 128.0, 9 / 128.0, 10 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 3 / 128.0, 6 / 128.0, 12 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 8 / 128.0, 13 / 128.0, 15 / 128.0,},
    {3 / 128.0, 6 / 128.0, 7 / 128.0, 8 / 128.0, 11 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 8 / 128.0, 11 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 5 / 128.0, 6 / 128.0, 11 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 7 / 128.0, 11 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 5 / 128.0, 7 / 128.0, 7 / 128.0,},
    {3 / 128.0, 10 / 128.0, 12 / 128.0, 12 / 128.0, 15 / 128.0, 17 / 128.0,},
    {0 / 128.0, 1 / 128.0, 4 / 128.0, 7 / 128.0, 10 / 128.0, 11 / 128.0,},
    {1 / 128.0, 1 / 128.0, 6 / 128.0, 13 / 128.0, 13 / 128.0, 13 / 128.0,},
    {3 / 128.0, 5 / 128.0, 8 / 128.0, 10 / 128.0, 11 / 128.0, 11 / 128.0,},
    {1 / 128.0, 2 / 128.0, 6 / 128.0, 9 / 128.0, 11 / 128.0, 13 / 128.0,},
    {1 / 128.0, 2 / 128.0, 4 / 128.0, 5 / 128.0, 6 / 128.0, 10 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 6 / 128.0, 11 / 128.0, 15 / 128.0,},
    {1 / 128.0, 0 / 128.0, 6 / 128.0, 7 / 128.0, 8 / 128.0, 12 / 128.0,},
    {4 / 128.0, 5 / 128.0, 6 / 128.0, 10 / 128.0, 13 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 4 / 128.0, 9 / 128.0, 15 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 9 / 128.0, 14 / 128.0, 16 / 128.0,},
    {2 / 128.0, 3 / 128.0, 7 / 128.0, 8 / 128.0, 10 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 7 / 128.0, 10 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 7 / 128.0, 7 / 128.0, 8 / 128.0, 14 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 8 / 128.0, 9 / 128.0, 18 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 8 / 128.0, 9 / 128.0, 10 / 128.0,},
    {1 / 128.0, 1 / 128.0, 9 / 128.0, 12 / 128.0, 15 / 128.0, 20 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 7 / 128.0, 9 / 128.0, 10 / 128.0,},
    {3 / 128.0, 5 / 128.0, 7 / 128.0, 12 / 128.0, 15 / 128.0, 13 / 128.0,},
    {3 / 128.0, 4 / 128.0, 7 / 128.0, 8 / 128.0, 10 / 128.0, 14 / 128.0,},
    {1 / 128.0, 2 / 128.0, 6 / 128.0, 9 / 128.0, 11 / 128.0, 14 / 128.0,},
    {1 / 128.0, 2 / 128.0, 2 / 128.0, 3 / 128.0, 8 / 128.0, 10 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 7 / 128.0, 17 / 128.0, 22 / 128.0,},
    {3 / 128.0, 5 / 128.0, 6 / 128.0, 7 / 128.0, 9 / 128.0, 10 / 128.0,},
    {2 / 128.0, 3 / 128.0, 11 / 128.0, 13 / 128.0, 9 / 128.0, 12 / 128.0,},
    {1 / 128.0, 1 / 128.0, 5 / 128.0, 9 / 128.0, 13 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 9 / 128.0, 13 / 128.0, 14 / 128.0,},
    {3 / 128.0, 6 / 128.0, 7 / 128.0, 8 / 128.0, 9 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 10 / 128.0, 9 / 128.0, 10 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 6 / 128.0, 9 / 128.0, 15 / 128.0,},
    {2 / 128.0, 4 / 128.0, 5 / 128.0, 6 / 128.0, 11 / 128.0, 12 / 128.0,},
    {2 / 128.0, 4 / 128.0, 4 / 128.0, 6 / 128.0, 7 / 128.0, 8 / 128.0,},
    {1 / 128.0, 2 / 128.0, 14 / 128.0, 12 / 128.0, 13 / 128.0, 16 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 8 / 128.0, 10 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 10 / 128.0, 13 / 128.0, 14 / 128.0,},
    {3 / 128.0, 4 / 128.0, 7 / 128.0, 8 / 128.0, 9 / 128.0, 14 / 128.0,},
    {1 / 128.0, 2 / 128.0, 4 / 128.0, 11 / 128.0, 12 / 128.0, 13 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 5 / 128.0, 8 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 3 / 128.0, 5 / 128.0, 13 / 128.0, 16 / 128.0,},
    {2 / 128.0, 3 / 128.0, 7 / 128.0, 9 / 128.0, 8 / 128.0, 12 / 128.0,},
    {3 / 128.0, 4 / 128.0, 7 / 128.0, 11 / 128.0, 11 / 128.0, 13 / 128.0,},
    {1 / 128.0, 1 / 128.0, 2 / 128.0, -1 / 128.0, 9 / 128.0, 10 / 128.0,},
    {1 / 128.0, 1 / 128.0, 8 / 128.0, 12 / 128.0, 16 / 128.0, 16 / 128.0,},
    {3 / 128.0, 5 / 128.0, 6 / 128.0, 7 / 128.0, 9 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 7 / 128.0, 10 / 128.0, 13 / 128.0,},
    {1 / 128.0, 2 / 128.0, 4 / 128.0, 7 / 128.0, 8 / 128.0, 11 / 128.0,},
    {1 / 128.0, 1 / 128.0, 6 / 128.0, 8 / 128.0, 12 / 128.0, 18 / 128.0,},
    {3 / 128.0, 5 / 128.0, 7 / 128.0, 7 / 128.0, 8 / 128.0, 9 / 128.0,},
    {2 / 128.0, 3 / 128.0, 13 / 128.0, 16 / 128.0, 18 / 128.0, 18 / 128.0,},
    {1 / 128.0, 1 / 128.0, 3 / 128.0, 6 / 128.0, 11 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 13 / 128.0, 14 / 128.0, 15 / 128.0,},
    {4 / 128.0, 4 / 128.0, 5 / 128.0, 10 / 128.0, 11 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 9 / 128.0, 11 / 128.0, 12 / 128.0,},
    {1 / 128.0, 1 / 128.0, 3 / 128.0, 6 / 128.0, 3 / 128.0, 8 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 9 / 128.0, 13 / 128.0, 17 / 128.0,},
    {3 / 128.0, 3 / 128.0, 4 / 128.0, 9 / 128.0, 9 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 7 / 128.0, 12 / 128.0, 13 / 128.0, 16 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 7 / 128.0, 11 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 7 / 128.0, 9 / 128.0, 14 / 128.0, 14 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 8 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 7 / 128.0, 12 / 128.0, 12 / 128.0,},
    {3 / 128.0, 3 / 128.0, 5 / 128.0, 7 / 128.0, 8 / 128.0, 14 / 128.0,},
    {2 / 128.0, 4 / 128.0, 4 / 128.0, 7 / 128.0, 11 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 7 / 128.0, 8 / 128.0, 9 / 128.0,},
    {2 / 128.0, 7 / 128.0, 10 / 128.0, 11 / 128.0, 13 / 128.0, 15 / 128.0,},
    {1 / 128.0, 1 / 128.0, 3 / 128.0, 6 / 128.0, 10 / 128.0, 11 / 128.0,},
    {3 / 128.0, 3 / 128.0, 5 / 128.0, 10 / 128.0, 13 / 128.0, 14 / 128.0,},
    {3 / 128.0, 6 / 128.0, 8 / 128.0, 9 / 128.0, 11 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 11 / 128.0, 13 / 128.0, 14 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 6 / 128.0, 5 / 128.0, 8 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 6 / 128.0, 13 / 128.0, 17 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 9 / 128.0, 10 / 128.0, 11 / 128.0,},
    {3 / 128.0, 5 / 128.0, 6 / 128.0, 8 / 128.0, 12 / 128.0, 14 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 5 / 128.0, 10 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 3 / 128.0, 9 / 128.0, 15 / 128.0, 16 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 9 / 128.0, 10 / 128.0, 13 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 8 / 128.0, 9 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 7 / 128.0, 8 / 128.0, 15 / 128.0,},
    {3 / 128.0, 3 / 128.0, 6 / 128.0, 10 / 128.0, 10 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 7 / 128.0, 8 / 128.0, 9 / 128.0, 10 / 128.0,},
    {1 / 128.0, 5 / 128.0, 14 / 128.0, 11 / 128.0, 15 / 128.0, 16 / 128.0,},
    {1 / 128.0, 2 / 128.0, 4 / 128.0, 5 / 128.0, 8 / 128.0, 11 / 128.0,},
    {1 / 128.0, 1 / 128.0, 6 / 128.0, 12 / 128.0, 14 / 128.0, 15 / 128.0,},
    {3 / 128.0, 3 / 128.0, 6 / 128.0, 10 / 128.0, 11 / 128.0, 12 / 128.0,},
    {1 / 128.0, 1 / 128.0, 5 / 128.0, 9 / 128.0, 10 / 128.0, 12 / 128.0,},
    {0 / 128.0, 0 / 128.0, 3 / 128.0, 6 / 128.0, 8 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 6 / 128.0, 16 / 128.0, 17 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 8 / 128.0, 9 / 128.0, 10 / 128.0,},
    {2 / 128.0, 3 / 128.0, 8 / 128.0, 7 / 128.0, 11 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 3 / 128.0, 6 / 128.0, 11 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 3 / 128.0, 9 / 128.0, 14 / 128.0, 15 / 128.0,},
    {3 / 128.0, 5 / 128.0, 6 / 128.0, 9 / 128.0, 9 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 10 / 128.0, 11 / 128.0, 8 / 128.0,},
    {3 / 128.0, 3 / 128.0, 5 / 128.0, 5 / 128.0, 7 / 128.0, 17 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 9 / 128.0, 12 / 128.0, 13 / 128.0,},
    {3 / 128.0, 3 / 128.0, 4 / 128.0, 5 / 128.0, 5 / 128.0, 10 / 128.0,},
    {1 / 128.0, 1 / 128.0, 12 / 128.0, 13 / 128.0, 14 / 128.0, 15 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 8 / 128.0, 8 / 128.0, 9 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 12 / 128.0, 14 / 128.0, 15 / 128.0,},
    {2 / 128.0, 5 / 128.0, 9 / 128.0, 10 / 128.0, 12 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 10 / 128.0, 12 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 2 / 128.0, 4 / 128.0, 14 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 5 / 128.0, 13 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 6 / 128.0, 9 / 128.0, 11 / 128.0,},
    {4 / 128.0, 5 / 128.0, 5 / 128.0, 12 / 128.0, 12 / 128.0, 14 / 128.0,},
    {0 / 128.0, 0 / 128.0, 2 / 128.0, 4 / 128.0, 11 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 11 / 128.0, 12 / 128.0, 21 / 128.0,},
    {3 / 128.0, 5 / 128.0, 6 / 128.0, 7 / 128.0, 8 / 128.0, 12 / 128.0,},
    {1 / 128.0, 2 / 128.0, 5 / 128.0, 9 / 128.0, 10 / 128.0, 13 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 6 / 128.0, 8 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 8 / 128.0, 13 / 128.0, 14 / 128.0,},
    {2 / 128.0, 4 / 128.0, 6 / 128.0, 6 / 128.0, 8 / 128.0, 8 / 128.0,},
    {2 / 128.0, 2 / 128.0, 13 / 128.0, 17 / 128.0, 13 / 128.0, 14 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 4 / 128.0, 10 / 128.0, 12 / 128.0,},
    {1 / 128.0, 2 / 128.0, 8 / 128.0, 12 / 128.0, 18 / 128.0, 13 / 128.0,},
    {3 / 128.0, 3 / 128.0, 5 / 128.0, 9 / 128.0, 10 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 10 / 128.0, 11 / 128.0, 13 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 4 / 128.0, 7 / 128.0, 9 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 8 / 128.0, 13 / 128.0, 16 / 128.0,},
    {3 / 128.0, 3 / 128.0, 5 / 128.0, 8 / 128.0, 11 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 7 / 128.0, 11 / 128.0, 11 / 128.0, 16 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 6 / 128.0, 12 / 128.0, 14 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 8 / 128.0, 10 / 128.0, 13 / 128.0,},
    {2 / 128.0, 4 / 128.0, 6 / 128.0, 7 / 128.0, 10 / 128.0, 11 / 128.0,},
    {1 / 128.0, 2 / 128.0, 4 / 128.0, 8 / 128.0, 12 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 6 / 128.0, 7 / 128.0, 14 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 8 / 128.0, 13 / 128.0, 16 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 7 / 128.0, 5 / 128.0, 7 / 128.0,},
    {3 / 128.0, 7 / 128.0, 13 / 128.0, 13 / 128.0, 14 / 128.0, 15 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 7 / 128.0, 8 / 128.0, 12 / 128.0,},
    {1 / 128.0, 1 / 128.0, 5 / 128.0, 11 / 128.0, 12 / 128.0, 15 / 128.0,},
    {4 / 128.0, 5 / 128.0, 6 / 128.0, 10 / 128.0, 11 / 128.0, 12 / 128.0,},
    {3 / 128.0, 3 / 128.0, 5 / 128.0, 11 / 128.0, 12 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 7 / 128.0, 7 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 6 / 128.0, 13 / 128.0, 16 / 128.0,},
    {1 / 128.0, 1 / 128.0, 6 / 128.0, 8 / 128.0, 9 / 128.0, 11 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 11 / 128.0, 14 / 128.0, 14 / 128.0,},
    {1 / 128.0, 1 / 128.0, 2 / 128.0, 5 / 128.0, 8 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 10 / 128.0, 14 / 128.0, 17 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 8 / 128.0, 9 / 128.0, 14 / 128.0,},
    {1 / 128.0, 2 / 128.0, 7 / 128.0, 6 / 128.0, 10 / 128.0, 13 / 128.0,},
    {4 / 128.0, 5 / 128.0, 6 / 128.0, 6 / 128.0, 8 / 128.0, 15 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 7 / 128.0, 10 / 128.0, 16 / 128.0,},
    {2 / 128.0, 4 / 128.0, 5 / 128.0, 7 / 128.0, 9 / 128.0, 10 / 128.0,},
    {1 / 128.0, 2 / 128.0, 11 / 128.0, 11 / 128.0, 13 / 128.0, 17 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 6 / 128.0, 7 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 7 / 128.0, 14 / 128.0, 11 / 128.0, 16 / 128.0,},
    {3 / 128.0, 3 / 128.0, 7 / 128.0, 10 / 128.0, 10 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 9 / 128.0, 11 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 2 / 128.0, 4 / 128.0, 9 / 128.0, 8 / 128.0,},
    {1 / 128.0, 2 / 128.0, 7 / 128.0, 9 / 128.0, 17 / 128.0, 19 / 128.0,},
    {2 / 128.0, 3 / 128.0, 7 / 128.0, 8 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 8 / 128.0, 10 / 128.0, 11 / 128.0, 13 / 128.0,},
    {1 / 128.0, 0 / 128.0, 3 / 128.0, 8 / 128.0, 12 / 128.0, 15 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 10 / 128.0, 14 / 128.0, 15 / 128.0,},
    {3 / 128.0, 5 / 128.0, 7 / 128.0, 8 / 128.0, 9 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 9 / 128.0, 10 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 4 / 128.0, 9 / 128.0, 14 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 8 / 128.0, 10 / 128.0, 12 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 7 / 128.0, 7 / 128.0, 8 / 128.0,},
    {3 / 128.0, 6 / 128.0, 12 / 128.0, 12 / 128.0, 12 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 8 / 128.0, 10 / 128.0, 9 / 128.0,},
    {1 / 128.0, 2 / 128.0, 4 / 128.0, 10 / 128.0, 14 / 128.0, 13 / 128.0,},
    {4 / 128.0, 5 / 128.0, 7 / 128.0, 10 / 128.0, 10 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 8 / 128.0, 12 / 128.0, 13 / 128.0,},
    {1 / 128.0, 1 / 128.0, 3 / 128.0, 2 / 128.0, 6 / 128.0, 13 / 128.0,},
    {1 / 128.0, 1 / 128.0, 1 / 128.0, 5 / 128.0, 14 / 128.0, 14 / 128.0,},
    {3 / 128.0, 3 / 128.0, 5 / 128.0, 8 / 128.0, 9 / 128.0, 11 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 10 / 128.0, 11 / 128.0, 13 / 128.0,},
    {1 / 128.0, 1 / 128.0, 1 / 128.0, 0 / 128.0, 10 / 128.0, 12 / 128.0,},
    {1 / 128.0, 2 / 128.0, 8 / 128.0, 8 / 128.0, 14 / 128.0, 16 / 128.0,},
    {3 / 128.0, 3 / 128.0, 6 / 128.0, 6 / 128.0, 7 / 128.0, 12 / 128.0,},
    {1 / 128.0, 2 / 128.0, 4 / 128.0, 9 / 128.0, 9 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 7 / 128.0, 8 / 128.0, 11 / 128.0,},
    {0 / 128.0, 1 / 128.0, 6 / 128.0, 8 / 128.0, 13 / 128.0, 15 / 128.0,},
    {3 / 128.0, 5 / 128.0, 6 / 128.0, 7 / 128.0, 9 / 128.0, 10 / 128.0,},
    {1 / 128.0, 2 / 128.0, 11 / 128.0, 15 / 128.0, 15 / 128.0, 19 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 5 / 128.0, 10 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 12 / 128.0, 16 / 128.0, 16 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 10 / 128.0, 11 / 128.0, 10 / 128.0,},
    {1 / 128.0, 2 / 128.0, 4 / 128.0, 11 / 128.0, 10 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 3 / 128.0, 5 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 8 / 128.0, 15 / 128.0, 16 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 8 / 128.0, 10 / 128.0, 10 / 128.0,},
    {3 / 128.0, 3 / 128.0, 9 / 128.0, 11 / 128.0, 12 / 128.0, 14 / 128.0,},
    {2 / 128.0, 2 / 128.0, 2 / 128.0, 8 / 128.0, 13 / 128.0, 14 / 128.0,},
    {3 / 128.0, 3 / 128.0, 5 / 128.0, 9 / 128.0, 13 / 128.0, 15 / 128.0,},
    {3 / 128.0, 5 / 128.0, 7 / 128.0, 9 / 128.0, 10 / 128.0, 11 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 7 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 7 / 128.0, 9 / 128.0, 14 / 128.0,},
    {2 / 128.0, 4 / 128.0, 5 / 128.0, 6 / 128.0, 13 / 128.0, 17 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 8 / 128.0, 9 / 128.0, 8 / 128.0,},
    {2 / 128.0, 7 / 128.0, 10 / 128.0, 12 / 128.0, 16 / 128.0, 16 / 128.0,},
    {1 / 128.0, 1 / 128.0, 2 / 128.0, 9 / 128.0, 9 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 12 / 128.0, 13 / 128.0, 15 / 128.0,},
    {3 / 128.0, 6 / 128.0, 7 / 128.0, 8 / 128.0, 11 / 128.0, 11 / 128.0,},
    {3 / 128.0, 3 / 128.0, 6 / 128.0, 11 / 128.0, 12 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 5 / 128.0, 7 / 128.0, 10 / 128.0,},
    {2 / 128.0, 3 / 128.0, 3 / 128.0, 6 / 128.0, 13 / 128.0, 17 / 128.0,},
    {2 / 128.0, 3 / 128.0, 7 / 128.0, 9 / 128.0, 11 / 128.0, 8 / 128.0,},
    {2 / 128.0, 4 / 128.0, 6 / 128.0, 10 / 128.0, 13 / 128.0, 14 / 128.0,},
    {1 / 128.0, 1 / 128.0, 3 / 128.0, 3 / 128.0, 11 / 128.0, 14 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 9 / 128.0, 15 / 128.0, 16 / 128.0,},
    {4 / 128.0, 5 / 128.0, 7 / 128.0, 9 / 128.0, 9 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 8 / 128.0, 10 / 128.0, 13 / 128.0,},
    {3 / 128.0, 3 / 128.0, 5 / 128.0, 5 / 128.0, 7 / 128.0, 15 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 9 / 128.0, 11 / 128.0, 14 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 8 / 128.0, 9 / 128.0, 8 / 128.0,},
    {2 / 128.0, 5 / 128.0, 11 / 128.0, 13 / 128.0, 15 / 128.0, 17 / 128.0,},
    {2 / 128.0, 3 / 128.0, 3 / 128.0, 7 / 128.0, 9 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 7 / 128.0, 13 / 128.0, 14 / 128.0, 16 / 128.0,},
    {3 / 128.0, 3 / 128.0, 7 / 128.0, 9 / 128.0, 9 / 128.0, 11 / 128.0,},
    {1 / 128.0, 1 / 128.0, 5 / 128.0, 10 / 128.0, 11 / 128.0, 12 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 7 / 128.0, 9 / 128.0, 9 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 9 / 128.0, 15 / 128.0, 18 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 9 / 128.0, 9 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 10 / 128.0, 10 / 128.0, 12 / 128.0, 13 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 5 / 128.0, 9 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 3 / 128.0, 7 / 128.0, 13 / 128.0, 14 / 128.0,},
    {4 / 128.0, 5 / 128.0, 7 / 128.0, 9 / 128.0, 9 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 9 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 3 / 128.0, 8 / 128.0, 17 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 8 / 128.0, 11 / 128.0, 12 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 7 / 128.0, 7 / 128.0, 10 / 128.0,},
    {2 / 128.0, 3 / 128.0, 11 / 128.0, 12 / 128.0, 15 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 6 / 128.0, 8 / 128.0, 9 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 12 / 128.0, 13 / 128.0, 15 / 128.0,},
    {3 / 128.0, 4 / 128.0, 8 / 128.0, 8 / 128.0, 10 / 128.0, 17 / 128.0,},
    {3 / 128.0, 3 / 128.0, 4 / 128.0, 9 / 128.0, 13 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 5 / 128.0, 6 / 128.0, 14 / 128.0,},
    {1 / 128.0, 2 / 128.0, 4 / 128.0, 7 / 128.0, 15 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 8 / 128.0, 8 / 128.0, 10 / 128.0,},
    {4 / 128.0, 6 / 128.0, 7 / 128.0, 10 / 128.0, 12 / 128.0, 13 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 2 / 128.0, 10 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 9 / 128.0, 13 / 128.0, 18 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 8 / 128.0, 8 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 8 / 128.0, 7 / 128.0, 13 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 6 / 128.0, 7 / 128.0, 12 / 128.0,},
    {1 / 128.0, 1 / 128.0, 5 / 128.0, 6 / 128.0, 10 / 128.0, 16 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 7 / 128.0, 7 / 128.0, 10 / 128.0,},
    {6 / 128.0, 10 / 128.0, 16 / 128.0, 18 / 128.0, 18 / 128.0, 19 / 128.0,},
    {1 / 128.0, 1 / 128.0, 3 / 128.0, 4 / 128.0, 10 / 128.0, 11 / 128.0,},
    {3 / 128.0, 3 / 128.0, 5 / 128.0, 14 / 128.0, 16 / 128.0, 16 / 128.0,},
    {4 / 128.0, 5 / 128.0, 6 / 128.0, 9 / 128.0, 10 / 128.0, 11 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 10 / 128.0, 12 / 128.0, 12 / 128.0,},
    {1 / 128.0, 0 / 128.0, 4 / 128.0, 1 / 128.0, 4 / 128.0, 10 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 6 / 128.0, 12 / 128.0, 18 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 8 / 128.0, 10 / 128.0, 11 / 128.0,},
    {3 / 128.0, 3 / 128.0, 6 / 128.0, 10 / 128.0, 10 / 128.0, 16 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 5 / 128.0, 12 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 7 / 128.0, 13 / 128.0, 14 / 128.0,},
    {4 / 128.0, 5 / 128.0, 7 / 128.0, 8 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 7 / 128.0, 10 / 128.0, 13 / 128.0,},
    {3 / 128.0, 3 / 128.0, 5 / 128.0, 6 / 128.0, 7 / 128.0, 14 / 128.0,},
    {2 / 128.0, 4 / 128.0, 7 / 128.0, 8 / 128.0, 12 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 7 / 128.0, 7 / 128.0, 8 / 128.0,},
    {3 / 128.0, 14 / 128.0, 16 / 128.0, 9 / 128.0, 9 / 128.0, 13 / 128.0,},
    {1 / 128.0, 1 / 128.0, 5 / 128.0, 7 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 8 / 128.0, 16 / 128.0, 10 / 128.0, 11 / 128.0,},
    {3 / 128.0, 5 / 128.0, 6 / 128.0, 10 / 128.0, 12 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 10 / 128.0, 10 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 4 / 128.0, 6 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 3 / 128.0, 5 / 128.0, 12 / 128.0, 16 / 128.0,},
    {1 / 128.0, 3 / 128.0, 10 / 128.0, 7 / 128.0, 8 / 128.0, 10 / 128.0,},
    {3 / 128.0, 5 / 128.0, 5 / 128.0, 9 / 128.0, 12 / 128.0, 13 / 128.0,},
    {1 / 128.0, 2 / 128.0, 2 / 128.0, 3 / 128.0, 8 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 9 / 128.0, 13 / 128.0, 15 / 128.0,},
    {4 / 128.0, 5 / 128.0, 7 / 128.0, 8 / 128.0, 9 / 128.0, 15 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 6 / 128.0, 11 / 128.0, 13 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 6 / 128.0, 8 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 7 / 128.0, 10 / 128.0, 16 / 128.0,},
    {2 / 128.0, 4 / 128.0, 5 / 128.0, 7 / 128.0, 8 / 128.0, 10 / 128.0,},
    {2 / 128.0, 3 / 128.0, 10 / 128.0, 12 / 128.0, 14 / 128.0, 19 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 8 / 128.0, 8 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 7 / 128.0, 12 / 128.0, 13 / 128.0, 13 / 128.0,},
    {3 / 128.0, 3 / 128.0, 8 / 128.0, 9 / 128.0, 10 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 7 / 128.0, 8 / 128.0, 10 / 128.0, 12 / 128.0,},
    {1 / 128.0, 2 / 128.0, 0 / 128.0, 2 / 128.0, 10 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 11 / 128.0, 19 / 128.0, 21 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 9 / 128.0, 9 / 128.0, 11 / 128.0,},
    {3 / 128.0, 4 / 128.0, 9 / 128.0, 11 / 128.0, 9 / 128.0, 12 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 8 / 128.0, 12 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 10 / 128.0, 14 / 128.0, 15 / 128.0,},
    {3 / 128.0, 6 / 128.0, 7 / 128.0, 9 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 9 / 128.0, 10 / 128.0, 10 / 128.0,},
    {3 / 128.0, 3 / 128.0, 5 / 128.0, 5 / 128.0, 10 / 128.0, 14 / 128.0,},
    {2 / 128.0, 4 / 128.0, 5 / 128.0, 7 / 128.0, 12 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 6 / 128.0, 7 / 128.0, 8 / 128.0,},
    {2 / 128.0, 6 / 128.0, 12 / 128.0, 10 / 128.0, 12 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 7 / 128.0, 9 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 11 / 128.0, 14 / 128.0, 14 / 128.0,},
    {3 / 128.0, 4 / 128.0, 7 / 128.0, 9 / 128.0, 10 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 9 / 128.0, 12 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 6 / 128.0, 7 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 4 / 128.0, 15 / 128.0, 16 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 7 / 128.0, 6 / 128.0, 10 / 128.0,},
    {3 / 128.0, 5 / 128.0, 7 / 128.0, 10 / 128.0, 12 / 128.0, 13 / 128.0,},
    {1 / 128.0, 0 / 128.0, 2 / 128.0, 2 / 128.0, 7 / 128.0, 11 / 128.0,},
    {1 / 128.0, 1 / 128.0, 7 / 128.0, 10 / 128.0, 14 / 128.0, 15 / 128.0,},
    {3 / 128.0, 5 / 128.0, 7 / 128.0, 7 / 128.0, 8 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 7 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 7 / 128.0, 8 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 7 / 128.0, 8 / 128.0, 12 / 128.0, 16 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 7 / 128.0, 8 / 128.0, 9 / 128.0,},
    {1 / 128.0, 4 / 128.0, 17 / 128.0, 17 / 128.0, 18 / 128.0, 20 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 6 / 128.0, 11 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 13 / 128.0, 15 / 128.0, 14 / 128.0,},
    {3 / 128.0, 3 / 128.0, 7 / 128.0, 12 / 128.0, 12 / 128.0, 10 / 128.0,},
    {2 / 128.0, 4 / 128.0, 7 / 128.0, 9 / 128.0, 11 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 6 / 128.0, 0 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 8 / 128.0, 13 / 128.0, 16 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 9 / 128.0, 10 / 128.0, 11 / 128.0,},
    {2 / 128.0, 3 / 128.0, 9 / 128.0, 11 / 128.0, 13 / 128.0, 16 / 128.0,},
    {1 / 128.0, 1 / 128.0, 1 / 128.0, 8 / 128.0, 11 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 9 / 128.0, 13 / 128.0, 14 / 128.0,},
    {3 / 128.0, 5 / 128.0, 6 / 128.0, 8 / 128.0, 11 / 128.0, 12 / 128.0,},
    {1 / 128.0, 2 / 128.0, 5 / 128.0, 7 / 128.0, 10 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 7 / 128.0, 9 / 128.0, 13 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 8 / 128.0, 11 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 7 / 128.0, 7 / 128.0, 9 / 128.0,},
    {5 / 128.0, 7 / 128.0, 8 / 128.0, 10 / 128.0, 12 / 128.0, 14 / 128.0,},
    {0 / 128.0, 0 / 128.0, 2 / 128.0, 7 / 128.0, 9 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 11 / 128.0, 12 / 128.0, 13 / 128.0,},
    {3 / 128.0, 5 / 128.0, 6 / 128.0, 8 / 128.0, 11 / 128.0, 12 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 11 / 128.0, 12 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 3 / 128.0, 5 / 128.0, 6 / 128.0, 10 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 6 / 128.0, 12 / 128.0, 17 / 128.0,},
    {2 / 128.0, 3 / 128.0, 6 / 128.0, 9 / 128.0, 9 / 128.0, 10 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 9 / 128.0, 13 / 128.0, 13 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 3 / 128.0, 11 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 9 / 128.0, 17 / 128.0, 15 / 128.0,},
    {3 / 128.0, 4 / 128.0, 6 / 128.0, 8 / 128.0, 9 / 128.0, 12 / 128.0,},
    {2 / 128.0, 2 / 128.0, 5 / 128.0, 8 / 128.0, 9 / 128.0, 13 / 128.0,},
    {3 / 128.0, 4 / 128.0, 7 / 128.0, 7 / 128.0, 9 / 128.0, 16 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 9 / 128.0, 10 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 7 / 128.0, 8 / 128.0, 8 / 128.0, 9 / 128.0,},
    {2 / 128.0, 3 / 128.0, 11 / 128.0, 12 / 128.0, 14 / 128.0, 16 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 5 / 128.0, 9 / 128.0, 11 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 13 / 128.0, 13 / 128.0, 15 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 9 / 128.0, 10 / 128.0, 12 / 128.0,},
    {1 / 128.0, 1 / 128.0, 3 / 128.0, 9 / 128.0, 10 / 128.0, 13 / 128.0,},
    {0 / 128.0, -1 / 128.0, 3 / 128.0, 5 / 128.0, 9 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 5 / 128.0, 15 / 128.0, 19 / 128.0,},
    {2 / 128.0, 4 / 128.0, 6 / 128.0, 7 / 128.0, 8 / 128.0, 10 / 128.0,},
    {1 / 128.0, 2 / 128.0, 7 / 128.0, 9 / 128.0, 13 / 128.0, 14 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 6 / 128.0, 11 / 128.0, 14 / 128.0,},
    {1 / 128.0, 2 / 128.0, 2 / 128.0, 9 / 128.0, 12 / 128.0, 16 / 128.0,},
    {4 / 128.0, 4 / 128.0, 7 / 128.0, 8 / 128.0, 8 / 128.0, 10 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 9 / 128.0, 11 / 128.0, 11 / 128.0,},
    {3 / 128.0, 3 / 128.0, 6 / 128.0, 6 / 128.0, 9 / 128.0, 18 / 128.0,},
    {3 / 128.0, 5 / 128.0, 6 / 128.0, 9 / 128.0, 12 / 128.0, 12 / 128.0,},
    {3 / 128.0, 3 / 128.0, 5 / 128.0, 6 / 128.0, 7 / 128.0, 11 / 128.0,},
    {1 / 128.0, 1 / 128.0, 10 / 128.0, 13 / 128.0, 12 / 128.0, 15 / 128.0,},
    {1 / 128.0, 2 / 128.0, 3 / 128.0, 6 / 128.0, 8 / 128.0, 10 / 128.0,},
    {2 / 128.0, 2 / 128.0, 4 / 128.0, 11 / 128.0, 15 / 128.0, 15 / 128.0,},
    {3 / 128.0, 4 / 128.0, 8 / 128.0, 10 / 128.0, 11 / 128.0, 14 / 128.0,},
    {2 / 128.0, 2 / 128.0, 6 / 128.0, 9 / 128.0, 12 / 128.0, 12 / 128.0,},
    {2 / 128.0, 3 / 128.0, 4 / 128.0, 5 / 128.0, 5 / 128.0, 13 / 128.0,},
    {2 / 128.0, 2 / 128.0, 3 / 128.0, 6 / 128.0, 13 / 128.0, 14 / 128.0,},
    {2 / 128.0, 3 / 128.0, 5 / 128.0, 7 / 128.0, 10 / 128.0, 10 / 128.0,},
    {3 / 128.0, 4 / 128.0, 5 / 128.0, 10 / 128.0, 11 / 128.0, 14 / 128.0,},
    {1 / 128.0, 2 / 128.0, 0 / 128.0, 4 / 128.0, 12 / 128.0, 13 / 128.0,},
    {1 / 128.0, 2 / 128.0, 8 / 128.0, 10 / 128.0, 12 / 128.0, 18 / 128.0,},
};

static float cbb_new[VECSIZEb_NEW][VECDIMb_NEW] = {
    {13 / 128.0, 18 / 128.0, 22 / 128.0, 22 / 128.0,},
    {15 / 128.0, 17 / 128.0, 23 / 128.0, 23 / 128.0,},
    {13 / 128.0, 16 / 128.0, 19 / 128.0, 20 / 128.0,},
    {16 / 128.0, 19 / 128.0, 20 / 128.0, 21 / 128.0,},
    {10 / 128.0, 11 / 128.0, 18 / 128.0, 21 / 128.0,},
    {17 / 128.0, 19 / 128.0, 19 / 128.0, 20 / 128.0,},
    {15 / 128.0, 16 / 128.0, 17 / 128.0, 19 / 128.0,},
    {16 / 128.0, 17 / 128.0, 20 / 128.0, 21 / 128.0,},
    {13 / 128.0, 15 / 128.0, 20 / 128.0, 21 / 128.0,},
    {22 / 128.0, 22 / 128.0, 22 / 128.0, 23 / 128.0,},
    {14 / 128.0, 17 / 128.0, 17 / 128.0, 21 / 128.0,},
    {15 / 128.0, 18 / 128.0, 19 / 128.0, 20 / 128.0,},
    {12 / 128.0, 14 / 128.0, 18 / 128.0, 20 / 128.0,},
    {18 / 128.0, 20 / 128.0, 22 / 128.0, 22 / 128.0,},
    {16 / 128.0, 16 / 128.0, 17 / 128.0, 18 / 128.0,},
    {14 / 128.0, 15 / 128.0, 22 / 128.0, 23 / 128.0,},
    {12 / 128.0, 18 / 128.0, 20 / 128.0, 21 / 128.0,},
    {17 / 128.0, 18 / 128.0, 21 / 128.0, 22 / 128.0,},
    {14 / 128.0, 17 / 128.0, 19 / 128.0, 21 / 128.0,},
    {16 / 128.0, 18 / 128.0, 19 / 128.0, 20 / 128.0,},
    {11 / 128.0, 14 / 128.0, 20 / 128.0, 21 / 128.0,},
    {18 / 128.0, 19 / 128.0, 21 / 128.0, 22 / 128.0,},
    {12 / 128.0, 16 / 128.0, 17 / 128.0, 19 / 128.0,},
    {16 / 128.0, 17 / 128.0, 21 / 128.0, 22 / 128.0,},
    {13 / 128.0, 15 / 128.0, 21 / 128.0, 22 / 128.0,},
    {18 / 128.0, 18 / 128.0, 24 / 128.0, 24 / 128.0,},
    {14 / 128.0, 15 / 128.0, 19 / 128.0, 20 / 128.0,},
    {17 / 128.0, 17 / 128.0, 19 / 128.0, 21 / 128.0,},
    {14 / 128.0, 15 / 128.0, 17 / 128.0, 20 / 128.0,},
    {20 / 128.0, 20 / 128.0, 20 / 128.0, 21 / 128.0,},
    {14 / 128.0, 15 / 128.0, 15 / 128.0, 20 / 128.0,},
    {15 / 128.0, 16 / 128.0, 20 / 128.0, 22 / 128.0,},
    {11 / 128.0, 17 / 128.0, 21 / 128.0, 22 / 128.0,},
    {15 / 128.0, 19 / 128.0, 21 / 128.0, 22 / 128.0,},
    {12 / 128.0, 16 / 128.0, 19 / 128.0, 20 / 128.0,},
    {14 / 128.0, 19 / 128.0, 20 / 128.0, 21 / 128.0,},
    {12 / 128.0, 12 / 128.0, 19 / 128.0, 21 / 128.0,},
    {18 / 128.0, 18 / 128.0, 19 / 128.0, 21 / 128.0,},
    {15 / 128.0, 17 / 128.0, 18 / 128.0, 20 / 128.0,},
    {16 / 128.0, 17 / 128.0, 20 / 128.0, 22 / 128.0,},
    {13 / 128.0, 14 / 128.0, 20 / 128.0, 22 / 128.0,},
    {19 / 128.0, 21 / 128.0, 23 / 128.0, 23 / 128.0,},
    {15 / 128.0, 16 / 128.0, 18 / 128.0, 21 / 128.0,},
    {16 / 128.0, 17 / 128.0, 18 / 128.0, 19 / 128.0,},
    {12 / 128.0, 13 / 128.0, 16 / 128.0, 20 / 128.0,},
    {19 / 128.0, 20 / 128.0, 21 / 128.0, 22 / 128.0,},
    {16 / 128.0, 17 / 128.0, 16 / 128.0, 19 / 128.0,},
    {15 / 128.0, 16 / 128.0, 21 / 128.0, 22 / 128.0,},
    {13 / 128.0, 17 / 128.0, 20 / 128.0, 22 / 128.0,},
    {18 / 128.0, 18 / 128.0, 22 / 128.0, 22 / 128.0,},
    {15 / 128.0, 17 / 128.0, 20 / 128.0, 20 / 128.0,},
    {16 / 128.0, 18 / 128.0, 20 / 128.0, 21 / 128.0,},
    {9 / 128.0, 16 / 128.0, 18 / 128.0, 20 / 128.0,},
    {17 / 128.0, 18 / 128.0, 20 / 128.0, 21 / 128.0,},
    {13 / 128.0, 17 / 128.0, 18 / 128.0, 19 / 128.0,},
    {15 / 128.0, 18 / 128.0, 21 / 128.0, 22 / 128.0,},
    {12 / 128.0, 13 / 128.0, 22 / 128.0, 23 / 128.0,},
    {17 / 128.0, 19 / 128.0, 23 / 128.0, 23 / 128.0,},
    {15 / 128.0, 16 / 128.0, 20 / 128.0, 21 / 128.0,},
    {16 / 128.0, 17 / 128.0, 18 / 128.0, 21 / 128.0,},
    {13 / 128.0, 14 / 128.0, 17 / 128.0, 21 / 128.0,},
    {18 / 128.0, 19 / 128.0, 20 / 128.0, 21 / 128.0,},
    {14 / 128.0, 15 / 128.0, 15 / 128.0, 17 / 128.0,},
    {14 / 128.0, 17 / 128.0, 21 / 128.0, 21 / 128.0,},
};



static float LSI_SPREAD_FACTOR = 0.005;

float
wvq_a (float *z, int SIZE, int *path1, float (*cb1)[VECDIMa_NEW], float *wt,
       float *wmse)
   /* wt-ed VQ encoding */
{
    int k, n, ind = 0, N = VECDIMa_NEW;
    float mindist = INFINITY, dist, temp, mse;

    for (n = 0; n < SIZE; n++) {
	/* for each codevectors */
	dist = 0;

	for (k = 0; k < N; k++) {
	    temp = (z[k] - cb1[n][k]);
	    dist += temp * temp * wt[k];
	    if (dist > mindist)
		k = N + 10;
	}

	if (dist <= mindist) {
	    mindist = dist;
	    ind = n;
	}

    }				/* for-n */

    mse = mindist;

    path1[0] = ind;
    wmse[0] = mindist;

    return (mse);

}/********************* end wvq2 **********************/

float
wvq_b (float *z, int SIZE, int *path1, float (*cb1)[VECDIMb_NEW], float *wt,
       float *wmse)
   /* wt-ed VQ encoding */
{
    int k, n, ind = 0, N = VECDIMb_NEW;
    float mindist = INFINITY, dist, temp, mse;

    for (n = 0; n < SIZE; n++) {
	/* for each codevectors */
	dist = 0;

	for (k = 0; k < N; k++) {
	    temp = (z[k] - cb1[n][k]);
	    dist += temp * temp * wt[k];
	    if (dist > mindist)
		k = N + 10;
	}

	if (dist <= mindist) {
	    mindist = dist;
	    ind = n;
	}

    }				/* for-n */

    mse = mindist;

    path1[0] = ind;
    wmse[0] = mindist;

    return (mse);

}/********************* end wvq2 **********************/


void
quantize_LSI2 (float *x, double *sens, float *xq, unsigned short *qindex, int FOURGV_2KBPSMODE)
{
    float wt[VECDIM];
    float best_mse, lspq[10], sd, err[10];
    int i, j, best_index;
    float std;
    float part1a[VECDIMa_NEW], part1b[VECDIMb_NEW], wt1a[VECDIMa_NEW],
	wt1b[VECDIMb_NEW];
    int path1a[K], path1b[K];
    float sigP, noiseP;

    float mse1, mse2, dist, temp, out[VECDIM], mse, wmse1a[K], wmse1b[K];
    int worst, sel_index1[K], sel1a[K], sel1b[K];

    float wtsum = 0.0;

    static int open_lsi_file = NO;


    for (j = 0; j < 10; j++)
	wtsum += (float) sens[j];
    for (j = 0; j < 10; j++)
	wt[j] = (float) sens[j] / wtsum;

    for (j = 0; j < VECDIMa_NEW; j++) {
	part1a[j] = x[j];
	wt1a[j] = wt[j];
    }
    for (j = 0; j < VECDIMb_NEW; j++) {
	part1b[j] = x[j + VECDIMa_NEW];
	wt1b[j] = wt[j + VECDIMa_NEW];
    }

  /****** code for new first stage ***/
    if(FOURGV_2KBPSMODE){
		mse1 = wvq_a(part1a, VECSIZEa_NEW_2KBPS, path1a, cba_new_2kbps, wt1a, wmse1a);
		mse2 = wvq_b(part1b, VECSIZEb_NEW_2KBPS, path1b, cbb_new_2kbps, wt1b, wmse1b);
		best_index=64*path1a[0]+path1b[0];
		for (j=0;j<6;j++) xq[j]=cba_new_2kbps[path1a[0]][j];
		for (j=0;j<4;j++) xq[6+j]=cbb_new_2kbps[path1b[0]][j];
	}else{
		mse1 = wvq_a (part1a, VECSIZEa_NEW, path1a, cba_new, wt1a, wmse1a);
		mse2 = wvq_b (part1b, VECSIZEb_NEW, path1b, cbb_new, wt1b, wmse1b);
		best_index = 64 * path1a[0] + path1b[0];
		for (j = 0; j < 6; j++)
			xq[j] = cba_new[path1a[0]][j];
		for (j = 0; j < 4; j++)
			xq[6 + j] = cbb_new[path1b[0]][j];
	}
    qindex[0] = path1a[0];
    qindex[1] = path1b[0];

}


void
unquantize_LSI2 (unsigned short *qindex, float *lspq, int FOURGV_2KBPSMODE)
{
	int j, ind1a, ind1b;

	ind1a = qindex[0];
	ind1b = qindex[1];
	if (FOURGV_2KBPSMODE) {
		for (j=0;j<6;j++) lspq[j]=cba_new_2kbps[ind1a][j];
		for (j=0;j<4;j++) lspq[6+j]=cbb_new_2kbps[ind1b][j];
	} else {
		for (j = 0; j < 6; j++)
			lspq[j] = cba_new[ind1a][j];
		for (j = 0; j < 4; j++)
			lspq[6 + j] = cbb_new[ind1b][j];
	}

}

/************* end new_vq ***************************/


void
stabilize (float *qlsi)
{
    int i;

    if (qlsi[0] < LSI_SPREAD_FACTOR)
	qlsi[0] = LSI_SPREAD_FACTOR;
    for (i = 1; i < ORDER; i++)
	if (qlsi[i] - qlsi[i - 1] < LSI_SPREAD_FACTOR)
	    qlsi[i] = qlsi[i - 1] + LSI_SPREAD_FACTOR;
    if (1.0 - qlsi[ORDER - 1] < 2 * LSI_SPREAD_FACTOR) {
	qlsi[ORDER - 1] = 1.0 - 2 * LSI_SPREAD_FACTOR;
	i = ORDER - 2;
	while (qlsi[i + 1] - qlsi[i] < LSI_SPREAD_FACTOR) {
	    qlsi[i] = qlsi[i + 1] - LSI_SPREAD_FACTOR;
	    i--;
	}
    }
}


/*======================================================================*/
/*  Lucent Technologies Network Wireless Systems                        */
/*  EVRC Floating-point C Simulation.                                   */
/*                                                                      */
/*  Copyright (C) 1996 Lucent Technologies Incorporated. All rights     */
/*  reserved.                                                           */
/*----------------------------------------------------------------------*/
/*  Module:     lspmaq.c                                                */
/*----------------------------------------------------------------------*/
/*  History:                                                            */
/*     01/01/95  Written By Dror Nahumi, AT&T                           */
/*----------------------------------------------------------------------*/

/************************************************************************
*            *****   LSP matrix quantization  ************              *
*                                                                       *
* Input Arguments                                                       *
* ***************                                                       *
* x		Input LSP matrix  x(ndimx,kdim), i.e., kdim rows of     *
*		ndimx elements.                                         *
*		LSP vectors row by row.                                 *
* ndim		Actual vector dimension (LSP order).  ndim <= ndimx     *
* kdim		Number of LSP vectors, i.e., number of rows in the main matrix.
* many		Number of sub-matrices.                                 *
* nsub		Array containing "many" sub-matrices sizes. nsub(i) is the size
*		of the rows in the ith sub-matrix. Sum(i)[ nsub(i) ] = ndim *
* book		(1D). Contains "many" codebooks in series. The ith codebook *
*		contains matices of size kdim rows by nsub(i) columns.      *
*		i.e., kdim vectors of size nsub(i) in series.               *
* alp		Weight adjustment factor.  alp=0  no weight                 *
*                                          alp >0 input is weighted         *
* nsiz		Contain "many" size values. nsiz(i) is the number of matrices *
*		in codebook i.                                                *
*                                                                       *
* Output arguments                                                      *
* ****************                                                      *
* y		Output matrix. The quantized version of x (same size).        *
* index		Contains "many" indices of the best matrix from each codebook *
* d		Aux. array, at least the size of max( nsiz(i) )               *
*                                                                       *
*************************************************************************/
#include "macro.h"
#include "rom.h"

void
lspmaq (float *x, short ndim, short kdim, short many, short *nsub,
	short *nsiz, float alp, float *y, short *index, short br,
	float *lsptab)
{
#define OneDivPI2 0.15915494
    register int i, j, k, m, im, jp, km, jm, jk, jpm, jj, jpmk, kn;
    float dm;
    static float df = 0.05 * OneDivPI2;
    float d[2048];

    jj = 0;

    /* Find weights */
    for (k = 0; k < kdim; k++) {
	kn = k * ndim;
	y[kn] = x[kn + 1] - x[kn];
	y[kn + ndim - 1] = x[kn + ndim - 1] - x[kn + ndim - 2];
	for (i = 1; i < ndim - 1; i++) {
	    y[i + kn] =
		Min (x[i + kn] - x[i - 1 + kn], x[i + 1 + kn] - x[i + kn]);
	}
	for (i = 0; i < ndim; i++) {
	    if (y[i + kn] != 0)
		y[i + kn] = alp / y[i + kn] * OneDivPI2 + 1.0;
	    else
		y[i + kn] = 50.0 * OneDivPI2 + 1.0;
	}
    }

    /* Code all sub-matrices */
    im = 0;
    jp = 0;
    for (m = 0; m < many; m++) {
	for (j = 0; j < nsiz[m]; j++)
	    d[j] = 0;
	km = nsub[m] * kdim;
	for (j = 0; j < nsiz[m]; j++) {
	    jm = km * j;
	    for (k = 0; k < kdim; k++) {
		jk = k * nsub[m];
		kn = k * ndim;
		jpm = jp + jm + jk;
		for (i = 0; i < nsub[m]; i++)
		    d[j] =
			d[j] + y[i + im + kn] * (x[i + im + kn] -
						 lsptab[jpm + i]) * (x[i +
								       im +
								       kn] -
								     lsptab
								     [jpm +
								      i]);
	    }
	}

	if (im > 0) {
	    for (k = 0; k < kdim; k++) {
		jk = k * nsub[m];
		kn = k * ndim;
		for (j = 0; j < nsiz[m]; j++) {
		    jm = km * j;
		    jpm = jp + jm + jk;
		    if (lsptab[jpm] <= y[im - 1 + kn] + df)
			d[j] = 1.0e38;
		}
	    }
	}

	dm = 1.0e38;
	for (j = 0; j < nsiz[m]; j++) {
	    if (d[j] < dm) {
		dm = d[j];
		jj = j;
	    }
	}

	index[m] = jj;

	jpm = jp + km * index[m];
	for (k = 0; k < kdim; k++) {
	    jpmk = jpm + k * nsub[m];
	    kn = k * ndim;
	    for (i = 0; i < nsub[m]; i++)
		y[im + i + kn] = lsptab[jpmk + i];
	}

	im += nsub[m];
	jp += km * nsiz[m];
    }

}

/***************************************************************************
* Routine name: lspmaq_dec                                                 *
* Function: VQ of line spectral frequencies - Decoder part.                *
* Inputs:                                                                  *
*         ndim	- Actual vector dimension (LSP order).                     *
*         kdim	- Number of LSP vectors, i.e., number of rows in the main  *
*                matrix.                                                   *
*         many	- Number of sub-matrices.                                  *
*         nsub	- Array containing "many" sub-matrices sizes. nsub(i) is   *
*                the size of the rows in the ith sub-matrix.               *
*                Sum(i)[ nsub(i) ] = ndim.                                 *
*         book	- (1D). Contains "many" codebooks in series. The ith       *
*                codebook contains matices of size kdim rows by nsub(i)    *
*                columns. i.e., kdim vectors of size nsub(i) in series.    *
*         alp	- Weight adjustment factor. alp=0 no weight. alp >0 input  *
*                is weighted.                                              *
*         nsiz	- Contain "many" size values. nsiz(i) is the number of     *
*                matrices in codebook i.                                   *
*                                                                          *
* Outputs: y	- Output matrix. The quantized version of x (same size).   *
*          index - Contains "many" indices of the best matrix from each    *
*                  codebook.                                               *
*                                                                          *
*                                                                          *
*  Program written by Dror Nahumi, Dep. 45370H                             *
***************************************************************************/
void
lspmaq_dec (short ndim, short kdim, short many, short *nsub,
	    short *nsiz, float *y, short *index, short br, float *lsptab)
{
    register int i, k, m, im, jp, km, jpm, jpmk, kn;

    /* Code all sub-matrices */
    im = 0;
    jp = 0;
    for (m = 0; m < many; m++) {
	km = nsub[m] * kdim;
	jpm = jp + km * index[m];
	for (k = 0; k < kdim; k++) {
	    jpmk = jpm + k * nsub[m];
	    kn = k * ndim;
	    for (i = 0; i < nsub[m]; i++)
		y[im + i + kn] = lsptab[jpmk + i];
	}
	im += nsub[m];
	jp += km * nsiz[m];
    }
}
