/**********************************************************************
Each of the companies; Qualcomm, Motorola, Lucent, and Nokia (hereinafter 
referred to individually as "Source" or collectively as "Sources") do 
hereby state:

To the extent to which the Source(s) may legally and freely do so, the 
Source(s), upon submission of a Contribution, grant(s) a free, 
irrevocable, non-exclusive, license to the Third Generation Partnership 
Project 2 (3GPP2) and its Organizational Partners: ARIB, CCSA, TIA, TTA, 
and TTC, under the Source's copyright or copyright license rights in the 
Contribution, to, in whole or in part, copy, make derivative works, 
perform, display and distribute the Contribution and derivative works 
thereof consistent with 3GPP2's and each Organizational Partner's 
policies and procedures, with the right to (i) sublicense the foregoing 
rights consistent with 3GPP2's and each Organizational Partner's  policies 
and procedures and (ii) copyright and sell, if applicable) in 3GPP2's name 
or each Organizational Partner's name any 3GPP2 or transposed Publication 
even though this Publication may contain the Contribution or a derivative 
work thereof.  The Contribution shall disclose any known limitations on 
the Source's rights to license as herein provided.

When a Contribution is submitted by the Source(s) to assist the 
formulating groups of 3GPP2 or any of its Organizational Partners, it 
is proposed to the Committee as a basis for discussion and is not to 
be construed as a binding proposal on the Source(s).  The Source(s) 
specifically reserve(s) the right to amend or modify the material 
contained in the Contribution. Nothing contained in the Contribution 
shall, except as herein expressly provided, be construed as conferring 
by implication, estoppel or otherwise, any license or right under (i) 
any existing or later issuing patent, whether or not the use of 
information in the document necessarily employs an invention of any 
existing or later issued patent, (ii) any copyright, (iii) any 
trademark, or (iv) any other intellectual property right.

With respect to the Software necessary for the practice of any or 
all Normative portions of the EVRC-WB Variable Rate Speech Codec as 
it exists on the date of submittal of this form, should the EVRC-WB be 
approved as a Specification or Report by 3GPP2, or as a transposed 
Standard by any of the 3GPP2's Organizational Partners, the Source(s) 
state(s) that a worldwide license to reproduce, use and distribute the 
Software, the license rights to which are held by the Source(s), will 
be made available to applicants under terms and conditions that are 
reasonable and non-discriminatory, which may include monetary compensation, 
and only to the extent necessary for the practice of any or all of the 
Normative portions of the EVRC-WB or the field of use of practice of the 
EVRC-WB Specification, Report, or Standard.  The statement contained above 
is irrevocable and shall be binding upon the Source(s).  In the event 
the rights of the Source(s) in and to copyright or copyright license 
rights subject to such commitment are assigned or transferred, the 
Source(s) shall notify the assignee or transferee of the existence of 
such commitments.
*******************************************************************/

static char const rcsid[] =
    "$Id: //E-XMS/GIT/csa/Utilities/cpp/RtpCodecUtil/evrc_nw/mode.cpp#1 $";

/*======================================================================*/
/*  4GV - Fourth Generation Vocoder Speech Service Option for             */
/*  Wideband Spread Spectrum Digital System                             */
/*  C Source Code Simulation                                            */
/*                                                                      */
/*  Copyright (C) 1999 Qualcomm Incorporated. All rights                */
/*  reserved.                                                           */
/*----------------------------------------------------------------------*/

#include <stdio.h>
#include "defines.h"
#include "struct.h"
#include "filt.h"

extern EvrcArgs *Eargs;

int hist[20] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };


static long int RATE[4] = { 0, 24, 48, 96 }; //rate X10




void
FGV_MEM::update_average_rate (int rate)	//valid rates are 1,2,3,4
{
    if (data_packet.WB_MODE_BIT == 0) {
	if (numactive == Eargs->ratewin) {
	    ave_rate_kbps = ave_rate;	//to be used in voiced for ave-rate control
	    // = ar*ratewin*10

	}

	if (Eargs->avg_rate_control) {

	    if (Eargs->operating_point == 0) {


		if (numactive == Eargs->ratewin) {
		    //if initial value of ave_rate_kbps make it equal to target

		    if (ave_rate_kbps == 0)
			ave_rate_kbps =
			    (long int) (Eargs->ratewin *
					Eargs->avg_rate_target * 10);
		    long int avratetarg =
			(long int) ((Eargs->ratewin * 10) * (2 - 0.02) *
				    Eargs->avg_rate_target - ave_rate_kbps);
		    pattern_m =
			(int) (1000 *
			       (avratetarg -
				7.5 * Eargs->ratewin * 10) / (10 *
							      Eargs->ratewin *
							      (9.0 - 7.5)));

		    if (pattern_m < 0)
			pattern_m = 0;

		    if (pattern_m > 1000)
			pattern_m = 1000;
		    patterncount = 0;
		}
	    }
	    if (Eargs->operating_point == 1) {

		if (numactive == Eargs->ratewin) {
		    //if initial value of ave_rate_kbps make it equal to target

		    if (ave_rate_kbps == 0)
			ave_rate_kbps =
			    (long int) (Eargs->ratewin *
					Eargs->avg_rate_target * 10);
		    long int avratetarg =
			(long int) ((Eargs->ratewin * 10) * (2 - 0.00) *
				    Eargs->avg_rate_target - ave_rate_kbps);
		    pattern_m =
			(int) (1000 *
			       (avratetarg -
				6.6 * Eargs->ratewin * 10) / (10 *
							      Eargs->ratewin *
							      (7.5 - 6.6)));

		    if (pattern_m < 0)
			pattern_m = 0;

		    if (pattern_m > 1000)
			pattern_m = 1000;
		    patterncount = 0;

		}
	    }
	    if (Eargs->operating_point == 2) {

		if (numactive == Eargs->ratewin) {
		    //if initial value of ave_rate_kbps make it equal to target

		    if (ave_rate_kbps == 0)
			ave_rate_kbps =
			    (long int) (Eargs->ratewin *
					Eargs->avg_rate_target * 10);
		    long int avratetarg =
			(long int) ((Eargs->ratewin * 10) * (2 - 0.02) *
				    Eargs->avg_rate_target - ave_rate_kbps);
		    pattern_m =
			(int) (1000 *
			       (avratetarg -
				5.75 * Eargs->ratewin * 10) / (10 *
							       Eargs->
							       ratewin *
							       (6.6 - 5.75)));

		    if (pattern_m < 0)
			pattern_m = 0;

		    if (pattern_m > 1000)
			pattern_m = 1000;
		    patterncount = 0;
		}
	    }
	}
    }
    if (numactive == Eargs->ratewin) {
	ave_rate = 0;
	numactive = 0;
    }

    if (rate != 1 && rate!=0) {



	NUMFRAMES[rate - 1]++;
	numactive++;
	ave_rate += RATE[rate - 1];
    }
}
