/**********************************************************************
Each of the companies; Qualcomm, Motorola, Lucent, and Nokia (hereinafter 
referred to individually as "Source" or collectively as "Sources") do 
hereby state:

To the extent to which the Source(s) may legally and freely do so, the 
Source(s), upon submission of a Contribution, grant(s) a free, 
irrevocable, non-exclusive, license to the Third Generation Partnership 
Project 2 (3GPP2) and its Organizational Partners: ARIB, CCSA, TIA, TTA, 
and TTC, under the Source's copyright or copyright license rights in the 
Contribution, to, in whole or in part, copy, make derivative works, 
perform, display and distribute the Contribution and derivative works 
thereof consistent with 3GPP2's and each Organizational Partner's 
policies and procedures, with the right to (i) sublicense the foregoing 
rights consistent with 3GPP2's and each Organizational Partner's  policies 
and procedures and (ii) copyright and sell, if applicable) in 3GPP2's name 
or each Organizational Partner's name any 3GPP2 or transposed Publication 
even though this Publication may contain the Contribution or a derivative 
work thereof.  The Contribution shall disclose any known limitations on 
the Source's rights to license as herein provided.

When a Contribution is submitted by the Source(s) to assist the 
formulating groups of 3GPP2 or any of its Organizational Partners, it 
is proposed to the Committee as a basis for discussion and is not to 
be construed as a binding proposal on the Source(s).  The Source(s) 
specifically reserve(s) the right to amend or modify the material 
contained in the Contribution. Nothing contained in the Contribution 
shall, except as herein expressly provided, be construed as conferring 
by implication, estoppel or otherwise, any license or right under (i) 
any existing or later issuing patent, whether or not the use of 
information in the document necessarily employs an invention of any 
existing or later issued patent, (ii) any copyright, (iii) any 
trademark, or (iv) any other intellectual property right.

With respect to the Software necessary for the practice of any or 
all Normative portions of the EVRC-WB Variable Rate Speech Codec as 
it exists on the date of submittal of this form, should the EVRC-WB be 
approved as a Specification or Report by 3GPP2, or as a transposed 
Standard by any of the 3GPP2's Organizational Partners, the Source(s) 
state(s) that a worldwide license to reproduce, use and distribute the 
Software, the license rights to which are held by the Source(s), will 
be made available to applicants under terms and conditions that are 
reasonable and non-discriminatory, which may include monetary compensation, 
and only to the extent necessary for the practice of any or all of the 
Normative portions of the EVRC-WB or the field of use of practice of the 
EVRC-WB Specification, Report, or Standard.  The statement contained above 
is irrevocable and shall be binding upon the Source(s).  In the event 
the rights of the Source(s) in and to copyright or copyright license 
rights subject to such commitment are assigned or transferred, the 
Source(s) shall notify the assignee or transferee of the existence of 
such commitments.
*******************************************************************/

/*======================================================================*/
/*  4GV - Fourth Generation Vocoder Speech Service Option for             */
/*  Wideband Spread Spectrum Digital System                             */
/*  C Source Code Simulation                                            */
/*                                                                      */
/*  Copyright (C) 1999 Qualcomm Incorporated. All rights                */
/*  reserved.                                                           */
/*----------------------------------------------------------------------*/


#include <stdio.h>
#include "macro.h"
#include "proto.h"
#include "defines.h"
#include "struct.h"
#include "filt.h"
#include "transient_consts.h"
#include "MSencode.h"

#define TURN_ON_DIAGNOSTICS


#define LSP_SPREAD_FACTOR_QPPP 0.01
extern EvrcArgs *Eargs;
extern float tr_lsfcb_6bit_stg1[640],tr_lsfcb_6bit_stg2[640],tr_lsfcb_6bit_stg3[640];
extern float meanlsf[ORDER];


int FGV_MEM::transient_encoder(float *out)
{

    int i,j;
    short   subframesize,trans_strt_loc=0,tsl;
    short unvoiced_q=0;
    TRANSMODE currfrm,prev_frame;
    
    short int_lag,disrupt_cntr_flag=0;
    short trans_next_pk;
    short erflag=0,ill_lag_flg=0;
    short cand_strt_loc[ORDER];
    
    float lagacb[3], frm_egy_evol, enratio,ssum,beta_dummy=0.5;
    short trans_strt_loc_temp,tl;
    float out_temp[FrameSize], tmplsp[ORDER], lpc1[ORDER], lpc2[ORDER], ph_offset = 0.0;
    float delta1, delta2,delta, alpha = 0.5/TWO_PI,tmpwt[ORDER];
    float lpc_circ[ORDER],lsp_circ[ORDER];
    float residual_mod[(FrameSize+LOOKAHEAD_LEN)],modspeech[(FrameSize+LOOKAHEAD_LEN+1)],spfiltmemtemp[ORDER], spt[300];
    short fcflag,mapped_pks[10],spdloc;
    short cutoff_freq=3500;
    



    data_packet.MODE_BIT=2;

    /*************************************************************/
    /*************** LSF QUANTIZATION ****************************/
    /*************************************************************/

    float lsfnq_mr[ORDER],rlsfnq_mr[ORDER];
    short ind1,ind2,ind3;

    //determine weights for LSFs
    for (i = 0; i < ORDER; i++) {
            delta1 = (i == 0) ? lsp_nq[i] : lsp_nq[i] - lsp_nq[i - 1];
            delta2 = (i == ORDER - 1) ? 0.5 - lsp_nq[i] : lsp_nq[i + 1] - lsp_nq[i];
            delta = sqrt (delta1 * delta2);
            tmpwt[i] = alpha / delta;
    }


    //remove lsf mean and scale to frequency
    for (j=0;j<ORDER;j++) lsfnq_mr[j]=((8000*lsp_nq[j])-meanlsf[j]);


    //quantize the lsfs
    MSencode_3stage(lsfnq_mr,tmpwt,&(data_packet.LSP_IDX[0]),&(data_packet.LSP_IDX[1]),&(data_packet.LSP_IDX[2]),
                     rlsfnq_mr,ORDER,64,64,64,8,tr_lsfcb_6bit_stg1,tr_lsfcb_6bit_stg2,tr_lsfcb_6bit_stg3);

    for(j=0;j<3;j++) trans_model.lpc_quant_indx[j]=data_packet.LSP_IDX[j];

    //rescale back to the typical lsp range of 0-0.5
    for (j=0;j<ORDER;j++) lsp[j]= (rlsfnq_mr[j]+meanlsf[j])/8000;

      


    //stabilize the lsps
    {

        if (lsp[0]<LSP_SPREAD_FACTOR_QPPP) lsp[0]=LSP_SPREAD_FACTOR_QPPP;
        for (i=1; i<ORDER; i++)
            if (lsp[i]-lsp[i-1]<LSP_SPREAD_FACTOR_QPPP)
                lsp[i]=lsp[i-1]+LSP_SPREAD_FACTOR_QPPP;
        if (0.5-lsp[ORDER-1]<2*LSP_SPREAD_FACTOR_QPPP) {
            lsp[ORDER-1]=0.5-2*LSP_SPREAD_FACTOR_QPPP;
            i=ORDER-2;
            while ((lsp[i+1]-lsp[i]<LSP_SPREAD_FACTOR_QPPP) && (i>=0)) {
                lsp[i]=MAX(lsp[i+1]-LSP_SPREAD_FACTOR_QPPP,0);
                i--;
            }
        }
    }
    
    for (i=0;i<ORDER;i++) {
#ifdef PREV_CB_LSF_BUGFIX
        cbprevprev_E[i]=lsp[i];
#else
        cbprevprev_E[i]=cbprev_E[i];
#endif
        cbprev_E[i]=lsp[i];
    } 


    for (j=0;j<ORDER;j++) global_lsp[j]=lsp[j];
#ifdef TURN_ON_DIAGNOSTICS
    if (Eargs->unquantized_lsp) {
        for (i=0;i<ORDER;i++) global_lsp[i]=lsp_nq[i]; 
        for (i=0;i<ORDER;i++) lsp[i]=lsp_nq[i];
    }
#endif

    /*************************************************************/
    /*****REGULARIZATION (RCELP) AND EXTENSION TO LOOKAHEAD*******/
    /*************************************************************/

    float   mres[FrameSize];
    float   targ_speech[FrameSize];
    float   acc3[NoOfSubFrames];

    /* Save target filters' memory for closed loop processing */
    for (i=0;i<ORDER;i++) SynMemoryM2[i]= SynMemoryM[i];
    for (i=0;i<ORDER;i++) WFmemFIR2[i]= WFmemFIR[i];
    for (i=0;i<ORDER;i++) WFmemIIR2[i]= WFmemIIR[i];
    for (i=0;i<ACBMemSize;i++) Excitation2[i]=Excitation[i];
    for (i=0;i<dpm;i++) residualm2[i]=residualm[i];
    delay2=delay, accshift2=accshift, dpm2=dpm, shiftSTATE2=shiftSTATE;
    for (i=0;i<ACBMemSize;i++) bufferm2[i]=bufferm[i];
    float pdelay_save;
    pdelay_save=pdelay;
    // do rcelp for the first FrameSize-dpl samples of the present frame.
    get_rcelp();

    //extend RCELP shift into lookahead
    for(i=0;i<FrameSize;i++) {
        residual_mod[i]=residualm_frame[i];
    }
    for(i=FrameSize,j=0;j<dpm;i++,j++) 
        residual_mod[i]=residualm[j];

	//Alok: bug fixing
	float zp_residual[FrameSize+LOOKAHEAD_8+40];
	for(i=0;i<FrameSize+LOOKAHEAD_8;i++)
        zp_residual[i] = residual[GUARD+i];
    for (i=FrameSize+LOOKAHEAD_8;i<FrameSize+LOOKAHEAD_8+40;i++)
        zp_residual[i] = 0;
	for (i=0;i<(LOOKAHEAD_8-dpm);i++)
        bl_intrp (residual_mod+i+FrameSize+ dpm, zp_residual+FSIZE+ dpm+i,accshift, BLFREQ, BLPRECISION);
	
    for(i=0;i<FrameSize;i++) modspeech[i]=mspeech[i];
	for(i=FrameSize+LOOKAHEAD_LEN;i<FrameSize+LOOKAHEAD_LEN+1;i++) modspeech[i]=0;
    for(i=0;i<ORDER;i++) spfiltmemtemp[i]=SynMemoryM[i];
    lsp2a(pci,lsp,ORDER);
    SynthesisFilter(modspeech+FrameSize,residual_mod+FrameSize,pci,spfiltmemtemp,ORDER,LOOKAHEAD_8);

    


    if(lastrateE==3) pdelay=pdelay_save;
    


    ///residualm_Frame has been populated by get_rcelp()
    for (j=0;j<FSIZE;j++)
        copy[j]=mres[j]=residualm_frame[j];

    /***************************************************************************************/
    /*******ANALYZE/ COPY OVER PARAMETERS FROM THE PREVIOUS FRAME FOR CONTINUOUS SYNTH******/
    /***************************************************************************************/

    if(prev_frm_mode>2) {
        if(beta1>beta) {
            delay=delay1;
            beta=beta1;
        }
    }

    beta_n=beta;


    if(lastrateE==3 ) { //previous frame was voiced QPPP
        if(prev_frm_mode==3) {
            prev_frame.get_signal_peaks(transient_residual,(short) pdelay,(short) pdelay,FrameSize,3,1,&beta_dummy);
            prev_frame.get_last_pk_inframe();
            prev_frame.adj_last_pk_loc();
            if(prev_frame.last_pitchspike+pdelay<FrameSize) // the last pitchspike should be within one pitchcycle of the previous frame.
                prev_frame.last_pitchspike+=(int)pdelay;
            int pf_adjstrt;
            pf_adjstrt=prev_frame.adj_to_minima(prev_frame.last_pitchspike,(int)(0.2*pdelay),FrameSize);
            prev_frame.diffloc=prev_frame.last_pitchspike-pf_adjstrt;
            prev_frame_strt_adj=prev_frame.diffloc;
            tl=prev_frame.last_pitchspike+(short)pdelay-prev_frame_strt_adj;
            if(tl>(FrameSize+140)) tl=(FrameSize+140);
            if(tl<FrameSize) tl=FrameSize;
            lagacb[0]=lagacb[1]=lagacb[2]=pdelay;
            putacbc(&(transient_residual[FrameSize]),&(transient_residual[FrameSize]), 0,tl-FrameSize,0,lagacb,(float)0.9,8);
            for(j=tl;j<(3*FrameSize);j++) transient_residual[j]=0.0;
            estim_loc_first_pk=prev_frame.last_pitchspike+ (short)pdelay;

        }else{
            prev_frame.last_pitchspike=loc_last_pk_prev_frame;
            prev_frame.diffloc=prev_frame_strt_adj;
            tl=prev_frame.last_pitchspike+(short)pdelay-prev_frame_strt_adj;
            if(tl>(FrameSize+140)) tl=(FrameSize+140);
            if(tl<FrameSize) tl=FrameSize;
            for(j=tl;j<(3*FrameSize);j++) transient_residual[j]=0.0;
        }
    }else{
        
        for(j=FrameSize;j<(3*FrameSize);j++) transient_residual[j]=0.0;
        currfrm.last_pk_prev_frm=0;
        prev_frame.last_pitchspike=0;
        prev_frame_strt_adj=0;
        prev_frame.pitchlag_mod=0;
        prev_frame.diffloc=0;
        tl=FrameSize;

    }

    //get the ratio of the energy of the previous frame to the present.
    float tenersp=0.0;
    for(j=0;j<(FrameSize+LOOKAHEAD_LEN);j++) tenersp+=(HPspeech[LOOKAHEAD_8+j]*HPspeech[LOOKAHEAD_8+j]);
    if(prev_frm_spegy>0) frm_egy_evol=tenersp/prev_frm_spegy;
    else frm_egy_evol=0;

    /*************************************************************/
    /******ANALYZE CURRENT FRAME**********************************/
    /*************************************************************/
    
    currfrm.get_signal_peaks(residual_mod,(short)delay,(short)pdelay,(FrameSize+LOOKAHEAD_LEN),prev_frm_mode,frm_egy_evol,&beta_n); //analyze the buffer to estimate the location of peaks in the signal

    if (currfrm.numpeaks_inframe > 0) {
        //determine start and end location of the active region of the frame (for voicing/ sparseness determination).
        //currfrm.det_strt_end(prev_frm_mode, beta_n);
        //based on the latest set of pitch spikes and the previous frame, quit to unvoiced coding if needed
        unvoiced_q=currfrm.addlcheck_if_unvoiced(frm_egy_evol,beta_n,prev_frm_mode);
    }else
        unvoiced_q=1;

    if(unvoiced_q==1) return(1);

 //  currfrm.extract_integer_cyc();
      
   currfrm.adj_cycle_boundry((FrameSize+LOOKAHEAD_LEN));
   currfrm.get_last_pk_inframe();

   
   currfrm.reestimate_pitch((short) pdelay,prev_frm_mode, beta_n,beta_prev,frm_egy_evol,stdy_voiced_cnt, stdy_pitch_flag);

   //Alok
	if(currfrm.numpeaks_inframe == 1 && currfrm.pitchspikes_inframe[0] <= 40 && currfrm.pitchlag_mod < 40 && beta_n < 0.2) unvoiced_q=1; 
	
	if(prev_frm_mode < 3) {
       pdelay=currfrm.pitchlag_mod;
   }


   //currfrm.extract_single_cyc();
  // cutoff_freq=currfrm.estimate_vcf(currfrm.pitchlag_mod,currfrm.SpM_cyc);
   long tempvar[1];
   tempvar[0]=10000;
   spdloc=currfrm.diffloc;
   cutoff_freq=3000;
   currfrm.gen_proto_wf(currfrm.pitchlag_mod,cutoff_freq,tempvar,prev_frame.diffloc);

   trans_model.diffloc= currfrm.diffloc;


    /************************************/
    /*  Synthesize the present frame    */
    /************************************/
   
    /*populate structure needed for reconstruction*/
    trans_model.pitchlag=currfrm.pitchlag_mod;
    for(j=0;j<trans_model.pitchlag;j++) trans_model.prototype[j]=currfrm.pitchproto[j]; 
    /*for(j=0;j<ORDER;j++){
        trans_model.plsp[j]=OldlspE[j];
        trans_model.lsp[j]=lsp[j];
    }*/
    trans_model.plsp = OldlspE;
    trans_model.lsp = lsp;

    if(prev_frm_mode>2)
        trans_model.loc_prev_frm_cyc=prev_frame.last_pitchspike-prev_frame_strt_adj;//FrameSize-(short)pdelay;
    else
        trans_model.loc_prev_frm_cyc=0;
    if(trans_model.loc_prev_frm_cyc<0) {
        trans_model.loc_prev_frm_cyc=0;
        prev_frame_strt_adj=trans_model.loc_prev_frm_cyc;
    }

   
    /* Determine the ratio of the previous frame energy to the present frame energy*/
    float s1=0.0, s2=0.0;

    for (j=0;j<FrameSize;j++) s2+=(residual_mod[j]*residual_mod[j]);
   
    enratio=prev_frm_egy/(s2+1);

    //eliminate the first peak if it has already been included in the previous frame's coding
    if(prev_frm_mode==6 || (prev_frm_mode==3 && fabs(pdelay-trans_model.pitchlag)<15))
        currfrm.eliminate_included_pk(prev_frm_last_coded_pk, estim_loc_first_pk);
    if(currfrm.numpeaks_inframe==0) return(1);
    
        
    /*Determine if the frame is to be coded as an independent frame or dependent frame*/
    trans_model.indep_coding_flag=determine_coding_mode(currfrm.pitchlag_mod,currfrm.numpeaks_inframe, (int)pdelay, enratio,prev_frm_mode,
                                                        currfrm.last_pitchspike, prev_frame.last_pitchspike, currfrm.pitchspikes[0]);

    #ifdef PRN_MODE
    if(trans_model.indep_coding_flag==1)
        printf("%d\n",4);
    else
        printf("%d\n",6);
    #endif    
    
    
    /*Determine and quantize the location of the first peak*/
    
    if(trans_model.indep_coding_flag==0)
        trans_model.loc_first_pk=quantize_loc_first_pk(currfrm.pitchspikes_inframe[0], &(trans_model.loc_first_pk_ind));
        

    /*create a countour for the excitation signal*/
    create_syn_excitation(transient_residual, syn_pkloc, num_syn_pk, trans_model, (int) pdelay, prev_frm_mode,prev_frame.last_pitchspike, &tl);
    
   
    /*map the actual peaks in the residual to the peaks estimated in the spectrum*/
    map_peaks(currfrm.pitchspikes,currfrm.numpeaks, syn_pkloc, num_syn_pk[0],currfrm.pitchlag_mod, mapped_pks);

    prev_frm_last_coded_pk=(FrameSize+LOOKAHEAD_LEN);
    if(mapped_pks[num_syn_pk[0]-1]>FrameSize )  // the last peak included goes past the present frame into the future //&& pitchlag_exceeded!=1
        prev_frm_last_coded_pk=mapped_pks[num_syn_pk[0]-1];

    estim_loc_first_pk=(FrameSize+LOOKAHEAD_LEN);
    for(j=0;j<currfrm.numpeaks;j++) {
        if(currfrm.pitchspikes[j]> mapped_pks[num_syn_pk[0]-1] ) {
           estim_loc_first_pk= currfrm.pitchspikes[j];
           break;
        }
    }
   
    /* FER Protection Parameters*/    
    if(trans_model.indep_coding_flag==1) {
        trans_model.fe_protection=determine_fer_depfrm(trans_model.pitchlag,num_syn_pk[0]);
    }

    /*calculate the gains in the speech domain*/
    estimate_gains(modspeech,&(transient_residual[FrameSize]), syn_pkloc,num_syn_pk, mapped_pks,&trans_model, spdloc,enc_syn_mem,
                   residual_mod, tl);

   
    apply_gains(&(transient_residual[FrameSize]),spt,syn_pkloc,num_syn_pk[0], & trans_model,enc_syn_mem, tl,(int) pdelay);
  
    
    /****************************************/
    /*  update parameters for next frame    */
    /****************************************/
    loc_last_pk_prev_frame=syn_pkloc[num_syn_pk[0]-1];//-currfrm.diffloc; //NOTE: this has to be replaced with the diffloc corresponding to the reconstructed w/f
    for(j=0;j<(FrameSize+LOOKAHEAD_LEN);j++) {
        transient_residual[j]=transient_residual[j+FrameSize];
    }
    prev_frame_strt_adj=trans_model.diffloc;
	
    for(j=0;j<FrameSize;j++) {
        out[j]=transient_residual[j];
    }
    data_packet.PULSE_LAG=(short)(currfrm.pitchlag_mod-20 >= 0 ? currfrm.pitchlag_mod-20:0);
    prev_frame_strt_adj=currfrm.diffloc;
	
    /*********************************************************************************************************************/

#ifdef TURN_ON_DIAGNOSTICS
    if (Eargs->accshift_out) write_samples(1,acc3,3);
    if (Eargs->mform_res_out) write_samples(1,mres,FrameSize);
    if (Eargs->target_speech_out) write_samples(1,targ_speech,FrameSize);
#endif

    /* Update reconstruction filter memory */
    for (i=0;i<NoOfSubFrames;i++) {
        if (i < 2) subframesize = SubFrameSize - 1;
        else subframesize = SubFrameSize;
        /* interpolate lsp */
        Interpol(lspi, OldlspE, lsp, i, ORDER);
        Interpol(lspi_nq, Oldlsp_nq, lsp_nq, i, ORDER);
        /* Convert lsp to PC */
        lsp2a(pci, lspi, ORDER);
        lsp2a(pci_nq, lspi_nq, ORDER);
        /* Update filters memory */
        ZeroInput(zir,pci_nq,pci,out+i*(SubFrameSize-1),GAMMA1,GAMMA2,ORDER,
                  subframesize,1);
    }
    /* Update excitation */
    if (ACBMemSize <= FrameSize)
        for (j=0;j<ACBMemSize;j++) Excitation[j]=out[FrameSize-ACBMemSize+j];
    else {
        for (j=0;j<(ACBMemSize-FrameSize);j++) Excitation[j]=Excitation[FrameSize+j];
        for (j=0;j<FrameSize;j++)Excitation[(ACBMemSize-FrameSize)+j]= out[j];
    }

      
    /* Update encoder variables */

    pdelay = rint(currfrm.pitchlag_mod);
    prev_frame_trans=1;
    return(0);

}

void FGV_MEM::transient_decoder(float *outFbuf, short post_filter,short  *obuf_len)
{

    register int i, j;
    register float *foutP;
    short subframesize,len, offset=0;
    int num_samples;
    int temp_samples_count = 0;
    float  *out=new float[FrameSize]; //buffer to hold decoded residual
    float intfac,beta_dummy=0.5,lagacb[3];
    short trans_strt_loc_temp,tl,dec_dim_adj;
    TRANSMODE prev_frame, currfrmD;
    short cutoff_freq;
    float rlsfnq_mr[ORDER],decsp_buffer[320];
    float delayi[3];

	short redirectVM=0;

	short comp_offset=0;


	for (j=0;j<320;j++) decsp_buffer[j]=0; 
    MSdecode_3stage(trans_model.lpc_quant_indx[0],trans_model.lpc_quant_indx[1],trans_model.lpc_quant_indx[2],
                    rlsfnq_mr,ORDER,tr_lsfcb_6bit_stg1,tr_lsfcb_6bit_stg2,tr_lsfcb_6bit_stg3);
    for (j=0;j<ORDER;j++) lsp[j]= (rlsfnq_mr[j]+meanlsf[j])/8000;



    {
        if (lsp[0]<LSP_SPREAD_FACTOR_QPPP) lsp[0]=LSP_SPREAD_FACTOR_QPPP;
        for (i=1; i<ORDER; i++)
            if (lsp[i]-lsp[i-1]<LSP_SPREAD_FACTOR_QPPP)
                lsp[i]=lsp[i-1]+LSP_SPREAD_FACTOR_QPPP;
        if (0.5-lsp[ORDER-1]<2*LSP_SPREAD_FACTOR_QPPP) {
            lsp[ORDER-1]=0.5-2*LSP_SPREAD_FACTOR_QPPP;
            i=ORDER-2;
            while ((lsp[i+1]-lsp[i]<LSP_SPREAD_FACTOR_QPPP) && (i>=0)) {
                lsp[i]=MAX(lsp[i+1]-LSP_SPREAD_FACTOR_QPPP,0);
                i--;
            }
        }
    }
    for (i=0;i<ORDER;i++) {
#ifdef PREV_CB_LSF_BUGFIX
        cbprevprev_D[i]=lsp[i];
#else
        cbprevprev_D[i]=cbprev_D[i];
#endif
        cbprev_D[i]=lsp[i];
    }

    if(pdelayD > MAXLAG_2KBPS_TRMODE)
      pdelayD=MAXLAG_2KBPS_TRMODE;
	
	trans_model.pitchlag=data_packet.PULSE_LAG+20;
    delay=(float)trans_model.pitchlag;
 
    num_samples = FrameSize; //might need to make dynamic if used in VoIP context
    foutP = outFbuf;
    *obuf_len = num_samples;
    temp_samples_count = 0;

    

    if(lastrateD==3) {
        if(prev_frm_mode==3) {
            prev_frame.get_signal_peaks(transient_residual,(short) pdelayD,(short) pdelayD,FrameSize,3,1,&beta_dummy);
            prev_frame.get_last_pk_inframe();
            prev_frame.adj_last_pk_loc();
            if(prev_frame.last_pitchspike+pdelayD<FrameSize) // the last pitchspike should be within one pitchcycle of the previous frame.
                prev_frame.last_pitchspike+=(int)pdelayD;
            prev_frame.last_pitchspike; 
            int pf_adjstrt;
            pf_adjstrt=prev_frame.adj_to_minima(prev_frame.last_pitchspike,(int)(0.2*pdelayD),FrameSize);
            prev_frame.diffloc=prev_frame.last_pitchspike-pf_adjstrt;
            prev_frame_strt_adj=prev_frame.diffloc;
            tl=prev_frame.last_pitchspike+(short)pdelayD-prev_frame_strt_adj;
            if(tl>(FrameSize+140)) tl=(FrameSize+140);
            if(tl<FrameSize) tl=FrameSize;
            lagacb[0]=lagacb[1]=lagacb[2]=pdelayD;
            putacbc(&(transient_residual[FrameSize]),&(transient_residual[FrameSize]), 0,tl-FrameSize,0,lagacb,(float)0.9,8);
            for(j=tl;j<(3*FrameSize);j++) transient_residual[j]=0.0;
            estim_loc_first_pk=prev_frame.last_pitchspike+(short)pdelayD;

        }else{
            for(j=0;j<FrameSize;j++) prev_frame.resid_signal[j]=transient_residual[j];
            prev_frame.last_pitchspike=loc_last_pk_prev_frame;
            prev_frame.diffloc=prev_frame_strt_adj;
            tl=prev_frame.last_pitchspike+(short)pdelayD-prev_frame_strt_adj;
            if(tl>(FrameSize+140)) tl=(FrameSize+140);
            if(tl<FrameSize) tl=FrameSize;
            for(j=tl;j<(3*FrameSize);j++) transient_residual[j]=0.0;
        }
    }else{
        for(j=FrameSize;j<(3*FrameSize);j++) transient_residual[j]=0.0;
        prev_frame.last_pitchspike=0;
        prev_frame_strt_adj=0;
        prev_frame.pitchlag_mod=0;
        prev_frame.diffloc=0;
        tl=FrameSize;
        pdelayD=trans_model.pitchlag;

    }

	if(trans_model.indep_coding_flag == 1 && ((prev_frm_mode == 2) || (prev_frm_mode == 1)))
		redirectVM =1;
	else
		redirectVM =0;

   
   /* Construct the transient residual based on the model parameters */
   long tempvar[1];
   tempvar[0]=10000;
   cutoff_freq=3000;
   currfrmD.gen_proto_wf(trans_model.pitchlag,cutoff_freq,tempvar,prev_frame.diffloc);
   trans_model.diffloc= currfrmD.diffloc;

    for(j=0;j<trans_model.pitchlag;j++) trans_model.prototype[j]=currfrmD.pitchproto[j]; 
   
    trans_model.plsp = OldlspD;
    trans_model.lsp = lsp;

    if(prev_frm_mode>2)
        trans_model.loc_prev_frm_cyc=prev_frame.last_pitchspike-prev_frame_strt_adj;//FrameSize-(short)pdelay;
    else
        trans_model.loc_prev_frm_cyc=0;
    if(trans_model.loc_prev_frm_cyc<0) {
        trans_model.loc_prev_frm_cyc=0;
        prev_frame_strt_adj=trans_model.loc_prev_frm_cyc;
    }

   if(trans_model.indep_coding_flag==0 && redirectVM == 0) {
       trans_model.loc_first_pk=dequantize_loc_first_pk(trans_model.loc_first_pk_ind);
   }
   if(redirectVM)
   {
	   trans_model.indep_coding_flag = 0;
	   trans_model.loc_first_pk = (short)((float)FrameSize/(float)trans_model.pitchlag);
	   trans_model.leadupflag = 0;
	   //trans_model.gains_PS[0]=trans_model.gains_PS[0]/2;
   }
   /*create a countour for the excitation signal*/
   create_syn_excitation(transient_residual, syn_pkloc, num_syn_pk, trans_model, (int) pdelayD, prev_frm_mode,prev_frame.last_pitchspike, &tl);
  
   /*For FER protection, ensure that the dimensions of the gain matches the estimated dimensions*/
   if(trans_model.indep_coding_flag==1) {
       dec_dim_adj= check_misestim_numpks(trans_model.pitchlag,num_syn_pk[0],trans_model.fe_protection);
    }else
       dec_dim_adj=0;
#if 0
    if(dec_dim_adj!=0) printf("mismatch due to FER in transient frame number %d \n",decode_fcnt);
#endif

   decode_gains_transient(&trans_model,num_syn_pk[0],dec_dim_adj);


 
 
   /* apply gains and synthesize the output*/
   apply_gains(&(transient_residual[FrameSize]),decsp_buffer,syn_pkloc,num_syn_pk[0], & trans_model,SynMemory, tl,(int) pdelayD);
 

#ifdef POSTFILTER_STND_SUBFRAME

   //apply post filter on a subframe basis
    for (i = 0; i < NoOfSubFrames; i++) {
        if (i < 2)
            subframesize = SubFrameSize - 1;
        else
            subframesize = SubFrameSize;


        if (post_filter) {
            Interpol (lspi, OldlspD, lsp, i, ORDER);
            lsp2a(pci,lspi,ORDER);
            Interpol_delay (delayi, &pdelayD, &delay, i);
            Post_Filter (&(decsp_buffer[i*(SubFrameSize-1)]), lspi, pci, DECspeechPF,(delayi[0] + delayi[1]) / 2.0, 
                         0.4, 0.15, subframesize,0);
        }else
            V_copy(&(decsp_buffer[i*(SubFrameSize-1)]),DECspeechPF,subframesize);

        for (j = 0; j < subframesize; j++) {
            if (DECspeechPF[j] > 32767.0) *foutP++ = 32767.0;
            else {
                if (DECspeechPF[j] < -32768) *foutP++ = -32768.0;
                else *foutP++ = DECspeechPF[j];
            }
        }

    }
#else
//synthesis loop
    temp_samples_count=syn_pkloc[0]-trans_model.diffloc;
    if(temp_samples_count<0) {
        offset=-temp_samples_count;
        temp_samples_count=0;
    }else
        offset=0;


    if((temp_samples_count> 0)&&(temp_samples_count < 10)){
	comp_offset=temp_samples_count;
	temp_samples_count=0;
    }else{
	comp_offset=0;
    }

    if(temp_samples_count>0) {
        
        lsp2a(pci,OldlspD,ORDER);
        if (post_filter) 
            Post_Filter(decsp_buffer, OldlspD, pci, DECspeechPF, delay, 0.4, 0.15,  temp_samples_count,0);
        else V_copy(decsp_buffer,DECspeechPF,temp_samples_count);
        for (j = 0; j < temp_samples_count; j++) {
            if (DECspeechPF[j] > 32767.0) *foutP++ = 32767.0;
            else {
                if (DECspeechPF[j] < -32768) *foutP++ = -32768.0;
                else *foutP++ = DECspeechPF[j];
            }
        }

    }
    for(i=0;i<this->num_syn_pk[0];i++) {
        // interpolate the lsps
        intfac=((float)syn_pkloc[i]+0.5*delay)/(float)FrameSize;
        if(intfac>1.0) intfac=1.0;

        Interpol_fac(lspi, OldlspD, lsp,intfac,ORDER);
        lsp2a(pci,lspi,ORDER);

        if(i < this->num_syn_pk[0]-1) len=syn_pkloc[i+1]-syn_pkloc[i];
        else len=(FrameSize-syn_pkloc[i]+trans_model.diffloc);

		if(i==0) len=len+comp_offset;	

        #ifdef POST_FILTER_MOD_IN_TRANS
        if (post_filter) 
            Post_Filter(decsp_buffer+temp_samples_count, lspi, pci, DECspeechPF, delay, 0.4, 0.15,  len-offset,1);
        #else
        if (post_filter) 
            Post_Filter(decsp_buffer+temp_samples_count, lspi, pci, DECspeechPF, delay, 0.4, 0.15,  len-offset,0);
        #endif

        else V_copy(decsp_buffer+temp_samples_count,DECspeechPF,len-offset);

        // Write p.f. decoder output and variables to files 
        for (j = 0; j < len-offset; j++) {
            if (DECspeechPF[j] > 32767.0) *foutP++ = 32767.0;
            else {
                if (DECspeechPF[j] < -32768) *foutP++ = -32768.0;
                else *foutP++ = DECspeechPF[j];
            }
        }
        temp_samples_count+=(len-offset);
        offset=0;
    }

#endif

    for(j=0;j<ACBMemSize;j++) {
        PitchMemoryD[j]=transient_residual[FrameSize+j+(FrameSize-ACBMemSize)];
        PitchPreFiltMemoryD[j]=transient_residual[FrameSize+j+(FrameSize-ACBMemSize)];
    }

    loc_last_pk_prev_frame=syn_pkloc[num_syn_pk[0]-1];
    for(j=0;j<(FrameSize+LOOKAHEAD_LEN);j++) {
        transient_residual[j]=transient_residual[j+FrameSize];
    }
    prev_frame_strt_adj=trans_model.diffloc;


    pdelayD = delay;
    delete[] out;

}
